"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.resolveGenericType = exports.baseTypes = exports.defaultListType = exports.defaultSetType = exports.defaultType = void 0;
var MAX_SAFE_INTEGER = Math.pow(2, 53) - 1;
var MIN_SAFE_INTEGER = -MAX_SAFE_INTEGER;
exports.defaultType = { type: 'object' };
exports.defaultSetType = {
    type: 'array',
    uniqueItems: true,
    items: exports.defaultType,
};
exports.defaultListType = {
    type: 'array',
    items: exports.defaultType,
};
exports.baseTypes = {
    byte: {
        type: 'integer',
        minimum: -128,
        maximum: 127,
    },
    boolean: {
        type: 'boolean',
    },
    char: {
        type: 'string',
        maxLength: 1,
    },
    float: {
        type: 'number',
    },
    double: {
        type: 'number',
    },
    int: {
        type: 'integer',
        minimum: -0x80000000,
        maximum: 0x7fffffff,
    },
    short: {
        type: 'integer',
        minimum: -0x8000,
        maximum: 0x7fff,
    },
    long: {
        type: 'integer',
        minimum: MIN_SAFE_INTEGER,
        maximum: MAX_SAFE_INTEGER,
    },
    'java.lang.Byte': {
        type: 'integer',
        minimum: -128,
        maximum: 127,
    },
    'java.lang.String': {
        type: 'string',
    },
    'java.lang.Boolean': {
        type: 'boolean',
    },
    'java.lang.Character': {
        type: 'string',
        maxLength: 1,
    },
    'java.lang.Float': {
        type: 'number',
    },
    'java.lang.Double': {
        type: 'number',
    },
    'java.lang.Integer': {
        type: 'integer',
        minimum: -0x80000000,
        maximum: 0x7fffffff,
    },
    'java.lang.Short': {
        type: 'integer',
        minimum: -0x8000,
        maximum: 0x7fff,
    },
    'java.lang.Long': {
        type: 'integer',
        minimum: MIN_SAFE_INTEGER,
        maximum: MAX_SAFE_INTEGER,
    },
    'java.util.Date': {
        type: 'string',
        mock: {
            mock: '@datetime',
        },
    },
    'java.sql.Date': {
        type: 'string',
        mock: {
            mock: '@datetime',
        },
    },
    'java.sql.Timestamp': {
        type: 'string',
        mock: {
            mock: '@datetime',
        },
    },
    'java.sql.Time': {
        type: 'string',
        mock: {
            mock: '@datetime',
        },
    },
    'java.time.LocalDate': {
        type: 'string',
        format: 'date',
    },
    'java.time.LocalDateTime': {
        type: 'string',
        mock: {
            mock: '@date()T@time()',
        },
    },
    'java.time.LocalTime': {
        type: 'string',
        mock: {
            mock: '@date()T@time()',
        },
    },
    'java.util.List': exports.defaultListType,
    'java.util.ArrayList': exports.defaultListType,
    'java.util.LinkedList': exports.defaultListType,
    'java.util.Queue': exports.defaultListType,
    'java.util.PriorityQueue': exports.defaultListType,
    'java.util.Collection': exports.defaultListType,
    'java.util.Vector': exports.defaultListType,
    'java.util.Stack': exports.defaultListType,
    'java.util.Deque': exports.defaultListType,
    'java.util.ArrayDeque': exports.defaultListType,
    'java.util.Set': exports.defaultSetType,
    'java.util.HashSet': exports.defaultSetType,
    'java.util.TreeSet': exports.defaultSetType,
    'java.util.SortedSet': exports.defaultSetType,
    'java.util.LinkedHashSet': exports.defaultSetType,
    'java.util.NavigableSet': exports.defaultSetType,
    'java.lang.Object': {
        type: 'object',
    },
};
function resolveGenericType(type) {
    var _a, _b, _c;
    var subTypes = [];
    for (var _i = 1; _i < arguments.length; _i++) {
        subTypes[_i - 1] = arguments[_i];
    }
    switch (type) {
        case 'java.util.List':
        case 'java.util.ArrayList':
        case 'java.util.LinkedList':
        case 'java.util.Queue':
        case 'java.util.PriorityQueue':
        case 'java.util.Collection':
        case 'java.util.Vector':
        case 'java.util.Stack':
        case 'java.util.Deque':
        case 'java.util.ArrayDeque': {
            return {
                type: 'array',
                items: (_a = subTypes[0]) !== null && _a !== void 0 ? _a : exports.defaultType,
            };
        }
        case 'java.util.Set':
        case 'java.util.HashSet':
        case 'java.util.TreeSet':
        case 'java.util.SortedSet':
        case 'java.util.LinkedHashSet':
        case 'java.util.NavigableSet': {
            return {
                type: 'array',
                uniqueItems: true,
                items: (_b = subTypes[0]) !== null && _b !== void 0 ? _b : exports.defaultType,
            };
        }
        case 'java.util.Map':
        case 'java.util.HashMap':
        case 'java.util.TreeMap':
        case 'java.util.LinkedHashMap':
        case 'java.util.WeakHashMap':
        case 'java.util.IdentityHashMap':
        case 'java.util.SortedMap':
        case 'java.util.NavigableMap':
        case 'java.util.Hashtable': {
            return {
                type: 'object',
                additionalProperties: (_c = subTypes[1]) !== null && _c !== void 0 ? _c : exports.defaultType,
            };
        }
        default: {
            return exports.defaultType;
        }
    }
}
exports.resolveGenericType = resolveGenericType;
