"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var tslib_1 = require("tslib");
var vitest_1 = require("vitest");
var api_1 = require("../api");
(0, vitest_1.describe)('api', function () {
    (0, vitest_1.describe)('fetchAllData', function () {
        (0, vitest_1.it)('should fetch all data - 1 page', function () { return tslib_1.__awaiter(void 0, void 0, void 0, function () {
            var fn, data;
            return tslib_1.__generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        fn = vitest_1.vi.fn(function () { return tslib_1.__awaiter(void 0, void 0, void 0, function () {
                            return tslib_1.__generator(this, function (_a) {
                                return [2 /*return*/, ({
                                        Content: [1, 2, 3],
                                        PageSize: 3,
                                        PageNumber: 1,
                                        TotalElements: 3,
                                        TotalPages: 1,
                                    })];
                            });
                        }); });
                        return [4 /*yield*/, (0, api_1.fetchAllData)(fn, {})];
                    case 1:
                        data = _a.sent();
                        (0, vitest_1.expect)(data).toEqual([1, 2, 3]);
                        (0, vitest_1.expect)(fn).toBeCalledTimes(1);
                        return [2 /*return*/];
                }
            });
        }); });
        (0, vitest_1.it)('should fetch all data - 2 pages', function () { return tslib_1.__awaiter(void 0, void 0, void 0, function () {
            var fn, data;
            return tslib_1.__generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        fn = vitest_1.vi.fn(function () { return tslib_1.__awaiter(void 0, void 0, void 0, function () {
                            return tslib_1.__generator(this, function (_a) {
                                return [2 /*return*/, ({
                                        Content: [1, 2, 3],
                                        PageSize: 3,
                                        PageNumber: 1,
                                        TotalElements: 6,
                                        TotalPages: 2,
                                    })];
                            });
                        }); });
                        return [4 /*yield*/, (0, api_1.fetchAllData)(fn, {})];
                    case 1:
                        data = _a.sent();
                        (0, vitest_1.expect)(data).toEqual([1, 2, 3, 1, 2, 3]);
                        (0, vitest_1.expect)(fn).toBeCalledTimes(2);
                        return [2 /*return*/];
                }
            });
        }); });
        (0, vitest_1.it)('should stop fetching if empty result is returned from server', function () { return tslib_1.__awaiter(void 0, void 0, void 0, function () {
            var fn, data;
            return tslib_1.__generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        fn = vitest_1.vi
                            .fn()
                            .mockImplementationOnce(function () { return tslib_1.__awaiter(void 0, void 0, void 0, function () {
                            return tslib_1.__generator(this, function (_a) {
                                return [2 /*return*/, ({
                                        Content: [1, 2, 3],
                                        PageSize: 3,
                                        PageNumber: 1,
                                        TotalElements: 9,
                                        TotalPages: 3,
                                    })];
                            });
                        }); })
                            .mockImplementationOnce(function () { return tslib_1.__awaiter(void 0, void 0, void 0, function () {
                            return tslib_1.__generator(this, function (_a) {
                                return [2 /*return*/, ({
                                        Content: [],
                                        PageSize: 3,
                                        PageNumber: 2,
                                        TotalElements: 9,
                                        TotalPages: 3,
                                    })];
                            });
                        }); });
                        return [4 /*yield*/, (0, api_1.fetchAllData)(fn, {})];
                    case 1:
                        data = _a.sent();
                        (0, vitest_1.expect)(data).toEqual([1, 2, 3]);
                        (0, vitest_1.expect)(fn).toBeCalledTimes(2);
                        return [2 /*return*/];
                }
            });
        }); });
    });
});
