"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var tslib_1 = require("tslib");
var vitest_1 = require("vitest");
var client_1 = tslib_1.__importStar(require("../client"));
(0, vitest_1.describe)('client', function () {
    (0, vitest_1.it)('should make correct configs', function () { return new Promise(function (resolve) {
        client_1.default.interceptors.request.use(function (config) {
            var _a;
            var newConfig = (0, client_1.signRequestInfo)(config);
            (0, vitest_1.expect)((_a = newConfig.headers) === null || _a === void 0 ? void 0 : _a.Authorization).toEqual('acs fake-access-key-id:O2QGK8AbtdviiaToDx3DIUeI6D0=');
            (0, vitest_1.expect)(newConfig.baseURL).toEqual('https://edas.cn-shenzhen.aliyuncs.com');
            (0, vitest_1.expect)(newConfig.url).toEqual('/pop/sp/api/mseForOam/getServiceProvidersPage');
            resolve();
            return config;
        });
        client_1.default.post('/pop/sp/api/mseForOam/getServiceProvidersPage', {}, {
            aliyunAccessKey: {
                id: 'fake-access-key-id',
                secret: 'fake-signing-key',
            },
            aliyunSignOptions: {
                date: 'Mon, 29 May 2023 02:37:06 GMT',
                nonce: 'uc4lgldhnpc', // cspell:disable-line
            },
            params: {
                region: 'cn-hangzhou',
                namespace: 'cn-hangzhou',
                serviceType: 'dubbo',
                appId: 'cf42bd49-342e-46dd-b976-7b289dfe46d4',
                serviceName: 'com.dubbo.example.DemoService',
                serviceVersion: '1.0.0',
                group: '',
                page: '0',
                size: '20',
            },
        });
    }); });
});
