"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.fetchAllData = exports.getServiceProviderList = exports.getMethodList = exports.getServiceList = exports.getAppList = exports.getLogicalRegionList = void 0;
var tslib_1 = require("tslib");
var client_1 = tslib_1.__importDefault(require("./client"));
function getLogicalRegionList(options) {
    var _a, _b;
    return tslib_1.__awaiter(this, void 0, void 0, function () {
        var res, data;
        return tslib_1.__generator(this, function (_c) {
            switch (_c.label) {
                case 0: return [4 /*yield*/, client_1.default.post('/pop/v5/user_region_defs', {}, {
                        aliyunRegion: options.region,
                        aliyunAccessKey: {
                            id: options.aliyunAccessKeyId,
                            secret: options.aliyunAccessKeySecret,
                        },
                        adapter: (_a = options.http) === null || _a === void 0 ? void 0 : _a.adapter,
                        xhrAgent: (_b = options.http) === null || _b === void 0 ? void 0 : _b.xhrAgent,
                    })];
                case 1:
                    res = _c.sent();
                    data = res.data;
                    if (data.Message.toLowerCase() !== 'success') {
                        throw new Error(data.Message);
                    }
                    return [2 /*return*/, data.UserDefineRegionList.UserDefineRegionEntity];
            }
        });
    });
}
exports.getLogicalRegionList = getLogicalRegionList;
function getAppList(options) {
    var _a, _b, _c;
    return tslib_1.__awaiter(this, void 0, void 0, function () {
        var res, data;
        return tslib_1.__generator(this, function (_d) {
            switch (_d.label) {
                case 0: return [4 /*yield*/, client_1.default.post('/pop/v5/app/app_list', {}, {
                        aliyunRegion: options.region,
                        aliyunAccessKey: {
                            id: options.aliyunAccessKeyId,
                            secret: options.aliyunAccessKeySecret,
                        },
                        params: {
                            LogicalRegionIdFilter: (_a = options.logicalRegion) !== null && _a !== void 0 ? _a : options.region,
                        },
                        adapter: (_b = options.http) === null || _b === void 0 ? void 0 : _b.adapter,
                        xhrAgent: (_c = options.http) === null || _c === void 0 ? void 0 : _c.xhrAgent,
                    })];
                case 1:
                    res = _d.sent();
                    data = res.data;
                    if (data.Message.toLowerCase() !== 'success') {
                        throw new Error(data.Message);
                    }
                    return [2 /*return*/, data.ApplicationList.Application];
            }
        });
    });
}
exports.getAppList = getAppList;
function getServiceList(options) {
    var _a, _b, _c, _d;
    return tslib_1.__awaiter(this, void 0, void 0, function () {
        var page, res, data;
        return tslib_1.__generator(this, function (_e) {
            switch (_e.label) {
                case 0:
                    page = options.page ? options.page - 1 : 0;
                    return [4 /*yield*/, client_1.default.post('/pop/sp/api/mseForOam/getServiceListPage', {}, {
                            aliyunRegion: options.region,
                            aliyunAccessKey: {
                                id: options.aliyunAccessKeyId,
                                secret: options.aliyunAccessKeySecret,
                            },
                            params: {
                                region: options.region,
                                serviceType: options.serviceType,
                                searchType: 'app',
                                searchValue: options.appId,
                                namespace: (_a = options.logicalRegion) !== null && _a !== void 0 ? _a : options.region,
                                page: page,
                                size: (_b = options.size) !== null && _b !== void 0 ? _b : 20,
                            },
                            adapter: (_c = options.http) === null || _c === void 0 ? void 0 : _c.adapter,
                            xhrAgent: (_d = options.http) === null || _d === void 0 ? void 0 : _d.xhrAgent,
                        })];
                case 1:
                    res = _e.sent();
                    data = res.data;
                    if (data.Message.toLowerCase() !== 'success') {
                        throw new Error(data.Message);
                    }
                    return [2 /*return*/, {
                            Content: data.Data.Content,
                            PageSize: data.Data.Size,
                            PageNumber: page + 1,
                            TotalElements: data.Data.TotalElements,
                            TotalPages: data.Data.TotalPages,
                        }];
            }
        });
    });
}
exports.getServiceList = getServiceList;
function getMethodList(options) {
    var _a, _b, _c, _d;
    return tslib_1.__awaiter(this, void 0, void 0, function () {
        var res, data;
        return tslib_1.__generator(this, function (_e) {
            switch (_e.label) {
                case 0: return [4 /*yield*/, client_1.default.post('/pop/sp/api/mseForOam/getServiceMethodPage', {}, {
                        aliyunRegion: options.region,
                        aliyunAccessKey: {
                            id: options.aliyunAccessKeyId,
                            secret: options.aliyunAccessKeySecret,
                        },
                        params: {
                            region: options.region,
                            namespace: (_a = options.logicalRegion) !== null && _a !== void 0 ? _a : options.region,
                            appId: options.appId,
                            serviceType: options.serviceType,
                            serviceName: options.serviceName,
                            serviceVersion: options.serviceVersion,
                            group: options.group,
                            pageNumber: options.page ? options.page : 1,
                            pageSize: (_b = options.size) !== null && _b !== void 0 ? _b : 20,
                        },
                        adapter: (_c = options.http) === null || _c === void 0 ? void 0 : _c.adapter,
                        xhrAgent: (_d = options.http) === null || _d === void 0 ? void 0 : _d.xhrAgent,
                    })];
                case 1:
                    res = _e.sent();
                    data = res.data;
                    if (data.Message.toLowerCase() !== 'success') {
                        throw new Error(JSON.stringify(data));
                    }
                    return [2 /*return*/, {
                            Content: data.Data.Result,
                            PageSize: data.Data.PageSize,
                            PageNumber: data.Data.PageNumber,
                            TotalElements: data.Data.TotalSize,
                            TotalPages: Math.ceil(data.Data.TotalSize / data.Data.PageSize),
                        }];
            }
        });
    });
}
exports.getMethodList = getMethodList;
function getServiceProviderList(options) {
    var _a, _b, _c, _d;
    return tslib_1.__awaiter(this, void 0, void 0, function () {
        var page, res, data;
        return tslib_1.__generator(this, function (_e) {
            switch (_e.label) {
                case 0:
                    page = options.page ? options.page - 1 : 0;
                    return [4 /*yield*/, client_1.default.post('/pop/sp/api/mseForOam/getServiceProvidersPage', {}, {
                            aliyunRegion: options.region,
                            aliyunAccessKey: {
                                id: options.aliyunAccessKeyId,
                                secret: options.aliyunAccessKeySecret,
                            },
                            params: {
                                region: options.region,
                                serviceType: options.serviceType,
                                appId: options.appId,
                                serviceName: options.serviceName,
                                namespace: (_a = options.logicalRegion) !== null && _a !== void 0 ? _a : options.region,
                                page: page,
                                size: (_b = options.size) !== null && _b !== void 0 ? _b : 20,
                                group: options.group,
                                serviceVersion: options.serviceVersion,
                            },
                            adapter: (_c = options.http) === null || _c === void 0 ? void 0 : _c.adapter,
                            xhrAgent: (_d = options.http) === null || _d === void 0 ? void 0 : _d.xhrAgent,
                        })];
                case 1:
                    res = _e.sent();
                    data = res.data;
                    if (data.Message.toLowerCase() !== 'success') {
                        throw new Error(data.Message);
                    }
                    return [2 /*return*/, {
                            Content: data.Data.Content,
                            PageSize: data.Data.Size,
                            PageNumber: page + 1,
                            TotalElements: data.Data.TotalElements,
                            TotalPages: data.Data.TotalPages,
                        }];
            }
        });
    });
}
exports.getServiceProviderList = getServiceProviderList;
function sleep(interval) {
    return tslib_1.__awaiter(this, void 0, void 0, function () {
        return tslib_1.__generator(this, function (_a) {
            switch (_a.label) {
                case 0: return [4 /*yield*/, new Promise(function (resolve) { return setTimeout(resolve, interval !== null && interval !== void 0 ? interval : 100); })];
                case 1: return [2 /*return*/, _a.sent()];
            }
        });
    });
}
function fetchAllData(fn, options) {
    var _a;
    return tslib_1.__awaiter(this, void 0, void 0, function () {
        var result, pageNumber, totalPages, _b, Content, TotalPages;
        return tslib_1.__generator(this, function (_c) {
            switch (_c.label) {
                case 0:
                    result = [];
                    pageNumber = 1;
                    totalPages = 1;
                    _c.label = 1;
                case 1:
                    if (!(pageNumber <= totalPages)) return [3 /*break*/, 4];
                    return [4 /*yield*/, fn(tslib_1.__assign(tslib_1.__assign({}, options), { page: pageNumber }))];
                case 2:
                    _b = _c.sent(), Content = _b.Content, TotalPages = _b.TotalPages;
                    if (!Array.isArray(Content) || Content.length === 0) {
                        return [3 /*break*/, 4];
                    }
                    result.push.apply(result, Content);
                    totalPages = TotalPages;
                    pageNumber++;
                    return [4 /*yield*/, sleep((_a = options.requester) === null || _a === void 0 ? void 0 : _a.delay)];
                case 3:
                    _c.sent();
                    return [3 /*break*/, 1];
                case 4: return [2 /*return*/, result];
            }
        });
    });
}
exports.fetchAllData = fetchAllData;
