"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.signRequestInfo = void 0;
var tslib_1 = require("tslib");
var edas_1 = require("../../utils/edas");
var axios_1 = tslib_1.__importDefault(require("@tarslib/axios"));
var client = axios_1.default.create({
    baseURL: edas_1.EDAS_ENDPOINT_PATTERN,
});
function signRequestInfo(config) {
    var _a, _b;
    var _c = config.method, method = _c === void 0 ? 'POST' : _c, _d = config.baseURL, baseURL = _d === void 0 ? '' : _d, _e = config.url, url = _e === void 0 ? '' : _e, _f = config.aliyunAccessKey, aliyunAccessKey = _f === void 0 ? { id: '', secret: '' } : _f, _g = config.aliyunRegion, aliyunRegion = _g === void 0 ? 'cn-shenzhen' : _g;
    var newConfig = tslib_1.__assign({}, config);
    newConfig.baseURL = baseURL.replace('{region}', aliyunRegion);
    var id = aliyunAccessKey.id, secret = aliyunAccessKey.secret;
    var result = (0, edas_1.sign)({
        method: method.toUpperCase(),
        path: url,
        query: newConfig.params,
        data: JSON.stringify(newConfig.data),
        accessKeyId: id,
        signingKey: secret,
        date: (_a = newConfig.aliyunSignOptions) === null || _a === void 0 ? void 0 : _a.date,
        nonce: (_b = newConfig.aliyunSignOptions) === null || _b === void 0 ? void 0 : _b.nonce,
    });
    var headers = new axios_1.default.AxiosHeaders();
    for (var _i = 0, _h = Object.entries(result.headers); _i < _h.length; _i++) {
        var _j = _h[_i], key = _j[0], value = _j[1];
        headers.set(key, value);
    }
    newConfig.headers = headers;
    return newConfig;
}
exports.signRequestInfo = signRequestInfo;
client.interceptors.request.use(signRequestInfo);
exports.default = client;
