"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Edas = void 0;
var tslib_1 = require("tslib");
var adapter_1 = require("../../adapter");
var types_1 = require("../../types");
var api_1 = require("./api");
var utils_1 = require("../../utils");
var Edas = /** @class */ (function () {
    function Edas(options) {
        this.options = options;
        this._adapter = new adapter_1.Adapter(this.options);
    }
    Edas.prototype.getApps = function () {
        return tslib_1.__awaiter(this, void 0, void 0, function () {
            var registerOptions, result;
            return tslib_1.__generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        registerOptions = this.options.register;
                        (0, utils_1.assertRegisterType)(registerOptions, types_1.RegisterType.EDAS);
                        return [4 /*yield*/, (0, api_1.getAppList)({
                                region: registerOptions.region,
                                logicalRegion: registerOptions.logicalRegion,
                                aliyunAccessKeyId: registerOptions.auth.aliyunAccessKeyId,
                                aliyunAccessKeySecret: registerOptions.auth.aliyunAccessKeySecret,
                                http: registerOptions.http,
                            })];
                    case 1:
                        result = _a.sent();
                        return [2 /*return*/, this._adapter.getAppInfoList(result)];
                }
            });
        });
    };
    Edas.prototype.getServiceProviders = function (key, appId) {
        return tslib_1.__awaiter(this, void 0, void 0, function () {
            var registerOptions, options, result;
            return tslib_1.__generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        registerOptions = this.options.register;
                        (0, utils_1.assertRegisterType)(registerOptions, types_1.RegisterType.EDAS);
                        options = {
                            serviceName: key,
                            region: registerOptions.region,
                            logicalRegion: registerOptions.logicalRegion,
                            serviceType: this.options.service.serviceType.toLowerCase(),
                            aliyunAccessKeyId: registerOptions.auth.aliyunAccessKeyId,
                            aliyunAccessKeySecret: registerOptions.auth.aliyunAccessKeySecret,
                            http: registerOptions.http,
                        };
                        if (appId) {
                            options.appId = appId;
                        }
                        if (this.options.service.serviceType === types_1.ServiceType.DUBBO) {
                            options.serviceVersion = this.options.service.version;
                            options.group = this.options.service.group;
                        }
                        return [4 /*yield*/, (0, api_1.fetchAllData)(api_1.getServiceProviderList, tslib_1.__assign(tslib_1.__assign({}, options), { requester: registerOptions.requester }))];
                    case 1:
                        result = _a.sent();
                        return [2 /*return*/, this._adapter.processServiceProviderResult(result)];
                }
            });
        });
    };
    Edas.prototype.loadServices = function (appId) {
        var _a, _b;
        return tslib_1.__awaiter(this, void 0, void 0, function () {
            var registerOptions, options, metadataList, services, _i, services_1, service, methods;
            return tslib_1.__generator(this, function (_c) {
                switch (_c.label) {
                    case 0:
                        registerOptions = this.options.register;
                        (0, utils_1.assertRegisterType)(registerOptions, types_1.RegisterType.EDAS);
                        options = {
                            appId: appId,
                            region: registerOptions.region,
                            logicalRegion: registerOptions.logicalRegion,
                            serviceType: this.options.service.serviceType.toLowerCase(),
                            aliyunAccessKeyId: registerOptions.auth.aliyunAccessKeyId,
                            aliyunAccessKeySecret: registerOptions.auth.aliyunAccessKeySecret,
                            http: registerOptions.http,
                        };
                        metadataList = [];
                        return [4 /*yield*/, (0, api_1.fetchAllData)(api_1.getServiceList, tslib_1.__assign(tslib_1.__assign({}, options), { requester: registerOptions.requester }))];
                    case 1:
                        services = _c.sent();
                        _i = 0, services_1 = services;
                        _c.label = 2;
                    case 2:
                        if (!(_i < services_1.length)) return [3 /*break*/, 5];
                        service = services_1[_i];
                        return [4 /*yield*/, (0, api_1.fetchAllData)(api_1.getMethodList, tslib_1.__assign(tslib_1.__assign({}, options), { appId: service.EdasAppId, serviceName: service.ServiceName, requester: registerOptions.requester }))];
                    case 3:
                        methods = _c.sent();
                        metadataList.push({ service: service, methods: methods });
                        _c.label = 4;
                    case 4:
                        _i++;
                        return [3 /*break*/, 2];
                    case 5: return [2 /*return*/, this._adapter.parseMetadataList("".concat(registerOptions.region, "/").concat((_b = (_a = services[0]) === null || _a === void 0 ? void 0 : _a.EdasAppName) !== null && _b !== void 0 ? _b : ''), metadataList)];
                }
            });
        });
    };
    return Edas;
}());
exports.Edas = Edas;
