"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.RegisterClient = void 0;
var types_1 = require("../types");
var edas_1 = require("./edas");
var nacos_1 = require("./nacos");
var zookeeper_1 = require("./zookeeper");
var RegisterClient = exports.RegisterClient = /** @class */ (function () {
    function RegisterClient(options) {
        this.options = options;
    }
    Object.defineProperty(RegisterClient.prototype, "register", {
        get: function () {
            var RegisterClass = RegisterClient.registerClientMap.get(this.options.register.registerType);
            if (!RegisterClass) {
                throw new Error("registerType (".concat(this.options.register.registerType, ") is not supported"));
            }
            return new RegisterClass(this.options);
        },
        enumerable: false,
        configurable: true
    });
    RegisterClient.prototype.getApps = function () {
        return this.register.getApps();
    };
    RegisterClient.prototype.getServiceProviders = function (path, appId) {
        return this.register.getServiceProviders(path, appId);
    };
    RegisterClient.prototype.loadServices = function (appName) {
        return this.register.loadServices(appName);
    };
    RegisterClient.registerClientMap = new Map([
        [types_1.RegisterType.ZOOKEEPER, zookeeper_1.ZooKeeper],
        [types_1.RegisterType.NACOS, nacos_1.Nacos],
        [types_1.RegisterType.EDAS, edas_1.Edas],
    ]);
    return RegisterClient;
}());
