"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getConfigs = void 0;
var tslib_1 = require("tslib");
var http_api_client_1 = require("./http-api-client");
function getConfigs(appName, options) {
    var _a, _b, _c;
    return tslib_1.__awaiter(this, void 0, void 0, function () {
        var client, nacosConfigs, pageNumber, pageSize, res;
        return tslib_1.__generator(this, function (_d) {
            switch (_d.label) {
                case 0:
                    client = (0, http_api_client_1.createClient)(options);
                    nacosConfigs = [];
                    pageNumber = 1;
                    pageSize = 10;
                    _d.label = 1;
                case 1:
                    if (!true) return [3 /*break*/, 4];
                    return [4 /*yield*/, client.get('/v1/cs/configs', {
                            params: {
                                dataId: "*:".concat(appName),
                                group: (_a = options.group) !== null && _a !== void 0 ? _a : '',
                                tenant: options.namespace,
                                pageNo: pageNumber,
                                pageSize: pageSize,
                                search: 'blur',
                                username: (_b = options.auth) === null || _b === void 0 ? void 0 : _b.username,
                                password: (_c = options.auth) === null || _c === void 0 ? void 0 : _c.password,
                            },
                        })];
                case 2:
                    res = _d.sent();
                    nacosConfigs = nacosConfigs.concat(res.data.pageItems);
                    if (res.data.pageNumber >= res.data.pagesAvailable) {
                        return [3 /*break*/, 4];
                    }
                    pageNumber++;
                    return [4 /*yield*/, new Promise(function (resolve) { return setTimeout(resolve, 500); })];
                case 3:
                    _d.sent();
                    return [3 /*break*/, 1];
                case 4: return [2 /*return*/, nacosConfigs];
            }
        });
    });
}
exports.getConfigs = getConfigs;
