"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Nacos = void 0;
var tslib_1 = require("tslib");
var nacos_1 = require("nacos");
var adapter_1 = require("../../adapter");
var types_1 = require("../../types");
var get_metadata_list_1 = require("./get-metadata-list");
var utils_1 = require("../../utils");
var Nacos = /** @class */ (function () {
    function Nacos(options) {
        this.options = options;
        this._adapter = new adapter_1.Adapter(this.options);
    }
    Nacos.prototype.exec = function (handler) {
        var _this = this;
        return new Promise(function (resolve, reject) {
            var _a;
            var registerOptions = _this.options.register;
            (0, utils_1.assertRegisterType)(registerOptions, types_1.RegisterType.NACOS);
            var options = {
                logger: (_a = _this.options.logger) !== null && _a !== void 0 ? _a : console,
                serverList: registerOptions.endpoint,
                namespace: registerOptions.namespace,
            };
            if (registerOptions.auth) {
                options.username = registerOptions.auth.username;
                options.password = registerOptions.auth.password;
            }
            var client = new nacos_1.NacosNamingClient(options);
            client.ready().then(function () { return tslib_1.__awaiter(_this, void 0, void 0, function () {
                var _a, err_1;
                return tslib_1.__generator(this, function (_b) {
                    switch (_b.label) {
                        case 0:
                            _b.trys.push([0, 2, 3, 4]);
                            _a = resolve;
                            return [4 /*yield*/, handler(client, registerOptions)];
                        case 1:
                            _a.apply(void 0, [_b.sent()]);
                            return [3 /*break*/, 4];
                        case 2:
                            err_1 = _b.sent();
                            reject(err_1);
                            return [3 /*break*/, 4];
                        case 3:
                            client._close();
                            return [7 /*endfinally*/];
                        case 4: return [2 /*return*/];
                    }
                });
            }); });
        });
    };
    Nacos.prototype.getApps = function () {
        return tslib_1.__awaiter(this, void 0, void 0, function () {
            var registerOptions, metadataStrList;
            return tslib_1.__generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        registerOptions = this.options.register;
                        (0, utils_1.assertRegisterType)(registerOptions, types_1.RegisterType.NACOS);
                        return [4 /*yield*/, (0, get_metadata_list_1.getMetadataList)('*', registerOptions)];
                    case 1:
                        metadataStrList = _a.sent();
                        return [2 /*return*/, this._adapter.getAppInfoList(metadataStrList)];
                }
            });
        });
    };
    Nacos.prototype.getServiceProviders = function (key) {
        return tslib_1.__awaiter(this, void 0, void 0, function () {
            var _this = this;
            return tslib_1.__generator(this, function (_a) {
                return [2 /*return*/, this.exec(function (client, options) { return tslib_1.__awaiter(_this, void 0, void 0, function () {
                        var path, result;
                        return tslib_1.__generator(this, function (_a) {
                            switch (_a.label) {
                                case 0:
                                    path = this._adapter.getServiceProviderPath(key);
                                    return [4 /*yield*/, client.getAllInstances(path, options.group, options.cluster, false)];
                                case 1:
                                    result = _a.sent();
                                    return [2 /*return*/, this._adapter.processServiceProviderResult(result)];
                            }
                        });
                    }); })];
            });
        });
    };
    Nacos.prototype.loadServices = function (appName) {
        return tslib_1.__awaiter(this, void 0, void 0, function () {
            var registerOptions, metadataStrList;
            return tslib_1.__generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        registerOptions = this.options.register;
                        (0, utils_1.assertRegisterType)(registerOptions, types_1.RegisterType.NACOS);
                        return [4 /*yield*/, (0, get_metadata_list_1.getMetadataList)(appName, registerOptions)];
                    case 1:
                        metadataStrList = _a.sent();
                        return [2 /*return*/, this._adapter.parseMetadataList(appName, metadataStrList)];
                }
            });
        });
    };
    return Nacos;
}());
exports.Nacos = Nacos;
