"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ZooKeeper = void 0;
var tslib_1 = require("tslib");
var node_zookeeper_client_1 = tslib_1.__importDefault(require("node-zookeeper-client"));
var adapter_1 = require("../adapter");
var types_1 = require("../types");
var dubbo_1 = require("../adapter/dubbo");
var utils_1 = require("../utils");
var p_limit_1 = tslib_1.__importDefault(require("../vendor/p-limit"));
var event_lite_1 = tslib_1.__importDefault(require("event-lite"));
var CLEAR_QUEUE = 'clear-queue';
var ZooKeeper = /** @class */ (function (_super) {
    tslib_1.__extends(ZooKeeper, _super);
    function ZooKeeper(options) {
        var _this = _super.call(this) || this;
        _this.options = options;
        _this._adapter = new adapter_1.Adapter(_this.options);
        return _this;
    }
    Object.defineProperty(ZooKeeper.prototype, "logger", {
        get: function () {
            var _a;
            return (_a = this.options.logger) !== null && _a !== void 0 ? _a : console;
        },
        enumerable: false,
        configurable: true
    });
    ZooKeeper.prototype.exec = function (handler) {
        var _this = this;
        return new Promise(function (resolve, reject) {
            var _a, _b;
            var registerOptions = _this.options.register;
            (0, utils_1.assertRegisterType)(registerOptions, types_1.RegisterType.ZOOKEEPER);
            var timeout = (_a = registerOptions.timeout) !== null && _a !== void 0 ? _a : (10 * 1000);
            var client = node_zookeeper_client_1.default.createClient(registerOptions.endpoint, registerOptions.options);
            if (registerOptions.auth) {
                client.addAuthInfo(registerOptions.auth.scheme, Buffer.from((_b = registerOptions.auth.authInfo) !== null && _b !== void 0 ? _b : ''));
            }
            var timer;
            if (timeout > 0) {
                timer = setTimeout(function () {
                    _this.emit(CLEAR_QUEUE);
                    client.close();
                    reject(Error('EXECUTION_TIMEOUT'));
                }, timeout);
            }
            if (_this.options.debug) {
                client.on('state', function (state) {
                    _this.logger.log("[state]: ".concat(JSON.stringify(state)));
                });
            }
            client.once('connected', function () { return tslib_1.__awaiter(_this, void 0, void 0, function () {
                var _a, err_1;
                return tslib_1.__generator(this, function (_b) {
                    switch (_b.label) {
                        case 0:
                            _b.trys.push([0, 2, 3, 4]);
                            _a = resolve;
                            return [4 /*yield*/, handler(client, registerOptions)];
                        case 1:
                            _a.apply(void 0, [_b.sent()]);
                            return [3 /*break*/, 4];
                        case 2:
                            err_1 = _b.sent();
                            reject(err_1);
                            return [3 /*break*/, 4];
                        case 3:
                            if (timer) {
                                clearTimeout(timer);
                            }
                            this.emit(CLEAR_QUEUE);
                            client.close();
                            return [7 /*endfinally*/];
                        case 4: return [2 /*return*/];
                    }
                });
            }); });
            client.connect();
        });
    };
    ZooKeeper.prototype.getApps = function () {
        return tslib_1.__awaiter(this, void 0, void 0, function () {
            var _this = this;
            return tslib_1.__generator(this, function (_a) {
                return [2 /*return*/, this.exec(function (client, options) { return tslib_1.__awaiter(_this, void 0, void 0, function () {
                        var basePath, metadataList, error_1;
                        var _a;
                        return tslib_1.__generator(this, function (_b) {
                            switch (_b.label) {
                                case 0:
                                    basePath = "/".concat((_a = options.group) !== null && _a !== void 0 ? _a : dubbo_1.ZOOKEEPER_DUBBO_DEFAULT_ROOT_NODE);
                                    metadataList = [];
                                    _b.label = 1;
                                case 1:
                                    _b.trys.push([1, 3, , 4]);
                                    return [4 /*yield*/, this.traverse(client, 'metadata', basePath, function (data) {
                                            metadataList.push(data);
                                        })];
                                case 2:
                                    _b.sent();
                                    return [3 /*break*/, 4];
                                case 3:
                                    error_1 = _b.sent();
                                    if (error_1 instanceof node_zookeeper_client_1.default.Exception && error_1.code === node_zookeeper_client_1.default.Exception.NO_NODE) {
                                        this.logger.warn("get apps failed: ".concat(error_1));
                                    }
                                    else {
                                        throw error_1;
                                    }
                                    return [3 /*break*/, 4];
                                case 4: return [2 /*return*/, this._adapter.getAppInfoList(metadataList)];
                            }
                        });
                    }); })];
            });
        });
    };
    ZooKeeper.prototype.getServiceProviders = function (key) {
        return tslib_1.__awaiter(this, void 0, void 0, function () {
            var _this = this;
            return tslib_1.__generator(this, function (_a) {
                return [2 /*return*/, this.exec(function (client) { return tslib_1.__awaiter(_this, void 0, void 0, function () {
                        var path, children, error_2;
                        return tslib_1.__generator(this, function (_a) {
                            switch (_a.label) {
                                case 0:
                                    path = this._adapter.getServiceProviderPath(key);
                                    children = [];
                                    _a.label = 1;
                                case 1:
                                    _a.trys.push([1, 3, , 4]);
                                    return [4 /*yield*/, this.getChildren(client, path)];
                                case 2:
                                    children = _a.sent();
                                    return [3 /*break*/, 4];
                                case 3:
                                    error_2 = _a.sent();
                                    if (error_2 instanceof node_zookeeper_client_1.default.Exception && error_2.code === node_zookeeper_client_1.default.Exception.NO_NODE) {
                                        this.logger.warn("get service providers failed: ".concat(error_2));
                                    }
                                    else {
                                        throw error_2;
                                    }
                                    return [3 /*break*/, 4];
                                case 4: return [2 /*return*/, this._adapter.processServiceProviderResult(children)];
                            }
                        });
                    }); })];
            });
        });
    };
    ZooKeeper.prototype.getData = function (client, key, basePath) {
        var path = basePath ? "".concat(basePath, "/").concat(key) : key;
        return new Promise(function (resolve, reject) {
            client.getData(path, function (error, data) {
                var _a;
                if (error) {
                    reject(error);
                }
                else {
                    resolve((_a = data === null || data === void 0 ? void 0 : data.toString()) !== null && _a !== void 0 ? _a : '{}');
                }
            });
        });
    };
    ZooKeeper.prototype.getChildren = function (client, key, basePath) {
        var path = basePath ? "".concat(basePath, "/").concat(key) : key;
        return new Promise(function (resolve, reject) {
            client.getChildren(path, function (error, children) {
                if (error) {
                    reject(error);
                }
                else {
                    resolve(children);
                }
            });
        });
    };
    ZooKeeper.prototype.traverse = function (client, key, basePath, callback) {
        return tslib_1.__awaiter(this, void 0, void 0, function () {
            var children, data, limit, jobs;
            var _this = this;
            return tslib_1.__generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, this.getChildren(client, key, basePath)];
                    case 1:
                        children = _a.sent();
                        if (!(!Array.isArray(children) || children.length === 0)) return [3 /*break*/, 3];
                        return [4 /*yield*/, this.getData(client, key, basePath)];
                    case 2:
                        data = _a.sent();
                        return [2 /*return*/, callback(data)];
                    case 3:
                        limit = (0, p_limit_1.default)(25);
                        jobs = children.map(function (child) { return limit(function () { return _this.traverse(client, child, "".concat(basePath, "/").concat(key), callback); }); });
                        this.once(CLEAR_QUEUE, function () {
                            limit.clearQueue();
                        });
                        return [4 /*yield*/, Promise.all(jobs)];
                    case 4:
                        _a.sent();
                        return [2 /*return*/];
                }
            });
        });
    };
    ZooKeeper.prototype.loadServices = function (appName) {
        var _this = this;
        return this.exec(function (client, options) { return tslib_1.__awaiter(_this, void 0, void 0, function () {
            var basePath, metadataList, error_3;
            var _a;
            return tslib_1.__generator(this, function (_b) {
                switch (_b.label) {
                    case 0:
                        basePath = "/".concat((_a = options.group) !== null && _a !== void 0 ? _a : dubbo_1.ZOOKEEPER_DUBBO_DEFAULT_ROOT_NODE);
                        metadataList = [];
                        _b.label = 1;
                    case 1:
                        _b.trys.push([1, 3, , 4]);
                        return [4 /*yield*/, this.traverse(client, 'metadata', basePath, function (data) {
                                metadataList.push(data);
                            })];
                    case 2:
                        _b.sent();
                        return [3 /*break*/, 4];
                    case 3:
                        error_3 = _b.sent();
                        if (error_3 instanceof node_zookeeper_client_1.default.Exception && error_3.code === node_zookeeper_client_1.default.Exception.NO_NODE) {
                            this.logger.warn("load services failed: ".concat(error_3));
                        }
                        else {
                            throw error_3;
                        }
                        return [3 /*break*/, 4];
                    case 4: return [2 /*return*/, this._adapter.parseMetadataList(appName, metadataList)];
                }
            });
        }); });
    };
    return ZooKeeper;
}(event_lite_1.default));
exports.ZooKeeper = ZooKeeper;
