"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ServiceProfile = void 0;
var tslib_1 = require("tslib");
var jsonpath_1 = tslib_1.__importDefault(require("jsonpath"));
var dubbo_metadata_parser_1 = require("./dubbo-metadata-parser");
var ServiceProfile = /** @class */ (function () {
    function ServiceProfile(_name, _type) {
        this._name = _name;
        this._type = _type;
        this._id = 0;
        this._location = '';
        this._dataSchemas = [];
        this._rpcModuleMap = new Map();
    }
    ServiceProfile.prototype.parseDubboMetadata = function (metadataList) {
        var parser = new dubbo_metadata_parser_1.DubboMetadataParser(this._name);
        var _a = parser.parse(metadataList), dataSchemas = _a.dataSchemas, rpcModuleMap = _a.rpcModuleMap, messageLoader = _a.messageLoader;
        this._dataSchemas = dataSchemas;
        this._rpcModuleMap = rpcModuleMap;
        this._messageLoader = messageLoader;
    };
    ServiceProfile.prototype.toJSON = function () {
        var _this = this;
        var _a, _b;
        var result = {
            name: this._name,
            location: this._location,
            id: this._id,
            type: this._type,
            dataSchemas: this._dataSchemas.sort(function (a, b) { return a.path.localeCompare(b.path); }),
            rpcModules: Array.from(this._rpcModuleMap.values()).map(function (rpcModule) {
                var _a, _b;
                return tslib_1.__assign(tslib_1.__assign({}, rpcModule), { rpcServices: rpcModule.rpcServices.map(function (rpcService) {
                        return tslib_1.__assign(tslib_1.__assign({}, rpcService), { rpcMethods: rpcService.rpcMethods.sort(function (a, b) { return a.requestPath.localeCompare(b.requestPath); }) });
                    }).sort(function (a, b) { return a.name.localeCompare(b.name); }), rpcMessages: (_b = (_a = _this._messageLoader) === null || _a === void 0 ? void 0 : _a.getMessages(rpcModule.name).sort(function (a, b) { return a.path.localeCompare(b.path); })) !== null && _b !== void 0 ? _b : [] });
            }).sort(function (a, b) { return a.name.localeCompare(b.name); }),
        };
        (_a = this._messageLoader) === null || _a === void 0 ? void 0 : _a.trimJSONSchemaProperties(jsonpath_1.default.query(result, '$.dataSchemas[*].jsonSchema'));
        (_b = this._messageLoader) === null || _b === void 0 ? void 0 : _b.trimJSONSchemaProperties(jsonpath_1.default.query(result, '$.rpcModules[*].rpcMessages[*].jsonSchema'));
        return result;
    };
    return ServiceProfile;
}());
exports.ServiceProfile = ServiceProfile;
