"use strict";
// cspell:ignore edas, canonicalized
Object.defineProperty(exports, "__esModule", { value: true });
exports.sign = exports.EDAS_ENDPOINT_PATTERN = void 0;
var tslib_1 = require("tslib");
var md5_1 = tslib_1.__importDefault(require("crypto-js/md5"));
var enc_base64_1 = tslib_1.__importDefault(require("crypto-js/enc-base64"));
var hmac_sha1_1 = tslib_1.__importDefault(require("crypto-js/hmac-sha1"));
exports.EDAS_ENDPOINT_PATTERN = 'https://edas.{region}.aliyuncs.com';
function formatParamString(params, formatItem, connector) {
    var keys = Object.keys(params);
    keys.sort(function (a, b) { return a.localeCompare(b); });
    return keys.map(function (key) { return formatItem(key, params[key]); }).filter(Boolean).join(connector);
}
function sign(params) {
    var _a, _b, _c;
    var date = (_a = params.date) !== null && _a !== void 0 ? _a : new Date().toUTCString();
    var accept = 'application/json';
    var contentType = 'application/json';
    var contentMD5 = enc_base64_1.default.stringify((0, md5_1.default)(params.data));
    var acsHeaders = {
        'x-acs-signature-method': 'HMAC-SHA1',
        'x-acs-signature-nonce': (_b = params.nonce) !== null && _b !== void 0 ? _b : Math.random().toString(36).slice(2),
        'x-acs-version': '2017-08-01',
        'x-acs-signature-version': '1.0'
    };
    var canonicalizedHeadersStr = formatParamString(acsHeaders, function (key, value) {
        return "".concat(key, ":").concat(value);
    }, '\n');
    var queryStr = formatParamString((_c = params.query) !== null && _c !== void 0 ? _c : {}, function (key, value) {
        if (typeof value === 'undefined') {
            return '';
        }
        if (value !== '') {
            return "".concat(key, "=").concat(value);
        }
        return key;
    }, '&');
    var pathname = params.path;
    try {
        pathname = new URL(pathname).pathname;
    }
    catch (err) {
        // ignore
    }
    var canonicalizedResource = queryStr ? "".concat(pathname, "?").concat(queryStr) : pathname;
    var stringToSign = "".concat(params.method.toUpperCase(), "\n").concat(accept, "\n").concat(contentMD5, "\n").concat(contentType, "\n") +
        "".concat(date, "\n").concat(canonicalizedHeadersStr, "\n").concat(canonicalizedResource);
    var signature = enc_base64_1.default.stringify((0, hmac_sha1_1.default)(stringToSign, params.signingKey));
    return {
        headers: tslib_1.__assign(tslib_1.__assign({}, acsHeaders), { Date: date, 'Content-Type': contentType, 'Content-MD5': contentMD5, Authorization: "acs ".concat(params.accessKeyId, ":").concat(signature), Accept: accept })
    };
}
exports.sign = sign;
