"use strict";

var __awaiter = this && this.__awaiter || function(e, a, u, _) {
    return new (u = u || Promise)(function(r, t) {
        function n(e) {
            try {
                c(_.next(e));
            } catch (e) {
                t(e);
            }
        }
        function i(e) {
            try {
                c(_.throw(e));
            } catch (e) {
                t(e);
            }
        }
        function c(e) {
            var t;
            e.done ? r(e.value) : ((t = e.value) instanceof u ? t : new u(function(e) {
                e(t);
            })).then(n, i);
        }
        c((_ = _.apply(e, a || [])).next());
    });
}, __generator = this && this.__generator || function(r, n) {
    var i, c, a, u = {
        label: 0,
        sent: function() {
            if (1 & a[0]) throw a[1];
            return a[1];
        },
        trys: [],
        ops: []
    }, e = {
        next: t(0),
        throw: t(1),
        return: t(2)
    };
    return "function" == typeof Symbol && (e[Symbol.iterator] = function() {
        return this;
    }), e;
    function t(t) {
        return function(e) {
            return function(t) {
                if (i) throw new TypeError("Generator is already executing.");
                for (;u; ) try {
                    if (i = 1, c && (a = 2 & t[0] ? c.return : t[0] ? c.throw || ((a = c.return) && a.call(c), 
                    0) : c.next) && !(a = a.call(c, t[1])).done) return a;
                    switch (c = 0, a && (t = [ 2 & t[0], a.value ]), t[0]) {
                      case 0:
                      case 1:
                        a = t;
                        break;

                      case 4:
                        return u.label++, {
                            value: t[1],
                            done: !1
                        };

                      case 5:
                        u.label++, c = t[1], t = [ 0 ];
                        continue;

                      case 7:
                        t = u.ops.pop(), u.trys.pop();
                        continue;

                      default:
                        if (!(a = 0 < (a = u.trys).length && a[a.length - 1]) && (6 === t[0] || 2 === t[0])) {
                            u = 0;
                            continue;
                        }
                        if (3 === t[0] && (!a || t[1] > a[0] && t[1] < a[3])) {
                            u.label = t[1];
                            break;
                        }
                        if (6 === t[0] && u.label < a[1]) {
                            u.label = a[1], a = t;
                            break;
                        }
                        if (a && u.label < a[2]) {
                            u.label = a[2], u.ops.push(t);
                            break;
                        }
                        a[2] && u.ops.pop(), u.trys.pop();
                        continue;
                    }
                    t = n.call(r, u);
                } catch (e) {
                    t = [ 6, e ], c = 0;
                } finally {
                    i = a = 0;
                }
                if (5 & t[0]) throw t[1];
                return {
                    value: t[0] ? t[1] : void 0,
                    done: !0
                };
            }([ t, e ]);
        };
    }
};

Object.defineProperty(exports, "__esModule", {
    value: !0
});

var dbtype_1 = require("../driver/dbtype"), bufferUtil_1 = require("../utils/bufferUtil"), error_1 = require("../driver/error"), const_1 = require("../desc/const"), convertUtil_1 = require("../utils/convertUtil"), dateUtil_1 = require("../utils/dateUtil"), numeric_1 = require("../driver/numeric"), offRowBufferBinder_1 = require("./offRowBufferBinder"), stringUtil_1 = require("../utils/stringUtil"), oracleDateFormat_1 = require("../utils/oracleDateFormat"), intervalDT_1 = require("../driver/intervalDT"), intervalYM_1 = require("../driver/intervalYM"), typeData_1 = require("../desc/typeData"), offRowBlobBinder_1 = require("./offRowBlobBinder"), offRowClobBinder_1 = require("./offRowClobBinder"), offRowReadableBinder_1 = require("./offRowReadableBinder"), J2DB = function() {
    function o() {}
    return o.fromBoolean = function(e, t, r) {
        switch (t.type) {
          case dbtype_1.DBType.BOOLEAN:
          case dbtype_1.DBType.BIT:
          case dbtype_1.DBType.TINYINT:
          case dbtype_1.DBType.SMALLINT:
          case dbtype_1.DBType.INT:
          case dbtype_1.DBType.BIGINT:
          case dbtype_1.DBType.REAL:
          case dbtype_1.DBType.DOUBLE:
          case dbtype_1.DBType.DECIMAL:
          case dbtype_1.DBType.CHAR:
          case dbtype_1.DBType.VARCHAR2:
          case dbtype_1.DBType.VARCHAR:
          case dbtype_1.DBType.CLOB:
            return this.fromNumber(e ? 1 : 0, t, r);

          case dbtype_1.DBType.BINARY:
          case dbtype_1.DBType.VARBINARY:
          case dbtype_1.DBType.BLOB:
            return bufferUtil_1.BufferUtil.a(e ? 1 : 0);

          default:
            throw error_1.DBError.ECJS_DATA_CONVERTION_ERROR();
        }
    }, o.fromNumber = function(e, t, r) {
        switch (t.type) {
          case dbtype_1.DBType.BOOLEAN:
          case dbtype_1.DBType.BIT:
            return bufferUtil_1.BufferUtil.a(0 === e ? 0 : 1);

          case dbtype_1.DBType.TINYINT:
            return checkTinyInt(e), bufferUtil_1.BufferUtil.a(e);

          case dbtype_1.DBType.SMALLINT:
            return checkSmallInt(e), bufferUtil_1.BufferUtil._(e);

          case dbtype_1.DBType.INT:
            return checkInt(e), bufferUtil_1.BufferUtil.s(e);

          case dbtype_1.DBType.BIGINT:
            return checkBigInt(e), bufferUtil_1.BufferUtil.o(BigInt(e));

          case dbtype_1.DBType.REAL:
            return checkReal(e), bufferUtil_1.BufferUtil.f(e);

          case dbtype_1.DBType.DOUBLE:
            return bufferUtil_1.BufferUtil.d(e);

          case dbtype_1.DBType.DECIMAL:
            return numeric_1.Numeric.fromNumber(e, t.prec, t.scale).encode();

          case dbtype_1.DBType.CHAR:
          case dbtype_1.DBType.VARCHAR2:
          case dbtype_1.DBType.VARCHAR:
          case dbtype_1.DBType.CLOB:
            return bufferUtil_1.BufferUtil.b(e.toLocaleString("en-IN", {
                useGrouping: !1,
                maximumFractionDigits: 20
            }), r.getServerEncoding());

          case dbtype_1.DBType.BINARY:
          case dbtype_1.DBType.VARBINARY:
          case dbtype_1.DBType.BLOB:
            if (Number.isSafeInteger(e)) return this.toBinary(BigInt(e), t.prec);
            throw error_1.DBError.ECJS_DATA_CONVERTION_ERROR();

          case dbtype_1.DBType.DATE:
          case dbtype_1.DBType.TIME:
          case dbtype_1.DBType.DATETIME:
          case dbtype_1.DBType.DATETIME2:
            if (Number.isSafeInteger(e)) return dateUtil_1.DateUtil.toDateFromNumber(e, t, r.conn_prop_localTimezone, r.dbTimezone);
            throw error_1.DBError.ECJS_DATA_CONVERTION_ERROR();

          default:
            throw error_1.DBError.ECJS_DATA_CONVERTION_ERROR();
        }
    }, o.fromBigInt = function(e, t, r) {
        switch (t.type) {
          case dbtype_1.DBType.BOOLEAN:
          case dbtype_1.DBType.BIT:
            return bufferUtil_1.BufferUtil.a(e === BigInt(0) ? 0 : 1);

          case dbtype_1.DBType.TINYINT:
            return checkTinyInt(e), bufferUtil_1.BufferUtil.a(Number(e));

          case dbtype_1.DBType.SMALLINT:
            return checkSmallInt(e), bufferUtil_1.BufferUtil._(Number(e));

          case dbtype_1.DBType.INT:
            return checkInt(e), bufferUtil_1.BufferUtil.s(Number(e));

          case dbtype_1.DBType.BIGINT:
            return checkBigInt(e), bufferUtil_1.BufferUtil.o(e);

          case dbtype_1.DBType.REAL:
            return checkReal(e), bufferUtil_1.BufferUtil.f(Number(e));

          case dbtype_1.DBType.DOUBLE:
            return bufferUtil_1.BufferUtil.d(Number(e));

          case dbtype_1.DBType.DECIMAL:
            return numeric_1.Numeric.fromString(e.toString(), t.prec, t.scale).encode();

          case dbtype_1.DBType.CHAR:
          case dbtype_1.DBType.VARCHAR2:
          case dbtype_1.DBType.VARCHAR:
          case dbtype_1.DBType.CLOB:
            return bufferUtil_1.BufferUtil.b(e.toString(), r.getServerEncoding());

          default:
            throw error_1.DBError.ECJS_DATA_CONVERTION_ERROR();
        }
    }, o.fromString = function(n, i, c) {
        return __awaiter(this, void 0, void 0, function() {
            var t, r;
            return __generator(this, function(e) {
                switch (i.type) {
                  case dbtype_1.DBType.BOOLEAN:
                  case dbtype_1.DBType.BIT:
                    return [ 2, bufferUtil_1.BufferUtil.a(convertUtil_1.ConvertUtil.toBoolean(n) ? 1 : 0) ];

                  case dbtype_1.DBType.TINYINT:
                  case dbtype_1.DBType.SMALLINT:
                  case dbtype_1.DBType.INT:
                    return [ 2, this.fromNumber(Number(Number(n).toFixed()), i, c) ];

                  case dbtype_1.DBType.BIGINT:
                    try {
                        return t = convertUtil_1.ConvertUtil.toBigInt(n), [ 2, this.fromBigInt(t, i, c) ];
                    } catch (e) {
                        throw error_1.DBError.ECJS_DATA_CONVERTION_ERROR();
                    }

                  case dbtype_1.DBType.REAL:
                  case dbtype_1.DBType.DOUBLE:
                    if (r = parseFloat(n), Number.isNaN(r)) throw error_1.DBError.ECJS_DATA_CONVERTION_ERROR();
                    return [ 2, this.fromNumber(r, i, c) ];

                  case dbtype_1.DBType.DECIMAL:
                    return [ 2, numeric_1.Numeric.fromString(n, i.prec, i.scale).encode() ];

                  case dbtype_1.DBType.CHAR:
                  case dbtype_1.DBType.VARCHAR2:
                  case dbtype_1.DBType.VARCHAR:
                    if (i.mask === const_1.Const.MASK_BFILE && !dbtype_1.DBType.isValidBFileStr(n)) throw error_1.DBError.ECJS_INVALID_BFILE_STR();
                    return [ 2, bufferUtil_1.BufferUtil.b(n, c.getServerEncoding()) ];

                  case dbtype_1.DBType.CLOB:
                    return [ 2, this.string2clob(n, i, c) ];

                  case dbtype_1.DBType.BINARY:
                  case dbtype_1.DBType.VARBINARY:
                    return [ 2, stringUtil_1.StringUtil.hexStringToBuffer(n) ];

                  case dbtype_1.DBType.BLOB:
                    if (dbtype_1.DBType.isComplexType(i.type, i.scale)) throw error_1.DBError.ECJS_DATA_CONVERTION_ERROR();
                    return [ 2, this.buffer2blob(stringUtil_1.StringUtil.hexStringToBuffer(n), i, c) ];

                  case dbtype_1.DBType.DATE:
                    return c.formatDate && "" !== c.formatDate ? [ 2, dateUtil_1.DateUtil.encode(oracleDateFormat_1.OracleDateFormat.parse(n, c.formatDate, c.oracleDateLanguage), i, c.conn_prop_localTimezone, c.dbTimezone) ] : [ 2, dateUtil_1.DateUtil.encodeByString(n, i, c.conn_prop_localTimezone, c.dbTimezone) ];

                  case dbtype_1.DBType.TIME:
                    return c.formatTime && "" !== c.formatTime ? [ 2, dateUtil_1.DateUtil.encode(oracleDateFormat_1.OracleDateFormat.parse(n, c.formatTime, c.oracleDateLanguage), i, c.conn_prop_localTimezone, c.dbTimezone) ] : [ 2, dateUtil_1.DateUtil.encodeByString(n, i, c.conn_prop_localTimezone, c.dbTimezone) ];

                  case dbtype_1.DBType.DATETIME:
                  case dbtype_1.DBType.DATETIME2:
                    return c.formatTimestamp && "" !== c.formatTimestamp ? [ 2, dateUtil_1.DateUtil.encode(oracleDateFormat_1.OracleDateFormat.parse(n, c.formatTimestamp, c.oracleDateLanguage), i, c.conn_prop_localTimezone, c.dbTimezone) ] : [ 2, dateUtil_1.DateUtil.encodeByString(n, i, c.conn_prop_localTimezone, c.dbTimezone) ];

                  case dbtype_1.DBType.TIME_TZ:
                    return c.formatTimeTZ && "" !== c.formatTimeTZ ? [ 2, dateUtil_1.DateUtil.encode(oracleDateFormat_1.OracleDateFormat.parse(n, c.formatTimeTZ, c.oracleDateLanguage), i, c.conn_prop_localTimezone, c.dbTimezone) ] : [ 2, dateUtil_1.DateUtil.encodeByString(n, i, c.conn_prop_localTimezone, c.dbTimezone) ];

                  case dbtype_1.DBType.DATETIME_TZ:
                  case dbtype_1.DBType.DATETIME2_TZ:
                    return c.formatTimestampTZ && "" !== c.formatTimestampTZ ? [ 2, dateUtil_1.DateUtil.encode(oracleDateFormat_1.OracleDateFormat.parse(n, c.formatTimestampTZ, c.oracleDateLanguage), i, c.conn_prop_localTimezone, c.dbTimezone) ] : [ 2, dateUtil_1.DateUtil.encodeByString(n, i, c.conn_prop_localTimezone, c.dbTimezone) ];

                  case dbtype_1.DBType.INTERVAL_DT:
                    return [ 2, new intervalDT_1.IntervalDT(n).encode(i.scale) ];

                  case dbtype_1.DBType.INTERVAL_YM:
                    return [ 2, new intervalYM_1.IntervalYM(n).encode(i.scale) ];

                  default:
                    throw error_1.DBError.ECJS_DATA_CONVERTION_ERROR();
                }
                return [ 2 ];
            });
        });
    }, o.fromBlob = function(u, _, s) {
        return __awaiter(this, void 0, void 0, function() {
            var t, r, n, i, c, a;
            return __generator(this, function(e) {
                switch (e.label) {
                  case 0:
                    switch (_.type) {
                      case dbtype_1.DBType.BINARY:
                      case dbtype_1.DBType.VARBINARY:
                        return [ 3, 1 ];

                      case dbtype_1.DBType.BLOB:
                        return [ 3, 3 ];

                      case dbtype_1.DBType.ARRAY:
                      case dbtype_1.DBType.CLASS:
                      case dbtype_1.DBType.PLTYPE_RECORD:
                      case dbtype_1.DBType.SARRAY:
                        return [ 3, 4 ];
                    }
                    return [ 3, 8 ];

                  case 1:
                    return [ 4, u.getLength() ];

                  case 2:
                    return t = e.sent(), [ 2, u.getBytes(1, t) ];

                  case 3:
                    return [ 2, o.blob2blob(u, _, s) ];

                  case 4:
                    return (r = _.typeDescriptor) ? (c = (i = u).getBytes, a = [ 1 ], [ 4, u.getLength() ]) : [ 3, 7 ];

                  case 5:
                    return [ 4, c.apply(i, a.concat([ e.sent() ])) ];

                  case 6:
                    return n = e.sent(), [ 2, typeData_1.TypeData.objBlobToBuffer(n, r) ];

                  case 7:
                  case 8:
                    throw error_1.DBError.ECJS_DATA_CONVERTION_ERROR();
                }
            });
        });
    }, o.fromClob = function(c, a, u) {
        return __awaiter(this, void 0, void 0, function() {
            var t, r, n, i;
            return __generator(this, function(e) {
                switch (e.label) {
                  case 0:
                    switch (a.type) {
                      case dbtype_1.DBType.CHAR:
                      case dbtype_1.DBType.VARCHAR:
                      case dbtype_1.DBType.VARCHAR2:
                        return [ 3, 1 ];

                      case dbtype_1.DBType.CLOB:
                        return [ 3, 4 ];
                    }
                    return [ 3, 5 ];

                  case 1:
                    return n = (r = c).getSubString, i = [ 1 ], [ 4, c.getLength() ];

                  case 2:
                    return [ 4, n.apply(r, i.concat([ e.sent() ])) ];

                  case 3:
                    return t = e.sent(), [ 2, bufferUtil_1.BufferUtil.b(t, u.getServerEncoding()) ];

                  case 4:
                    return [ 2, o.clob2clob(c, a, u) ];

                  case 5:
                    throw error_1.DBError.ECJS_DATA_CONVERTION_ERROR();
                }
            });
        });
    }, o.fromDate = function(e, t, r) {
        switch (t.type) {
          case dbtype_1.DBType.CHAR:
          case dbtype_1.DBType.VARCHAR2:
          case dbtype_1.DBType.VARCHAR:
          case dbtype_1.DBType.CLOB:
            return bufferUtil_1.BufferUtil.b(e.toISOString(), r.getServerEncoding());

          case dbtype_1.DBType.DATE:
          case dbtype_1.DBType.TIME:
          case dbtype_1.DBType.TIME_TZ:
          case dbtype_1.DBType.DATETIME:
          case dbtype_1.DBType.DATETIME2:
          case dbtype_1.DBType.DATETIME_TZ:
          case dbtype_1.DBType.DATETIME2_TZ:
            return dateUtil_1.DateUtil.encodeByDate(e, t, r.conn_prop_localTimezone, r.dbTimezone);

          default:
            throw error_1.DBError.ECJS_DATA_CONVERTION_ERROR();
        }
    }, o.fromBuffer = function(t, r, n) {
        return __awaiter(this, void 0, void 0, function() {
            return __generator(this, function(e) {
                switch (r.type) {
                  case dbtype_1.DBType.CHAR:
                  case dbtype_1.DBType.VARCHAR2:
                  case dbtype_1.DBType.VARCHAR:
                    return [ 2, this.toVarchar(t) ];

                  case dbtype_1.DBType.CLOB:
                    return [ 2, this.buffer2clob(t, r, n) ];

                  case dbtype_1.DBType.BINARY:
                  case dbtype_1.DBType.VARBINARY:
                    return [ 2, t ];

                  case dbtype_1.DBType.BLOB:
                    return [ 2, this.buffer2blob(t, r, n) ];

                  case dbtype_1.DBType.ARRAY:
                  case dbtype_1.DBType.CLASS:
                  case dbtype_1.DBType.PLTYPE_RECORD:
                  case dbtype_1.DBType.SARRAY:
                    if (r.typeDescriptor) return [ 2, typeData_1.TypeData.objBlobToBuffer(t, r.typeDescriptor) ];
                    throw error_1.DBError.ECJS_DATA_CONVERTION_ERROR();

                  default:
                    throw error_1.DBError.ECJS_DATA_CONVERTION_ERROR();
                }
                return [ 2 ];
            });
        });
    }, o.fromReadable = function(i, r, c) {
        return __awaiter(this, void 0, void 0, function() {
            var t, n;
            return __generator(this, function(e) {
                switch (e.label) {
                  case 0:
                    switch (r.type) {
                      case dbtype_1.DBType.CHAR:
                      case dbtype_1.DBType.VARCHAR:
                      case dbtype_1.DBType.VARCHAR2:
                      case dbtype_1.DBType.BINARY:
                      case dbtype_1.DBType.VARBINARY:
                        return [ 3, 1 ];

                      case dbtype_1.DBType.BLOB:
                      case dbtype_1.DBType.CLOB:
                        return [ 3, 2 ];

                      case dbtype_1.DBType.ARRAY:
                      case dbtype_1.DBType.CLASS:
                      case dbtype_1.DBType.PLTYPE_RECORD:
                      case dbtype_1.DBType.SARRAY:
                        return [ 3, 4 ];
                    }
                    return [ 3, 5 ];

                  case 1:
                    return [ 2, new Promise(function(e, t) {
                        i.setEncoding("binary");
                        var r = Buffer.alloc(0);
                        i.on("data", function(e) {
                            r = Buffer.concat([ r, e ], r.length + e.length);
                        }), i.once("error", function(e) {
                            t(e);
                        }), i.once("end", function() {
                            e(r);
                        });
                    }) ];

                  case 2:
                    return [ 4, new offRowReadableBinder_1.OffRowReadableBinder(i, c.getServerEncoding()).init() ];

                  case 3:
                    return [ 2, (t = e.sent()).offRow ? t : t.readAll() ];

                  case 4:
                    if (n = r.typeDescriptor) return [ 2, new Promise(function(e, t) {
                        i.setEncoding("binary");
                        var r = Buffer.alloc(0);
                        i.on("data", function(e) {
                            r = Buffer.concat([ r, e ], r.length + e.length);
                        }), i.once("error", function(e) {
                            t(e);
                        }), i.once("end", function() {
                            e(typeData_1.TypeData.objBlobToBuffer(r, n));
                        });
                    }) ];
                    throw error_1.DBError.ECJS_DATA_CONVERTION_ERROR();

                  case 5:
                    throw error_1.DBError.ECJS_DATA_CONVERTION_ERROR();
                }
            });
        });
    }, o.blob2blob = function(a, u, _) {
        return __awaiter(this, void 0, void 0, function() {
            var t, r, n, i, c;
            return __generator(this, function(e) {
                switch (e.label) {
                  case 0:
                    return t = this.isOffRow, r = [ u.type ], [ 4, a.getLength() ];

                  case 1:
                    return t.apply(this, r.concat([ e.sent() ])) ? [ 2, new offRowBlobBinder_1.OffRowBlobBinder(a, _.getServerEncoding()).init() ] : (i = (n = a).getBytes, 
                    c = [ 1 ], [ 4, a.getLength() ]);

                  case 2:
                    return [ 2, i.apply(n, c.concat([ e.sent() ])) ];
                }
            });
        });
    }, o.clob2clob = function(u, _, s) {
        return __awaiter(this, void 0, void 0, function() {
            var t, r, n, i, c, a;
            return __generator(this, function(e) {
                switch (e.label) {
                  case 0:
                    return t = this.isOffRow, r = [ _.type ], [ 4, u.getLength() ];

                  case 1:
                    return t.apply(this, r.concat([ e.sent() ])) ? [ 2, new offRowClobBinder_1.OffRowClobBinder(u, s.getServerEncoding()).init() ] : (c = (i = u).getSubString, 
                    a = [ 1 ], [ 4, u.getLength() ]);

                  case 2:
                    return [ 4, c.apply(i, a.concat([ e.sent() ])) ];

                  case 3:
                    return n = e.sent(), [ 2, bufferUtil_1.BufferUtil.b(n, s.getServerEncoding()) ];
                }
            });
        });
    }, o.buffer2blob = function(t, r, n) {
        return __awaiter(this, void 0, void 0, function() {
            return __generator(this, function(e) {
                return [ 2, this.changeOffRowData(r, t, n.getServerEncoding()) ];
            });
        });
    }, o.string2clob = function(t, r, n) {
        return __awaiter(this, void 0, void 0, function() {
            return __generator(this, function(e) {
                return [ 2, this.changeOffRowData(r, bufferUtil_1.BufferUtil.b(t, n.getServerEncoding()), n.getServerEncoding()) ];
            });
        });
    }, o.buffer2clob = function(t, r, n) {
        return __awaiter(this, void 0, void 0, function() {
            return __generator(this, function(e) {
                return [ 2, this.changeOffRowData(r, this.toVarchar(t), n.getServerEncoding()) ];
            });
        });
    }, o.changeOffRowData = function(t, r, n) {
        return __awaiter(this, void 0, void 0, function() {
            return __generator(this, function(e) {
                return [ 2, this.isOffRow(t.type, r.length) ? new offRowBufferBinder_1.OffRowBufferBinder(r, n).init() : r ];
            });
        });
    }, o.isOffRow = function(e, t) {
        return (e === dbtype_1.DBType.BLOB || e === dbtype_1.DBType.CLOB) && t > const_1.Const.PUT_LOB_LEN;
    }, o.toVarchar = function(e) {
        if (!e || 0 === e.length) return Buffer.alloc(0);
        for (var t, r = Buffer.alloc(2 * e.length), n = 0; n < e.length; n++) t = this.toChar(e[n]), 
        r[2 * n] = t[0], r[2 * n + 1] = t[1];
        return r;
    }, o.toBinary = function(e, t) {
        var r = bufferUtil_1.BufferUtil.o(e);
        return 0 < t && t < r.length ? r.slice(r.length - t) : r;
    }, o.toChar = function(e) {
        var t = Buffer.alloc(2);
        return t[0] = this.getCharByNumVal(e >> 4 & 15), t[1] = this.getCharByNumVal(15 & e), 
        t;
    }, o.getCharByNumVal = function(e) {
        if (0 <= e && e <= 9) return e + 48;
        if (10 <= e && e <= 15) return e + 65 - 10;
        throw error_1.DBError.ECJS_INVALID_HEX();
    }, o;
}();

function checkTinyInt(e) {
    if (e < const_1.Const.INT8_MIN || e > const_1.Const.INT8_MAX) throw error_1.DBError.EC_DATA_OVERFLOW();
}

function checkSmallInt(e) {
    if (e < const_1.Const.INT16_MIN || e > const_1.Const.INT16_MAX) throw error_1.DBError.EC_DATA_OVERFLOW();
}

function checkInt(e) {
    if (e < const_1.Const.INT32_MIN || e > const_1.Const.INT32_MAX) throw error_1.DBError.EC_DATA_OVERFLOW();
}

function checkBigInt(e) {
    if (e < const_1.Const.INT64_MIN || e > const_1.Const.INT64_MAX) throw error_1.DBError.EC_DATA_OVERFLOW();
}

function checkReal(e) {
    if (e < const_1.Const.REAL_MIN || e > const_1.Const.REAL_MAX) throw error_1.DBError.EC_DATA_OVERFLOW();
}

exports.J2DB = J2DB;