"use strict";

Object.defineProperty(exports, "__esModule", {
    value: !0
});

var bufferUtil_1 = require("../utils/bufferUtil"), error_1 = require("./error"), IntervalDT = function() {
    function c(t, i, h, s, r, e, a, f) {
        if (this.scaleForSvr = 0, this.leadScale = 2, this.secScale = 6, this.negative = !1, 
        this.type = c.QUA_D, this.days = 0, this.hours = 0, this.minutes = 0, this.seconds = 0, 
        this.fraction = 0, t instanceof Buffer) {
            switch (this.type = t[21], this.scaleForSvr = bufferUtil_1.BufferUtil.t(t, 20), 
            this.leadScale = this.scaleForSvr >> 4 & 15, this.secScale = 15 & this.scaleForSvr, 
            this.type) {
              case c.QUA_D:
                this.days = bufferUtil_1.BufferUtil.t(t, 0);
                break;

              case c.QUA_DH:
                this.days = bufferUtil_1.BufferUtil.t(t, 0), this.hours = bufferUtil_1.BufferUtil.t(t, 4);
                break;

              case c.QUA_DHM:
                this.days = bufferUtil_1.BufferUtil.t(t, 0), this.hours = bufferUtil_1.BufferUtil.t(t, 4), 
                this.minutes = bufferUtil_1.BufferUtil.t(t, 8);
                break;

              case c.QUA_DHMS:
                this.days = bufferUtil_1.BufferUtil.t(t, 0), this.hours = bufferUtil_1.BufferUtil.t(t, 4), 
                this.minutes = bufferUtil_1.BufferUtil.t(t, 8), this.seconds = bufferUtil_1.BufferUtil.t(t, 12), 
                this.fraction = bufferUtil_1.BufferUtil.t(t, 16);
                break;

              case c.QUA_H:
                this.hours = bufferUtil_1.BufferUtil.t(t, 4);
                break;

              case c.QUA_HM:
                this.hours = bufferUtil_1.BufferUtil.t(t, 4), this.minutes = bufferUtil_1.BufferUtil.t(t, 8);
                break;

              case c.QUA_HMS:
                this.hours = bufferUtil_1.BufferUtil.t(t, 4), this.minutes = bufferUtil_1.BufferUtil.t(t, 8), 
                this.seconds = bufferUtil_1.BufferUtil.t(t, 12), this.fraction = bufferUtil_1.BufferUtil.t(t, 16);
                break;

              case c.QUA_M:
                this.minutes = bufferUtil_1.BufferUtil.t(t, 8);
                break;

              case c.QUA_MS:
                this.minutes = bufferUtil_1.BufferUtil.t(t, 8), this.seconds = bufferUtil_1.BufferUtil.t(t, 12), 
                this.fraction = bufferUtil_1.BufferUtil.t(t, 16);
                break;

              case c.QUA_S:
                this.seconds = bufferUtil_1.BufferUtil.t(t, 12), this.fraction = bufferUtil_1.BufferUtil.t(t, 16);
            }
            this.days < 0 && (this.days = -this.days, this.negative = !0), this.hours < 0 && (this.hours = -this.hours, 
            this.negative = !0), this.minutes < 0 && (this.minutes = -this.minutes, this.negative = !0), 
            this.seconds < 0 && (this.seconds = -this.seconds, this.negative = !0), this.fraction < 0 && (this.fraction = -this.fraction, 
            this.negative = !0);
        } else "string" == typeof t ? this.parseIntervalDTString(t) : (this.type = t, this.negative = i, 
        this.leadScale = f >> 4 & 15, this.secScale = 15 & f, this.days = h, this.hours = s, 
        this.minutes = r, this.seconds = e, this.fraction = a, this.scaleForSvr = f);
    }
    return c.prototype.encode = function(t) {
        0 == t && (t = this.scaleForSvr);
        var i, h, s = this.days, r = this.hours, e = this.minutes, a = this.seconds, f = this.fraction;
        t != this.scaleForSvr ? (s = (i = this.convertTo(t)).days, r = i.hours, e = i.minutes, 
        a = i.seconds, f = i.fraction) : (h = t >> 4 & 15, this.checkScale(h));
        var o = Buffer.alloc(24);
        return bufferUtil_1.BufferUtil.v(o, 0, this.negative ? -s : s), bufferUtil_1.BufferUtil.v(o, 4, this.negative ? -r : r), 
        bufferUtil_1.BufferUtil.v(o, 8, this.negative ? -e : e), bufferUtil_1.BufferUtil.v(o, 12, this.negative ? -a : a), 
        bufferUtil_1.BufferUtil.v(o, 16, this.negative ? -f : f), bufferUtil_1.BufferUtil.v(o, 20, t), 
        o;
    }, c.prototype.toString = function() {
        var t, i, h, s, r, e, a, f = "INTERVAL ";
        switch (this.type) {
          case c.QUA_D:
            if (h = this.days.toString(), this.negative && (f += "-"), h.length < this.leadScale) for (t = h.length, 
            i = this.leadScale; i-- > t; ) h = "0" + h;
            f += "'" + h + "' DAY(" + this.leadScale + ")";
            break;

          case c.QUA_DH:
            if (h = this.days.toString(), s = this.hours.toString(), this.negative && (f += "-"), 
            h.length < this.leadScale) for (t = h.length, i = this.leadScale; i-- > t; ) h = "0" + h;
            s.length < 2 && (s = "0" + s), f += "'" + h + " " + s + "' DAY(" + this.leadScale + ") TO HOUR";
            break;

          case c.QUA_DHM:
            if (h = this.days.toString(), s = this.hours.toString(), r = this.minutes.toString(), 
            this.negative && (f += "-"), h.length < this.leadScale) for (t = h.length, i = this.leadScale; i-- > t; ) h = "0" + h;
            s.length < 2 && (s = "0" + s), r.length < 2 && (r = "0" + r), f += "'" + h + " " + s + ":" + r + "' DAY(" + this.leadScale + ") TO MINUTE";
            break;

          case c.QUA_DHMS:
            if (h = this.days.toString(), s = this.hours.toString(), r = this.minutes.toString(), 
            e = this.seconds.toString(), a = this.getMsecString(), this.negative && (f += "-"), 
            h.length < this.leadScale) for (t = h.length, i = this.leadScale; i-- > t; ) h = "0" + h;
            s.length < 2 && (s = "0" + s), r.length < 2 && (r = "0" + r), e.length < 2 && (e = "0" + e), 
            f += "'" + h + " " + s + ":" + r + ":" + e + ("" !== a ? "." + a : "") + "' DAY(" + +this.leadScale + ") TO SECOND(" + this.secScale + ")";
            break;

          case c.QUA_H:
            if (s = this.hours.toString(), this.negative && (f += "-"), s.length < this.leadScale) for (t = s.length, 
            i = this.leadScale; i-- > t; ) s = "0" + s;
            f += "'" + s + "' HOUR(" + this.leadScale + ")";
            break;

          case c.QUA_HM:
            if (s = this.hours.toString(), r = this.minutes.toString(), this.negative && (f += "-"), 
            s.length < this.leadScale) for (t = s.length, i = this.leadScale; i-- > t; ) s = "0" + s;
            r.length < 2 && (r = "0" + r), f += "'" + s + ":" + r + "' HOUR(" + this.leadScale + ") TO MINUTE";
            break;

          case c.QUA_HMS:
            if (a = this.getMsecString(), s = this.hours.toString(), r = this.minutes.toString(), 
            e = this.seconds.toString(), this.negative && (f += "-"), s.length < this.leadScale) for (t = s.length, 
            i = this.leadScale; i-- > t; ) s = "0" + s;
            r.length < 2 && (r = "0" + r), e.length < 2 && (e = "0" + e), f += "'" + s + ":" + r + ":" + e + ("" !== a ? "." + a : "") + "' HOUR(" + this.leadScale + ") TO SECOND(" + this.secScale + ")";
            break;

          case c.QUA_M:
            if (r = this.minutes.toString(), this.negative && (f += "-"), r.length < this.leadScale) for (t = r.length, 
            i = this.leadScale; i-- > t; ) r = "0" + r;
            f += "'" + r + "' MINUTE(" + this.leadScale + ")";
            break;

          case c.QUA_MS:
            if (a = this.getMsecString(), r = this.minutes.toString(), e = this.seconds.toString(), 
            this.negative && (f += "-"), r.length < this.leadScale) for (t = r.length, i = this.leadScale; i-- > t; ) r = "0" + r;
            e.length < 2 && (e = "0" + e), f += "'" + r + ":" + e + ("" !== a ? "." + a : "") + "' MINUTE(" + this.leadScale + ") TO SECOND(" + this.secScale + ")";
            break;

          case c.QUA_S:
            if (a = this.getMsecString(), e = this.seconds.toString(), this.negative && (f += "-"), 
            e.length < this.leadScale) for (t = e.length, i = this.leadScale; i-- > t; ) e = "0" + e;
            f += "'" + e + ("" !== a ? "." + a : "") + "' SECOND(" + this.leadScale + ", " + this.secScale + ")";
        }
        return f;
    }, c.prototype.convertTo = function(t) {
        var i = (65280 & t) >> 8, h = t >> 4 & 15, s = 15 & t, r = new Array(5), e = new Array(5);
        switch (this.type) {
          case c.QUA_D:
            r[0] = this.days;
            break;

          case c.QUA_DH:
            r[0] = this.days, r[1] = this.hours;
            break;

          case c.QUA_DHM:
            r[0] = this.days, r[1] = this.hours, r[2] = this.minutes;
            break;

          case c.QUA_DHMS:
            r[0] = this.days, r[1] = this.hours, r[2] = this.minutes, r[3] = this.seconds, r[4] = this.fraction;
            break;

          case c.QUA_H:
            r[0] = Math.trunc(this.hours / 24), r[1] = this.hours % 24;
            break;

          case c.QUA_HM:
            r[0] = Math.trunc(this.hours / 24), r[1] = this.hours % 24, r[2] = this.minutes;
            break;

          case c.QUA_HMS:
            r[0] = Math.trunc(this.hours / 24), r[1] = this.hours % 24, r[2] = this.minutes, 
            r[3] = this.seconds, r[4] = this.fraction;
            break;

          case c.QUA_M:
            r[0] = Math.trunc(this.minutes / 1440), r[1] = Math.trunc(this.minutes % 1440 / 60), 
            r[2] = this.minutes % 1440 % 60;
            break;

          case c.QUA_MS:
            r[0] = Math.trunc(this.minutes / 1440), r[1] = Math.trunc(this.minutes % 1440 / 60), 
            r[2] = this.minutes % 1440 % 60, r[3] = this.seconds, r[4] = this.fraction;
            break;

          case c.QUA_S:
            r[0] = Math.trunc(this.seconds / 86400), r[1] = Math.trunc(this.seconds % 86400 / 3600), 
            r[2] = Math.trunc(this.seconds % 86400 % 3600 / 60), r[3] = this.seconds % 86400 % 3600 % 60, 
            r[4] = this.fraction;
        }
        switch (i) {
          case c.QUA_D:
            if (e[0] = r[0], 12 <= r[1] && this.incrementDay(c.QUA_D, e), h < Math.abs(e[0]).toString().length) throw error_1.DBError.ECJS_INTERVAL_OVERFLOW();
            break;

          case c.QUA_DH:
            if (e[0] = r[0], e[1] = r[1], 30 <= r[2] && this.incrementHour(c.QUA_DH, e), h < Math.abs(e[0]).toString().length) throw error_1.DBError.ECJS_INTERVAL_OVERFLOW();
            break;

          case c.QUA_DHM:
            if (e[0] = r[0], e[1] = r[1], e[2] = r[2], 30 <= r[3] && this.incrementMinute(c.QUA_DHM, e), 
            h < Math.abs(e[0]).toString().length) throw error_1.DBError.ECJS_INTERVAL_OVERFLOW();
            break;

          case c.QUA_DHMS:
            if (e[0] = r[0], e[1] = r[1], e[2] = r[2], e[3] = r[3], e[4] = r[4], this.convertMSecond(c.QUA_DHMS, e, s), 
            h < Math.abs(e[0]).toString().length) throw error_1.DBError.ECJS_INTERVAL_OVERFLOW();
            break;

          case c.QUA_H:
            if (e[1] = 24 * r[0] + r[1], 30 <= r[2] && this.incrementHour(c.QUA_H, e), h < Math.abs(e[1]).toString().length) throw error_1.DBError.ECJS_INTERVAL_OVERFLOW();
            break;

          case c.QUA_HM:
            if (e[1] = 24 * r[0] + r[1], e[2] = r[2], 30 <= r[3] && this.incrementMinute(c.QUA_HM, e), 
            h < Math.abs(e[1]).toString().length) throw error_1.DBError.ECJS_INTERVAL_OVERFLOW();
            break;

          case c.QUA_HMS:
            if (e[1] = 24 * r[0] + r[1], e[2] = r[2], e[3] = r[3], e[4] = r[4], this.convertMSecond(c.QUA_HMS, e, s), 
            h < Math.abs(e[1]).toString().length) throw error_1.DBError.ECJS_INTERVAL_OVERFLOW();
            break;

          case c.QUA_M:
            if (e[2] = 24 * r[0] * 60 + 60 * r[1] + r[2], 30 <= r[3] && this.incrementMinute(c.QUA_M, e), 
            h < Math.abs(e[2]).toString().length) throw error_1.DBError.ECJS_INTERVAL_OVERFLOW();
            break;

          case c.QUA_MS:
            if (e[2] = 24 * r[0] * 60 + 60 * r[1] + r[2], e[3] = r[3], e[4] = r[4], this.convertMSecond(c.QUA_MS, e, s), 
            h < Math.abs(e[2]).toString().length) throw error_1.DBError.ECJS_INTERVAL_OVERFLOW();
            break;

          case c.QUA_S:
            if (e[3] = 24 * r[0] * 60 * 60 + 60 * r[1] * 60 + 60 * r[2] + r[3], e[4] = r[4], 
            this.convertMSecond(c.QUA_S, e, s), h < Math.abs(e[3]).toString().length) throw error_1.DBError.ECJS_INTERVAL_OVERFLOW();
        }
        return new c(i, this.negative, e[0], e[1], e[2], e[3], e[4], t);
    }, c.prototype.convertMSecond = function(t, i, h) {
        var s = i[4];
        if (0 === h || h < this.secScale) {
            var r = Math.pow(10, 6 - h - 1), e = Math.trunc(s / r / 10);
            if (5 <= s / r % 10 && 1e6 == (e = ++e * r * 10)) return i[4] = 0, void this.incrementSecond(t, i);
            i[4] = e;
        }
    }, c.prototype.getMsecString = function() {
        for (var t = "" + this.fraction, i = 6 - t.length; 0 < i; i--) t = "0" + t;
        return t.length > this.secScale && (t = t.substring(0, this.secScale)), t;
    }, c.prototype.parseIntervalDTString = function(t) {
        if (!t) throw error_1.DBError.ECJS_INVALID_TIME_INTERVAL();
        var i = t.trim().toUpperCase();
        if (!i.startsWith("INTERVAL ")) throw error_1.DBError.ECJS_INVALID_TIME_INTERVAL();
        try {
            i = i.substring(i.indexOf(" ")).trim();
            var h = 0, s = null;
            if ("'" === i.charAt(0) && -1 !== (h = i.indexOf("'", 1)) && (s = i.substring(1, h).trim(), 
            s = this.checkSign(s), i = i.substring(h + 1).trim()), null === s) {
                if ("'" !== (i = this.checkSign(i)).charAt(0) || -1 === (h = i.indexOf("'", 1))) throw error_1.DBError.ECJS_INVALID_TIME_INTERVAL();
                s = i.substring(1, h).trim(), i = i.substring(h + 1).trim();
            }
            var r = "", e = "", a = 0, f = 0, o = 0;
            if (-1 != (a = i.indexOf("DAY"))) {
                if (-1 == (o = i.indexOf("TO", a))) r = i.substring(a).trim(), this.setDay(s); else if (r = i.substring(a, o).trim(), 
                -1 != i.indexOf("HOUR", o)) this.setDayToHour(s); else if (-1 != i.indexOf("MINUTE", o)) this.setDayToMinute(s); else {
                    if (-1 == (f = i.indexOf("SECOND", o))) throw error_1.DBError.ECJS_INVALID_TIME_INTERVAL();
                    e = i.substring(f), this.setDayToSecond(s);
                }
                return void this.setPrecForSvr(i, r, e);
            }
            if (-1 != (a = i.indexOf("HOUR"))) {
                if (-1 == (o = i.indexOf("TO", a))) r = i.substring(a), this.setHour(s); else if (r = i.substring(a, o), 
                -1 != i.indexOf("MINUTE", o)) this.setHourToMinute(s); else {
                    if (-1 == (f = i.indexOf("SECOND", o))) throw error_1.DBError.ECJS_INVALID_TIME_INTERVAL();
                    e = i.substring(f), this.setHourToSecond(s);
                }
                return void this.setPrecForSvr(i, r, e);
            }
            if (-1 != (a = i.indexOf("MINUTE"))) {
                if (-1 == (o = i.indexOf("TO", a))) r = i.substring(a), this.setMinute(s); else {
                    if (r = i.substring(a, o), -1 == (f = i.indexOf("SECOND", o))) throw error_1.DBError.ECJS_INVALID_TIME_INTERVAL();
                    e = i.substring(f), this.setMinuteToSecond(s);
                }
                return void this.setPrecForSvr(i, r, e);
            }
            if (-1 != (a = i.indexOf("SECOND"))) {
                this.setSecond(s);
                var n = (i = i.substring(a).trim()).indexOf(",");
                return -1 != n && (r = i.substring(0, n).trim() + ")", e = "(" + i.substring(n + 1).trim()), 
                void this.setPrecForSvr(i, r, e);
            }
        } catch (t) {
            throw t instanceof error_1.DBError ? t : error_1.DBError.ECJS_INVALID_TIME_INTERVAL(t + "");
        }
        throw error_1.DBError.ECJS_INVALID_TIME_INTERVAL();
    }, c.prototype.checkSign = function(t) {
        return "-" === t.charAt(0) ? (t = t.substring(1).trim(), this.negative = !0) : "+" == t.charAt(0) && (t = t.substring(1).trim(), 
        this.negative = !1), t;
    }, c.prototype.setPrecForSvr = function(t, i, h) {
        var s = this.checkScale(this.parsePrec(i));
        this.leadScale = s < c.LOADPREC_DEFAULT ? c.LOADPREC_DEFAULT : s, s = this.parsePrec(h), 
        this.secScale = 0 < s && s < c.SECDPREC_MAX ? s : c.SECDPREC_DEFAULT, this.scaleForSvr = (this.type << 8) + (this.leadScale << 4) + this.secScale;
    }, c.prototype.checkScale = function(t) {
        switch (this.type) {
          case c.QUA_D:
            if (-1 === t) t = Math.abs(this.days).toString().length; else if (t < Math.abs(this.days).toString().length) throw error_1.DBError.ECJS_INVALID_TIME_INTERVAL();
            break;

          case c.QUA_DH:
            if (-1 === t) t = Math.abs(this.days).toString().length; else if (t < Math.abs(this.days).toString().length) throw error_1.DBError.ECJS_INVALID_TIME_INTERVAL();
            if (23 < Math.abs(this.hours)) throw error_1.DBError.ECJS_INVALID_TIME_INTERVAL();
            break;

          case c.QUA_DHM:
            if (-1 === t) t = Math.abs(this.days).toString().length; else if (t < Math.abs(this.days).toString().length) throw error_1.DBError.ECJS_INVALID_TIME_INTERVAL();
            if (23 < Math.abs(this.hours) || 59 < Math.abs(this.minutes)) throw error_1.DBError.ECJS_INVALID_TIME_INTERVAL();
            break;

          case c.QUA_DHMS:
            if (-1 === t) t = Math.abs(this.days).toString().length; else if (t < Math.abs(this.days).toString().length) throw error_1.DBError.ECJS_INVALID_TIME_INTERVAL();
            if (23 < Math.abs(this.hours) || 59 < Math.abs(this.minutes) || 59 < Math.abs(this.seconds)) throw error_1.DBError.ECJS_INVALID_TIME_INTERVAL();
            break;

          case c.QUA_H:
            if (-1 === t) t = Math.abs(this.hours).toString().length; else if (t < Math.abs(this.hours).toString().length) throw error_1.DBError.ECJS_INVALID_TIME_INTERVAL();
            break;

          case c.QUA_HM:
            if (-1 === t) t = Math.abs(this.hours).toString().length; else if (t < Math.abs(this.hours).toString().length) throw error_1.DBError.ECJS_INVALID_TIME_INTERVAL();
            if (59 < Math.abs(this.minutes)) throw error_1.DBError.ECJS_INVALID_TIME_INTERVAL();
            break;

          case c.QUA_HMS:
            if (-1 === t) t = Math.abs(this.hours).toString().length; else if (t < Math.abs(this.hours).toString().length) throw error_1.DBError.ECJS_INVALID_TIME_INTERVAL();
            if (59 < Math.abs(this.minutes) || 59 < Math.abs(this.seconds)) throw error_1.DBError.ECJS_INVALID_TIME_INTERVAL();
            break;

          case c.QUA_M:
            if (-1 === t) t = Math.abs(this.minutes).toString().length; else if (t < Math.abs(this.minutes).toString().length) throw error_1.DBError.ECJS_INVALID_TIME_INTERVAL();
            break;

          case c.QUA_MS:
            if (-1 === t) t = Math.abs(this.minutes).toString().length; else if (t < Math.abs(this.minutes).toString().length) throw error_1.DBError.ECJS_INVALID_TIME_INTERVAL();
            if (59 < Math.abs(this.seconds)) throw error_1.DBError.ECJS_INVALID_TIME_INTERVAL();
            break;

          case c.QUA_S:
            if (-1 === t) t = Math.abs(this.seconds).toString().length; else if (t < Math.abs(this.seconds).toString().length) throw error_1.DBError.ECJS_INVALID_TIME_INTERVAL();
        }
        if (c.LOADPREC_MAX < t) throw error_1.DBError.ECJS_INVALID_TIME_INTERVAL();
        return t;
    }, c.prototype.parsePrec = function(t) {
        var i, h = t.indexOf("("), s = t.indexOf(")"), r = -1;
        return -1 !== s && -1 !== h && h + 1 < s && (i = t.substring(h + 1, s).trim(), r = parseInt(i)), 
        r;
    }, c.prototype.incrementDay = function(t, i) {
        i[0]++;
    }, c.prototype.incrementHour = function(t, i) {
        i[1]++, 24 == i[1] && t < c.QUA_H && (this.incrementDay(t, i), i[1] = 0);
    }, c.prototype.incrementMinute = function(t, i) {
        i[2]++, 60 == i[2] && t < c.QUA_M && (this.incrementHour(t, i), i[2] = 0);
    }, c.prototype.incrementSecond = function(t, i) {
        i[3]++, 60 == i[3] && t < c.QUA_S && (this.incrementMinute(t, i), i[3] = 0);
    }, c.prototype.setDay = function(t) {
        if (1 < t.split(/[ :.]+/).length) throw error_1.DBError.ECJS_INVALID_TIME_INTERVAL();
        this.type = c.QUA_D;
        var i = parseInt(t);
        this.days = i < 0 ? -i : i, i < 0 && (this.negative = !0);
    }, c.prototype.setHour = function(t) {
        if (1 < t.split(/[ :.]+/).length) throw error_1.DBError.ECJS_INVALID_TIME_INTERVAL();
        this.type = c.QUA_H;
        var i = parseInt(t);
        this.hours = i < 0 ? -i : i, i < 0 && (this.negative = !0);
    }, c.prototype.setMinute = function(t) {
        if (1 < t.split(/[ :.]+/).length) throw error_1.DBError.ECJS_INVALID_TIME_INTERVAL();
        this.type = c.QUA_M;
        var i = parseInt(t);
        this.minutes = i < 0 ? -i : i, i < 0 && (this.negative = !0);
    }, c.prototype.setSecond = function(t) {
        var i = t.split(/[ :.]+/);
        if (2 < i.length) throw error_1.DBError.ECJS_INVALID_TIME_INTERVAL();
        this.type = c.QUA_S;
        var h, s, r, e = parseInt(i[0]), a = 0;
        1 < i.length && (h = "0." + i[1], s = parseFloat(h), r = Math.pow(10, this.secScale), 
        a = parseInt((s * r).toFixed(0))), this.seconds = e < 0 ? -e : e, this.fraction = a < 0 ? -a : a, 
        (e < 0 || a < 0) && (this.negative = !0);
    }, c.prototype.setHourToSecond = function(t) {
        var i = t.split(/[ :.]+/);
        if (4 < i.length) throw error_1.DBError.ECJS_INVALID_TIME_INTERVAL();
        this.type = c.QUA_HMS;
        var h, s, r, e = parseInt(i[0]), a = parseInt(i[1]), f = parseInt(i[2]), o = 0;
        3 < i.length && (h = "0." + i[3], s = parseFloat(h), r = Math.pow(10, this.secScale), 
        o = parseInt((s * r).toFixed(0))), this.hours = e < 0 ? -e : e, this.minutes = a < 0 ? -a : a, 
        this.seconds = f < 0 ? -f : f, this.fraction = o < 0 ? -o : o, (e < 0 || a < 0 || f < 0 || o < 0) && (this.negative = !0);
    }, c.prototype.setHourToMinute = function(t) {
        var i = (t = t.trim()).split(/[ :.]+/);
        if (2 < i.length) throw error_1.DBError.ECJS_INVALID_TIME_INTERVAL();
        this.type = c.QUA_HM;
        var h = parseInt(i[0]), s = parseInt(i[1]);
        if (2 < i.length) throw error_1.DBError.ECJS_INVALID_TIME_INTERVAL();
        this.hours = h < 0 ? -h : h, this.minutes = s < 0 ? -s : s, (h < 0 || s < 0) && (this.negative = !0);
    }, c.prototype.setMinuteToSecond = function(t) {
        var i = t.split(/[ :.]+/);
        if (3 < i.length) throw error_1.DBError.ECJS_INVALID_TIME_INTERVAL();
        this.type = c.QUA_MS;
        var h, s, r, e = parseInt(i[0]), a = parseInt(i[1]), f = 0;
        2 < i.length && (h = "0." + i[2], s = parseFloat(h), r = Math.pow(10, this.secScale), 
        f = parseInt((s * r).toFixed(0))), this.minutes = e < 0 ? -e : e, this.seconds = a < 0 ? -a : a, 
        this.fraction = f < 0 ? -f : f, (e < 0 || a < 0 || f < 0) && (this.negative = !0);
    }, c.prototype.setDayToHour = function(t) {
        var i = t.split(/[ :.]+/);
        if (2 < i.length) throw error_1.DBError.ECJS_INVALID_TIME_INTERVAL();
        this.type = c.QUA_DH;
        var h = parseInt(i[0]), s = parseInt(i[1]);
        this.days = h < 0 ? -h : h, this.hours = s < 0 ? -s : s, (h < 0 || s < 0) && (this.negative = !0);
    }, c.prototype.setDayToMinute = function(t) {
        var i = t.split(/[ :.]+/);
        if (3 < i.length) throw error_1.DBError.ECJS_INVALID_TIME_INTERVAL();
        this.type = c.QUA_DHM;
        var h = parseInt(i[0]), s = parseInt(i[1]), r = parseInt(i[2]);
        this.days = h < 0 ? -h : h, this.hours = s < 0 ? -s : s, this.minutes = r < 0 ? -r : r, 
        (h < 0 || s < 0 || r < 0) && (this.negative = !0);
    }, c.prototype.setDayToSecond = function(t) {
        var i = t.split(/[ :.]+/);
        if (5 < i.length) throw error_1.DBError.ECJS_INVALID_TIME_INTERVAL();
        this.type = c.QUA_DHMS;
        var h, s, r, e = parseInt(i[0]), a = parseInt(i[1]), f = parseInt(i[2]), o = parseInt(i[3]), n = 0;
        4 < i.length && (h = "0." + i[4], s = parseFloat(h), r = Math.pow(10, this.secScale), 
        n = Math.trunc(s * r)), this.days = e < 0 ? -e : e, this.hours = a < 0 ? -a : a, 
        this.minutes = f < 0 ? -f : f, this.seconds = o < 0 ? -o : o, this.fraction = n < 0 ? -n : n, 
        (e < 0 || a < 0 || f < 0 || o < 0 || n < 0) && (this.negative = !0);
    }, c.LOADPREC_DEFAULT = 2, c.LOADPREC_MAX = 9, c.SECDPREC_DEFAULT = 6, c.SECDPREC_MAX = 6, 
    c.QUA_D = 3, c.QUA_DH = 4, c.QUA_DHM = 5, c.QUA_DHMS = 6, c.QUA_H = 7, c.QUA_HM = 8, 
    c.QUA_HMS = 9, c.QUA_M = 10, c.QUA_MS = 11, c.QUA_S = 12, c;
}();

exports.IntervalDT = IntervalDT;