"use strict";

Object.defineProperty(exports, "__esModule", {
    value: !0
});

var bufferUtil_1 = require("../utils/bufferUtil"), error_1 = require("./error"), IntervalYM = function() {
    function o(t, r, i, h) {
        if (this.scaleForSvr = 0, this.leadScale = 0, this.isLeadScaleSet = !1, this.type = o.QUA_Y, 
        this.years = 0, this.months = 0, Buffer.isBuffer(t)) switch (this.scaleForSvr = bufferUtil_1.BufferUtil.t(t, 8), 
        this.leadScale = this.scaleForSvr >> 4 & 15, this.type = t[9], this.type) {
          case o.QUA_Y:
            this.years = bufferUtil_1.BufferUtil.t(t, 0);
            break;

          case o.QUA_YM:
            this.years = bufferUtil_1.BufferUtil.t(t, 0), this.months = bufferUtil_1.BufferUtil.t(t, 4);
            break;

          case o.QUA_MO:
            this.months = bufferUtil_1.BufferUtil.t(t, 4);
        } else "string" == typeof t ? (this.isLeadScaleSet = !1, this.parseIntervalYMString(t)) : (this.type = t, 
        this.years = r, this.months = i, this.scaleForSvr = h, this.leadScale = h >> 4 & 15);
    }
    return o.prototype.encode = function(t) {
        0 == t && (t = this.scaleForSvr);
        var r, i = this.years, h = this.months;
        this.checkScale(this.leadScale), t != this.scaleForSvr ? (i = (r = this.convertTo(t)).years, 
        h = r.months) : this.checkScale(this.leadScale);
        var s = Buffer.alloc(12);
        return bufferUtil_1.BufferUtil.v(s, 0, i), bufferUtil_1.BufferUtil.v(s, 4, h), bufferUtil_1.BufferUtil.v(s, 8, t), 
        s;
    }, o.prototype.toString = function() {
        var t, r, i, h, s = "INTERVAL ";
        switch (this.type) {
          case o.QUA_Y:
            if (t = Math.abs(this.years).toString(), this.years < 0 && (s += "-"), this.leadScale > t.length) for (i = t.length, 
            h = this.leadScale; h-- > i; ) t = "0" + t;
            s += "'" + t + "' YEAR(" + this.leadScale + ")";
            break;

          case o.QUA_YM:
            if (t = Math.abs(this.years).toString(), r = Math.abs(this.months).toString(), (this.years < 0 || this.months < 0) && (s += "-"), 
            this.leadScale > t.length) for (i = t.length, h = this.leadScale; h-- > i; ) t = "0" + t;
            r.length < 2 && (r = "0" + r), s += "'" + t + "-" + r + "' YEAR(" + this.leadScale + ") TO MONTH";
            break;

          case o.QUA_MO:
            if (r = Math.abs(this.months).toString(), this.months < 0 && (s += "-"), this.leadScale > r.length) for (i = r.length, 
            h = this.leadScale; h-- > i; ) r = "0" + r;
            s += "'" + r + "' MONTH(" + this.leadScale + ")";
        }
        return s;
    }, o.prototype.convertTo = function(t) {
        var r = (65280 & t) >> 8, i = t >> 4 & 15, h = 12 * this.years + this.months, s = 0, e = 0;
        switch (r) {
          case o.QUA_Y:
            if (s = Math.trunc(h / 12), 6 <= h % 12 ? s++ : h % 12 <= -6 && s--, i < Math.abs(s).toString().length) throw error_1.DBError.ECJS_INTERVAL_OVERFLOW();
            break;

          case o.QUA_YM:
            if (s = Math.trunc(h / 12), e = h % 12, i < Math.abs(s).toString().length) throw error_1.DBError.ECJS_INTERVAL_OVERFLOW();
            break;

          case o.QUA_MO:
            if (e = h, i < Math.abs(e).toString().length) throw error_1.DBError.ECJS_INTERVAL_OVERFLOW();
        }
        return new o(r, s, e, t);
    }, o.prototype.parseIntervalYMString = function(t) {
        if (!t) throw error_1.DBError.ECJS_INVALID_TIME_INTERVAL();
        var r = (t = t.toUpperCase()).split(" ");
        if (r.length < 3 || "INTERVAL" !== r[0] || !r[2].startsWith("YEAR") && !r[2].startsWith("MONTH")) throw error_1.DBError.ECJS_INVALID_TIME_INTERVAL();
        this.type = o.QUA_YM;
        var i = t.indexOf("YEAR"), h = t.indexOf("MONTH");
        if (-1 == t.indexOf("TO")) if (-1 !== i && -1 === h) this.type = o.QUA_Y, this.leadScale = this.getLeadPrec(t, i); else {
            if (-1 === h || -1 !== i) throw error_1.DBError.ECJS_INVALID_TIME_INTERVAL();
            this.type = o.QUA_MO, this.leadScale = this.getLeadPrec(t, h);
        } else {
            if (-1 === i || -1 === h) throw error_1.DBError.ECJS_INVALID_TIME_INTERVAL();
            this.type = o.QUA_YM, this.leadScale = this.getLeadPrec(t, i);
        }
        this.scaleForSvr = (this.type << 8) + (this.leadScale << 4);
        var s = this.getTimeValue(r[1], this.type);
        this.years = s[0], this.months = s[1], this.checkScale(this.leadScale);
    }, o.prototype.getLeadPrec = function(t, r) {
        if (this.isLeadScaleSet) return this.leadScale;
        var i = t.indexOf("(", r), h = t.indexOf(")", r), s = 0;
        if (-1 === h && -1 === i) {
            var e, f, a = t.indexOf("'"), o = -1 !== a ? t.indexOf("'", a + 1) : -1, n = -1 !== o ? t.substring(a + 1, o).trim() : "";
            s = n ? ("+" !== (e = n.charAt(0)) && "-" !== e || (n = n.substring(1).trim()), 
            (n = -1 !== (f = n.indexOf("-")) ? n.substring(0, f) : n).length) : 2;
        } else {
            if (!(-1 !== h && -1 !== i && i + 1 < h)) throw error_1.DBError.ECJS_INVALID_TIME_INTERVAL();
            var u = t.substring(i + 1, h).trim();
            s = parseInt(u);
        }
        return s;
    }, o.prototype.getTimeValue = function(t, r) {
        var i = !1;
        "'" === t.charAt(0) && "'" === t.charAt(t.length - 1) && (i = !0, t = t.substring(1, t.length - 1).trim());
        var h = !1;
        if (t.startsWith("-") ? (h = !0, t = t.substring(1)) : t.startsWith("+") && (h = !1, 
        t = t.substring(1)), "'" === t.charAt(0) && "'" === t.charAt(t.length - 1) && (i = !0, 
        t = t.substring(1, t.length - 1).trim()), !i) throw error_1.DBError.ECJS_INVALID_TIME_INTERVAL();
        var s, e, f = t.lastIndexOf("-"), a = new Array(2);
        if (-1 === f || 0 === f ? (a[0] = t, a[1] = "") : (a[0] = t.substring(0, f), a[1] = t.substring(f + 1)), 
        r == o.QUA_YM) {
            if (s = parseInt(a[0]), e = "" === a[1] ? 0 : parseInt(a[1]), h && (s *= -1, e *= -1), 
            s > Math.pow(10, this.leadScale) - 1 || s < 1 - Math.pow(10, this.leadScale)) throw error_1.DBError.ECJS_INVALID_TIME_INTERVAL();
        } else if (r == o.QUA_Y) {
            if (s = parseInt(a[0]), e = 0, h && (s *= -1), s > Math.pow(10, this.leadScale) - 1 || s < 1 - Math.pow(10, this.leadScale)) throw error_1.DBError.ECJS_INVALID_TIME_INTERVAL();
        } else if (s = 0, e = parseInt(a[0]), h && (e *= -1), e > Math.pow(10, this.leadScale) - 1 || e < 1 - Math.pow(10, this.leadScale)) throw error_1.DBError.ECJS_INVALID_TIME_INTERVAL();
        return [ s, e ];
    }, o.prototype.checkScale = function(t) {
        switch (this.type) {
          case o.QUA_Y:
            if (t < Math.abs(this.years).toString().length) throw error_1.DBError.ECJS_INTERVAL_OVERFLOW();
            break;

          case o.QUA_YM:
            if (t < Math.abs(this.years).toString().length) throw error_1.DBError.ECJS_INTERVAL_OVERFLOW();
            if (11 < Math.abs(this.months)) throw error_1.DBError.ECJS_INVALID_TIME_INTERVAL();
            break;

          case o.QUA_MO:
            if (t < Math.abs(this.months).toString().length) throw error_1.DBError.ECJS_INTERVAL_OVERFLOW();
        }
    }, o.QUA_Y = 0, o.QUA_YM = 1, o.QUA_MO = 2, o;
}();

exports.IntervalYM = IntervalYM;