"use strict";

Object.defineProperty(exports, "__esModule", {
    value: !0
});

var error_1 = require("./error"), bufferUtil_1 = require("../utils/bufferUtil"), dbtype_1 = require("./dbtype"), Numeric = function() {
    function o(t, r, i) {
        if (this.sign = 0, this.weight = 0, this.prec = 0, this.scale = 0, this.digits = "", 
        void 0 !== t && null != r && null != i) {
            if (dbtype_1.DBType.isFloat(dbtype_1.DBType.DECIMAL, i) ? (this.prec = dbtype_1.DBType.getFloatPrec(r), 
            this.scale = -1) : (this.prec = r, this.scale = i), null == t || 0 == t.length || t.length > o.XDEC_SIZE) throw error_1.DBError.ECJS_FATAL_ERROR();
            if (t[0] == o.FLAG_ZERO || 1 == t.length) return;
            this.sign = 0 != (t[0] & o.FLAG_ZERO) ? 1 : -1;
            for (var e, s = bufferUtil_1.BufferUtil.M(t, 0), h = 0 < this.sign ? s - o.FLAG_POSITIVE : o.FLAG_NEGTIVE - s, u = "", n = 1; n < t.length && !((e = 0 < this.sign ? t[n] - o.NUM_POSITIVE : o.NUM_NEGTIVE - t[n]) < 0 || 99 < e); n++) e < 10 && (u += "0"), 
            u += e;
            this.digits = u, this.weight = 2 * h - (this.digits.length - 2);
        }
    }
    return o.fromNumber = function(t, r, i) {
        var e = new o();
        if (dbtype_1.DBType.isFloat(dbtype_1.DBType.DECIMAL, i) ? (e.prec = dbtype_1.DBType.getFloatPrec(r), 
        e.scale = -1) : (e.prec = r, e.scale = i), e.sign = Math.sign(t), 0 === t) return e;
        var s = Math.abs(t).toLocaleString("en-IN", {
            useGrouping: !1,
            maximumFractionDigits: 20
        });
        return "0" !== s && "-0" !== s || "0.00000000000000000000000000000000000000" !== (s = Math.abs(t).toFixed(38)) ? this.fromString((-1 === e.sign ? "-" : "") + s, r, i) : (e.sign = 0, 
        e);
    }, o.fromString = function(t, r, i) {
        if (Number.isNaN(Number(t))) throw error_1.DBError.ECJS_DATA_CONVERTION_ERROR();
        var e = t, s = new o();
        dbtype_1.DBType.isFloat(dbtype_1.DBType.DECIMAL, i) ? (s.prec = dbtype_1.DBType.getFloatPrec(r), 
        s.scale = -1) : (s.prec = r, s.scale = i), s.sign = Math.sign(Number(e)), -1 === s.sign && (e = e.substr(1));
        var h = e.indexOf("."), u = 0, n = 0, f = e.length;
        if (-1 !== h) if ("0" === e[0]) {
            for (u = n = 2; u < f && "0" === e[u]; u++) ;
            e = e.substring(u), s.weight -= u - n + e.length;
        } else e = e.substring(0, h) + e.substring(h + 1), s.weight -= f - h - 1;
        for (u = n = (f = e.length) - 1; 0 < u && "0" === e[u]; u--) ;
        return e = e.substring(0, u + 1) + e.substring(f), s.weight += n - u, s.weight % 2 != 0 && (e += "0", 
        s.weight--), e.length % 2 != 0 && (e = "0" + e), s.digits = e, s;
    }, o.prototype.encode = function() {
        if (this.isZero()) return Buffer.from([ o.FLAG_ZERO ]);
        var t = (this.weight + this.digits.length) / 2 - 1;
        if (o.EXP_MAX < t || t < o.EXP_MIN) throw error_1.DBError.EC_DATA_OVERFLOW();
        var r = this.digits.length / 2 + 1, r = this.sign < 0 && o.XDEC_SIZE <= r ? o.XDEC_SIZE - 1 : o.XDEC_SIZE < r ? o.XDEC_SIZE : r, i = this.sign < 0 ? r + 1 : r, e = Buffer.alloc(i);
        e[0] = 0 < this.sign ? t + o.FLAG_POSITIVE : o.FLAG_NEGTIVE - t;
        for (var s, h = 1, u = 0; h < r; ) s = 10 * parseInt(this.digits.charAt(u++), 10) + parseInt(this.digits.charAt(u++), 10), 
        e[h++] = 0 < this.sign ? s + o.NUM_POSITIVE : o.NUM_NEGTIVE - s;
        return this.sign < 0 && h < i && (e[h++] = 102), h < i && (e[h] = 0), e;
    }, o.prototype.toNumber = function() {
        if (this.isZero()) return Number(0);
        var t = (this.sign < 0 ? "-" : "") + this.digits, r = Number(t);
        return 0 < this.weight ? r *= Number("1" + "0".repeat(this.weight)) : this.weight < 0 && (r /= Number("1" + "0".repeat(-this.weight))), 
        r;
    }, o.prototype.toString = function() {
        if (this.isZero()) return "0";
        var t = this.digits;
        return 0 < this.weight ? t += "0".repeat(this.weight) : this.weight < 0 && (t = (t = t.padStart(1 - this.weight, "0")).substring(0, t.length + this.weight) + "." + t.substring(t.length + this.weight)), 
        "0" === t[0] && "." !== t[1] && (t = t.substr(1)), "0" === t[t.length - 1] && 0 <= t.indexOf(".") && (t = t.substr(0, t.length - 1)), 
        t = (this.sign < 0 ? "-" : "") + t;
    }, o.prototype.isZero = function() {
        return 0 === this.sign;
    }, o.XDEC_SIZE = 21, o.FLAG_ZERO = 128, o.FLAG_POSITIVE = 193, o.FLAG_NEGTIVE = 62, 
    o.EXP_MAX = 254 - o.FLAG_POSITIVE, o.EXP_MIN = o.FLAG_NEGTIVE + 1 - 127, o.NUM_POSITIVE = 1, 
    o.NUM_NEGTIVE = 101, o;
}();

exports.Numeric = Numeric;