"use strict";

Object.defineProperty(exports, "__esModule", {
    value: !0
});

var connection_1 = require("../../driver/connection"), logRecord_1 = require("./logRecord"), const_1 = require("../../desc/const"), dateUtil_1 = require("../../utils/dateUtil"), executeRetInfo_1 = require("../../desc/executeRetInfo"), lob_1 = require("../../driver/lob"), pool_1 = require("../../driver/pool"), resultSet_1 = require("../../driver/resultSet"), Logger = function() {
    function i(n, t) {
        this.svcConf = n, this.logWriter = t;
    }
    return i.prototype.isDebugEnabled = function() {
        return this.svcConf.logLevel >= const_1.Const.LOG_DEBUG;
    }, i.prototype.isErrorEnabled = function() {
        return this.svcConf.logLevel >= const_1.Const.LOG_ERROR;
    }, i.prototype.isInfoEnabled = function() {
        return this.svcConf.logLevel >= const_1.Const.LOG_INFO;
    }, i.prototype.isWarnEnabled = function() {
        return this.svcConf.logLevel >= const_1.Const.LOG_WARN;
    }, i.prototype.isSqlEnabled = function() {
        return this.svcConf.logLevel >= const_1.Const.LOG_SQL;
    }, i.prototype.info = function(n) {
        this.isInfoEnabled() && this.println(this.formatHead("INFO ") + n);
    }, i.prototype.sql = function(n) {
        this.isSqlEnabled() && this.println(this.formatHead("SQL  ") + n);
    }, i.prototype.debug = function(n, t, e) {
        this.isDebugEnabled() && this.println(this.formatHead("DEBUG") + i.formatTrace(n, t, void 0) + e);
    }, i.prototype.warn = function(n) {
        this.isWarnEnabled() && this.println(this.formatHead("WARN ") + n);
    }, i.prototype.error = function(n, t) {
        this.isErrorEnabled() && this.println(this.formatHead("ERROR") + n + (t ? "\n" + t.stack : ""));
    }, i.prototype.println = function(n) {
        this.logWriter.writeLine(n.trim());
    }, i.prototype.formatHead = function(n) {
        return "[" + n + " - " + dateUtil_1.DateUtil.formatDate(new Date(), !0) + "]";
    }, i.formatSource = function(n) {
        return n ? "string" == typeof n ? n : n instanceof connection_1.Connection ? this.formatConn(n) : n instanceof lob_1.Lob ? this.formatLob(n) : n instanceof pool_1.Pool ? this.formatPool(n) : n instanceof resultSet_1.ResultSet ? this.formatResultSet(n) : "unknown_source" : "";
    }, i.formatConn = function(n) {
        return n && n.middlewares.logInfo ? "conn-" + n.middlewares.getID() : "conn-null";
    }, i.formatRs = function(n) {
        return n && n.middlewares.logInfo ? "rs-" + n.middlewares.getID() : "rs-null";
    }, i.formatRss = function(n) {
        return n && n.middlewares.logInfo ? "rss-" + n.middlewares.getID() : "rss-null";
    }, i.formatLob = function(n) {
        return n && n.middlewares.logInfo ? "lob-" + n.middlewares.getID() : "lob-null";
    }, i.formatPool = function(n) {
        return n && n.middlewares.logInfo ? "pool-" + n.middlewares.getID() : "pool-null";
    }, i.formatResultSet = function(n) {
        return n && n.middlewares.logInfo ? "resultSet-" + n.middlewares.getID() : "resultSet-null";
    }, i.formatReturn = function(n) {
        var t = "";
        return n instanceof connection_1.Connection ? (t = this.formatConn(n), n.sessionID !== BigInt(-1) && (t += ", sessionID-0x" + n.sessionID.toString(16))) : t = n instanceof executeRetInfo_1.Result ? this.formatRs(n) : n instanceof executeRetInfo_1.Results ? this.formatRss(n) : n instanceof lob_1.Lob ? this.formatLob(n) : n instanceof logRecord_1.NullData ? "null" : n instanceof Buffer ? n.toString("hex") : n instanceof Array ? "[" + n + "]" : "string" == typeof n ? '"' + n + '"' : n.toString(), 
        t;
    }, i.formatTrace = function(n, t, e) {
        for (var i = [], o = 3; o < arguments.length; o++) i[o - 3] = arguments[o];
        var r = "";
        if (n && (r += "{ " + this.formatSource(n) + " } "), r += t + "(", i && 0 < i.length) for (var s = 0; s < i.length; s++) 0 !== s && (r += ", "), 
        r += typeof i[s];
        if (r += ")", void 0 !== e && (r += ": " + this.formatReturn(e)), r += ";  ", i && 0 < i.length) {
            r += "[PARAMS]: ";
            for (s = 0; s < i.length; s++) 0 !== s && (r += ", "), void 0 === i[s] ? r += "undefined" : null === i[s] ? r += "null" : r += '"' + i[s].toString() + '"';
            r += "; ";
        }
        return r;
    }, i;
}();

exports.Logger = Logger;