"use strict";

Object.defineProperty(exports, "__esModule", {
    value: !0
});

var middleware_1 = require("../middleware"), const_1 = require("../../desc/const"), RWCounter = function() {
    function r(t, i) {
        this.ntrx_primary = 0, this.ntrx_total = 0, this.primaryPercent = 0, this.standbyPercent = 0, 
        this.standbyNTrxMap = new Map(), this.standbyIdMap = new Map(), this.standbyCount = 0, 
        this.flag = new Array(), this.increments = new Array(), this.reset(t, i);
    }
    return r.prototype.reset = function(t, i) {
        this.ntrx_primary = 0, this.ntrx_total = 0, this.standbyCount = i, this.increments = new Array(i + 1);
        var s = this.gcd(t * i, 100 - t);
        this.increments[0] = t * i / s, this.increments.fill((100 - t) / s, 1, this.increments.length), 
        this.flag = this.increments.slice(), 0 < i ? (this.primaryPercent = t / 100, this.standbyPercent = (100 - t) / 100 / i) : (this.primaryPercent = 1, 
        this.standbyPercent = 0);
    }, r.getInstance = function(t, i) {
        var s = t.conn_prop_host + "_" + t.conn_prop_port + "_" + t.conn_prop_rwPercent, h = this.rwMap.get(s);
        return h ? h.standbyCount !== i && h.reset(t.conn_prop_rwPercent, i) : (h = new r(t.conn_prop_rwPercent, i), 
        this.rwMap.set(s, h)), h;
    }, r.prototype.countPrimary = function() {
        return this.adjustNtrx(), this.increasePrimaryNtrx(), middleware_1.RWSiteEnum.PRIMARY;
    }, r.prototype.count = function(t, i) {
        switch (this.adjustNtrx(), t) {
          case middleware_1.RWSiteEnum.ANY:
            t = 1 === this.primaryPercent || this.flag[0] > this.getStandbyFlag(i) && this.flag[0] > this.flag.reduce(function(t, i, s) {
                return (1 === s ? 0 : t) + i;
            }) ? (this.increasePrimaryNtrx(), middleware_1.RWSiteEnum.PRIMARY) : (this.increaseStandbyNtrx(i), 
            middleware_1.RWSiteEnum.STANDBY);
            break;

          case middleware_1.RWSiteEnum.STANDBY:
            this.increaseStandbyNtrx(i);
            break;

          case middleware_1.RWSiteEnum.PRIMARY:
            this.increasePrimaryNtrx();
            break;

          default:
            throw new Error("Invalid RWSite!");
        }
        return t;
    }, r.prototype.adjustNtrx = function() {
        var h, r = this;
        this.ntrx_total >= const_1.Const.INT64_MAX && (this.standbyNTrxMap.forEach(function(t) {
            (void 0 === h || t < h) && (h = t);
        }), h = h < this.ntrx_primary ? h : this.ntrx_primary, this.ntrx_primary /= h, this.ntrx_total /= h, 
        this.standbyNTrxMap.forEach(function(t, i, s) {
            s.set(i, t / h);
        })), this.flag[0] <= 0 && this.flag.reduce(function(t, i, s) {
            return (1 === s ? 0 : t) + i;
        }) <= 0 && this.flag.map(function(t, i, s) {
            return s[i] += r.increments[i];
        });
    }, r.prototype.increasePrimaryNtrx = function() {
        this.ntrx_primary++, this.flag[0]--, this.ntrx_total++;
    }, r.prototype.getStandbyId = function(t) {
        var i = t.conn_prop_host + ":" + t.conn_prop_port;
        if (this.standbyIdMap.has(i)) return this.standbyIdMap.get(i);
        var s = this.standbyIdMap.size + 1;
        return s > this.standbyCount ? -1 : (this.standbyIdMap.set(i, s), s);
    }, r.prototype.getStandbyFlag = function(t) {
        var i = this.getStandbyId(t);
        return 0 < i && i < this.flag.length ? this.flag[i] : 0;
    }, r.prototype.increaseStandbyNtrx = function(t) {
        var i = t.conn_prop_host + ":" + t.conn_prop_port, s = void 0 !== (s = this.standbyNTrxMap.get(i)) ? s + 1 : 1;
        this.standbyNTrxMap.set(i, s);
        var h = this.standbyIdMap.get(i);
        void 0 === h && (h = this.standbyIdMap.size + 1, this.standbyIdMap.set(i, h)), this.flag[h]--, 
        this.ntrx_total++;
    }, r.prototype.random = function(t) {
        return Math.floor(Math.random() * Math.min(t, this.standbyCount));
    }, r.prototype.toString = function() {
        return "PERCENT(P/S) : " + this.primaryPercent + "/" + this.standbyPercent + "\nNTRX_PRIMARY : " + this.ntrx_primary + "\nNTRX_TOTAL : " + this.ntrx_total + "\nNTRX_STANDBY : " + JSON.stringify(this.standbyNTrxMap);
    }, r.prototype.gcd = function(t, i) {
        if (!Number.isSafeInteger(t) || !Number.isSafeInteger(i)) throw new Error(t + " or " + i + " is not safe integer number: ");
        if (0 === t || 0 === i) return 1;
        var s = t % i;
        return t = i, 0 == (i = s) ? t : this.gcd(t, i);
    }, r.rwMap = new Map(), r;
}();

exports.RWCounter = RWCounter;