"use strict";

Object.defineProperty(exports, "__esModule", {
    value: !0
});

var fs_1 = require("fs"), dateUtil_1 = require("../utils/dateUtil"), bufferArray_1 = require("../utils/bufferArray"), Writer = function() {
    function t(t, i, s) {
        this.date = dateUtil_1.DateUtil.formatDate(new Date(), !1), this.buffer = new bufferArray_1.BufferArray(), 
        this.filePath = t, this.filePrefix = i, this.flushFreq = s;
    }
    return t.prototype.doFlush = function(t) {
        this.fd && !this.needCreateNewFile() || (this.closeCurrentFile(), this.createNewFile()), 
        this.writeStream || (this.writeStream = fs_1.createWriteStream("", {
            fd: this.fd
        })), this.writeStream && t.readWritable(this.writeStream, t.length);
    }, t.prototype.createNewFile = function() {
        this.date = dateUtil_1.DateUtil.formatDate(new Date(), !1);
        var t = this.filePrefix + "_" + this.date + "_" + Date.now() + ".log";
        fs_1.existsSync(this.filePath) || fs_1.mkdirSync(this.filePath), this.fd = fs_1.openSync(this.filePath + t, "a"), 
        this.writeStream = fs_1.createWriteStream("", {
            fd: this.fd
        });
    }, t.prototype.closeCurrentFile = function() {
        this.writeStream && (this.writeStream.emit("close"), this.writeStream = void 0);
    }, t.prototype.needCreateNewFile = function() {
        return dateUtil_1.DateUtil.formatDate(new Date(), !1) !== this.date || !this.fd || fs_1.fstatSync(this.fd).size > t.MAX_FILE_SIZE;
    }, t.MAX_FILE_SIZE = 104857600, t.FLUSH_SIZE = 32768, t;
}();

exports.Writer = Writer;