"use strict";

var __values = this && this.__values || function(r) {
    var t = "function" == typeof Symbol && Symbol.iterator, e = t && r[t], i = 0;
    if (e) return e.call(r);
    if (r && "number" == typeof r.length) return {
        next: function() {
            return r && i >= r.length && (r = void 0), {
                value: r && r[i++],
                done: !r
            };
        }
    };
    throw new TypeError(t ? "Object is not iterable." : "Symbol.iterator is not defined.");
};

Object.defineProperty(exports, "__esModule", {
    value: !0
});

var lval_1 = require("./lval"), lexer_1 = require("./lexer"), stringUtil_1 = require("../utils/stringUtil"), dbtype_1 = require("../driver/dbtype"), const_1 = require("../desc/const"), bufferUtil_1 = require("../utils/bufferUtil"), numeric_1 = require("../driver/numeric"), error_1 = require("../driver/error"), dm_1 = require("../dm"), SQLProcessor = function() {
    function p() {}
    return p.lex = function(r) {
        for (var t, e = new lexer_1.Lexer(r, !1), i = 0, a = new Array(); null != (t = e.yylex()); ) t.position = i++, 
        a.push(t);
        return a;
    }, p.escape = function(r, t) {
        var e, i;
        if (0 === t.length && !r.includes("{")) return r;
        var a = new Map();
        if (0 < t.length) try {
            for (var l = __values(t), n = l.next(); !n.done; n = l.next()) {
                var s = n.value;
                a.set(s.toLowerCase(), null);
            }
        } catch (r) {
            e = {
                error: r
            };
        } finally {
            try {
                n && !n.done && (i = l.return) && i.call(l);
            } finally {
                if (e) throw e.error;
            }
        }
        for (var _ = "", u = new Array(), o = this.lex(r), f = 0; f < o.length; f++) {
            var v, c, d, b = o[f];
            b.type == lval_1.Type.NORMAL ? "{" === b.value ? (v = this.next(o, f + 1)) && v.type == lval_1.Type.NORMAL ? stringUtil_1.StringUtil.equalsIgnoreCase(v.value, "escape") || stringUtil_1.StringUtil.equalsIgnoreCase(v.value, "call") ? u.push(!0) : stringUtil_1.StringUtil.equalsIgnoreCase(v.value, "oj") ? (u.push(!0), 
            v.value = "", v.type = lval_1.Type.WHITESPACE_OR_COMMENT) : stringUtil_1.StringUtil.equalsIgnoreCase(v.value, "d") ? (u.push(!0), 
            v.value = "date") : stringUtil_1.StringUtil.equalsIgnoreCase(v.value, "t") ? (u.push(!0), 
            v.value = "time") : stringUtil_1.StringUtil.equalsIgnoreCase(v.value, "ts") ? (u.push(!0), 
            v.value = "datetime") : stringUtil_1.StringUtil.equalsIgnoreCase(v.value, "fn") ? (u.push(!0), 
            v.value = "", v.type = lval_1.Type.WHITESPACE_OR_COMMENT, (c = p.next(o, v.position + 1)) && c.type == lval_1.Type.NORMAL && stringUtil_1.StringUtil.equalsIgnoreCase(c.value, "database") && (c.value = "cur_database")) : "?" === v.value && (c = p.next(o, v.position + 1)) && c.type == lval_1.Type.NORMAL && stringUtil_1.StringUtil.equalsIgnoreCase(c.value, "=") && (d = p.next(o, c.position + 1)) && d.type == lval_1.Type.NORMAL && stringUtil_1.StringUtil.equalsIgnoreCase(d.value, "call") ? (u.push(!0), 
            d.value = "", d.type = lval_1.Type.WHITESPACE_OR_COMMENT) : (u.push(!1), _ += b.value) : (u.push(!1), 
            _ += b.value) : "}" === b.value ? 0 < u.length && u.pop() || (_ += b.value) : a && a.has(b.value.toLowerCase()) ? _ += '"' + stringUtil_1.StringUtil.processDoubleQuoteOfName(b.value.toUpperCase()) + '"' : _ += b.value : b.type == lval_1.Type.STRING ? _ += "'" + stringUtil_1.StringUtil.processSingleQuoteOfName(b.value) + "'" : _ += b.value;
        }
        return _;
    }, p.execOpt = function(r, t, e) {
        var i = "", a = this.lex(r);
        if (!a || 0 === a.length) return r;
        var l = a[0].value;
        if (!(stringUtil_1.StringUtil.equalsIgnoreCase(l, "insert") || stringUtil_1.StringUtil.equalsIgnoreCase(l, "select") || stringUtil_1.StringUtil.equalsIgnoreCase(l, "update") || stringUtil_1.StringUtil.equalsIgnoreCase(l, "delete"))) return r;
        for (var n = 0; n < a.length; n++) {
            var s = a[n], _ = void 0;
            switch (s.type) {
              case lval_1.Type.NULL:
                i += "?", t.push(new OptParameter(null, dbtype_1.DBType.NULL, dbtype_1.DBType.NULL_PREC));
                break;

              case lval_1.Type.INT:
                i += "?";
                try {
                    _ = BigInt(s.value);
                } catch (r) {
                    throw error_1.DBError.ECJS_DATA_CONVERTION_ERROR(r + "");
                }
                _ <= const_1.Const.INT32_MAX && _ >= const_1.Const.INT32_MIN ? t.push(new OptParameter(bufferUtil_1.BufferUtil.s(Number(_)), dbtype_1.DBType.INT, dbtype_1.DBType.INT_PREC)) : t.push(new OptParameter(bufferUtil_1.BufferUtil.o(_), dbtype_1.DBType.BIGINT, dbtype_1.DBType.BIGINT_PREC));
                break;

              case lval_1.Type.DOUBLE:
                if (i += "?", _ = parseFloat(s.value), Number.isNaN(_)) throw error_1.DBError.ECJS_DATA_CONVERTION_ERROR();
                t.push(new OptParameter(bufferUtil_1.BufferUtil.d(_), dbtype_1.DBType.DOUBLE, dbtype_1.DBType.DOUBLE_PREC));
                break;

              case lval_1.Type.DECIMAL:
                i += "?", t.push(new OptParameter(numeric_1.Numeric.fromString(s.value, 0, 0).encode(), dbtype_1.DBType.DECIMAL, 0));
                break;

              case lval_1.Type.STRING:
                if (s.value.length > const_1.Const.INT16_MAX) {
                    i += "'" + stringUtil_1.StringUtil.processSingleQuoteOfName(s.value) + "'";
                    break;
                }
                i += "?", t.push(new OptParameter(bufferUtil_1.BufferUtil.b(s.value, e), dbtype_1.DBType.VARCHAR, dbtype_1.DBType.VARCHAR_PREC));
                break;

              case lval_1.Type.HEX_INT:
              default:
                i += s.value;
            }
            0;
        }
        return i;
    }, p.arrayConstant = function(r, t) {
        var e = "", i = this.lex(r);
        if (!i || 0 === i.length) return [ r, t ];
        var a = i[0].value;
        if (!(stringUtil_1.StringUtil.equalsIgnoreCase(a, "insert") || stringUtil_1.StringUtil.equalsIgnoreCase(a, "select") || stringUtil_1.StringUtil.equalsIgnoreCase(a, "update") || stringUtil_1.StringUtil.equalsIgnoreCase(a, "delete"))) return [ r, t ];
        var l, n = new Map();
        if (Array.isArray(t)) {
            l = new Array();
            for (var s = 0; s < t.length; s++) {
                var _ = dm_1.dmdb.isBindParameter(t[s]) ? t[s].val : t[s];
                Array.isArray(_) ? n.set(s, stringUtil_1.StringUtil.array2String(_)) : l.push(t[s]);
            }
        } else for (var u in l = {}, t) {
            _ = dm_1.dmdb.isBindParameter(t[u]) ? t[u].val : t[u];
            Array.isArray(_) ? n.set(u, stringUtil_1.StringUtil.array2String(_)) : l[u] = t[u];
        }
        if (0 === n.size) return [ r, t ];
        for (var o = -1, s = 0; s < i.length; s++) {
            var f, v = i[s];
            switch (v.type) {
              case lval_1.Type.NORMAL:
                "?" === v.value ? (o++, n.has(o) ? e += n.get(o) : e += v.value) : ":" === v.value && (f = this.next(i, s + 1)) ? (o++, 
                u = Array.isArray(t) ? o : f.value, n.has(u) ? (e += n.get(u), s = f.position) : e += v.value) : e += v.value;
                break;

              default:
                e += v.value;
            }
        }
        return [ e, l ];
    }, p.next = function(r, t) {
        for (var e = null, i = t; i < r.length && (e = r[i]).type === lval_1.Type.WHITESPACE_OR_COMMENT; i++) ;
        return e;
    }, p;
}();

exports.SQLProcessor = SQLProcessor;

var OptParameter = function() {
    function r(r, t, e) {
        this.ioType = 0, this.scale = 0, this.bytes = r, this.type = t, this.prec = e;
    }
    return r.prototype.toString = function() {
        return this.bytes ? this.bytes.toString() : "null";
    }, r;
}();

exports.OptParameter = OptParameter;