"use strict";

var __extends = this && this.__extends || function() {
    var e = function(t, r) {
        return (e = Object.setPrototypeOf || {
            __proto__: []
        } instanceof Array && function(t, r) {
            t.__proto__ = r;
        } || function(t, r) {
            for (var i in r) r.hasOwnProperty(i) && (t[i] = r[i]);
        })(t, r);
    };
    return function(t, r) {
        function i() {
            this.constructor = t;
        }
        e(t, r), t.prototype = null === r ? Object.create(r) : (i.prototype = r.prototype, 
        new i());
    };
}();

Object.defineProperty(exports, "__esModule", {
    value: !0
});

var abstractCipher_1 = require("./abstractCipher"), msgSecurity_1 = require("./msgSecurity"), crypto_1 = require("crypto"), error_1 = require("../driver/error"), SymmCipher = function(s) {
    function t(t, r) {
        var i = s.call(this) || this;
        i.hashType = msgSecurity_1.MsgSecurity.MD5, i.hashSize = msgSecurity_1.MsgSecurity.MD5_DIGEST_SIZE, 
        i.cipherDesc = new SymmCipherDesc(t);
        var e = i.cipherDesc.keyLength;
        return i.cipherDesc.algorithmType === msgSecurity_1.MsgSecurity.DES3 ? (i.sessionKey = Buffer.alloc(e + 8), 
        r.copy(i.sessionKey, 0, 0, e), r.copy(i.sessionKey, e, 0, 8)) : (i.sessionKey = Buffer.alloc(e), 
        r.copy(i.sessionKey, 0, 0, e)), i.iv = msgSecurity_1.MsgSecurity.getIV(i.cipherDesc.ivLength), 
        i;
    }
    return __extends(t, s), t.prototype.encrypt = function(t, r) {
        try {
            var i = crypto_1.createCipheriv(this.cipherDesc.algorithmName, this.sessionKey, this.iv);
            i.setAutoPadding(this.cipherDesc.needPadding);
            var e, s = Buffer.concat([ i.update(t), i.final() ]);
            return r && (e = this.genMessageDigest(this.hashType, t), s = Buffer.concat([ s, e ], s.length + e.length)), 
            s;
        } catch (t) {
            throw error_1.DBError.ECJS_MESSAGE_ENCRYPT_FAIL(t + "");
        }
    }, t.prototype.decrypt = function(t, r) {
        try {
            var i = crypto_1.createDecipheriv(this.cipherDesc.algorithmName, this.sessionKey, this.iv);
            i.setAutoPadding(this.cipherDesc.needPadding);
            var e = void 0;
            if (r) {
                var s = t.slice(t.length - this.hashSize), e = t.slice(0, t.length - this.hashSize);
                if (e = Buffer.concat([ i.update(e), i.final() ]), !s.equals(this.genMessageDigest(this.hashType, e))) throw new Error("digest check failed");
            } else e = Buffer.concat([ i.update(t), i.final() ]);
            return e;
        } catch (t) {
            throw error_1.DBError.ECJS_MESSAGE_DECRYPT_FAIL(t + "");
        }
    }, t.prototype.genMessageDigest = function(t, r) {
        switch (t) {
          case msgSecurity_1.MsgSecurity.MD5:
            try {
                var i = crypto_1.createHash("MD5");
                return i.update(r), i.digest();
            } catch (t) {
                throw new Error("invalid digest type." + t.message);
            }

          default:
            throw new Error("invalid digest type");
        }
    }, t;
}(abstractCipher_1.AbstractCipher);

exports.SymmCipher = SymmCipher;

var SymmCipherDesc = function() {
    function t(t) {
        switch (this.algorithmType = -1, this.workMode = -1, this.algorithmName = "", this.keyLength = -1, 
        this.ivLength = -1, this.needPadding = !1, this.algorithmType = t & msgSecurity_1.MsgSecurity.ALGO_MASK, 
        this.workMode = t & msgSecurity_1.MsgSecurity.WORK_MODE_MASK, this.algorithmType) {
          case msgSecurity_1.MsgSecurity.AES128:
            this.algorithmName += "AES-128", this.keyLength = 16, this.ivLength = 16;
            break;

          case msgSecurity_1.MsgSecurity.AES192:
            this.algorithmName += "AES-192", this.keyLength = 24, this.ivLength = 16;
            break;

          case msgSecurity_1.MsgSecurity.AES256:
            this.algorithmName += "AES-256", this.keyLength = 32, this.ivLength = 16;
            break;

          case msgSecurity_1.MsgSecurity.DES:
            this.algorithmName += "DES", this.keyLength = 8, this.ivLength = 8;
            break;

          case msgSecurity_1.MsgSecurity.DES3:
            this.algorithmName += "DES-EDE3", this.keyLength = 16, this.ivLength = 8;
            break;

          case msgSecurity_1.MsgSecurity.RC4:
            return this.algorithmName += "RC4", void (this.keyLength = 16);

          default:
            throw error_1.DBError.ECJS_INVALID_CIPHER();
        }
        switch (this.workMode) {
          case msgSecurity_1.MsgSecurity.ECB_MODE:
            this.algorithmName += "-ECB", this.needPadding = !0, this.ivLength = -1;
            break;

          case msgSecurity_1.MsgSecurity.CBC_MODE:
            this.algorithmName += "-CBC", this.needPadding = !0;
            break;

          case msgSecurity_1.MsgSecurity.CFB_MODE:
            this.algorithmName += "-CFB", this.needPadding = !1;
            break;

          case msgSecurity_1.MsgSecurity.OFB_MODE:
            this.algorithmName += "-OFB", this.needPadding = !1;
            break;

          default:
            throw error_1.DBError.ECJS_INVALID_CIPHER();
        }
    }
    return t.DEFAULT_PADDING_TYPE = "PKCS5Padding", t.NO_PADDING_TYPE = "NoPadding", 
    t;
}();