"use strict";

Object.defineProperty(exports, "__esModule", {
    value: !0
});

var timestamp_1 = require("../driver/timestamp"), bufferUtil_1 = require("./bufferUtil"), dbtype_1 = require("../driver/dbtype"), error_1 = require("../driver/error"), oracleDateFormat_1 = require("./oracleDateFormat"), const_1 = require("../desc/const"), DateUtil = function() {
    function c() {}
    return c.encode = function(t, e, m, i) {
        if (t[timestamp_1.Timestamp.OFFSET_TIMEZONE] != timestamp_1.Timestamp.INVALID_VALUE && c.transformTZ(t, t[timestamp_1.Timestamp.OFFSET_TIMEZONE], m), 
        e.mask === const_1.Const.MASK_LOCAL_DATETIME && c.transformTZ(t, t[timestamp_1.Timestamp.OFFSET_TIMEZONE], i), 
        t[timestamp_1.Timestamp.OFFSET_YEAR] < timestamp_1.Timestamp.MIN_YEAR || t[timestamp_1.Timestamp.OFFSET_YEAR] > timestamp_1.Timestamp.MAX_YEAR) throw error_1.DBError.EC_DATETIME_OVERFLOW();
        var a = t[timestamp_1.Timestamp.OFFSET_YEAR], r = t[timestamp_1.Timestamp.OFFSET_MONTH], s = t[timestamp_1.Timestamp.OFFSET_DAY], _ = t[timestamp_1.Timestamp.OFFSET_HOUR], p = t[timestamp_1.Timestamp.OFFSET_MINUTE], n = t[timestamp_1.Timestamp.OFFSET_SECOND], f = t[timestamp_1.Timestamp.OFFSET_NANOSECOND], u = t[timestamp_1.Timestamp.OFFSET_TIMEZONE] == timestamp_1.Timestamp.INVALID_VALUE ? i : t[timestamp_1.Timestamp.OFFSET_TIMEZONE];
        if ([ a, r, s, _, p, n, f, u ].includes(NaN)) throw error_1.DBError.EC_DATETIME_OVERFLOW();
        var o = e.type, b = null;
        if (o == dbtype_1.DBType.DATE) (b = Buffer.alloc(3))[0] = 255 & a, b[1] = 0 <= a ? a >> 8 | (1 & r) << 7 : a >> 8 & ((1 & r) << 7 | 127), 
        b[2] = (14 & r) >> 1 | s << 3; else if (o == dbtype_1.DBType.DATETIME) f /= 1e3, 
        (b = Buffer.alloc(8))[0] = 255 & a, b[1] = 0 <= a ? a >> 8 | (1 & r) << 7 : a >> 8 & ((1 & r) << 7 | 127), 
        b[2] = (14 & r) >> 1 | s << 3, b[3] = _ | (7 & p) << 5, b[4] = (56 & p) >> 3 | (31 & n) << 3, 
        b[5] = (32 & n) >> 5 | (127 & f) << 1, b[6] = f >> 7 & 255, b[7] = f >> 15 & 255; else if (o == dbtype_1.DBType.DATETIME2) (b = Buffer.alloc(9))[0] = 255 & a, 
        b[1] = 0 <= a ? a >> 8 | (1 & r) << 7 : a >> 8 & ((1 & r) << 7 | 127), b[2] = (14 & r) >> 1 | s << 3, 
        b[3] = _ | (7 & p) << 5, b[4] = (56 & p) >> 3 | (31 & n) << 3, b[5] = (32 & n) >> 5 | (127 & f) << 1, 
        b[6] = f >> 7 & 255, b[7] = f >> 15 & 255, b[8] = f >> 23 & 255; else if (o == dbtype_1.DBType.DATETIME_TZ) f /= 1e3, 
        (b = Buffer.alloc(10))[0] = 255 & a, b[1] = 0 <= a ? a >> 8 | (1 & r) << 7 : a >> 8 & ((1 & r) << 7 | 127), 
        b[2] = (14 & r) >> 1 | s << 3, b[3] = _ | (7 & p) << 5, b[4] = (56 & p) >> 3 | (31 & n) << 3, 
        b[5] = (32 & n) >> 5 | (127 & f) << 1, b[6] = f >> 7 & 255, b[7] = f >> 15 & 255, 
        bufferUtil_1.BufferUtil.y(b, 8, u); else if (o == dbtype_1.DBType.DATETIME2_TZ) (b = Buffer.alloc(11))[0] = 255 & a, 
        b[1] = 0 <= a ? a >> 8 | (1 & r) << 7 : a >> 8 & ((1 & r) << 7 | 127), b[2] = (14 & r) >> 1 | s << 3, 
        b[3] = _ | (7 & p) << 5, b[4] = (56 & p) >> 3 | (31 & n) << 3, b[5] = (32 & n) >> 5 | (127 & f) << 1, 
        b[6] = f >> 7 & 255, b[7] = f >> 15 & 255, b[8] = f >> 23 & 255, bufferUtil_1.BufferUtil.y(b, 8, u); else if (o == dbtype_1.DBType.TIME) f /= 1e3, 
        (b = Buffer.alloc(5))[0] = _ | (7 & p) << 5, b[1] = (56 & p) >> 3 | (31 & n) << 3, 
        b[2] = (32 & n) >> 5 | (127 & f) << 1, b[3] = f >> 7 & 255, b[4] = f >> 15 & 255; else {
            if (o != dbtype_1.DBType.TIME_TZ) throw error_1.DBError.ECJS_INVALID_DATETIME_FORMAT();
            f /= 1e3, (b = Buffer.alloc(7))[0] = _ | (7 & p) << 5, b[1] = (56 & p) >> 3 | (31 & n) << 3, 
            b[2] = (32 & n) >> 5 | (127 & f) << 1, b[3] = f >> 7 & 255, b[4] = f >> 15 & 255, 
            bufferUtil_1.BufferUtil.y(b, 5, u);
        }
        return b;
    }, c.decode = function(t, e, m, i, a) {
        var r = e ? this.dmdtDecodeBdta(t) : this.dmdtDecodeFast(t);
        return m === const_1.Const.MASK_LOCAL_DATETIME && this.transformTZ(r, a, i), r;
    }, c.encodeByString = function(t, e, m, i) {
        var a = new Array(timestamp_1.Timestamp.DT_LEN);
        return this.toDTFromString(t, a), this.encode(a, e, m, i);
    }, c.encodeByDate = function(t, e, m, i) {
        var a = this.toDTFromDate(t);
        return this.encode(a, e, m, i);
    }, c.toDateFromNumber = function(t, e, m, i) {
        switch (e.type) {
          case dbtype_1.DBType.DATETIME:
          case dbtype_1.DBType.DATETIME2:
            var a = this.toDTFromUnix(1e3 * t - timestamp_1.Timestamp.MiSeconds_1900_1970);
            if (a[timestamp_1.Timestamp.OFFSET_YEAR] < timestamp_1.Timestamp.MIN_YEAR || a[timestamp_1.Timestamp.OFFSET_YEAR] > timestamp_1.Timestamp.MAX_YEAR) throw error_1.DBError.EC_DATETIME_OVERFLOW();
            return this.encode(a, e, m, i);

          case dbtype_1.DBType.TIME:
            return a = this.toDTFromUnix(1e3 * t), this.encode(a, e, m, i);

          case dbtype_1.DBType.DATE:
            if ((a = this.toDTFromUnix(24 * t * 60 * 60 * 1e3 - timestamp_1.Timestamp.MiSeconds_1900_1970))[timestamp_1.Timestamp.OFFSET_YEAR] < timestamp_1.Timestamp.MIN_YEAR || a[timestamp_1.Timestamp.OFFSET_YEAR] > timestamp_1.Timestamp.MAX_YEAR) throw error_1.DBError.EC_DATETIME_OVERFLOW();
            return this.encode(a, e, m, i);

          default:
            throw error_1.DBError.ECJS_DATA_CONVERTION_ERROR();
        }
    }, c.toDTFromString = function(t, e) {
        try {
            var m, i, a, r = null, s = null, _ = null, p = null, n = 0, f = 0, u = 0, o = 0, b = 0, c = 0, h = 0, l = void 0, d = void 0, y = 0, v = timestamp_1.Timestamp.INVALID_VALUE, w = 0;
            (t = t.trim()).startsWith("-", 0) && (t = t.substring(1).trim(), y = 1);
            var U = t.split(" ");
            switch (U.length) {
              case 3:
                r = U[0], s = U[1], p = U[2], w = dbtype_1.DBType.DATETIME_TZ;
                break;

              case 2:
                w = 0 < U[0].indexOf(":") ? (s = U[0], p = U[1], dbtype_1.DBType.TIME_TZ) : (r = U[0], 
                s = U[1], dbtype_1.DBType.DATETIME);
                break;

              case 1:
                w = 0 < U[0].indexOf(":") ? (s = U[0], dbtype_1.DBType.TIME) : (r = U[0], dbtype_1.DBType.DATE);
                break;

              default:
                throw error_1.DBError.ECJS_INVALID_DATETIME_FORMAT();
            }
            if (null != r) {
                if (l = r.indexOf("-"), d = r.indexOf("-", l + 1), (l < 0 || d < 0) && (l = t.indexOf("."), 
                d = t.indexOf(".", l + 1)), (l < 0 || d < 0) && (l = t.indexOf("/"), d = t.indexOf("/", l + 1)), 
                !(0 < l && 0 < d && d < r.length - 1)) throw error_1.DBError.ECJS_INVALID_DATETIME_FORMAT();
                if (n = 1 == y ? 0 - parseInt(r.substring(0, l)) - 1900 : parseInt(r.substring(0, l)) - 1900, 
                f = parseInt(r.substring(l + 1, d)) - 1, u = parseInt(r.substring(d + 1)), !this.checkDate(n + 1900, f + 1, u)) throw error_1.DBError.ECJS_INVALID_DATETIME_FORMAT();
            }
            if (null != s) {
                if (m = s.indexOf(":"), i = s.indexOf(":", m + 1), a = s.indexOf(".", i + 1), !(0 < m && 0 < i && i < s.length - 1)) throw error_1.DBError.ECJS_INVALID_DATETIME_FORMAT();
                if (o = parseInt(s.substring(0, m)), b = parseInt(s.substring(m + 1, i)), 0 < a && a < s.length - 1) {
                    if (c = parseInt(s.substring(i + 1, a)), (_ = s.substring(a + 1)).length > timestamp_1.Timestamp.NANOSECOND_DIGITS) throw error_1.DBError.ECJS_INVALID_DATETIME_FORMAT();
                    if (_.charAt(0) < "0" || "9" < _.charAt(0)) throw error_1.DBError.ECJS_INVALID_DATETIME_FORMAT();
                    _ += "000000000".substring(0, timestamp_1.Timestamp.NANOSECOND_DIGITS - _.length), 
                    h = parseInt(_);
                } else {
                    if (0 < a) throw error_1.DBError.ECJS_INVALID_DATETIME_FORMAT();
                    c = parseInt(s.substring(i + 1));
                }
                if (24 <= o || o < 0 || 60 <= b || b < 0 || 60 <= c || c < 0) throw error_1.DBError.ECJS_INVALID_DATETIME_FORMAT();
            }
            if (null != p) {
                var I = !1;
                p.startsWith("-") && (I = !0), (p.startsWith("-") || p.startsWith("+")) && (p = p.substring(1).trim());
                var D = p.split(":"), B = 0, q = 0;
                switch (D.length) {
                  case 2:
                    B = parseInt(D[0].trim()), q = parseInt(D[1].trim());
                    break;

                  case 1:
                    B = parseInt(D[0].trim());
                    break;

                  default:
                    throw error_1.DBError.ECJS_INVALID_DATETIME_FORMAT();
                }
                if ((v = 60 * B + q) < 0) throw error_1.DBError.ECJS_INVALID_DATETIME_FORMAT();
                if (I && (v *= -1), v <= -780 || 840 < v) throw error_1.DBError.ECJS_INVALID_DATETIME_FORMAT();
            }
            return e[timestamp_1.Timestamp.OFFSET_YEAR] = n + 1900, e[timestamp_1.Timestamp.OFFSET_MONTH] = f + 1, 
            e[timestamp_1.Timestamp.OFFSET_DAY] = 0 == u ? 1 : u, e[timestamp_1.Timestamp.OFFSET_HOUR] = o, 
            e[timestamp_1.Timestamp.OFFSET_MINUTE] = b, e[timestamp_1.Timestamp.OFFSET_SECOND] = c, 
            e[timestamp_1.Timestamp.OFFSET_NANOSECOND] = h, e[timestamp_1.Timestamp.OFFSET_TIMEZONE] = v, 
            w;
        } catch (t) {
            throw error_1.DBError.ECJS_INVALID_DATETIME_FORMAT();
        }
    }, c.toDateFromString = function(t, e) {
        var m = new Array(timestamp_1.Timestamp.DT_LEN);
        return this.toDTFromString(t, m), this.toDateFromDT(m, e);
    }, c.toDTFromDate = function(t) {
        var e = new Array(timestamp_1.Timestamp.DT_LEN);
        return e[timestamp_1.Timestamp.OFFSET_YEAR] = t.getFullYear(), e[timestamp_1.Timestamp.OFFSET_MONTH] = t.getMonth() + 1, 
        e[timestamp_1.Timestamp.OFFSET_DAY] = t.getDate(), e[timestamp_1.Timestamp.OFFSET_HOUR] = t.getHours(), 
        e[timestamp_1.Timestamp.OFFSET_MINUTE] = t.getMinutes(), e[timestamp_1.Timestamp.OFFSET_SECOND] = t.getSeconds(), 
        e[timestamp_1.Timestamp.OFFSET_NANOSECOND] = 1e6 * t.getMilliseconds(), e[timestamp_1.Timestamp.OFFSET_TIMEZONE] = timestamp_1.Timestamp.INVALID_VALUE, 
        e;
    }, c.toDTFromUnix = function(t) {
        return this.toDTFromDate(new Date(t));
    }, c.toDateFromDT = function(t, e) {
        var m = t[timestamp_1.Timestamp.OFFSET_YEAR], i = 0 < t[timestamp_1.Timestamp.OFFSET_MONTH] ? t[timestamp_1.Timestamp.OFFSET_MONTH] : 1, a = 0 < t[timestamp_1.Timestamp.OFFSET_DAY] ? t[timestamp_1.Timestamp.OFFSET_DAY] : 1, r = t[timestamp_1.Timestamp.OFFSET_HOUR], s = t[timestamp_1.Timestamp.OFFSET_MINUTE], _ = t[timestamp_1.Timestamp.OFFSET_SECOND], p = t[timestamp_1.Timestamp.OFFSET_NANOSECOND], n = t[timestamp_1.Timestamp.OFFSET_TIMEZONE] === timestamp_1.Timestamp.INVALID_VALUE ? e : t[timestamp_1.Timestamp.OFFSET_TIMEZONE];
        return new Date(Date.UTC(m, i - 1, a, r, s - n, _, parseInt(p.toString().substr(0, 3))));
    }, c.toStringFromDT = function(t, e, m, i) {
        return oracleDateFormat_1.OracleDateFormat.format(t, e, m, i);
    }, c.transformTZ = function(t, e, m) {
        e !== timestamp_1.Timestamp.INVALID_VALUE && m !== timestamp_1.Timestamp.INVALID_VALUE && m != e && ((t = this.addMinute(t, m - e))[timestamp_1.Timestamp.OFFSET_TIMEZONE] = m);
    }, c.getDaysOfMonth = function(t, e) {
        switch (e) {
          case 1:
          case 3:
          case 5:
          case 7:
          case 8:
          case 10:
          case 12:
            return 31;

          case 4:
          case 6:
          case 9:
          case 11:
            return 30;

          case 2:
            return this.isLeapYear(t) ? 29 : 28;

          default:
            return 0;
        }
    }, c.formatDate = function(t, e) {
        var m = t.getFullYear() + "-" + (t.getMonth() + 1).toString().padStart(2, "0") + "-" + t.getDate().toString().padStart(2, "0");
        return e && (m += " " + t.getHours().toString().padStart(2, "0") + ":" + t.getMinutes().toString().padStart(2, "0") + ":" + t.getSeconds().toString().padStart(2, "0")), 
        m;
    }, c.checkDate = function(t, e, m) {
        return !(9999 < t || t < -4712 || 12 < e || e < 1) && !(this.getDaysOfMonth(t, e) < m || m < 1);
    }, c.isLeapYear = function(t) {
        return t % 4 == 0 && t % 100 != 0 || t % 400 == 0;
    }, c.dmdtDecodeBdta = function(t) {
        var e = new Array(timestamp_1.Timestamp.DT_LEN);
        return e[timestamp_1.Timestamp.OFFSET_YEAR] = bufferUtil_1.BufferUtil.r(t, 0), e[timestamp_1.Timestamp.OFFSET_MONTH] = 255 & t[2], 
        e[timestamp_1.Timestamp.OFFSET_DAY] = 255 & t[3], e[timestamp_1.Timestamp.OFFSET_HOUR] = 255 & t[4], 
        e[timestamp_1.Timestamp.OFFSET_MINUTE] = 255 & t[5], e[timestamp_1.Timestamp.OFFSET_SECOND] = 255 & t[6], 
        e[timestamp_1.Timestamp.OFFSET_NANOSECOND] = (255 & t[7]) + (t[8] << 8) + (t[9] << 16), 
        e[timestamp_1.Timestamp.OFFSET_TIMEZONE] = bufferUtil_1.BufferUtil.r(t, 10), e;
    }, c.dmdtDecodeFast = function(t) {
        var e = new Array(timestamp_1.Timestamp.DT_LEN).fill(0);
        e[timestamp_1.Timestamp.OFFSET_TIMEZONE] = timestamp_1.Timestamp.INVALID_VALUE;
        var m = 0;
        return t.length == dbtype_1.DBType.DATE_PREC ? m = dbtype_1.DBType.DATE : t.length == dbtype_1.DBType.TIME_PREC ? m = dbtype_1.DBType.TIME : t.length == dbtype_1.DBType.TIME_TZ_PREC ? m = dbtype_1.DBType.TIME_TZ : t.length == dbtype_1.DBType.DATETIME_PREC ? m = dbtype_1.DBType.DATETIME : t.length == dbtype_1.DBType.DATETIME2_PREC ? m = dbtype_1.DBType.DATETIME2 : t.length == dbtype_1.DBType.DATETIME_TZ_PREC ? m = dbtype_1.DBType.DATETIME_TZ : t.length == dbtype_1.DBType.DATETIME2_TZ_PREC && (m = dbtype_1.DBType.DATETIME2_TZ), 
        m === dbtype_1.DBType.DATE ? (e[timestamp_1.Timestamp.OFFSET_YEAR] = 32767 & bufferUtil_1.BufferUtil.oi(t, 0), 
        9999 < e[timestamp_1.Timestamp.OFFSET_YEAR] && (e[timestamp_1.Timestamp.OFFSET_YEAR] = bufferUtil_1.BufferUtil.cn(bufferUtil_1.BufferUtil.Gn(32768 | e[timestamp_1.Timestamp.OFFSET_YEAR]))), 
        e[timestamp_1.Timestamp.OFFSET_MONTH] = (t[1] >> 7 & 1) + ((7 & t[2]) << 1), e[timestamp_1.Timestamp.OFFSET_DAY] = (248 & t[2]) >> 3 & 31) : m === dbtype_1.DBType.TIME ? (e[timestamp_1.Timestamp.OFFSET_HOUR] = 31 & t[0], 
        e[timestamp_1.Timestamp.OFFSET_MINUTE] = (t[0] >> 5 & 7) + ((7 & t[1]) << 3), e[timestamp_1.Timestamp.OFFSET_SECOND] = (t[1] >> 3 & 31) + ((1 & t[2]) << 5), 
        e[timestamp_1.Timestamp.OFFSET_NANOSECOND] = (t[2] >> 1 & 127) + ((255 & t[3]) << 7) + ((31 & t[4]) << 15), 
        e[timestamp_1.Timestamp.OFFSET_NANOSECOND] *= 1e3) : m === dbtype_1.DBType.TIME_TZ ? (e[timestamp_1.Timestamp.OFFSET_HOUR] = 31 & t[0], 
        e[timestamp_1.Timestamp.OFFSET_MINUTE] = (t[0] >> 5 & 7) + ((7 & t[1]) << 3), e[timestamp_1.Timestamp.OFFSET_SECOND] = (t[1] >> 3 & 31) + ((1 & t[2]) << 5), 
        e[timestamp_1.Timestamp.OFFSET_NANOSECOND] = (t[2] >> 1 & 127) + ((255 & t[3]) << 7) + ((31 & t[4]) << 15), 
        e[timestamp_1.Timestamp.OFFSET_NANOSECOND] *= 1e3, e[timestamp_1.Timestamp.OFFSET_TIMEZONE] = bufferUtil_1.BufferUtil.r(t, 5)) : m === dbtype_1.DBType.DATETIME ? (e[timestamp_1.Timestamp.OFFSET_YEAR] = 32767 & bufferUtil_1.BufferUtil.r(t, 0), 
        9999 < e[timestamp_1.Timestamp.OFFSET_YEAR] && (e[timestamp_1.Timestamp.OFFSET_YEAR] = -32768 | e[timestamp_1.Timestamp.OFFSET_YEAR]), 
        e[timestamp_1.Timestamp.OFFSET_MONTH] = (t[1] >> 7 & 1) + ((7 & t[2]) << 1), e[timestamp_1.Timestamp.OFFSET_DAY] = (248 & t[2]) >> 3 & 31, 
        e[timestamp_1.Timestamp.OFFSET_HOUR] = 31 & t[3], e[timestamp_1.Timestamp.OFFSET_MINUTE] = (t[3] >> 5 & 7) + ((7 & t[4]) << 3), 
        e[timestamp_1.Timestamp.OFFSET_SECOND] = (t[4] >> 3 & 31) + ((1 & t[5]) << 5), e[timestamp_1.Timestamp.OFFSET_NANOSECOND] = (t[5] >> 1 & 127) + ((255 & t[6]) << 7) + ((31 & t[7]) << 15), 
        e[timestamp_1.Timestamp.OFFSET_NANOSECOND] *= 1e3) : m === dbtype_1.DBType.DATETIME_TZ ? (e[timestamp_1.Timestamp.OFFSET_YEAR] = 32767 & bufferUtil_1.BufferUtil.r(t, 0), 
        9999 < e[timestamp_1.Timestamp.OFFSET_YEAR] && (e[timestamp_1.Timestamp.OFFSET_YEAR] = -32768 | e[timestamp_1.Timestamp.OFFSET_YEAR]), 
        e[timestamp_1.Timestamp.OFFSET_MONTH] = (t[1] >> 7 & 1) + ((7 & t[2]) << 1), e[timestamp_1.Timestamp.OFFSET_DAY] = (248 & t[2]) >> 3 & 31, 
        e[timestamp_1.Timestamp.OFFSET_HOUR] = 31 & t[3], e[timestamp_1.Timestamp.OFFSET_MINUTE] = (t[3] >> 5 & 7) + ((7 & t[4]) << 3), 
        e[timestamp_1.Timestamp.OFFSET_SECOND] = (t[4] >> 3 & 31) + ((1 & t[5]) << 5), e[timestamp_1.Timestamp.OFFSET_NANOSECOND] = (t[5] >> 1 & 127) + ((255 & t[6]) << 7) + ((31 & t[7]) << 15), 
        e[timestamp_1.Timestamp.OFFSET_NANOSECOND] *= 1e3, e[timestamp_1.Timestamp.OFFSET_TIMEZONE] = bufferUtil_1.BufferUtil.r(t, t.length - 2)) : m === dbtype_1.DBType.DATETIME2 ? (e[timestamp_1.Timestamp.OFFSET_YEAR] = 32767 & bufferUtil_1.BufferUtil.r(t, 0), 
        9999 < e[timestamp_1.Timestamp.OFFSET_YEAR] && (e[timestamp_1.Timestamp.OFFSET_YEAR] = -32768 | e[timestamp_1.Timestamp.OFFSET_YEAR]), 
        e[timestamp_1.Timestamp.OFFSET_MONTH] = (t[1] >> 7 & 1) + ((7 & t[2]) << 1), e[timestamp_1.Timestamp.OFFSET_DAY] = (248 & t[2]) >> 3 & 31, 
        e[timestamp_1.Timestamp.OFFSET_HOUR] = 31 & t[3], e[timestamp_1.Timestamp.OFFSET_MINUTE] = (t[3] >> 5 & 7) + ((7 & t[4]) << 3), 
        e[timestamp_1.Timestamp.OFFSET_SECOND] = (t[4] >> 3 & 31) + ((1 & t[5]) << 5), e[timestamp_1.Timestamp.OFFSET_NANOSECOND] = (t[5] >> 1 & 127) + ((255 & t[6]) << 7) + ((31 & t[7]) << 15) + ((127 & t[8]) << 23)) : m === dbtype_1.DBType.DATETIME2_TZ && (e[timestamp_1.Timestamp.OFFSET_YEAR] = 32767 & bufferUtil_1.BufferUtil.r(t, 0), 
        9999 < e[timestamp_1.Timestamp.OFFSET_YEAR] && (e[timestamp_1.Timestamp.OFFSET_YEAR] = -32768 | e[timestamp_1.Timestamp.OFFSET_YEAR]), 
        e[timestamp_1.Timestamp.OFFSET_MONTH] = (t[1] >> 7 & 1) + ((7 & t[2]) << 1), e[timestamp_1.Timestamp.OFFSET_DAY] = (248 & t[2]) >> 3 & 31, 
        e[timestamp_1.Timestamp.OFFSET_HOUR] = 31 & t[3], e[timestamp_1.Timestamp.OFFSET_MINUTE] = (t[3] >> 5 & 7) + ((7 & t[4]) << 3), 
        e[timestamp_1.Timestamp.OFFSET_SECOND] = (t[4] >> 3 & 31) + ((1 & t[5]) << 5), e[timestamp_1.Timestamp.OFFSET_NANOSECOND] = (t[5] >> 1 & 127) + ((255 & t[6]) << 7) + ((31 & t[7]) << 15) + ((127 & t[8]) << 23), 
        e[timestamp_1.Timestamp.OFFSET_TIMEZONE] = bufferUtil_1.BufferUtil.r(t, t.length - 2)), 
        e;
    }, c.addMinute = function(t, e) {
        var m = t[timestamp_1.Timestamp.OFFSET_MINUTE] + e, i = Math.trunc(m / 60);
        return (m %= 60) < 0 && (m += 60, i--), t[timestamp_1.Timestamp.OFFSET_MINUTE] = m, 
        this.addHour(t, i), t;
    }, c.addHour = function(t, e) {
        var m = t[timestamp_1.Timestamp.OFFSET_HOUR] + e, i = Math.trunc(m / 24);
        return (m %= 24) < 0 && (m += 24, i--), t[timestamp_1.Timestamp.OFFSET_HOUR] = m, 
        this.addDay(t, i), t;
    }, c.addDay = function(t, e) {
        for (var m, i = t[timestamp_1.Timestamp.OFFSET_DAY] + e; i > (m = this.getDaysOfMonth(t[timestamp_1.Timestamp.OFFSET_YEAR], t[timestamp_1.Timestamp.OFFSET_MONTH])) || i <= 0; ) this.addMonth(t, m < i ? 1 : -1), 
        i = m < i ? i - m : i + m;
        return t[timestamp_1.Timestamp.OFFSET_DAY] = i, t;
    }, c.addMonth = function(t, e) {
        var m = t[timestamp_1.Timestamp.OFFSET_MONTH] + e, i = Math.trunc(m / 12);
        (m %= 12) < 1 && (m += 12, i--);
        var a = this.getDaysOfMonth(t[timestamp_1.Timestamp.OFFSET_YEAR], m);
        return t[timestamp_1.Timestamp.OFFSET_DAY] > a && (t[timestamp_1.Timestamp.OFFSET_DAY] = a), 
        t[timestamp_1.Timestamp.OFFSET_MONTH] = m, this.addYear(t, i), t;
    }, c.addYear = function(t, e) {
        return t[timestamp_1.Timestamp.OFFSET_YEAR] += e, t;
    }, c;
}();

exports.DateUtil = DateUtil;