"use strict";

var __extends = this && this.__extends || function() {
    var e = function(t, r) {
        return (e = Object.setPrototypeOf || {
            __proto__: []
        } instanceof Array && function(t, r) {
            t.__proto__ = r;
        } || function(t, r) {
            for (var n in r) r.hasOwnProperty(n) && (t[n] = r[n]);
        })(t, r);
    };
    return function(t, r) {
        function n() {
            this.constructor = t;
        }
        e(t, r), t.prototype = null === r ? Object.create(r) : (n.prototype = r.prototype, 
        new n());
    };
}(), __values = this && this.__values || function(t) {
    var r = "function" == typeof Symbol && Symbol.iterator, n = r && t[r], e = 0;
    if (n) return n.call(t);
    if (t && "number" == typeof t.length) return {
        next: function() {
            return t && e >= t.length && (t = void 0), {
                value: t && t[e++],
                done: !t
            };
        }
    };
    throw new TypeError(r ? "Object is not iterable." : "Symbol.iterator is not defined.");
};

Object.defineProperty(exports, "__esModule", {
    value: !0
});

var timestamp_1 = require("../driver/timestamp"), error_1 = require("../driver/error"), const_1 = require("../desc/const"), stringUtil_1 = require("./stringUtil"), dateUtil_1 = require("./dateUtil"), OracleDateFormat = function() {
    function s() {
        this.Y = new YearElement(this), this.HH12 = new HH12Element(this), this.HH24 = new HH24Element(this), 
        this.MI = new MIElement(this), this.SS = new SSElement(this), this.AM = new AMElement(this), 
        this.Month = new MonthElement(this), this.Mon = new MonElement(this), this.MM = new MMElement(this), 
        this.DD = new DDElement(this), this.TZH = new TZHElement(this), this.TZM = new TZMElement(this), 
        this.F = new FElement(this), this.formatElementList = new Array(), this.language = const_1.Const.LANGUAGE_CN, 
        this.scale = timestamp_1.Timestamp.NANOSECOND_DIGITS, this.PM = !1, this.TZNegative = !1;
    }
    return s.parse = function(t, r, n) {
        var e = new s();
        return e.setPattern(r), e.language = n, e.parse(t);
    }, s.format = function(t, r, n, e) {
        var i = new s();
        return i.setPattern(r), i.language = e, i.scale = n, i.format(t);
    }, s.prototype.setPattern = function(t) {
        t !== this.pattern && (this.pattern = t, this.formatElementList = [], this.analysePattern(t));
    }, s.prototype.parse = function(t) {
        var r, n;
        this.clearBeforeParse();
        var e = new Array(timestamp_1.Timestamp.DT_LEN), i = new Date();
        e[timestamp_1.Timestamp.OFFSET_YEAR] = i.getFullYear(), e[timestamp_1.Timestamp.OFFSET_MONTH] = i.getMonth() + 1, 
        e[timestamp_1.Timestamp.OFFSET_DAY] = i.getDate(), e[timestamp_1.Timestamp.OFFSET_TIMEZONE] = timestamp_1.Timestamp.INVALID_VALUE;
        var s = 0;
        try {
            t = t.trim();
            try {
                for (var a = __values(this.formatElementList), o = a.next(); !o.done; o = a.next()) {
                    for (var m = o.value; " " === t.charAt(s) && " " !== m.toString(); ) s++;
                    m instanceof Element ? s = m.parse(t, s, e) : s += m.toString().length;
                }
            } catch (t) {
                r = {
                    error: t
                };
            } finally {
                try {
                    o && !o.done && (n = a.return) && n.call(a);
                } finally {
                    if (r) throw r.error;
                }
            }
            if (s < t.length) throw error_1.DBError.ECJS_INVALID_DATETIME_VALUE();
            this.PM && (e[timestamp_1.Timestamp.OFFSET_HOUR] = (e[timestamp_1.Timestamp.OFFSET_HOUR] + 12) % 24), 
            this.TZNegative && (e[timestamp_1.Timestamp.OFFSET_TIMEZONE] = -e[timestamp_1.Timestamp.OFFSET_TIMEZONE]);
        } catch (t) {
            if (t instanceof error_1.DBError && (t.errCode === error_1.DBError.ECJS_INVALID_DATETIME_VALUE().errCode || t.errCode === error_1.DBError.ECJS_INVALID_DATETIME_FORMAT().errCode)) throw t;
            throw error_1.DBError.ECJS_INVALID_DATETIME_FORMAT(t + "");
        }
        if (e[timestamp_1.Timestamp.OFFSET_DAY] > dateUtil_1.DateUtil.getDaysOfMonth(e[timestamp_1.Timestamp.OFFSET_YEAR], e[timestamp_1.Timestamp.OFFSET_MONTH]) || e[timestamp_1.Timestamp.OFFSET_DAY] < 1) throw error_1.DBError.ECJS_INVALID_DATETIME_VALUE();
        if (e[timestamp_1.Timestamp.OFFSET_TIMEZONE] !== timestamp_1.Timestamp.INVALID_VALUE && (840 < e[timestamp_1.Timestamp.OFFSET_TIMEZONE] || e[timestamp_1.Timestamp.OFFSET_TIMEZONE] <= -780)) throw error_1.DBError.ECJS_INVALID_DATETIME_VALUE();
        return e;
    }, s.prototype.format = function(t) {
        var r, n, e = "", i = !1;
        try {
            for (var s = __values(this.formatElementList), a = s.next(); !a.done; a = s.next()) {
                var o = a.value;
                !i && (o instanceof TZHElement || o instanceof TZMElement) && (i = !0, e += t[timestamp_1.Timestamp.OFFSET_TIMEZONE] < 0 ? "-" : "+"), 
                e += o instanceof Element ? o.format(t) : o.toString();
            }
        } catch (t) {
            r = {
                error: t
            };
        } finally {
            try {
                a && !a.done && (n = s.return) && n.call(s);
            } finally {
                if (r) throw r.error;
            }
        }
        return e;
    }, s.prototype.clearBeforeParse = function() {
        this.PM = !1, this.TZNegative = !1;
    }, s.prototype.analysePattern = function(t) {
        for (var r, n, e, i = (t = t.trim()).length, s = new Array(0), a = 0, o = 0; o < i; o++) e = t.charAt(o), 
        /(^[A-Za-z0-9]$)/.test(e) ? o === i - 1 && s.push(t.substring(a, o + 1)) : (a < o && s.push(t.substring(a, o)), 
        s.push(e), a = o + 1);
        try {
            for (var m = __values(s), u = m.next(); !u.done; u = m.next()) {
                var h = u.value;
                if (1 !== h.length || /(^[A-Za-z0-9]$)/.test(h.charAt(0))) for (var f; "" !== h; ) {
                    for (o = h.length; 0 < o; o--) {
                        f = h.substring(0, o);
                        var _, l = this.getFormatElement(f);
                        if (l) {
                            l !== this.TZH && l !== this.TZM || ("+" !== (_ = this.formatElementList[this.formatElementList.length - 1].toString()) && "-" !== _ || this.formatElementList.pop()), 
                            this.formatElementList.push(l), h = o == h.length ? "" : h.substring(o, h.length);
                            break;
                        }
                    }
                    if (0 == o) {
                        this.formatElementList.push(h);
                        break;
                    }
                } else this.formatElementList.push(h);
            }
        } catch (t) {
            r = {
                error: t
            };
        } finally {
            try {
                u && !u.done && (n = m.return) && n.call(m);
            } finally {
                if (r) throw r.error;
            }
        }
        return this.formatElementList;
    }, s.prototype.getFormatElement = function(t) {
        if ("HH" === t.toUpperCase() || "HH12" === t.toUpperCase()) return this.HH12;
        if ("HH24" === t.toUpperCase()) return this.HH24;
        if ("MI" === t.toUpperCase()) return this.MI;
        if ("SS" === t.toUpperCase()) return this.SS;
        if ("AM" === t.toUpperCase() || "A.M." === t.toUpperCase() || "PM" === t.toUpperCase() || "P.M." === t.toUpperCase()) return this.AM;
        if ("MONTH" === t) return this.Month.upperCase = !0, this.Month.lowerCase = !1, 
        this.Month;
        if ("month" === t) return this.Month.upperCase = !1, this.Month.lowerCase = !0, 
        this.Month;
        if (stringUtil_1.StringUtil.equalsIgnoreCase(t, "Month")) return this.Month.upperCase = !1, 
        this.Month.lowerCase = !1, this.Month;
        if ("MON" === t) return this.Mon.upperCase = !0, this.Mon.lowerCase = !1, this.Mon;
        if ("mon" === t) return this.Mon.upperCase = !1, this.Mon.lowerCase = !0, this.Mon;
        if (stringUtil_1.StringUtil.equalsIgnoreCase(t, "Mon")) return this.Mon.upperCase = !1, 
        this.Mon.lowerCase = !1, this.Mon;
        if ("MM" === t.toUpperCase()) return this.MM;
        if ("DD" === t.toUpperCase()) return this.DD;
        if ("TZH" === t.toUpperCase()) return this.TZH;
        if ("TZM" === t.toUpperCase()) return this.TZM;
        if (t.startsWith("Y") || t.startsWith("y")) return this.Y.len = t.length, this.Y;
        if (t.startsWith("F") || t.startsWith("f")) try {
            var r = (t = t.toUpperCase()).lastIndexOf("F") + 1, n = r < t.length ? parseInt(t.substring(r)) : -1;
            return this.F.len = n, this.F;
        } catch (t) {}
    }, s;
}();

exports.OracleDateFormat = OracleDateFormat;

var Element = function(t) {
    this.oraFormat = t;
}, YearElement = function(r) {
    function t() {
        var t = null !== r && r.apply(this, arguments) || this;
        return t.len = 4, t;
    }
    return __extends(t, r), t.prototype.parse = function(t, r, n) {
        for (var e, i = 0, s = r; s < r + this.len && s < t.length && stringUtil_1.StringUtil.isLetterOrDigit(t.charAt(s)); s++) i++;
        return t = t.substr(r, i), this.len < 4 ? (e = n[timestamp_1.Timestamp.OFFSET_YEAR].toString(), 
        n[timestamp_1.Timestamp.OFFSET_YEAR] = parseInt(e.substring(0, 4 - this.len) + t)) : n[timestamp_1.Timestamp.OFFSET_YEAR] = parseInt(t), 
        r + i;
    }, t.prototype.format = function(t) {
        return formatInt(t[timestamp_1.Timestamp.OFFSET_YEAR], this.len);
    }, t;
}(Element), HH12Element = function(t) {
    function r() {
        return null !== t && t.apply(this, arguments) || this;
    }
    return __extends(r, t), r.prototype.parse = function(t, r, n) {
        for (var e = 0, i = r; i < r + 2 && i < t.length && stringUtil_1.StringUtil.isLetterOrDigit(t.charAt(i)); i++) e++;
        t = t.substr(r, e);
        var s = parseInt(t);
        if (12 < s || s < 1) throw error_1.DBError.ECJS_INVALID_DATETIME_VALUE();
        return n[timestamp_1.Timestamp.OFFSET_HOUR] = s, r + e;
    }, r.prototype.format = function(t) {
        var r = t[timestamp_1.Timestamp.OFFSET_HOUR];
        return formatInt(12 < r || 0 == r ? Math.abs(r - 12) : r, 2);
    }, r;
}(Element), HH24Element = function(t) {
    function r() {
        return null !== t && t.apply(this, arguments) || this;
    }
    return __extends(r, t), r.prototype.parse = function(t, r, n) {
        for (var e = 0, i = r; i < r + 2 && i < t.length && stringUtil_1.StringUtil.isLetterOrDigit(t.charAt(i)); i++) e++;
        t = t.substr(r, e);
        var s = parseInt(t);
        if (23 < s || s < 0) throw error_1.DBError.ECJS_INVALID_DATETIME_VALUE();
        return n[timestamp_1.Timestamp.OFFSET_HOUR] = s, r + e;
    }, r.prototype.format = function(t) {
        return formatInt(t[timestamp_1.Timestamp.OFFSET_HOUR], 2);
    }, r;
}(Element), MIElement = function(t) {
    function r() {
        return null !== t && t.apply(this, arguments) || this;
    }
    return __extends(r, t), r.prototype.parse = function(t, r, n) {
        for (var e = 0, i = r; i < r + 2 && i < t.length && stringUtil_1.StringUtil.isLetterOrDigit(t.charAt(i)); i++) e++;
        t = t.substr(r, e);
        var s = parseInt(t);
        if (59 < s || s < 0) throw error_1.DBError.ECJS_INVALID_DATETIME_VALUE();
        return n[timestamp_1.Timestamp.OFFSET_MINUTE] = s, r + e;
    }, r.prototype.format = function(t) {
        return formatInt(t[timestamp_1.Timestamp.OFFSET_MINUTE], 2);
    }, r;
}(Element), SSElement = function(t) {
    function r() {
        return null !== t && t.apply(this, arguments) || this;
    }
    return __extends(r, t), r.prototype.parse = function(t, r, n) {
        for (var e = 0, i = r; i < r + 2 && i < t.length && stringUtil_1.StringUtil.isLetterOrDigit(t.charAt(i)); i++) e++;
        t = t.substr(r, e);
        var s = parseInt(t);
        if (59 < s || s < 0) throw error_1.DBError.ECJS_INVALID_DATETIME_VALUE();
        return n[timestamp_1.Timestamp.OFFSET_SECOND] = s, r + e;
    }, r.prototype.format = function(t) {
        return formatInt(t[timestamp_1.Timestamp.OFFSET_SECOND], 2);
    }, r;
}(Element), MMElement = function(t) {
    function r() {
        return null !== t && t.apply(this, arguments) || this;
    }
    return __extends(r, t), r.prototype.parse = function(t, r, n) {
        for (var e = 0, i = r; i < r + 2 && i < t.length && stringUtil_1.StringUtil.isLetterOrDigit(t.charAt(i)); i++) e++;
        if (t = t.substr(r, e), !stringUtil_1.StringUtil.isDigit(t)) throw error_1.DBError.ECJS_INVALID_DATETIME_FORMAT();
        var s = parseInt(t);
        if (12 < s || s < 1) throw error_1.DBError.ECJS_INVALID_DATETIME_VALUE();
        return n[timestamp_1.Timestamp.OFFSET_MONTH] = s, r + e;
    }, r.prototype.format = function(t) {
        return formatInt(t[timestamp_1.Timestamp.OFFSET_MONTH], 2);
    }, r;
}(Element), DDElement = function(t) {
    function r() {
        return null !== t && t.apply(this, arguments) || this;
    }
    return __extends(r, t), r.prototype.parse = function(t, r, n) {
        for (var e = 0, i = r; i < r + 2 && i < t.length && stringUtil_1.StringUtil.isLetterOrDigit(t.charAt(i)); i++) e++;
        t = t.substr(r, e);
        var s = parseInt(t);
        if (31 < s || s < 1) throw error_1.DBError.ECJS_INVALID_DATETIME_VALUE();
        return n[timestamp_1.Timestamp.OFFSET_DAY] = s, r + e;
    }, r.prototype.format = function(t) {
        return formatInt(t[timestamp_1.Timestamp.OFFSET_DAY], 2);
    }, r;
}(Element), MonthElement = function(r) {
    function t() {
        var t = null !== r && r.apply(this, arguments) || this;
        return t.upperCase = !1, t.lowerCase = !1, t.nameList = [ "", "January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December" ], 
        t;
    }
    return __extends(t, r), t.prototype.parse = function(t, r, n) {
        if (this.oraFormat.language === const_1.Const.LANGUAGE_CN) {
            var e = t.indexOf("月", r);
            if (-1 === e) throw error_1.DBError.ECJS_INVALID_DATETIME_FORMAT();
            if (12 < (i = parseInt(t.substring(r, e))) || i < 1) throw error_1.DBError.ECJS_INVALID_DATETIME_VALUE();
            return n[timestamp_1.Timestamp.OFFSET_MONTH] = i, e + 1;
        }
        t = t.substring(r).toLowerCase();
        for (var i = 0, s = 1; s < this.nameList.length; s++) if (t.toUpperCase().startsWith(this.nameList[s].toUpperCase())) {
            i = s;
            break;
        }
        if (0 === i) throw error_1.DBError.ECJS_INVALID_DATETIME_FORMAT();
        return n[timestamp_1.Timestamp.OFFSET_MONTH] = i, r + this.nameList[i].length;
    }, t.prototype.format = function(t) {
        var r = t[timestamp_1.Timestamp.OFFSET_MONTH];
        return this.oraFormat.language === const_1.Const.LANGUAGE_CN ? r + "月" : this.upperCase ? this.nameList[r].toUpperCase() : this.lowerCase ? this.nameList[r].toLowerCase() : this.nameList[r];
    }, t;
}(Element), MonElement = function(r) {
    function t() {
        var t = null !== r && r.apply(this, arguments) || this;
        return t.upperCase = !1, t.lowerCase = !1, t.nameList = [ "", "Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec" ], 
        t;
    }
    return __extends(t, r), t.prototype.parse = function(t, r, n) {
        if (this.oraFormat.language === const_1.Const.LANGUAGE_CN) {
            var e = t.indexOf("月", r);
            if (-1 === e) throw error_1.DBError.ECJS_INVALID_DATETIME_FORMAT();
            if (12 < (i = parseInt(t.substring(r, e))) || i < 1) throw error_1.DBError.ECJS_INVALID_DATETIME_VALUE();
            return n[timestamp_1.Timestamp.OFFSET_MONTH] = i, e + 1;
        }
        t = t.substring(r, r + 3);
        for (var i = 0, s = 1; s < this.nameList.length; s++) if (stringUtil_1.StringUtil.equalsIgnoreCase(t, this.nameList[s])) {
            i = s;
            break;
        }
        if (0 === i) throw error_1.DBError.ECJS_INVALID_DATETIME_FORMAT();
        return n[timestamp_1.Timestamp.OFFSET_MONTH] = i, r + 3;
    }, t.prototype.format = function(t) {
        var r = t[timestamp_1.Timestamp.OFFSET_MONTH];
        return this.oraFormat.language === const_1.Const.LANGUAGE_CN ? r + "月" : this.upperCase ? this.nameList[r].toUpperCase() : this.lowerCase ? this.nameList[r].toLowerCase() : this.nameList[r];
    }, t;
}(Element), FElement = function(r) {
    function t() {
        var t = null !== r && r.apply(this, arguments) || this;
        return t.len = -1, t;
    }
    return __extends(t, r), t.prototype.parse = function(t, r, n) {
        for (var e = 0, i = 0 < this.len ? this.len : timestamp_1.Timestamp.NANOSECOND_DIGITS, s = r; s < r + i && s < t.length && stringUtil_1.StringUtil.isLetterOrDigit(t.charAt(s)); s++) e++;
        t = t.substr(r, e);
        var a = parseInt(t), a = e < timestamp_1.Timestamp.NANOSECOND_DIGITS ? a * Math.pow(10, timestamp_1.Timestamp.NANOSECOND_DIGITS - e) : a / Math.pow(10, e - timestamp_1.Timestamp.NANOSECOND_DIGITS);
        return n[timestamp_1.Timestamp.OFFSET_NANOSECOND] = a, r + e;
    }, t.prototype.format = function(t) {
        var r = 0 < this.len ? this.len : this.oraFormat.scale;
        return formatNanoSecond(t[timestamp_1.Timestamp.OFFSET_NANOSECOND], r);
    }, t;
}(Element), TZHElement = function(t) {
    function r() {
        return null !== t && t.apply(this, arguments) || this;
    }
    return __extends(r, t), r.prototype.parse = function(t, r, n) {
        "+" == t.charAt(r) ? r += 1 : "-" == t.charAt(r) && (r += 1, this.oraFormat.TZNegative = !0);
        for (var e = 0, i = r; i < r + 2 && i < t.length && stringUtil_1.StringUtil.isLetterOrDigit(t.charAt(i)); i++) e++;
        t = t.substr(r, e);
        var s = parseInt(t);
        if (23 < s || s < 0) throw error_1.DBError.ECJS_INVALID_DATETIME_VALUE();
        return s *= 60, n[timestamp_1.Timestamp.OFFSET_TIMEZONE] = n[timestamp_1.Timestamp.OFFSET_TIMEZONE] === timestamp_1.Timestamp.INVALID_VALUE ? s : n[timestamp_1.Timestamp.OFFSET_TIMEZONE] + s, 
        r + e;
    }, r.prototype.format = function(t) {
        return formatInt(t[timestamp_1.Timestamp.OFFSET_TIMEZONE] !== timestamp_1.Timestamp.INVALID_VALUE ? Math.abs(t[timestamp_1.Timestamp.OFFSET_TIMEZONE]) / 60 : 0, 2);
    }, r;
}(Element), TZMElement = function(t) {
    function r() {
        return null !== t && t.apply(this, arguments) || this;
    }
    return __extends(r, t), r.prototype.parse = function(t, r, n) {
        "+" == t.charAt(r) ? r += 1 : "-" == t.charAt(r) && (r += 1, this.oraFormat.TZNegative = !0);
        for (var e = 0, i = r; i < r + 2 && i < t.length && stringUtil_1.StringUtil.isLetterOrDigit(t.charAt(i)); i++) e++;
        t = t.substr(r, e);
        var s = parseInt(t);
        if (59 < s || s < 0) throw error_1.DBError.ECJS_INVALID_DATETIME_VALUE();
        return n[timestamp_1.Timestamp.OFFSET_TIMEZONE] = n[timestamp_1.Timestamp.OFFSET_TIMEZONE] === timestamp_1.Timestamp.INVALID_VALUE ? s : n[timestamp_1.Timestamp.OFFSET_TIMEZONE] + s, 
        r + e;
    }, r.prototype.format = function(t) {
        return formatInt(t[timestamp_1.Timestamp.OFFSET_TIMEZONE] != timestamp_1.Timestamp.INVALID_VALUE ? Math.abs(t[timestamp_1.Timestamp.OFFSET_TIMEZONE]) % 60 : 0, 2);
    }, r;
}(Element), AMElement = function(t) {
    function r() {
        return null !== t && t.apply(this, arguments) || this;
    }
    return __extends(r, t), r.prototype.parse = function(t, r, n) {
        return t = t.substring(r, r + 2), this.oraFormat.PM = this.oraFormat.language === const_1.Const.LANGUAGE_CN ? !!stringUtil_1.StringUtil.equalsIgnoreCase("下午", t) : !!stringUtil_1.StringUtil.equalsIgnoreCase("PM", t), 
        r + 2;
    }, r.prototype.format = function(t) {
        var r = t[timestamp_1.Timestamp.OFFSET_HOUR];
        return this.oraFormat.language === const_1.Const.LANGUAGE_CN ? 12 < r ? "下午" : "上午" : 12 < r ? "PM" : "AM";
    }, r;
}(Element);

function formatInt(t, r) {
    var n = Math.pow(10, r);
    return n <= t && (t %= n), (t += n).toString().substring(1);
}

function formatNanoSecond(t, r) {
    var n = null, n = t < 10 ? "00000000" + t : t < 100 ? "0000000" + t : t < 1e3 ? "000000" + t : t < 1e4 ? "00000" + t : t < 1e5 ? "0000" + t : t < 1e6 ? "000" + t : t < 1e7 ? "00" + t : t < 1e8 ? "0" + t : t.toString();
    return r < timestamp_1.Timestamp.NANOSECOND_DIGITS ? n.substring(0, r) : n;
}