"use strict";
/**
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.NacosConfigClient = exports.HttpAgent = exports.Snapshot = exports.ServerListManager = exports.ClientWorker = exports.DataClient = void 0;
const client_1 = require("./client");
const utils_1 = require("./utils");
__exportStar(require("./interface"), exports);
var client_2 = require("./client");
Object.defineProperty(exports, "DataClient", { enumerable: true, get: function () { return client_2.DataClient; } });
var client_worker_1 = require("./client_worker");
Object.defineProperty(exports, "ClientWorker", { enumerable: true, get: function () { return client_worker_1.ClientWorker; } });
var server_list_mgr_1 = require("./server_list_mgr");
Object.defineProperty(exports, "ServerListManager", { enumerable: true, get: function () { return server_list_mgr_1.ServerListManager; } });
var snapshot_1 = require("./snapshot");
Object.defineProperty(exports, "Snapshot", { enumerable: true, get: function () { return snapshot_1.Snapshot; } });
var http_agent_1 = require("./http_agent");
Object.defineProperty(exports, "HttpAgent", { enumerable: true, get: function () { return http_agent_1.HttpAgent; } });
const APIClientBase = require('cluster-client').APIClientBase;
class NacosConfigClient extends APIClientBase {
    /**
     * cluster-client wrapper client
     * set after constructor
     */
    constructor(options = {}) {
        super(options);
    }
    get DataClient() {
        return client_1.DataClient;
    }
    get clusterOptions() {
        const host = this.options.endpoint;
        return {
            name: `DiamondClient@${host}`,
        };
    }
    /**
     * 订阅
     * @param {Object} reg
     *   - {String} dataId - id of the data you want to subscribe
     *   - {String} [group] - group name of the data
     *   - {String} [unit] - which unit you want to connect, default is current unit
     * @param {Function} listener - listener
     * @return {DiamondClient} self
     */
    subscribe(reg, listener) {
        const { dataId, group } = reg;
        (0, utils_1.checkParameters)(dataId, group);
        this._client.subscribe(reg, listener);
        return this;
    }
    /**
     * 退订
     * @param {Object} reg
     *   - {String} dataId - id of the data you want to subscribe
     *   - {String} [group] - group name of the data
     *   - {String} [unit] - which unit you want to connect, default is current unit
     * @param {Function} listener - listener
     * @return {DiamondClient} self
     */
    unSubscribe(reg, listener) {
        const { dataId, group } = reg;
        (0, utils_1.checkParameters)(dataId, group);
        this._client.unSubscribe(reg, listener);
        return this;
    }
    /**
     * 获取当前机器所在机房
     * @return {String} currentUnit
     */
    async getCurrentUnit() {
        return await this._client.getCurrentUnit();
    }
    /**
     * 获取所有单元信息
     * @return {Array} units
     */
    async getAllUnits() {
        return await this._client.getAllUnits();
    }
    /**
     * 查询租户下的所有的配置
     * @return {Array} config
     */
    async getConfigs() {
        return await this._client.getConfigs();
    }
    /**
     * 获取配置
     * @param {String} dataId - id of the data
     * @param {String} group - group name of the data
     * @param {Object} options
     *   - {Stirng} unit - which unit you want to connect, default is current unit
     * @return {String} value
     */
    async getConfig(dataId, group, options) {
        (0, utils_1.checkParameters)(dataId, group);
        return await this._client.getConfig(dataId, group, options);
    }
    /**
     * 发布配置
     * @param {String} dataId - id of the data
     * @param {String} group - group name of the data
     * @param {String} content - config value
     * @param {Object} options
     *   - {Stirng} unit - which unit you want to connect, default is current unit
     * @return {Boolean} success
     */
    async publishSingle(dataId, group, content, options) {
        (0, utils_1.checkParameters)(dataId, group);
        return await this._client.publishSingle(dataId, group, content, options);
    }
    /**
     * 删除配置
     * @param {String} dataId - id of the data
     * @param {String} group - group name of the data
     * @param {Object} options
     *   - {Stirng} unit - which unit you want to connect, default is current unit
     * @return {Boolean} success
     */
    async remove(dataId, group, options) {
        (0, utils_1.checkParameters)(dataId, group);
        return await this._client.remove(dataId, group, options);
    }
    /**
     * 批量获取配置
     * @param {Array} dataIds - data id array
     * @param {String} group - group name of the data
     * @param {Object} options
     *   - {Stirng} unit - which unit you want to connect, default is current unit
     * @return {Array} result
     */
    async batchGetConfig(dataIds, group, options) {
        (0, utils_1.checkParameters)(dataIds, group);
        return await this._client.batchGetConfig(dataIds, group, options);
    }
    /**
     * 批量查询
     * @param {Array} dataIds - data id array
     * @param {String} group - group name of the data
     * @param {Object} options
     *   - {Stirng} unit - which unit you want to connect, default is current unit
     * @return {Object} result
     */
    async batchQuery(dataIds, group, options) {
        (0, utils_1.checkParameters)(dataIds, group);
        return await this._client.batchQuery(dataIds, group, options);
    }
    /**
     * 将配置发布到所有单元
     * @param {String} dataId - id of the data
     * @param {String} group - group name of the data
     * @param {String} content - config value
     * @return {Boolean} success
     */
    async publishToAllUnit(dataId, group, content) {
        (0, utils_1.checkParameters)(dataId, group);
        return await this._client.publishToAllUnit(dataId, group, content);
    }
    /**
     * 将配置从所有单元中删除
     * @param {String} dataId - id of the data
     * @param {String} group - group name of the data
     * @return {Boolean} success
     */
    async removeToAllUnit(dataId, group) {
        (0, utils_1.checkParameters)(dataId, group);
        return await this._client.removeToAllUnit(dataId, group);
    }
    async publishAggr(dataId, group, datumId, content, options) {
        (0, utils_1.checkParameters)(dataId, group, datumId);
        return await this._client.publishAggr(dataId, group, datumId, content, options);
    }
    async removeAggr(dataId, group, datumId, options) {
        (0, utils_1.checkParameters)(dataId, group, datumId);
        return await this._client.removeAggr(dataId, group, datumId, options);
    }
    close() {
        return this._client.close();
    }
    static get DataClient() {
        return client_1.DataClient;
    }
}
exports.NacosConfigClient = NacosConfigClient;
//# sourceMappingURL=index.js.map