"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.SymmetricKey = void 0;

// This code is based on the `mssql-jdbc` library published under the conditions of MIT license.
// Copyright (c) 2019 Microsoft Corporation
class SymmetricKey {
  constructor(rootKey) {
    this.rootKey = void 0;

    if (!rootKey) {
      throw new Error('Column encryption key cannot be null.');
    } else if (0 === rootKey.length) {
      throw new Error('Empty column encryption key specified.');
    }

    this.rootKey = rootKey;
  }

  zeroOutKey() {
    this.rootKey = Buffer.alloc(this.rootKey.length);
  }

}

exports.SymmetricKey = SymmetricKey;
var _default = SymmetricKey;
exports.default = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi4uLy4uL3NyYy9hbHdheXMtZW5jcnlwdGVkL3N5bW1ldHJpYy1rZXkudHMiXSwibmFtZXMiOlsiU3ltbWV0cmljS2V5IiwiY29uc3RydWN0b3IiLCJyb290S2V5IiwiRXJyb3IiLCJsZW5ndGgiLCJ6ZXJvT3V0S2V5IiwiQnVmZmVyIiwiYWxsb2MiXSwibWFwcGluZ3MiOiI7Ozs7Ozs7QUFBQTtBQUNBO0FBRU8sTUFBTUEsWUFBTixDQUFtQjtBQUd4QkMsRUFBQUEsV0FBVyxDQUFDQyxPQUFELEVBQWtCO0FBQUEsU0FGN0JBLE9BRTZCOztBQUMzQixRQUFJLENBQUNBLE9BQUwsRUFBYztBQUNaLFlBQU0sSUFBSUMsS0FBSixDQUFVLHVDQUFWLENBQU47QUFDRCxLQUZELE1BRU8sSUFBSSxNQUFNRCxPQUFPLENBQUNFLE1BQWxCLEVBQTBCO0FBQy9CLFlBQU0sSUFBSUQsS0FBSixDQUFVLHdDQUFWLENBQU47QUFDRDs7QUFDRCxTQUFLRCxPQUFMLEdBQWVBLE9BQWY7QUFDRDs7QUFFREcsRUFBQUEsVUFBVSxHQUFHO0FBQ1gsU0FBS0gsT0FBTCxHQUFlSSxNQUFNLENBQUNDLEtBQVAsQ0FBYSxLQUFLTCxPQUFMLENBQWFFLE1BQTFCLENBQWY7QUFDRDs7QUFkdUI7OztlQWdCWEosWSIsInNvdXJjZXNDb250ZW50IjpbIi8vIFRoaXMgY29kZSBpcyBiYXNlZCBvbiB0aGUgYG1zc3FsLWpkYmNgIGxpYnJhcnkgcHVibGlzaGVkIHVuZGVyIHRoZSBjb25kaXRpb25zIG9mIE1JVCBsaWNlbnNlLlxuLy8gQ29weXJpZ2h0IChjKSAyMDE5IE1pY3Jvc29mdCBDb3Jwb3JhdGlvblxuXG5leHBvcnQgY2xhc3MgU3ltbWV0cmljS2V5IHtcbiAgcm9vdEtleTogQnVmZmVyO1xuXG4gIGNvbnN0cnVjdG9yKHJvb3RLZXk6IEJ1ZmZlcikge1xuICAgIGlmICghcm9vdEtleSkge1xuICAgICAgdGhyb3cgbmV3IEVycm9yKCdDb2x1bW4gZW5jcnlwdGlvbiBrZXkgY2Fubm90IGJlIG51bGwuJyk7XG4gICAgfSBlbHNlIGlmICgwID09PSByb290S2V5Lmxlbmd0aCkge1xuICAgICAgdGhyb3cgbmV3IEVycm9yKCdFbXB0eSBjb2x1bW4gZW5jcnlwdGlvbiBrZXkgc3BlY2lmaWVkLicpO1xuICAgIH1cbiAgICB0aGlzLnJvb3RLZXkgPSByb290S2V5O1xuICB9XG5cbiAgemVyb091dEtleSgpIHtcbiAgICB0aGlzLnJvb3RLZXkgPSBCdWZmZXIuYWxsb2ModGhpcy5yb290S2V5Lmxlbmd0aCk7XG4gIH1cbn1cbmV4cG9ydCBkZWZhdWx0IFN5bW1ldHJpY0tleTtcbiJdfQ==