"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.typeByName = exports.TYPES = exports.TYPE = void 0;

var _null = _interopRequireDefault(require("./data-types/null"));

var _tinyint = _interopRequireDefault(require("./data-types/tinyint"));

var _bit = _interopRequireDefault(require("./data-types/bit"));

var _smallint = _interopRequireDefault(require("./data-types/smallint"));

var _int = _interopRequireDefault(require("./data-types/int"));

var _smalldatetime = _interopRequireDefault(require("./data-types/smalldatetime"));

var _real = _interopRequireDefault(require("./data-types/real"));

var _money = _interopRequireDefault(require("./data-types/money"));

var _datetime = _interopRequireDefault(require("./data-types/datetime"));

var _float = _interopRequireDefault(require("./data-types/float"));

var _decimal = _interopRequireDefault(require("./data-types/decimal"));

var _numeric = _interopRequireDefault(require("./data-types/numeric"));

var _smallmoney = _interopRequireDefault(require("./data-types/smallmoney"));

var _bigint = _interopRequireDefault(require("./data-types/bigint"));

var _image = _interopRequireDefault(require("./data-types/image"));

var _text = _interopRequireDefault(require("./data-types/text"));

var _uniqueidentifier = _interopRequireDefault(require("./data-types/uniqueidentifier"));

var _intn = _interopRequireDefault(require("./data-types/intn"));

var _ntext = _interopRequireDefault(require("./data-types/ntext"));

var _bitn = _interopRequireDefault(require("./data-types/bitn"));

var _decimaln = _interopRequireDefault(require("./data-types/decimaln"));

var _numericn = _interopRequireDefault(require("./data-types/numericn"));

var _floatn = _interopRequireDefault(require("./data-types/floatn"));

var _moneyn = _interopRequireDefault(require("./data-types/moneyn"));

var _datetimen = _interopRequireDefault(require("./data-types/datetimen"));

var _varbinary = _interopRequireDefault(require("./data-types/varbinary"));

var _varchar = _interopRequireDefault(require("./data-types/varchar"));

var _binary = _interopRequireDefault(require("./data-types/binary"));

var _char = _interopRequireDefault(require("./data-types/char"));

var _nvarchar = _interopRequireDefault(require("./data-types/nvarchar"));

var _nchar = _interopRequireDefault(require("./data-types/nchar"));

var _xml = _interopRequireDefault(require("./data-types/xml"));

var _time = _interopRequireDefault(require("./data-types/time"));

var _date = _interopRequireDefault(require("./data-types/date"));

var _datetime2 = _interopRequireDefault(require("./data-types/datetime2"));

var _datetimeoffset = _interopRequireDefault(require("./data-types/datetimeoffset"));

var _udt = _interopRequireDefault(require("./data-types/udt"));

var _tvp = _interopRequireDefault(require("./data-types/tvp"));

var _sqlVariant = _interopRequireDefault(require("./data-types/sql-variant"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const TYPE = {
  [_null.default.id]: _null.default,
  [_tinyint.default.id]: _tinyint.default,
  [_bit.default.id]: _bit.default,
  [_smallint.default.id]: _smallint.default,
  [_int.default.id]: _int.default,
  [_smalldatetime.default.id]: _smalldatetime.default,
  [_real.default.id]: _real.default,
  [_money.default.id]: _money.default,
  [_datetime.default.id]: _datetime.default,
  [_float.default.id]: _float.default,
  [_decimal.default.id]: _decimal.default,
  [_numeric.default.id]: _numeric.default,
  [_smallmoney.default.id]: _smallmoney.default,
  [_bigint.default.id]: _bigint.default,
  [_image.default.id]: _image.default,
  [_text.default.id]: _text.default,
  [_uniqueidentifier.default.id]: _uniqueidentifier.default,
  [_intn.default.id]: _intn.default,
  [_ntext.default.id]: _ntext.default,
  [_bitn.default.id]: _bitn.default,
  [_decimaln.default.id]: _decimaln.default,
  [_numericn.default.id]: _numericn.default,
  [_floatn.default.id]: _floatn.default,
  [_moneyn.default.id]: _moneyn.default,
  [_datetimen.default.id]: _datetimen.default,
  [_varbinary.default.id]: _varbinary.default,
  [_varchar.default.id]: _varchar.default,
  [_binary.default.id]: _binary.default,
  [_char.default.id]: _char.default,
  [_nvarchar.default.id]: _nvarchar.default,
  [_nchar.default.id]: _nchar.default,
  [_xml.default.id]: _xml.default,
  [_time.default.id]: _time.default,
  [_date.default.id]: _date.default,
  [_datetime2.default.id]: _datetime2.default,
  [_datetimeoffset.default.id]: _datetimeoffset.default,
  [_udt.default.id]: _udt.default,
  [_tvp.default.id]: _tvp.default,
  [_sqlVariant.default.id]: _sqlVariant.default
};
/**
 * <table>
 * <thead>
 *   <tr>
 *     <th>Type</th>
 *     <th>Constant</th>
 *     <th>JavaScript</th>
 *     <th>Result set</th>
 *     <th>Parameter</th>
 *   </tr>
 * </thead>
 *
 * <tbody>
 *   <tr class="group-heading">
 *     <th colspan="5">Exact numerics</th>
 *   </tr>
 *   <tr>
 *     <td><code>bit</code></td>
 *     <td><code>[[TYPES.Bit]]</code></td>
 *     <td><code>boolean</code></td>
 *     <td>✓</td>
 *     <td>✓</td>
 *   </tr>
 *   <tr>
 *     <td><code>tinyint</code></td>
 *     <td><code>[[TYPES.TinyInt]]</code></td>
 *     <td><code>number</code></td>
 *     <td>✓</td>
 *     <td>✓</td>
 *   </tr>
 *   <tr>
 *     <td><code>smallint</code></td>
 *     <td><code>[[TYPES.SmallInt]]</code></td>
 *     <td><code>number</code></td>
 *     <td>✓</td>
 *     <td>✓</td>
 *   </tr>
 *   <tr>
 *     <td><code>int</code></td>
 *     <td><code>[[TYPES.Int]]</code></td>
 *     <td><code>number</code></td>
 *     <td>✓</td>
 *     <td>✓</td>
 *   </tr>
 *   <tr>
 *     <td><code>bigint</code><sup>1</sup></td>
 *     <td><code>[[TYPES.BigInt]]</code></td>
 *     <td><code>string</code></td>
 *     <td>✓</td>
 *     <td>✓</td>
 *   </tr>
 *   <tr>
 *     <td><code>numeric</code><sup>2</sup></td>
 *     <td><code>[[TYPES.Numeric]]</code></td>
 *     <td><code>number</code></td>
 *     <td>✓</td>
 *     <td>✓</td>
 *   </tr>
 *   <tr>
 *     <td><code>decimal</code><sup>2</sup></td>
 *     <td><code>[[TYPES.Decimal]]</code></td>
 *     <td><code>number</code></td>
 *     <td>✓</td>
 *     <td>✓</td>
 *   </tr>
 *   <tr>
 *     <td><code>smallmoney</code></td>
 *     <td><code>[[TYPES.SmallMoney]]</code></td>
 *     <td><code>number</code></td>
 *     <td>✓</td>
 *     <td>✓</td>
 *   </tr>
 *   <tr>
 *     <td><code>money</code></td>
 *     <td><code>[[TYPES.Money]]</code></td>
 *     <td><code>number</code></td>
 *     <td>✓</td>
 *     <td>✓</td>
 *   </tr>
 * </tbody>
 *
 * <tbody>
 *   <tr class="group-heading">
 *     <th colspan="5">Approximate numerics</th>
 *   </tr>
 *   <tr>
 *     <td><code>float</code></td>
 *     <td><code>[[TYPES.Float]]</code></td>
 *     <td><code>number</code></td>
 *     <td>✓</td>
 *     <td>✓</td>
 *   </tr>
 *   <tr>
 *     <td><code>real</code></td>
 *     <td><code>[[TYPES.Real]]</code></td>
 *     <td><code>number</code></td>
 *     <td>✓</td>
 *     <td>✓</td>
 *   </tr>
 * </tbody>
 *
 * <tbody>
 *   <tr class="group-heading">
 *     <th colspan="4">Date and Time</th>
 *   </tr>
 *   <tr>
 *     <td><code>smalldatetime</code></td>
 *     <td><code>[[TYPES.SmallDateTime]]</code></td>
 *     <td><code>Date</code></td>
 *     <td>✓</td>
 *     <td>✓</td>
 *   </tr>
 *   <tr>
 *     <td><code>datetime</code></td>
 *     <td><code>[[TYPES.DateTime]]</code></td>
 *     <td><code>Date</code></td>
 *     <td>✓</td>
 *     <td>✓</td>
 *   </tr>
 *   <tr>
 *     <td><code>datetime2</code></td>
 *     <td><code>[[TYPES.DateTime2]]</code></td>
 *     <td><code>Date</code></td>
 *     <td>✓</td>
 *     <td>✓</td>
 *   </tr>
 *   <tr>
 *     <td><code>datetimeoffset</code></td>
 *     <td><code>[[TYPES.DateTimeOffset]]</code></td>
 *     <td><code>Date</code></td>
 *     <td>✓</td>
 *     <td>✓</td>
 *   </tr>
 *   <tr>
 *     <td><code>time</code></td>
 *     <td><code>[[TYPES.Time]]</code></td>
 *     <td><code>Date</code></td>
 *     <td>✓</td>
 *     <td>✓</td>
 *   </tr>
 *   <tr>
 *     <td><code>date</code></td>
 *     <td><code>[[TYPES.Date]]</code></td>
 *     <td><code>Date</code></td>
 *     <td>✓</td>
 *     <td>✓</td>
 *   </tr>
 * </tbody>
 *
 * <tbody>
 *   <tr class="group-heading">
 *     <th colspan="4">Character Strings</th>
 *   </tr>
 *   <tr>
 *     <td><code>char</code></td>
 *     <td><code>[[TYPES.Char]]</code></td>
 *     <td><code>string</code></td>
 *     <td>✓</td>
 *     <td>✓</td>
 *   </tr>
 *   <tr>
 *     <td><code>varchar</code><sup>3</sup></td>
 *     <td><code>[[TYPES.VarChar]]</code></td>
 *     <td><code>string</code></td>
 *     <td>✓</td>
 *     <td>✓</td>
 *   </tr>
 *   <tr>
 *     <td><code>text</code></td>
 *     <td><code>[[TYPES.Text]]</code></td>
 *     <td><code>string</code></td>
 *     <td>✓</td>
 *     <td>✓</td>
 *   </tr>
 * </tbody>
 *
 * <tbody>
 *   <tr class="group-heading">
 *     <th colspan="4">Unicode Strings</th>
 *   </tr>
 *   <tr>
 *     <td><code>nchar</code></td>
 *     <td><code>[[TYPES.NChar]]</code></td>
 *     <td><code>string</code></td>
 *     <td>✓</td>
 *     <td>✓</td>
 *   </tr>
 *   <tr>
 *     <td><code>nvarchar</code><sup>3</sup></td>
 *     <td><code>[[TYPES.NVarChar]]</code></td>
 *     <td><code>string</code></td>
 *     <td>✓</td>
 *     <td>✓</td>
 *   </tr>
 *   <tr>
 *     <td><code>ntext</code></td>
 *     <td><code>[[TYPES.NText]]</code></td>
 *     <td><code>string</code></td>
 *     <td>✓</td>
 *     <td>-</td>
 *   </tr>
 * </tbody>
 *
 * <tbody>
 *   <tr class="group-heading">
 *     <th colspan="5">Binary Strings<sup>4</sup></th>
 *   </tr>
 *   <tr>
 *     <td><code>binary</code></td>
 *     <td><code>[[TYPES.Binary]]</code></td>
 *     <td><code>Buffer</code></td>
 *     <td>✓</td>
 *     <td>✓</td>
 *   </tr>
 *   <tr>
 *     <td><code>varbinary</code></td>
 *     <td><code>[[TYPES.VarBinary]]</code></td>
 *     <td><code>Buffer</code></td>
 *     <td>✓</td>
 *     <td>✓</td>
 *   </tr>
 *   <tr>
 *     <td><code>image</code></td>
 *     <td><code>[[TYPES.Image]]</code></td>
 *     <td><code>Buffer</code></td>
 *     <td>✓</td>
 *     <td>✓</td>
 *   </tr>
 * </tbody>
 *
 * <tbody>
 *   <tr class="group-heading">
 *     <th colspan="5">Other Data Types</th>
 *   </tr>
 *   <tr>
 *     <td><code>TVP</code></td>
 *     <td><code>[[TYPES.TVP]]</code></td>
 *     <td><code>Object</code></td>
 *     <td>-</td>
 *     <td>✓</td>
 *   </tr>
 *   <tr>
 *     <td><code>UDT</code></td>
 *     <td><code>[[TYPES.UDT]]</code></td>
 *     <td><code>Buffer</code></td>
 *     <td>✓</td>
 *     <td>-</td>
 *   </tr>
 *   <tr>
 *     <td><code>uniqueidentifier</code><sup>4</sup></td>
 *     <td><code>[[TYPES.UniqueIdentifier]]</code></td>
 *     <td><code>string</code></td>
 *     <td>✓</td>
 *     <td>✓</td>
 *   </tr>
 *   <tr>
 *     <td><code>variant</code></td>
 *     <td><code>[[TYPES.Variant]]</code></td>
 *     <td><code>any</code></td>
 *     <td>✓</td>
 *     <td>-</td>
 *   </tr>
 *   <tr>
 *     <td><code>xml</code></td>
 *     <td><code>[[TYPES.Xml]]</code></td>
 *     <td><code>string</code></td>
 *     <td>✓</td>
 *     <td>-</td>
 *   </tr>
 * </tbody>
 * </table>
 *
 * <ol>
 *   <li>
 *     <h4>BigInt</h4>
 *     <p>
 *       Values are returned as a string. This is because values can exceed 53 bits of significant data, which is greater than a
 *       Javascript <code>number</code> type can represent as an integer.
 *     </p>
 *   </li>
 *   <li>
 *     <h4>Numerical, Decimal</h4>
 *     <p>
 *       For input parameters, default precision is 18 and default scale is 0. Maximum supported precision is 19.
 *     </p>
 *   </li>
 *   <li>
 *     <h4>VarChar, NVarChar</h4>
 *     <p>
 *       <code>varchar(max)</code> and <code>nvarchar(max)</code> are also supported.
 *     </p>
 *   </li>
 *   <li>
 *     <h4>UniqueIdentifier</h4>
 *     <p>
 *       Values are returned as a 16 byte hexadecimal string.
 *     </p>
 *     <p>
 *       Note that the order of bytes is not the same as the character representation. See
 *       <a href="http://msdn.microsoft.com/en-us/library/ms190215.aspx">Using uniqueidentifier Data</a>
 *       for an example of the different ordering of bytes.
 *     </p>
 *   </li>
 * </ol>
 */

exports.TYPE = TYPE;
const TYPES = {
  TinyInt: _tinyint.default,
  Bit: _bit.default,
  SmallInt: _smallint.default,
  Int: _int.default,
  SmallDateTime: _smalldatetime.default,
  Real: _real.default,
  Money: _money.default,
  DateTime: _datetime.default,
  Float: _float.default,
  Decimal: _decimal.default,
  Numeric: _numeric.default,
  SmallMoney: _smallmoney.default,
  BigInt: _bigint.default,
  Image: _image.default,
  Text: _text.default,
  UniqueIdentifier: _uniqueidentifier.default,
  NText: _ntext.default,
  VarBinary: _varbinary.default,
  VarChar: _varchar.default,
  Binary: _binary.default,
  Char: _char.default,
  NVarChar: _nvarchar.default,
  NChar: _nchar.default,
  Xml: _xml.default,
  Time: _time.default,
  Date: _date.default,
  DateTime2: _datetime2.default,
  DateTimeOffset: _datetimeoffset.default,
  UDT: _udt.default,
  TVP: _tvp.default,
  Variant: _sqlVariant.default
};
exports.TYPES = TYPES;
const typeByName = TYPES;
exports.typeByName = typeByName;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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