"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _bitn = _interopRequireDefault(require("./bitn"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const DATA_LENGTH = Buffer.from([0x01]);
const NULL_LENGTH = Buffer.from([0x00]);
const Bit = {
  id: 0x32,
  type: 'BIT',
  name: 'Bit',
  declaration: function () {
    return 'bit';
  },

  generateTypeInfo() {
    return Buffer.from([_bitn.default.id, 0x01]);
  },

  generateParameterLength(parameter, options) {
    if (parameter.value == null) {
      return NULL_LENGTH;
    }

    return DATA_LENGTH;
  },

  *generateParameterData(parameter, options) {
    if (parameter.value == null) {
      return;
    }

    yield parameter.value ? Buffer.from([0x01]) : Buffer.from([0x00]);
  },

  validate: function (value) {
    if (value == null) {
      return null;
    }

    if (value) {
      return true;
    } else {
      return false;
    }
  }
};
var _default = Bit;
exports.default = _default;
module.exports = Bit;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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