"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _iconvLite = _interopRequireDefault(require("iconv-lite"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const NULL_LENGTH = Buffer.from([0xFF, 0xFF]);
const Char = {
  id: 0xAF,
  type: 'BIGCHAR',
  name: 'Char',
  maximumLength: 8000,
  declaration: function (parameter) {
    const value = parameter.value;
    let length;

    if (parameter.length) {
      length = parameter.length;
    } else if (value != null) {
      length = value.length || 1;
    } else if (value === null && !parameter.output) {
      length = 1;
    } else {
      length = this.maximumLength;
    }

    if (length < this.maximumLength) {
      return 'char(' + length + ')';
    } else {
      return 'char(' + this.maximumLength + ')';
    }
  },
  // ParameterData<any> is temporary solution. TODO: need to understand what type ParameterData<...> can be.
  resolveLength: function (parameter) {
    const value = parameter.value;

    if (parameter.length != null) {
      return parameter.length;
    } else if (value != null) {
      return value.length || 1;
    } else {
      return this.maximumLength;
    }
  },

  generateTypeInfo(parameter) {
    const buffer = Buffer.alloc(8);
    buffer.writeUInt8(this.id, 0);
    buffer.writeUInt16LE(parameter.length, 1);

    if (parameter.collation) {
      parameter.collation.toBuffer().copy(buffer, 3, 0, 5);
    }

    return buffer;
  },

  generateParameterLength(parameter, options) {
    const value = parameter.value;

    if (value == null) {
      return NULL_LENGTH;
    }

    const buffer = Buffer.alloc(2);
    buffer.writeUInt16LE(value.length, 0);
    return buffer;
  },

  *generateParameterData(parameter, options) {
    if (parameter.value == null) {
      return;
    }

    yield Buffer.from(parameter.value, 'ascii');
  },

  validate: function (value, collation) {
    if (value == null) {
      return null;
    }

    if (typeof value !== 'string') {
      throw new TypeError('Invalid string.');
    }

    if (!collation) {
      throw new Error('No collation was set by the server for the current connection.');
    }

    if (!collation.codepage) {
      throw new Error('The collation set by the server has no associated encoding.');
    }

    return _iconvLite.default.encode(value, collation.codepage);
  }
};
var _default = Char;
exports.default = _default;
module.exports = Char;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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