"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _datetimen = _interopRequireDefault(require("./datetimen"));

var _core = require("@js-joda/core");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const EPOCH_DATE = _core.LocalDate.ofYearDay(1900, 1);

const NULL_LENGTH = Buffer.from([0x00]);
const DATA_LENGTH = Buffer.from([0x08]);
const DateTime = {
  id: 0x3D,
  type: 'DATETIME',
  name: 'DateTime',
  declaration: function () {
    return 'datetime';
  },

  generateTypeInfo() {
    return Buffer.from([_datetimen.default.id, 0x08]);
  },

  generateParameterLength(parameter, options) {
    if (parameter.value == null) {
      return NULL_LENGTH;
    }

    return DATA_LENGTH;
  },

  generateParameterData: function* (parameter, options) {
    if (parameter.value == null) {
      return;
    }

    const value = parameter.value; // Temporary solution. Remove 'any' later.

    let date;

    if (options.useUTC) {
      date = _core.LocalDate.of(value.getUTCFullYear(), value.getUTCMonth() + 1, value.getUTCDate());
    } else {
      date = _core.LocalDate.of(value.getFullYear(), value.getMonth() + 1, value.getDate());
    }

    let days = EPOCH_DATE.until(date, _core.ChronoUnit.DAYS);
    let milliseconds, threeHundredthsOfSecond;

    if (options.useUTC) {
      let seconds = value.getUTCHours() * 60 * 60;
      seconds += value.getUTCMinutes() * 60;
      seconds += value.getUTCSeconds();
      milliseconds = seconds * 1000 + value.getUTCMilliseconds();
    } else {
      let seconds = value.getHours() * 60 * 60;
      seconds += value.getMinutes() * 60;
      seconds += value.getSeconds();
      milliseconds = seconds * 1000 + value.getMilliseconds();
    }

    threeHundredthsOfSecond = milliseconds / (3 + 1 / 3);
    threeHundredthsOfSecond = Math.round(threeHundredthsOfSecond); // 25920000 equals one day

    if (threeHundredthsOfSecond === 25920000) {
      days += 1;
      threeHundredthsOfSecond = 0;
    }

    const buffer = Buffer.alloc(8);
    buffer.writeInt32LE(days, 0);
    buffer.writeUInt32LE(threeHundredthsOfSecond, 4);
    yield buffer;
  },
  // TODO: type 'any' needs to be revisited.
  validate: function (value) {
    if (value == null) {
      return null;
    }

    if (!(value instanceof Date)) {
      value = new Date(Date.parse(value));
    }

    if (isNaN(value)) {
      throw new TypeError('Invalid date.');
    }

    return value;
  }
};
var _default = DateTime;
exports.default = _default;
module.exports = DateTime;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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