"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _moneyn = _interopRequireDefault(require("./moneyn"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const DATA_LENGTH = Buffer.from([0x04]);
const NULL_LENGTH = Buffer.from([0x00]);
const SmallMoney = {
  id: 0x7A,
  type: 'MONEY4',
  name: 'SmallMoney',
  declaration: function () {
    return 'smallmoney';
  },
  generateTypeInfo: function () {
    return Buffer.from([_moneyn.default.id, 0x04]);
  },

  generateParameterLength(parameter, options) {
    if (parameter.value == null) {
      return NULL_LENGTH;
    }

    return DATA_LENGTH;
  },

  *generateParameterData(parameter, options) {
    if (parameter.value == null) {
      return;
    }

    const buffer = Buffer.alloc(4);
    buffer.writeInt32LE(parameter.value * 10000, 0);
    yield buffer;
  },

  validate: function (value) {
    if (value == null) {
      return null;
    }

    value = parseFloat(value);

    if (isNaN(value)) {
      throw new TypeError('Invalid number.');
    }

    if (value < -214748.3648 || value > 214748.3647) {
      throw new TypeError('Value must be between -214748.3648 and 214748.3647.');
    }

    return value;
  }
};
var _default = SmallMoney;
exports.default = _default;
module.exports = SmallMoney;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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