"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _writableTrackingBuffer = _interopRequireDefault(require("../tracking-buffer/writable-tracking-buffer"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const NULL_LENGTH = Buffer.from([0x00]);
const Time = {
  id: 0x29,
  type: 'TIMEN',
  name: 'Time',
  declaration: function (parameter) {
    return 'time(' + this.resolveScale(parameter) + ')';
  },
  resolveScale: function (parameter) {
    if (parameter.scale != null) {
      return parameter.scale;
    } else if (parameter.value === null) {
      return 0;
    } else {
      return 7;
    }
  },

  generateTypeInfo(parameter) {
    return Buffer.from([this.id, parameter.scale]);
  },

  generateParameterLength(parameter, options) {
    if (parameter.value == null) {
      return NULL_LENGTH;
    }

    switch (parameter.scale) {
      case 0:
      case 1:
      case 2:
        return Buffer.from([0x03]);

      case 3:
      case 4:
        return Buffer.from([0x04]);

      case 5:
      case 6:
      case 7:
        return Buffer.from([0x05]);

      default:
        throw new Error('invalid scale');
    }
  },

  *generateParameterData(parameter, options) {
    if (parameter.value == null) {
      return;
    }

    const buffer = new _writableTrackingBuffer.default(16);
    const time = parameter.value;
    let timestamp;

    if (options.useUTC) {
      timestamp = ((time.getUTCHours() * 60 + time.getUTCMinutes()) * 60 + time.getUTCSeconds()) * 1000 + time.getUTCMilliseconds();
    } else {
      timestamp = ((time.getHours() * 60 + time.getMinutes()) * 60 + time.getSeconds()) * 1000 + time.getMilliseconds();
    }

    timestamp = timestamp * Math.pow(10, parameter.scale - 3);
    timestamp += (parameter.value.nanosecondDelta != null ? parameter.value.nanosecondDelta : 0) * Math.pow(10, parameter.scale);
    timestamp = Math.round(timestamp);

    switch (parameter.scale) {
      case 0:
      case 1:
      case 2:
        buffer.writeUInt24LE(timestamp);
        break;

      case 3:
      case 4:
        buffer.writeUInt32LE(timestamp);
        break;

      case 5:
      case 6:
      case 7:
        buffer.writeUInt40LE(timestamp);
    }

    yield buffer.data;
  },

  validate: function (value) {
    if (value == null) {
      return null;
    }

    if (!(value instanceof Date)) {
      value = new Date(Date.parse(value));
    }

    if (isNaN(value)) {
      throw new TypeError('Invalid time.');
    }

    return value;
  }
};
var _default = Time;
exports.default = _default;
module.exports = Time;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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