"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _intn = _interopRequireDefault(require("./intn"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const DATA_LENGTH = Buffer.from([0x01]);
const NULL_LENGTH = Buffer.from([0x00]);
const TinyInt = {
  id: 0x30,
  type: 'INT1',
  name: 'TinyInt',
  declaration: function () {
    return 'tinyint';
  },

  generateTypeInfo() {
    return Buffer.from([_intn.default.id, 0x01]);
  },

  generateParameterLength(parameter, options) {
    if (parameter.value == null) {
      return NULL_LENGTH;
    }

    return DATA_LENGTH;
  },

  *generateParameterData(parameter, options) {
    if (parameter.value == null) {
      return;
    }

    const buffer = Buffer.alloc(1);
    buffer.writeUInt8(Number(parameter.value), 0);
    yield buffer;
  },

  validate: function (value) {
    if (value == null) {
      return null;
    }

    if (typeof value !== 'number') {
      value = Number(value);
    }

    if (isNaN(value)) {
      throw new TypeError('Invalid number.');
    }

    if (value < 0 || value > 255) {
      throw new TypeError('Value must be between 0 and 255, inclusive.');
    }

    return value | 0;
  }
};
var _default = TinyInt;
exports.default = _default;
module.exports = TinyInt;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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