"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.bufferToUpperCaseGuid = bufferToUpperCaseGuid;
exports.bufferToLowerCaseGuid = bufferToLowerCaseGuid;
exports.guidToArray = guidToArray;
const UPPER_CASE_MAP = ['00', '01', '02', '03', '04', '05', '06', '07', '08', '09', '0A', '0B', '0C', '0D', '0E', '0F', '10', '11', '12', '13', '14', '15', '16', '17', '18', '19', '1A', '1B', '1C', '1D', '1E', '1F', '20', '21', '22', '23', '24', '25', '26', '27', '28', '29', '2A', '2B', '2C', '2D', '2E', '2F', '30', '31', '32', '33', '34', '35', '36', '37', '38', '39', '3A', '3B', '3C', '3D', '3E', '3F', '40', '41', '42', '43', '44', '45', '46', '47', '48', '49', '4A', '4B', '4C', '4D', '4E', '4F', '50', '51', '52', '53', '54', '55', '56', '57', '58', '59', '5A', '5B', '5C', '5D', '5E', '5F', '60', '61', '62', '63', '64', '65', '66', '67', '68', '69', '6A', '6B', '6C', '6D', '6E', '6F', '70', '71', '72', '73', '74', '75', '76', '77', '78', '79', '7A', '7B', '7C', '7D', '7E', '7F', '80', '81', '82', '83', '84', '85', '86', '87', '88', '89', '8A', '8B', '8C', '8D', '8E', '8F', '90', '91', '92', '93', '94', '95', '96', '97', '98', '99', '9A', '9B', '9C', '9D', '9E', '9F', 'A0', 'A1', 'A2', 'A3', 'A4', 'A5', 'A6', 'A7', 'A8', 'A9', 'AA', 'AB', 'AC', 'AD', 'AE', 'AF', 'B0', 'B1', 'B2', 'B3', 'B4', 'B5', 'B6', 'B7', 'B8', 'B9', 'BA', 'BB', 'BC', 'BD', 'BE', 'BF', 'C0', 'C1', 'C2', 'C3', 'C4', 'C5', 'C6', 'C7', 'C8', 'C9', 'CA', 'CB', 'CC', 'CD', 'CE', 'CF', 'D0', 'D1', 'D2', 'D3', 'D4', 'D5', 'D6', 'D7', 'D8', 'D9', 'DA', 'DB', 'DC', 'DD', 'DE', 'DF', 'E0', 'E1', 'E2', 'E3', 'E4', 'E5', 'E6', 'E7', 'E8', 'E9', 'EA', 'EB', 'EC', 'ED', 'EE', 'EF', 'F0', 'F1', 'F2', 'F3', 'F4', 'F5', 'F6', 'F7', 'F8', 'F9', 'FA', 'FB', 'FC', 'FD', 'FE', 'FF'];
const LOWER_CASE_MAP = ['00', '01', '02', '03', '04', '05', '06', '07', '08', '09', '0a', '0b', '0c', '0d', '0e', '0f', '10', '11', '12', '13', '14', '15', '16', '17', '18', '19', '1a', '1b', '1c', '1d', '1e', '1f', '20', '21', '22', '23', '24', '25', '26', '27', '28', '29', '2a', '2b', '2c', '2d', '2e', '2f', '30', '31', '32', '33', '34', '35', '36', '37', '38', '39', '3a', '3b', '3c', '3d', '3e', '3f', '40', '41', '42', '43', '44', '45', '46', '47', '48', '49', '4a', '4b', '4c', '4d', '4e', '4f', '50', '51', '52', '53', '54', '55', '56', '57', '58', '59', '5a', '5b', '5c', '5d', '5e', '5f', '60', '61', '62', '63', '64', '65', '66', '67', '68', '69', '6a', '6b', '6c', '6d', '6e', '6f', '70', '71', '72', '73', '74', '75', '76', '77', '78', '79', '7a', '7b', '7c', '7d', '7e', '7f', '80', '81', '82', '83', '84', '85', '86', '87', '88', '89', '8a', '8b', '8c', '8d', '8e', '8f', '90', '91', '92', '93', '94', '95', '96', '97', '98', '99', '9a', '9b', '9c', '9d', '9e', '9f', 'a0', 'a1', 'a2', 'a3', 'a4', 'a5', 'a6', 'a7', 'a8', 'a9', 'aa', 'ab', 'ac', 'ad', 'ae', 'af', 'b0', 'b1', 'b2', 'b3', 'b4', 'b5', 'b6', 'b7', 'b8', 'b9', 'ba', 'bb', 'bc', 'bd', 'be', 'bf', 'c0', 'c1', 'c2', 'c3', 'c4', 'c5', 'c6', 'c7', 'c8', 'c9', 'ca', 'cb', 'cc', 'cd', 'ce', 'cf', 'd0', 'd1', 'd2', 'd3', 'd4', 'd5', 'd6', 'd7', 'd8', 'd9', 'da', 'db', 'dc', 'dd', 'de', 'df', 'e0', 'e1', 'e2', 'e3', 'e4', 'e5', 'e6', 'e7', 'e8', 'e9', 'ea', 'eb', 'ec', 'ed', 'ee', 'ef', 'f0', 'f1', 'f2', 'f3', 'f4', 'f5', 'f6', 'f7', 'f8', 'f9', 'fa', 'fb', 'fc', 'fd', 'fe', 'ff'];

function bufferToUpperCaseGuid(buffer) {
  return UPPER_CASE_MAP[buffer[3]] + UPPER_CASE_MAP[buffer[2]] + UPPER_CASE_MAP[buffer[1]] + UPPER_CASE_MAP[buffer[0]] + '-' + UPPER_CASE_MAP[buffer[5]] + UPPER_CASE_MAP[buffer[4]] + '-' + UPPER_CASE_MAP[buffer[7]] + UPPER_CASE_MAP[buffer[6]] + '-' + UPPER_CASE_MAP[buffer[8]] + UPPER_CASE_MAP[buffer[9]] + '-' + UPPER_CASE_MAP[buffer[10]] + UPPER_CASE_MAP[buffer[11]] + UPPER_CASE_MAP[buffer[12]] + UPPER_CASE_MAP[buffer[13]] + UPPER_CASE_MAP[buffer[14]] + UPPER_CASE_MAP[buffer[15]];
}

function bufferToLowerCaseGuid(buffer) {
  return LOWER_CASE_MAP[buffer[3]] + LOWER_CASE_MAP[buffer[2]] + LOWER_CASE_MAP[buffer[1]] + LOWER_CASE_MAP[buffer[0]] + '-' + LOWER_CASE_MAP[buffer[5]] + LOWER_CASE_MAP[buffer[4]] + '-' + LOWER_CASE_MAP[buffer[7]] + LOWER_CASE_MAP[buffer[6]] + '-' + LOWER_CASE_MAP[buffer[8]] + LOWER_CASE_MAP[buffer[9]] + '-' + LOWER_CASE_MAP[buffer[10]] + LOWER_CASE_MAP[buffer[11]] + LOWER_CASE_MAP[buffer[12]] + LOWER_CASE_MAP[buffer[13]] + LOWER_CASE_MAP[buffer[14]] + LOWER_CASE_MAP[buffer[15]];
}

const CHARCODEMAP = {};
const hexDigits = ['0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'A', 'B', 'C', 'D', 'E', 'F'].map(d => d.charCodeAt(0));

for (let i = 0; i < hexDigits.length; i++) {
  const map = CHARCODEMAP[hexDigits[i]] = {};

  for (let j = 0; j < hexDigits.length; j++) {
    const hex = String.fromCharCode(hexDigits[i], hexDigits[j]);
    const value = parseInt(hex, 16);
    map[hexDigits[j]] = value;
  }
}

function guidToArray(guid) {
  return [CHARCODEMAP[guid.charCodeAt(6)][guid.charCodeAt(7)], CHARCODEMAP[guid.charCodeAt(4)][guid.charCodeAt(5)], CHARCODEMAP[guid.charCodeAt(2)][guid.charCodeAt(3)], CHARCODEMAP[guid.charCodeAt(0)][guid.charCodeAt(1)], CHARCODEMAP[guid.charCodeAt(11)][guid.charCodeAt(12)], CHARCODEMAP[guid.charCodeAt(9)][guid.charCodeAt(10)], CHARCODEMAP[guid.charCodeAt(16)][guid.charCodeAt(17)], CHARCODEMAP[guid.charCodeAt(14)][guid.charCodeAt(15)], CHARCODEMAP[guid.charCodeAt(19)][guid.charCodeAt(20)], CHARCODEMAP[guid.charCodeAt(21)][guid.charCodeAt(22)], CHARCODEMAP[guid.charCodeAt(24)][guid.charCodeAt(25)], CHARCODEMAP[guid.charCodeAt(26)][guid.charCodeAt(27)], CHARCODEMAP[guid.charCodeAt(28)][guid.charCodeAt(29)], CHARCODEMAP[guid.charCodeAt(30)][guid.charCodeAt(31)], CHARCODEMAP[guid.charCodeAt(32)][guid.charCodeAt(33)], CHARCODEMAP[guid.charCodeAt(34)][guid.charCodeAt(35)]];
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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