"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _token = require("./token");

const FEATURE_ID = {
  SESSIONRECOVERY: 0x01,
  FEDAUTH: 0x02,
  COLUMNENCRYPTION: 0x04,
  GLOBALTRANSACTIONS: 0x05,
  AZURESQLSUPPORT: 0x08,
  UTF8_SUPPORT: 0x0A,
  TERMINATOR: 0xFF
};

function featureExtAckParser(parser, _options, callback) {
  let fedAuth;
  let utf8Support;

  function next() {
    parser.readUInt8(featureId => {
      if (featureId === FEATURE_ID.TERMINATOR) {
        return callback(new _token.FeatureExtAckToken(fedAuth, utf8Support));
      }

      parser.readUInt32LE(featureAckDataLen => {
        parser.readBuffer(featureAckDataLen, featureData => {
          switch (featureId) {
            case FEATURE_ID.FEDAUTH:
              fedAuth = featureData;
              break;

            case FEATURE_ID.UTF8_SUPPORT:
              utf8Support = !!featureData[0];
              break;
          }

          next();
        });
      });
    });
  }

  next();
}

var _default = featureExtAckParser;
exports.default = _default;
module.exports = featureExtAckParser;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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