"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _token = require("./token");

var _tdsVersions = require("../tds-versions");

const interfaceTypes = {
  0: 'SQL_DFLT',
  1: 'SQL_TSQL'
};

function loginAckParser(parser, _options, callback) {
  // length
  parser.readUInt16LE(() => {
    parser.readUInt8(interfaceNumber => {
      const interfaceType = interfaceTypes[interfaceNumber];
      parser.readUInt32BE(tdsVersionNumber => {
        const tdsVersion = _tdsVersions.versionsByValue[tdsVersionNumber];
        parser.readBVarChar(progName => {
          parser.readUInt8(major => {
            parser.readUInt8(minor => {
              parser.readUInt8(buildNumHi => {
                parser.readUInt8(buildNumLow => {
                  callback(new _token.LoginAckToken({
                    interface: interfaceType,
                    tdsVersion: tdsVersion,
                    progName: progName,
                    progVersion: {
                      major: major,
                      minor: minor,
                      buildNumHi: buildNumHi,
                      buildNumLow: buildNumLow
                    }
                  }));
                });
              });
            });
          });
        });
      });
    });
  });
}

var _default = loginAckParser;
exports.default = _default;
module.exports = loginAckParser;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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