"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _token = require("./token");

var _metadataParser = _interopRequireDefault(require("../metadata-parser"));

var _valueParser = _interopRequireDefault(require("../value-parser"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

// s2.2.7.16
function returnParser(parser, options, callback) {
  parser.readUInt16LE(paramOrdinal => {
    parser.readBVarChar(paramName => {
      if (paramName.charAt(0) === '@') {
        paramName = paramName.slice(1);
      } // status


      parser.readUInt8(() => {
        (0, _metadataParser.default)(parser, options, metadata => {
          (0, _valueParser.default)(parser, metadata, options, value => {
            callback(new _token.ReturnValueToken({
              paramOrdinal: paramOrdinal,
              paramName: paramName,
              metadata: metadata,
              value: value
            }));
          });
        });
      });
    });
  });
}

var _default = returnParser;
exports.default = _default;
module.exports = returnParser;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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