/*
 * Decompiled with CFR 0.152.
 */
package java.rmi.activation;

import java.rmi.MarshalledObject;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.activation.ActivationDesc;
import java.rmi.activation.ActivationException;
import java.rmi.activation.ActivationGroup;
import java.rmi.activation.ActivationID;
import java.rmi.activation.ActivationSystem;
import java.rmi.activation.UnknownGroupException;
import java.rmi.activation.UnknownObjectException;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.RemoteServer;
import sun.rmi.server.ActivatableRef;
import sun.rmi.server.ActivatableServerRef;
import sun.rmi.transport.ObjectTable;

public abstract class Activatable
extends RemoteServer {
    private ActivationID id;
    private static final long serialVersionUID = -3120617863591563455L;

    protected Activatable(String string, MarshalledObject<?> marshalledObject, boolean bl, int n) throws ActivationException, RemoteException {
        this.id = Activatable.exportObject((Remote)this, string, marshalledObject, bl, n);
    }

    protected Activatable(String string, MarshalledObject<?> marshalledObject, boolean bl, int n, RMIClientSocketFactory rMIClientSocketFactory, RMIServerSocketFactory rMIServerSocketFactory) throws ActivationException, RemoteException {
        this.id = Activatable.exportObject(this, string, marshalledObject, bl, n, rMIClientSocketFactory, rMIServerSocketFactory);
    }

    protected Activatable(ActivationID activationID, int n) throws RemoteException {
        this.id = activationID;
        Activatable.exportObject(this, activationID, n);
    }

    protected Activatable(ActivationID activationID, int n, RMIClientSocketFactory rMIClientSocketFactory, RMIServerSocketFactory rMIServerSocketFactory) throws RemoteException {
        this.id = activationID;
        Activatable.exportObject((Remote)this, activationID, n, rMIClientSocketFactory, rMIServerSocketFactory);
    }

    protected ActivationID getID() {
        return this.id;
    }

    public static Remote register(ActivationDesc activationDesc) throws UnknownGroupException, ActivationException, RemoteException {
        ActivationID activationID = ActivationGroup.getSystem().registerObject(activationDesc);
        return ActivatableRef.getStub((ActivationDesc)activationDesc, (ActivationID)activationID);
    }

    public static boolean inactive(ActivationID activationID) throws UnknownObjectException, ActivationException, RemoteException {
        return ActivationGroup.currentGroup().inactiveObject(activationID);
    }

    public static void unregister(ActivationID activationID) throws UnknownObjectException, ActivationException, RemoteException {
        ActivationGroup.getSystem().unregisterObject(activationID);
    }

    public static ActivationID exportObject(Remote remote, String string, MarshalledObject<?> marshalledObject, boolean bl, int n) throws ActivationException, RemoteException {
        return Activatable.exportObject(remote, string, marshalledObject, bl, n, null, null);
    }

    public static ActivationID exportObject(Remote remote, String string, MarshalledObject<?> marshalledObject, boolean bl, int n, RMIClientSocketFactory rMIClientSocketFactory, RMIServerSocketFactory rMIServerSocketFactory) throws ActivationException, RemoteException {
        ActivationDesc activationDesc = new ActivationDesc(remote.getClass().getName(), string, marshalledObject, bl);
        ActivationSystem activationSystem = ActivationGroup.getSystem();
        ActivationID activationID = activationSystem.registerObject(activationDesc);
        try {
            Activatable.exportObject(remote, activationID, n, rMIClientSocketFactory, rMIServerSocketFactory);
        }
        catch (RemoteException remoteException) {
            try {
                activationSystem.unregisterObject(activationID);
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw remoteException;
        }
        ActivationGroup.currentGroup().activeObject(activationID, remote);
        return activationID;
    }

    public static Remote exportObject(Remote remote, ActivationID activationID, int n) throws RemoteException {
        return Activatable.exportObject(remote, new ActivatableServerRef(activationID, n));
    }

    public static Remote exportObject(Remote remote, ActivationID activationID, int n, RMIClientSocketFactory rMIClientSocketFactory, RMIServerSocketFactory rMIServerSocketFactory) throws RemoteException {
        return Activatable.exportObject(remote, new ActivatableServerRef(activationID, n, rMIClientSocketFactory, rMIServerSocketFactory));
    }

    public static boolean unexportObject(Remote remote, boolean bl) throws NoSuchObjectException {
        return ObjectTable.unexportObject(remote, bl);
    }

    private static Remote exportObject(Remote remote, ActivatableServerRef activatableServerRef) throws RemoteException {
        if (remote instanceof Activatable) {
            ((Activatable)remote).ref = activatableServerRef;
        }
        return activatableServerRef.exportObject(remote, null, false);
    }
}

