require(GlobalDependencys:GetDependency("StandardBase"):GetPackageName())

--GAME VARS
fAdditionalFOV = 0
fDefaultAspectRatio = 1.777777791
fFOVMax = 110

--ControlVars
bFOVFixGame = true
bFixEnabled = true
bAspectRatio = true
bCullingFix = true
bHUDFix = false

FOVScaleGame = 1.0


--PROCESS VARS
Process_FriendlyName = Module:GetFriendlyName()
Process_WindowName = "AtomicHeart  "
Process_ClassName = "UnrealWindow"
Process_EXEName = "AtomicHeart-WinGDK-Shipping.exe"

--INJECTION BEHAVIOUR
InjectDelay = 5000
WriteInterval = 500
SearchInterval = 1000
SuspendThread = false

--Name                         Manual/Auto/Hybrid  		Steam/Origin/Any                IncludeFile:Configure;Enable;Periodic;Disable;
SupportedVersions = { 		
{"Automatically Detect",       "Hybrid",  		  	"Any",	                         "Configure_SignatureScan;Enable_Inject;Periodic;Disable_Inject;"},
}

function Init_Controls()

	local FOVSlider_X, FOVSlider_Y = 15, 70

	DefaultControls.AddHeader("Header_FOV_1","In-Game FOV - Fine adjustment",FOVSlider_X,FOVSlider_Y,210,17)
	DefaultControls.AddFixedFOVSlider("FOVSliderGame","FOVSliderGame_Changed",FOVSlider_X+40,FOVSlider_Y+30,125,35,0,30,0,1)
	FOVSliderGame:SetTickFrequency(5)
	FOVSliderGame:SetLabel1Text("0%")
	FOVSliderGame:SetLabel2Text("30%")
	
    HUDScalingOptions = {"Use DisplayDetection","Constrain HUD to 16:9","Constrain HUD to 16:10","Constrain HUD to 21:9"}
    DefaultControls.AddHeader("Header_HUDScalingOptions","HUD Scaling Options",245,207,210,17)
    DefaultControls.AddComboBox("HUDScalingCombo","HUDScalingCombo_Changed",HUDScalingOptions,255,234,190,300)
	
	DefaultControls.AddHeader("Header_FixesEnableDisable","Individual Fixes",245,70,210,17)
	DefaultControls.AddFixToggle("CKFOVFixGame_Enable","FOV Fix (Game)","CKFOVFixGame_Changed",255,101,180,14)	
	DefaultControls.AddFixToggle("CKAspect_Enable","Aspect Ratio","CKAspect_Changed",255,120,180,14)
	DefaultControls.AddFixToggle("CKCullingFix_Enable","Culling Fix","CKCullingFix_Changed",255,139,180,14)
	DefaultControls.AddFixToggle("CKHUDFix_Enable","HUD Fix (Constrain)","CKHUDFix_Changed",255,139+19,180,14,false)

	
end

function Configure_SignatureScan() 

	local tAddress = HackTool:AddAddress("AspectRatioFix")
	if HackTool:SignatureScan("74 ?? F3 0F 10 ?? ?? ?? ?? ?? F3 0F 58 ?? ?? ?? ?? ?? EB ?? F3 0F 10 ?? ?? ?? ?? ?? F3 0F ?? ?? ?? 8B",tAddress,PAGE_EXECUTE_READ,0x21,Process_EXEName) == 0 then	
		return ErrorOccurred(string.format(SigScanError,tAddress:GetName()))
	else
		print( tAddress:GetInfo(TYPE_ADDRESS) )		
	end	
	
	local tAddress = HackTool:AddAddress("CullingFix")
	if HackTool:SignatureScan("74 ?? 48 ?? ?? ?? ?? ?? ?? 48 ?? ?? 74 ?? F3 0F 10 ?? ?? ?? ?? ?? EB ?? F3 0F 10",tAddress,PAGE_EXECUTE_READ,0x0E,Process_EXEName) == 0 then	
		return ErrorOccurred(string.format(SigScanError,tAddress:GetName()))
	else
		print( tAddress:GetInfo(TYPE_ADDRESS) )		
	end	

	local tAddress = HackTool:AddAddress("FOVFixGame")
	if HackTool:SignatureScan("F6 ?? ?? ?? ?? ?? 10 74 ?? F3 0F 10 ?? ?? ?? ?? ?? F3 0F 58 ?? ?? ?? ?? ?? EB ?? F3 0F 10 ?? ?? ?? ?? ?? F3",tAddress,PAGE_EXECUTE_READ,0x1B,Process_EXEName) == 0 then	
		return ErrorOccurred(string.format(SigScanError,tAddress:GetName()))
	else
		print( tAddress:GetInfo(TYPE_ADDRESS) )		
	end	
	
	local tAddress = HackTool:AddAddress("HUDConstraint")
	if HackTool:SignatureScan("48 ?? ?? 66 48 0F ?? ?? FF ?? 48 8B ?? ?? ?? 0F ?? ?? 48 8B ?? 0F ?? ?? 48 83 ?? ?? ?? C3 48",tAddress,PAGE_EXECUTE_READ,0x12,Process_EXEName) == 0 then	
		return ErrorOccurred(string.format(SigScanError,tAddress:GetName()))
	else
		print( tAddress:GetInfo(TYPE_ADDRESS) )		
	end
	
	
	--
	
	return true

end

function rshift(x, by)
  return math.floor(x / 2 ^ by)
end

function Enable_Inject() 

	local NearTo = 0
	local tAddress = HackTool:GetAddress("AspectRatioFix")

	if HackTool:GetArchitecture() == 0 then --Workaround for GamePass
		NearTo = HackTool:GetBaseAddress() + tAddress:GetAddress()
	end
	
	local Variables = HackTool:AllocateMemory("Variables",0)
	Variables:PushFloat("AR_Ingame_In")
	Variables:PushFloat("AR_Ingame_Out")
	Variables:PushFloat("FOVGame_In")
	Variables:PushFloat("FOVGame_Out")	
	Variables:PushFloat("FOVGame_Scale")	
	Variables:PushFloat("DefaultAspect")
	Variables:PushFloat("HUD_LeftScale")
	Variables:PushFloat("HUD_RightScale")
	Variables:PushFloat("CullingFixValue")
	Variables:Allocate(NearTo)

	FOVCalculator1 = HackTool:InjectFOVCalculator("FOVCalculatorGame",NearTo)

	if HackTool:GetArchitecture() == 0 then --Workaround for GamePass
		FOVCalculator1["AddrValuesStart"]:WritePtr( rshift(FOVCalculator1:GetAddress(),32), 0x4 )
	end

	ResolutionChanged()
	
	local asm = [[	
	
		(codecave:jmp)FOVFixGame,FOVFixGame_cc:
			fld dword [$$2]
			fst dword ptr [(allocation)Variables->FOVGame_In]
			fmul dword ptr [(allocation)Variables->FOVGame_Scale]
			call (allocation)FOVCalculatorGame			
			fstp dword ptr [(allocation)Variables->FOVGame_Out]
			$$0 $$1, [(allocation)Variables->FOVGame_Out]			$ctx=1
			jmp %returnaddress%		
			%end%

		(codecave:jmp)AspectRatioFix,AspectRatioFix_cc:
			%originalcode%
			mov [(allocation)Variables->AR_Ingame_In], $$1			$ctx=1
			mov $$1, [(allocation)Variables->AR_Ingame_Out]			$ctx=1	
			jmp %returnaddress%
			%end%	

		(codecave:jmp)CullingFix,CullingFix_cc:
			movss $$1, [(allocation)Variables->CullingFixValue]		$ctx=1	
			movss [$$2], $$1										$ctx=1
			jmp %returnaddress%
			%end%	
			
		(codecave:jmp)HUDConstraint,HUDConstraint_cc:
			%originalcode%
			movss $$2, [(allocation)Variables->HUD_LeftScale]		$ctx=2
			movss [$$1], $$2										$ctx=2
			movss $$2, [(allocation)Variables->HUD_RightScale]		$ctx=2
			movss [$$1+0x8], $$2									$ctx=2
			jmp %returnaddress%
			%end%
	]] 

	if HackTool:CompileAssembly(asm,"FOVFix",NearTo) == nil then
		return ErrorOccurred("Assembly compilation failed...")
	else
		Toggle_CodeCave("FOVFixGame_cc",bFOVFixGame)
		Toggle_CodeCave("AspectRatioFix_cc",bAspectRatio)
		Toggle_CodeCave("CullingFix_cc",bCullingFix)
		Toggle_CodeCave("HUDConstraint_cc",bHUDFix)
		Toggle_CodeCave("MarkersRect_cc",bMarkersComplex)
	end	
		
end



function Periodic()

	local Variables = HackTool:GetAllocation("Variables")
	if Variables then 
	
		PluginViewport:AppendStatusMessage( "\r\n" )
		
		if bFOVFixGame or bFOVFixOther then 
			if bFOVFixGame and Variables["FOVGame_In"] and Variables["FOVGame_Out"] then
				PluginViewport:AppendStatusMessage( string.format("     (Game FOV Scaling) In=%.2f, Out=%.2f",	Variables["FOVGame_In"]:ReadFloat(),Variables["FOVGame_Out"]:ReadFloat()) )
			end
			
			PluginViewport:AppendStatusMessage( "\r\n" )
		end
			
		if bAspectRatio == true then			
			PluginViewport:AppendStatusMessage( string.format("     (Aspect Ratio) In=%.2f, Out=%.2f",	Variables["AR_Ingame_In"]:ReadFloat(),Variables["AR_Ingame_Out"]:ReadFloat()) )	
		end
		
		if bHUDFix == true then
			PluginViewport:AppendStatusMessage( string.format("     (HUDScaling) Left=%.4f, Right=%.4f   (%d:%s)", Variables["HUD_LeftScale"]:ReadFloat(), Variables["HUD_RightScale"]:ReadFloat(), HUDScalingCombo:GetSelectedIndex(), HUDScalingCombo:GetSelectedString()) )
		end

	end		
	
end

function Disable_Inject()
	
	CleanUp()
	
end

function ResolutionChanged() 

	SyncDisplayDetection()
	
	local CurrentAspectRatio = DisplayInfo:GetAspectRatio()
	
	if CurrentAspectRatio < 1.78 then
		CurrentAspectRatio = fDefaultAspectRatio
	end
	
	local AspectDevisional = CurrentAspectRatio/fDefaultAspectRatio
	
	
	
	UpdateFOVCalculator("FOVCalculatorGame",AspectDevisional,0.0)		

	local Variables = HackTool:GetAllocation("Variables")
	if Variables then
		if Variables["AR_Ingame_Out"] then
			Variables["AR_Ingame_Out"]:WriteFloat(CurrentAspectRatio)
		end

		if Variables["DefaultAspect"] then
			Variables["DefaultAspect"]:WriteFloat(fDefaultAspectRatio)
		end	
		
		if Variables["CullingFixValue"] then
			Variables["CullingFixValue"]:WriteFloat(90 * 5.0)
		end
	end
	
	CalculateHUDScaling()
	WriteFOVScaling() 

end

function CalculateHUDScaling() 	

	local Variables = HackTool:GetAllocation("Variables")
	if Variables then
	
		local cbIndex = HUDScalingCombo:GetSelectedIndex()
		
		local tHeight = DisplayInfo:GetHeight()
		local tWidth = DisplayInfo:GetWidth()

		
		local tHUDWidth, HUDLeft, HUDRight
		
		if cbIndex == 0 then --Use DisplayDetection
			tHUDWidth = DisplayInfo:GetfOffsetWidth(0,0)	
			HUDLeft = DisplayInfo:GetiOffsetX(0)
			HUDRight = DisplayInfo:GetiOffsetX2(0)	
		elseif cbIndex == 1 then  -- Use 21:9	
			tHUDWidth = math.floor(tHeight * 1.7777778) 	
		elseif cbIndex == 2 then --use 16:9	
			tHUDWidth = math.floor(tHeight * 1.6000001)  		
		elseif cbIndex == 3 then  -- Use 21:9	
			tHUDWidth = math.floor(tHeight * 2.3333334) 
		end		
		
		if cbIndex ~= 0 then
			HUDLeft = (tWidth - tHUDWidth) / 2
			HUDRight = HUDLeft + tHUDWidth
		end
		
		if HUDLeft > 0 then
			Variables["HUD_LeftScale"]:WriteFloat(HUDLeft / tWidth)
			Variables["HUD_RightScale"]:WriteFloat(HUDRight / tWidth)			
		else
			Variables["HUD_LeftScale"]:WriteFloat(0.0)
			Variables["HUD_RightScale"]:WriteFloat(1.0)
		end
	
	end


end

function HUDScalingCombo_Changed(Sender)

	CalculateHUDScaling()
	ForceUpdate()
	
end

function CKFOVFixGame_Changed(Sender)

	bFOVFixGame = Toggle_CheckFix(Sender)
	Toggle_CodeCave("FOVFixGame_cc",bFOVFixGame)
	ForceUpdate()
	
end
		
function CKAspect_Changed(Sender)

	bAspectRatio = Toggle_CheckFix(Sender)
	Toggle_CodeCave("AspectRatioFix_cc",bAspectRatio)
	ForceUpdate()
	
end

function CKCullingFix_Changed(Sender)

	bCullingFix = Toggle_CheckFix(Sender)
	Toggle_CodeCave("CullingFix_cc",bCullingFix)
	ForceUpdate()
	
end

function CKHUDFix_Changed(Sender)

	bHUDFix = Toggle_CheckFix(Sender)
	
	if bHUDFix == true then
		CalculateHUDScaling() 
	end
	
	Toggle_CodeCave("HUDConstraint_cc",bHUDFix)
	ForceUpdate()
	
end

function HK_IncreaseFOV()	
	FOVSlider:OffsetPosition(1)
end

function HK_DecreaseFOV()	
	FOVSlider:OffsetPosition(-1)
end

function FOVSliderGame_Changed(Sender)

	local AdditionalFOV = Sender:GetPosition()
	lblFOVSliderGame.Caption:SetCaption( string.format("Value: +%.0f%%",AdditionalFOV) )
	
	FOVScaleGame = 1.0 + (AdditionalFOV/100)
	
	WriteFOVScaling()
	
	ForceUpdate()

end

function WriteFOVScaling() 

	local Variables = HackTool:GetAllocation("Variables")
	if Variables then
		if bFOVFixGame and Variables["FOVGame_Scale"] then
			Variables["FOVGame_Scale"]:WriteFloat(FOVScaleGame)
		end	
	end
	
end

function Init()	
	Init_BaseControls()
	Init_Controls()
end

function DeInit()
	DisableFix()
end
