// CuNNy 8x8C BILINEAR RGB NVL DN - https://github.com/cunnyplapper/CuNNy

// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

//!MAGPIE EFFECT
//!VERSION 4
//!SORT_NAME CuNNy-DN-D08N08

//!TEXTURE
Texture2D INPUT;

//!TEXTURE
//!WIDTH INPUT_WIDTH * 2
//!HEIGHT INPUT_HEIGHT * 2
Texture2D OUTPUT;

//!SAMPLER
//!FILTER POINT
SamplerState SP;

//!SAMPLER
//!FILTER LINEAR
SamplerState SL;

//!COMMON
#define O(t, p) t.SampleLevel(SP, pos + p * pt, 0)
#define V4 min16float4
#define M4 min16float4x4

//!TEXTURE
//!WIDTH INPUT_WIDTH
//!HEIGHT INPUT_HEIGHT
//!FORMAT R8G8B8A8_SNORM
Texture2D t0;

//!TEXTURE
//!WIDTH INPUT_WIDTH
//!HEIGHT INPUT_HEIGHT
//!FORMAT R8G8B8A8_SNORM
Texture2D t1;

//!TEXTURE
//!WIDTH INPUT_WIDTH
//!HEIGHT INPUT_HEIGHT
//!FORMAT R8G8B8A8_SNORM
Texture2D t2;

//!TEXTURE
//!WIDTH INPUT_WIDTH
//!HEIGHT INPUT_HEIGHT
//!FORMAT R8G8B8A8_SNORM
Texture2D t3;

//!PASS 1
//!DESC in
//!BLOCK_SIZE 8
//!NUM_THREADS 64
//!IN INPUT
//!OUT t0, t1

#define l0(x, y) min16float((dot(float3(1.925e-01, 3.819e-01, 8.369e-02), O(INPUT, float2(x, y)).rgb) + -5.387e-01))

V4 f0(min16float s0_0, min16float s0_1, min16float s0_2, min16float s0_3, min16float s0_4, min16float s0_5, min16float s0_6, min16float s0_7, min16float s0_8) {
	V4 r = 0.0;
	r += V4(2.639e-02, -1.701e-01, -3.774e-03, -1.132e-01) * s0_0;
	r += V4(7.110e-02, 1.313e-01, -1.082e-02, 2.661e-02) * s0_1;
	r += V4(-7.133e-02, 3.915e-02, 1.220e-02, -3.065e-02) * s0_2;
	r += V4(-1.310e-01, -4.277e-01, 5.738e-01, -1.361e-01) * s0_3;
	r += V4(8.785e-02, -3.337e-02, -2.604e-02, 5.665e-01) * s0_4;
	r += V4(-1.597e-01, 4.606e-01, -4.603e-03, -5.048e-02) * s0_5;
	r += V4(5.069e-02, 2.608e-02, -2.872e-02, -1.027e-01) * s0_6;
	r += V4(1.334e-01, -3.456e-02, -1.744e-03, 7.886e-02) * s0_7;
	r += V4(2.759e-02, 1.279e-02, -7.839e-03, -2.046e-01) * s0_8;
	r += V4(4.846e-02, 9.244e-03, -3.897e-02, 9.766e-03);
	return r;
}

V4 f1(min16float s0_0, min16float s0_1, min16float s0_2, min16float s0_3, min16float s0_4, min16float s0_5, min16float s0_6, min16float s0_7, min16float s0_8) {
	V4 r = 0.0;
	r += V4(-2.867e-01, 2.141e-01, 4.437e-02, -5.342e-02) * s0_0;
	r += V4(-4.092e-01, -1.685e-01, -3.220e-02, -2.083e-01) * s0_1;
	r += V4(-4.212e-02, -3.446e-02, 3.496e-02, -6.681e-02) * s0_2;
	r += V4(6.756e-02, 4.954e-01, -9.457e-02, 1.597e-01) * s0_3;
	r += V4(7.022e-01, -4.053e-02, 3.086e-02, -3.529e-01) * s0_4;
	r += V4(-1.718e-02, -4.736e-01, -1.362e-02, 2.655e-02) * s0_5;
	r += V4(6.323e-02, 1.250e-02, -2.611e-01, 2.058e-02) * s0_6;
	r += V4(-1.266e-01, -5.605e-03, -3.361e-01, 1.510e-01) * s0_7;
	r += V4(4.938e-02, -7.117e-04, 2.257e-02, -7.702e-03) * s0_8;
	r += V4(1.322e-02, 1.053e-02, 6.702e-02, 8.937e-03);
	return r;
}

void Pass1(uint2 blockStart, uint3 tid) {
	float2 pt = float2(GetInputPt());
	uint2 gxy = Rmp8x8(tid.x) + blockStart;
	uint2 size = GetInputSize();
	if (gxy.x >= size.x || gxy.y >= size.y) {
		return;
	}
	float2 pos = (gxy + 0.5) * pt;

	min16float s0_0 = l0(-1.0, -1.0);
	min16float s0_1 = l0(0.0, -1.0);
	min16float s0_2 = l0(1.0, -1.0);
	min16float s0_3 = l0(-1.0, 0.0);
	min16float s0_4 = l0(0.0, 0.0);
	min16float s0_5 = l0(1.0, 0.0);
	min16float s0_6 = l0(-1.0, 1.0);
	min16float s0_7 = l0(0.0, 1.0);
	min16float s0_8 = l0(1.0, 1.0);

	t0[gxy] = f0(s0_0, s0_1, s0_2, s0_3, s0_4, s0_5, s0_6, s0_7, s0_8);
	t1[gxy] = f1(s0_0, s0_1, s0_2, s0_3, s0_4, s0_5, s0_6, s0_7, s0_8);
}

//!PASS 2
//!DESC conv1
//!BLOCK_SIZE 8
//!NUM_THREADS 64
//!IN t0, t1
//!OUT t2, t3

#define l0(x, y) V4(O(t0, float2(x, y)))
#define l1(x, y) V4(O(t1, float2(x, y)))

V4 f0(V4 s0_0, V4 s0_1, V4 s0_2, V4 s0_3, V4 s0_4, V4 s0_5, V4 s0_6, V4 s0_7, V4 s0_8, V4 s1_0, V4 s1_1, V4 s1_2, V4 s1_3, V4 s1_4, V4 s1_5, V4 s1_6, V4 s1_7, V4 s1_8, V4 s2_0, V4 s2_1, V4 s2_2, V4 s2_3, V4 s2_4, V4 s2_5, V4 s2_6, V4 s2_7, V4 s2_8, V4 s3_0, V4 s3_1, V4 s3_2, V4 s3_3, V4 s3_4, V4 s3_5, V4 s3_6, V4 s3_7, V4 s3_8) {
	V4 r = 0.0;
	r += mul(s0_0, M4(-6.787e-02, 1.507e-01, 1.386e-01, 1.354e-01, -1.647e-02, 2.280e-01, -6.392e-02, -1.182e-01, -3.002e-01, 5.059e-02, -4.223e-02, 1.296e-01, 3.034e-01, 9.575e-02, 2.396e-01, 2.604e-01));
	r += mul(s0_1, M4(1.771e-01, 1.258e-01, 9.676e-02, -5.836e-02, 2.180e-01, 9.400e-02, -1.364e-01, 1.365e-01, -1.889e-01, 6.458e-02, 2.028e-01, 1.279e-01, -2.230e-01, 4.919e-02, 3.303e-01, 2.852e-02));
	r += mul(s0_2, M4(-2.253e-02, -3.429e-02, 1.720e-01, 3.019e-02, 1.779e-01, -1.289e-01, -1.485e-02, 2.294e-01, 6.777e-02, 2.094e-01, -8.003e-02, -2.814e-01, 5.090e-02, -1.822e-02, 4.285e-02, 9.212e-03));
	r += mul(s0_3, M4(4.345e-01, -1.625e-02, 2.947e-02, 5.848e-02, -6.072e-01, -1.842e-01, -2.682e-01, -8.853e-02, -4.014e-01, 1.387e-01, -1.617e-01, 2.580e-02, 5.142e-01, 7.146e-02, -7.968e-02, -5.864e-02));
	r += mul(s0_4, M4(-3.146e-01, -1.256e-02, -1.312e-01, 1.912e-02, -3.825e-01, -7.159e-02, -8.802e-02, -2.785e-01, 1.166e+00, 3.918e-01, 1.766e-01, -9.949e-01, -3.057e-01, 3.247e-01, -5.187e-02, -3.849e-01));
	r += mul(s0_5, M4(-1.266e-01, -3.163e-02, 5.540e-02, -1.063e-04, -3.565e-01, 2.094e-02, -7.364e-02, 4.674e-02, -3.207e-01, -4.732e-02, -3.064e-02, -7.816e-01, -2.368e-01, -1.159e-01, 4.110e-02, 1.199e-01));
	r += mul(s0_6, M4(-5.285e-02, 1.116e-01, -1.387e-01, 9.422e-02, -1.251e-02, -1.096e-02, 3.989e-01, 1.370e-02, 2.573e-03, -6.050e-02, 9.572e-02, -2.029e-01, 4.006e-02, 4.752e-02, -2.514e-01, -7.318e-02));
	r += mul(s0_7, M4(1.563e-01, -6.792e-02, 7.001e-02, 1.968e-02, 3.360e-01, -1.072e-01, 1.499e-01, -4.911e-02, -4.225e-01, -7.392e-02, -9.010e-01, -1.592e-01, -7.005e-03, -3.628e-01, -2.941e-01, 6.075e-02));
	r += mul(s0_8, M4(-6.457e-02, -1.010e-01, -1.549e-01, -8.569e-02, 2.008e-01, -3.078e-02, -1.027e-01, 1.431e-01, -1.821e-01, 4.419e-02, -1.641e-01, -1.295e-01, 2.477e-03, -1.839e-01, 7.758e-02, -4.918e-02));
	r += mul(s1_0, M4(8.745e-02, 4.435e-02, -1.817e-01, -6.904e-01, -5.046e-01, -6.161e-02, -2.511e-01, 1.648e-01, 5.188e-02, 7.367e-02, 2.228e-01, -8.911e-02, 3.976e-01, 1.385e-01, 3.897e-01, 2.256e-01));
	r += mul(s1_1, M4(-2.179e-02, 2.662e-01, -1.836e-01, 6.580e-01, -2.441e-02, 1.059e-01, 2.016e-01, -5.101e-02, 2.634e-02, 7.840e-02, 2.103e-02, 1.695e-01, -1.253e-01, -5.145e-02, 1.500e-01, 1.995e-01));
	r += mul(s1_2, M4(3.784e-02, -6.314e-02, 7.330e-02, -3.828e-01, -3.898e-03, 1.618e-01, 8.129e-02, 1.630e-01, 2.141e-02, 1.426e-01, -1.058e-02, 6.683e-02, -1.627e-02, 2.531e-03, 7.962e-02, 1.641e-01));
	r += mul(s1_3, M4(2.354e-01, -1.180e-02, 4.459e-02, -2.539e-01, -1.247e-02, 2.407e-01, 2.427e-01, -7.432e-02, -1.158e-01, 1.015e-02, -7.599e-02, -5.581e-02, 3.942e-01, -2.540e-02, -3.743e-01, 2.689e-01));
	r += mul(s1_4, M4(1.472e-01, -5.494e-01, 2.751e-02, -6.865e-01, 4.673e-01, 2.978e-01, -3.744e-01, 4.839e-02, 3.663e-01, 6.252e-03, 4.537e-02, -3.700e-02, -4.528e-01, 4.329e-01, 2.170e-01, -5.655e-02));
	r += mul(s1_5, M4(-3.136e-01, 3.527e-02, -9.977e-02, 1.680e-01, 1.746e-01, 2.170e-01, -1.577e-01, -3.133e-02, -2.571e-01, 4.381e-02, 5.043e-02, 4.327e-01, -2.274e-01, -2.338e-01, 1.237e-01, 9.396e-02));
	r += mul(s1_6, M4(-2.045e-01, -3.270e-01, 3.275e-01, 1.302e-01, 1.187e-01, -2.118e-02, 3.357e-01, 3.389e-02, 1.123e-01, 5.050e-03, -6.020e-03, 1.285e-02, 1.499e-01, 2.891e-01, -6.994e-01, 6.691e-02));
	r += mul(s1_7, M4(7.207e-02, 1.789e-01, 4.475e-01, 7.563e-02, 1.562e-01, 9.745e-02, 2.281e-01, 1.472e-01, -1.739e-01, 2.556e-02, -3.121e-01, 4.985e-02, -4.985e-02, -5.638e-01, -4.190e-01, 1.795e-01));
	r += mul(s1_8, M4(-3.225e-02, -5.762e-02, -2.681e-02, -3.269e-01, -1.883e-01, -1.365e-01, 8.040e-02, -2.820e-02, -4.708e-02, -1.241e-01, 2.407e-02, 5.468e-02, 8.962e-03, -5.522e-02, -5.487e-02, 5.633e-02));
	r += mul(s2_0, M4(-7.475e-02, 2.239e-02, 1.336e-02, -1.309e-02, -2.294e-01, 1.259e-02, -6.364e-02, 1.705e-01, -1.467e-01, 6.734e-02, -1.129e-01, 2.675e-01, -8.728e-02, -2.415e-01, -5.943e-02, 8.068e-02));
	r += mul(s2_1, M4(1.161e-01, 1.003e-01, -9.628e-03, -5.014e-02, -1.559e-01, -6.243e-02, 3.428e-01, -1.662e-01, 8.781e-02, -5.090e-02, -1.466e-01, 6.924e-02, -7.831e-02, -7.191e-02, -3.093e-01, -1.182e-01));
	r += mul(s2_2, M4(-1.187e-02, -1.124e-01, 1.241e-01, 3.818e-02, -3.489e-02, 1.072e-01, -3.086e-02, 8.455e-02, -3.857e-02, 1.693e-01, -1.791e-01, 1.621e-01, 5.023e-02, 6.312e-02, -1.419e-01, 3.264e-02));
	r += mul(s2_3, M4(6.541e-01, 1.355e-02, 6.582e-01, 4.098e-02, 5.969e-01, 1.744e-01, 1.758e-01, 1.798e-01, -2.511e-02, 6.407e-02, -4.659e-02, 1.100e-01, -3.252e-01, -2.088e-02, -3.156e-02, 2.349e-01));
	r += mul(s2_4, M4(-5.107e-01, 6.148e-01, -2.237e-01, -2.672e-01, 3.043e-01, 4.147e-01, -1.371e-02, -9.339e-02, -7.676e-02, -1.914e-02, 4.465e-02, -1.130e-01, 3.640e-01, -4.571e-01, 1.863e-02, 1.653e-01));
	r += mul(s2_5, M4(-1.206e-02, -6.812e-02, 1.585e-01, 1.884e-01, 2.366e-01, 3.310e-01, -1.584e-01, 4.540e-02, 6.728e-04, 3.926e-02, -1.147e-01, 1.093e-01, 2.546e-01, 1.105e-01, 1.950e-02, 1.075e-01));
	r += mul(s2_6, M4(1.302e-01, -1.658e-01, -4.834e-01, -2.295e-02, -1.106e-01, 2.600e-02, -2.262e-01, 8.762e-02, -5.511e-02, -1.613e-03, 1.347e-02, -2.278e-04, -9.678e-02, 7.248e-02, 1.184e-01, -1.321e-01));
	r += mul(s2_7, M4(-6.153e-02, -5.202e-01, -9.300e-01, 1.067e-01, 1.116e-01, -2.270e-01, 2.099e-02, 4.166e-02, 2.248e-02, 7.370e-02, 4.101e-01, 9.718e-02, 2.057e-01, -1.217e-01, 9.265e-02, -1.137e-01));
	r += mul(s2_8, M4(-1.353e-01, -2.862e-01, -6.823e-02, -2.380e-02, -6.254e-02, -8.065e-02, 1.598e-01, -1.998e-02, 5.988e-02, 1.871e-01, 8.992e-02, -7.480e-02, 2.728e-02, 1.082e-01, 3.140e-01, 1.540e-01));
	r += mul(s3_0, M4(-1.587e-01, 7.444e-02, -1.777e-02, 2.381e-02, 1.406e-01, 3.196e-01, -1.374e-03, 9.152e-02, -5.543e-01, -8.394e-03, 1.747e-01, 4.359e-01, -7.423e-02, -3.368e-01, -9.362e-02, 7.286e-02));
	r += mul(s3_1, M4(1.121e-01, 1.016e-01, 3.174e-02, -5.360e-02, -1.795e-02, 1.725e-02, -1.327e-02, 1.641e-01, -7.362e-01, -1.406e-01, -7.589e-01, 8.071e-01, -2.497e-01, -1.097e-01, -2.655e-01, -1.087e-01));
	r += mul(s3_2, M4(7.331e-03, -2.768e-02, 1.184e-01, 1.065e-01, 1.451e-01, -4.143e-02, -1.411e-01, 1.550e-01, 6.200e-01, 1.024e+00, -7.276e-02, 8.515e-01, 1.175e-01, 1.839e-01, -2.676e-01, -1.548e-02));
	r += mul(s3_3, M4(6.424e-01, 2.821e-02, 5.957e-01, 1.530e-01, 1.276e-01, -2.298e-01, -1.210e-01, 1.548e-01, 7.219e-01, 1.262e-01, 9.240e-01, 3.466e-01, -2.720e-01, -5.621e-02, -4.165e-02, 1.123e-01));
	r += mul(s3_4, M4(-4.418e-01, 5.566e-01, 6.313e-03, -4.863e-01, -4.189e-01, -1.606e-01, 2.613e-01, -4.014e-01, -4.206e-01, -4.682e-01, -3.779e-01, 5.871e-01, 2.516e-01, -5.022e-01, 2.759e-01, 1.313e-01));
	r += mul(s3_5, M4(-3.682e-02, -2.897e-01, 2.019e-01, 3.667e-03, -1.666e-01, 2.953e-02, -1.446e-01, -6.928e-02, -1.346e-01, -6.624e-02, -1.522e-02, 8.483e-01, 3.168e-01, 1.247e-01, -6.584e-02, -8.030e-02));
	r += mul(s3_6, M4(1.670e-01, -4.091e-02, 1.881e-01, 1.276e-01, -1.441e-01, 1.636e-01, -1.322e-01, 8.716e-02, 9.290e-02, 3.344e-01, 2.737e-01, -4.509e-01, -1.560e-01, 8.292e-02, -5.494e-02, 2.625e-02));
	r += mul(s3_7, M4(6.209e-02, -8.711e-01, -2.422e-02, -1.158e-02, 1.969e-01, -4.698e-01, -1.016e-01, -1.333e-01, 5.883e-01, -9.214e-02, 1.058e+00, 2.119e-01, 3.611e-01, 2.443e-01, 1.390e-01, 3.819e-01));
	r += mul(s3_8, M4(-1.502e-01, -5.064e-01, 8.467e-02, -2.262e-02, 2.649e-01, 1.169e-01, -5.726e-02, 1.341e-01, 2.349e-01, 7.791e-01, 6.799e-02, 7.027e-02, -5.221e-02, 1.357e-01, 1.382e-01, -3.748e-02));
	r += V4(-4.129e-03, -4.378e-02, 1.747e-02, 3.267e-02);
	return r;
}

V4 f1(V4 s0_0, V4 s0_1, V4 s0_2, V4 s0_3, V4 s0_4, V4 s0_5, V4 s0_6, V4 s0_7, V4 s0_8, V4 s1_0, V4 s1_1, V4 s1_2, V4 s1_3, V4 s1_4, V4 s1_5, V4 s1_6, V4 s1_7, V4 s1_8, V4 s2_0, V4 s2_1, V4 s2_2, V4 s2_3, V4 s2_4, V4 s2_5, V4 s2_6, V4 s2_7, V4 s2_8, V4 s3_0, V4 s3_1, V4 s3_2, V4 s3_3, V4 s3_4, V4 s3_5, V4 s3_6, V4 s3_7, V4 s3_8) {
	V4 r = 0.0;
	r += mul(s0_0, M4(7.766e-02, 4.523e-03, -1.029e-01, 3.952e-02, 1.207e-01, -3.205e-02, -1.516e-01, -4.993e-02, -2.106e-01, 5.000e-01, 2.802e-01, -1.797e-01, 1.157e-02, 4.642e-01, -1.830e-01, 9.749e-03));
	r += mul(s0_1, M4(5.684e-02, -1.916e-01, 1.998e-02, 8.908e-02, -1.295e-01, 1.184e-01, 3.992e-02, -3.736e-01, 5.210e-01, -1.915e-01, -1.448e-02, -3.299e-01, 1.325e-01, 5.057e-01, 1.203e-01, 1.044e-01));
	r += mul(s0_2, M4(-7.759e-02, 1.978e-01, 2.185e-01, -1.370e-01, 5.627e-02, 3.739e-02, 1.866e-02, 4.120e-02, 1.212e-01, -2.967e-01, -4.022e-02, -1.058e-01, 9.193e-02, -6.720e-02, -8.270e-02, -3.294e-02));
	r += mul(s0_3, M4(-1.156e-01, -3.838e-01, -1.304e-01, 1.556e-01, 2.972e-01, -3.797e-02, -8.053e-02, 1.932e-01, -8.240e-01, 8.246e-01, 6.350e-01, -4.248e-01, 1.592e-03, -2.154e-01, 3.861e-01, -8.019e-02));
	r += mul(s0_4, M4(1.134e-01, 3.460e-01, -1.323e-01, 1.038e-01, 3.182e-01, 5.052e-02, -2.690e-01, 4.359e-01, -5.274e-01, -1.360e+00, 5.110e-01, -8.171e-01, -4.418e-02, 3.662e-01, -4.468e-01, -8.695e-02));
	r += mul(s0_5, M4(-5.947e-02, 6.545e-02, 7.860e-02, 1.032e-01, 3.691e-01, -1.867e-02, -6.669e-02, -1.166e-01, 4.599e-01, -6.066e-01, -1.696e+00, -7.313e-01, -2.449e-01, -8.068e-02, 1.883e-03, -1.603e-01));
	r += mul(s0_6, M4(1.844e-01, -8.927e-02, 2.002e-02, -4.609e-04, -2.650e-01, 7.654e-02, -1.074e-01, -6.939e-02, 3.150e-01, -2.191e-01, 4.955e-01, -1.906e-02, -1.020e-01, -4.901e-02, -1.017e-01, -2.561e-01));
	r += mul(s0_7, M4(-8.724e-02, -1.306e-01, 4.306e-02, -1.211e-01, -6.401e-02, -5.717e-02, 1.212e-01, 2.038e-01, -7.175e-02, -3.181e-01, 3.271e-01, 6.668e-02, -6.730e-02, 1.929e-01, 2.173e-01, 1.680e-01));
	r += mul(s0_8, M4(1.231e-02, 5.079e-02, 1.005e-01, 8.730e-02, 5.038e-02, 9.516e-02, 2.623e-01, 7.546e-02, -2.105e-02, 2.273e-02, -5.382e-02, 9.471e-02, 6.055e-02, 2.890e-02, 5.401e-02, 1.443e-02));
	r += mul(s1_0, M4(4.897e-01, 4.202e-01, -8.175e-01, 2.352e-01, -1.649e-01, 1.083e-01, 1.852e-01, 2.373e-02, 1.422e-02, -5.769e-02, -3.236e-02, -4.748e-02, 1.910e-01, -1.096e-01, 3.096e-02, 1.352e-01));
	r += mul(s1_1, M4(4.412e-01, -6.797e-01, -1.467e-01, -6.489e-01, -7.817e-03, 5.137e-03, 1.653e-01, 2.525e-01, 1.898e-01, -1.662e-02, -7.295e-03, 1.482e-01, 2.308e-01, -2.795e-01, -7.044e-02, -2.044e-01));
	r += mul(s1_2, M4(2.954e-01, 7.991e-03, -3.515e-02, 5.353e-01, 3.823e-01, 1.324e-01, -1.496e-01, 2.410e-01, 1.570e-01, -2.524e-02, -9.177e-02, 6.568e-02, 1.920e-01, 1.506e-02, -4.787e-02, -1.636e-01));
	r += mul(s1_3, M4(-2.704e-01, 3.949e-02, -1.541e-01, -3.039e-01, -5.590e-01, -4.014e-01, 3.342e-01, 6.506e-02, -1.872e-01, 1.954e-01, -1.813e-02, 5.556e-02, 8.577e-02, 1.206e-01, 9.298e-02, 4.025e-02));
	r += mul(s1_4, M4(-5.198e-01, 7.954e-01, -1.264e-01, -7.453e-01, -1.635e-01, -1.080e-01, 6.140e-01, -3.089e-01, -9.613e-02, -3.290e-01, 1.678e-01, -7.862e-02, 4.744e-02, -8.617e-02, -3.783e-01, -5.302e-02));
	r += mul(s1_5, M4(-3.316e-01, -9.648e-02, 3.075e-01, -8.622e-02, -2.702e-02, 2.573e-01, 4.803e-02, 2.886e-01, 1.101e-01, -5.590e-02, -2.187e-01, 4.012e-02, -6.776e-02, -2.531e-02, 1.187e-01, 1.914e-01));
	r += mul(s1_6, M4(1.292e-01, 7.338e-01, -1.035e+00, -3.613e-01, -1.081e-01, 5.978e-02, 1.108e-01, 1.432e-01, -7.837e-02, 7.895e-02, 1.205e-02, -5.820e-02, 9.230e-02, -2.629e-01, 1.338e-01, 1.457e-02));
	r += mul(s1_7, M4(1.799e-01, -2.778e-01, 2.910e-01, -3.160e-01, 1.320e-01, -2.639e-01, 1.126e-01, -4.365e-01, -1.801e-01, 4.184e-02, 1.418e-01, 1.234e-01, -1.337e-01, -8.716e-02, 6.319e-02, -4.482e-02));
	r += mul(s1_8, M4(-1.452e-01, 9.640e-02, 2.817e-01, 1.741e-01, -1.779e-01, 2.690e-02, 3.388e-02, 1.115e-02, -1.610e-01, -4.691e-02, -1.704e-01, -2.261e-01, 7.297e-02, 5.985e-02, 1.668e-01, 1.194e-02));
	r += mul(s2_0, M4(1.225e-01, -1.822e-01, -7.392e-02, 7.928e-02, -9.254e-02, 6.534e-03, 1.812e-01, 6.578e-02, 6.421e-02, -6.216e-02, -1.401e-01, -1.043e-01, -3.504e-01, -6.918e-02, 1.484e-01, 1.426e-01));
	r += mul(s2_1, M4(4.606e-02, -1.660e-02, -1.607e-01, -4.997e-02, 1.538e-01, 1.111e-02, 2.039e-01, -1.516e-02, -5.033e-02, -5.356e-02, 9.295e-02, -2.669e-01, -1.850e-01, 7.764e-02, 5.003e-02, -4.675e-02));
	r += mul(s2_2, M4(5.484e-02, 2.393e-02, 6.362e-03, 1.969e-01, 3.522e-01, -3.946e-02, -2.846e-01, 3.291e-01, 2.223e-01, 1.481e-01, -1.728e-03, 6.660e-02, -4.053e-02, -6.892e-02, 4.244e-02, 2.214e-01));
	r += mul(s2_3, M4(-3.490e-01, -9.302e-02, 2.349e-01, -2.202e-01, -4.376e-01, -1.789e-01, 1.899e-01, 5.442e-02, -1.084e-01, 3.997e-02, -1.352e-01, 1.549e-01, 8.160e-02, 2.716e-01, 2.301e-02, 1.718e-01));
	r += mul(s2_4, M4(3.561e-02, 5.771e-02, -6.185e-01, -7.735e-02, -4.608e-01, -4.666e-02, 6.230e-01, -1.867e-01, -4.888e-02, 1.459e-01, -2.126e-01, -1.254e-01, -3.141e-01, -7.960e-02, 2.873e-01, 2.510e-02));
	r += mul(s2_5, M4(1.481e-01, 1.674e-02, -1.207e-01, 2.081e-01, -1.548e-01, 1.376e-01, 4.633e-02, 2.706e-01, 2.653e-02, 8.545e-02, 1.186e-01, 1.113e-01, -5.347e-02, -7.582e-03, 1.496e-01, -1.793e-02));
	r += mul(s2_6, M4(-1.792e-01, 1.004e-01, 4.906e-02, -1.008e-01, 1.174e-01, -5.349e-02, 7.906e-02, 1.349e-01, -4.414e-02, -5.315e-02, -1.098e-03, 9.865e-02, 8.420e-02, -9.036e-02, -1.430e-01, -1.643e-01));
	r += mul(s2_7, M4(-4.867e-01, 1.544e-01, 4.995e-01, 8.678e-02, -1.243e-01, -9.942e-02, 3.613e-01, -2.650e-01, 8.803e-02, 6.569e-02, -1.275e-01, -6.514e-02, -2.140e-02, 2.578e-04, -6.209e-02, -1.538e-01));
	r += mul(s2_8, M4(-4.464e-01, 9.445e-02, -8.204e-02, -1.032e-01, 8.754e-04, 2.704e-02, 2.153e-02, 2.418e-02, 6.872e-02, -8.452e-02, -3.028e-02, 6.132e-02, 7.423e-02, -1.119e-01, -1.669e-02, 3.309e-02));
	r += mul(s3_0, M4(8.549e-02, 4.522e-02, 1.895e-02, -1.330e-01, 2.075e-01, -1.273e-01, -2.992e-02, -3.167e-02, -4.418e-01, -4.636e-01, -3.327e-01, 1.122e+00, -2.823e-01, -4.644e-01, 8.801e-02, 1.657e-01));
	r += mul(s3_1, M4(1.285e-01, -2.622e-02, -6.361e-02, -1.547e-01, 2.056e-01, 2.397e-01, -1.266e-03, -5.679e-01, 1.275e-01, -1.047e+00, 2.648e-01, 2.793e+00, -1.654e-01, 1.219e-01, 8.593e-02, -2.056e-01));
	r += mul(s3_2, M4(3.391e-02, 5.880e-02, -1.770e-03, 1.562e-01, -1.247e-04, 3.836e-03, -3.243e-02, -1.212e-01, -3.804e-01, -6.416e-01, 1.051e+00, 3.382e-01, -1.993e-01, 1.436e-01, 7.728e-02, -1.012e-01));
	r += mul(s3_3, M4(-1.693e-01, -2.344e-01, 1.774e-01, 8.301e-02, 1.180e-01, -2.529e-01, -1.157e-01, -1.074e-01, 4.684e-02, 1.431e-01, 3.555e-01, 9.063e-01, 3.541e-02, 1.555e-01, -2.294e-01, 3.541e-01));
	r += mul(s3_4, M4(6.790e-01, 2.978e-03, -5.333e-01, -7.826e-02, 4.578e-02, -7.635e-02, -6.772e-01, -2.766e-02, -5.894e-02, 4.245e-02, -7.763e-01, -1.412e+00, -1.240e-01, -3.159e-01, 4.795e-01, 2.910e-01));
	r += mul(s3_5, M4(1.609e-01, 4.055e-02, 1.846e-02, -3.977e-02, 2.659e-01, 1.511e-02, -2.099e-01, -4.121e-01, 4.071e-01, 4.634e-01, 2.884e-01, 9.777e-01, -1.012e-01, 5.495e-02, 1.572e-01, -3.293e-01));
	r += mul(s3_6, M4(-8.705e-02, -1.337e-01, -1.727e-01, -9.255e-02, 1.578e-02, -2.723e-02, -1.492e-01, -1.372e-01, -2.315e-01, 5.413e-01, 4.250e-01, 4.866e-01, -1.362e-01, -1.312e-01, -1.257e-01, 1.292e-01));
	r += mul(s3_7, M4(-1.415e-01, -5.995e-02, 1.151e-01, 1.606e-01, -3.936e-01, 2.124e-01, -9.745e-02, 3.440e-01, -5.216e-01, -3.266e-01, -5.189e-01, -7.262e-01, 1.290e-02, 9.216e-02, 1.121e-01, 1.337e-01));
	r += mul(s3_8, M4(2.335e-02, -4.137e-02, -2.396e-02, -4.996e-02, 2.455e-01, 8.565e-02, 2.153e-01, 6.100e-02, 6.328e-01, -8.356e-01, 1.118e-01, -2.496e-01, -3.962e-02, -7.803e-02, -1.017e-01, -1.817e-01));
	r += V4(-2.496e-02, -1.212e-01, -1.419e-02, 2.482e-02);
	return r;
}

void Pass2(uint2 blockStart, uint3 tid) {
	float2 pt = float2(GetInputPt());
	uint2 gxy = Rmp8x8(tid.x) + blockStart;
	uint2 size = GetInputSize();
	if (gxy.x >= size.x || gxy.y >= size.y) {
		return;
	}
	float2 pos = (gxy + 0.5) * pt;

	V4 s0_0 = l0(-1.0, -1.0);
	V4 s0_1 = l0(0.0, -1.0);
	V4 s0_2 = l0(1.0, -1.0);
	V4 s0_3 = l0(-1.0, 0.0);
	V4 s0_4 = l0(0.0, 0.0);
	V4 s0_5 = l0(1.0, 0.0);
	V4 s0_6 = l0(-1.0, 1.0);
	V4 s0_7 = l0(0.0, 1.0);
	V4 s0_8 = l0(1.0, 1.0);
	V4 s1_0 = -max(-s0_0, 0.0);
	V4 s1_1 = -max(-s0_1, 0.0);
	V4 s1_2 = -max(-s0_2, 0.0);
	V4 s1_3 = -max(-s0_3, 0.0);
	V4 s1_4 = -max(-s0_4, 0.0);
	V4 s1_5 = -max(-s0_5, 0.0);
	V4 s1_6 = -max(-s0_6, 0.0);
	V4 s1_7 = -max(-s0_7, 0.0);
	V4 s1_8 = -max(-s0_8, 0.0);
	s0_0 = max(s0_0, 0.0);
	s0_1 = max(s0_1, 0.0);
	s0_2 = max(s0_2, 0.0);
	s0_3 = max(s0_3, 0.0);
	s0_4 = max(s0_4, 0.0);
	s0_5 = max(s0_5, 0.0);
	s0_6 = max(s0_6, 0.0);
	s0_7 = max(s0_7, 0.0);
	s0_8 = max(s0_8, 0.0);

	V4 s2_0 = l1(-1.0, -1.0);
	V4 s2_1 = l1(0.0, -1.0);
	V4 s2_2 = l1(1.0, -1.0);
	V4 s2_3 = l1(-1.0, 0.0);
	V4 s2_4 = l1(0.0, 0.0);
	V4 s2_5 = l1(1.0, 0.0);
	V4 s2_6 = l1(-1.0, 1.0);
	V4 s2_7 = l1(0.0, 1.0);
	V4 s2_8 = l1(1.0, 1.0);
	V4 s3_0 = -max(-s2_0, 0.0);
	V4 s3_1 = -max(-s2_1, 0.0);
	V4 s3_2 = -max(-s2_2, 0.0);
	V4 s3_3 = -max(-s2_3, 0.0);
	V4 s3_4 = -max(-s2_4, 0.0);
	V4 s3_5 = -max(-s2_5, 0.0);
	V4 s3_6 = -max(-s2_6, 0.0);
	V4 s3_7 = -max(-s2_7, 0.0);
	V4 s3_8 = -max(-s2_8, 0.0);
	s2_0 = max(s2_0, 0.0);
	s2_1 = max(s2_1, 0.0);
	s2_2 = max(s2_2, 0.0);
	s2_3 = max(s2_3, 0.0);
	s2_4 = max(s2_4, 0.0);
	s2_5 = max(s2_5, 0.0);
	s2_6 = max(s2_6, 0.0);
	s2_7 = max(s2_7, 0.0);
	s2_8 = max(s2_8, 0.0);

	t2[gxy] = f0(s0_0, s0_1, s0_2, s0_3, s0_4, s0_5, s0_6, s0_7, s0_8, s1_0, s1_1, s1_2, s1_3, s1_4, s1_5, s1_6, s1_7, s1_8, s2_0, s2_1, s2_2, s2_3, s2_4, s2_5, s2_6, s2_7, s2_8, s3_0, s3_1, s3_2, s3_3, s3_4, s3_5, s3_6, s3_7, s3_8);
	t3[gxy] = f1(s0_0, s0_1, s0_2, s0_3, s0_4, s0_5, s0_6, s0_7, s0_8, s1_0, s1_1, s1_2, s1_3, s1_4, s1_5, s1_6, s1_7, s1_8, s2_0, s2_1, s2_2, s2_3, s2_4, s2_5, s2_6, s2_7, s2_8, s3_0, s3_1, s3_2, s3_3, s3_4, s3_5, s3_6, s3_7, s3_8);
}

//!PASS 3
//!DESC conv2
//!BLOCK_SIZE 8
//!NUM_THREADS 64
//!IN t2, t3
//!OUT t0, t1

#define l0(x, y) V4(O(t2, float2(x, y)))
#define l1(x, y) V4(O(t3, float2(x, y)))

V4 f0(V4 s0_0, V4 s0_1, V4 s0_2, V4 s0_3, V4 s0_4, V4 s0_5, V4 s0_6, V4 s0_7, V4 s0_8, V4 s1_0, V4 s1_1, V4 s1_2, V4 s1_3, V4 s1_4, V4 s1_5, V4 s1_6, V4 s1_7, V4 s1_8, V4 s2_0, V4 s2_1, V4 s2_2, V4 s2_3, V4 s2_4, V4 s2_5, V4 s2_6, V4 s2_7, V4 s2_8, V4 s3_0, V4 s3_1, V4 s3_2, V4 s3_3, V4 s3_4, V4 s3_5, V4 s3_6, V4 s3_7, V4 s3_8) {
	V4 r = 0.0;
	r += mul(s0_0, M4(3.773e-02, -4.916e-02, 1.204e-01, -2.493e-02, 6.937e-01, 2.135e-01, 1.818e-01, -3.537e-01, 1.529e-01, 6.021e-02, 1.170e-01, -1.189e-01, 1.189e-01, -9.206e-03, 1.108e-01, 3.896e-02));
	r += mul(s0_1, M4(-1.620e-01, -1.064e-01, -2.412e-01, -2.743e-01, 2.700e-01, 2.419e-01, -6.450e-02, -2.533e-01, -3.513e-01, -1.194e-01, -3.858e-01, -6.738e-01, -1.275e-03, 1.531e-02, -6.212e-02, 6.180e-02));
	r += mul(s0_2, M4(-1.407e-01, -2.679e-01, -1.344e-01, 6.411e-02, -1.541e-01, 1.592e-01, 7.251e-02, 2.381e-02, 2.503e-01, 1.899e-01, 1.577e-02, 1.255e-01, -6.473e-02, -1.242e-01, -2.175e-03, 4.059e-02));
	r += mul(s0_3, M4(-1.168e-01, 7.074e-03, -6.052e-02, -8.601e-02, -1.645e-01, 5.184e-02, 1.711e-01, 2.114e-01, 5.484e-02, -3.865e-02, 6.780e-02, 1.577e-02, -2.114e-02, 8.978e-02, 3.936e-02, 1.152e-01));
	r += mul(s0_4, M4(4.902e-01, 1.460e-01, 1.333e-01, 1.720e-01, -8.563e-02, -3.756e-01, -2.379e-01, 5.975e-02, 2.295e-01, -1.261e-01, 6.562e-02, -4.971e-01, 7.983e-02, 1.276e-01, -4.241e-02, -1.105e-01));
	r += mul(s0_5, M4(3.213e-01, -5.127e-01, -9.751e-02, -8.480e-02, 9.720e-02, 6.087e-02, 5.854e-02, -1.636e-01, -4.187e-02, 1.622e-01, 1.296e-01, 1.646e-01, -2.426e-01, -7.077e-02, -7.194e-02, -1.413e-02));
	r += mul(s0_6, M4(5.106e-02, 1.813e-02, -1.207e-01, 1.479e-01, 7.105e-02, -1.572e-02, 2.355e-01, 3.700e-02, -2.041e-01, 1.066e-01, -1.663e-02, 5.370e-02, -1.855e-01, 2.424e-03, -1.153e-02, 3.895e-02));
	r += mul(s0_7, M4(3.740e-02, 2.510e-01, 4.747e-02, -1.610e-02, -1.276e-01, 1.675e-02, -1.122e-01, -7.178e-02, -3.253e-01, -1.639e-01, -1.312e-01, 6.179e-02, 1.135e-01, 2.657e-02, -1.152e-01, -9.269e-02));
	r += mul(s0_8, M4(-3.307e-02, 1.119e-01, -1.452e-02, 1.724e-01, -5.484e-02, 2.508e-03, -3.591e-02, 6.865e-02, 1.889e-01, 1.723e-01, 1.635e-01, 1.258e-01, 1.857e-02, 1.273e-01, 1.566e-01, -1.652e-02));
	r += mul(s1_0, M4(-2.277e-01, -1.423e-01, 1.949e-01, 4.971e-02, -3.095e-01, -7.076e-02, -1.716e-01, -3.408e-01, 1.357e-01, 1.048e-01, -3.445e-02, -6.842e-02, 2.769e-01, 1.989e-02, 8.616e-02, 2.153e-01));
	r += mul(s1_1, M4(-2.882e-01, -3.427e-01, 9.095e-02, 7.691e-01, 1.701e-01, 3.928e-01, -3.796e-01, -4.772e-01, 2.376e-01, 1.403e-01, 1.900e-01, 4.017e-02, 1.762e-01, 7.482e-02, -3.929e-03, 2.218e-03));
	r += mul(s1_2, M4(-2.240e-01, -3.791e-01, 4.275e-02, 1.327e-01, -1.085e-01, 2.639e-02, 1.546e-01, -2.289e-02, -6.099e-01, -1.290e-01, -1.267e-01, 5.642e-02, -1.649e-01, -2.882e-01, 1.917e-02, 1.338e-01));
	r += mul(s1_3, M4(2.616e-01, 8.183e-03, -1.014e-02, -1.328e-01, 3.280e-01, 1.409e-01, -3.935e-01, -5.285e-02, -1.023e-02, -7.158e-02, 4.159e-03, -4.778e-02, -5.562e-01, 3.113e-02, 4.077e-02, -2.240e-01));
	r += mul(s1_4, M4(4.202e-02, 9.718e-02, -9.851e-02, -7.479e-01, 3.624e-02, -4.618e-01, -2.312e-01, 1.559e-01, -6.908e-01, 1.833e-01, -2.083e-01, 6.335e-02, -2.836e-02, 2.194e-01, 1.387e-01, -2.445e-01));
	r += mul(s1_5, M4(1.029e-01, -3.759e-01, 2.112e-02, -3.595e-02, 4.997e-03, -8.256e-02, 1.003e-01, -1.616e-01, 2.521e-01, 7.646e-02, -1.807e-01, 8.995e-02, -4.928e-01, -4.602e-02, -1.609e-01, 8.111e-02));
	r += mul(s1_6, M4(2.841e-01, 7.997e-02, -1.299e-01, -3.545e-02, -3.290e-02, 4.075e-04, 1.653e-01, 3.074e-02, 6.276e-02, 5.983e-02, -3.728e-02, -6.306e-02, -1.742e-01, -1.482e-01, -3.579e-01, 6.636e-02));
	r += mul(s1_7, M4(1.981e-01, 1.679e-01, -6.883e-02, -2.588e-01, -2.647e-01, 8.313e-02, -5.174e-02, 1.209e-01, -2.284e-01, -1.392e-01, -1.328e-01, 3.198e-02, 1.279e-01, -4.582e-02, -2.727e-01, 6.927e-02));
	r += mul(s1_8, M4(1.525e-01, -2.406e-01, 8.315e-02, 7.265e-03, -2.063e-03, -9.131e-02, 1.110e-03, 3.074e-02, 1.791e-01, 5.909e-02, -8.521e-02, -6.441e-02, 2.074e-01, 7.446e-02, 1.452e-01, 7.400e-02));
	r += mul(s2_0, M4(1.997e-02, 2.843e-01, 8.649e-02, 9.571e-02, -1.781e-01, -9.968e-03, -2.890e-02, -7.883e-02, 2.019e-02, -1.216e-02, 1.812e-01, 2.368e-01, 6.113e-02, 3.176e-02, 7.946e-02, 1.075e-01));
	r += mul(s2_1, M4(1.032e-01, -5.896e-01, 1.941e-01, 3.837e-01, 1.188e-01, 8.780e-02, 3.861e-02, -1.744e-01, 4.878e-02, -7.646e-02, 2.619e-01, 1.448e-01, 5.215e-02, 4.933e-02, -6.758e-02, 8.912e-02));
	r += mul(s2_2, M4(-2.291e-01, -1.530e-01, 1.102e-01, 5.480e-02, 4.077e-01, -8.378e-03, -7.649e-02, -6.372e-02, 2.670e-01, 1.017e-01, 2.667e-01, -8.936e-03, -1.644e-02, -4.544e-02, -6.324e-02, -5.411e-02));
	r += mul(s2_3, M4(-1.113e-01, 7.794e-02, -2.500e-01, 2.054e-01, 7.857e-02, 3.525e-02, -6.270e-02, 1.187e-01, 1.222e-01, 3.236e-02, -2.597e-01, -1.654e-01, 2.588e-02, -2.900e-01, -8.871e-02, -1.734e-02));
	r += mul(s2_4, M4(7.606e-01, -5.853e-01, 1.359e-01, -1.206e-01, -2.826e-01, 2.765e-01, 2.347e-01, 3.174e-01, -2.738e-01, -6.352e-02, 1.287e-01, -2.197e-01, -4.855e-01, -1.005e-02, -1.929e-01, -3.095e-02));
	r += mul(s2_5, M4(2.727e-01, -2.414e-01, 1.192e-01, -2.436e-01, 1.855e-01, -9.626e-02, -1.515e-01, 1.784e-01, -1.328e-02, 3.473e-03, 1.846e-01, -1.311e-01, 2.775e-01, 1.262e-01, 8.677e-03, 5.321e-02));
	r += mul(s2_6, M4(3.195e-01, 1.377e-02, -1.920e-01, -9.662e-02, 2.030e-01, 1.059e-02, -1.692e-01, -1.024e-02, -3.002e-02, -7.144e-03, -1.783e-01, -5.337e-02, 1.894e-01, 5.339e-02, 2.365e-02, -9.065e-02));
	r += mul(s2_7, M4(-3.501e-01, 1.304e-01, -3.536e-01, -7.251e-02, 3.473e-02, 9.994e-02, -2.137e-01, -1.372e-01, -1.165e-02, -6.450e-02, -3.175e-01, -6.435e-02, 1.299e-01, -1.793e-01, 1.847e-01, -5.373e-02));
	r += mul(s2_8, M4(2.007e-01, -2.978e-01, 2.092e-01, -1.322e-01, -6.292e-02, 3.227e-01, -3.444e-01, 7.335e-02, 4.040e-03, -5.816e-02, -1.870e-03, -2.017e-02, -1.157e-01, 1.134e-01, -3.315e-02, 4.837e-02));
	r += mul(s3_0, M4(5.560e-02, 2.772e-02, 8.952e-02, 7.943e-02, -1.587e-01, 1.216e-02, 3.493e-03, 3.803e-02, 2.253e-01, 1.839e-01, 4.247e-02, 1.694e-01, -4.995e-02, 3.428e-01, -1.507e-01, 3.553e-01));
	r += mul(s3_1, M4(1.367e-02, -1.897e-01, -9.217e-02, 8.214e-03, 1.802e-01, 7.154e-02, -6.387e-02, 1.552e-02, -3.173e-01, -1.991e-01, 2.504e-01, 5.033e-01, -3.434e-01, 2.710e-03, 7.297e-02, 5.751e-01));
	r += mul(s3_2, M4(-1.310e-02, 2.518e-01, -8.101e-03, -5.719e-02, 1.436e-01, -1.783e-01, -6.461e-02, -4.487e-02, 4.401e-02, -1.240e-02, 1.103e-01, 2.310e-01, 4.486e-02, 5.592e-02, -6.506e-02, -1.333e-01));
	r += mul(s3_3, M4(9.502e-02, 5.695e-02, -1.551e-01, 1.754e-02, 2.585e-02, 3.478e-02, -1.198e-01, 1.182e-01, -1.117e-01, 1.009e-01, -2.105e-01, 1.057e-01, 2.102e-01, 1.993e-01, -3.809e-02, -8.390e-02));
	r += mul(s3_4, M4(-3.507e-01, -2.784e-01, -2.989e-02, -2.785e-01, 4.284e-02, -1.155e-01, 1.934e-01, -1.492e-01, 5.998e-01, -1.442e-01, -9.265e-02, -1.053e-01, -2.690e-01, -2.468e-01, -2.995e-01, -3.690e-02));
	r += mul(s3_5, M4(5.049e-02, 1.616e-01, 1.367e-01, -2.065e-03, -9.968e-02, -1.378e-01, -1.028e-02, 1.187e-01, -6.145e-02, -3.774e-02, 8.126e-02, -3.003e-01, 4.898e-01, -1.995e-01, -1.431e-01, -2.276e-03));
	r += mul(s3_6, M4(4.055e-01, 1.422e-01, -1.436e-01, 3.012e-02, -6.197e-02, 7.033e-02, 4.149e-02, 8.287e-02, -1.137e-01, -1.588e-01, -5.402e-02, 2.393e-02, 2.222e-01, 1.236e-01, 4.226e-02, 2.098e-01));
	r += mul(s3_7, M4(2.309e-02, -9.689e-02, -8.908e-02, -2.339e-01, 1.829e-01, -8.781e-02, 1.132e-01, -3.135e-01, -2.134e-01, 9.304e-02, -2.253e-01, -9.650e-02, -2.415e-03, -1.840e-01, 1.981e-01, -1.488e-01));
	r += mul(s3_8, M4(-1.466e-01, 1.364e-01, 1.174e-01, 5.666e-02, -1.027e-01, 1.929e-01, 8.108e-02, 5.678e-02, -1.460e-01, 8.134e-02, -1.315e-01, 6.725e-02, 1.327e-01, 1.911e-01, -2.188e-01, 7.731e-02));
	r += V4(2.298e-02, -1.923e-02, -2.658e-02, 1.368e-03);
	return r;
}

V4 f1(V4 s0_0, V4 s0_1, V4 s0_2, V4 s0_3, V4 s0_4, V4 s0_5, V4 s0_6, V4 s0_7, V4 s0_8, V4 s1_0, V4 s1_1, V4 s1_2, V4 s1_3, V4 s1_4, V4 s1_5, V4 s1_6, V4 s1_7, V4 s1_8, V4 s2_0, V4 s2_1, V4 s2_2, V4 s2_3, V4 s2_4, V4 s2_5, V4 s2_6, V4 s2_7, V4 s2_8, V4 s3_0, V4 s3_1, V4 s3_2, V4 s3_3, V4 s3_4, V4 s3_5, V4 s3_6, V4 s3_7, V4 s3_8) {
	V4 r = 0.0;
	r += mul(s0_0, M4(-1.130e-01, 1.214e-01, -1.108e-02, 1.352e-01, 6.377e-02, -1.713e-01, 1.967e-02, -1.919e-01, 1.150e-02, -9.545e-04, 1.293e-01, 6.316e-02, 1.290e-02, -8.948e-02, 6.572e-02, 1.822e-02));
	r += mul(s0_1, M4(2.092e-01, 2.239e-01, -8.298e-02, 2.838e-01, -2.186e-01, 2.432e-01, -1.698e-01, 1.926e-01, -4.677e-01, -1.034e-02, -1.518e-01, 1.623e-02, -1.795e-02, 5.413e-02, -5.460e-02, 2.335e-02));
	r += mul(s0_2, M4(2.608e-01, 1.430e-01, -1.394e-02, 7.100e-02, 6.597e-02, 8.825e-02, 7.601e-02, -1.882e-02, -1.082e-01, 7.205e-02, 1.003e-01, -1.760e-01, 2.237e-01, -9.588e-02, -1.699e-02, 4.950e-02));
	r += mul(s0_3, M4(-1.373e-01, -1.715e-01, -1.798e-01, 7.263e-02, 1.256e-02, -2.401e-01, -1.070e-01, -1.565e-01, 1.507e-01, 1.169e-01, 4.934e-02, 1.995e-02, -8.259e-02, 2.094e-01, -6.138e-02, -7.254e-02));
	r += mul(s0_4, M4(-2.767e-01, -4.899e-01, -7.727e-01, -1.497e-01, -3.017e-03, -3.284e-02, 2.596e-01, -4.209e-01, -1.953e-01, 1.452e-01, 7.560e-03, -3.027e-01, -1.194e-01, 1.329e-01, -1.687e-01, 1.195e-01));
	r += mul(s0_5, M4(-1.280e-01, -3.473e-01, -9.935e-02, -1.362e-01, 7.692e-02, 1.451e-01, 1.568e-02, 6.818e-02, 6.812e-02, -3.212e-01, -6.089e-03, -2.132e-01, -1.721e-01, -1.182e-01, -5.266e-02, -1.555e-01));
	r += mul(s0_6, M4(-3.717e-02, -4.738e-02, -2.076e-01, 4.773e-02, -8.280e-02, -9.293e-02, -6.792e-02, -8.102e-02, 7.954e-02, 2.675e-02, 1.215e-02, 3.023e-02, -7.328e-03, -7.478e-02, 7.216e-02, 2.117e-01));
	r += mul(s0_7, M4(-1.612e-01, -3.211e-01, -2.805e-01, -5.244e-01, -5.702e-02, -6.611e-03, -5.634e-02, 1.504e-01, 1.134e-01, -6.816e-02, -3.059e-02, 2.929e-02, 8.199e-02, -1.340e-01, -5.846e-02, -1.619e-01));
	r += mul(s0_8, M4(-6.973e-02, -5.321e-01, 1.599e-02, -6.657e-02, 5.820e-02, 3.689e-02, 3.444e-02, -6.053e-02, 2.894e-02, -9.890e-02, 9.278e-02, -1.179e-01, -5.478e-02, -1.127e-01, -8.066e-03, 9.613e-03));
	r += mul(s1_0, M4(-4.428e-02, 6.076e-02, -4.348e-02, 9.205e-02, -3.087e-02, -2.955e-02, -1.082e-01, -1.677e-01, 6.964e-02, -6.678e-02, 1.186e-02, 4.676e-02, 1.122e-01, 2.608e-02, -7.710e-02, 1.314e-02));
	r += mul(s1_1, M4(3.823e-02, 9.601e-02, -3.015e-02, 1.601e-01, -3.331e-01, 4.881e-02, 1.877e-01, 4.381e-02, -4.786e-02, -6.752e-02, -1.870e-01, -1.172e-01, 3.151e-01, -1.060e-01, -2.141e-01, 1.811e-02));
	r += mul(s1_2, M4(1.288e-01, 7.224e-02, 1.647e-01, 9.426e-02, -1.369e-01, -3.410e-02, 2.160e-02, -2.060e-02, 1.585e-01, 1.380e-01, -1.537e-01, 1.532e-01, 2.734e-01, 4.569e-03, -7.428e-02, 4.233e-02));
	r += mul(s1_3, M4(1.178e-01, -2.371e-02, 1.479e-01, -2.215e-01, 1.109e-01, -1.197e-01, -1.628e-01, -4.200e-01, -1.274e-01, -3.016e-02, -2.777e-02, -7.318e-02, 1.257e-01, 3.237e-01, 2.290e-01, 1.030e-01));
	r += mul(s1_4, M4(4.789e-01, 4.644e-02, -1.997e-01, -7.073e-01, 4.108e-02, -2.901e-01, 3.818e-01, -4.996e-01, -1.879e-01, 5.111e-02, -1.602e-01, 4.706e-02, -7.003e-01, -1.329e-01, -9.032e-01, 1.350e-01));
	r += mul(s1_5, M4(4.773e-01, 1.039e-01, 8.412e-02, 1.490e-01, 3.035e-02, 1.400e-01, -6.338e-02, 8.991e-02, 4.904e-01, 3.650e-01, -3.968e-02, 3.972e-01, -2.319e-01, -4.904e-02, -5.767e-01, -2.348e-02));
	r += mul(s1_6, M4(-7.230e-02, 6.087e-02, -2.064e-02, -6.899e-03, -1.217e-01, -1.687e-01, -1.857e-01, -1.239e-01, -6.371e-02, 6.974e-02, 1.337e-02, 8.767e-02, 2.289e-01, 4.729e-01, 9.679e-02, 1.118e-01));
	r += mul(s1_7, M4(-5.391e-02, 4.743e-02, -4.716e-02, 1.767e-01, -4.998e-02, -2.546e-01, 8.780e-02, 4.767e-02, -7.362e-03, -6.664e-02, 1.749e-01, 7.709e-02, -2.150e-01, -8.501e-02, -3.625e-01, -1.570e-01));
	r += mul(s1_8, M4(1.795e-01, -1.680e-01, 5.013e-02, 8.052e-02, 4.902e-02, 8.731e-03, 1.408e-02, 3.582e-02, -8.009e-02, 3.017e-02, -2.784e-02, 8.367e-02, 1.287e-01, 8.771e-02, -3.202e-02, 2.532e-02));
	r += mul(s2_0, M4(-1.419e-02, -1.381e-01, 1.070e-02, 1.267e-01, 5.872e-02, 8.846e-02, 1.327e-01, 3.797e-02, -9.500e-02, -4.932e-02, -1.433e-02, -5.332e-02, -9.478e-02, -4.424e-02, 1.445e-02, 1.336e-01));
	r += mul(s2_1, M4(-2.619e-01, 2.202e-01, 8.033e-02, 3.468e-01, 3.048e-01, -1.002e-02, -1.701e-01, -6.405e-02, 3.158e-02, -1.062e-01, 1.464e-01, 1.837e-01, 7.958e-02, 5.367e-03, -9.772e-02, 5.937e-02));
	r += mul(s2_2, M4(4.148e-01, -9.892e-02, -1.164e-01, 9.342e-02, -2.268e-01, 3.121e-02, -1.576e-01, -4.941e-02, -3.639e-01, -6.088e-02, -2.668e-02, -3.922e-02, 2.593e-02, 9.331e-02, 8.824e-02, 6.521e-03));
	r += mul(s2_3, M4(-2.006e-01, -6.678e-02, 3.283e-01, 4.849e-01, 1.016e-01, -1.125e-01, -1.296e-01, -1.680e-01, 2.772e-01, 1.909e-01, 3.458e-01, -1.367e-01, 5.993e-02, 2.428e-01, 1.871e-02, -1.480e-01));
	r += mul(s2_4, M4(-1.486e-02, 3.916e-01, 1.216e-01, -4.918e-01, -5.480e-02, 1.275e-01, -1.182e-01, 5.374e-01, -6.052e-02, 3.231e-01, 3.526e-02, -1.833e-01, -6.420e-02, -1.273e-03, -1.800e-01, 7.652e-02));
	r += mul(s2_5, M4(-2.349e-01, 7.653e-02, 8.108e-02, 1.898e-01, -1.317e-01, -2.513e-01, -2.790e-02, -3.601e-02, 2.290e-01, -1.461e-01, 8.279e-02, 1.899e-01, -4.883e-02, 8.442e-02, -5.347e-02, -4.900e-02));
	r += mul(s2_6, M4(-3.134e-01, 8.996e-02, 3.181e-02, -1.457e-01, -9.578e-02, 1.116e-01, -6.355e-02, -1.488e-01, -2.890e-02, 2.076e-02, 6.027e-02, 1.788e-02, 1.403e-01, 8.653e-02, 1.352e-01, -6.965e-02));
	r += mul(s2_7, M4(2.188e-01, 2.762e-01, 8.939e-02, 2.626e-01, 2.829e-01, 1.395e-02, -2.333e-02, -3.416e-02, 1.208e-02, 5.859e-02, 2.510e-01, 3.831e-01, -1.118e-01, -6.555e-03, -4.403e-02, -4.370e-02));
	r += mul(s2_8, M4(1.361e-02, 1.759e-01, -6.858e-02, 1.548e-01, -9.035e-03, -1.969e-01, -1.406e-01, 4.979e-02, 1.587e-02, -1.111e-01, -1.971e-02, 3.073e-02, 5.107e-02, 1.063e-02, -1.163e-02, 4.328e-02));
	r += mul(s3_0, M4(-3.105e-02, -3.297e-03, -1.346e-02, 3.279e-02, -6.446e-02, -8.300e-03, 1.195e-02, 1.704e-02, -2.825e-02, -7.198e-02, -1.241e-01, -5.453e-03, -1.010e-01, -2.661e-01, -1.093e-01, -4.753e-01));
	r += mul(s3_1, M4(6.416e-02, 3.290e-03, -6.664e-02, 3.536e-02, 1.340e-01, 6.209e-02, 1.751e-02, 3.663e-02, 1.215e-01, 2.067e-01, 2.157e-02, 2.474e-01, 8.811e-02, 3.345e-01, -1.319e-01, 4.883e-01));
	r += mul(s3_2, M4(-2.049e-01, 3.166e-02, 2.001e-02, 1.423e-04, 6.755e-02, 2.682e-02, -1.911e-02, 5.750e-02, 2.807e-02, -8.508e-02, 9.625e-03, -4.121e-02, 5.264e-01, -1.940e-01, 1.523e-02, 1.072e-01));
	r += mul(s3_3, M4(-3.709e-02, -2.069e-02, 2.408e-01, 2.808e-02, 3.065e-02, -1.316e-01, -4.231e-02, -9.350e-02, 8.105e-02, -1.048e-01, 1.708e-01, -8.174e-02, 3.743e-01, -3.742e-02, 2.901e-01, 7.091e-01));
	r += mul(s3_4, M4(-1.409e-01, -2.233e-02, 2.452e-02, -2.700e-01, -2.514e-01, 1.795e-01, 1.342e-01, 7.064e-01, -3.364e-01, 1.200e-01, -4.678e-01, -1.900e-01, -5.496e-01, 2.325e-01, -2.933e-02, 6.220e-01));
	r += mul(s3_5, M4(-1.505e-01, 1.194e-01, -1.962e-02, 8.578e-02, -1.999e-01, -1.274e-01, -1.435e-01, -2.373e-01, 3.485e-01, -1.336e-01, 2.627e-01, 1.902e-02, -4.103e-01, -2.210e-01, 4.443e-01, -5.294e-01));
	r += mul(s3_6, M4(1.998e-01, 6.277e-02, -3.951e-02, 5.659e-02, -1.930e-02, -4.212e-02, -5.306e-02, -1.381e-01, -1.701e-01, 1.967e-01, 1.383e-02, -2.463e-01, 2.810e-01, 2.186e-01, 2.522e-01, -5.045e-01));
	r += mul(s3_7, M4(2.436e-01, 1.870e-01, 8.677e-03, -4.233e-02, 4.271e-01, 2.146e-01, 8.672e-02, -2.921e-01, 1.262e-03, -2.255e-01, 9.194e-03, 1.431e-01, 4.044e-02, 4.419e-01, -1.759e-01, 1.003e-01));
	r += mul(s3_8, M4(-3.728e-02, -2.172e-01, -1.118e-01, 7.946e-02, -4.604e-02, 2.679e-02, 2.423e-02, -5.371e-03, 1.024e-01, -7.889e-02, -3.896e-02, -8.837e-03, 9.574e-02, -3.400e-01, 1.938e-01, -4.385e-01));
	r += V4(2.654e-02, 3.773e-02, -2.198e-02, -1.098e-02);
	return r;
}

void Pass3(uint2 blockStart, uint3 tid) {
	float2 pt = float2(GetInputPt());
	uint2 gxy = Rmp8x8(tid.x) + blockStart;
	uint2 size = GetInputSize();
	if (gxy.x >= size.x || gxy.y >= size.y) {
		return;
	}
	float2 pos = (gxy + 0.5) * pt;

	V4 s0_0 = l0(-1.0, -1.0);
	V4 s0_1 = l0(0.0, -1.0);
	V4 s0_2 = l0(1.0, -1.0);
	V4 s0_3 = l0(-1.0, 0.0);
	V4 s0_4 = l0(0.0, 0.0);
	V4 s0_5 = l0(1.0, 0.0);
	V4 s0_6 = l0(-1.0, 1.0);
	V4 s0_7 = l0(0.0, 1.0);
	V4 s0_8 = l0(1.0, 1.0);
	V4 s1_0 = -max(-s0_0, 0.0);
	V4 s1_1 = -max(-s0_1, 0.0);
	V4 s1_2 = -max(-s0_2, 0.0);
	V4 s1_3 = -max(-s0_3, 0.0);
	V4 s1_4 = -max(-s0_4, 0.0);
	V4 s1_5 = -max(-s0_5, 0.0);
	V4 s1_6 = -max(-s0_6, 0.0);
	V4 s1_7 = -max(-s0_7, 0.0);
	V4 s1_8 = -max(-s0_8, 0.0);
	s0_0 = max(s0_0, 0.0);
	s0_1 = max(s0_1, 0.0);
	s0_2 = max(s0_2, 0.0);
	s0_3 = max(s0_3, 0.0);
	s0_4 = max(s0_4, 0.0);
	s0_5 = max(s0_5, 0.0);
	s0_6 = max(s0_6, 0.0);
	s0_7 = max(s0_7, 0.0);
	s0_8 = max(s0_8, 0.0);

	V4 s2_0 = l1(-1.0, -1.0);
	V4 s2_1 = l1(0.0, -1.0);
	V4 s2_2 = l1(1.0, -1.0);
	V4 s2_3 = l1(-1.0, 0.0);
	V4 s2_4 = l1(0.0, 0.0);
	V4 s2_5 = l1(1.0, 0.0);
	V4 s2_6 = l1(-1.0, 1.0);
	V4 s2_7 = l1(0.0, 1.0);
	V4 s2_8 = l1(1.0, 1.0);
	V4 s3_0 = -max(-s2_0, 0.0);
	V4 s3_1 = -max(-s2_1, 0.0);
	V4 s3_2 = -max(-s2_2, 0.0);
	V4 s3_3 = -max(-s2_3, 0.0);
	V4 s3_4 = -max(-s2_4, 0.0);
	V4 s3_5 = -max(-s2_5, 0.0);
	V4 s3_6 = -max(-s2_6, 0.0);
	V4 s3_7 = -max(-s2_7, 0.0);
	V4 s3_8 = -max(-s2_8, 0.0);
	s2_0 = max(s2_0, 0.0);
	s2_1 = max(s2_1, 0.0);
	s2_2 = max(s2_2, 0.0);
	s2_3 = max(s2_3, 0.0);
	s2_4 = max(s2_4, 0.0);
	s2_5 = max(s2_5, 0.0);
	s2_6 = max(s2_6, 0.0);
	s2_7 = max(s2_7, 0.0);
	s2_8 = max(s2_8, 0.0);

	t0[gxy] = f0(s0_0, s0_1, s0_2, s0_3, s0_4, s0_5, s0_6, s0_7, s0_8, s1_0, s1_1, s1_2, s1_3, s1_4, s1_5, s1_6, s1_7, s1_8, s2_0, s2_1, s2_2, s2_3, s2_4, s2_5, s2_6, s2_7, s2_8, s3_0, s3_1, s3_2, s3_3, s3_4, s3_5, s3_6, s3_7, s3_8);
	t1[gxy] = f1(s0_0, s0_1, s0_2, s0_3, s0_4, s0_5, s0_6, s0_7, s0_8, s1_0, s1_1, s1_2, s1_3, s1_4, s1_5, s1_6, s1_7, s1_8, s2_0, s2_1, s2_2, s2_3, s2_4, s2_5, s2_6, s2_7, s2_8, s3_0, s3_1, s3_2, s3_3, s3_4, s3_5, s3_6, s3_7, s3_8);
}

//!PASS 4
//!DESC conv3
//!BLOCK_SIZE 8
//!NUM_THREADS 64
//!IN t0, t1
//!OUT t2, t3

#define l0(x, y) V4(O(t0, float2(x, y)))
#define l1(x, y) V4(O(t1, float2(x, y)))

V4 f0(V4 s0_0, V4 s0_1, V4 s0_2, V4 s0_3, V4 s0_4, V4 s0_5, V4 s0_6, V4 s0_7, V4 s0_8, V4 s1_0, V4 s1_1, V4 s1_2, V4 s1_3, V4 s1_4, V4 s1_5, V4 s1_6, V4 s1_7, V4 s1_8, V4 s2_0, V4 s2_1, V4 s2_2, V4 s2_3, V4 s2_4, V4 s2_5, V4 s2_6, V4 s2_7, V4 s2_8, V4 s3_0, V4 s3_1, V4 s3_2, V4 s3_3, V4 s3_4, V4 s3_5, V4 s3_6, V4 s3_7, V4 s3_8) {
	V4 r = 0.0;
	r += mul(s0_0, M4(-9.930e-02, -8.715e-02, -9.548e-02, -1.855e-02, 1.095e-01, 2.065e-01, 1.197e-01, -1.570e-02, 1.574e-01, 1.091e-01, -6.599e-02, 4.981e-03, -1.202e-02, -1.267e-02, -3.307e-02, -4.164e-02));
	r += mul(s0_1, M4(-5.548e-02, -8.579e-02, -1.219e-01, -2.839e-03, 8.177e-02, 3.298e-02, 2.258e-02, -9.106e-02, 1.195e-01, -8.941e-03, 2.294e-02, 3.104e-02, 5.574e-02, 9.188e-02, 3.466e-02, -3.615e-02));
	r += mul(s0_2, M4(-6.549e-02, -9.322e-02, 1.286e-02, -6.585e-03, -9.047e-02, -4.453e-02, -4.657e-02, 4.226e-02, 1.639e-01, 2.342e-01, -1.120e-02, -4.821e-02, -1.004e-01, -2.352e-03, -2.815e-02, 3.063e-02));
	r += mul(s0_3, M4(2.220e-02, 5.185e-03, 1.132e-01, 1.700e-01, 1.671e-01, -1.331e-03, -4.262e-02, -5.368e-01, -2.847e-01, -6.449e-02, -1.573e-01, -1.291e-01, 1.065e-01, -3.527e-02, 2.175e-02, -9.759e-02));
	r += mul(s0_4, M4(-6.274e-02, 5.046e-02, -7.344e-02, -1.713e-02, 3.599e-02, -1.940e-01, 4.244e-02, 5.161e-02, -2.285e-01, 2.347e-01, -1.516e-01, 4.668e-02, 5.899e-02, 4.766e-01, 2.878e-02, -1.491e-01));
	r += mul(s0_5, M4(1.430e-02, -1.483e-01, 1.337e-01, 5.809e-02, -1.794e-02, 3.310e-02, -6.586e-02, -2.245e-02, 4.123e-01, -5.310e-02, 2.135e-01, 1.468e-02, -2.746e-01, 6.546e-02, -2.512e-01, 6.142e-02));
	r += mul(s0_6, M4(4.337e-02, -2.250e-02, 1.685e-01, 5.046e-02, -4.996e-01, -8.999e-02, -3.918e-01, -1.998e-02, -5.723e-02, -1.890e-01, -7.521e-02, -1.420e-02, 2.147e-01, -7.020e-02, -1.031e-01, 7.691e-02));
	r += mul(s0_7, M4(6.315e-04, -9.858e-02, -1.540e-01, 2.171e-02, 3.620e-01, -1.191e-01, 1.217e-01, 8.591e-02, 2.791e-02, 9.235e-02, -2.327e-02, -9.034e-03, 2.280e-01, 4.347e-01, -3.150e-01, 8.650e-02));
	r += mul(s0_8, M4(-2.714e-02, -2.215e-01, 1.516e-01, -3.802e-02, -1.612e-02, -5.077e-02, -1.311e-01, 2.074e-02, 2.457e-02, 7.442e-02, 1.970e-03, 1.698e-02, -2.027e-01, 6.232e-02, -2.108e-01, -1.618e-02));
	r += mul(s1_0, M4(1.029e-01, 5.622e-02, -1.224e-01, 6.814e-02, 1.126e-01, 1.469e-01, 3.430e-02, -2.006e-02, 9.965e-03, 1.500e-01, 3.369e-01, 4.728e-02, -1.169e-01, 7.054e-02, -3.382e-02, 3.463e-02));
	r += mul(s1_1, M4(1.890e-04, 2.958e-01, -9.510e-02, 6.847e-02, 1.335e-01, 1.174e-01, -4.600e-02, -1.080e-01, 1.446e-01, 1.380e-01, -1.213e-03, 5.221e-02, -7.797e-03, -7.192e-02, -2.139e-02, -1.013e-01));
	r += mul(s1_2, M4(-1.966e-02, -7.701e-02, -1.022e-01, -2.180e-02, -1.363e-02, -4.144e-02, -1.094e-01, 1.956e-02, 4.011e-02, -1.149e-01, 9.707e-02, -5.067e-02, -1.240e-01, -4.850e-02, 5.535e-04, -7.421e-02));
	r += mul(s1_3, M4(-1.511e-01, 2.479e-01, -2.632e-02, 2.342e-01, 1.382e-01, 2.093e-01, -2.834e-01, -4.066e-01, -1.914e-01, 6.572e-02, 2.396e-03, -2.234e-01, 7.510e-02, 7.839e-02, -4.164e-02, 3.453e-02));
	r += mul(s1_4, M4(-2.032e-01, 4.775e-01, -3.155e-01, 4.759e-02, -3.128e-03, 7.992e-02, -1.580e-01, 1.370e-01, 7.606e-02, -2.428e-01, -3.431e-01, 8.765e-02, 1.948e-01, 3.910e-02, 1.793e-01, -2.253e-01));
	r += mul(s1_5, M4(-6.497e-02, 3.718e-01, -1.607e-01, 1.969e-01, 1.130e-01, 1.543e-01, -6.874e-02, 3.665e-02, -2.082e-02, -1.314e-01, 1.726e-01, -3.860e-02, -1.390e-01, -6.533e-02, 1.400e-02, -1.440e-02));
	r += mul(s1_6, M4(2.533e-02, 4.261e-01, -4.830e-02, -3.112e-02, -4.698e-01, 1.500e-01, -3.778e-01, -4.040e-02, 1.883e-01, -4.829e-02, -1.404e-01, 1.089e-01, -7.179e-02, -2.045e-01, -9.545e-02, 1.307e-01));
	r += mul(s1_7, M4(1.579e-01, 5.817e-01, -3.106e-01, 2.197e-01, 1.791e-01, -5.029e-02, -2.680e-01, 8.439e-02, -3.268e-02, 3.793e-01, 4.710e-02, -7.101e-02, -4.163e-01, -5.762e-01, 6.999e-02, -3.126e-02));
	r += mul(s1_8, M4(-2.019e-01, 2.995e-01, -1.985e-01, 3.372e-02, -1.814e-03, -8.885e-02, -1.580e-01, 5.131e-02, -3.058e-01, 1.882e-01, -1.935e-01, -9.108e-04, -1.722e-01, -1.703e-01, 2.751e-02, -1.436e-01));
	r += mul(s2_0, M4(-1.572e-01, 7.107e-02, 1.546e-01, 7.852e-02, 2.804e-01, 9.207e-02, 1.863e-01, -2.990e-02, 7.031e-02, 7.487e-03, -2.383e-01, 9.415e-02, -4.405e-02, -2.135e-01, 4.289e-02, -1.969e-02));
	r += mul(s2_1, M4(1.009e-01, 6.349e-02, -1.495e-03, 1.668e-02, -3.615e-02, -1.591e-01, -2.520e-01, 6.259e-03, 6.579e-02, -1.644e-01, -5.543e-02, -5.906e-02, -9.854e-02, 8.397e-02, 8.320e-02, -8.373e-02));
	r += mul(s2_2, M4(-3.516e-02, 1.545e-03, 3.351e-03, -3.178e-02, 1.191e-01, -9.185e-02, 2.679e-01, 3.951e-02, 1.385e-01, -8.283e-02, -4.421e-02, 6.449e-02, -1.340e-01, -8.220e-02, -1.149e-02, -3.884e-02));
	r += mul(s2_3, M4(-9.423e-02, -5.891e-02, 2.833e-01, 1.868e-01, 5.074e-02, 1.226e-01, -1.307e-01, -2.509e-01, -1.022e-01, 2.094e-02, 1.032e-01, 9.668e-02, 1.411e-01, -6.280e-02, 1.329e-02, 8.977e-02));
	r += mul(s2_4, M4(1.336e-01, -6.825e-02, 9.910e-02, 6.299e-03, -3.647e-01, -1.297e-01, -5.259e-02, -2.980e-01, 4.552e-01, 1.724e-01, 2.430e-01, -4.053e-01, 6.858e-02, 2.330e-01, -1.802e-01, -2.499e-01));
	r += mul(s2_5, M4(2.282e-01, -5.794e-03, 6.329e-02, -1.208e-01, 2.021e-01, -2.298e-02, 1.093e-01, 6.128e-02, -5.259e-02, 1.390e-01, -1.171e-01, 1.162e-01, -1.808e-01, 2.376e-01, -3.242e-01, -4.872e-03));
	r += mul(s2_6, M4(9.993e-03, 2.233e-01, 2.358e-01, 7.060e-02, -2.864e-02, -7.382e-02, -2.750e-01, 1.675e-01, -1.010e-01, 6.265e-02, 3.681e-02, -4.289e-02, -4.836e-03, 3.679e-02, -8.175e-02, -1.268e-02));
	r += mul(s2_7, M4(-4.403e-01, 1.954e-01, 1.783e-01, -2.415e-03, 2.802e-02, -1.300e-01, -1.612e-01, -1.006e-01, 3.618e-02, -1.846e-01, 2.350e-02, 1.274e-01, -6.638e-02, 9.782e-02, -6.339e-02, 2.921e-02));
	r += mul(s2_8, M4(-3.557e-02, 3.254e-02, -1.660e-02, -8.243e-02, 1.413e-01, 9.227e-02, -2.222e-02, 1.104e-01, 1.241e-01, 2.385e-01, -7.126e-02, 1.685e-01, -2.223e-02, 1.654e-01, -1.238e-01, 2.770e-02));
	r += mul(s3_0, M4(3.766e-02, -1.169e-01, -1.768e-01, 1.940e-02, -1.264e-01, 6.004e-02, 7.806e-02, -5.408e-02, -5.266e-02, 1.241e-01, 5.232e-02, 5.166e-02, -1.548e-01, -2.214e-02, -1.899e-02, 3.862e-02));
	r += mul(s3_1, M4(1.318e-01, -1.692e-02, -2.739e-02, 8.390e-02, -2.753e-01, 9.796e-02, -1.220e-01, 3.006e-02, 7.237e-02, -1.026e-01, -4.912e-02, -5.414e-02, 1.599e-02, 1.103e-02, 2.587e-01, -1.008e-01));
	r += mul(s3_2, M4(-2.140e-02, -1.934e-02, 2.338e-02, 3.088e-02, 3.095e-02, -1.189e-01, 1.848e-01, -1.983e-02, 1.788e-02, -8.243e-02, -4.502e-03, -3.665e-02, 5.258e-02, -9.368e-02, 8.604e-02, -6.375e-02));
	r += mul(s3_3, M4(3.559e-02, -4.663e-01, -1.866e-01, 9.592e-02, 1.656e-01, -2.107e-02, 1.781e-01, -1.324e-01, -1.047e-01, 4.386e-02, 3.693e-02, 6.419e-02, 3.781e-02, -1.108e-01, 3.440e-01, 1.116e-01));
	r += mul(s3_4, M4(9.007e-02, -1.986e-01, -2.803e-02, 1.300e-01, -2.704e-02, 4.319e-02, 3.338e-02, -9.694e-02, 3.277e-01, -2.424e-02, 3.779e-01, -5.205e-01, 1.618e-01, 1.366e-01, 8.522e-02, -2.863e-01));
	r += mul(s3_5, M4(1.929e-01, 3.554e-02, -8.457e-03, 6.138e-02, -1.672e-02, -1.217e-01, 1.997e-01, -8.514e-02, -6.749e-02, 5.450e-02, 7.215e-03, -7.587e-02, -3.529e-02, -1.021e-02, 5.863e-02, 2.202e-02));
	r += mul(s3_6, M4(1.631e-01, -1.250e-01, 7.616e-03, 1.028e-01, -1.353e-01, -3.640e-01, -1.947e-01, -9.438e-02, -5.227e-02, -1.033e-01, -1.453e-02, -1.795e-02, 1.948e-01, -7.952e-02, 1.281e-01, -1.553e-02));
	r += mul(s3_7, M4(-4.316e-01, 6.337e-02, -6.498e-02, 7.992e-04, 1.663e-01, -1.837e-01, 1.463e-01, -8.458e-02, -9.212e-02, -6.334e-02, -1.500e-01, 1.331e-01, -8.807e-02, 1.654e-01, 7.674e-03, -3.696e-03));
	r += mul(s3_8, M4(8.960e-02, 1.206e-02, -1.317e-01, 1.738e-02, -1.972e-02, 7.104e-02, 9.549e-03, 3.120e-04, -5.724e-02, -1.955e-02, -9.568e-02, 1.298e-01, -1.468e-01, 9.693e-02, 1.818e-02, -3.696e-02));
	r += V4(-5.503e-03, -1.971e-02, 4.307e-02, 2.403e-03);
	return r;
}

V4 f1(V4 s0_0, V4 s0_1, V4 s0_2, V4 s0_3, V4 s0_4, V4 s0_5, V4 s0_6, V4 s0_7, V4 s0_8, V4 s1_0, V4 s1_1, V4 s1_2, V4 s1_3, V4 s1_4, V4 s1_5, V4 s1_6, V4 s1_7, V4 s1_8, V4 s2_0, V4 s2_1, V4 s2_2, V4 s2_3, V4 s2_4, V4 s2_5, V4 s2_6, V4 s2_7, V4 s2_8, V4 s3_0, V4 s3_1, V4 s3_2, V4 s3_3, V4 s3_4, V4 s3_5, V4 s3_6, V4 s3_7, V4 s3_8) {
	V4 r = 0.0;
	r += mul(s0_0, M4(-8.596e-02, -5.285e-02, 5.158e-02, 8.907e-02, 4.899e-02, -2.187e-02, -3.438e-02, -1.706e-01, -7.313e-02, -6.446e-03, -1.219e-01, 5.467e-02, 1.417e-02, 8.520e-02, 6.738e-02, -3.482e-02));
	r += mul(s0_1, M4(3.106e-02, -2.627e-03, 1.389e-02, 3.474e-02, 3.618e-02, -1.077e-01, -4.858e-02, -8.000e-02, 1.019e-01, -9.408e-02, -1.601e-01, 1.003e-01, -7.328e-03, 1.167e-01, 1.367e-01, -1.538e-01));
	r += mul(s0_2, M4(-1.290e-01, -7.244e-02, 4.047e-04, 5.332e-02, -5.096e-02, -6.015e-02, 4.490e-02, -4.033e-02, 1.587e-01, -6.248e-02, -2.208e-01, -5.304e-02, 5.434e-02, 1.597e-01, 3.131e-02, -3.238e-02));
	r += mul(s0_3, M4(-3.771e-02, -8.350e-02, -8.219e-02, 2.164e-02, -5.266e-02, 1.337e-01, 5.790e-02, -3.579e-02, 1.371e-01, 7.213e-02, 2.308e-01, 1.958e-01, -9.141e-02, 1.143e-01, 7.658e-02, -4.488e-02));
	r += mul(s0_4, M4(1.631e-02, -2.806e-02, 1.665e-01, -1.948e-02, -1.633e-01, -2.538e-03, -1.970e-01, 2.337e-02, 9.817e-02, 3.921e-01, -1.388e-01, 4.121e-02, 8.042e-03, -5.681e-02, 2.117e-01, -8.773e-02));
	r += mul(s0_5, M4(-1.510e-01, -7.396e-02, 1.387e-01, 1.461e-01, -1.826e-01, -2.693e-02, 9.142e-02, 9.284e-02, -1.825e-01, -9.509e-02, 6.374e-02, -1.388e-01, -8.189e-02, 1.223e-01, -1.750e-02, 1.406e-01));
	r += mul(s0_6, M4(1.135e-02, -9.048e-02, -1.223e-01, 2.888e-02, 1.880e-01, 1.797e-01, 4.345e-01, -8.939e-02, -1.525e-01, 5.877e-02, -9.220e-02, 6.612e-02, 2.258e-02, 1.177e-01, -8.183e-02, 8.373e-03));
	r += mul(s0_7, M4(1.696e-01, 1.752e-01, -6.929e-02, 1.645e-01, 8.546e-02, 9.341e-02, 1.696e-01, -3.056e-02, -7.792e-02, 8.699e-02, 1.695e-01, -3.911e-03, -2.366e-01, 8.806e-02, -4.111e-01, -1.648e-02));
	r += mul(s0_8, M4(5.684e-02, -8.478e-02, -1.300e-01, 9.553e-02, -1.272e-02, -9.817e-03, 5.397e-02, 8.448e-02, -1.665e-02, 1.940e-02, -1.479e-01, -1.231e-01, -1.558e-01, 4.587e-02, 9.477e-02, 1.733e-01));
	r += mul(s1_0, M4(4.928e-02, 1.630e-01, 3.530e-02, -2.609e-01, 2.080e-02, 2.517e-02, -5.341e-02, 2.393e-02, 2.070e-01, -7.999e-02, -5.407e-02, 9.927e-02, 1.005e-01, -1.452e-01, -1.293e-01, 1.179e-03));
	r += mul(s1_1, M4(4.045e-01, 1.635e-01, -7.885e-02, -2.496e-01, 8.646e-02, -9.838e-02, -6.499e-02, -5.604e-02, -1.479e-01, 8.245e-02, 2.084e-01, 3.130e-02, 3.350e-02, -1.592e-01, -3.301e-03, -1.571e-01));
	r += mul(s1_2, M4(1.435e-01, -1.269e-01, 4.380e-02, -9.012e-02, 5.184e-02, 3.579e-02, -8.166e-02, -2.591e-02, 2.181e-01, -2.666e-01, -1.091e-01, 1.673e-01, 6.085e-02, -2.818e-02, 2.975e-02, -1.134e-01));
	r += mul(s1_3, M4(4.309e-02, -3.624e-02, 3.632e-02, -1.492e-01, 1.492e-01, 1.318e-01, -3.694e-02, 2.850e-01, 2.685e-01, -6.430e-02, 1.423e-01, -1.073e-01, 7.645e-04, -1.715e-01, -2.463e-02, 6.346e-02));
	r += mul(s1_4, M4(7.196e-01, -1.132e-01, -4.236e-02, -4.937e-01, 1.175e-01, 4.154e-02, -3.213e-01, 1.145e-02, -2.131e-01, 2.879e-02, -2.353e-01, 1.775e-01, 4.716e-02, 4.443e-02, -1.883e-03, 1.204e-01));
	r += mul(s1_5, M4(4.435e-01, 3.854e-01, -1.692e-01, -1.702e-01, -6.404e-02, 1.060e-01, -2.896e-02, 2.275e-02, 9.162e-03, -2.673e-01, -1.698e-01, -1.770e-01, -1.354e-01, 9.096e-02, -1.099e-01, 3.785e-01));
	r += mul(s1_6, M4(2.284e-01, 1.976e-02, -1.113e-01, -2.744e-01, 1.518e-01, 8.682e-02, 3.085e-01, 1.258e-01, -3.514e-02, 9.450e-02, -4.096e-02, -2.853e-02, -8.595e-03, -3.154e-01, -3.680e-02, 2.172e-01));
	r += mul(s1_7, M4(1.785e-01, 1.978e-01, -1.906e-02, 2.771e-02, 1.501e-01, 2.575e-02, 2.389e-01, 3.010e-01, 1.457e-01, -4.462e-02, -2.300e-01, -1.614e-01, -2.747e-01, -7.497e-02, -4.463e-01, 2.659e-01));
	r += mul(s1_8, M4(3.257e-01, 1.932e-01, -5.289e-03, 3.878e-03, -1.571e-01, 4.645e-03, 7.888e-03, 1.243e-01, 5.842e-02, -2.256e-02, -6.602e-03, -3.731e-02, -7.605e-02, -3.408e-01, -1.688e-01, -5.470e-03));
	r += mul(s2_0, M4(-3.495e-02, -1.928e-02, 4.994e-02, 1.395e-01, -1.112e-01, 1.772e-01, -1.634e-01, -3.699e-02, 1.127e-01, 6.082e-03, -5.189e-02, -4.303e-02, -7.775e-02, -6.178e-02, -7.501e-02, 1.320e-01));
	r += mul(s2_1, M4(-4.850e-02, -1.289e-01, -9.325e-02, -1.643e-02, 2.239e-01, -9.011e-02, -2.566e-02, 5.301e-02, 1.855e-01, -9.348e-02, -1.585e-02, -2.001e-01, -5.371e-02, -5.272e-02, 1.356e-01, 1.703e-01));
	r += mul(s2_2, M4(1.056e-01, -6.602e-02, -3.005e-02, 9.795e-03, 5.049e-02, -9.108e-02, 3.054e-02, -1.752e-01, -1.561e-01, 3.075e-01, 8.300e-02, -8.430e-02, 1.265e-02, -2.776e-01, -5.878e-02, 1.144e-02));
	r += mul(s2_3, M4(1.382e-01, -2.842e-01, -2.699e-02, -2.153e-01, 2.187e-01, 2.651e-01, 1.307e-01, 1.926e-01, 5.445e-02, -2.797e-01, -8.728e-02, 7.571e-02, 6.814e-02, -1.233e-01, -3.357e-02, 1.947e-01));
	r += mul(s2_4, M4(-1.063e-02, 1.618e-01, -1.176e-01, 8.081e-02, -4.808e-02, 2.455e-02, -4.511e-02, -1.988e-01, 7.006e-02, -5.232e-01, 1.190e-01, 1.209e-01, 1.514e-03, -3.750e-02, -3.545e-01, -7.031e-02));
	r += mul(s2_5, M4(2.690e-01, 6.288e-02, -8.282e-02, -5.746e-02, 2.216e-02, 1.134e-01, -2.658e-01, 1.436e-01, -2.117e-01, 4.009e-03, -8.882e-02, -1.534e-02, 7.304e-02, -1.343e-01, 1.021e-01, 1.895e-01));
	r += mul(s2_6, M4(1.037e-03, -1.050e-01, -2.224e-01, -2.244e-01, 4.082e-02, 2.096e-01, 2.538e-01, 1.739e-01, -1.823e-02, 2.410e-02, 2.399e-01, -2.812e-01, 1.423e-01, -9.570e-02, -5.401e-02, -1.056e-02));
	r += mul(s2_7, M4(1.985e-01, -1.232e-02, -2.831e-01, -9.744e-02, -2.427e-01, -1.069e-01, -9.460e-02, 1.293e-01, -9.502e-02, -2.604e-01, 1.861e-01, -1.988e-01, -5.062e-02, -2.880e-02, 2.069e-01, 4.192e-02));
	r += mul(s2_8, M4(1.906e-01, -2.576e-02, -1.644e-01, -8.586e-02, -1.002e-01, 1.869e-02, 8.363e-02, -1.062e-01, -3.330e-01, 5.037e-02, 1.923e-01, -6.374e-02, -2.618e-02, -3.867e-02, 2.036e-01, 1.382e-01));
	r += mul(s3_0, M4(-1.223e-01, 4.404e-02, 7.597e-02, 1.037e-01, 5.300e-02, -3.714e-01, 8.780e-02, 1.064e-01, 4.379e-02, 5.496e-02, -5.741e-02, -8.834e-02, 4.607e-02, 2.440e-01, -3.621e-02, -1.449e-01));
	r += mul(s3_1, M4(1.114e-02, -3.579e-03, -1.118e-01, -7.019e-02, 1.253e-01, 1.410e-01, 1.507e-01, 1.204e-01, 4.912e-02, -2.110e-01, -1.393e-01, 1.398e-02, -3.292e-02, 2.104e-01, 1.470e-01, -4.723e-01));
	r += mul(s3_2, M4(-7.613e-02, -3.437e-02, 3.357e-02, 2.053e-02, 2.749e-02, -1.624e-02, 1.085e-01, 4.885e-02, -8.099e-02, -1.709e-01, 1.212e-01, -1.369e-01, 8.667e-03, -2.034e-01, 1.859e-02, -2.609e-01));
	r += mul(s3_3, M4(-2.751e-01, -6.155e-02, 3.194e-02, 2.257e-01, 2.247e-01, -1.563e-01, -2.388e-01, 4.747e-01, 8.550e-02, -2.046e-01, 5.261e-02, 1.302e-02, -2.718e-01, 8.046e-02, 6.971e-03, -4.401e-02));
	r += mul(s3_4, M4(-2.097e-01, 4.087e-02, 1.145e-01, 3.885e-01, -2.739e-01, 4.656e-01, 1.839e-01, -4.552e-02, 1.422e-01, -8.299e-02, 1.631e-01, 8.810e-02, -2.652e-01, 3.779e-01, -1.959e-01, -7.052e-01));
	r += mul(s3_5, M4(2.480e-03, 2.248e-01, 9.405e-02, 1.128e-01, 1.134e-01, -7.725e-02, -7.705e-02, 4.144e-02, 1.185e-02, -1.614e-01, -6.596e-02, 1.191e-01, 1.946e-01, 6.701e-02, 4.365e-02, -2.465e-01));
	r += mul(s3_6, M4(-2.183e-01, 6.265e-03, -2.004e-02, 1.360e-01, 9.385e-02, -6.143e-03, -3.924e-02, 2.857e-01, -1.091e-01, 5.286e-02, -2.204e-03, -4.854e-02, -2.588e-01, -8.500e-02, -7.099e-02, -3.542e-02));
	r += mul(s3_7, M4(-2.584e-01, -1.560e-01, 3.706e-02, 8.145e-03, -4.860e-02, -6.664e-02, -2.890e-01, 9.694e-02, 6.597e-02, -1.415e-01, -9.524e-02, 4.655e-03, -1.705e-01, 1.622e-01, 2.766e-01, -1.033e-01));
	r += mul(s3_8, M4(1.214e-02, 6.487e-02, -1.258e-03, 1.522e-01, 8.112e-02, -1.089e-02, -2.167e-02, -1.711e-01, -1.753e-01, -7.256e-02, 8.314e-02, 6.349e-02, 1.489e-01, 4.952e-02, 1.646e-01, -7.355e-02));
	r += V4(-1.384e-02, -2.911e-02, -8.125e-03, 2.809e-03);
	return r;
}

void Pass4(uint2 blockStart, uint3 tid) {
	float2 pt = float2(GetInputPt());
	uint2 gxy = Rmp8x8(tid.x) + blockStart;
	uint2 size = GetInputSize();
	if (gxy.x >= size.x || gxy.y >= size.y) {
		return;
	}
	float2 pos = (gxy + 0.5) * pt;

	V4 s0_0 = l0(-1.0, -1.0);
	V4 s0_1 = l0(0.0, -1.0);
	V4 s0_2 = l0(1.0, -1.0);
	V4 s0_3 = l0(-1.0, 0.0);
	V4 s0_4 = l0(0.0, 0.0);
	V4 s0_5 = l0(1.0, 0.0);
	V4 s0_6 = l0(-1.0, 1.0);
	V4 s0_7 = l0(0.0, 1.0);
	V4 s0_8 = l0(1.0, 1.0);
	V4 s1_0 = -max(-s0_0, 0.0);
	V4 s1_1 = -max(-s0_1, 0.0);
	V4 s1_2 = -max(-s0_2, 0.0);
	V4 s1_3 = -max(-s0_3, 0.0);
	V4 s1_4 = -max(-s0_4, 0.0);
	V4 s1_5 = -max(-s0_5, 0.0);
	V4 s1_6 = -max(-s0_6, 0.0);
	V4 s1_7 = -max(-s0_7, 0.0);
	V4 s1_8 = -max(-s0_8, 0.0);
	s0_0 = max(s0_0, 0.0);
	s0_1 = max(s0_1, 0.0);
	s0_2 = max(s0_2, 0.0);
	s0_3 = max(s0_3, 0.0);
	s0_4 = max(s0_4, 0.0);
	s0_5 = max(s0_5, 0.0);
	s0_6 = max(s0_6, 0.0);
	s0_7 = max(s0_7, 0.0);
	s0_8 = max(s0_8, 0.0);

	V4 s2_0 = l1(-1.0, -1.0);
	V4 s2_1 = l1(0.0, -1.0);
	V4 s2_2 = l1(1.0, -1.0);
	V4 s2_3 = l1(-1.0, 0.0);
	V4 s2_4 = l1(0.0, 0.0);
	V4 s2_5 = l1(1.0, 0.0);
	V4 s2_6 = l1(-1.0, 1.0);
	V4 s2_7 = l1(0.0, 1.0);
	V4 s2_8 = l1(1.0, 1.0);
	V4 s3_0 = -max(-s2_0, 0.0);
	V4 s3_1 = -max(-s2_1, 0.0);
	V4 s3_2 = -max(-s2_2, 0.0);
	V4 s3_3 = -max(-s2_3, 0.0);
	V4 s3_4 = -max(-s2_4, 0.0);
	V4 s3_5 = -max(-s2_5, 0.0);
	V4 s3_6 = -max(-s2_6, 0.0);
	V4 s3_7 = -max(-s2_7, 0.0);
	V4 s3_8 = -max(-s2_8, 0.0);
	s2_0 = max(s2_0, 0.0);
	s2_1 = max(s2_1, 0.0);
	s2_2 = max(s2_2, 0.0);
	s2_3 = max(s2_3, 0.0);
	s2_4 = max(s2_4, 0.0);
	s2_5 = max(s2_5, 0.0);
	s2_6 = max(s2_6, 0.0);
	s2_7 = max(s2_7, 0.0);
	s2_8 = max(s2_8, 0.0);

	t2[gxy] = f0(s0_0, s0_1, s0_2, s0_3, s0_4, s0_5, s0_6, s0_7, s0_8, s1_0, s1_1, s1_2, s1_3, s1_4, s1_5, s1_6, s1_7, s1_8, s2_0, s2_1, s2_2, s2_3, s2_4, s2_5, s2_6, s2_7, s2_8, s3_0, s3_1, s3_2, s3_3, s3_4, s3_5, s3_6, s3_7, s3_8);
	t3[gxy] = f1(s0_0, s0_1, s0_2, s0_3, s0_4, s0_5, s0_6, s0_7, s0_8, s1_0, s1_1, s1_2, s1_3, s1_4, s1_5, s1_6, s1_7, s1_8, s2_0, s2_1, s2_2, s2_3, s2_4, s2_5, s2_6, s2_7, s2_8, s3_0, s3_1, s3_2, s3_3, s3_4, s3_5, s3_6, s3_7, s3_8);
}

//!PASS 5
//!DESC conv4
//!BLOCK_SIZE 8
//!NUM_THREADS 64
//!IN t2, t3
//!OUT t0, t1

#define l0(x, y) V4(O(t2, float2(x, y)))
#define l1(x, y) V4(O(t3, float2(x, y)))

V4 f0(V4 s0_0, V4 s0_1, V4 s0_2, V4 s0_3, V4 s0_4, V4 s0_5, V4 s0_6, V4 s0_7, V4 s0_8, V4 s1_0, V4 s1_1, V4 s1_2, V4 s1_3, V4 s1_4, V4 s1_5, V4 s1_6, V4 s1_7, V4 s1_8, V4 s2_0, V4 s2_1, V4 s2_2, V4 s2_3, V4 s2_4, V4 s2_5, V4 s2_6, V4 s2_7, V4 s2_8, V4 s3_0, V4 s3_1, V4 s3_2, V4 s3_3, V4 s3_4, V4 s3_5, V4 s3_6, V4 s3_7, V4 s3_8) {
	V4 r = 0.0;
	r += mul(s0_0, M4(-9.839e-02, 3.062e-02, -3.104e-02, 1.230e-01, -3.336e-02, -6.990e-02, -5.725e-02, -1.051e-01, 5.154e-02, -1.304e-01, -2.518e-02, 3.975e-03, -2.458e-02, -4.391e-02, -1.022e-01, 1.249e-01));
	r += mul(s0_1, M4(1.530e-01, 1.379e-01, -4.847e-02, -8.142e-02, -1.899e-01, -9.819e-03, -2.943e-02, 8.787e-02, 8.270e-02, -7.839e-04, 4.236e-03, 2.756e-03, 1.612e-01, -1.871e-01, -1.973e-01, -8.765e-02));
	r += mul(s0_2, M4(1.230e-01, 7.002e-02, 2.676e-02, -2.607e-01, 3.729e-02, -1.075e-01, -5.825e-02, 9.552e-02, -6.701e-02, 5.642e-02, 5.425e-02, -1.487e-01, 6.427e-02, -1.606e-01, -2.290e-01, 2.280e-01));
	r += mul(s0_3, M4(-1.096e-01, 4.115e-02, -5.260e-02, 9.679e-02, 1.028e-01, -1.253e-01, -1.221e-01, -1.339e-02, 1.119e-01, -8.725e-02, 1.090e-01, -8.990e-02, 1.657e-01, -5.536e-02, 7.055e-02, -6.021e-03));
	r += mul(s0_4, M4(3.182e-01, -1.503e-01, -9.298e-02, 9.546e-02, 2.257e-01, -1.978e-01, -1.203e-01, -5.362e-02, -2.116e-02, -3.685e-02, 6.188e-02, 7.871e-02, 6.547e-01, 3.793e-01, -9.293e-03, -5.081e-01));
	r += mul(s0_5, M4(6.746e-02, -3.872e-02, -8.004e-02, 4.643e-02, -1.157e-01, -1.149e-01, -1.323e-01, -1.319e-02, -3.194e-02, -1.266e-02, -4.837e-02, -6.710e-02, 1.123e-01, -1.855e-01, -9.259e-03, -1.861e-01));
	r += mul(s0_6, M4(-7.725e-02, -4.151e-02, -7.387e-02, 1.089e-01, -5.642e-02, 7.030e-03, 7.847e-02, 1.234e-01, 9.461e-03, -4.967e-02, 1.502e-02, 3.836e-02, 1.171e-02, 3.758e-02, 3.336e-02, 5.168e-02));
	r += mul(s0_7, M4(2.541e-02, 1.428e-01, 2.426e-03, 2.451e-02, -1.436e-01, 5.267e-02, 2.402e-02, -4.748e-02, 2.185e-02, -5.397e-02, -4.221e-02, -4.758e-02, 1.504e-01, 1.818e-01, -3.334e-04, 1.985e-01));
	r += mul(s0_8, M4(5.651e-02, 1.104e-01, 1.186e-01, -4.816e-02, -1.772e-03, -3.797e-02, -1.169e-01, 9.888e-02, -7.066e-02, -2.928e-02, 1.300e-01, -9.514e-02, 8.911e-02, 1.399e-01, 8.996e-02, 7.361e-02));
	r += mul(s1_0, M4(-4.999e-02, 7.076e-02, 1.754e-01, 2.998e-01, -5.965e-02, 8.642e-02, 6.403e-02, 1.597e-02, -1.367e-02, -1.751e-01, -1.432e-01, -1.337e-01, -1.356e-01, -1.147e-02, 4.994e-02, 1.355e-01));
	r += mul(s1_1, M4(-1.462e-01, 2.612e-01, 1.009e-01, 6.179e-02, 1.171e-01, -2.310e-01, -1.324e-01, -1.989e-01, -7.842e-02, 2.017e-01, -2.558e-02, 1.725e-01, -1.879e-01, 2.705e-01, 9.276e-02, 2.009e-01));
	r += mul(s1_2, M4(-5.937e-02, 1.314e-02, 1.771e-01, -8.971e-02, 9.120e-02, -8.247e-03, 6.149e-02, -1.310e-02, 1.856e-01, -8.410e-02, 3.653e-02, 1.994e-02, 1.377e-02, -2.608e-02, 2.918e-02, 1.410e-01));
	r += mul(s1_3, M4(-1.270e-01, 2.306e-01, 1.223e-01, 5.712e-02, 6.862e-02, -1.441e-02, -1.116e-02, -1.195e-01, 4.816e-02, -9.698e-03, -1.642e-01, 2.214e-01, -1.748e-01, -1.574e-01, 7.939e-02, 4.879e-02));
	r += mul(s1_4, M4(-6.803e-02, -2.231e-01, -9.303e-02, 3.363e-01, 4.699e-01, -6.197e-01, -1.678e-01, 1.660e-02, -3.526e-01, -2.941e-01, 4.667e-01, -3.648e-01, -5.144e-01, 7.678e-01, 4.839e-01, -5.598e-01));
	r += mul(s1_5, M4(-7.123e-02, -2.319e-01, -3.813e-02, 1.547e-01, 2.632e-01, -2.001e-02, 4.992e-02, -1.581e-01, -4.053e-02, -2.970e-04, 5.472e-02, -6.788e-02, -2.869e-01, -9.887e-02, 4.475e-02, -1.027e-01));
	r += mul(s1_6, M4(7.336e-02, 1.784e-02, -1.559e-01, 7.106e-02, 9.975e-02, -6.405e-03, 7.519e-02, 7.405e-02, -9.000e-02, 8.590e-02, -2.557e-01, -1.597e-02, -4.081e-02, 7.353e-02, 3.324e-02, -5.861e-02));
	r += mul(s1_7, M4(2.380e-02, -1.385e-01, -1.038e-01, 2.752e-02, -4.866e-02, 6.411e-02, 3.531e-01, -1.330e-01, 2.261e-01, -7.266e-02, -5.772e-02, -6.657e-02, -1.588e-01, 1.268e-01, 1.618e-02, 9.695e-02));
	r += mul(s1_8, M4(1.300e-01, -1.683e-01, -1.481e-02, -1.442e-02, 2.942e-02, -4.528e-03, 3.715e-01, -2.056e-01, -1.070e-01, 7.589e-02, -1.326e-01, 9.583e-02, -1.052e-01, 4.535e-02, -5.072e-02, 1.023e-01));
	r += mul(s2_0, M4(4.804e-02, 4.605e-02, 1.479e-01, 2.794e-02, 1.518e-02, 1.881e-02, 5.332e-02, 6.881e-02, -9.226e-02, -1.212e-02, 5.999e-03, 4.409e-02, -2.364e-01, -4.576e-02, 4.537e-02, 1.615e-01));
	r += mul(s2_1, M4(-1.719e-02, 2.187e-01, 1.772e-01, 1.933e-02, -3.135e-02, 4.963e-02, 1.303e-02, -2.623e-02, -1.273e-01, 1.462e-02, 7.118e-02, -1.498e-01, 1.978e-01, 7.777e-02, -1.052e-01, 1.954e-01));
	r += mul(s2_2, M4(-2.936e-02, -1.679e-02, 1.548e-01, 2.521e-02, 4.974e-02, 5.132e-02, 1.145e-02, 4.237e-02, -2.103e-01, 3.828e-03, -3.888e-02, 1.429e-01, -2.964e-02, -1.423e-02, -2.417e-01, 3.932e-01));
	r += mul(s2_3, M4(-1.881e-01, -2.086e-02, 1.815e-04, 1.164e-01, -7.054e-02, 8.297e-02, 7.999e-02, 3.579e-02, -1.240e-02, 5.415e-02, -4.885e-02, -7.243e-02, -7.780e-02, -8.180e-02, 1.529e-01, 1.616e-01));
	r += mul(s2_4, M4(-1.410e-01, 9.917e-02, 2.589e-01, -2.888e-01, -1.248e-01, 2.510e-01, 3.366e-02, 1.437e-01, 3.793e-01, 5.004e-02, 3.701e-01, 3.111e-01, -3.195e-01, -3.731e-02, 1.132e-01, 1.961e-01));
	r += mul(s2_5, M4(-8.966e-02, -5.875e-02, -1.135e-01, 8.984e-02, 5.129e-02, 7.536e-02, 2.763e-01, 1.203e-02, -2.020e-01, 1.617e-01, -1.427e-02, 6.661e-02, -1.930e-01, -7.980e-03, 8.300e-02, 1.697e-01));
	r += mul(s2_6, M4(5.726e-02, -1.777e-02, -4.372e-02, 3.170e-03, 2.430e-02, -1.211e-02, -4.311e-02, -1.215e-01, -1.066e-01, 1.810e-02, 1.013e-01, -2.315e-02, -3.001e-01, -8.701e-02, -1.455e-01, 4.155e-02));
	r += mul(s2_7, M4(1.431e-01, 2.344e-03, 1.489e-02, 4.575e-02, 7.550e-02, 3.571e-02, -2.517e-01, -5.387e-03, 4.699e-02, 5.390e-02, 2.202e-01, -7.897e-02, 6.326e-02, -1.588e-01, -1.852e-01, -3.037e-02));
	r += mul(s2_8, M4(-3.479e-02, -8.214e-02, 6.944e-02, 5.269e-02, -7.719e-03, -7.718e-02, -8.393e-02, -8.959e-02, -2.111e-01, 1.286e-01, 1.948e-01, -8.095e-02, -2.335e-02, 9.535e-02, -1.144e-01, 3.688e-02));
	r += mul(s3_0, M4(8.765e-02, -6.740e-02, 1.200e-01, 6.992e-02, 1.884e-02, -1.592e-02, -9.304e-02, 1.706e-01, 6.023e-02, 1.494e-01, -1.165e-01, 3.848e-02, -2.808e-02, 4.820e-02, -4.830e-02, 9.253e-02));
	r += mul(s3_1, M4(-1.087e-01, 2.039e-01, -8.116e-02, 1.500e-01, 1.942e-01, -2.291e-02, -1.321e-02, 1.630e-02, 2.216e-01, 3.536e-02, -2.321e-01, 1.143e-01, 2.093e-01, -6.126e-02, -3.792e-02, 6.886e-02));
	r += mul(s3_2, M4(1.225e-01, -6.231e-02, -1.999e-01, 9.921e-02, -4.257e-02, -2.975e-02, -4.073e-02, 7.069e-02, -5.033e-02, 2.268e-03, -1.908e-01, 9.678e-02, -4.540e-02, 4.195e-02, -1.990e-02, -9.002e-02));
	r += mul(s3_3, M4(8.620e-02, 1.856e-02, 1.201e-01, 1.343e-01, 6.518e-03, 1.274e-01, 1.006e-01, -4.803e-02, 2.593e-02, 1.861e-01, -2.316e-01, -1.882e-01, 2.021e-02, -5.658e-02, -1.339e-02, -6.240e-02));
	r += mul(s3_4, M4(3.285e-01, -2.068e-02, 4.279e-01, -7.153e-02, 1.368e-02, 2.029e-01, 3.056e-01, -2.398e-02, -2.007e-02, -6.963e-02, 4.423e-01, 2.373e-01, -3.829e-03, -8.114e-02, 1.907e-01, 6.471e-02));
	r += mul(s3_5, M4(6.460e-02, -2.118e-01, -1.407e-01, 8.041e-02, 5.512e-02, 1.740e-01, 2.092e-01, 1.569e-02, 2.071e-02, -5.675e-02, -9.011e-02, 5.301e-02, 9.519e-02, -2.758e-02, -3.116e-02, -2.141e-02));
	r += mul(s3_6, M4(-2.575e-02, 1.869e-02, 7.810e-02, -7.650e-03, 2.013e-01, 2.214e-02, -8.345e-02, 2.879e-02, 1.492e-01, -4.496e-02, -1.297e-01, 2.238e-03, 7.626e-02, -7.449e-02, -5.789e-02, 5.411e-02));
	r += mul(s3_7, M4(5.731e-02, 8.709e-02, 8.776e-02, 1.547e-01, 9.076e-02, -1.621e-01, -3.538e-01, -3.413e-02, 1.609e-01, -6.938e-03, -5.128e-02, 7.688e-02, -5.171e-03, 9.220e-02, 2.424e-02, 1.621e-02));
	r += mul(s3_8, M4(6.538e-02, -3.415e-02, 5.399e-02, -8.863e-02, -7.563e-02, -1.511e-01, -2.978e-01, 7.569e-02, -1.429e-01, 3.110e-02, -2.972e-02, -8.001e-03, -8.429e-02, -1.092e-02, -4.655e-02, 3.067e-02));
	r += V4(-3.137e-02, 6.441e-03, -1.512e-02, 2.709e-02);
	return r;
}

V4 f1(V4 s0_0, V4 s0_1, V4 s0_2, V4 s0_3, V4 s0_4, V4 s0_5, V4 s0_6, V4 s0_7, V4 s0_8, V4 s1_0, V4 s1_1, V4 s1_2, V4 s1_3, V4 s1_4, V4 s1_5, V4 s1_6, V4 s1_7, V4 s1_8, V4 s2_0, V4 s2_1, V4 s2_2, V4 s2_3, V4 s2_4, V4 s2_5, V4 s2_6, V4 s2_7, V4 s2_8, V4 s3_0, V4 s3_1, V4 s3_2, V4 s3_3, V4 s3_4, V4 s3_5, V4 s3_6, V4 s3_7, V4 s3_8) {
	V4 r = 0.0;
	r += mul(s0_0, M4(-3.334e-02, -7.793e-02, 7.471e-02, 4.792e-02, -9.991e-03, 1.358e-02, 7.063e-02, -7.185e-02, 1.122e-01, 1.016e-01, 1.666e-01, -4.230e-02, -2.916e-03, 1.093e-01, 3.944e-02, -6.470e-02));
	r += mul(s0_1, M4(-3.424e-02, -5.060e-03, -9.649e-03, 1.311e-01, 9.390e-02, -6.332e-03, 8.698e-02, -1.949e-03, 5.118e-02, 4.049e-02, 7.113e-02, 1.951e-01, 1.856e-01, 2.065e-01, -7.642e-02, -1.852e-02));
	r += mul(s0_2, M4(-6.507e-03, -1.195e-02, -1.476e-01, -4.432e-02, 1.839e-02, 2.119e-02, -3.374e-03, -7.739e-03, -4.710e-03, -6.300e-02, -3.058e-02, -1.966e-03, -4.888e-03, 6.550e-02, 3.826e-02, 4.369e-02));
	r += mul(s0_3, M4(-2.796e-03, 6.707e-02, 1.750e-01, 5.898e-02, -6.279e-02, 1.146e-01, 4.500e-02, -1.178e-01, 1.591e-02, 4.649e-03, 1.249e-01, 1.531e-02, 2.940e-02, -3.842e-02, 1.162e-02, 8.735e-02));
	r += mul(s0_4, M4(1.997e-01, 1.499e-01, -2.234e-01, 2.460e-01, -6.721e-02, 2.135e-01, -1.372e-01, -1.864e-01, 1.432e-01, 1.012e-01, -3.441e-02, 7.842e-02, -2.026e-01, 1.294e-01, 3.063e-01, 2.969e-01));
	r += mul(s0_5, M4(1.302e-02, -1.252e-01, -1.174e-01, 2.114e-01, -5.837e-02, -1.377e-01, 4.956e-03, -1.486e-01, -7.287e-03, -1.002e-01, 1.431e-01, -8.579e-02, -2.642e-02, -9.106e-02, -5.609e-02, 3.664e-02));
	r += mul(s0_6, M4(-3.524e-02, 6.427e-02, 5.395e-02, -6.112e-02, -3.246e-02, -3.689e-02, 5.133e-02, 6.382e-02, -7.140e-02, 8.407e-02, -1.051e-02, 1.865e-02, -1.559e-02, 8.857e-02, -5.051e-02, 1.129e-03));
	r += mul(s0_7, M4(-7.399e-02, -1.028e-01, -1.066e-01, 1.430e-01, -1.403e-01, 9.422e-02, -8.995e-02, -1.358e-02, -8.900e-02, 1.519e-01, -7.974e-02, -1.915e-01, 2.726e-02, 2.748e-01, -2.521e-02, 9.171e-02));
	r += mul(s0_8, M4(4.422e-02, -1.013e-01, -9.089e-02, 3.341e-02, -3.750e-02, 1.762e-01, 8.286e-02, -4.945e-02, -1.285e-01, 1.504e-02, -4.042e-02, -7.892e-02, 3.263e-02, -2.562e-02, -1.577e-01, 2.407e-02));
	r += mul(s1_0, M4(-9.014e-02, 9.935e-03, 4.158e-02, 6.269e-02, -3.854e-02, -6.123e-02, 5.101e-02, -1.229e-01, -5.554e-02, -4.848e-02, -5.602e-02, -2.115e-01, -5.692e-02, 9.588e-03, 8.485e-02, 7.810e-02));
	r += mul(s1_1, M4(-5.449e-02, -5.076e-02, 7.205e-02, -5.263e-02, -1.293e-01, 1.127e-01, -1.122e-01, -6.078e-02, 8.158e-02, -2.493e-01, 4.842e-02, 1.959e-01, 5.976e-02, -1.003e-01, -6.969e-02, 1.654e-01));
	r += mul(s1_2, M4(-2.894e-02, 1.048e-01, 3.925e-03, -1.321e-01, -4.509e-02, -1.643e-02, -1.334e-01, 9.845e-02, -1.127e-01, -1.049e-01, 1.350e-02, -1.013e-02, -1.599e-01, -6.552e-02, 3.246e-02, 3.401e-02));
	r += mul(s1_3, M4(1.324e-01, -7.379e-02, 6.628e-02, -1.243e-01, -9.905e-02, 1.141e-01, 5.375e-02, -1.293e-01, -2.330e-02, -3.277e-01, 5.023e-02, -1.837e-01, 6.815e-02, -4.447e-02, 1.480e-01, -2.077e-03));
	r += mul(s1_4, M4(3.168e-01, 3.120e-01, 4.723e-02, -1.814e-01, -4.271e-01, 3.554e-01, -2.607e-01, 3.691e-02, 1.565e-01, -4.785e-01, 1.167e-01, -4.891e-02, -1.643e-01, -2.565e-01, 6.425e-01, -9.561e-02));
	r += mul(s1_5, M4(-4.394e-02, 1.831e-01, 2.602e-02, 8.348e-02, -4.285e-01, -2.126e-01, -2.658e-01, 1.340e-01, -6.773e-02, -1.315e-01, 9.904e-02, -1.672e-01, 1.995e-01, 1.307e-01, 1.985e-01, -8.368e-02));
	r += mul(s1_6, M4(-8.468e-03, 2.030e-01, -8.770e-04, -1.421e-01, -5.327e-02, 1.042e-01, 7.595e-02, -7.467e-02, -2.326e-03, -1.496e-01, -3.598e-02, 1.430e-02, 6.833e-02, 1.257e-01, 5.333e-03, 1.382e-01));
	r += mul(s1_7, M4(-7.236e-02, 2.202e-01, 7.527e-03, -1.157e-01, -4.825e-01, -1.938e-01, -2.971e-01, -7.394e-02, -3.056e-02, 6.438e-02, -8.167e-02, -1.749e-01, 7.804e-02, 3.541e-01, 1.631e-01, 1.105e-01));
	r += mul(s1_8, M4(-3.117e-02, 1.456e-01, 1.217e-02, -9.099e-02, -2.173e-01, -5.803e-02, -1.068e-01, -6.206e-02, -1.187e-04, 9.938e-02, 4.721e-02, -3.500e-02, -7.154e-02, -4.535e-02, -1.900e-02, 6.525e-03));
	r += mul(s2_0, M4(3.437e-02, 3.957e-03, -1.536e-02, 2.984e-02, 8.057e-03, 1.446e-02, -2.851e-02, -1.680e-02, 9.630e-04, -3.550e-02, 4.249e-02, -5.379e-02, -2.274e-02, 3.657e-02, 6.309e-02, -1.412e-01));
	r += mul(s2_1, M4(-4.765e-02, -7.905e-02, -7.251e-02, -8.459e-02, -1.866e-02, 4.668e-02, -2.496e-02, -3.761e-02, 6.520e-02, 9.971e-02, -1.199e-02, -3.565e-02, -2.936e-02, -1.288e-02, -8.909e-03, 1.604e-01));
	r += mul(s2_2, M4(-2.684e-02, 3.571e-02, 2.920e-02, -1.400e-01, -8.129e-03, 2.701e-02, -1.237e-02, 6.292e-02, 3.752e-02, -3.476e-02, 7.166e-02, 2.922e-02, 2.153e-02, -2.079e-02, 2.298e-01, 2.646e-01));
	r += mul(s2_3, M4(5.891e-02, -3.401e-02, 1.310e-01, 1.284e-01, -3.706e-02, -6.929e-03, 5.705e-02, 2.617e-02, 1.908e-03, 1.155e-01, 4.786e-02, 1.471e-01, -8.026e-02, 6.384e-02, 3.177e-01, -6.423e-02));
	r += mul(s2_4, M4(1.941e-01, -1.938e-04, -4.664e-02, 3.134e-01, -7.269e-02, -2.396e-01, -5.068e-02, -3.354e-01, 2.428e-01, 2.566e-01, -3.293e-01, 3.857e-01, -1.129e-02, 1.540e-01, -9.700e-02, -1.510e-01));
	r += mul(s2_5, M4(4.818e-02, 1.620e-01, 1.519e-01, 2.711e-03, -1.559e-02, 1.144e-01, 7.668e-03, -1.534e-01, 3.862e-03, -4.583e-02, 5.226e-02, -6.465e-02, 6.788e-02, 5.557e-02, 6.880e-02, 9.542e-02));
	r += mul(s2_6, M4(1.471e-01, 3.141e-02, 1.711e-02, 3.585e-02, 7.758e-02, 3.487e-03, -4.199e-02, 1.119e-02, -9.641e-02, 7.175e-02, -6.454e-03, -8.769e-02, 4.452e-02, 3.013e-02, 2.107e-01, 1.447e-02));
	r += mul(s2_7, M4(1.941e-01, -1.489e-01, 1.093e-01, 1.092e-02, 1.309e-01, 1.173e-01, 3.414e-02, -1.350e-01, -2.374e-01, -1.292e-01, -1.259e-01, 1.377e-02, -5.705e-02, 1.641e-01, -3.345e-02, -1.443e-01));
	r += mul(s2_8, M4(5.172e-02, 8.306e-03, 6.669e-02, -2.207e-02, -2.737e-02, 7.314e-02, -5.039e-02, -6.565e-02, -1.124e-01, -1.920e-01, -8.356e-02, 2.342e-02, 8.945e-03, 2.739e-02, 8.816e-03, 7.638e-02));
	r += mul(s3_0, M4(-2.968e-02, 1.037e-01, -2.673e-02, 1.869e-02, 9.621e-02, -5.237e-02, 1.487e-03, -9.423e-02, 3.269e-02, -5.264e-02, -4.862e-02, 2.446e-02, 6.554e-02, -8.896e-02, 2.104e-02, -1.165e-01));
	r += mul(s3_1, M4(-9.417e-03, 6.345e-02, -7.850e-03, 2.754e-01, -2.751e-02, -1.201e-01, -5.333e-02, -1.217e-01, 8.778e-02, 1.394e-01, -1.787e-01, 1.017e-01, -3.779e-02, 6.921e-02, 2.664e-02, 1.665e-01));
	r += mul(s3_2, M4(3.141e-02, 7.360e-02, 9.011e-02, -1.109e-02, 1.985e-02, -4.239e-02, 1.468e-01, -2.676e-02, 1.225e-01, -5.115e-02, 3.496e-02, 8.530e-02, 1.594e-02, -2.731e-02, 3.492e-02, -4.212e-02));
	r += mul(s3_3, M4(7.578e-02, 3.966e-03, -7.774e-03, 4.263e-02, 3.758e-02, -1.590e-01, 1.144e-01, -1.083e-01, 9.865e-02, 3.237e-03, -1.194e-01, 3.048e-02, -1.231e-01, 5.687e-02, 3.601e-02, -2.234e-01));
	r += mul(s3_4, M4(3.291e-01, 2.283e-01, -2.254e-01, 1.114e-01, -3.019e-01, -1.677e-01, -1.735e-01, -5.636e-01, 4.295e-01, 1.206e-01, -1.169e-01, -9.182e-02, 2.546e-01, 2.820e-01, -9.122e-02, 1.703e-01));
	r += mul(s3_5, M4(1.178e-01, 1.875e-01, 7.948e-02, -1.907e-02, -9.888e-02, 8.592e-02, 8.759e-02, -2.194e-01, -4.479e-02, 1.983e-02, 1.738e-02, -1.237e-01, -9.644e-02, -6.784e-02, -1.594e-02, 5.128e-02));
	r += mul(s3_6, M4(7.520e-02, 6.732e-02, 1.898e-02, 3.384e-02, 1.156e-01, 7.703e-02, -9.079e-02, 2.659e-02, 2.860e-02, 2.034e-01, -4.492e-02, -5.377e-02, 4.771e-02, 1.099e-01, 2.032e-02, 4.955e-02));
	r += mul(s3_7, M4(-1.573e-02, 1.987e-01, -9.155e-02, 1.445e-01, 2.224e-01, 7.036e-02, 1.126e-01, -2.900e-01, -3.571e-02, 6.868e-02, -5.302e-02, -2.629e-02, -2.798e-01, 1.832e-01, -1.850e-01, -8.079e-02));
	r += mul(s3_8, M4(-1.843e-02, -2.045e-02, -2.602e-02, -6.202e-02, 1.303e-01, 1.797e-01, 1.169e-01, -2.712e-02, -5.147e-02, -5.439e-02, 2.103e-02, -6.035e-02, 4.517e-02, 3.473e-02, 6.015e-02, -9.014e-02));
	r += V4(1.952e-02, -1.174e-02, -1.100e-02, -1.307e-02);
	return r;
}

void Pass5(uint2 blockStart, uint3 tid) {
	float2 pt = float2(GetInputPt());
	uint2 gxy = Rmp8x8(tid.x) + blockStart;
	uint2 size = GetInputSize();
	if (gxy.x >= size.x || gxy.y >= size.y) {
		return;
	}
	float2 pos = (gxy + 0.5) * pt;

	V4 s0_0 = l0(-1.0, -1.0);
	V4 s0_1 = l0(0.0, -1.0);
	V4 s0_2 = l0(1.0, -1.0);
	V4 s0_3 = l0(-1.0, 0.0);
	V4 s0_4 = l0(0.0, 0.0);
	V4 s0_5 = l0(1.0, 0.0);
	V4 s0_6 = l0(-1.0, 1.0);
	V4 s0_7 = l0(0.0, 1.0);
	V4 s0_8 = l0(1.0, 1.0);
	V4 s1_0 = -max(-s0_0, 0.0);
	V4 s1_1 = -max(-s0_1, 0.0);
	V4 s1_2 = -max(-s0_2, 0.0);
	V4 s1_3 = -max(-s0_3, 0.0);
	V4 s1_4 = -max(-s0_4, 0.0);
	V4 s1_5 = -max(-s0_5, 0.0);
	V4 s1_6 = -max(-s0_6, 0.0);
	V4 s1_7 = -max(-s0_7, 0.0);
	V4 s1_8 = -max(-s0_8, 0.0);
	s0_0 = max(s0_0, 0.0);
	s0_1 = max(s0_1, 0.0);
	s0_2 = max(s0_2, 0.0);
	s0_3 = max(s0_3, 0.0);
	s0_4 = max(s0_4, 0.0);
	s0_5 = max(s0_5, 0.0);
	s0_6 = max(s0_6, 0.0);
	s0_7 = max(s0_7, 0.0);
	s0_8 = max(s0_8, 0.0);

	V4 s2_0 = l1(-1.0, -1.0);
	V4 s2_1 = l1(0.0, -1.0);
	V4 s2_2 = l1(1.0, -1.0);
	V4 s2_3 = l1(-1.0, 0.0);
	V4 s2_4 = l1(0.0, 0.0);
	V4 s2_5 = l1(1.0, 0.0);
	V4 s2_6 = l1(-1.0, 1.0);
	V4 s2_7 = l1(0.0, 1.0);
	V4 s2_8 = l1(1.0, 1.0);
	V4 s3_0 = -max(-s2_0, 0.0);
	V4 s3_1 = -max(-s2_1, 0.0);
	V4 s3_2 = -max(-s2_2, 0.0);
	V4 s3_3 = -max(-s2_3, 0.0);
	V4 s3_4 = -max(-s2_4, 0.0);
	V4 s3_5 = -max(-s2_5, 0.0);
	V4 s3_6 = -max(-s2_6, 0.0);
	V4 s3_7 = -max(-s2_7, 0.0);
	V4 s3_8 = -max(-s2_8, 0.0);
	s2_0 = max(s2_0, 0.0);
	s2_1 = max(s2_1, 0.0);
	s2_2 = max(s2_2, 0.0);
	s2_3 = max(s2_3, 0.0);
	s2_4 = max(s2_4, 0.0);
	s2_5 = max(s2_5, 0.0);
	s2_6 = max(s2_6, 0.0);
	s2_7 = max(s2_7, 0.0);
	s2_8 = max(s2_8, 0.0);

	t0[gxy] = f0(s0_0, s0_1, s0_2, s0_3, s0_4, s0_5, s0_6, s0_7, s0_8, s1_0, s1_1, s1_2, s1_3, s1_4, s1_5, s1_6, s1_7, s1_8, s2_0, s2_1, s2_2, s2_3, s2_4, s2_5, s2_6, s2_7, s2_8, s3_0, s3_1, s3_2, s3_3, s3_4, s3_5, s3_6, s3_7, s3_8);
	t1[gxy] = f1(s0_0, s0_1, s0_2, s0_3, s0_4, s0_5, s0_6, s0_7, s0_8, s1_0, s1_1, s1_2, s1_3, s1_4, s1_5, s1_6, s1_7, s1_8, s2_0, s2_1, s2_2, s2_3, s2_4, s2_5, s2_6, s2_7, s2_8, s3_0, s3_1, s3_2, s3_3, s3_4, s3_5, s3_6, s3_7, s3_8);
}

//!PASS 6
//!DESC conv5
//!BLOCK_SIZE 8
//!NUM_THREADS 64
//!IN t0, t1
//!OUT t2, t3

#define l0(x, y) V4(O(t0, float2(x, y)))
#define l1(x, y) V4(O(t1, float2(x, y)))

V4 f0(V4 s0_0, V4 s0_1, V4 s0_2, V4 s0_3, V4 s0_4, V4 s0_5, V4 s0_6, V4 s0_7, V4 s0_8, V4 s1_0, V4 s1_1, V4 s1_2, V4 s1_3, V4 s1_4, V4 s1_5, V4 s1_6, V4 s1_7, V4 s1_8, V4 s2_0, V4 s2_1, V4 s2_2, V4 s2_3, V4 s2_4, V4 s2_5, V4 s2_6, V4 s2_7, V4 s2_8, V4 s3_0, V4 s3_1, V4 s3_2, V4 s3_3, V4 s3_4, V4 s3_5, V4 s3_6, V4 s3_7, V4 s3_8) {
	V4 r = 0.0;
	r += mul(s0_0, M4(-6.394e-02, -8.671e-02, 1.570e-02, -4.415e-02, 1.044e-01, 1.031e-01, 2.257e-02, -1.991e-02, -6.187e-02, 6.388e-02, 9.901e-02, 1.943e-02, 3.702e-02, 5.943e-03, 1.052e-02, 5.888e-02));
	r += mul(s0_1, M4(8.377e-02, 1.451e-01, 1.580e-01, 3.663e-02, 1.333e-01, 3.462e-02, 2.649e-02, 7.588e-02, 2.175e-02, 1.744e-01, 1.048e-01, -1.644e-01, -5.844e-02, 1.648e-02, 1.306e-01, -5.721e-02));
	r += mul(s0_2, M4(-7.420e-02, 5.839e-02, -2.164e-02, 2.832e-03, 1.776e-02, -1.732e-01, 1.505e-02, -1.082e-02, -1.647e-02, 3.072e-01, 1.187e-01, -1.273e-02, -9.205e-02, 1.119e-01, -2.918e-02, 9.009e-02));
	r += mul(s0_3, M4(-4.099e-03, -5.330e-02, -6.372e-02, -4.979e-02, -5.943e-02, -3.211e-02, -1.558e-01, 1.997e-01, -5.598e-02, -1.344e-02, 8.655e-02, 1.490e-01, -3.303e-02, -3.863e-02, 1.987e-03, -3.842e-02));
	r += mul(s0_4, M4(9.400e-02, 1.535e-01, 8.863e-02, 1.286e-01, 4.315e-01, -1.199e-01, 1.476e-01, 2.280e-01, -3.763e-02, 1.189e-01, 2.648e-01, 1.310e-01, -2.201e-01, -6.282e-02, 2.480e-01, 3.236e-02));
	r += mul(s0_5, M4(3.101e-02, -7.681e-02, -6.753e-02, 3.084e-02, 8.940e-02, -1.872e-01, -2.982e-02, -8.335e-02, 7.990e-02, 1.128e-01, 2.703e-01, 2.021e-01, -9.396e-02, 4.201e-02, 6.420e-03, -4.602e-02));
	r += mul(s0_6, M4(4.940e-02, -6.328e-03, -1.384e-02, -5.572e-02, 3.489e-02, -3.705e-02, 8.067e-02, -4.078e-02, -7.071e-03, 2.446e-02, 1.633e-02, -1.022e-02, -4.371e-02, 2.045e-02, 5.237e-02, -1.685e-02));
	r += mul(s0_7, M4(2.613e-02, 3.379e-02, -5.088e-02, 6.559e-02, -7.908e-03, -7.828e-02, -1.304e-02, -3.928e-02, 3.253e-02, -8.783e-02, 7.669e-03, -1.617e-01, 2.507e-02, 1.387e-01, 1.676e-01, 6.068e-02));
	r += mul(s0_8, M4(-1.872e-02, 6.736e-03, -2.342e-02, 3.332e-03, 1.419e-02, -3.932e-02, -8.530e-02, -5.934e-02, 8.273e-03, 8.759e-03, 6.867e-02, -3.344e-02, 8.183e-02, 1.472e-01, 3.134e-02, 5.993e-02));
	r += mul(s1_0, M4(6.022e-02, -1.966e-02, -1.612e-02, -6.922e-02, 7.477e-02, 1.176e-01, 1.365e-03, 8.882e-02, -4.594e-02, 7.740e-02, 6.959e-02, 8.633e-02, 3.034e-02, -8.553e-02, -6.847e-02, 2.439e-02));
	r += mul(s1_1, M4(1.861e-01, 1.628e-01, 9.891e-02, 8.686e-02, 1.521e-01, 2.777e-02, -4.557e-02, -5.964e-02, -7.298e-02, 9.138e-02, 9.796e-02, 1.437e-02, -6.912e-02, -1.500e-01, 1.108e-02, 8.537e-02));
	r += mul(s1_2, M4(1.272e-01, 1.039e-01, -1.040e-02, 5.735e-02, -9.561e-03, -7.849e-02, 2.013e-02, 6.743e-02, -1.308e-01, 2.097e-01, -2.586e-02, -2.612e-02, -1.021e-01, -2.057e-01, -3.857e-02, 1.757e-02));
	r += mul(s1_3, M4(8.053e-02, -6.616e-02, -1.770e-02, -1.982e-01, -2.444e-02, 7.095e-02, -3.175e-02, 1.033e-01, -5.762e-02, 3.046e-02, 1.113e-01, -7.795e-02, 7.733e-02, -2.446e-01, -9.412e-02, -1.653e-01));
	r += mul(s1_4, M4(3.202e-01, 3.417e-01, 2.862e-01, 1.982e-01, 2.573e-01, 8.468e-02, 1.595e-01, 4.027e-01, -1.133e-01, 1.141e-01, 3.135e-01, 8.849e-02, -3.401e-01, -4.237e-01, -9.999e-03, 1.012e-01));
	r += mul(s1_5, M4(2.600e-01, 5.980e-02, 8.030e-02, -2.103e-02, -1.986e-02, -5.828e-02, -1.421e-01, -1.034e-01, 4.901e-02, 4.389e-02, 5.034e-02, 1.400e-01, 6.483e-02, -2.524e-01, -5.724e-02, 6.231e-02));
	r += mul(s1_6, M4(1.074e-01, 3.976e-02, 3.519e-02, -4.123e-02, 6.299e-02, 5.759e-02, 6.204e-02, 4.752e-02, 5.410e-02, -4.425e-05, 4.521e-02, -8.902e-02, -5.916e-02, -2.006e-01, -1.372e-01, -1.440e-01));
	r += mul(s1_7, M4(9.065e-02, 2.786e-03, -7.057e-02, -7.517e-03, -4.347e-02, 6.086e-02, -2.635e-02, 4.724e-03, 1.253e-02, 4.647e-03, 2.887e-02, -1.678e-02, -8.265e-02, -6.195e-02, 1.822e-02, 7.331e-02));
	r += mul(s1_8, M4(4.428e-02, 6.706e-02, -4.415e-02, -1.130e-02, -1.310e-02, 4.253e-02, -9.984e-02, -1.037e-02, 3.263e-02, 8.474e-02, 7.599e-02, -3.215e-02, 4.988e-02, -1.178e-01, -1.416e-02, -2.848e-02));
	r += mul(s2_0, M4(8.826e-02, 8.038e-02, 7.920e-02, 9.084e-02, 6.145e-02, 8.284e-03, -5.767e-02, 9.238e-03, -4.508e-03, -8.890e-02, -1.910e-02, -1.507e-01, -7.447e-02, 4.104e-02, -2.612e-02, -8.667e-02));
	r += mul(s2_1, M4(-5.439e-02, 3.984e-01, 5.645e-02, -1.242e-01, -8.338e-02, -1.595e-01, -6.036e-02, 5.165e-02, 2.823e-01, 1.645e-01, 5.408e-02, 1.663e-01, 2.206e-02, -1.240e-01, -7.492e-02, 5.293e-02));
	r += mul(s2_2, M4(1.161e-02, 1.763e-01, 3.373e-02, 7.828e-03, 1.142e-01, 1.688e-01, 1.343e-01, 7.300e-02, 8.175e-02, 1.114e-01, -6.659e-02, 4.685e-02, 2.217e-02, -3.111e-02, 1.022e-01, -5.566e-02));
	r += mul(s2_3, M4(1.668e-02, 1.160e-01, 1.852e-01, 2.139e-01, -5.002e-02, 4.529e-02, -2.762e-02, 1.528e-01, 1.020e-01, -4.068e-02, -5.659e-02, 6.207e-03, 2.146e-02, -7.677e-02, -1.098e-02, -1.738e-01));
	r += mul(s2_4, M4(-3.080e-01, -1.794e-01, 3.752e-01, -1.512e-02, 6.082e-02, -1.906e-01, 4.469e-02, -1.824e-01, 5.373e-01, 2.499e-01, -3.037e-02, 4.862e-01, 2.590e-01, 3.245e-01, 1.882e-01, -5.488e-01));
	r += mul(s2_5, M4(1.734e-01, 1.910e-01, 1.513e-02, 5.352e-02, -6.647e-02, 5.546e-02, 4.049e-02, 1.364e-01, -3.987e-02, -2.656e-01, -1.042e-01, 3.166e-01, -9.156e-02, -1.295e-01, 7.885e-02, 2.314e-02));
	r += mul(s2_6, M4(9.283e-03, 4.879e-02, 7.797e-02, 3.678e-02, 1.426e-02, -4.030e-02, -1.420e-02, 1.217e-03, 3.934e-02, 8.811e-03, -3.593e-03, -9.359e-02, -2.613e-02, -6.882e-02, -1.049e-01, -6.001e-02));
	r += mul(s2_7, M4(-1.466e-01, -2.775e-02, -5.452e-02, -3.920e-02, 3.784e-02, -2.177e-02, 1.765e-03, -5.121e-03, 7.044e-02, -2.550e-02, 4.265e-02, 1.714e-01, 1.928e-02, -1.084e-01, -1.362e-01, -6.649e-02));
	r += mul(s2_8, M4(1.515e-02, 2.673e-02, -6.883e-02, 2.487e-02, -2.320e-02, -8.358e-02, -1.656e-02, -7.216e-03, -4.509e-03, 8.023e-02, 5.342e-02, -6.369e-02, -2.025e-02, 1.406e-02, -5.119e-02, 3.383e-02));
	r += mul(s3_0, M4(-9.426e-02, 2.166e-02, -3.618e-02, 1.094e-01, 2.509e-01, -4.044e-02, 5.655e-02, -3.421e-01, 8.115e-03, -1.962e-01, -2.723e-02, -7.238e-02, -1.999e-02, 4.283e-03, 2.814e-02, -1.090e-02));
	r += mul(s3_1, M4(-1.476e-01, -9.419e-04, -2.845e-01, -3.093e-02, 7.671e-02, 1.561e-01, 2.363e-01, -1.520e-01, -4.572e-02, -7.799e-02, 1.145e-01, 7.141e-02, -1.601e-02, -1.268e-01, -5.096e-02, -1.117e-01));
	r += mul(s3_2, M4(1.561e-01, -1.141e-01, -4.663e-02, -4.326e-02, 9.767e-02, -8.240e-02, 1.372e-01, -3.313e-02, -2.856e-02, 2.021e-01, 4.114e-02, -1.512e-01, -4.197e-03, -1.235e-01, 5.185e-02, -9.070e-02));
	r += mul(s3_3, M4(6.872e-02, 3.742e-02, -2.118e-02, -2.090e-02, -1.240e-02, -2.806e-02, -8.335e-03, 2.746e-02, -8.620e-02, -4.219e-02, 2.922e-02, 3.157e-02, 1.153e-01, -9.716e-02, -4.720e-02, -1.023e-01));
	r += mul(s3_4, M4(-2.349e-01, -4.080e-01, -3.222e-01, -4.920e-01, 1.183e-01, -4.490e-02, 1.509e-01, -7.753e-02, -8.539e-02, 7.595e-02, -1.085e-01, 2.213e-01, 2.203e-01, 4.651e-02, 4.022e-02, -4.619e-01));
	r += mul(s3_5, M4(1.305e-01, -6.924e-02, -2.362e-02, -1.763e-01, -7.495e-02, -5.263e-02, -2.810e-03, 3.534e-03, -4.620e-02, 1.199e-03, 1.183e-01, 7.935e-02, 7.310e-03, -1.576e-01, 5.596e-02, 1.310e-01));
	r += mul(s3_6, M4(1.163e-02, 5.437e-02, 9.811e-02, 8.154e-02, 1.875e-02, -5.344e-02, 1.110e-03, -1.606e-02, 1.176e-02, 3.321e-02, 7.622e-02, -1.049e-01, -4.287e-02, -2.004e-01, -1.664e-01, -1.601e-01));
	r += mul(s3_7, M4(-5.847e-02, 3.982e-02, -9.274e-02, -3.528e-02, 1.357e-02, -8.811e-02, 2.798e-02, 1.610e-02, -8.094e-02, 1.221e-01, 1.545e-01, 1.393e-01, 1.614e-02, -6.596e-03, -9.230e-02, 7.828e-02));
	r += mul(s3_8, M4(1.433e-02, 2.302e-02, 1.756e-03, 4.419e-02, 2.216e-02, -1.352e-01, -2.377e-02, -7.755e-02, -1.540e-01, 6.615e-02, -9.143e-04, -1.092e-01, -5.908e-02, 8.977e-03, -1.693e-01, 1.599e-01));
	r += V4(1.103e-02, -1.627e-02, -1.286e-02, -1.415e-02);
	return r;
}

V4 f1(V4 s0_0, V4 s0_1, V4 s0_2, V4 s0_3, V4 s0_4, V4 s0_5, V4 s0_6, V4 s0_7, V4 s0_8, V4 s1_0, V4 s1_1, V4 s1_2, V4 s1_3, V4 s1_4, V4 s1_5, V4 s1_6, V4 s1_7, V4 s1_8, V4 s2_0, V4 s2_1, V4 s2_2, V4 s2_3, V4 s2_4, V4 s2_5, V4 s2_6, V4 s2_7, V4 s2_8, V4 s3_0, V4 s3_1, V4 s3_2, V4 s3_3, V4 s3_4, V4 s3_5, V4 s3_6, V4 s3_7, V4 s3_8) {
	V4 r = 0.0;
	r += mul(s0_0, M4(-5.521e-03, -3.227e-02, -8.959e-02, -2.310e-02, -3.505e-02, -1.074e-01, 1.005e-01, -1.186e-02, -2.056e-03, -1.544e-02, 1.421e-01, -8.042e-02, 1.062e-02, -6.143e-02, -4.901e-03, -9.454e-02));
	r += mul(s0_1, M4(3.801e-02, -5.568e-02, 3.259e-02, 6.786e-02, -6.511e-02, 5.286e-02, 1.561e-02, -4.836e-02, -9.207e-02, -1.990e-01, 4.230e-01, 2.050e-02, 4.370e-02, 1.434e-01, -5.622e-02, 6.287e-02));
	r += mul(s0_2, M4(-7.980e-02, 5.040e-02, -2.226e-02, -2.332e-02, -1.077e-02, -1.836e-02, -2.621e-02, -1.471e-02, 2.554e-02, 4.099e-02, 1.355e-01, -1.841e-01, 8.085e-03, -3.333e-02, 8.552e-03, -2.047e-02));
	r += mul(s0_3, M4(6.407e-02, 1.156e-01, -1.245e-01, -4.790e-02, -1.968e-01, -5.708e-02, 5.560e-02, 3.975e-01, -3.533e-02, -1.222e-01, -1.292e-02, -6.471e-02, -4.069e-03, -4.856e-02, 2.772e-02, -2.131e-01));
	r += mul(s0_4, M4(5.784e-03, -4.214e-01, 9.652e-02, 2.624e-01, -4.463e-01, -3.606e-01, -3.593e-02, 2.150e-01, 1.693e-01, 1.568e-01, -4.593e-02, -3.257e-01, 7.479e-02, -8.113e-03, 3.176e-01, 2.823e-01));
	r += mul(s0_5, M4(-4.752e-02, 1.916e-01, -1.042e-01, -1.253e-02, -2.057e-02, -3.405e-02, -5.519e-02, -3.911e-02, 2.241e-01, -1.885e-02, 1.204e-01, 4.924e-02, 2.986e-02, 5.848e-02, -3.441e-02, -7.179e-02));
	r += mul(s0_6, M4(6.014e-02, 4.232e-02, -5.073e-02, -2.059e-02, -4.711e-02, -1.640e-01, 9.222e-02, 2.780e-01, -1.505e-03, -2.975e-02, 4.008e-02, -2.294e-02, 6.812e-02, 5.715e-03, -1.852e-01, -8.323e-02));
	r += mul(s0_7, M4(6.323e-02, -4.207e-02, 2.370e-02, 1.695e-01, -6.565e-02, 1.543e-01, -6.446e-02, -5.231e-02, 8.916e-03, -8.248e-03, 3.969e-02, 9.619e-02, 1.804e-01, -1.653e-01, 1.140e-01, 2.200e-01));
	r += mul(s0_8, M4(8.670e-03, -3.521e-02, -1.453e-01, -9.260e-02, 2.707e-02, 1.519e-01, -8.643e-02, -1.226e-01, 4.304e-02, 7.913e-03, 1.759e-02, 2.059e-01, 1.695e-02, -1.457e-02, 1.015e-01, -5.574e-02));
	r += mul(s1_0, M4(-9.047e-04, -7.526e-02, 3.870e-02, -3.091e-03, -3.185e-02, -3.210e-02, -5.562e-02, 1.604e-01, -4.968e-02, 3.186e-02, 1.647e-01, 4.125e-02, -5.160e-02, -1.243e-02, -4.020e-02, -8.829e-02));
	r += mul(s1_1, M4(2.446e-02, -1.086e-01, 1.076e-01, 1.603e-01, -1.886e-01, 6.601e-02, 2.700e-03, -1.031e-02, -1.411e-01, -1.737e-02, -1.220e-02, 1.722e-01, -9.362e-02, 8.900e-02, 3.836e-02, 2.557e-02));
	r += mul(s1_2, M4(5.523e-02, 1.215e-01, 2.999e-02, -7.301e-02, -1.061e-01, -2.018e-02, 1.581e-03, 3.590e-02, -7.798e-02, -2.899e-02, 8.488e-02, 6.095e-02, -5.692e-03, 4.157e-02, -4.302e-02, 8.434e-02));
	r += mul(s1_3, M4(4.727e-02, -1.131e-01, 1.154e-02, -3.369e-01, -2.170e-02, -8.931e-02, 1.535e-01, 8.759e-02, 4.050e-02, -1.016e-01, 8.183e-02, -1.638e-01, 3.286e-02, -2.050e-01, -9.847e-02, 8.546e-02));
	r += mul(s1_4, M4(8.860e-02, -4.114e-01, 3.215e-01, 3.164e-01, -3.487e-01, -4.634e-01, 1.398e-01, 3.320e-01, 1.261e-01, -1.121e-01, 5.128e-02, 2.666e-01, -4.104e-04, -4.406e-01, -1.674e-01, 2.686e-01));
	r += mul(s1_5, M4(1.196e-01, 7.047e-04, 1.721e-01, 1.966e-02, -3.580e-02, 1.681e-02, -8.139e-02, 1.200e-01, 2.414e-02, 8.583e-02, 5.284e-02, -8.748e-03, -1.313e-01, 8.085e-02, 2.055e-02, -4.308e-02));
	r += mul(s1_6, M4(2.875e-02, -6.798e-02, 3.081e-02, 9.796e-02, -8.332e-03, -1.172e-01, 6.169e-02, 2.643e-02, 7.465e-03, -9.946e-02, 6.580e-02, -9.836e-02, 5.662e-02, 1.801e-02, -8.294e-02, -1.172e-01));
	r += mul(s1_7, M4(5.495e-02, -9.538e-04, -3.587e-02, 1.118e-01, -4.600e-02, 2.166e-01, 6.635e-02, 2.927e-02, 5.700e-02, -5.216e-02, 4.287e-02, -3.235e-02, 2.396e-01, -2.299e-01, -1.761e-01, -9.716e-02));
	r += mul(s1_8, M4(5.748e-02, 2.837e-02, -5.760e-02, 4.236e-02, 2.148e-02, 7.319e-02, -7.836e-02, -1.546e-01, -1.942e-02, 2.458e-02, 1.181e-01, 7.293e-02, -2.915e-02, -2.068e-02, -3.460e-02, -1.232e-01));
	r += mul(s2_0, M4(3.632e-02, -1.866e-02, 2.030e-01, -4.521e-02, 8.081e-02, 8.579e-02, 3.637e-02, -7.211e-02, -7.259e-02, -9.637e-02, -3.099e-02, 8.137e-03, -5.767e-03, 1.281e-02, 2.569e-02, 1.671e-02));
	r += mul(s2_1, M4(1.033e-01, 1.037e-02, 3.472e-01, 3.228e-02, -1.171e-01, 2.538e-02, -5.485e-02, 2.071e-02, 4.456e-02, -1.482e-01, 4.948e-02, 1.478e-01, 1.292e-02, -3.387e-02, 1.172e-02, -5.736e-02));
	r += mul(s2_2, M4(-5.565e-03, 3.590e-02, 5.145e-02, -4.043e-02, -3.857e-02, -1.070e-01, 1.745e-01, 8.157e-02, -2.818e-02, 8.915e-02, 1.199e-01, 1.283e-03, 7.934e-02, -5.920e-02, -1.159e-02, -1.067e-01));
	r += mul(s2_3, M4(4.071e-02, -6.976e-02, 4.140e-02, 1.077e-01, 2.992e-02, 4.067e-02, -3.996e-02, 1.372e-01, 1.240e-02, -1.392e-01, 8.767e-02, -5.693e-02, -5.435e-02, -1.238e-01, 1.790e-02, -1.646e-01));
	r += mul(s2_4, M4(1.929e-01, 2.386e-01, -1.810e-01, 4.484e-01, -2.357e-02, -6.054e-02, -6.168e-02, -2.420e-01, -6.921e-02, -3.946e-01, -2.529e-01, 1.010e-01, 3.271e-01, -6.237e-02, -1.207e-02, -1.547e-01));
	r += mul(s2_5, M4(-1.669e-02, -7.439e-02, 1.247e-01, 8.483e-02, 1.398e-01, -2.795e-02, -8.120e-02, 6.695e-02, 9.151e-02, 3.799e-03, -2.224e-01, 2.380e-01, 9.462e-02, -1.340e-01, -1.219e-01, 4.606e-02));
	r += mul(s2_6, M4(-6.699e-03, 7.497e-02, 7.645e-02, 8.640e-02, -1.486e-02, -3.314e-02, 2.684e-02, -6.462e-02, 3.503e-03, -4.940e-02, 7.803e-02, -4.800e-02, -3.313e-03, -6.215e-02, -1.157e-02, 4.294e-02));
	r += mul(s2_7, M4(5.624e-02, 2.786e-01, -6.348e-02, -8.999e-02, -1.007e-01, 3.742e-03, 1.282e-02, -3.012e-02, 7.205e-02, -4.481e-03, 5.465e-02, -8.988e-02, 5.866e-02, 1.780e-01, -3.760e-01, -2.454e-01));
	r += mul(s2_8, M4(9.374e-03, -7.492e-03, -9.421e-02, -2.475e-02, -2.297e-03, 6.944e-02, 2.745e-02, 7.689e-02, 5.201e-03, 4.984e-02, 1.676e-01, 1.915e-02, 3.006e-03, -9.448e-02, 2.945e-02, 4.559e-02));
	r += mul(s3_0, M4(4.476e-02, 2.980e-01, -1.164e-01, -1.511e-01, 1.188e-01, -3.359e-01, 2.101e-01, -3.195e-01, -2.468e-03, 5.351e-02, -1.329e-01, -1.496e-01, -8.304e-02, 4.541e-02, -8.868e-03, 3.964e-03));
	r += mul(s3_1, M4(-1.505e-01, 2.723e-02, -9.004e-02, 2.151e-01, -3.771e-02, -1.941e-01, 3.681e-01, -2.844e-01, 1.730e-01, 2.429e-02, -2.395e-01, 1.791e-02, -9.777e-02, 5.106e-02, -6.921e-03, -9.913e-02));
	r += mul(s3_2, M4(4.079e-02, 7.965e-02, -1.219e-01, -1.476e-01, -8.922e-02, -1.848e-01, 9.943e-02, -6.997e-02, -6.066e-02, 1.087e-01, 2.364e-02, -1.383e-01, 3.358e-02, -1.140e-01, -1.239e-02, -1.002e-01));
	r += mul(s3_3, M4(-2.038e-02, -2.087e-01, -2.781e-02, 2.218e-01, -4.068e-03, -2.081e-01, -2.048e-01, -1.173e-01, 4.122e-02, 1.402e-01, -1.797e-03, 1.284e-01, -6.767e-02, -6.230e-02, -1.694e-01, 2.256e-02));
	r += mul(s3_4, M4(1.255e-01, 2.984e-01, -5.116e-01, 3.584e-01, -1.813e-01, -3.424e-01, 1.837e-01, -5.376e-03, -2.635e-01, -1.358e-01, -5.520e-01, -4.240e-02, 1.161e-01, -6.542e-02, -1.056e-01, -4.898e-02));
	r += mul(s3_5, M4(-1.399e-02, -5.929e-02, -3.799e-02, 5.016e-02, 6.597e-02, -7.250e-02, -9.893e-02, 1.723e-01, 2.748e-01, 2.064e-02, -1.016e-01, -1.385e-02, -2.072e-02, -2.790e-02, -6.064e-02, -2.727e-02));
	r += mul(s3_6, M4(-1.990e-02, -8.099e-02, 2.959e-02, -9.899e-02, -6.404e-02, -7.691e-02, 1.050e-01, 4.486e-02, 6.109e-02, -5.415e-02, 2.468e-02, -3.233e-02, -3.263e-02, 5.391e-02, -2.056e-01, -7.300e-02));
	r += mul(s3_7, M4(-6.814e-02, 1.238e-01, 3.873e-02, -2.108e-02, -1.586e-01, -2.624e-02, -1.219e-02, -1.521e-01, 1.786e-01, -8.109e-02, 2.714e-02, -8.674e-02, 2.940e-02, -4.832e-02, -1.425e-01, 4.084e-02));
	r += mul(s3_8, M4(2.428e-02, -4.195e-02, -6.436e-02, -1.113e-01, -9.072e-03, 1.545e-02, 4.824e-02, -1.465e-01, -4.214e-02, -1.313e-01, -6.468e-02, 2.691e-02, 2.508e-02, 1.355e-01, -1.529e-01, -2.560e-02));
	r += V4(3.107e-02, -3.014e-02, 6.615e-03, -1.582e-02);
	return r;
}

void Pass6(uint2 blockStart, uint3 tid) {
	float2 pt = float2(GetInputPt());
	uint2 gxy = Rmp8x8(tid.x) + blockStart;
	uint2 size = GetInputSize();
	if (gxy.x >= size.x || gxy.y >= size.y) {
		return;
	}
	float2 pos = (gxy + 0.5) * pt;

	V4 s0_0 = l0(-1.0, -1.0);
	V4 s0_1 = l0(0.0, -1.0);
	V4 s0_2 = l0(1.0, -1.0);
	V4 s0_3 = l0(-1.0, 0.0);
	V4 s0_4 = l0(0.0, 0.0);
	V4 s0_5 = l0(1.0, 0.0);
	V4 s0_6 = l0(-1.0, 1.0);
	V4 s0_7 = l0(0.0, 1.0);
	V4 s0_8 = l0(1.0, 1.0);
	V4 s1_0 = -max(-s0_0, 0.0);
	V4 s1_1 = -max(-s0_1, 0.0);
	V4 s1_2 = -max(-s0_2, 0.0);
	V4 s1_3 = -max(-s0_3, 0.0);
	V4 s1_4 = -max(-s0_4, 0.0);
	V4 s1_5 = -max(-s0_5, 0.0);
	V4 s1_6 = -max(-s0_6, 0.0);
	V4 s1_7 = -max(-s0_7, 0.0);
	V4 s1_8 = -max(-s0_8, 0.0);
	s0_0 = max(s0_0, 0.0);
	s0_1 = max(s0_1, 0.0);
	s0_2 = max(s0_2, 0.0);
	s0_3 = max(s0_3, 0.0);
	s0_4 = max(s0_4, 0.0);
	s0_5 = max(s0_5, 0.0);
	s0_6 = max(s0_6, 0.0);
	s0_7 = max(s0_7, 0.0);
	s0_8 = max(s0_8, 0.0);

	V4 s2_0 = l1(-1.0, -1.0);
	V4 s2_1 = l1(0.0, -1.0);
	V4 s2_2 = l1(1.0, -1.0);
	V4 s2_3 = l1(-1.0, 0.0);
	V4 s2_4 = l1(0.0, 0.0);
	V4 s2_5 = l1(1.0, 0.0);
	V4 s2_6 = l1(-1.0, 1.0);
	V4 s2_7 = l1(0.0, 1.0);
	V4 s2_8 = l1(1.0, 1.0);
	V4 s3_0 = -max(-s2_0, 0.0);
	V4 s3_1 = -max(-s2_1, 0.0);
	V4 s3_2 = -max(-s2_2, 0.0);
	V4 s3_3 = -max(-s2_3, 0.0);
	V4 s3_4 = -max(-s2_4, 0.0);
	V4 s3_5 = -max(-s2_5, 0.0);
	V4 s3_6 = -max(-s2_6, 0.0);
	V4 s3_7 = -max(-s2_7, 0.0);
	V4 s3_8 = -max(-s2_8, 0.0);
	s2_0 = max(s2_0, 0.0);
	s2_1 = max(s2_1, 0.0);
	s2_2 = max(s2_2, 0.0);
	s2_3 = max(s2_3, 0.0);
	s2_4 = max(s2_4, 0.0);
	s2_5 = max(s2_5, 0.0);
	s2_6 = max(s2_6, 0.0);
	s2_7 = max(s2_7, 0.0);
	s2_8 = max(s2_8, 0.0);

	t2[gxy] = f0(s0_0, s0_1, s0_2, s0_3, s0_4, s0_5, s0_6, s0_7, s0_8, s1_0, s1_1, s1_2, s1_3, s1_4, s1_5, s1_6, s1_7, s1_8, s2_0, s2_1, s2_2, s2_3, s2_4, s2_5, s2_6, s2_7, s2_8, s3_0, s3_1, s3_2, s3_3, s3_4, s3_5, s3_6, s3_7, s3_8);
	t3[gxy] = f1(s0_0, s0_1, s0_2, s0_3, s0_4, s0_5, s0_6, s0_7, s0_8, s1_0, s1_1, s1_2, s1_3, s1_4, s1_5, s1_6, s1_7, s1_8, s2_0, s2_1, s2_2, s2_3, s2_4, s2_5, s2_6, s2_7, s2_8, s3_0, s3_1, s3_2, s3_3, s3_4, s3_5, s3_6, s3_7, s3_8);
}

//!PASS 7
//!DESC conv6
//!BLOCK_SIZE 8
//!NUM_THREADS 64
//!IN t2, t3
//!OUT t0, t1

#define l0(x, y) V4(O(t2, float2(x, y)))
#define l1(x, y) V4(O(t3, float2(x, y)))

V4 f0(V4 s0_0, V4 s0_1, V4 s0_2, V4 s0_3, V4 s0_4, V4 s0_5, V4 s0_6, V4 s0_7, V4 s0_8, V4 s1_0, V4 s1_1, V4 s1_2, V4 s1_3, V4 s1_4, V4 s1_5, V4 s1_6, V4 s1_7, V4 s1_8, V4 s2_0, V4 s2_1, V4 s2_2, V4 s2_3, V4 s2_4, V4 s2_5, V4 s2_6, V4 s2_7, V4 s2_8, V4 s3_0, V4 s3_1, V4 s3_2, V4 s3_3, V4 s3_4, V4 s3_5, V4 s3_6, V4 s3_7, V4 s3_8) {
	V4 r = 0.0;
	r += mul(s0_0, M4(2.404e-02, 2.997e-02, -3.284e-02, -5.164e-02, -8.224e-02, 1.916e-02, -5.887e-02, -1.108e-01, 5.058e-02, -9.101e-02, -2.799e-02, -1.015e-01, -2.853e-03, -5.750e-02, -3.651e-02, 7.911e-02));
	r += mul(s0_1, M4(7.598e-02, -4.379e-03, -1.111e-01, 1.520e-01, 6.809e-02, 2.420e-02, -1.512e-02, -8.763e-02, -5.779e-02, 2.712e-03, 2.095e-01, -1.363e-02, 6.453e-03, -8.446e-02, -4.731e-02, 2.419e-02));
	r += mul(s0_2, M4(7.891e-02, -1.816e-02, 7.892e-02, 8.296e-02, -1.422e-02, 5.360e-02, 8.078e-02, -2.628e-02, -6.979e-03, -2.700e-02, -8.674e-02, 8.292e-02, -1.558e-02, -4.723e-02, -1.121e-01, 6.815e-02));
	r += mul(s0_3, M4(2.828e-02, -4.739e-02, -2.074e-01, -3.196e-01, -3.889e-02, 8.126e-02, 1.927e-01, 2.481e-01, 1.304e-01, -2.371e-02, -3.977e-02, -9.958e-02, -1.919e-03, 3.208e-02, 4.055e-02, -1.030e-01));
	r += mul(s0_4, M4(-1.040e-01, 1.768e-01, -8.376e-02, 4.783e-01, -2.102e-01, -2.036e-01, 2.606e-01, -5.867e-02, 1.840e-01, -9.110e-02, 9.612e-02, 2.183e-01, -1.455e-01, 1.636e-01, 2.425e-01, -2.316e-01));
	r += mul(s0_5, M4(1.393e-01, -7.825e-02, -6.535e-02, 6.115e-02, 7.806e-02, -7.575e-02, 2.447e-03, -1.255e-02, -8.062e-02, -1.768e-02, 1.831e-02, 1.318e-02, -1.194e-01, 1.821e-02, -6.475e-02, 9.178e-02));
	r += mul(s0_6, M4(2.158e-02, 5.031e-02, 5.894e-02, -2.206e-02, 1.642e-02, -4.703e-02, 7.177e-03, 4.832e-02, -6.795e-03, 1.200e-01, 7.350e-02, 4.357e-02, -1.374e-02, -2.273e-02, 5.343e-02, -3.053e-02));
	r += mul(s0_7, M4(-2.053e-03, 2.418e-01, -7.675e-02, 7.563e-02, 1.879e-01, -5.891e-02, 1.363e-02, -5.479e-02, -2.454e-01, 3.717e-02, -6.543e-02, -9.897e-02, 1.506e-01, -1.457e-02, 7.962e-02, 2.634e-02));
	r += mul(s0_8, M4(-4.787e-02, 7.421e-02, 4.307e-02, -1.165e-01, -1.552e-01, -2.697e-02, -9.967e-02, 3.872e-02, -6.328e-02, 1.037e-01, -3.953e-02, 8.554e-02, 4.862e-02, -2.809e-02, -2.267e-02, -1.011e-02));
	r += mul(s1_0, M4(6.553e-02, -3.868e-03, -3.811e-02, 6.105e-03, 8.599e-03, 4.356e-02, 7.104e-02, -1.001e-01, -8.656e-02, -2.863e-02, 4.224e-02, -4.758e-02, 8.669e-04, 2.007e-02, 4.083e-02, 7.794e-02));
	r += mul(s1_1, M4(-2.462e-02, -1.574e-02, -4.985e-03, 1.459e-01, 1.573e-03, 8.120e-02, -1.362e-01, -1.597e-01, -2.973e-02, -2.999e-01, 1.528e-03, 4.741e-01, 9.943e-02, 7.836e-02, 1.532e-02, -4.459e-02));
	r += mul(s1_2, M4(1.434e-02, -2.119e-02, -3.105e-02, -1.281e-02, -1.791e-01, -3.910e-02, 5.519e-02, 1.343e-01, -1.333e-01, -8.837e-02, -1.076e-01, 1.067e-01, -1.577e-02, 6.211e-02, 1.116e-02, -6.399e-02));
	r += mul(s1_3, M4(-1.004e-01, 2.091e-02, -5.478e-02, -1.756e-01, -9.005e-02, 9.037e-02, 1.250e-01, 8.268e-02, 1.398e-01, -1.338e-01, -1.158e-01, -6.447e-02, 4.636e-02, 8.153e-02, 3.763e-02, -5.705e-02));
	r += mul(s1_4, M4(3.115e-01, -3.808e-01, 1.332e-01, 8.542e-02, 1.126e-01, -1.795e-01, 2.202e-01, 1.600e-01, 1.475e-01, 1.186e-01, 1.995e-01, -1.733e-01, -4.463e-01, 5.858e-01, 7.088e-02, -4.531e-01));
	r += mul(s1_5, M4(-5.391e-02, 5.806e-02, 7.177e-02, 2.734e-01, -1.093e-01, -7.192e-02, -2.031e-03, -9.404e-02, -2.599e-02, -2.688e-03, 2.064e-02, 1.819e-01, 8.417e-02, -3.743e-02, -5.253e-02, -2.005e-01));
	r += mul(s1_6, M4(1.709e-02, 5.473e-02, 1.583e-02, -1.412e-01, 3.210e-02, -5.364e-02, -1.279e-02, -4.324e-02, -2.110e-01, 6.215e-02, -7.099e-02, 1.011e-01, -3.931e-03, -3.861e-03, 2.847e-02, 9.082e-02));
	r += mul(s1_7, M4(-2.610e-01, 1.499e-01, -5.311e-02, 1.480e-02, 1.285e-02, -1.043e-01, -1.002e-01, -3.947e-02, -1.508e-01, 1.144e-01, 1.443e-01, -3.456e-02, 1.332e-01, 1.841e-01, 2.120e-01, -6.647e-03));
	r += mul(s1_8, M4(-1.090e-02, -3.561e-02, 3.492e-02, -7.376e-02, -8.500e-02, -4.378e-02, -1.281e-02, 2.313e-02, -2.974e-01, -1.025e-01, -5.699e-02, 2.294e-02, -4.649e-02, 6.585e-02, 7.421e-02, -6.087e-02));
	r += mul(s2_0, M4(9.719e-02, -1.495e-02, 1.597e-01, 6.545e-03, 1.616e-02, -1.136e-03, 4.194e-02, -2.144e-02, -4.504e-02, -2.040e-02, 3.672e-02, 7.161e-02, 5.032e-02, 7.780e-02, 7.739e-02, 6.251e-02));
	r += mul(s2_1, M4(1.598e-01, 7.514e-02, -3.737e-02, -4.716e-02, -1.324e-01, 1.908e-02, -2.415e-02, -6.085e-02, 9.660e-02, 5.538e-02, -6.763e-02, -8.017e-03, 4.100e-02, -4.304e-03, 9.956e-02, 3.581e-02));
	r += mul(s2_2, M4(4.912e-02, -3.518e-02, -3.550e-02, 5.028e-02, 8.666e-02, 1.122e-01, -1.027e-02, -1.043e-01, 8.323e-02, 4.898e-03, -1.090e-02, -1.912e-02, 2.538e-02, -5.575e-03, 4.678e-02, -5.409e-02));
	r += mul(s2_3, M4(8.412e-03, 1.402e-01, 2.510e-01, -2.978e-02, 2.691e-02, -7.400e-02, -1.719e-01, -2.765e-02, 7.918e-02, -8.331e-03, -2.848e-02, 1.808e-01, -5.017e-02, -1.434e-02, -5.966e-02, 4.193e-04));
	r += mul(s2_4, M4(-7.351e-02, -2.898e-01, -3.926e-01, -2.116e-01, 1.478e-01, -9.418e-02, -1.530e-01, -2.963e-01, -1.190e-01, 4.534e-01, -2.833e-01, -2.530e-01, 2.825e-01, -2.388e-02, 7.258e-02, 4.468e-02));
	r += mul(s2_5, M4(-7.228e-02, 4.241e-02, -1.818e-02, -4.262e-02, -1.139e-01, -5.711e-02, -7.106e-02, -7.861e-02, -4.809e-02, 1.474e-01, -7.394e-03, -4.692e-02, 2.199e-02, 1.038e-01, -5.060e-02, 8.474e-02));
	r += mul(s2_6, M4(1.236e-01, -7.740e-02, 4.034e-02, 2.473e-02, -1.046e-05, 4.154e-02, -5.698e-03, 2.456e-02, -5.245e-02, -1.311e-02, -1.292e-01, -5.838e-02, -4.741e-02, -1.506e-02, -5.012e-02, 2.703e-03));
	r += mul(s2_7, M4(8.191e-02, 1.102e-01, 4.677e-02, -1.667e-02, -2.850e-01, 1.548e-01, -4.856e-03, 1.074e-03, 1.559e-02, 3.353e-02, 2.302e-02, -4.748e-02, -7.978e-02, -1.328e-02, -8.056e-02, 1.167e-02));
	r += mul(s2_8, M4(6.904e-02, -2.015e-02, 7.204e-02, -3.156e-02, -1.374e-01, 5.652e-02, 5.052e-02, -4.269e-02, 3.874e-02, 1.011e-02, 6.918e-02, -5.973e-02, 1.694e-01, 6.863e-02, 8.218e-02, 4.696e-02));
	r += mul(s3_0, M4(1.036e-02, -9.171e-02, 2.046e-01, 1.921e-02, 2.592e-03, -3.041e-02, -1.027e-01, -1.301e-01, -9.272e-03, 5.752e-02, 4.755e-02, -1.453e-02, -3.280e-03, -3.442e-02, -1.207e-02, -2.463e-02));
	r += mul(s3_1, M4(2.136e-01, -2.675e-02, -1.771e-01, 2.694e-02, 3.292e-02, 3.093e-02, 2.271e-01, 2.195e-01, -5.501e-02, 5.664e-03, -2.300e-01, 3.389e-02, -6.249e-02, 3.345e-02, -5.372e-02, -5.311e-02));
	r += mul(s3_2, M4(3.520e-02, -1.165e-01, -7.715e-02, 3.538e-02, 2.150e-01, 1.602e-01, 1.783e-01, -6.312e-02, 1.099e-01, 1.013e-01, -6.535e-02, -1.370e-01, 2.222e-02, 8.245e-02, 3.791e-02, -5.384e-02));
	r += mul(s3_3, M4(4.063e-03, -2.201e-01, 6.289e-02, 1.063e-01, 7.458e-02, -9.281e-02, -1.792e-01, -1.193e-01, -2.276e-02, -2.212e-02, -1.820e-01, -3.791e-02, 6.566e-02, 3.899e-02, 3.693e-02, 2.944e-02));
	r += mul(s3_4, M4(-5.110e-01, -3.091e-01, -7.583e-01, 2.226e-01, -4.668e-02, -4.517e-01, -8.393e-03, -3.556e-01, -6.915e-01, 1.907e-01, -5.686e-01, -5.042e-02, 5.118e-01, 1.140e-01, 3.401e-01, -2.682e-02));
	r += mul(s3_5, M4(-7.635e-03, -9.166e-02, -2.271e-02, -5.200e-02, 1.570e-02, -5.974e-03, 1.862e-01, 7.035e-02, -2.859e-01, 4.639e-02, 4.377e-02, -4.687e-03, 1.782e-01, 1.578e-01, 3.609e-02, -2.364e-02));
	r += mul(s3_6, M4(1.410e-02, -1.417e-01, -9.227e-02, 8.895e-03, 8.245e-02, 1.675e-03, 1.763e-02, -4.726e-02, -3.146e-02, -4.661e-02, -1.085e-01, 6.988e-02, 5.238e-02, 8.178e-02, 7.645e-02, -6.760e-02));
	r += mul(s3_7, M4(2.610e-01, 1.194e-02, -1.065e-02, -9.494e-03, -1.750e-02, 1.167e-02, 2.371e-02, 3.010e-02, 7.709e-02, 2.302e-02, 9.363e-02, 2.560e-02, -1.188e-01, -6.296e-02, -2.176e-02, -1.106e-01));
	r += mul(s3_8, M4(1.396e-01, -1.282e-01, 3.914e-02, -2.227e-02, -1.906e-02, 5.945e-02, -1.260e-02, -7.651e-02, 8.742e-02, 1.698e-02, 8.794e-02, -3.933e-02, 2.223e-02, -2.413e-03, -2.701e-02, -4.654e-02));
	r += V4(1.289e-02, -6.634e-03, 3.674e-02, 1.609e-03);
	return r;
}

V4 f1(V4 s0_0, V4 s0_1, V4 s0_2, V4 s0_3, V4 s0_4, V4 s0_5, V4 s0_6, V4 s0_7, V4 s0_8, V4 s1_0, V4 s1_1, V4 s1_2, V4 s1_3, V4 s1_4, V4 s1_5, V4 s1_6, V4 s1_7, V4 s1_8, V4 s2_0, V4 s2_1, V4 s2_2, V4 s2_3, V4 s2_4, V4 s2_5, V4 s2_6, V4 s2_7, V4 s2_8, V4 s3_0, V4 s3_1, V4 s3_2, V4 s3_3, V4 s3_4, V4 s3_5, V4 s3_6, V4 s3_7, V4 s3_8) {
	V4 r = 0.0;
	r += mul(s0_0, M4(1.600e-02, -1.109e-01, 7.068e-02, -1.811e-01, 1.063e-02, -6.863e-02, -6.434e-02, 1.375e-02, 2.456e-01, -4.348e-02, 5.149e-02, 2.022e-02, -3.151e-02, 1.061e-02, 1.882e-02, 3.657e-02));
	r += mul(s0_1, M4(6.848e-02, 6.202e-02, 6.749e-02, 2.417e-01, 8.964e-02, 1.551e-01, 3.107e-03, 5.573e-02, -1.239e-01, -6.104e-02, 2.686e-01, -1.557e-01, -2.527e-02, 3.832e-02, -4.138e-02, 1.948e-01));
	r += mul(s0_2, M4(-2.463e-01, -3.228e-02, 5.194e-02, -1.168e-01, -8.813e-02, -2.266e-02, -8.269e-03, 8.535e-02, 2.962e-02, 4.934e-02, 1.222e-02, -2.672e-02, 8.425e-02, 7.315e-02, -1.661e-03, 6.929e-02));
	r += mul(s0_3, M4(4.423e-02, -5.269e-02, -8.159e-02, -4.065e-02, -1.822e-01, 1.176e-01, 5.985e-02, 1.526e-01, 6.602e-02, -1.554e-01, -9.981e-02, -5.084e-02, -2.635e-02, -1.488e-01, -3.293e-02, -1.259e-01));
	r += mul(s0_4, M4(5.130e-01, 1.827e-02, -8.425e-02, -1.359e-01, 6.076e-02, -3.010e-02, -3.517e-02, -1.604e-01, 6.842e-02, 4.031e-01, -4.483e-01, 1.444e-01, 7.936e-02, 2.010e-01, 1.000e-02, 8.051e-02));
	r += mul(s0_5, M4(1.784e-02, -5.340e-02, 8.986e-03, -8.302e-02, 1.744e-01, -5.748e-02, 3.942e-02, 1.104e-02, -1.938e-01, -5.557e-02, -6.293e-03, -1.411e-01, 7.521e-03, 9.413e-02, 2.034e-02, 1.249e-01));
	r += mul(s0_6, M4(2.540e-02, 2.131e-01, 4.611e-02, 9.382e-02, 5.992e-02, -6.154e-02, -3.255e-02, -4.284e-02, -1.709e-02, 3.054e-02, -7.711e-02, -3.413e-02, 2.668e-02, 7.784e-03, 1.578e-01, -3.615e-03));
	r += mul(s0_7, M4(-6.617e-02, -1.114e-01, 3.306e-02, 2.025e-02, -2.133e-01, -2.866e-01, 1.364e-01, 2.138e-02, 2.444e-02, -1.753e-02, 3.907e-02, 6.912e-03, -3.994e-02, -2.617e-02, 1.246e-02, -3.568e-02));
	r += mul(s0_8, M4(1.790e-02, -6.453e-02, 1.921e-02, -2.243e-02, 9.646e-02, 2.163e-01, -5.867e-02, 3.342e-02, 5.237e-02, 1.622e-01, -1.256e-01, 1.834e-02, 1.350e-01, 3.223e-02, -1.533e-02, 2.442e-02));
	r += mul(s1_0, M4(-6.017e-02, -1.388e-01, 9.635e-02, -5.857e-02, 4.819e-02, -8.395e-02, -2.810e-02, -5.550e-02, 1.881e-01, 4.630e-02, 5.251e-02, 1.190e-02, -5.155e-02, -4.143e-02, 4.654e-02, 1.323e-01));
	r += mul(s1_1, M4(-1.534e-01, 2.133e-01, 7.453e-03, 3.310e-01, 3.330e-01, -2.181e-01, 7.039e-03, -3.036e-01, 5.444e-02, 2.537e-02, 2.069e-01, -4.402e-01, -1.355e-01, 2.013e-01, -5.209e-02, 8.730e-02));
	r += mul(s1_2, M4(-1.847e-01, -1.391e-01, 1.870e-02, 1.309e-01, 2.844e-01, 3.281e-02, 8.661e-02, -1.124e-01, -2.647e-01, -1.385e-01, 4.175e-02, -2.057e-01, -2.192e-02, -4.144e-02, -1.024e-02, 1.893e-01));
	r += mul(s1_3, M4(6.497e-02, -1.624e-01, -1.987e-01, -9.848e-02, 2.015e-02, -1.708e-01, 1.357e-02, -7.956e-03, 6.654e-02, 1.122e-01, 5.543e-02, 1.017e-01, -9.423e-02, -6.570e-02, 2.641e-02, -1.932e-02));
	r += mul(s1_4, M4(5.957e-01, -3.290e-03, -2.924e-02, -1.725e-01, 3.083e-01, -2.819e-01, -3.768e-02, -1.529e-01, -1.565e-01, 1.963e-01, -3.850e-01, -1.976e-02, 1.505e-01, -6.149e-02, 1.786e-01, -7.251e-02));
	r += mul(s1_5, M4(4.111e-01, 2.475e-01, 3.496e-03, -1.918e-02, 3.022e-01, -3.534e-02, -1.221e-01, -1.536e-02, 2.677e-03, -5.321e-02, -4.602e-03, -3.425e-02, -9.627e-02, 1.600e-01, -1.031e-02, 1.667e-01));
	r += mul(s1_6, M4(-1.234e-01, -8.749e-03, 2.104e-01, 4.344e-02, 7.180e-03, -2.356e-01, -2.194e-01, -7.217e-02, 5.686e-02, 1.327e-01, -1.764e-01, 3.995e-02, -4.611e-02, 5.706e-02, 1.884e-01, 5.417e-02));
	r += mul(s1_7, M4(-2.653e-02, -8.258e-02, -1.446e-01, -1.117e-02, 7.767e-02, -2.549e-01, 3.667e-02, -1.282e-02, -6.408e-03, -1.133e-01, -3.932e-01, -2.699e-02, -8.717e-02, -6.648e-02, 6.511e-03, -5.576e-02));
	r += mul(s1_8, M4(-1.220e-01, -7.955e-02, -6.599e-02, 1.149e-02, 9.638e-02, 1.366e-01, -2.627e-02, 8.338e-03, 1.672e-01, 1.442e-01, -1.766e-01, -1.002e-03, 7.156e-02, -8.644e-02, 6.749e-02, 4.908e-02));
	r += mul(s2_0, M4(-7.895e-02, -4.986e-02, 9.949e-02, -6.798e-03, 6.860e-02, 9.700e-04, -2.217e-02, -3.504e-02, 3.005e-02, 3.853e-02, 9.426e-02, -1.053e-02, -9.779e-02, -5.977e-02, 1.559e-02, 1.355e-03));
	r += mul(s2_1, M4(-4.166e-02, 2.806e-02, 3.031e-02, -1.847e-01, 5.010e-02, -2.266e-01, 6.752e-02, -8.594e-02, -1.181e-01, -3.677e-02, -4.894e-02, -3.854e-01, -9.499e-02, 8.388e-02, 2.762e-02, -6.678e-02));
	r += mul(s2_2, M4(-5.632e-02, 1.572e-02, 1.683e-02, 7.935e-02, 9.419e-02, 1.391e-01, 7.486e-03, -9.942e-02, 4.651e-02, 6.332e-03, -9.859e-04, 3.178e-02, -1.804e-01, -1.141e-01, -1.244e-02, -2.914e-01));
	r += mul(s2_3, M4(-9.909e-02, -9.091e-02, -1.990e-01, -6.067e-02, 6.513e-02, 3.841e-02, -1.060e-01, 9.766e-03, -5.435e-02, 1.849e-01, -1.739e-01, 3.043e-02, 2.413e-02, -1.910e-02, -1.332e-02, 2.362e-02));
	r += mul(s2_4, M4(2.024e-02, -1.499e-01, -2.345e-01, 6.952e-02, 1.034e-01, 8.021e-03, 5.147e-02, 4.872e-02, -5.598e-02, -1.413e-01, 1.956e-01, -1.350e-02, -8.105e-02, -4.961e-03, -4.300e-03, 5.564e-02));
	r += mul(s2_5, M4(2.284e-02, 3.897e-02, -3.260e-02, -6.460e-02, -1.718e-01, -6.209e-02, 1.432e-02, -8.207e-02, 5.573e-03, 1.411e-01, -7.778e-02, 6.243e-02, -5.605e-02, -1.684e-01, 1.622e-02, -1.153e-01));
	r += mul(s2_6, M4(-1.053e-01, 4.113e-02, 1.887e-01, 5.750e-02, -5.854e-03, 8.616e-02, -1.401e-02, -3.050e-03, 2.563e-02, -1.300e-02, 4.781e-02, -8.556e-03, 2.668e-02, 1.663e-02, 1.541e-02, 1.076e-02));
	r += mul(s2_7, M4(3.180e-02, 1.162e-01, 1.821e-01, -1.556e-02, 2.421e-02, 9.821e-03, -3.662e-02, -1.845e-02, 1.169e-01, 1.404e-01, -7.214e-02, -7.006e-03, 4.773e-02, -8.450e-02, -1.174e-01, -1.970e-02));
	r += mul(s2_8, M4(-1.512e-02, -1.228e-01, 8.843e-02, -5.915e-03, 7.202e-02, 7.004e-02, -3.259e-02, -3.609e-02, 2.087e-02, -6.377e-02, 1.081e-01, -2.104e-02, -5.860e-02, -1.030e-01, -1.644e-02, 4.554e-03));
	r += mul(s3_0, M4(-1.026e-01, -2.673e-01, 2.419e-01, 1.951e-02, 4.828e-02, -1.120e-01, 9.974e-02, -1.526e-01, 9.792e-03, -1.194e-02, 2.884e-02, -3.913e-02, -4.019e-02, 1.306e-03, -9.133e-03, 2.829e-02));
	r += mul(s3_1, M4(5.099e-02, 1.166e-01, 9.745e-02, -6.132e-01, 9.886e-02, -1.197e-01, 1.625e-01, 4.334e-02, 1.472e-02, -2.947e-01, 7.289e-02, -4.089e-01, 5.513e-02, -2.122e-01, 1.863e-03, -1.450e-01));
	r += mul(s3_2, M4(-8.166e-02, 7.367e-02, 6.029e-03, 6.953e-02, -2.331e-01, -1.240e-01, 5.302e-02, -2.107e-01, 1.353e-01, 7.785e-02, -4.803e-02, -4.513e-02, 1.067e-01, -3.485e-02, -8.357e-03, -2.302e-01));
	r += mul(s3_3, M4(5.918e-02, 7.926e-02, -3.945e-01, 1.734e-01, 4.372e-02, 3.205e-02, -9.344e-02, -4.708e-02, -1.211e-01, 2.742e-02, 2.032e-02, 1.747e-02, -6.007e-02, 5.451e-02, -8.460e-02, -2.765e-02));
	r += mul(s3_4, M4(6.409e-01, -1.212e-01, -1.105e-01, 5.278e-02, 5.982e-01, -3.474e-01, -1.078e-01, 2.872e-02, -1.287e-03, -2.148e-01, -1.752e-01, -8.497e-02, -3.730e-01, 8.165e-03, -5.113e-02, 1.547e-01));
	r += mul(s3_5, M4(-8.520e-02, 1.228e-01, 6.252e-03, 1.262e-01, -2.339e-01, -1.996e-01, 1.169e-01, -1.452e-01, -1.209e-02, 1.329e-01, 1.228e-01, -1.087e-01, -1.669e-01, -2.158e-01, 9.188e-02, -4.751e-02));
	r += mul(s3_6, M4(-2.664e-02, -4.621e-02, 1.539e-01, 1.262e-02, 2.615e-02, 1.102e-01, -3.000e-02, 2.546e-02, 2.668e-02, 4.050e-02, -1.118e-01, 2.701e-02, 1.231e-02, 2.743e-02, 3.393e-02, -1.372e-02));
	r += mul(s3_7, M4(5.715e-02, -1.962e-02, 8.036e-02, -3.092e-02, 1.051e-01, -8.764e-02, -1.678e-02, 3.628e-02, -1.425e-01, -1.649e-03, -2.529e-01, 7.452e-02, 8.522e-02, -5.112e-02, 1.689e-01, -2.235e-02));
	r += mul(s3_8, M4(-8.426e-02, -1.070e-01, 1.473e-01, -5.678e-02, -4.167e-02, -8.678e-02, -9.901e-02, 1.746e-02, -1.020e-01, -1.905e-01, 6.511e-02, -1.759e-02, -6.187e-02, 5.960e-03, -9.606e-03, 3.401e-02));
	r += V4(-5.133e-03, 1.777e-02, 4.068e-03, 1.012e-02);
	return r;
}

void Pass7(uint2 blockStart, uint3 tid) {
	float2 pt = float2(GetInputPt());
	uint2 gxy = Rmp8x8(tid.x) + blockStart;
	uint2 size = GetInputSize();
	if (gxy.x >= size.x || gxy.y >= size.y) {
		return;
	}
	float2 pos = (gxy + 0.5) * pt;

	V4 s0_0 = l0(-1.0, -1.0);
	V4 s0_1 = l0(0.0, -1.0);
	V4 s0_2 = l0(1.0, -1.0);
	V4 s0_3 = l0(-1.0, 0.0);
	V4 s0_4 = l0(0.0, 0.0);
	V4 s0_5 = l0(1.0, 0.0);
	V4 s0_6 = l0(-1.0, 1.0);
	V4 s0_7 = l0(0.0, 1.0);
	V4 s0_8 = l0(1.0, 1.0);
	V4 s1_0 = -max(-s0_0, 0.0);
	V4 s1_1 = -max(-s0_1, 0.0);
	V4 s1_2 = -max(-s0_2, 0.0);
	V4 s1_3 = -max(-s0_3, 0.0);
	V4 s1_4 = -max(-s0_4, 0.0);
	V4 s1_5 = -max(-s0_5, 0.0);
	V4 s1_6 = -max(-s0_6, 0.0);
	V4 s1_7 = -max(-s0_7, 0.0);
	V4 s1_8 = -max(-s0_8, 0.0);
	s0_0 = max(s0_0, 0.0);
	s0_1 = max(s0_1, 0.0);
	s0_2 = max(s0_2, 0.0);
	s0_3 = max(s0_3, 0.0);
	s0_4 = max(s0_4, 0.0);
	s0_5 = max(s0_5, 0.0);
	s0_6 = max(s0_6, 0.0);
	s0_7 = max(s0_7, 0.0);
	s0_8 = max(s0_8, 0.0);

	V4 s2_0 = l1(-1.0, -1.0);
	V4 s2_1 = l1(0.0, -1.0);
	V4 s2_2 = l1(1.0, -1.0);
	V4 s2_3 = l1(-1.0, 0.0);
	V4 s2_4 = l1(0.0, 0.0);
	V4 s2_5 = l1(1.0, 0.0);
	V4 s2_6 = l1(-1.0, 1.0);
	V4 s2_7 = l1(0.0, 1.0);
	V4 s2_8 = l1(1.0, 1.0);
	V4 s3_0 = -max(-s2_0, 0.0);
	V4 s3_1 = -max(-s2_1, 0.0);
	V4 s3_2 = -max(-s2_2, 0.0);
	V4 s3_3 = -max(-s2_3, 0.0);
	V4 s3_4 = -max(-s2_4, 0.0);
	V4 s3_5 = -max(-s2_5, 0.0);
	V4 s3_6 = -max(-s2_6, 0.0);
	V4 s3_7 = -max(-s2_7, 0.0);
	V4 s3_8 = -max(-s2_8, 0.0);
	s2_0 = max(s2_0, 0.0);
	s2_1 = max(s2_1, 0.0);
	s2_2 = max(s2_2, 0.0);
	s2_3 = max(s2_3, 0.0);
	s2_4 = max(s2_4, 0.0);
	s2_5 = max(s2_5, 0.0);
	s2_6 = max(s2_6, 0.0);
	s2_7 = max(s2_7, 0.0);
	s2_8 = max(s2_8, 0.0);

	t0[gxy] = f0(s0_0, s0_1, s0_2, s0_3, s0_4, s0_5, s0_6, s0_7, s0_8, s1_0, s1_1, s1_2, s1_3, s1_4, s1_5, s1_6, s1_7, s1_8, s2_0, s2_1, s2_2, s2_3, s2_4, s2_5, s2_6, s2_7, s2_8, s3_0, s3_1, s3_2, s3_3, s3_4, s3_5, s3_6, s3_7, s3_8);
	t1[gxy] = f1(s0_0, s0_1, s0_2, s0_3, s0_4, s0_5, s0_6, s0_7, s0_8, s1_0, s1_1, s1_2, s1_3, s1_4, s1_5, s1_6, s1_7, s1_8, s2_0, s2_1, s2_2, s2_3, s2_4, s2_5, s2_6, s2_7, s2_8, s3_0, s3_1, s3_2, s3_3, s3_4, s3_5, s3_6, s3_7, s3_8);
}

//!PASS 8
//!DESC conv7
//!BLOCK_SIZE 8
//!NUM_THREADS 64
//!IN t0, t1
//!OUT t2, t3

#define l0(x, y) V4(O(t0, float2(x, y)))
#define l1(x, y) V4(O(t1, float2(x, y)))

V4 f0(V4 s0_0, V4 s0_1, V4 s0_2, V4 s0_3, V4 s0_4, V4 s0_5, V4 s0_6, V4 s0_7, V4 s0_8, V4 s1_0, V4 s1_1, V4 s1_2, V4 s1_3, V4 s1_4, V4 s1_5, V4 s1_6, V4 s1_7, V4 s1_8, V4 s2_0, V4 s2_1, V4 s2_2, V4 s2_3, V4 s2_4, V4 s2_5, V4 s2_6, V4 s2_7, V4 s2_8, V4 s3_0, V4 s3_1, V4 s3_2, V4 s3_3, V4 s3_4, V4 s3_5, V4 s3_6, V4 s3_7, V4 s3_8) {
	V4 r = 0.0;
	r += mul(s0_0, M4(1.631e-02, 3.701e-02, -2.434e-02, 8.471e-02, 4.263e-02, 5.692e-02, 5.410e-02, 4.454e-03, -5.624e-02, -7.308e-02, -8.138e-03, -1.520e-02, -5.507e-03, -4.765e-02, 3.131e-02, -6.383e-02));
	r += mul(s0_1, M4(1.588e-02, 1.464e-02, 2.917e-02, -3.454e-02, -1.494e-03, -1.481e-02, -9.514e-02, -4.334e-02, 3.919e-02, 3.710e-02, 4.232e-02, 1.561e-01, 2.753e-02, -9.642e-02, -2.388e-01, -4.597e-02));
	r += mul(s0_2, M4(5.193e-03, -9.561e-03, 5.468e-02, -6.118e-02, 3.707e-02, 5.846e-02, 7.340e-02, 2.255e-02, -3.022e-02, 5.151e-02, 2.252e-02, 7.787e-03, 2.760e-02, 3.242e-02, 9.113e-02, -4.307e-02));
	r += mul(s0_3, M4(-8.921e-03, -7.181e-02, -1.512e-01, 4.666e-02, -4.676e-02, -1.771e-02, 6.837e-02, 8.735e-02, 3.111e-02, 7.935e-02, -4.188e-03, -1.714e-01, 2.293e-02, 9.058e-02, -1.764e-01, 8.294e-03));
	r += mul(s0_4, M4(1.993e-01, 1.421e-01, 7.711e-02, 6.236e-02, -3.828e-02, -1.568e-01, -2.417e-01, -1.350e-01, -8.580e-02, -2.849e-01, -1.312e-01, -3.715e-01, -3.884e-02, -4.602e-01, -1.172e-01, 2.457e-01));
	r += mul(s0_5, M4(1.442e-01, 6.769e-02, 1.666e-01, -5.753e-02, -8.668e-02, -7.359e-02, 3.895e-03, 1.682e-03, 1.593e-02, 9.310e-02, -4.170e-03, 1.061e-01, 4.005e-02, 7.271e-02, -1.133e-02, -6.095e-02));
	r += mul(s0_6, M4(1.652e-02, -4.932e-02, -1.026e-01, -4.651e-03, 2.605e-02, 4.361e-02, -8.225e-02, -1.536e-02, -1.655e-02, 5.030e-03, 4.067e-02, 8.822e-02, -2.308e-02, 8.050e-02, -6.368e-02, 6.068e-03));
	r += mul(s0_7, M4(5.290e-02, -1.020e-02, 1.377e-02, -2.169e-02, 3.890e-02, -7.155e-02, 6.368e-02, -3.030e-02, -3.352e-02, -7.496e-02, -3.534e-02, 4.126e-02, -1.180e-02, -1.737e-01, -3.262e-02, -1.906e-01));
	r += mul(s0_8, M4(5.808e-02, 8.817e-02, 5.857e-02, -5.555e-04, 3.944e-02, -1.533e-03, -1.000e-02, -2.643e-02, 8.856e-03, -9.440e-02, -1.108e-01, -3.988e-03, -7.107e-02, -1.128e-01, -6.348e-02, -5.594e-02));
	r += mul(s1_0, M4(6.233e-02, 2.632e-03, -2.944e-02, -7.241e-03, 6.527e-02, 5.843e-02, 7.877e-02, -3.049e-03, -4.898e-02, -9.257e-02, -7.349e-02, 2.061e-02, 1.027e-02, -9.056e-03, 1.359e-02, 6.851e-03));
	r += mul(s1_1, M4(5.769e-02, -1.509e-01, -4.090e-01, -3.105e-02, 6.866e-02, 8.362e-03, -2.706e-01, -1.117e-01, -5.216e-03, 1.158e-01, 8.544e-02, 7.913e-03, -1.341e-02, -4.537e-02, -6.818e-02, -3.521e-02));
	r += mul(s1_2, M4(7.527e-02, 4.825e-02, 1.968e-01, 4.230e-02, -9.816e-03, 1.132e-01, 1.272e-01, 6.139e-02, -5.991e-02, 8.797e-02, 2.490e-02, 8.849e-02, 6.118e-03, 8.134e-02, 1.287e-01, 1.401e-02));
	r += mul(s1_3, M4(3.013e-02, -1.096e-01, -3.818e-01, -2.105e-01, -7.226e-02, 1.442e-01, 1.028e-01, 1.038e-01, 6.223e-02, 2.133e-03, 1.029e-01, 5.877e-02, 3.329e-02, -1.971e-02, -1.260e-01, -4.246e-02));
	r += mul(s1_4, M4(4.756e-01, 6.473e-02, 1.863e-01, 2.217e-01, -3.590e-01, -6.434e-01, -1.796e-01, -1.997e-02, -2.041e-01, 8.227e-02, 1.277e-01, -2.091e-01, 1.817e-02, -2.976e-01, -3.877e-01, 8.980e-02));
	r += mul(s1_5, M4(3.625e-01, -6.200e-02, -1.578e-02, -6.555e-02, -1.656e-01, 1.131e-02, 3.952e-02, -5.259e-02, 2.280e-01, 2.605e-01, -1.093e-01, 2.026e-01, -4.178e-02, 2.472e-02, 1.802e-01, 5.444e-02));
	r += mul(s1_6, M4(2.555e-02, -6.827e-02, -1.084e-01, 3.976e-02, 1.274e-02, 6.716e-02, -4.575e-02, -2.343e-02, 2.861e-02, -7.587e-04, 5.146e-02, 1.335e-01, -1.543e-02, -4.756e-02, -5.113e-02, 1.725e-02));
	r += mul(s1_7, M4(2.567e-03, -1.154e-01, 2.448e-02, 3.738e-03, 1.572e-01, -1.440e-01, 7.550e-02, -1.769e-02, 6.346e-02, 5.747e-02, 9.293e-03, -1.939e-01, 8.411e-03, -2.033e-01, -1.109e-01, -1.597e-01));
	r += mul(s1_8, M4(1.227e-02, 1.120e-01, 9.656e-02, 1.212e-02, 4.532e-02, -1.865e-02, 2.360e-02, -2.847e-02, -1.250e-01, -1.511e-02, -4.564e-02, -2.920e-02, -3.807e-02, -2.316e-02, 2.247e-02, 4.428e-02));
	r += mul(s2_0, M4(-1.919e-03, -4.392e-03, -1.503e-01, 2.610e-01, 3.634e-02, 1.206e-02, 3.478e-02, -7.205e-02, 4.359e-02, 5.512e-03, -2.062e-02, -7.692e-02, -5.576e-03, -1.764e-02, -8.326e-02, 1.027e-01));
	r += mul(s2_1, M4(4.291e-02, -1.704e-02, 3.850e-01, -2.389e-03, 1.603e-02, 1.502e-02, -6.005e-04, -1.089e-01, 2.820e-02, -1.144e-03, -1.296e-02, 3.798e-02, 1.740e-02, -4.183e-02, 4.017e-02, 1.070e-01));
	r += mul(s2_2, M4(-1.513e-02, -7.006e-02, -6.258e-02, -4.526e-02, 2.048e-02, 6.189e-02, -8.497e-03, 5.349e-02, 1.713e-02, -7.838e-02, -9.167e-02, 1.616e-01, 1.160e-02, -2.925e-03, 6.162e-03, 1.576e-02));
	r += mul(s2_3, M4(1.732e-02, -7.628e-03, -3.389e-01, 9.102e-02, -1.819e-02, 3.728e-02, 4.961e-02, 7.595e-02, 9.210e-03, -2.414e-02, -1.018e-01, -2.461e-02, -2.735e-02, -1.492e-01, -9.396e-02, -1.685e-01));
	r += mul(s2_4, M4(-3.447e-01, -1.770e-01, 3.567e-01, 3.690e-02, -4.678e-02, 1.335e-01, 9.902e-02, -4.134e-02, -1.305e-02, -2.474e-02, 5.640e-02, -4.424e-01, -2.472e-02, -5.142e-02, -1.626e-01, 7.690e-02));
	r += mul(s2_5, M4(9.079e-02, -2.009e-01, -1.323e-01, -3.918e-02, 9.400e-03, 8.146e-02, 5.737e-02, -1.784e-02, -1.499e-01, -5.093e-02, -1.098e-01, 3.289e-02, 1.768e-02, 1.473e-02, 6.505e-02, 3.706e-02));
	r += mul(s2_6, M4(3.560e-02, 5.268e-02, -1.088e-01, 2.118e-02, 2.692e-02, 1.300e-02, 3.629e-02, -1.314e-01, -3.040e-03, -2.379e-02, 4.084e-02, 2.610e-02, -5.023e-02, -4.076e-03, 8.663e-02, 5.673e-02));
	r += mul(s2_7, M4(6.639e-02, -1.538e-01, 1.271e-03, 9.794e-02, 2.727e-02, -4.575e-03, 1.234e-02, 3.835e-03, -1.786e-02, -2.353e-02, -8.215e-06, 3.503e-02, 1.446e-02, -8.232e-02, -9.569e-02, -2.136e-02));
	r += mul(s2_8, M4(-6.274e-02, 3.597e-02, -1.374e-02, 1.240e-01, -4.918e-03, 9.546e-02, 2.940e-02, 3.907e-02, -3.768e-02, -3.928e-04, -2.817e-02, -2.097e-03, -1.098e-01, -6.711e-02, -1.060e-02, -3.996e-02));
	r += mul(s3_0, M4(-8.705e-04, 6.913e-03, -8.508e-02, 9.533e-02, -5.128e-02, 1.287e-01, -1.359e-01, -1.808e-01, 3.749e-02, -5.344e-02, -1.595e-01, -1.543e-01, 3.085e-02, 5.201e-02, 3.952e-02, -3.127e-02));
	r += mul(s3_1, M4(4.285e-02, 1.749e-02, 4.436e-02, 1.969e-01, 7.142e-02, 4.295e-01, 2.308e-01, -2.510e-01, 6.257e-02, -1.732e-01, 8.754e-02, -1.097e-01, -4.325e-03, -7.495e-03, -3.973e-02, 5.667e-03));
	r += mul(s3_2, M4(3.658e-02, 5.831e-03, 5.057e-02, -4.212e-02, -3.096e-01, 1.765e-01, 5.637e-02, 2.513e-01, 2.164e-01, -5.145e-02, -1.441e-02, 1.741e-02, 1.152e-02, -3.634e-03, -5.337e-02, 4.853e-03));
	r += mul(s3_3, M4(-2.759e-02, -1.018e-01, -2.492e-01, -1.179e-02, 2.017e-02, 3.613e-01, 4.407e-01, 2.802e-01, 2.645e-02, -3.572e-02, -4.548e-02, 6.994e-02, -1.924e-02, -6.029e-02, -4.268e-02, -3.740e-01));
	r += mul(s3_4, M4(-2.998e-02, -1.127e-01, 4.528e-02, -2.201e-03, -1.362e-01, -1.173e-02, 2.897e-01, 1.886e-01, 4.796e-02, -9.274e-03, -4.043e-02, -1.611e-01, 1.040e-01, 1.789e-01, 7.764e-02, 5.576e-02));
	r += mul(s3_5, M4(2.363e-02, 9.824e-02, 6.683e-02, 4.886e-02, 1.781e-01, -2.578e-01, -2.830e-01, -2.291e-01, 2.046e-01, -7.397e-02, -9.421e-03, -1.329e-01, 4.403e-02, -5.740e-02, -8.843e-02, -1.077e-01));
	r += mul(s3_6, M4(-9.686e-03, -6.426e-02, -8.451e-02, -1.543e-02, 4.212e-02, -8.461e-02, -6.925e-02, 1.326e-01, -2.320e-02, 1.063e-02, 5.104e-03, 2.349e-02, -1.832e-02, 1.542e-01, 2.940e-01, 9.564e-02));
	r += mul(s3_7, M4(-4.924e-02, 2.808e-02, 6.840e-02, -2.073e-02, 1.797e-01, -1.848e-02, 1.170e-01, -3.062e-01, 2.053e-02, -2.797e-03, -1.919e-02, -8.586e-02, 6.958e-02, 2.482e-01, 1.206e-01, -2.592e-01));
	r += mul(s3_8, M4(-1.581e-03, 1.504e-02, -6.646e-03, -2.199e-02, -2.461e-01, 2.447e-01, 2.928e-02, 6.105e-03, 3.845e-02, -8.580e-03, 2.356e-02, -3.423e-02, -5.714e-02, -1.385e-01, -1.413e-01, -1.655e-01));
	r += V4(4.493e-03, 9.879e-03, 4.742e-03, 7.609e-03);
	return r;
}

V4 f1(V4 s0_0, V4 s0_1, V4 s0_2, V4 s0_3, V4 s0_4, V4 s0_5, V4 s0_6, V4 s0_7, V4 s0_8, V4 s1_0, V4 s1_1, V4 s1_2, V4 s1_3, V4 s1_4, V4 s1_5, V4 s1_6, V4 s1_7, V4 s1_8, V4 s2_0, V4 s2_1, V4 s2_2, V4 s2_3, V4 s2_4, V4 s2_5, V4 s2_6, V4 s2_7, V4 s2_8, V4 s3_0, V4 s3_1, V4 s3_2, V4 s3_3, V4 s3_4, V4 s3_5, V4 s3_6, V4 s3_7, V4 s3_8) {
	V4 r = 0.0;
	r += mul(s0_0, M4(-7.606e-03, -1.450e-01, 7.048e-02, -5.560e-02, -2.107e-02, -8.767e-02, 4.197e-02, -3.903e-02, 2.785e-02, 4.231e-02, -8.629e-02, 7.399e-02, -4.145e-02, 2.668e-02, 4.936e-03, 2.811e-02));
	r += mul(s0_1, M4(-2.178e-02, -9.573e-02, 4.466e-02, -4.596e-02, 1.264e-01, -1.470e-02, -2.223e-02, -1.171e-01, 9.840e-02, 3.306e-02, -3.467e-02, 3.803e-02, -5.662e-02, 4.639e-03, -4.650e-02, -6.032e-02));
	r += mul(s0_2, M4(-2.858e-02, -5.296e-02, 3.520e-02, 8.093e-03, -5.357e-02, -3.564e-02, 1.554e-02, 1.925e-02, -1.468e-02, 6.853e-02, 5.027e-02, 2.541e-02, 6.782e-02, 8.630e-02, -1.517e-02, 7.121e-02));
	r += mul(s0_3, M4(3.350e-02, 7.664e-02, 1.083e-01, 4.846e-02, 1.295e-02, 2.439e-02, 6.116e-02, -6.071e-02, 6.696e-02, -6.066e-02, -1.552e-01, 1.984e-02, -1.023e-01, -1.433e-02, 2.393e-04, -3.211e-02));
	r += mul(s0_4, M4(-8.745e-02, -1.353e-01, -9.550e-02, -5.556e-02, 2.083e-01, -6.727e-02, 8.289e-02, 4.910e-01, -7.763e-02, 2.153e-01, 4.773e-01, -1.019e-01, -2.608e-01, -2.339e-01, -1.347e-01, 3.045e-02));
	r += mul(s0_5, M4(-4.816e-03, -5.705e-02, 5.751e-02, 6.914e-02, -2.323e-03, 1.954e-02, -6.234e-02, 2.904e-02, -1.618e-02, -5.947e-02, 8.672e-02, -9.847e-02, -1.798e-01, -3.539e-01, -1.188e-01, -1.909e-01));
	r += mul(s0_6, M4(-7.460e-02, -4.881e-02, 9.756e-02, 1.474e-02, -6.241e-02, -1.905e-02, 4.644e-02, 2.807e-04, 4.447e-02, 5.130e-02, -1.164e-01, -1.247e-03, -6.590e-02, -2.624e-02, -5.928e-02, -3.539e-02));
	r += mul(s0_7, M4(1.638e-01, 5.812e-02, -1.803e-01, -7.788e-02, -1.016e-01, -4.893e-02, -5.868e-02, -3.538e-03, -2.306e-01, -1.062e-01, 1.456e-01, 1.246e-01, -2.549e-01, 4.943e-02, 7.763e-02, 4.620e-02));
	r += mul(s0_8, M4(-3.654e-02, -7.453e-02, 1.955e-02, 4.617e-02, 4.147e-02, -1.313e-02, -4.974e-03, -3.849e-02, -6.676e-02, -2.096e-02, 2.696e-02, 4.776e-02, 2.142e-01, 3.247e-02, -5.714e-03, -8.951e-02));
	r += mul(s1_0, M4(-7.790e-02, -2.760e-01, 1.016e-01, -1.447e-01, -6.912e-02, -9.298e-02, 1.287e-02, -1.297e-02, -1.509e-02, 7.726e-02, -4.248e-02, 3.258e-02, 2.005e-02, -3.405e-03, -7.025e-03, 1.306e-02));
	r += mul(s1_1, M4(-3.396e-02, 2.075e-01, -3.389e-01, -1.892e-01, 7.255e-02, 1.213e-01, -1.733e-01, -1.080e-01, 5.638e-02, 1.893e-01, -1.445e-02, 1.323e-01, 6.380e-02, -1.103e-02, 6.004e-03, 3.340e-02));
	r += mul(s1_2, M4(9.550e-02, -7.969e-02, 1.467e-01, -1.510e-01, -6.064e-02, -1.011e-02, 9.627e-02, 5.701e-02, -1.502e-02, 5.514e-02, 1.194e-01, -8.703e-02, 1.962e-02, -2.335e-02, 1.273e-01, 3.821e-02));
	r += mul(s1_3, M4(5.118e-02, -4.244e-02, 3.218e-02, 2.105e-01, 2.683e-03, 1.639e-01, -7.032e-02, -6.492e-03, -6.695e-02, -1.580e-01, -3.038e-02, -1.280e-01, 5.194e-02, -4.606e-02, 7.701e-02, 4.344e-02));
	r += mul(s1_4, M4(-2.659e-01, -2.845e-01, -6.540e-02, 4.223e-02, -9.556e-02, 6.592e-01, -3.941e-01, 8.342e-01, 4.311e-01, -4.670e-01, 7.613e-01, 1.446e-02, -1.768e-01, 9.708e-02, -4.275e-02, -1.575e-01));
	r += mul(s1_5, M4(8.871e-02, -1.971e-01, 5.135e-02, 8.891e-02, -3.116e-01, 4.480e-02, 3.692e-02, 8.906e-02, 2.387e-01, -1.665e-01, 1.100e-01, -2.411e-01, -3.362e-01, 3.610e-03, -3.060e-02, 5.738e-02));
	r += mul(s1_6, M4(-8.271e-02, -1.283e-02, 5.737e-02, 2.650e-03, -3.927e-02, -7.014e-03, -8.666e-04, 6.659e-02, 3.380e-02, 7.843e-02, -5.220e-02, -4.679e-02, -5.453e-03, 1.609e-02, -4.788e-02, 2.133e-02));
	r += mul(s1_7, M4(2.159e-01, -8.350e-02, -1.979e-01, -4.520e-02, -1.429e-01, 4.874e-02, -9.640e-02, -6.331e-02, 1.226e-01, 1.200e-01, 2.666e-01, 3.174e-01, -2.204e-01, 1.731e-02, 3.981e-02, 5.188e-02));
	r += mul(s1_8, M4(-1.194e-01, -9.985e-02, 7.560e-02, 1.145e-01, -3.150e-04, 6.180e-02, -4.255e-02, -4.634e-02, -7.316e-02, 4.107e-02, 1.685e-02, -2.061e-03, 1.040e-01, 1.853e-02, -4.165e-02, -9.763e-02));
	r += mul(s2_0, M4(-1.972e-02, -1.625e-01, -3.716e-02, -6.495e-02, 3.466e-02, -3.497e-02, 4.673e-02, -1.410e-02, 1.877e-02, -7.723e-02, 2.751e-02, 1.365e-02, -8.140e-03, -1.770e-02, 1.922e-02, -1.498e-02));
	r += mul(s2_1, M4(-1.786e-02, -1.179e-01, 1.953e-01, 1.006e-01, 2.893e-02, 6.931e-03, -4.640e-03, -2.826e-02, 9.737e-02, -8.263e-02, 1.216e-01, -1.508e-01, -2.827e-03, -2.454e-02, -3.020e-02, -2.437e-02));
	r += mul(s2_2, M4(1.134e-02, -1.006e-02, 1.179e-02, 3.855e-02, 7.075e-02, -2.106e-02, 9.123e-02, -8.254e-02, 2.474e-02, 1.142e-02, -9.821e-02, 6.447e-05, -1.998e-02, -2.427e-02, -1.350e-02, 2.790e-02));
	r += mul(s2_3, M4(2.106e-01, 1.613e-01, -1.067e-01, -2.487e-02, -5.780e-02, -4.198e-03, -8.941e-02, -9.418e-03, 6.684e-02, 1.602e-02, -3.390e-02, 3.211e-02, -5.629e-02, 9.606e-02, 5.797e-02, -5.583e-03));
	r += mul(s2_4, M4(-1.209e-01, 5.758e-01, 1.261e-03, 1.741e-01, -2.419e-01, -1.311e-01, 5.495e-02, 1.059e-01, 1.174e-01, 1.139e-01, 7.558e-02, 3.146e-02, 3.048e-01, 1.029e-01, -4.014e-02, 5.124e-02));
	r += mul(s2_5, M4(2.601e-01, 1.167e-01, -1.328e-01, 6.108e-02, -2.140e-01, -1.833e-02, 7.347e-02, -1.673e-02, 8.485e-02, 7.450e-02, -4.355e-02, -2.229e-01, 2.606e-02, 5.274e-02, -3.851e-03, -4.787e-03));
	r += mul(s2_6, M4(-3.845e-02, 1.459e-02, -9.795e-04, -3.515e-03, 9.791e-02, -4.729e-03, 4.591e-02, 2.429e-02, -4.431e-02, 5.498e-04, -4.050e-02, 1.392e-02, -2.258e-01, -6.294e-02, -4.323e-02, -1.549e-02));
	r += mul(s2_7, M4(-1.184e-01, -2.039e-01, -1.069e-02, -2.209e-02, 1.933e-01, 4.867e-02, -1.127e-01, -1.196e-01, -9.386e-02, 2.226e-03, 1.569e-02, -4.063e-03, -5.044e-02, -1.930e-01, 7.287e-02, 1.237e-01));
	r += mul(s2_8, M4(-8.680e-02, -9.201e-02, 2.773e-02, -4.725e-02, 4.422e-02, -1.834e-02, 4.184e-02, 1.488e-02, -3.397e-02, 1.727e-04, 2.558e-02, 5.452e-02, -2.750e-02, 4.529e-02, -3.442e-02, 7.563e-02));
	r += mul(s3_0, M4(-7.896e-03, -1.086e-01, 5.701e-02, -3.965e-02, 8.469e-02, 1.352e-01, -6.528e-02, -1.477e-02, 2.109e-02, -8.591e-02, -4.694e-03, -3.514e-03, 5.960e-02, -4.514e-02, 1.488e-02, -3.246e-02));
	r += mul(s3_1, M4(5.433e-02, -5.217e-02, -1.891e-02, -3.308e-02, -1.775e-01, -3.605e-02, 1.126e-01, -2.166e-01, 4.270e-02, -4.366e-01, 1.504e-01, -2.861e-01, -1.690e-03, 1.295e-02, -9.738e-04, -6.364e-02));
	r += mul(s3_2, M4(2.461e-02, 3.878e-02, 2.036e-02, 5.172e-02, 1.882e-02, 1.194e-01, 2.614e-01, 4.576e-02, 1.069e-01, -1.662e-01, -9.787e-02, -4.312e-01, 6.190e-02, -4.314e-03, 8.764e-04, -1.972e-02));
	r += mul(s3_3, M4(1.434e-02, 1.003e-03, 1.437e-01, -4.020e-02, 1.354e-01, -1.095e-02, -4.405e-01, -2.827e-02, 4.254e-02, -1.466e-02, -3.134e-02, -3.096e-03, -8.806e-02, 5.043e-02, 4.063e-03, 5.549e-02));
	r += mul(s3_4, M4(-1.294e-01, 2.964e-02, 5.146e-02, 6.517e-02, -6.495e-01, -5.152e-02, 5.726e-01, 3.115e-01, 1.993e-01, -2.266e-01, -9.610e-02, 2.153e-01, 1.816e-02, -1.818e-01, 1.234e-01, -3.177e-01));
	r += mul(s3_5, M4(7.489e-02, -3.528e-02, 6.062e-03, -3.331e-02, 2.551e-01, 2.377e-01, -1.997e-01, -4.533e-02, -3.031e-01, -8.469e-02, 1.362e-01, 2.675e-01, -1.314e-01, -6.837e-03, -1.181e-01, -1.001e-02));
	r += mul(s3_6, M4(-6.568e-02, -2.240e-02, 4.283e-02, 1.558e-02, 6.800e-02, -5.739e-03, 6.958e-02, -2.239e-02, 2.790e-02, 5.060e-03, -7.806e-03, 2.765e-03, -1.731e-01, 1.712e-01, -3.499e-01, 6.484e-02));
	r += mul(s3_7, M4(1.238e-01, -8.504e-02, -4.829e-02, -1.088e-02, 7.962e-02, -1.782e-02, -9.934e-02, -5.628e-02, -4.412e-02, 4.612e-02, 1.926e-03, 7.206e-02, -7.886e-02, 5.169e-02, 2.761e-01, 4.394e-01));
	r += mul(s3_8, M4(-6.514e-02, -7.796e-02, -9.301e-03, 4.148e-02, 1.350e-01, -7.848e-02, 2.949e-02, -1.101e-01, 4.236e-02, 3.716e-02, 4.291e-02, 7.020e-02, 1.850e-01, -4.661e-03, -2.221e-01, -1.237e-01));
	r += V4(1.407e-02, -1.303e-02, 6.423e-03, -6.361e-03);
	return r;
}

void Pass8(uint2 blockStart, uint3 tid) {
	float2 pt = float2(GetInputPt());
	uint2 gxy = Rmp8x8(tid.x) + blockStart;
	uint2 size = GetInputSize();
	if (gxy.x >= size.x || gxy.y >= size.y) {
		return;
	}
	float2 pos = (gxy + 0.5) * pt;

	V4 s0_0 = l0(-1.0, -1.0);
	V4 s0_1 = l0(0.0, -1.0);
	V4 s0_2 = l0(1.0, -1.0);
	V4 s0_3 = l0(-1.0, 0.0);
	V4 s0_4 = l0(0.0, 0.0);
	V4 s0_5 = l0(1.0, 0.0);
	V4 s0_6 = l0(-1.0, 1.0);
	V4 s0_7 = l0(0.0, 1.0);
	V4 s0_8 = l0(1.0, 1.0);
	V4 s1_0 = -max(-s0_0, 0.0);
	V4 s1_1 = -max(-s0_1, 0.0);
	V4 s1_2 = -max(-s0_2, 0.0);
	V4 s1_3 = -max(-s0_3, 0.0);
	V4 s1_4 = -max(-s0_4, 0.0);
	V4 s1_5 = -max(-s0_5, 0.0);
	V4 s1_6 = -max(-s0_6, 0.0);
	V4 s1_7 = -max(-s0_7, 0.0);
	V4 s1_8 = -max(-s0_8, 0.0);
	s0_0 = max(s0_0, 0.0);
	s0_1 = max(s0_1, 0.0);
	s0_2 = max(s0_2, 0.0);
	s0_3 = max(s0_3, 0.0);
	s0_4 = max(s0_4, 0.0);
	s0_5 = max(s0_5, 0.0);
	s0_6 = max(s0_6, 0.0);
	s0_7 = max(s0_7, 0.0);
	s0_8 = max(s0_8, 0.0);

	V4 s2_0 = l1(-1.0, -1.0);
	V4 s2_1 = l1(0.0, -1.0);
	V4 s2_2 = l1(1.0, -1.0);
	V4 s2_3 = l1(-1.0, 0.0);
	V4 s2_4 = l1(0.0, 0.0);
	V4 s2_5 = l1(1.0, 0.0);
	V4 s2_6 = l1(-1.0, 1.0);
	V4 s2_7 = l1(0.0, 1.0);
	V4 s2_8 = l1(1.0, 1.0);
	V4 s3_0 = -max(-s2_0, 0.0);
	V4 s3_1 = -max(-s2_1, 0.0);
	V4 s3_2 = -max(-s2_2, 0.0);
	V4 s3_3 = -max(-s2_3, 0.0);
	V4 s3_4 = -max(-s2_4, 0.0);
	V4 s3_5 = -max(-s2_5, 0.0);
	V4 s3_6 = -max(-s2_6, 0.0);
	V4 s3_7 = -max(-s2_7, 0.0);
	V4 s3_8 = -max(-s2_8, 0.0);
	s2_0 = max(s2_0, 0.0);
	s2_1 = max(s2_1, 0.0);
	s2_2 = max(s2_2, 0.0);
	s2_3 = max(s2_3, 0.0);
	s2_4 = max(s2_4, 0.0);
	s2_5 = max(s2_5, 0.0);
	s2_6 = max(s2_6, 0.0);
	s2_7 = max(s2_7, 0.0);
	s2_8 = max(s2_8, 0.0);

	t2[gxy] = f0(s0_0, s0_1, s0_2, s0_3, s0_4, s0_5, s0_6, s0_7, s0_8, s1_0, s1_1, s1_2, s1_3, s1_4, s1_5, s1_6, s1_7, s1_8, s2_0, s2_1, s2_2, s2_3, s2_4, s2_5, s2_6, s2_7, s2_8, s3_0, s3_1, s3_2, s3_3, s3_4, s3_5, s3_6, s3_7, s3_8);
	t3[gxy] = f1(s0_0, s0_1, s0_2, s0_3, s0_4, s0_5, s0_6, s0_7, s0_8, s1_0, s1_1, s1_2, s1_3, s1_4, s1_5, s1_6, s1_7, s1_8, s2_0, s2_1, s2_2, s2_3, s2_4, s2_5, s2_6, s2_7, s2_8, s3_0, s3_1, s3_2, s3_3, s3_4, s3_5, s3_6, s3_7, s3_8);
}

//!PASS 9
//!DESC conv8
//!BLOCK_SIZE 8
//!NUM_THREADS 64
//!IN t2, t3
//!OUT t0, t1

#define l0(x, y) V4(O(t2, float2(x, y)))
#define l1(x, y) V4(O(t3, float2(x, y)))

V4 f0(V4 s0_0, V4 s0_1, V4 s0_2, V4 s0_3, V4 s0_4, V4 s0_5, V4 s0_6, V4 s0_7, V4 s0_8, V4 s1_0, V4 s1_1, V4 s1_2, V4 s1_3, V4 s1_4, V4 s1_5, V4 s1_6, V4 s1_7, V4 s1_8, V4 s2_0, V4 s2_1, V4 s2_2, V4 s2_3, V4 s2_4, V4 s2_5, V4 s2_6, V4 s2_7, V4 s2_8, V4 s3_0, V4 s3_1, V4 s3_2, V4 s3_3, V4 s3_4, V4 s3_5, V4 s3_6, V4 s3_7, V4 s3_8) {
	V4 r = 0.0;
	r += mul(s0_0, M4(8.716e-02, -2.891e-02, -2.183e-01, -7.676e-03, -1.552e-02, 1.494e-02, 2.825e-02, -3.651e-02, 4.604e-03, 5.645e-03, 8.134e-03, -1.298e-02, 2.144e-02, 1.195e-03, 1.450e-02, 1.619e-02));
	r += mul(s0_1, M4(-3.389e-02, -2.900e-01, -3.087e-01, -5.633e-02, 2.753e-02, 2.198e-02, -6.998e-02, -6.210e-02, 2.079e-02, 2.083e-02, 4.432e-02, -1.027e-02, 3.827e-02, 8.856e-04, 4.809e-03, -3.012e-02));
	r += mul(s0_2, M4(8.829e-03, -1.200e-02, -2.731e-02, 2.589e-02, -4.841e-03, -1.333e-01, -3.516e-02, -2.656e-02, -1.726e-03, -4.446e-03, -8.521e-02, -2.038e-02, 5.978e-02, 9.301e-02, 1.080e-02, 5.518e-02));
	r += mul(s0_3, M4(-8.477e-02, 6.865e-02, 1.804e-01, 1.239e-01, 2.939e-02, -5.360e-02, -1.714e-01, -4.654e-02, 5.288e-03, -1.770e-02, 1.804e-02, -1.039e-02, -1.376e-02, -4.660e-02, -1.135e-01, -8.134e-02));
	r += mul(s0_4, M4(4.002e-02, 2.814e-01, 3.318e-01, -2.789e-01, -1.151e-02, -6.062e-02, 1.340e-01, -2.157e-01, -1.594e-02, 3.660e-02, -2.938e-02, 2.064e-01, 5.313e-02, 9.726e-02, -1.831e-01, 1.773e-01));
	r += mul(s0_5, M4(1.286e-02, 5.915e-02, 9.298e-02, 7.291e-02, 2.413e-02, 1.863e-01, 4.568e-02, 1.337e-01, 1.420e-02, -1.661e-02, 8.140e-02, 2.640e-02, -4.800e-02, -3.460e-01, -3.232e-01, 8.426e-02));
	r += mul(s0_6, M4(-1.923e-02, -7.129e-02, 1.256e-01, 1.482e-02, 2.752e-02, 6.057e-02, -2.595e-02, 1.176e-02, -5.789e-03, 1.235e-02, 2.846e-02, -3.297e-02, 2.591e-02, 9.832e-03, -1.272e-02, -2.601e-02));
	r += mul(s0_7, M4(3.527e-02, 3.830e-01, 2.712e-01, 1.038e-01, 4.921e-02, -1.047e-01, -1.821e-01, 2.358e-02, -2.067e-02, 5.368e-02, 1.773e-01, -1.114e-02, -6.454e-02, -1.991e-02, -9.674e-02, -1.353e-01));
	r += mul(s0_8, M4(2.063e-02, -5.830e-02, -7.769e-03, -2.469e-02, -2.694e-03, -5.945e-02, 7.213e-02, 3.814e-02, -1.769e-02, 9.680e-02, -5.531e-03, -8.608e-02, 5.463e-02, 1.511e-01, 2.052e-01, 5.571e-02));
	r += mul(s1_0, M4(5.597e-02, -1.255e-01, -1.365e-01, -8.874e-02, -2.838e-02, 8.409e-03, 7.349e-02, 5.397e-03, 1.360e-02, -1.040e-02, -2.247e-02, 1.490e-02, -1.303e-02, 1.433e-02, 1.603e-02, 1.108e-02));
	r += mul(s1_1, M4(-6.497e-02, -1.599e-02, 2.908e-02, -2.089e-01, 5.060e-02, -7.639e-02, -1.720e-01, -1.082e-01, 1.348e-02, 2.165e-02, -1.413e-02, 9.410e-02, 4.757e-03, -1.502e-02, -9.644e-02, 2.782e-02));
	r += mul(s1_2, M4(1.597e-02, -7.105e-02, -3.690e-02, 3.880e-02, 2.393e-04, -3.600e-02, 7.562e-02, -9.162e-02, -4.744e-02, 5.457e-02, -5.874e-02, 2.780e-02, -9.128e-03, -4.318e-02, -6.162e-02, 9.923e-02));
	r += mul(s1_3, M4(-9.415e-02, 8.443e-02, 1.850e-01, 2.272e-01, 6.203e-02, -6.275e-02, -1.687e-01, -1.142e-01, -4.309e-02, 4.878e-03, 2.693e-02, 3.195e-02, 1.393e-02, -8.775e-03, -3.935e-02, -2.571e-02));
	r += mul(s1_4, M4(-8.029e-02, 9.122e-01, 1.307e-01, -3.950e-01, -2.208e-01, 1.042e-01, 1.690e-01, -9.825e-02, -5.692e-02, 7.496e-02, -1.333e-01, 4.595e-01, 8.206e-02, 5.508e-02, 1.307e-01, -1.802e-01));
	r += mul(s1_5, M4(4.041e-02, 7.446e-02, 1.326e-02, 4.840e-02, -3.398e-03, 8.501e-02, -1.043e-02, 2.989e-02, 9.050e-02, -6.651e-02, 3.538e-03, -2.544e-01, -1.664e-02, -1.277e-02, 7.405e-03, 1.360e-01));
	r += mul(s1_6, M4(4.049e-03, 2.225e-02, -1.467e-02, 4.199e-02, -1.629e-02, -2.449e-02, 9.364e-03, 3.742e-02, 1.461e-02, 1.914e-02, -1.475e-02, 2.694e-02, 1.939e-02, 1.508e-02, -2.493e-02, 2.145e-02));
	r += mul(s1_7, M4(-1.139e-02, -2.558e-02, 2.030e-02, -1.332e-02, 9.789e-02, -1.343e-01, -1.585e-01, -2.415e-02, -3.155e-02, 5.701e-02, 9.033e-02, 1.058e-02, -6.113e-02, 3.790e-02, 5.825e-02, 1.036e-01));
	r += mul(s1_8, M4(2.258e-03, 2.830e-04, 2.544e-03, 4.909e-02, -5.359e-02, -2.778e-02, 4.536e-02, 6.162e-03, -3.971e-03, 9.985e-02, -2.324e-02, -2.912e-02, 1.898e-02, 3.549e-02, 1.523e-02, -5.460e-02));
	r += mul(s2_0, M4(-2.683e-03, -2.313e-02, -9.765e-02, 6.443e-02, -1.147e-02, -4.148e-02, -6.236e-02, 3.064e-02, 1.535e-03, -4.514e-03, -1.590e-02, -6.948e-03, 2.944e-02, -1.097e-02, 4.388e-02, -6.514e-02));
	r += mul(s2_1, M4(-3.525e-02, 2.655e-02, 1.220e-01, 1.464e-02, 7.646e-02, -6.272e-02, -1.444e-01, -5.726e-02, -1.391e-02, -1.336e-02, -1.038e-01, 4.556e-02, 2.769e-02, 2.400e-02, 6.146e-02, -1.442e-01));
	r += mul(s2_2, M4(9.590e-03, -1.095e-02, -2.527e-02, -2.780e-02, -6.799e-03, -9.882e-02, -4.968e-02, -1.557e-02, -6.521e-03, 2.517e-02, 6.286e-03, 4.018e-02, 1.262e-02, 9.613e-03, 4.015e-02, -4.083e-02));
	r += mul(s2_3, M4(-3.107e-02, 2.050e-02, 2.190e-01, -5.231e-02, -1.644e-02, 1.728e-02, -9.647e-02, 2.000e-02, 6.885e-03, -3.772e-02, -1.800e-02, -1.167e-02, 3.840e-02, -8.962e-02, -1.389e-01, -9.490e-02));
	r += mul(s2_4, M4(5.263e-02, -1.751e-02, -9.476e-02, -5.722e-02, 1.043e+00, 2.111e-01, 1.155e-01, 2.278e-01, 2.259e-02, -1.039e-02, 7.633e-02, -5.180e-02, 2.861e-01, 2.293e-01, 2.457e-01, -1.031e+00));
	r += mul(s2_5, M4(-1.717e-02, 3.437e-02, 1.829e-02, 6.573e-02, 4.646e-02, 4.430e-01, 1.042e-01, -6.801e-02, 1.584e-02, 4.456e-02, 5.250e-02, -9.501e-02, -1.277e-02, -3.398e-02, 1.408e-02, 3.100e-02));
	r += mul(s2_6, M4(1.276e-02, -2.000e-02, -1.067e-01, 1.639e-02, -6.351e-03, -6.506e-04, 1.168e-03, -8.173e-03, -7.451e-03, 1.989e-02, 1.142e-02, -8.287e-03, 4.566e-02, 2.864e-02, -2.859e-02, 4.019e-02));
	r += mul(s2_7, M4(-3.441e-02, -1.582e-02, 3.287e-02, 7.107e-02, -4.680e-02, -8.453e-02, -8.472e-02, -1.265e-03, -9.706e-03, 4.809e-02, -3.750e-02, 9.239e-02, -3.768e-02, -1.209e-01, -1.171e-01, 2.288e-01));
	r += mul(s2_8, M4(-1.296e-03, 1.673e-02, -1.629e-02, -4.858e-02, 1.224e-02, -1.321e-01, -4.292e-02, 1.164e-01, 2.477e-02, 7.985e-02, -7.381e-02, 4.411e-02, 2.398e-02, -1.543e-02, 3.089e-02, -2.552e-02));
	r += mul(s3_0, M4(1.648e-02, 3.567e-03, -1.052e-01, 4.280e-02, -6.192e-04, -1.966e-02, -4.740e-02, -1.942e-03, -5.032e-03, 1.183e-02, -1.079e-02, 3.852e-03, 2.288e-02, 3.801e-03, 3.902e-02, -3.914e-02));
	r += mul(s3_1, M4(-5.489e-02, -1.027e-01, -1.111e-01, 1.519e-01, -1.327e-02, 1.596e-03, -1.675e-01, 5.952e-02, -6.748e-02, 2.754e-02, -5.609e-02, 6.575e-02, 2.188e-02, 9.031e-03, 4.638e-02, -1.094e-01));
	r += mul(s3_2, M4(3.213e-03, 4.675e-02, -2.631e-02, -1.086e-02, -1.903e-02, -1.028e-01, -1.084e-01, 2.649e-02, 9.822e-03, 7.725e-03, -1.691e-02, 3.222e-02, -9.035e-03, 2.980e-02, 5.749e-02, -3.044e-02));
	r += mul(s3_3, M4(-7.619e-02, -1.622e-03, 3.324e-01, 4.752e-02, -3.685e-02, -4.685e-02, -8.527e-02, 2.294e-02, -2.439e-02, -6.236e-03, -3.104e-02, 3.233e-02, 1.789e-02, -4.432e-02, -1.392e-01, -9.780e-02));
	r += mul(s3_4, M4(2.911e-01, 3.642e-01, 3.817e-01, -9.316e-02, 4.124e-02, -3.579e-02, 4.983e-02, 1.040e-01, 5.359e-02, -3.462e-01, 4.782e-02, -2.421e-01, 2.007e-02, -2.380e-01, -1.773e-01, -6.314e-01));
	r += mul(s3_5, M4(-3.313e-03, -1.201e-02, -1.415e-02, 8.734e-03, 3.021e-02, 9.567e-02, 2.296e-02, -6.178e-02, 5.850e-02, 6.168e-02, -6.368e-02, -5.051e-02, -2.251e-02, -3.667e-02, 3.398e-02, 2.872e-02));
	r += mul(s3_6, M4(4.334e-02, -4.642e-02, -2.431e-01, -3.343e-02, -2.479e-03, -5.827e-03, 3.528e-02, 3.433e-02, -4.470e-02, -2.127e-02, -7.138e-03, 3.796e-02, 1.379e-02, 4.208e-02, 4.114e-02, 2.813e-02));
	r += mul(s3_7, M4(-1.170e-02, -4.718e-02, 2.204e-02, 5.829e-02, -5.554e-03, -1.019e-01, -2.598e-01, -1.456e-01, 1.797e-02, 1.255e-01, -5.581e-02, 1.283e-01, -3.416e-02, -8.180e-02, -5.774e-02, 9.365e-02));
	r += mul(s3_8, M4(1.354e-02, 4.724e-02, 4.335e-02, 5.845e-02, -9.950e-03, -7.794e-02, -2.257e-02, 3.610e-03, 2.669e-02, -1.255e-01, -5.754e-02, 1.600e-01, -2.851e-03, 3.557e-02, 3.722e-02, 1.257e-02));
	r += V4(1.101e-03, 2.116e-04, -1.154e-03, -3.483e-03);
	return r;
}

V4 f1(V4 s0_0, V4 s0_1, V4 s0_2, V4 s0_3, V4 s0_4, V4 s0_5, V4 s0_6, V4 s0_7, V4 s0_8, V4 s1_0, V4 s1_1, V4 s1_2, V4 s1_3, V4 s1_4, V4 s1_5, V4 s1_6, V4 s1_7, V4 s1_8, V4 s2_0, V4 s2_1, V4 s2_2, V4 s2_3, V4 s2_4, V4 s2_5, V4 s2_6, V4 s2_7, V4 s2_8, V4 s3_0, V4 s3_1, V4 s3_2, V4 s3_3, V4 s3_4, V4 s3_5, V4 s3_6, V4 s3_7, V4 s3_8) {
	V4 r = 0.0;
	r += mul(s0_0, M4(-8.139e-03, 4.801e-02, 1.603e-02, 3.358e-02, 4.412e-02, -3.926e-03, 1.599e-02, -2.674e-02, 1.052e-02, 3.787e-03, -7.897e-03, 6.304e-03, -5.446e-03, 4.456e-03, 3.906e-03, -3.014e-02));
	r += mul(s0_1, M4(-4.183e-02, -4.484e-02, -1.794e-02, 8.394e-02, 9.001e-03, 8.132e-03, -1.436e-02, 6.112e-02, -3.553e-02, 1.347e-02, 1.129e-02, -1.392e-02, -5.328e-02, 4.777e-03, -2.372e-02, 1.061e-02));
	r += mul(s0_2, M4(-9.735e-02, 5.944e-02, 2.399e-02, -2.746e-02, -3.898e-02, 3.360e-03, -6.036e-03, -3.314e-02, 4.432e-02, -1.326e-02, -1.406e-02, 3.821e-02, -3.058e-02, -5.659e-03, 4.182e-04, -4.163e-02));
	r += mul(s0_3, M4(-1.753e-01, 8.851e-03, 9.107e-02, 6.816e-02, 5.333e-02, 1.918e-02, -3.936e-02, 1.615e-02, 5.222e-03, -9.198e-03, 2.073e-03, -2.037e-02, -3.624e-02, 5.469e-03, 3.329e-02, 7.935e-02));
	r += mul(s0_4, M4(3.188e-01, -3.351e-02, 3.946e-02, -1.936e-01, -8.892e-02, -2.977e-02, 1.599e-02, -8.213e-02, -2.080e-02, -4.108e-02, 7.681e-02, 5.185e-02, 3.339e-01, -1.861e-01, 8.615e-02, -4.358e-02));
	r += mul(s0_5, M4(-1.339e-01, 2.904e-02, -6.564e-02, 1.283e-01, -2.102e-01, -9.994e-02, 6.066e-02, 8.217e-02, 1.274e-01, 4.664e-02, 1.387e-02, -1.304e-01, -4.338e-01, 1.438e-01, -8.452e-02, 9.942e-02));
	r += mul(s0_6, M4(-3.172e-03, 1.855e-02, -1.299e-01, -5.566e-02, 1.342e-02, -3.773e-02, 1.164e-01, -4.885e-02, 2.672e-02, 2.120e-03, 6.741e-03, -1.942e-02, 1.131e-02, 1.268e-02, -6.915e-03, -3.804e-02));
	r += mul(s0_7, M4(-3.183e-02, 1.248e-01, 2.723e-01, 4.886e-02, -5.783e-02, -3.498e-02, -7.778e-02, 7.155e-02, -4.697e-02, -1.291e-02, 1.091e-02, -5.571e-02, 4.493e-02, 2.837e-03, 1.022e-01, -5.141e-02));
	r += mul(s0_8, M4(-6.313e-03, -4.400e-02, 5.050e-04, 2.227e-02, -9.350e-02, -4.613e-03, -4.296e-02, 1.727e-03, 6.421e-02, 5.700e-02, 7.157e-03, 6.188e-02, -2.251e-01, -8.961e-03, -4.093e-02, 9.974e-02));
	r += mul(s1_0, M4(-1.039e-01, 1.880e-02, 8.841e-03, 7.631e-02, -4.356e-03, 1.133e-03, 1.746e-02, -4.062e-02, -1.458e-02, -1.400e-02, -4.845e-03, 7.824e-03, 3.870e-02, -1.011e-03, -5.752e-03, -3.031e-02));
	r += mul(s1_1, M4(6.233e-02, -2.081e-02, 2.657e-02, 9.817e-02, -5.733e-02, 5.913e-02, -4.861e-03, 5.648e-02, 1.835e-02, -1.568e-02, 6.182e-03, -1.379e-02, 6.751e-03, 4.911e-03, -1.231e-02, 3.740e-02));
	r += mul(s1_2, M4(-4.699e-02, 8.618e-02, 1.229e-02, -6.548e-03, 2.591e-02, -9.380e-02, 4.808e-02, 1.493e-03, 5.835e-02, -2.621e-03, -2.251e-02, 2.527e-03, -8.374e-02, 4.826e-03, -2.984e-03, -1.785e-02));
	r += mul(s1_3, M4(-9.938e-03, -4.651e-02, 1.316e-01, -1.821e-01, -4.344e-02, 1.548e-02, -5.539e-02, 1.124e-01, 6.993e-03, -5.261e-03, 2.396e-02, 7.078e-03, -3.761e-02, 1.679e-02, 6.152e-02, -6.838e-04));
	r += mul(s1_4, M4(-1.082e-01, 1.483e-01, -1.165e-01, -6.575e-01, 3.764e-01, -5.165e-02, 2.034e-01, -3.174e-01, 2.801e-01, -2.852e-02, -1.561e-02, 4.623e-02, 8.767e-03, -6.216e-02, 7.259e-02, -4.773e-02));
	r += mul(s1_5, M4(-4.327e-02, -5.334e-02, -1.740e-02, 8.949e-02, 2.073e-01, -9.327e-01, -5.263e-02, 8.325e-03, 2.765e-01, 7.962e-01, 6.864e-02, -1.538e-01, -1.516e-01, 2.461e-02, -7.246e-03, 5.921e-02));
	r += mul(s1_6, M4(-8.185e-03, -3.844e-02, 7.961e-02, -9.410e-03, 4.108e-04, -2.167e-03, -1.127e-01, 2.967e-02, 1.753e-03, 4.788e-03, 4.251e-02, -1.486e-02, 2.875e-02, -1.012e-02, 3.946e-02, -3.900e-02));
	r += mul(s1_7, M4(-8.943e-03, 2.983e-02, -5.527e-02, -2.334e-02, -6.379e-02, 3.683e-02, -3.037e-01, 1.132e-01, 1.233e-02, 2.120e-02, 2.496e-01, -1.707e-01, -4.890e-03, 4.398e-02, -4.966e-02, 3.483e-02));
	r += mul(s1_8, M4(-4.941e-03, 7.157e-03, -1.099e-02, 4.138e-02, -7.410e-02, -5.163e-02, 3.074e-02, -3.082e-02, -2.063e-02, 2.558e-01, -1.401e-01, 1.954e-01, 1.225e-02, -6.256e-02, 2.581e-02, -3.332e-02));
	r += mul(s2_0, M4(3.635e-02, 5.231e-03, -4.170e-02, 4.580e-02, -4.653e-03, 9.252e-03, -2.538e-02, 5.636e-03, 5.214e-02, 6.077e-03, -1.398e-02, -2.888e-02, -4.214e-02, 1.758e-02, 2.678e-02, -2.664e-02));
	r += mul(s2_1, M4(-4.114e-02, 5.198e-02, 9.590e-03, -2.777e-02, -6.989e-02, 5.447e-03, -1.375e-02, 1.284e-01, -9.811e-04, 2.238e-02, 4.914e-03, 3.380e-02, 6.931e-02, -1.843e-02, 1.917e-02, 1.045e-02));
	r += mul(s2_2, M4(8.599e-02, -1.864e-02, -7.699e-03, 1.346e-02, 6.046e-03, 3.235e-02, 1.948e-02, -2.311e-03, -2.597e-02, 3.028e-02, 3.122e-02, -1.293e-02, -1.139e-03, 9.886e-03, 1.895e-02, 1.435e-02));
	r += mul(s2_3, M4(-9.374e-02, -4.919e-02, 9.379e-02, -7.869e-02, -1.614e-03, -1.447e-02, -1.151e-02, 1.634e-02, -4.178e-02, -4.215e-03, 1.515e-02, 3.309e-02, 1.458e-02, 4.229e-02, 1.160e-03, 3.808e-02));
	r += mul(s2_4, M4(-2.479e-02, 2.123e-03, -1.670e-02, 1.710e-01, 1.476e-01, 1.105e-01, 8.431e-03, -6.465e-01, 1.034e-01, -2.353e-02, -4.223e-02, -4.599e-02, 2.390e-01, -8.565e-02, 1.056e-01, -1.849e-02));
	r += mul(s2_5, M4(7.623e-02, 2.227e-02, 2.566e-03, -8.814e-02, -1.420e-01, -4.561e-02, -8.096e-03, 6.678e-02, 1.813e-01, -4.586e-02, -2.824e-03, 4.914e-03, -5.548e-02, 2.289e-02, -3.724e-02, -4.919e-02));
	r += mul(s2_6, M4(1.146e-02, -9.689e-03, -4.242e-02, 5.383e-02, 3.955e-03, -2.442e-02, 7.879e-02, -3.362e-02, 2.215e-02, 2.008e-03, 5.887e-03, -1.880e-02, -2.466e-02, -2.656e-02, 1.069e-01, -5.091e-02));
	r += mul(s2_7, M4(-1.438e-02, 1.372e-02, 4.616e-03, -6.651e-02, 1.724e-03, -2.181e-02, -1.028e-02, 1.685e-01, -1.914e-04, -5.789e-02, 1.803e-01, -4.568e-02, -2.648e-03, 9.449e-02, 1.811e-03, 1.118e-01));
	r += mul(s2_8, M4(5.457e-02, 7.597e-03, 3.242e-02, -1.486e-02, 8.487e-02, -4.658e-03, -5.511e-02, -2.655e-02, 1.510e-01, -1.640e-02, 2.092e-01, -2.047e-01, -3.228e-02, -5.188e-02, -3.577e-02, 6.335e-02));
	r += mul(s3_0, M4(2.751e-02, 1.164e-02, -7.354e-03, 1.738e-02, 5.841e-02, 2.209e-02, -2.322e-02, -1.156e-02, 6.615e-02, 1.279e-02, -4.472e-03, -9.096e-03, -1.528e-02, 1.383e-02, 1.389e-02, -3.084e-02));
	r += mul(s3_1, M4(-2.044e-01, 3.340e-03, -3.237e-04, -3.528e-02, -4.652e-02, -1.142e-02, 2.224e-02, 8.739e-02, 8.402e-02, -1.391e-02, -6.910e-03, 5.285e-02, 1.661e-02, 1.119e-02, 8.985e-03, 1.291e-02));
	r += mul(s3_2, M4(1.460e-01, -8.168e-02, 3.896e-02, -1.981e-02, -5.708e-02, 4.458e-02, 5.119e-03, -2.267e-02, -6.497e-02, 7.691e-02, -1.412e-02, -1.887e-03, 3.175e-02, 4.805e-02, 5.430e-03, 1.617e-02));
	r += mul(s3_3, M4(-6.320e-02, -3.050e-02, -9.449e-02, -8.528e-02, -3.759e-02, -7.222e-03, -4.294e-03, 6.067e-02, -5.506e-03, 9.794e-03, 3.820e-02, 4.139e-02, -5.172e-02, 6.190e-02, 3.339e-02, 6.331e-02));
	r += mul(s3_4, M4(-3.370e-01, 3.061e-01, 1.962e-01, 1.538e-01, 1.176e-01, -2.454e-02, 1.303e-02, -1.997e-01, 3.462e-01, 2.586e-02, -1.343e-01, -3.291e-01, -8.535e-02, -1.103e-01, -4.880e-02, 2.446e-01));
	r += mul(s3_5, M4(1.265e-01, -1.734e-01, 2.422e-02, -1.558e-01, -2.041e-02, 4.496e-02, -1.906e-02, 8.517e-02, -3.115e-01, 2.843e-01, 2.961e-02, 7.657e-03, -2.348e-03, 6.712e-02, -4.156e-02, -5.768e-02));
	r += mul(s3_6, M4(1.086e-02, -2.221e-03, 8.270e-02, 3.185e-02, -1.962e-02, -1.782e-03, -2.368e-02, -3.431e-02, -2.859e-02, -1.832e-02, -4.540e-02, 2.570e-02, -2.138e-03, -1.952e-02, 2.247e-04, -4.177e-02));
	r += mul(s3_7, M4(-1.425e-01, 6.336e-02, -1.040e-01, 5.089e-02, -3.597e-02, 1.705e-02, -2.995e-02, 1.966e-01, 1.487e-01, -6.668e-02, 6.159e-01, -2.875e-01, -1.333e-02, 2.252e-02, -1.610e-01, 4.135e-02));
	r += mul(s3_8, M4(-5.173e-02, -2.024e-02, 7.865e-02, 1.027e-02, 3.283e-02, 1.865e-02, 2.220e-02, -6.929e-02, 8.660e-03, 3.481e-02, -3.540e-03, 2.775e-02, -7.171e-02, -2.940e-02, 2.794e-02, 3.405e-02));
	r += V4(7.644e-03, -3.720e-03, -2.028e-03, -1.031e-03);
	return r;
}

void Pass9(uint2 blockStart, uint3 tid) {
	float2 pt = float2(GetInputPt());
	uint2 gxy = Rmp8x8(tid.x) + blockStart;
	uint2 size = GetInputSize();
	if (gxy.x >= size.x || gxy.y >= size.y) {
		return;
	}
	float2 pos = (gxy + 0.5) * pt;

	V4 s0_0 = l0(-1.0, -1.0);
	V4 s0_1 = l0(0.0, -1.0);
	V4 s0_2 = l0(1.0, -1.0);
	V4 s0_3 = l0(-1.0, 0.0);
	V4 s0_4 = l0(0.0, 0.0);
	V4 s0_5 = l0(1.0, 0.0);
	V4 s0_6 = l0(-1.0, 1.0);
	V4 s0_7 = l0(0.0, 1.0);
	V4 s0_8 = l0(1.0, 1.0);
	V4 s1_0 = -max(-s0_0, 0.0);
	V4 s1_1 = -max(-s0_1, 0.0);
	V4 s1_2 = -max(-s0_2, 0.0);
	V4 s1_3 = -max(-s0_3, 0.0);
	V4 s1_4 = -max(-s0_4, 0.0);
	V4 s1_5 = -max(-s0_5, 0.0);
	V4 s1_6 = -max(-s0_6, 0.0);
	V4 s1_7 = -max(-s0_7, 0.0);
	V4 s1_8 = -max(-s0_8, 0.0);
	s0_0 = max(s0_0, 0.0);
	s0_1 = max(s0_1, 0.0);
	s0_2 = max(s0_2, 0.0);
	s0_3 = max(s0_3, 0.0);
	s0_4 = max(s0_4, 0.0);
	s0_5 = max(s0_5, 0.0);
	s0_6 = max(s0_6, 0.0);
	s0_7 = max(s0_7, 0.0);
	s0_8 = max(s0_8, 0.0);

	V4 s2_0 = l1(-1.0, -1.0);
	V4 s2_1 = l1(0.0, -1.0);
	V4 s2_2 = l1(1.0, -1.0);
	V4 s2_3 = l1(-1.0, 0.0);
	V4 s2_4 = l1(0.0, 0.0);
	V4 s2_5 = l1(1.0, 0.0);
	V4 s2_6 = l1(-1.0, 1.0);
	V4 s2_7 = l1(0.0, 1.0);
	V4 s2_8 = l1(1.0, 1.0);
	V4 s3_0 = -max(-s2_0, 0.0);
	V4 s3_1 = -max(-s2_1, 0.0);
	V4 s3_2 = -max(-s2_2, 0.0);
	V4 s3_3 = -max(-s2_3, 0.0);
	V4 s3_4 = -max(-s2_4, 0.0);
	V4 s3_5 = -max(-s2_5, 0.0);
	V4 s3_6 = -max(-s2_6, 0.0);
	V4 s3_7 = -max(-s2_7, 0.0);
	V4 s3_8 = -max(-s2_8, 0.0);
	s2_0 = max(s2_0, 0.0);
	s2_1 = max(s2_1, 0.0);
	s2_2 = max(s2_2, 0.0);
	s2_3 = max(s2_3, 0.0);
	s2_4 = max(s2_4, 0.0);
	s2_5 = max(s2_5, 0.0);
	s2_6 = max(s2_6, 0.0);
	s2_7 = max(s2_7, 0.0);
	s2_8 = max(s2_8, 0.0);

	t0[gxy] = f0(s0_0, s0_1, s0_2, s0_3, s0_4, s0_5, s0_6, s0_7, s0_8, s1_0, s1_1, s1_2, s1_3, s1_4, s1_5, s1_6, s1_7, s1_8, s2_0, s2_1, s2_2, s2_3, s2_4, s2_5, s2_6, s2_7, s2_8, s3_0, s3_1, s3_2, s3_3, s3_4, s3_5, s3_6, s3_7, s3_8);
	t1[gxy] = f1(s0_0, s0_1, s0_2, s0_3, s0_4, s0_5, s0_6, s0_7, s0_8, s1_0, s1_1, s1_2, s1_3, s1_4, s1_5, s1_6, s1_7, s1_8, s2_0, s2_1, s2_2, s2_3, s2_4, s2_5, s2_6, s2_7, s2_8, s3_0, s3_1, s3_2, s3_3, s3_4, s3_5, s3_6, s3_7, s3_8);
}

//!PASS 10
//!DESC out-shuffle
//!BLOCK_SIZE 16
//!NUM_THREADS 64
//!IN INPUT, t0, t1
//!OUT OUTPUT

#define l0(x, y) V4(O(t0, float2(x, y)))
#define l1(x, y) V4(O(t1, float2(x, y)))

V4 f0(V4 s0_0, V4 s0_1, V4 s0_2, V4 s0_3, V4 s0_4, V4 s0_5, V4 s0_6, V4 s0_7, V4 s0_8, V4 s1_0, V4 s1_1, V4 s1_2, V4 s1_3, V4 s1_4, V4 s1_5, V4 s1_6, V4 s1_7, V4 s1_8, V4 s2_0, V4 s2_1, V4 s2_2, V4 s2_3, V4 s2_4, V4 s2_5, V4 s2_6, V4 s2_7, V4 s2_8, V4 s3_0, V4 s3_1, V4 s3_2, V4 s3_3, V4 s3_4, V4 s3_5, V4 s3_6, V4 s3_7, V4 s3_8) {
	V4 r = 0.0;
	r += mul(s0_0, M4(8.460e-03, 7.227e-04, -9.095e-03, -1.062e-03, 1.404e-03, -3.055e-03, 1.972e-02, -3.617e-03, -1.110e-02, -2.615e-03, -2.163e-02, 7.194e-03, 1.631e-02, 5.920e-03, -2.313e-02, 9.194e-03));
	r += mul(s0_1, M4(1.074e-01, 4.925e-02, 3.811e-03, -3.480e-03, -1.927e-02, -9.323e-02, 3.442e-02, -3.375e-03, 8.942e-02, 5.369e-02, 3.605e-03, -2.149e-02, 1.238e-01, 1.032e-01, -7.511e-03, -2.420e-02));
	r += mul(s0_2, M4(-4.397e-03, 6.268e-02, -1.117e-03, 5.248e-03, 6.173e-03, -4.652e-02, 2.153e-03, -1.332e-02, -2.124e-02, 6.323e-02, -6.680e-03, 2.414e-02, -2.336e-02, 3.126e-02, -1.137e-03, 8.318e-03));
	r += mul(s0_3, M4(-2.841e-02, 1.182e-02, 5.716e-03, 1.522e-02, 1.087e-01, -2.623e-03, 2.560e-02, -1.135e-03, -2.773e-02, 4.115e-02, -9.738e-03, -5.203e-03, -4.173e-02, -2.201e-02, 3.295e-02, -1.266e-02));
	r += mul(s0_4, M4(-4.117e-01, -2.906e-01, 1.740e-01, 7.056e-02, 2.449e-01, 2.290e-01, 2.660e-02, -1.887e-01, -1.606e-01, -2.341e-01, 2.386e-02, 9.567e-02, 2.140e-01, 5.510e-02, 3.705e-01, 3.566e-01));
	r += mul(s0_5, M4(9.640e-03, -1.480e-01, -1.321e-02, 9.225e-02, -4.257e-03, -3.511e-02, -7.280e-03, -7.580e-02, -1.273e-02, 7.344e-02, -1.140e-02, 8.228e-02, -6.665e-02, 2.214e-02, -2.575e-02, 5.468e-02));
	r += mul(s0_6, M4(2.629e-02, 3.221e-03, 1.147e-02, 1.322e-02, 1.657e-03, -8.292e-03, 2.597e-02, -3.207e-04, 4.843e-03, -2.782e-03, 6.102e-03, 1.200e-02, 7.469e-03, 1.380e-02, -1.182e-02, -1.349e-02));
	r += mul(s0_7, M4(-2.984e-02, 2.692e-02, -3.633e-02, -2.845e-02, -5.878e-02, -4.681e-02, 9.777e-02, 7.897e-03, 2.619e-02, 4.158e-02, -6.065e-02, -5.580e-02, -1.509e-03, -3.725e-03, 3.659e-02, 2.728e-02));
	r += mul(s0_8, M4(4.502e-03, 5.966e-03, -6.348e-03, -2.444e-02, -1.109e-02, -9.121e-03, 1.412e-02, -2.219e-02, 2.528e-02, 1.424e-02, -1.909e-02, 3.809e-02, 3.335e-03, -6.195e-03, -5.777e-03, -1.163e-02));
	r += mul(s1_0, M4(7.927e-02, -3.654e-02, -7.104e-02, -5.741e-03, -4.468e-02, -1.148e-02, 3.049e-02, -7.024e-03, 4.900e-02, -1.474e-02, -2.352e-02, -7.655e-03, -6.889e-03, -1.154e-04, -1.898e-02, -1.786e-03));
	r += mul(s1_1, M4(-1.474e-01, 4.527e-01, 9.350e-02, -1.063e-02, -1.159e-01, -1.820e-01, 2.065e-02, -2.246e-02, 8.028e-02, 1.627e-01, -5.292e-02, -5.642e-02, 9.400e-02, 6.621e-02, -1.423e-02, -2.229e-02));
	r += mul(s1_2, M4(-4.682e-02, 7.007e-02, 4.030e-03, -5.523e-02, -4.159e-03, -3.023e-02, 3.451e-04, -1.617e-02, 1.268e-02, 2.771e-02, -5.629e-03, 1.612e-02, -2.279e-02, 1.539e-02, -6.265e-03, 3.223e-03));
	r += mul(s1_3, M4(-2.588e-01, 5.084e-02, 2.529e-01, 3.827e-02, 2.549e-02, 6.341e-03, 9.548e-02, 2.094e-02, -2.024e-02, 2.899e-02, -3.879e-02, 7.127e-03, -3.527e-02, -2.582e-02, 3.312e-03, -1.217e-02));
	r += mul(s1_4, M4(8.045e-02, -5.762e-01, -2.616e-01, -9.298e-02, 2.315e-01, -1.745e-01, 2.468e-02, 5.254e-01, -5.182e-01, -4.752e-01, 4.877e-01, 1.722e-01, 1.480e-01, 4.491e-02, 2.757e-01, 2.529e-01));
	r += mul(s1_5, M4(1.792e-02, -1.146e-02, 2.996e-02, 1.509e-01, -2.630e-02, -1.523e-02, 2.457e-02, -5.773e-02, -2.553e-02, 3.057e-02, -3.759e-02, 1.110e-01, -6.776e-02, -6.445e-03, -3.691e-02, 4.384e-02));
	r += mul(s1_6, M4(-9.344e-03, 5.605e-02, 3.183e-02, -6.304e-03, -1.731e-02, 2.691e-03, 2.398e-02, -1.864e-02, 1.464e-02, 8.938e-04, -1.099e-02, -1.108e-03, -4.259e-03, 6.059e-03, -2.336e-02, -1.933e-02));
	r += mul(s1_7, M4(-4.542e-02, -1.644e-02, 5.247e-02, -2.091e-02, -7.788e-02, -3.454e-02, 8.288e-02, -1.948e-02, 7.775e-02, 7.495e-02, -1.214e-01, -8.277e-02, -2.031e-02, -2.472e-02, 2.223e-02, 2.040e-02));
	r += mul(s1_8, M4(4.182e-03, 1.227e-02, -3.306e-02, -2.026e-02, -1.007e-02, -4.687e-03, 8.388e-03, -1.988e-02, 4.379e-02, 2.888e-02, -3.609e-02, -8.212e-03, 9.212e-03, -1.536e-02, -1.724e-02, -2.522e-02));
	r += mul(s2_0, M4(1.291e-02, -7.279e-03, -1.884e-02, -1.385e-02, 5.309e-02, -1.217e-01, -5.973e-02, 3.029e-03, 4.425e-02, -1.353e-02, -1.157e-02, -2.189e-02, 2.732e-02, -1.622e-03, -2.147e-02, -6.696e-03));
	r += mul(s2_1, M4(1.174e-03, 4.834e-02, 1.280e-03, -1.357e-02, 1.357e-04, -2.637e-02, -8.604e-03, -1.080e-02, -9.358e-02, 7.446e-02, -8.482e-02, 4.900e-03, 1.160e-01, 8.796e-02, 4.314e-02, -7.086e-02));
	r += mul(s2_2, M4(-1.170e-02, -3.009e-02, -6.555e-03, 7.647e-03, -1.085e-04, -7.936e-03, 6.060e-04, -2.554e-03, 4.105e-02, -1.081e-02, 2.310e-02, -4.364e-02, -3.687e-02, -5.708e-03, 1.309e-02, 5.824e-03));
	r += mul(s2_3, M4(-8.081e-02, 4.155e-02, 4.842e-03, 1.172e-03, 3.383e-01, -2.309e-01, 4.094e-01, -3.521e-01, -2.314e-02, 4.370e-03, 3.993e-02, -1.701e-02, 6.141e-02, 2.521e-02, 7.447e-02, -2.860e-02));
	r += mul(s2_4, M4(9.761e-02, -2.114e-01, 6.705e-02, 8.186e-02, -7.398e-02, 1.014e-01, -1.438e-02, 7.350e-02, -6.589e-02, -1.153e-01, -6.204e-02, 1.552e-01, 6.467e-03, -3.129e-01, -4.580e-01, 3.175e-01));
	r += mul(s2_5, M4(-3.723e-02, 4.215e-02, -3.603e-03, -8.876e-03, -3.673e-03, 6.429e-03, -2.291e-03, 1.391e-03, 3.951e-02, 3.606e-02, 4.704e-02, -1.833e-02, 1.196e-01, -1.401e-02, 5.382e-02, -9.219e-02));
	r += mul(s2_6, M4(2.195e-02, -7.400e-03, -5.462e-03, -8.206e-05, -3.480e-02, 6.492e-03, 2.162e-02, -6.141e-02, -9.732e-03, 4.517e-04, 1.305e-02, -3.104e-03, 2.624e-03, -3.583e-03, 3.643e-02, -6.009e-04));
	r += mul(s2_7, M4(-3.295e-02, -3.172e-03, 3.492e-02, -4.382e-02, 3.715e-02, -6.948e-03, -4.113e-02, 2.448e-02, 2.546e-02, 1.106e-02, -3.410e-02, -3.827e-03, -6.474e-02, 1.733e-02, 6.169e-02, -5.725e-02));
	r += mul(s2_8, M4(5.160e-03, -9.184e-03, -8.453e-03, 1.735e-02, -9.055e-04, 2.434e-03, -2.602e-03, -6.082e-03, 2.434e-03, 1.192e-03, 4.964e-03, 1.187e-02, -1.960e-02, -1.187e-02, 4.503e-02, 4.133e-03));
	r += mul(s3_0, M4(-3.137e-02, 2.267e-03, -2.172e-02, -6.702e-03, -5.108e-02, -1.915e-02, -5.771e-02, -1.442e-03, -5.126e-02, -3.757e-03, -2.437e-03, -2.560e-02, 8.972e-03, 5.875e-03, -2.397e-02, 6.039e-03));
	r += mul(s3_1, M4(4.555e-02, 3.433e-02, 8.142e-03, -2.053e-02, 1.649e-03, 1.561e-02, -5.300e-03, -3.121e-02, 5.693e-01, -9.351e-02, -1.264e-01, -1.818e-01, 1.213e-01, -1.382e-02, 3.586e-02, -3.418e-02));
	r += mul(s3_2, M4(-1.550e-02, 7.598e-03, -5.015e-03, 1.551e-02, -4.808e-03, -9.668e-03, -1.379e-03, -2.895e-05, -5.092e-02, -1.590e-01, -3.258e-02, 1.031e-01, -2.058e-02, -1.988e-02, 1.329e-02, 6.773e-03));
	r += mul(s3_3, M4(-1.773e-02, 6.275e-02, -1.810e-02, 3.388e-02, 4.458e-02, -5.655e-02, 4.576e-02, -1.008e-01, 2.308e-02, 2.453e-03, -1.786e-02, -2.168e-02, 3.045e-02, 4.050e-02, 4.333e-02, -6.095e-03));
	r += mul(s3_4, M4(3.527e-01, -5.137e-01, 2.419e-01, -9.781e-02, -1.164e-01, 2.269e-01, -7.007e-02, 2.617e-01, -1.806e-01, -9.152e-02, -5.043e-02, 2.164e-01, -5.430e-02, -2.751e-01, 6.120e-02, 8.343e-02));
	r += mul(s3_5, M4(-4.383e-02, 5.480e-02, -6.708e-03, 1.620e-02, 6.208e-05, -5.279e-03, 4.534e-03, -2.042e-02, 7.568e-02, 5.119e-02, 2.790e-02, -2.173e-01, 5.097e-02, -1.295e-02, 5.325e-02, -1.220e-01));
	r += mul(s3_6, M4(-1.231e-02, 1.110e-03, -2.134e-02, 2.965e-03, -1.631e-02, 1.171e-02, -8.523e-04, -2.774e-02, -2.671e-03, -5.021e-03, 1.219e-03, -1.524e-03, 3.867e-03, -2.020e-02, 4.456e-02, 6.040e-03));
	r += mul(s3_7, M4(-3.383e-02, 1.125e-02, 9.401e-02, -1.240e-01, 4.461e-02, -2.716e-02, -9.338e-03, 1.624e-03, 1.596e-02, 1.825e-02, -1.462e-02, -2.676e-02, -1.739e-02, 8.447e-03, 2.961e-02, -1.786e-02));
	r += mul(s3_8, M4(9.271e-03, -5.721e-03, -1.180e-02, 4.245e-02, -2.551e-04, 7.369e-03, -1.046e-02, 5.688e-03, -1.398e-02, 9.160e-06, 2.457e-02, 8.210e-03, -1.589e-03, -4.574e-03, 3.357e-02, 2.664e-02));
	r += V4(3.001e-04, 1.819e-03, -1.517e-04, 1.301e-03);
	return tanh(r);
}

void Pass10(uint2 blockStart, uint3 tid) {
	float2 pt = float2(GetInputPt());
	uint2 gxy = (Rmp8x8(tid.x) << 1) + blockStart;
	uint2 size = GetOutputSize();
	if (gxy.x >= size.x || gxy.y >= size.y) {
		return;
	}
	float2 pos = ((gxy >> 1) + 0.5) * pt;

	V4 s0_0 = l0(-1.0, -1.0);
	V4 s0_1 = l0(0.0, -1.0);
	V4 s0_2 = l0(1.0, -1.0);
	V4 s0_3 = l0(-1.0, 0.0);
	V4 s0_4 = l0(0.0, 0.0);
	V4 s0_5 = l0(1.0, 0.0);
	V4 s0_6 = l0(-1.0, 1.0);
	V4 s0_7 = l0(0.0, 1.0);
	V4 s0_8 = l0(1.0, 1.0);
	V4 s1_0 = -max(-s0_0, 0.0);
	V4 s1_1 = -max(-s0_1, 0.0);
	V4 s1_2 = -max(-s0_2, 0.0);
	V4 s1_3 = -max(-s0_3, 0.0);
	V4 s1_4 = -max(-s0_4, 0.0);
	V4 s1_5 = -max(-s0_5, 0.0);
	V4 s1_6 = -max(-s0_6, 0.0);
	V4 s1_7 = -max(-s0_7, 0.0);
	V4 s1_8 = -max(-s0_8, 0.0);
	s0_0 = max(s0_0, 0.0);
	s0_1 = max(s0_1, 0.0);
	s0_2 = max(s0_2, 0.0);
	s0_3 = max(s0_3, 0.0);
	s0_4 = max(s0_4, 0.0);
	s0_5 = max(s0_5, 0.0);
	s0_6 = max(s0_6, 0.0);
	s0_7 = max(s0_7, 0.0);
	s0_8 = max(s0_8, 0.0);

	V4 s2_0 = l1(-1.0, -1.0);
	V4 s2_1 = l1(0.0, -1.0);
	V4 s2_2 = l1(1.0, -1.0);
	V4 s2_3 = l1(-1.0, 0.0);
	V4 s2_4 = l1(0.0, 0.0);
	V4 s2_5 = l1(1.0, 0.0);
	V4 s2_6 = l1(-1.0, 1.0);
	V4 s2_7 = l1(0.0, 1.0);
	V4 s2_8 = l1(1.0, 1.0);
	V4 s3_0 = -max(-s2_0, 0.0);
	V4 s3_1 = -max(-s2_1, 0.0);
	V4 s3_2 = -max(-s2_2, 0.0);
	V4 s3_3 = -max(-s2_3, 0.0);
	V4 s3_4 = -max(-s2_4, 0.0);
	V4 s3_5 = -max(-s2_5, 0.0);
	V4 s3_6 = -max(-s2_6, 0.0);
	V4 s3_7 = -max(-s2_7, 0.0);
	V4 s3_8 = -max(-s2_8, 0.0);
	s2_0 = max(s2_0, 0.0);
	s2_1 = max(s2_1, 0.0);
	s2_2 = max(s2_2, 0.0);
	s2_3 = max(s2_3, 0.0);
	s2_4 = max(s2_4, 0.0);
	s2_5 = max(s2_5, 0.0);
	s2_6 = max(s2_6, 0.0);
	s2_7 = max(s2_7, 0.0);
	s2_8 = max(s2_8, 0.0);

	V4 r = f0(s0_0, s0_1, s0_2, s0_3, s0_4, s0_5, s0_6, s0_7, s0_8, s1_0, s1_1, s1_2, s1_3, s1_4, s1_5, s1_6, s1_7, s1_8, s2_0, s2_1, s2_2, s2_3, s2_4, s2_5, s2_6, s2_7, s2_8, s3_0, s3_1, s3_2, s3_3, s3_4, s3_5, s3_6, s3_7, s3_8);

	static const float3x3 rgb2yuv = {0.299, 0.587, 0.114, -0.169, -0.331, 0.5, 0.5, -0.419, -0.081};
	static const float3x3 yuv2rgb = {1, -0.00093, 1.401687, 1, -0.3437, -0.71417, 1, 1.77216, 0.00099};
	float2 opt = float2(GetOutputPt());

	pos -= 0.5f * opt;
	float3 yuv = mul(rgb2yuv, INPUT.SampleLevel(SL, pos, 0).rgb);
	OUTPUT[gxy] = float4(mul(yuv2rgb, float3(saturate(yuv.r + r.x), yuv.yz)), 1);

	++gxy.x;
	pos.x += opt.x;
	yuv = mul(rgb2yuv, INPUT.SampleLevel(SL, pos, 0).rgb);
	OUTPUT[gxy] = float4(mul(yuv2rgb, float3(saturate(yuv.r + r.y), yuv.yz)), 1);

	++gxy.y;
	pos.y += opt.y;
	yuv = mul(rgb2yuv, INPUT.SampleLevel(SL, pos, 0).rgb);
	OUTPUT[gxy] = float4(mul(yuv2rgb, float3(saturate(yuv.r + r.w), yuv.yz)), 1);

	--gxy.x;
	pos.x -= opt.x;
	yuv = mul(rgb2yuv, INPUT.SampleLevel(SL, pos, 0).rgb);
	OUTPUT[gxy] = float4(mul(yuv2rgb, float3(saturate(yuv.r + r.z), yuv.yz)), 1);
}
