// This file is generated by the scripts available at https://github.com/hauuau/magpie-prescalers
// Please don't edit this file directly.
// Generated by: nnedi3.py --nns 256 --win 8x6 --use-compute-shader --use-magpie
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

//!MAGPIE EFFECT
//!VERSION 4
//!SORT_NAME NNEDI3_256_6

//!TEXTURE
Texture2D INPUT;

//!SAMPLER
//!FILTER POINT
SamplerState sam_INPUT;

//!TEXTURE
//!WIDTH  INPUT_WIDTH * 1 * 2
//!HEIGHT INPUT_HEIGHT * 2 * 1
Texture2D OUTPUT;

//!SAMPLER
//!FILTER LINEAR
SamplerState sam_INPUT_LINEAR;

//!TEXTURE
//!FORMAT R16_FLOAT
//!WIDTH  INPUT_WIDTH * 1
//!HEIGHT INPUT_HEIGHT * 2
Texture2D temp;

//!SAMPLER
//!FILTER POINT
SamplerState sam_temp;

//!COMMON
#include "prescalers.hlsli"

#define LAST_PASS 2

//!PASS 1
//!DESC NNEDI3 (double_y, nns256, win8x6)
//!IN INPUT
//!OUT temp
//!BLOCK_SIZE 32, 16
//!NUM_THREADS 32, 8
#pragma optionNV(inline none)
float nnedi3(vec4 samples[12]) {
	float sum = 0.0, sumsq = 0.0;
	[unroll] for (int i = 0; i < 12; i++) {
		sum += dot(samples[i], vec4(1.0, 1.0, 1.0, 1.0));
		sumsq += dot(samples[i], samples[i]);
	}
	float mstd0 = sum / 48.0;
	float mstd1 = sumsq / 48.0 - mstd0 * mstd0;
	float mstd2 = mix(0.0, inversesqrt(mstd1), mstd1 >= 1.192092896e-7);
	mstd1 *= mstd2;
	float vsum = 0.0, wsum = 0.0, sum1, sum2;
#define T(x) intBitsToFloat(x)
#define W(i, w0, w1, w2, w3) dot(samples[i], vec4(T(w0), T(w1), T(w2), T(w3)))
#define WS(w0, w1)                                                                                                     \
	sum1 = exp(sum1 * mstd2 + T(w0));                                                                                  \
	sum2 = sum2 * mstd2 + T(w1);                                                                                       \
	wsum += sum1;                                                                                                      \
	vsum += sum1 * (sum2 / (1.0 + abs(sum2)));
	sum1 = W(0, -1118812211, -1118354985, -1108702207, -1107177196)
		 + W(1, -1116025261, -1113369587, -1126504964, -1117760744)
		 + W(2, -1127312137, 1040658850, -1105559165, 1024463101)
		 + W(3, -1120674615, -1117458482, -1124477727, 1041726453)
		 + W(4, -1102924251, -1120327001, 1037346316, -1097807929)
		 + W(5, 1051925971, 1061593601, -1098269094, 1015141868)
		 + W(6, -1120777358, -1114916026, 1042061230, 1053108884)
		 + W(7, -1109857889, -1129934237, -1137814218, -1101147334)
		 + W(8, 1032645830, 1029100907, -1121960158, -1114359336) + W(9, -1128256674, 978731342, 1026597474, 1023094846)
		 + W(10, -1133406593, 1018102856, -1118580651, -1112914505)
		 + W(11, 1040041685, 1010634196, -1137769344, -1124738995);
	sum2 =
		W(0, 1012167794, 1034293816, 1040949842, -1073125242) + W(1, -1098861131, 1034317546, 975711915, -1103749327)
		+ W(2, -1105000392, -1097051670, 1026609280, -1107080190)
		+ W(3, 1007876102, 1042152488, -1113573827, 1048636347) + W(4, -1103172582, 1037196612, -1112492311, 1032768248)
		+ W(5, 1065119806, 1064777150, 1028248806, -1106667446) + W(6, 1037438381, 1026775674, 1049707133, 1035198208)
		+ W(7, 1042916747, 1024046979, -1104922990, -1112883791)
		+ W(8, -1118855570, 1049268872, -1108803486, -1112062411)
		+ W(9, 1035896848, 1009005510, 1019305156, -1110039318) + W(10, 1037762592, 1031133421, -1129478003, 1029694272)
		+ W(11, -1105233202, 1045598091, 1002108025, -1116379320);
	WS(1002542528, -1081598301);
	sum1 =
		W(0, -1123106403, 1018532849, 1058293919, -1096563748) + W(1, 1033211315, -1104454821, 1003194766, 1031358712)
		+ W(2, 1048723343, -1102943230, 1043311017, 1033034550)
		+ W(3, -1115291860, -1100442248, 1060312385, -1084853826)
		+ W(4, -1122032382, -1105126162, -1120609928, -1102109750)
		+ W(5, 1065191364, -1082116255, 1048832547, -1093430837)
		+ W(6, 1033033375, -1124327881, 1057579241, -1090047916) + W(7, 1045565001, 1033480943, -1104418325, 1022719310)
		+ W(8, 1055391647, -1090520747, 1034840623, -1104668395) + W(9, 1031657633, 1042404749, 1048926634, -1115672903)
		+ W(10, 1040065984, 1041617645, -1140694509, -1173350542)
		+ W(11, 1057234642, -1088607906, 1034960904, -1100859732);
	sum2 =
		W(0, -1118979564, 1038135851, 1040555036, 1046730291) + W(1, -1098841046, 1010901456, -1136455954, -1098903542)
		+ W(2, -1113356687, -1091503884, 1033064908, -1105119573) + W(3, 1031647880, 1043936541, 1041172918, 1053446821)
		+ W(4, -1105844234, 1050988870, -1098733088, -1095471090)
		+ W(5, 1058853402, 1057969905, -1107613268, -1096003667)
		+ W(6, 1032618663, -1114646115, -1111675314, 1026777488)
		+ W(7, -1104403193, 1040941647, -1115252794, 1050331000)
		+ W(8, 1042547849, 1032649026, -1109177822, -1135105484)
		+ W(9, -1105564107, -1107943513, -1102521857, -1097022326)
		+ W(10, -1106932655, -1111654963, 1028338874, 1030299514)
		+ W(11, 1048036907, 1045220138, -1104926499, 1015146572);
	WS(-1089089900, 1057806976);
	sum1 =
		W(0, -1107295812, 1034138799, -1095422036, 1050726826) + W(1, 1041715821, -1107540610, -1127595840, 1025412102)
		+ W(2, -1098433268, -1189029283, -1122343505, -1114195981)
		+ W(3, -1123024597, 1036945929, -1092642698, 1055732365)
		+ W(4, -1122551116, 1004508092, -1107414907, 1043589025)
		+ W(5, -1086058047, 1066834483, 1012137296, -1123010964) + W(6, 1016079705, 1048626936, -1087422851, 1060391966)
		+ W(7, -1112593208, 1021997657, -1114511976, 1026901142)
		+ W(8, -1090938821, 1050840209, 1032081267, -1116540066)
		+ W(9, -1121404144, -1122208804, -1099844512, 1046023279)
		+ W(10, 1025525231, -1117735535, -1120167114, -1132433569)
		+ W(11, -1092394401, 1054523402, 1034856335, -1140325311);
	sum2 =
		W(0, -1100068589, 1045053907, 1035618626, 1049401249) + W(1, 1036897142, -1103084156, 1040406565, -1112537807)
		+ W(2, -1097933278, -1091711434, 1040848725, 1039746012)
		+ W(3, -1105732125, 1034765996, -1099579155, 1056573344)
		+ W(4, -1089717374, 1030295740, -1129255625, -1096936254)
		+ W(5, 1047111871, 1055190008, 1050298277, -1110783667) + W(6, -1110986904, -1098576495, 1056019034, 1058665437)
		+ W(7, -1089302244, 1041764164, 1041854514, -1119869595)
		+ W(8, -1119227686, -1092612461, 1058580142, -1100808273)
		+ W(9, -1108063740, -1108123574, 1029490732, -1121089271)
		+ W(10, -1127874601, 1022690203, 1040297872, -1106886121)
		+ W(11, 996712344, -1113107096, -1110437244, 1034569294);
	WS(1049963735, -1124746024);
	sum1 = W(0, 1006389467, 1034213253, 1058411598, -1089111694) + W(1, -1120169982, 1033778855, 991131306, -1110639240)
		 + W(2, 1049374726, -1111102680, 1039576302, -1134195605)
		 + W(3, -1124991168, -1124116580, 1060442825, -1086690096)
		 + W(4, 1018630958, -1122058050, 1036315168, -1106688436)
		 + W(5, 1064243752, -1080857842, 1032153615, 1024033695)
		 + W(6, -1114080443, 1016950458, 1058630778, -1086343400) + W(7, 1034713638, 1016006830, 1034164414, 1034354600)
		 + W(8, 1057235431, -1086990857, 1036089759, 1017381585)
		 + W(9, -1168983685, -1118357326, 1051622657, -1099687954)
		 + W(10, 1035150121, 1027377121, 1034869786, 1046100667)
		 + W(11, 1028310995, -1090257402, -1126482082, -1130216101);
	sum2 = W(0, -1114775505, -1111353121, 1051023520, 1077280281)
		 + W(1, 1042396970, -1100155636, 1022693528, 1040828458) + W(2, 1041444385, 1083159907, 1039028690, 1038899070)
		 + W(3, 1033686534, -1108626677, -1101109690, -1090827263)
		 + W(4, -1129576724, -1108327399, -1159675846, -1179590680)
		 + W(5, -1089609004, -1064966677, -1146898193, -1128357112)
		 + W(6, -1112709023, 1041114289, -1101828769, -1073695373)
		 + W(7, -1117377551, 1026559236, 1033838002, 1028829848) + W(8, 1037546580, -1090323484, 1046069066, 1017563688)
		 + W(9, -1125624388, -1108121837, 1033655640, 1042738654)
		 + W(10, -1098820901, -1149039617, 1032684170, 1037026782)
		 + W(11, -1104771455, -1104201752, 1049907200, -1119733667);
	WS(-1082925548, -1131273240);
	sum1 =
		W(0, -1130676005, 1028984921, -1090453298, 1056020338) + W(1, 1036092472, 1031745797, 1024417890, 1026031368)
		+ W(2, -1094705109, 1048479050, 1026370227, 1023514525) + W(3, -1127912110, 1046418962, -1088411833, 1054709085)
		+ W(4, 1040943828, -1139610597, -1123681912, 1048544370) + W(5, -1080625999, 1056570469, 1016526011, 1039178347)
		+ W(6, -1128802908, 1032747842, -1078821070, 1060414079)
		+ W(7, -1134933227, -1115579031, 1009745483, -1115143804)
		+ W(8, -1093720869, 1058018725, -1146727344, 1033865376) + W(9, 1030244593, 1035809011, -1115224705, 1048613352)
		+ W(10, -1126383553, -1123856496, -1124372951, 1012870858)
		+ W(11, -1099806226, 1053689379, 1034696072, 1032018765);
	sum2 = W(0, -1117505397, -1114926763, 1048798551, -1102904639)
		 + W(1, 1025448640, -1112830121, -1126832117, -1140231915)
		 + W(2, -1146496262, -1113101086, -1129185935, -1125809392)
		 + W(3, -1116692107, -1125548157, 1045683415, -1125191934)
		 + W(4, 1034411663, -1121525964, -1107644007, -1125354742)
		 + W(5, 1053833339, 1000279686, -1120274227, -1113082203)
		 + W(6, -1117458583, 1042669208, 1057710126, -1104919217)
		 + W(7, 1041220979, -1111650191, -1123105101, 1027773818)
		 + W(8, 1032098567, -1107525999, 1022009255, 1035574395)
		 + W(9, -1117032217, -1115355410, -1100115369, 1032507221)
		 + W(10, 1021108475, -1112638630, 1004815486, -1119603373)
		 + W(11, -1110288078, -1103622420, 1039592007, -1117835672);
	WS(-1089340204, 1064822548);
	sum1 =
		W(0, 1024560260, 1040632746, 1042654740, -1106019185) + W(1, -1121721479, 1037194524, 1017532199, -1123651609)
		+ W(2, 1053882699, -1094337163, 1033472482, 1028050126) + W(3, 1036465700, 998268921, 1058440180, -1083627654)
		+ W(4, -1112650528, 993325743, 1032538389, -1115892569) + W(5, 1062655475, -1081203240, 1042941034, 1013010462)
		+ W(6, 1031720480, -1109887627, 1057084090, -1087921069) + W(7, 1046201917, 1035154240, 1035008482, 1033415588)
		+ W(8, 1054084900, -1086686700, 1038013786, 1021897635) + W(9, 1020865894, -1112010572, 1046711885, -1098821294)
		+ W(10, 1039144481, 1027972046, 1041385023, 1043778521)
		+ W(11, 1050203279, -1083224116, 1043447032, -1131974615);
	sum2 = W(0, -1108565409, 1034353453, -1088688588, 1053209723)
		 + W(1, 1049996954, -1107721619, 1041490776, 1018486577)
		 + W(2, -1105841420, -1092734414, 1039814215, -1122233136)
		 + W(3, -1103680498, -1113519263, 1037914109, -1094792328)
		 + W(4, 1034343810, -1116717915, -1113858207, 1052082200) + W(5, 1062919581, 1049986423, 1012724150, 1040029087)
		 + W(6, 1018958125, -1097140178, -1095558118, -1107726366)
		 + W(7, -1098318745, 1007719490, -1139146344, 1046768714)
		 + W(8, 1049328132, 1044527939, 1024888668, -1100531711) + W(9, 1024460115, -1098207895, 1041960027, 1046336394)
		 + W(10, -1106186917, 1037888927, -1111959213, -1128703602)
		 + W(11, 1035231667, -1110040773, 1036710347, -1102670680);
	WS(-1083458668, -1076208878);
	sum1 = W(0, 1028803476, 1040683401, 1046406904, -1098733730)
		 + W(1, 1004468631, 1030855367, -1119221604, -1097616301)
		 + W(2, 1051879501, -1093169213, -1110693690, -1111140815)
		 + W(3, -1136427363, 1042493937, 1058517387, -1088547874)
		 + W(4, 1024040880, -1127640694, 1033962333, -1106128994)
		 + W(5, 1062475632, -1086787145, 1045297574, -1108587948)
		 + W(6, -1108948664, -1096558041, 1061490456, -1088927588)
		 + W(7, 1028806548, -1104411844, 1041264181, 1044433886) + W(8, 1053313566, 1035939910, 1038834422, 1040762412)
		 + W(9, -1108358441, -1097860853, 1049919352, -1096390160)
		 + W(10, -1095128350, -1118015030, 1032628870, -1123751924)
		 + W(11, 1054299289, -1130402734, -1106314264, -1165494119);
	sum2 = W(0, 1016611708, 1016478676, -1110195557, -1101004152)
		 + W(1, 1040169462, -1128480930, 1037888148, 1037533502) + W(2, 1036667983, 1029018929, 1051795874, -1116498505)
		 + W(3, -1105282980, 1012928145, -1126800264, -1092116144)
		 + W(4, 1041335879, -1105668811, 1016374797, 1042320298)
		 + W(5, -1123884642, 1048907311, 1052196876, -1110762465)
		 + W(6, -1146676672, -1119445205, -1097480948, 1063932318)
		 + W(7, -1105880602, -1096424000, -1118267731, -1133007186)
		 + W(8, -1111241984, 1045206632, -1088285853, 1016609657)
		 + W(9, -1130451858, -1123652878, 1039970164, 1051255124)
		 + W(10, -1095104183, 1029046774, 1032410610, -1114217777)
		 + W(11, 1039354964, 1032089604, -1090379026, 1046489649);
	WS(-1104670894, -1131977046);
	sum1 =
		W(0, -1112648188, -1127207577, 1054983097, -1088875575) + W(1, 1031188251, -1103988635, -1122872327, 1044660591)
		+ W(2, 1050049705, -1112061830, 1037435556, 1027063042) + W(3, 1034658686, -1159198685, 1055452918, -1088327234)
		+ W(4, 1047857485, -1117747167, -1105196647, -1091967838)
		+ W(5, 1062208630, -1080890076, 1027642075, -1097581231) + W(6, 1040705957, 1050515731, 1055187309, -1103107959)
		+ W(7, 1054501223, 1026629396, -1105551222, -1105182655)
		+ W(8, 1051606290, -1088400827, -1109004816, -1115427963)
		+ W(9, -1121117111, -1127322710, 1047450666, -1103254713)
		+ W(10, 1042878098, -1119280070, 1017793890, 1049557794)
		+ W(11, 1052382814, -1097595959, 1041414585, -1121163375);
	sum2 =
		W(0, 1016354951, 1027513536, -1143898815, -1120711631) + W(1, -1121835937, 1011202413, -1117974191, 1035918257)
		+ W(2, 1029824032, 1038928177, -1110582057, 1027020738) + W(3, 1039379806, 1037237024, -1103985849, -1101088822)
		+ W(4, 1009730353, -1113735870, 1055799129, -1144611727)
		+ W(5, -1097216592, -1097673825, 1040607236, 1044957698)
		+ W(6, 1043516685, 1028380863, -1106760625, -1124050651)
		+ W(7, -1115312251, -1114960631, 1037116388, 1042440009)
		+ W(8, -1103814691, -1105579212, 1038947942, 1027787831)
		+ W(9, 1033575170, -1106882882, -1123395355, 1026359109)
		+ W(10, -1135830635, -1133116095, -1131729016, 1025801393)
		+ W(11, -1136138683, 1011024469, -1112603972, 1008198659);
	WS(-1096559831, 1037484900);
	sum1 =
		W(0, 1028249855, 1038422322, 1057397273, -1091437192) + W(1, -1101563608, 1033785689, -1134487991, 1027879764)
		+ W(2, 1048869250, -1098773026, 1029769503, 1031362249) + W(3, 1034313250, 1029515489, 1056640275, -1086850776)
		+ W(4, -1127965876, -1173649736, 1016173128, -1112460521)
		+ W(5, 1065757625, -1083502823, -1131269971, -1128247556)
		+ W(6, 1027417370, -1107825326, 1058322735, -1083394976) + W(7, 1044386388, 1035484541, 1028347039, -1123304579)
		+ W(8, 1054334819, -1089694535, -1107441417, -1132373103)
		+ W(9, 1000575210, 1030471249, 1052511918, -1098313541) + W(10, 1031752252, 1034873120, 1035635068, -1120703806)
		+ W(11, 1052376319, -1102551488, -1098473097, -1142130892);
	sum2 = W(0, -1112511339, -1073555081, 1076402541, -1104998932)
		 + W(1, -1101584674, 1037626737, 1040888051, -1070793862)
		 + W(2, 1075658117, 1054215981, -1115233903, 1015165170) + W(3, 1033770332, -1069228230, 1075655149, 1042820552)
		 + W(4, 1010151672, 1023929473, 1027239578, -1071158503) + W(5, 1077820889, 1046227202, 1035248614, 1033175695)
		 + W(6, -1109060021, -1080567434, 1045918702, -1095422364)
		 + W(7, 1038949494, 1025525751, -1135961020, 1047598893)
		 + W(8, -1118850699, -1101978428, 1049027220, 1032251645) + W(9, -1113507810, 948656059, 1035044244, 1045389579)
		 + W(10, 1028467783, -1117328038, -1110941727, -1129804625)
		 + W(11, 1026016583, -1103164541, -1118124613, 1042587545);
	WS(-1081931126, 1073966570);
	sum1 =
		W(0, -1121849711, 1035175459, -1121951547, 1027761070) + W(1, 1025905706, -1114686833, -1146361331, -1097410109)
		+ W(2, 1026127169, 1045225025, 1037511592, -1113648733) + W(3, 1017322599, 1043585907, -1144746721, -1106255910)
		+ W(4, 1043091875, 1017686828, -1106692309, -1120101763)
		+ W(5, -1091000962, 1065386286, -1111228857, -1108319001)
		+ W(6, 1025148299, 1050307440, -1079735571, 1061827739) + W(7, -1120837551, 1018597782, -1106210884, 1038219466)
		+ W(8, -1091953433, 1056380469, -1102991437, -1147707682)
		+ W(9, 1006422511, 1023773090, -1096168868, 1049682211)
		+ W(10, 1003336935, -1110127893, -1115138804, -1132131774)
		+ W(11, -1102445962, 1046599772, 1040799505, 1028136822);
	sum2 =
		W(0, -1106398945, 1035173169, -1101335301, 1053305068) + W(1, -1121291886, -1109509581, 1034732755, -1090565718)
		+ W(2, 1056357842, 1050400788, -1115544374, -1107192051)
		+ W(3, -1136096426, 1037348813, -1122254044, 1036743473)
		+ W(4, -1105444760, 1016457143, -1116038033, -1089313148)
		+ W(5, 1066071262, 1057700465, -1086616818, 1022772267) + W(6, 1044672515, 1037418911, -1095175639, -1084949846)
		+ W(7, 1050477957, 1033704361, -1100200943, 1045738761) + W(8, -1132458755, 1003355997, -1102270714, 1035291569)
		+ W(9, 1037208365, -1130864309, 1007521414, 1030076164)
		+ W(10, 1045722667, -1111299866, 1025870712, -1117649125)
		+ W(11, 1025322164, -1106413087, 999303933, 1024551876);
	WS(1052508503, 1065718149);
	sum1 = W(0, 1042149474, 962035242, 1048663227, -1097510801) + W(1, 1028239019, 1038442493, -1109127212, -1098223900)
		 + W(2, 1043423478, -1096660204, -1104342914, -1109357577)
		 + W(3, 1041796883, 1027445007, 1055339346, -1087758861) + W(4, 1027971236, 1040109559, 1033122295, -1108112926)
		 + W(5, 1061167739, -1089406218, 1037128774, 1025450507)
		 + W(6, -1120120612, -1098175173, 1054196775, -1094841886)
		 + W(7, -1105773058, -1123303012, 1045736850, 1043181559)
		 + W(8, 1055761732, -1105769888, 1042761157, 1044237597)
		 + W(9, -1110374755, -1100319159, 1041284046, -1103555357)
		 + W(10, -1101757237, -1111907879, 1038133568, -1102543586)
		 + W(11, 1051299336, -1120191499, -1105847257, 1039590240);
	sum2 =
		W(0, -1109097964, 1037136687, 1031673749, -1125393555) + W(1, 1019467600, 1025995330, 1021868522, -1116667451)
		+ W(2, -1094712046, 1041352693, -1104433838, 1008084051) + W(3, 1007318978, -1107845433, 1038331125, 1034962829)
		+ W(4, -1122570447, 1039892459, 1032613655, -1109068920)
		+ W(5, 1040720319, -1112580519, -1121851072, 1025598855)
		+ W(6, 1002517286, 1016069779, -1111158812, -1106409067)
		+ W(7, -1113430896, 1045465420, -1126879582, -1103760436)
		+ W(8, 1056111085, -1106729155, 1049773824, -1110468674)
		+ W(9, 1031113174, 1030143702, -1106358629, -1106975050)
		+ W(10, 1036295980, 1020538422, -1114937810, -1118059752)
		+ W(11, -1121843086, 1047380650, -1122235886, -1113447212);
	WS(1056997868, 1008833773);
	sum1 =
		W(0, -1118496039, 1006806901, 1039826714, -1123143270) + W(1, 1006039247, 1017005492, 1036420187, -1130107576)
		+ W(2, -1123687353, -1104570591, 1032886196, -1125702370)
		+ W(3, -1113594582, -1115019369, 1053157409, -1093231896)
		+ W(4, -1105180689, 1028719950, 1034344230, 1045363911) + W(5, 1059756929, -1095316624, -1102708199, 1009228202)
		+ W(6, 1038393121, -1090717022, 1058230383, -1095564524)
		+ W(7, 1035814292, -1119964195, -1109888100, 1037930126)
		+ W(8, 1045739824, -1098051412, -1129186168, 1033820442)
		+ W(9, 1032434307, -1110427933, 1042446790, -1101398261)
		+ W(10, 1025625861, 1028568173, -1131937728, -1112104883)
		+ W(11, 1052782212, -1104229594, -1112516090, -1136905401);
	sum2 =
		W(0, 1034320453, -1118604595, 1025235375, 1028595208) + W(1, 1002638229, -1116609216, -1112051735, -1109468006)
		+ W(2, -1107232926, 1046387359, -1105038970, 1005965131) + W(3, 1043966073, -1106879339, 1049289065, 1044354198)
		+ W(4, 1045499601, -1111658272, 1033608293, -1088213587)
		+ W(5, 1067079268, -1087106166, 1035867996, -1132447732)
		+ W(6, -1092579307, 1064370547, -1088486363, -1108961766)
		+ W(7, -1096457250, 1042442572, 1051236380, -1095838484)
		+ W(8, 1044420987, -1104528882, 1028839698, -1134350406)
		+ W(9, -1102939053, 1043763107, -1107783352, 1035658672)
		+ W(10, -1122532695, -1131375963, 1027336318, 1016664388)
		+ W(11, -1116658227, 1023955051, -1126291119, -1135660575);
	WS(1064849644, -1092967401);
	sum1 =
		W(0, 1041078624, 1033930742, 1053270962, -1091277968) + W(1, -1115974645, -1124489961, -1103081652, 1034184171)
		+ W(2, 1058076017, -1091900963, -1101902009, 1046377811)
		+ W(3, 1045204674, -1098756264, 1059044453, -1097334921)
		+ W(4, 1038364767, -1096742869, -1126422222, 1038407355) + W(5, 1061713418, -1078564449, 1031099397, 1034335299)
		+ W(6, -1107755791, -1103118957, 1064682577, -1099822850)
		+ W(7, 1025967234, 1015202107, 1049230600, -1103625882) + W(8, 1047988615, -1091654943, 1010917525, -1098744549)
		+ W(9, -1101861336, 1035198826, 1055582710, -1096942230)
		+ W(10, 1021900159, 1047801952, 1041473799, -1102710964)
		+ W(11, 1058355518, -1098047297, -1106099948, -1101582418);
	sum2 =
		W(0, 1034970587, 1039267337, -1109640195, -1085205368) + W(1, 1065312771, -1111782462, -1105865147, 1026053125)
		+ W(2, 1027743203, -1076908464, 1068235631, 1029167111) + W(3, 1024111791, 1040193826, 1042644379, -1072741915)
		+ W(4, 1074530244, 1035172075, 1018431373, 1037956157) + W(5, -1088412806, -1079896887, 1069229068, 1048206286)
		+ W(6, -1107243650, -1106797747, -1104275404, 1057561219)
		+ W(7, -1110308581, -1092973955, 1038385161, 1031902437) + W(8, 1031274183, 1052902509, 1045193510, -1105822229)
		+ W(9, -1114574492, -1114137980, -1115379021, -1103620900)
		+ W(10, -1167188013, -1102796809, -1129893537, -1128932411)
		+ W(11, 1040558376, 1054347378, -1099424233, -1106619819);
	WS(-1085552428, 1044647857);
	sum1 =
		W(0, -1130568573, -1120131932, -1097293585, 1052681344) + W(1, -1115182247, 1016796643, -1111247047, 1046596325)
		+ W(2, -1095715202, 1050957098, -1125685565, -1123522377)
		+ W(3, 1001536536, 1026932885, -1090361246, 1059711152) + W(4, -1097304503, 1028362085, -1104704953, 1049575094)
		+ W(5, -1085535724, 1060788917, -1122898434, -1112833505)
		+ W(6, 1029690778, 1042872064, -1105723034, 1048249845)
		+ W(7, -1115360055, 1008149481, -1104108900, -1127841478)
		+ W(8, -1113844876, -1106926654, 1050188162, -1111804152)
		+ W(9, 1012447989, -1114289465, -1127895515, 1034645781)
		+ W(10, -1110595670, 1032897312, -1107166286, -1110288351)
		+ W(11, 1028149942, 1043016176, 1041406167, -1119471349);
	sum2 =
		W(0, 1049638564, -1122573304, -1097365817, -1120650912) + W(1, 1039129637, -1114566411, 1012096208, -1169058693)
		+ W(2, -1118822370, 1032693677, 1036528332, -1119534724)
		+ W(3, 1055008508, -1092917400, -1124083512, -1127709292)
		+ W(4, -1113518885, 1015256750, 1058022553, -1080721407) + W(5, 1056959548, 1044260765, -1122124802, 1042163670)
		+ W(6, 1059601221, -1081684685, 1056508637, -1099806388)
		+ W(7, 1019567420, -1110975736, 1065544846, -1080284825) + W(8, 1051359763, 1042746095, -1101554026, 1032382474)
		+ W(9, 1035938200, -1096574070, 1044088441, 1033735876)
		+ W(10, 1041548497, -1110809702, 1043980555, -1098850345)
		+ W(11, 1031681402, -1121369890, -1108142320, 1022534793);
	WS(1049904727, -1085461498);
	sum1 =
		W(0, -1114441151, 1047758995, -1092338425, 1054893264) + W(1, -1095327506, 1042581180, 1032673159, -1122472531)
		+ W(2, -1101190388, 1042608805, -1108884127, -1119554504)
		+ W(3, 1027012354, 1048177385, -1096531431, 1050188989) + W(4, -1104987150, 1041262473, 1041600521, -1116753522)
		+ W(5, 1059669870, -1088410395, -1123782065, -1120686401)
		+ W(6, 1035856141, -1105032264, 1063099682, -1084283112)
		+ W(7, 1042263123, -1117364890, 1033107055, -1109908945)
		+ W(8, 1058897901, -1088007491, 1042892731, -1107384925)
		+ W(9, 1031163069, -1104848436, 1049115478, -1096369309)
		+ W(10, 1029697804, -1138499405, -1139856090, -1111353615)
		+ W(11, 1055941567, -1096366496, 1047202227, -1100444021);
	sum2 =
		W(0, -1101934313, 1068410613, 1053392914, 1045964051) + W(1, -1109754454, -1118726053, -1127864237, 1066297935)
		+ W(2, 1047339448, -1107136628, 1023924243, 1029832629) + W(3, -1112463889, 1052441146, -1111508378, 1035674775)
		+ W(4, -1121555471, -1111696115, 1047304216, -1077079694)
		+ W(5, 1044634164, 1046050296, -1111827987, 1036477638)
		+ W(6, -1097499627, -1082290320, -1086326188, -1113442140)
		+ W(7, 1006763480, -1119582249, 1041678537, -1095668928) + W(8, 1053023843, -1135364198, 1034831467, 1024856185)
		+ W(9, -1128505773, -1097722710, 1050833435, 1028981469)
		+ W(10, -1128234727, -1112331027, 1039199998, -1096167330)
		+ W(11, -1112581958, 1028034745, 1032814306, 1017921306);
	WS(-1087326956, 1033622098);
	sum1 = W(0, -1113899675, 1045896801, 1041409216, -1108955706)
		 + W(1, -1104543128, 1041055226, 1035193378, -1161971013)
		 + W(2, -1108871427, 1048600721, -1114333163, -1106692192)
		 + W(3, 1030557818, 1045303135, -1104804773, -1094955846)
		 + W(4, 1045266364, 1039063182, -1119324954, -1095480777)
		 + W(5, 1041468886, 1051943793, -1096626659, -1112593372)
		 + W(6, 1042470612, -1110770003, -1098059200, 1025944442)
		 + W(7, 1048775867, -1107180444, -1117399605, -1109576477)
		 + W(8, 1052050234, -1097508910, 1043056710, 1041486173) + W(9, 1021883592, -1100233714, 1041862393, 1030612641)
		 + W(10, -1122051827, -1114362202, 1035419591, -1122013269)
		 + W(11, 1017834329, -1106071902, 1042839849, -1121041260);
	sum2 =
		W(0, 1008283263, -1111634453, -1112224655, -1121896666) + W(1, 1031996897, -1106176579, -1114415273, 1032259795)
		+ W(2, 1046234660, 1020399084, -1105304684, 1027107696)
		+ W(3, -1114655921, -1123951654, 1039099048, -1139717487)
		+ W(4, 1017260660, -1106922258, 1036167174, -1116061542) + W(5, 1049934438, 1050902690, -1102142181, 1022104088)
		+ W(6, -1111159985, 1039368345, 1003410015, 1039007446) + W(7, 1003551903, -1122048418, 1033204129, -1102899145)
		+ W(8, -1113540553, 1039510238, -1114854307, -1135188919)
		+ W(9, -1122340118, 1024476440, -1117681522, 1032062517)
		+ W(10, 992233789, -1128403972, -1127458940, -1118949310)
		+ W(11, -1122317014, 1033150391, -1113963477, -1125862176);
	WS(1068173014, -1111006676);
	sum1 =
		W(0, 1031049568, -1103201566, 1048004603, -1100468360) + W(1, 1046039773, 1012485196, -1115395480, -1112513259)
		+ W(2, -1117860850, -1173290307, -1123264224, -1127850837)
		+ W(3, 1019703498, -1112438249, -1104427535, 1042677725) + W(4, 1030284012, 1029876039, -1113567107, 1042819653)
		+ W(5, -1083606526, 1064316383, -1122621123, 1036820754) + W(6, 1015808760, 1048780036, -1083053360, 1063571221)
		+ W(7, -1094902185, 1035184606, -1109811912, 1039150546)
		+ W(8, -1090564527, 1060600586, -1103353426, 1024997805) + W(9, 1027899359, 1034094633, -1092330682, 1050639762)
		+ W(10, -1106486660, -1149057999, -1103105894, 1040353932)
		+ W(11, -1095220995, 1054475004, 1034806311, -1123061719);
	sum2 =
		W(0, 1014853092, -1122580470, -1120994367, 1047459793) + W(1, 1064875701, -1132455031, -1120466254, -1114547761)
		+ W(2, 1038991680, 1047680543, 1054395623, 1011283964) + W(3, 1027909890, 1030745116, 1034511499, -1098401240)
		+ W(4, 1045153300, -1108441710, -1117512854, -1119656010)
		+ W(5, 1041066172, -1121088174, -1085223893, 1018552602) + W(6, 1026011110, 1035574738, -1109149586, 1045982327)
		+ W(7, -1084582209, -1106692167, -1110873488, -1120221385)
		+ W(8, 1024235728, 1024310650, -1099510820, 1026658994) + W(9, 1036041188, 1020780404, -1112980367, -1122000913)
		+ W(10, 1029465320, 1023023932, -1115497806, -1122615179)
		+ W(11, 1020521688, 1042402937, -1105747852, 1004613671);
	WS(-1095915991, 979918868);
	sum1 =
		W(0, -1115463727, 1032823819, 1026707497, -1119898332) + W(1, 1026568544, -1121143952, -1137886897, 1037523161)
		+ W(2, -1131549790, 1035412665, -1108324895, -1129452238)
		+ W(3, 1011021190, 1029800132, -1108429845, -1136100063)
		+ W(4, -1138504034, -1120493188, 1011860489, 1043477300)
		+ W(5, -1100874368, -1112838682, 1047390560, -1147670274)
		+ W(6, -1129491953, -1105888052, 1047336484, -1098267600)
		+ W(7, 1036689246, 1028096953, 1007409140, -1114264129) + W(8, 1049886943, -1097768883, 1037432366, -1134502280)
		+ W(9, -1124741815, 1021218335, 1042964547, -1106237874)
		+ W(10, 996441389, -1157333673, -1122228982, 1030459197)
		+ W(11, 1038061098, -1108915952, -1121991146, -1177453050);
	sum2 = W(0, -1121902268, 1020062213, 1034601005, -1096503308)
		 + W(1, 1050858947, -1108630019, -1128394666, -1143339877)
		 + W(2, -1111450467, 1052764693, -1099720262, -1130142915)
		 + W(3, 1039974898, -1102502778, 1034366199, -1095299550)
		 + W(4, 1055940597, -1105816149, -1114856664, 1034423857)
		 + W(5, -1093114037, 1060522961, -1087523263, 1037139152) + W(6, 1032116923, 1030950002, 1027196884, 1057088106)
		 + W(7, -1085850393, 1054601799, -1115163450, 1038088024)
		 + W(8, 1036157347, -1104371255, -1107617878, 1043807995)
		 + W(9, -1112859101, 1036537682, -1130356560, 1031719642)
		 + W(10, -1119144319, -1122652165, -1128925353, 1019282123)
		 + W(11, 1032717961, -1110891365, 1017512699, 1025497552);
	WS(1066530838, 1025703389);
	sum1 =
		W(0, -1120765920, -1132051981, -1129191897, 1042371592) + W(1, 1007708012, -1116932051, 1009297086, -1139418709)
		+ W(2, 1032587897, -1118415861, -1122811552, -1134432681)
		+ W(3, -1122351141, -1109474502, 1057153612, -1120712699)
		+ W(4, -1105657359, -1127344014, 1015487755, -1098776251)
		+ W(5, 1049522345, -1099055070, -1099127683, 1026629028) + W(6, 1015844344, -1109199593, 1041525985, 1049700744)
		+ W(7, -1111888320, -1119906716, -1127613121, -1123764613)
		+ W(8, -1109817213, 1050593755, -1113004743, -1136900213)
		+ W(9, -1133586812, -1121408403, 1010121533, 1036084166)
		+ W(10, 984437698, -1118848634, -1124468594, -1145136640)
		+ W(11, -1107128582, 1038803505, 1036904923, -1123829719);
	sum2 = W(0, -1117430114, 1041261247, 1033806419, -1126022952)
		 + W(1, -1155381873, -1125967712, 1039120940, -1107749198)
		 + W(2, -1097831330, 1041137317, -1127685702, -1116954634)
		 + W(3, -1106133189, -1099018179, 1064523288, 1057416214)
		 + W(4, -1099691831, 1032736142, 1026507473, -1131506304)
		 + W(5, 1045711847, -1092069746, 1026250214, -1120045450)
		 + W(6, 1031550625, -1123617030, -1088977338, 1059767697)
		 + W(7, -1098651966, 1021746164, -1142215401, -1123190888)
		 + W(8, 1052831473, -1088761837, -1118397760, 1028302350)
		 + W(9, 1026312489, -1112954810, -1133526188, 1033531722)
		 + W(10, -1130823120, 990513889, -1139250704, -1137414048)
		 + W(11, -1122137188, -1110686692, 1029280576, -1115066264);
	WS(1066680246, 1040921440);
	sum1 = W(0, -1119730500, -1110280861, -1092083138, 1053565584)
		 + W(1, -1110918026, 1029997623, 1034101258, 1011417444)
		 + W(2, 1031601302, 1054599907, -1143895330, -1113777127)
		 + W(3, -1132236433, 1027753539, -1090607216, 1058261942)
		 + W(4, -1111808624, 1039976245, -1104735450, 1038200908)
		 + W(5, -1078665075, 1061430978, -1099071584, -1112447940)
		 + W(6, 1035235184, 1035268043, -1096046953, 1061610294)
		 + W(7, -1106320677, 1023744576, -1111591250, -1121734057)
		 + W(8, -1093429316, 1056142824, -1105323662, -1145165385)
		 + W(9, 1024518355, 1032771355, -1094352558, 1053165350)
		 + W(10, -1138833863, -1113453535, -1121802685, -1126371080)
		 + W(11, -1102572591, 1055282545, 1035738553, 1031263347);
	sum2 = W(0, 1033717276, 1028210443, 1046091050, -1119519632)
		 + W(1, 1050909876, -1117678961, -1129082210, -1130739278)
		 + W(2, -1085374293, 1026401017, -1110182528, 1042909501)
		 + W(3, -1111396517, -1117565460, 1033058760, -1106338078)
		 + W(4, -1149282827, -1099518378, 1053521042, -1113906791)
		 + W(5, 1062822204, 1066908993, -1081393742, 1044082334)
		 + W(6, -1096499765, -1106119849, -1089123399, 1034907371)
		 + W(7, -1094008056, -1097984366, 1041638909, 1044690885) + W(8, 1003636411, 1054286387, 1035142168, 1040282994)
		 + W(9, -1115028859, 1000486481, 1048601259, -1096894542)
		 + W(10, 1020535023, -1109925208, -1143837439, 1015998178)
		 + W(11, -1103883056, 1041460877, 1028271260, 1021313035);
	WS(-1111691100, -1070453585);
	sum1 =
		W(0, 1040350706, 1032181048, 1054597571, -1090063653) + W(1, -1105977411, -1114266718, -1107702492, 1006352113)
		+ W(2, 1056547603, -1111618639, 1011306277, 1034245578) + W(3, 1045915011, -1101176752, 1059824936, -1087007388)
		+ W(4, 1037450066, -1130610528, -1103582444, -1098104500)
		+ W(5, 1062411659, -1079908657, -1113612402, -1111998342)
		+ W(6, 1036820082, -1111995209, 1062112057, -1098160558) + W(7, 1043358554, 1021846218, 1030081641, -1105752467)
		+ W(8, 1042786985, -1094958736, -1108376090, 1026051990)
		+ W(9, -1112926972, -1111976126, 1050598527, -1104521261)
		+ W(10, 1024420791, 1032139296, 1034445457, 1025879721)
		+ W(11, 1058122296, -1107753094, -1098378691, 1018599200);
	sum2 = W(0, -1102183736, 1044690091, 1025447267, -1103679886)
		 + W(1, 1034791609, -1120655593, 1045283790, -1117083441)
		 + W(2, 1036724432, -1096666126, 1043810354, -1109094473)
		 + W(3, -1099060082, -1109435037, -1100626978, 935783211)
		 + W(4, -1097803022, 1029730663, 1029589699, 1005932683) + W(5, 1066859805, 1061824774, 1034749891, 1023292171)
		 + W(6, -1103326288, -1109954065, -1114206859, -1098480165)
		 + W(7, -1094988176, -1109570093, -1146696619, -1130369043)
		 + W(8, 1024539831, -1113161303, 1050252440, 1012313206)
		 + W(9, -1123727405, -1115538567, -1123732285, -1109149493)
		 + W(10, 1029732207, -1106431920, -1106785078, 1039027144)
		 + W(11, 1040901138, -1129688427, -1105144948, 1015686163);
	WS(-1105638574, -1077878805);
	sum1 = W(0, -1112101313, 1043313362, -1104398291, 1034529536)
		 + W(1, -1120033234, 1017824488, 1025565072, 1041884710)
		 + W(2, -1093904634, 1043314021, -1106696920, 1028280843)
		 + W(3, -1118212870, 1045058176, -1086702118, 1058479092)
		 + W(4, -1128822905, 1038132788, 1034991091, -1099609869)
		 + W(5, 1055637093, 1049084915, -1126325576, -1136921361)
		 + W(6, 1037618766, -1100255017, 1061981800, -1082434966)
		 + W(7, 1050170340, -1125947450, 1033034081, -1097107341)
		 + W(8, 1053455331, -1087005060, 1046293466, -1124008918)
		 + W(9, 1023523536, -1104696333, 1048950646, -1098585534)
		 + W(10, 1042248226, -1126565485, -1143864013, -1128917761)
		 + W(11, 1037339676, -1105402705, 1032623999, -1114937252);
	sum2 =
		W(0, 1040832216, -1125419559, -1166596642, -1076839498) + W(1, -1085872442, 1038631745, 1042032808, -1103788280)
		+ W(2, 1045241846, -1091833274, -1105795498, 1037000995) + W(3, 1039550307, 1043848052, 1051795538, 1035730071)
		+ W(4, -1094587067, -1115278352, 1029252447, -1099123277)
		+ W(5, 1068949095, 1070654393, 1007431650, -1103746979) + W(6, 1040592387, 1047689572, -1094163017, -1096947569)
		+ W(7, -1089767553, 1041143367, -1111709033, -1102650535)
		+ W(8, -1111700665, 1050259859, 1041510738, 1025070825) + W(9, 1050208698, -1105352144, -1117027793, 1051072204)
		+ W(10, -1100476212, -1116523862, -1091595987, 1033340873)
		+ W(11, 1027304955, 1048679723, 1057584085, -1093749689);
	WS(-1095944791, 1081861902);
	sum1 =
		W(0, -1129669743, 1034635115, 1057433596, -1090131839) + W(1, -1120322428, 1008560041, -1116664839, -1122706061)
		+ W(2, 1048908041, -1093164666, 1030509816, 1023557506) + W(3, -1148272609, 1033259121, 1058166921, -1087001587)
		+ W(4, 1035303897, 1013701241, -1121494877, -1124251544)
		+ W(5, 1058746094, -1083481847, 1044900399, -1117995899)
		+ W(6, -1115602986, -1126517523, 1055593874, -1085306808)
		+ W(7, 1041073282, -1116643091, 1028329496, -1128061368) + W(8, 1057488289, -1091485686, 1023593721, 1023656437)
		+ W(9, -1123378150, -1130313237, 1049860117, -1102755929)
		+ W(10, 1034451003, -1164007844, 1027525168, -1119991479)
		+ W(11, 1061071735, -1105495231, -1102595129, 1024551167);
	sum2 = W(0, 1029670841, 999172620, 1042251423, -1105031588) + W(1, 1027957701, 1026093121, -1115575058, -1099435099)
		 + W(2, 1041110640, -1120449287, 1035596553, -1156632055)
		 + W(3, 1042858197, -1139359478, 1058527193, 1010020318)
		 + W(4, 1019832195, -1126960339, -1101600217, 1027943101)
		 + W(5, 1075961547, -1109667225, 1011086126, 1010028142) + W(6, -1117748556, 1048715384, 1073424302, 1057314889)
		 + W(7, 1033526397, 1037810339, 1035438169, -1098854617) + W(8, -1086643829, 1037113027, 975610078, -1115077778)
		 + W(9, -1114535210, 1036336651, -1080060710, -1123725073)
		 + W(10, 1012557694, -1133987070, 1032334939, 1041563473)
		 + W(11, -1067239867, -1100548924, -1095465488, 1036754195);
	WS(-1085172076, 1069147958);
	sum1 = W(0, 1025703205, 1027233863, 1026640114, 1029190628)
		 + W(1, -1111659152, -1139375968, -1141293989, -1106615031)
		 + W(2, 1042354526, -1106775167, -1115892869, 1028377583)
		 + W(3, 1041286826, -1115436126, 1053740861, -1106293072)
		 + W(4, 1035182992, -1156734143, -1119005195, -1112858253)
		 + W(5, 1054852793, -1089581852, 1027435128, -1121669673)
		 + W(6, 1026450561, 1042609938, -1119314307, -1098775605)
		 + W(7, -1137028117, 1034668065, -1117134469, -1122683754)
		 + W(8, 1026745790, -1108063055, 1038436612, -1119291218)
		 + W(9, -1120895076, 1044686038, -1108709290, 1015550627)
		 + W(10, -1112739478, 1027259179, 1025414366, -1117169125)
		 + W(11, 1023400633, -1125318352, 1031194923, -1118201212);
	sum2 = W(0, -1154464437, 1027039233, 1008089899, -1117609897)
		 + W(1, -1118717800, 1027401421, 1004660066, -1115032564)
		 + W(2, 1041471507, 1033488023, 1033628240, -1112728150) + W(3, 1011666487, -1147080182, 1053281755, 1082321679)
		 + W(4, 1046901100, 1012824907, 1016373458, 975139636) + W(5, -1081313755, -1065846603, 1050032460, -1108305112)
		 + W(6, -1117096132, 1025013868, -1118862913, -1122974098)
		 + W(7, -1106934499, 1038621352, 1027534293, -1117310194)
		 + W(8, 1040077608, -1130639872, -1137731251, -1137500513)
		 + W(9, -1118720211, 1025607183, -1134922624, -1143672974)
		 + W(10, -1177023016, -1129758225, 1024315262, -1145025250)
		 + W(11, 993302909, -1114202318, 1017914834, 1025570630);
	WS(1065820150, -1112682631);
	sum1 =
		W(0, -1105640672, -1140735040, -1096706537, 1051064512)
		+ W(1, -1114855500, -1128129890, -1136938293, 1045425461)
		+ W(2, -1095619178, 1046810501, 1041816072, -1108472292) + W(3, 1007936778, 1012508339, -1101065539, 1057299292)
		+ W(4, 1015987827, 1036938130, -1099447769, 1052020966) + W(5, -1083835034, 1054321083, 1049485320, -1101761488)
		+ W(6, 1033964109, -1110876672, -1127256032, 1044289505)
		+ W(7, -1106506396, 1035708141, -1110772895, 1038536521)
		+ W(8, -1101414038, 1042038046, 1031650401, -1113134674)
		+ W(9, -1107676126, 1034428376, -1102412811, 1050440565) + W(10, -1098866309, 1031811610, 948858222, 1041035251)
		+ W(11, -1104437005, -1126355329, 1044647659, -1119496853);
	sum2 =
		W(0, -1116689599, -1104060794, 1023887631, 1047625619) + W(1, -1104647113, 1032108768, 1033662400, 1047714485)
		+ W(2, -1101000300, -1113896185, 1049921725, -1114038586)
		+ W(3, -1110264521, -1106889746, -1123902349, 1058674488)
		+ W(4, -1100964722, -1134500667, -1113832562, 1055059659)
		+ W(5, 1047334183, -1105663288, 1060005487, -1105023935)
		+ W(6, 1034493072, -1089308922, 1060541265, -1079751447) + W(7, -1088726381, 1046968990, 1024644211, 1027816870)
		+ W(8, -1145174230, 1040502911, 1026206299, -1116742649)
		+ W(9, -1105470304, 1032487381, -1099777158, 1059286709)
		+ W(10, -1093081927, 1042150309, 1030330543, 1043118546)
		+ W(11, -1100795602, -1110882655, 1033716355, -1127164330);
	WS(1051219671, 1032040132);
	sum1 =
		W(0, 1024246061, -1110293770, -1098745559, 1035978230) + W(1, 1050231066, -1111943280, 1029213629, -1111062337)
		+ W(2, -1104763504, 1041701281, -1106571859, 1016965359)
		+ W(3, -1142580623, 1026027124, -1097349705, 1051781481) + W(4, 1040668770, 1026054164, 1007533386, 1035026513)
		+ W(5, -1082429923, 1065410260, -1111350032, 1035026168)
		+ W(6, -1132388626, 1036422600, -1083869189, 1060856625) + W(7, -1113287631, 987392292, 1016678619, 1011246152)
		+ W(8, -1095610025, 1057796630, -1122887388, 1019565189) + W(9, 998523489, -1173422083, -1095350964, 1045145830)
		+ W(10, -1109374678, -1110518465, 1023830470, -1130424090)
		+ W(11, -1094623957, 1055180598, 1007169387, 1026555204);
	sum2 =
		W(0, -1123481859, -1131096266, -1107023625, 1040776673) + W(1, -1073406322, 1074128739, 1024186334, -1121050215)
		+ W(2, 1040345453, -1129271163, -1080765061, 1066657253)
		+ W(3, -1181265672, 1023491721, -1110082893, 1044851152)
		+ W(4, -1077100552, 1068015119, -1136581772, -1115413373)
		+ W(5, -1116173932, -1097567007, -1085034176, 1066670217) + W(6, 1007273042, 1036272276, 1041634800, 1051516690)
		+ W(7, -1104398720, -1111857710, -1130526339, -1110187157)
		+ W(8, 1028205855, -1106625929, 1019889879, 1026394385) + W(9, -1134191606, -1123342647, 1036476425, 1035231370)
		+ W(10, -1115096299, 990445793, 1035801320, -1125507188)
		+ W(11, -1124495703, 1007786534, -1105128420, 1030299973);
	WS(-1124324720, 1038677119);
	sum1 = W(0, 1008341069, 1038389179, 1056361124, -1081451931) + W(1, 1047683325, -1130646284, 1031967089, 993181316)
		 + W(2, 1050863173, -1096246661, 1035916906, -1134539381)
		 + W(3, 1023486232, -1145165264, 1054230472, -1086637900) + W(4, 1027831167, 986748732, 1037528348, 991007864)
		 + W(5, 1063082151, -1088130503, 1026128198, 1003368116)
		 + W(6, -1122921519, 1024190949, 1050043692, -1092787999)
		 + W(7, 1020947750, -1115252008, 1029849459, 1044031254) + W(8, 1049660054, -1099337955, 1025351359, 1036720064)
		 + W(9, -1114006089, -1123515526, 1043779649, -1095996120)
		 + W(10, 1037985981, -1116396881, 1035528454, 1052524910)
		 + W(11, -1097977265, -1102904005, -1114005272, 1029521402);
	sum2 = W(0, 1042203848, -1089098687, 1035967917, 1068788369)
		 + W(1, -1095505730, 1025788011, -1133163156, -1098025067)
		 + W(2, 1052777785, -1096461215, -1097973178, -1111191248)
		 + W(3, -1108707706, 1036383110, 1043356562, -1090569807)
		 + W(4, -1127034898, 1023876171, 1027923803, 1058285406) + W(5, 1046924897, -1088764217, 1056967609, 1046203397)
		 + W(6, -1098359820, 1062333205, -1080913711, -1095261121)
		 + W(7, 1040836988, -1107189985, 1043843260, 1048839159)
		 + W(8, -1088408400, -1098396864, 1046078649, -1113219498)
		 + W(9, 1021888231, 1058743586, -1097507024, -1093746709)
		 + W(10, -1111389506, -1110869404, 1023965418, -1078465930)
		 + W(11, 1067915456, 1064748817, -1099047850, 1040158004);
	WS(-1080347734, -1094728165);
	sum1 =
		W(0, -1115633753, 1036436624, -1113632799, 1018734050) + W(1, -1104273977, 1022550473, -1128052610, 1031912915)
		+ W(2, -1104119121, -1104173746, -1115038313, -1128796792)
		+ W(3, 996364134, 1038598142, -1095896866, 1042956529) + W(4, -1098511458, 1027191321, 1027254679, -1114408211)
		+ W(5, 1064358521, 1051156401, 1006576423, -1123707765) + W(6, 1027401421, -1097652239, 1061684826, -1087880029)
		+ W(7, 1037804713, -1125317723, -1125749028, -1109729611)
		+ W(8, 1051089073, -1093838037, 1039011098, -1116369959)
		+ W(9, -1143663749, -1111208674, 1044518984, -1100689848)
		+ W(10, -1157246715, -1130384675, 1017291157, -1118442418)
		+ W(11, 1048577269, -1104163629, -1145301883, -1113863292);
	sum2 = W(0, -1137561210, 1000810292, -1109671087, -1098257975)
		 + W(1, -1113334223, 1010643898, 1008161562, 1017087401)
		 + W(2, -1143663956, -1088410023, 1033424863, -1122425914)
		 + W(3, -1138249722, -1104015266, -1100429296, -1110483119)
		 + W(4, -1113376685, -1120544050, 1032804591, 1045940061) + W(5, 1064636422, 1065774501, 1041401738, 1015219657)
		 + W(6, -1118405314, -1112933693, 1041071232, -1111449957)
		 + W(7, -1107119710, 1028103016, -1149548391, 1040845572)
		 + W(8, -1095622064, -1114533177, 1041680128, -1125778629)
		 + W(9, -1140666666, -1131915309, -1113635957, -1105461804)
		 + W(10, -1114424843, -1127495397, -1121723310, -1125770861)
		 + W(11, -1156294183, -1154727079, -1143304660, -1128411685);
	WS(1062796012, -1081433938);
	sum1 =
		W(0, -1140258862, 1047697940, 1041493798, -1090901033) + W(1, 1032453887, 1008978681, 1019305782, -1137205890)
		+ W(2, 1051824452, -1095124244, 1034552166, 1031420374) + W(3, 1017521696, 1040574503, 1048941321, -1090555023)
		+ W(4, 1032035723, -1124609380, -1128637410, -1131514496)
		+ W(5, 1061551411, -1084025976, 1036871279, 1025475023) + W(6, 1030042599, -1115750349, 1058760695, -1089279069)
		+ W(7, 1041251643, 1016399695, -1140240046, -1114177400) + W(8, 1056942277, -1089170928, 1032547975, 1024887097)
		+ W(9, 1023786378, -1119424318, 1045023263, -1099538126)
		+ W(10, -1117686145, 1002611913, 1027083972, 1025144619)
		+ W(11, 1056967544, -1087239225, 1027338481, 1012109898);
	sum2 = W(0, 1004838046, 1036867068, 1023348885, -1120560082) + W(1, 1032448279, 1025411331, 1009005547, -1112484311)
		 + W(2, -1113333873, 1019969949, -1115333043, -1123665230)
		 + W(3, 1023830295, 1034701810, -1115269491, -1089366478)
		 + W(4, 1028612787, 1024216939, -1121204348, -1131856601)
		 + W(5, -1084820204, -1067115412, -1132671203, 1034346460)
		 + W(6, 1026709605, 1008859907, -1095888786, -1071017431)
		 + W(7, -1112864526, -1116027280, -1145957446, -1129570235)
		 + W(8, 1052224270, 1066362408, 1045423025, -1133553563) + W(9, 1024434367, -1120209470, 1043852487, 1084005284)
		 + W(10, 1025066805, 1032270816, -1122812157, 1023686531)
		 + W(11, 1047863595, 1063525936, 1043035962, -1105823812);
	WS(-1103681710, -1114530079);
	sum1 =
		W(0, 1025861737, -1130912909, -1110124091, 1040844938) + W(1, -1105267215, 1021540535, 1029506744, -1104283663)
		+ W(2, -1117715067, 1046218351, -1121870249, 1032871129)
		+ W(3, 1032236919, -1132593150, 1039686571, -1098764800)
		+ W(4, 1038793978, -1120294159, 1035998951, -1102933559)
		+ W(5, -1097542514, 1059317136, -1096018272, 1036773558)
		+ W(6, -1111043394, 1040041573, -1088677703, 1057765873) + W(7, -1105386706, -1111111618, 1007410083, 992747222)
		+ W(8, -1112367617, 1054923388, -1101946581, 1031187710)
		+ W(9, -1126534927, 1034020670, -1105036246, 1029185429)
		+ W(10, -1122605111, -1138057273, -1123346113, -1119406504)
		+ W(11, 1035634224, 1040434219, -1143951794, 1023823648);
	sum2 =
		W(0, -1133865733, 1041378526, -1102114760, 1040042063) + W(1, 1036263014, -1111718847, -1114357788, 1025611699)
		+ W(2, 1041852494, -1102827642, 1023561916, -1109687464)
		+ W(3, -1113774565, 1057780422, -1090351620, 1041105879)
		+ W(4, -1107817782, 1041802453, -1094909862, -1134317911)
		+ W(5, 1058263821, -1094128428, 1049906607, -1106696300)
		+ W(6, 1041934157, -1084534604, 1059786982, -1121888905)
		+ W(7, -1106476521, 1023851848, 1048238594, -1105040821) + W(8, -1114163954, 1038597269, 1034361268, 1032032810)
		+ W(9, 1041091101, -1096429323, 1034035361, -1139774900)
		+ W(10, 1016844568, -1111010993, 1042608690, -1128928913)
		+ W(11, -1102786592, 1035391793, 1014428216, 1031652841);
	WS(1059372396, -1131086843);
	sum1 = W(0, -1116770958, 1038224730, -1145642197, 1033085351)
		 + W(1, -1114157744, -1129272066, -1133338231, -1110641250)
		 + W(2, 1044958408, -1100693257, 1030339791, 1026076824) + W(3, -1109423369, 1048611339, 1054215533, 1024247225)
		 + W(4, -1106016522, -1113286331, -1142676381, 1026922691)
		 + W(5, 1059821143, -1085100606, 1039898225, -1126911267)
		 + W(6, -1119417706, 1012241985, 1063416476, -1082741615)
		 + W(7, 1046979692, -1119319754, 1016864285, 1033593306)
		 + W(8, -1109435540, -1105005730, -1157274234, -1131274519)
		 + W(9, -1134266292, -1108924145, 1051611888, -1096553463)
		 + W(10, 1033932042, 1018258200, 1026073927, 1029871326)
		 + W(11, 1046037553, -1091104802, 1022970360, -1118999381);
	sum2 = W(0, -1117639690, 1032542252, 1049036492, -1106428174)
		 + W(1, -1100598545, -1124515281, -1126294727, -1105983103)
		 + W(2, 1053585046, -1090074420, -1101677356, 1042350020)
		 + W(3, -1135696947, -1105990346, 1063294224, 1074893281)
		 + W(4, -1088449090, -1128187082, 996342293, -1101410582)
		 + W(5, -1084067012, -1121077701, 1052666358, -1118105649)
		 + W(6, 1025603183, 1031145839, 1030876063, -1079475296) + W(7, 1049420880, 1033189178, -1120264553, 1029472991)
		 + W(8, -1090564487, 1059480413, -1099961793, 1012743453)
		 + W(9, 1034416033, -1125334020, 1047874805, -1099339963)
		 + W(10, 1047783255, 1016211057, 1029227505, 1016716795)
		 + W(11, -1103677712, -1097572114, -1106211131, 1026065323);
	WS(998487488, 1024735998);
	sum1 =
		W(0, 1034787125, -1096711418, -1093645783, 1058035879) + W(1, -1113381667, 1020339515, 1033987197, 1049342972)
		+ W(2, -1089249828, 1055719968, 1033680357, 1037116250)
		+ W(3, -1118966639, -1099717199, -1085775960, 1060189357)
		+ W(4, -1108537011, -1109989161, -1138173503, 1051641300)
		+ W(5, -1083720757, 1061848612, -1102783527, 1046511483) + W(6, 1022076300, 1049184050, -1086133195, 1062875388)
		+ W(7, -1129404117, 1032957443, -1112157509, 1032130968)
		+ W(8, -1087092580, 1007190411, -1110331987, 1011591327) + W(9, 1034213589, 1048086279, -1098046771, 1051240059)
		+ W(10, 1030325168, 1039628088, -1125240838, 1039987293)
		+ W(11, -1087792286, 1039984791, 1051616838, -1135236550);
	sum2 = W(0, 1001577162, 1048277958, -1094388043, -1079852425) + W(1, 1055450674, 1040994203, 1041063142, 1048804575)
		 + W(2, 1061039504, -1095199392, 1054780006, 1035580564)
		 + W(3, -1112011211, 1037383696, 1055288082, -1077655189)
		 + W(4, 1058201467, -1111912036, 1039747614, 1042988518)
		 + W(5, -1084834029, -1103423898, 1071463850, -1100510960)
		 + W(6, -1137882877, -1097597287, -1087507005, 1064308251)
		 + W(7, 1058560116, -1097442490, -1105672858, -1099442373)
		 + W(8, 1044806256, 1065240337, -1080251704, -1090250140)
		 + W(9, 1031849538, -1108394523, -1093629181, 1071708239)
		 + W(10, -1090257183, 1028605291, -1108158369, -1155656404)
		 + W(11, 1059993792, 1061107030, -1073879137, -1106111844);
	WS(-1077135094, 1050907162);
	sum1 =
		W(0, -1132921461, -1117094275, -1098008869, 1043699095)
		+ W(1, -1112620946, -1122422352, -1127648729, 1033699545)
		+ W(2, -1094355462, 1055483630, 1042990903, 1034045812) + W(3, -1124984131, 1030394994, -1089194394, 1053279460)
		+ W(4, 1047326318, 1011377167, -1118007170, 1045491604) + W(5, -1081313730, 1065160347, -1121246728, 1042128328)
		+ W(6, -1117294457, 1039295895, -1088142214, 1056280352)
		+ W(7, -1110840279, -1103632934, -1126452986, 1040542752)
		+ W(8, -1094044967, 1058021117, -1106681402, 1039870541)
		+ W(9, -1124706520, 1018438944, -1098093746, 1041063570)
		+ W(10, -1128181366, -1109127577, -1119126518, 1035722382)
		+ W(11, -1094059515, 1050783700, 1018820533, 1037083890);
	sum2 = W(0, 1003021837, -1110495495, 1016902499, -1116948709)
		 + W(1, 1029108513, -1113320609, 1029225785, 1032075003) + W(2, 993748010, 1041772340, -1097222635, 1042534143)
		 + W(3, -1123823650, -1122423961, 1028513681, 1083263801)
		 + W(4, -1063916786, 1039031010, 1023947681, 1043723635)
		 + W(5, -1096435650, 1074788880, -1074844879, -1104645285)
		 + W(6, -1119691195, -1138212418, -1120166015, 1038793960)
		 + W(7, -1115182489, -1124877446, 1024608678, 1017994477)
		 + W(8, -1119557273, 1017310535, 1021770517, -1131419477)
		 + W(9, -1125446899, -1115371525, 1032720188, 1032034162)
		 + W(10, 1014563122, -1119401015, 1034042378, 1002413729)
		 + W(11, -1115060009, -1118011761, 1027576529, 999290841);
	WS(1048452526, 1015184705);
	sum1 = W(0, -1138645804, -1110581160, -1106270342, 1048623137)
		 + W(1, 1006760678, -1113210911, 1032256237, 1049910352) + W(2, -1113826958, 1036222192, 1042522323, 1029873877)
		 + W(3, -1114005032, -1103860667, -1097372109, 1057099626)
		 + W(4, -1101854594, -1111141177, 1026512560, -1098570768)
		 + W(5, -1087095027, 1061337654, -1106501979, 1024448974)
		 + W(6, -1140244890, -1119844941, -1095003728, 1054485156)
		 + W(7, -1115808507, -1125584845, -1131077462, 1040825100)
		 + W(8, -1095439444, 1049129464, 1027903818, -1111469876)
		 + W(9, 1024452554, 1017183931, -1128526324, 1044366494)
		 + W(10, -1153767820, 1027351533, -1122466948, -1119780203)
		 + W(11, -1106181921, 1040163591, 1034550428, -1117633442);
	sum2 =
		W(0, -1117856953, 1034706164, 999139177, -1115089108) + W(1, 970725323, 1017499348, 1002437005, -1114697961)
		+ W(2, 1016679180, 1009230224, 1019562884, -1131336757) + W(3, -1122373390, -1110151254, 1034965747, 1007700984)
		+ W(4, -1131774725, 1031482891, 1023823647, -1078943314)
		+ W(5, 1069645782, -1105149666, 1038179083, -1120925641)
		+ W(6, -1131092262, -1111296752, 1026082346, 1033262730) + W(7, 1014219446, 1015408436, -1119824143, 1008147760)
		+ W(8, 1005900489, -1142960238, -1130072184, 1001625665)
		+ W(9, -1129026789, 1015792571, -1134452913, 1015281188)
		+ W(10, 1012295392, -1137039581, -1118651901, 1029244251)
		+ W(11, -1121319377, 1026230788, -1122304449, 1019807852);
	WS(1061396972, -1097419696);
	sum1 =
		W(0, 1040610541, -1110826049, -1087862644, -1108888122) + W(1, 1051684947, -1117156776, -1116833412, 1042368898)
		+ W(2, 1000165941, 1058527541, -1102910221, -1135746300)
		+ W(3, 1015657075, -1113808270, -1108964145, 1056284429) + W(4, 1041698836, 1026275932, -1126977972, 1036447253)
		+ W(5, -1085843362, 1053927177, -1107922836, 1041042462) + W(6, 1033993320, 1043284110, -1088558114, 1062174380)
		+ W(7, 991752527, -1137078595, -1125945514, 1048078310) + W(8, -1086794197, 1055390198, -1112253878, 1035139905)
		+ W(9, 1028019732, 1028739112, -1087573386, 1042115560)
		+ W(10, 1039363202, -1118906322, -1120964750, 1052576556)
		+ W(11, -1079810761, 1051035743, 1047360574, 1038370422);
	sum2 = W(0, -1104315228, -1103350409, -1094844926, 1062539510)
		 + W(1, -1096027281, 1014020953, -1117475550, 1024254038)
		 + W(2, -1091235931, -1112967686, 1042482062, -1119186298)
		 + W(3, 1019617669, -1116633366, -1089312569, 1056743222)
		 + W(4, -1129394013, 1028745390, -1096755788, 1042486592)
		 + W(5, -1104902685, 1052266072, 1051055108, -1093268483) + W(6, 1043056626, 1038440719, 1045881224, 1037341407)
		 + W(7, 1044017054, 1054988226, -1097959989, -1097184876)
		 + W(8, -1101957876, 1012499609, -1101861122, -1102938164)
		 + W(9, 1038305467, -1107570984, 1058820589, 1048266302)
		 + W(10, -1105903455, 1026503526, -1121707278, -1092525975)
		 + W(11, 1058872796, -1099676541, 1041661910, -1135013257);
	WS(-1084431788, -1073850193);
	sum1 = W(0, -1121456839, -1130755883, -1131651239, 1035028387)
		 + W(1, 1035837265, -1139076328, 1023326765, -1119027356)
		 + W(2, -1113039213, 1052115068, 1031790055, -1110649673)
		 + W(3, -1111055334, 1007276024, 1041028837, -1087869490)
		 + W(4, 1043959725, -1126605404, -1131954777, 1032958718)
		 + W(5, -1121014635, 1031197854, -1151139494, 1037205893)
		 + W(6, -1127100870, 1051511197, -1080291009, 1064028192)
		 + W(7, -1097929447, 1022476742, -1115233108, 1038479638)
		 + W(8, -1101242168, 1046762496, 1016490449, 1029406204) + W(9, 1032290155, 1033362061, -1095204295, 1048797598)
		 + W(10, 974160200, -1117985767, -1113154576, -1118671783)
		 + W(11, -1109590335, 1048241682, 1033898418, 1016018525);
	sum2 = W(0, 975878233, 1035912472, 1033266404, -1098777501) + W(1, -1115369638, 1024165887, 1027199947, 1026239811)
		 + W(2, -1101163205, -1120465270, 1047867282, -1114558090)
		 + W(3, 1032202892, -1109490583, -1092678923, 1026269275)
		 + W(4, 1048647954, -1127793863, 1011577542, -1099491895)
		 + W(5, 1052721602, 1058060839, 1026065727, -1110013405) + W(6, 989447596, 1027909011, -1115079323, 1022663675)
		 + W(7, -1107120056, -1115589183, -1126785583, -1142596491)
		 + W(8, 1042994318, -1109244590, -1139333782, 1028177183)
		 + W(9, -1112180928, 1032601180, -1117880304, -1139999774)
		 + W(10, -1113232790, -1119188249, 1027448187, 1030066347)
		 + W(11, 999387083, -1113199846, -1128307819, 1010561254);
	WS(1060891500, 1063998119);
	sum1 =
		W(0, 1009319059, 1034817251, 1060685055, -1082111981) + W(1, -1146641530, 1021753903, 1021371624, -1123888698)
		+ W(2, 1050963407, -1089953728, 1042831681, -1158245846) + W(3, 1020060242, 1007070174, 1059880676, -1083685732)
		+ W(4, 1044491976, 1024323659, 1034805925, 1031377177) + W(5, 1058492133, -1080402290, 1049293617, 974645755)
		+ W(6, -1119463744, 1035958587, 1057972187, -1087669949) + W(7, 1044279073, 1017781825, 1029917861, 1040845210)
		+ W(8, 1045390927, -1092052092, 1030870792, 1029410098) + W(9, 1022228167, -1119265271, 1050698442, -1101265316)
		+ W(10, 1040824939, 1009963113, 1028919037, 1041595485)
		+ W(11, 1042995863, -1093474029, -1117179330, 1033823734);
	sum2 =
		W(0, 1043252027, 1031085111, -1089976691, 1015926083) + W(1, 1075090314, -1090475122, 1039685669, -1103588836)
		+ W(2, -1136546874, 1047286193, 1055918010, 1041438201) + W(3, 1021402919, -1094345084, -1106220008, 1049855126)
		+ W(4, -1100279282, -1097421747, 1043798699, -1097680472)
		+ W(5, 1053086422, -1093227067, -1086978538, 1055157984)
		+ W(6, -1106121381, -1098140010, 1041831351, 1030378489)
		+ W(7, -1081018505, 1047503463, -1107286980, -1117022930)
		+ W(8, 1053158416, 1047431201, -1090494906, 1040447738)
		+ W(9, -1116219530, -1111854401, 1043898913, -1088912308)
		+ W(10, 1049023531, 1013873926, -1105216890, -1165267820)
		+ W(11, 1065796563, 1047204695, -1076607098, 1060337257);
	WS(-1071907259, -1110912590);
	sum1 = W(0, -1125193009, 1047025832, -1082520498, 1060301769)
		 + W(1, 1034040338, 1027334603, -1128862543, 1037187527) + W(2, -1091004805, 1051495910, 999732421, 1007930762)
		 + W(3, -1134196340, 1045585380, -1082717575, 1059488668) + W(4, 1034460834, 1012148988, 1030754750, 1046461539)
		 + W(5, -1081098270, 1059029683, 1039737374, -1153534395)
		 + W(6, -1115532794, 1034859053, -1085641231, 1058265227) + W(7, 1026869576, 1008981841, 1035978988, 1044478211)
		 + W(8, -1094770022, 1047385124, 1035505465, -1141674924)
		 + W(9, -1122396199, 1038023446, -1100806498, 1051401113)
		 + W(10, -1108119003, -1131397284, 1030566929, -1115297724)
		 + W(11, -1096364930, 1030610907, 1049444580, 1004145403);
	sum2 = W(0, -1094095783, 1071341959, -1106266089, -1079612356)
		 + W(1, -1096220802, 1053270877, 1046265071, 1041114835)
		 + W(2, -1087794787, -1090342602, -1119797941, -1103321092)
		 + W(3, -1105766507, -1093757522, 1036032273, -1097206613)
		 + W(4, -1100480279, 1044676561, 1052972269, -1096593198)
		 + W(5, 1065807667, 1072329002, -1091841958, -1113258696)
		 + W(6, -1118583019, -1091593516, -1120668367, 1052074546)
		 + W(7, -1107977625, 1022355226, 1048411623, -1091154406)
		 + W(8, -1098744738, 1035089459, 1049018868, -1099949977)
		 + W(9, -1102184915, 1057911473, -1101075731, 1053464489)
		 + W(10, -1101117382, 1048742227, 1063609884, -1073590228)
		 + W(11, 1041493985, 1066861510, -1098841365, -1096064815);
	WS(-1073583387, -1097642521);
	sum1 = W(0, -1113793830, 1040986278, -1123577624, 1026212810)
		 + W(1, 1031641306, -1117606078, 1025630043, 1018743169) + W(2, 1051202676, -1107655120, 1015332695, 1026666645)
		 + W(3, 999171711, 1043520539, -1085714085, 1058537807) + W(4, -1102186706, 999394704, -1113970392, -1126196031)
		 + W(5, -1137921726, -1102760649, 1042214156, -1098706922)
		 + W(6, 1041107242, -1117788829, 1058609607, -1084066799)
		 + W(7, 1050734989, 1028174279, -1126372055, 1023908016)
		 + W(8, -1120709796, 1038867522, -1104026556, -1105230460)
		 + W(9, 1019259188, 999617264, 1049515695, -1105494638) + W(10, 1038371877, -1131430066, -1141619744, 997975216)
		 + W(11, 1048163249, -1113662887, -1118473257, -1117999154);
	sum2 =
		W(0, 1020465344, -1114187457, 1042661620, -1108558660) + W(1, 1022323488, 1024517966, -1122047285, 1035498840)
		+ W(2, -1112200610, 990338200, 1037081003, -1114108748) + W(3, -1132946638, 990134284, 1050532943, -1098817485)
		+ W(4, -1116108394, 1033071181, 1029560286, -1105572872) + W(5, 1053825241, 1046181371, -1112231866, 1024966834)
		+ W(6, -1137208000, -1125836673, 1035380426, 1052951690)
		+ W(7, -1098433232, 1018142458, 1032274109, -1107008827)
		+ W(8, 1041934457, -1099854916, -1115059895, -1114933005)
		+ W(9, 996568996, -1143550666, -1132156656, -1101729420)
		+ W(10, -1106305341, 1025004711, -1139618609, -1133886920)
		+ W(11, -1115627477, -1120597401, -1145950712, -1129654551);
	WS(1066138518, -1093674260);
	sum1 =
		W(0, 1029114768, -1096639483, 1057895286, -1095967018) + W(1, 1030209323, -1115838467, 1016625343, -1107076945)
		+ W(2, 1046373881, -1098130813, 1027610352, 1036809869) + W(3, 1023256234, -1097327813, 1060592282, -1090692519)
		+ W(4, 1010824623, -1116997111, -1135602902, -1112968866)
		+ W(5, 1048700903, -1096019117, -1147523994, 1034515722)
		+ W(6, -1154917052, 1039946769, -1102042589, 1052511498)
		+ W(7, -1107963320, 1025259308, -1126509217, -1145778087)
		+ W(8, -1102212410, 1050590801, -1106421308, 1031910367)
		+ W(9, -1119361423, 1040195377, -1110743776, 1037092318)
		+ W(10, -1114290095, 1015369596, -1120895465, 1035798312)
		+ W(11, -1096085673, 1054517602, -1103975991, 1032370884);
	sum2 =
		W(0, 1020680083, -1098235374, 1040052819, 1039185699) + W(1, -1105651771, 999965284, 1026207298, -1129289080)
		+ W(2, 1000882372, 1041518935, -1108930987, 1025606660) + W(3, -1114338038, 1035819795, -1104532064, 1060121453)
		+ W(4, -1132043948, -1127194998, 1034412140, 1034843888)
		+ W(5, -1096717996, -1098039050, 1059664416, -1123799241)
		+ W(6, -1119552802, 1030579314, 1025849568, -1085068698) + W(7, 1064006582, 1020099573, -1132183796, 1031435954)
		+ W(8, -1126927262, -1105751584, -1108966794, -1130436386)
		+ W(9, 1014438782, -1118921036, 1034356940, 1039772175)
		+ W(10, -1090790505, 1040432622, 1026463590, -1110299389)
		+ W(11, 1043556407, 1060018227, -1083675102, -1098649260);
	WS(-1098394199, 1021768394);
	sum1 =
		W(0, -1106976773, 1047476460, 1035645360, -1107202165) + W(1, -1121988294, 1008308247, 1030592418, -1106379994)
		+ W(2, 1042879449, -1121922344, 986778214, -1140215924) + W(3, -1109895628, 1041629170, 1052123789, -1091385002)
		+ W(4, 1042582852, -1120193402, 1031813276, -1108680996)
		+ W(5, 1053022447, -1090269731, 1042227034, -1127396653)
		+ W(6, -1114022359, 1028771909, -1107385030, -1107044710)
		+ W(7, 1044112989, 973525940, -1124672038, -1123109432)
		+ W(8, 1044862779, -1127679127, -1115617842, -1139398721) + W(9, 980431986, 1035760915, 1023833154, -1107740288)
		+ W(10, 1030134009, 1014367554, -1118216524, 1039049769)
		+ W(11, 1040198899, -1099192133, 1025832513, -1116507498);
	sum2 = W(0, -1098169790, 1055345266, -1106123518, 1039932359) + W(1, -1111072353, 1012808524, 968544056, 1027898732)
		 + W(2, 1021773530, 1036378047, -1123343911, -1132858861)
		 + W(3, -1162122654, 1053687424, -1089212318, 1035540057)
		 + W(4, -1111121590, 1037852727, 1056997121, -1077105818)
		 + W(5, 1068095045, -1098361429, 1044527270, -1103837325)
		 + W(6, 1029158812, 1039110353, -1090252350, 1000425352)
		 + W(7, -1115281069, 1036594354, -1112228820, 1037144043)
		 + W(8, -1124556656, 1050038066, -1114307158, -1134065606)
		 + W(9, 1026696161, 1022799116, -1130232224, -1118055459)
		 + W(10, -1116705210, 1032061348, -1112296199, 1042942743)
		 + W(11, -1104975561, 1040445489, 1023167430, -1114916168);
	WS(1064984812, 1025677564);
	sum1 =
		W(0, 1043884023, -1096329284, -1084712758, 1057726586) + W(1, 1043356655, 1012739123, 1030924649, 1033742216)
		+ W(2, -1103101243, 1046959260, 1018532660, -1131015624)
		+ W(3, 1038396303, -1101734196, -1087209573, 1057188432) + W(4, 1046520365, 1002161670, 1036152448, -1105624932)
		+ W(5, -1086845720, 1061206275, -1114153679, 1044816791) + W(6, 1017544939, 1017123640, -1084903475, 1060371326)
		+ W(7, -1111584053, 1024962678, 1042241831, -1108991823) + W(8, -1087299343, 1055419738, 1028245989, 1043667629)
		+ W(9, -1121467129, 1037154774, -1108220133, 1041931586)
		+ W(10, 994164350, -1114955616, 1047065797, -1096026219)
		+ W(11, -1087523701, 1055087388, 1051664559, 1040331724);
	sum2 =
		W(0, 1043159502, -1104158106, -1085409392, 1067096435) + W(1, -1090972778, -1098664617, -1105699647, 1050222709)
		+ W(2, -1090385012, -1106627676, -1102151020, 1050757442)
		+ W(3, 1038273264, 1025130152, -1106188919, 1052171093) + W(4, -1086083449, 1039140273, 1032147900, 1032288328)
		+ W(5, 1061149199, 1075677902, -1070862987, 1030992941) + W(6, 1048938986, -1103450106, 1050752016, 1075039778)
		+ W(7, -1070168511, 1040257314, -1106879197, -1110143950)
		+ W(8, 1049612036, 1073503496, -1072257998, 1041175752) + W(9, -1128156680, -1098742781, 1057886527, 1075355126)
		+ W(10, -1070483864, 1030488248, 1049056829, -1091104362)
		+ W(11, -1095713225, 1082426924, -1070643407, -1098188298);
	WS(-1072457547, -1104871915);
	sum1 = W(0, 1018087532, -1138749297, -1129333765, 983826087) + W(1, 1026100589, 1007352484, 1014551830, 1036550950)
		 + W(2, -1131367952, 1050222745, -1118152278, -1123482688)
		 + W(3, -1143311830, 1001512248, -1083142279, 1055877542)
		 + W(4, -1106883828, 1034580622, 1031881454, -1098112129)
		 + W(5, 1014989673, 1020808474, 1016760626, -1109491581)
		 + W(6, 1033102921, -1104222042, 1059974718, -1086706094)
		 + W(7, 1045231050, -1122062610, 1020957612, -1104597767)
		 + W(8, 1057969217, -1096646942, 1040528910, -1114916930)
		 + W(9, -1158925470, -1125431314, 1048954301, -1105443081)
		 + W(10, 1027306868, -1147978606, 1015585054, 1042534317)
		 + W(11, 1043242379, -1106542638, -1120756612, -1122581117);
	sum2 =
		W(0, -1120473304, 1034530006, -1151412702, -1124099243) + W(1, 1026058392, -1131120105, -1112539216, 1032795060)
		+ W(2, 1009244103, -1115907580, -1114805763, 1025202928) + W(3, -1132295147, 1046686841, 1037608248, 1020085733)
		+ W(4, -1120554932, 998829429, -1099708049, 1054832981) + W(5, 1050403530, 1033863239, -1154011810, -1131382687)
		+ W(6, -1120301365, -1109933894, 1051005406, -1107650300)
		+ W(7, 1036477609, 1020773937, -1106531527, -1089566811)
		+ W(8, -1106362502, 1030750625, -1122049677, -1143352615)
		+ W(9, -1119309605, 1004612697, -1114169666, -1130967605)
		+ W(10, 1028389062, -1142800679, -1165429700, -1105741108)
		+ W(11, 1026755208, -1146151019, 1026996282, 1016610669);
	WS(1057548396, -1118860492);
	sum1 = W(0, 1024314991, 1024521628, 1019907062, -1109277847) + W(1, 1042186208, -1127185475, 1015464700, 1035643506)
		 + W(2, 1035362560, 1033181378, 1019936830, 1015346289) + W(3, 1033090170, 1022826491, -1102305323, 1038789717)
		 + W(4, 1047455161, 1015056043, 1024068436, 1044765945) + W(5, -1077384746, -1093016121, 1050623422, 1035221881)
		 + W(6, 1023937802, 1040253828, -1095947197, 1047039772) + W(7, 1039235079, 1019339797, 1007695803, 1032416458)
		 + W(8, -1110302756, 1032628147, 1012944520, 1030260028) + W(9, 1026830221, 1031527745, -1110046895, 1032291149)
		 + W(10, 1025595072, -1124358344, -1142835770, 1041535598)
		 + W(11, -1106773417, 1038601945, 1031404576, 1039118899);
	sum2 =
		W(0, 1028948662, -1119520873, 1040692087, -1099276378) + W(1, 1042585669, -1108959122, -1108748842, 1035535229)
		+ W(2, -1128105382, -1125068566, -1119570187, -1105777938)
		+ W(3, 1035054379, 1034598190, -1105801492, 1046560183) + W(4, -1104135640, 1040780747, -1114955281, 1040844095)
		+ W(5, 1058969109, 1035247795, -1104363062, -1115696651)
		+ W(6, -1123628391, 1017632867, -1140061979, 1037021603)
		+ W(7, -1119904127, -1122498951, 1033670708, 1028317650)
		+ W(8, -1098716294, 1041621971, -1109815486, 1039115990)
		+ W(9, -1113438145, -1152158269, -1100355456, 1042440154)
		+ W(10, 1033417138, -1102421790, 1009774019, 1033306906)
		+ W(11, -1097137530, 1045186907, -1096381982, 1043903068);
	WS(-1111617372, -1089239798);
	sum1 =
		W(0, -1120946745, -1109363280, 1036859267, -1107333692) + W(1, -1131126919, 1028471724, 1043411666, -1105933140)
		+ W(2, -1100282243, 1036658471, 1046725686, -1102252305)
		+ W(3, -1105344783, -1122482989, 1033736099, -1096910672)
		+ W(4, -1138971218, 1048148056, 1034980559, -1097138762)
		+ W(5, 1040067055, 1063625005, -1100591479, -1115573502) + W(6, 1035032490, 1028445691, -1085774908, 1059841631)
		+ W(7, -1101046354, 1018704810, -1102176538, 1038047807) + W(8, 985367106, 1050659758, -1099856795, 1038410359)
		+ W(9, 1042691462, -1104930291, -1095561837, 1056206133)
		+ W(10, -1114722211, -1104725204, -1106084756, 1036625252)
		+ W(11, -1105930796, 1039222942, 1033845467, 1032806392);
	sum2 =
		W(0, 1032901751, -1102980188, -1097455677, 1019096213) + W(1, 1032175116, -1112661460, -1107914664, 1034775565)
		+ W(2, -1079544271, -1123759676, -1101940532, 1048109574)
		+ W(3, 1029069579, -1107463876, -1107584024, 1039965269) + W(4, 1028816201, -1102645998, 987500422, -1115674720)
		+ W(5, 1066142773, 1060530292, 1036298034, 1048822254) + W(6, -1107918292, -1122769714, 1049477386, 1039765158)
		+ W(7, -1100641824, -1106440053, 1041931397, 1028640927)
		+ W(8, -1110827944, -1133849713, 1041944181, -1113520406)
		+ W(9, -1106970712, -1133982193, 1040943686, -1110406142)
		+ W(10, -1113302080, 1032469881, 1026585516, -1112107626)
		+ W(11, 1033119735, -1129682772, 1007346649, -1114426196);
	WS(1055684951, -1075449937);
	sum1 = W(0, 1025203701, 1021145317, -1089325052, 1050955910) + W(1, 1044060206, 1023449767, -1109225282, 1041132226)
		 + W(2, -1098148265, 1048074946, -1122722677, -1117792831)
		 + W(3, -1105594014, 1045336591, -1089314051, 1059061644)
		 + W(4, -1138312640, 1024771419, -1102495686, 1048290762)
		 + W(5, -1085251962, 1063401377, -1135340574, 1034487612)
		 + W(6, -1115277256, 1046212734, -1086898788, 1058388246)
		 + W(7, -1108206354, -1122363216, -1131312361, 1033816821)
		 + W(8, -1089905605, 1057949871, 1012872015, 1023079171) + W(9, 1003392922, 1042625602, -1090587428, 1049257380)
		 + W(10, 1013091209, -1119440554, -1119401549, 1032304674)
		 + W(11, -1086086859, 1056447675, 1030899626, 1029355212);
	sum2 =
		W(0, 1061277558, -1075680192, 1064394375, 1041412946) + W(1, -1097187807, 1043650757, 1070915797, -1078675502)
		+ W(2, -1099840736, 1036217426, 1041322393, -1128025338)
		+ W(3, 1077465728, -1072669743, -1080083122, 1053075748)
		+ W(4, -1098777830, -1113957037, 1077005703, -1071891757)
		+ W(5, -1110541808, 1035413026, -1105806062, 1028555409)
		+ W(6, 1067272551, -1079654744, 1034295344, -1098463344) + W(7, 1042040059, 1035679275, 1035834095, -1094224921)
		+ W(8, 1034313258, 1050839735, -1099205009, -1113787473)
		+ W(9, -1140563054, -1124876273, 1044374977, 1012713199)
		+ W(10, 1043077130, 1015942004, -1101597023, -1106967769)
		+ W(11, 1056268760, 1033733408, -1097742853, 1036121231);
	WS(-1084991020, -1093321377);
	sum1 =
		W(0, -1124603198, 1041431403, 1058092855, -1087194206) + W(1, 1031898965, 1027465426, 1020905181, -1106261797)
		+ W(2, 1050746614, -1093664550, 1020373118, 1019387090) + W(3, 1034567442, 1012534679, 1060858482, -1086211050)
		+ W(4, 1037199077, 942151344, 1033810210, -1100435893) + W(5, 1063338984, -1081371861, 1028138434, -1130539845)
		+ W(6, 1026468027, -1113177704, 1057782107, -1091610836) + W(7, 1041359812, 1019123574, 1034346016, 1029015460)
		+ W(8, 1050350895, -1090363161, 1026545296, 1032894586) + W(9, 1012576759, -1109083497, 1047981412, -1099126963)
		+ W(10, 1017607178, 1018549369, 1040898454, 1045957208)
		+ W(11, 1051078083, -1088769118, -1114891854, 1024075622);
	sum2 =
		W(0, 1049096145, -1096421724, -1104462777, 1019605429) + W(1, -1107039596, 1039363330, 1050639335, -1100344181)
		+ W(2, 1044471716, 1054069324, -1112798845, -1113551308)
		+ W(3, 1060252300, -1085369111, -1101216805, -1124780213) + W(4, 1041817400, 999612981, 1068716746, -1076762820)
		+ W(5, 1050347336, 1025609425, -1099054195, 1018249637) + W(6, 1070836883, -1073687271, 1052234046, -1096692411)
		+ W(7, 1029953841, 1028531297, 1071114171, -1075542147) + W(8, 1009296899, 1043747806, 1030832137, -1109453871)
		+ W(9, 1069477538, -1076870984, 1047758574, 1026561745)
		+ W(10, -1135279155, 1027426027, 1068968491, -1078719402)
		+ W(11, -1114781860, 1035243068, -1140937749, -1125031723);
	WS(-1082530796, 1061926473);
	sum1 = W(0, -1111745736, -1107298323, 1048819916, 1033356744)
		 + W(1, 1034157517, -1119982339, 1030277984, -1127531019)
		 + W(2, 1039611697, -1113172467, -1127895905, 1009757802)
		 + W(3, -1123296661, -1109831840, 1058045501, 1035918242)
		 + W(4, -1146238814, -1125062126, 1039021467, -1118701125)
		 + W(5, -1099048749, -1088898044, -1099659681, 1039341706)
		 + W(6, -1130604760, -1101933527, 1052265202, -1125679275)
		 + W(7, 1032846000, -1111731430, 1012520514, -1114851579) + W(8, 1034215157, 1029808585, 1005542493, 1016627083)
		 + W(9, -1112767704, 1016124742, 1037161440, -1110952702)
		 + W(10, 1024904046, -1137100912, 1017586258, -1131932512)
		 + W(11, 1010862879, 1040689749, -1114167271, -1130467695);
	sum2 = W(0, -1123675689, 1027790609, -1107220732, -1138688370)
		 + W(1, -1114685917, -1131813881, 1025856461, -1115257125)
		 + W(2, -1103597907, 1036222096, -1104487390, -1138958066)
		 + W(3, -1129839981, 1041635489, -1083432255, -1099581339)
		 + W(4, -1113019592, 1015980625, 1039506778, -1087170514)
		 + W(5, 1074899174, 1052206445, -1103205528, 1015820001)
		 + W(6, -1111122039, 1054414527, -1087814585, 1033877978)
		 + W(7, -1114160943, 1023501105, -1108253250, 1040911707)
		 + W(8, -1119836905, 1035305654, -1128600489, -1135082354)
		 + W(9, 1042547871, -1107819629, -1108795814, 1040418607)
		 + W(10, -1113593105, 1028405761, 1023517501, -1119501461)
		 + W(11, -1120345851, 974999585, -1136105250, 1023691837);
	WS(1064809580, 1026007555);
	sum1 = W(0, -1117346201, -1139810490, 1018638922, 1046259126)
		 + W(1, -1110265860, -1107316166, 1012678303, -1117193870)
		 + W(2, 1041509643, -1116046893, -1107022182, 1042684025)
		 + W(3, -1112794575, 1032058104, -1089321581, 1058768682)
		 + W(4, 1049529906, -1107194416, 1024755966, -1127734554)
		 + W(5, -1106321711, 1057441571, -1097674775, -1115653262)
		 + W(6, -1119597108, 1040786347, 1042250009, -1088983804)
		 + W(7, 1052962187, -1115453338, -1109792204, -1106953519)
		 + W(8, -1136225478, 1052663642, -1105006210, -1104239151)
		 + W(9, 1039580268, -1120656619, -1140389406, 1033398978)
		 + W(10, -1138416249, 1026892022, -1109340249, -1123630216)
		 + W(11, 1031754384, 1030125211, -1114619763, -1113265368);
	sum2 = W(0, 1002173025, -1126476274, 993251281, 1035289805) + W(1, 1026092616, -1119256919, 1022454821, -1112202702)
		 + W(2, 1027055467, -1110248161, -1106697397, 1035602798)
		 + W(3, -1114052781, 1040267060, -1106967376, 1050537246)
		 + W(4, 1051631259, -1119463370, 1026488668, -1105276944)
		 + W(5, 1037292044, -1103163514, -1119693560, -1109176262)
		 + W(6, 1024785122, 1041996701, 1032247852, 1036995069) + W(7, 1026699348, -1123291766, -1114947733, 1024974628)
		 + W(8, -1103384730, 1044720036, -1113586574, -1103668424)
		 + W(9, 1041552522, -1106672600, 1024347316, -1136575544)
		 + W(10, 1012871948, -1104716490, -1114686018, 1014734543)
		 + W(11, 1038837578, 1011597497, -1113050536, -1124038001);
	WS(1065652022, 1032044813);
	sum1 =
		W(0, 1008146233, 1024151812, -1109382253, 1046726755) + W(1, -1118504831, -1145994760, -1138253430, 1033154018)
		+ W(2, -1111423088, -1114751985, 1030270670, 1011776865)
		+ W(3, -1111490857, 1037025524, -1089787453, 1060185520)
		+ W(4, -1108385813, 1031075253, 1034343482, -1098142828)
		+ W(5, 1056996567, -1102691401, 1034117937, -1115595081)
		+ W(6, 1027957290, -1093711910, 1064926206, -1084615165) + W(7, 1042611828, -1141498448, 1037589943, 1019326054)
		+ W(8, 1020462798, -1096112169, 999245356, 1030480467) + W(9, 1035138662, -1137243780, 1028825917, -1123985530)
		+ W(10, -1106962907, 1020535720, -1130048270, 1033030167)
		+ W(11, 1017317515, -1105819364, -1131349303, -1161641125);
	sum2 = W(0, 1006780909, 1018874621, -1118402441, -1125742470)
		 + W(1, 1022906649, 1002124531, 1032029355, -1106542042)
		 + W(2, -1123089851, 1042324218, 1032351097, -1127943559)
		 + W(3, 928839112, -1114343998, -1111882995, -1150379126)
		 + W(4, 1030201786, -1112138839, -1118040285, -1106692361)
		 + W(5, 1057618964, 1059562898, -1096401122, 1036092239)
		 + W(6, -1112805367, 1043467647, -1114692462, -1124030112)
		 + W(7, -1101041619, -1119061832, -1105940221, 1041450718)
		 + W(8, 1035656455, -1096899429, -1105376866, 1038704957)
		 + W(9, 1025941308, 1036583459, -1122657152, -1115452253)
		 + W(10, 1025207396, -1115257437, 1031169874, -1106475204)
		 + W(11, -1181112366, -1108009053, -1117532473, 1040262599);
	WS(1060219372, -1086892801);
	sum1 =
		W(0, -1103145773, 1039153858, 1051640744, -1098525574) + W(1, -1104573181, 1018968139, 1041685441, -1139059104)
		+ W(2, -1111094658, -1114399172, 1034492410, -1114173214)
		+ W(3, -1114046300, -1139626983, 1060139625, -1105262039)
		+ W(4, -1112320535, -1114750605, -1105288038, 1051743245)
		+ W(5, 1048845947, -1084251893, 1048366229, -1119683574) + W(6, 1036049319, 1005204005, 1056234019, -1132035760)
		+ W(7, 1045757805, -1113866359, -1105447101, -1096900831)
		+ W(8, 1058595229, -1097183901, -1102598303, -1132035040)
		+ W(9, -1153064218, 1006778518, 1030114274, -1095492788)
		+ W(10, 1044243314, 1021887633, 1037687846, -1097346218)
		+ W(11, 1052830405, -1105878061, -1114955456, -1107291810);
	sum2 =
		W(0, -1116149857, 1025241726, -1099180395, 1043244905) + W(1, -1108018378, 1036684654, -1115656995, 1004099725)
		+ W(2, -1094029030, 1042198638, 1030698655, -1113978987) + W(3, 1030898684, 1025926274, 1029208805, 1050305603)
		+ W(4, -1105752531, 1030311314, -1101937257, 1029996270)
		+ W(5, -1093188603, 1051892024, 1032179392, -1143836228) + W(6, -1172884346, 1015423640, 1043486640, 1010118001)
		+ W(7, 1042453668, -1107174775, -1108962642, -1098527410)
		+ W(8, 1057927618, -1111697287, -1110311603, 1032971351)
		+ W(9, -1122887710, -1102965987, 1033678913, -1106879588)
		+ W(10, 1043859461, -1114814873, 1035380843, -1099100919)
		+ W(11, 1054675670, -1115267941, -1124505249, -1114563702);
	WS(1054285911, 1050558006);
	sum1 =
		W(0, -1123510162, 1038924416, -1103298920, 1049975562) + W(1, -1107117058, -1132690963, -1131523010, 1041880394)
		+ W(2, -1093800836, 1050884477, -1103773453, 1013663344)
		+ W(3, -1131464621, 1042834130, -1095165898, 1056805171) + W(4, -1101616339, 1008580322, 1019709806, 1022473868)
		+ W(5, 1057683379, -1101108530, -1121085405, -1112183179)
		+ W(6, 1029482925, -1100861061, 1065493943, -1084744157)
		+ W(7, 1044641696, -1107880231, 1019519396, -1099456110)
		+ W(8, 1059660975, -1084827161, 1037612741, -1118057053)
		+ W(9, 1008876867, -1103795177, 1052993120, -1096422344) + W(10, 1041661496, -1120002940, 990268585, 1023983666)
		+ W(11, 1049686449, -1102767109, -1112995616, -1125681410);
	sum2 = W(0, -1122499415, -1115660402, 1019721643, 1052675919)
		 + W(1, -1134010714, -1107636671, -1135750526, -1103885919)
		 + W(2, -1163427536, -1111228057, -1097257542, 1043515230)
		 + W(3, 1025808744, -1107570715, 1050733408, 1050715774)
		 + W(4, -1097200131, -1113330231, 1004729468, -1109043837)
		 + W(5, 1068391994, 1068640266, -1098019427, 1035061875)
		 + W(6, 1038371609, -1101018403, -1088555463, -1109791041)
		 + W(7, -1104872484, 1015805682, 1025309219, -1106866200)
		 + W(8, 1029079067, -1082318320, -1103711089, -1134559274)
		 + W(9, 1037233345, -1100735475, 1034253450, 1048468038)
		 + W(10, -1096395820, 1043601518, -1107252608, 1049544712)
		 + W(11, -1147071004, -1092391889, 1032346912, -1139706642);
	WS(-1090663639, -1077388844);
	sum1 =
		W(0, 1018174482, -1118693311, -1093711755, 1049109025) + W(1, 1040639418, 1010315758, -1160081154, 1029100670)
		+ W(2, -1098783931, 1046071575, 1021012498, -1115518041)
		+ W(3, -1125628059, -1120731528, -1088582516, 1052420297)
		+ W(4, -1106387497, -1181480889, -1132569784, -1106887239)
		+ W(5, -1095941442, 1068562223, 986381179, 1034527238) + W(6, -1117916196, -1106415899, -1087125152, 1064382514)
		+ W(7, -1096200966, 974332196, -1117849353, -1097169074)
		+ W(8, -1094690684, 1058209900, -1116837948, 1015836076)
		+ W(9, 1021610031, -1146324700, -1097735927, 1048904111)
		+ W(10, 1025702951, -1123641014, -1122253105, -1168966176)
		+ W(11, -1093052224, 1056110513, -1121509238, 1025570188);
	sum2 = W(0, 1034436941, -1094381136, 1032181918, 1038416019)
		 + W(1, -1157362266, 1040127243, -1113720588, 1042206203)
		 + W(2, 998633097, -1112936962, 1041189037, -1108577062) + W(3, 1024698569, -1096498964, 1057336919, 1044225483)
		 + W(4, -1114037642, -1122557473, -1106229774, -1082651758)
		 + W(5, 1076874404, 1035551973, 1029476436, 1033287923) + W(6, 1036635696, -1065300211, 1081990850, 1041430251)
		 + W(7, 1035032611, 1024588020, 1046234567, -1070759890) + W(8, 1049370102, 1045207615, 1036601034, 1015731519)
		 + W(9, 1052080385, -1090746117, -1114040834, 1038285588)
		 + W(10, -1115422836, -1155116306, 1034351318, -1089089289)
		 + W(11, 1035723536, -1119691531, -1130950394, 1031958369);
	WS(-1080363926, -1071486509);
	sum1 = W(0, 1035667824, -1117755862, 1058850627, -1089812638)
		 + W(1, -1119781738, 1033333673, -1106562756, -1102851061)
		 + W(2, 1044522508, -1098855847, -1124105919, -1122920906)
		 + W(3, 1048836261, 1026770536, 1060900423, -1094273901)
		 + W(4, -1136163052, 1034167779, -1099668353, -1096598034)
		 + W(5, 1062774732, -1081351512, 1019768789, -1100720585)
		 + W(6, 1041756943, -1111989629, 1060314417, -1091724133)
		 + W(7, 1036217472, 1023569595, 1034350288, -1117155588) + W(8, 1058954340, -1097309107, 1034476769, 1037864032)
		 + W(9, -1111757455, -1106686285, 1047827972, -1089979637)
		 + W(10, 1034808863, -1108224543, 1036008540, -1110305168)
		 + W(11, 1058323473, -1097705308, -1112569431, 997120104);
	sum2 =
		W(0, -1130221439, 1026473921, -1098631230, 1059210683) + W(1, 991949852, -1088875775, 1039521143, 1040027805)
		+ W(2, 1049962270, 1037922688, -1128609979, 1043008084)
		+ W(3, -1106623296, -1103850305, -1102633929, 1032319554)
		+ W(4, 1032322677, -1081254616, 1040812416, 1044422007) + W(5, 1053913409, 1075309200, -1093367457, -1078110278)
		+ W(6, -1108121630, 1033782288, 1041179127, 1051007822)
		+ W(7, -1128820939, -1087823621, 1011405671, -1112409330)
		+ W(8, -1118313372, -1114991064, 1042490244, -1085620101) + W(9, 1024610419, 1042204829, 1033589003, 1064519547)
		+ W(10, -1108707286, 1038944538, -1120568012, 1007920671)
		+ W(11, -1105557487, 1041664007, -1108726636, -1097283302);
	WS(-1085146860, -1078432897);
	sum1 =
		W(0, 1000247468, -1149696569, 1046594056, -1105608437) + W(1, 1029982264, -1128935441, 1037132754, -1105005939)
		+ W(2, 1049101493, -1092242085, 1035020227, -1114749360) + W(3, -1107087079, 1047641075, 1036712721, 1034057408)
		+ W(4, 1000135432, 1041253327, 1043827999, -1094624073)
		+ W(5, 1056540903, -1091288646, -1097712673, -1098691603)
		+ W(6, -1105171356, 1038438012, 1056427897, -1092984875) + W(7, 1048401189, 1031740017, 1034542459, -1098392071)
		+ W(8, 1052522438, -1099696227, -1113847620, -1124493285)
		+ W(9, -1139389265, 1037791108, 1039493090, -1123704450)
		+ W(10, 1041969240, 1035876258, 1019250012, -1111893867)
		+ W(11, 1053002294, -1096292923, -1109486882, -1117863020);
	sum2 =
		W(0, 981650725, 1022634928, -1122722467, -1134931805) + W(1, -1114801830, 1035155349, -1123188651, -1141995321)
		+ W(2, 1043118137, 1038372119, -1108690895, -1113558499)
		+ W(3, -1132394336, -1159373413, -1111962066, -1088039805)
		+ W(4, 1059960197, -1123558064, 1019312288, 1040593594)
		+ W(5, -1085264893, -1062981933, 1086226578, -1122982849)
		+ W(6, 1007032529, -1125839148, 1035586791, -1088420516) + W(7, 1052041256, 1041973847, 1019035800, -1144628769)
		+ W(8, 1030456162, 1033594923, -1121903247, -1112866008)
		+ W(9, -1139057577, -1130558040, 1025167346, -1132235322) + W(10, -1127116104, 999416881, 994405618, 996479090)
		+ W(11, -1121727683, -1141102409, 1010205301, 1015327588);
	WS(1065314092, 1028007882);
	sum1 =
		W(0, 1031315399, -1118910333, -1110071882, 1027958726) + W(1, -1132049297, 1030345978, 1009229913, 1044274103)
		+ W(2, -1091088835, 1049048403, -1098774521, 1015648546)
		+ W(3, -1129846167, 1040482617, -1081937298, 1058342964) + W(4, -1097400260, 1033820695, 1030512684, 1028502523)
		+ W(5, 1057125791, 1041882615, -1128387300, -1123750794)
		+ W(6, 1027211107, -1098008831, 1063505604, -1081007746)
		+ W(7, 1042307230, -1119357859, 1024491495, -1114626726)
		+ W(8, 1056913060, -1094994912, 1046624506, -1108219417)
		+ W(9, -1133667543, 1030034106, 1045615294, -1103714125) + W(10, 1018202602, 1021380405, 1020076159, 1035646611)
		+ W(11, 1046315392, -1120947018, -1116178789, -1113806211);
	sum2 =
		W(0, -1105494348, 1051114204, -1106549278, -1106413411) + W(1, 1026636954, -1101805730, 1042860341, -1095282678)
		+ W(2, -1095274416, -1115620988, 1032482885, -1123651604)
		+ W(3, 1034523914, -1099570184, -1097084890, -1100406176)
		+ W(4, -1103782738, 1033985372, 1032509803, -1092355888) + W(5, 1068351366, 1061966336, -1111829172, 1041181693)
		+ W(6, 1037500440, -1093487707, 1045336627, 1064976080)
		+ W(7, -1099957245, -1105149847, -1136462181, -1101634066)
		+ W(8, -1093371043, -1095768559, 1011878641, 1041978329) + W(9, -1115571726, 1038218158, 1025607496, 1051011462)
		+ W(10, -1122142689, -1106959075, 1030953968, -1144657738)
		+ W(11, -1098135458, -1103066203, 1046841453, 1034424520);
	WS(-1100053422, 1042143034);
	sum1 =
		W(0, -1121193300, 1038907933, 1037214192, -1104157285) + W(1, 1003265009, 927491180, 1027006179, -1101648146)
		+ W(2, 1052804861, -1116788520, -1105088109, 1036085839)
		+ W(3, -1116784408, 1051061595, -1092953078, -1115727182)
		+ W(4, 1044603252, -1112320669, -1124403186, -1096312949)
		+ W(5, 1063691363, -1094770533, -1110178331, -1132796507)
		+ W(6, 1032959000, 1021329739, 1057610578, -1085255924) + W(7, 1042273837, -1129217311, 1036096698, -1104405590)
		+ W(8, 1046101531, 1032460934, -1099699080, 1029210945) + W(9, -1106874909, 1032316755, 1033832353, -1101777344)
		+ W(10, 1042741769, -1111566277, -1140087089, 1026338531)
		+ W(11, 1044117027, -1123976854, -1110400285, 1023324661);
	sum2 =
		W(0, -1141740532, -1127364827, 1016858659, 1019476887) + W(1, 1027610232, -1114104878, -1141563308, -1115378106)
		+ W(2, 1014774982, 1033910688, -1098709711, 1038463125)
		+ W(3, -1146742484, -1097895309, 1061549017, -1098904537)
		+ W(4, 1048121474, 1009723338, 1037326381, -1089066292)
		+ W(5, -1086943216, -1087533486, 1044386108, -1128378528)
		+ W(6, -1100634945, 1074712949, -1081904953, 1051894188)
		+ W(7, 1035948687, -1114075451, -1112991637, 1036278807) + W(8, 1016249563, -1105464222, 1034738839, 1023041183)
		+ W(9, 998071241, 1023404119, -1104500239, 1039001405) + W(10, -1111082062, 1028418264, 1028661660, 1032269699)
		+ W(11, -1118089334, 1002948788, 1032376859, -1116656881);
	WS(1064553004, -1122811923);
	sum1 =
		W(0, -1129171987, 1031404000, 1045766677, -1102182210) + W(1, 1024429036, -1144455651, 1032276908, -1105326008)
		+ W(2, 1049463355, -1094389820, 1026361994, -1121595412) + W(3, -1113233767, 1049333812, 1036005443, 974120215)
		+ W(4, 1035186995, 1034062296, 1041762428, -1095271692)
		+ W(5, 1059787495, -1088583546, -1095666629, -1100003363)
		+ W(6, -1110071667, 1021654775, 1057980603, -1092394330) + W(7, 1048809333, 1024774373, 1027123610, -1101813124)
		+ W(8, 1052117804, -1097358280, -1132328890, -1125809241)
		+ W(9, -1123823416, 1034262350, 1041561742, -1111517243)
		+ W(10, 1043990330, 1035275874, 1026480898, -1114787413)
		+ W(11, 1051913520, -1097569834, -1107060706, -1116630377);
	sum2 =
		W(0, 1027128731, -1118374135, 1034513610, -1123174378) + W(1, 1026835315, -1114420605, -1153474964, 1014938475)
		+ W(2, -1107487108, -1123472496, 1026726549, 1026647445) + W(3, 1032141903, -1106631533, 1042187602, 1054134699)
		+ W(4, -1092438474, 1008281595, -1114194268, 1049333862)
		+ W(5, -1091768288, 1082046784, -1066065893, 1032174407) + W(6, 1010972171, -1117272233, 1029258819, 1048672371)
		+ W(7, -1108402828, -1107223380, -1128303982, 1026850075)
		+ W(8, -1112584656, 1015595275, -1129520676, 1020663133)
		+ W(9, 1020076945, -1130317298, 1019094573, -1143083862)
		+ W(10, 1012988295, 1016020771, -1125252319, 1023253865)
		+ W(11, 1030375545, -1112246350, 1033146096, -1120189048);
	WS(1066855734, -1119441794);
	sum1 =
		W(0, -1127562022, 1039804281, -1090674092, 1057948125) + W(1, -1113289318, 1040603681, -1123770274, -1106380690)
		+ W(2, -1096623933, 1041520634, -1102744925, -1104646487)
		+ W(3, -1115364812, 1049486942, -1088928155, 1058254390)
		+ W(4, -1126493725, 1030330554, -1108591004, 1052921753)
		+ W(5, -1086271011, 1066610309, -1125400685, 1047144630)
		+ W(6, -1109630903, 1002857256, -1088126629, 1047590014)
		+ W(7, -1097419497, -1118729135, 1012450637, 1049080999) + W(8, -1098448030, 1058670697, 1027654745, 1040353710)
		+ W(9, -1111453929, -1123146086, -1095526376, 1020669183)
		+ W(10, -1103558716, -1110153949, -1112819014, 1045715313)
		+ W(11, -1090620137, 1057080301, -1122765265, 1038000005);
	sum2 =
		W(0, 1029773001, 1045848843, -1100354950, 1042255280) + W(1, 1031741567, -1106457511, -1098400772, -1098127734)
		+ W(2, 985414438, -1114969170, -1101857955, -1121665039) + W(3, 1049403575, 1040542896, -1094506611, 1044461531)
		+ W(4, 1033605854, -1106685198, -1106957817, -1113384065)
		+ W(5, 1065317808, 1063282493, -1099888837, -1090380876)
		+ W(6, 1040180418, -1098054809, -1102424534, -1111953320)
		+ W(7, -1148110913, -1097784009, -1125940042, 1051521525)
		+ W(8, 1038107076, 1052337139, -1125555808, 1010307405)
		+ W(9, -1121768997, -1098090743, 1030043463, -1098581045)
		+ W(10, 1034608926, -1105861523, 1035657430, 1035815778)
		+ W(11, -1104826760, 1052586351, -1105779304, -1121200133);
	WS(1024108216, 1053619151);
	sum1 =
		W(0, -1110237276, -1117217830, 1029541828, -1116974327) + W(1, 1028000106, 997960357, 1036125123, -1104025987)
		+ W(2, 1035829669, 1029841740, -1125285423, -1115997186)
		+ W(3, -1105593599, 1053313098, 1040682969, -1093167724)
		+ W(4, 1031701731, 1020700860, -1116690717, -1107833238) + W(5, 1058976450, 1049118258, -1094097902, 1017239158)
		+ W(6, -1138403916, -1112296045, -1104638900, -1102593951)
		+ W(7, 1055269059, -1122615091, -1118424632, -1108171422)
		+ W(8, 1053496066, -1123704112, -1100830255, 1029941429) + W(9, -1118568038, 1025019530, 997886569, -1107943218)
		+ W(10, 1036129823, -1111217181, -1117554448, -1113883668)
		+ W(11, 1047703644, -1108512765, -1109656827, 1020926429);
	sum2 = W(0, -1119993039, -1109450011, 1040401784, -1106582025)
		 + W(1, 1033614749, -1147493015, 1038893624, -1096262037)
		 + W(2, 1053717996, -1117988753, 1000703247, -1114388777)
		 + W(3, -1105602869, 1055566572, 1043380434, -1092886002)
		 + W(4, 1034388956, 1043473668, -1106354535, -1158461197)
		 + W(5, -1105416337, 1072933379, -1081255560, 1043342555)
		 + W(6, 1032998629, -1117939535, -1087999087, -1083385663)
		 + W(7, 1066426555, -1094544057, 998835515, -1108137959) + W(8, 1027244587, 1045359897, -1093783038, 1045623937)
		 + W(9, -1119543359, 1037096144, -1117843291, -1101171319)
		 + W(10, 1051461624, -1102892249, 1026155597, -1114868339)
		 + W(11, 1031605777, 1022787365, -1100938466, 1041102940);
	WS(1062840044, 1036517115);
	sum1 =
		W(0, 1027882709, 1024218619, -1088734638, 1057788973) + W(1, 1032695796, -1105941698, -1102360361, -1119309706)
		+ W(2, 1031157223, 1045291130, -1107257205, 1032367183) + W(3, 1037386637, 1051294017, -1082181941, 1057574554)
		+ W(4, 1039133128, 1015412087, 1026327034, -1105387538) + W(5, -1087289600, 1064725383, 1024151288, -1102302982)
		+ W(6, -1102333276, 1045232110, -1089919726, 1056789371) + W(7, -1131902346, 1046746652, 1042539613, 1042423170)
		+ W(8, -1088061047, 1052153154, 1045762482, -1110282969)
		+ W(9, -1113170154, -1107171938, -1126992520, -1124580994)
		+ W(10, -1130270357, -1116552186, -1117867630, 1042893141)
		+ W(11, -1098512042, -1109192172, 1047580087, 1032060742);
	sum2 = W(0, -1128425377, -1106124336, -1106789449, -1116881359)
		 + W(1, -1108203604, -1154187588, 1027402769, -1123408727)
		 + W(2, 1046361983, 1040877836, 1041799035, 1037669599) + W(3, -1122701285, 1035952055, 1033758045, -1092736894)
		 + W(4, -1110885432, -1106801609, 1029460017, -1106291502)
		 + W(5, -1092942672, -1089281400, 1058715791, 1044648045)
		 + W(6, -1128656941, 1034330078, 1022825967, 1067937621)
		 + W(7, 1060265099, -1104725901, 1015114546, -1137130753)
		 + W(8, 1043050798, 1057367901, -1090127289, -1099584998)
		 + W(9, -1131912907, -1151273092, 1026393205, -1100743964)
		 + W(10, -1100147508, -1114467924, 1012677721, -1141059698)
		 + W(11, -1114857397, -1116376233, -1085394823, 1048436512);
	WS(-1090906199, 1032077706);
	sum1 =
		W(0, -1133027020, -1114971356, 1042474992, -1109782777) + W(1, 1040233361, -1113511763, -1121893314, 1044790618)
		+ W(2, -1113284386, 1033127972, -1105262125, 1025873725)
		+ W(3, 1023318639, -1123234602, 1041326284, -1090554926) + W(4, 1034823031, 1011115622, 1029445080, 1040694938)
		+ W(5, -1105269270, 1053731809, -1109230339, -1129412204)
		+ W(6, 1001128051, 1035215242, -1090300845, 1054234875) + W(7, -1098565414, 1038160135, 1034316233, -1102125462)
		+ W(8, 1049843289, -1098556565, 1042417542, 1018477632)
		+ W(9, -1103958128, 1043268297, -1131346756, -1121911775)
		+ W(10, 1026215817, 1009497794, 1035906358, -1122145747)
		+ W(11, 1025511402, -1113919963, -1122686272, 998364239);
	sum2 = W(0, 1010874613, 1030375188, -1115235366, 1049471257)
		 + W(1, -1100352469, 1040126787, 1031993168, -1098558104)
		 + W(2, 1051363302, -1094785947, 1040320218, -1131978284)
		 + W(3, -1110586713, -1116546039, 1056517150, 1031272431)
		 + W(4, -1111763071, -1124433226, 1035954309, -1089737673)
		 + W(5, 1057138262, -1102658594, 1043402933, 1027656919)
		 + W(6, 1034349301, -1094899703, -1098486858, -1112892354)
		 + W(7, 1057577914, -1092308561, -1122071401, 1053685859)
		 + W(8, -1093546729, 1046184196, 1039716432, -1116345243)
		 + W(9, -1140127141, -1108774266, 1034072089, -1109252950)
		 + W(10, -1122970680, 1016915650, 1029284667, -1124583674)
		 + W(11, -1122424073, 1037904141, 958822899, -1140678181);
	WS(1065971990, -1117349785);
	sum1 =
		W(0, 1041698888, -1103591502, -1130045402, 1049080916) + W(1, 1009208654, 1021475879, -1112126136, 1043874709)
		+ W(2, 1044992637, 1047240445, -1121869537, -1134810027)
		+ W(3, 1034826515, -1101299034, -1083999976, 1060703412)
		+ W(4, -1123043996, -1144695867, -1129568652, -1186542860)
		+ W(5, -1081978560, 1061790267, 1028920692, 1017436104) + W(6, -1109843230, 1041410157, -1085461041, 1058214583)
		+ W(7, -1105683576, -1131209785, 1024013025, -1159955630)
		+ W(8, -1090063736, 1059365054, 1011681824, -1139574520) + W(9, 1009653886, 1030113747, -1097631850, 1049303674)
		+ W(10, -1125202109, 1000157667, -1137279078, -1120752640)
		+ W(11, -1094129699, 1052607100, 1021258909, 1022839599);
	sum2 = W(0, -1117014919, -1073720352, -1104300581, 1055286111)
		 + W(1, -1105567211, -1108683793, -1130364155, -1086725672)
		 + W(2, -1091483554, -1109695767, 1032269150, 1033653176)
		 + W(3, -1106662873, 1069712606, 1061376514, -1114136197)
		 + W(4, -1138351682, -1115525434, -1114007102, 1062079613)
		 + W(5, 1060429625, 1052661025, 1018497014, 1043366723)
		 + W(6, 1049348603, -1102930718, -1098979910, -1131131469)
		 + W(7, 1032920333, -1107942477, -1111037227, 1020707077)
		 + W(8, -1091915359, 1050631696, -1117367449, -1139459182)
		 + W(9, 1016435713, -1114426132, 1043583392, -1112682766)
		 + W(10, -1122101547, -1122885189, 1035610526, 1034066723)
		 + W(11, -1091474650, -1112601210, 1039950258, 1026792554);
	WS(-1087438700, -1079683283);
	sum1 =
		W(0, 1017584527, -1111085935, -1097724786, 1052950249) + W(1, -1112145065, 1032156829, -1126645293, -1110290014)
		+ W(2, -1098381907, 1053593812, -1106211842, -1129163939)
		+ W(3, 1024510860, 1033919541, -1083731542, 1063649365) + W(4, 1003633557, -1118260846, -1126938201, 1049726143)
		+ W(5, -1081500983, 1059087538, 1023563130, -1120786763) + W(6, 1025818403, 1042036038, -1097215121, 1052548297)
		+ W(7, 1019377518, -1116189667, -1163276521, -1114444262)
		+ W(8, -1091706404, 1057898452, -1104008328, 1023503580) + W(9, 1040771729, 1029908410, -1097070911, 1045403069)
		+ W(10, -1115067299, -1112674412, -1160528892, 1035428627)
		+ W(11, -1097940968, 1052829673, 1032435766, 1015355644);
	sum2 =
		W(0, 1027460995, -1139353737, -1116062036, -1105887481)
		+ W(1, 1043084390, -1112909236, -1126036613, -1172793556)
		+ W(2, 1041340702, 1031879973, -1108443334, -1144584219) + W(3, 1029366028, 1021322407, 1050063273, -1101108606)
		+ W(4, 1031078409, -1116288208, -1129309981, -1097919394)
		+ W(5, 1055277098, 1009470709, 1041616760, -1099143154) + W(6, 1020875062, -1121912528, -1106551211, 1047064096)
		+ W(7, -1107655532, -1100042276, 988377354, 1034370211) + W(8, 1041415105, 1034815104, 1018545561, -1108610892)
		+ W(9, -1109676838, -1137199485, -1128558209, 1034836242)
		+ W(10, 1014245687, -1111876576, 1030688918, -1107628664)
		+ W(11, -1134721053, 1049845283, -1104117922, -1123449114);
	WS(1044595630, -1081949232);
	sum1 =
		W(0, 1039675598, -1112185757, -1088266627, -1103352647) + W(1, 1051863744, -1115854735, -1114551286, 1041771076)
		+ W(2, -1144202605, 1058269731, -1102436935, -1130126796)
		+ W(3, 1008233858, -1113654239, -1106609306, 1055957016) + W(4, 1041931682, 1017898629, -1121252161, 1036138408)
		+ W(5, -1087961804, 1060473075, -1105147684, 1041818984) + W(6, 1033942172, 1043328887, -1087619944, 1062639593)
		+ W(7, 1002098271, -1130413359, -1122512668, 1047911808)
		+ W(8, -1086197995, 1055667963, -1111264410, 1032948860) + W(9, 1026205083, 1028532559, -1087181441, 1042300482)
		+ W(10, 1038991809, -1115140949, -1118876117, 1051948425)
		+ W(11, -1079365891, 1051816684, 1047648830, 1035539513);
	sum2 =
		W(0, 1050752765, -1087877559, -1089125923, 1063798323) + W(1, 1013490077, -1098786735, -1102559074, 1042152886)
		+ W(2, 1035361880, 1052128007, -1090156566, 1029952535) + W(3, 1004621594, -1095393630, 1058416370, 1062325475)
		+ W(4, -1094287538, -1116454071, -1106905815, -1106434273)
		+ W(5, 1058355794, -1120474523, -1101206197, 1025568531) + W(6, 1038134564, -1099723068, 1056388755, 1051681161)
		+ W(7, -1100293430, 1009033997, -1114858390, 1036662936) + W(8, 1040360076, -1096401119, -1104699402, 997069429)
		+ W(9, 999530010, -1101776331, -1106345832, -1106373450)
		+ W(10, 1048788631, -1117506479, -1104442024, 1054232067)
		+ W(11, 1034476952, -1089943559, -1113690608, 1019208527);
	WS(-1082323244, 1081334754);
	sum1 =
		W(0, 1017652669, -1114671162, 1045686283, -1100397239) + W(1, 1040334760, -1120290385, 1026074030, -1101582293)
		+ W(2, 1051997878, -1097273854, 1036251335, 1010893986) + W(3, 1026308835, -1102225205, 1056290627, -1091487775)
		+ W(4, 1044247257, -1114193219, -1139023631, -1128122150)
		+ W(5, -1109179969, 1033600923, 1034603313, 1015477828) + W(6, -1124784756, 1047028384, -1088067773, 1058585755)
		+ W(7, -1098471302, 1027532986, -1157466090, 1041367009)
		+ W(8, -1090935975, 1058457225, -1104671877, 1028455628)
		+ W(9, -1151223253, 1037350457, -1100014755, 1047302995)
		+ W(10, -1113240670, 1023216600, -1123067319, 1018518877)
		+ W(11, -1100605637, 1040259816, 1007040336, -1167442276);
	sum2 = W(0, 1021161720, 1034310052, 1028060302, -1111691904)
		 + W(1, -1117456161, -1120681063, -1130912565, -1120070653)
		 + W(2, 1057895756, 1060473449, -1103940220, 1030806761) + W(3, -1130074229, 1013066141, 1050008660, 1048707954)
		 + W(4, 1041027109, -1131293055, -1117040706, -1097167140)
		 + W(5, -1077198236, -1071981659, -1101172514, 1009545637)
		 + W(6, 1025588007, -1126989997, 1036249174, 1055589119) + W(7, 1014637039, 1035622377, 1012731209, 1035986228)
		 + W(8, 1061480822, 1068029984, 1014223793, -1130249456) + W(9, -1117264939, 979500482, 1036420478, 1025639810)
		 + W(10, 1027808652, -1120874755, 1035821810, -1131150309)
		 + W(11, -1114248001, -1104930835, -1128414380, 1036288471);
	WS(1053726551, 1012659382);
	sum1 = W(0, 1032083097, -1106638998, -1098702088, 1047871676) + W(1, 998886703, 1022035144, -1115995457, 1034541187)
		 + W(2, -1098027112, 1032148771, 1042659740, -1112198366)
		 + W(3, 1025061558, -1115280977, -1088652495, 1060231518)
		 + W(4, -1106688851, 1034668492, -1122031383, -1104507249)
		 + W(5, -1092902123, 1065996118, -1104094145, 1024148149)
		 + W(6, 1038196358, -1114143426, -1085882325, 1058126194)
		 + W(7, -1102012910, 1010989620, -1115071689, 1029764374)
		 + W(8, -1097451113, 1059563219, -1121352461, 1012420282)
		 + W(9, -1130575936, 1031225348, -1098237300, 1035470703)
		 + W(10, -1128714910, -1123786037, -1113099877, -1102798468)
		 + W(11, -1111014420, 1054581342, 1000597622, 1024134712);
	sum2 = W(0, -1124504165, 1043258069, -1119272862, -1120765402)
		 + W(1, -1132584009, -1130103221, 1044199209, -1105860909)
		 + W(2, -1096303760, 1027333462, -1112573193, 1030769098)
		 + W(3, -1105768285, -1149580326, 1030851358, -1110802573)
		 + W(4, 1028533186, -1111917317, 1030597508, 1054859448) + W(5, 1057797022, 1040041196, 1035436142, 1033418125)
		 + W(6, -1097181409, 1065166573, 1062380695, 1017534493)
		 + W(7, -1141430739, -1140263257, 1040834484, 1012576825)
		 + W(8, -1116955554, -1108797661, 1032147286, -1126074797)
		 + W(9, -1106395293, -1091772000, -1113754765, 1042765191)
		 + W(10, -1113752657, 1020067757, 1038991009, -1077787203)
		 + W(11, -1098893101, -1110880129, -1120959090, -1136443945);
	WS(-1091585367, -1096979755);
	sum1 =
		W(0, -1125210148, -1104771642, -1104387016, 1039960904) + W(1, 1043768271, -1127914889, -1121704545, 1041680018)
		+ W(2, -1093500244, 1056326757, -1114046313, -1113011982)
		+ W(3, -1120024086, 1043362647, -1085845307, 1060708396)
		+ W(4, 1022927067, -1140249314, -1106223422, 1048656073)
		+ W(5, -1086139981, 1060053831, -1105827043, -1132509525) + W(6, 1027649645, 1038801018, 971788283, -1115241635)
		+ W(7, -1120254754, 1027284814, -1106879908, -1103521718)
		+ W(8, -1124812374, 1040958787, 1038747748, 1026834103) + W(9, 1033259600, -1106174833, 1011346436, 995843043)
		+ W(10, -1118768800, -1115807705, -1108105765, 1031226898)
		+ W(11, -1119913673, 1040930453, 1040461604, 1029803545);
	sum2 = W(0, 1007158722, 1004004293, -1123076619, -1109929145)
		 + W(1, -1104848259, 1045822378, -1117465525, 1030693613)
		 + W(2, 1034532408, -1107544976, -1095482533, -1130708853)
		 + W(3, 1020157105, 1007550482, -1101572236, -1110988335)
		 + W(4, -1085485924, 1036333634, -1115575087, 1032793866)
		 + W(5, 1059720067, 1067665797, -1090269083, -1111111456)
		 + W(6, 1029731993, -1104867994, -1112732963, 1048427228)
		 + W(7, -1135504754, -1105802165, -1115951245, -1111503366)
		 + W(8, -1098900155, 1058832170, 1037004208, -1115747431)
		 + W(9, 1042169362, -1101768383, -1132362761, 1029991341)
		 + W(10, -1108400441, -1132122165, -1111020797, 1042858280)
		 + W(11, -1101011815, 1043396912, 1041064016, -1126685993);
	WS(1050761175, 1067771859);
	sum1 =
		W(0, 1007679755, -1103008542, -1117542415, 1040506400) + W(1, -1107587308, -1123566389, 1016344868, 1051881455)
		+ W(2, -1099208581, 1050438683, -1138473483, 1035136294)
		+ W(3, -1111212068, -1113694143, -1094852820, 1036449755)
		+ W(4, -1102372368, -1110750261, 1035369236, 1057165115) + W(5, -1086714990, 1067282489, 1045850761, 1047098321)
		+ W(6, -1114152399, 1030154052, -1087862176, 1049754336)
		+ W(7, -1112794889, -1108921199, 1027679203, -1119705863)
		+ W(8, -1098820035, 1030273979, -1111030523, -1158006009)
		+ W(9, 1024513697, 1037582923, -1101037788, 1048082428)
		+ W(10, -1114576136, 1025557440, 1023429051, -1106945041)
		+ W(11, -1098056967, 1020854026, 1000524418, 1029171882);
	sum2 =
		W(0, -1108377721, 1042939389, -1118508723, -1101760284) + W(1, 1037932369, -1111488356, 1043256577, -1092756549)
		+ W(2, -1136988785, 1050996294, -1104406221, 1040203060)
		+ W(3, -1098471532, -1140040329, -1099870420, -1098704018)
		+ W(4, 1015984185, -1103619810, 1048495965, -1094992475) + W(5, 1064902851, 1062859454, -1098855018, 1045571731)
		+ W(6, -1103576309, 1017276157, 1045749581, -1089477514) + W(7, 1025174042, 1025902034, 1036658009, -1104050853)
		+ W(8, 1045838269, -1157061765, -1121418697, -1107737652)
		+ W(9, -1107738492, 1032200565, -1110226959, 1046491511)
		+ W(10, -1106492592, 1044444185, 1030436882, -1104348148)
		+ W(11, 1042649061, -1106567852, 1027657606, -1105647758);
	WS(1057448172, 1069108917);
	sum1 =
		W(0, 1025232554, -1116799928, -1100727837, 1055215485)
		+ W(1, -1106508548, -1139419762, -1128422002, -1123655391)
		+ W(2, 1037047614, -1104723136, 1040448906, 1006660815) + W(3, 1032607415, -1111298160, -1102160962, 1056783106)
		+ W(4, -1103004521, 1016236833, -1106129908, -1119092894)
		+ W(5, 1036246919, -1165535249, 1040745899, -1123853933)
		+ W(6, -1141856298, 1044964179, -1088316592, 1049606186)
		+ W(7, -1132962087, 1016605067, 1015221011, -1128617181)
		+ W(8, -1116622467, 1044617768, -1103456342, -1160895193)
		+ W(9, 1010040610, -1116425884, 1027658969, -1132120236) + W(10, 1037741920, 1018376479, 1026592994, 1015937075)
		+ W(11, -1102536008, 1042573835, -1118303623, -1120915345);
	sum2 =
		W(0, -1128749003, 1042697161, -1101835107, 1038607216) + W(1, -1108371617, 1031384482, -1091479855, 1061865996)
		+ W(2, -1097573200, 1026943422, -1114744392, 1026017402)
		+ W(3, -1124909389, 1067634595, -1083343720, -1110364223)
		+ W(4, 1035072621, 1036186174, 1030767422, -1111988197)
		+ W(5, -1090130192, -1089515454, 1054823097, -1104718688)
		+ W(6, 1028475536, -1102439466, 1055493018, -1090714326)
		+ W(7, 1059932372, 1024781950, -1118686225, -1117920963)
		+ W(8, 1027292464, -1101900071, 1031097460, -1110105890) + W(9, -1133507353, 1022976741, 1030733458, 1033968573)
		+ W(10, -1132241300, 1040128898, 1003197653, 1008285339)
		+ W(11, 1002427213, 1033064671, -1101772178, 1026666744);
	WS(1065065708, -1125796377);
	sum1 =
		W(0, -1112144555, -1106943759, 1017193539, 1048634147) + W(1, -1127916040, -1132404112, 1029634469, 1025116330)
		+ W(2, -1112668180, 1027133034, 1026809557, 1004217594)
		+ W(3, -1112840237, -1105630541, -1112954809, 1055950575)
		+ W(4, -1112907992, -1111964638, 1034269757, -1106751530)
		+ W(5, -1096457447, 1060800975, -1093799807, 1038388364)
		+ W(6, -1122801969, 1023923175, -1094266089, 1051425450)
		+ W(7, -1103940357, -1132895812, -1133240789, 1041797158)
		+ W(8, -1096385878, 1041695411, 1039766276, 1013909417) + W(9, 1016754760, -1113089188, -1106190977, 1044103184)
		+ W(10, -1130590086, 1032062573, -1119164014, -1130226634)
		+ W(11, -1114305030, 1036967948, 1008751883, 992673732);
	sum2 = W(0, 1043431555, -1098806978, 1024222598, -1105154239) + W(1, 1031236307, 953732840, -1109692118, 1046643695)
		 + W(2, 1045861043, 1054740901, 1035789437, -1115663935)
		 + W(3, 1036275465, -1097975189, -1101643320, -1083291725)
		 + W(4, 1007109846, 1042301531, -1111890182, 1048664613) + W(5, 1058544270, 1068703829, -1081353417, 1035678115)
		 + W(6, -1102288351, 1049750262, -1098883379, -1080748028)
		 + W(7, 1031821902, -1120166561, 1045724738, -1098934938)
		 + W(8, 1049188212, 1058055770, -1100833476, 1047454611)
		 + W(9, -1109691788, 1032869755, -1107029975, -1100454574)
		 + W(10, 1051695731, -1096856793, 1007408138, -1111259526)
		 + W(11, 1048185689, -1148294292, -1114785167, 1041528279);
	WS(1061652844, 1044003957);
	sum1 =
		W(0, -1118715405, 1022617806, 1044034950, -1101088515) + W(1, 1019688911, -1131961856, 1029075868, 1045689305)
		+ W(2, 1030904095, -1103346936, 1045834099, -1110934572)
		+ W(3, -1115471369, -1094261862, 1059625182, -1096538237)
		+ W(4, -1102841294, 1036052922, 1032954233, 1027529537) + W(5, 1057470859, -1086691558, 1041319556, -1148682371)
		+ W(6, 998963525, -1099266912, 1062131070, -1094363880) + W(7, -1166277444, 1017830866, -1111723799, 1045678528)
		+ W(8, -1098407445, -1105378993, 1028040508, -1109411965)
		+ W(9, 1036011862, -1119248992, 1047156095, -1123294521)
		+ W(10, -1135804811, 1030886475, -1152687195, -1108410990)
		+ W(11, 1037164834, 1016045215, -1106724595, -1123601124);
	sum2 = W(0, -1123087716, -1115107680, 1039737456, 1045652727)
		 + W(1, -1106100707, -1128513463, -1122327585, -1105390433)
		 + W(2, -1106584843, -1139899009, -1102201417, -1114704327)
		 + W(3, 1034911826, 1034185422, 987338697, 1060423005) + W(4, -1111505321, 1009548801, -1115300382, 1042081129)
		 + W(5, -1094697399, -1103292099, -1094374885, 1026056400)
		 + W(6, -1147444258, 1036682846, 1048628369, -1079464406)
		 + W(7, 1066067653, -1112497116, 1031538244, 1043195731)
		 + W(8, -1100913302, -1102260713, 1062702469, -1107096307)
		 + W(9, -1122824244, -1112377777, 1041194171, -1101961861)
		 + W(10, 1013733313, -1125635761, 1026384688, 1024479380)
		 + W(11, 1036768370, -1106123677, 1034543612, 1037241080);
	WS(1061983340, -1091535279);
	sum1 = W(0, -1154828523, -1133965299, 1043906007, -1118138894)
		 + W(1, -1109842717, 1025343169, 1027504414, -1128653831)
		 + W(2, 1027190112, -1097538828, 1037523079, -1121887129)
		 + W(3, -1131271078, -1114200663, 1061948198, 1027560685)
		 + W(4, -1106988467, 1023298667, -1120408436, -1129743238)
		 + W(5, 1054216086, -1081158944, 1048594270, -1108007945)
		 + W(6, -1131629652, -1117839504, 1062537731, -1089869577)
		 + W(7, -1121464863, 1034422373, -1122568783, 1035797658)
		 + W(8, 1028696552, -1097887897, 1028427349, -1120763036)
		 + W(9, -1165314478, -1115205249, 1045640431, -1111951485)
		 + W(10, -1121440284, 1008081777, 995201141, 1019503421)
		 + W(11, 1044774081, -1105384996, -1119142300, -1122356070);
	sum2 = W(0, 995087446, 1036608468, 965233164, 1033021468) + W(1, -1114419070, 1033025046, 1030495116, -1099055008)
		 + W(2, -1104807397, -1107407110, 1033869233, -1119280070)
		 + W(3, 1007114937, -1115487063, -1070882050, 1038417178)
		 + W(4, -1103406865, 1028798922, -1121939088, 1057848194)
		 + W(5, 1075270016, -1094462735, 1051754977, -1120762821)
		 + W(6, -1109334595, -1106051731, 1059573542, 1039375650)
		 + W(7, -1104596666, 1018124826, 1012755199, 1015526929) + W(8, -1102771000, -1124510890, 1028405316, 976567206)
		 + W(9, 1031009559, -1118519790, 1023903156, 1016192349)
		 + W(10, -1111745826, 1015800189, -1123906524, 1024955281)
		 + W(11, -1159976683, 1023974018, 955743793, -1129936862);
	WS(1062927532, 1035014202);
	sum1 =
		W(0, 1039522007, -1114736246, 1037103646, -1104897563) + W(1, 1044380938, -1121785378, 1034505951, -1109500450)
		+ W(2, 1048942600, -1092956200, 1044086236, 1027254073) + W(3, 1040732909, 1011271190, 1053278895, -1091146839)
		+ W(4, 1044239087, -1145709740, 1002357921, 1044028441) + W(5, -1097469770, -1093973369, 1042916452, 981579331)
		+ W(6, 1016035605, 1050061010, -1085392865, 1051214559) + W(7, -1112456671, 1035761861, -1122944943, 1042353405)
		+ W(8, -1094832633, 1050975197, -1111813313, 1033165606) + W(9, 999726956, 1036129025, -1103977959, 1043068615)
		+ W(10, -1112116510, 1025151372, -1140151454, 1041525964)
		+ W(11, -1111797875, -1126246883, -1110444494, 1033358643);
	sum2 =
		W(0, 1038528863, -1084044031, -1082440456, 1050939225) + W(1, 1053868195, -1113963371, 1036214533, -1091834288)
		+ W(2, -1077502553, -1095085693, 1028074081, -1114781385)
		+ W(3, 1049223347, -1110305241, 1049812579, 1050231565) + W(4, 1046376147, 1035810200, -1113699843, 1042795689)
		+ W(5, 1068178608, 1060273714, -1132635925, -1160679206)
		+ W(6, 1041716852, 1050774414, -1092073446, -1115682722)
		+ W(7, -1098688235, 1036026944, -1100571883, 1043118649) + W(8, 1047476754, -1105112612, 1017697398, 1016345266)
		+ W(9, 1017295180, 1047177880, 1034666293, 1050691511) + W(10, -1092800689, 1040315316, -1101978327, 1050263507)
		+ W(11, 1054410728, -1101197699, -1104788145, -1112282035);
	WS(-1086906028, 1058773265);
	sum1 = W(0, -1132629757, 1044191380, 1032367334, -1096691584)
		 + W(1, -1152318558, -1109034905, 997844200, 1043197109) + W(2, 1050808506, -1095732027, 1042781664, 1031594505)
		 + W(3, 965362145, -1125429564, 1058285756, -1086608026)
		 + W(4, 1034636741, -1119832870, -1106996409, 1033453658)
		 + W(5, 1062016570, -1081591954, 1043388193, -1106441585)
		 + W(6, -1153797548, -1118095697, 1044397873, 1041881517)
		 + W(7, 1045470808, -1149103576, -1120050655, -1121403972)
		 + W(8, 1043993638, -1096430215, -1115428219, -1113585524)
		 + W(9, -1122322046, -1119804562, 1042486572, 1002316636)
		 + W(10, 1018594522, -1135705587, 1015091632, 1026125167)
		 + W(11, 1047754366, -1099777504, 1024196285, -1122333654);
	sum2 =
		W(0, 1048104076, -1096548381, -1107021820, 1018456960) + W(1, -1136070657, -1112321878, 1038532068, -1086001730)
		+ W(2, -1131935456, 1007620609, 1040453646, 1033875386) + W(3, -1129915388, -1083843015, 1060056432, 1033171254)
		+ W(4, -1111662792, -1117768272, -1101156186, 1035944594)
		+ W(5, 1066609131, 1050949241, -1110531416, 1032538050)
		+ W(6, -1128179824, -1102068111, 1027352212, -1107874139)
		+ W(7, -1104445548, -1114035189, -1128045264, 1044127780)
		+ W(8, 1048571914, -1104179329, -1127646596, 1032855260)
		+ W(9, -1131782160, -1114990278, -1120175088, 1038875644)
		+ W(10, -1110249452, -1144805954, -1109473444, 1041203218)
		+ W(11, 1038985844, -1112054433, 1034344442, -1130080864);
	WS(1046014126, 1065769758);
	sum1 =
		W(0, 1012096182, -1121314108, -1091239207, 1052142286) + W(1, 1042130570, 1019346753, -1112076254, 1039437825)
		+ W(2, -1094624040, 1048611696, -1109865911, -1152131961)
		+ W(3, -1100987245, 1043473803, -1091961473, 1060125676)
		+ W(4, -1128757714, -1123465492, -1106802021, 1045721640)
		+ W(5, -1088552177, 1062377804, -1119711185, 1039063160)
		+ W(6, -1106286530, 1049347084, -1089539427, 1053897896)
		+ W(7, -1128945819, -1114302645, -1129503003, -1109380841)
		+ W(8, -1091526873, 1057150062, -1119080717, 1015225093) + W(9, 1021132153, 1049245244, -1091375076, 1048631067)
		+ W(10, 1034078686, -1135518836, -1112401299, -1120677869)
		+ W(11, -1088888106, 1057709495, -1122337355, 1014030866);
	sum2 =
		W(0, -1089976447, 1064913799, -1094573985, -1109226965) + W(1, 1030445629, -1115506338, -1078304891, 1068350548)
		+ W(2, 1019506715, -1120561974, 1021062218, 1018259030) + W(3, -1071851632, 1070575185, 1065710309, 1002672995)
		+ W(4, -1127826384, 1012290398, -1070679577, 1072673707) + W(5, 1065504629, -1098180006, 1031139735, 995896746)
		+ W(6, -1081022179, 1063744071, 1056839493, -1117214353)
		+ W(7, -1112765526, 1010152224, -1113339548, -1128451504)
		+ W(8, -1124929726, -1111255228, 1037321868, -1118014213)
		+ W(9, 1011136331, 1040942179, -1106886716, 1028658493) + W(10, -1127063938, 967860273, 1035458322, -1115281660)
		+ W(11, -1111465381, 1033265670, 1001938923, -1119523230);
	WS(-1096468055, 1053785380);
	sum1 = W(0, -1110473361, -1116957735, 1034879511, 1017136705)
		 + W(1, -1116669644, -1118632404, 1020813409, -1114360891)
		 + W(2, -1114475674, -1111337627, -1135792006, -1120549867)
		 + W(3, -1111899059, -1123200592, -1109008383, 1028379180)
		 + W(4, -1105125143, -1162426624, 1027946631, -1090968927)
		 + W(5, 1066746382, 1051825655, -1094808947, -1173354793)
		 + W(6, 1003556839, -1107232681, 1064704330, -1094442401)
		 + W(7, -1116312257, -1119514205, -1143096715, -1117882342)
		 + W(8, 1046069775, -1129057075, -1106172505, -1113957025)
		 + W(9, 996386562, -1118523124, 1042611044, -1114700263)
		 + W(10, -1135525501, -1130080208, -1123588698, -1105979736)
		 + W(11, 1040361862, 1022269000, -1106276184, -1123525720);
	sum2 =
		W(0, -1127419095, -1122531649, -1111543417, 1043407189) + W(1, 1013519927, -1134679399, -1140125367, 1025350612)
		+ W(2, -1108347637, 1028851928, -1117946771, 991440379) + W(3, 1028088432, -1123116186, -1101718819, 1048774619)
		+ W(4, 1041147594, -1127107007, -1126099139, 1020760995)
		+ W(5, 1056423339, -1086358248, -1112971994, -1115422093)
		+ W(6, -1114986450, 1019570567, 1073762237, -1076137651) + W(7, -1118107520, 1037345920, 1024738032, 1039021380)
		+ W(8, -1100544782, 1044261707, 1015761083, -1103403994)
		+ W(9, -1114843176, 1018690059, 1049061203, -1099227611)
		+ W(10, -1111772147, 1042824177, 1023949256, -1119198021)
		+ W(11, 1026425060, -1123270518, 1027419728, -1129333383);
	WS(-1089097708, -1091261619);
	sum1 = W(0, -1127316247, 1003986316, -1111263852, 1044425283)
		 + W(1, 1033605983, -1116984894, -1113526029, -1120011361)
		 + W(2, -1112997295, 1047767320, -1118942860, -1121673366)
		 + W(3, -1118797136, 1046355762, -1081822066, 1061869832)
		 + W(4, -1110810403, 1027944882, -1123552881, -1103137072)
		 + W(5, -1100403388, 1058200050, 1009152314, -1124559262)
		 + W(6, -1123795687, -1103576251, 1053114278, -1092855018)
		 + W(7, 1046189751, -1131347855, 1015138359, 1032220600)
		 + W(8, -1138618770, -1160534136, 1031283151, -1118591413)
		 + W(9, -1129675572, -1120446878, 1007314666, 1034662460)
		 + W(10, 1016196275, -1131488026, -1126584008, 1027028747)
		 + W(11, -1123471427, 1018063772, -1128724178, -1122517738);
	sum2 =
		W(0, -1151923233, 1040701127, -1110923755, -1103532415) + W(1, 1041909162, -1121169096, 1026311687, -1109901381)
		+ W(2, 1024679085, 1016651554, 1036375055, -1135341024) + W(3, 1025121279, 1034378939, -1080291839, -1082840291)
		+ W(4, -1110170843, 1041541680, -1123775834, -1092342947)
		+ W(5, 1071256357, 1066054209, -1090243220, -1128413506) + W(6, 1033596173, -1096202739, 1042190483, 1056834874)
		+ W(7, -1097275958, 1043004954, -1105542037, 1051958537)
		+ W(8, -1103925783, -1199035157, 1038401459, -1097944284)
		+ W(9, 1035290939, -1098166743, 1046386099, 1035522294)
		+ W(10, -1113079432, 1042529081, -1108107550, 1047977685)
		+ W(11, -1114731953, 1030555165, 1015019440, -1099750845);
	WS(1061142188, 1045552914);
	sum1 =
		W(0, 1022384747, 1020461367, 1058732728, -1095805239) + W(1, -1101590238, 1033080372, 1019603337, -1114371061)
		+ W(2, 1054684529, -1098135841, -1123665301, 1031766591) + W(3, 992843677, -1137489184, 1060634392, -1085459239)
		+ W(4, 1027392977, -1123755612, 1025369499, -1128616851)
		+ W(5, 1056292747, -1081060320, -1124699057, -1116775033)
		+ W(6, -1149984013, -1114859644, 1061516204, -1083596540)
		+ W(7, 1038698931, 1034158665, 1030794181, -1134916072)
		+ W(8, 1058073341, -1097701630, -1106352164, -1134014242)
		+ W(9, -1123167236, -1114858116, 1052882077, 1026645922) + W(10, 1006025241, 1037240581, 1034453383, 1009189588)
		+ W(11, 1050605022, -1099032542, -1100750969, -1122655396);
	sum2 = W(0, 1041010686, 1045355628, -1091459780, -1092997038)
		 + W(1, 1025085151, 1019331790, -1100296712, -1110840017)
		 + W(2, -1109934927, -1109499465, -1110570114, -1115246837)
		 + W(3, 1042377248, 1028443719, -1120459763, 1023984711)
		 + W(4, -1120816159, 1025130703, -1124701214, -1097271182)
		 + W(5, 1068946970, 1068602839, -1090645327, 1036287199) + W(6, 1002573079, -1108318217, 1048538630, 1049236461)
		 + W(7, 1036483715, 1028224647, 1026372231, 1034868187)
		 + W(8, -1095496747, -1112347607, -1110453128, -1106754238)
		 + W(9, -1107309152, 1032249619, -1112114883, -1088682480)
		 + W(10, -1121128467, 1040581836, 1022594646, 1034940919)
		 + W(11, -1096153349, 1036467963, -1105549173, -1106253388);
	WS(-1090464684, 1058848194);
	sum1 = W(0, 1038070654, 1035807069, 1059156269, -1091590511)
		 + W(1, 1049775661, -1111666744, -1104784595, -1106022588)
		 + W(2, 1027584334, -1104101108, -1100086527, -1128618637)
		 + W(3, -1140651524, -1107342224, 1060192817, -1084437581)
		 + W(4, 1050662239, -1128690758, 1048797564, -1112865880)
		 + W(5, 1062566262, -1088742755, 1037690576, -1097281200)
		 + W(6, -1115845272, -1102596230, 1060113046, -1087393870)
		 + W(7, 1050391262, 1024450616, -1115304422, -1117573217)
		 + W(8, 1043041013, -1095911543, -1117869728, -1151911514)
		 + W(9, 1022142646, 1011767229, 1054886405, -1102839322)
		 + W(10, 1042443855, -1131868338, 1026901973, -1105151431)
		 + W(11, 1057383999, -1088896680, 1039830925, -1104457275);
	sum2 =
		W(0, -1106952896, -1173421195, -1113206734, -1136957987)
		+ W(1, -1152575873, -1112584615, 1050458431, -1100970530)
		+ W(2, 1037511626, 1029901269, -1116273053, 1045345833)
		+ W(3, -1084179073, -1117103305, 1063723378, -1106205415)
		+ W(4, 1039247706, 1031320371, -1068828969, 1049093414) + W(5, 1078393261, -1105390455, 1034474614, -1099252776)
		+ W(6, -1082769727, 1015202727, 1065452472, -1128426057) + W(7, 1032907306, 1035573879, 1054525389, -1093960872)
		+ W(8, -1106048166, 993579659, -1100143257, 1040309898) + W(9, -1098029126, 1043872404, 1031385535, -1114758982)
		+ W(10, -1155923695, -1124055116, 1038352192, -1107157710)
		+ W(11, 1030855073, 1034755506, 1034533524, -1124561432);
	WS(-1106782638, -1120193880);
	sum1 = W(0, 1020741911, -1116040418, 1053259451, -1112821605)
		 + W(1, -1101282812, -1111424287, 1021367862, -1121939617)
		 + W(2, 1050945756, -1100446872, 1049499553, -1129092267)
		 + W(3, 1038644232, -1109539853, 1055524943, -1091353929)
		 + W(4, -1100504250, 1016236516, -1126436322, -1098608828)
		 + W(5, 1065255335, -1085596156, -1101475552, 1033532871)
		 + W(6, 1043522250, -1101880327, 1061719830, -1096552606) + W(7, 1025835692, 1022700239, -1112066734, 993980163)
		 + W(8, 1048874997, -1090468372, -1114054607, -1114668904)
		 + W(9, 1018349205, -1115252655, 1051405991, -1106280862)
		 + W(10, 1027947689, -1147278953, 1033129938, -1133833389)
		 + W(11, 1042923217, -1102788916, -1104899626, 1028803059);
	sum2 =
		W(0, -1113068388, -1115580494, 1039529972, -1091718951) + W(1, -1076395174, 1046645532, 1036673453, 1024834555)
		+ W(2, -1098466798, 1052150318, -1080701891, -1104586573)
		+ W(3, -1118880240, -1115483686, 1043501593, 1043613567) + W(4, 1068474066, 1009076111, 1028813378, -1117546792)
		+ W(5, -1115055672, 1062484975, 1066750300, -1093753132)
		+ W(6, -1107832014, 1043490929, -1117282076, 1045088246)
		+ W(7, -1097140180, 1036864955, 1027909744, -1105092918) + W(8, 1042504898, -1094456673, 1049333443, 1022104546)
		+ W(9, -1122240512, 1040415904, -1107365158, 1030923561)
		+ W(10, -1109881554, 1033514298, 1011592783, -1119502452)
		+ W(11, -1112704202, -1123953380, 1043999999, -1115391680);
	WS(-1093231703, 1042706757);
	sum1 =
		W(0, 1032826937, 1040624182, 1058499572, -1084803183) + W(1, -1104136529, 1041579305, 1026075841, 1000558899)
		+ W(2, 1052553144, -1099119122, 1025447538, 1031885534) + W(3, 1032961819, -1110755278, 1061343357, -1083389465)
		+ W(4, -1114092422, 1032264780, 1036684171, -1127770315)
		+ W(5, 1062021249, -1081334022, -1112317122, 1018739433)
		+ W(6, 1034757510, -1106938311, 1060752603, -1087386813) + W(7, -1132554758, 1031902455, 1036416025, 1019575916)
		+ W(8, 1057695045, -1090036539, -1109030926, 1037874311)
		+ W(9, 1015758976, -1114624210, 1051786740, -1098198604) + W(10, 1012060669, 1027119072, 1040004261, 1042264396)
		+ W(11, 1058906011, -1088285503, -1096739300, 1035404188);
	sum2 =
		W(0, -1134545280, 1057942802, -1072425931, -1067197419) + W(1, 1049446840, 1074141781, -1101426979, 1047102485)
		+ W(2, -1084592242, -1071603316, 1042726179, 1060445087)
		+ W(3, 1012752443, 1055001204, -1079302223, -1077093049) + W(4, 1050812050, 1060645469, 1036306510, -1096203167)
		+ W(5, -1123894686, -1098326846, -1129334697, 1037955576)
		+ W(6, 1034320105, -1114902087, 1062181631, 1072541263)
		+ W(7, -1097319760, -1094473234, -1111393843, -1096420171)
		+ W(8, 1062084093, 1067609499, -1093274589, -1087350702) + W(9, 1046638158, -1101073471, 1064536824, 1073214169)
		+ W(10, 1001153868, -1085693573, -1108867307, -1091559913)
		+ W(11, 1073505700, 1078744623, -1094526709, -1077663090);
	WS(-1075107862, 1049521772);
	sum1 = W(0, 1027861131, 1045206278, -1086495609, 1051717721) + W(1, 1033503081, 1031434621, 987763517, 1041173528)
		 + W(2, -1097093508, 1049572700, -1116084523, -1144572069)
		 + W(3, -1129668766, 1032319275, -1086275954, 1055584810)
		 + W(4, 1009361560, -1140119493, 1033675992, 1040210256) + W(5, -1081944455, 1064397290, 995768539, 1027980366)
		 + W(6, 1016072268, 1041485791, -1082045908, 1059363461) + W(7, -1112276757, -1129633421, 992091051, 1044520444)
		 + W(8, -1096923684, 1055988184, -1112468587, 1024276072)
		 + W(9, 1026084697, 1042655839, -1093981119, 1051323143)
		 + W(10, 1005879363, 1000619058, -1120420163, -1112688453)
		 + W(11, -1094413520, 1050124978, 1033578820, 1025196738);
	sum2 =
		W(0, 1033523983, -1091543751, 1048034710, 1051542012) + W(1, 1024239879, 1041022978, -1107297920, -1125142534)
		+ W(2, 1031510683, -1103344470, -1117305947, -1121264057)
		+ W(3, -1109353447, -1100365589, 995045613, -1120961303)
		+ W(4, -1099173366, -1115033235, -1097553497, -1121112319)
		+ W(5, 1061520608, 1061214811, 1044020024, 1053722991) + W(6, -1102290887, -1119424675, 1042981818, -1094266425)
		+ W(7, -1093433218, -1097363289, 987526362, -1094244068) + W(8, -1103162896, 1043830132, 1046119446, 1047286054)
		+ W(9, 1022298470, 1033606211, 1052169844, 1041952964) + W(10, 1043499670, -1106943326, 944749371, -1100627225)
		+ W(11, -1098189213, 1041818078, -1096785580, 1031561067);
	WS(-1097146583, -1102489480);
	sum1 = W(0, -1121239074, -1102624204, 1041928668, 1043173384)
		 + W(1, -1118777253, 1016656554, 1035066361, 1033907292) + W(2, -1096659727, 1051162503, -1108685857, 995611334)
		 + W(3, -1110655283, -1104909116, -1123609439, 1057278053)
		 + W(4, -1102566959, 1009112868, 1032257412, -1109600459)
		 + W(5, -1091326393, 1050132159, -1100309385, 1037330963)
		 + W(6, 1020382076, -1113387282, -1105975127, 1049365769)
		 + W(7, -1101876333, -1111738159, 1014217354, -1114213060)
		 + W(8, -1098203983, 1049080395, 1040792061, 1033561904) + W(9, 1032256145, -1114763275, 1045101428, 1033542535)
		 + W(10, -1121020400, -1149295615, -1120529307, -1123950514)
		 + W(11, -1093952115, 1055699093, 1035959564, -1122689753);
	sum2 =
		W(0, 1030001048, 1039849292, -1106927121, 1046837828) + W(1, -1131959957, -1116147800, -1107119695, -1106305989)
		+ W(2, 1060202814, -1095733546, 1012779430, -1124391765) + W(3, 1023713698, 1019090837, -1104587624, 1043085465)
		+ W(4, 1026454649, 1028873647, -1115026335, 1035696383) + W(5, 1057308499, 1053508746, 1038120705, -1104339358)
		+ W(6, 1024715164, 1036481868, 1047684818, 1034862818) + W(7, 1037173687, 1045294658, -1112691697, 1023388499)
		+ W(8, -1112160637, 1046794790, -1101425448, -1119391248)
		+ W(9, 1024758511, -1146519572, -1093257675, -1094465043)
		+ W(10, 1036335613, -1156574008, -1147275412, -1112564365)
		+ W(11, 1041456307, -1083960309, -1094791365, 1012709310);
	WS(1057303084, -1084740383);
	sum1 =
		W(0, 1025949163, -1105987664, 1034968156, -1097863693) + W(1, 1046214631, -1130932027, 1023904890, -1104417576)
		+ W(2, 1048292239, -1093717272, 1042713619, -1126920426)
		+ W(3, 1033327896, -1097440039, 1057303604, -1088500414) + W(4, 1043920086, 1012093510, 1022060320, -1106403568)
		+ W(5, -1134851644, 1058205452, 1041892896, 1040636140) + W(6, -1131905805, 1043670267, -1082452830, 1059877080)
		+ W(7, -1101986947, 1028551783, -1114170862, 1041763972)
		+ W(8, -1089247692, 1058731430, -1107457363, 1041063330) + W(9, 1021513971, 1037885311, -1093401571, 1046703382)
		+ W(10, -1110573172, -1143718184, -1109381346, 1019385429)
		+ W(11, -1097845612, 1049842950, 1031126152, 1016340900);
	sum2 =
		W(0, -1097593869, -1100989715, 1026566131, 1061153405) + W(1, 1050695083, -1095509343, 1040446621, 1036240143)
		+ W(2, -1100851860, 1047874592, -1096668864, 1040237386)
		+ W(3, -1107347821, -1105186205, 1046892012, -1103469514)
		+ W(4, -1104864053, -1114614656, 1036994425, -1119554977)
		+ W(5, 1069594194, 1074408805, -1103368475, 1040210470) + W(6, 989701019, 1048367016, -1107809286, -1110319007)
		+ W(7, -1100341899, -1105386934, 1043906150, -1095197585)
		+ W(8, 1031148367, -1079941721, -1084422687, 1031716423) + W(9, 1040271244, -1102913875, 1038853877, 1042791078)
		+ W(10, -1093040701, 1036206107, 1016581730, 1041272891)
		+ W(11, -1105136265, -1086296266, -1099178193, 1042594729);
	WS(-1085311468, 1078025451);
	sum1 =
		W(0, -1114246985, 1033236492, -1126048573, 1051596674) + W(1, -1110129580, -1109388771, -1123523234, 1042717314)
		+ W(2, -1100167817, 1050764301, -1101525701, 1021849401)
		+ W(3, -1123774423, 1046675224, -1090923842, 1057423711) + W(4, -1102550347, 1031509177, 1017942127, 1030027079)
		+ W(5, 1002547123, -1138337956, -1117387765, -1126623147)
		+ W(6, 1018695644, -1107516674, 1061445386, -1085962671)
		+ W(7, 1045061525, -1118825262, -1134274761, -1105985470)
		+ W(8, 1051174149, -1101362115, 1037275627, -1107617348) + W(9, 973249598, -1118366597, 1032724353, -1098415672)
		+ W(10, 1033244340, -1124427728, 1032511109, -1108369993)
		+ W(11, 1047097650, -1105953621, 1025818592, -1115961017);
	sum2 =
		W(0, -1123353384, -1131031713, 1029311455, 1047725718) + W(1, 1051601031, -1113968956, 1030359787, -1114557735)
		+ W(2, -1123787418, 1042470619, -1121374979, 1045218010)
		+ W(3, 1024787123, -1125418898, -1099438470, -1106551206)
		+ W(4, 1049816965, 1044805763, 1015567503, -1132430472) + W(5, 1049323738, -1097880179, -1088308991, 1039658119)
		+ W(6, -1115408082, 1029672716, 1042547290, -1089568094)
		+ W(7, -1098255621, 1042126156, 1026077135, -1118070691)
		+ W(8, 1050505809, -1166364565, 1026888229, -1115384233)
		+ W(9, -1137211259, -1125125186, -1110579463, -1115324497)
		+ W(10, -1112338809, 1043221816, 1015951538, -1135395683)
		+ W(11, 1040847724, 1028809582, -1102185033, 1014731468);
	WS(1060142060, 1042832150);
	sum1 =
		W(0, 1031397804, 1036648197, 1052129567, -1093104885) + W(1, -1125587404, 1030014814, -1121488955, -1142445829)
		+ W(2, 1051097024, -1094159296, -1138833071, 1024131190)
		+ W(3, 1033996248, -1117943062, 1054892021, -1086111346) + W(4, 1028704007, 1024270930, 1018827426, -1111782928)
		+ W(5, 1065668620, -1081757070, 1032794495, -1123778927)
		+ W(6, -1131717262, -1108508447, 1059881804, -1087336873)
		+ W(7, 1047817147, 1022586319, 1033609702, -1106903604)
		+ W(8, 1058770516, -1090845580, -1104469332, -1125662417)
		+ W(9, 1010765225, 1015606653, 1050176059, -1100487494) + W(10, 1038701961, 1032196289, 1029196868, -1115637854)
		+ W(11, 1054801908, -1126749404, -1091639031, 1019613157);
	sum2 =
		W(0, 1016709191, 1043282989, -1105914972, -1104055195) + W(1, -1113893232, 1031619176, 1013621039, -1105412866)
		+ W(2, 1048947993, 1038685325, -1143937773, -1128320153)
		+ W(3, -1134054043, 1034830675, -1104630078, -1084033248)
		+ W(4, -1103493551, 990218298, 1033829499, -1123744731)
		+ W(5, -1088942993, -1072142874, -1098435347, 1026126526)
		+ W(6, -1133247239, -1107183956, -1093767876, 1073971039)
		+ W(7, 1052470850, 1042783259, 1014723479, -1110083630) + W(8, 1055362845, 1076386430, -1104225446, -1103699955)
		+ W(9, 1025542948, -1115844306, -1111303066, -1098251720)
		+ W(10, 1051939911, -1123473137, -1113297030, -1097083153)
		+ W(11, 1064727508, -1090433741, -1091328171, 1025388740);
	WS(-1086199532, 1054743650);
	sum1 = W(0, 1034444474, 1032011277, 1048862696, -1097849454) + W(1, 1006964268, 1027368614, 1027498242, -1095519909)
		 + W(2, 1053262121, -1090625833, 1040908045, -1113781807)
		 + W(3, 1040848158, -1107222607, 1061389071, -1084999869)
		 + W(4, 1038795271, -1118338586, 1023783640, -1152811127)
		 + W(5, 1030342167, -1113365765, 1038235355, -1108967739) + W(6, 999869046, 1044283945, -1084989084, 1060145155)
		 + W(7, -1104327823, 1006059384, -1115850147, 1044573214)
		 + W(8, -1095010778, 1054594461, -1101807134, 1028815960)
		 + W(9, 1025498402, 1036275699, -1106712265, 1045643928)
		 + W(10, -1122717633, -1124545277, -1134397103, -1123084051)
		 + W(11, 1032418005, 1033574715, 1015954881, -1135640905);
	sum2 =
		W(0, -1098769930, 1042608106, -1101852353, -1093087039) + W(1, -1139600545, 1036192806, 1041383757, -1089209738)
		+ W(2, -1121408570, 1038811718, -1093098827, -1121276186)
		+ W(3, 1031909130, -1102323575, -1108783974, -1089123880)
		+ W(4, -1121335963, 1045867083, 1040055926, -1105226719) + W(5, 1065973699, 1069194195, -1098519743, 1023817866)
		+ W(6, -1112037460, -1124786133, 1049738412, 1026907074)
		+ W(7, -1089198426, 1042688929, 1040275414, -1117623756)
		+ W(8, 1057999228, -1106112227, -1101165651, -1122635193)
		+ W(9, -1111784639, -1131302943, -1111524780, 1020629449)
		+ W(10, -1109243346, 1041146873, -1113621249, 1048083051)
		+ W(11, 1025491254, -1107530612, 1048264427, -1095495518);
	WS(-1090983255, -1089207473);
	sum1 =
		W(0, 1011536056, -1126565928, 1055178415, -1101680475) + W(1, -1102945718, 1026884961, 1031895551, -1113602338)
		+ W(2, 1054038520, -1097154360, -1121652462, 990918528)
		+ W(3, -1113368985, -1111099810, 1055473117, -1089575247) + W(4, 994604183, 1022227241, 1041335941, -1099647257)
		+ W(5, 1064470249, -1084973552, -1121284913, -1151944468)
		+ W(6, -1112820133, -1102367072, 1063942234, -1086493203)
		+ W(7, 1041044307, -1119623498, 1033755607, 1030939267) + W(8, 1050197537, -1097159533, -1111487017, 1029397803)
		+ W(9, -1120463213, -1111909392, 1058279198, -1096914715)
		+ W(10, 1017418960, -1127714823, 1029129223, 1034973975)
		+ W(11, 1042393881, -1096995926, -1111098786, 1024652821);
	sum2 = W(0, 1008868714, -1138668162, 988655570, -1108603395) + W(1, 1033342078, 1018452757, 1000134020, 1023930211)
		 + W(2, -1099344177, 1041622837, 1025638720, -1115444075)
		 + W(3, -1131179173, -1108628571, -1064898888, -1131013053)
		 + W(4, -1133763810, 1023801183, 1026383992, -1114490385)
		 + W(5, -1066369231, -1087427617, 1033730604, -1118168395)
		 + W(6, -1108980541, 1047990867, 1075540559, -1095163420)
		 + W(7, -1117896039, 1033324797, 1033178726, 1030525898) + W(8, 1086324754, 1057379348, 1031531103, -1116567631)
		 + W(9, -1113100227, -1131668265, 1049763634, 1040828448)
		 + W(10, -1119632759, 1028372534, 1025874080, -1138114226)
		 + W(11, -1100090533, -1109206595, 1025251971, -1128577333);
	WS(-1109283164, -1114463829);
	sum1 = W(0, 1026307305, 1048505142, 1056046207, -1087851802) + W(1, -1097387850, 1043738183, 1010065376, 1006853751)
		 + W(2, 1051849183, -1096622464, 1034233556, 1033008793)
		 + W(3, 1036887575, -1122796048, 1060373686, -1086026376)
		 + W(4, -1106692609, 1030721871, 1032762791, -1121781501)
		 + W(5, 1062361681, -1080983673, -1116217316, 1031320492)
		 + W(6, 1038442146, -1106474773, 1060935143, -1086759863)
		 + W(7, -1136008963, 1024808165, 1036926348, -1140109366)
		 + W(8, 1058739944, -1088322398, -1111740214, 1037732587)
		 + W(9, 983730417, -1113784606, 1052729243, -1098544579) + W(10, 973353381, 1028455576, 1042339968, 1033209828)
		 + W(11, 1060958338, -1085562739, -1098996574, 1032429188);
	sum2 = W(0, 1033103311, -1088826877, 1076551262, 1082157528)
		 + W(1, -1088761642, -1073488400, 1036675590, -1093870598)
		 + W(2, 1064863709, 1075036637, 1044533603, -1083381518) + W(3, 1035316039, -1096260803, 1066303868, 1074566779)
		 + W(4, -1088656095, -1087052440, -1139597621, 1038770367)
		 + W(5, 1054257493, 1054121358, -1096732938, 1034260530)
		 + W(6, -1104037187, -1120383141, -1086745184, -1075712309)
		 + W(7, 1026461691, 1055295113, 1036924272, 1054470917) + W(8, -1080791393, -1075955022, 1058516172, 1062460380)
		 + W(9, -1111374359, 1048854624, -1081541832, -1073360354)
		 + W(10, 1036676016, 1061463967, 1033604811, 1052968175)
		 + W(11, -1074269835, -1068055688, 1036957577, 1072405502);
	WS(-1073690779, -1087724268);
	sum1 = W(0, 1020006630, 1040645890, 1037569760, 1040537741) + W(1, -1102207443, 1011752087, 944113971, 1024788392)
		 + W(2, 1033313762, 1022063376, -1117962707, 1010250996) + W(3, 1028328440, 1048604230, 1026748704, 1037819609)
		 + W(4, 1018608989, 1035208397, 1026519064, -1124203663)
		 + W(5, -1097395091, -1081034849, 1030158086, -1107990331)
		 + W(6, 1023877839, 1026558293, 1058432566, -1089181115) + W(7, 1048090929, 1030700463, 1026744019, -1108217132)
		 + W(8, 1052406658, -1095782133, 1028902900, -1115106384)
		 + W(9, -1116930962, 1024907750, 1046357449, -1103915032)
		 + W(10, 1040820950, 1006665970, 1037411798, -1124509669)
		 + W(11, 1052615509, -1095058991, 1037074644, -1120315546);
	sum2 =
		W(0, 1036147454, 991782552, -1100036784, -1102354425) + W(1, -1132125723, 1037581214, -1115074830, 1025479068)
		+ W(2, -1096384442, 1031211776, -1114551496, -1107514244)
		+ W(3, -1143660011, -1111873890, 1042154750, -1098733186)
		+ W(4, -1120425773, 1036528495, -1109526737, 1054093522) + W(5, 1036720443, 1061883500, 1042458762, -1113752408)
		+ W(6, -1113309480, 1016478163, 1015496998, 1040999099) + W(7, -1118319659, -1131440878, 1006285882, 1035621794)
		+ W(8, -1111840809, -1099055155, 1021928735, 1009305230)
		+ W(9, -1115649745, 1027286665, 1028637267, -1117281017)
		+ W(10, -1113807339, -1115311515, 1026243607, -1108696429)
		+ W(11, 1024623035, -1120753705, 1033776741, -1117838632);
	WS(1053167575, 1034582410);
	sum1 =
		W(0, 1023109013, -1135820801, -1107146278, 1042183330) + W(1, -1106326923, 1038375967, -1105499654, 1041430288)
		+ W(2, 1045138183, 1015167422, 1048594337, -1103059717) + W(3, 1047073940, -1099071824, 1006706653, -1110119411)
		+ W(4, -1101264321, 1036901240, -1103829756, 1051022760)
		+ W(5, -1098544246, -1114407921, 1042439875, 1019390619)
		+ W(6, -1134567319, -1103780951, 1035133548, 1029794991)
		+ W(7, -1115149997, -1122256838, 1029509866, 1038026111)
		+ W(8, -1101742889, 1025810371, -1124355817, 1039002364)
		+ W(9, -1107075490, -1144576488, 1040882462, 1020673517)
		+ W(10, -1133994400, -1113322768, 1028951523, 1034415069)
		+ W(11, -1110494113, -1144644710, 1017843520, 1025775953);
	sum2 = W(0, 1007469645, -1127684796, 1026289720, -1134400734)
		 + W(1, -1121586613, 1012304630, 1024932078, -1122451669)
		 + W(2, 1029479215, -1114161855, 1018968072, 1018258842) + W(3, -1123529450, 934668744, 1048216767, -1092503803)
		 + W(4, 1055026065, -1105610792, -1106895484, 1046133075)
		 + W(5, -1101979386, -1118826374, 1057475450, -1091642753)
		 + W(6, -1154152567, 1050482770, -1086100405, 1054881826)
		 + W(7, 1057991283, -1094138317, 1026396887, -1100501045)
		 + W(8, -1104578417, 1054831843, 1037697257, -1097381938)
		 + W(9, 1034932657, -1112663810, -1110628430, 1037309396)
		 + W(10, 1041220013, -1108645190, -1118589447, -1145059796)
		 + W(11, -1120799353, 1034243151, 1035239909, -1109776821);
	WS(1065106092, 1009251236);
	sum1 = W(0, -1127594260, -1119086128, -1106710454, 1041658930) + W(1, 1028936149, 999711717, 1015119794, 1041681344)
		 + W(2, -1108480942, 1053952044, -1098626929, -1128362792)
		 + W(3, -1105935716, 1038033220, -1085761952, 1059673337)
		 + W(4, -1106493133, 1030156593, 1030756271, -1103164984)
		 + W(5, 1048660750, 1035410928, 1042075767, -1105711219)
		 + W(6, 1015463627, -1097628571, 1062385221, -1083076739)
		 + W(7, 1048795361, -1109139763, 1033714469, -1096661826)
		 + W(8, 1057312254, -1097132616, 1042769246, -1109546740)
		 + W(9, -1121831017, -1162082196, 1045270286, -1100422942)
		 + W(10, 1033263484, -1128821631, 1032817313, 1037645501)
		 + W(11, 1038003425, -1134248242, -1109564844, -1113038632);
	sum2 =
		W(0, 1026504012, -1111982251, -1115575890, 1025515301) + W(1, 1038047283, -1121134093, -1115537349, -1109318355)
		+ W(2, 1037274256, 1036029355, -1140512157, -1118959675)
		+ W(3, 1004448402, -1126991046, 1032461625, -1105715099) + W(4, 1031934837, 966777949, -1120289237, -1114485349)
		+ W(5, 1046084064, 1035923056, -1127252256, 1001443794) + W(6, -1116193727, 1031030421, -1104386736, 1039615788)
		+ W(7, 1008094609, -1126229172, 1023273402, 1036795295) + W(8, 1033981186, 1034803763, -1108137243, 999509622)
		+ W(9, -1106169890, 1038895038, 1034486696, -1111316562)
		+ W(10, 1013721630, -1115420717, -1116296115, 1037382021)
		+ W(11, 1014573341, -1126611440, -1109430807, -1121268263);
	WS(1058235500, 1054922309);
	sum1 = W(0, -1126843838, -1110452882, -1096439037, 1054965252)
		 + W(1, -1126708475, -1113819273, -1115091447, 1026999796)
		 + W(2, -1109530936, 1035486938, 1040994960, -1112039092)
		 + W(3, 1037063794, 1027596138, -1126567064, 1052521111) + W(4, 1048136923, 1029145158, -1097782353, 1043595317)
		 + W(5, -1080972858, 1054616871, -1135709192, -1103625129)
		 + W(6, 1017345397, 1026915457, -1087153329, 1059777872)
		 + W(7, -1117730271, -1113712109, -1106496120, 1051692426)
		 + W(8, -1092439359, 1055199219, 1025849689, -1133876016)
		 + W(9, -1124168315, 1033470169, -1096481402, 1049045985)
		 + W(10, -1109862614, -1120397392, -1111050604, 1047889704)
		 + W(11, -1101856358, 1042302776, 1048178521, 1018059916);
	sum2 =
		W(0, 1032658614, -1104671284, 1033357456, -1107649550) + W(1, -1107785448, 1014985523, 1026047005, 1026757765)
		+ W(2, -1146410551, -1093450531, 1045006287, -1108588814)
		+ W(3, 1016793814, -1106565422, -1129670058, 1029536101) + W(4, 1032863350, -1114405495, 979115576, 1040092458)
		+ W(5, 1049738304, 1048902638, 1031141497, 1032866808) + W(6, 1025048255, -1118382609, 1047130549, 1043845633)
		+ W(7, 1024835039, -1128051766, -1120340424, 1024555245) + W(8, -1099524683, 1031379649, 1016575718, 1011865867)
		+ W(9, -1124528004, -1115048442, -1114147283, 1015256822)
		+ W(10, -1115840886, 1016407002, -1113479651, -1102456829)
		+ W(11, -1143577495, 1032535412, -1140327483, -1121997281);
	WS(1050344663, 1040331465);
	sum1 =
		W(0, -1119034750, -1123846924, 1038870821, 1016005498) + W(1, -1113185550, -1180899430, 1027008397, 1032620906)
		+ W(2, -1145305726, -1104369525, 1047408652, -1117862216)
		+ W(3, -1123135107, -1107606109, 1045963311, -1101093248)
		+ W(4, -1106188838, 1031141157, 1034001074, -1113228665) + W(5, 1055978044, -1091899011, 1019406818, 1025902913)
		+ W(6, -1165785906, -1104523524, 1061494191, -1089807144)
		+ W(7, -1133495032, 995937181, -1109811775, 1044228977) + W(8, 994921841, -1100340494, 1039673315, -1126170822)
		+ W(9, 1012082163, -1136436803, 1043858443, -1113047285)
		+ W(10, 1003314783, -1155810234, 1021442477, 1015486907)
		+ W(11, 1032566715, -1121306753, -1110918342, 1012720916);
	sum2 = W(0, 1017323653, 1006857268, 1027026905, -1096858156) + W(1, 1057582691, -1108630874, 983063098, 1027629321)
		 + W(2, 1041250623, -1096058068, 1069736593, -1103954988)
		 + W(3, -1124332548, 1040636195, -1098379711, -1081757810)
		 + W(4, -1098564102, 1039138402, -1136855038, 1050922570)
		 + W(5, -1095854749, 1046692173, -1092586095, 1040290673)
		 + W(6, 1038193266, -1107256285, -1124475180, 1055388353)
		 + W(7, -1101296593, 1026430908, -1115428487, 1024268384)
		 + W(8, -1107079153, 1044471504, -1099842491, -1135051275)
		 + W(9, 1037749325, -1105738834, 1035306909, 1018283467)
		 + W(10, -1130236866, -1127494735, -1162541650, -1112368096)
		 + W(11, 1041041721, 1034757871, -1116072515, -1128054004);
	WS(1064629676, -1098084920);
	sum1 =
		W(0, 1033302207, 1017516913, 1037844037, 1004101612) + W(1, -1100831258, 1023773169, 1017176603, 986968687)
		+ W(2, 1048067236, -1094217842, 1032944847, 1036346276) + W(3, 1043155505, -1093133598, 1059745345, -1107275372)
		+ W(4, -1118901210, -1109611315, 1036523218, -1136867787)
		+ W(5, 1054752956, -1083111259, -1111571193, 1036061697)
		+ W(6, -1135635048, -1099849236, 1054803234, 1036740290)
		+ W(7, -1104247276, -1130856180, 1036902751, -1112073298)
		+ W(8, 1049105955, -1089373007, 1044914424, -1178541510) + W(9, -1154473427, 1015173986, 1045303547, 1007182507)
		+ W(10, 1032262742, 1028817260, 1031815708, -1108314079)
		+ W(11, 1049045791, -1096296960, 1028425028, -1121119813);
	sum2 = W(0, 1031116538, -1106561538, 1041324255, -1097318271) + W(1, 1038093550, 1003684433, 1018758860, 1041892626)
		 + W(2, -1122918288, 1050772655, -1113042451, 1005733025)
		 + W(3, -1093507837, 1060901401, -1090730175, -1089173269)
		 + W(4, -1103574570, 1036702490, -1142239225, -1094547881)
		 + W(5, 1059998586, 1050575163, -1096117806, 1007559836)
		 + W(6, 1008547208, 1048344650, -1105692057, -1105982083)
		 + W(7, 1045224094, -1111284039, -1115133937, -1106548880)
		 + W(8, -1107738784, 1062167006, -1093777588, 1032209739)
		 + W(9, 1037272918, 1031802380, -1109731964, -1115007264)
		 + W(10, 1040225760, -1119496571, -1116833334, 1032935937)
		 + W(11, -1105354579, 1051274636, -1097190188, 1039213738);
	WS(1059570988, -1104849743);
	sum1 = W(0, 1015935639, -1105217736, -1100062838, 1055580097)
		 + W(1, -1114680436, 1027695934, -1114327981, -1117057793)
		 + W(2, -1095539196, 1051203348, -1104422643, -1122995670)
		 + W(3, 1032097032, 1045549308, -1097913193, 1057098153) + W(4, 1035503236, 1026067698, -1100671580, 994695167)
		 + W(5, -1081463016, 1065307314, -1100709080, -1115820943)
		 + W(6, -1118415719, 1019924475, -1088685699, 1060408535)
		 + W(7, -1100882497, -1121911751, -1146837726, 1044124420)
		 + W(8, -1103538521, 1060044676, -1127513406, 1040976712)
		 + W(9, -1128662677, -1133264506, -1090424260, 1048658511)
		 + W(10, -1106885414, -1109730008, -1106017873, 1026902699)
		 + W(11, -1096642336, 1058793797, -1112552037, 1032897105);
	sum2 =
		W(0, -1101738300, -1102635520, 1049960021, -1107186076) + W(1, 1031463651, -1109595133, 1026251680, 1042860418)
		+ W(2, 1045813894, 1037904592, 1043360780, 1032162510) + W(3, -1096487254, -1118004862, 1012147620, -1101520598)
		+ W(4, -1099464580, -1144663840, -1097132336, -1097577131)
		+ W(5, 1062244087, 1050699569, 1042220045, 1017587638) + W(6, -1103125896, 1034939290, 1030928730, -1118944274)
		+ W(7, -1129575892, -1122088198, -1098301296, -1107323885)
		+ W(8, 1018590462, 996952385, -1143727552, -1112243029) + W(9, -1145491968, 1046219299, 1042676852, -1132230456)
		+ W(10, 1038679603, 1028948530, -1102991820, -1101571742)
		+ W(11, 1048890187, -1120981264, 1022002534, -1108091801);
	WS(-1095386967, -1111219145);
	sum1 =
		W(0, 989878260, 1046105185, 1042696371, -1089927208) + W(1, -1127509006, 1030962098, -1130549149, -1114353482)
		+ W(2, 1044731284, -1092958347, 1029760895, 1015099027) + W(3, 1027494660, -1126247292, 1059356463, -1090136954)
		+ W(4, -1123276603, 1002268463, 1027516453, -1101798869)
		+ W(5, 1066759339, -1086407791, -1134143337, 1008759050)
		+ W(6, -1138329195, -1109199416, 1060963410, -1086208082)
		+ W(7, 1037957160, 1030926587, 1029536895, -1149170463) + W(8, 1056388995, -1087382795, 1028489291, 1024487352)
		+ W(9, 1016226972, -1110945897, 1052477254, -1099705531) + W(10, 1033794703, 1027177352, 1031794584, 1041043200)
		+ W(11, 1048385630, -1090430272, -1116367629, -1155852515);
	sum2 = W(0, 1037152773, -1107393101, -1107499267, -1071982339)
		 + W(1, 1050177526, 1034063245, -1155239869, -1118272906)
		 + W(2, -1123365743, -1066777138, -1099174901, -1111285661)
		 + W(3, -1110337901, -1121008946, 1053226346, 1065602467)
		 + W(4, -1114100047, -1111810642, 1031799544, 1040803769)
		 + W(5, -1091451910, 1078719649, 1051522302, 1032887971) + W(6, -1115579003, 1040826838, 1036591998, 1072207876)
		 + W(7, -1112448128, -1105619991, 1027082675, -1129277077) + W(8, 984589146, 1012365693, 1036247818, 1027337883)
		 + W(9, -1125050611, 1044810576, -1111221822, -1114663567)
		 + W(10, 1024897040, -1128259763, 1027786160, -1128372019)
		 + W(11, -1115106721, 1027240586, 1010421237, -1110086921);
	WS(-1090330604, -1095913405);
	sum1 =
		W(0, 1020138108, -1155846064, -1089580553, 1060107168) + W(1, 1026904097, -1129005794, -1123891981, -1158857313)
		+ W(2, -1099259748, 1041623909, 1034391623, 1027969480) + W(3, 1027835331, 1042832881, -1086143680, 1061453552)
		+ W(4, -1115844409, -1126805065, -1104251929, 1026174194)
		+ W(5, -1083565678, 1065434151, -1108664129, 1015124739) + W(6, 1036891437, 1041459232, -1087459168, 1058328348)
		+ W(7, -1103857816, -1133565543, -1115340623, -1107002233)
		+ W(8, -1094838563, 1058061687, -1108388469, 1018898230) + W(9, 1034060158, 1043482052, -1096454718, 1046178603)
		+ W(10, -1124051644, -1128371111, -1111402939, -1101325435)
		+ W(11, -1097944271, 1056232524, -1124315511, 1016813002);
	sum2 = W(0, -1123501879, 1032645553, 1031823713, 1073269342) + W(1, 1039470942, -1134706270, 994818552, -1106534525)
		 + W(2, 1055123028, 1086127434, -1106004733, -1108902493)
		 + W(3, 1024190209, 1041404870, 1003420836, -1097366650)
		 + W(4, 1048036108, -1131894299, 1026428551, -1104982451)
		 + W(5, -1080276792, -1064048639, 1029604730, 1040747994)
		 + W(6, -1113685733, 1042593674, -1127504591, -1073275019)
		 + W(7, -1102930579, -1114192145, 1033345966, -1115833227)
		 + W(8, 1051480126, -1090368136, -1127043711, 1028687353)
		 + W(9, -1113104927, 1034301013, -1116624943, 1039074558)
		 + W(10, 1016207563, -1110363669, 1032770548, 1019409377)
		 + W(11, 1017007809, -1104405577, 1023925896, 1028902826);
	WS(-1090401964, -1152005757);
	sum1 = W(0, -1107975723, -1110378885, -1108756369, 1036253290)
		 + W(1, -1114963960, -1113670180, 1027213860, -1114833045)
		 + W(2, -1095679285, -1126602324, 1031108853, -1122691487)
		 + W(3, -1098681011, -1110030634, -1106296032, 1055690689)
		 + W(4, -1100045596, -1107558750, 1041527967, -1088517567)
		 + W(5, 1070380432, 1071039479, -1089232274, 1041737494)
		 + W(6, -1104614908, -1108968043, -1108442736, 1052643167)
		 + W(7, -1099409217, -1114805320, -1117487349, -1117626874)
		 + W(8, -1098750614, 1027420045, -1149243844, -1114809497)
		 + W(9, -1139447119, 1013150495, -1103582017, 1037720897)
		 + W(10, -1112117145, -1129003237, -1114124023, -1107640642)
		 + W(11, -1109258534, 1028231256, 1004205268, -1115685308);
	sum2 =
		W(0, 1032241318, -1104603794, -1110024851, 1040884292) + W(1, -1102517567, 1041491703, -1099535875, 1042476400)
		+ W(2, 1036274242, -1098717699, 1017815860, -1106264274)
		+ W(3, 1055385702, -1090035137, -1088795135, 1054345172)
		+ W(4, -1094964358, 1050847172, -1088862448, 1058560544) + W(5, 1070638870, 1049287225, 1049908300, -1097728340)
		+ W(6, 1049303281, -1088861159, -1093985609, 1045145516)
		+ W(7, -1104972980, -1120926078, -1109469239, 1052772694)
		+ W(8, -1106832655, 1028821082, -1121780800, 1040141480)
		+ W(9, -1107728961, -1098593341, 1040915158, -1095210561)
		+ W(10, 1046695263, -1097969166, -1128383244, 1040732759)
		+ W(11, -1094544594, 1053404675, -1097835418, 1042680505);
	WS(-1070853435, -1079594702);
	sum1 = W(0, 1031368074, 1015638464, -1114370347, -1115839497)
		 + W(1, -1115223191, 1032466078, -1129832370, 1041167744)
		 + W(2, -1117069532, -1102391672, 1027397066, 1017764904)
		 + W(3, 1034753191, 1035847262, -1123068615, -1103157041)
		 + W(4, -1112317379, 1032880216, 1015854174, -1103546680)
		 + W(5, 1064504443, -1091637800, -1115479934, -1129698458)
		 + W(6, 1034404179, -1113675090, 1061831318, -1080200908) + W(7, 1034003429, 1015162251, 1016952500, 1024462894)
		 + W(8, 1053421228, -1096184888, 1024063661, -1140051844)
		 + W(9, -1121119193, 1024493276, 1039689052, -1127920108)
		 + W(10, 1021986479, -1133040549, 1030231874, -1128491667)
		 + W(11, 1047845552, -1114780422, -1108195108, -1121925385);
	sum2 =
		W(0, -1106137478, -1112484873, 1057355655, 1035747177) + W(1, -1121112608, -1111886750, 1043473407, -1102332364)
		+ W(2, -1095817987, -1115086293, -1132505032, 1028632460)
		+ W(3, -1106937584, -1092913054, 1065744344, 1023360745)
		+ W(4, -1113186427, -1106034045, 1026389244, -1107744995)
		+ W(5, 1065853704, 1072123343, -1092294539, 1034294011)
		+ W(6, -1112665680, -1097742336, -1081387458, -1079419356)
		+ W(7, -1121542644, 1024287965, 1037682857, 1043622402) + W(8, -1127502696, -1106562006, 1037780507, 1025382780)
		+ W(9, -1122471729, 1020098037, -1107102958, -1106082519)
		+ W(10, 1042075138, 1002478149, -1132137458, 1022975237)
		+ W(11, -1141866869, -1126279403, 1036152561, -1184105122);
	WS(1049779927, -1112776705);
	sum1 =
		W(0, 1028071903, -1118237477, -1102803275, 1029391902) + W(1, 1034486619, -1146402448, -1114011991, 1043483133)
		+ W(2, -1098367878, -1104983021, 1030141823, 1024272361) + W(3, 1029458468, 1007633232, -1088820906, 1052808064)
		+ W(4, 1041927295, -1136262168, -1119065733, 1035764138)
		+ W(5, -1094340312, 1066199650, 1028311666, -1116603171)
		+ W(6, -1132325110, 1035328577, -1080604425, 1053987355) + W(7, -1120802495, 1022508086, 1021654911, 1034435922)
		+ W(8, -1090240908, 1056392483, 1033716813, -1120600656)
		+ W(9, -1140102008, -1138188744, -1148292210, 1036299814)
		+ W(10, -1137351220, -1178578023, -1114327724, -1122000063)
		+ W(11, -1113705707, 1048826612, 1019304377, 1020743116);
	sum2 =
		W(0, 1032570045, 1038214390, -1105258373, 1049712324) + W(1, -1104412018, -1123221706, -1105084280, 1026252154)
		+ W(2, 1013797397, -1092505394, -1106628914, 1042796766) + W(3, 1038138439, 1040403525, -1089116471, 1060934721)
		+ W(4, -1095609080, 997194667, -1106537061, -1094267982) + W(5, 1076181184, 1059180753, -1100140938, 1031304969)
		+ W(6, 1040196930, -1111441511, -1077048432, -1094660144)
		+ W(7, -1105239307, 1025898916, -1115643975, -1113353460)
		+ W(8, 1025617857, -1116351798, 1035183993, -1113508292)
		+ W(9, 1030892929, 1041615042, -1099622062, -1112051433)
		+ W(10, -1108612586, 1036578837, -1115802712, 1045634969)
		+ W(11, 1030853641, 1036834683, -1126459673, -1114596985);
	WS(1046079918, -1101410372);
	sum1 =
		W(0, -1119247786, -1128322399, 1042510685, 1040172212) + W(1, -1102544268, -1115138862, 1028420729, 1041896248)
		+ W(2, 1041276767, 1029165630, 1023180436, 1035447066) + W(3, -1112243383, -1105916230, 1052547749, -1093769957)
		+ W(4, -1094151845, -1116787216, 992275696, 1048641796) + W(5, 1049660162, -1086983984, 1051181214, -1126725978)
		+ W(6, -1122025413, -1106854731, 1058242473, -1090223605)
		+ W(7, 1034028133, 1020616971, -1106451742, 1031954663) + W(8, 1042746961, -1101840568, 1035662026, -1106918309)
		+ W(9, 1031954516, 1008473970, 1045913078, -1131429676)
		+ W(10, -1136064862, 1031591591, -1132155589, -1111364501)
		+ W(11, 1038481040, 1034663574, -1123376855, -1113758304);
	sum2 = W(0, -1141998719, -1109775790, 1044487768, -1123003936)
		 + W(1, -1128896096, -1116651188, -1145824639, -1114337335)
		 + W(2, 1032184652, -1105393491, -1105870753, 1028260552)
		 + W(3, 1031031156, 1035421278, -1118695686, 1043275908)
		 + W(4, -1123077850, -1117301622, 1020781312, -1094152732)
		 + W(5, 1023745864, 1060925239, -1116720242, -1118185274) + W(6, 1022361784, 1019796096, 1018742928, 1035441608)
		 + W(7, 1005384511, -1111756371, 1035727822, -1109500163)
		 + W(8, 1044822196, -1129786704, -1106753069, 1028382728)
		 + W(9, -1106658345, -1126048860, 1018234504, -1154747838)
		 + W(10, -1109895735, -1112885074, 1018984000, -1133379360)
		 + W(11, 1040264262, -1114483694, -1115363912, 1013789936);
	WS(1065850966, 1065849900);
	sum1 =
		W(0, -1148044715, 1023026535, -1096615656, 1051437895) + W(1, 1037565454, 1009078433, 1016251913, 1037817733)
		+ W(2, -1090259708, 1044690723, 1031445334, -1134993406)
		+ W(3, -1121600570, 1025496281, -1086496425, 1060547800)
		+ W(4, -1123828273, -1122338716, -1122606683, 1030608138)
		+ W(5, -1089114938, 1067874188, -1103278290, 961099943) + W(6, -1119487441, 1035148220, -1087399018, 1061971613)
		+ W(7, -1103477215, -1115158089, -1123929445, 1038603949)
		+ W(8, -1089721837, 1051923078, 1017932657, -1152593000) + W(9, 1022387720, 1040789578, -1091666965, 1020371139)
		+ W(10, 1017045638, 1017681054, -1113618935, 1029056085)
		+ W(11, -1090055623, 1050691807, 1041207209, 1032486406);
	sum2 = W(0, 1035054009, 1029203106, -1095822387, -1096883389)
		 + W(1, -1106861506, 1003858895, -1100085534, 1055497340)
		 + W(2, -1094806083, 1022251406, 1025821768, -1141198631)
		 + W(3, 1050236106, -1099101530, -1112580467, -1105263591)
		 + W(4, -1099047212, 1038164225, -1106312974, -1091493710)
		 + W(5, 1065636371, 1066985993, -1090221894, 1007864647) + W(6, 1040394388, 1035688516, 1057422694, 1050729384)
		 + W(7, 1040303734, -1131632326, -1111006317, -1100130836)
		 + W(8, 1038056034, -1113669663, -1095697855, 1034223408)
		 + W(9, -1122528690, 1051271785, -1090043318, -1109365057)
		 + W(10, -1132012078, 1022279531, -1120327060, 1037370697)
		 + W(11, -1101753600, -1098907474, 1042447412, -1111449439);
	WS(-1097113303, -1098536273);
	sum1 =
		W(0, -1128711506, 1026190055, -1089449919, 1051085133) + W(1, 1039600836, 1017357112, 1001100740, -1129782332)
		+ W(2, -1090119792, 1054274400, 1006971045, -1151099700)
		+ W(3, -1116245678, 1036959597, -1089233276, 1059231684) + W(4, 1035061810, 1008174399, -1123204686, 1010531062)
		+ W(5, -1088111001, 1068549146, -1106500579, 1027830380)
		+ W(6, -1122390725, 1040533155, -1083999320, 1060528017) + W(7, -1110173729, -1118330949, 973480529, 1032146359)
		+ W(8, -1100399617, 1051645044, -1118570949, -1138008953)
		+ W(9, -1135175840, 1016950072, -1096337083, 1021720363)
		+ W(10, -1105366950, -1113983621, -1112078369, -1115082484)
		+ W(11, -1098983064, 1056811397, -1163217111, -1114515356);
	sum2 = W(0, -1126544110, 1057867675, -1084782762, -1101472514)
		 + W(1, 1046930113, 1047938716, -1106788080, 1045040387)
		 + W(2, -1103936041, -1095964817, 1060484868, -1116398073)
		 + W(3, -1123763395, -1116688865, -1096694543, 1033632512)
		 + W(4, -1098897900, 1033301960, 1031886252, 1008770068) + W(5, 1065118928, 1070094219, 1055777327, -1112910333)
		 + W(6, 1019879781, -1111977015, -1120781351, -1093909441)
		 + W(7, -1105350592, -1132175940, -1106896864, -1104133845)
		 + W(8, -1094413904, -1091348732, -1098592917, 1028498658)
		 + W(9, 1025236903, -1123575137, 1055216743, -1087869152)
		 + W(10, 1032159773, -1111429301, -1103198659, -1095297610)
		 + W(11, 1063595180, -1101379604, -1090856164, -1148399072);
	WS(-1088872108, 1052196610);
	sum1 = W(0, -1115772244, -1114837443, 1040729928, 999143576)
		 + W(1, 1035543595, -1109636323, 1026268067, -1111544357)
		 + W(2, -1129315660, 1051137549, -1115388138, -1138847608)
		 + W(3, 1022683057, -1104977249, 1050293045, 1050616762)
		 + W(4, -1110255664, -1148093909, -1119255225, -1110507588)
		 + W(5, -1115663356, -1123488747, -1102766242, -1113579532)
		 + W(6, -1126845407, -1124752108, 1055556797, -1107532492)
		 + W(7, -1115121626, 1031428336, 1018606696, -1106979958)
		 + W(8, 1038400791, -1115698508, -1111362474, -1123058305)
		 + W(9, -1122729971, -1118779367, 1043464385, -1106851872)
		 + W(10, -1114761165, 1024891874, -1119390253, 1032957370)
		 + W(11, 1010467373, 1013947482, -1127308771, -1117161611);
	sum2 =
		W(0, 1021571414, -1136485425, 1033792089, 1044650880) + W(1, -1111938281, -1111133361, 1005045849, -1108696907)
		+ W(2, 1026572719, 1068805535, 1042295210, 1015874538) + W(3, 1032761087, 1015124882, -1097148617, 1072674603)
		+ W(4, 1053858128, -1115667125, -1131955840, -1109877489)
		+ W(5, -1072841573, -1073632622, -1114078156, 1025743417) + W(6, 1002892889, 1050593712, 1051731235, 1040667946)
		+ W(7, 986622244, 1029743517, -1113636159, -1105061066)
		+ W(8, 1040799594, -1114163718, -1105514756, -1150165522) + W(9, 1017257782, 1027289415, 1025178361, 1033059623)
		+ W(10, -1131411966, 1028606721, -1116947723, 1035889263)
		+ W(11, 1033387155, -1113785952, 1024784261, -1131685126);
	WS(1059574956, -1147706177);
	sum1 =
		W(0, -1126851274, -1107330821, 1039522745, -1101979721) + W(1, 1039509326, -1113513772, 1032992154, -1114850125)
		+ W(2, 1036915515, -1103811902, 1037543219, -1122830319) + W(3, 990365335, -1111585801, 1058476188, -1091594576)
		+ W(4, 1044635632, -1115799180, 1021792788, 1025219833) + W(5, 1057257569, -1102147871, 1015035920, 999411009)
		+ W(6, 1014654722, 1042448198, -1130368142, 1049911159) + W(7, -1098033363, 1008106627, 1023708133, 1041111834)
		+ W(8, -1087441640, 1046832311, -1103709614, 1030688938) + W(9, 1021433863, 1028566264, -1103664757, 1042912388)
		+ W(10, -1112635561, 998865060, 1024270494, 1025900485)
		+ W(11, -1101532519, 1034347764, -1106561201, 1033251158);
	sum2 = W(0, 1030668111, -1100054904, -1106823977, 1038847176)
		 + W(1, 1045749759, -1139922314, -1138525905, -1127093272)
		 + W(2, -1118630721, 1023505668, -1100949461, -1137789612)
		 + W(3, -1118095530, -1104427366, -1104404781, 1055088734)
		 + W(4, -1106737563, 1025350194, 1046358820, -1094333916)
		 + W(5, 1066330506, 1059364463, -1115593085, -1118124817)
		 + W(6, 1026007575, -1098434999, 1032956568, -1109156363)
		 + W(7, -1105827255, 1044080198, 1036395993, -1114547879)
		 + W(8, -1089680445, -1102029714, 1014767972, -1111415597)
		 + W(9, 1044323398, -1098255510, -1118009606, 1019564502)
		 + W(10, -1114455410, 1034872747, -1102154889, 1043811931)
		 + W(11, -1104253130, 1042217401, 1033201092, -1116871429);
	WS(1056332375, 1037816258);
	sum1 = W(0, -1121656782, -1103168373, -1119737691, 1044637987)
		 + W(1, 1028439953, -1147698697, -1121854558, -1112652978)
		 + W(2, -1116096096, 1045017865, -1108613751, 1015231409) + W(3, 988019291, 1032694229, -1099471067, 1051843657)
		 + W(4, -1124711667, -1126623722, 1027294260, 1032971073)
		 + W(5, -1088930875, 1058468850, -1105155884, 1025720722)
		 + W(6, -1141230927, 1036051832, -1088040995, 1059943427)
		 + W(7, -1110648631, -1125643860, -1146196851, 1029047507)
		 + W(8, -1094038173, 1054278049, 1023373473, 1025459107)
		 + W(9, -1124586778, -1138159876, -1105369135, 1040438911)
		 + W(10, -1109090662, -1140770656, -1119789479, -1116156558)
		 + W(11, -1100717841, 1052440082, -1121068380, 1033302707);
	sum2 =
		W(0, 1037403217, -1101035659, 1032316963, -1116665707) + W(1, -1159849898, 1025618366, 1056969468, -1090106390)
		+ W(2, 1038083410, -1119459300, 1009385423, -1128266716) + W(3, 1057593955, -1080354518, 1060881997, 1028006921)
		+ W(4, 1038355181, -1107076145, 1065979451, -1077736273)
		+ W(5, 1057826659, -1093367622, -1108823981, 1040978108) + W(6, 1052219437, -1095104394, 1040943565, 1050471411)
		+ W(7, 1028403474, -1107763897, 1048107842, -1110113632)
		+ W(8, -1093495590, -1098889696, 1041580846, 1031803963) + W(9, 1012201018, 1035332836, 1023246776, 1037291810)
		+ W(10, -1108503511, 1028340263, 1034400525, 1036232380)
		+ W(11, -1105354500, -1172133380, 1023204972, -1124125618);
	WS(1057728492, -1114894260);
	sum1 =
		W(0, -1113553553, -1137973853, 1030725486, 1027451936) + W(1, 1024408310, -1122023828, -1129994721, 1032124939)
		+ W(2, 1023297510, 1039175515, -1104644784, 1015759447) + W(3, -1116323110, 1038491142, 1042012404, -1096381204)
		+ W(4, -1098358292, -1129065232, 1032700067, 1042214629) + W(5, 1063322480, 1002639809, -1097199096, 1025211173)
		+ W(6, 1022553594, -1102850457, 1049455560, -1095884801)
		+ W(7, 1038368473, -1119912573, -1174372438, -1103814977)
		+ W(8, 1038337085, -1099447670, 1041557913, -1120935138)
		+ W(9, 1025649872, -1108835354, 1036180712, -1107257155)
		+ W(10, -1143485305, 1022194670, -1204938694, -1117610625)
		+ W(11, 1041170774, -1110131186, -1139346043, -1131327617);
	sum2 = W(0, -1132724746, -1136277690, -1115335750, -1142062564)
		 + W(1, -1111737990, 1021138001, -1125894137, 1023794749)
		 + W(2, 1019650853, -1102896527, 1036465851, -1117376889)
		 + W(3, 1008401986, 1034921985, -1111489002, -1095970428)
		 + W(4, -1093339450, 1036367329, -1123753553, -1135255538)
		 + W(5, 1065003137, 1052274635, -1130345777, -1114642052)
		 + W(6, 1028568703, -1095862669, 1042205114, 1050282098) + W(7, 961646223, 983274770, -1129573217, -1103833757)
		 + W(8, -1104966989, 1039075981, -1123958953, -1121876761)
		 + W(9, -1115138968, 989975657, 1028245440, -1124502561)
		 + W(10, 975314596, -1131382405, -1129237393, -1117578737)
		 + W(11, -1137003202, 1029353869, 981021860, -1129104973);
	WS(1064957100, -1084259623);
	sum1 =
		W(0, -1147443767, 1048172674, 1050085746, -1087174820) + W(1, -1110620477, 1041967934, 1002237105, 1022388856)
		+ W(2, 1049301459, -1096483251, -1130736462, 1032395752)
		+ W(3, 1042679235, -1111985505, 1061123934, -1084863818) + W(4, 1036594273, 1029284270, 1025036588, -1105536623)
		+ W(5, 1059891343, -1085360136, -1096717087, 1027822410)
		+ W(6, 1039980881, -1111204540, 1063082922, -1087496217) + W(7, 1049051417, 1038157169, 1039876787, -1118973740)
		+ W(8, 1059164422, -1085023864, -1098175193, 1033526682)
		+ W(9, -1122119878, -1115201293, 1050147791, -1099749261)
		+ W(10, 1038851310, 1035926782, 1046679440, 1036937851)
		+ W(11, 1052477312, -1093770425, -1094492881, 1040430103);
	sum2 =
		W(0, 1043574668, -1079200674, 1070660923, 1052128984) + W(1, -1102512316, -1114631788, -1110691764, -1088609636)
		+ W(2, 1057860954, 1049301959, -1119415890, -1111966430)
		+ W(3, -1103083598, -1104512784, -1107138551, -1106877192)
		+ W(4, -1099577256, 1025811761, -1104224219, 1072315297)
		+ W(5, -1092267131, -1082025998, 1048136354, -1120067756)
		+ W(6, -1111324648, 1071717488, -1073631870, -1098154139)
		+ W(7, -1101281480, -1097839567, 1045365848, 1074062948) + W(8, -1072626825, 1060924493, 1049098296, 1046934152)
		+ W(9, -1123650350, 1072927288, -1076777698, 1055782129)
		+ W(10, 1053482338, -1142912019, 1040472402, 1075518858)
		+ W(11, -1068851440, -1085268633, 1045375219, -1113956244);
	WS(-1075237718, 1059347685);
	sum1 =
		W(0, 1021242911, 1049968737, -1123217820, -1100043508) + W(1, -1123750750, 1039650209, 1033512399, -1159856274)
		+ W(2, 1052611492, -1096977477, 1035058824, -1164938034) + W(3, 1029870036, 1035044013, 1055398719, -1086974821)
		+ W(4, -1111424357, 1031585078, 1022930282, -1122614884)
		+ W(5, 1061884279, -1081627821, 1035852049, -1146263191)
		+ W(6, 1032776022, -1113136009, 1059035017, -1085989237) + W(7, 1046594056, 1040828171, 1018371807, -1134430929)
		+ W(8, 1058365139, -1083853344, 1040835864, -1113397210)
		+ W(9, 1019954077, -1114025505, 1054270736, -1094951367) + W(10, 1036293471, 1041271429, 1033340372, 1040742208)
		+ W(11, 1057072208, -1082038839, 1043435581, -1112152131);
	sum2 =
		W(0, -1109418256, -1082007392, 1074622373, -1087167323) + W(1, -1079889153, 1054843717, 1045686709, -1092895857)
		+ W(2, 1045059925, -1090791673, 1052961109, -1111299754) + W(3, 1025535098, -1097230803, 1022527077, 1061750517)
		+ W(4, -1094791227, -1097908774, 1041368995, -1087580936)
		+ W(5, 1072979117, 1066822104, -1121141584, 1039933817) + W(6, 1025255906, -1090709237, 1059630355, -1104688853)
		+ W(7, -1114952578, -1109459004, 1045341483, 1030380818)
		+ W(8, -1082271661, -1098772696, 1048788253, 1032974905)
		+ W(9, -1131647237, -1098811123, -1098333373, -1097425000)
		+ W(10, -1109808864, 1041274025, 1050563248, -1122444474)
		+ W(11, -1080249300, 1035536875, 1062091865, -1101634861);
	WS(-1073405707, 1071333561);
	sum1 =
		W(0, 1032445482, -1107154225, -1086616986, 1053035442) + W(1, 1037191452, 1005358651, -1114759602, 1043648434)
		+ W(2, -1097373989, 1049497533, -1113096234, -1140703610)
		+ W(3, 1009365348, 1025826187, -1088696011, 1058380737) + W(4, 1042579156, -1147371482, -1116673978, 1050217769)
		+ W(5, -1084271170, 1057270871, 1027100008, 1008260703) + W(6, -1140494528, 1045274198, -1086550017, 1060414079)
		+ W(7, -1122447285, -1128134433, -1138343378, 1041826370)
		+ W(8, -1088202787, 1054213138, 1033632004, -1146407565)
		+ W(9, -1164102249, 1037855412, -1096484208, 1049814032)
		+ W(10, -1117413058, -1132301012, -1128324122, 1036590066)
		+ W(11, -1090407429, 1044502774, 1049279047, 1030979244);
	sum2 =
		W(0, -1104849756, 1044778147, 1087011564, 1051692028) + W(1, -1115275477, 1024288807, -1130309268, 1042344095)
		+ W(2, 1065552014, 1050304642, 1012814276, -1122813731)
		+ W(3, 1032168017, -1115874267, -1071484991, -1095624232) + W(4, 1034711867, 1018071134, 1006608216, 1016899230)
		+ W(5, -1064792716, -1080996320, 1012706900, -1113948677)
		+ W(6, 1025939811, 1015318926, -1108487910, 1038353709) + W(7, 1031018877, 1039145567, -1116205504, 1017541078)
		+ W(8, -1111002668, 1015541566, 1017981722, -1121567210)
		+ W(9, -1134020588, 1025032291, 1026184365, -1115175630)
		+ W(10, 1016059306, -1161414849, 1015836550, -1134707560)
		+ W(11, -1105554232, 1035428553, 1030487759, 957459976);
	WS(-1093094231, 1019545057);
	sum1 =
		W(0, -1147370279, 1024662611, 1045730364, -1100871081) + W(1, -1113292876, -1115285964, -1111661690, 1043371102)
		+ W(2, 1007712219, -1103400446, -1125293706, 1035921815)
		+ W(3, 1036370005, -1098598749, 1063151515, -1086049630)
		+ W(4, 1038700136, -1106696483, -1130128916, -1121967929)
		+ W(5, 1048771569, -1094208743, 1042591246, 1031896756) + W(6, -1138886402, 1034324947, -1102866212, 1057052051)
		+ W(7, -1109292474, -1117085921, -1114353490, 1030255498)
		+ W(8, 1043747359, -1103168823, 1040829042, -1117982022)
		+ W(9, -1139052495, 1020719663, 1042970997, -1114366281) + W(10, -1113681601, 986496271, -1123566046, 983686292)
		+ W(11, 1044423271, -1105757546, -1119014482, -1116127556);
	sum2 =
		W(0, 1017737448, -1113949677, -1109074925, -1106456753) + W(1, 1033894674, 1002006465, -1112488549, 1043174240)
		+ W(2, -1099690943, 1036040708, -1136025401, -1127095326) + W(3, 1041909593, -1095542187, 1055357640, 990810979)
		+ W(4, 1036060652, -1106928479, -1119128646, -1123930650)
		+ W(5, 1063813292, 1064786485, -1095508468, 1041202855) + W(6, 995222883, 1011641777, 1029075282, -1080550900)
		+ W(7, -1096849813, 1028541984, -1138532089, 1043431269)
		+ W(8, -1111808055, -1099317256, 1042059844, 1013308785)
		+ W(9, -1122958336, -1133447353, -1121958092, -1111251400)
		+ W(10, 1031456264, -1130037494, 1002378369, 1011720393)
		+ W(11, -1111615901, -1122017034, 1041840135, 1011740497);
	WS(1065464534, 1066200435);
	sum1 = W(0, -1120929867, -1114034816, -1093428139, 1053507241)
		 + W(1, 1039630850, 1039737375, 1037468205, -1098649416)
		 + W(2, -1095417420, 1053719708, -1117479019, -1104296205)
		 + W(3, -1104046500, 1044270480, -1095455089, 1059517274)
		 + W(4, -1116571174, 1034668025, -1118049328, 1030873567)
		 + W(5, -1078956988, 1062996894, 1037682987, 1027940302) + W(6, 1026495526, 1027018036, -1097112752, 1062358792)
		 + W(7, -1100052716, -1105628906, -1102710553, 1029661039)
		 + W(8, -1090364038, 1051059848, -1134398359, 1047874257) + W(9, 1047356358, 992085460, -1098761015, 1053033759)
		 + W(10, -1124964177, -1105711476, -1104379061, 1014898857)
		 + W(11, -1089997432, 1058137077, -1119205176, 1036556777);
	sum2 =
		W(0, 1052570920, -1079960756, 1059860803, 1024102895) + W(1, -1109439044, 1028585912, -1096757231, -1072214843)
		+ W(2, 1077140634, 1045135233, -1135125103, 1026412089) + W(3, 1032706704, -1067716640, 1078085184, 1007395147)
		+ W(4, 1039504993, 999691338, 1048916325, -1071149720) + W(5, 1074719494, 1048879105, -1119420973, 1031274943)
		+ W(6, 1032567852, -1113086642, -1126012658, -1105291454)
		+ W(7, 1042487387, -1115876939, 1027784571, 1026889523) + W(8, 1023965646, -1125605772, -1107726802, 1031655696)
		+ W(9, -1123035498, -1102782368, 1033915049, 1036400237)
		+ W(10, 1040624471, -1118021143, 1032789056, -1113248449)
		+ W(11, -1131155204, -1120868355, -1123377002, 1033633154);
	WS(-1088460652, -1077196042);
	sum1 =
		W(0, -1106714405, -1126618358, -1100538888, 1061836401) + W(1, -1105561066, 1017778831, 1012745873, -1104692362)
		+ W(2, -1105672234, 1049398341, -1107347643, -1107815087)
		+ W(3, -1106817926, -1128320455, -1096420642, 1063373516)
		+ W(4, -1095103574, 1021813111, 1014233321, -1113350277)
		+ W(5, 1032760733, 1062672955, -1104500106, -1130991024) + W(6, -1139695810, -1104636978, 980853696, 1040237156)
		+ W(7, -1136108756, 1015562593, -1112340330, -1111992333)
		+ W(8, -1098221750, 1049303442, -1098848505, -1124042178)
		+ W(9, -1112616426, -1112151140, 1032069058, -1115352833)
		+ W(10, 1028357771, -1117430379, 1014140598, -1103199781)
		+ W(11, -1124202648, 1047738902, -1108236605, 1024298444);
	sum2 =
		W(0, 1042942941, -1095373315, 1047404354, 1041600542) + W(1, 1029337611, -1116792463, -1103739979, 1042549384)
		+ W(2, -1104635751, 1049880149, -1113660916, 1033409028)
		+ W(3, 1021675082, -1100136800, -1156628070, 1042313351)
		+ W(4, -1103511888, -1100575516, 1031504716, 1032277385) + W(5, 1056265483, -1095000083, 1052284225, 1042607543)
		+ W(6, -1103784377, 1051314558, -1086627236, 1058671506)
		+ W(7, -1098025422, -1102539848, 1021140017, -1097536524)
		+ W(8, 1056610233, -1087499329, 1053296214, -1123811627) + W(9, 1032312275, 1033748340, -1097748456, 1053303874)
		+ W(10, -1097031052, 1034071897, -1113021145, 1006926454)
		+ W(11, 1032415346, -1106742186, 1040224097, -1116904421);
	WS(-1090190636, 1052333694);
	sum1 = W(0, -1118008162, 1046164882, -1087764995, 1050774996) + W(1, -1132114980, 992812356, 1017370722, 1025512151)
		 + W(2, -1107299674, -1113611419, -1133738119, -1143374172)
		 + W(3, 1028313190, 1039176172, -1107276920, 1042980645) + W(4, 1016759930, 1031741320, 1032465571, -1140639831)
		 + W(5, 1054861041, -1104478910, 1039228938, 991966796) + W(6, 1021024634, -1114523818, 1048774281, -1116066086)
		 + W(7, 1029146129, -1131726971, 1022145795, -1123803590)
		 + W(8, 1052546887, -1088290914, 1046828701, -1135053738)
		 + W(9, 974396430, -1114987978, 1033108808, -1101829203)
		 + W(10, 1025239231, -1135839572, 1023704762, -1150325779)
		 + W(11, 1052242867, -1082760046, 1050382392, -1117633184);
	sum2 = W(0, -1112927492, -1126311221, -1124129707, -1089259297)
		 + W(1, -1121960162, -1127721129, 1000278501, -1112124316)
		 + W(2, 1030656727, -1136644755, -1119195008, -1143597573)
		 + W(3, -1115114722, -1096516945, 1062718459, -1089907054)
		 + W(4, -1113085858, 1010259715, 1038568093, -1095439368)
		 + W(5, 1069168233, 1066488720, -1108783853, 1016497897)
		 + W(6, -1107752992, 1035770391, -1092856910, 1057602472)
		 + W(7, -1101947316, -1142073349, 1036864823, -1173738153)
		 + W(8, -1097729376, -1119016562, -1105922885, 1034450025)
		 + W(9, -1111435217, -1127749525, -1108466839, 1028769031)
		 + W(10, -1119106133, -1113345821, 999311589, -1118042174)
		 + W(11, -1106807928, -1101412503, -1119408565, -1121786357);
	WS(1050584535, 1068150000);
	sum1 =
		W(0, -1115260532, 1034938395, 1038987194, -1117589351) + W(1, -1115913835, 1013034091, 1010165469, -1115625742)
		+ W(2, 1047833470, -1104527215, -1116485512, 1026352434)
		+ W(3, -1112895478, 1043729220, -1102791097, 1041775364) + W(4, 1035117570, -1123123343, 1003680362, 1046586119)
		+ W(5, 1053057826, -1092950416, 1032942189, -1126776150)
		+ W(6, 1038151522, -1096382429, 1060286702, -1085160955)
		+ W(7, 1051158381, -1118268740, -1113655284, 1036369142) + W(8, 1031810112, -1099697720, -1109351189, 992197073)
		+ W(9, -1132334157, -1110737789, 1033665067, -1112334730)
		+ W(10, 1035094123, 1007592182, -1116596385, 1020311663)
		+ W(11, 1045919272, -1112800213, -1113211075, -1128843070);
	sum2 = W(0, 1027450901, -1130117632, -1112751331, 1023748039) + W(1, -1129067048, 1020055214, 999052617, 1037992777)
		 + W(2, 1031860941, -1148181737, 1031574877, -1123191999)
		 + W(3, 998486633, 1035832253, -1100828230, -1107268336)
		 + W(4, -1108371420, -1176849298, -1098069390, 1058826704)
		 + W(5, 1066377631, 1031601953, -1110435251, 992240434) + W(6, 1050271656, -1075559944, 1059983898, -1105105514)
		 + W(7, -1111123861, 1022099846, -1144500281, 1051052067)
		 + W(8, -1089703828, 1006070601, -1135053221, -1122685646)
		 + W(9, 1034115809, -1104035684, 1037142243, 1031181077)
		 + W(10, 1013422629, -1154287506, -1111215245, 1041076323)
		 + W(11, -1116488683, -1123703892, 994427506, 1025316569);
	WS(1065940278, 1034622363);
	sum1 =
		W(0, -1130882111, 1042781009, 1048563851, -1106282856) + W(1, 991352096, -1132163876, 1018945629, -1105035701)
		+ W(2, 1039562393, -1093168999, -1128564863, -1146137419)
		+ W(3, 1038546130, 1037583679, 1050832116, -1106056839) + W(4, 1040441019, 1034240611, -1109081570, -1089961211)
		+ W(5, 1065150616, -1081267407, -1125259845, -1103163033)
		+ W(6, -1116833467, -1106689964, 1063013875, -1093571617) + W(7, 1037655800, 1014989293, 1027338207, 1025705412)
		+ W(8, 1053064399, -1098826451, 1032573560, -1132178841)
		+ W(9, -1118439678, -1110899849, 1043578884, -1098971955)
		+ W(10, -1126802554, -1140385876, 1023675896, 1000818681)
		+ W(11, 1052844651, -1103816344, -1174556270, -1124029942);
	sum2 = W(0, 1042045232, 1025081894, -1120251562, -1098032480)
		 + W(1, -1122897683, -1131598407, -1100582068, 1047796551)
		 + W(2, -1130142714, 1051286467, -1114446743, 1028094206)
		 + W(3, 1051353130, -1135649915, -1091982339, -1088973774)
		 + W(4, 1048662352, -1114986235, -1098661297, -1083821047)
		 + W(5, 1066411068, 1066192686, -1098476628, 1035402858)
		 + W(6, 1033093932, -1113123121, -1108263063, -1096817778)
		 + W(7, 1043244089, -1113670703, 1041505758, -1102707738)
		 + W(8, -1116829613, -1124748705, -1105512115, 1040252082)
		 + W(9, -1111611431, 1042774566, 1029093314, -1115318079)
		 + W(10, 1039955893, -1113507172, 1036803556, -1119704488)
		 + W(11, -1105374597, 1039210409, -1115075522, -1136180467);
	WS(1056991468, -1087030746);
	sum1 =
		W(0, -1123211458, -1104816506, -1105628499, 1049039296)
		+ W(1, -1110865210, -1119944116, 1040392564, -1123900599) + W(2, 1035944426, 1031104918, 1038992913, 1019968535)
		+ W(3, -1107179074, -1097679367, -1092912076, 1058030045)
		+ W(4, -1092536332, -1113705364, 1032323379, 1050060447) + W(5, 1043269081, 1044634502, 1052766173, 1024115141)
		+ W(6, -1112698351, -1113372906, -1098944114, 1032247835)
		+ W(7, -1101773536, 1016666555, -1113154609, -1118981766)
		+ W(8, -1111852653, 1043769326, -1111088882, -1113641643) + W(9, 1035059984, 1036804874, 1030188977, 1035537687)
		+ W(10, 1017337855, 1034739876, -1117349658, -1117759553)
		+ W(11, -1099907470, 1048904265, -1120093295, -1119368937);
	sum2 = W(0, 1038207100, -1100024892, 1019998746, -1116235844)
		 + W(1, 1028590129, -1132429552, 1055370704, -1091918952)
		 + W(2, -1108168198, 1051323790, 1017416940, -1131674494)
		 + W(3, 1017023961, -1082116017, 1065911065, -1096201210)
		 + W(4, 1032160655, -1107738152, -1102268135, -1125190319)
		 + W(5, 1060923636, -1094794141, 1048662690, -1115273448)
		 + W(6, -1122475964, 1048656820, -1095962080, 1023749917)
		 + W(7, 1005611185, -1120617509, 1023693826, -1118701724)
		 + W(8, 1025593786, -1112111831, -1121410776, 1032669658) + W(9, 1033230771, 1009208157, 1022143062, 1028403793)
		 + W(10, -1131420642, 1007544955, -1120372849, 1017593165)
		 + W(11, -1123799386, -1116942925, 1018425448, 990755743);
	WS(1065408790, 1036624080);
	sum1 =
		W(0, 1031689276, -1095782030, 1040908418, 1044865119) + W(1, 1010781241, -1124793181, -1118902603, 1036811736)
		+ W(2, -1099523235, 1048657234, -1114118270, -1132122507)
		+ W(3, -1130392064, -1106389326, -1100633526, 1056569877)
		+ W(4, -1105362262, 1010247305, -1130349122, -1116251760)
		+ W(5, -1088986706, 1059819669, -1109527143, 1021657598)
		+ W(6, -1124855342, 1016267643, -1097124896, 1057017186)
		+ W(7, -1101014271, -1147394236, -1120117724, -1116551776)
		+ W(8, -1093812931, 1059687187, -1105256235, 1019294354) + W(9, 1032115325, 1029730958, -1102530619, 1046000250)
		+ W(10, 1028862634, -1131137795, -1114562026, -1110739566)
		+ W(11, -1093706094, 1058243684, -1118348593, 1010280523);
	sum2 = W(0, 1008018405, 1028827850, 1048442625, 1022982076) + W(1, 1015261982, 1023643398, -1131603511, -1115409151)
		 + W(2, -1128423353, 976919119, -1110305290, -1142661114)
		 + W(3, 988821927, 1044469435, -1144038842, -1106419532)
		 + W(4, 1025710382, 1024565032, -1126539767, -1105522597)
		 + W(5, -1080807551, -1069309764, -1128896061, -1156968388)
		 + W(6, 1029044494, 1031515550, -1100063920, -1077869698)
		 + W(7, 1034212953, -1108906576, -1154431236, 1029512486) + W(8, 1047735839, 1057375362, 1047372093, 1040986767)
		 + W(9, -1144594818, -1118759177, 1049631559, 1074645104)
		 + W(10, -1121013958, -1109343217, -1134541747, 1017115388)
		 + W(11, 1040817807, 1074183528, 1028992794, 1013497529);
	WS(-1134496480, -1135409208);
	sum1 =
		W(0, 1012816882, -1118561391, -1172095542, 1042727039) + W(1, -1101252924, 1038725048, -1131032216, 1023949458)
		+ W(2, -1135187513, -1111514505, 940438235, -1118209095) + W(3, 1015795842, 1025102291, -1122643706, 1044113108)
		+ W(4, -1099247502, 1039141810, 1017081284, -1098855254)
		+ W(5, 1062211658, -1088869665, 1037442288, -1110868352)
		+ W(6, 1032335660, -1109465919, 1053298610, -1090758606)
		+ W(7, 1036453998, -1124785329, -1114842158, 1018180354)
		+ W(8, 1055550179, -1097017583, 1038283500, -1123999226)
		+ W(9, -1121133019, 1039697400, -1104417019, 1024023145)
		+ W(10, -1127849669, 984058180, 1020892138, -1121622748)
		+ W(11, 1042088653, -1131309822, -1111728213, 985363057);
	sum2 =
		W(0, 1027844464, -1123756397, -1109401613, -1123223808) + W(1, 1035039619, -1128717516, -1120185020, 1023474305)
		+ W(2, 1009596088, 1048386893, -1119575836, -1197272208)
		+ W(3, 1033301171, -1120807818, -1105464515, -1117881742)
		+ W(4, 1029989604, -1129559846, -1142892826, 1045181163)
		+ W(5, -1069578385, -1079085438, 1032607110, 1013531724) + W(6, -1130897478, 1050514681, 1080182479, 1057107198)
		+ W(7, -1113328530, 1001587842, -1112219415, -1148494098)
		+ W(8, 1033916695, -1155326684, -1143648562, -1126181730)
		+ W(9, 1008317678, -1124897908, -1111316356, 1015620530)
		+ W(10, 1010222764, 1011089790, -1123809910, -1112292483)
		+ W(11, 1038900121, -1138311341, -1144599918, -1129634008);
	WS(1063953772, 1006246735);
	sum1 = W(0, -1129265445, 1023929568, 1050480356, -1094701786)
		 + W(1, 1037312131, 1034664643, -1103221880, -1113408580)
		 + W(2, 1053092565, -1092563365, -1114954585, 1012249970)
		 + W(3, -1129858606, -1152025615, 1054804888, -1099755687)
		 + W(4, 1041973195, 1007014628, -1113052252, -1124775629)
		 + W(5, 1058637767, -1081976315, 1043978961, 1034276907) + W(6, 970168057, -1116248388, 1061520345, -1085039957)
		 + W(7, -1109284733, -1121545966, 1035503657, -1112901548)
		 + W(8, 1052655373, -1106127939, 1037644971, 1031841028)
		 + W(9, -1114702297, -1114551939, 1043614208, -1104465584)
		 + W(10, 1036504960, -1122618723, 1026538155, 1012918985)
		 + W(11, 1053852345, -1094975651, -1153236991, 1015394179);
	sum2 = W(0, -1108119214, -1098605940, 1035846227, 1036002502)
		 + W(1, -1110269476, -1115932080, -1096454441, 1047215192)
		 + W(2, -1114546522, 1051355228, 1034086715, 1019597651)
		 + W(3, -1110533412, -1103381544, 1042040175, -1102267339)
		 + W(4, -1102892813, -1130886478, -1119694402, -1128298432)
		 + W(5, 1054173861, 1055154953, 1033662351, -1108620470)
		 + W(6, -1127729168, -1115663656, -1103681801, 1052945690)
		 + W(7, 1018137856, 1033484697, -1110958880, -1114162078)
		 + W(8, 1035812038, -1097546689, -1135158408, -1106956606)
		 + W(9, 1023031785, 1023974294, 1020649501, 1033369183) + W(10, 998437331, 1029836288, -1130979192, -1102917557)
		 + W(11, 1043843622, 1033695483, -1106336801, 1026224246);
	WS(1049960663, -1098656338);
	sum1 =
		W(0, -1129270334, -1097905355, -1106458043, 1053746044) + W(1, -1153859324, -1120671826, 1010743226, 1038429850)
		+ W(2, -1094238830, 1050579558, 1008020477, 1036488405) + W(3, -1116543140, 1026505899, -1084542826, 1060156652)
		+ W(4, -1101873487, 1033306211, 1036165346, -1111354490)
		+ W(5, -1093117384, 1065413702, -1122984978, 1035776465)
		+ W(6, 1026370235, 1012909508, -1096055524, -1110641506) + W(7, -1132001470, 1015184758, 1026933359, 1034045586)
		+ W(8, -1093158415, -1140159326, 1048347588, -1115507932)
		+ W(9, 1009750007, -1139624135, -1113672231, -1153271990)
		+ W(10, 1027525597, 1024719161, -1164389112, 1033987231)
		+ W(11, -1098353419, 1046556600, -1124973593, 1037016731);
	sum2 =
		W(0, 1007202997, -1107138382, -1101985157, -1105521455) + W(1, 998286218, -1135144653, 1038605814, -1092409649)
		+ W(2, -1111080585, 1031799434, -1127152184, -1138707909)
		+ W(3, -1111184485, -1086536233, 1058778058, -1102287591)
		+ W(4, 1043783051, 1018462794, -1097778206, 1033842165) + W(5, 1062592323, 1054124413, -1107786643, -1134709509)
		+ W(6, -1107862779, 1050500010, -1115904936, -1121603522)
		+ W(7, -1104929125, 1016336685, -1126800416, -1107791267)
		+ W(8, 1050870644, 1039372702, -1103666737, 1035379787) + W(9, -1122928880, 1035028069, -1115500703, 1030823202)
		+ W(10, -1123649878, -1120475406, -1117103670, 1024236113)
		+ W(11, -1137706913, 1012044041, 1042413442, -1119073178);
	WS(1045571246, -1101396513);
	sum1 =
		W(0, 1027156266, -1105879340, -1095381975, 1052608133) + W(1, 1036979366, -1116386461, -1135540454, 1031079263)
		+ W(2, -1094890856, 1052732944, -1110160581, -1124519785)
		+ W(3, -1123739311, 1036462891, -1086841044, 1059410250)
		+ W(4, 1033495803, -1113888968, -1123826896, 1048275928) + W(5, -1081913239, 1057453824, 986236332, 1015417435)
		+ W(6, -1110505155, 1040289247, -1087831711, 1053535332)
		+ W(7, -1121128186, -1106215130, -1138173481, 1033674439)
		+ W(8, -1095054872, 1059217778, -1117509614, 1025380519) + W(9, 1019384210, 1035302207, -1100616678, 1056369955)
		+ W(10, 1002559041, -1132265864, -1138775820, -1109766005)
		+ W(11, -1096527684, 1057086003, 1031959012, 1009437253);
	sum2 =
		W(0, 1023702857, 1025579445, -1107828603, 1030949885) + W(1, 1030056541, -1138881396, -1116086512, 1041684936)
		+ W(2, -1100190580, -1127701406, -1101693823, 1031874044) + W(3, 1027064225, 991232624, -1127488618, 1063977916)
		+ W(4, 1026840857, -1115029594, 1024261913, 1049263730) + W(5, -1121382305, 1081524863, 1032271344, -1124133978)
		+ W(6, -1115739014, 994389040, 1049530396, 1074557390) + W(7, 1041139218, 1015337722, 1023117658, -1121855219)
		+ W(8, 1041567276, -1078514947, 1024600809, -1113125346)
		+ W(9, 1011341860, -1121905805, -1097196557, -1067412604)
		+ W(10, -1110332083, -1157524144, 1016675050, -1114246345)
		+ W(11, -1125328530, -1072747255, 1045882874, 1009384836);
	WS(-1091844311, 1066789497);
	sum1 = W(0, -1126657090, -1121934839, 1053346558, -1094816004)
		 + W(1, -1134360567, -1196074864, -1118280816, -1104655157)
		 + W(2, -1150447404, -1096277599, 1026981217, 1030410603)
		 + W(3, 1035276339, 1036892560, 1061301148, -1095276499) + W(4, 1035239934, -1117233544, 1034822275, 1041291861)
		 + W(5, 1054539137, -1085328499, -1132053288, 1032377106)
		 + W(6, -1122398524, 1016354085, 1061579109, -1094948141)
		 + W(7, 1041572288, -1113536398, 1027512241, -1100932977)
		 + W(8, 1052329175, -1090319102, -1138204721, 1028691858)
		 + W(9, -1105911320, -1113195754, 1010492736, -1109759879)
		 + W(10, 1026669711, 1016723124, 1036073133, -1137558275)
		 + W(11, 1052092547, -1096198988, -1122862318, 1004385343);
	sum2 =
		W(0, -1130924015, 1022730742, -1156842543, 1039023607) + W(1, -1147026848, 1024455841, 976327856, -1107671502)
		+ W(2, 1030703882, -1100688592, -1113451109, 1015244616) + W(3, 1006816288, -1102494949, 1050591037, 1039287442)
		+ W(4, 1030233046, -1121583866, 1032746467, -1063244855) + W(5, 1084548157, -1091568120, 1034384724, 1032201434)
		+ W(6, -1109752024, -1117144683, 1041535529, 1042495948)
		+ W(7, 1024850879, -1112832588, 1030725620, -1118200508) + W(8, 1030607420, -1100624377, 1037336210, 984232072)
		+ W(9, -1118656485, 1023153636, -1117378226, 1033109796)
		+ W(10, -1123040622, 1003511712, 1013150272, 1019358625)
		+ W(11, 1000111712, -1135441064, 1025293966, -1124806470);
	WS(1062375148, 982896070);
	sum1 =
		W(0, 1041356906, -1092346958, -1098857839, 1052252533) + W(1, 1050501706, -1165233042, -1141741512, 1042371688)
		+ W(2, -1100631199, 1048733184, -1126563284, -1134397903)
		+ W(3, -1123251246, -1107640316, -1093348349, 1057292943)
		+ W(4, 1043133649, 1008063554, -1121772047, 1037798623) + W(5, -1081710855, 1063732968, -1111246422, 1032268279)
		+ W(6, -1138991637, 1035668286, -1084667272, 1061645578) + W(7, -1112114769, 988108978, -1156317853, 1026956462)
		+ W(8, -1088318752, 1059891330, -1106214611, 1037368483)
		+ W(9, -1161666833, 1016120313, -1093940123, 1051947731)
		+ W(10, -1109426316, -1138661789, 1011726474, -1115727625)
		+ W(11, -1084607638, 1059995535, -1190508359, 1040598420);
	sum2 = W(0, -1087149149, -1081699534, 1075074133, 1074122230)
		 + W(1, 972078363, -1097056662, -1111774062, 1035582541) + W(2, 1078981756, 1067224402, -1092574897, 1045566397)
		 + W(3, -1122195827, -1087576154, 1080077903, 1066418532)
		 + W(4, -1094572008, 1049096521, 1039123010, -1082404199)
		 + W(5, -1086433828, -1082120864, -1101495601, -1109136155)
		 + W(6, 1035630599, -1111170675, -1073636555, -1078722695)
		 + W(7, -1124013413, 1034655424, 1055099903, -1119441337)
		 + W(8, -1080599553, -1083892454, 1051613332, 1023040696)
		 + W(9, 1042757145, -1097950160, -1080969229, 1038753292)
		 + W(10, 1020974546, 1027077203, 1060125526, -1098859385)
		 + W(11, -1075310961, -1085615144, 1056506110, -1129411423);
	WS(-1073733835, -1077508759);
	sum1 =
		W(0, 1004911573, 1043185540, 1056421033, -1084678800) + W(1, 1025064353, 1009545653, 999004239, -1120942224)
		+ W(2, 1054442442, -1094509130, 1020812405, 1022285001) + W(3, 1008908284, -1136904037, 1059517190, -1087084867)
		+ W(4, -1149079216, -1118599969, 1032559088, -1114184455)
		+ W(5, 1066321721, -1089134469, -1127746091, 1007063543)
		+ W(6, -1123346838, -1112686066, 1063474337, -1088382556)
		+ W(7, 1027145139, -1149726053, 1021646261, 1032555200) + W(8, 1052962698, -1089853747, -1126936380, 1015641511)
		+ W(9, -1114632613, 1005792618, 1044159722, -1092765869) + W(10, 1027348136, 1023282088, 1036339578, 1040940927)
		+ W(11, 992460573, -1093589176, -1126618160, 981480241);
	sum2 =
		W(0, 1016441223, 1040812131, -1091551076, -1083270432) + W(1, 1054198423, 1001473573, -1123853806, -1136381199)
		+ W(2, 1020713637, -1123741604, -1108424657, -1110846033)
		+ W(3, 1034027700, -1121560396, -1092123318, 1057043619)
		+ W(4, -1115262538, 1008724259, 1016212045, -1100123577)
		+ W(5, 1069362941, 1065772322, -1092584961, -1120589670) + W(6, 1025170155, -1100550013, 1050653373, 1058297195)
		+ W(7, -1121642970, 1040111989, 1030169991, -1105283667)
		+ W(8, 1020763615, -1091989226, 1029919048, -1104422780)
		+ W(9, 1024326153, 1029487024, -1121149602, -1092470882)
		+ W(10, 1039520200, 1027795061, 1020004331, -1102325825)
		+ W(11, -1094990109, -1106605421, 1026718342, -1115881428);
	WS(-1083424620, -1083774644);
	sum1 =
		W(0, 1025997707, -1107578509, -1116799831, 1051882641) + W(1, -1114213177, -1140244728, 995558823, -1112668224)
		+ W(2, -1098861996, 1045883512, -1127946135, -1116793621)
		+ W(3, -1132669247, -1109754213, -1099316274, 1060321715)
		+ W(4, -1106758402, -1131243108, 1015677409, 1048694360)
		+ W(5, -1079768279, 1059777970, 1040276008, -1129876893)
		+ W(6, -1113673299, -1099923633, -1093459346, 1064776049)
		+ W(7, -1108196294, -1167573435, -1146244698, 1044345284)
		+ W(8, -1098475085, 1036566882, 1008462282, 1020492609) + W(9, 1028038186, -1117921566, -1113981277, 1042756750)
		+ W(10, -1117078569, 1015090721, -1119640804, 1030760459)
		+ W(11, -1105585281, 1033934183, -1130472177, -1176961296);
	sum2 =
		W(0, -1120400279, -1120118931, -1114073896, 1044457775) + W(1, 1036833596, -1137956564, 1006239848, -1112851025)
		+ W(2, 1016448074, -1095953339, -1112980685, -1122147671)
		+ W(3, 1033967902, -1101370370, 1047917593, 1065044078) + W(4, -1119396143, 987310366, -1138878316, 1037781128)
		+ W(5, -1113781647, 1069276419, -1110041421, -1187381491)
		+ W(6, 1012842788, -1100258045, 1045546113, -1075186216)
		+ W(7, -1132903556, -1131003226, -1135736068, 1002346920)
		+ W(8, -1114666278, 1035717470, -1120766465, 1029533357)
		+ W(9, 1028356101, -1112182778, 1002645288, -1097061266) + W(10, 1015304410, 1003776904, -1120658117, 995892591)
		+ W(11, -1115876966, 1049663208, -1123504973, -1150885167);
	WS(1055938007, -1113494123);
	sum1 =
		W(0, 1002908945, 1028210664, -1133494457, -1135464580) + W(1, 1008466835, -1131269290, 1005413771, -1117675639)
		+ W(2, 1035958810, -1095959351, 1040264713, 1035203030) + W(3, 1025040167, 1040926954, 1041989700, -1087581816)
		+ W(4, 1048292991, -1116685065, 1016082831, -1118443670)
		+ W(5, -1101702418, -1121242873, 1034336763, -1117662885)
		+ W(6, -1114102015, 1040854289, -1098047787, 1048632765) + W(7, 1043249233, -1132796663, 1024456642, 1046508410)
		+ W(8, -1093641223, 1052220147, -1183964258, -1144182458)
		+ W(9, -1121270129, 1019764906, -1111985289, 1025236686)
		+ W(10, 1036425152, -1137681823, 1006080470, 1029150738)
		+ W(11, -1102768646, 1042463785, -1131127167, 1031884341);
	sum2 =
		W(0, -1148833389, -1103329032, 1039527980, 1036545465) + W(1, -1140514638, -1111163586, 1034952858, -1114547380)
		+ W(2, 1019372679, -1111710878, 1042452640, 1025974311) + W(3, -1131645803, -1099667252, 1017530647, 1040867364)
		+ W(4, 1048394746, -1102843950, 1044582101, 1046239383) + W(5, -1095619156, 1074171367, 1046568773, 1030125627)
		+ W(6, -1100126968, 1038848953, 1053527025, -1072583834) + W(7, -1104419698, 1045672947, 1041029558, 1023994452)
		+ W(8, -1122648352, -1089175055, -1095650184, 1033990232)
		+ W(9, -1101188496, 1040593566, 1048348234, -1110512168)
		+ W(10, -1113024814, 1039972451, 1038559400, -1104909140)
		+ W(11, 1034383711, 1048723535, -1105559093, -1123744674);
	WS(1054254551, 1014537956);
	sum1 =
		W(0, -1121039367, 1035774671, -1112598570, -1132150029) + W(1, -1109088445, 1040615567, 1018675757, -1130008697)
		+ W(2, 1008273253, -1122251932, -1109769252, 1003469451) + W(3, 1022410264, 1030747950, -1093495169, 1041075666)
		+ W(4, -1103842329, 1040565356, 1028321069, -1107714718)
		+ W(5, 1061840455, -1100441032, -1105690119, -1126038165)
		+ W(6, 1032078897, -1097508911, 1062686448, -1084814013)
		+ W(7, 1049125597, -1115375938, 1035879540, -1100889147)
		+ W(8, 1058139578, -1090418276, 1045096257, -1105705223) + W(9, 998902321, -1111836109, 1050284599, -1098262366)
		+ W(10, 1018266794, 1030169589, 1035017184, -1112194220)
		+ W(11, 1050365160, -1104639554, -1137878196, -1123088958);
	sum2 =
		W(0, 1011204314, -1130282463, -1119643322, 1040567914) + W(1, 1058038651, -1092395975, -1151906447, 1008292026)
		+ W(2, 1036989282, -1093705400, 1048788001, 1041384381) + W(3, -1132982086, -1113509623, 1023195387, 1046529995)
		+ W(4, 1069827352, -1082188469, 1015334447, -1118416042) + W(5, 1031871454, 1053486166, 1061661513, -1087135929)
		+ W(6, -1126682819, 1010705513, 1036745108, 1053627848) + W(7, -1076895592, 1050130047, 1031867988, 1015562377)
		+ W(8, -1105750465, -1097180463, -1083563182, 1062283738)
		+ W(9, -1118412630, 1033032763, 1024841875, 1042871577)
		+ W(10, -1102862368, -1108358221, 1019402007, -1171211484)
		+ W(11, -1132045005, -1098551422, -1093245544, 1058279550);
	WS(1057163500, -1105993220);
	sum1 =
		W(0, -1117201821, -1127293622, 1046510122, -1119279260) + W(1, -1111026820, 1018908832, -1121502764, 1045431725)
		+ W(2, -1097880614, 1032698105, 1044535287, -1110256660)
		+ W(3, 1035599249, -1100979748, 1061106926, -1097882833)
		+ W(4, -1095331735, 1024080836, -1105708961, 1049617722)
		+ W(5, -1099817760, -1088567265, 1053288920, -1117593824)
		+ W(6, 1039647740, -1110465655, -1119635500, 1058361641)
		+ W(7, -1096979757, 1027464313, -1100922079, 1042176840)
		+ W(8, -1109566363, -1097567811, 1050620014, -1113789929)
		+ W(9, 1009912816, 1018827936, -1147860066, 1036626725) + W(10, 999121112, -1159432152, -1136735831, 1001114727)
		+ W(11, 1037588842, -1111863248, 1037098289, 1012647057);
	sum2 = W(0, 1032576295, -1107895050, 1016729470, 1038099246)
		 + W(1, -1122727069, -1114110583, -1123342042, 1039805910)
		 + W(2, -1102939450, -1120156902, -1128970625, -1124467804)
		 + W(3, -1102694716, 1052615154, 1050355566, -1100691281)
		 + W(4, 1046407453, -1110408836, -1132748357, 1027679479) + W(5, 1057040101, -1098318717, 997134844, 1035923921)
		 + W(6, -1114775905, -1183264704, 1041423933, 1028185223)
		 + W(7, -1094682594, 1040728790, 1033817148, -1127944484)
		 + W(8, -1098800812, 1043085543, 1023808656, -1104134547) + W(9, 942234367, 1017960690, 1027447559, -1113846578)
		 + W(10, 1033077879, -1111084310, -1109637447, -1117652574)
		 + W(11, -1113353192, 1025700351, -1136470782, 1024627457);
	WS(1069430838, -1077807532);
	sum1 = W(0, -1123171840, 926704291, 1028287308, 1024652287)
		 + W(1, -1121358347, -1124249574, -1123870031, 1035074891)
		 + W(2, 1030377682, -1104443381, -1137933441, -1123723658)
		 + W(3, 1012978707, -1102713036, 1060355037, 1049114747)
		 + W(4, -1102473935, -1124350158, 1026708965, -1094582899)
		 + W(5, 1064667974, 1049334299, -1095444677, -1155502135)
		 + W(6, 1032241614, -1104095024, 1044883747, -1097738289)
		 + W(7, -1112982200, 996719039, -1110089696, -1131766218)
		 + W(8, 1023923417, -1112895132, -1115022670, -1114119663)
		 + W(9, 1013657340, -1123449267, 1023074654, -1133494194)
		 + W(10, -1123735342, -1129702439, -1120091289, -1126388352)
		 + W(11, -1134219998, -1105084689, -1125652635, -1115595936);
	sum2 =
		W(0, -1176390445, -1120278537, -1122813389, 1041053822) + W(1, 1022193201, -1120846771, 1032791968, -1112747779)
		+ W(2, -1119517685, 1042596904, -1132233097, -1150821318)
		+ W(3, -1107216374, 1039675898, 1061000499, 1032712030) + W(4, 1037891533, -1120324549, 1039748018, 1025598156)
		+ W(5, 1059349510, 1055783944, 1009116037, 1006903493) + W(6, -1104895086, 1049256042, -1087513873, -1099074048)
		+ W(7, -1107732985, -1117395279, 1038133354, -1105015824)
		+ W(8, 1030867610, -1084050573, -1101549778, 1034659541)
		+ W(9, -1123666927, 1024448666, -1108606159, 1040697602)
		+ W(10, 1022775251, -1115429715, 1013658503, -1110290749)
		+ W(11, 1029186614, -1106116496, -1106656496, 1028618234);
	WS(-1107817820, -1083770194);
	sum1 =
		W(0, 1033900161, -1103638846, -1091016130, 1053216608) + W(1, 1041711845, 1032252891, -1129878691, 1019165999)
		+ W(2, -1105602789, 1056291523, -1114138529, 1005244003)
		+ W(3, -1129439246, 1023785569, -1097747004, 1057499003)
		+ W(4, -1107402783, -1129556050, -1131338575, 1041664750)
		+ W(5, -1076846267, 1059566574, 1043057225, 1037921123) + W(6, 1015365308, 1007653393, -1089110318, 1057822998)
		+ W(7, -1097881621, -1126092988, -1128788741, 1026305479)
		+ W(8, -1101714279, 1057215924, -1104471663, 1041959808) + W(9, 1034359265, 1029035509, -1095981534, 1051239662)
		+ W(10, 1029122288, 1025745172, 1024049691, -1111132977)
		+ W(11, -1089968180, 1055184137, 1032118072, 1027268745);
	sum2 = W(0, -1108694073, 1017327589, 1040440313, 1037365040)
		 + W(1, -1097181356, -1123414724, 1045019344, 1034893158)
		 + W(2, 1020539438, 1043169414, 1044490295, -1142407924)
		 + W(3, -1102469381, -1100848825, -1091152854, -1179472005)
		 + W(4, -1098856738, -1124070306, 1037993179, -1146521528)
		 + W(5, 1062010427, 1059039676, -1105305386, -1103656828)
		 + W(6, -1102369829, -1136622056, 1017850914, 1038217042)
		 + W(7, -1109601321, 1025666621, 1036817135, -1122158468)
		 + W(8, -1095264144, -1119445175, -1098482637, -1105116469)
		 + W(9, -1116848662, 1036214504, 1045324437, 1048192551)
		 + W(10, 1034613852, 1027457629, -1123721670, -1109074807)
		 + W(11, 1047380031, -1115655698, -1105047780, -1121369495);
	WS(-1121449656, -1084978473);
	sum1 = W(0, 1045775831, -1099605930, -1086366198, 1054843763) + W(1, 1044622847, 1025802254, 1021114964, 1028648016)
		 + W(2, -1100836955, 1049277222, -1121703995, -1116658981)
		 + W(3, 1036495664, -1113195701, -1085601027, 1059006957)
		 + W(4, 1039106531, -1138285574, 1032769888, -1106810756)
		 + W(5, -1088747404, 1062277595, -1122091582, 1043922200)
		 + W(6, -1134400474, 1033523886, -1083936243, 1060137529)
		 + W(7, -1102614275, 1020367213, 1043049231, -1109837568)
		 + W(8, -1087596695, 1057384673, 1011169881, 1042132230)
		 + W(9, -1112792957, 1039225431, -1102874546, 1045407794)
		 + W(10, -1118753961, -1132370673, 1043659613, -1097941829)
		 + W(11, -1088234269, 1055835664, 1048366450, 1039326553);
	sum2 =
		W(0, 1027272459, -1105747151, 1058588727, 1050147388) + W(1, -1089616072, 1040922163, -1122536322, -1103046200)
		+ W(2, 1025881493, 1054947781, -1098050255, -1157391810) + W(3, -1115599503, 1043039962, 1025318337, 1058930692)
		+ W(4, 1020160348, -1097372724, -1109953333, 1029006014)
		+ W(5, -1079698237, -1072349877, 1078384354, 1029236731)
		+ W(6, -1101108438, 1049577028, -1116019666, -1069493839)
		+ W(7, 1078006681, -1111844849, -1160853572, 1035298821)
		+ W(8, 1050247454, -1072151832, 1075828182, -1095907204)
		+ W(9, -1125199072, 1043042004, -1104971590, -1072978341)
		+ W(10, 1074567753, 1046502148, -1105305527, 1053260045)
		+ W(11, -1094505007, -1072202568, 1072013431, 1037030073);
	WS(-1076413686, 1050217089);
	sum1 = W(0, 1037264211, -1103937453, 1032015257, 1043075881)
		 + W(1, -1122840185, -1144808135, -1140703701, 981259974)
		 + W(2, 1015092336, -1110472573, -1115654547, -1126940256)
		 + W(3, 1010880426, -1126374874, -1117441203, -1140207123)
		 + W(4, -1121072785, -1127053849, -1119658251, 1042459879)
		 + W(5, -1095655209, 1058975156, 1016890098, 1040888602)
		 + W(6, -1116247362, -1115463620, -1089060935, 1059127610)
		 + W(7, -1095200233, 1021095812, 1031154598, 1040532067) + W(8, -1097693400, 1049753500, 1024224509, 990976051)
		 + W(9, -1125273098, -1110800684, -1116339093, 1026525586)
		 + W(10, -1116764924, -1118091276, -1131976189, 1020764716)
		 + W(11, -1115082479, 1038259412, 1027865572, 1016317274);
	sum2 = W(0, 1057721492, -1087030854, -1098169441, 976966634) + W(1, 1023517212, 1010046217, 1028643349, -1118716844)
		 + W(2, 1050324940, 1023362490, -1141117066, 1027499437)
		 + W(3, 1060288138, -1080168014, 1016748144, -1115171624)
		 + W(4, 1023617033, -1115470708, 1059252612, -1080273709)
		 + W(5, -1095791676, 1047291739, -1099550108, 1034407868)
		 + W(6, -1088865108, 1065839894, 1025332663, -1136639192)
		 + W(7, 1041241265, -1116997486, -1086775589, 1065802380)
		 + W(8, 1048744751, -1124716700, 1003901823, -1138422172)
		 + W(9, -1123025940, 1052992874, -1103675095, 1045176631)
		 + W(10, -1105682362, 1028187249, -1093527126, 1051057083)
		 + W(11, 1047968677, -1122660154, 1020688386, -1121332252);
	WS(1066004950, -1130673709);
	sum1 =
		W(0, -1116101174, 1031654568, -1088044468, 1052873383) + W(1, 1041536990, -1136500130, -1143212072, -1115365365)
		+ W(2, -1112634148, 1046315731, 1018103788, -1125315968)
		+ W(3, -1110468285, 1037471350, -1095270314, 1053790292)
		+ W(4, 1044233532, -1143909091, -1115338446, 1044807147)
		+ W(5, -1086079158, 1057379349, -1114923292, 1020745202)
		+ W(6, -1108483849, 1036857292, -1084922887, 1062574892) + W(7, -1111082699, 1016815907, 1016794668, 1049500535)
		+ W(8, -1089120237, 1059566963, -1112535089, -1120057699)
		+ W(9, -1129241385, -1116011560, -1096691029, 1043154809)
		+ W(10, 1013224078, 1009076749, 1013476922, 1018991691)
		+ W(11, -1092328502, 1052540519, 1045681849, -1111113254);
	sum2 = W(0, 1049010278, 1059657103, -1081123115, -1096253478)
		 + W(1, 1022187211, 1042763848, 1037489391, -1120407882)
		 + W(2, -1091075041, 1044030983, -1110198086, -1123055347)
		 + W(3, -1120558834, 1065561208, -1094693777, -1088412254)
		 + W(4, 1026065263, 1010460099, -1115441721, 1065354919) + W(5, -1086070082, -1088804298, 979808314, 1037997843)
		 + W(6, -1107156556, 1033902725, 1048072918, 1059822273) + W(7, 1015305348, -1106407542, 992841734, -1090673211)
		 + W(8, 1058489027, 1048768363, -1103664360, -1127526979)
		 + W(9, 1011333881, -1082019922, 1067731839, -1110539158)
		 + W(10, -1102578162, 1046102351, 1042878013, -1076779646)
		 + W(11, 1065573397, 1056386736, 1041735451, -1098151359);
	WS(1047691950, 1051513987);
	sum1 =
		W(0, 1022367675, -1106171493, 1047705594, -1115678670) + W(1, -1110486184, -1119968336, 1023115866, -1148261013)
		+ W(2, -1138130365, 1039875161, 1038987295, -1146539325)
		+ W(3, 1025923810, -1110614526, -1138856554, -1098498099)
		+ W(4, -1111291916, 1031736900, -1121417283, 1048684730)
		+ W(5, -1092459648, 1059839847, 1037143648, -1113038256)
		+ W(6, -1135269348, 1043654816, -1088007377, 1055365231) + W(7, -1116325726, 999460043, -1123344254, 1037977761)
		+ W(8, -1117423671, -1110502987, 1038170008, -1124410005)
		+ W(9, -1153116613, 1018209505, -1145599589, -1108540005)
		+ W(10, 1024662707, -1170140361, -1140725337, 1012206837)
		+ W(11, -1130685354, 1013205632, -1106962771, 1022378313);
	sum2 =
		W(0, -1153456458, 1034638423, 1026219462, -1118314715) + W(1, -1119545213, 1020158000, -1134949160, -1132037434)
		+ W(2, -1110235102, 1026400860, 1033998497, -1129681397) + W(3, 976205336, 1047224115, 1041432515, -1098555575)
		+ W(4, 1038320636, 1034767622, -1107040555, -1111241686)
		+ W(5, -1098519781, 1048945857, 1042089138, -1100590807) + W(6, 1031938263, -1102088763, 1016119332, 1066956313)
		+ W(7, -1089428981, -1131704894, -1148458760, -1109506803)
		+ W(8, 1045200456, 1038098069, -1088147582, 1033722488) + W(9, -1128058621, -1119972538, 1026438298, 1020127420)
		+ W(10, -1103340362, 1036980701, 1018102832, -1122339703)
		+ W(11, 1012163112, 1026446934, -1114149729, -1126638758);
	WS(1065730166, 1060778308);
	sum1 = W(0, -1109508860, -1157499671, 1041425921, 999270323)
		 + W(1, 1009856488, -1122732458, -1155017835, -1122491724)
		 + W(2, 1039607429, -1108915110, 1019270959, 1019165315)
		 + W(3, -1113193022, -1101845990, 1059840031, -1093896302)
		 + W(4, 1048952862, -1112299503, 1018445113, -1123710636)
		 + W(5, -1103201623, 1034241095, -1124851701, 1031136123)
		 + W(6, -1116526739, 1037579925, -1086536234, 1065443257)
		 + W(7, -1100984082, -1130156262, 1027367671, -1109701838)
		 + W(8, -1119532176, -1115473720, 1042597895, -1112137490)
		 + W(9, -1113248331, 1024052458, -1131587533, 1023021127)
		 + W(10, 988759974, 1035869970, -1116098736, -1155438706)
		 + W(11, -1135484603, -1169161851, -1109972554, 1026435614);
	sum2 = W(0, -1117967445, 1023936292, 1048994422, 1036573845) + W(1, 1025878262, -1136777476, 1040648348, 1027011316)
		 + W(2, -1081925843, -1090561506, -1121546197, 1000734832)
		 + W(3, -1112630617, -1104815876, 1069895227, 1061477130)
		 + W(4, 1006994724, -1120512530, 1042642774, 1032485416)
		 + W(5, -1079286264, -1076993331, 1017402756, 1043800887)
		 + W(6, -1134880336, -1097739621, 1067803238, 1074358700)
		 + W(7, -1094759274, -1115175264, -1108734545, 1008252288)
		 + W(8, -1093635474, -1082750513, -1124517798, -1106635673)
		 + W(9, 1042723069, 1027781874, 1039731885, -1152591489)
		 + W(10, -1128233335, 1050798200, -1110919553, 1017816544)
		 + W(11, -1113045602, 1040942069, 1015619872, -1104563368);
	WS(1051081815, 1004177576);
	sum1 = W(0, -1127006616, 1047378036, 1040477302, -1095193921) + W(1, 984028115, 1015654525, 1009183853, -1123222753)
		 + W(2, -1133548407, -1099314072, 1033152150, 1000220336)
		 + W(3, 1030806032, 1030530563, 1061394914, -1084986498)
		 + W(4, -1134209438, 1016832613, 1035550201, -1112167248)
		 + W(5, 1067589976, -1091645900, -1104155199, 1007541309)
		 + W(6, -1148492092, -1102096100, 1061693295, -1092420382)
		 + W(7, -1126214664, 1020442767, 1031890286, -1119963793)
		 + W(8, 1056018877, -1084371172, -1117645071, 1016050244)
		 + W(9, -1122950699, -1117414047, 1051876647, -1100397982)
		 + W(10, -1115478541, 1015156587, 1033051522, -1118879820)
		 + W(11, 1054656608, -1096248194, -1098736399, -1120116135);
	sum2 =
		W(0, 1038737431, -1086393652, -1122890851, 1062117952) + W(1, 1031555324, -1105710539, -1107492679, 1061143042)
		+ W(2, -1087802869, -1089713201, 1047951996, 1021198999) + W(3, 1048033211, -1086071985, 1050554685, 1059347527)
		+ W(4, 1026779363, -1103176732, -1120313369, 1050160290) + W(5, 1074235084, 1068761695, -1098359769, 1024031768)
		+ W(6, 1015799927, 1036302581, -1097102610, 1051722018)
		+ W(7, 1043634021, -1105088271, -1127256174, -1118303985)
		+ W(8, -1080828834, -1090432670, -1093586557, 1023611974)
		+ W(9, -1108431753, 1030572627, 1051308486, -1096060997)
		+ W(10, -1093678452, -1113357802, 1025558434, 1049210573)
		+ W(11, -1086660156, -1089293346, -1099341241, 1042868230);
	WS(-1081907798, -1114644056);
	sum1 = W(0, 1023775725, -1099395677, 1055907631, -1100928459)
		 + W(1, -1119324179, -1109439504, -1170980595, -1134709766)
		 + W(2, 1050593936, -1112754945, 1032148262, 1017060589)
		 + W(3, 1026005873, -1099241994, 1058604967, -1087793848)
		 + W(4, 1009969504, -1128826918, -1126334628, -1120114113)
		 + W(5, 1054687330, -1087665246, 1038203192, -1138112959)
		 + W(6, -1135823392, 1034531271, 1038229186, -1104299004)
		 + W(7, 1028440637, 1038462084, -1129163353, -1108351113) + W(8, 1034921283, 1040795209, -1104169898, 999099597)
		 + W(9, -1151688884, 1019473342, 1018134455, 1040889398)
		 + W(10, -1106565731, 1007377992, -1129940170, -1110039318)
		 + W(11, -1120708196, 1054318790, -1107725509, 1027667523);
	sum2 = W(0, -1119441358, -1109792567, -1127769135, -1107196821)
		 + W(1, 1030789742, -1113410550, -1129970231, -1120391232) + W(2, 1050978947, 992017798, 1040616080, 1030775978)
		 + W(3, 1013923693, -1103233485, 1033489482, -1095646457)
		 + W(4, 1038693473, -1115392393, -1135011770, -1103316489)
		 + W(5, 1054134565, 1049668759, -1124339641, -1108882435)
		 + W(6, 1015830944, -1104701758, 1049300223, 1056508485) + W(7, 1043974386, -1145057435, -1115083307, 961266788)
		 + W(8, -1110832497, 1047186396, -1086696217, -1118394614)
		 + W(9, 1009913072, -1120471806, 1049274561, -1110580647)
		 + W(10, -1110322035, 1032794842, -1117182320, 1032096200)
		 + W(11, -1124368769, -1109467751, -1103392519, 1029776437);
	WS(1054547415, -1080700728);
	sum1 = W(0, -1118959255, -1106813137, -1136179854, 1049136707)
		 + W(1, -1121699838, -1110798213, 1000886579, 1020745112)
		 + W(2, 1042266506, -1113159542, -1135369949, -1133353861)
		 + W(3, -1108938574, 1000629071, -1114102394, -1117329322)
		 + W(4, -1098171678, -1132246652, 1035589374, -1089948699)
		 + W(5, 1058763908, 1057279043, -1102488395, -1116069530)
		 + W(6, -1115953331, -1104374042, 1043996152, 1058534976)
		 + W(7, -1118338951, 1023843187, -1120209015, -1115354302)
		 + W(8, 1034434840, 1042941412, -1123101368, -1110056358)
		 + W(9, -1130255148, -1115551813, 1030595334, 1024662339)
		 + W(10, -1111680098, -1125104281, -1114831416, -1107411355)
		 + W(11, 1037557447, -1115931546, -1111356186, -1113468791);
	sum2 =
		W(0, -1104438281, 1010047952, 1041416137, -1126834256) + W(1, -1137643420, -1141914640, 1006975884, 1033813267)
		+ W(2, -1103312430, -1117623020, -1119875938, -1142859168)
		+ W(3, -1114845259, -1104617278, 1059878226, -1091497753)
		+ W(4, 1032827109, -1115736166, -1121830816, 1016682467) + W(5, 1030331467, 1058017528, -1098691452, 1030249718)
		+ W(6, 1035922248, -1119230330, 1042445877, 1016098448) + W(7, 1038105687, -1111253212, -1109021584, 1016925125)
		+ W(8, -1127060444, 1041560361, -1110812698, -1153808400)
		+ W(9, 1024387710, 1031893944, -1106783001, -1112957506)
		+ W(10, 1032692112, -1114320479, -1116080890, 1028042677)
		+ W(11, -1113418625, 1032681483, -1112120334, -1122393388);
	WS(1052913623, 1049378679);
	sum1 =
		W(0, -1122838827, 1042960148, -1086626395, 1057292387) + W(1, 1037967453, -1155224026, -1140317417, -1131398976)
		+ W(2, -1096052024, 1051976144, -1115050310, 1021209962)
		+ W(3, -1125024735, 1047376245, -1085621156, 1057250406)
		+ W(4, 1033197251, -1137632582, -1119624720, -1142164473)
		+ W(5, -1082562971, 1065554348, -1105683981, 1041116332)
		+ W(6, -1114511683, 1052155164, -1087926293, 1052193006) + W(7, 1022767638, -1114068531, 1000517975, 1026436976)
		+ W(8, -1091398264, 1054127476, 1031945184, 1019309136) + W(9, 980913767, 1040745327, -1096441475, 1052669955)
		+ W(10, -1117629257, -1119607996, -1118732996, 1037554661)
		+ W(11, -1088065070, 1051850318, 1041425290, 1029050594);
	sum2 =
		W(0, -1128729473, -1113890565, 1030681183, -1116238263) + W(1, 1054381777, -1088819879, 1026695603, -1113695617)
		+ W(2, 1046246583, 1032966985, 1060417287, -1094452995) + W(3, -1122814467, 1012493154, -1119541727, 1063042504)
		+ W(4, 1065151040, -1073258706, 1038041001, 1007226362) + W(5, -1105895610, 1066720275, 1069419683, -1071852139)
		+ W(6, -1114364242, 1022932917, 1013035938, 1061802664) + W(7, 1070184946, -1071972143, 1029245131, -1121347205)
		+ W(8, -1109256305, 1054635319, 1067716376, -1076852924) + W(9, -1114309631, 1028217359, 1037707015, 1034508407)
		+ W(10, 1063333907, -1084913408, -1131614889, 1005475605)
		+ W(11, 1018572933, -1114817272, 1057796391, -1086618913);
	WS(-1080205366, 1054586731);
	sum1 =
		W(0, 1028285119, -1104231365, -1105384067, 1018315643) + W(1, 1050517144, -1107795033, 1034516295, -1118125300)
		+ W(2, -1098317298, 1050987674, -1103331232, 1030553289)
		+ W(3, -1114270114, -1122896269, -1102251495, 1045079495)
		+ W(4, 1044797187, -1134423957, 1028158052, 1031422323) + W(5, -1084181862, 1065887519, -1106919576, 1039594145)
		+ W(6, -1122816794, 1042423964, -1083878719, 1058366107)
		+ W(7, -1136969466, -1127143669, 1015275709, -1113275778)
		+ W(8, -1102645126, 1055927247, -1127822612, 1007528111) + W(9, 1008209269, 1035567225, -1094749758, 1042520123)
		+ W(10, -1111681950, -1112108944, 1026827799, -1113291743)
		+ W(11, -1095155767, 1054820368, 1023800268, 1010334934);
	sum2 = W(0, 1018519238, 999332143, 1041061518, 1033756160) + W(1, 1071473984, -1074851124, 1015687849, 1021267259)
		 + W(2, -1105547391, 1042746528, 1066765865, -1079967238)
		 + W(3, -1123243110, 1021268373, 1034089943, 1026544409)
		 + W(4, 1067795051, -1079279124, -1154321191, 1001850235)
		 + W(5, -1097359239, 1057524548, 1059938647, -1081222132)
		 + W(6, -1147705571, -1122367554, 1024181853, -1128118669)
		 + W(7, -1126584943, 1036308208, -1137574530, -1149097003) + W(8, 964634475, 1033087855, -1109247299, 995399503)
		 + W(9, 1025499637, 1028798873, -1139074510, -1129467393)
		 + W(10, 1002507759, 1006964374, -1123293958, -1120881342)
		 + W(11, 1038775557, -1131901697, -1137941026, -1131371017);
	WS(1032292188, -1145187004);
	sum1 =
		W(0, -1121091224, 1026282854, -1110430066, 1041424886) + W(1, -1163709786, -1130362518, -1124591439, 1032165735)
		+ W(2, -1099744666, 1053335502, -1097458647, 1026340962)
		+ W(3, -1121198813, 1048823572, -1088767505, 1045555550) + W(4, 1040806261, 1020242430, 1009701366, -1113803654)
		+ W(5, -1109489438, 1044961340, 1038271382, -1136150382)
		+ W(6, 1007646671, -1119045850, 1041537816, -1098280566)
		+ W(7, 1040783354, -1117600916, 1026658136, -1092992668) + W(8, 1047050636, 1043075732, 1037260307, 997023189)
		+ W(9, 1020346030, 1019935126, -1121506375, -1107270401)
		+ W(10, 1000329008, -1124456788, -1122546321, -1119672872)
		+ W(11, -1110555528, 1047792295, -1120965766, 1026784415);
	sum2 =
		W(0, -1120115102, 1027036707, 1028744443, 1037973272) + W(1, -1111409649, -1114092190, 1024423113, -1119221834)
		+ W(2, -1122478763, 1049287438, -1096539764, 1034186497) + W(3, -1131404107, 1034928052, 1034534080, 1047707985)
		+ W(4, 1032305459, -1111870688, -1162462122, -1115806512)
		+ W(5, -1117650486, 1065549495, 1059270295, -1104163224)
		+ W(6, -1116017912, -1133321326, -1108495610, -1079218451)
		+ W(7, 1053073262, -1116841516, 1035047655, -1101382306)
		+ W(8, -1105332910, -1101676179, -1108544028, 1038206879)
		+ W(9, -1146105278, 1029706393, 1038914207, -1109811124)
		+ W(10, -1125217018, 1004549098, 1011265421, 1023154260)
		+ W(11, -1113944011, -1116861489, 1023662974, 1021319568);
	WS(1065238444, 1029810764);
	sum1 = W(0, -1117664959, 1035631050, -1105662947, 1044376095)
		 + W(1, -1180059800, -1144996235, 1033625479, 998132025) + W(2, -1110409480, 1041425605, 1029921727, 1002652741)
		 + W(3, -1121511107, 1046740798, -1115600622, -1117226857) + W(4, 1047596134, 986508455, 1026353828, 1049143094)
		 + W(5, -1117398499, -1088462543, 1050498082, 1031133314)
		 + W(6, -1154871713, 1044265580, -1101622768, -1090821428)
		 + W(7, 1032067983, -1119889178, 980940712, 1037075730)
		 + W(8, -1109487884, -1099167518, -1134957959, 1038687768)
		 + W(9, 1018182811, 1028486865, -1112099063, 1039936213)
		 + W(10, 1021107193, -1122286680, 1025470327, -1128624253)
		 + W(11, -1120941494, -1117520833, 1019194744, 1032539083);
	sum2 =
		W(0, 1027136813, -1109237812, -1131106290, 1028116649) + W(1, -1115313320, -1132573667, -1126103938, 1029641913)
		+ W(2, 1047599733, 1041211299, -1119521049, 1022404146)
		+ W(3, -1134438995, -1108335880, -1097134429, -1092284431)
		+ W(4, -1100904528, 1016921434, 1023841561, 1016569578) + W(5, -1076957808, -1103461794, 1040752059, 1027441157)
		+ W(6, 1003327910, 1032415828, 1044824498, 1073063564) + W(7, 1045381268, -1106952976, -1130954514, 999116870)
		+ W(8, 1037851390, -1111597872, -1112786376, 1036890340)
		+ W(9, -1135210803, 1003972614, -1123469057, 1033926584)
		+ W(10, 1034574746, -1110049884, 994333964, -1138234067)
		+ W(11, 1043898273, -1115472968, -1137298819, -1139674515);
	WS(-1111543132, 1053084187);
	sum1 = W(0, 1033211657, 1029336727, 1056808676, -1089574549)
		 + W(1, -1112225370, 1035575202, -1116548448, -1100473306)
		 + W(2, 1042013257, -1097689349, 999357322, -1114691470) + W(3, 1043994373, 1036113196, 1061342772, -1087296749)
		 + W(4, 1042186215, 1040681774, -1112421659, -1100606697)
		 + W(5, 1060655799, -1082434496, -1100755553, 1045312421)
		 + W(6, 1033458902, -1117467379, 1059165410, -1087667391) + W(7, 1042539448, 1039236406, 1042588164, 1024205686)
		 + W(8, 1057924951, -1091727169, 1041805473, 1042949980)
		 + W(9, -1106715184, -1098518156, 1042727104, -1095816456)
		 + W(10, -1105873704, -1113675407, 1042106754, 1010302211)
		 + W(11, 1057649845, -1093601226, -1114265639, 1035739628);
	sum2 =
		W(0, 1036389819, 1006854517, 1049279774, -1104547241) + W(1, -1140479293, 1032391465, -1106855677, -1114095075)
		+ W(2, -1106885840, -1120692701, -1096936463, -1098591621)
		+ W(3, 1031620401, 1044374087, 1052305677, 1045612807) + W(4, 1051540981, -1115708783, -1109245550, -1105124479)
		+ W(5, 1054861276, 1058901209, -1092919117, -1081363743) + W(6, 997072274, -1105277948, 1057655059, 1054428932)
		+ W(7, -1129490106, -1090444858, -1132619277, 1043212463) + W(8, 1046093411, 1034709627, 1034565381, 1017473602)
		+ W(9, -1096737767, -1104242691, -1094755169, 1054770354)
		+ W(10, -1092959620, -1098730750, 1049991282, -1113287926)
		+ W(11, 1057224822, -1094426804, 1030915645, 1044114915);
	WS(-1084020140, 1068126260);
	sum1 = W(0, 1006295077, -1156074282, 1049019906, -1097931528)
		 + W(1, -1117241095, -1123621559, -1137936208, -1103771606)
		 + W(2, 1049395923, -1091558419, 1040511881, 1023627215)
		 + W(3, 1034316741, -1104490636, 1061237576, -1086810430)
		 + W(4, 1040083512, -1108467318, -1149620895, 1038480604)
		 + W(5, 1033598516, -1099102215, 1044377854, -1115694024)
		 + W(6, -1141477121, 1018703789, -1094713154, 1059440745)
		 + W(7, 1044961993, -1120119968, -1110713826, 1041233006)
		 + W(8, -1098857908, 1018408058, -1146014215, -1145494414)
		 + W(9, -1119964867, 1031629367, 1023717620, -1122483505)
		 + W(10, 1038059949, -1122997930, -1159113641, 1005339683)
		 + W(11, 1036793310, -1108866660, -1129764324, 1007729326);
	sum2 =
		W(0, 1015277664, 1025130698, 1027591084, -1117062871) + W(1, -1101670769, 1019605180, -1114453597, -1134749664)
		+ W(2, 1033917561, -1115087054, -1114105716, -1131991228)
		+ W(3, 1036987011, 1032879133, -1126832950, 1055956188)
		+ W(4, -1097729634, -1104354242, -1112547401, -1134874844)
		+ W(5, -1114337945, -1108159193, -1123425664, -1097147867)
		+ W(6, 1038859445, -1112115766, 1026538526, 1052262112) + W(7, 1058230624, -1101321392, -1116674795, 1018163604)
		+ W(8, -1114930086, 1032023389, 1047994902, -1100180330) + W(9, 983557058, -1128408082, 968847366, -1105383385)
		+ W(10, 1046456588, -1106875572, -1127718668, 1003243264)
		+ W(11, -1132712652, -1120777676, 1042953566, 1009596296);
	WS(1044178094, -1112419455);
	sum1 =
		W(0, -1131480425, 1028145051, 1050373320, -1113746394) + W(1, -1097767254, 1005496122, 1014469647, -1106904202)
		+ W(2, 1050878345, -1101407218, 1036986154, 1009224698) + W(3, 1033460669, -1114114798, 1059597501, -1089975999)
		+ W(4, -1106579916, 1010606701, -1111970637, -1103921210)
		+ W(5, 1061375910, -1083033439, 1025899544, -1155279741)
		+ W(6, 1018155424, -1104772954, 1062331213, -1089702156) + W(7, 1034746546, 1027233072, 1028778773, -1105642670)
		+ W(8, 1054878354, -1100724747, 1032512190, 1015772371)
		+ W(9, -1120733619, -1122369255, 1050980308, -1095744476)
		+ W(10, -1113254377, -1131981388, 1036392279, -1105836421)
		+ W(11, 1057064179, -1096031599, -1120232930, -1140419566);
	sum2 =
		W(0, 1044058702, -1120335698, 1041124235, 1021344157) + W(1, -1087803383, 1057976488, -1105410550, 1016883675)
		+ W(2, 1035757794, -1104385836, -1085495757, 1058928386) + W(3, 1033398047, 1032351899, -1105578788, 1068114101)
		+ W(4, -1081571635, 1051244378, -1119512188, -1103364509)
		+ W(5, -1105098443, 1052569394, -1086748155, 1048853947)
		+ W(6, -1121578506, -1123961512, 1037191880, 1027075889)
		+ W(7, 1031589750, -1130402783, -1129503263, 1043612533)
		+ W(8, 1025665274, -1095293941, 1048618044, -1124003088)
		+ W(9, 1005093795, -1110855577, 1024086018, -1113226379)
		+ W(10, -1121765158, 1010599720, -1116781712, 1044044613)
		+ W(11, 1023695645, -1106316439, 1039073287, -1120128288);
	WS(-1095246679, -1087513362);
	sum1 = W(0, 1027634667, 1005582218, 1054139855, -1093682933) + W(1, 1002440559, -1142612208, 998672596, 1034119552)
		 + W(2, 1049059024, -1099832192, 1040529483, 1024339285)
		 + W(3, -1149130110, -1098084154, 1052649123, -1089047862)
		 + W(4, -1122861959, 1025618962, 1026870673, -1141537276)
		 + W(5, 1065515488, -1088853800, -1126585773, 1014930618)
		 + W(6, 1006905115, -1098155038, 1064339388, -1084571535)
		 + W(7, -1099945809, -1117714471, 1027369115, -1115874224)
		 + W(8, 1053781857, -1097071228, -1105399392, -1136815962)
		 + W(9, -1156874400, -1130796284, 1050040635, -1107001190)
		 + W(10, 1023818537, 1018962754, 1027010724, -1110211381)
		 + W(11, 1056042372, -1095503614, -1117200441, 1028298602);
	sum2 =
		W(0, 1021849900, 1041438934, -1128850825, 1035803991) + W(1, -1100551265, 1028120411, -1131412357, -1119369172)
		+ W(2, 1021256857, -1111021944, 1042971908, -1109090883) + W(3, -1118206650, 1040592619, 1046750596, 1038923952)
		+ W(4, -1109478151, 1026074630, -1125196517, -1114002177)
		+ W(5, 1025252531, 1072474004, -1083937830, -1100770381) + W(6, 1035111533, 1032710077, 1048692472, 1077302109)
		+ W(7, -1067064389, 1049109423, -1144348946, 1044882286)
		+ W(8, -1128830461, -1095554578, -1084038225, 1041329596)
		+ W(9, 1021086832, -1106944856, 1032666924, 1044371493) + W(10, -1106119426, 1033664959, 1020034266, 1034465258)
		+ W(11, 1034167215, -1126088605, -1103479472, -1114595648);
	WS(-1086863724, -1072185677);
	sum1 =
		W(0, 1028385114, 999422396, 1054099261, -1096116227) + W(1, -1144842721, -1139590961, -1117432553, -1108936247)
		+ W(2, 1053618221, -1097427086, 1026659130, 1021035463) + W(3, 1039695343, -1104614655, 1060257868, -1085349189)
		+ W(4, 1037424170, -1123772160, -1109809663, -1104994067)
		+ W(5, 1062802560, -1083398775, 1038629270, -1103266023)
		+ W(6, 1021420394, -1154652341, 1056152893, -1099176000)
		+ W(7, 1048207210, 1017905387, -1123921882, -1146863602)
		+ W(8, 1045520765, -1110026089, -1118540449, -1111374457)
		+ W(9, -1130768465, -1114930982, 1044268562, -1104661441)
		+ W(10, -1129199023, 997564786, 1022384484, 1034006493)
		+ W(11, 1050379178, -1115290030, -1101129750, -1108736604);
	sum2 =
		W(0, -1122660132, 1040406414, 1007232002, -1096101684) + W(1, -1114861255, 1041847394, 1028330563, 1017997140)
		+ W(2, 1025921746, 1022732374, 1041150821, -1105481885) + W(3, -1115262781, 1025264396, 1043786284, -1102241564)
		+ W(4, -1094431556, 1055232297, 1045687787, -1103384157) + W(5, 1040909479, 1055010544, -1078483413, 1061241514)
		+ W(6, -1108704409, -1151694751, -1108714653, 1057419270) + W(7, -1079156700, 1063042984, 1029063313, 986929807)
		+ W(8, 1043690826, -1126901852, -1078269109, 1067726336)
		+ W(9, -1116092784, 1026201848, -1119932664, 1047767958)
		+ W(10, -1092610189, 1054314043, 1013546756, -1115691336)
		+ W(11, 1038266954, -1115096031, -1098859524, 1052159629);
	WS(-1100931758, -1079897221);
	sum1 =
		W(0, 1002503979, -1105750735, -1109125113, 1042140489) + W(1, -1126416416, -1119888216, 1034941050, 1038153885)
		+ W(2, 1017797614, 1051948423, 1024057510, 1035399096) + W(3, -1106318298, -1105238364, -1095922988, 1034322060)
		+ W(4, -1103862864, -1104877795, 1040768819, 1049149819) + W(5, -1090093369, 1059094088, 1040510958, 1042879258)
		+ W(6, -1115730241, 1028324215, -1091054939, 1049017573)
		+ W(7, -1112163155, -1120272065, -1141069099, -1106412131)
		+ W(8, -1102230944, 1050624300, -1106256757, -1112985689)
		+ W(9, 1027555620, 1039911116, -1127686569, 1045992036)
		+ W(10, 1017980086, 1033961137, -1123362142, -1114353739)
		+ W(11, -1097766172, 1043140938, 1018029782, -1117933580);
	sum2 =
		W(0, -1118098210, 1039272612, 1033865352, -1107428188) + W(1, 1041731770, -1138511840, -1106915273, -1120265428)
		+ W(2, 1043187452, -1111026913, -1108614463, -1129236656)
		+ W(3, 1038839398, 1047577900, -1107536005, 1034998667)
		+ W(4, -1104254290, 1049639209, -1115506453, -1112696018)
		+ W(5, -1090204449, 1068488571, -1073443109, 1065503173) + W(6, 1032442192, -1123012045, 982996928, -1096446249)
		+ W(7, 1040126834, 1035312463, 1016491198, -1123570623) + W(8, 1042935567, 1013219076, 1041050172, -1104804103)
		+ W(9, 996494424, -1121836120, -1120793710, -1101384300) + W(10, 998034192, 1040382819, -1145352236, 1026228225)
		+ W(11, 1030161309, 1023915500, 1038049010, -1106858818);
	WS(1060652716, -1122012062);
	sum1 =
		W(0, -1136700086, -1113850590, -1093156519, 1056384406) + W(1, -1101587139, 1021600449, -1120727741, 1022556549)
		+ W(2, -1098011208, 1052398904, -1106430355, -1114714908)
		+ W(3, -1136846536, 1030968440, -1100004083, 1062519968)
		+ W(4, -1132405458, 1016310696, -1102129381, 1036351121)
		+ W(5, -1079676696, 1061355096, -1107897312, -1113036024)
		+ W(6, 1035874533, 1049961616, -1097573322, 1059521337) + W(7, 1048756772, 1022545811, -1111246103, -1119797202)
		+ W(8, -1087704492, 1052440101, -1109566980, 956768943) + W(9, 1019584793, 1037896960, -1096988084, 1048869443)
		+ W(10, 1020055223, -1121983087, -1111739075, 1033695743)
		+ W(11, -1092447605, 1048091420, 1043876621, 1018273385);
	sum2 = W(0, -1134928360, 1033535752, -1108867200, 1056652859)
		 + W(1, -1094974673, 1034782854, 1028726521, -1102458559)
		 + W(2, 1031241917, 1048810536, -1100509489, -1123876292)
		 + W(3, -1102649789, -1114678181, 1028753942, 1051021341)
		 + W(4, -1100441695, -1100025719, 1041988393, 1050124192) + W(5, 1056497468, 1036208495, 1034323322, 1037384204)
		 + W(6, -1105797881, -1102215651, -1090602802, -1099717915)
		 + W(7, -1115767916, -1098766868, -1125378124, 1032107719)
		 + W(8, 1057082230, -1114740583, 1041259997, 1024245049) + W(9, 1034345705, 1014416128, 1023046526, 1002570703)
		 + W(10, -1122784508, -1114560124, -1134413224, -1119150822)
		 + W(11, 1025484112, -1101875417, 1037850051, -1112409616);
	WS(-1104650926, -1097620835);
	sum1 =
		W(0, -1121602225, 1025795527, 1046345311, -1105175020) + W(1, -1160491701, 1000929055, 1021304961, -1105437010)
		+ W(2, -1108985665, 1045711217, -1117138161, -1145522137)
		+ W(3, -1132438763, 1039870965, 1041625463, -1093274991)
		+ W(4, 1040158758, -1117941464, 1033606955, -1097752993)
		+ W(5, -1144407721, 1062570208, 1049985633, -1122762228)
		+ W(6, -1119908749, 1037504305, -1100934531, -1099088029)
		+ W(7, 1037586881, -1109694278, 1032325913, -1109081755) + W(8, 1047145475, -1097698093, 1004919651, 1026835862)
		+ W(9, -1112547088, -1121171172, -1119544288, -1136783989)
		+ W(10, -1124949278, 1024727664, 1011690407, -1116159153)
		+ W(11, 1036418740, -1106563213, 999804916, -1126831120);
	sum2 =
		W(0, -1103930431, -1122873970, 1048581640, -1139346648) + W(1, 1030984702, -1115391660, 1043997541, -1100601593)
		+ W(2, -1108032519, 1042591516, -1123657132, -1107477718)
		+ W(3, -1102154605, -1174042309, 1029742536, 1045200151)
		+ W(4, -1106767363, 1032437784, 1046282803, -1084779372) + W(5, 1068068442, 1052027066, -1086671314, 1025856678)
		+ W(6, -1106269056, -1114322527, 1051594943, -1098651742)
		+ W(7, 1024653780, 1036550683, -1116052960, 1046060831)
		+ W(8, -1119470820, -1115540046, -1127107345, -1121355040)
		+ W(9, 993204113, -1115511338, -1138871916, 1021777728)
		+ W(10, -1163609763, -1115373797, -1113135778, 1041954938)
		+ W(11, 1020181836, -1107159950, -1134598872, -1122730046);
	WS(1066180726, 1071088208);
	sum1 =
		W(0, 1019239309, -1125280121, -1096761986, 1046613601) + W(1, -1107071425, 1022045682, -1139409238, 1001471451)
		+ W(2, 1012641888, -1137946220, 1047813898, 1006921793)
		+ W(3, 1016498838, -1110062156, -1103040193, -1089511315)
		+ W(4, 1045045936, 1010038708, -1117575980, 1036666525) + W(5, -1098591157, 1064065326, 1024305865, 1025055882)
		+ W(6, 1000209679, 1049354787, -1079760364, 1058946251) + W(7, -1110782371, 990559266, -1113394675, 1048739493)
		+ W(8, -1090655988, 1056455200, 1013890551, 1028621651) + W(9, 1030691589, -1119525817, -1102803453, 1048597558)
		+ W(10, 981956228, -1118324476, -1133365628, -1103045922)
		+ W(11, -1099636767, 1050574049, 1043476657, -1146495466);
	sum2 = W(0, -1132513434, 1043448685, -1099364915, -1092624350)
		 + W(1, 1056566992, -1119372495, -1110784932, -1133524329)
		 + W(2, 1037755510, 1047633966, -1103089496, -1105722911)
		 + W(3, 1015163300, -1107748756, -1102119678, -1120785461)
		 + W(4, 1032253510, -1123661455, 1015068960, 1038994810)
		 + W(5, 1041992963, 1052941265, -1122308723, -1115405106)
		 + W(6, 1033174530, -1104237963, 1059473601, -1112171819)
		 + W(7, 1028984470, -1126727948, -1135254713, -1120882016)
		 + W(8, 1015880446, -1149514732, -1121912217, 1038410412)
		 + W(9, 1032888151, -1105704866, 1034086136, -1106883398)
		 + W(10, 1037486360, -1113287020, -1132281738, 1042278645)
		 + W(11, -1087682569, 1032085587, -1121651695, 1025242322);
	WS(1036385628, 1044378228);
	sum1 =
		W(0, -1125923878, -1119989961, -1113894352, 1034400041) + W(1, 1040468885, -1119159494, -1122454178, 1024777096)
		+ W(2, -1109744594, 1050462805, -1118152051, -1136375156)
		+ W(3, -1106272614, 1045742974, -1081686591, 1057689729)
		+ W(4, -1112362495, 1016953331, 1034604284, -1106270482) + W(5, 1049041391, 1056885773, -1111838475, 1033159371)
		+ W(6, -1112814039, -1097223397, 1058546239, -1082103097)
		+ W(7, 1051410218, -1127987422, 1030894675, -1112273196) + W(8, 1043400251, -1111542214, 1042722054, 1008300000)
		+ W(9, -1123079474, -1131680651, 1024933634, 1032256832)
		+ W(10, -1104716944, 1020481857, -1130721815, 974203052)
		+ W(11, -1127331477, 1030325078, 1028514056, -1122308858);
	sum2 = W(0, -1126857538, -1124098806, 1017023528, -1105780084)
		 + W(1, -1128747572, -1133097491, -1118763531, -1105376950)
		 + W(2, -1096176503, -1094874635, -1140350635, 1036694112)
		 + W(3, 1031801448, 1037674477, 1067983244, 1071605005)
		 + W(4, -1109792866, -1111308161, 1032593429, -1110580495)
		 + W(5, -1078904043, -1075832971, -1097243929, 1036064001)
		 + W(6, 1004108563, -1116861031, 1060638644, 1065456263) + W(7, 1040323331, 1039332997, -1119835024, 1039467599)
		 + W(8, -1111109918, -1112838992, -1114824160, -1103055030)
		 + W(9, 1016299757, -1109178305, -1098624444, -1104548941)
		 + W(10, 1033955221, 1027541135, -1169697445, 1033383777)
		 + W(11, 1040587540, 1006549790, -1127435882, 1022453269);
	WS(1044586414, 987793058);
	sum1 = W(0, 981244734, -1094962922, 1056192743, -1106851755)
		 + W(1, -1119312576, -1109764848, 1029861564, -1105742952)
		 + W(2, 1054313512, -1099782448, 1027895469, 1032524411)
		 + W(3, -1127551587, -1103252055, 1058042871, -1098041547)
		 + W(4, 1019737521, -1110892330, 1008852553, -1106380176)
		 + W(5, 1048369556, -1096188128, -1121596880, 1024237680)
		 + W(6, -1110264932, 1039776063, -1104749720, 1052995119)
		 + W(7, -1106765091, -1120426409, -1120415085, 1036900841)
		 + W(8, -1097596121, 1058305414, -1098125906, 1026360866)
		 + W(9, -1128191927, 1025145152, -1105335335, 1045503990)
		 + W(10, -1106717007, -1151171624, -1111219811, 1028803677)
		 + W(11, -1103570473, 1055249646, -1101993823, 1031597860);
	sum2 =
		W(0, -1170894487, 1038321486, 1053283699, -1093894288) + W(1, -1100030896, 1046510222, -1116947191, 1032730216)
		+ W(2, -1102463031, -1109920837, 1047091130, -1098101478)
		+ W(3, 1031282910, 1034140662, 1044178467, -1089191295)
		+ W(4, -1097946325, 1046381950, -1112734885, -1104751545)
		+ W(5, 1054507486, 1065532097, -1095028025, -1113780206)
		+ W(6, 1042944653, -1102906173, -1128523954, -1115680584)
		+ W(7, -1094781909, 1020709100, -1112368696, -1115060896)
		+ W(8, 1038784522, 1029167633, 1050920778, -1114933696) + W(9, 1023647443, -1124833342, -1109068581, 1021288403)
		+ W(10, -1113980416, -1114621382, -1149951158, -1103764076)
		+ W(11, -1105151256, 1048070264, 1052479172, -1120673083);
	WS(-1114317660, -1079530866);
	sum1 =
		W(0, 1005492722, -1115918380, -1124407701, -1116105277) + W(1, 1041270838, -1125596386, 1045601427, -1100871485)
		+ W(2, 1040297908, -1115200394, 1034785295, 1024917256)
		+ W(3, -1125684614, -1122621547, -1098312611, -1103806788)
		+ W(4, 1049040249, 1026343653, 1040691817, -1094477942) + W(5, 1054673340, -1097950923, -1103823208, 1033886401)
		+ W(6, -1138701159, 1044150368, 1041833209, -1088150296)
		+ W(7, -1129519613, 1039772509, -1122106750, 1041157065)
		+ W(8, -1120050519, 1040435582, -1121264402, 1028146611) + W(9, 1010492340, 1039210328, -1116922669, 1025767275)
		+ W(10, -1133614768, 1030520276, -1132247342, 1037992735)
		+ W(11, 1025359158, 1032362656, -1107139719, 1032249339);
	sum2 = W(0, -1155531695, 1035594747, -1111112193, -1101564588)
		 + W(1, -1116834132, -1130931838, -1116868484, -1130123766)
		 + W(2, 1034328851, -1113096514, -1115452418, -1123313694)
		 + W(3, -1135508412, -1121397012, 1033705026, 1029679690)
		 + W(4, -1152418495, 1018386998, -1106991844, -1115576312)
		 + W(5, 1050004218, 1048453590, 1029930774, -1127714868)
		 + W(6, -1135674828, -1126221532, -1117911568, 1050922209)
		 + W(7, 1007646710, -1121358676, 1001487940, -1107263445)
		 + W(8, -1123887534, 1043692754, -1114385718, 1023927325)
		 + W(9, -1119877490, -1121744498, 1017446183, 1034884616)
		 + W(10, -1122169416, -1115969900, -1131775200, -1125291430)
		 + W(11, -1110635219, 1032206024, 1016330315, -1122013064);
	WS(1066254326, -1103165682);
	sum1 =
		W(0, 1032736195, -1107990998, 1040177417, -1102376817) + W(1, 1034252186, 1019040113, 1027879829, -1114107453)
		+ W(2, -1121888407, 1024426522, -1134855959, 1012754494)
		+ W(3, 1031762634, -1103287009, 1058340070, -1086180914)
		+ W(4, 1048880356, -1128188760, -1123062443, 1041209406)
		+ W(5, -1097968365, 1045901207, -1117801777, -1116847305)
		+ W(6, 1004281096, 1039171204, -1082040497, 1060563077)
		+ W(7, -1108119503, -1149008906, -1148973229, -1113506869)
		+ W(8, 1042461256, 1045252895, 1021862138, -1140572507) + W(9, -1119568276, 1029657432, -1110264442, 1035749465)
		+ W(10, 1017288487, 1021245074, -1130151676, 1042306865)
		+ W(11, -1106785311, 1042341554, -1125959462, 1010461490);
	sum2 = W(0, 1021177914, -1111267114, 1038432054, -1105822865)
		 + W(1, 1037666445, -1122267795, -1124089023, 1044764288)
		 + W(2, -1106310853, -1100663157, 1039738660, -1121288215)
		 + W(3, 1026640236, 1026571855, -1115065858, -1088005063)
		 + W(4, -1097556837, 1045614354, 1019818775, -1103902938)
		 + W(5, 1063205014, 1066152263, -1094681119, -1112191805)
		 + W(6, 1019369915, -1139759728, 1054784388, -1093573252)
		 + W(7, -1095778937, 1041592438, -1106530127, 1046869720)
		 + W(8, -1096246655, -1098236584, 1051664274, -1110480242)
		 + W(9, 1038187852, -1116925721, -1115197568, 1033917272)
		 + W(10, -1104072801, 1015983837, 1030498751, -1107211067)
		 + W(11, 1035488589, -1107121631, 1038730556, 1022742082);
	WS(1062838508, -1098141683);
	sum1 =
		W(0, -1134697126, -1129876167, -1116304310, -1099161722) + W(1, 1038618718, 1030514076, 1033720508, 1021336509)
		+ W(2, -1104597903, 1019102333, 1045312786, -1118743028)
		+ W(3, -1121504814, 1014720225, -1101916102, 1049624810)
		+ W(4, 1036131058, -1134396481, -1119656591, 1046652247) + W(5, -1082370571, 1058084844, 1029119981, 1009920435)
		+ W(6, 950602286, 1047400131, -1091801796, 1053105145) + W(7, -1119759594, -1132133195, -1114868293, 1033072079)
		+ W(8, -1096699752, 1050650780, -1119884597, -1133963803)
		+ W(9, 1034808260, -1139606129, -1121911577, 1034036747) + W(10, 1024218735, 990998386, -1113093265, 1026913289)
		+ W(11, -1098146380, 1048726310, 1017329950, -1121758433);
	sum2 =
		W(0, -1120814392, 1026947049, -1124609851, 1029294693) + W(1, -1089366560, 1054044776, 1018600110, -1114533760)
		+ W(2, 1043306429, -1096357662, -1078857162, -1109773692)
		+ W(3, 1027325255, -1112504706, 1030055965, 1075131584)
		+ W(4, -1106088729, -1105806639, -1124538308, -1107191892)
		+ W(5, -1090928488, -1118772404, 1060040329, -1102685120)
		+ W(6, -1127260613, 1023329910, 1046523168, -1092017575)
		+ W(7, 1045316672, -1119137158, 1007599328, -1124222597) + W(8, 1015958190, -1113584525, 1047822624, 1032716843)
		+ W(9, -1128821133, 1024046209, 1022187138, -1109468012)
		+ W(10, 1021757630, -1120065319, -1125977712, 1019591350)
		+ W(11, -1115445424, -1105922548, 1038940063, 1016647840);
	WS(1054286935, 1054427377);
	sum1 =
		W(0, -1139016422, 1031868724, -1103470657, 1027450488) + W(1, 1036611766, -1113202838, 1015966225, 1024526894)
		+ W(2, -1100637795, 1046711412, -1105992614, 1036202402)
		+ W(3, 1034481375, -1107528289, 1043922306, -1098573729)
		+ W(4, 1045477269, -1121078688, 1029692191, -1123790766)
		+ W(5, -1096987004, 1036148808, -1138151730, 1006910195)
		+ W(6, -1118014037, 1033739398, -1103397016, 1053311986)
		+ W(7, -1103945702, 1033532379, 1037138557, -1101429240) + W(8, 1045510949, 1016118627, 1013880803, -1135069562)
		+ W(9, -1107878452, 1035472806, -1113746932, -1127637067)
		+ W(10, 1041047838, -1112788047, 996243233, -1114181077)
		+ W(11, 998962565, 1041113135, -1118755335, 1020627009);
	sum2 = W(0, 998302909, -1114977231, -1111023634, 1036510752) + W(1, 1004185429, 1033017445, 1020343611, 1031676937)
		 + W(2, -1115901635, -1117993552, 1041465226, -1113757911)
		 + W(3, 1029585253, -1113383024, -1091081120, -1099268355)
		 + W(4, -1113451820, 1021941233, 1014080934, 1053648356)
		 + W(5, -1095412525, -1083342245, -1115471327, -1161911507)
		 + W(6, -1135780688, 1044096370, 1066870285, 1034064765)
		 + W(7, -1118193886, -1120710156, -1115911996, 1042686855)
		 + W(8, -1137657706, 1037488276, 1023464409, 1018751107) + W(9, 1018594371, -1108781434, 1043350243, 1014772326)
		 + W(10, -1138084208, -1148724493, -1117868456, 1037265024)
		 + W(11, -1126645268, -1113946823, 1032826620, 967002060);
	WS(1069042774, 1023813606);
	sum1 =
		W(0, -1120569815, 1029846837, -1087916882, 1052864835) + W(1, 1037940281, -1130288148, 982627530, -1113747494)
		+ W(2, -1109565588, 1048856613, 1011966045, -1136915076)
		+ W(3, -1113058670, 1033076468, -1095056850, 1056781822)
		+ W(4, 1041407837, -1140629239, -1122018428, 1039673254)
		+ W(5, -1085384902, 1059308179, -1107102153, 1027021082)
		+ W(6, -1110295833, 1038190732, -1083727323, 1063669175) + W(7, -1111254596, 1007651659, 1021479086, 1046432919)
		+ W(8, -1089999723, 1059014405, -1110936865, -1128736648)
		+ W(9, 1001627822, -1134594983, -1094559921, 1044534497)
		+ W(10, 1025983877, -1139332738, 1013049407, 1016231853)
		+ W(11, -1094610970, 1048044230, 1046858383, -1114487747);
	sum2 =
		W(0, -1097118790, -1088323667, 1067177084, 1049654149) + W(1, -1120538318, -1108580354, -1115645027, 1030684990)
		+ W(2, 1056476304, -1101283859, 1040556965, -1124995735)
		+ W(3, -1109249259, -1081609065, 1058423359, 1057270411)
		+ W(4, -1122455315, 1017763415, 1042765123, -1082143899)
		+ W(5, 1061996602, 1055747315, -1120372038, -1114753052)
		+ W(6, 1015795842, -1102809807, 1006287482, -1087207348) + W(7, -1106540179, 1040354664, 1028792702, 1059694558)
		+ W(8, -1085597397, -1106003210, 1042932361, 1033427208)
		+ W(9, -1116071919, 1064574838, -1080103447, 1023804763)
		+ W(10, 1048665861, -1098395984, -1105083736, 1072110122)
		+ W(11, -1081832849, -1090423898, -1101912272, 1049644025);
	WS(1046279854, -1100682627);
	sum1 = W(0, -1155754074, -1109896894, -1107576521, 1035511522)
		 + W(1, 1002805634, -1116898232, -1110611178, -1114421037)
		 + W(2, 1030120983, -1124410677, -1114543731, 1008443967)
		 + W(3, 1022309140, -1131162933, -1094043528, 1038811574)
		 + W(4, 1039227081, -1122237996, -1118509483, 1027993210)
		 + W(5, 1062355587, 1059809630, -1113128332, -1141634631)
		 + W(6, -1109973457, 1040243222, -1094900881, 1038778317)
		 + W(7, -1105636701, 1021837827, 1022155595, -1117693450)
		 + W(8, -1110047247, 1046487839, -1109843880, -1132048229)
		 + W(9, -1107208537, 1019138289, -1110631994, -1127423844)
		 + W(10, 1004796827, -1123472091, -1117715774, 996768085)
		 + W(11, -1107567326, 1039784548, -1112311954, -1128081977);
	sum2 = W(0, -1155805362, -1107499970, 1022847832, 1035480223)
		 + W(1, -1120962569, -1110725720, -1111094572, -1112866732)
		 + W(2, 1044264749, -1148903065, -1114470280, 1021130376)
		 + W(3, 1028160711, -1106540686, -1155674450, 1040150233)
		 + W(4, 1010774604, -1120260095, -1123681391, -1140638716)
		 + W(5, 1057429467, 1045538131, 1016428102, 1009992044) + W(6, -1116453985, 1031083122, -1106158641, 1031696457)
		 + W(7, -1120179561, 1026515918, -1119301235, -1139408516)
		 + W(8, 1025824831, 1041846065, -1118124541, -1114275912)
		 + W(9, -1108559318, 1034592379, -1111164410, -1120456085)
		 + W(10, 999266665, 1011855672, -1115385578, -1116565509)
		 + W(11, -1121519923, -1129601606, -1119709653, -1115407958);
	WS(1068834358, -1130516755);
	sum1 =
		W(0, -1110020716, 1034114243, 1048068617, -1102038774) + W(1, 1031998965, -1110620517, 1043574522, -1095778974)
		+ W(2, 1048936405, 1035735542, -1100504766, 1038840817) + W(3, -1110718798, 1047457188, 1038642250, -1105529591)
		+ W(4, 1047377413, -1109142655, -1129582842, -1108460854)
		+ W(5, -1114164062, -1096174934, -1130108598, 1023990363)
		+ W(6, -1114402010, 1054126843, -1110583455, -1112126358)
		+ W(7, 1044906670, -1122044916, 1034180284, -1096959660) + W(8, 1049433806, 1043709316, -1095231947, 1040978881)
		+ W(9, 1025857751, 1033414773, -1136840220, -1123546692)
		+ W(10, -1130058411, -1131191403, -1111247176, 1039130852)
		+ W(11, -1119539023, -1112879245, 1035429307, -1115530151);
	sum2 = W(0, 970017593, -1108165952, 1047729556, -1102798485)
		 + W(1, -1142827268, 1029593938, -1125442959, 1040753488)
		 + W(2, 1000227776, -1088611471, 1049645408, -1108133201)
		 + W(3, -1107196630, 1033984686, 1038319755, -1087549565)
		 + W(4, -1127043239, -1114349374, -1108273260, 1051322703)
		 + W(5, 1055231112, 1062180091, -1103837458, 1035145460)
		 + W(6, -1130992285, -1113564209, -1094436986, 1046553690)
		 + W(7, -1107399737, -1114342182, -1132402709, 1041587650)
		 + W(8, 986706110, -1113546876, 1048231400, -1146643074)
		 + W(9, 1017358256, -1116630320, -1124437274, -1120036494)
		 + W(10, -1124561928, -1126967424, 988670622, -1122802752)
		 + W(11, -1132214419, 1032902155, -1145381770, 1014303584);
	WS(1067517750, 1033639701);
	sum1 =
		W(0, 1025509678, -1102897085, 1023511162, 1037697110) + W(1, 1039047450, -1138182274, -1130341242, -1132678155)
		+ W(2, -1096924480, 1040728225, -1108434135, -1138791135)
		+ W(3, -1120272434, -1151042791, -1094474081, 1056422164) + W(4, 1032921189, 1010850641, 1018375590, 1013105800)
		+ W(5, -1086033191, 1062857884, -1122589009, 1034477848)
		+ W(6, -1116961737, 1041000592, -1085852953, 1058773976)
		+ W(7, -1100255843, -1112868181, 1026047982, 1032243033)
		+ W(8, -1093123217, 1063905370, -1106044526, 1026848855) + W(9, 1025041660, 1034904976, -1093479580, 1050274619)
		+ W(10, -1112977566, -1122948276, -1113724179, -1123793645)
		+ W(11, -1091335173, 1057695471, -1136654701, 1007925107);
	sum2 =
		W(0, -1101843642, -1101718380, 1046322966, 1051125372) + W(1, -1084762721, 1050651985, 1047092496, -1110599661)
		+ W(2, 1053918698, -1092942861, 1058235489, -1101055683)
		+ W(3, 1032746990, -1127672356, -1100340247, 1040369276)
		+ W(4, -1090389206, 1050412863, -1098074183, -1096713677)
		+ W(5, 1069438643, 1074732797, -1088693676, -1103557505) + W(6, 1053786699, -1104014372, 1025809994, 1050011098)
		+ W(7, 1053232821, 1052371166, -1096910060, 1035860070) + W(8, -1083706115, -1080423025, 999981171, -1099152238)
		+ W(9, 1043846267, -1097849415, 1048729218, -1117530220)
		+ W(10, -1097505133, 1041618808, 1023876031, 1051096852)
		+ W(11, -1081917128, -1091623712, 1050919626, -1123531943);
	WS(-1098378327, -1087753140);
	sum1 =
		W(0, -1149815841, -1123262056, -1110243207, 1053738584) + W(1, -1096838314, 1031741109, 1013838405, -1131552366)
		+ W(2, 997589309, 1025605911, 967065877, -1135340592) + W(3, 1021155853, -1114416842, -1104972312, 1049179692)
		+ W(4, -1108406847, 1029594857, 1025974631, -1103162646)
		+ W(5, 1042062186, -1094476095, -1130981226, -1145022506)
		+ W(6, 1017740987, -1099404299, 1057054155, -1093068705) + W(7, 1023051300, 1005012974, 1020943940, -1100518162)
		+ W(8, 1059648114, -1101042271, 1010424693, -1112923496)
		+ W(9, -1137239299, -1111541722, 1047878460, -1111532695)
		+ W(10, -1117167136, 1030823984, 1031952605, -1098489580)
		+ W(11, 1061110492, -1100382705, 989087216, -1113821120);
	sum2 =
		W(0, 1034695587, 1032463913, -1087773887, 1051055536) + W(1, -1103774157, 1028563957, -1111830177, 1031752431)
		+ W(2, -1104893727, 1010301739, 1003908630, -1111301343)
		+ W(3, 1017885202, -1103205904, -1114987001, 1045597173)
		+ W(4, -1107230114, 1042437558, -1116805918, 1045285117) + W(5, 1061301409, 1065451004, 999416278, -1106181364)
		+ W(6, 1039973913, -1092035876, 1053784665, 1036331211) + W(7, -1118216068, 1014136811, -1113376464, 1044034906)
		+ W(8, -1096259933, -1101789830, 1047293827, -1127455968)
		+ W(9, 1024357631, -1097056010, 1015259894, -1105822235)
		+ W(10, -1119063058, -1137717779, -1109344122, 1034392181)
		+ W(11, -1095057905, -1098597360, -1139528651, 1017174230);
	WS(1051991511, -1090129628);
	sum1 =
		W(0, -1119709994, 1035475128, 1044364174, -1099369674) + W(1, 1024914253, -1122358045, 1028979258, -1103260128)
		+ W(2, 1048862488, -1107028176, 1037758213, -1142000036)
		+ W(3, 1025569135, -1099928080, 1054464119, -1092954947) + W(4, 1045752341, -1110227337, 1025156752, 1041023848)
		+ W(5, -1103260308, 1048877896, 992983000, 1023847918) + W(6, -1113846787, 1030722332, -1090331224, 1036105176)
		+ W(7, -1115078629, 1018698636, 1032797781, 1040845476) + W(8, 1039529634, -1113372113, 1027244574, -1139349278)
		+ W(9, -1137003429, 1015665914, 1015668019, -1104520406)
		+ W(10, 1039091960, -1131269376, -1126457798, 1032471277)
		+ W(11, 1036006161, -1111431094, -1113568276, 1004297100);
	sum2 =
		W(0, 1043798657, -1098470129, -1126555274, 1029962999) + W(1, 1028782608, -1131048284, -1117698064, -1096590117)
		+ W(2, 1047971790, 1037727050, -1161955740, 1022180969) + W(3, -1102458928, -1084690772, 1067678357, 1008201251)
		+ W(4, -1103096568, -1120783295, -1101130902, 1065791971)
		+ W(5, -1099131342, -1083609361, 1051059538, 1014843769) + W(6, 1025730631, -1123809426, 1036453804, 1031198846)
		+ W(7, -1106261335, 1020274026, 1026623851, 1019910088)
		+ W(8, -1117295572, -1113754273, 1041141064, -1111232000) + W(9, 995294154, 990258218, -1116170672, 1030505142)
		+ W(10, 1028328942, -1127235720, 1012466631, -1124630920)
		+ W(11, 1010360391, -1136369090, -1119361560, 1001879503);
	WS(1062559660, 1025273829);
	sum1 =
		W(0, 1017067222, -1098241838, -1088364567, 1060515311) + W(1, -1113064427, 1036248943, 1004255955, 1041017424)
		+ W(2, -1088941672, 1050253504, -1115329590, -1133026900)
		+ W(3, 1019590495, -1136327879, -1087512143, 1064814036)
		+ W(4, -1113817187, 1008140615, -1109975080, 1032386976)
		+ W(5, -1083706517, 1061681108, -1146803505, 1028690158) + W(6, 1028071367, 1031451349, -1089169701, 1061080357)
		+ W(7, -1112935650, 1010963867, 1004648665, -1112687016) + W(8, -1092690193, 1052988124, 1031379878, 1030651112)
		+ W(9, -1129853588, 1040197151, -1100415991, 1048643203)
		+ W(10, -1112391860, -1133141907, 999516190, -1105242363)
		+ W(11, -1093365052, 1050105214, 1051227835, -1139571464);
	sum2 =
		W(0, 1058977722, -1088438618, -1070888183, -1080154822) + W(1, 1057028315, 1020668753, -1123128465, -1084402469)
		+ W(2, -1068917363, -1109667848, -1133954517, -1117456198)
		+ W(3, 1051128320, -1097793743, -1079680807, -1080832517)
		+ W(4, 1057005952, 1031920962, 1025585093, -1092491618) + W(5, 1078112044, 1058335327, -1089499329, 1039195999)
		+ W(6, 1043020026, -1090336452, 1082393215, 1067339759) + W(7, 1038175360, 1046190750, -1090331128, -1094761348)
		+ W(8, 1070728174, 1057746923, -1096630558, -1139309423)
		+ W(9, 1037612985, 1032815200, -1090225897, -1122043266)
		+ W(10, 1051816122, -1116527206, -1101815127, -1080227574)
		+ W(11, 1066541275, 1067785018, -1086032969, 1046599598);
	WS(-1077531606, -1068627295);
	sum1 =
		W(0, -1124767318, -1113367136, -1095446127, 1055377197) + W(1, -1111814927, -1126382267, 1034866077, 1048375560)
		+ W(2, -1099058463, 1047513184, 1045191539, 1025894069)
		+ W(3, -1101653116, -1104403272, -1090535733, 1058086815)
		+ W(4, -1094831865, -1117513042, -1130761376, 1049955828)
		+ W(5, -1087242437, 1061174628, 1048150628, 1008100281) + W(6, -1106412978, 1036710310, -1088900579, 1057172304)
		+ W(7, -1103308083, 999030326, -1121310187, -1108970480)
		+ W(8, -1096168584, 1056094244, -1102502166, -1115104524)
		+ W(9, 1040285922, 1049541454, -1097928011, 1047121222)
		+ W(10, 1043510842, 1032672660, -1107982930, -1107579101)
		+ W(11, -1095682732, 1054731422, -1103869114, 1025118882);
	sum2 =
		W(0, -1118325221, 1021086937, 1043003051, -1131106753) + W(1, -1122810381, 1007248641, -1109912068, -1119472758)
		+ W(2, 1026424546, 1030452362, -1109242129, 1007569065) + W(3, 1055626857, 1051951524, -1092928023, -1103671831)
		+ W(4, 1034708821, -1112697430, 1073210842, 1028908234) + W(5, -1081037490, -1079815727, 1035695099, 1034566233)
		+ W(6, 1050117205, 1044779683, -1093398148, -1105002867)
		+ W(7, 1037167425, -1131640977, -1108710534, 1039597247) + W(8, 1044106321, 1032627417, -1112762482, 1020894429)
		+ W(9, 1007734945, -1130127373, -1119182686, -1108845723)
		+ W(10, -1120996683, -1144614067, 1005945059, 1026547602)
		+ W(11, 1019051617, 1023992222, 999154803, 1009135009);
	WS(1027136184, 1037475189);
	sum1 =
		W(0, 1032095571, -1116112165, -1115063802, 1049018533) + W(1, -1119314641, -1107767341, -1100957374, 1049686375)
		+ W(2, 1038845436, -1106083983, -1120251015, 1047825580) + W(3, 1042581547, 1028374302, -1088748902, 1046087792)
		+ W(4, 1034473457, -1104556803, 1008293424, -1096656387) + W(5, 1053200569, 1044615055, -1099043646, 1041068763)
		+ W(6, -1125080965, 1033692244, 1024446429, -1090279185) + W(7, 1029265287, 1035958465, 1046313162, -1105885187)
		+ W(8, -1103807360, 1052904956, 1033985068, -1106489925)
		+ W(9, -1104233593, -1122471385, 1048125173, -1106111045)
		+ W(10, -1106885357, 1037737330, 1032243376, -1122778646)
		+ W(11, -1114896431, -1113201013, 1045413959, -1123269230);
	sum2 = W(0, -1109957285, 1028061230, 1045893852, -1110812851)
		 + W(1, -1108048047, 1027149256, 1046942588, -1090820835)
		 + W(2, 1047577084, 1048459161, -1114577527, -1106934834)
		 + W(3, -1108558913, -1168618571, -1096957845, 1058947879)
		 + W(4, -1104353646, -1104794282, 1035311457, 1053631926)
		 + W(5, -1097789717, 1028951753, 1041621301, -1139749789)
		 + W(6, -1103268017, -1140171429, 1058472778, -1086199154)
		 + W(7, 1047742834, -1105608688, 1020819182, 1024395745) + W(8, 1010859305, 1018177816, -1101676043, 1051639728)
		 + W(9, 1017489970, 1034074787, -1118924631, -1119421881)
		 + W(10, 1030918112, -1105627073, -1119040125, -1111153127)
		 + W(11, -1134098557, 1029986143, -1110045381, 1035525353);
	WS(1059085676, -1120419895);
	sum1 =
		W(0, -1123531970, 1010567522, -1140828475, 1031892193) + W(1, -1126417758, 1013434325, 1015920803, 1041225150)
		+ W(2, 1042370229, -1105839574, 1021017477, -1117671948)
		+ W(3, -1129458830, 1048968044, -1081896608, 1052692461)
		+ W(4, -1106306215, 1033141013, 1003238718, -1107069702)
		+ W(5, 1061545382, -1113798029, 1033163859, -1110196995)
		+ W(6, 1024388894, -1107554082, 1057779808, -1080962214) + W(7, 1051334024, 998455538, 1019022757, -1131681870)
		+ W(8, 1048429719, 1023517883, 974463598, -1104852314) + W(9, -1122285937, -1110859547, 1046207852, -1107360247)
		+ W(10, -1137698561, -1130795454, 1029064795, 1018058500)
		+ W(11, 1043188126, -1109838114, -1182091254, -1115208005);
	sum2 = W(0, -1115293356, 1051048471, -1116254969, -1108089569)
		 + W(1, -1110389222, 1032305896, -1104270657, 1028093784)
		 + W(2, 1055158904, -1104160418, 1040482382, -1109483288)
		 + W(3, 995357221, -1111420185, -1108447426, -1113016550)
		 + W(4, -1105273681, 1033267880, -1140125409, -1087783718)
		 + W(5, 1057721666, 1060085251, -1106428297, -1106001572)
		 + W(6, 1041981586, 1031459460, -1086769840, 1041174723) + W(7, 1046452617, -1115354420, 1016190873, 1035133120)
		 + W(8, -1119040585, -1119561801, 1045849559, -1127947625)
		 + W(9, -1140513641, 1028088400, -1121069799, -1114345654)
		 + W(10, 1044224673, -1119205024, -1115228320, 1019234873)
		 + W(11, 1043934745, -1097229960, -1114369945, 1033437588);
	WS(1063842732, 1069263660);
	sum1 = W(0, -1134238373, -1122877239, 1055968823, -1099884346)
		 + W(1, -1101209335, 1027783644, 1031532473, -1122091454)
		 + W(2, 1052972391, -1097152888, -1119905385, 1025876211)
		 + W(3, -1118861678, -1114405937, 1057777668, -1088480739)
		 + W(4, 1025124405, -1133551424, 1031846503, -1102409375)
		 + W(5, 1062381841, -1081966868, -1166909210, -1124858713)
		 + W(6, -1118980549, -1105793535, 1065218890, -1086950263)
		 + W(7, 1045788186, -1146513705, 1032122901, -1113900631)
		 + W(8, 1051224528, -1107218856, -1105943487, -1136389690)
		 + W(9, -1119645672, -1129606328, 1055096307, -1097976619)
		 + W(10, 1011470685, -1153551023, 1033668289, -1133229476)
		 + W(11, 1043160456, -1106065147, -1107257190, 1024085520);
	sum2 =
		W(0, 1008982555, 1017497319, -1114050188, 1044555710) + W(1, -1115112254, -1121509319, -1122047761, -1119731325)
		+ W(2, 1048705804, -1104624717, -1113283108, 1042591944)
		+ W(3, -1134583037, -1110768789, 1082656561, 1041907901)
		+ W(4, 1041138312, -1111081434, -1137222855, 1050149080) + W(5, 1079097716, -1088882238, 1033378952, 1018241317)
		+ W(6, -1140752305, 1041298195, -1069364548, 1050137131)
		+ W(7, 1048604087, -1128224049, 1029699842, -1094516021)
		+ W(8, -1064571216, -1099205492, -1105508475, 1008906239)
		+ W(9, -1114302140, 1037679865, -1105564781, -1109039739)
		+ W(10, 1026612451, -1118064246, 1026101716, 1029205125)
		+ W(11, -1121859551, 1040352044, -1131493091, 1024193619);
	WS(-1129102704, 1046511454);
	sum1 =
		W(0, -1120255189, 1003871004, -1098175836, 1060542285) + W(1, -1104614392, -1115237700, 992833099, 1029362986)
		+ W(2, -1113473140, 1049212165, -1118651222, 1012659838) + W(3, -1134582632, 988783847, -1095364566, 1059935407)
		+ W(4, -1098721330, 1026034940, -1138794987, 1011030567)
		+ W(5, -1091886143, 1049733902, -1109648580, -1116104473)
		+ W(6, -1157138191, -1118838023, 1040190185, -1115543549)
		+ W(7, -1121023765, 1036784617, -1129425099, -1111313565)
		+ W(8, -1149570791, 1041064643, -1105481630, -1112251695)
		+ W(9, 1016407976, -1115457860, 1037653026, -1119854466)
		+ W(10, 1031662787, 1023835049, -1133147960, -1106432157)
		+ W(11, 1038304902, 1029519512, -1111089569, -1170197274);
	sum2 = W(0, 1039353726, 1022956598, -1093991321, -1088722171)
		 + W(1, 1039854738, -1125147089, -1104263814, 1036699032)
		 + W(2, -1154678850, -1088770012, -1104468959, -1123571799)
		 + W(3, 1027240563, -1120983737, -1089878099, -1101846939)
		 + W(4, -1096446657, 1036003207, 1028285409, -1106986979)
		 + W(5, 1067214284, 1070132546, 1029156699, -1117321918) + W(6, 1032871415, -1095425364, 1047639440, 1045480826)
		 + W(7, -1098508409, 1027342659, -1151417050, -1136397826)
		 + W(8, 1051464555, -1099095249, 1024325599, -1150420266)
		 + W(9, 1027668005, -1108376211, -1104038071, 1043597107)
		 + W(10, -1148394393, -1138411071, 1023556565, -1098325150)
		 + W(11, 1061372327, -1086577064, 1034968116, 1031516803);
	WS(1056411607, -1109579684);
	sum1 =
		W(0, -1129654332, 1040494825, 1053570965, -1089114662) + W(1, -1099475130, 1041782836, 1027988397, 1031736403)
		+ W(2, 1051564806, -1091392278, 1018661052, 1032323860) + W(3, 1041758889, -1118623100, 1061336939, -1087917688)
		+ W(4, 1034322317, 1035039650, 1027974595, -1104250813) + W(5, 1057393436, -1081469355, -1094207710, 1010041732)
		+ W(6, 1038643645, 1023561152, 1065029703, -1091410052) + W(7, 1052271760, 1041287822, 1038422303, -1115303377)
		+ W(8, 1052932495, -1085011849, -1096091282, 1020820966)
		+ W(9, -1115801276, -1111435064, 1051403778, -1108233957)
		+ W(10, 1036087894, 1036272138, 1047822542, 1037517815)
		+ W(11, 1056446507, -1089621406, -1095410877, 1043391417);
	sum2 =
		W(0, -1114696922, 1063327246, -1085101471, -1089121793) + W(1, 1049274948, 1041765085, 1043151870, 1054945342)
		+ W(2, -1091433742, -1108711949, 1036153834, -1114908726)
		+ W(3, -1098855398, -1111180476, 1044429796, -1096795753)
		+ W(4, 1047012469, 1017938665, 1045725515, -1078968963) + W(5, 1071264665, 1049748951, 1043607695, -1113887753)
		+ W(6, 1041130784, -1075182266, 1068966947, 1041099170) + W(7, 1008700501, 1052357470, -1093166728, -1073598210)
		+ W(8, 1074573142, -1107925652, -1106854972, -1097732836)
		+ W(9, 1048010869, -1072729035, 1072575447, -1087601324)
		+ W(10, -1100708600, 1035577978, -1097485062, -1069127579)
		+ W(11, 1082548410, 1057234494, -1095686167, -1117196119);
	WS(-1075355670, -1094395357);
	sum1 =
		W(0, -1145694380, 1013276974, 1022872131, -1102394069) + W(1, -1132601278, 1032373060, 1031927794, 1019602069)
		+ W(2, 1012968093, -1105184299, -1113047243, -1123577887)
		+ W(3, -1126751284, 1034056645, 1064151904, -1089968245)
		+ W(4, -1112578984, 1012023536, -1107635165, 1046251906)
		+ W(5, 1059501808, -1079531190, 1045395638, -1121043161) + W(6, 1035883256, -1107984424, 1052823861, 1040654683)
		+ W(7, 1035604635, -1136193989, -1117999477, -1101824103)
		+ W(8, 1052884390, -1097950850, -1102570614, -1124087697)
		+ W(9, 1025403748, -1117853800, 1040309473, 1021798787)
		+ W(10, 1016601958, 1014648876, -1135056568, -1113050587)
		+ W(11, 1051481338, -1099617206, -1117559395, 1015049529);
	sum2 = W(0, 1040559153, 1024400373, -1112035522, -1102969122)
		 + W(1, 1035694118, 1008704054, -1099966915, 1050797480)
		 + W(2, -1095559069, 1048535090, -1109162397, 1035803260)
		 + W(3, 1051040838, -1098907063, -1091507667, -1081423354)
		 + W(4, 1049424016, 1032276403, -1122400566, -1088192853)
		 + W(5, 1063399780, 1065515124, -1098794388, -1104133833)
		 + W(6, -1103745056, -1132746540, 1064106398, -1104928579)
		 + W(7, -1097345189, 1042270874, -1127876766, 1040989775)
		 + W(8, -1101527709, 1047332946, -1105732065, -1109516912)
		 + W(9, -1118336076, 999475557, 1025976147, -1171911780)
		 + W(10, -1107661001, 1033064723, -1122216569, 1024449813)
		 + W(11, -1118033876, 1047796018, 1036172042, -1106418589);
	WS(1045480366, -1089018411);
	sum1 = W(0, 956510844, -1147321796, -1098659472, 1046172476) + W(1, -1117032824, 1012429717, 998930446, -1119371847)
		 + W(2, -1114996930, 1016456206, 1032232105, 992745416) + W(3, -1129843310, 1033743797, -1084286683, 1060852743)
		 + W(4, 1034928007, -1120189081, -1113698796, 1047477674)
		 + W(5, -1080535200, 1065762350, 1036591131, -1130833259) + W(6, 1001814128, 993727556, -1100569285, 1055209670)
		 + W(7, 1034876769, -1112309127, -1126854725, 1019312750)
		 + W(8, -1095107249, 1054147605, -1103835661, -1162991986)
		 + W(9, 1033942209, 991522899, -1106428344, 1040201800)
		 + W(10, -1110790848, 1019870324, -1127622934, -1124727396)
		 + W(11, -1102902186, 1049320503, -1117790432, -1166423644);
	sum2 =
		W(0, -1135134951, 1034251754, -1112699779, 1028246411) + W(1, 1024730233, -1141862453, -1138029383, -1112450391)
		+ W(2, 1048844919, -1097747276, 1036047504, -1116303285) + W(3, 1039247354, 1048129179, -1081251706, 1030988939)
		+ W(4, 1032907358, 1032058431, -1105815405, 1013788103)
		+ W(5, -1102377508, -1085286825, -1098604264, 1026446373)
		+ W(6, 1043479193, -1107279344, 1074756442, 1066704374)
		+ W(7, -1121203556, -1115422697, -1108579602, -1098532570)
		+ W(8, -1079912447, 1048531717, -1097926469, 1017067577) + W(9, 1036464698, -1125069222, 1051417558, 1025432715)
		+ W(10, 1037541288, -1110631868, -1114044136, -1106884027)
		+ W(11, -1113485350, 1037742006, -1114746618, 1026757097);
	WS(-1129198960, -1098545020);
	sum1 =
		W(0, 1016631370, -1103774667, -1097986678, 1055978916) + W(1, 998946812, -1113370572, -1109829274, 1046260982)
		+ W(2, -1103302894, 1038066845, 1013747092, 1026014767) + W(3, 1027654249, 1041444949, -1085753764, 1057520791)
		+ W(4, 1033950432, -1133701934, -1135763497, 1029491033)
		+ W(5, -1087937321, 1064242364, -1108378356, -1124979408)
		+ W(6, 1022371969, 1033440347, -1100503343, 1043702710) + W(7, -1149232679, 1034434352, -1109147378, 1047095266)
		+ W(8, -1092825640, -1106434743, 1039795292, -1123636138)
		+ W(9, -1124465415, -1135425502, -1114972810, 1042256612)
		+ W(10, -1134578155, -1133096682, 1000105708, 1031236725)
		+ W(11, -1092048676, 1048160666, 1047273267, -1110866582);
	sum2 =
		W(0, 1008784866, -1101060946, 1045200185, 1046672822) + W(1, -1118279822, 994298612, -1111810524, 1041574978)
		+ W(2, -1109901275, -1123470329, -1113194466, -1124039764)
		+ W(3, -1123287968, -1113715041, -1111729623, 1052382391)
		+ W(4, -1105523541, 1016737108, 1035375858, 1009783259) + W(5, -1099551228, 1057574679, -1090683445, 1025528776)
		+ W(6, -1131156064, -1117592464, 1028611861, 1037781521) + W(7, -1089242363, 1044936991, 1014562100, 1037249766)
		+ W(8, -1126723736, -1088911756, 1057541056, 1038965019)
		+ W(9, 1013976797, -1112331585, 1048583824, -1105025107)
		+ W(10, 1046019340, -1100984465, 1025684805, -1116058888)
		+ W(11, -1123970907, -1098796399, 1058673062, -1111874598);
	WS(1055927127, 1032414456);
	sum1 = W(0, 1026777470, -1105922759, 1039415013, -1114467391)
		 + W(1, 1040445212, -1109775801, -1114645447, 1038629978)
		 + W(2, -1109541160, 1049649890, -1118657663, 1029983880)
		 + W(3, -1107741345, -1118870909, -1121580331, -1099187900)
		 + W(4, 1040802710, -1103039897, 1034928754, 1048976902) + W(5, 1035267569, -1110167275, 1050521172, 1032803169)
		 + W(6, -1106080726, 1031310464, -1092363639, 1044706191)
		 + W(7, -1122260014, -1106266495, 1036990351, -1116578243)
		 + W(8, 1052806443, -1098780639, 1045812872, -1117906236)
		 + W(9, -1132545269, -1121324945, -1105847083, 1042096283)
		 + W(10, -1112784326, 1031828590, -1115024108, 1028926430)
		 + W(11, -1107491323, 1026721601, 1028974308, -1113700371);
	sum2 =
		W(0, 1046339838, -1095477634, 1041080449, -1106007640) + W(1, 1022253579, -1124447256, -1116647554, 1046850624)
		+ W(2, -1097525459, 1046513622, -1109703351, 1043170037) + W(3, 1008329020, 1046890022, -1087064144, 1055899106)
		+ W(4, 1048733947, -1100004355, 1019769686, -1090363791)
		+ W(5, 1051375999, -1097018549, 1049672544, -1097807314)
		+ W(6, -1108633040, 1015468535, 1042338708, -1122727333)
		+ W(7, 1051464963, -1129042543, 1035617664, -1092874283)
		+ W(8, 1061754259, -1100515622, 1025134369, -1112390214)
		+ W(9, 1033551944, -1110478242, -1118600243, 1043707610)
		+ W(10, -1099218588, 1040819075, -1127469148, 1032940188)
		+ W(11, -1108757958, 1042447169, -1108633308, -1120359161);
	WS(1063732396, 1030954530);
	sum1 =
		W(0, 1032126752, 1036299263, 1040042182, -1085959612) + W(1, 1040218780, 1017251428, 976782235, -1151769923)
		+ W(2, -1126287138, -1100277765, 1040546448, -1135394341)
		+ W(3, 1026279044, 1034233519, 1024363996, -1112294345) + W(4, 1044348191, -1164354746, -1118035684, 1048463661)
		+ W(5, -1092651532, -1099766629, 1048686290, 1013744650) + W(6, 1028715099, 1036782808, -1113174091, 1035866674)
		+ W(7, 1009750781, -1137751148, -1121995199, 1036166050) + W(8, -1102126950, 1049742039, -1118854702, 972654113)
		+ W(9, 1032435871, 1020132772, -1118937966, -1116277291)
		+ W(10, 1040779899, -1123833085, -1124714096, 1046021200)
		+ W(11, -1096484767, 1041160144, 1026126509, 1032085003);
	sum2 =
		W(0, 1023560328, -1114346246, 1055635447, 1080093571) + W(1, 1053265582, -1109086292, 1005726416, 1027252420)
		+ W(2, 1058379047, 1066361916, 1041698127, 1032891532)
		+ W(3, -1116687692, -1128267680, -1093219742, -1079490865)
		+ W(4, 1044641580, -1142986448, -1115408842, -1102003721)
		+ W(5, -1075825777, -1069273193, -1103412699, 1040229437)
		+ W(6, 1041728877, 1038357336, -1122468504, 1048667285) + W(7, -1104322529, 1008854368, -1105589301, 1012806192)
		+ W(8, 1043596623, 1040586029, -1123753164, -1116993440) + W(9, 1038558105, 1025579970, -1110943172, 1032482622)
		+ W(10, -1134749344, -1125346072, -1113100068, 1032847335)
		+ W(11, 1037773232, -1123027612, 1003892288, 1027065900);
	WS(-1091386327, 1040820769);
	sum1 = W(0, -1133727678, -1113530145, 1024243708, 1033777591)
		 + W(1, 1009482248, -1122301794, 1015097725, -1145488419)
		 + W(2, -1111308865, 1043618337, -1113425624, 1016257779)
		 + W(3, -1138479056, 1016526204, -1103657483, 1057905859)
		 + W(4, -1104459527, 1026855702, -1114059050, 1038143634)
		 + W(5, -1091368514, 1056300329, -1103801765, -1136938187)
		 + W(6, 1024901707, -1118547201, -1102986721, 1019703993)
		 + W(7, 1043076580, -1118577003, -1122041679, 1031893970)
		 + W(8, -1104061090, 1024793576, 1039830345, -1111999542)
		 + W(9, 1013224377, -1120867010, 1020963773, -1114932462)
		 + W(10, 1042855834, -1119434421, -1123564392, 1007161468)
		 + W(11, -1118947879, 1024563890, -1129826522, 1018984621);
	sum2 =
		W(0, -1118014300, -1107425211, 988341556, -1122432623) + W(1, 1031639360, -1122715046, -1121259996, 1034914627)
		+ W(2, 1058886039, 1043257251, -1110426684, 1030027284) + W(3, -1118480989, 1057124947, 1080471640, 1049657622)
		+ W(4, 981320073, 1022014335, -1120519112, 1041680563) + W(5, -1067455811, -1080970083, -1105451271, 1012008135)
		+ W(6, 1034237400, -1110358856, -1105716188, -1091987171)
		+ W(7, 1044181951, -1121988626, 1031820662, -1114315301)
		+ W(8, -1113532913, 1051213388, -1110623014, 1009779611)
		+ W(9, -1116062192, 1010762999, 1033223294, -1109593637) + W(10, 1038375349, -1113750985, 1029964608, 974005161)
		+ W(11, -1106855886, 1037720533, 999181553, 1028099986);
	WS(1067317974, -1128063738);
	sum1 =
		W(0, -1112292702, 1047000343, -1088068429, 1048838463) + W(1, -1121751190, 1027999791, 1030230219, 1008892739)
		+ W(2, -1130941083, -1108932456, 1013016624, 1017454988) + W(3, 1023947008, 1038318737, -1122235065, 1034700890)
		+ W(4, -1165199081, 1031463650, 1037678225, -1110797816) + W(5, 1055157388, -1096039434, 1039874719, 1025959551)
		+ W(6, 1016840879, -1118959774, 1048428783, -1113377160) + W(7, 1031603132, 1018062255, 1032095758, -1114918032)
		+ W(8, 1052878187, -1088738347, 1045859362, -1143147336)
		+ W(9, 1018620213, -1114992535, 1036886165, -1100769370) + W(10, 1028131502, 1018649043, 1023530868, 1004226268)
		+ W(11, 1052393190, -1082056652, 1050791676, -1115371169);
	sum2 = W(0, 1017164622, -1091622621, 1072454217, 1067262657) + W(1, -1098954881, 1035940089, 1004731920, 1038964407)
		 + W(2, -1113390241, -1112910469, 1038887363, -1108193245)
		 + W(3, 1046790460, 1049069382, -1080520963, 1044434118) + W(4, 1033204278, 1032575148, -1106036842, 1047078409)
		 + W(5, -1071223185, -1073367678, -1106847320, -1127548642)
		 + W(6, 1036535757, -1107481011, 1059476479, -1099641871)
		 + W(7, 967303234, 1015223408, -1103678216, -1098544714) + W(8, 1061994978, 1029437169, 1030771421, -1109007913)
		 + W(9, 1025471738, 1040369699, 1053016271, 1051233508)
		 + W(10, -1123160801, 1042599225, -1122761780, -1107095641)
		 + W(11, 1054597152, 1062276141, -1113404397, -1116480773);
	WS(-1095745367, -1102532016);
	sum1 =
		W(0, -1117700567, -1131139906, -1104729417, 1031266390)
		+ W(1, 1034962037, -1123836106, -1125050061, -1115476726)
		+ W(2, 1049785973, 1034862742, -1108925228, 1021444802) + W(3, -1104292247, 1044141479, -1096094522, 1043929817)
		+ W(4, -1121682994, -1112024639, 1032821374, 1043020835) + W(5, -1103984511, 1025371182, 1003529681, 1036065165)
		+ W(6, -1106685309, 1033588284, -1135965844, 1048857569)
		+ W(7, -1108409524, -1114922921, 1026094807, 1027591436) + W(8, -1092452582, 1049600882, 1029191534, 1028793076)
		+ W(9, -1109617979, 1031476842, 1035377859, -1127826823)
		+ W(10, -1105178749, 1025559229, 1025256272, -1109574827)
		+ W(11, -1108767399, 1045422790, -1147768356, 1027631502);
	sum2 =
		W(0, -1102917712, 1050493331, -1104683957, 1038417192) + W(1, 1032679083, -1124032472, -1090566997, 1058641835)
		+ W(2, -1106617401, -1131983160, -1117134944, -1142618034)
		+ W(3, -1083236080, 1072277942, -1083529216, 1026745412) + W(4, 1030312114, 1033461689, -1084121809, 1066117726)
		+ W(5, -1110147426, -1097349120, 1045086676, -1107466492)
		+ W(6, -1092542987, 1055792221, 1053260074, -1092834676)
		+ W(7, -1115504874, 1040055828, -1098664696, 1016159325)
		+ W(8, 1047496584, 1048447149, -1103742512, -1111688997)
		+ W(9, -1115432352, -1123932559, 1040670728, -1110071086)
		+ W(10, 1018575153, 1025562022, -1109069600, -1107091755)
		+ W(11, 1041712051, 1019306140, 1023956348, 995416610);
	WS(1064673964, 1027541745);
	sum1 =
		W(0, 1040862122, 1042078126, 1060076351, -1092017101) + W(1, 1050924251, -1113513485, -1105951646, -1104573695)
		+ W(2, 1032906140, -1098380055, -1103234546, -1122608113)
		+ W(3, -1159900529, -1104241265, 1059885441, -1084208856)
		+ W(4, 1045405901, -1114509959, 1047048323, -1111978190)
		+ W(5, 1064315273, -1089015252, 1048739529, -1097330869)
		+ W(6, -1123048515, -1096920009, 1059865934, -1085419935)
		+ W(7, 1043557114, -1130206982, -1115789415, 1032018046) + W(8, 1050382000, -1095947620, 1032498465, 1009712656)
		+ W(9, 1032172675, 1022298419, 1053685923, -1104053605) + W(10, 1042167691, 1011282770, 1028373376, -1099040790)
		+ W(11, 1058530774, -1087017843, 1037400788, -1099616447);
	sum2 = W(0, 1039738446, -1137481092, 1036746190, 998253152) + W(1, 1035100433, 1029249908, -1096514001, 1050849818)
		 + W(2, -1109747727, -1102987618, -1144728624, -1103405950)
		 + W(3, 1067583917, 1017170018, -1078331016, 1044897487)
		 + W(4, -1108804343, -1113657787, 1083413745, 1041988969)
		 + W(5, -1066189939, -1088427847, 1030429056, 1049519441)
		 + W(6, 1067818743, -1115429835, -1077977055, -1125950758)
		 + W(7, -1124211336, -1105416150, -1089267428, 1054896719)
		 + W(8, 1050059376, -1108032139, 1045807183, -1104699523)
		 + W(9, 1050540062, -1108022123, -1119460484, 1038480975)
		 + W(10, -1164441214, 1036658641, -1102208699, 1042362507)
		 + W(11, -1140654200, -1098634922, -1138500556, -1135144148);
	WS(-1084384556, -1100810808);
	sum1 =
		W(0, 1032390692, -1101205955, -1095424763, 1056723089) + W(1, -1103994552, -1113631133, 1033258828, -1114756638)
		+ W(2, -1115332589, 1044941511, -1103092466, 1038921097) + W(3, 1036208454, 1034225747, -1089988048, 1059213081)
		+ W(4, 1016698694, 1041433148, -1153131217, -1123281148)
		+ W(5, -1080799329, 1058219330, -1102604175, 1029458059) + W(6, 1035878930, 1052764669, -1086451675, 1065718984)
		+ W(7, 1010056863, 1046701849, -1113170436, -1110681734)
		+ W(8, -1089641270, 1051546784, -1105901266, -1114617106)
		+ W(9, 1034716867, -1132636906, -1111992667, 1048907447)
		+ W(10, -1104305197, 1022756491, 1008810370, 1010363102)
		+ W(11, -1089944572, 1051751177, 1025009925, 1042675492);
	sum2 =
		W(0, 1003892755, -1106845972, -1130802613, 1042856976) + W(1, -1090921483, 1035865477, -1123544386, 1040443741)
		+ W(2, -1099129814, 1046395618, -1117156960, -1128022157) + W(3, 1040199158, 1041556166, 1034864555, 1049252005)
		+ W(4, -1101642940, 1029291710, -1099919704, -1098641213)
		+ W(5, 1044973210, 1051151809, -1094482604, 1033022953) + W(6, 1046124074, 1043027552, 1046986152, -1120255910)
		+ W(7, 1049495257, 1028643166, -1114201767, -1102894487)
		+ W(8, 1040886200, -1098031952, -1113386876, 1031856421)
		+ W(9, -1137485313, 1031291554, -1097152858, -1103612985)
		+ W(10, -1132183417, -1106468948, 1018916205, 1029095170)
		+ W(11, 1035815457, 1034278467, 1026205590, 1020718685);
	WS(-1097545175, -1081485407);
	sum1 = W(0, 1036015463, 1034150438, 1057909318, -1085934785) + W(1, 1035924004, 1033963168, 1036906638, -1107749409)
		 + W(2, 1041348600, -1091465804, -1120240750, -1115496908)
		 + W(3, 1033438601, 1025404544, 1058891216, -1088212159)
		 + W(4, 1040930578, 1023737332, -1148467606, -1130068931)
		 + W(5, 1062920275, -1085185870, 1044931644, 1034996968)
		 + W(6, -1116883369, -1110996648, 1058446394, -1083820335)
		 + W(7, -1110014855, -1109644005, 1043481795, -1129433572)
		 + W(8, 1057530498, -1097522985, 1046628778, 1044774695)
		 + W(9, -1107248831, -1112307200, 1041812911, -1098817647)
		 + W(10, -1112689630, -1109394217, 1035852867, -1133343797)
		 + W(11, 1058924580, -1088845017, 1031062731, 991839047);
	sum2 =
		W(0, -1085422352, -1096165509, 1057773529, -1090487063) + W(1, 1044955346, 1048850208, -1073537081, -1097506962)
		+ W(2, 1050305732, 1042351306, -1096519547, -1098077313) + W(3, -1090145600, 1035648589, 1070820271, 1042246902)
		+ W(4, 1012707558, 1040847724, -1103264022, 1037776879) + W(5, 1064009122, 1057815879, 1035447241, 1039355809)
		+ W(6, -1098060014, -1106454260, -1102687355, 1056492080)
		+ W(7, -1098251612, -1128314591, 1039561049, -1132410675)
		+ W(8, 1037201191, -1132940238, 1055262754, 1034334977)
		+ W(9, -1111561066, -1095706003, -1106323076, 1047053654)
		+ W(10, -1098685023, -1107078913, -1097648243, -1093619532)
		+ W(11, 1065891070, -1104795343, 1017091667, 1044351754);
	WS(-1079771574, 1075069839);
	sum1 = W(0, 1032166989, -1118529175, 1055702741, -1092970539)
		 + W(1, -1117950828, -1113551430, -1111167476, 1021133405)
		 + W(2, 1048648437, -1092445782, 1033539229, -1142239002)
		 + W(3, -1123178206, -1093562003, 1062276827, -1088433116)
		 + W(4, -1104828877, -1110397888, 1032734815, -1104246611)
		 + W(5, 1071187580, -1118830448, -1114529494, -1119974813)
		 + W(6, 1029165557, -1098100446, 1061220800, -1097110780)
		 + W(7, -1112849365, -1139975764, -1112820125, -1114628655)
		 + W(8, 1049405702, -1093425874, 1023590922, -1111568211)
		 + W(9, -1135576864, -1133453360, 1042497282, -1109854691)
		 + W(10, 992807281, 974859957, -1114861753, -1119446905)
		 + W(11, 1051379002, -1094782027, -1104282614, -1107804608);
	sum2 =
		W(0, -1108373663, 1058265898, -1105791278, -1097633487) + W(1, 1040059628, 1041333883, 1008476139, -1092753943)
		+ W(2, -1098184263, 1036219103, -1096394805, -1106791026)
		+ W(3, -1104454680, 1052155727, -1106622092, 1039768739) + W(4, 1043022076, 1034264586, 1048684757, -1094584251)
		+ W(5, 1051207789, 1059813061, -1089567461, 1043988712) + W(6, -1093428939, 1044002260, 1040647411, 1037804238)
		+ W(7, 1053976656, -1094438691, 1053127551, 1027921055) + W(8, -1092246791, 1058749571, -1109099791, 1046191998)
		+ W(9, -1096653504, -1109762731, 1028193495, -1091622541)
		+ W(10, -1128546349, -1105323978, 1052320010, -1093142139)
		+ W(11, -1102532444, 1056925595, -1105143398, 1027895571);
	WS(-1080085654, 1070612946);
	sum1 =
		W(0, 1024243697, -1111019203, -1099863023, 1051294614) + W(1, 1018553499, 1001929499, -1118763904, 1017624971)
		+ W(2, -1093242824, 1049086721, -1110032568, -1129474933)
		+ W(3, -1129448298, 998267115, -1096657110, 1054244159)
		+ W(4, -1107816470, -1103030358, -1125372076, 1049904509)
		+ W(5, -1083526619, 1063525996, 1050014740, 1034265690) + W(6, -1130529432, 1044325341, -1084273056, 1060516258)
		+ W(7, -1120428313, 1028809164, -1113325424, 1036368923)
		+ W(8, -1089131829, 1052725165, 1042939778, -1137068591) + W(9, 1028582463, 1022422215, -1100657096, 1045179095)
		+ W(10, -1105723916, 995816851, -1115811081, 1029887376)
		+ W(11, -1095229037, 1047234173, 1034815359, 1023513072);
	sum2 =
		W(0, 1027629060, -1114994936, 1044032624, -1120685804) + W(1, 1028515824, -1128032940, 1025235210, 1042086314)
		+ W(2, -1110089750, 1041443307, -1109301707, 1028557604)
		+ W(3, -1125103522, -1109536432, 1027377576, 1041551160)
		+ W(4, 1038947979, -1095260923, -1130467636, 1043514454) + W(5, 1040857173, 1078385077, -1069674168, 1041445431)
		+ W(6, 1000499297, -1116030212, 1049094807, 1071531230) + W(7, -1072009528, 1044521776, 1020465580, 1034381305)
		+ W(8, -1102199059, -1097624207, 1042363648, -1111317304)
		+ W(9, -1138182160, -1133867384, 1040209410, 1042950964)
		+ W(10, -1100125727, 1026231984, 1014590712, 1032991925)
		+ W(11, -1107097337, -1110894461, 1020171064, -1115643044);
	WS(-1094677847, 1071331518);
	sum1 =
		W(0, -1108370254, 1050522446, -1090412394, 1059909490) + W(1, -1131659964, 1045668787, 1027561514, -1102155388)
		+ W(2, -1096900614, 1033926552, -1108396174, -1099365497)
		+ W(3, -1098732332, 1051883284, -1088235704, 1060113893)
		+ W(4, -1104366446, 1036562753, -1118400576, 1052444946) + W(5, -1081990504, 1065971548, 1016076284, 1045429432)
		+ W(6, -1098654343, 1048632224, -1083209683, 1057796766) + W(7, -1094058291, 1027649399, 1020701942, 1036179296)
		+ W(8, -1095695623, 1055081266, 1044926426, -1115499084)
		+ W(9, -1114608461, 1043748547, -1096819473, 1048355474)
		+ W(10, -1102235562, 1020598162, -1102267173, 1046936641)
		+ W(11, -1088405429, 1057781222, -1122894705, 1041162909);
	sum2 = W(0, -1102306900, 1042298222, 1021581591, -1097774924) + W(1, 1051289508, 1044651623, 1039340517, 1011988276)
		 + W(2, -1091773202, -1083547573, 1050176620, 1060043835)
		 + W(3, 1036459319, -1104503945, -1086047943, -1076320925)
		 + W(4, 1066124397, 1072230275, 1032447827, -1099734245)
		 + W(5, -1071833762, -1070847208, 1069182349, 1080482397)
		 + W(6, -1099327251, 1032726509, -1087097517, -1079468544)
		 + W(7, 1058492703, 1067612874, 1052797014, 1032685073) + W(8, -1094401898, -1084551630, 1061745990, 1060905071)
		 + W(9, -1122082449, 1045894449, -1089730964, -1096261152)
		 + W(10, 1029975482, 1035766217, -1098452307, 1031495568)
		 + W(11, -1094627244, -1097740674, 1062784611, 1036170953);
	WS(-1075403638, -1098484659);
	sum1 =
		W(0, 1008218969, -1141902179, 1045612697, -1098198307) + W(1, -1115216112, 1014117412, 1031048294, 1016567255)
		+ W(2, 1051272109, -1097302541, 1045061466, 1032424528)
		+ W(3, -1123131291, -1102849342, 1045999461, -1089514713)
		+ W(4, -1110301017, -1117285565, 1045188911, 1018204181) + W(5, 1067242878, -1083074125, 1055219615, 1039741805)
		+ W(6, -1123984690, -1097928441, 1057827361, -1090995143)
		+ W(7, 1042127630, -1138318152, 1016373997, -1102752375) + W(8, 1039307800, -1089521325, 1018247819, 990571063)
		+ W(9, 1038284987, -1119205801, 1052680217, -1111274305) + W(10, 1043301703, 1035406958, 993498863, -1111653947)
		+ W(11, 1048974634, -1089001074, -1112012330, 991913685);
	sum2 = W(0, 1032878555, -1136655860, 1031615749, -1113247036)
		 + W(1, -1102324444, 1033821831, -1123900432, 1023477569)
		 + W(2, 1032172309, 1040892014, 1041677780, -1122117887) + W(3, 1029453781, 993352402, -1101515073, -1093800370)
		 + W(4, -1099560811, -1111754290, -1120535472, 1007422372)
		 + W(5, 1063516373, 1059067488, -1101931537, -1118366060)
		 + W(6, 1040510410, -1110556919, -1114866186, 1049733424)
		 + W(7, -1091691569, -1131546954, -1109544472, -1138628828)
		 + W(8, -1101753271, -1112478460, -1137342172, 1043560141)
		 + W(9, 1036988619, -1137184004, 1046060209, -1128679382)
		 + W(10, -1112686045, -1110783375, -1113659102, 1035524869)
		 + W(11, -1110546008, -1106958218, 999359657, 1026284797);
	WS(1018938736, 1060529869);
	sum1 =
		W(0, -1114076530, 1037607357, 1045714156, -1166977277) + W(1, -1102825464, 1003359422, 1008598737, -1120766810)
		+ W(2, 1044442542, 1024586298, 985048227, 1019680094) + W(3, 1029696041, -1113865353, 1057228923, -1084710912)
		+ W(4, 1048654858, -1122235660, -1118730378, 1019917938) + W(5, 1049628033, 1048848151, -1109196652, 1032134772)
		+ W(6, 1036159584, 1041300082, -1081803320, 1052825757) + W(7, -1101625253, 1023446241, 1012443924, -1119787914)
		+ W(8, 1042784239, -1110703311, 1021290536, 1025035938) + W(9, 1034257674, -1102751430, 1016494120, -1108049641)
		+ W(10, 1039349129, -1122160707, -1133449206, 1018668169)
		+ W(11, 1031639516, -1111061268, 1018121541, 1028394476);
	sum2 = W(0, -1146778654, 1033337426, -1101837401, 1023259685)
		 + W(1, -1165315756, 1017616818, 1009999826, -1117028555)
		 + W(2, -1107426057, -1113617305, 1042598704, -1119841713)
		 + W(3, 1042445717, -1092512747, -1106280442, 1063964069)
		 + W(4, -1101414619, 1033400884, 1027431889, -1100415596)
		 + W(5, 1063146362, 1058459732, -1136881638, -1110929163)
		 + W(6, -1118789096, -1100913756, -1086144449, -1101061454)
		 + W(7, -1099212326, 1043348599, 1034933139, 1031653672)
		 + W(8, -1121957589, -1139753565, 1035181957, -1110261015)
		 + W(9, -1102516465, 1049736808, -1104136456, 1034026738)
		 + W(10, 1031514566, -1119239229, 1039233552, -1123203031)
		 + W(11, -1123128270, -1143324392, -1103321885, 1032933914);
	WS(1057790316, -1113005641);
	sum1 = W(0, -1123468520, 1034968039, -1107161453, 1035442035)
		 + W(1, -1107573447, 1040623159, 1016842734, -1180462681)
		 + W(2, -1109372445, -1126387193, -1110219956, 1001956750)
		 + W(3, 1017823704, -1141354132, -1097660717, 1045333479)
		 + W(4, -1111689634, 1034883047, 1031334797, -1111663246)
		 + W(5, 1060769665, -1097006056, 1016331253, -1121213099)
		 + W(6, 1029517379, -1096962432, 1062816796, -1085875335) + W(7, 1042106418, 999707420, 1032276500, -1102337515)
		 + W(8, 1057344992, -1087615930, 1042154624, -1110655190)
		 + W(9, 1024531558, -1112383277, 1050585827, -1099229077)
		 + W(10, 1021430571, 1027213229, 1032934320, -1115337892)
		 + W(11, 1048852876, -1104188731, 1007994773, -1125102461);
	sum2 =
		W(0, 1027505374, 1006384241, 1038217397, -1102596332) + W(1, -1088198084, 1054112069, -1119743709, 1032385395)
		+ W(2, -1124784904, 1055108824, -1101781911, -1110486748)
		+ W(3, 1022357321, -1110226975, 1036163691, -1095998103)
		+ W(4, -1077861124, 1063443275, -1129702556, 1009992786)
		+ W(5, 1038388564, -1096068823, -1082211809, 1060625206)
		+ W(6, 1025908250, -1117540770, -1107551412, 1027585837)
		+ W(7, 1067639721, -1095993202, -1116658238, 1015280579) + W(8, 1043662427, 1052401764, 1063419774, -1084462256)
		+ W(9, 1007287620, 1013929491, -1110875284, -1112465838)
		+ W(10, 1041946916, 1040943353, -1132286080, -1123806249)
		+ W(11, 1032548500, 1049275421, 1054953848, -1088060635);
	WS(1057314092, 1031126097);
	sum1 = W(0, -1113264897, 1047286031, 1051515170, -1091122512)
		 + W(1, 1035529026, -1125355113, 1042921300, 1038748523) + W(2, 1044373061, -1119263830, 1016709539, 1029610636)
		 + W(3, -1118216326, 1040626286, 1057172805, -1081529962) + W(4, 1043973191, 1029771624, 1036778483, 1048990343)
		 + W(5, -1111196723, -1076778621, 1049229393, -1112976162)
		 + W(6, 1035020911, 1036098930, 1053560288, -1085296972) + W(7, 1046938632, 1041831703, -1108928881, 1042428894)
		 + W(8, 1053915059, -1112351005, -1123285785, -1103970660)
		 + W(9, 1036290288, 1016422504, 1044112316, -1100809115) + W(10, 1035877806, 1044125996, 1012907241, 1041504752)
		 + W(11, 1048512334, -1107245185, -1123727583, -1123672296);
	sum2 =
		W(0, -1110279027, -1116888772, 1033554595, -1108669327) + W(1, 1015808739, 1027314221, 1044898087, -1115916604)
		+ W(2, -1111117443, 1045218355, -1106102431, -1116221606)
		+ W(3, -1096945908, -1107202311, 1035778723, -1103416606) + W(4, 1041666953, 1024714919, 1039092196, 1045884385)
		+ W(5, -1113256321, 1065794034, -1107247823, -1098987808)
		+ W(6, -1113241071, -1103988696, -1115920774, -1090569433)
		+ W(7, 1049716916, 1049758114, -1099008684, 1049112986)
		+ W(8, -1139004677, 1055599565, -1106016659, -1091770239)
		+ W(9, 1044106833, -1123386226, -1112080343, -1099737884)
		+ W(10, 1031391070, 1053158291, -1103116396, -1134049769)
		+ W(11, -1114347803, 1044073709, -1108799013, -1105054228);
	WS(-1078536214, 1004530797);
	sum1 = W(0, 1027375859, -1101920227, 1025777344, 1044389645) + W(1, -1110651587, 1018050380, 1017444741, 1031432968)
		 + W(2, -1103056081, 1048716617, -1137653198, -1125959547)
		 + W(3, -1120029560, -1106564803, -1107107772, 1051154454)
		 + W(4, -1107166356, 1019570356, 1000019140, 1048371434)
		 + W(5, -1082038651, 1066595410, -1130046381, -1125449965)
		 + W(6, -1114543207, -1118108517, -1087843395, 1055824714)
		 + W(7, -1105265945, 1033235496, 1013557197, 1042631950)
		 + W(8, -1090887738, 1054676989, 1030116559, -1126792065)
		 + W(9, -1122136338, 1018155212, -1103973545, 1041035048)
		 + W(10, 1023828021, -1122035417, -1148145247, 1016114854)
		 + W(11, -1102912795, 1016296812, 1040191506, -1142050258);
	sum2 =
		W(0, 1027035378, 1026113022, -1111907604, -1117578886) + W(1, -1140538653, 1018825264, -1132701065, 1034348094)
		+ W(2, 1044772326, 987582920, -1136739637, 1015195718) + W(3, -1114259972, 1019537869, -1115459713, -1091701771)
		+ W(4, -1106970806, 1029368182, 1024730711, -1139897757)
		+ W(5, -1083470341, -1064559027, 1035917626, -1129456736) + W(6, 986229224, -1140805741, 1024256637, 1083026821)
		+ W(7, 1051507274, 1025912688, 1013886009, -1118691470) + W(8, 1050967575, 1062853848, 1035548789, -1107265712)
		+ W(9, -1129435432, 1009541569, 1013091981, -1097816209)
		+ W(10, 1030786995, 1031335734, -1141056234, -1129312440)
		+ W(11, 1028089297, 1036032976, -1102804079, -1115863996);
	WS(1053759831, 1032374114);
	sum1 =
		W(0, 972229904, -1121671930, 1054724605, -1092393035) + W(1, 1018308729, -1129466650, -1109228149, -1112583528)
		+ W(2, -1112974870, -1101934908, 1027590122, 1029939172) + W(3, 1034978575, 1034149296, 1061211455, -1092299422)
		+ W(4, 1034030567, -1113423424, 1041049216, 1029443406) + W(5, 1048871720, -1093922438, -1111847647, 1038901743)
		+ W(6, -1120680758, 1029497788, 1059772533, -1094240300)
		+ W(7, 1041914031, -1106909549, 1029299866, -1098177536)
		+ W(8, 1052523382, -1091878482, -1113968603, 1040006220)
		+ W(9, -1104501302, -1147362406, -1143596105, -1112394307)
		+ W(10, 1028043992, -1140269215, 1034604409, -1129221556)
		+ W(11, 1050895314, -1097371836, -1126204095, 998375305);
	sum2 =
		W(0, -1150066816, -1150466984, 1023864952, -1110066210) + W(1, 1023825317, -1124858867, -1122485893, 1032358015)
		+ W(2, -1120268940, 1042589181, 1027888694, -1130877326)
		+ W(3, -1114773240, 1050624105, -1092046440, 1028033997)
		+ W(4, -1151325172, -1135440218, 1024800634, 1086980496)
		+ W(5, -1062089081, -1086968029, 1038366470, -1140173368) + W(6, 996682648, 1049846439, -1092228228, 1024724796)
		+ W(7, -1121152696, 1022098295, -1123997738, -1116390866)
		+ W(8, 1022750294, 1041929871, -1118357792, 1017805328) + W(9, 1019128023, 1016213345, 1015347232, -1114433107)
		+ W(10, 1031614438, -1119866592, -1127165963, -1127449775)
		+ W(11, 1000268865, -1139900476, -1136800730, 1025894920);
	WS(1063005484, 1009613411);
	sum1 = W(0, 1023879031, -1099686359, 1052137768, 1046007565)
		 + W(1, -1104853008, 1005501772, -1116658758, -1121736524)
		 + W(2, 1047373394, -1096622041, 1032552475, -1119708225)
		 + W(3, 1016433014, -1101192360, 1060630207, -1088767007)
		 + W(4, -1107092245, -1118541917, 1020845368, -1114633573)
		 + W(5, 1066103327, -1084203279, 1041296218, -1116191290)
		 + W(6, 1014732617, -1095872969, 1062822060, -1090088910)
		 + W(7, 1027255591, 1022596005, -1133265115, -1106126199)
		 + W(8, 1059882369, -1090037515, -1131360500, -1115075910)
		 + W(9, -1123204757, -1114430117, 1050777829, -1103091289)
		 + W(10, -1122457924, 1022253604, 1010953149, -1135381594)
		 + W(11, 1058652475, -1092699671, -1108476770, -1114779071);
	sum2 =
		W(0, 1018912922, 1027578843, 1033809184, -1094114890) + W(1, -1100264522, -1107937173, -1115513506, -1122957333)
		+ W(2, -1107632498, 1001948858, 1024979575, 996744179) + W(3, 1035927400, 1036987406, -1102289594, 1056054406)
		+ W(4, -1110397259, -1110541201, -1104590179, -1100032664)
		+ W(5, 1055409420, 1048553428, -1121465059, -1114033403) + W(6, 1040736265, -1110179624, 1055289786, 1051787669)
		+ W(7, -1147035242, 1041331760, -1107721632, -1125426330)
		+ W(8, -1112721987, -1094744691, 1045301422, -1113161109)
		+ W(9, 1025188211, -1103038285, 1036015348, 1032878358)
		+ W(10, -1131004626, -1108457170, -1112944230, 1043904940)
		+ W(11, -1110109848, -1118996080, -1124556646, 1028913131);
	WS(-1088267692, 1058858468);
	sum1 = W(0, -1112379634, 1030761249, 1050799110, -1099191401)
		 + W(1, 1033839199, -1111715307, 1029162995, 1004146884) + W(2, 1045209037, -1095201623, 981108966, 1002675052)
		 + W(3, -1140270752, -1122297718, 1060358148, -1091143388)
		 + W(4, 1043211072, -1120236170, -1141342278, 1040340278)
		 + W(5, 1057423488, -1083233902, 1032118859, -1118812007)
		 + W(6, -1155361775, 1036240851, 1058630580, -1098879351)
		 + W(7, 1032700466, 1017441470, -1113272402, -1129581456)
		 + W(8, 1044230767, -1096101987, 1030417559, -1148456452)
		 + W(9, -1140210569, 1042224566, -1104611845, -1122560784)
		 + W(10, -1140846885, -1124250818, 1015213304, 994119730)
		 + W(11, -1109863885, -1109785875, 1009738084, -1131671893);
	sum2 =
		W(0, -1113443438, 1021821461, -1122246023, -1146734500) + W(1, -1128559783, -1125128801, 1023812788, 1044300514)
		+ W(2, -1104002403, 1024116650, -1115812447, -1134793082)
		+ W(3, -1131593767, -1104994806, 1038382254, 1049088332)
		+ W(4, -1105739887, -1131329759, -1112801638, 1060658961)
		+ W(5, -1099826888, -1089766136, 1025686404, 1034755166) + W(6, -1105757720, 1044687616, 1066144433, 1042354562)
		+ W(7, -1117250635, -1114066084, -1107427633, -1087213560)
		+ W(8, 1057721748, -1129092349, 1035306954, 1031417186)
		+ W(9, -1107137147, -1093064102, -1097329958, 1044181933)
		+ W(10, -1106719387, -1117543346, 1049954034, -1093773442)
		+ W(11, 1039897892, -1105235988, 1040800736, -1128306605);
	WS(1042978478, 1051058289);
	sum1 =
		W(0, -1105382966, 1032357083, -1099095273, 1056839899) + W(1, -1122236410, 1024938700, 1035278676, 1023966158)
		+ W(2, -1110890773, 1050844654, 1019140850, -1122653091)
		+ W(3, -1102112151, -1113794846, -1087097191, 1060126757)
		+ W(4, -1107056589, -1122892351, -1102711504, 1052488610)
		+ W(5, -1081382120, 1063120271, -1150461374, -1119829084)
		+ W(6, -1113404858, 1046698475, -1086454106, 1060142827)
		+ W(7, -1103751812, 1007453138, -1111458068, 1025992701)
		+ W(8, -1097860134, 1054395618, -1120625160, -1106500335)
		+ W(9, 1038103836, 1042579843, -1105233954, 1048420817) + W(10, 1025690583, 1032216339, -1101215220, 1026938905)
		+ W(11, -1091436978, 1056719627, -1112415123, 1010325087);
	sum2 =
		W(0, 986675002, -1098687074, 995475005, -1115454695) + W(1, -1110655697, 1018060844, -1112567440, 1041166801)
		+ W(2, -1097111455, -1132868679, -1114152579, -1101427932)
		+ W(3, 1033516168, -1099338776, 1062728692, -1120015952) + W(4, 1023628514, 1045275251, -1097585273, 1019263552)
		+ W(5, 1066654492, 1054175336, -1097107880, -1098419362) + W(6, 1031672616, -1108963639, 1034345380, 1038275134)
		+ W(7, -1118909665, 1049612882, 1029453516, -1104454378)
		+ W(8, -1124466258, -1096244103, 1049130538, -1100742770)
		+ W(9, -1106591291, -1109440188, -1092068145, 1039104546)
		+ W(10, -1093717692, 1000911598, 981423732, 1024870634)
		+ W(11, 1048117247, -1119846616, 1042494451, -1140045927);
	WS(-1097071959, 1072623846);
	sum1 =
		W(0, 1026094363, 1010541764, -1087379998, 1028105114) + W(1, 1046169702, -1135291959, -1114366565, 1023927408)
		+ W(2, -1100421531, 1051865478, -1105971271, -1125008010)
		+ W(3, 1026372640, 1034504814, -1091057687, 1057630379) + W(4, 1041980470, 1012391943, -1127140609, 1038480008)
		+ W(5, -1086095524, 1064048287, -1104375598, 1011497593) + W(6, 1020533357, 1046400295, -1083615449, 1061319210)
		+ W(7, -1113258549, -1126436590, -1164090721, 1040252248)
		+ W(8, -1089701071, 1056141130, -1149976804, 1008261592)
		+ W(9, -1143600974, 1040642843, -1093225865, 1049626241)
		+ W(10, -1120849689, -1126913777, 993477434, 1032065949)
		+ W(11, -1090227881, 1047950199, 1048635489, 1026040178);
	sum2 =
		W(0, 1012042818, 1045767812, -1063490706, -1101778611) + W(1, -1112785819, 1012780879, 1021360395, -1098807230)
		+ W(2, -1081789373, -1114664520, 1033999610, 1021391529) + W(3, -1107209227, 1044720012, 1074390906, 1049922132)
		+ W(4, -1110057121, -1130294258, 1027378250, 1042281858) + W(5, 1079115935, -1094869567, 1045861970, 1031106226)
		+ W(6, -1105921842, 1016599978, 1058048856, -1118592797)
		+ W(7, 1034050759, -1122317121, 1041772128, -1127223374)
		+ W(8, -1108782236, -1121088549, -1129798306, 1025125464)
		+ W(9, -1127367716, -1115783877, -1128008216, -1137516645)
		+ W(10, 1033434514, -1149825053, -1127019644, 1027816090)
		+ W(11, 1032186898, -1111496361, -1136389257, 1031888403);
	WS(-1103312814, -1092017335);
	sum1 = W(0, -1127703091, -1101144796, 1054306333, -1126801713)
		 + W(1, 1023075088, 989243788, 1018146514, -1115460311) + W(2, 1039997174, 1026063214, 1027296474, -1122138660)
		 + W(3, -1121799134, -1106383343, 1024945271, -1131110905)
		 + W(4, -1132250026, 1032388672, 1017072510, -1133230391)
		 + W(5, -1088288960, 1059941407, -1113425894, 982272924)
		 + W(6, -1131539818, 1034901054, -1088630417, 1061737047)
		 + W(7, -1097522374, 1021266411, -1112727125, 1027622014)
		 + W(8, -1096972398, 1057455253, -1097018828, -1135487483)
		 + W(9, 1017229265, 1018005017, -1101045202, 1048616129)
		 + W(10, -1112216732, -1117699788, -1109754009, 1034197373)
		 + W(11, -1098488314, 1051714580, -1142469689, 995701513);
	sum2 = W(0, 1015133861, -1105189044, -1093732269, -1094162786)
		 + W(1, -1109540616, 1030009493, 1037113072, -1115931822)
		 + W(2, -1102686481, -1113599737, 1040400825, -1114813207)
		 + W(3, -1114822552, -1098364789, 1041653115, 1041635421)
		 + W(4, -1118060506, 1027616765, 1028491873, -1113527921)
		 + W(5, 1065997875, 1064813540, -1123044799, -1116517245)
		 + W(6, -1105557810, 1024139573, -1130473293, 1037786550)
		 + W(7, -1105450383, 1021543889, 1038591890, -1112247318)
		 + W(8, -1098512761, 1036196676, -1106060901, 1005718790)
		 + W(9, -1105949948, 1007564387, -1125828389, -1114108758)
		 + W(10, -1118151575, -1122858549, 1032708826, -1120342494)
		 + W(11, -1125733097, -1132225813, 1010062515, 1029912177);
	WS(1054094679, 1053313313);
	sum1 =
		W(0, -1133457438, -1123263126, 1046955525, -1124016519)
		+ W(1, 1039131745, -1120644986, -1120986711, -1130558777)
		+ W(2, 1034791245, 1044418743, -1102726978, 1007447622) + W(3, 1034987238, -1097984725, 1059693200, -1102062065)
		+ W(4, -1136653836, -1119688622, 1028444909, -1096198619)
		+ W(5, 1056744813, -1098120268, -1097784815, -1150742701)
		+ W(6, 1035642130, 1007426149, -1111414009, -1111514230) + W(7, -1121981368, 1028941155, 1018062863, 1002886242)
		+ W(8, 1030506913, -1104691680, 1038384226, -1124505481)
		+ W(9, 1034710931, -1123562906, -1113706235, 1011520719)
		+ W(10, -1114621003, 1028268649, -1149170946, 1018181775)
		+ W(11, 1033357311, -1107703301, 1012043028, 1016894461);
	sum2 =
		W(0, 988916677, 1035831303, -1110571087, 1034464782) + W(1, -1106828560, -1178538002, -1137939637, -1140903881)
		+ W(2, 1038296707, -1090860425, 1044389789, 1041756630)
		+ W(3, -1123566910, -1103092742, -1107155945, 1056968489)
		+ W(4, -1079651989, 1029915845, 1028209713, -1131746560)
		+ W(5, -1117714466, 1064742714, 1050942503, -1106236653)
		+ W(6, -1123858844, -1101579019, 1038803820, 1040557782) + W(7, 1043224862, -1110415601, 1036944358, 1038814302)
		+ W(8, -1103151768, -1120375726, -1130430804, 1019097405)
		+ W(9, -1119538750, -1130948272, 1032643961, -1111036663)
		+ W(10, 1041889175, -1132733633, -1142606817, 1038676356)
		+ W(11, -1111989951, -1122089622, 1014857001, -1140337549);
	WS(1060301740, -1107262085);
	sum1 = W(0, 980901136, 1034782831, -1105836176, 1036556474) + W(1, -1123655719, -1123449511, 1027361860, 1047173818)
		 + W(2, -1090641081, 1050207945, -1104237805, 1032390687)
		 + W(3, -1140723427, 1039236098, -1089836727, 1053103024)
		 + W(4, -1097134658, 1023266998, 1026764890, -1167399456)
		 + W(5, 1057068694, 1041462691, -1168491986, -1128069487)
		 + W(6, 1040866884, -1096504911, 1061579759, -1084387656)
		 + W(7, 1041789973, -1111341496, 1025665684, -1107799148)
		 + W(8, 1058017849, -1086651203, 1041962562, -1121577073)
		 + W(9, 1033047081, -1104388354, 1050545524, -1099258584)
		 + W(10, 1042093191, -1128080260, -1120424813, 1042507977)
		 + W(11, 1043225643, -1106352190, -1107448273, -1118302731);
	sum2 = W(0, -1120672932, 1046006360, -1112452525, -1103760793)
		 + W(1, -1135937657, 1037670355, 1020434122, -1097339905)
		 + W(2, 1059308780, 1054394959, 1038148088, -1114765629) + W(3, 1029602171, -1114812458, 1040180724, 1058139034)
		 + W(4, -1103543044, -1120562291, 986372169, -1107596062)
		 + W(5, -1073685765, -1075031098, -1098429000, -1131755817)
		 + W(6, 1039121856, 1036462865, 1068230783, 1055263295) + W(7, 1051067274, 1034635900, -1113202257, 1042494496)
		 + W(8, 1060720662, 1065727212, -1106499347, 1010504894)
		 + W(9, -1139183469, -1097212089, -1116372590, -1106882983)
		 + W(10, -1127997619, -1127537321, 1010867474, -1111658779)
		 + W(11, -1096232759, -1102585430, 998537328, -1141626877);
	WS(-1096709719, -1109932402);
	sum1 = W(0, 1015250582, -1143431239, 1041217222, 1009444904)
		 + W(1, -1127867147, -1115442975, -1109965037, 1015070528)
		 + W(2, 1044707911, -1099789672, 1028928427, 1033219242) + W(3, 1037158888, -1094706154, 1032459556, 1049449359)
		 + W(4, 1015515213, -1119289842, -1115453048, 1051852512)
		 + W(5, -1103734188, -1091866852, 1049692098, -1140261177)
		 + W(6, 1032345875, -1107272167, -1116721265, 1042112892)
		 + W(7, -1094357813, 1041543818, -1113173429, 1039101648)
		 + W(8, -1100636937, 1051337808, 1036490203, -1107580668) + W(9, 1033146133, -1112986991, 980311674, 1011811037)
		 + W(10, -1118660177, 1027230184, -1109546082, 1034073405)
		 + W(11, 1017051268, 1035868647, 1019523665, -1121586498);
	sum2 = W(0, -1129366500, -1111869912, -1114572049, 1047691494)
		 + W(1, 1024096486, -1112777200, 1029756683, 1029022998) + W(2, 1041454921, 1051011830, -1094989992, 1033382685)
		 + W(3, -1113040482, 1046043365, 1063827282, -1075590857)
		 + W(4, -1094007689, 1046068934, 1041050942, 1028636589) + W(5, -1088878874, 1052419847, 1049374228, 1022134325)
		 + W(6, 1019865458, -1100561355, -1120053198, 1053136256)
		 + W(7, 1051405216, -1104418826, -1130192114, -1118786886)
		 + W(8, 1037601458, -1142379802, -1105102628, 1039472389)
		 + W(9, 1021094310, -1136660469, -1121128994, -1115896886)
		 + W(10, 1030093181, -1173694926, 1011878989, -1113939693)
		 + W(11, 1024511741, 1033422229, 1038213156, -1122209396);
	WS(1065853238, 1014077745);
	sum1 =
		W(0, -1141216588, -1117433015, -1094201799, 1050233869) + W(1, 1044254087, -1138617969, 1026623353, -1129058045)
		+ W(2, -1096460535, 1049952264, 1008011942, 1022594791) + W(3, -1128763228, 1039902504, -1083943142, 1051933059)
		+ W(4, 1048823509, -1141149825, 1020370461, 1043759351) + W(5, -1077503527, 1055071872, 1025148605, 1032777398)
		+ W(6, 1026101893, 1050608829, -1089716396, 1055823041) + W(7, 1040921250, -1117303781, -1118113002, 1042454284)
		+ W(8, -1098731144, 1057515106, -1120507502, 1030831063) + W(9, 1032019108, 1027449020, -1095714819, 1050055875)
		+ W(10, -1149099066, -1131034510, -1113706417, 965645460)
		+ W(11, -1094767340, 1054942629, 1040832262, 1023411184);
	sum2 = W(0, 1024492456, -1107369605, -1114418679, -1102696165)
		 + W(1, -1133142225, -1122518916, -1126703609, 1040389587)
		 + W(2, 1038677226, -1115181151, -1114014523, 1026327736)
		 + W(3, 1029353704, -1109233879, 1043636997, -1104069114)
		 + W(4, -1122395696, 1035228514, 1036516578, -1095300447)
		 + W(5, 1063429366, 1063594124, -1091978649, 1023044321)
		 + W(6, 1032071462, -1104963978, -1101740776, -1098164193)
		 + W(7, 1053626887, -1116601496, -1107363712, -1106122650)
		 + W(8, -1097459892, 1040620147, -1097146692, -1130578705)
		 + W(9, 1044306067, -1143085570, 1035238854, -1106357294)
		 + W(10, 1040976159, 1026795860, -1105180142, 1043865859)
		 + W(11, -1116890590, -1127904241, -1120794976, -1127926993);
	WS(-1088917996, 1063906509);
	sum1 =
		W(0, -1110920777, 1044506738, 1047786311, -1095080042) + W(1, -1134941681, 1033765698, 1042151912, -1103723194)
		+ W(2, 1032125650, -1113114611, 1025189266, -1104090263)
		+ W(3, -1101936374, 1033303784, 1061302810, -1088574755) + W(4, -1115794445, 1041151454, 1005195703, 1049511025)
		+ W(5, 1034065915, -1080208865, 1048946939, -1113407178) + W(6, 1032265367, -1113286290, 1048810800, 1049193686)
		+ W(7, -1126346531, -1109067703, -1103459368, 1043019742)
		+ W(8, 1054491533, -1121283466, -1103486336, 1044875416)
		+ W(9, 1041691572, -1128222025, -1112859072, 1024774526)
		+ W(10, 1015955599, -1121559327, -1129700693, -1114181825)
		+ W(11, 1049358361, -1147499681, -1097425800, 1029016425);
	sum2 =
		W(0, -1103461552, -1127991186, -1120190757, -1108916090) + W(1, 1012492564, 1029245469, 1050674327, -1116051994)
		+ W(2, -1113530372, -1124692174, 1042343963, -1115385529)
		+ W(3, -1104590141, -1131508502, 1055990720, -1121470095) + W(4, 1032226081, 1026603353, 1015549042, 1050173609)
		+ W(5, 1072931527, 1046026095, 1048814953, 1024686773) + W(6, 1036919049, -1105608002, -1095048932, 1050729023)
		+ W(7, -1098673970, -1108452621, -1098769683, 1039941075)
		+ W(8, -1078020039, -1084802111, -1101605152, 1046452703)
		+ W(9, 1046313441, -1101603735, -1101033642, 1047911325)
		+ W(10, -1113534935, -1112756717, -1112862464, 1031505597)
		+ W(11, 1010804308, 1034713295, 1017021378, -1119772659);
	WS(-1128039792, 1065254279);
	sum1 = W(0, 949814928, -1114341117, -1094482850, 1052398616) + W(1, 1027872723, -1155305313, 1027171091, 1031806764)
		 + W(2, -1095186291, 1051880795, -1139824782, 1022544667)
		 + W(3, -1129242384, 1033646238, -1085842430, 1058904806)
		 + W(4, 1010706555, -1121892394, 1031101353, 1018879791)
		 + W(5, -1092086861, 1068407459, -1098849364, 1040052675)
		 + W(6, -1120975327, 1042055949, -1084252337, 1055432619)
		 + W(7, -1121195299, -1127339326, 1003634843, 1033681236) + W(8, -1089087466, 1036562814, 1023772639, 993927654)
		 + W(9, -1144006416, 1023909046, -1099056317, 1039311896)
		 + W(10, -1126801378, -1123991661, -1123053628, 1027677731)
		 + W(11, -1095496311, 1050962337, 1038931216, 1005742098);
	sum2 =
		W(0, -1120833032, -1124763415, -1118777010, 1030229073) + W(1, 1028911958, -1123843510, 1034915193, -1113475142)
		+ W(2, 1010824003, -1105412742, -1133618203, 1030755234) + W(3, -1115307960, 1025322201, 1064953874, 1042572184)
		+ W(4, 1022077590, -1135426163, 967112657, 1059271888) + W(5, 1082807588, -1098383492, 1048790378, -1113939962)
		+ W(6, 1023925021, -1102912552, -1080316189, 1054443836)
		+ W(7, -1103923621, 1038571089, -1107476032, -1118552210)
		+ W(8, -1064631277, -1098098835, 1029953956, -1109596012)
		+ W(9, 1033449936, -1103660545, -1110193476, -1121091158)
		+ W(10, -1106218101, 1035405992, -1132191993, 1033898849)
		+ W(11, 1039205719, 1028111985, 1036034024, -1126376787);
	WS(-1100484014, -1082813103);
	sum1 =
		W(0, -1123138350, 1037916588, -1092840871, 1048819422) + W(1, 1042234192, -1212876940, -1124738939, -1123209507)
		+ W(2, -1095165544, 1053647432, -1117914254, 1018206961) + W(3, 991988525, 1049386547, -1086369653, 1054472273)
		+ W(4, 1039202605, -1120915541, -1115403050, 1038702225)
		+ W(5, -1082690349, 1063735148, -1121098737, 1024686130) + W(6, 1032429349, 1052139678, -1080932794, 1057734851)
		+ W(7, -1124146173, 1015928020, -1113715255, -1114440425)
		+ W(8, -1104541586, 1057909982, -1120991811, -1138122766)
		+ W(9, 1024280877, 1033284897, -1091044852, 1048946363)
		+ W(10, -1116174764, 1018911880, 1024090791, -1105213156)
		+ W(11, -1098590565, 1057027323, -1140316975, 1023234987);
	sum2 =
		W(0, 1017320792, -1151813795, -1114719136, -1127138406) + W(1, 1024237362, 1038691322, -1115193567, -1117132961)
		+ W(2, -1104426322, 1035777956, -1122656452, -1114810881)
		+ W(3, 1033153774, 1023133248, -1094043595, 1044557822)
		+ W(4, 1043828952, -1134215421, -1109723345, -1096979800)
		+ W(5, -1067432541, -1081748159, -1105451925, 1025666138)
		+ W(6, 1038092476, 1051436512, -1094705611, -1094662263)
		+ W(7, -1118217110, 1023161212, -1111785287, -1136600857)
		+ W(8, 1084038773, 1059186895, -1118750811, -1141123106) + W(9, -1119671739, 1043953938, 1051561136, 1023890070)
		+ W(10, 1026839182, 1009024009, -1109901657, 1038440342)
		+ W(11, -1097692319, 1021470996, -1114305884, -1122422926);
	WS(-1090600151, 1059961608);
	sum1 =
		W(0, 1026132748, 1003856660, -1086859502, 1051724689) + W(1, 1051693682, 1032934656, -1119499740, 1023957057)
		+ W(2, -1105095800, 1035359281, 1030063117, -1123043606) + W(3, 1009974340, 1043713207, -1089372619, 1059175635)
		+ W(4, 1040699442, 1034542394, -1113885561, 977342510) + W(5, -1080432315, 1059908410, -1106762114, 1018557983)
		+ W(6, 1031101992, 1051525550, -1084623068, 1060487798) + W(7, -1114853678, 1019132432, -1111559238, 1025363409)
		+ W(8, -1086083942, 1059822844, -1116041416, 1031213982) + W(9, 1038517558, 1031878320, -1090836983, 1051599439)
		+ W(10, -1130086580, -1150140386, -1109274083, -1114083846)
		+ W(11, -1097114792, 1057278953, 1040974422, -1138998830);
	sum2 =
		W(0, 992923986, -1099561897, -1105536701, 1079165891) + W(1, -1067147152, -1122782084, -1162949315, -1123994385)
		+ W(2, -1114799541, 1071631223, -1073660425, -1122543983)
		+ W(3, 1026898877, -1116860796, 1049791100, 1068780303)
		+ W(4, -1081838471, -1095462698, -1114052913, 1033030662)
		+ W(5, 1035377948, 1075632919, -1083671230, -1097530520)
		+ W(6, -1129262506, 1024241717, -1088177074, -1093777203)
		+ W(7, 1057542893, -1107750254, 1033577774, 1027801571) + W(8, 1049717575, -1083766160, 1057183721, 1032284006)
		+ W(9, -1129225578, 1041458479, 1043978030, 1029517847) + W(10, -1103299573, 1025982179, 1036380420, 1050404867)
		+ W(11, -1091169113, -1083354335, 1061807320, 1016984746);
	WS(-1077101366, 1062204989);
	sum1 =
		W(0, 1030791972, 1034919675, -1119759728, -1099266697) + W(1, 1044609922, -1131275309, 1033145401, -1109323772)
		+ W(2, 1033209467, 1032826652, -1108657922, -1142019948)
		+ W(3, 1041963978, -1109601924, 1053457281, -1084468746) + W(4, 1049423472, 1005679697, 974201395, -1098302775)
		+ W(5, 1054965265, -1116769210, 1034832195, -1125973710)
		+ W(6, -1122207423, 1049858413, -1085314770, 1055247733) + W(7, -1104833109, 1038354000, 987140211, -1163737350)
		+ W(8, -1111164798, 1051122507, -1113738245, 1030630601)
		+ W(9, 1038549201, -1104961646, -1103072597, 1043488164)
		+ W(10, -1121147841, -1132893044, -1110991006, 1022472166)
		+ W(11, -1115893275, 1036206931, -1131086146, 1033991117);
	sum2 =
		W(0, -1128313262, 1013333880, 1041733323, 1023499747) + W(1, -1111312052, 1026149469, -1111995834, 1035550861)
		+ W(2, 1024909109, -1107108555, 1015145454, -1188980193) + W(3, -1111474816, 1047569009, 1049082846, 1042800306)
		+ W(4, 1017141780, -1123639612, -1108547758, 1036006103)
		+ W(5, -1093864056, -1137016284, 1013541080, -1132476264)
		+ W(6, -1123519406, -1104835579, 1049905793, 1032249988) + W(7, 1034012446, 987971164, -1107039325, -1119199538)
		+ W(8, 1005924363, -1146750815, -1119513572, -1118671040)
		+ W(9, -1122872424, -1113807123, -1107099901, 1024429363)
		+ W(10, 1036805530, -1119021692, 1034342977, -1111926114)
		+ W(11, -1117079308, 1029021112, 1021769214, 1010774610);
	WS(1062330988, -1108933484);
	sum1 = W(0, -1130422235, -1127744279, -1103583502, -1112967222)
		 + W(1, 1030687296, 1027221408, 1014897395, 1022571909) + W(2, -1095189640, 1057599524, 1033146447, -1115561596)
		 + W(3, 1027643186, -1103670303, -1097916197, 1050533350)
		 + W(4, 1045948242, 1024802772, -1143835797, -1110385841)
		 + W(5, -1083565633, 1066390108, -1104991248, 1027456689)
		 + W(6, 1008148004, 1042533684, -1085814590, 1059916677)
		 + W(7, -1098839314, -1125614226, -1128962907, -1104774725)
		 + W(8, -1117452294, 1050496965, -1114792086, 1027191883)
		 + W(9, 1015454424, -1116892960, -1099231943, 1049304867)
		 + W(10, -1127702342, -1115468561, -1140840472, -1113171223)
		 + W(11, -1103031657, 1049771574, 1032045679, 1026854932);
	sum2 =
		W(0, 1032895988, 1032830726, -1115406541, -1088204952) + W(1, -1092446016, 1031989945, -1117467777, -1111744013)
		+ W(2, 1060942494, 1054289941, -1123665301, -1104702594) + W(3, 1028545567, 1005059811, 1047355779, 1071613570)
		+ W(4, 1060958044, 1046230999, -1111764526, 984631841) + W(5, -1080183554, -1077634808, 1046926373, -1100189171)
		+ W(6, 1041090350, 1049595248, -1134532596, -1093147012)
		+ W(7, -1113920155, 1034621337, -1115412116, -1107906030)
		+ W(8, 1035977506, 1042083474, -1097187857, -1132922134)
		+ W(9, -1125773241, -1128022386, 1020817981, 1037668146)
		+ W(10, -1142970826, -1117116166, 1023304410, 1041765137)
		+ W(11, 998580490, 1032116542, -1125184917, 1022449461);
	WS(-1109331804, 1042368707);
	sum1 =
		W(0, -1127022377, 1017844485, 1059385318, -1100795701) + W(1, -1111987554, 1016900750, 1024616740, -1131144083)
		+ W(2, 1050963589, -1097056965, 1029893237, 1023074109)
		+ W(3, -1123466393, -1107976561, 1060165431, -1085607547)
		+ W(4, 1029216560, -1112887422, -1123208698, -1113085828) + W(5, 1059271336, -1083778221, 1039937652, 998408382)
		+ W(6, -1123129456, -1114039899, 1060839292, -1087428756)
		+ W(7, 1032072458, -1132276000, 1019270569, -1111910285)
		+ W(8, 1056907678, -1094957746, -1114977786, 1030127674) + W(9, 981412042, -1118232839, 1049849056, -1097540376)
		+ W(10, 1024925794, 1027413302, -1140654132, 1022571624)
		+ W(11, 1053487153, -1103251894, -1099334072, 1016237783);
	sum2 =
		W(0, 1032849952, 1026055449, -1062565523, -1095655110) + W(1, -1117249787, 1033345650, -1124884727, -1115329827)
		+ W(2, -1069645041, 1045607629, -1117682124, -1126204236)
		+ W(3, -1113876395, 1027815845, 1071954840, 1038549538) + W(4, 1041120073, -1111681252, -1129227720, 1037903820)
		+ W(5, 1082661778, -1099195860, 1049745271, 1027383795) + W(6, -1120368220, 1033732250, 1074466947, 1038448988)
		+ W(7, -1117133911, 1003632367, 1017198470, -1135699996)
		+ W(8, 1029601901, -1098438651, 1028175479, -1122462785) + W(9, -1139825528, 999495607, 1010255452, -1108984513)
		+ W(10, 1021673198, 1028818665, -1146042855, -1129930944)
		+ W(11, 1032971494, 1036170224, -1119888169, 1008778484);
	WS(-1115348316, 1054745777);
	sum1 =
		W(0, -1137232980, 1036166838, 1049991788, -1091675395) + W(1, 1017816583, 1029575560, 1010567825, 1015838740)
		+ W(2, 1049110157, -1096298109, 1034100235, 1027659359) + W(3, 1027515738, -1156212270, 1058008076, -1087264777)
		+ W(4, 1034455816, 1022248439, -1129778165, -1111605669) + W(5, 1064241460, -1084812083, 1015442096, 1022178737)
		+ W(6, 1031078129, -1105267814, 1060214194, -1090012802)
		+ W(7, 1038960299, 1027280241, -1163675813, -1129353779) + W(8, 1054590870, -1089909917, 1024747424, 1032358751)
		+ W(9, 1021335208, -1109102196, 1041116785, -1099321920)
		+ W(10, -1128935590, -1140454872, 1015357019, 1044530957)
		+ W(11, 1051902330, -1087098097, 1001621141, 1023518060);
	sum2 =
		W(0, -1165172934, 1029679520, -1126280148, -1133513625) + W(1, 1007295249, -1112190701, 1024206556, 1020162972)
		+ W(2, -1122180110, 1032751166, -1123729058, 1031911051) + W(3, -1116697030, 1034059275, 997668227, 1058808820)
		+ W(4, -1106696521, -1130859572, 1027518769, 1040171419)
		+ W(5, -1097026624, 1078058683, 1051253388, -1110596693) + W(6, -1114129087, 1027996817, 1034726751, 1074823993)
		+ W(7, -1129919188, 1030310076, 1038375004, -1110434123)
		+ W(8, 1040744343, -1082346775, -1130957332, 1020514684)
		+ W(9, -1112102389, 1034335827, -1102815825, -1066028315)
		+ W(10, -1106067749, -1120038362, 1033334280, -1129105068)
		+ W(11, -1107441727, -1081349721, 1046963831, -1140190249);
	WS(-1106429870, -1094013011);
	sum1 =
		W(0, -1180060253, 1032914805, 1051659804, -1083977393) + W(1, 1044666432, -1143253052, 1010730896, -1122572746)
		+ W(2, 1041447962, -1096070845, 1042077981, -1112889935) + W(3, 1021824818, 1007289698, 1049003466, -1090427610)
		+ W(4, 1040702780, 1019043703, -1126648308, 1032028260) + W(5, 1055000463, -1110426966, 1039434940, -1121648024)
		+ W(6, -1129917792, 1028442598, 1028832887, -1154202266)
		+ W(7, -1143541158, -1121855216, -1130361130, 1044381070)
		+ W(8, -1108621431, 1047276227, -1126798128, 1025638626)
		+ W(9, -1120274467, 997655159, -1127588999, -1106909952)
		+ W(10, 1034262401, -1112957869, -1140710069, 1048974915)
		+ W(11, -1092428073, 1037115308, -1116914978, 1027653084);
	sum2 = W(0, -1113021585, 1044056205, -1096040530, -1099894114)
		 + W(1, -1101136816, -1129192316, 1027309129, 1042644451)
		 + W(2, -1098848264, -1100852865, 1051352325, -1127314210)
		 + W(3, 1040557912, -1130917417, -1086782093, 1055980834)
		 + W(4, -1094431966, 1001033976, -1105312463, -1097839840)
		 + W(5, 1066533545, 1060955207, -1105883820, 1028457481) + W(6, 1045635393, -1093830389, 1047866369, 1049480207)
		 + W(7, -1100511063, -1109915970, -1102513438, -1101732547)
		 + W(8, 1049511378, -1136131482, -1095199310, 1041484506)
		 + W(9, 1027399099, -1116545436, 1054444603, -1099150452)
		 + W(10, 1057783348, -1111537389, -1114789238, 1035602021)
		 + W(11, 1045074348, -1089010378, -1105061215, 1038428609);
	WS(1043891118, 1068855714);
	sum1 = W(0, 1034864935, -1116934668, -1092449819, 1054927906)
		 + W(1, 1034556804, -1137767170, -1115119790, -1132968331)
		 + W(2, -1094480060, 1036212657, -1105343195, -1110944332)
		 + W(3, 1021640868, 1038582262, -1087769325, 1059302628) + W(4, 1039390277, 1007166673, -1116826163, 1007221512)
		 + W(5, -1085866861, 1065404307, -1118670257, 1000130184)
		 + W(6, -1131811026, 1042862352, -1087019235, 1060871017)
		 + W(7, -1097654326, -1149095244, 1023733166, 1036137865)
		 + W(8, -1090795981, 1058788692, -1110180471, 1038210141)
		 + W(9, -1143217636, -1140157826, -1096174840, 1054585007)
		 + W(10, -1103987387, -1123846591, -1132040205, -1132089051)
		 + W(11, -1088777568, 1058320673, 1039274926, 1033742658);
	sum2 =
		W(0, -1109312558, 1043524956, -1128190925, -1098627702) + W(1, 1046310591, -1109532722, 1016877071, 1022447527)
		+ W(2, -1112207078, -1106898612, 1038513036, 1007593597)
		+ W(3, -1119267190, 1041115214, -1098728904, -1125515089)
		+ W(4, 1034661588, -1120394532, 1012463989, -1113751024)
		+ W(5, -1096567460, 1069702771, -1085518745, -1104054586)
		+ W(6, -1126846961, 1044302697, -1103900959, 1067943590)
		+ W(7, -1080776989, -1120974914, -1130793473, 1017381631)
		+ W(8, 1042180588, 1068665203, -1076263106, 1042247803) + W(9, 1028514185, -1118188819, -1098746809, 1066385707)
		+ W(10, -1082060374, 1009589981, 987754923, 1030898373)
		+ W(11, 1045698067, 1053793920, -1093259035, -1114854661);
	WS(-1087649964, 1019782291);
	sum1 =
		W(0, -1120416323, 1030168161, 1040415828, -1105270513) + W(1, 1024428446, -1138699736, -1143853715, -1112895868)
		+ W(2, 1040272853, 1031966316, -1115504066, -1138905653) + W(3, 997344379, 1041161399, -1108639376, -1088122706)
		+ W(4, 1050439898, 986611002, -1117444008, -1109107148)
		+ W(5, 1066099001, -1107599501, -1101667648, -1107645603)
		+ W(6, 1021907901, 1047711365, 1016783474, -1089416651) + W(7, 1046888529, 998160367, -1121005123, -1121138472)
		+ W(8, 1034911086, -1111272734, 1033038819, -1138080961) + W(9, 1024251314, 1000308143, 1025062450, -1107120316)
		+ W(10, -1142414472, 1016114481, -1131127160, 1016698342)
		+ W(11, 1039033917, -1102333873, 1024070769, -1128756052);
	sum2 = W(0, -1107127477, 1040784536, -1117663793, -1112675945)
		 + W(1, 1039537683, 1025325994, 1033768126, -1100939724) + W(2, 1017594321, 1057262150, -1092150404, 1019337948)
		 + W(3, 1023416069, -1105075327, -1107862291, -1072566694)
		 + W(4, 1066290117, -1099590626, -1125558334, 1031863699)
		 + W(5, -1098589794, 1078638992, -1077578123, 1051733383)
		 + W(6, 1043030557, -1103416126, 1051532765, -1086195181)
		 + W(7, 1053259006, -1119314417, -1118774605, -1104742149)
		 + W(8, 1047503953, -1109470897, 1050584179, -1100419866)
		 + W(9, -1151915405, 1042707477, -1106456825, 1041105499)
		 + W(10, -1103867215, 1038050610, 1000627574, -1121719211)
		 + W(11, 1014542959, -1106760943, 1033290657, 1002291590);
	WS(1061891500, 1029739432);
	sum1 = W(0, -1120639769, -1106216192, -1113834067, 1044238166)
		 + W(1, -1114217922, -1131739160, -1135804195, 1006283635)
		 + W(2, -1103570763, 991333090, -1139025510, -1118882723)
		 + W(3, -1111424495, -1105829118, -1096510251, 1059958553)
		 + W(4, -1105864021, -1144807936, 1029738303, -1090566706)
		 + W(5, 1051808376, 1070740438, -1094764771, 1034612526)
		 + W(6, -1117498485, -1116262763, -1092264601, 1055146526)
		 + W(7, -1102695282, -1134494805, -1118615961, 1034396863)
		 + W(8, -1100309453, 1034609097, -1115698885, 1017541191)
		 + W(9, -1125527056, 1019261400, -1103214946, 1035571491)
		 + W(10, -1137185181, -1114134173, -1118385394, -1120846617)
		 + W(11, -1103884676, 1043753671, -1118241703, 1003240643);
	sum2 = W(0, -1121600381, 1026550907, 1038640235, -1118247849)
		 + W(1, -1129506938, -1121040584, 1006302792, -1138054916)
		 + W(2, -1115693397, 1032667651, -1150824496, 1022873234)
		 + W(3, -1119262688, 1026195583, 1049140618, -1131891756)
		 + W(4, 1032667233, -1116879102, 1002488024, -1109251816)
		 + W(5, -1070322023, 1075955836, 1037796079, -1123674716) + W(6, 1029037035, 989985520, 1050244555, -1093462820)
		 + W(7, 1041966968, 1023067742, 1026568605, -1119850715)
		 + W(8, -1111337441, 1039467523, -1119306593, -1115823182)
		 + W(9, -1136033516, 1023268674, 1034795019, -1123631905)
		 + W(10, 1011205316, 1030765775, 1023468893, -1113487368)
		 + W(11, 1032357843, -1111383976, -1140765060, -1117038411);
	WS(-1084563692, -1094583093);
	sum1 =
		W(0, 1022703229, 1012279186, 1016172182, -1118740542) + W(1, 1030161881, -1118949361, -1162852794, -1124105959)
		+ W(2, 1043937588, 1029178707, -1113029519, 1029291849) + W(3, -1132568844, 1040618577, -1096721723, 1047241030)
		+ W(4, -1110742685, 1002005802, 1021772616, -1104495965) + W(5, 975997096, 1058138797, -1095587800, 1026228226)
		+ W(6, 1024085850, -1108936808, -1105257082, -1098942649)
		+ W(7, 1044167852, -1121437018, 996545514, -1134036365) + W(8, -1119752408, 1033384955, 1030217107, -1128298663)
		+ W(9, 1026223997, -1117471057, 1035927703, -1119041259)
		+ W(10, 1033396614, -1127843472, -1146052282, -1121618798)
		+ W(11, 1030206390, -1135741956, -1114495566, 1024441958);
	sum2 = W(0, 1025430445, -1154040649, -1116838887, 1050769250)
		 + W(1, -1101164186, 1025324860, 1022296570, 1041313314)
		 + W(2, -1089338077, -1110563158, 1049390351, -1110459458)
		 + W(3, 1036981025, -1095051054, -1080092115, 1047738904)
		 + W(4, -1105225557, -1123670947, -1113204042, 1045521896)
		 + W(5, 1068042633, -1105725339, 1058198082, -1102419914)
		 + W(6, 1015494893, -1140159290, -1123762249, 1046459196)
		 + W(7, -1097909404, 1036400862, -1113488118, 1036274902)
		 + W(8, 1036460009, -1099991734, 1042800199, -1121611661)
		 + W(9, -1127432409, 1033705522, -1115504399, 1035671600)
		 + W(10, -1112380024, 1029427990, -1122316989, 1014652738)
		 + W(11, 1034428960, -1109634740, 1019626217, -1122111247);
	WS(1070570422, -1118483066);
	sum1 =
		W(0, 1018165832, -1110069429, -1099959964, 1060331110) + W(1, -1162935118, -1139421786, -1132852684, 1031499417)
		+ W(2, -1099020957, 1050128623, 1032275410, 1009522871) + W(3, -1139725729, 1040072889, -1084885570, 1059366093)
		+ W(4, 1019497086, -1140197674, -1109730565, 1042906054) + W(5, -1081528768, 1062372980, 996066926, -1117746023)
		+ W(6, 1028156415, 1042919301, -1083523477, 1058454089)
		+ W(7, -1118811556, -1128372287, -1118139972, -1168228894)
		+ W(8, -1091258848, 1058887102, -1112630512, 1014662756) + W(9, 1024357779, 1039947243, -1095225642, 1048717802)
		+ W(10, -1117991970, -1119179525, -1122455036, -1103975241)
		+ W(11, -1094692227, 1057283318, 998336395, 1028666043);
	sum2 =
		W(0, 1041833519, -1105638218, -1090712556, -1068172350) + W(1, 1053466473, 1031038629, -1108615966, 1028972955)
		+ W(2, 1051586707, -1062545743, -1089644697, -1109024185)
		+ W(3, -1125372171, 1029956673, 1040982790, 1058445980) + W(4, 1044082250, -1115541422, -1161988394, 1048735800)
		+ W(5, -1113315600, 1081890452, 1021891615, -1110157560) + W(6, -1113215633, 1034458457, 1025381303, 1078990875)
		+ W(7, 1047100697, 1034093689, 1034531971, 1025753183) + W(8, -1116357686, 1057946443, -1138523317, -1121128958)
		+ W(9, -1118383435, 1036634769, -1096961046, -1129266047)
		+ W(10, -1118643722, -1164400298, 1028261725, 1000882603)
		+ W(11, 1047278155, 1020805991, 1003167691, 1023430939);
	WS(-1086946092, 1067745931);
	sum1 =
		W(0, -1129718754, 1043160110, 1057051220, -1086793423) + W(1, 1029510552, 1019782728, 1029399808, -1107060738)
		+ W(2, 1052187432, -1093519641, 1041235060, 1028876859) + W(3, 1034551451, 1035261538, 1056679450, -1086890615)
		+ W(4, 1027399596, -1121687640, 1031195606, -1095383669)
		+ W(5, 1065908691, -1082115172, 1028581668, -1151056709)
		+ W(6, 1040134022, -1133919947, 1053194351, -1091092163) + W(7, 1039541441, 985161115, 1033121193, -1122710934)
		+ W(8, 1055695833, -1087806651, 1022886169, 1032179179) + W(9, 1023151712, -1107305618, 1050664148, -1106762967)
		+ W(10, 1035840335, -1137650955, 1042343314, 1042006276)
		+ W(11, 1051480109, -1086763775, -1123269599, 1023858088);
	sum2 =
		W(0, -1092038506, 1049598436, 1043882093, 1042320103) + W(1, -1131832297, -1121740952, -1100127293, 1048639033)
		+ W(2, 1037661877, -1103044471, 1002123811, 1029198842) + W(3, -1076970891, 1064718435, 1059313512, 1034035103)
		+ W(4, -1103733932, -1115216799, -1074419095, 1072396257)
		+ W(5, 1057486689, -1104719409, 1041582287, 1010136401) + W(6, -1072137471, 1071503744, 1051417643, -1111075093)
		+ W(7, -1115120295, -1128000009, -1071882845, 1074270589)
		+ W(8, 1058040444, 1044428409, -1139439905, 1024386386) + W(9, -1075499422, 1071966648, 1034550731, -1105998171)
		+ W(10, 1008560441, -1120184167, -1077760287, 1067893220)
		+ W(11, -1109701446, 1040427981, -1112073274, 1030441594);
	WS(-1081254198, -1103496580);
	sum1 = W(0, -1115414444, -1146587219, -1093427101, 1048836291)
		 + W(1, 1038644661, 1040942563, 1041339642, -1098606506)
		 + W(2, -1097683981, 1057498447, -1144521152, -1102869832)
		 + W(3, -1098407452, 1050459360, -1091994231, 1058816906)
		 + W(4, -1117884339, 1036627839, -1130637434, 1042214179)
		 + W(5, -1078168847, 1061921355, 1040740783, -1165859686)
		 + W(6, 1020760807, -1117423418, -1095228700, 1063391143)
		 + W(7, -1099277734, -1107645994, -1101995566, 1034598934)
		 + W(8, -1092752622, 1049596874, -1125383814, 1047950513)
		 + W(9, 1047565230, -1122745995, -1097351785, 1055225025)
		 + W(10, -1125503451, -1104517417, -1100079212, 1024450296)
		 + W(11, -1094816186, 1057483350, -1112883619, 1038686359);
	sum2 =
		W(0, -1101463653, 1057761413, -1092703936, -1109493923) + W(1, 1041760680, 1014720459, 1049429767, 1067192921)
		+ W(2, -1078098525, -1139460835, 1028945771, -1117756514)
		+ W(3, -1128244554, 1075421514, -1071536845, 1039603395)
		+ W(4, -1114414573, 1016362862, -1113723320, 1075836777)
		+ W(5, -1077415283, -1087182285, 1045554670, -1118637934)
		+ W(6, -1100253783, -1088665878, 1059548308, 1034610843)
		+ W(7, -1106673179, -1125369728, -1100739127, 1016894214)
		+ W(8, 1051692516, -1117875445, 1032645955, 1027339291) + W(9, 1041910404, -1116933337, -1101242161, 1013931579)
		+ W(10, -1122014712, 1013909643, -1105778187, -1111337535)
		+ W(11, 1048285068, 1038460759, -1113595007, -1124961818);
	WS(-1089093868, 1047195432);
	sum1 = W(0, -1139038025, -1108646892, 1042227448, -1116853265)
		 + W(1, 1032512066, 1015754506, -1146634508, -1102493258)
		 + W(2, 1050027260, -1113152371, 1037772585, -1111624526)
		 + W(3, -1107247574, -1102675263, 1055627170, -1102292967)
		 + W(4, 1040310103, -1122052409, -1111039036, 1027299238)
		 + W(5, -1094097439, 1059178599, -1120135685, -1123630421)
		 + W(6, -1111569431, 1043334313, -1086063146, 1064850945)
		 + W(7, -1097054397, 1035574535, -1131070116, 1035038251)
		 + W(8, -1091453053, 1055758905, -1107670363, -1126001639)
		 + W(9, -1123633457, -1130835530, -1104540112, 1047069456)
		 + W(10, -1109953256, 1015067608, -1125658710, 1006218639)
		 + W(11, -1100496626, 1028822677, 1033685440, 906381938);
	sum2 = W(0, -1103632983, 1051248459, 1050224986, -1112111441)
		 + W(1, -1114055425, -1111599379, 1043805370, -1102825598)
		 + W(2, -1106748849, -1107415409, -1113209339, 1037386114)
		 + W(3, -1100282419, -1110573499, -1142028319, 1047715488)
		 + W(4, -1106125891, -1107474855, 1043204826, 1027245233) + W(5, 1068200484, 1064575785, 1034756297, 1042201726)
		 + W(6, -1107284068, -1115422824, -1110893073, -1116519441)
		 + W(7, -1121811913, -1115818225, 1032596944, -1088944566)
		 + W(8, -1082511144, -1166081973, 1036646608, 1036836551)
		 + W(9, -1115324019, -1119815045, -1101546175, 1033478296)
		 + W(10, -1139772871, -1107371535, 1038389706, -1103855212)
		 + W(11, -1099926119, -1112155627, 1042197713, 1026011708);
	WS(-1121781432, -1075996235);
	sum1 =
		W(0, -1139185884, -1104344139, 1055178280, 1023675446) + W(1, -1115352921, -1116105386, 1017932812, -1106763371)
		+ W(2, 1050633065, -1102467779, -1113788396, -1134059780)
		+ W(3, 1031934942, -1097501556, 1061458986, -1098857564) + W(4, 987917899, -1113912527, 986151814, -1122902443)
		+ W(5, 1056941803, -1087567683, 1038547421, -1136836585)
		+ W(6, -1164665422, -1153685131, 1057254916, -1091469811)
		+ W(7, -1108760371, 1007170123, 1000199096, -1127990679)
		+ W(8, 1045616484, -1104204108, 1011665321, -1128021832) + W(9, 1007298263, 1001735501, 1030315686, -1129857478)
		+ W(10, -1121847517, -1154396360, -1140438078, -1113474827)
		+ W(11, 1046908556, -1103515070, -1118109260, -1121041198);
	sum2 =
		W(0, -1168649543, -1097479461, 1049098480, 1042706476) + W(1, 1041988609, -1106980555, -1129109975, -1104465921)
		+ W(2, 1049155382, -1102354715, -1112820525, -1122042062)
		+ W(3, 1016893178, -1103938775, 1057022497, 1043506300)
		+ W(4, 1047765539, -1105649317, -1132018102, -1118749694)
		+ W(5, -1098731951, -1097087336, 1046909100, 1031531696)
		+ W(6, -1117453381, -1115486085, -1119719509, 1057524747)
		+ W(7, -1100642605, -1114531186, 1023462612, 976518647) + W(8, -1106384437, 1036026738, -1121071990, 1040948740)
		+ W(9, -1106957470, 1025546665, -1098317799, 1045328977)
		+ W(10, -1106523641, -1113359258, -1115823387, 1034975399)
		+ W(11, -1105263623, 1035074429, 1003192501, 1033488186);
	WS(1058868844, 1053114578);
	sum1 =
		W(0, 1019520880, 1047026923, 1040716289, -1095841007) + W(1, 1020793813, 1026453035, -1122446279, -1120049453)
		+ W(2, 1048040834, -1093651986, 1039005404, -1117418946) + W(3, 1037061470, 994701546, 1059285152, -1089525095)
		+ W(4, 1046415125, 1019785277, 1025396381, -1104790763) + W(5, 1063349990, -1081113852, 1040363303, -1114838686)
		+ W(6, 1029402067, -1104820950, 1062179110, -1086213616) + W(7, 1045703966, 1030676884, 1031841884, 1021084025)
		+ W(8, 1056787146, -1087503095, 1041196477, 1024749253)
		+ W(9, -1120186199, -1105237507, 1046529242, -1091401861) + W(10, 999605293, 1004229292, 1033549944, 1009185118)
		+ W(11, 1057448647, -1088312360, 1036113571, 1022861598);
	sum2 =
		W(0, 1050427341, -1089070569, 1053219089, 1067490860) + W(1, -1080930470, 1058659628, -1106859908, -1111523090)
		+ W(2, 1052246278, -1093125710, -1078811541, 1066232343) + W(3, 1035861035, 1043538575, 1059060280, -1078649576)
		+ W(4, -1074777053, 1073277874, -1112488680, -1097196972)
		+ W(5, -1088179143, -1087268097, -1075643449, 1065823003) + W(6, 1032409135, 1036654054, 1017346040, 1059384755)
		+ W(7, -1124572738, 1062269032, -1122621450, -1133854060) + W(8, 1043005089, 1062938540, 1049929252, 1043425453)
		+ W(9, -1104767713, -1130574088, -1092034159, -1093321870)
		+ W(10, -1112625720, -1092663388, 1046587865, -1093068011)
		+ W(11, 1052143300, 1059539225, 1059287102, -1098215774);
	WS(-1074642550, 1059001037);
	sum1 =
		W(0, 1033877849, -1105864948, 1040506928, -1096349630) + W(1, 1046552293, -1110243859, -1114814273, -1133959838)
		+ W(2, -1108476642, 1023714759, -1108357401, -1127057913)
		+ W(3, 1017602926, -1106724665, -1098100854, 1055335876)
		+ W(4, 1032280783, -1147216585, -1122785432, 1042832010)
		+ W(5, -1084427489, 1065396984, -1132282059, 1033899323)
		+ W(6, -1119942606, 1046400581, -1083890617, 1062559324)
		+ W(7, -1113686945, 1032718711, -1121541554, 1036804396)
		+ W(8, -1088670813, 1061684023, -1104721044, 1025273824) + W(9, 1004629641, 1032924291, -1090515058, 1051195620)
		+ W(10, -1110306392, -1122497752, -1103073299, 1039804561)
		+ W(11, -1095458045, 1054342111, 1031943308, -1121848889);
	sum2 =
		W(0, 1024273115, 1021686194, 1043888107, -1108335658) + W(1, -1077891718, -1110849641, -1131612410, 1025348247)
		+ W(2, -1101286924, -1122239076, -1091711743, -1111108183)
		+ W(3, -1107407950, -1105777061, 1048538591, 1046097166) + W(4, -1097181377, 1033944270, 1041256788, 1042238427)
		+ W(5, -1090332406, 1036931728, 1065426853, -1111979954)
		+ W(6, -1117121277, -1126779625, 1053208564, 1040874893) + W(7, 1063431633, 1039617071, 1031505312, -1118046720)
		+ W(8, 1043322093, 1040745205, 1040529954, -1105370761)
		+ W(9, -1110072407, -1118330488, -1135252559, 1050743072)
		+ W(10, -1097546746, -1122096807, 1016793154, 1027338756)
		+ W(11, -1116082242, -1096125238, 1050690616, -1122718137);
	WS(-1088674604, -1128666815);
	sum1 =
		W(0, -1123914807, -1112902532, 1031043843, 1051063687) + W(1, -1094561666, 1018478931, 1016031116, -1154837176)
		+ W(2, 1033184452, -1131397783, 1025159063, -1134237698) + W(3, 1014718188, -1114821559, 1015481863, 1027540319)
		+ W(4, -1102063788, 1024172061, 1024027612, -1098901213)
		+ W(5, 1054517603, -1102428675, -1104802482, -1126359028)
		+ W(6, -1145356432, -1103324234, 1051928805, -1094753613)
		+ W(7, 1021380397, -1133861065, 1024193015, -1099251759)
		+ W(8, 1059978813, -1100081596, -1111732847, -1114031158)
		+ W(9, -1124389866, -1119376425, 1047372601, -1110958225)
		+ W(10, -1154253637, 1028470484, 1032770888, -1101826270)
		+ W(11, 1062901239, -1101878062, -1113334654, -1114369951);
	sum2 =
		W(0, -1125911137, -1108931889, 1017628143, 1050970701) + W(1, 1035307535, -1132880011, 1012595671, -1114639139)
		+ W(2, 1032292317, -1128469007, -1112594616, 1026392505) + W(3, 999266341, 1007405169, -1114156858, -1110785518)
		+ W(4, 1028698628, -1126668834, 1044288444, -1110292957)
		+ W(5, -1067836662, -1074929312, -1112320536, 1035975658)
		+ W(6, -1101165077, 1050109344, -1072172899, -1105301985)
		+ W(7, 1032862316, -1115294669, 1041147790, 1041510968) + W(8, 1037860217, 1044362436, -1133865234, -1122721591)
		+ W(9, -1113177198, 1029583838, 1074693740, 1048694785) + W(10, -1121233078, 1027549527, 1025832748, 1046353900)
		+ W(11, 1081403750, 1057358913, 1015908463, -1114367420);
	WS(-1092184279, -1114774309);
	sum1 =
		W(0, -1112548452, 1035183681, -1114927434, 1044352162) + W(1, 979364527, -1115173597, -1120800919, 1038305887)
		+ W(2, -1101125062, 1039166894, -1131609361, -1182492945)
		+ W(3, -1114639366, 1043708422, -1087724142, 1063427286) + W(4, -1093459700, 1021495134, 1008341430, 1037535198)
		+ W(5, -1103312811, 1034792975, 1048665209, -1113251558)
		+ W(6, 1009522319, -1098020135, 1062809460, -1088121787)
		+ W(7, 1043037714, -1113757330, -1120506536, 1029108045)
		+ W(8, -1118967585, -1115071968, 1023205859, -1113409875)
		+ W(9, 1034801619, -1128765878, 1002077113, -1114196826)
		+ W(10, 1033949151, -1123554950, 1022706306, -1106461058)
		+ W(11, 1043448960, -1129024277, -1126884683, -1115469664);
	sum2 =
		W(0, -1130731300, -1113218164, 1024876637, -1112264614) + W(1, -1099018413, 1026854381, -1146462793, 1028824397)
		+ W(2, -1129593633, -1113338336, -1111675537, -1102804304)
		+ W(3, -1114036842, 1013989596, 1044891209, 1058622224) + W(4, -1088855347, -1102462733, 1017173194, 1034818358)
		+ W(5, -1101530532, -1105838439, 1059579881, -1108694945)
		+ W(6, 1027612469, -1104368005, 1049606516, 1050794194) + W(7, 1042736448, -1114432119, -1121343755, 1040334859)
		+ W(8, -1097048862, -1102338893, 1043492825, 1019755962) + W(9, 1027895615, -1123082454, 1042764886, 1040822444)
		+ W(10, -1121501222, -1122392540, -1154268081, -1123775916)
		+ W(11, -1113704648, -1122592353, 1034905054, -1119817837);
	WS(1061153836, -1122742154);
	sum1 = W(0, 1027853554, -1109089440, -1102650256, 1051082942)
		 + W(1, 1027843188, -1131011401, -1115291137, 1043116226)
		 + W(2, -1115210274, 1047414994, -1112215273, -1119605372)
		 + W(3, -1171221910, -1138258466, -1112757431, 1055597733)
		 + W(4, 1034632359, -1126942769, -1112977164, 1050791197)
		 + W(5, -1077890273, 1055540065, 1042514461, -1126698730)
		 + W(6, -1121554637, 1034471002, -1082648980, 1061271560) + W(7, -1131618020, 998349933, 1022714404, 1041098678)
		 + W(8, -1093251577, 1053866013, 1046515591, 1025132479)
		 + W(9, -1157881362, -1134239506, -1097764996, 1044732088)
		 + W(10, 1036747322, -1120958927, -1123187178, 1034237593)
		 + W(11, -1092621429, 1032996986, 1043087924, 984532249);
	sum2 =
		W(0, 1031101174, -1102026314, 1042272104, -1126868316) + W(1, 1028240358, 1023923290, -1132731961, 1038074007)
		+ W(2, -1090146581, 1042331882, 1036936531, -1128194324) + W(3, 1022986308, -1092900468, 1028046198, 1039425711)
		+ W(4, -1122656394, -1114483483, 1017601076, 1030590838) + W(5, 1054179894, 1068886648, 1039233571, -1108833787)
		+ W(6, -1126674740, 1001758673, -1096188072, 1049555295) + W(7, -1086618714, 1026905222, 1022398052, 1001713969)
		+ W(8, 1035923987, -1096410864, -1090080092, 1029729918)
		+ W(9, 1013813081, -1140283033, -1106500726, 1036573795)
		+ W(10, -1110072380, 1035325123, 1010235161, -1138091097)
		+ W(11, 1036670019, -1105222854, -1134061337, 1035525391);
	WS(-1098883799, 1037141561);
	sum1 = W(0, -1114839991, 1039141586, -1110021469, 1020247259) + W(1, 1030453625, 1040211480, 1029657918, 1034970850)
		 + W(2, -1090767256, 1029681923, -1119339247, -1126798193)
		 + W(3, -1116594483, 1048999812, -1089859629, 1058872566)
		 + W(4, -1104869706, 1041448405, 1034543274, 1026227619)
		 + W(5, 1007604554, -1100094273, -1106749124, -1123771570)
		 + W(6, 1026816074, -1103366664, 1063309440, -1090400131)
		 + W(7, 1040832320, 1006844457, -1140770618, -1115755155)
		 + W(8, 1050338841, -1090199858, 1023759014, -1131945671)
		 + W(9, 1035386535, -1109617409, 1049028980, -1104209655)
		 + W(10, 1040157646, -1115455274, 1007197468, -1117505278)
		 + W(11, 1050252341, -1101914812, 1034144506, -1106217213);
	sum2 = W(0, 1003211606, -1120528483, -1156174412, -1122088448)
		 + W(1, 1034591096, 1008615371, -1137674963, -1120827669)
		 + W(2, -1165578649, 1021421814, 1046263423, -1109822394)
		 + W(3, -1151639180, -1113012012, 1045965141, -1108742643)
		 + W(4, 1043768035, -1107512724, -1126381316, -1125167698)
		 + W(5, -1143882022, 1025314463, 1048434617, -1102660599)
		 + W(6, -1125497686, -1133545211, -1157195276, 1048741047)
		 + W(7, -1100558843, -1103528899, -1120928387, 1042115577)
		 + W(8, -1139515595, 1042307479, -1111490489, -1116374767)
		 + W(9, 1024650751, -1111755343, 1024020315, 1028526161)
		 + W(10, -1106766859, 1031989982, -1121709003, 1034768106)
		 + W(11, -1128894336, 1033940928, -1105393784, -1146160726);
	WS(1056068055, 1054753321);
	sum1 = W(0, -1151415881, 1039080395, 1057552055, -1089028090)
		 + W(1, -1115248008, 1035025164, -1148496799, -1110003853)
		 + W(2, 1043835198, 1042243518, 1050869997, 1014222010) + W(3, 1010657956, 1010453293, 1059020393, -1089501818)
		 + W(4, 1038857744, 1019596694, 1024019466, 1036235820) + W(5, 1056043521, -1077848098, 1040563886, -1121658024)
		 + W(6, -1130137728, 1020552269, 1059247988, -1085601017)
		 + W(7, 1031869090, -1123056704, 1008503186, 1036573197) + W(8, 1054798584, -1088101382, 1014726271, 1035081577)
		 + W(9, -1132133255, -1115513116, 1050516586, -1102383812)
		 + W(10, 1037313809, -1137744617, 1035499631, 1040242409)
		 + W(11, 1047345767, -1092379525, -1116861746, 1008326318);
	sum2 =
		W(0, 1028355794, -1096807405, 1040605863, 1067941768) + W(1, -1077104108, 1052817152, -1106782132, 1053669968)
		+ W(2, -1138391825, -1075220438, -1095467240, -1103015841)
		+ W(3, 1035193429, -1113415499, 1054131819, -1088459045) + W(4, -1094157882, 1049259157, 1019490884, 1045145961)
		+ W(5, -1117197986, 1059082808, 1063065831, -1103440804) + W(6, -1103311494, 1033457423, 1014178849, 1050105229)
		+ W(7, 1061761756, -1095094287, 1051099266, -1105194567)
		+ W(8, 1043284247, -1121773074, 1042603721, -1122898552)
		+ W(9, -1107701072, -1111393110, 1045435457, -1120483817)
		+ W(10, -1116379229, -1109769641, 1017055868, 995616995)
		+ W(11, -1110630971, 1023829774, 1044996767, 1018464332);
	WS(-1081368566, -1084412265);
	sum1 =
		W(0, 1027068306, -1116002144, 1048181720, -1097381330) + W(1, -1110979184, 1021378954, 1015688387, -1139602460)
		+ W(2, 1048418201, -1109028275, 1018111780, 1036715310) + W(3, 1033201483, -1116483849, 1059204754, -1086309497)
		+ W(4, -1126061147, -1118145977, 1018141039, -1108067395)
		+ W(5, 1059054739, -1080843359, 1023153354, 1024269909) + W(6, 1032237687, -1114781410, 1060863016, 1035809139)
		+ W(7, 1043786804, 1014428471, 1022250212, -1101031910) + W(8, 1054995541, -1090938969, -1102361409, 1015803518)
		+ W(9, 1019999841, -1110135922, 1048891912, -1097995920)
		+ W(10, 1017536656, 1027639288, 1019305877, -1115253585)
		+ W(11, 1054003721, -1098655035, -1110370680, 1026153225);
	sum2 =
		W(0, -1105480981, 1050460434, -1098849709, 1048076097) + W(1, 1035320005, -1105501338, 1035973965, -1096496755)
		+ W(2, 1051612828, -1090117310, 1047120319, -1108725217) + W(3, 1037165381, 1049140757, -1090898849, 1053634690)
		+ W(4, 1021130333, 1039969785, -1106311589, 1006710678) + W(5, 1040931379, 1066845841, -1083953982, 1046728781)
		+ W(6, 1052000177, -1091756558, 1058463605, -1077185739) + W(7, 1057459457, 1038345201, -1104974154, 1044207757)
		+ W(8, -1090778289, 1058534342, -1091684787, -1141278071)
		+ W(9, -1120302417, 1032159893, 1039812947, -1102438650)
		+ W(10, 1041032826, 1040363142, 1040627526, -1100748342)
		+ W(11, 1045155050, -1096398368, 1045504944, -1109297232);
	WS(1040286894, 1035975353);
	sum1 = W(0, -1171293815, 1034319831, 1059664710, -1091927835)
		 + W(1, -1116625676, 1013574450, 1023182418, -1127987806)
		 + W(2, 1048633701, -1097464070, 1029070026, 1012611215) + W(3, 996039142, -1102399280, 1062256902, -1087363556)
		 + W(4, 1016696459, -1115123712, -1137235964, -1105596260)
		 + W(5, 1059153168, -1086480503, 1000027879, 1006568169)
		 + W(6, -1135192533, -1103790599, 1061115073, -1089057879)
		 + W(7, 1028964506, -1134032598, 1025821242, -1108335719)
		 + W(8, 1056014846, -1099300213, -1108586113, 1032814547)
		 + W(9, -1128818097, -1114500598, 1050028641, -1097571161)
		 + W(10, 1032749254, 1020632239, 1020463141, -1129600787)
		 + W(11, 1052737098, -1112421262, -1096430155, 1016193698);
	sum2 = W(0, -1115556642, 1037372428, 1085969060, 1051814466)
		 + W(1, 1011471282, -1114698318, -1130243023, 1030557532) + W(2, 1077581449, 1043810263, 1030366783, 1034280644)
		 + W(3, 1032034792, 1049080310, -1074326256, -1103611514)
		 + W(4, -1109496698, -1140286158, -1126476135, -1112452010)
		 + W(5, -1064530882, -1081646826, -1129814679, 1022645135)
		 + W(6, 1032996496, -1108874582, -1074476109, 1033029539)
		 + W(7, 1035377868, -1126128243, -1138592966, -1125709403)
		 + W(8, -1104386166, 993676602, 1007963430, 1013431542) + W(9, -1121911846, -1147299853, 1029772508, 1034388196)
		 + W(10, 1005762565, -1114714998, 1029413614, -1125845903)
		 + W(11, -1109306490, 1000946837, 1024214725, 1024966722);
	WS(-1128144240, -1105727419);
	sum1 = W(0, 1008177348, 1038442911, 1034971295, 1037111480) + W(1, -1119737674, 1019898055, 1008158465, 1030921926)
		 + W(2, -1108323937, 1020025483, 1015575522, 1036155997) + W(3, 1025380533, -1116236765, 1041262911, 1039711206)
		 + W(4, -1096558626, 1023258159, 1041196118, -1091904121)
		 + W(5, -1116818069, -1090328900, -1106145913, 1038413850)
		 + W(6, -1123971020, -1110541401, -1118195565, 1053066642)
		 + W(7, -1107602136, -1123851725, 1038005880, -1155490648)
		 + W(8, 1050488689, -1108534613, 1033678004, 1027658998)
		 + W(9, -1110790464, -1118346788, 1005836543, 1032777199)
		 + W(10, 1034582855, -1118860082, 1022532691, -1132141153)
		 + W(11, 1035288564, 1043217853, -1110557919, -1161170171);
	sum2 =
		W(0, -1128930637, -1132037027, 1018701611, -1110976033) + W(1, -1129623857, 1029665439, 1013105493, -1110061572)
		+ W(2, 1028677045, -1113315034, -1136221161, -1120215489)
		+ W(3, 1027020519, 1023565141, -1097696705, -1136487341)
		+ W(4, 1045236380, 1025952555, -1111106512, -1118411413)
		+ W(5, 1051172043, 1064921249, -1100340880, -1120959951)
		+ W(6, 1033707008, -1104848450, 1036460110, -1097426277) + W(7, 1026225447, 1006240491, -1108465338, 1001195043)
		+ W(8, -1134254189, 1028959819, 1033145987, -1118442072)
		+ W(9, -1130609759, -1113096913, 1035127174, -1113952185)
		+ W(10, -1105387359, -1137489821, -1112986298, -1123693871)
		+ W(11, 1021784635, -1139702593, 1025786651, -1119362634);
	WS(1066786198, 1018352061);
	sum1 =
		W(0, 1037807432, 1042991174, 1056116676, -1089303485) + W(1, -1115182496, 1044944769, -1147124480, -1118935590)
		+ W(2, 1053008404, -1093203077, 1032850856, 1019595829) + W(3, 1032919115, -1102401423, 1058826232, -1091158043)
		+ W(4, -1118679276, 1030098999, 1043153405, -1111703874) + W(5, 1052869895, -1077398372, -1112497438, 990101824)
		+ W(6, 1024885356, -1105747115, 1063596395, -1088790919) + W(7, 1041854800, 1037575334, 1040525108, -1109427003)
		+ W(8, 1052412861, -1096537905, -1158252416, 1022825908) + W(9, 1034093744, 1036876386, 1055303296, -1092801624)
		+ W(10, 1029739551, 1042956152, 1041644314, -1113217832)
		+ W(11, 1055747689, -1095292522, -1097656684, 1027108728);
	sum2 = W(0, 1036031230, -1102747382, 1040389106, 1027629590)
		 + W(1, 1033840740, -1113736580, -1120880520, 1035081854) + W(2, 999021742, 1048871361, 1037408166, 1036561850)
		 + W(3, -1118383086, -1081312733, 1046511529, -1102228261)
		 + W(4, -1111365044, -1105995296, -1112120068, -1097589576)
		 + W(5, 1061513306, 1059108854, 1017984327, 1037901466) + W(6, 1044452135, -1136989239, -1098672489, 1030279668)
		 + W(7, 1032578550, 1024281094, -1113902667, -1101386787)
		 + W(8, 1028645652, -1090327880, -1098256610, 1003868670) + W(9, 1036248196, 1038098664, 1037598188, 1046091275)
		 + W(10, 1055272900, 1035521712, -1175016923, -1106083613)
		 + W(11, 1027306194, -1110606753, -1100293962, -1114802202);
	WS(-1088826540, -1072617048);
	sum1 =
		W(0, 986338164, 1037920241, 1051799989, -1096657083) + W(1, -1131268440, -1122826702, 1023136598, -1108211448)
		+ W(2, 1051897846, -1097067830, -1134063855, 1022858827)
		+ W(3, -1127817408, -1117329516, 1060040519, -1085267217)
		+ W(4, 1034398076, 1016624516, 1038855104, -1098615294) + W(5, 1068445460, -1091986338, -1104903024, 1025833567)
		+ W(6, -1112014844, -1156351446, 1041659186, -1085224562)
		+ W(7, 1041222927, -1148095931, 1032100206, -1125030464)
		+ W(8, 1049473503, -1095210946, -1123500579, 1018816617)
		+ W(9, -1114071293, 1025960366, 1046320643, -1103740786)
		+ W(10, 1021522163, 1004333185, 1031252724, -1128205111)
		+ W(11, 1053193450, -1098483636, -1110505437, -1135786218);
	sum2 =
		W(0, 1025188267, -1139275200, 1040515214, -1131755519) + W(1, -1105181237, 1030566925, -1121532154, 1033600964)
		+ W(2, -1111129732, -1105820182, 1041295374, -1137053008)
		+ W(3, 1037371296, -1123953755, 1035395064, 1067277095)
		+ W(4, -1104867399, -1131759093, -1111771837, 1046721727)
		+ W(5, -1119362505, 1075696256, 1058324165, 1026363312) + W(6, 1040037716, -1098628025, 1046868281, -1070220409)
		+ W(7, -1095490474, -1118056117, -1106548534, 1040338433)
		+ W(8, -1095083293, -1079865944, 1030948623, 1018203389) + W(9, 1039102739, -1109104289, 1045077862, 1049591033)
		+ W(10, -1107729189, -1128931569, -1109851481, 1042987802)
		+ W(11, -1121821072, -1113640498, 1039251361, -1123620784);
	WS(-1126600048, -1081356549);
	sum1 = W(0, -1127841038, -1133929050, -1098403026, 1044657313)
		 + W(1, -1112364357, -1126110067, -1121393942, 1032965854)
		 + W(2, -1092154099, 1056638003, 1040562850, 1036225512)
		 + W(3, -1127713943, 1033968271, -1092503722, 1049224359)
		 + W(4, 1040769245, -1129561307, -1112866678, 1043820719)
		 + W(5, -1081570623, 1066854747, -1105175211, 1047740947)
		 + W(6, -1130256197, 1042942538, -1086843241, 1055316562)
		 + W(7, -1123699911, -1102743497, -1113126004, 1043379215)
		 + W(8, -1092479684, 1058087872, -1108064855, 1041161205)
		 + W(9, -1135790871, 1027795642, -1097678271, 1032418298)
		 + W(10, -1138101411, -1106598351, -1114110304, 1034600139)
		 + W(11, -1094287464, 1051778533, 999504676, 1039116783);
	sum2 =
		W(0, 1002695390, 1041236493, -1107205869, -1110230321) + W(1, 1025661924, 1013006047, -1122258341, 1024135109)
		+ W(2, -1167041196, -1120190201, 1051920007, -1101224590)
		+ W(3, -1122292123, 1018577975, 1048984334, -1063745707) + W(4, 1083223141, 1033459361, -1120933435, 1034742596)
		+ W(5, -1085659967, -1070580481, 1079255156, 1037086181) + W(6, 1032169765, -1148289286, 1041640777, 1042707591)
		+ W(7, -1110361303, -1105447820, -1117894001, -1155671947)
		+ W(8, -1108030745, 1049556353, -1097500712, 1029970779)
		+ W(9, 1003179774, 1027950533, -1123201389, -1106095214)
		+ W(10, 1030518681, 1006793819, -1138289315, -1116290259)
		+ W(11, -1139220243, 1050855401, -1105964729, -1115669085);
	WS(1044741550, -1111040261);
	sum1 =
		W(0, -1123328853, -1129171790, -1119860449, 1045626213) + W(1, -1104602741, 1022127887, -1102049737, 1051367713)
		+ W(2, -1091471693, 1046305018, 1044417333, -1107859535) + W(3, 1040528310, -1097130129, 1035652177, 1049556145)
		+ W(4, -1091825946, 1033350174, -1104112191, 1051950321)
		+ W(5, -1092522751, 1053940037, 1049099055, -1124872112) + W(6, 1024305776, 1039437043, -1095677118, 1055561708)
		+ W(7, -1104689389, -1115808049, -1101315365, 1045396986)
		+ W(8, -1130673884, -1095468986, 1055485165, -1115536169)
		+ W(9, 1021709031, -1108128612, -1112716514, 1044018368)
		+ W(10, -1103796617, 1029190802, -1111623399, -1165073551)
		+ W(11, -1121220876, 1026385047, 1036376309, -1122289340);
	sum2 =
		W(0, -1104033148, 1039328248, 1040757730, 1023457753) + W(1, -1105261590, 1019934334, -1105436527, 1038128967)
		+ W(2, 1010939044, -1118329847, 1011822306, 998732076) + W(3, -1109964889, 1010051700, 1051778220, -1098103909)
		+ W(4, 1019752394, -1151355224, -1097126651, 1057153562)
		+ W(5, 1035481326, -1094975289, 1037637839, -1112777586)
		+ W(6, -1098141643, 1057745438, -1094952202, 1048659070) + W(7, 1023965510, 1012075272, -1090250993, 1060383381)
		+ W(8, -1102222701, -1098057265, 1049957743, -1134551782)
		+ W(9, -1116302593, 1035812245, -1133841678, -1123621243)
		+ W(10, -1104798795, 1031321862, -1118233874, 1044677482)
		+ W(11, -1105877607, -1160321672, 1036758948, -1124061226);
	WS(1065794902, 1053657215);
	sum1 =
		W(0, -1121908120, 1038333639, 1027457764, -1123855831) + W(1, -1123864939, 1004753494, 1018314063, 1031009517)
		+ W(2, -1106391546, 1034446294, -1121443224, 1015085764) + W(3, 1015310777, 1039118671, -1097318831, 1039330595)
		+ W(4, 1026117491, -1152877546, -1124873339, 1034311430)
		+ W(5, -1141167585, -1090069831, 1040632671, -1119728987)
		+ W(6, 1031572020, 1041290230, 1054548019, -1096859758)
		+ W(7, 1028976296, -1155937596, -1147984576, -1120195837)
		+ W(8, 1053489270, -1090834490, 1043686014, -1132243578)
		+ W(9, 1024640407, -1119856235, 1041008530, -1105884449) + W(10, 1007855863, 999100652, 1026486289, -1114392412)
		+ W(11, 1038700424, -1105777031, 1023881277, -1148206328);
	sum2 =
		W(0, -1111593455, 1035072504, 1043803228, 1033408259) + W(1, -1104275307, 998670368, 1026283313, 1028902500)
		+ W(2, -1108682745, -1102620143, 1005020832, 1032181798) + W(3, -1106910582, 1047373071, 1040261276, 1048908013)
		+ W(4, -1100960524, 1023771046, -1123416451, 1053329938) + W(5, 1067600226, -1090850305, 1050480903, 1032569956)
		+ W(6, 1050577288, -1092564654, -1072392505, 1062297118)
		+ W(7, -1138210428, -1112013629, -1128641646, -1100521328)
		+ W(8, -1113219589, 1017836657, -1168415746, 1023611526) + W(9, 1047088729, -1096962366, 1049469167, 1033530157)
		+ W(10, 1025688819, -1112880371, -1113858977, 1017970524)
		+ W(11, 1037790473, -1125952722, -1131011166, 1021270423);
	WS(1062391596, 1012575503);
	sum1 =
		W(0, 1031343933, -1118754907, -1124966418, -1110681406) + W(1, 1044511208, -1105353116, -1104891955, 1040079801)
		+ W(2, 1034244551, -1097175282, 1039695694, 1041572194) + W(3, 1032025473, -1098309187, -1115351741, 1051954479)
		+ W(4, 1024690888, -1106768761, 1018981700, 1047266492) + W(5, -1082667844, 1046130725, 1049723012, -1111177056)
		+ W(6, -1107154694, 1041578200, 1034155267, 1051147223) + W(7, -1103478091, 1041859398, 1037332142, -1102249736)
		+ W(8, -1116669206, 1052085167, 1031631968, -1100878141)
		+ W(9, -1113508494, 1040475388, -1108675062, 1003822408)
		+ W(10, 1001356052, 1037747241, -1120166325, -1099931343)
		+ W(11, 1037232762, 1045069376, -1120670778, -1115735812);
	sum2 = W(0, 1033523600, 984378304, 1029410276, 1013286288) + W(1, -1149511552, -1114072340, -1111554425, 1035520350)
		 + W(2, 1027721316, -1092144316, 1040549613, 1027894332)
		 + W(3, -1129275556, -1139357832, -1120989222, 1051778774)
		 + W(4, -1101613332, -1138380800, -1122087690, 1042336361)
		 + W(5, 1063527919, 1062226267, 1044728263, -1113445964)
		 + W(6, -1124036306, -1098127108, -1086537602, -1106529787)
		 + W(7, -1102568312, 1042436209, 1037981702, -1108770624)
		 + W(8, -1087308230, 1023869712, 1043627655, -1103441850)
		 + W(9, -1119955572, 1031985496, 1038170956, -1106223749)
		 + W(10, -1109791564, 1038090706, -1122349214, 1030270440)
		 + W(11, 1040810725, -1113965912, 1025118636, -1120264936);
	WS(1061969900, 1065420380);
	sum1 = W(0, 1002358108, 1041410250, 1005238718, -1098164717)
		 + W(1, -1127598604, 1013481849, -1132400117, 1024825568)
		 + W(2, 1055004288, -1093641048, 1037205414, -1128588267)
		 + W(3, 1036273784, -1111416381, 1058195604, -1089452644)
		 + W(4, -1122200151, 995531041, -1121891281, -1112279056)
		 + W(5, 1065721300, -1081575699, 1041630292, -1118185583)
		 + W(6, 1031471239, -1100377015, 1058645356, -1095897092)
		 + W(7, -1115380038, 1031870564, 1014037550, -1110955448)
		 + W(8, 1050103969, -1095327860, 1033148051, -1125213521)
		 + W(9, 1015146068, -1140842745, 1047622119, -1122283864)
		 + W(10, -1112032609, 1031659065, 1021231496, -1109508230)
		 + W(11, 1050895308, -1101391147, -1107652840, -1167265945);
	sum2 = W(0, 1037378832, -1097408481, -1089422359, -1134521568)
		 + W(1, 1024014288, -1156999910, -1105869799, 1040337956)
		 + W(2, 1064628576, 1048269110, -1113808990, -1121898726) + W(3, 1034348880, 1050274911, 1078490638, 1055313899)
		 + W(4, 1025241947, 1025759300, 1010791317, -1124897054)
		 + W(5, -1067190452, -1081189141, -1100728789, 1010618498)
		 + W(6, 1020451237, -1105197585, 1026583828, 1051135592) + W(7, 1047164907, 981635389, 1025476671, -1107003535)
		 + W(8, 1034175619, 1043712009, -1112306567, -1142752483)
		 + W(9, -1121382126, -1131733180, 1030289482, -1114815155)
		 + W(10, 1025919494, -1158764013, -1144944739, -1128932040)
		 + W(11, 1035014695, -1125325948, -1116208218, 1029088384);
	WS(1048733783, 1027643848);
	sum1 =
		W(0, -1133845785, 1036515120, -1088559253, 1057953132) + W(1, 1034283684, -1114935677, -1133175894, 1023561851)
		+ W(2, -1093510507, 1049915371, -1130587597, 1012777537)
		+ W(3, -1135183403, 1042717327, -1088396394, 1060634166)
		+ W(4, -1127730531, -1122593837, -1116789548, 1030082171)
		+ W(5, -1080791005, 1063183646, -1114509469, 1031486794)
		+ W(6, -1148511502, 1048693393, -1089662985, 1058925305)
		+ W(7, -1138682841, -1116148770, -1134260761, 1034425221)
		+ W(8, -1090323862, 1044704560, 1038705162, -1166921432) + W(9, 1018609610, 1039337356, -1100061261, 1042697693)
		+ W(10, 1015444552, -1126426832, -1123833247, 1027869798)
		+ W(11, -1089888600, 1047384498, 1049640472, 1023971661);
	sum2 =
		W(0, 994989105, 1037891939, -1173716290, -1100065758) + W(1, -1120127409, 1036146011, -1144072856, -1103317800)
		+ W(2, 1052666546, -1122814128, -1094230404, 1054652553)
		+ W(3, -1122509885, 1037436931, 1001371192, -1129250144)
		+ W(4, -1083084807, 1061875701, 1026939205, -1127785128) + W(5, 1040815920, 1058553182, -1075758811, 1067689129)
		+ W(6, 1028398855, -1103788534, -1100616833, 1055924851)
		+ W(7, -1074914963, 1068744910, -1120878413, 1034163445) + W(8, 1020001090, 1053725018, -1075891465, 1067320464)
		+ W(9, 1025208177, -1127272012, -1134790452, 1036740791)
		+ W(10, -1081737398, 1065190583, -1113678678, 1026044831)
		+ W(11, 1043708121, -1123998093, -1084193900, 1062426867);
	WS(-1084457324, 1066101859);
	sum1 = W(0, -1146837948, -1111022815, -1115296098, 1042035070)
		 + W(1, 1030912362, -1121095658, 1016102797, -1125864729)
		 + W(2, 1038645029, 1047347075, -1106508822, -1128702979)
		 + W(3, -1115430590, 1047559389, -1083544605, 1059438663)
		 + W(4, -1104927285, 1022709564, -1115904029, 1034715654)
		 + W(5, 1037951214, 1052960194, -1167432352, -1129984885)
		 + W(6, -1139281484, -1103064096, 1057869073, -1083491782)
		 + W(7, 1045723406, -1123913107, -1117556663, -1108958078)
		 + W(8, -1109939240, 1046468604, 1012598283, -1123056725)
		 + W(9, 1034492603, -1131712724, -1123954086, -1121536740)
		 + W(10, 1019381994, 1026960983, -1124011056, -1131623214)
		 + W(11, -1123535023, 1043250206, -1110102674, -1128824061);
	sum2 =
		W(0, -1125705477, -1127395739, -1105227463, 1036906007) + W(1, 1026846896, 989272222, -1127756609, 1044805550)
		+ W(2, 1015549291, -1109261657, 1037043129, -1106679057) + W(3, 993770127, -1097909373, 1049252886, -1102191244)
		+ W(4, -1097396928, 1042524140, 1034569455, -1177736375) + W(5, 1058826852, 1061852121, -1116961215, 1013800282)
		+ W(6, 1010458600, -1116962018, -1119951878, -1086841826)
		+ W(7, -1103314123, 1033157194, -1119844207, 1043096893)
		+ W(8, -1094678765, -1128420796, 1038664018, -1128652243)
		+ W(9, -1122090273, 1035619005, -1119199398, 1021651597)
		+ W(10, 1035622840, -1124905499, 1019369801, -1112228363)
		+ W(11, -1109645851, 1038741216, 1019677755, -1126258736);
	WS(1067036470, -1087655195);
	sum1 =
		W(0, -1143851962, 1018554747, 1050955184, -1110423387) + W(1, -1106360251, 1025799530, 1026890311, -1120379564)
		+ W(2, 1053786273, -1098337218, 1040602294, -1118031105)
		+ W(3, -1106604063, -1114993347, 1042552729, -1090196611)
		+ W(4, -1134551499, -1119796702, 1016195769, 1022258327)
		+ W(5, 1063572966, -1083965137, 1045568787, -1110210301) + W(6, -1138731339, 981655329, 1058367344, -1084059678)
		+ W(7, 1046272662, -1132188582, 1037080924, 1045778247) + W(8, 1055564522, -1090231591, 1028646847, -1117810092)
		+ W(9, -1121217270, 1025121994, 1047575674, -1096786628) + W(10, 1026932869, 1021012754, 1029907824, 1023696087)
		+ W(11, 1048845230, -1095677575, 1027665749, -1118338222);
	sum2 =
		W(0, -1113854255, -1108417433, 1042382895, 1025435556) + W(1, -1108154666, 1042045079, 1028862084, 1033605964)
		+ W(2, 1032534216, 1033584957, 1046901615, -1105415159) + W(3, -1104900936, -1109151867, 1017793091, 1033281558)
		+ W(4, -1111336587, 1039313065, -1104116954, -1102487521)
		+ W(5, 1067799294, -1099286824, 1036137805, 1005958605) + W(6, -1114719178, -1071728118, 1077900204, 1056033422)
		+ W(7, 1024983956, 1020191839, 1040474278, -1073652757) + W(8, 1051278318, -1113833767, 1034492621, -1114752489)
		+ W(9, 1048817634, -1090221130, 1048299521, 1011833167)
		+ W(10, 1033542750, 1024757388, -1122519186, -1102125815)
		+ W(11, -1105402373, -1107682623, -1127962013, 1032711916);
	WS(-1087701164, 1071308133);
	sum1 =
		W(0, 1040776942, -1100025248, 1040244657, 1047131214) + W(1, -1116520012, -1152028354, -1112915908, 1039729431)
		+ W(2, -1108101926, -1104971284, -1123736282, -1120800451)
		+ W(3, 1032135583, -1111499300, -1107965963, 1036283892)
		+ W(4, -1105297773, 1024489952, -1109010607, 1047911115) + W(5, -1095250332, 1057920197, 1040789767, 1038925278)
		+ W(6, -1125896234, -1096854047, -1097276733, 1057601759)
		+ W(7, -1089523085, 1034463851, 1033070381, 1047586960) + W(8, -1104060437, 1046835436, 1046328829, -1130324381)
		+ W(9, 1001383873, -1100475875, -1129328465, 1017446731)
		+ W(10, -1107686492, -1112186573, -1127540900, 1025720505)
		+ W(11, -1115131352, 1041767855, 1031878575, 1015088161);
	sum2 =
		W(0, -1089646175, 1060062242, 1050551269, 1017421696) + W(1, -1124178965, 1023971829, -1112379036, 1018139178)
		+ W(2, -1096611550, 1040955729, -1115297526, -1112174927)
		+ W(3, -1087427677, 1066898400, -1116330565, 1035645225)
		+ W(4, -1111832492, 1035838465, -1088789602, 1066001716) + W(5, 1056235229, 1040223965, 1027731712, -1128027042)
		+ W(6, 1059010203, -1079880526, -1118197619, -1114176344)
		+ W(7, -1106279788, 1015547306, 1060985431, -1081253059)
		+ W(8, -1102574794, 1044677785, -1130074994, 1033729011)
		+ W(9, -1139584980, -1095878540, 1039647840, -1100382074)
		+ W(10, 1040262609, -1110899873, 1054225000, -1095013927)
		+ W(11, -1099698701, 1035015292, -1124507789, 1032866060);
	WS(1063980716, -1121784884);
	sum1 =
		W(0, 1027357276, 1046480497, -1094692773, 1050884987) + W(1, 1046796692, 1025153935, -1104528667, -1121849329)
		+ W(2, -1090457523, 1048987838, -1098583576, -1107151594)
		+ W(3, -1122859745, 1049050976, -1090130146, 1057733925) + W(4, 1037378828, 1016110982, -1107033792, 1046903620)
		+ W(5, -1084796508, 1061180023, 1034725880, 1023598816)
		+ W(6, -1105809438, -1128776604, -1089370535, 1054317580)
		+ W(7, -1096435840, -1114135692, 1033196814, 1050194992) + W(8, -1105629197, 1055134019, 1049629536, 1040596522)
		+ W(9, -1111338526, -1112079704, -1093813713, 1046804578)
		+ W(10, -1097780651, -1113598601, -1111105883, 1037688238)
		+ W(11, -1094775914, 1057027842, 1038664949, -1127372967);
	sum2 =
		W(0, 1041589168, -1098133521, 1031854878, -1105720063) + W(1, 1035016760, -1121214780, 1024315846, -1106371173)
		+ W(2, 1051327081, 1023684981, -1128261352, 1011090873)
		+ W(3, 1043663909, -1106740015, -1108849860, -1124767392)
		+ W(4, 1035542785, 1029549000, 1040621380, -1107177437)
		+ W(5, -1106409587, -1127108094, -1111599720, 1034668152)
		+ W(6, 1040212968, -1111131552, -1120392794, -1102248051)
		+ W(7, 1051247500, -1136161665, 1033384296, 1040430896) + W(8, -1093765703, 1050935529, -1102687331, 1018485311)
		+ W(9, 1014426993, 1032409853, -1107120761, 1033359350) + W(10, 1037002974, -1126387868, 1022694293, 1003633577)
		+ W(11, -1104283048, -1128561530, 1026574958, 998242826);
	WS(1047153326, -1105960410);
	sum1 = W(0, 1032318440, -1105871782, -1111485966, 1043448020)
		 + W(1, -1110710801, 1019497606, -1133035902, 1024269605)
		 + W(2, -1098984649, 1044051929, 1028564080, 1019882933) + W(3, 1023033002, -1110369667, 1050315790, 1059563250)
		 + W(4, -1113831750, -1118335287, -1111741083, 1047130673)
		 + W(5, -1080272088, 1053459949, 1024144723, 1018957863) + W(6, 1009988015, 1043587009, -1086889743, 1061038806)
		 + W(7, -1117616080, -1122250988, -1126171361, -1113373146)
		 + W(8, -1098309317, 1044456898, -1145766181, -1124691083)
		 + W(9, -1183551252, 1035984354, -1105786176, 1048086975)
		 + W(10, -1114741783, -1123242346, -1118067977, -1111622952)
		 + W(11, -1106267538, 1037611273, 1040212689, -1150984053);
	sum2 = W(0, -1132142402, -1109262360, 1044069954, -1111364284)
		 + W(1, 1031679549, 1018817977, 1019405455, 1034679642)
		 + W(2, -1104355470, -1108806456, -1097044621, 1034241557)
		 + W(3, 1022592575, -1099677890, -1119884477, -1066728208) + W(4, 1043056057, 988348592, 1002713172, 1048612806)
		 + W(5, -1094376769, 1079847520, 1057366851, -1114461524) + W(6, 993592760, 1036415285, -1110824904, 1060715429)
		 + W(7, -1104696735, -1107038514, -1120241477, -1118742739)
		 + W(8, 1031998111, -1103911380, 993276152, 1036085605) + W(9, 1024283135, -1125545553, -1128336378, 1028262793)
		 + W(10, 1012785110, -1128734189, -1139068036, -1129249399)
		 + W(11, 1030577347, -1127589036, -1133646774, -1182233281);
	WS(1056964652, 1042968547);
	sum1 =
		W(0, 1026864302, 1044356666, -1111481597, -1091567350) + W(1, 1041608192, 1008927875, -1136392949, 1026146499)
		+ W(2, 1051097712, -1098882624, 1029687022, -1130908784) + W(3, 1024389106, 1030265493, 1040695131, -1090350559)
		+ W(4, 1042991030, -1127664937, -1126999334, 1038248593)
		+ W(5, 1052760426, -1081953599, 1043333208, -1121268145)
		+ W(6, 1026043785, -1126651679, 1056669112, -1095456258) + W(7, 1044232931, 952128323, -1130628252, -1146035092)
		+ W(8, 1038264227, -1102468122, 1038520784, -1146879000) + W(9, 1000688741, 986691602, 1027446877, -1109487565)
		+ W(10, 1033386798, -1137895230, 1002882868, 1033146167)
		+ W(11, 1040116499, -1110909592, 1040618297, 1023066122);
	sum2 =
		W(0, -1155037894, -1109445776, -1106399184, 1052866656) + W(1, 1046069094, 1012439553, -1117766868, -1132308185)
		+ W(2, 1041934367, -1111172948, 1042904039, -1108172404)
		+ W(3, 1042293027, -1101307898, -1137539889, 1058738313) + W(4, 1045435531, -1110297962, 1004126723, 995397702)
		+ W(5, 1035303811, 1064268129, 1051607279, -1110625272) + W(6, -1123150924, 1014206993, -1091518060, 1052685347)
		+ W(7, -1098813712, -1107185126, 1015608713, 1046458351)
		+ W(8, -1124849601, -1090299347, -1150133894, 1045339946)
		+ W(9, -1135323377, -1120597884, 1043824666, -1087905074)
		+ W(10, 1037110006, -1122419536, 1030487760, 1026431488)
		+ W(11, 1061366644, -1075431372, -1089430426, 1049588119);
	WS(-1096061015, 1045980634);
	sum1 =
		W(0, -1136709393, 1047345176, -1089944925, -1113534082) + W(1, 1020871950, 1032683291, 1028828435, 1016418418)
		+ W(2, -1096285771, 1049565603, 1021274185, 1018404508) + W(3, 997001355, 1049157941, -1094897728, -1113216951)
		+ W(4, 1042276288, 1027484139, 1022855123, 1032879612) + W(5, -1097979037, -1094660427, 1039512084, -1119890439)
		+ W(6, -1128346047, 1042754713, 1014307589, 1031601097) + W(7, 1028680388, 1030972704, 1031977874, 1032419332)
		+ W(8, 1040846151, -1095562472, 1044068336, -1125789619) + W(9, 984865373, -1124110958, 1042092045, -1109834744)
		+ W(10, -1140756488, 1031142826, 1040707047, 1040469689)
		+ W(11, 1041011167, -1093905225, 1048548616, -1123584299);
	sum2 =
		W(0, -1114682679, 1055059251, 1064739409, -1095220576) + W(1, -1100660553, 1038444345, -1115477579, 1024869090)
		+ W(2, 1031266096, -1113806527, -1105830101, -1132048253)
		+ W(3, -1100789101, 1055732865, 1030176534, 1040530242)
		+ W(4, -1096186716, 1040636888, -1113658391, -1122542034)
		+ W(5, 1067742275, 1036337974, -1103152959, 1015520805)
		+ W(6, -1110942733, -1120682294, 1062911121, -1087169731)
		+ W(7, 1035448471, 1032588114, 1044868728, -1107016239) + W(8, -1081471397, 1042181045, 1052603278, -1102136445)
		+ W(9, 1028313432, -1152832742, -1080677577, 1042749891)
		+ W(10, 1033558186, -1134141481, 1046472362, -1087243594)
		+ W(11, -1077241450, 1067213860, 1052345796, -1112398105);
	WS(-1086603372, 1061480206);
	sum1 =
		W(0, 1025472273, 1022341006, 1006839158, -1102342404) + W(1, 1042514621, -1114893026, -1143591172, 1027469190)
		+ W(2, -1128153798, -1124925900, 1043263108, -1114252238)
		+ W(3, -1124123051, -1141108008, 1051787090, -1093885235)
		+ W(4, 1027880941, -1121794488, -1110008795, 1042054049)
		+ W(5, -1090097115, 1058414043, -1105821275, 1039892842)
		+ W(6, -1124248793, 1051331968, -1081435553, 1063214861)
		+ W(7, -1094479791, 1028544109, -1127491490, 1044174205)
		+ W(8, -1089913687, 1057428893, -1099759469, 1041669328) + W(9, 1014214528, 1044005681, -1092574472, 1052102264)
		+ W(10, -1112069887, 977928239, -1120184170, -1155225358)
		+ W(11, -1096696337, 1048742922, 1035771431, 1039400116);
	sum2 =
		W(0, 1037224808, 1025638319, -1093017633, -1143762368) + W(1, -1119609796, 995865588, -1109009263, 1049599085)
		+ W(2, 1039705537, -1112746506, -1119534458, 1021427773)
		+ W(3, -1120793535, -1142324554, 1040559103, -1099136162)
		+ W(4, -1123476586, 988834049, -1110258597, 1028269513) + W(5, 1053657173, 1056581815, -1104556193, -1122952792)
		+ W(6, -1112240446, -1132053081, -1120149375, -1118127758)
		+ W(7, 1044376501, -1114993482, -1151274598, -1119573384)
		+ W(8, 1043501160, -1147801478, -1107739102, 1029987722)
		+ W(9, -1120536233, 1010517574, -1121251494, -1130373692)
		+ W(10, 1033895801, -1106681926, -1103902982, 1008384356)
		+ W(11, 1035850418, 1032229723, -1122521676, -1116132116);
	WS(1037058908, -1087106898);
	sum1 = W(0, 1032385376, 1026637522, -1098495714, 1041048768) + W(1, 1039729665, 1017191910, 1028077583, -1129390954)
		 + W(2, -1107088868, 1041268325, -1126519617, -1132138900)
		 + W(3, 1014613011, 1048467894, -1108180359, 1045140885) + W(4, 1040649531, 1035348883, -1151370839, 1048758199)
		 + W(5, -1093334653, -1080472255, -1114665834, 997380151)
		 + W(6, -1139761263, 1043852440, -1108393155, 1045570315)
		 + W(7, -1125126080, 1031307292, 1027279360, 1034990442) + W(8, -1097414435, 1045361342, 1035082182, 1030937245)
		 + W(9, 1022565566, 1017011558, -1111470776, 1028923180)
		 + W(10, 1023808326, -1138594135, 1031834108, 1036138504)
		 + W(11, -1104527470, 1036330497, 1027790590, 1036519916);
	sum2 = W(0, -1111516802, -1131222514, -1097346809, 1049467820)
		 + W(1, -1118099733, -1111393075, 1036231024, -1098228691)
		 + W(2, -1128682274, 1020406578, -1102087439, 1039222222)
		 + W(3, -1130951686, 1034905648, -1113861539, 1024259929)
		 + W(4, 1049541587, -1113826501, 1031916934, -1090487171)
		 + W(5, 1052765954, 1061096371, -1108988196, 1025340241)
		 + W(6, -1130989326, 1032129266, -1108538807, -1104129123)
		 + W(7, 1033200380, 1029417921, -1129631002, 1035677128)
		 + W(8, -1122282521, -1108918961, 1042713844, -1111528334)
		 + W(9, -1123615369, -1103168970, 1038239484, -1114584358)
		 + W(10, -1097598443, 1034012496, -1119469958, 1049196148)
		 + W(11, -1116187122, -1129232626, 1018354634, 1029857705);
	WS(1054906071, -1091145324);
	sum1 = W(0, 1029398237, -1120406171, 1051536197, -1115196942)
		 + W(1, -1136290815, -1126429728, -1140775857, -1106052861)
		 + W(2, 1046952684, -1109008729, 1034481647, 1032555988)
		 + W(3, -1128656451, -1099422950, 1057886666, -1097962977)
		 + W(4, -1114344740, 1015919623, 1004160018, 1032725545)
		 + W(5, -1085942396, -1130426984, 1050651652, -1108426832)
		 + W(6, -1130732913, -1097841652, -1098611557, 1048146402)
		 + W(7, -1102043591, 1040987294, 1029686973, 1037934865)
		 + W(8, 1042440654, 1034532491, -1133864753, -1107032303)
		 + W(9, 1021855224, 1036573848, 1035129734, -1122054089)
		 + W(10, -1124817654, 1044439941, -1128798955, -1157619404)
		 + W(11, 1032622058, 1027356128, -1126847669, -1115113714);
	sum2 = W(0, -1113802973, 1027581315, -1110955855, 1047020911)
		 + W(1, -1105727831, 1022816774, -1116219822, -1112877584)
		 + W(2, -1127685514, 1021259086, -1118276653, -1129541322)
		 + W(3, 1020553430, -1110295429, -1097495000, 1057623683)
		 + W(4, -1110729082, 997980814, -1109755343, 1027296115) + W(5, 1025841055, 1053623791, -1104267868, 1016281450)
		 + W(6, -1131329246, -1126007358, -1104102640, 1057318729)
		 + W(7, -1106795812, -1105649969, -1112950186, 1035099341)
		 + W(8, -1110724235, 1040083835, -1119773745, 1031563375)
		 + W(9, -1113313093, -1130784978, -1165405916, 1048620928)
		 + W(10, -1128480210, -1111917112, -1116367256, 1035863861)
		 + W(11, -1097352168, 1039940909, -1110646461, 1032754595);
	WS(1063926444, -1083200389);
	sum1 =
		W(0, -1110900111, 1049653262, -1089993663, 1052688460) + W(1, -1098055945, 1042131972, 1015785179, -1116391059)
		+ W(2, -1106495964, 1038385529, -1108169455, -1121748392)
		+ W(3, -1132926346, 1048988121, -1104923071, 1045396422)
		+ W(4, -1110654965, 1039495970, 1034778082, -1111931241)
		+ W(5, 1061854120, -1089207439, -1111176153, -1117097761)
		+ W(6, 1029162938, 1002973694, 1062129309, -1085048198) + W(7, 1042255343, -1120523578, 1024169214, -1107911937)
		+ W(8, 1059656227, -1087799869, 1043917388, -1106362715)
		+ W(9, 1031086749, -1104277444, 1047872627, -1096506545)
		+ W(10, 1012240783, 1011366638, -1116484151, -1114837807)
		+ W(11, 1055218483, -1096830980, 1049045741, -1098874335);
	sum2 = W(0, 1031260311, -1079593190, -1121246507, -1113337443)
		 + W(1, 985022717, 1032096214, 1008713252, -1080879443) + W(2, 1035854140, 1043424734, -1123981203, -1130846658)
		 + W(3, -1110413739, -1099919153, 1040572163, -1112705599)
		 + W(4, 1028350097, -1119780465, -1108083749, 1067198745)
		 + W(5, -1111993270, -1102589461, 1035118406, 1007072124) + W(6, 1024382525, 1061544601, 1060638292, 1044789771)
		 + W(7, -1119559917, -1132931022, -1107516795, 1037733964)
		 + W(8, -1122943484, 1040341398, -1123835438, -1131952682)
		 + W(9, 1032742989, 1034769578, -1098923291, -1116338100)
		 + W(10, 1021760610, 1028149723, -1107429215, 1037726418)
		 + W(11, 1034609836, 1030676197, -1114867192, -1115680064);
	WS(-1091090263, 1040227933);
	sum1 =
		W(0, -1123880467, -1113261184, 1033284496, 1044923332) + W(1, -1105999782, -1135767575, -1114808049, 1027485320)
		+ W(2, 1019377225, -1098653061, 1042536309, -1127683258)
		+ W(3, 1014154590, -1101480756, -1102787036, 1059927492) + W(4, -1095990282, 1037484605, 1032220316, 1043855170)
		+ W(5, -1094753319, 1040011797, 1044858269, -1120454550)
		+ W(6, 1018131933, -1088775234, 1065098078, -1099661886)
		+ W(7, -1091964998, 1029352975, -1121223347, 1021676847)
		+ W(8, -1107869654, -1151140018, 1045062557, -1109078132)
		+ W(9, -1128795491, 1031227206, 1045897152, -1113799968)
		+ W(10, -1109510984, 1027724204, 1008528046, 1026364723)
		+ W(11, 1025551690, -1125551659, 1023695008, 1006311503);
	sum2 =
		W(0, -1123304381, -1135928985, 1039889929, -1113522433) + W(1, -1108136941, 1038356153, 1011470018, -1131363804)
		+ W(2, 1045400660, -1100907702, 1038781261, -1139124254)
		+ W(3, -1116901758, 1044779190, -1100997480, -1104972678)
		+ W(4, 1052809383, -1105005165, 1029761957, -1101932196) + W(5, 1055172736, 1058841413, -1093286229, 1040780481)
		+ W(6, -1135722528, -1097334030, -1087140500, 1039800739)
		+ W(7, 1034962749, -1105451984, -1111769341, 994986369) + W(8, 1054550160, -1122473050, -1105965260, 1042887374)
		+ W(9, -1107033568, 1042173475, -1110305303, -1109069053)
		+ W(10, 1038676003, -1114167820, 1032808415, 1025113569)
		+ W(11, -1115908038, 1032761157, -1155418681, -1152192529);
	WS(1063982124, 1031276218);
	sum1 =
		W(0, 1041442545, 1031361481, 1056936890, -1090353464) + W(1, -1122143798, 1007942615, -1103090149, 1026538936)
		+ W(2, 1055470587, -1090262005, -1101092681, 1040474995)
		+ W(3, 1042807746, -1101400314, 1060963845, -1096383728) + W(4, 1031723710, -1103896066, 1024468200, 1034898060)
		+ W(5, 1061353486, -1078114170, -1122232454, 1027975174)
		+ W(6, -1106882536, -1103132501, 1063510555, -1106902698)
		+ W(7, 1043143621, 1030475455, 1049721332, -1112916420)
		+ W(8, 1048946651, -1088793180, -1172995470, -1101011290)
		+ W(9, -1101888878, -1139074135, 1054541302, -1098771630)
		+ W(10, 1032268200, 1044176219, 1042454319, -1110788513)
		+ W(11, 1058321972, -1093460753, -1104729748, -1108198577);
	sum2 =
		W(0, 1015674059, -1109357907, 1031332447, 1066992274) + W(1, -1074609058, 1048304191, 1034996578, 1024785272)
		+ W(2, 1048659656, 1076858856, -1070866381, 1030261153) + W(3, 1026624942, -1129998179, -1108514478, 1078632808)
		+ W(4, -1068251573, -1098508369, -1128049054, -1120348186)
		+ W(5, 1052415888, 1073772904, -1076608801, -1108782845) + W(6, 999367802, 1048014132, -1105319294, -1105884909)
		+ W(7, -1103939197, 1048310856, 1021382702, -1105300006)
		+ W(8, -1117149322, 1038594495, -1109221944, 1031934850) + W(9, -1124407536, 1046166047, 1010482847, 1038514249)
		+ W(10, -1098022157, 1046147873, 1029480964, -1116382211)
		+ W(11, -1154249511, -1098756758, -1125235504, 1038709270);
	WS(-1084008748, -1076428689);
	sum1 =
		W(0, 995293936, -1119372516, -1088304948, 1059786207) + W(1, -1137964103, 1013109895, -1162911689, 1036299874)
		+ W(2, -1097059736, 1051547992, -1125552990, 1006687204)
		+ W(3, -1138016718, 1017340780, -1085861109, 1060565598)
		+ W(4, -1116363658, 1002349741, -1132274729, 1041960361)
		+ W(5, -1081600491, 1064118968, -1116908178, 1007519945)
		+ W(6, -1145295444, 1044385332, -1083799507, 1058261310) + W(7, -1119006543, 994300076, -1131268254, 1034368866)
		+ W(8, -1090459925, 1050466917, 1026422690, -1119097260)
		+ W(9, -1201649403, 1043013720, -1104403080, 1049921019)
		+ W(10, -1131911306, -1123993357, -1135278623, -1103541652)
		+ W(11, -1103180426, 1042671596, 1051353751, 1023041036);
	sum2 =
		W(0, 1033856632, -1090933982, 1068958128, 1067844920) + W(1, -1095515318, -1124923033, 1041148647, -1094617784)
		+ W(2, 1066199400, -1102124443, -1122244574, 1042779533)
		+ W(3, -1094518814, -1122277735, 1055138982, 1051248434) + W(4, 1036900546, -1103088355, 1045521814, 1062250596)
		+ W(5, -1070105649, -1078683071, 1046136146, -1114411292)
		+ W(6, -1128266986, 1027053741, -1070096660, -1079091570)
		+ W(7, 1021983978, -1114099181, 1033117136, 1050179515) + W(8, -1082392713, -1089309992, 1045719314, 1023274434)
		+ W(9, -1173165821, 1033890948, 1067349236, 1047411220)
		+ W(10, 1050937215, -1124200313, 1041230368, -1086799133)
		+ W(11, 1076979077, 1070525583, -1091587052, 1042022635);
	WS(-1081223670, 1021288719);
	sum1 =
		W(0, 1011016529, 1035837139, 1042651768, -1098433890) + W(1, -1129696110, 995272815, -1123721507, 1032041909)
		+ W(2, 1036928499, -1100608474, 1024607124, 1027549342) + W(3, 1017381041, -1108640782, 1055254255, -1094722148)
		+ W(4, -1131079071, -1116321147, 1017648243, 1024313608) + W(5, 1061777248, -1083909329, 1047474926, 1017435439)
		+ W(6, 1028006000, -1105590117, 1061429156, -1087617676)
		+ W(7, 1036831026, -1122084432, -1122128468, -1108791100)
		+ W(8, 1052534382, -1091388554, 1033276873, -1139273509)
		+ W(9, 1009660876, -1128783630, 1049990152, -1104773376)
		+ W(10, -1150770463, 1024807730, 1007983923, -1116825572)
		+ W(11, 1053483289, -1093454083, 1005912461, -1125665142);
	sum2 =
		W(0, 1057380038, -1088994983, 1016685185, 998662038) + W(1, 1040844632, 1027712021, 1057597982, -1085734595)
		+ W(2, 983594263, 1031174835, -1116219635, -1109851055) + W(3, 1069621581, -1072283812, 1066773393, -1099503122)
		+ W(4, -1134907857, 1037507283, 1060801069, -1079782207)
		+ W(5, 1060848632, -1097910780, 1027931069, -1116080368) + W(6, 1060050844, -1081640783, 1043641192, 1038323247)
		+ W(7, -1111695032, -1123552119, 1041938366, 1046270010) + W(8, -1105013658, 1026094487, 1047921746, 1028446195)
		+ W(9, -1122435905, -1113922524, -1104981345, 1036576275)
		+ W(10, -1114519002, -1108250726, 1024344515, 1043446590)
		+ W(11, -1105295106, -1145544806, 1032973176, 1031771441);
	WS(-1120405176, 1052288640);
	sum1 =
		W(0, -1136485047, 1040656325, 1051431647, -1114886102) + W(1, -1113721480, -1115542032, -1120969533, 1013423883)
		+ W(2, 1042796768, -1092939904, 1039390695, -1165530871)
		+ W(3, 1032711321, -1108004548, 1062809491, -1083705303) + W(4, 1026161897, 1020434857, 1027237267, -1107763377)
		+ W(5, 1060861813, -1089040632, -1116341945, 1024821617) + W(6, 1021305874, 1022040031, 1027813500, 1039332409)
		+ W(7, -1108229347, 1031183209, -1146847086, 1040265357)
		+ W(8, -1107918083, -1098943929, 1035322940, 1019272038)
		+ W(9, -1133175986, 1031093856, 1039657966, -1112315213)
		+ W(10, -1115465454, 1024346473, 1039673939, -1100629595)
		+ W(11, 1043412169, -1104541036, -1114748782, 1012723731);
	sum2 = W(0, 1032873736, -1128467212, -1098460251, 1024553592)
		 + W(1, 1047433570, -1128334191, -1106233681, -1131275971)
		 + W(2, 1035809416, -1114616785, 1026776904, -1107845863)
		 + W(3, 1036788040, -1113770947, -1078975662, -1092555656)
		 + W(4, -1132131619, 1043173677, 1009987037, -1088748320)
		 + W(5, 1062703231, 1067981395, -1104531393, -1111351589)
		 + W(6, -1117147579, -1097209973, 1059662245, 1058574054) + W(7, -1106248497, 991598885, 1018109057, 1040210251)
		 + W(8, -1110493560, -1103422592, -1125640736, -1107997815)
		 + W(9, -1114508674, -1099376356, 1052516052, 1038056552)
		 + W(10, -1107638185, 1023829740, -1106556966, 1050939532)
		 + W(11, 992650581, 1026754378, -1107493388, -1106870741);
	WS(1050656983, 1072047790);
	sum1 =
		W(0, -1128713579, 1048792739, 1050333168, -1097949975) + W(1, -1101689274, -1127716817, 1026709637, 1034799517)
		+ W(2, 1050171449, -1104033571, 1036522731, 1037025856) + W(3, 1023201012, 1014670385, 1053203577, -1085647978)
		+ W(4, -1115538280, -1116963676, 1030859291, -1116111658)
		+ W(5, 1064066450, -1080119690, 1043957990, -1112813084) + W(6, 1041237492, 1025355287, 1060032700, -1088145917)
		+ W(7, 1037919995, 1036783049, -1152997210, -1112906461)
		+ W(8, 1050694506, -1088560507, -1120212113, -1113565993)
		+ W(9, -1155686725, 1036463444, 1053095469, -1105136840) + W(10, 1035379762, 1035776666, 1040488948, 1002270506)
		+ W(11, 1046913707, -1093840327, -1108210918, -1122514141);
	sum2 = W(0, 1032121925, 1067037293, -1074821338, -1094551116)
		 + W(1, 1045030197, -1115959604, -1105031648, 1072414374)
		 + W(2, -1081225596, 1050387420, 1035683027, -1117669800)
		 + W(3, -1130820039, 1072723545, -1069168235, 1050306407)
		 + W(4, 1054464199, -1109697271, -1105961083, 1076922042)
		 + W(5, -1068908234, -1080768789, -1129129027, -1106200850)
		 + W(6, 1040237041, 1072846596, 1068735095, -1110799161)
		 + W(7, -1109242003, 1041008693, -1091675607, -1079373087)
		 + W(8, 1050158994, 1048692149, -1102086715, -1107790175) + W(9, 1052906990, 1048404715, 1043049709, 1039557097)
		 + W(10, 1050068036, 1019897614, -1119953618, -1090018360)
		 + W(11, 1036354441, -1114340558, -1106557101, 1034398799);
	WS(-1081468886, 1041730784);
	sum1 =
		W(0, -1114247594, 1021500053, 1028761377, 1044129269) + W(1, -1131183895, -1121682823, 999910687, 1042624634)
		+ W(2, 1005300019, 1053438789, -1096850135, 1029411807) + W(3, -1112649805, 1043096639, -1100727404, 1055682820)
		+ W(4, -1106832988, 1022343799, 1022168820, 1034747044) + W(5, 1035906940, -1086991443, 1038040260, -1113521452)
		+ W(6, 1009392321, -1103886814, 1062898916, -1084075064)
		+ W(7, 1044548897, -1110992968, 1025791509, -1101453262)
		+ W(8, 1054732110, -1098009154, 1037861846, -1110478453)
		+ W(9, -1115410306, 1026735815, 1042621601, -1097832968)
		+ W(10, 1022910341, -1125653940, 1020540891, 1034256626)
		+ W(11, 1041116931, -1117544535, -1121491970, -1112646442);
	sum2 = W(0, -1109856908, 1025315462, -1111613060, -1108093549)
		 + W(1, 1041489120, -1114414815, 995541592, 1040254152) + W(2, 997512408, -1085520225, -1094645099, 1040714423)
		 + W(3, -1107331629, 1035675473, -1115826672, -1103361463)
		 + W(4, -1102705141, -1125997775, 1043476326, 1026228130)
		 + W(5, 1067108106, 1059978555, -1121534122, 1032256197)
		 + W(6, -1104942022, -1101803200, 1053887552, -1094292172)
		 + W(7, 1039802977, -1130615251, 1039471517, -1123010638)
		 + W(8, -1104388416, -1120534147, 1017265579, -1129091643)
		 + W(9, -1114856041, 1040268905, -1120685867, -1108094032)
		 + W(10, 1040793483, -1108206349, 1022399907, 1028920354)
		 + W(11, -1103458923, 1040596394, -1107135380, 1027593934);
	WS(1054796503, -1111794816);

	return clamp(mstd0 + 5.0 * vsum / wsum * mstd1, 0.0, 1.0);
}

shared float inp[507];

#define CURRENT_PASS 1

#define GET_SAMPLE(x) dot(x.rgb, rgb2y)
#define imageStore(out_image, pos, val) imageStoreOverride(pos, val.x)
void imageStoreOverride(uint2 pos, float value) { temp[pos] = (value); }

#define INPUT_tex(pos) GET_SAMPLE(vec4(texture(INPUT, pos)))
static const float2 INPUT_size = float2(GetInputSize());
static const float2 INPUT_pt = float2(GetInputPt());

#define HOOKED_tex(pos) INPUT_tex(pos)
#define HOOKED_size INPUT_size
#define HOOKED_pt INPUT_pt

void Pass1(uint2 blockStart, uint3 threadId) {
	ivec2 group_base = ivec2(gl_WorkGroupID) * ivec2(gl_WorkGroupSize);
	int local_pos = int(gl_LocalInvocationID.x) * 13 + int(gl_LocalInvocationID.y);
	for (int id = int(gl_LocalInvocationIndex); id < 507; id += int(gl_WorkGroupSize.x * gl_WorkGroupSize.y)) {
		uint x = (uint)id / 13, y = (uint)id % 13;
		inp[id] =
			HOOKED_tex(HOOKED_pt * vec2(float(group_base.x + x - (3)) + 0.5, float(group_base.y + y - (2)) + 0.5)).x;
	}
	barrier();
	vec4 ret = vec4(0.0, 0.0, 0.0, 0.0);
	vec4 ret0 = vec4(0.0, 0.0, 0.0, 0.0);
	vec4 samples[12];
	samples[0][0] = inp[local_pos + 0];
	samples[0][1] = inp[local_pos + 1];
	samples[0][2] = inp[local_pos + 2];
	samples[0][3] = inp[local_pos + 3];
	samples[1][0] = inp[local_pos + 4];
	samples[1][1] = inp[local_pos + 5];
	samples[1][2] = inp[local_pos + 13];
	samples[1][3] = inp[local_pos + 14];
	samples[2][0] = inp[local_pos + 15];
	samples[2][1] = inp[local_pos + 16];
	samples[2][2] = inp[local_pos + 17];
	samples[2][3] = inp[local_pos + 18];
	samples[3][0] = inp[local_pos + 26];
	samples[3][1] = inp[local_pos + 27];
	samples[3][2] = inp[local_pos + 28];
	samples[3][3] = inp[local_pos + 29];
	samples[4][0] = inp[local_pos + 30];
	samples[4][1] = inp[local_pos + 31];
	samples[4][2] = inp[local_pos + 39];
	samples[4][3] = inp[local_pos + 40];
	samples[5][0] = inp[local_pos + 41];
	samples[5][1] = inp[local_pos + 42];
	samples[5][2] = inp[local_pos + 43];
	samples[5][3] = inp[local_pos + 44];
	samples[6][0] = inp[local_pos + 52];
	samples[6][1] = inp[local_pos + 53];
	samples[6][2] = inp[local_pos + 54];
	samples[6][3] = inp[local_pos + 55];
	samples[7][0] = inp[local_pos + 56];
	samples[7][1] = inp[local_pos + 57];
	samples[7][2] = inp[local_pos + 65];
	samples[7][3] = inp[local_pos + 66];
	samples[8][0] = inp[local_pos + 67];
	samples[8][1] = inp[local_pos + 68];
	samples[8][2] = inp[local_pos + 69];
	samples[8][3] = inp[local_pos + 70];
	samples[9][0] = inp[local_pos + 78];
	samples[9][1] = inp[local_pos + 79];
	samples[9][2] = inp[local_pos + 80];
	samples[9][3] = inp[local_pos + 81];
	samples[10][0] = inp[local_pos + 82];
	samples[10][1] = inp[local_pos + 83];
	samples[10][2] = inp[local_pos + 91];
	samples[10][3] = inp[local_pos + 92];
	samples[11][0] = inp[local_pos + 93];
	samples[11][1] = inp[local_pos + 94];
	samples[11][2] = inp[local_pos + 95];
	samples[11][3] = inp[local_pos + 96];
	ret[0] = nnedi3(samples);
	ret0[0] = inp[local_pos + 41];
#if CURRENT_PASS == LAST_PASS
	uint2 destPos = blockStart + threadId.xy * 2;
	uint2 outputSize = GetOutputSize();
	if (destPos.x >= outputSize.x || destPos.y >= outputSize.y) {
		return;
	}
#endif
	imageStore(out_image, ivec2(gl_GlobalInvocationID) * ivec2(1, 2), ret0);
	imageStore(out_image, ivec2(gl_GlobalInvocationID) * ivec2(1, 2) + ivec2(0, 1), ret);
}
//!PASS 2
//!DESC NNEDI3 (double_x, nns256, win8x6)
//!IN INPUT, temp
//!OUT OUTPUT
//!BLOCK_SIZE 64, 8
//!NUM_THREADS 32, 8
#pragma optionNV(inline none)
float nnedi3(vec4 samples[12]) {
	float sum = 0.0, sumsq = 0.0;
	[unroll] for (int i = 0; i < 12; i++) {
		sum += dot(samples[i], vec4(1.0, 1.0, 1.0, 1.0));
		sumsq += dot(samples[i], samples[i]);
	}
	float mstd0 = sum / 48.0;
	float mstd1 = sumsq / 48.0 - mstd0 * mstd0;
	float mstd2 = mix(0.0, inversesqrt(mstd1), mstd1 >= 1.192092896e-7);
	mstd1 *= mstd2;
	float vsum = 0.0, wsum = 0.0, sum1, sum2;
#define T(x) intBitsToFloat(x)
#define W(i, w0, w1, w2, w3) dot(samples[i], vec4(T(w0), T(w1), T(w2), T(w3)))
#define WS(w0, w1)                                                                                                     \
	sum1 = exp(sum1 * mstd2 + T(w0));                                                                                  \
	sum2 = sum2 * mstd2 + T(w1);                                                                                       \
	wsum += sum1;                                                                                                      \
	vsum += sum1 * (sum2 / (1.0 + abs(sum2)));
	sum1 = W(0, -1118812211, -1126504964, -1120674615, 1037346316)
		 + W(1, -1120777358, -1137814218, -1128256674, -1118580651)
		 + W(2, -1118354985, -1117760744, -1117458482, -1097807929)
		 + W(3, -1114916026, -1101147334, 978731342, -1112914505)
		 + W(4, -1108702207, -1127312137, -1124477727, 1051925971)
		 + W(5, 1042061230, 1032645830, 1026597474, 1040041685) + W(6, -1107177196, 1040658850, 1041726453, 1061593601)
		 + W(7, 1053108884, 1029100907, 1023094846, 1010634196)
		 + W(8, -1116025261, -1105559165, -1102924251, -1098269094)
		 + W(9, -1109857889, -1121960158, -1133406593, -1137769344)
		 + W(10, -1113369587, 1024463101, -1120327001, 1015141868)
		 + W(11, -1129934237, -1114359336, 1018102856, -1124738995);
	sum2 =
		W(0, 1012167794, 975711915, 1007876102, -1112492311) + W(1, 1037438381, -1104922990, 1035896848, -1129478003)
		+ W(2, 1034293816, -1103749327, 1042152488, 1032768248) + W(3, 1026775674, -1112883791, 1009005510, 1029694272)
		+ W(4, 1040949842, -1105000392, -1113573827, 1065119806)
		+ W(5, 1049707133, -1118855570, 1019305156, -1105233202)
		+ W(6, -1073125242, -1097051670, 1048636347, 1064777150) + W(7, 1035198208, 1049268872, -1110039318, 1045598091)
		+ W(8, -1098861131, 1026609280, -1103172582, 1028248806) + W(9, 1042916747, -1108803486, 1037762592, 1002108025)
		+ W(10, 1034317546, -1107080190, 1037196612, -1106667446)
		+ W(11, 1024046979, -1112062411, 1031133421, -1116379320);
	WS(1002542528, -1081598301);
	sum1 = W(0, -1123106403, 1003194766, -1115291860, -1120609928)
		 + W(1, 1033033375, -1104418325, 1031657633, -1140694509)
		 + W(2, 1018532849, 1031358712, -1100442248, -1102109750)
		 + W(3, -1124327881, 1022719310, 1042404749, -1173350542) + W(4, 1058293919, 1048723343, 1060312385, 1065191364)
		 + W(5, 1057579241, 1055391647, 1048926634, 1057234642)
		 + W(6, -1096563748, -1102943230, -1084853826, -1082116255)
		 + W(7, -1090047916, -1090520747, -1115672903, -1088607906)
		 + W(8, 1033211315, 1043311017, -1122032382, 1048832547) + W(9, 1045565001, 1034840623, 1040065984, 1034960904)
		 + W(10, -1104454821, 1033034550, -1105126162, -1093430837)
		 + W(11, 1033480943, -1104668395, 1041617645, -1100859732);
	sum2 =
		W(0, -1118979564, -1136455954, 1031647880, -1098733088) + W(1, 1032618663, -1115252794, -1105564107, 1028338874)
		+ W(2, 1038135851, -1098903542, 1043936541, -1095471090)
		+ W(3, -1114646115, 1050331000, -1107943513, 1030299514) + W(4, 1040555036, -1113356687, 1041172918, 1058853402)
		+ W(5, -1111675314, 1042547849, -1102521857, 1048036907) + W(6, 1046730291, -1091503884, 1053446821, 1057969905)
		+ W(7, 1026777488, 1032649026, -1097022326, 1045220138)
		+ W(8, -1098841046, 1033064908, -1105844234, -1107613268)
		+ W(9, -1104403193, -1109177822, -1106932655, -1104926499)
		+ W(10, 1010901456, -1105119573, 1050988870, -1096003667)
		+ W(11, 1040941647, -1135105484, -1111654963, 1015146572);
	WS(-1089089900, 1057806976);
	sum1 = W(0, -1107295812, -1127595840, -1123024597, -1107414907)
		 + W(1, 1016079705, -1114511976, -1121404144, -1120167114)
		 + W(2, 1034138799, 1025412102, 1036945929, 1043589025) + W(3, 1048626936, 1026901142, -1122208804, -1132433569)
		 + W(4, -1095422036, -1098433268, -1092642698, -1086058047)
		 + W(5, -1087422851, -1090938821, -1099844512, -1092394401)
		 + W(6, 1050726826, -1189029283, 1055732365, 1066834483) + W(7, 1060391966, 1050840209, 1046023279, 1054523402)
		 + W(8, 1041715821, -1122343505, -1122551116, 1012137296)
		 + W(9, -1112593208, 1032081267, 1025525231, 1034856335)
		 + W(10, -1107540610, -1114195981, 1004508092, -1123010964)
		 + W(11, 1021997657, -1116540066, -1117735535, -1140325311);
	sum2 = W(0, -1100068589, 1040406565, -1105732125, -1129255625)
		 + W(1, -1110986904, 1041854514, -1108063740, 1040297872)
		 + W(2, 1045053907, -1112537807, 1034765996, -1096936254)
		 + W(3, -1098576495, -1119869595, -1108123574, -1106886121)
		 + W(4, 1035618626, -1097933278, -1099579155, 1047111871) + W(5, 1056019034, -1119227686, 1029490732, 996712344)
		 + W(6, 1049401249, -1091711434, 1056573344, 1055190008)
		 + W(7, 1058665437, -1092612461, -1121089271, -1113107096)
		 + W(8, 1036897142, 1040848725, -1089717374, 1050298277)
		 + W(9, -1089302244, 1058580142, -1127874601, -1110437244)
		 + W(10, -1103084156, 1039746012, 1030295740, -1110783667)
		 + W(11, 1041764164, -1100808273, 1022690203, 1034569294);
	WS(1049963735, -1124746024);
	sum1 = W(0, 1006389467, 991131306, -1124991168, 1036315168) + W(1, -1114080443, 1034164414, -1168983685, 1034869786)
		 + W(2, 1034213253, -1110639240, -1124116580, -1106688436)
		 + W(3, 1016950458, 1034354600, -1118357326, 1046100667) + W(4, 1058411598, 1049374726, 1060442825, 1064243752)
		 + W(5, 1058630778, 1057235431, 1051622657, 1028310995)
		 + W(6, -1089111694, -1111102680, -1086690096, -1080857842)
		 + W(7, -1086343400, -1086990857, -1099687954, -1090257402)
		 + W(8, -1120169982, 1039576302, 1018630958, 1032153615) + W(9, 1034713638, 1036089759, 1035150121, -1126482082)
		 + W(10, 1033778855, -1134195605, -1122058050, 1024033695)
		 + W(11, 1016006830, 1017381585, 1027377121, -1130216101);
	sum2 =
		W(0, -1114775505, 1022693528, 1033686534, -1159675846) + W(1, -1112709023, 1033838002, -1125624388, 1032684170)
		+ W(2, -1111353121, 1040828458, -1108626677, -1179590680)
		+ W(3, 1041114289, 1028829848, -1108121837, 1037026782) + W(4, 1051023520, 1041444385, -1101109690, -1089609004)
		+ W(5, -1101828769, 1037546580, 1033655640, -1104771455)
		+ W(6, 1077280281, 1083159907, -1090827263, -1064966677)
		+ W(7, -1073695373, -1090323484, 1042738654, -1104201752)
		+ W(8, 1042396970, 1039028690, -1129576724, -1146898193)
		+ W(9, -1117377551, 1046069066, -1098820901, 1049907200)
		+ W(10, -1100155636, 1038899070, -1108327399, -1128357112)
		+ W(11, 1026559236, 1017563688, -1149039617, -1119733667);
	WS(-1082925548, -1131273240);
	sum1 =
		W(0, -1130676005, 1024417890, -1127912110, -1123681912) + W(1, -1128802908, 1009745483, 1030244593, -1124372951)
		+ W(2, 1028984921, 1026031368, 1046418962, 1048544370) + W(3, 1032747842, -1115143804, 1035809011, 1012870858)
		+ W(4, -1090453298, -1094705109, -1088411833, -1080625999)
		+ W(5, -1078821070, -1093720869, -1115224705, -1099806226)
		+ W(6, 1056020338, 1048479050, 1054709085, 1056570469) + W(7, 1060414079, 1058018725, 1048613352, 1053689379)
		+ W(8, 1036092472, 1026370227, 1040943828, 1016526011) + W(9, -1134933227, -1146727344, -1126383553, 1034696072)
		+ W(10, 1031745797, 1023514525, -1139610597, 1039178347)
		+ W(11, -1115579031, 1033865376, -1123856496, 1032018765);
	sum2 = W(0, -1117505397, -1126832117, -1116692107, -1107644007)
		 + W(1, -1117458583, -1123105101, -1117032217, 1004815486)
		 + W(2, -1114926763, -1140231915, -1125548157, -1125354742)
		 + W(3, 1042669208, 1027773818, -1115355410, -1119603373)
		 + W(4, 1048798551, -1146496262, 1045683415, 1053833339)
		 + W(5, 1057710126, 1032098567, -1100115369, -1110288078)
		 + W(6, -1102904639, -1113101086, -1125191934, 1000279686)
		 + W(7, -1104919217, -1107525999, 1032507221, -1103622420)
		 + W(8, 1025448640, -1129185935, 1034411663, -1120274227) + W(9, 1041220979, 1022009255, 1021108475, 1039592007)
		 + W(10, -1112830121, -1125809392, -1121525964, -1113082203)
		 + W(11, -1111650191, 1035574395, -1112638630, -1117835672);
	WS(-1089340204, 1064822548);
	sum1 =
		W(0, 1024560260, 1017532199, 1036465700, 1032538389) + W(1, 1031720480, 1035008482, 1020865894, 1041385023)
		+ W(2, 1040632746, -1123651609, 998268921, -1115892569) + W(3, -1109887627, 1033415588, -1112010572, 1043778521)
		+ W(4, 1042654740, 1053882699, 1058440180, 1062655475) + W(5, 1057084090, 1054084900, 1046711885, 1050203279)
		+ W(6, -1106019185, -1094337163, -1083627654, -1081203240)
		+ W(7, -1087921069, -1086686700, -1098821294, -1083224116)
		+ W(8, -1121721479, 1033472482, -1112650528, 1042941034) + W(9, 1046201917, 1038013786, 1039144481, 1043447032)
		+ W(10, 1037194524, 1028050126, 993325743, 1013010462) + W(11, 1035154240, 1021897635, 1027972046, -1131974615);
	sum2 =
		W(0, -1108565409, 1041490776, -1103680498, -1113858207) + W(1, 1018958125, -1139146344, 1024460115, -1111959213)
		+ W(2, 1034353453, 1018486577, -1113519263, 1052082200)
		+ W(3, -1097140178, 1046768714, -1098207895, -1128703602)
		+ W(4, -1088688588, -1105841420, 1037914109, 1062919581) + W(5, -1095558118, 1049328132, 1041960027, 1035231667)
		+ W(6, 1053209723, -1092734414, -1094792328, 1049986423)
		+ W(7, -1107726366, 1044527939, 1046336394, -1110040773) + W(8, 1049996954, 1039814215, 1034343810, 1012724150)
		+ W(9, -1098318745, 1024888668, -1106186917, 1036710347)
		+ W(10, -1107721619, -1122233136, -1116717915, 1040029087)
		+ W(11, 1007719490, -1100531711, 1037888927, -1102670680);
	WS(-1083458668, -1076208878);
	sum1 =
		W(0, 1028803476, -1119221604, -1136427363, 1033962333) + W(1, -1108948664, 1041264181, -1108358441, 1032628870)
		+ W(2, 1040683401, -1097616301, 1042493937, -1106128994)
		+ W(3, -1096558041, 1044433886, -1097860853, -1123751924) + W(4, 1046406904, 1051879501, 1058517387, 1062475632)
		+ W(5, 1061490456, 1053313566, 1049919352, 1054299289)
		+ W(6, -1098733730, -1093169213, -1088547874, -1086787145)
		+ W(7, -1088927588, 1035939910, -1096390160, -1130402734)
		+ W(8, 1004468631, -1110693690, 1024040880, 1045297574) + W(9, 1028806548, 1038834422, -1095128350, -1106314264)
		+ W(10, 1030855367, -1111140815, -1127640694, -1108587948)
		+ W(11, -1104411844, 1040762412, -1118015030, -1165494119);
	sum2 = W(0, 1016611708, 1037888148, -1105282980, 1016374797)
		 + W(1, -1146676672, -1118267731, -1130451858, 1032410610)
		 + W(2, 1016478676, 1037533502, 1012928145, 1042320298)
		 + W(3, -1119445205, -1133007186, -1123652878, -1114217777)
		 + W(4, -1110195557, 1036667983, -1126800264, -1123884642)
		 + W(5, -1097480948, -1111241984, 1039970164, 1039354964)
		 + W(6, -1101004152, 1029018929, -1092116144, 1048907311) + W(7, 1063932318, 1045206632, 1051255124, 1032089604)
		 + W(8, 1040169462, 1051795874, 1041335879, 1052196876)
		 + W(9, -1105880602, -1088285853, -1095104183, -1090379026)
		 + W(10, -1128480930, -1116498505, -1105668811, -1110762465)
		 + W(11, -1096424000, 1016609657, 1029046774, 1046489649);
	WS(-1104670894, -1131977046);
	sum1 = W(0, -1112648188, -1122872327, 1034658686, -1105196647)
		 + W(1, 1040705957, -1105551222, -1121117111, 1017793890)
		 + W(2, -1127207577, 1044660591, -1159198685, -1091967838)
		 + W(3, 1050515731, -1105182655, -1127322710, 1049557794) + W(4, 1054983097, 1050049705, 1055452918, 1062208630)
		 + W(5, 1055187309, 1051606290, 1047450666, 1052382814)
		 + W(6, -1088875575, -1112061830, -1088327234, -1080890076)
		 + W(7, -1103107959, -1088400827, -1103254713, -1097595959)
		 + W(8, 1031188251, 1037435556, 1047857485, 1027642075) + W(9, 1054501223, -1109004816, 1042878098, 1041414585)
		 + W(10, -1103988635, 1027063042, -1117747167, -1097581231)
		 + W(11, 1026629396, -1115427963, -1119280070, -1121163375);
	sum2 = W(0, 1016354951, -1117974191, 1039379806, 1055799129) + W(1, 1043516685, 1037116388, 1033575170, -1131729016)
		 + W(2, 1027513536, 1035918257, 1037237024, -1144611727) + W(3, 1028380863, 1042440009, -1106882882, 1025801393)
		 + W(4, -1143898815, 1029824032, -1103985849, -1097216592)
		 + W(5, -1106760625, -1103814691, -1123395355, -1136138683)
		 + W(6, -1120711631, 1038928177, -1101088822, -1097673825)
		 + W(7, -1124050651, -1105579212, 1026359109, 1011024469)
		 + W(8, -1121835937, -1110582057, 1009730353, 1040607236)
		 + W(9, -1115312251, 1038947942, -1135830635, -1112603972)
		 + W(10, 1011202413, 1027020738, -1113735870, 1044957698)
		 + W(11, -1114960631, 1027787831, -1133116095, 1008198659);
	WS(-1096559831, 1037484900);
	sum1 = W(0, 1028249855, -1134487991, 1034313250, 1016173128) + W(1, 1027417370, 1028347039, 1000575210, 1035635068)
		 + W(2, 1038422322, 1027879764, 1029515489, -1112460521)
		 + W(3, -1107825326, -1123304579, 1030471249, -1120703806)
		 + W(4, 1057397273, 1048869250, 1056640275, 1065757625) + W(5, 1058322735, 1054334819, 1052511918, 1052376319)
		 + W(6, -1091437192, -1098773026, -1086850776, -1083502823)
		 + W(7, -1083394976, -1089694535, -1098313541, -1102551488)
		 + W(8, -1101563608, 1029769503, -1127965876, -1131269971)
		 + W(9, 1044386388, -1107441417, 1031752252, -1098473097)
		 + W(10, 1033785689, 1031362249, -1173649736, -1128247556)
		 + W(11, 1035484541, -1132373103, 1034873120, -1142130892);
	sum2 = W(0, -1112511339, 1040888051, 1033770332, 1027239578)
		 + W(1, -1109060021, -1135961020, -1113507810, -1110941727)
		 + W(2, -1073555081, -1070793862, -1069228230, -1071158503)
		 + W(3, -1080567434, 1047598893, 948656059, -1129804625) + W(4, 1076402541, 1075658117, 1075655149, 1077820889)
		 + W(5, 1045918702, -1118850699, 1035044244, 1026016583) + W(6, -1104998932, 1054215981, 1042820552, 1046227202)
		 + W(7, -1095422364, -1101978428, 1045389579, -1103164541)
		 + W(8, -1101584674, -1115233903, 1010151672, 1035248614)
		 + W(9, 1038949494, 1049027220, 1028467783, -1118124613) + W(10, 1037626737, 1015165170, 1023929473, 1033175695)
		 + W(11, 1025525751, 1032251645, -1117328038, 1042587545);
	WS(-1081931126, 1073966570);
	sum1 =
		W(0, -1121849711, -1146361331, 1017322599, -1106692309) + W(1, 1025148299, -1106210884, 1006422511, -1115138804)
		+ W(2, 1035175459, -1097410109, 1043585907, -1120101763) + W(3, 1050307440, 1038219466, 1023773090, -1132131774)
		+ W(4, -1121951547, 1026127169, -1144746721, -1091000962)
		+ W(5, -1079735571, -1091953433, -1096168868, -1102445962)
		+ W(6, 1027761070, 1045225025, -1106255910, 1065386286) + W(7, 1061827739, 1056380469, 1049682211, 1046599772)
		+ W(8, 1025905706, 1037511592, 1043091875, -1111228857) + W(9, -1120837551, -1102991437, 1003336935, 1040799505)
		+ W(10, -1114686833, -1113648733, 1017686828, -1108319001)
		+ W(11, 1018597782, -1147707682, -1110127893, 1028136822);
	sum2 =
		W(0, -1106398945, 1034732755, -1136096426, -1116038033) + W(1, 1044672515, -1100200943, 1037208365, 1025870712)
		+ W(2, 1035173169, -1090565718, 1037348813, -1089313148)
		+ W(3, 1037418911, 1045738761, -1130864309, -1117649125)
		+ W(4, -1101335301, 1056357842, -1122254044, 1066071262)
		+ W(5, -1095175639, -1132458755, 1007521414, 1025322164) + W(6, 1053305068, 1050400788, 1036743473, 1057700465)
		+ W(7, -1084949846, 1003355997, 1030076164, -1106413087)
		+ W(8, -1121291886, -1115544374, -1105444760, -1086616818)
		+ W(9, 1050477957, -1102270714, 1045722667, 999303933) + W(10, -1109509581, -1107192051, 1016457143, 1022772267)
		+ W(11, 1033704361, 1035291569, -1111299866, 1024551876);
	WS(1052508503, 1065718149);
	sum1 = W(0, 1042149474, -1109127212, 1041796883, 1033122295)
		 + W(1, -1120120612, 1045736850, -1110374755, 1038133568)
		 + W(2, 962035242, -1098223900, 1027445007, -1108112926)
		 + W(3, -1098175173, 1043181559, -1100319159, -1102543586)
		 + W(4, 1048663227, 1043423478, 1055339346, 1061167739) + W(5, 1054196775, 1055761732, 1041284046, 1051299336)
		 + W(6, -1097510801, -1096660204, -1087758861, -1089406218)
		 + W(7, -1094841886, -1105769888, -1103555357, -1120191499)
		 + W(8, 1028239019, -1104342914, 1027971236, 1037128774)
		 + W(9, -1105773058, 1042761157, -1101757237, -1105847257)
		 + W(10, 1038442493, -1109357577, 1040109559, 1025450507)
		 + W(11, -1123303012, 1044237597, -1111907879, 1039590240);
	sum2 =
		W(0, -1109097964, 1021868522, 1007318978, 1032613655) + W(1, 1002517286, -1126879582, 1031113174, -1114937810)
		+ W(2, 1037136687, -1116667451, -1107845433, -1109068920)
		+ W(3, 1016069779, -1103760436, 1030143702, -1118059752) + W(4, 1031673749, -1094712046, 1038331125, 1040720319)
		+ W(5, -1111158812, 1056111085, -1106358629, -1121843086)
		+ W(6, -1125393555, 1041352693, 1034962829, -1112580519)
		+ W(7, -1106409067, -1106729155, -1106975050, 1047380650)
		+ W(8, 1019467600, -1104433838, -1122570447, -1121851072)
		+ W(9, -1113430896, 1049773824, 1036295980, -1122235886) + W(10, 1025995330, 1008084051, 1039892459, 1025598855)
		+ W(11, 1045465420, -1110468674, 1020538422, -1113447212);
	WS(1056997868, 1008833773);
	sum1 = W(0, -1118496039, 1036420187, -1113594582, 1034344230)
		 + W(1, 1038393121, -1109888100, 1032434307, -1131937728)
		 + W(2, 1006806901, -1130107576, -1115019369, 1045363911)
		 + W(3, -1090717022, 1037930126, -1110427933, -1112104883)
		 + W(4, 1039826714, -1123687353, 1053157409, 1059756929) + W(5, 1058230383, 1045739824, 1042446790, 1052782212)
		 + W(6, -1123143270, -1104570591, -1093231896, -1095316624)
		 + W(7, -1095564524, -1098051412, -1101398261, -1104229594)
		 + W(8, 1006039247, 1032886196, -1105180689, -1102708199)
		 + W(9, 1035814292, -1129186168, 1025625861, -1112516090)
		 + W(10, 1017005492, -1125702370, 1028719950, 1009228202)
		 + W(11, -1119964195, 1033820442, 1028568173, -1136905401);
	sum2 =
		W(0, 1034320453, -1112051735, 1043966073, 1033608293) + W(1, -1092579307, 1051236380, -1102939053, 1027336318)
		+ W(2, -1118604595, -1109468006, -1106879339, -1088213587)
		+ W(3, 1064370547, -1095838484, 1043763107, 1016664388) + W(4, 1025235375, -1107232926, 1049289065, 1067079268)
		+ W(5, -1088486363, 1044420987, -1107783352, -1116658227)
		+ W(6, 1028595208, 1046387359, 1044354198, -1087106166) + W(7, -1108961766, -1104528882, 1035658672, 1023955051)
		+ W(8, 1002638229, -1105038970, 1045499601, 1035867996)
		+ W(9, -1096457250, 1028839698, -1122532695, -1126291119)
		+ W(10, -1116609216, 1005965131, -1111658272, -1132447732)
		+ W(11, 1042442572, -1134350406, -1131375963, -1135660575);
	WS(1064849644, -1092967401);
	sum1 =
		W(0, 1041078624, -1103081652, 1045204674, -1126422222) + W(1, -1107755791, 1049230600, -1101861336, 1041473799)
		+ W(2, 1033930742, 1034184171, -1098756264, 1038407355)
		+ W(3, -1103118957, -1103625882, 1035198826, -1102710964) + W(4, 1053270962, 1058076017, 1059044453, 1061713418)
		+ W(5, 1064682577, 1047988615, 1055582710, 1058355518)
		+ W(6, -1091277968, -1091900963, -1097334921, -1078564449)
		+ W(7, -1099822850, -1091654943, -1096942230, -1098047297)
		+ W(8, -1115974645, -1101902009, 1038364767, 1031099397) + W(9, 1025967234, 1010917525, 1021900159, -1106099948)
		+ W(10, -1124489961, 1046377811, -1096742869, 1034335299)
		+ W(11, 1015202107, -1098744549, 1047801952, -1101582418);
	sum2 =
		W(0, 1034970587, -1105865147, 1024111791, 1018431373) + W(1, -1107243650, 1038385161, -1114574492, -1129893537)
		+ W(2, 1039267337, 1026053125, 1040193826, 1037956157) + W(3, -1106797747, 1031902437, -1114137980, -1128932411)
		+ W(4, -1109640195, 1027743203, 1042644379, -1088412806)
		+ W(5, -1104275404, 1031274183, -1115379021, 1040558376)
		+ W(6, -1085205368, -1076908464, -1072741915, -1079896887)
		+ W(7, 1057561219, 1052902509, -1103620900, 1054347378) + W(8, 1065312771, 1068235631, 1074530244, 1069229068)
		+ W(9, -1110308581, 1045193510, -1167188013, -1099424233)
		+ W(10, -1111782462, 1029167111, 1035172075, 1048206286)
		+ W(11, -1092973955, -1105822229, -1102796809, -1106619819);
	WS(-1085552428, 1044647857);
	sum1 = W(0, -1130568573, -1111247047, 1001536536, -1104704953)
		 + W(1, 1029690778, -1104108900, 1012447989, -1107166286)
		 + W(2, -1120131932, 1046596325, 1026932885, 1049575094)
		 + W(3, 1042872064, -1127841478, -1114289465, -1110288351)
		 + W(4, -1097293585, -1095715202, -1090361246, -1085535724)
		 + W(5, -1105723034, -1113844876, -1127895515, 1028149942)
		 + W(6, 1052681344, 1050957098, 1059711152, 1060788917) + W(7, 1048249845, -1106926654, 1034645781, 1043016176)
		 + W(8, -1115182247, -1125685565, -1097304503, -1122898434)
		 + W(9, -1115360055, 1050188162, -1110595670, 1041406167)
		 + W(10, 1016796643, -1123522377, 1028362085, -1112833505)
		 + W(11, 1008149481, -1111804152, 1032897312, -1119471349);
	sum2 = W(0, 1049638564, 1012096208, 1055008508, 1058022553) + W(1, 1059601221, 1065544846, 1035938200, 1043980555)
		 + W(2, -1122573304, -1169058693, -1092917400, -1080721407)
		 + W(3, -1081684685, -1080284825, -1096574070, -1098850345)
		 + W(4, -1097365817, -1118822370, -1124083512, 1056959548)
		 + W(5, 1056508637, 1051359763, 1044088441, 1031681402) + W(6, -1120650912, 1032693677, -1127709292, 1044260765)
		 + W(7, -1099806388, 1042746095, 1033735876, -1121369890)
		 + W(8, 1039129637, 1036528332, -1113518885, -1122124802)
		 + W(9, 1019567420, -1101554026, 1041548497, -1108142320)
		 + W(10, -1114566411, -1119534724, 1015256750, 1042163670)
		 + W(11, -1110975736, 1032382474, -1110809702, 1022534793);
	WS(1049904727, -1085461498);
	sum1 = W(0, -1114441151, 1032673159, 1027012354, 1041600521) + W(1, 1035856141, 1033107055, 1031163069, -1139856090)
		 + W(2, 1047758995, -1122472531, 1048177385, -1116753522)
		 + W(3, -1105032264, -1109908945, -1104848436, -1111353615)
		 + W(4, -1092338425, -1101190388, -1096531431, 1059669870)
		 + W(5, 1063099682, 1058897901, 1049115478, 1055941567) + W(6, 1054893264, 1042608805, 1050188989, -1088410395)
		 + W(7, -1084283112, -1088007491, -1096369309, -1096366496)
		 + W(8, -1095327506, -1108884127, -1104987150, -1123782065)
		 + W(9, 1042263123, 1042892731, 1029697804, 1047202227)
		 + W(10, 1042581180, -1119554504, 1041262473, -1120686401)
		 + W(11, -1117364890, -1107384925, -1138499405, -1100444021);
	sum2 =
		W(0, -1101934313, -1127864237, -1112463889, 1047304216) + W(1, -1097499627, 1041678537, -1128505773, 1039199998)
		+ W(2, 1068410613, 1066297935, 1052441146, -1077079694)
		+ W(3, -1082290320, -1095668928, -1097722710, -1096167330)
		+ W(4, 1053392914, 1047339448, -1111508378, 1044634164) + W(5, -1086326188, 1053023843, 1050833435, -1112581958)
		+ W(6, 1045964051, -1107136628, 1035674775, 1046050296) + W(7, -1113442140, -1135364198, 1028981469, 1028034745)
		+ W(8, -1109754454, 1023924243, -1121555471, -1111827987)
		+ W(9, 1006763480, 1034831467, -1128234727, 1032814306)
		+ W(10, -1118726053, 1029832629, -1111696115, 1036477638)
		+ W(11, -1119582249, 1024856185, -1112331027, 1017921306);
	WS(-1087326956, 1033622098);
	sum1 =
		W(0, -1113899675, 1035193378, 1030557818, -1119324954) + W(1, 1042470612, -1117399605, 1021883592, 1035419591)
		+ W(2, 1045896801, -1161971013, 1045303135, -1095480777)
		+ W(3, -1110770003, -1109576477, -1100233714, -1122013269)
		+ W(4, 1041409216, -1108871427, -1104804773, 1041468886) + W(5, -1098059200, 1052050234, 1041862393, 1017834329)
		+ W(6, -1108955706, 1048600721, -1094955846, 1051943793)
		+ W(7, 1025944442, -1097508910, 1030612641, -1106071902)
		+ W(8, -1104543128, -1114333163, 1045266364, -1096626659)
		+ W(9, 1048775867, 1043056710, -1122051827, 1042839849)
		+ W(10, 1041055226, -1106692192, 1039063182, -1112593372)
		+ W(11, -1107180444, 1041486173, -1114362202, -1121041260);
	sum2 =
		W(0, 1008283263, -1114415273, -1114655921, 1036167174) + W(1, -1111159985, 1033204129, -1122340118, -1127458940)
		+ W(2, -1111634453, 1032259795, -1123951654, -1116061542)
		+ W(3, 1039368345, -1102899145, 1024476440, -1118949310) + W(4, -1112224655, 1046234660, 1039099048, 1049934438)
		+ W(5, 1003410015, -1113540553, -1117681522, -1122317014)
		+ W(6, -1121896666, 1020399084, -1139717487, 1050902690) + W(7, 1039007446, 1039510238, 1032062517, 1033150391)
		+ W(8, 1031996897, -1105304684, 1017260660, -1102142181) + W(9, 1003551903, -1114854307, 992233789, -1113963477)
		+ W(10, -1106176579, 1027107696, -1106922258, 1022104088)
		+ W(11, -1122048418, -1135188919, -1128403972, -1125862176);
	WS(1068173014, -1111006676);
	sum1 =
		W(0, 1031049568, -1115395480, 1019703498, -1113567107) + W(1, 1015808760, -1109811912, 1027899359, -1103105894)
		+ W(2, -1103201566, -1112513259, -1112438249, 1042819653) + W(3, 1048780036, 1039150546, 1034094633, 1040353932)
		+ W(4, 1048004603, -1117860850, -1104427535, -1083606526)
		+ W(5, -1083053360, -1090564527, -1092330682, -1095220995)
		+ W(6, -1100468360, -1173290307, 1042677725, 1064316383) + W(7, 1063571221, 1060600586, 1050639762, 1054475004)
		+ W(8, 1046039773, -1123264224, 1030284012, -1122621123)
		+ W(9, -1094902185, -1103353426, -1106486660, 1034806311)
		+ W(10, 1012485196, -1127850837, 1029876039, 1036820754)
		+ W(11, 1035184606, 1024997805, -1149057999, -1123061719);
	sum2 =
		W(0, 1014853092, -1120466254, 1027909890, -1117512854) + W(1, 1026011110, -1110873488, 1036041188, -1115497806)
		+ W(2, -1122580470, -1114547761, 1030745116, -1119656010)
		+ W(3, 1035574738, -1120221385, 1020780404, -1122615179) + W(4, -1120994367, 1038991680, 1034511499, 1041066172)
		+ W(5, -1109149586, 1024235728, -1112980367, 1020521688)
		+ W(6, 1047459793, 1047680543, -1098401240, -1121088174) + W(7, 1045982327, 1024310650, -1122000913, 1042402937)
		+ W(8, 1064875701, 1054395623, 1045153300, -1085223893)
		+ W(9, -1084582209, -1099510820, 1029465320, -1105747852)
		+ W(10, -1132455031, 1011283964, -1108441710, 1018552602)
		+ W(11, -1106692167, 1026658994, 1023023932, 1004613671);
	WS(-1095915991, 979918868);
	sum1 =
		W(0, -1115463727, -1137886897, 1011021190, 1011860489) + W(1, -1129491953, 1007409140, -1124741815, -1122228982)
		+ W(2, 1032823819, 1037523161, 1029800132, 1043477300) + W(3, -1105888052, -1114264129, 1021218335, 1030459197)
		+ W(4, 1026707497, -1131549790, -1108429845, -1100874368) + W(5, 1047336484, 1049886943, 1042964547, 1038061098)
		+ W(6, -1119898332, 1035412665, -1136100063, -1112838682)
		+ W(7, -1098267600, -1097768883, -1106237874, -1108915952)
		+ W(8, 1026568544, -1108324895, -1138504034, 1047390560) + W(9, 1036689246, 1037432366, 996441389, -1121991146)
		+ W(10, -1121143952, -1129452238, -1120493188, -1147670274)
		+ W(11, 1028096953, -1134502280, -1157333673, -1177453050);
	sum2 = W(0, -1121902268, -1128394666, 1039974898, -1114856664)
		 + W(1, 1032116923, -1115163450, -1112859101, -1128925353)
		 + W(2, 1020062213, -1143339877, -1102502778, 1034423857) + W(3, 1030950002, 1038088024, 1036537682, 1019282123)
		 + W(4, 1034601005, -1111450467, 1034366199, -1093114037)
		 + W(5, 1027196884, 1036157347, -1130356560, 1032717961)
		 + W(6, -1096503308, 1052764693, -1095299550, 1060522961)
		 + W(7, 1057088106, -1104371255, 1031719642, -1110891365)
		 + W(8, 1050858947, -1099720262, 1055940597, -1087523263)
		 + W(9, -1085850393, -1107617878, -1119144319, 1017512699)
		 + W(10, -1108630019, -1130142915, -1105816149, 1037139152)
		 + W(11, 1054601799, 1043807995, -1122652165, 1025497552);
	WS(1066530838, 1025703389);
	sum1 =
		W(0, -1120765920, 1009297086, -1122351141, 1015487755) + W(1, 1015844344, -1127613121, -1133586812, -1124468594)
		+ W(2, -1132051981, -1139418709, -1109474502, -1098776251)
		+ W(3, -1109199593, -1123764613, -1121408403, -1145136640)
		+ W(4, -1129191897, 1032587897, 1057153612, 1049522345) + W(5, 1041525985, -1109817213, 1010121533, -1107128582)
		+ W(6, 1042371592, -1118415861, -1120712699, -1099055070) + W(7, 1049700744, 1050593755, 1036084166, 1038803505)
		+ W(8, 1007708012, -1122811552, -1105657359, -1099127683)
		+ W(9, -1111888320, -1113004743, 984437698, 1036904923)
		+ W(10, -1116932051, -1134432681, -1127344014, 1026629028)
		+ W(11, -1119906716, -1136900213, -1118848634, -1123829719);
	sum2 = W(0, -1117430114, 1039120940, -1106133189, 1026507473)
		 + W(1, 1031550625, -1142215401, 1026312489, -1139250704)
		 + W(2, 1041261247, -1107749198, -1099018179, -1131506304)
		 + W(3, -1123617030, -1123190888, -1112954810, -1137414048)
		 + W(4, 1033806419, -1097831330, 1064523288, 1045711847)
		 + W(5, -1088977338, 1052831473, -1133526188, -1122137188)
		 + W(6, -1126022952, 1041137317, 1057416214, -1092069746)
		 + W(7, 1059767697, -1088761837, 1033531722, -1110686692)
		 + W(8, -1155381873, -1127685702, -1099691831, 1026250214)
		 + W(9, -1098651966, -1118397760, -1130823120, 1029280576)
		 + W(10, -1125967712, -1116954634, 1032736142, -1120045450)
		 + W(11, 1021746164, 1028302350, 990513889, -1115066264);
	WS(1066680246, 1040921440);
	sum1 =
		W(0, -1119730500, 1034101258, -1132236433, -1104735450) + W(1, 1035235184, -1111591250, 1024518355, -1121802685)
		+ W(2, -1110280861, 1011417444, 1027753539, 1038200908) + W(3, 1035268043, -1121734057, 1032771355, -1126371080)
		+ W(4, -1092083138, 1031601302, -1090607216, -1078665075)
		+ W(5, -1096046953, -1093429316, -1094352558, -1102572591)
		+ W(6, 1053565584, 1054599907, 1058261942, 1061430978) + W(7, 1061610294, 1056142824, 1053165350, 1055282545)
		+ W(8, -1110918026, -1143895330, -1111808624, -1099071584)
		+ W(9, -1106320677, -1105323662, -1138833863, 1035738553)
		+ W(10, 1029997623, -1113777127, 1039976245, -1112447940)
		+ W(11, 1023744576, -1145165385, -1113453535, 1031263347);
	sum2 =
		W(0, 1033717276, -1129082210, -1111396517, 1053521042) + W(1, -1096499765, 1041638909, -1115028859, -1143837439)
		+ W(2, 1028210443, -1130739278, -1117565460, -1113906791)
		+ W(3, -1106119849, 1044690885, 1000486481, 1015998178) + W(4, 1046091050, -1085374293, 1033058760, 1062822204)
		+ W(5, -1089123399, 1003636411, 1048601259, -1103883056)
		+ W(6, -1119519632, 1026401017, -1106338078, 1066908993) + W(7, 1034907371, 1054286387, -1096894542, 1041460877)
		+ W(8, 1050909876, -1110182528, -1149282827, -1081393742)
		+ W(9, -1094008056, 1035142168, 1020535023, 1028271260)
		+ W(10, -1117678961, 1042909501, -1099518378, 1044082334)
		+ W(11, -1097984366, 1040282994, -1109925208, 1021313035);
	WS(-1111691100, -1070453585);
	sum1 = W(0, 1040350706, -1107702492, 1045915011, -1103582444)
		 + W(1, 1036820082, 1030081641, -1112926972, 1034445457)
		 + W(2, 1032181048, 1006352113, -1101176752, -1098104500)
		 + W(3, -1111995209, -1105752467, -1111976126, 1025879721)
		 + W(4, 1054597571, 1056547603, 1059824936, 1062411659) + W(5, 1062112057, 1042786985, 1050598527, 1058122296)
		 + W(6, -1090063653, -1111618639, -1087007388, -1079908657)
		 + W(7, -1098160558, -1094958736, -1104521261, -1107753094)
		 + W(8, -1105977411, 1011306277, 1037450066, -1113612402)
		 + W(9, 1043358554, -1108376090, 1024420791, -1098378691)
		 + W(10, -1114266718, 1034245578, -1130610528, -1111998342)
		 + W(11, 1021846218, 1026051990, 1032139296, 1018599200);
	sum2 =
		W(0, -1102183736, 1045283790, -1099060082, 1029589699)
		+ W(1, -1103326288, -1146696619, -1123727405, -1106785078)
		+ W(2, 1044690091, -1117083441, -1109435037, 1005932683)
		+ W(3, -1109954065, -1130369043, -1115538567, 1039027144)
		+ W(4, 1025447267, 1036724432, -1100626978, 1066859805) + W(5, -1114206859, 1024539831, -1123732285, 1040901138)
		+ W(6, -1103679886, -1096666126, 935783211, 1061824774)
		+ W(7, -1098480165, -1113161303, -1109149493, -1129688427)
		+ W(8, 1034791609, 1043810354, -1097803022, 1034749891) + W(9, -1094988176, 1050252440, 1029732207, -1105144948)
		+ W(10, -1120655593, -1109094473, 1029730663, 1023292171)
		+ W(11, -1109570093, 1012313206, -1106431920, 1015686163);
	WS(-1105638574, -1077878805);
	sum1 = W(0, -1112101313, 1025565072, -1118212870, 1034991091)
		 + W(1, 1037618766, 1033034081, 1023523536, -1143864013) + W(2, 1043313362, 1041884710, 1045058176, -1099609869)
		 + W(3, -1100255017, -1097107341, -1104696333, -1128917761)
		 + W(4, -1104398291, -1093904634, -1086702118, 1055637093)
		 + W(5, 1061981800, 1053455331, 1048950646, 1037339676) + W(6, 1034529536, 1043314021, 1058479092, 1049084915)
		 + W(7, -1082434966, -1087005060, -1098585534, -1105402705)
		 + W(8, -1120033234, -1106696920, -1128822905, -1126325576)
		 + W(9, 1050170340, 1046293466, 1042248226, 1032623999) + W(10, 1017824488, 1028280843, 1038132788, -1136921361)
		 + W(11, -1125947450, -1124008918, -1126565485, -1114937252);
	sum2 =
		W(0, 1040832216, 1042032808, 1039550307, 1029252447) + W(1, 1040592387, -1111709033, 1050208698, -1091595987)
		+ W(2, -1125419559, -1103788280, 1043848052, -1099123277)
		+ W(3, 1047689572, -1102650535, -1105352144, 1033340873) + W(4, -1166596642, 1045241846, 1051795538, 1068949095)
		+ W(5, -1094163017, -1111700665, -1117027793, 1027304955)
		+ W(6, -1076839498, -1091833274, 1035730071, 1070654393) + W(7, -1096947569, 1050259859, 1051072204, 1048679723)
		+ W(8, -1085872442, -1105795498, -1094587067, 1007431650)
		+ W(9, -1089767553, 1041510738, -1100476212, 1057584085)
		+ W(10, 1038631745, 1037000995, -1115278352, -1103746979)
		+ W(11, 1041143367, 1025070825, -1116523862, -1093749689);
	WS(-1095944791, 1081861902);
	sum1 = W(0, -1129669743, -1116664839, -1148272609, -1121494877)
		 + W(1, -1115602986, 1028329496, -1123378150, 1027525168)
		 + W(2, 1034635115, -1122706061, 1033259121, -1124251544)
		 + W(3, -1126517523, -1128061368, -1130313237, -1119991479)
		 + W(4, 1057433596, 1048908041, 1058166921, 1058746094) + W(5, 1055593874, 1057488289, 1049860117, 1061071735)
		 + W(6, -1090131839, -1093164666, -1087001587, -1083481847)
		 + W(7, -1085306808, -1091485686, -1102755929, -1105495231)
		 + W(8, -1120322428, 1030509816, 1035303897, 1044900399) + W(9, 1041073282, 1023593721, 1034451003, -1102595129)
		 + W(10, 1008560041, 1023557506, 1013701241, -1117995899)
		 + W(11, -1116643091, 1023656437, -1164007844, 1024551167);
	sum2 =
		W(0, 1029670841, -1115575058, 1042858197, -1101600217) + W(1, -1117748556, 1035438169, -1114535210, 1032334939)
		+ W(2, 999172620, -1099435099, -1139359478, 1027943101) + W(3, 1048715384, -1098854617, 1036336651, 1041563473)
		+ W(4, 1042251423, 1041110640, 1058527193, 1075961547) + W(5, 1073424302, -1086643829, -1080060710, -1067239867)
		+ W(6, -1105031588, -1120449287, 1010020318, -1109667225)
		+ W(7, 1057314889, 1037113027, -1123725073, -1100548924) + W(8, 1027957701, 1035596553, 1019832195, 1011086126)
		+ W(9, 1033526397, 975610078, 1012557694, -1095465488) + W(10, 1026093121, -1156632055, -1126960339, 1010028142)
		+ W(11, 1037810339, -1115077778, -1133987070, 1036754195);
	WS(-1085172076, 1069147958);
	sum1 = W(0, 1025703205, -1141293989, 1041286826, -1119005195)
		 + W(1, 1026450561, -1117134469, -1120895076, 1025414366)
		 + W(2, 1027233863, -1106615031, -1115436126, -1112858253)
		 + W(3, 1042609938, -1122683754, 1044686038, -1117169125) + W(4, 1026640114, 1042354526, 1053740861, 1054852793)
		 + W(5, -1119314307, 1026745790, -1108709290, 1023400633)
		 + W(6, 1029190628, -1106775167, -1106293072, -1089581852)
		 + W(7, -1098775605, -1108063055, 1015550627, -1125318352)
		 + W(8, -1111659152, -1115892869, 1035182992, 1027435128)
		 + W(9, -1137028117, 1038436612, -1112739478, 1031194923)
		 + W(10, -1139375968, 1028377583, -1156734143, -1121669673)
		 + W(11, 1034668065, -1119291218, 1027259179, -1118201212);
	sum2 =
		W(0, -1154464437, 1004660066, 1011666487, 1016373458) + W(1, -1117096132, 1027534293, -1118720211, 1024315262)
		+ W(2, 1027039233, -1115032564, -1147080182, 975139636) + W(3, 1025013868, -1117310194, 1025607183, -1145025250)
		+ W(4, 1008089899, 1041471507, 1053281755, -1081313755) + W(5, -1118862913, 1040077608, -1134922624, 993302909)
		+ W(6, -1117609897, 1033488023, 1082321679, -1065846603)
		+ W(7, -1122974098, -1130639872, -1143672974, -1114202318)
		+ W(8, -1118717800, 1033628240, 1046901100, 1050032460)
		+ W(9, -1106934499, -1137731251, -1177023016, 1017914834)
		+ W(10, 1027401421, -1112728150, 1012824907, -1108305112)
		+ W(11, 1038621352, -1137500513, -1129758225, 1025570630);
	WS(1065820150, -1112682631);
	sum1 =
		W(0, -1105640672, -1136938293, 1007936778, -1099447769) + W(1, 1033964109, -1110772895, -1107676126, 948858222)
		+ W(2, -1140735040, 1045425461, 1012508339, 1052020966) + W(3, -1110876672, 1038536521, 1034428376, 1041035251)
		+ W(4, -1096706537, -1095619178, -1101065539, -1083835034)
		+ W(5, -1127256032, -1101414038, -1102412811, -1104437005)
		+ W(6, 1051064512, 1046810501, 1057299292, 1054321083) + W(7, 1044289505, 1042038046, 1050440565, -1126355329)
		+ W(8, -1114855500, 1041816072, 1015987827, 1049485320) + W(9, -1106506396, 1031650401, -1098866309, 1044647659)
		+ W(10, -1128129890, -1108472292, 1036938130, -1101761488)
		+ W(11, 1035708141, -1113134674, 1031811610, -1119496853);
	sum2 =
		W(0, -1116689599, 1033662400, -1110264521, -1113832562) + W(1, 1034493072, 1024644211, -1105470304, 1030330543)
		+ W(2, -1104060794, 1047714485, -1106889746, 1055059659) + W(3, -1089308922, 1027816870, 1032487381, 1043118546)
		+ W(4, 1023887631, -1101000300, -1123902349, 1047334183)
		+ W(5, 1060541265, -1145174230, -1099777158, -1100795602)
		+ W(6, 1047625619, -1113896185, 1058674488, -1105663288)
		+ W(7, -1079751447, 1040502911, 1059286709, -1110882655)
		+ W(8, -1104647113, 1049921725, -1100964722, 1060005487)
		+ W(9, -1088726381, 1026206299, -1093081927, 1033716355)
		+ W(10, 1032108768, -1114038586, -1134500667, -1105023935)
		+ W(11, 1046968990, -1116742649, 1042150309, -1127164330);
	WS(1051219671, 1032040132);
	sum1 = W(0, 1024246061, 1029213629, -1142580623, 1007533386) + W(1, -1132388626, 1016678619, 998523489, 1023830470)
		 + W(2, -1110293770, -1111062337, 1026027124, 1035026513)
		 + W(3, 1036422600, 1011246152, -1173422083, -1130424090)
		 + W(4, -1098745559, -1104763504, -1097349705, -1082429923)
		 + W(5, -1083869189, -1095610025, -1095350964, -1094623957)
		 + W(6, 1035978230, 1041701281, 1051781481, 1065410260) + W(7, 1060856625, 1057796630, 1045145830, 1055180598)
		 + W(8, 1050231066, -1106571859, 1040668770, -1111350032)
		 + W(9, -1113287631, -1122887388, -1109374678, 1007169387)
		 + W(10, -1111943280, 1016965359, 1026054164, 1035026168)
		 + W(11, 987392292, 1019565189, -1110518465, 1026555204);
	sum2 =
		W(0, -1123481859, 1024186334, -1181265672, -1136581772) + W(1, 1007273042, -1130526339, -1134191606, 1035801320)
		+ W(2, -1131096266, -1121050215, 1023491721, -1115413373)
		+ W(3, 1036272276, -1110187157, -1123342647, -1125507188)
		+ W(4, -1107023625, 1040345453, -1110082893, -1116173932)
		+ W(5, 1041634800, 1028205855, 1036476425, -1124495703) + W(6, 1040776673, -1129271163, 1044851152, -1097567007)
		+ W(7, 1051516690, -1106625929, 1035231370, 1007786534)
		+ W(8, -1073406322, -1080765061, -1077100552, -1085034176)
		+ W(9, -1104398720, 1019889879, -1115096299, -1105128420)
		+ W(10, 1074128739, 1066657253, 1068015119, 1066670217) + W(11, -1111857710, 1026394385, 990445793, 1030299973);
	WS(-1124324720, 1038677119);
	sum1 = W(0, 1008341069, 1031967089, 1023486232, 1037528348) + W(1, -1122921519, 1029849459, -1114006089, 1035528454)
		 + W(2, 1038389179, 993181316, -1145165264, 991007864) + W(3, 1024190949, 1044031254, -1123515526, 1052524910)
		 + W(4, 1056361124, 1050863173, 1054230472, 1063082151) + W(5, 1050043692, 1049660054, 1043779649, -1097977265)
		 + W(6, -1081451931, -1096246661, -1086637900, -1088130503)
		 + W(7, -1092787999, -1099337955, -1095996120, -1102904005)
		 + W(8, 1047683325, 1035916906, 1027831167, 1026128198) + W(9, 1020947750, 1025351359, 1037985981, -1114005272)
		 + W(10, -1130646284, -1134539381, 986748732, 1003368116)
		 + W(11, -1115252008, 1036720064, -1116396881, 1029521402);
	sum2 =
		W(0, 1042203848, -1133163156, -1108707706, 1027923803) + W(1, -1098359820, 1043843260, 1021888231, 1023965418)
		+ W(2, -1089098687, -1098025067, 1036383110, 1058285406) + W(3, 1062333205, 1048839159, 1058743586, -1078465930)
		+ W(4, 1035967917, 1052777785, 1043356562, 1046924897) + W(5, -1080913711, -1088408400, -1097507024, 1067915456)
		+ W(6, 1068788369, -1096461215, -1090569807, -1088764217)
		+ W(7, -1095261121, -1098396864, -1093746709, 1064748817)
		+ W(8, -1095505730, -1097973178, -1127034898, 1056967609)
		+ W(9, 1040836988, 1046078649, -1111389506, -1099047850)
		+ W(10, 1025788011, -1111191248, 1023876171, 1046203397)
		+ W(11, -1107189985, -1113219498, -1110869404, 1040158004);
	WS(-1080347734, -1094728165);
	sum1 = W(0, -1115633753, -1128052610, 996364134, 1027254679)
		 + W(1, 1027401421, -1125749028, -1143663749, 1017291157)
		 + W(2, 1036436624, 1031912915, 1038598142, -1114408211)
		 + W(3, -1097652239, -1109729611, -1111208674, -1118442418)
		 + W(4, -1113632799, -1104119121, -1095896866, 1064358521)
		 + W(5, 1061684826, 1051089073, 1044518984, 1048577269) + W(6, 1018734050, -1104173746, 1042956529, 1051156401)
		 + W(7, -1087880029, -1093838037, -1100689848, -1104163629)
		 + W(8, -1104273977, -1115038313, -1098511458, 1006576423)
		 + W(9, 1037804713, 1039011098, -1157246715, -1145301883)
		 + W(10, 1022550473, -1128796792, 1027191321, -1123707765)
		 + W(11, -1125317723, -1116369959, -1130384675, -1113863292);
	sum2 = W(0, -1137561210, 1008161562, -1138249722, 1032804591)
		 + W(1, -1118405314, -1149548391, -1140666666, -1121723310)
		 + W(2, 1000810292, 1017087401, -1104015266, 1045940061)
		 + W(3, -1112933693, 1040845572, -1131915309, -1125770861)
		 + W(4, -1109671087, -1143663956, -1100429296, 1064636422)
		 + W(5, 1041071232, -1095622064, -1113635957, -1156294183)
		 + W(6, -1098257975, -1088410023, -1110483119, 1065774501)
		 + W(7, -1111449957, -1114533177, -1105461804, -1154727079)
		 + W(8, -1113334223, 1033424863, -1113376685, 1041401738)
		 + W(9, -1107119710, 1041680128, -1114424843, -1143304660)
		 + W(10, 1010643898, -1122425914, -1120544050, 1015219657)
		 + W(11, 1028103016, -1125778629, -1127495397, -1128411685);
	WS(1062796012, -1081433938);
	sum1 = W(0, -1140258862, 1019305782, 1017521696, -1128637410)
		 + W(1, 1030042599, -1140240046, 1023786378, 1027083972)
		 + W(2, 1047697940, -1137205890, 1040574503, -1131514496)
		 + W(3, -1115750349, -1114177400, -1119424318, 1025144619)
		 + W(4, 1041493798, 1051824452, 1048941321, 1061551411) + W(5, 1058760695, 1056942277, 1045023263, 1056967544)
		 + W(6, -1090901033, -1095124244, -1090555023, -1084025976)
		 + W(7, -1089279069, -1089170928, -1099538126, -1087239225)
		 + W(8, 1032453887, 1034552166, 1032035723, 1036871279) + W(9, 1041251643, 1032547975, -1117686145, 1027338481)
		 + W(10, 1008978681, 1031420374, -1124609380, 1025475023)
		 + W(11, 1016399695, 1024887097, 1002611913, 1012109898);
	sum2 =
		W(0, 1004838046, 1009005547, 1023830295, -1121204348) + W(1, 1026709605, -1145957446, 1024434367, -1122812157)
		+ W(2, 1036867068, -1112484311, 1034701810, -1131856601)
		+ W(3, 1008859907, -1129570235, -1120209470, 1023686531)
		+ W(4, 1023348885, -1113333873, -1115269491, -1084820204)
		+ W(5, -1095888786, 1052224270, 1043852487, 1047863595)
		+ W(6, -1120560082, 1019969949, -1089366478, -1067115412)
		+ W(7, -1071017431, 1066362408, 1084005284, 1063525936) + W(8, 1032448279, -1115333043, 1028612787, -1132671203)
		+ W(9, -1112864526, 1045423025, 1025066805, 1043035962) + W(10, 1025411331, -1123665230, 1024216939, 1034346460)
		+ W(11, -1116027280, -1133553563, 1032270816, -1105823812);
	WS(-1103681710, -1114530079);
	sum1 =
		W(0, 1025861737, 1029506744, 1032236919, 1035998951) + W(1, -1111043394, 1007410083, -1126534927, -1123346113)
		+ W(2, -1130912909, -1104283663, -1132593150, -1102933559)
		+ W(3, 1040041573, 992747222, 1034020670, -1119406504) + W(4, -1110124091, -1117715067, 1039686571, -1097542514)
		+ W(5, -1088677703, -1112367617, -1105036246, 1035634224)
		+ W(6, 1040844938, 1046218351, -1098764800, 1059317136) + W(7, 1057765873, 1054923388, 1029185429, 1040434219)
		+ W(8, -1105267215, -1121870249, 1038793978, -1096018272)
		+ W(9, -1105386706, -1101946581, -1122605111, -1143951794)
		+ W(10, 1021540535, 1032871129, -1120294159, 1036773558)
		+ W(11, -1111111618, 1031187710, -1138057273, 1023823648);
	sum2 = W(0, -1133865733, -1114357788, -1113774565, -1094909862)
		 + W(1, 1041934157, 1048238594, 1041091101, 1042608690) + W(2, 1041378526, 1025611699, 1057780422, -1134317911)
		 + W(3, -1084534604, -1105040821, -1096429323, -1128928913)
		 + W(4, -1102114760, 1041852494, -1090351620, 1058263821)
		 + W(5, 1059786982, -1114163954, 1034035361, -1102786592)
		 + W(6, 1040042063, -1102827642, 1041105879, -1094128428)
		 + W(7, -1121888905, 1038597269, -1139774900, 1035391793)
		 + W(8, 1036263014, 1023561916, -1107817782, 1049906607) + W(9, -1106476521, 1034361268, 1016844568, 1014428216)
		 + W(10, -1111718847, -1109687464, 1041802453, -1106696300)
		 + W(11, 1023851848, 1032032810, -1111010993, 1031652841);
	WS(1059372396, -1131086843);
	sum1 =
		W(0, -1116770958, -1133338231, -1109423369, -1142676381)
		+ W(1, -1119417706, 1016864285, -1134266292, 1026073927) + W(2, 1038224730, -1110641250, 1048611339, 1026922691)
		+ W(3, 1012241985, 1033593306, -1108924145, 1029871326) + W(4, -1145642197, 1044958408, 1054215533, 1059821143)
		+ W(5, 1063416476, -1109435540, 1051611888, 1046037553) + W(6, 1033085351, -1100693257, 1024247225, -1085100606)
		+ W(7, -1082741615, -1105005730, -1096553463, -1091104802)
		+ W(8, -1114157744, 1030339791, -1106016522, 1039898225) + W(9, 1046979692, -1157274234, 1033932042, 1022970360)
		+ W(10, -1129272066, 1026076824, -1113286331, -1126911267)
		+ W(11, -1119319754, -1131274519, 1018258200, -1118999381);
	sum2 = W(0, -1117639690, -1126294727, -1135696947, 996342293)
		 + W(1, 1025603183, -1120264553, 1034416033, 1029227505)
		 + W(2, 1032542252, -1105983103, -1105990346, -1101410582)
		 + W(3, 1031145839, 1029472991, -1125334020, 1016716795) + W(4, 1049036492, 1053585046, 1063294224, -1084067012)
		 + W(5, 1030876063, -1090564487, 1047874805, -1103677712)
		 + W(6, -1106428174, -1090074420, 1074893281, -1121077701)
		 + W(7, -1079475296, 1059480413, -1099339963, -1097572114)
		 + W(8, -1100598545, -1101677356, -1088449090, 1052666358)
		 + W(9, 1049420880, -1099961793, 1047783255, -1106211131)
		 + W(10, -1124515281, 1042350020, -1128187082, -1118105649)
		 + W(11, 1033189178, 1012743453, 1016211057, 1026065323);
	WS(998487488, 1024735998);
	sum1 = W(0, 1034787125, 1033987197, -1118966639, -1138173503)
		 + W(1, 1022076300, -1112157509, 1034213589, -1125240838)
		 + W(2, -1096711418, 1049342972, -1099717199, 1051641300) + W(3, 1049184050, 1032130968, 1048086279, 1039987293)
		 + W(4, -1093645783, -1089249828, -1085775960, -1083720757)
		 + W(5, -1086133195, -1087092580, -1098046771, -1087792286)
		 + W(6, 1058035879, 1055719968, 1060189357, 1061848612) + W(7, 1062875388, 1007190411, 1051240059, 1039984791)
		 + W(8, -1113381667, 1033680357, -1108537011, -1102783527)
		 + W(9, -1129404117, -1110331987, 1030325168, 1051616838)
		 + W(10, 1020339515, 1037116250, -1109989161, 1046511483)
		 + W(11, 1032957443, 1011591327, 1039628088, -1135236550);
	sum2 = W(0, 1001577162, 1041063142, -1112011211, 1039747614)
		 + W(1, -1137882877, -1105672858, 1031849538, -1108158369)
		 + W(2, 1048277958, 1048804575, 1037383696, 1042988518)
		 + W(3, -1097597287, -1099442373, -1108394523, -1155656404)
		 + W(4, -1094388043, 1061039504, 1055288082, -1084834029)
		 + W(5, -1087507005, 1044806256, -1093629181, 1059993792)
		 + W(6, -1079852425, -1095199392, -1077655189, -1103423898)
		 + W(7, 1064308251, 1065240337, 1071708239, 1061107030) + W(8, 1055450674, 1054780006, 1058201467, 1071463850)
		 + W(9, 1058560116, -1080251704, -1090257183, -1073879137)
		 + W(10, 1040994203, 1035580564, -1111912036, -1100510960)
		 + W(11, -1097442490, -1090250140, 1028605291, -1106111844);
	WS(-1077135094, 1050907162);
	sum1 = W(0, -1132921461, -1127648729, -1124984131, -1118007170)
		 + W(1, -1117294457, -1126452986, -1124706520, -1119126518)
		 + W(2, -1117094275, 1033699545, 1030394994, 1045491604) + W(3, 1039295895, 1040542752, 1018438944, 1035722382)
		 + W(4, -1098008869, -1094355462, -1089194394, -1081313730)
		 + W(5, -1088142214, -1094044967, -1098093746, -1094059515)
		 + W(6, 1043699095, 1055483630, 1053279460, 1065160347) + W(7, 1056280352, 1058021117, 1041063570, 1050783700)
		 + W(8, -1112620946, 1042990903, 1047326318, -1121246728)
		 + W(9, -1110840279, -1106681402, -1128181366, 1018820533)
		 + W(10, -1122422352, 1034045812, 1011377167, 1042128328)
		 + W(11, -1103632934, 1039870541, -1109127577, 1037083890);
	sum2 = W(0, 1003021837, 1029225785, -1123823650, 1023947681)
		 + W(1, -1119691195, 1024608678, -1125446899, 1034042378)
		 + W(2, -1110495495, 1032075003, -1122423961, 1043723635)
		 + W(3, -1138212418, 1017994477, -1115371525, 1002413729) + W(4, 1016902499, 993748010, 1028513681, -1096435650)
		 + W(5, -1120166015, -1119557273, 1032720188, -1115060009)
		 + W(6, -1116948709, 1041772340, 1083263801, 1074788880) + W(7, 1038793960, 1017310535, 1032034162, -1118011761)
		 + W(8, 1029108513, -1097222635, -1063916786, -1074844879)
		 + W(9, -1115182489, 1021770517, 1014563122, 1027576529)
		 + W(10, -1113320609, 1042534143, 1039031010, -1104645285)
		 + W(11, -1124877446, -1131419477, -1119401015, 999290841);
	WS(1048452526, 1015184705);
	sum1 = W(0, -1138645804, 1032256237, -1114005032, 1026512560)
		 + W(1, -1140244890, -1131077462, 1024452554, -1122466948)
		 + W(2, -1110581160, 1049910352, -1103860667, -1098570768)
		 + W(3, -1119844941, 1040825100, 1017183931, -1119780203)
		 + W(4, -1106270342, -1113826958, -1097372109, -1087095027)
		 + W(5, -1095003728, -1095439444, -1128526324, -1106181921)
		 + W(6, 1048623137, 1036222192, 1057099626, 1061337654) + W(7, 1054485156, 1049129464, 1044366494, 1040163591)
		 + W(8, 1006760678, 1042522323, -1101854594, -1106501979)
		 + W(9, -1115808507, 1027903818, -1153767820, 1034550428)
		 + W(10, -1113210911, 1029873877, -1111141177, 1024448974)
		 + W(11, -1125584845, -1111469876, 1027351533, -1117633442);
	sum2 = W(0, -1117856953, 1002437005, -1122373390, 1023823647)
		 + W(1, -1131092262, -1119824143, -1129026789, -1118651901)
		 + W(2, 1034706164, -1114697961, -1110151254, -1078943314)
		 + W(3, -1111296752, 1008147760, 1015792571, 1029244251) + W(4, 999139177, 1016679180, 1034965747, 1069645782)
		 + W(5, 1026082346, 1005900489, -1134452913, -1121319377)
		 + W(6, -1115089108, 1009230224, 1007700984, -1105149666)
		 + W(7, 1033262730, -1142960238, 1015281188, 1026230788) + W(8, 970725323, 1019562884, -1131774725, 1038179083)
		 + W(9, 1014219446, -1130072184, 1012295392, -1122304449)
		 + W(10, 1017499348, -1131336757, 1031482891, -1120925641)
		 + W(11, 1015408436, 1001625665, -1137039581, 1019807852);
	WS(1061396972, -1097419696);
	sum1 = W(0, 1040610541, -1116833412, 1015657075, -1126977972)
		 + W(1, 1033993320, -1125945514, 1028019732, -1120964750)
		 + W(2, -1110826049, 1042368898, -1113808270, 1036447253) + W(3, 1043284110, 1048078310, 1028739112, 1052576556)
		 + W(4, -1087862644, 1000165941, -1108964145, -1085843362)
		 + W(5, -1088558114, -1086794197, -1087573386, -1079810761)
		 + W(6, -1108888122, 1058527541, 1056284429, 1053927177) + W(7, 1062174380, 1055390198, 1042115560, 1051035743)
		 + W(8, 1051684947, -1102910221, 1041698836, -1107922836) + W(9, 991752527, -1112253878, 1039363202, 1047360574)
		 + W(10, -1117156776, -1135746300, 1026275932, 1041042462)
		 + W(11, -1137078595, 1035139905, -1118906322, 1038370422);
	sum2 =
		W(0, -1104315228, -1117475550, 1019617669, -1096755788) + W(1, 1043056626, -1097959989, 1038305467, -1121707278)
		+ W(2, -1103350409, 1024254038, -1116633366, 1042486592)
		+ W(3, 1038440719, -1097184876, -1107570984, -1092525975)
		+ W(4, -1094844926, -1091235931, -1089312569, -1104902685)
		+ W(5, 1045881224, -1101957876, 1058820589, 1058872796) + W(6, 1062539510, -1112967686, 1056743222, 1052266072)
		+ W(7, 1037341407, 1012499609, 1048266302, -1099676541) + W(8, -1096027281, 1042482062, -1129394013, 1051055108)
		+ W(9, 1044017054, -1101861122, -1105903455, 1041661910)
		+ W(10, 1014020953, -1119186298, 1028745390, -1093268483)
		+ W(11, 1054988226, -1102938164, 1026503526, -1135013257);
	WS(-1084431788, -1073850193);
	sum1 = W(0, -1121456839, 1023326765, -1111055334, -1131954777)
		 + W(1, -1127100870, -1115233108, 1032290155, -1113154576)
		 + W(2, -1130755883, -1119027356, 1007276024, 1032958718)
		 + W(3, 1051511197, 1038479638, 1033362061, -1118671783)
		 + W(4, -1131651239, -1113039213, 1041028837, -1121014635)
		 + W(5, -1080291009, -1101242168, -1095204295, -1109590335)
		 + W(6, 1035028387, 1052115068, -1087869490, 1031197854) + W(7, 1064028192, 1046762496, 1048797598, 1048241682)
		 + W(8, 1035837265, 1031790055, 1043959725, -1151139494) + W(9, -1097929447, 1016490449, 974160200, 1033898418)
		 + W(10, -1139076328, -1110649673, -1126605404, 1037205893)
		 + W(11, 1022476742, 1029406204, -1117985767, 1016018525);
	sum2 =
		W(0, 975878233, 1027199947, 1032202892, 1011577542) + W(1, 989447596, -1126785583, -1112180928, 1027448187)
		+ W(2, 1035912472, 1026239811, -1109490583, -1099491895) + W(3, 1027909011, -1142596491, 1032601180, 1030066347)
		+ W(4, 1033266404, -1101163205, -1092678923, 1052721602) + W(5, -1115079323, 1042994318, -1117880304, 999387083)
		+ W(6, -1098777501, -1120465270, 1026269275, 1058060839)
		+ W(7, 1022663675, -1109244590, -1139999774, -1113199846)
		+ W(8, -1115369638, 1047867282, 1048647954, 1026065727)
		+ W(9, -1107120056, -1139333782, -1113232790, -1128307819)
		+ W(10, 1024165887, -1114558090, -1127793863, -1110013405)
		+ W(11, -1115589183, 1028177183, -1119188249, 1010561254);
	WS(1060891500, 1063998119);
	sum1 = W(0, 1009319059, 1021371624, 1020060242, 1034805925) + W(1, -1119463744, 1029917861, 1022228167, 1028919037)
		 + W(2, 1034817251, -1123888698, 1007070174, 1031377177) + W(3, 1035958587, 1040845210, -1119265271, 1041595485)
		 + W(4, 1060685055, 1050963407, 1059880676, 1058492133) + W(5, 1057972187, 1045390927, 1050698442, 1042995863)
		 + W(6, -1082111981, -1089953728, -1083685732, -1080402290)
		 + W(7, -1087669949, -1092052092, -1101265316, -1093474029)
		 + W(8, -1146641530, 1042831681, 1044491976, 1049293617) + W(9, 1044279073, 1030870792, 1040824939, -1117179330)
		 + W(10, 1021753903, -1158245846, 1024323659, 974645755)
		 + W(11, 1017781825, 1029410098, 1009963113, 1033823734);
	sum2 =
		W(0, 1043252027, 1039685669, 1021402919, 1043798699) + W(1, -1106121381, -1107286980, -1116219530, -1105216890)
		+ W(2, 1031085111, -1103588836, -1094345084, -1097680472)
		+ W(3, -1098140010, -1117022930, -1111854401, -1165267820)
		+ W(4, -1089976691, -1136546874, -1106220008, 1053086422) + W(5, 1041831351, 1053158416, 1043898913, 1065796563)
		+ W(6, 1015926083, 1047286193, 1049855126, -1093227067) + W(7, 1030378489, 1047431201, -1088912308, 1047204695)
		+ W(8, 1075090314, 1055918010, -1100279282, -1086978538)
		+ W(9, -1081018505, -1090494906, 1049023531, -1076607098)
		+ W(10, -1090475122, 1041438201, -1097421747, 1055157984)
		+ W(11, 1047503463, 1040447738, 1013873926, 1060337257);
	WS(-1071907259, -1110912590);
	sum1 = W(0, -1125193009, -1128862543, -1134196340, 1030754750)
		 + W(1, -1115532794, 1035978988, -1122396199, 1030566929) + W(2, 1047025832, 1037187527, 1045585380, 1046461539)
		 + W(3, 1034859053, 1044478211, 1038023446, -1115297724)
		 + W(4, -1082520498, -1091004805, -1082717575, -1081098270)
		 + W(5, -1085641231, -1094770022, -1100806498, -1096364930)
		 + W(6, 1060301769, 1051495910, 1059488668, 1059029683) + W(7, 1058265227, 1047385124, 1051401113, 1030610907)
		 + W(8, 1034040338, 999732421, 1034460834, 1039737374) + W(9, 1026869576, 1035505465, -1108119003, 1049444580)
		 + W(10, 1027334603, 1007930762, 1012148988, -1153534395)
		 + W(11, 1008981841, -1141674924, -1131397284, 1004145403);
	sum2 =
		W(0, -1094095783, 1046265071, -1105766507, 1052972269) + W(1, -1118583019, 1048411623, -1102184915, 1063609884)
		+ W(2, 1071341959, 1041114835, -1093757522, -1096593198)
		+ W(3, -1091593516, -1091154406, 1057911473, -1073590228)
		+ W(4, -1106266089, -1087794787, 1036032273, 1065807667)
		+ W(5, -1120668367, -1098744738, -1101075731, 1041493985)
		+ W(6, -1079612356, -1090342602, -1097206613, 1072329002) + W(7, 1052074546, 1035089459, 1053464489, 1066861510)
		+ W(8, -1096220802, -1119797941, -1100480279, -1091841958)
		+ W(9, -1107977625, 1049018868, -1101117382, -1098841365)
		+ W(10, 1053270877, -1103321092, 1044676561, -1113258696)
		+ W(11, 1022355226, -1099949977, 1048742227, -1096064815);
	WS(-1073583387, -1097642521);
	sum1 =
		W(0, -1113793830, 1025630043, 999171711, -1113970392) + W(1, 1041107242, -1126372055, 1019259188, -1141619744)
		+ W(2, 1040986278, 1018743169, 1043520539, -1126196031) + W(3, -1117788829, 1023908016, 999617264, 997975216)
		+ W(4, -1123577624, 1051202676, -1085714085, -1137921726)
		+ W(5, 1058609607, -1120709796, 1049515695, 1048163249) + W(6, 1026212810, -1107655120, 1058537807, -1102760649)
		+ W(7, -1084066799, 1038867522, -1105494638, -1113662887)
		+ W(8, 1031641306, 1015332695, -1102186706, 1042214156) + W(9, 1050734989, -1104026556, 1038371877, -1118473257)
		+ W(10, -1117606078, 1026666645, 999394704, -1098706922)
		+ W(11, 1028174279, -1105230460, -1131430066, -1117999154);
	sum2 = W(0, 1020465344, -1122047285, -1132946638, 1029560286)
		 + W(1, -1137208000, 1032274109, 996568996, -1139618609) + W(2, -1114187457, 1035498840, 990134284, -1105572872)
		 + W(3, -1125836673, -1107008827, -1143550666, -1133886920)
		 + W(4, 1042661620, -1112200610, 1050532943, 1053825241)
		 + W(5, 1035380426, 1041934457, -1132156656, -1115627477)
		 + W(6, -1108558660, 990338200, -1098817485, 1046181371)
		 + W(7, 1052951690, -1099854916, -1101729420, -1120597401)
		 + W(8, 1022323488, 1037081003, -1116108394, -1112231866)
		 + W(9, -1098433232, -1115059895, -1106305341, -1145950712)
		 + W(10, 1024517966, -1114108748, 1033071181, 1024966834)
		 + W(11, 1018142458, -1114933005, 1025004711, -1129654551);
	WS(1066138518, -1093674260);
	sum1 = W(0, 1029114768, 1016625343, 1023256234, -1135602902)
		 + W(1, -1154917052, -1126509217, -1119361423, -1120895465)
		 + W(2, -1096639483, -1107076945, -1097327813, -1112968866)
		 + W(3, 1039946769, -1145778087, 1040195377, 1035798312) + W(4, 1057895286, 1046373881, 1060592282, 1048700903)
		 + W(5, -1102042589, -1102212410, -1110743776, -1096085673)
		 + W(6, -1095967018, -1098130813, -1090692519, -1096019117)
		 + W(7, 1052511498, 1050590801, 1037092318, 1054517602) + W(8, 1030209323, 1027610352, 1010824623, -1147523994)
		 + W(9, -1107963320, -1106421308, -1114290095, -1103975991)
		 + W(10, -1115838467, 1036809869, -1116997111, 1034515722)
		 + W(11, 1025259308, 1031910367, 1015369596, 1032370884);
	sum2 =
		W(0, 1020680083, 1026207298, -1114338038, 1034412140) + W(1, -1119552802, -1132183796, 1014438782, 1026463590)
		+ W(2, -1098235374, -1129289080, 1035819795, 1034843888)
		+ W(3, 1030579314, 1031435954, -1118921036, -1110299389)
		+ W(4, 1040052819, 1000882372, -1104532064, -1096717996) + W(5, 1025849568, -1126927262, 1034356940, 1043556407)
		+ W(6, 1039185699, 1041518935, 1060121453, -1098039050) + W(7, -1085068698, -1105751584, 1039772175, 1060018227)
		+ W(8, -1105651771, -1108930987, -1132043948, 1059664416)
		+ W(9, 1064006582, -1108966794, -1090790505, -1083675102)
		+ W(10, 999965284, 1025606660, -1127194998, -1123799241)
		+ W(11, 1020099573, -1130436386, 1040432622, -1098649260);
	WS(-1098394199, 1021768394);
	sum1 =
		W(0, -1106976773, 1030592418, -1109895628, 1031813276) + W(1, -1114022359, -1124672038, 980431986, -1118216524)
		+ W(2, 1047476460, -1106379994, 1041629170, -1108680996) + W(3, 1028771909, -1123109432, 1035760915, 1039049769)
		+ W(4, 1035645360, 1042879449, 1052123789, 1053022447) + W(5, -1107385030, 1044862779, 1023833154, 1040198899)
		+ W(6, -1107202165, -1121922344, -1091385002, -1090269731)
		+ W(7, -1107044710, -1127679127, -1107740288, -1099192133)
		+ W(8, -1121988294, 986778214, 1042582852, 1042227034) + W(9, 1044112989, -1115617842, 1030134009, 1025832513)
		+ W(10, 1008308247, -1140215924, -1120193402, -1127396653)
		+ W(11, 973525940, -1139398721, 1014367554, -1116507498);
	sum2 = W(0, -1098169790, 968544056, -1162122654, 1056997121)
		 + W(1, 1029158812, -1112228820, 1026696161, -1112296199)
		 + W(2, 1055345266, 1027898732, 1053687424, -1077105818) + W(3, 1039110353, 1037144043, 1022799116, 1042942743)
		 + W(4, -1106123518, 1021773530, -1089212318, 1068095045)
		 + W(5, -1090252350, -1124556656, -1130232224, -1104975561)
		 + W(6, 1039932359, 1036378047, 1035540057, -1098361429) + W(7, 1000425352, 1050038066, -1118055459, 1040445489)
		 + W(8, -1111072353, -1123343911, -1111121590, 1044527270)
		 + W(9, -1115281069, -1114307158, -1116705210, 1023167430)
		 + W(10, 1012808524, -1132858861, 1037852727, -1103837325)
		 + W(11, 1036594354, -1134065606, 1032061348, -1114916168);
	WS(1064984812, 1025677564);
	sum1 = W(0, 1043884023, 1030924649, 1038396303, 1036152448) + W(1, 1017544939, 1042241831, -1121467129, 1047065797)
		 + W(2, -1096329284, 1033742216, -1101734196, -1105624932)
		 + W(3, 1017123640, -1108991823, 1037154774, -1096026219)
		 + W(4, -1084712758, -1103101243, -1087209573, -1086845720)
		 + W(5, -1084903475, -1087299343, -1108220133, -1087523701)
		 + W(6, 1057726586, 1046959260, 1057188432, 1061206275) + W(7, 1060371326, 1055419738, 1041931586, 1055087388)
		 + W(8, 1043356655, 1018532660, 1046520365, -1114153679) + W(9, -1111584053, 1028245989, 994164350, 1051664559)
		 + W(10, 1012739123, -1131015624, 1002161670, 1044816791)
		 + W(11, 1024962678, 1043667629, -1114955616, 1040331724);
	sum2 = W(0, 1043159502, -1105699647, 1038273264, 1032147900)
		 + W(1, 1048938986, -1106879197, -1128156680, 1049056829)
		 + W(2, -1104158106, 1050222709, 1025130152, 1032288328)
		 + W(3, -1103450106, -1110143950, -1098742781, -1091104362)
		 + W(4, -1085409392, -1090385012, -1106188919, 1061149199)
		 + W(5, 1050752016, 1049612036, 1057886527, -1095713225) + W(6, 1067096435, -1106627676, 1052171093, 1075677902)
		 + W(7, 1075039778, 1073503496, 1075355126, 1082426924)
		 + W(8, -1090972778, -1102151020, -1086083449, -1070862987)
		 + W(9, -1070168511, -1072257998, -1070483864, -1070643407)
		 + W(10, -1098664617, 1050757442, 1039140273, 1030992941)
		 + W(11, 1040257314, 1041175752, 1030488248, -1098188298);
	WS(-1072457547, -1104871915);
	sum1 =
		W(0, 1018087532, 1014551830, -1143311830, 1031881454) + W(1, 1033102921, 1020957612, -1158925470, 1015585054)
		+ W(2, -1138749297, 1036550950, 1001512248, -1098112129)
		+ W(3, -1104222042, -1104597767, -1125431314, 1042534317)
		+ W(4, -1129333765, -1131367952, -1083142279, 1014989673) + W(5, 1059974718, 1057969217, 1048954301, 1043242379)
		+ W(6, 983826087, 1050222745, 1055877542, 1020808474) + W(7, -1086706094, -1096646942, -1105443081, -1106542638)
		+ W(8, 1026100589, -1118152278, -1106883828, 1016760626) + W(9, 1045231050, 1040528910, 1027306868, -1120756612)
		+ W(10, 1007352484, -1123482688, 1034580622, -1109491581)
		+ W(11, -1122062610, -1114916930, -1147978606, -1122581117);
	sum2 =
		W(0, -1120473304, -1112539216, -1132295147, -1099708049)
		+ W(1, -1120301365, -1106531527, -1119309605, -1165429700)
		+ W(2, 1034530006, 1032795060, 1046686841, 1054832981) + W(3, -1109933894, -1089566811, 1004612697, -1105741108)
		+ W(4, -1151412702, 1009244103, 1037608248, 1050403530) + W(5, 1051005406, -1106362502, -1114169666, 1026755208)
		+ W(6, -1124099243, -1115907580, 1020085733, 1033863239)
		+ W(7, -1107650300, 1030750625, -1130967605, -1146151019)
		+ W(8, 1026058392, -1114805763, -1120554932, -1154011810)
		+ W(9, 1036477609, -1122049677, 1028389062, 1026996282) + W(10, -1131120105, 1025202928, 998829429, -1131382687)
		+ W(11, 1020773937, -1143352615, -1142800679, 1016610669);
	WS(1057548396, -1118860492);
	sum1 = W(0, 1024314991, 1015464700, 1033090170, 1024068436) + W(1, 1023937802, 1007695803, 1026830221, -1142835770)
		 + W(2, 1024521628, 1035643506, 1022826491, 1044765945) + W(3, 1040253828, 1032416458, 1031527745, 1041535598)
		 + W(4, 1019907062, 1035362560, -1102305323, -1077384746)
		 + W(5, -1095947197, -1110302756, -1110046895, -1106773417)
		 + W(6, -1109277847, 1033181378, 1038789717, -1093016121) + W(7, 1047039772, 1032628147, 1032291149, 1038601945)
		 + W(8, 1042186208, 1019936830, 1047455161, 1050623422) + W(9, 1039235079, 1012944520, 1025595072, 1031404576)
		 + W(10, -1127185475, 1015346289, 1015056043, 1035221881)
		 + W(11, 1019339797, 1030260028, -1124358344, 1039118899);
	sum2 = W(0, 1028948662, -1108748842, 1035054379, -1114955281)
		 + W(1, -1123628391, 1033670708, -1113438145, 1009774019)
		 + W(2, -1119520873, 1035535229, 1034598190, 1040844095) + W(3, 1017632867, 1028317650, -1152158269, 1033306906)
		 + W(4, 1040692087, -1128105382, -1105801492, 1058969109)
		 + W(5, -1140061979, -1098716294, -1100355456, -1097137530)
		 + W(6, -1099276378, -1125068566, 1046560183, 1035247795) + W(7, 1037021603, 1041621971, 1042440154, 1045186907)
		 + W(8, 1042585669, -1119570187, -1104135640, -1104363062)
		 + W(9, -1119904127, -1109815486, 1033417138, -1096381982)
		 + W(10, -1108959122, -1105777938, 1040780747, -1115696651)
		 + W(11, -1122498951, 1039115990, -1102421790, 1043903068);
	WS(-1111617372, -1089239798);
	sum1 = W(0, -1120946745, 1043411666, -1105344783, 1034980559)
		 + W(1, 1035032490, -1102176538, 1042691462, -1106084756)
		 + W(2, -1109363280, -1105933140, -1122482989, -1097138762)
		 + W(3, 1028445691, 1038047807, -1104930291, 1036625252) + W(4, 1036859267, -1100282243, 1033736099, 1040067055)
		 + W(5, -1085774908, 985367106, -1095561837, -1105930796)
		 + W(6, -1107333692, 1036658471, -1096910672, 1063625005) + W(7, 1059841631, 1050659758, 1056206133, 1039222942)
		 + W(8, -1131126919, 1046725686, -1138971218, -1100591479)
		 + W(9, -1101046354, -1099856795, -1114722211, 1033845467)
		 + W(10, 1028471724, -1102252305, 1048148056, -1115573502)
		 + W(11, 1018704810, 1038410359, -1104725204, 1032806392);
	sum2 = W(0, 1032901751, -1107914664, 1029069579, 987500422) + W(1, -1107918292, 1041931397, -1106970712, 1026585516)
		 + W(2, -1102980188, 1034775565, -1107463876, -1115674720)
		 + W(3, -1122769714, 1028640927, -1133982193, -1112107626)
		 + W(4, -1097455677, -1079544271, -1107584024, 1066142773)
		 + W(5, 1049477386, -1110827944, 1040943686, 1033119735) + W(6, 1019096213, -1123759676, 1039965269, 1060530292)
		 + W(7, 1039765158, -1133849713, -1110406142, -1129682772)
		 + W(8, 1032175116, -1101940532, 1028816201, 1036298034)
		 + W(9, -1100641824, 1041944181, -1113302080, 1007346649)
		 + W(10, -1112661460, 1048109574, -1102645998, 1048822254)
		 + W(11, -1106440053, -1113520406, 1032469881, -1114426196);
	WS(1055684951, -1075449937);
	sum1 = W(0, 1025203701, -1109225282, -1105594014, -1102495686)
		 + W(1, -1115277256, -1131312361, 1003392922, -1119401549)
		 + W(2, 1021145317, 1041132226, 1045336591, 1048290762) + W(3, 1046212734, 1033816821, 1042625602, 1032304674)
		 + W(4, -1089325052, -1098148265, -1089314051, -1085251962)
		 + W(5, -1086898788, -1089905605, -1090587428, -1086086859)
		 + W(6, 1050955910, 1048074946, 1059061644, 1063401377) + W(7, 1058388246, 1057949871, 1049257380, 1056447675)
		 + W(8, 1044060206, -1122722677, -1138312640, -1135340574)
		 + W(9, -1108206354, 1012872015, 1013091209, 1030899626)
		 + W(10, 1023449767, -1117792831, 1024771419, 1034487612)
		 + W(11, -1122363216, 1023079171, -1119440554, 1029355212);
	sum2 = W(0, 1061277558, 1070915797, 1077465728, 1077005703) + W(1, 1067272551, 1035834095, -1140563054, -1101597023)
		 + W(2, -1075680192, -1078675502, -1072669743, -1071891757)
		 + W(3, -1079654744, -1094224921, -1124876273, -1106967769)
		 + W(4, 1064394375, -1099840736, -1080083122, -1110541808)
		 + W(5, 1034295344, 1034313258, 1044374977, 1056268760) + W(6, 1041412946, 1036217426, 1053075748, 1035413026)
		 + W(7, -1098463344, 1050839735, 1012713199, 1033733408)
		 + W(8, -1097187807, 1041322393, -1098777830, -1105806062)
		 + W(9, 1042040059, -1099205009, 1043077130, -1097742853)
		 + W(10, 1043650757, -1128025338, -1113957037, 1028555409)
		 + W(11, 1035679275, -1113787473, 1015942004, 1036121231);
	WS(-1084991020, -1093321377);
	sum1 = W(0, -1124603198, 1020905181, 1034567442, 1033810210) + W(1, 1026468027, 1034346016, 1012576759, 1040898454)
		 + W(2, 1041431403, -1106261797, 1012534679, -1100435893)
		 + W(3, -1113177704, 1029015460, -1109083497, 1045957208) + W(4, 1058092855, 1050746614, 1060858482, 1063338984)
		 + W(5, 1057782107, 1050350895, 1047981412, 1051078083)
		 + W(6, -1087194206, -1093664550, -1086211050, -1081371861)
		 + W(7, -1091610836, -1090363161, -1099126963, -1088769118)
		 + W(8, 1031898965, 1020373118, 1037199077, 1028138434) + W(9, 1041359812, 1026545296, 1017607178, -1114891854)
		 + W(10, 1027465426, 1019387090, 942151344, -1130539845)
		 + W(11, 1019123574, 1032894586, 1018549369, 1024075622);
	sum2 =
		W(0, 1049096145, 1050639335, 1060252300, 1068716746) + W(1, 1070836883, 1071114171, 1069477538, 1068968491)
		+ W(2, -1096421724, -1100344181, -1085369111, -1076762820)
		+ W(3, -1073687271, -1075542147, -1076870984, -1078719402)
		+ W(4, -1104462777, 1044471716, -1101216805, 1050347336) + W(5, 1052234046, 1009296899, 1047758574, -1114781860)
		+ W(6, 1019605429, 1054069324, -1124780213, 1025609425) + W(7, -1096692411, 1043747806, 1026561745, 1035243068)
		+ W(8, -1107039596, -1112798845, 1041817400, -1099054195)
		+ W(9, 1029953841, 1030832137, -1135279155, -1140937749) + W(10, 1039363330, -1113551308, 999612981, 1018249637)
		+ W(11, 1028531297, -1109453871, 1027426027, -1125031723);
	WS(-1082530796, 1061926473);
	sum1 = W(0, -1111745736, 1030277984, -1123296661, 1039021467)
		 + W(1, -1130604760, 1012520514, -1112767704, 1017586258)
		 + W(2, -1107298323, -1127531019, -1109831840, -1118701125)
		 + W(3, -1101933527, -1114851579, 1016124742, -1131932512)
		 + W(4, 1048819916, 1039611697, 1058045501, -1099048749) + W(5, 1052265202, 1034215157, 1037161440, 1010862879)
		 + W(6, 1033356744, -1113172467, 1035918242, -1088898044)
		 + W(7, -1125679275, 1029808585, -1110952702, 1040689749)
		 + W(8, 1034157517, -1127895905, -1146238814, -1099659681)
		 + W(9, 1032846000, 1005542493, 1024904046, -1114167271)
		 + W(10, -1119982339, 1009757802, -1125062126, 1039341706)
		 + W(11, -1111731430, 1016627083, -1137100912, -1130467695);
	sum2 = W(0, -1123675689, 1025856461, -1129839981, 1039506778)
		 + W(1, -1111122039, -1108253250, 1042547871, 1023517501)
		 + W(2, 1027790609, -1115257125, 1041635489, -1087170514)
		 + W(3, 1054414527, 1040911707, -1107819629, -1119501461)
		 + W(4, -1107220732, -1103597907, -1083432255, 1074899174)
		 + W(5, -1087814585, -1119836905, -1108795814, -1120345851)
		 + W(6, -1138688370, 1036222096, -1099581339, 1052206445) + W(7, 1033877978, 1035305654, 1040418607, 974999585)
		 + W(8, -1114685917, -1104487390, -1113019592, -1103205528)
		 + W(9, -1114160943, -1128600489, -1113593105, -1136105250)
		 + W(10, -1131813881, -1138958066, 1015980625, 1015820001)
		 + W(11, 1023501105, -1135082354, 1028405761, 1023691837);
	WS(1064809580, 1026007555);
	sum1 = W(0, -1117346201, 1012678303, -1112794575, 1024755966)
		 + W(1, -1119597108, -1109792204, 1039580268, -1109340249)
		 + W(2, -1139810490, -1117193870, 1032058104, -1127734554)
		 + W(3, 1040786347, -1106953519, -1120656619, -1123630216)
		 + W(4, 1018638922, 1041509643, -1089321581, -1106321711)
		 + W(5, 1042250009, -1136225478, -1140389406, 1031754384)
		 + W(6, 1046259126, -1116046893, 1058768682, 1057441571) + W(7, -1088983804, 1052663642, 1033398978, 1030125211)
		 + W(8, -1110265860, -1107022182, 1049529906, -1097674775)
		 + W(9, 1052962187, -1105006210, -1138416249, -1114619763)
		 + W(10, -1107316166, 1042684025, -1107194416, -1115653262)
		 + W(11, -1115453338, -1104239151, 1026892022, -1113265368);
	sum2 =
		W(0, 1002173025, 1022454821, -1114052781, 1026488668) + W(1, 1024785122, -1114947733, 1041552522, -1114686018)
		+ W(2, -1126476274, -1112202702, 1040267060, -1105276944)
		+ W(3, 1041996701, 1024974628, -1106672600, 1014734543) + W(4, 993251281, 1027055467, -1106967376, 1037292044)
		+ W(5, 1032247852, -1103384730, 1024347316, 1038837578) + W(6, 1035289805, -1110248161, 1050537246, -1103163514)
		+ W(7, 1036995069, 1044720036, -1136575544, 1011597497) + W(8, 1026092616, -1106697397, 1051631259, -1119693560)
		+ W(9, 1026699348, -1113586574, 1012871948, -1113050536)
		+ W(10, -1119256919, 1035602798, -1119463370, -1109176262)
		+ W(11, -1123291766, -1103668424, -1104716490, -1124038001);
	WS(1065652022, 1032044813);
	sum1 =
		W(0, 1008146233, -1138253430, -1111490857, 1034343482) + W(1, 1027957290, 1037589943, 1035138662, -1130048270)
		+ W(2, 1024151812, 1033154018, 1037025524, -1098142828) + W(3, -1093711910, 1019326054, -1137243780, 1033030167)
		+ W(4, -1109382253, -1111423088, -1089787453, 1056996567) + W(5, 1064926206, 1020462798, 1028825917, 1017317515)
		+ W(6, 1046726755, -1114751985, 1060185520, -1102691401)
		+ W(7, -1084615165, -1096112169, -1123985530, -1105819364)
		+ W(8, -1118504831, 1030270670, -1108385813, 1034117937) + W(9, 1042611828, 999245356, -1106962907, -1131349303)
		+ W(10, -1145994760, 1011776865, 1031075253, -1115595081)
		+ W(11, -1141498448, 1030480467, 1020535720, -1161641125);
	sum2 = W(0, 1006780909, 1032029355, 928839112, -1118040285) + W(1, -1112805367, -1105940221, 1025941308, 1031169874)
		 + W(2, 1018874621, -1106542042, -1114343998, -1106692361)
		 + W(3, 1043467647, 1041450718, 1036583459, -1106475204)
		 + W(4, -1118402441, -1123089851, -1111882995, 1057618964)
		 + W(5, -1114692462, 1035656455, -1122657152, -1181112366)
		 + W(6, -1125742470, 1042324218, -1150379126, 1059562898)
		 + W(7, -1124030112, -1096899429, -1115452253, -1108009053)
		 + W(8, 1022906649, 1032351097, 1030201786, -1096401122)
		 + W(9, -1101041619, -1105376866, 1025207396, -1117532473)
		 + W(10, 1002124531, -1127943559, -1112138839, 1036092239)
		 + W(11, -1119061832, 1038704957, -1115257437, 1040262599);
	WS(1060219372, -1086892801);
	sum1 = W(0, -1103145773, 1041685441, -1114046300, -1105288038)
		 + W(1, 1036049319, -1105447101, -1153064218, 1037687846)
		 + W(2, 1039153858, -1139059104, -1139626983, 1051743245)
		 + W(3, 1005204005, -1096900831, 1006778518, -1097346218)
		 + W(4, 1051640744, -1111094658, 1060139625, 1048845947) + W(5, 1056234019, 1058595229, 1030114274, 1052830405)
		 + W(6, -1098525574, -1114399172, -1105262039, -1084251893)
		 + W(7, -1132035760, -1097183901, -1095492788, -1105878061)
		 + W(8, -1104573181, 1034492410, -1112320535, 1048366229)
		 + W(9, 1045757805, -1102598303, 1044243314, -1114955456)
		 + W(10, 1018968139, -1114173214, -1114750605, -1119683574)
		 + W(11, -1113866359, -1132035040, 1021887633, -1107291810);
	sum2 =
		W(0, -1116149857, -1115656995, 1030898684, -1101937257)
		+ W(1, -1172884346, -1108962642, -1122887710, 1035380843) + W(2, 1025241726, 1004099725, 1025926274, 1029996270)
		+ W(3, 1015423640, -1098527410, -1102965987, -1099100919)
		+ W(4, -1099180395, -1094029030, 1029208805, -1093188603) + W(5, 1043486640, 1057927618, 1033678913, 1054675670)
		+ W(6, 1043244905, 1042198638, 1050305603, 1051892024) + W(7, 1010118001, -1111697287, -1106879588, -1115267941)
		+ W(8, -1108018378, 1030698655, -1105752531, 1032179392)
		+ W(9, 1042453668, -1110311603, 1043859461, -1124505249)
		+ W(10, 1036684654, -1113978987, 1030311314, -1143836228)
		+ W(11, -1107174775, 1032971351, -1114814873, -1114563702);
	WS(1054285911, 1050558006);
	sum1 = W(0, -1123510162, -1131523010, -1131464621, 1019709806) + W(1, 1029482925, 1019519396, 1008876867, 990268585)
		 + W(2, 1038924416, 1041880394, 1042834130, 1022473868)
		 + W(3, -1100861061, -1099456110, -1103795177, 1023983666)
		 + W(4, -1103298920, -1093800836, -1095165898, 1057683379)
		 + W(5, 1065493943, 1059660975, 1052993120, 1049686449) + W(6, 1049975562, 1050884477, 1056805171, -1101108530)
		 + W(7, -1084744157, -1084827161, -1096422344, -1102767109)
		 + W(8, -1107117058, -1103773453, -1101616339, -1121085405)
		 + W(9, 1044641696, 1037612741, 1041661496, -1112995616)
		 + W(10, -1132690963, 1013663344, 1008580322, -1112183179)
		 + W(11, -1107880231, -1118057053, -1120002940, -1125681410);
	sum2 =
		W(0, -1122499415, -1135750526, 1025808744, 1004729468) + W(1, 1038371609, 1025309219, 1037233345, -1107252608)
		+ W(2, -1115660402, -1103885919, -1107570715, -1109043837)
		+ W(3, -1101018403, -1106866200, -1100735475, 1049544712)
		+ W(4, 1019721643, -1163427536, 1050733408, 1068391994) + W(5, -1088555463, 1029079067, 1034253450, -1147071004)
		+ W(6, 1052675919, -1111228057, 1050715774, 1068640266)
		+ W(7, -1109791041, -1082318320, 1048468038, -1092391889)
		+ W(8, -1134010714, -1097257542, -1097200131, -1098019427)
		+ W(9, -1104872484, -1103711089, -1096395820, 1032346912)
		+ W(10, -1107636671, 1043515230, -1113330231, 1035061875)
		+ W(11, 1015805682, -1134559274, 1043601518, -1139706642);
	WS(-1090663639, -1077388844);
	sum1 = W(0, 1018174482, -1160081154, -1125628059, -1132569784)
		 + W(1, -1117916196, -1117849353, 1021610031, -1122253105)
		 + W(2, -1118693311, 1029100670, -1120731528, -1106887239)
		 + W(3, -1106415899, -1097169074, -1146324700, -1168966176)
		 + W(4, -1093711755, -1098783931, -1088582516, -1095941442)
		 + W(5, -1087125152, -1094690684, -1097735927, -1093052224)
		 + W(6, 1049109025, 1046071575, 1052420297, 1068562223) + W(7, 1064382514, 1058209900, 1048904111, 1056110513)
		 + W(8, 1040639418, 1021012498, -1106387497, 986381179)
		 + W(9, -1096200966, -1116837948, 1025702951, -1121509238)
		 + W(10, 1010315758, -1115518041, -1181480889, 1034527238)
		 + W(11, 974332196, 1015836076, -1123641014, 1025570188);
	sum2 = W(0, 1034436941, -1113720588, 1024698569, -1106229774) + W(1, 1036635696, 1046234567, 1052080385, 1034351318)
		 + W(2, -1094381136, 1042206203, -1096498964, -1082651758)
		 + W(3, -1065300211, -1070759890, -1090746117, -1089089289)
		 + W(4, 1032181918, 998633097, 1057336919, 1076874404) + W(5, 1081990850, 1049370102, -1114040834, 1035723536)
		 + W(6, 1038416019, -1112936962, 1044225483, 1035551973) + W(7, 1041430251, 1045207615, 1038285588, -1119691531)
		 + W(8, -1157362266, 1041189037, -1114037642, 1029476436)
		 + W(9, 1035032611, 1036601034, -1115422836, -1130950394)
		 + W(10, 1040127243, -1108577062, -1122557473, 1033287923)
		 + W(11, 1024588020, 1015731519, -1155116306, 1031958369);
	WS(-1080363926, -1071486509);
	sum1 = W(0, 1035667824, -1106562756, 1048836261, -1099668353)
		 + W(1, 1041756943, 1034350288, -1111757455, 1036008540)
		 + W(2, -1117755862, -1102851061, 1026770536, -1096598034)
		 + W(3, -1111989629, -1117155588, -1106686285, -1110305168)
		 + W(4, 1058850627, 1044522508, 1060900423, 1062774732) + W(5, 1060314417, 1058954340, 1047827972, 1058323473)
		 + W(6, -1089812638, -1098855847, -1094273901, -1081351512)
		 + W(7, -1091724133, -1097309107, -1089979637, -1097705308)
		 + W(8, -1119781738, -1124105919, -1136163052, 1019768789)
		 + W(9, 1036217472, 1034476769, 1034808863, -1112569431)
		 + W(10, 1033333673, -1122920906, 1034167779, -1100720585)
		 + W(11, 1023569595, 1037864032, -1108224543, 997120104);
	sum2 = W(0, -1130221439, 1039521143, -1106623296, 1040812416)
		 + W(1, -1108121630, 1011405671, 1024610419, -1120568012)
		 + W(2, 1026473921, 1040027805, -1103850305, 1044422007) + W(3, 1033782288, -1112409330, 1042204829, 1007920671)
		 + W(4, -1098631230, 1049962270, -1102633929, 1053913409)
		 + W(5, 1041179127, -1118313372, 1033589003, -1105557487) + W(6, 1059210683, 1037922688, 1032319554, 1075309200)
		 + W(7, 1051007822, -1114991064, 1064519547, 1041664007) + W(8, 991949852, -1128609979, 1032322677, -1093367457)
		 + W(9, -1128820939, 1042490244, -1108707286, -1108726636)
		 + W(10, -1088875775, 1043008084, -1081254616, -1078110278)
		 + W(11, -1087823621, -1085620101, 1038944538, -1097283302);
	WS(-1085146860, -1078432897);
	sum1 =
		W(0, 1000247468, 1037132754, -1107087079, 1043827999) + W(1, -1105171356, 1034542459, -1139389265, 1019250012)
		+ W(2, -1149696569, -1105005939, 1047641075, -1094624073)
		+ W(3, 1038438012, -1098392071, 1037791108, -1111893867) + W(4, 1046594056, 1049101493, 1036712721, 1056540903)
		+ W(5, 1056427897, 1052522438, 1039493090, 1053002294) + W(6, -1105608437, -1092242085, 1034057408, -1091288646)
		+ W(7, -1092984875, -1099696227, -1123704450, -1096292923)
		+ W(8, 1029982264, 1035020227, 1000135432, -1097712673) + W(9, 1048401189, -1113847620, 1041969240, -1109486882)
		+ W(10, -1128935441, -1114749360, 1041253327, -1098691603)
		+ W(11, 1031740017, -1124493285, 1035876258, -1117863020);
	sum2 = W(0, 981650725, -1123188651, -1132394336, 1019312288) + W(1, 1007032529, 1019035800, -1139057577, 994405618)
		 + W(2, 1022634928, -1141995321, -1159373413, 1040593594)
		 + W(3, -1125839148, -1144628769, -1130558040, 996479090)
		 + W(4, -1122722467, 1043118137, -1111962066, -1085264893)
		 + W(5, 1035586791, 1030456162, 1025167346, -1121727683)
		 + W(6, -1134931805, 1038372119, -1088039805, -1062981933)
		 + W(7, -1088420516, 1033594923, -1132235322, -1141102409)
		 + W(8, -1114801830, -1108690895, 1059960197, 1086226578)
		 + W(9, 1052041256, -1121903247, -1127116104, 1010205301)
		 + W(10, 1035155349, -1113558499, -1123558064, -1122982849)
		 + W(11, 1041973847, -1112866008, 999416881, 1015327588);
	WS(1065314092, 1028007882);
	sum1 =
		W(0, 1031315399, 1009229913, -1129846167, 1030512684) + W(1, 1027211107, 1024491495, -1133667543, 1020076159)
		+ W(2, -1118910333, 1044274103, 1040482617, 1028502523) + W(3, -1098008831, -1114626726, 1030034106, 1035646611)
		+ W(4, -1110071882, -1091088835, -1081937298, 1057125791) + W(5, 1063505604, 1056913060, 1045615294, 1046315392)
		+ W(6, 1027958726, 1049048403, 1058342964, 1041882615)
		+ W(7, -1081007746, -1094994912, -1103714125, -1120947018)
		+ W(8, -1132049297, -1098774521, -1097400260, -1128387300)
		+ W(9, 1042307230, 1046624506, 1018202602, -1116178789) + W(10, 1030345978, 1015648546, 1033820695, -1123750794)
		+ W(11, -1119357859, -1108219417, 1021380405, -1113806211);
	sum2 = W(0, -1105494348, 1042860341, 1034523914, 1032509803)
		 + W(1, 1037500440, -1136462181, -1115571726, 1030953968)
		 + W(2, 1051114204, -1095282678, -1099570184, -1092355888)
		 + W(3, -1093487707, -1101634066, 1038218158, -1144657738)
		 + W(4, -1106549278, -1095274416, -1097084890, 1068351366)
		 + W(5, 1045336627, -1093371043, 1025607496, -1098135458)
		 + W(6, -1106413411, -1115620988, -1100406176, 1061966336)
		 + W(7, 1064976080, -1095768559, 1051011462, -1103066203)
		 + W(8, 1026636954, 1032482885, -1103782738, -1111829172)
		 + W(9, -1099957245, 1011878641, -1122142689, 1046841453)
		 + W(10, -1101805730, -1123651604, 1033985372, 1041181693)
		 + W(11, -1105149847, 1041978329, -1106959075, 1034424520);
	WS(-1100053422, 1042143034);
	sum1 =
		W(0, -1121193300, 1027006179, -1116784408, -1124403186) + W(1, 1032959000, 1036096698, -1106874909, -1140087089)
		+ W(2, 1038907933, -1101648146, 1051061595, -1096312949) + W(3, 1021329739, -1104405590, 1032316755, 1026338531)
		+ W(4, 1037214192, 1052804861, -1092953078, 1063691363) + W(5, 1057610578, 1046101531, 1033832353, 1044117027)
		+ W(6, -1104157285, -1116788520, -1115727182, -1094770533)
		+ W(7, -1085255924, 1032460934, -1101777344, -1123976854)
		+ W(8, 1003265009, -1105088109, 1044603252, -1110178331)
		+ W(9, 1042273837, -1099699080, 1042741769, -1110400285)
		+ W(10, 927491180, 1036085839, -1112320669, -1132796507)
		+ W(11, -1129217311, 1029210945, -1111566277, 1023324661);
	sum2 =
		W(0, -1141740532, -1141563308, -1146742484, 1037326381) + W(1, -1100634945, -1112991637, 998071241, 1028661660)
		+ W(2, -1127364827, -1115378106, -1097895309, -1089066292)
		+ W(3, 1074712949, 1036278807, 1023404119, 1032269699) + W(4, 1016858659, 1014774982, 1061549017, -1086943216)
		+ W(5, -1081904953, 1016249563, -1104500239, -1118089334)
		+ W(6, 1019476887, 1033910688, -1098904537, -1087533486) + W(7, 1051894188, -1105464222, 1039001405, 1002948788)
		+ W(8, 1027610232, -1098709711, 1048121474, 1044386108) + W(9, 1035948687, 1034738839, -1111082062, 1032376859)
		+ W(10, -1114104878, 1038463125, 1009723338, -1128378528)
		+ W(11, -1114075451, 1023041183, 1028418264, -1116656881);
	WS(1064553004, -1122811923);
	sum1 =
		W(0, -1129171987, 1032276908, -1113233767, 1041762428) + W(1, -1110071667, 1027123610, -1123823416, 1026480898)
		+ W(2, 1031404000, -1105326008, 1049333812, -1095271692)
		+ W(3, 1021654775, -1101813124, 1034262350, -1114787413) + W(4, 1045766677, 1049463355, 1036005443, 1059787495)
		+ W(5, 1057980603, 1052117804, 1041561742, 1051913520) + W(6, -1102182210, -1094389820, 974120215, -1088583546)
		+ W(7, -1092394330, -1097358280, -1111517243, -1097569834)
		+ W(8, 1024429036, 1026361994, 1035186995, -1095666629) + W(9, 1048809333, -1132328890, 1043990330, -1107060706)
		+ W(10, -1144455651, -1121595412, 1034062296, -1100003363)
		+ W(11, 1024774373, -1125809241, 1035275874, -1116630377);
	sum2 =
		W(0, 1027128731, -1153474964, 1032141903, -1114194268) + W(1, 1010972171, -1128303982, 1020076945, -1125252319)
		+ W(2, -1118374135, 1014938475, -1106631533, 1049333862)
		+ W(3, -1117272233, 1026850075, -1130317298, 1023253865)
		+ W(4, 1034513610, -1107487108, 1042187602, -1091768288) + W(5, 1029258819, -1112584656, 1019094573, 1030375545)
		+ W(6, -1123174378, -1123472496, 1054134699, 1082046784)
		+ W(7, 1048672371, 1015595275, -1143083862, -1112246350)
		+ W(8, 1026835315, 1026726549, -1092438474, -1066065893)
		+ W(9, -1108402828, -1129520676, 1012988295, 1033146096)
		+ W(10, -1114420605, 1026647445, 1008281595, 1032174407)
		+ W(11, -1107223380, 1020663133, 1016020771, -1120189048);
	WS(1066855734, -1119441794);
	sum1 = W(0, -1127562022, -1123770274, -1115364812, -1108591004)
		 + W(1, -1109630903, 1012450637, -1111453929, -1112819014)
		 + W(2, 1039804281, -1106380690, 1049486942, 1052921753) + W(3, 1002857256, 1049080999, -1123146086, 1045715313)
		 + W(4, -1090674092, -1096623933, -1088928155, -1086271011)
		 + W(5, -1088126629, -1098448030, -1095526376, -1090620137)
		 + W(6, 1057948125, 1041520634, 1058254390, 1066610309) + W(7, 1047590014, 1058670697, 1020669183, 1057080301)
		 + W(8, -1113289318, -1102744925, -1126493725, -1125400685)
		 + W(9, -1097419497, 1027654745, -1103558716, -1122765265)
		 + W(10, 1040603681, -1104646487, 1030330554, 1047144630)
		 + W(11, -1118729135, 1040353710, -1110153949, 1038000005);
	sum2 =
		W(0, 1029773001, -1098400772, 1049403575, -1106957817) + W(1, 1040180418, -1125940042, -1121768997, 1035657430)
		+ W(2, 1045848843, -1098127734, 1040542896, -1113384065)
		+ W(3, -1098054809, 1051521525, -1098090743, 1035815778) + W(4, -1100354950, 985414438, -1094506611, 1065317808)
		+ W(5, -1102424534, 1038107076, 1030043463, -1104826760) + W(6, 1042255280, -1114969170, 1044461531, 1063282493)
		+ W(7, -1111953320, 1052337139, -1098581045, 1052586351)
		+ W(8, 1031741567, -1101857955, 1033605854, -1099888837)
		+ W(9, -1148110913, -1125555808, 1034608926, -1105779304)
		+ W(10, -1106457511, -1121665039, -1106685198, -1090380876)
		+ W(11, -1097784009, 1010307405, -1105861523, -1121200133);
	WS(1024108216, 1053619151);
	sum1 =
		W(0, -1110237276, 1036125123, -1105593599, -1116690717)
		+ W(1, -1138403916, -1118424632, -1118568038, -1117554448)
		+ W(2, -1117217830, -1104025987, 1053313098, -1107833238)
		+ W(3, -1112296045, -1108171422, 1025019530, -1113883668) + W(4, 1029541828, 1035829669, 1040682969, 1058976450)
		+ W(5, -1104638900, 1053496066, 997886569, 1047703644) + W(6, -1116974327, 1029841740, -1093167724, 1049118258)
		+ W(7, -1102593951, -1123704112, -1107943218, -1108512765)
		+ W(8, 1028000106, -1125285423, 1031701731, -1094097902)
		+ W(9, 1055269059, -1100830255, 1036129823, -1109656827) + W(10, 997960357, -1115997186, 1020700860, 1017239158)
		+ W(11, -1122615091, 1029941429, -1111217181, 1020926429);
	sum2 =
		W(0, -1119993039, 1038893624, -1105602869, -1106354535) + W(1, 1032998629, 998835515, -1119543359, 1026155597)
		+ W(2, -1109450011, -1096262037, 1055566572, -1158461197)
		+ W(3, -1117939535, -1108137959, 1037096144, -1114868339)
		+ W(4, 1040401784, 1053717996, 1043380434, -1105416337) + W(5, -1087999087, 1027244587, -1117843291, 1031605777)
		+ W(6, -1106582025, -1117988753, -1092886002, 1072933379)
		+ W(7, -1083385663, 1045359897, -1101171319, 1022787365) + W(8, 1033614749, 1000703247, 1034388956, -1081255560)
		+ W(9, 1066426555, -1093783038, 1051461624, -1100938466)
		+ W(10, -1147493015, -1114388777, 1043473668, 1043342555)
		+ W(11, -1094544057, 1045623937, -1102892249, 1041102940);
	WS(1062840044, 1036517115);
	sum1 =
		W(0, 1027882709, -1102360361, 1037386637, 1026327034) + W(1, -1102333276, 1042539613, -1113170154, -1117867630)
		+ W(2, 1024218619, -1119309706, 1051294017, -1105387538) + W(3, 1045232110, 1042423170, -1107171938, 1042893141)
		+ W(4, -1088734638, 1031157223, -1082181941, -1087289600)
		+ W(5, -1089919726, -1088061047, -1126992520, -1098512042)
		+ W(6, 1057788973, 1045291130, 1057574554, 1064725383) + W(7, 1056789371, 1052153154, -1124580994, -1109192172)
		+ W(8, 1032695796, -1107257205, 1039133128, 1024151288) + W(9, -1131902346, 1045762482, -1130270357, 1047580087)
		+ W(10, -1105941698, 1032367183, 1015412087, -1102302982)
		+ W(11, 1046746652, -1110282969, -1116552186, 1032060742);
	sum2 =
		W(0, -1128425377, 1027402769, -1122701285, 1029460017) + W(1, -1128656941, 1015114546, -1131912907, 1012677721)
		+ W(2, -1106124336, -1123408727, 1035952055, -1106291502)
		+ W(3, 1034330078, -1137130753, -1151273092, -1141059698)
		+ W(4, -1106789449, 1046361983, 1033758045, -1092942672) + W(5, 1022825967, 1043050798, 1026393205, -1114857397)
		+ W(6, -1116881359, 1040877836, -1092736894, -1089281400)
		+ W(7, 1067937621, 1057367901, -1100743964, -1116376233)
		+ W(8, -1108203604, 1041799035, -1110885432, 1058715791)
		+ W(9, 1060265099, -1090127289, -1100147508, -1085394823)
		+ W(10, -1154187588, 1037669599, -1106801609, 1044648045)
		+ W(11, -1104725901, -1099584998, -1114467924, 1048436512);
	WS(-1090906199, 1032077706);
	sum1 = W(0, -1133027020, -1121893314, 1023318639, 1029445080)
		 + W(1, 1001128051, 1034316233, -1103958128, 1035906358)
		 + W(2, -1114971356, 1044790618, -1123234602, 1040694938)
		 + W(3, 1035215242, -1102125462, 1043268297, -1122145747)
		 + W(4, 1042474992, -1113284386, 1041326284, -1105269270)
		 + W(5, -1090300845, 1049843289, -1131346756, 1025511402)
		 + W(6, -1109782777, 1033127972, -1090554926, 1053731809)
		 + W(7, 1054234875, -1098556565, -1121911775, -1113919963)
		 + W(8, 1040233361, -1105262125, 1034823031, -1109230339)
		 + W(9, -1098565414, 1042417542, 1026215817, -1122686272)
		 + W(10, -1113511763, 1025873725, 1011115622, -1129412204)
		 + W(11, 1038160135, 1018477632, 1009497794, 998364239);
	sum2 = W(0, 1010874613, 1031993168, -1110586713, 1035954309)
		 + W(1, 1034349301, -1122071401, -1140127141, 1029284667)
		 + W(2, 1030375188, -1098558104, -1116546039, -1089737673)
		 + W(3, -1094899703, 1053685859, -1108774266, -1124583674)
		 + W(4, -1115235366, 1051363302, 1056517150, 1057138262)
		 + W(5, -1098486858, -1093546729, 1034072089, -1122424073)
		 + W(6, 1049471257, -1094785947, 1031272431, -1102658594)
		 + W(7, -1112892354, 1046184196, -1109252950, 1037904141)
		 + W(8, -1100352469, 1040320218, -1111763071, 1043402933) + W(9, 1057577914, 1039716432, -1122970680, 958822899)
		 + W(10, 1040126787, -1131978284, -1124433226, 1027656919)
		 + W(11, -1092308561, -1116345243, 1016915650, -1140678181);
	WS(1065971990, -1117349785);
	sum1 = W(0, 1041698888, -1112126136, 1034826515, -1129568652)
		 + W(1, -1109843230, 1024013025, 1009653886, -1137279078)
		 + W(2, -1103591502, 1043874709, -1101299034, -1186542860)
		 + W(3, 1041410157, -1159955630, 1030113747, -1120752640)
		 + W(4, -1130045402, 1044992637, -1083999976, -1081978560)
		 + W(5, -1085461041, -1090063736, -1097631850, -1094129699)
		 + W(6, 1049080916, 1047240445, 1060703412, 1061790267) + W(7, 1058214583, 1059365054, 1049303674, 1052607100)
		 + W(8, 1009208654, -1121869537, -1123043996, 1028920692)
		 + W(9, -1105683576, 1011681824, -1125202109, 1021258909)
		 + W(10, 1021475879, -1134810027, -1144695867, 1017436104)
		 + W(11, -1131209785, -1139574520, 1000157667, 1022839599);
	sum2 = W(0, -1117014919, -1130364155, -1106662873, -1114007102)
		 + W(1, 1049348603, -1111037227, 1016435713, 1035610526)
		 + W(2, -1073720352, -1086725672, 1069712606, 1062079613)
		 + W(3, -1102930718, 1020707077, -1114426132, 1034066723)
		 + W(4, -1104300581, -1091483554, 1061376514, 1060429625)
		 + W(5, -1098979910, -1091915359, 1043583392, -1091474650)
		 + W(6, 1055286111, -1109695767, -1114136197, 1052661025)
		 + W(7, -1131131469, 1050631696, -1112682766, -1112601210)
		 + W(8, -1105567211, 1032269150, -1138351682, 1018497014)
		 + W(9, 1032920333, -1117367449, -1122101547, 1039950258)
		 + W(10, -1108683793, 1033653176, -1115525434, 1043366723)
		 + W(11, -1107942477, -1139459182, -1122885189, 1026792554);
	WS(-1087438700, -1079683283);
	sum1 =
		W(0, 1017584527, -1126645293, 1024510860, -1126938201) + W(1, 1025818403, -1163276521, 1040771729, -1160528892)
		+ W(2, -1111085935, -1110290014, 1033919541, 1049726143) + W(3, 1042036038, -1114444262, 1029908410, 1035428627)
		+ W(4, -1097724786, -1098381907, -1083731542, -1081500983)
		+ W(5, -1097215121, -1091706404, -1097070911, -1097940968)
		+ W(6, 1052950249, 1053593812, 1063649365, 1059087538) + W(7, 1052548297, 1057898452, 1045403069, 1052829673)
		+ W(8, -1112145065, -1106211842, 1003633557, 1023563130)
		+ W(9, 1019377518, -1104008328, -1115067299, 1032435766)
		+ W(10, 1032156829, -1129163939, -1118260846, -1120786763)
		+ W(11, -1116189667, 1023503580, -1112674412, 1015355644);
	sum2 = W(0, 1027460995, -1126036613, 1029366028, -1129309981) + W(1, 1020875062, 988377354, -1109676838, 1030688918)
		 + W(2, -1139353737, -1172793556, 1021322407, -1097919394)
		 + W(3, -1121912528, 1034370211, -1137199485, -1107628664)
		 + W(4, -1116062036, 1041340702, 1050063273, 1055277098)
		 + W(5, -1106551211, 1041415105, -1128558209, -1134721053)
		 + W(6, -1105887481, 1031879973, -1101108606, 1009470709) + W(7, 1047064096, 1034815104, 1034836242, 1049845283)
		 + W(8, 1043084390, -1108443334, 1031078409, 1041616760)
		 + W(9, -1107655532, 1018545561, 1014245687, -1104117922)
		 + W(10, -1112909236, -1144584219, -1116288208, -1099143154)
		 + W(11, -1100042276, -1108610892, -1111876576, -1123449114);
	WS(1044595630, -1081949232);
	sum1 =
		W(0, 1039675598, -1114551286, 1008233858, -1121252161) + W(1, 1033942172, -1122512668, 1026205083, -1118876117)
		+ W(2, -1112185757, 1041771076, -1113654239, 1036138408) + W(3, 1043328887, 1047911808, 1028532559, 1051948425)
		+ W(4, -1088266627, -1144202605, -1106609306, -1087961804)
		+ W(5, -1087619944, -1086197995, -1087181441, -1079365891)
		+ W(6, -1103352647, 1058269731, 1055957016, 1060473075) + W(7, 1062639593, 1055667963, 1042300482, 1051816684)
		+ W(8, 1051863744, -1102436935, 1041931682, -1105147684) + W(9, 1002098271, -1111264410, 1038991809, 1047648830)
		+ W(10, -1115854735, -1130126796, 1017898629, 1041818984)
		+ W(11, -1130413359, 1032948860, -1115140949, 1035539513);
	sum2 =
		W(0, 1050752765, -1102559074, 1004621594, -1106905815) + W(1, 1038134564, -1114858390, 999530010, -1104442024)
		+ W(2, -1087877559, 1042152886, -1095393630, -1106434273)
		+ W(3, -1099723068, 1036662936, -1101776331, 1054232067) + W(4, -1089125923, 1035361880, 1058416370, 1058355794)
		+ W(5, 1056388755, 1040360076, -1106345832, 1034476952) + W(6, 1063798323, 1052128007, 1062325475, -1120474523)
		+ W(7, 1051681161, -1096401119, -1106373450, -1089943559)
		+ W(8, 1013490077, -1090156566, -1094287538, -1101206197)
		+ W(9, -1100293430, -1104699402, 1048788631, -1113690608)
		+ W(10, -1098786735, 1029952535, -1116454071, 1025568531)
		+ W(11, 1009033997, 997069429, -1117506479, 1019208527);
	WS(-1082323244, 1081334754);
	sum1 =
		W(0, 1017652669, 1026074030, 1026308835, -1139023631) + W(1, -1124784756, -1157466090, -1151223253, -1123067319)
		+ W(2, -1114671162, -1101582293, -1102225205, -1128122150)
		+ W(3, 1047028384, 1041367009, 1037350457, 1018518877) + W(4, 1045686283, 1051997878, 1056290627, -1109179969)
		+ W(5, -1088067773, -1090935975, -1100014755, -1100605637)
		+ W(6, -1100397239, -1097273854, -1091487775, 1033600923) + W(7, 1058585755, 1058457225, 1047302995, 1040259816)
		+ W(8, 1040334760, 1036251335, 1044247257, 1034603313) + W(9, -1098471302, -1104671877, -1113240670, 1007040336)
		+ W(10, -1120290385, 1010893986, -1114193219, 1015477828)
		+ W(11, 1027532986, 1028455628, 1023216600, -1167442276);
	sum2 =
		W(0, 1021161720, -1130912565, -1130074229, -1117040706) + W(1, 1025588007, 1012731209, -1117264939, 1035821810)
		+ W(2, 1034310052, -1120070653, 1013066141, -1097167140) + W(3, -1126989997, 1035986228, 979500482, -1131150309)
		+ W(4, 1028060302, 1057895756, 1050008660, -1077198236) + W(5, 1036249174, 1061480822, 1036420478, -1114248001)
		+ W(6, -1111691904, 1060473449, 1048707954, -1071981659) + W(7, 1055589119, 1068029984, 1025639810, -1104930835)
		+ W(8, -1117456161, -1103940220, 1041027109, -1101172514)
		+ W(9, 1014637039, 1014223793, 1027808652, -1128414380)
		+ W(10, -1120681063, 1030806761, -1131293055, 1009545637)
		+ W(11, 1035622377, -1130249456, -1120874755, 1036288471);
	WS(1053726551, 1012659382);
	sum1 = W(0, 1032083097, -1115995457, 1025061558, -1122031383)
		 + W(1, 1038196358, -1115071689, -1130575936, -1113099877)
		 + W(2, -1106638998, 1034541187, -1115280977, -1104507249)
		 + W(3, -1114143426, 1029764374, 1031225348, -1102798468)
		 + W(4, -1098702088, -1098027112, -1088652495, -1092902123)
		 + W(5, -1085882325, -1097451113, -1098237300, -1111014420)
		 + W(6, 1047871676, 1032148771, 1060231518, 1065996118) + W(7, 1058126194, 1059563219, 1035470703, 1054581342)
		 + W(8, 998886703, 1042659740, -1106688851, -1104094145)
		 + W(9, -1102012910, -1121352461, -1128714910, 1000597622)
		 + W(10, 1022035144, -1112198366, 1034668492, 1024148149)
		 + W(11, 1010989620, 1012420282, -1123786037, 1024134712);
	sum2 = W(0, -1124504165, 1044199209, -1105768285, 1030597508)
		 + W(1, -1097181409, 1040834484, -1106395293, 1038991009)
		 + W(2, 1043258069, -1105860909, -1149580326, 1054859448)
		 + W(3, 1065166573, 1012576825, -1091772000, -1077787203)
		 + W(4, -1119272862, -1096303760, 1030851358, 1057797022)
		 + W(5, 1062380695, -1116955554, -1113754765, -1098893101)
		 + W(6, -1120765402, 1027333462, -1110802573, 1040041196)
		 + W(7, 1017534493, -1108797661, 1042765191, -1110880129)
		 + W(8, -1132584009, -1112573193, 1028533186, 1035436142)
		 + W(9, -1141430739, 1032147286, -1113752657, -1120959090)
		 + W(10, -1130103221, 1030769098, -1111917317, 1033418125)
		 + W(11, -1140263257, -1126074797, 1020067757, -1136443945);
	WS(-1091585367, -1096979755);
	sum1 = W(0, -1125210148, -1121704545, -1120024086, -1106223422)
		 + W(1, 1027649645, -1106879908, 1033259600, -1108105765)
		 + W(2, -1104771642, 1041680018, 1043362647, 1048656073)
		 + W(3, 1038801018, -1103521718, -1106174833, 1031226898)
		 + W(4, -1104387016, -1093500244, -1085845307, -1086139981)
		 + W(5, 971788283, -1124812374, 1011346436, -1119913673) + W(6, 1039960904, 1056326757, 1060708396, 1060053831)
		 + W(7, -1115241635, 1040958787, 995843043, 1040930453) + W(8, 1043768271, -1114046313, 1022927067, -1105827043)
		 + W(9, -1120254754, 1038747748, -1118768800, 1040461604)
		 + W(10, -1127914889, -1113011982, -1140249314, -1132509525)
		 + W(11, 1027284814, 1026834103, -1115807705, 1029803545);
	sum2 =
		W(0, 1007158722, -1117465525, 1020157105, -1115575087) + W(1, 1029731993, -1115951245, 1042169362, -1111020797)
		+ W(2, 1004004293, 1030693613, 1007550482, 1032793866) + W(3, -1104867994, -1111503366, -1101768383, 1042858280)
		+ W(4, -1123076619, 1034532408, -1101572236, 1059720067)
		+ W(5, -1112732963, -1098900155, -1132362761, -1101011815)
		+ W(6, -1109929145, -1107544976, -1110988335, 1067665797) + W(7, 1048427228, 1058832170, 1029991341, 1043396912)
		+ W(8, -1104848259, -1095482533, -1085485924, -1090269083)
		+ W(9, -1135504754, 1037004208, -1108400441, 1041064016)
		+ W(10, 1045822378, -1130708853, 1036333634, -1111111456)
		+ W(11, -1105802165, -1115747431, -1132122165, -1126685993);
	WS(1050761175, 1067771859);
	sum1 = W(0, 1007679755, 1016344868, -1111212068, 1035369236) + W(1, -1114152399, 1027679203, 1024513697, 1023429051)
		 + W(2, -1103008542, 1051881455, -1113694143, 1057165115)
		 + W(3, 1030154052, -1119705863, 1037582923, -1106945041)
		 + W(4, -1117542415, -1099208581, -1094852820, -1086714990)
		 + W(5, -1087862176, -1098820035, -1101037788, -1098056967)
		 + W(6, 1040506400, 1050438683, 1036449755, 1067282489) + W(7, 1049754336, 1030273979, 1048082428, 1020854026)
		 + W(8, -1107587308, -1138473483, -1102372368, 1045850761)
		 + W(9, -1112794889, -1111030523, -1114576136, 1000524418)
		 + W(10, -1123566389, 1035136294, -1110750261, 1047098321)
		 + W(11, -1108921199, -1158006009, 1025557440, 1029171882);
	sum2 =
		W(0, -1108377721, 1043256577, -1098471532, 1048495965) + W(1, -1103576309, 1036658009, -1107738492, 1030436882)
		+ W(2, 1042939389, -1092756549, -1140040329, -1094992475)
		+ W(3, 1017276157, -1104050853, 1032200565, -1104348148)
		+ W(4, -1118508723, -1136988785, -1099870420, 1064902851)
		+ W(5, 1045749581, 1045838269, -1110226959, 1042649061) + W(6, -1101760284, 1050996294, -1098704018, 1062859454)
		+ W(7, -1089477514, -1157061765, 1046491511, -1106567852)
		+ W(8, 1037932369, -1104406221, 1015984185, -1098855018)
		+ W(9, 1025174042, -1121418697, -1106492592, 1027657606)
		+ W(10, -1111488356, 1040203060, -1103619810, 1045571731)
		+ W(11, 1025902034, -1107737652, 1044444185, -1105647758);
	WS(1057448172, 1069108917);
	sum1 =
		W(0, 1025232554, -1128422002, 1032607415, -1106129908) + W(1, -1141856298, 1015221011, 1010040610, 1026592994)
		+ W(2, -1116799928, -1123655391, -1111298160, -1119092894)
		+ W(3, 1044964179, -1128617181, -1116425884, 1015937075)
		+ W(4, -1100727837, 1037047614, -1102160962, 1036246919)
		+ W(5, -1088316592, -1116622467, 1027658969, -1102536008)
		+ W(6, 1055215485, -1104723136, 1056783106, -1165535249) + W(7, 1049606186, 1044617768, -1132120236, 1042573835)
		+ W(8, -1106508548, 1040448906, -1103004521, 1040745899)
		+ W(9, -1132962087, -1103456342, 1037741920, -1118303623)
		+ W(10, -1139419762, 1006660815, 1016236833, -1123853933)
		+ W(11, 1016605067, -1160895193, 1018376479, -1120915345);
	sum2 =
		W(0, -1128749003, -1091479855, -1124909389, 1030767422) + W(1, 1028475536, -1118686225, -1133507353, 1003197653)
		+ W(2, 1042697161, 1061865996, 1067634595, -1111988197) + W(3, -1102439466, -1117920963, 1022976741, 1008285339)
		+ W(4, -1101835107, -1097573200, -1083343720, -1090130192)
		+ W(5, 1055493018, 1027292464, 1030733458, 1002427213) + W(6, 1038607216, 1026943422, -1110364223, -1089515454)
		+ W(7, -1090714326, -1101900071, 1033968573, 1033064671)
		+ W(8, -1108371617, -1114744392, 1035072621, 1054823097)
		+ W(9, 1059932372, 1031097460, -1132241300, -1101772178)
		+ W(10, 1031384482, 1026017402, 1036186174, -1104718688)
		+ W(11, 1024781950, -1110105890, 1040128898, 1026666744);
	WS(1065065708, -1125796377);
	sum1 = W(0, -1112144555, 1029634469, -1112840237, 1034269757)
		 + W(1, -1122801969, -1133240789, 1016754760, -1119164014)
		 + W(2, -1106943759, 1025116330, -1105630541, -1106751530)
		 + W(3, 1023923175, 1041797158, -1113089188, -1130226634)
		 + W(4, 1017193539, -1112668180, -1112954809, -1096457447)
		 + W(5, -1094266089, -1096385878, -1106190977, -1114305030)
		 + W(6, 1048634147, 1027133034, 1055950575, 1060800975) + W(7, 1051425450, 1041695411, 1044103184, 1036967948)
		 + W(8, -1127916040, 1026809557, -1112907992, -1093799807)
		 + W(9, -1103940357, 1039766276, -1130590086, 1008751883)
		 + W(10, -1132404112, 1004217594, -1111964638, 1038388364)
		 + W(11, -1132895812, 1013909417, 1032062573, 992673732);
	sum2 =
		W(0, 1043431555, -1109692118, 1036275465, -1111890182) + W(1, -1102288351, 1045724738, -1109691788, 1007408138)
		+ W(2, -1098806978, 1046643695, -1097975189, 1048664613)
		+ W(3, 1049750262, -1098934938, 1032869755, -1111259526) + W(4, 1024222598, 1045861043, -1101643320, 1058544270)
		+ W(5, -1098883379, 1049188212, -1107029975, 1048185689)
		+ W(6, -1105154239, 1054740901, -1083291725, 1068703829)
		+ W(7, -1080748028, 1058055770, -1100454574, -1148294292)
		+ W(8, 1031236307, 1035789437, 1007109846, -1081353417) + W(9, 1031821902, -1100833476, 1051695731, -1114785167)
		+ W(10, 953732840, -1115663935, 1042301531, 1035678115)
		+ W(11, -1120166561, 1047454611, -1096856793, 1041528279);
	WS(1061652844, 1044003957);
	sum1 = W(0, -1118715405, 1029075868, -1115471369, 1032954233)
		 + W(1, 998963525, -1111723799, 1036011862, -1152687195) + W(2, 1022617806, 1045689305, -1094261862, 1027529537)
		 + W(3, -1099266912, 1045678528, -1119248992, -1108410990)
		 + W(4, 1044034950, 1030904095, 1059625182, 1057470859) + W(5, 1062131070, -1098407445, 1047156095, 1037164834)
		 + W(6, -1101088515, -1103346936, -1096538237, -1086691558)
		 + W(7, -1094363880, -1105378993, -1123294521, 1016045215)
		 + W(8, 1019688911, 1045834099, -1102841294, 1041319556)
		 + W(9, -1166277444, 1028040508, -1135804811, -1106724595)
		 + W(10, -1131961856, -1110934572, 1036052922, -1148682371)
		 + W(11, 1017830866, -1109411965, 1030886475, -1123601124);
	sum2 =
		W(0, -1123087716, -1122327585, 1034911826, -1115300382) + W(1, -1147444258, 1031538244, -1122824244, 1026384688)
		+ W(2, -1115107680, -1105390433, 1034185422, 1042081129) + W(3, 1036682846, 1043195731, -1112377777, 1024479380)
		+ W(4, 1039737456, -1106584843, 987338697, -1094697399) + W(5, 1048628369, -1100913302, 1041194171, 1036768370)
		+ W(6, 1045652727, -1139899009, 1060423005, -1103292099)
		+ W(7, -1079464406, -1102260713, -1101961861, -1106123677)
		+ W(8, -1106100707, -1102201417, -1111505321, -1094374885)
		+ W(9, 1066067653, 1062702469, 1013733313, 1034543612) + W(10, -1128513463, -1114704327, 1009548801, 1026056400)
		+ W(11, -1112497116, -1107096307, -1125635761, 1037241080);
	WS(1061983340, -1091535279);
	sum1 =
		W(0, -1154828523, 1027504414, -1131271078, -1120408436) + W(1, -1131629652, -1122568783, -1165314478, 995201141)
		+ W(2, -1133965299, -1128653831, -1114200663, -1129743238)
		+ W(3, -1117839504, 1035797658, -1115205249, 1019503421) + W(4, 1043906007, 1027190112, 1061948198, 1054216086)
		+ W(5, 1062537731, 1028696552, 1045640431, 1044774081) + W(6, -1118138894, -1097538828, 1027560685, -1081158944)
		+ W(7, -1089869577, -1097887897, -1111951485, -1105384996)
		+ W(8, -1109842717, 1037523079, -1106988467, 1048594270)
		+ W(9, -1121464863, 1028427349, -1121440284, -1119142300)
		+ W(10, 1025343169, -1121887129, 1023298667, -1108007945)
		+ W(11, 1034422373, -1120763036, 1008081777, -1122356070);
	sum2 =
		W(0, 995087446, 1030495116, 1007114937, -1121939088) + W(1, -1109334595, 1012755199, 1031009559, -1123906524)
		+ W(2, 1036608468, -1099055008, -1115487063, 1057848194)
		+ W(3, -1106051731, 1015526929, -1118519790, 1024955281) + W(4, 965233164, -1104807397, -1070882050, 1075270016)
		+ W(5, 1059573542, -1102771000, 1023903156, -1159976683)
		+ W(6, 1033021468, -1107407110, 1038417178, -1094462735) + W(7, 1039375650, -1124510890, 1016192349, 1023974018)
		+ W(8, -1114419070, 1033869233, -1103406865, 1051754977) + W(9, -1104596666, 1028405316, -1111745826, 955743793)
		+ W(10, 1033025046, -1119280070, 1028798922, -1120762821)
		+ W(11, 1018124826, 976567206, 1015800189, -1129936862);
	WS(1062927532, 1035014202);
	sum1 = W(0, 1039522007, 1034505951, 1040732909, 1002357921) + W(1, 1016035605, -1122944943, 999726956, -1140151454)
		 + W(2, -1114736246, -1109500450, 1011271190, 1044028441) + W(3, 1050061010, 1042353405, 1036129025, 1041525964)
		 + W(4, 1037103646, 1048942600, 1053278895, -1097469770)
		 + W(5, -1085392865, -1094832633, -1103977959, -1111797875)
		 + W(6, -1104897563, -1092956200, -1091146839, -1093973369)
		 + W(7, 1051214559, 1050975197, 1043068615, -1126246883) + W(8, 1044380938, 1044086236, 1044239087, 1042916452)
		 + W(9, -1112456671, -1111813313, -1112116510, -1110444494)
		 + W(10, -1121785378, 1027254073, -1145709740, 981579331)
		 + W(11, 1035761861, 1033165606, 1025151372, 1033358643);
	sum2 = W(0, 1038528863, 1036214533, 1049223347, -1113699843)
		 + W(1, 1041716852, -1100571883, 1017295180, -1101978327)
		 + W(2, -1084044031, -1091834288, -1110305241, 1042795689)
		 + W(3, 1050774414, 1043118649, 1047177880, 1050263507) + W(4, -1082440456, -1077502553, 1049812579, 1068178608)
		 + W(5, -1092073446, 1047476754, 1034666293, 1054410728) + W(6, 1050939225, -1095085693, 1050231565, 1060273714)
		 + W(7, -1115682722, -1105112612, 1050691511, -1101197699)
		 + W(8, 1053868195, 1028074081, 1046376147, -1132635925)
		 + W(9, -1098688235, 1017697398, -1092800689, -1104788145)
		 + W(10, -1113963371, -1114781385, 1035810200, -1160679206)
		 + W(11, 1036026944, 1016345266, 1040315316, -1112282035);
	WS(-1086906028, 1058773265);
	sum1 = W(0, -1132629757, 997844200, 965362145, -1106996409)
		 + W(1, -1153797548, -1120050655, -1122322046, 1015091632)
		 + W(2, 1044191380, 1043197109, -1125429564, 1033453658)
		 + W(3, -1118095697, -1121403972, -1119804562, 1026125167)
		 + W(4, 1032367334, 1050808506, 1058285756, 1062016570) + W(5, 1044397873, 1043993638, 1042486572, 1047754366)
		 + W(6, -1096691584, -1095732027, -1086608026, -1081591954)
		 + W(7, 1041881517, -1096430215, 1002316636, -1099777504)
		 + W(8, -1152318558, 1042781664, 1034636741, 1043388193) + W(9, 1045470808, -1115428219, 1018594522, 1024196285)
		 + W(10, -1109034905, 1031594505, -1119832870, -1106441585)
		 + W(11, -1149103576, -1113585524, -1135705587, -1122333654);
	sum2 = W(0, 1048104076, 1038532068, -1129915388, -1101156186)
		 + W(1, -1128179824, -1128045264, -1131782160, -1109473444)
		 + W(2, -1096548381, -1086001730, -1083843015, 1035944594)
		 + W(3, -1102068111, 1044127780, -1114990278, 1041203218)
		 + W(4, -1107021820, -1131935456, 1060056432, 1066609131)
		 + W(5, 1027352212, 1048571914, -1120175088, 1038985844) + W(6, 1018456960, 1007620609, 1033171254, 1050949241)
		 + W(7, -1107874139, -1104179329, 1038875644, -1112054433)
		 + W(8, -1136070657, 1040453646, -1111662792, -1110531416)
		 + W(9, -1104445548, -1127646596, -1110249452, 1034344442)
		 + W(10, -1112321878, 1033875386, -1117768272, 1032538050)
		 + W(11, -1114035189, 1032855260, -1144805954, -1130080864);
	WS(1046014126, 1065769758);
	sum1 = W(0, 1012096182, -1112076254, -1100987245, -1106802021)
		 + W(1, -1106286530, -1129503003, 1021132153, -1112401299)
		 + W(2, -1121314108, 1039437825, 1043473803, 1045721640)
		 + W(3, 1049347084, -1109380841, 1049245244, -1120677869)
		 + W(4, -1091239207, -1094624040, -1091961473, -1088552177)
		 + W(5, -1089539427, -1091526873, -1091375076, -1088888106)
		 + W(6, 1052142286, 1048611696, 1060125676, 1062377804) + W(7, 1053897896, 1057150062, 1048631067, 1057709495)
		 + W(8, 1042130570, -1109865911, -1128757714, -1119711185)
		 + W(9, -1128945819, -1119080717, 1034078686, -1122337355)
		 + W(10, 1019346753, -1152131961, -1123465492, 1039063160)
		 + W(11, -1114302645, 1015225093, -1135518836, 1014030866);
	sum2 =
		W(0, -1089976447, -1078304891, -1071851632, -1070679577)
		+ W(1, -1081022179, -1113339548, 1011136331, 1035458322) + W(2, 1064913799, 1068350548, 1070575185, 1072673707)
		+ W(3, 1063744071, -1128451504, 1040942179, -1115281660) + W(4, -1094573985, 1019506715, 1065710309, 1065504629)
		+ W(5, 1056839493, -1124929726, -1106886716, -1111465381)
		+ W(6, -1109226965, -1120561974, 1002672995, -1098180006)
		+ W(7, -1117214353, -1111255228, 1028658493, 1033265670) + W(8, 1030445629, 1021062218, -1127826384, 1031139735)
		+ W(9, -1112765526, 1037321868, -1127063938, 1001938923) + W(10, -1115506338, 1018259030, 1012290398, 995896746)
		+ W(11, 1010152224, -1118014213, 967860273, -1119523230);
	WS(-1096468055, 1053785380);
	sum1 = W(0, -1110473361, 1020813409, -1111899059, 1027946631)
		 + W(1, 1003556839, -1143096715, 996386562, -1123588698)
		 + W(2, -1116957735, -1114360891, -1123200592, -1090968927)
		 + W(3, -1107232681, -1117882342, -1118523124, -1105979736)
		 + W(4, 1034879511, -1114475674, -1109008383, 1066746382) + W(5, 1064704330, 1046069775, 1042611044, 1040361862)
		 + W(6, 1017136705, -1111337627, 1028379180, 1051825655)
		 + W(7, -1094442401, -1129057075, -1114700263, 1022269000)
		 + W(8, -1116669644, -1135792006, -1105125143, -1094808947)
		 + W(9, -1116312257, -1106172505, -1135525501, -1106276184)
		 + W(10, -1118632404, -1120549867, -1162426624, -1173354793)
		 + W(11, -1119514205, -1113957025, -1130080208, -1123525720);
	sum2 =
		W(0, -1127419095, -1140125367, 1028088432, -1126099139) + W(1, -1114986450, 1024738032, -1114843176, 1023949256)
		+ W(2, -1122531649, 1025350612, -1123116186, 1020760995) + W(3, 1019570567, 1039021380, 1018690059, -1119198021)
		+ W(4, -1111543417, -1108347637, -1101718819, 1056423339)
		+ W(5, 1073762237, -1100544782, 1049061203, 1026425060) + W(6, 1043407189, 1028851928, 1048774619, -1086358248)
		+ W(7, -1076137651, 1044261707, -1099227611, -1123270518)
		+ W(8, 1013519927, -1117946771, 1041147594, -1112971994)
		+ W(9, -1118107520, 1015761083, -1111772147, 1027419728)
		+ W(10, -1134679399, 991440379, -1127107007, -1115422093)
		+ W(11, 1037345920, -1103403994, 1042824177, -1129333383);
	WS(-1089097708, -1091261619);
	sum1 = W(0, -1127316247, -1113526029, -1118797136, -1123552881)
		 + W(1, -1123795687, 1015138359, -1129675572, -1126584008)
		 + W(2, 1003986316, -1120011361, 1046355762, -1103137072)
		 + W(3, -1103576251, 1032220600, -1120446878, 1027028747)
		 + W(4, -1111263852, -1112997295, -1081822066, -1100403388)
		 + W(5, 1053114278, -1138618770, 1007314666, -1123471427) + W(6, 1044425283, 1047767320, 1061869832, 1058200050)
		 + W(7, -1092855018, -1160534136, 1034662460, 1018063772)
		 + W(8, 1033605983, -1118942860, -1110810403, 1009152314)
		 + W(9, 1046189751, 1031283151, 1016196275, -1128724178)
		 + W(10, -1116984894, -1121673366, 1027944882, -1124559262)
		 + W(11, -1131347855, -1118591413, -1131488026, -1122517738);
	sum2 =
		W(0, -1151923233, 1026311687, 1025121279, -1123775834) + W(1, 1033596173, -1105542037, 1035290939, -1108107550)
		+ W(2, 1040701127, -1109901381, 1034378939, -1092342947)
		+ W(3, -1096202739, 1051958537, -1098166743, 1047977685)
		+ W(4, -1110923755, 1024679085, -1080291839, 1071256357)
		+ W(5, 1042190483, -1103925783, 1046386099, -1114731953)
		+ W(6, -1103532415, 1016651554, -1082840291, 1066054209) + W(7, 1056834874, -1199035157, 1035522294, 1030555165)
		+ W(8, 1041909162, 1036375055, -1110170843, -1090243220)
		+ W(9, -1097275958, 1038401459, -1113079432, 1015019440)
		+ W(10, -1121169096, -1135341024, 1041541680, -1128413506)
		+ W(11, 1043004954, -1097944284, 1042529081, -1099750845);
	WS(1061142188, 1045552914);
	sum1 = W(0, 1022384747, 1019603337, 992843677, 1025369499) + W(1, -1149984013, 1030794181, -1123167236, 1034453383)
		 + W(2, 1020461367, -1114371061, -1137489184, -1128616851)
		 + W(3, -1114859644, -1134916072, -1114858116, 1009189588)
		 + W(4, 1058732728, 1054684529, 1060634392, 1056292747) + W(5, 1061516204, 1058073341, 1052882077, 1050605022)
		 + W(6, -1095805239, -1098135841, -1085459239, -1081060320)
		 + W(7, -1083596540, -1097701630, 1026645922, -1099032542)
		 + W(8, -1101590238, -1123665301, 1027392977, -1124699057)
		 + W(9, 1038698931, -1106352164, 1006025241, -1100750969)
		 + W(10, 1033080372, 1031766591, -1123755612, -1116775033)
		 + W(11, 1034158665, -1134014242, 1037240581, -1122655396);
	sum2 =
		W(0, 1041010686, -1100296712, 1042377248, -1124701214) + W(1, 1002573079, 1026372231, -1107309152, 1022594646)
		+ W(2, 1045355628, -1110840017, 1028443719, -1097271182) + W(3, -1108318217, 1034868187, 1032249619, 1034940919)
		+ W(4, -1091459780, -1109934927, -1120459763, 1068946970)
		+ W(5, 1048538630, -1095496747, -1112114883, -1096153349)
		+ W(6, -1092997038, -1109499465, 1023984711, 1068602839)
		+ W(7, 1049236461, -1112347607, -1088682480, 1036467963)
		+ W(8, 1025085151, -1110570114, -1120816159, -1090645327)
		+ W(9, 1036483715, -1110453128, -1121128467, -1105549173)
		+ W(10, 1019331790, -1115246837, 1025130703, 1036287199)
		+ W(11, 1028224647, -1106754238, 1040581836, -1106253388);
	WS(-1090464684, 1058848194);
	sum1 = W(0, 1038070654, -1104784595, -1140651524, 1048797564)
		 + W(1, -1115845272, -1115304422, 1022142646, 1026901973)
		 + W(2, 1035807069, -1106022588, -1107342224, -1112865880)
		 + W(3, -1102596230, -1117573217, 1011767229, -1105151431)
		 + W(4, 1059156269, 1027584334, 1060192817, 1062566262) + W(5, 1060113046, 1043041013, 1054886405, 1057383999)
		 + W(6, -1091590511, -1104101108, -1084437581, -1088742755)
		 + W(7, -1087393870, -1095911543, -1102839322, -1088896680)
		 + W(8, 1049775661, -1100086527, 1050662239, 1037690576) + W(9, 1050391262, -1117869728, 1042443855, 1039830925)
		 + W(10, -1111666744, -1128618637, -1128690758, -1097281200)
		 + W(11, 1024450616, -1151911514, -1131868338, -1104457275);
	sum2 =
		W(0, -1106952896, 1050458431, -1084179073, -1068828969) + W(1, -1082769727, 1054525389, -1098029126, 1038352192)
		+ W(2, -1173421195, -1100970530, -1117103305, 1049093414)
		+ W(3, 1015202727, -1093960872, 1043872404, -1107157710) + W(4, -1113206734, 1037511626, 1063723378, 1078393261)
		+ W(5, 1065452472, -1106048166, 1031385535, 1030855073)
		+ W(6, -1136957987, 1029901269, -1106205415, -1105390455)
		+ W(7, -1128426057, 993579659, -1114758982, 1034755506) + W(8, -1152575873, -1116273053, 1039247706, 1034474614)
		+ W(9, 1032907306, -1100143257, -1155923695, 1034533524)
		+ W(10, -1112584615, 1045345833, 1031320371, -1099252776)
		+ W(11, 1035573879, 1040309898, -1124055116, -1124561432);
	WS(-1106782638, -1120193880);
	sum1 = W(0, 1020741911, 1021367862, 1038644232, -1126436322) + W(1, 1043522250, -1112066734, 1018349205, 1033129938)
		 + W(2, -1116040418, -1121939617, -1109539853, -1098608828)
		 + W(3, -1101880327, 993980163, -1115252655, -1133833389) + W(4, 1053259451, 1050945756, 1055524943, 1065255335)
		 + W(5, 1061719830, 1048874997, 1051405991, 1042923217)
		 + W(6, -1112821605, -1100446872, -1091353929, -1085596156)
		 + W(7, -1096552606, -1090468372, -1106280862, -1102788916)
		 + W(8, -1101282812, 1049499553, -1100504250, -1101475552)
		 + W(9, 1025835692, -1114054607, 1027947689, -1104899626)
		 + W(10, -1111424287, -1129092267, 1016236516, 1033532871)
		 + W(11, 1022700239, -1114668904, -1147278953, 1028803059);
	sum2 =
		W(0, -1113068388, 1036673453, -1118880240, 1028813378) + W(1, -1107832014, 1027909744, -1122240512, 1011592783)
		+ W(2, -1115580494, 1024834555, -1115483686, -1117546792)
		+ W(3, 1043490929, -1105092918, 1040415904, -1119502452)
		+ W(4, 1039529972, -1098466798, 1043501593, -1115055672)
		+ W(5, -1117282076, 1042504898, -1107365158, -1112704202)
		+ W(6, -1091718951, 1052150318, 1043613567, 1062484975) + W(7, 1045088246, -1094456673, 1030923561, -1123953380)
		+ W(8, -1076395174, -1080701891, 1068474066, 1066750300)
		+ W(9, -1097140180, 1049333443, -1109881554, 1043999999)
		+ W(10, 1046645532, -1104586573, 1009076111, -1093753132)
		+ W(11, 1036864955, 1022104546, 1033514298, -1115391680);
	WS(-1093231703, 1042706757);
	sum1 = W(0, 1032826937, 1026075841, 1032961819, 1036684171) + W(1, 1034757510, 1036416025, 1015758976, 1040004261)
		 + W(2, 1040624182, 1000558899, -1110755278, -1127770315)
		 + W(3, -1106938311, 1019575916, -1114624210, 1042264396) + W(4, 1058499572, 1052553144, 1061343357, 1062021249)
		 + W(5, 1060752603, 1057695045, 1051786740, 1058906011)
		 + W(6, -1084803183, -1099119122, -1083389465, -1081334022)
		 + W(7, -1087386813, -1090036539, -1098198604, -1088285503)
		 + W(8, -1104136529, 1025447538, -1114092422, -1112317122)
		 + W(9, -1132554758, -1109030926, 1012060669, -1096739300)
		 + W(10, 1041579305, 1031885534, 1032264780, 1018739433)
		 + W(11, 1031902455, 1037874311, 1027119072, 1035404188);
	sum2 = W(0, -1134545280, -1101426979, 1012752443, 1036306510)
		 + W(1, 1034320105, -1111393843, 1046638158, -1108867307)
		 + W(2, 1057942802, 1047102485, 1055001204, -1096203167)
		 + W(3, -1114902087, -1096420171, -1101073471, -1091559913)
		 + W(4, -1072425931, -1084592242, -1079302223, -1123894686)
		 + W(5, 1062181631, 1062084093, 1064536824, 1073505700)
		 + W(6, -1067197419, -1071603316, -1077093049, -1098326846)
		 + W(7, 1072541263, 1067609499, 1073214169, 1078744623) + W(8, 1049446840, 1042726179, 1050812050, -1129334697)
		 + W(9, -1097319760, -1093274589, 1001153868, -1094526709)
		 + W(10, 1074141781, 1060445087, 1060645469, 1037955576)
		 + W(11, -1094473234, -1087350702, -1085693573, -1077663090);
	WS(-1075107862, 1049521772);
	sum1 = W(0, 1027861131, 987763517, -1129668766, 1033675992) + W(1, 1016072268, 992091051, 1026084697, -1120420163)
		 + W(2, 1045206278, 1041173528, 1032319275, 1040210256) + W(3, 1041485791, 1044520444, 1042655839, -1112688453)
		 + W(4, -1086495609, -1097093508, -1086275954, -1081944455)
		 + W(5, -1082045908, -1096923684, -1093981119, -1094413520)
		 + W(6, 1051717721, 1049572700, 1055584810, 1064397290) + W(7, 1059363461, 1055988184, 1051323143, 1050124978)
		 + W(8, 1033503081, -1116084523, 1009361560, 995768539) + W(9, -1112276757, -1112468587, 1005879363, 1033578820)
		 + W(10, 1031434621, -1144572069, -1140119493, 1027980366)
		 + W(11, -1129633421, 1024276072, 1000619058, 1025196738);
	sum2 = W(0, 1033523983, -1107297920, -1109353447, -1097553497) + W(1, -1102290887, 987526362, 1022298470, 944749371)
		 + W(2, -1091543751, -1125142534, -1100365589, -1121112319)
		 + W(3, -1119424675, -1094244068, 1033606211, -1100627225) + W(4, 1048034710, 1031510683, 995045613, 1061520608)
		 + W(5, 1042981818, -1103162896, 1052169844, -1098189213)
		 + W(6, 1051542012, -1103344470, -1120961303, 1061214811)
		 + W(7, -1094266425, 1043830132, 1041952964, 1041818078)
		 + W(8, 1024239879, -1117305947, -1099173366, 1044020024)
		 + W(9, -1093433218, 1046119446, 1043499670, -1096785580)
		 + W(10, 1041022978, -1121264057, -1115033235, 1053722991)
		 + W(11, -1097363289, 1047286054, -1106943326, 1031561067);
	WS(-1097146583, -1102489480);
	sum1 = W(0, -1121239074, 1035066361, -1110655283, 1032257412)
		 + W(1, 1020382076, 1014217354, 1032256145, -1120529307)
		 + W(2, -1102624204, 1033907292, -1104909116, -1109600459)
		 + W(3, -1113387282, -1114213060, -1114763275, -1123950514)
		 + W(4, 1041928668, -1096659727, -1123609439, -1091326393)
		 + W(5, -1105975127, -1098203983, 1045101428, -1093952115)
		 + W(6, 1043173384, 1051162503, 1057278053, 1050132159) + W(7, 1049365769, 1049080395, 1033542535, 1055699093)
		 + W(8, -1118777253, -1108685857, -1102566959, -1100309385)
		 + W(9, -1101876333, 1040792061, -1121020400, 1035959564) + W(10, 1016656554, 995611334, 1009112868, 1037330963)
		 + W(11, -1111738159, 1033561904, -1149295615, -1122689753);
	sum2 =
		W(0, 1030001048, -1107119695, 1023713698, -1115026335) + W(1, 1024715164, -1112691697, 1024758511, -1147275412)
		+ W(2, 1039849292, -1106305989, 1019090837, 1035696383) + W(3, 1036481868, 1023388499, -1146519572, -1112564365)
		+ W(4, -1106927121, 1060202814, -1104587624, 1057308499)
		+ W(5, 1047684818, -1112160637, -1093257675, 1041456307) + W(6, 1046837828, -1095733546, 1043085465, 1053508746)
		+ W(7, 1034862818, 1046794790, -1094465043, -1083960309) + W(8, -1131959957, 1012779430, 1026454649, 1038120705)
		+ W(9, 1037173687, -1101425448, 1036335613, -1094791365)
		+ W(10, -1116147800, -1124391765, 1028873647, -1104339358)
		+ W(11, 1045294658, -1119391248, -1156574008, 1012709310);
	WS(1057303084, -1084740383);
	sum1 =
		W(0, 1025949163, 1023904890, 1033327896, 1022060320) + W(1, -1131905805, -1114170862, 1021513971, -1109381346)
		+ W(2, -1105987664, -1104417576, -1097440039, -1106403568)
		+ W(3, 1043670267, 1041763972, 1037885311, 1019385429) + W(4, 1034968156, 1048292239, 1057303604, -1134851644)
		+ W(5, -1082452830, -1089247692, -1093401571, -1097845612)
		+ W(6, -1097863693, -1093717272, -1088500414, 1058205452) + W(7, 1059877080, 1058731430, 1046703382, 1049842950)
		+ W(8, 1046214631, 1042713619, 1043920086, 1041892896) + W(9, -1101986947, -1107457363, -1110573172, 1031126152)
		+ W(10, -1130932027, -1126920426, 1012093510, 1040636140)
		+ W(11, 1028551783, 1041063330, -1143718184, 1016340900);
	sum2 =
		W(0, -1097593869, 1040446621, -1107347821, 1036994425) + W(1, 989701019, 1043906150, 1040271244, 1016581730)
		+ W(2, -1100989715, 1036240143, -1105186205, -1119554977)
		+ W(3, 1048367016, -1095197585, -1102913875, 1041272891) + W(4, 1026566131, -1100851860, 1046892012, 1069594194)
		+ W(5, -1107809286, 1031148367, 1038853877, -1105136265) + W(6, 1061153405, 1047874592, -1103469514, 1074408805)
		+ W(7, -1110319007, -1079941721, 1042791078, -1086296266)
		+ W(8, 1050695083, -1096668864, -1104864053, -1103368475)
		+ W(9, -1100341899, -1084422687, -1093040701, -1099178193)
		+ W(10, -1095509343, 1040237386, -1114614656, 1040210470)
		+ W(11, -1105386934, 1031716423, 1036206107, 1042594729);
	WS(-1085311468, 1078025451);
	sum1 = W(0, -1114246985, -1123523234, -1123774423, 1017942127)
		 + W(1, 1018695644, -1134274761, 973249598, 1032511109) + W(2, 1033236492, 1042717314, 1046675224, 1030027079)
		 + W(3, -1107516674, -1105985470, -1118366597, -1108369993)
		 + W(4, -1126048573, -1100167817, -1090923842, 1002547123)
		 + W(5, 1061445386, 1051174149, 1032724353, 1047097650) + W(6, 1051596674, 1050764301, 1057423711, -1138337956)
		 + W(7, -1085962671, -1101362115, -1098415672, -1105953621)
		 + W(8, -1110129580, -1101525701, -1102550347, -1117387765)
		 + W(9, 1045061525, 1037275627, 1033244340, 1025818592)
		 + W(10, -1109388771, 1021849401, 1031509177, -1126623147)
		 + W(11, -1118825262, -1107617348, -1124427728, -1115961017);
	sum2 =
		W(0, -1123353384, 1030359787, 1024787123, 1015567503) + W(1, -1115408082, 1026077135, -1137211259, 1015951538)
		+ W(2, -1131031713, -1114557735, -1125418898, -1132430472)
		+ W(3, 1029672716, -1118070691, -1125125186, -1135395683)
		+ W(4, 1029311455, -1123787418, -1099438470, 1049323738) + W(5, 1042547290, 1050505809, -1110579463, 1040847724)
		+ W(6, 1047725718, 1042470619, -1106551206, -1097880179)
		+ W(7, -1089568094, -1166364565, -1115324497, 1028809582)
		+ W(8, 1051601031, -1121374979, 1049816965, -1088308991)
		+ W(9, -1098255621, 1026888229, -1112338809, -1102185033)
		+ W(10, -1113968956, 1045218010, 1044805763, 1039658119)
		+ W(11, 1042126156, -1115384233, 1043221816, 1014731468);
	WS(1060142060, 1042832150);
	sum1 = W(0, 1031397804, -1121488955, 1033996248, 1018827426) + W(1, -1131717262, 1033609702, 1010765225, 1029196868)
		 + W(2, 1036648197, -1142445829, -1117943062, -1111782928)
		 + W(3, -1108508447, -1106903604, 1015606653, -1115637854)
		 + W(4, 1052129567, 1051097024, 1054892021, 1065668620) + W(5, 1059881804, 1058770516, 1050176059, 1054801908)
		 + W(6, -1093104885, -1094159296, -1086111346, -1081757070)
		 + W(7, -1087336873, -1090845580, -1100487494, -1126749404)
		 + W(8, -1125587404, -1138833071, 1028704007, 1032794495)
		 + W(9, 1047817147, -1104469332, 1038701961, -1091639031)
		 + W(10, 1030014814, 1024131190, 1024270930, -1123778927)
		 + W(11, 1022586319, -1125662417, 1032196289, 1019613157);
	sum2 =
		W(0, 1016709191, 1013621039, -1134054043, 1033829499) + W(1, -1133247239, 1014723479, 1025542948, -1113297030)
		+ W(2, 1043282989, -1105412866, 1034830675, -1123744731)
		+ W(3, -1107183956, -1110083630, -1115844306, -1097083153)
		+ W(4, -1105914972, 1048947993, -1104630078, -1088942993)
		+ W(5, -1093767876, 1055362845, -1111303066, 1064727508)
		+ W(6, -1104055195, 1038685325, -1084033248, -1072142874)
		+ W(7, 1073971039, 1076386430, -1098251720, -1090433741)
		+ W(8, -1113893232, -1143937773, -1103493551, -1098435347)
		+ W(9, 1052470850, -1104225446, 1051939911, -1091328171) + W(10, 1031619176, -1128320153, 990218298, 1026126526)
		+ W(11, 1042783259, -1103699955, -1123473137, 1025388740);
	WS(-1086199532, 1054743650);
	sum1 = W(0, 1034444474, 1027498242, 1040848158, 1023783640) + W(1, 999869046, -1115850147, 1025498402, -1134397103)
		 + W(2, 1032011277, -1095519909, -1107222607, -1152811127)
		 + W(3, 1044283945, 1044573214, 1036275699, -1123084051) + W(4, 1048862696, 1053262121, 1061389071, 1030342167)
		 + W(5, -1084989084, -1095010778, -1106712265, 1032418005)
		 + W(6, -1097849454, -1090625833, -1084999869, -1113365765)
		 + W(7, 1060145155, 1054594461, 1045643928, 1033574715) + W(8, 1006964268, 1040908045, 1038795271, 1038235355)
		 + W(9, -1104327823, -1101807134, -1122717633, 1015954881)
		 + W(10, 1027368614, -1113781807, -1118338586, -1108967739)
		 + W(11, 1006059384, 1028815960, -1124545277, -1135640905);
	sum2 =
		W(0, -1098769930, 1041383757, 1031909130, 1040055926) + W(1, -1112037460, 1040275414, -1111784639, -1113621249)
		+ W(2, 1042608106, -1089209738, -1102323575, -1105226719)
		+ W(3, -1124786133, -1117623756, -1131302943, 1048083051)
		+ W(4, -1101852353, -1121408570, -1108783974, 1065973699)
		+ W(5, 1049738412, 1057999228, -1111524780, 1025491254) + W(6, -1093087039, 1038811718, -1089123880, 1069194195)
		+ W(7, 1026907074, -1106112227, 1020629449, -1107530612)
		+ W(8, -1139600545, -1093098827, -1121335963, -1098519743)
		+ W(9, -1089198426, -1101165651, -1109243346, 1048264427)
		+ W(10, 1036192806, -1121276186, 1045867083, 1023817866)
		+ W(11, 1042688929, -1122635193, 1041146873, -1095495518);
	WS(-1090983255, -1089207473);
	sum1 =
		W(0, 1011536056, 1031895551, -1113368985, 1041335941) + W(1, -1112820133, 1033755607, -1120463213, 1029129223)
		+ W(2, -1126565928, -1113602338, -1111099810, -1099647257)
		+ W(3, -1102367072, 1030939267, -1111909392, 1034973975) + W(4, 1055178415, 1054038520, 1055473117, 1064470249)
		+ W(5, 1063942234, 1050197537, 1058279198, 1042393881)
		+ W(6, -1101680475, -1097154360, -1089575247, -1084973552)
		+ W(7, -1086493203, -1097159533, -1096914715, -1096995926)
		+ W(8, -1102945718, -1121652462, 994604183, -1121284913)
		+ W(9, 1041044307, -1111487017, 1017418960, -1111098786) + W(10, 1026884961, 990918528, 1022227241, -1151944468)
		+ W(11, -1119623498, 1029397803, -1127714823, 1024652821);
	sum2 =
		W(0, 1008868714, 1000134020, -1131179173, 1026383992) + W(1, -1108980541, 1033178726, -1113100227, 1025874080)
		+ W(2, -1138668162, 1023930211, -1108628571, -1114490385)
		+ W(3, 1047990867, 1030525898, -1131668265, -1138114226)
		+ W(4, 988655570, -1099344177, -1064898888, -1066369231) + W(5, 1075540559, 1086324754, 1049763634, -1100090533)
		+ W(6, -1108603395, 1041622837, -1131013053, -1087427617)
		+ W(7, -1095163420, 1057379348, 1040828448, -1109206595) + W(8, 1033342078, 1025638720, -1133763810, 1033730604)
		+ W(9, -1117896039, 1031531103, -1119632759, 1025251971)
		+ W(10, 1018452757, -1115444075, 1023801183, -1118168395)
		+ W(11, 1033324797, -1116567631, 1028372534, -1128577333);
	WS(-1109283164, -1114463829);
	sum1 = W(0, 1026307305, 1010065376, 1036887575, 1032762791) + W(1, 1038442146, 1036926348, 983730417, 1042339968)
		 + W(2, 1048505142, 1006853751, -1122796048, -1121781501)
		 + W(3, -1106474773, -1140109366, -1113784606, 1033209828)
		 + W(4, 1056046207, 1051849183, 1060373686, 1062361681) + W(5, 1060935143, 1058739944, 1052729243, 1060958338)
		 + W(6, -1087851802, -1096622464, -1086026376, -1080983673)
		 + W(7, -1086759863, -1088322398, -1098544579, -1085562739)
		 + W(8, -1097387850, 1034233556, -1106692609, -1116217316)
		 + W(9, -1136008963, -1111740214, 973353381, -1098996574)
		 + W(10, 1043738183, 1033008793, 1030721871, 1031320492)
		 + W(11, 1024808165, 1037732587, 1028455576, 1032429188);
	sum2 =
		W(0, 1033103311, 1036675590, 1035316039, -1139597621) + W(1, -1104037187, 1036924272, -1111374359, 1033604811)
		+ W(2, -1088826877, -1093870598, -1096260803, 1038770367)
		+ W(3, -1120383141, 1054470917, 1048854624, 1052968175) + W(4, 1076551262, 1064863709, 1066303868, 1054257493)
		+ W(5, -1086745184, -1080791393, -1081541832, -1074269835)
		+ W(6, 1082157528, 1075036637, 1074566779, 1054121358)
		+ W(7, -1075712309, -1075955022, -1073360354, -1068055688)
		+ W(8, -1088761642, 1044533603, -1088656095, -1096732938) + W(9, 1026461691, 1058516172, 1036676016, 1036957577)
		+ W(10, -1073488400, -1083381518, -1087052440, 1034260530)
		+ W(11, 1055295113, 1062460380, 1061463967, 1072405502);
	WS(-1073690779, -1087724268);
	sum1 = W(0, 1020006630, 944113971, 1028328440, 1026519064) + W(1, 1023877839, 1026744019, -1116930962, 1037411798)
		 + W(2, 1040645890, 1024788392, 1048604230, -1124203663)
		 + W(3, 1026558293, -1108217132, 1024907750, -1124509669)
		 + W(4, 1037569760, 1033313762, 1026748704, -1097395091) + W(5, 1058432566, 1052406658, 1046357449, 1052615509)
		 + W(6, 1040537741, 1022063376, 1037819609, -1081034849)
		 + W(7, -1089181115, -1095782133, -1103915032, -1095058991)
		 + W(8, -1102207443, -1117962707, 1018608989, 1030158086) + W(9, 1048090929, 1028902900, 1040820950, 1037074644)
		 + W(10, 1011752087, 1010250996, 1035208397, -1107990331)
		 + W(11, 1030700463, -1115106384, 1006665970, -1120315546);
	sum2 =
		W(0, 1036147454, -1115074830, -1143660011, -1109526737) + W(1, -1113309480, 1006285882, -1115649745, 1026243607)
		+ W(2, 991782552, 1025479068, -1111873890, 1054093522) + W(3, 1016478163, 1035621794, 1027286665, -1108696429)
		+ W(4, -1100036784, -1096384442, 1042154750, 1036720443) + W(5, 1015496998, -1111840809, 1028637267, 1024623035)
		+ W(6, -1102354425, 1031211776, -1098733186, 1061883500)
		+ W(7, 1040999099, -1099055155, -1117281017, -1120753705)
		+ W(8, -1132125723, -1114551496, -1120425773, 1042458762)
		+ W(9, -1118319659, 1021928735, -1113807339, 1033776741)
		+ W(10, 1037581214, -1107514244, 1036528495, -1113752408)
		+ W(11, -1131440878, 1009305230, -1115311515, -1117838632);
	WS(1053167575, 1034582410);
	sum1 =
		W(0, 1023109013, -1105499654, 1047073940, -1103829756) + W(1, -1134567319, 1029509866, -1107075490, 1028951523)
		+ W(2, -1135820801, 1041430288, -1099071824, 1051022760)
		+ W(3, -1103780951, 1038026111, -1144576488, 1034415069)
		+ W(4, -1107146278, 1045138183, 1006706653, -1098544246)
		+ W(5, 1035133548, -1101742889, 1040882462, -1110494113)
		+ W(6, 1042183330, 1015167422, -1110119411, -1114407921) + W(7, 1029794991, 1025810371, 1020673517, -1144644710)
		+ W(8, -1106326923, 1048594337, -1101264321, 1042439875)
		+ W(9, -1115149997, -1124355817, -1133994400, 1017843520)
		+ W(10, 1038375967, -1103059717, 1036901240, 1019390619)
		+ W(11, -1122256838, 1039002364, -1113322768, 1025775953);
	sum2 =
		W(0, 1007469645, 1024932078, -1123529450, -1106895484) + W(1, -1154152567, 1026396887, 1034932657, -1118589447)
		+ W(2, -1127684796, -1122451669, 934668744, 1046133075)
		+ W(3, 1050482770, -1100501045, -1112663810, -1145059796)
		+ W(4, 1026289720, 1029479215, 1048216767, -1101979386)
		+ W(5, -1086100405, -1104578417, -1110628430, -1120799353)
		+ W(6, -1134400734, -1114161855, -1092503803, -1118826374)
		+ W(7, 1054881826, 1054831843, 1037309396, 1034243151) + W(8, -1121586613, 1018968072, 1055026065, 1057475450)
		+ W(9, 1057991283, 1037697257, 1041220013, 1035239909) + W(10, 1012304630, 1018258842, -1105610792, -1091642753)
		+ W(11, -1094138317, -1097381938, -1108645190, -1109776821);
	WS(1065106092, 1009251236);
	sum1 =
		W(0, -1127594260, 1015119794, -1105935716, 1030756271) + W(1, 1015463627, 1033714469, -1121831017, 1032817313)
		+ W(2, -1119086128, 1041681344, 1038033220, -1103164984)
		+ W(3, -1097628571, -1096661826, -1162082196, 1037645501)
		+ W(4, -1106710454, -1108480942, -1085761952, 1048660750) + W(5, 1062385221, 1057312254, 1045270286, 1038003425)
		+ W(6, 1041658930, 1053952044, 1059673337, 1035410928)
		+ W(7, -1083076739, -1097132616, -1100422942, -1134248242)
		+ W(8, 1028936149, -1098626929, -1106493133, 1042075767) + W(9, 1048795361, 1042769246, 1033263484, -1109564844)
		+ W(10, 999711717, -1128362792, 1030156593, -1105711219)
		+ W(11, -1109139763, -1109546740, -1128821631, -1113038632);
	sum2 = W(0, 1026504012, -1115537349, 1004448402, -1120289237)
		 + W(1, -1116193727, 1023273402, -1106169890, -1116296115)
		 + W(2, -1111982251, -1109318355, -1126991046, -1114485349)
		 + W(3, 1031030421, 1036795295, 1038895038, 1037382021) + W(4, -1115575890, 1037274256, 1032461625, 1046084064)
		 + W(5, -1104386736, 1033981186, 1034486696, 1014573341) + W(6, 1025515301, 1036029355, -1105715099, 1035923056)
		 + W(7, 1039615788, 1034803763, -1111316562, -1126611440)
		 + W(8, 1038047283, -1140512157, 1031934837, -1127252256)
		 + W(9, 1008094609, -1108137243, 1013721630, -1109430807)
		 + W(10, -1121134093, -1118959675, 966777949, 1001443794)
		 + W(11, -1126229172, 999509622, -1115420717, -1121268263);
	WS(1058235500, 1054922309);
	sum1 = W(0, -1126843838, -1115091447, 1037063794, -1097782353)
		 + W(1, 1017345397, -1106496120, -1124168315, -1111050604)
		 + W(2, -1110452882, 1026999796, 1027596138, 1043595317) + W(3, 1026915457, 1051692426, 1033470169, 1047889704)
		 + W(4, -1096439037, -1109530936, -1126567064, -1080972858)
		 + W(5, -1087153329, -1092439359, -1096481402, -1101856358)
		 + W(6, 1054965252, 1035486938, 1052521111, 1054616871) + W(7, 1059777872, 1055199219, 1049045985, 1042302776)
		 + W(8, -1126708475, 1040994960, 1048136923, -1135709192)
		 + W(9, -1117730271, 1025849689, -1109862614, 1048178521)
		 + W(10, -1113819273, -1112039092, 1029145158, -1103625129)
		 + W(11, -1113712109, -1133876016, -1120397392, 1018059916);
	sum2 = W(0, 1032658614, 1026047005, 1016793814, 979115576) + W(1, 1025048255, -1120340424, -1124528004, -1113479651)
		 + W(2, -1104671284, 1026757765, -1106565422, 1040092458)
		 + W(3, -1118382609, 1024555245, -1115048442, -1102456829)
		 + W(4, 1033357456, -1146410551, -1129670058, 1049738304)
		 + W(5, 1047130549, -1099524683, -1114147283, -1143577495)
		 + W(6, -1107649550, -1093450531, 1029536101, 1048902638) + W(7, 1043845633, 1031379649, 1015256822, 1032535412)
		 + W(8, -1107785448, 1045006287, 1032863350, 1031141497)
		 + W(9, 1024835039, 1016575718, -1115840886, -1140327483)
		 + W(10, 1014985523, -1108588814, -1114405495, 1032866808)
		 + W(11, -1128051766, 1011865867, 1016407002, -1121997281);
	WS(1050344663, 1040331465);
	sum1 =
		W(0, -1119034750, 1027008397, -1123135107, 1034001074) + W(1, -1165785906, -1109811775, 1012082163, 1021442477)
		+ W(2, -1123846924, 1032620906, -1107606109, -1113228665)
		+ W(3, -1104523524, 1044228977, -1136436803, 1015486907) + W(4, 1038870821, -1145305726, 1045963311, 1055978044)
		+ W(5, 1061494191, 994921841, 1043858443, 1032566715) + W(6, 1016005498, -1104369525, -1101093248, -1091899011)
		+ W(7, -1089807144, -1100340494, -1113047285, -1121306753)
		+ W(8, -1113185550, 1047408652, -1106188838, 1019406818)
		+ W(9, -1133495032, 1039673315, 1003314783, -1110918342)
		+ W(10, -1180899430, -1117862216, 1031141157, 1025902913)
		+ W(11, 995937181, -1126170822, -1155810234, 1012720916);
	sum2 = W(0, 1017323653, 983063098, -1124332548, -1136855038)
		 + W(1, 1038193266, -1115428487, 1037749325, -1162541650) + W(2, 1006857268, 1027629321, 1040636195, 1050922570)
		 + W(3, -1107256285, 1024268384, -1105738834, -1112368096)
		 + W(4, 1027026905, 1041250623, -1098379711, -1095854749)
		 + W(5, -1124475180, -1107079153, 1035306909, 1041041721)
		 + W(6, -1096858156, -1096058068, -1081757810, 1046692173)
		 + W(7, 1055388353, 1044471504, 1018283467, 1034757871) + W(8, 1057582691, 1069736593, -1098564102, -1092586095)
		 + W(9, -1101296593, -1099842491, -1130236866, -1116072515)
		 + W(10, -1108630874, -1103954988, 1039138402, 1040290673)
		 + W(11, 1026430908, -1135051275, -1127494735, -1128054004);
	WS(1064629676, -1098084920);
	sum1 =
		W(0, 1033302207, 1017176603, 1043155505, 1036523218) + W(1, -1135635048, 1036902751, -1154473427, 1031815708)
		+ W(2, 1017516913, 986968687, -1093133598, -1136867787)
		+ W(3, -1099849236, -1112073298, 1015173986, -1108314079) + W(4, 1037844037, 1048067236, 1059745345, 1054752956)
		+ W(5, 1054803234, 1049105955, 1045303547, 1049045791) + W(6, 1004101612, -1094217842, -1107275372, -1083111259)
		+ W(7, 1036740290, -1089373007, 1007182507, -1096296960)
		+ W(8, -1100831258, 1032944847, -1118901210, -1111571193)
		+ W(9, -1104247276, 1044914424, 1032262742, 1028425028) + W(10, 1023773169, 1036346276, -1109611315, 1036061697)
		+ W(11, -1130856180, -1178541510, 1028817260, -1121119813);
	sum2 =
		W(0, 1031116538, 1018758860, -1093507837, -1142239225) + W(1, 1008547208, -1115133937, 1037272918, -1116833334)
		+ W(2, -1106561538, 1041892626, 1060901401, -1094547881) + W(3, 1048344650, -1106548880, 1031802380, 1032935937)
		+ W(4, 1041324255, -1122918288, -1090730175, 1059998586)
		+ W(5, -1105692057, -1107738784, -1109731964, -1105354579)
		+ W(6, -1097318271, 1050772655, -1089173269, 1050575163)
		+ W(7, -1105982083, 1062167006, -1115007264, 1051274636)
		+ W(8, 1038093550, -1113042451, -1103574570, -1096117806)
		+ W(9, 1045224094, -1093777588, 1040225760, -1097190188) + W(10, 1003684433, 1005733025, 1036702490, 1007559836)
		+ W(11, -1111284039, 1032209739, -1119496571, 1039213738);
	WS(1059570988, -1104849743);
	sum1 = W(0, 1015935639, -1114327981, 1032097032, -1100671580)
		 + W(1, -1118415719, -1146837726, -1128662677, -1106017873)
		 + W(2, -1105217736, -1117057793, 1045549308, 994695167) + W(3, 1019924475, 1044124420, -1133264506, 1026902699)
		 + W(4, -1100062838, -1095539196, -1097913193, -1081463016)
		 + W(5, -1088685699, -1103538521, -1090424260, -1096642336)
		 + W(6, 1055580097, 1051203348, 1057098153, 1065307314) + W(7, 1060408535, 1060044676, 1048658511, 1058793797)
		 + W(8, -1114680436, -1104422643, 1035503236, -1100709080)
		 + W(9, -1100882497, -1127513406, -1106885414, -1112552037)
		 + W(10, 1027695934, -1122995670, 1026067698, -1115820943)
		 + W(11, -1121911751, 1040976712, -1109730008, 1032897105);
	sum2 = W(0, -1101738300, 1026251680, -1096487254, -1097132336)
		 + W(1, -1103125896, -1098301296, -1145491968, -1102991820)
		 + W(2, -1102635520, 1042860418, -1118004862, -1097577131)
		 + W(3, 1034939290, -1107323885, 1046219299, -1101571742) + W(4, 1049960021, 1045813894, 1012147620, 1062244087)
		 + W(5, 1030928730, 1018590462, 1042676852, 1048890187) + W(6, -1107186076, 1037904592, -1101520598, 1050699569)
		 + W(7, -1118944274, 996952385, -1132230456, -1120981264)
		 + W(8, 1031463651, 1043360780, -1099464580, 1042220045)
		 + W(9, -1129575892, -1143727552, 1038679603, 1022002534)
		 + W(10, -1109595133, 1032162510, -1144663840, 1017587638)
		 + W(11, -1122088198, -1112243029, 1028948530, -1108091801);
	WS(-1095386967, -1111219145);
	sum1 = W(0, 989878260, -1130549149, 1027494660, 1027516453) + W(1, -1138329195, 1029536895, 1016226972, 1031794584)
		 + W(2, 1046105185, -1114353482, -1126247292, -1101798869)
		 + W(3, -1109199416, -1149170463, -1110945897, 1041043200)
		 + W(4, 1042696371, 1044731284, 1059356463, 1066759339) + W(5, 1060963410, 1056388995, 1052477254, 1048385630)
		 + W(6, -1089927208, -1092958347, -1090136954, -1086407791)
		 + W(7, -1086208082, -1087382795, -1099705531, -1090430272)
		 + W(8, -1127509006, 1029760895, -1123276603, -1134143337)
		 + W(9, 1037957160, 1028489291, 1033794703, -1116367629) + W(10, 1030962098, 1015099027, 1002268463, 1008759050)
		 + W(11, 1030926587, 1024487352, 1027177352, -1155852515);
	sum2 =
		W(0, 1037152773, -1155239869, -1110337901, 1031799544) + W(1, -1115579003, 1027082675, -1125050611, 1027786160)
		+ W(2, -1107393101, -1118272906, -1121008946, 1040803769)
		+ W(3, 1040826838, -1129277077, 1044810576, -1128372019)
		+ W(4, -1107499267, -1123365743, 1053226346, -1091451910)
		+ W(5, 1036591998, 984589146, -1111221822, -1115106721) + W(6, -1071982339, -1066777138, 1065602467, 1078719649)
		+ W(7, 1072207876, 1012365693, -1114663567, 1027240586) + W(8, 1050177526, -1099174901, -1114100047, 1051522302)
		+ W(9, -1112448128, 1036247818, 1024897040, 1010421237)
		+ W(10, 1034063245, -1111285661, -1111810642, 1032887971)
		+ W(11, -1105619991, 1027337883, -1128259763, -1110086921);
	WS(-1090330604, -1095913405);
	sum1 = W(0, 1020138108, -1123891981, 1027835331, -1104251929)
		 + W(1, 1036891437, -1115340623, 1034060158, -1111402939)
		 + W(2, -1155846064, -1158857313, 1042832881, 1026174194)
		 + W(3, 1041459232, -1107002233, 1043482052, -1101325435)
		 + W(4, -1089580553, -1099259748, -1086143680, -1083565678)
		 + W(5, -1087459168, -1094838563, -1096454718, -1097944271)
		 + W(6, 1060107168, 1041623909, 1061453552, 1065434151) + W(7, 1058328348, 1058061687, 1046178603, 1056232524)
		 + W(8, 1026904097, 1034391623, -1115844409, -1108664129)
		 + W(9, -1103857816, -1108388469, -1124051644, -1124315511)
		 + W(10, -1129005794, 1027969480, -1126805065, 1015124739)
		 + W(11, -1133565543, 1018898230, -1128371111, 1016813002);
	sum2 =
		W(0, -1123501879, 994818552, 1024190209, 1026428551) + W(1, -1113685733, 1033345966, -1113104927, 1032770548)
		+ W(2, 1032645553, -1106534525, 1041404870, -1104982451) + W(3, 1042593674, -1115833227, 1034301013, 1019409377)
		+ W(4, 1031823713, 1055123028, 1003420836, -1080276792) + W(5, -1127504591, 1051480126, -1116624943, 1017007809)
		+ W(6, 1073269342, 1086127434, -1097366650, -1064048639)
		+ W(7, -1073275019, -1090368136, 1039074558, -1104405577)
		+ W(8, 1039470942, -1106004733, 1048036108, 1029604730) + W(9, -1102930579, -1127043711, 1016207563, 1023925896)
		+ W(10, -1134706270, -1108902493, -1131894299, 1040747994)
		+ W(11, -1114192145, 1028687353, -1110363669, 1028902826);
	WS(-1090401964, -1152005757);
	sum1 = W(0, -1107975723, 1027213860, -1098681011, 1041527967)
		 + W(1, -1104614908, -1117487349, -1139447119, -1114124023)
		 + W(2, -1110378885, -1114833045, -1110030634, -1088517567)
		 + W(3, -1108968043, -1117626874, 1013150495, -1107640642)
		 + W(4, -1108756369, -1095679285, -1106296032, 1070380432)
		 + W(5, -1108442736, -1098750614, -1103582017, -1109258534)
		 + W(6, 1036253290, -1126602324, 1055690689, 1071039479) + W(7, 1052643167, 1027420045, 1037720897, 1028231256)
		 + W(8, -1114963960, 1031108853, -1100045596, -1089232274)
		 + W(9, -1099409217, -1149243844, -1112117145, 1004205268)
		 + W(10, -1113670180, -1122691487, -1107558750, 1041737494)
		 + W(11, -1114805320, -1114809497, -1129003237, -1115685308);
	sum2 = W(0, 1032241318, -1099535875, 1055385702, -1088862448)
		 + W(1, 1049303281, -1109469239, -1107728961, -1128383244)
		 + W(2, -1104603794, 1042476400, -1090035137, 1058560544)
		 + W(3, -1088861159, 1052772694, -1098593341, 1040732759)
		 + W(4, -1110024851, 1036274242, -1088795135, 1070638870)
		 + W(5, -1093985609, -1106832655, 1040915158, -1094544594)
		 + W(6, 1040884292, -1098717699, 1054345172, 1049287225) + W(7, 1045145516, 1028821082, -1095210561, 1053404675)
		 + W(8, -1102517567, 1017815860, -1094964358, 1049908300)
		 + W(9, -1104972980, -1121780800, 1046695263, -1097835418)
		 + W(10, 1041491703, -1106264274, 1050847172, -1097728340)
		 + W(11, -1120926078, 1040141480, -1097969166, 1042680505);
	WS(-1070853435, -1079594702);
	sum1 =
		W(0, 1031368074, -1129832370, 1034753191, 1015854174) + W(1, 1034404179, 1016952500, -1121119193, 1030231874)
		+ W(2, 1015638464, 1041167744, 1035847262, -1103546680) + W(3, -1113675090, 1024462894, 1024493276, -1128491667)
		+ W(4, -1114370347, -1117069532, -1123068615, 1064504443) + W(5, 1061831318, 1053421228, 1039689052, 1047845552)
		+ W(6, -1115839497, -1102391672, -1103157041, -1091637800)
		+ W(7, -1080200908, -1096184888, -1127920108, -1114780422)
		+ W(8, -1115223191, 1027397066, -1112317379, -1115479934)
		+ W(9, 1034003429, 1024063661, 1021986479, -1108195108) + W(10, 1032466078, 1017764904, 1032880216, -1129698458)
		+ W(11, 1015162251, -1140051844, -1133040549, -1121925385);
	sum2 = W(0, -1106137478, 1043473407, -1106937584, 1026389244)
		 + W(1, -1112665680, 1037682857, -1122471729, -1132137458)
		 + W(2, -1112484873, -1102332364, -1092913054, -1107744995)
		 + W(3, -1097742336, 1043622402, 1020098037, 1022975237) + W(4, 1057355655, -1095817987, 1065744344, 1065853704)
		 + W(5, -1081387458, -1127502696, -1107102958, -1141866869)
		 + W(6, 1035747177, -1115086293, 1023360745, 1072123343)
		 + W(7, -1079419356, -1106562006, -1106082519, -1126279403)
		 + W(8, -1121112608, -1132505032, -1113186427, -1092294539)
		 + W(9, -1121542644, 1037780507, 1042075138, 1036152561)
		 + W(10, -1111886750, 1028632460, -1106034045, 1034294011)
		 + W(11, 1024287965, 1025382780, 1002478149, -1184105122);
	WS(1049779927, -1112776705);
	sum1 =
		W(0, 1028071903, -1114011991, 1029458468, -1119065733) + W(1, -1132325110, 1021654911, -1140102008, -1114327724)
		+ W(2, -1118237477, 1043483133, 1007633232, 1035764138) + W(3, 1035328577, 1034435922, -1138188744, -1122000063)
		+ W(4, -1102803275, -1098367878, -1088820906, -1094340312)
		+ W(5, -1080604425, -1090240908, -1148292210, -1113705707)
		+ W(6, 1029391902, -1104983021, 1052808064, 1066199650) + W(7, 1053987355, 1056392483, 1036299814, 1048826612)
		+ W(8, 1034486619, 1030141823, 1041927295, 1028311666) + W(9, -1120802495, 1033716813, -1137351220, 1019304377)
		+ W(10, -1146402448, 1024272361, -1136262168, -1116603171)
		+ W(11, 1022508086, -1120600656, -1178578023, 1020743116);
	sum2 =
		W(0, 1032570045, -1105084280, 1038138439, -1106537061) + W(1, 1040196930, -1115643975, 1030892929, -1115802712)
		+ W(2, 1038214390, 1026252154, 1040403525, -1094267982) + W(3, -1111441511, -1113353460, 1041615042, 1045634969)
		+ W(4, -1105258373, 1013797397, -1089116471, 1076181184)
		+ W(5, -1077048432, 1025617857, -1099622062, 1030853641) + W(6, 1049712324, -1092505394, 1060934721, 1059180753)
		+ W(7, -1094660144, -1116351798, -1112051433, 1036834683)
		+ W(8, -1104412018, -1106628914, -1095609080, -1100140938)
		+ W(9, -1105239307, 1035183993, -1108612586, -1126459673)
		+ W(10, -1123221706, 1042796766, 997194667, 1031304969)
		+ W(11, 1025898916, -1113508292, 1036578837, -1114596985);
	WS(1046079918, -1101410372);
	sum1 = W(0, -1119247786, 1028420729, -1112243383, 992275696)
		 + W(1, -1122025413, -1106451742, 1031954516, -1132155589)
		 + W(2, -1128322399, 1041896248, -1105916230, 1048641796)
		 + W(3, -1106854731, 1031954663, 1008473970, -1111364501) + W(4, 1042510685, 1041276767, 1052547749, 1049660162)
		 + W(5, 1058242473, 1042746961, 1045913078, 1038481040) + W(6, 1040172212, 1029165630, -1093769957, -1086983984)
		 + W(7, -1090223605, -1101840568, -1131429676, 1034663574)
		 + W(8, -1102544268, 1023180436, -1094151845, 1051181214)
		 + W(9, 1034028133, 1035662026, -1136064862, -1123376855)
		 + W(10, -1115138862, 1035447066, -1116787216, -1126725978)
		 + W(11, 1020616971, -1106918309, 1031591591, -1113758304);
	sum2 = W(0, -1141998719, -1145824639, 1031031156, 1020781312)
		 + W(1, 1022361784, 1035727822, -1106658345, 1018984000)
		 + W(2, -1109775790, -1114337335, 1035421278, -1094152732)
		 + W(3, 1019796096, -1109500163, -1126048860, -1133379360)
		 + W(4, 1044487768, 1032184652, -1118695686, 1023745864) + W(5, 1018742928, 1044822196, 1018234504, 1040264262)
		 + W(6, -1123003936, -1105393491, 1043275908, 1060925239)
		 + W(7, 1035441608, -1129786704, -1154747838, -1114483694)
		 + W(8, -1128896096, -1105870753, -1123077850, -1116720242)
		 + W(9, 1005384511, -1106753069, -1109895735, -1115363912)
		 + W(10, -1116651188, 1028260552, -1117301622, -1118185274)
		 + W(11, -1111756371, 1028382728, -1112885074, 1013789936);
	WS(1065850966, 1065849900);
	sum1 = W(0, -1148044715, 1016251913, -1121600570, -1122606683)
		 + W(1, -1119487441, -1123929445, 1022387720, -1113618935)
		 + W(2, 1023026535, 1037817733, 1025496281, 1030608138) + W(3, 1035148220, 1038603949, 1040789578, 1029056085)
		 + W(4, -1096615656, -1090259708, -1086496425, -1089114938)
		 + W(5, -1087399018, -1089721837, -1091666965, -1090055623)
		 + W(6, 1051437895, 1044690723, 1060547800, 1067874188) + W(7, 1061971613, 1051923078, 1020371139, 1050691807)
		 + W(8, 1037565454, 1031445334, -1123828273, -1103278290)
		 + W(9, -1103477215, 1017932657, 1017045638, 1041207209)
		 + W(10, 1009078433, -1134993406, -1122338716, 961099943)
		 + W(11, -1115158089, -1152593000, 1017681054, 1032486406);
	sum2 =
		W(0, 1035054009, -1100085534, 1050236106, -1106312974) + W(1, 1040394388, -1111006317, -1122528690, -1120327060)
		+ W(2, 1029203106, 1055497340, -1099101530, -1091493710) + W(3, 1035688516, -1100130836, 1051271785, 1037370697)
		+ W(4, -1095822387, -1094806083, -1112580467, 1065636371)
		+ W(5, 1057422694, 1038056034, -1090043318, -1101753600)
		+ W(6, -1096883389, 1022251406, -1105263591, 1066985993)
		+ W(7, 1050729384, -1113669663, -1109365057, -1098907474)
		+ W(8, -1106861506, 1025821768, -1099047212, -1090221894)
		+ W(9, 1040303734, -1095697855, -1132012078, 1042447412)
		+ W(10, 1003858895, -1141198631, 1038164225, 1007864647)
		+ W(11, -1131632326, 1034223408, 1022279531, -1111449439);
	WS(-1097113303, -1098536273);
	sum1 = W(0, -1128711506, 1001100740, -1116245678, -1123204686)
		 + W(1, -1122390725, 973480529, -1135175840, -1112078369)
		 + W(2, 1026190055, -1129782332, 1036959597, 1010531062) + W(3, 1040533155, 1032146359, 1016950072, -1115082484)
		 + W(4, -1089449919, -1090119792, -1089233276, -1088111001)
		 + W(5, -1083999320, -1100399617, -1096337083, -1098983064)
		 + W(6, 1051085133, 1054274400, 1059231684, 1068549146) + W(7, 1060528017, 1051645044, 1021720363, 1056811397)
		 + W(8, 1039600836, 1006971045, 1035061810, -1106500579)
		 + W(9, -1110173729, -1118570949, -1105366950, -1163217111)
		 + W(10, 1017357112, -1151099700, 1008174399, 1027830380)
		 + W(11, -1118330949, -1138008953, -1113983621, -1114515356);
	sum2 = W(0, -1126544110, -1106788080, -1123763395, 1031886252)
		 + W(1, 1019879781, -1106896864, 1025236903, -1103198659)
		 + W(2, 1057867675, 1045040387, -1116688865, 1008770068)
		 + W(3, -1111977015, -1104133845, -1123575137, -1095297610)
		 + W(4, -1084782762, -1103936041, -1096694543, 1065118928)
		 + W(5, -1120781351, -1094413904, 1055216743, 1063595180)
		 + W(6, -1101472514, -1095964817, 1033632512, 1070094219)
		 + W(7, -1093909441, -1091348732, -1087869152, -1101379604)
		 + W(8, 1046930113, 1060484868, -1098897900, 1055777327)
		 + W(9, -1105350592, -1098592917, 1032159773, -1090856164)
		 + W(10, 1047938716, -1116398073, 1033301960, -1112910333)
		 + W(11, -1132175940, 1028498658, -1111429301, -1148399072);
	WS(-1088872108, 1052196610);
	sum1 =
		W(0, -1115772244, 1026268067, 1022683057, -1119255225) + W(1, -1126845407, 1018606696, -1122729971, -1119390253)
		+ W(2, -1114837443, -1111544357, -1104977249, -1110507588)
		+ W(3, -1124752108, -1106979958, -1118779367, 1032957370)
		+ W(4, 1040729928, -1129315660, 1050293045, -1115663356) + W(5, 1055556797, 1038400791, 1043464385, 1010467373)
		+ W(6, 999143576, 1051137549, 1050616762, -1123488747) + W(7, -1107532492, -1115698508, -1106851872, 1013947482)
		+ W(8, 1035543595, -1115388138, -1110255664, -1102766242)
		+ W(9, -1115121626, -1111362474, -1114761165, -1127308771)
		+ W(10, -1109636323, -1138847608, -1148093909, -1113579532)
		+ W(11, 1031428336, -1123058305, 1024891874, -1117161611);
	sum2 =
		W(0, 1021571414, 1005045849, 1032761087, -1131955840) + W(1, 1002892889, -1113636159, 1017257782, -1116947723)
		+ W(2, -1136485425, -1108696907, 1015124882, -1109877489)
		+ W(3, 1050593712, -1105061066, 1027289415, 1035889263) + W(4, 1033792089, 1026572719, -1097148617, -1072841573)
		+ W(5, 1051731235, 1040799594, 1025178361, 1033387155) + W(6, 1044650880, 1068805535, 1072674603, -1073632622)
		+ W(7, 1040667946, -1114163718, 1033059623, -1113785952)
		+ W(8, -1111938281, 1042295210, 1053858128, -1114078156) + W(9, 986622244, -1105514756, -1131411966, 1024784261)
		+ W(10, -1111133361, 1015874538, -1115667125, 1025743417)
		+ W(11, 1029743517, -1150165522, 1028606721, -1131685126);
	WS(1059574956, -1147706177);
	sum1 = W(0, -1126851274, 1032992154, 990365335, 1021792788) + W(1, 1014654722, 1023708133, 1021433863, 1024270494)
		 + W(2, -1107330821, -1114850125, -1111585801, 1025219833)
		 + W(3, 1042448198, 1041111834, 1028566264, 1025900485) + W(4, 1039522745, 1036915515, 1058476188, 1057257569)
		 + W(5, -1130368142, -1087441640, -1103664757, -1101532519)
		 + W(6, -1101979721, -1103811902, -1091594576, -1102147871)
		 + W(7, 1049911159, 1046832311, 1042912388, 1034347764) + W(8, 1039509326, 1037543219, 1044635632, 1015035920)
		 + W(9, -1098033363, -1103709614, -1112635561, -1106561201)
		 + W(10, -1113513772, -1122830319, -1115799180, 999411009)
		 + W(11, 1008106627, 1030688938, 998865060, 1033251158);
	sum2 = W(0, 1030668111, -1138525905, -1118095530, 1046358820)
		 + W(1, 1026007575, 1036395993, 1044323398, -1102154889)
		 + W(2, -1100054904, -1127093272, -1104427366, -1094333916)
		 + W(3, -1098434999, -1114547879, -1098255510, 1043811931)
		 + W(4, -1106823977, -1118630721, -1104404781, 1066330506)
		 + W(5, 1032956568, -1089680445, -1118009606, -1104253130)
		 + W(6, 1038847176, 1023505668, 1055088734, 1059364463) + W(7, -1109156363, -1102029714, 1019564502, 1042217401)
		 + W(8, 1045749759, -1100949461, -1106737563, -1115593085)
		 + W(9, -1105827255, 1014767972, -1114455410, 1033201092)
		 + W(10, -1139922314, -1137789612, 1025350194, -1118124817)
		 + W(11, 1044080198, -1111415597, 1034872747, -1116871429);
	WS(1056332375, 1037816258);
	sum1 = W(0, -1121656782, -1121854558, 988019291, 1027294260)
		 + W(1, -1141230927, -1146196851, -1124586778, -1119789479)
		 + W(2, -1103168373, -1112652978, 1032694229, 1032971073)
		 + W(3, 1036051832, 1029047507, -1138159876, -1116156558)
		 + W(4, -1119737691, -1116096096, -1099471067, -1088930875)
		 + W(5, -1088040995, -1094038173, -1105369135, -1100717841)
		 + W(6, 1044637987, 1045017865, 1051843657, 1058468850) + W(7, 1059943427, 1054278049, 1040438911, 1052440082)
		 + W(8, 1028439953, -1108613751, -1124711667, -1105155884)
		 + W(9, -1110648631, 1023373473, -1109090662, -1121068380)
		 + W(10, -1147698697, 1015231409, -1126623722, 1025720722)
		 + W(11, -1125643860, 1025459107, -1140770656, 1033302707);
	sum2 = W(0, 1037403217, 1056969468, 1057593955, 1065979451) + W(1, 1052219437, 1048107842, 1012201018, 1034400525)
		 + W(2, -1101035659, -1090106390, -1080354518, -1077736273)
		 + W(3, -1095104394, -1110113632, 1035332836, 1036232380) + W(4, 1032316963, 1038083410, 1060881997, 1057826659)
		 + W(5, 1040943565, -1093495590, 1023246776, -1105354500)
		 + W(6, -1116665707, -1119459300, 1028006921, -1093367622)
		 + W(7, 1050471411, -1098889696, 1037291810, -1172133380)
		 + W(8, -1159849898, 1009385423, 1038355181, -1108823981)
		 + W(9, 1028403474, 1041580846, -1108503511, 1023204972)
		 + W(10, 1025618366, -1128266716, -1107076145, 1040978108)
		 + W(11, -1107763897, 1031803963, 1028340263, -1124125618);
	WS(1057728492, -1114894260);
	sum1 = W(0, -1113553553, -1129994721, -1116323110, 1032700067)
		 + W(1, 1022553594, -1174372438, 1025649872, -1204938694)
		 + W(2, -1137973853, 1032124939, 1038491142, 1042214629)
		 + W(3, -1102850457, -1103814977, -1108835354, -1117610625)
		 + W(4, 1030725486, 1023297510, 1042012404, 1063322480) + W(5, 1049455560, 1038337085, 1036180712, 1041170774)
		 + W(6, 1027451936, 1039175515, -1096381204, 1002639809)
		 + W(7, -1095884801, -1099447670, -1107257155, -1110131186)
		 + W(8, 1024408310, -1104644784, -1098358292, -1097199096)
		 + W(9, 1038368473, 1041557913, -1143485305, -1139346043)
		 + W(10, -1122023828, 1015759447, -1129065232, 1025211173)
		 + W(11, -1119912573, -1120935138, 1022194670, -1131327617);
	sum2 = W(0, -1132724746, -1125894137, 1008401986, -1123753553)
		 + W(1, 1028568703, -1129573217, -1115138968, -1129237393)
		 + W(2, -1136277690, 1023794749, 1034921985, -1135255538)
		 + W(3, -1095862669, -1103833757, 989975657, -1117578737)
		 + W(4, -1115335750, 1019650853, -1111489002, 1065003137)
		 + W(5, 1042205114, -1104966989, 1028245440, -1137003202)
		 + W(6, -1142062564, -1102896527, -1095970428, 1052274635)
		 + W(7, 1050282098, 1039075981, -1124502561, 1029353869)
		 + W(8, -1111737990, 1036465851, -1093339450, -1130345777) + W(9, 961646223, -1123958953, 975314596, 981021860)
		 + W(10, 1021138001, -1117376889, 1036367329, -1114642052)
		 + W(11, 983274770, -1121876761, -1131382405, -1129104973);
	WS(1064957100, -1084259623);
	sum1 = W(0, -1147443767, 1002237105, 1042679235, 1025036588) + W(1, 1039980881, 1039876787, -1122119878, 1046679440)
		 + W(2, 1048172674, 1022388856, -1111985505, -1105536623)
		 + W(3, -1111204540, -1118973740, -1115201293, 1036937851)
		 + W(4, 1050085746, 1049301459, 1061123934, 1059891343) + W(5, 1063082922, 1059164422, 1050147791, 1052477312)
		 + W(6, -1087174820, -1096483251, -1084863818, -1085360136)
		 + W(7, -1087496217, -1085023864, -1099749261, -1093770425)
		 + W(8, -1110620477, -1130736462, 1036594273, -1096717087)
		 + W(9, 1049051417, -1098175193, 1038851310, -1094492881)
		 + W(10, 1041967934, 1032395752, 1029284270, 1027822410)
		 + W(11, 1038157169, 1033526682, 1035926782, 1040430103);
	sum2 = W(0, 1043574668, -1110691764, -1103083598, -1104224219)
		 + W(1, -1111324648, 1045365848, -1123650350, 1040472402)
		 + W(2, -1079200674, -1088609636, -1104512784, 1072315297)
		 + W(3, 1071717488, 1074062948, 1072927288, 1075518858) + W(4, 1070660923, 1057860954, -1107138551, -1092267131)
		 + W(5, -1073631870, -1072626825, -1076777698, -1068851440)
		 + W(6, 1052128984, 1049301959, -1106877192, -1082025998)
		 + W(7, -1098154139, 1060924493, 1055782129, -1085268633)
		 + W(8, -1102512316, -1119415890, -1099577256, 1048136354)
		 + W(9, -1101281480, 1049098296, 1053482338, 1045375219)
		 + W(10, -1114631788, -1111966430, 1025811761, -1120067756)
		 + W(11, -1097839567, 1046934152, -1142912019, -1113956244);
	WS(-1075237718, 1059347685);
	sum1 = W(0, 1021242911, 1033512399, 1029870036, 1022930282) + W(1, 1032776022, 1018371807, 1019954077, 1033340372)
		 + W(2, 1049968737, -1159856274, 1035044013, -1122614884)
		 + W(3, -1113136009, -1134430929, -1114025505, 1040742208)
		 + W(4, -1123217820, 1052611492, 1055398719, 1061884279) + W(5, 1059035017, 1058365139, 1054270736, 1057072208)
		 + W(6, -1100043508, -1096977477, -1086974821, -1081627821)
		 + W(7, -1085989237, -1083853344, -1094951367, -1082038839)
		 + W(8, -1123750750, 1035058824, -1111424357, 1035852049) + W(9, 1046594056, 1040835864, 1036293471, 1043435581)
		 + W(10, 1039650209, -1164938034, 1031585078, -1146263191)
		 + W(11, 1040828171, -1113397210, 1041271429, -1112152131);
	sum2 = W(0, -1109418256, 1045686709, 1025535098, 1041368995) + W(1, 1025255906, 1045341483, -1131647237, 1050563248)
		 + W(2, -1082007392, -1092895857, -1097230803, -1087580936)
		 + W(3, -1090709237, 1030380818, -1098811123, -1122444474)
		 + W(4, 1074622373, 1045059925, 1022527077, 1072979117)
		 + W(5, 1059630355, -1082271661, -1098333373, -1080249300)
		 + W(6, -1087167323, -1090791673, 1061750517, 1066822104)
		 + W(7, -1104688853, -1098772696, -1097425000, 1035536875)
		 + W(8, -1079889153, 1052961109, -1094791227, -1121141584)
		 + W(9, -1114952578, 1048788253, -1109808864, 1062091865)
		 + W(10, 1054843717, -1111299754, -1097908774, 1039933817)
		 + W(11, -1109459004, 1032974905, 1041274025, -1101634861);
	WS(-1073405707, 1071333561);
	sum1 = W(0, 1032445482, -1114759602, 1009365348, -1116673978)
		 + W(1, -1140494528, -1138343378, -1164102249, -1128324122)
		 + W(2, -1107154225, 1043648434, 1025826187, 1050217769) + W(3, 1045274198, 1041826370, 1037855412, 1036590066)
		 + W(4, -1086616986, -1097373989, -1088696011, -1084271170)
		 + W(5, -1086550017, -1088202787, -1096484208, -1090407429)
		 + W(6, 1053035442, 1049497533, 1058380737, 1057270871) + W(7, 1060414079, 1054213138, 1049814032, 1044502774)
		 + W(8, 1037191452, -1113096234, 1042579156, 1027100008)
		 + W(9, -1122447285, 1033632004, -1117413058, 1049279047)
		 + W(10, 1005358651, -1140703610, -1147371482, 1008260703)
		 + W(11, -1128134433, -1146407565, -1132301012, 1030979244);
	sum2 =
		W(0, -1104849756, -1130309268, 1032168017, 1006608216) + W(1, 1025939811, -1116205504, -1134020588, 1015836550)
		+ W(2, 1044778147, 1042344095, -1115874267, 1016899230) + W(3, 1015318926, 1017541078, 1025032291, -1134707560)
		+ W(4, 1087011564, 1065552014, -1071484991, -1064792716)
		+ W(5, -1108487910, -1111002668, 1026184365, -1105554232)
		+ W(6, 1051692028, 1050304642, -1095624232, -1080996320) + W(7, 1038353709, 1015541566, -1115175630, 1035428553)
		+ W(8, -1115275477, 1012814276, 1034711867, 1012706900) + W(9, 1031018877, 1017981722, 1016059306, 1030487759)
		+ W(10, 1024288807, -1122813731, 1018071134, -1113948677)
		+ W(11, 1039145567, -1121567210, -1161414849, 957459976);
	WS(-1093094231, 1019545057);
	sum1 = W(0, -1147370279, -1111661690, 1036370005, -1130128916)
		 + W(1, -1138886402, -1114353490, -1139052495, -1123566046)
		 + W(2, 1024662611, 1043371102, -1098598749, -1121967929) + W(3, 1034324947, 1030255498, 1020719663, 983686292)
		 + W(4, 1045730364, 1007712219, 1063151515, 1048771569) + W(5, -1102866212, 1043747359, 1042970997, 1044423271)
		 + W(6, -1100871081, -1103400446, -1086049630, -1094208743)
		 + W(7, 1057052051, -1103168823, -1114366281, -1105757546)
		 + W(8, -1113292876, -1125293706, 1038700136, 1042591246)
		 + W(9, -1109292474, 1040829042, -1113681601, -1119014482)
		 + W(10, -1115285964, 1035921815, -1106696483, 1031896756)
		 + W(11, -1117085921, -1117982022, 986496271, -1116127556);
	sum2 =
		W(0, 1017737448, -1112488549, 1041909593, -1119128646) + W(1, 995222883, -1138532089, -1122958336, 1002378369)
		+ W(2, -1113949677, 1043174240, -1095542187, -1123930650)
		+ W(3, 1011641777, 1043431269, -1133447353, 1011720393) + W(4, -1109074925, -1099690943, 1055357640, 1063813292)
		+ W(5, 1029075282, -1111808055, -1121958092, -1111615901) + W(6, -1106456753, 1036040708, 990810979, 1064786485)
		+ W(7, -1080550900, -1099317256, -1111251400, -1122017034)
		+ W(8, 1033894674, -1136025401, 1036060652, -1095508468) + W(9, -1096849813, 1042059844, 1031456264, 1041840135)
		+ W(10, 1002006465, -1127095326, -1106928479, 1041202855)
		+ W(11, 1028541984, 1013308785, -1130037494, 1011740497);
	WS(1065464534, 1066200435);
	sum1 = W(0, -1120929867, 1037468205, -1104046500, -1118049328)
		 + W(1, 1026495526, -1102710553, 1047356358, -1104379061)
		 + W(2, -1114034816, -1098649416, 1044270480, 1030873567) + W(3, 1027018036, 1029661039, 992085460, 1014898857)
		 + W(4, -1093428139, -1095417420, -1095455089, -1078956988)
		 + W(5, -1097112752, -1090364038, -1098761015, -1089997432)
		 + W(6, 1053507241, 1053719708, 1059517274, 1062996894) + W(7, 1062358792, 1051059848, 1053033759, 1058137077)
		 + W(8, 1039630850, -1117479019, -1116571174, 1037682987)
		 + W(9, -1100052716, -1134398359, -1124964177, -1119205176)
		 + W(10, 1039737375, -1104296205, 1034668025, 1027940302)
		 + W(11, -1105628906, 1047874257, -1105711476, 1036556777);
	sum2 = W(0, 1052570920, -1096757231, 1032706704, 1048916325) + W(1, 1032567852, 1027784571, -1123035498, 1032789056)
		 + W(2, -1079960756, -1072214843, -1067716640, -1071149720)
		 + W(3, -1113086642, 1026889523, -1102782368, -1113248449)
		 + W(4, 1059860803, 1077140634, 1078085184, 1074719494) + W(5, -1126012658, 1023965646, 1033915049, -1131155204)
		 + W(6, 1024102895, 1045135233, 1007395147, 1048879105)
		 + W(7, -1105291454, -1125605772, 1036400237, -1120868355)
		 + W(8, -1109439044, -1135125103, 1039504993, -1119420973)
		 + W(9, 1042487387, -1107726802, 1040624471, -1123377002) + W(10, 1028585912, 1026412089, 999691338, 1031274943)
		 + W(11, -1115876939, 1031655696, -1118021143, 1033633154);
	WS(-1088460652, -1077196042);
	sum1 = W(0, -1106714405, 1012745873, -1106817926, 1014233321)
		 + W(1, -1139695810, -1112340330, -1112616426, 1014140598)
		 + W(2, -1126618358, -1104692362, -1128320455, -1113350277)
		 + W(3, -1104636978, -1111992333, -1112151140, -1103199781)
		 + W(4, -1100538888, -1105672234, -1096420642, 1032760733)
		 + W(5, 980853696, -1098221750, 1032069058, -1124202648) + W(6, 1061836401, 1049398341, 1063373516, 1062672955)
		 + W(7, 1040237156, 1049303442, -1115352833, 1047738902)
		 + W(8, -1105561066, -1107347643, -1095103574, -1104500106)
		 + W(9, -1136108756, -1098848505, 1028357771, -1108236605)
		 + W(10, 1017778831, -1107815087, 1021813111, -1130991024)
		 + W(11, 1015562593, -1124042178, -1117430379, 1024298444);
	sum2 =
		W(0, 1042942941, -1103739979, 1021675082, 1031504716) + W(1, -1103784377, 1021140017, 1032312275, -1113021145)
		+ W(2, -1095373315, 1042549384, -1100136800, 1032277385) + W(3, 1051314558, -1097536524, 1033748340, 1006926454)
		+ W(4, 1047404354, -1104635751, -1156628070, 1056265483)
		+ W(5, -1086627236, 1056610233, -1097748456, 1032415346) + W(6, 1041600542, 1049880149, 1042313351, -1095000083)
		+ W(7, 1058671506, -1087499329, 1053303874, -1106742186)
		+ W(8, 1029337611, -1113660916, -1103511888, 1052284225)
		+ W(9, -1098025422, 1053296214, -1097031052, 1040224097)
		+ W(10, -1116792463, 1033409028, -1100575516, 1042607543)
		+ W(11, -1102539848, -1123811627, 1034071897, -1116904421);
	WS(-1090190636, 1052333694);
	sum1 = W(0, -1118008162, 1017370722, 1028313190, 1032465571) + W(1, 1021024634, 1022145795, 974396430, 1023704762)
		 + W(2, 1046164882, 1025512151, 1039176172, -1140639831)
		 + W(3, -1114523818, -1123803590, -1114987978, -1150325779)
		 + W(4, -1087764995, -1107299674, -1107276920, 1054861041)
		 + W(5, 1048774281, 1052546887, 1033108808, 1052242867) + W(6, 1050774996, -1113611419, 1042980645, -1104478910)
		 + W(7, -1116066086, -1088290914, -1101829203, -1082760046)
		 + W(8, -1132114980, -1133738119, 1016759930, 1039228938) + W(9, 1029146129, 1046828701, 1025239231, 1050382392)
		 + W(10, 992812356, -1143374172, 1031741320, 991966796)
		 + W(11, -1131726971, -1135053738, -1135839572, -1117633184);
	sum2 = W(0, -1112927492, 1000278501, -1115114722, 1038568093)
		 + W(1, -1107752992, 1036864823, -1111435217, 999311589)
		 + W(2, -1126311221, -1112124316, -1096516945, -1095439368)
		 + W(3, 1035770391, -1173738153, -1127749525, -1118042174)
		 + W(4, -1124129707, 1030656727, 1062718459, 1069168233)
		 + W(5, -1092856910, -1097729376, -1108466839, -1106807928)
		 + W(6, -1089259297, -1136644755, -1089907054, 1066488720)
		 + W(7, 1057602472, -1119016562, 1028769031, -1101412503)
		 + W(8, -1121960162, -1119195008, -1113085858, -1108783853)
		 + W(9, -1101947316, -1105922885, -1119106133, -1119408565)
		 + W(10, -1127721129, -1143597573, 1010259715, 1016497897)
		 + W(11, -1142073349, 1034450025, -1113345821, -1121786357);
	WS(1050584535, 1068150000);
	sum1 =
		W(0, -1115260532, 1010165469, -1112895478, 1003680362) + W(1, 1038151522, -1113655284, -1132334157, -1116596385)
		+ W(2, 1034938395, -1115625742, 1043729220, 1046586119) + W(3, -1096382429, 1036369142, -1110737789, 1020311663)
		+ W(4, 1038987194, 1047833470, -1102791097, 1053057826) + W(5, 1060286702, 1031810112, 1033665067, 1045919272)
		+ W(6, -1117589351, -1104527215, 1041775364, -1092950416)
		+ W(7, -1085160955, -1099697720, -1112334730, -1112800213)
		+ W(8, -1115913835, -1116485512, 1035117570, 1032942189)
		+ W(9, 1051158381, -1109351189, 1035094123, -1113211075)
		+ W(10, 1013034091, 1026352434, -1123123343, -1126776150)
		+ W(11, -1118268740, 992197073, 1007592182, -1128843070);
	sum2 =
		W(0, 1027450901, 999052617, 998486633, -1098069390) + W(1, 1050271656, -1144500281, 1034115809, -1111215245)
		+ W(2, -1130117632, 1037992777, 1035832253, 1058826704) + W(3, -1075559944, 1051052067, -1104035684, 1041076323)
		+ W(4, -1112751331, 1031860941, -1100828230, 1066377631)
		+ W(5, 1059983898, -1089703828, 1037142243, -1116488683)
		+ W(6, 1023748039, -1148181737, -1107268336, 1031601953)
		+ W(7, -1105105514, 1006070601, 1031181077, -1123703892)
		+ W(8, -1129067048, 1031574877, -1108371420, -1110435251)
		+ W(9, -1111123861, -1135053221, 1013422629, 994427506) + W(10, 1020055214, -1123191999, -1176849298, 992240434)
		+ W(11, 1022099846, -1122685646, -1154287506, 1025316569);
	WS(1065940278, 1034622363);
	sum1 =
		W(0, -1130882111, 1018945629, 1038546130, -1109081570) + W(1, -1116833467, 1027338207, -1118439678, 1023675896)
		+ W(2, 1042781009, -1105035701, 1037583679, -1089961211)
		+ W(3, -1106689964, 1025705412, -1110899849, 1000818681) + W(4, 1048563851, 1039562393, 1050832116, 1065150616)
		+ W(5, 1063013875, 1053064399, 1043578884, 1052844651)
		+ W(6, -1106282856, -1093168999, -1106056839, -1081267407)
		+ W(7, -1093571617, -1098826451, -1098971955, -1103816344)
		+ W(8, 991352096, -1128564863, 1040441019, -1125259845) + W(9, 1037655800, 1032573560, -1126802554, -1174556270)
		+ W(10, -1132163876, -1146137419, 1034240611, -1103163033)
		+ W(11, 1014989293, -1132178841, -1140385876, -1124029942);
	sum2 = W(0, 1042045232, -1100582068, 1051353130, -1098661297)
		 + W(1, 1033093932, 1041505758, -1111611431, 1036803556)
		 + W(2, 1025081894, 1047796551, -1135649915, -1083821047)
		 + W(3, -1113123121, -1102707738, 1042774566, -1119704488)
		 + W(4, -1120251562, -1130142714, -1091982339, 1066411068)
		 + W(5, -1108263063, -1116829613, 1029093314, -1105374597)
		 + W(6, -1098032480, 1051286467, -1088973774, 1066192686)
		 + W(7, -1096817778, -1124748705, -1115318079, 1039210409)
		 + W(8, -1122897683, -1114446743, 1048662352, -1098476628)
		 + W(9, 1043244089, -1105512115, 1039955893, -1115075522)
		 + W(10, -1131598407, 1028094206, -1114986235, 1035402858)
		 + W(11, -1113670703, 1040252082, -1113507172, -1136180467);
	WS(1056991468, -1087030746);
	sum1 =
		W(0, -1123211458, 1040392564, -1107179074, 1032323379) + W(1, -1112698351, -1113154609, 1035059984, -1117349658)
		+ W(2, -1104816506, -1123900599, -1097679367, 1050060447)
		+ W(3, -1113372906, -1118981766, 1036804874, -1117759553)
		+ W(4, -1105628499, 1035944426, -1092912076, 1043269081)
		+ W(5, -1098944114, -1111852653, 1030188977, -1099907470) + W(6, 1049039296, 1031104918, 1058030045, 1044634502)
		+ W(7, 1032247835, 1043769326, 1035537687, 1048904265) + W(8, -1110865210, 1038992913, -1092536332, 1052766173)
		+ W(9, -1101773536, -1111088882, 1017337855, -1120093295)
		+ W(10, -1119944116, 1019968535, -1113705364, 1024115141)
		+ W(11, 1016666555, -1113641643, 1034739876, -1119368937);
	sum2 = W(0, 1038207100, 1055370704, 1017023961, -1102268135)
		 + W(1, -1122475964, 1023693826, 1033230771, -1120372849)
		 + W(2, -1100024892, -1091918952, -1082116017, -1125190319)
		 + W(3, 1048656820, -1118701724, 1009208157, 1017593165) + W(4, 1019998746, -1108168198, 1065911065, 1060923636)
		 + W(5, -1095962080, 1025593786, 1022143062, -1123799386)
		 + W(6, -1116235844, 1051323790, -1096201210, -1094794141)
		 + W(7, 1023749917, -1112111831, 1028403793, -1116942925) + W(8, 1028590129, 1017416940, 1032160655, 1048662690)
		 + W(9, 1005611185, -1121410776, -1131420642, 1018425448)
		 + W(10, -1132429552, -1131674494, -1107738152, -1115273448)
		 + W(11, -1120617509, 1032669658, 1007544955, 990755743);
	WS(1065408790, 1036624080);
	sum1 = W(0, 1031689276, -1118902603, -1130392064, -1130349122)
		 + W(1, -1124855342, -1120117724, 1032115325, -1114562026)
		 + W(2, -1095782030, 1036811736, -1106389326, -1116251760)
		 + W(3, 1016267643, -1116551776, 1029730958, -1110739566)
		 + W(4, 1040908418, -1099523235, -1100633526, -1088986706)
		 + W(5, -1097124896, -1093812931, -1102530619, -1093706094)
		 + W(6, 1044865119, 1048657234, 1056569877, 1059819669) + W(7, 1057017186, 1059687187, 1046000250, 1058243684)
		 + W(8, 1010781241, -1114118270, -1105362262, -1109527143)
		 + W(9, -1101014271, -1105256235, 1028862634, -1118348593)
		 + W(10, -1124793181, -1132122507, 1010247305, 1021657598)
		 + W(11, -1147394236, 1019294354, -1131137795, 1010280523);
	sum2 =
		W(0, 1008018405, -1131603511, 988821927, -1126539767) + W(1, 1029044494, -1154431236, -1144594818, -1134541747)
		+ W(2, 1028827850, -1115409151, 1044469435, -1105522597) + W(3, 1031515550, 1029512486, -1118759177, 1017115388)
		+ W(4, 1048442625, -1128423353, -1144038842, -1080807551)
		+ W(5, -1100063920, 1047735839, 1049631559, 1040817807) + W(6, 1022982076, 976919119, -1106419532, -1069309764)
		+ W(7, -1077869698, 1057375362, 1074645104, 1074183528) + W(8, 1015261982, -1110305290, 1025710382, -1128896061)
		+ W(9, 1034212953, 1047372093, -1121013958, 1028992794)
		+ W(10, 1023643398, -1142661114, 1024565032, -1156968388)
		+ W(11, -1108906576, 1040986767, -1109343217, 1013497529);
	WS(-1134496480, -1135409208);
	sum1 =
		W(0, 1012816882, -1131032216, 1015795842, 1017081284) + W(1, 1032335660, -1114842158, -1121133019, 1020892138)
		+ W(2, -1118561391, 1023949458, 1025102291, -1098855254)
		+ W(3, -1109465919, 1018180354, 1039697400, -1121622748)
		+ W(4, -1172095542, -1135187513, -1122643706, 1062211658)
		+ W(5, 1053298610, 1055550179, -1104417019, 1042088653) + W(6, 1042727039, -1111514505, 1044113108, -1088869665)
		+ W(7, -1090758606, -1097017583, 1024023145, -1131309822)
		+ W(8, -1101252924, 940438235, -1099247502, 1037442288) + W(9, 1036453998, 1038283500, -1127849669, -1111728213)
		+ W(10, 1038725048, -1118209095, 1039141810, -1110868352)
		+ W(11, -1124785329, -1123999226, 984058180, 985363057);
	sum2 =
		W(0, 1027844464, -1120185020, 1033301171, -1142892826) + W(1, -1130897478, -1112219415, 1008317678, -1123809910)
		+ W(2, -1123756397, 1023474305, -1120807818, 1045181163)
		+ W(3, 1050514681, -1148494098, -1124897908, -1112292483)
		+ W(4, -1109401613, 1009596088, -1105464515, -1069578385)
		+ W(5, 1080182479, 1033916695, -1111316356, 1038900121)
		+ W(6, -1123223808, 1048386893, -1117881742, -1079085438)
		+ W(7, 1057107198, -1155326684, 1015620530, -1138311341) + W(8, 1035039619, -1119575836, 1029989604, 1032607110)
		+ W(9, -1113328530, -1143648562, 1010222764, -1144599918)
		+ W(10, -1128717516, -1197272208, -1129559846, 1013531724)
		+ W(11, 1001587842, -1126181730, 1011089790, -1129634008);
	WS(1063953772, 1006246735);
	sum1 =
		W(0, -1129265445, -1103221880, -1129858606, -1113052252) + W(1, 970168057, 1035503657, -1114702297, 1026538155)
		+ W(2, 1023929568, -1113408580, -1152025615, -1124775629)
		+ W(3, -1116248388, -1112901548, -1114551939, 1012918985) + W(4, 1050480356, 1053092565, 1054804888, 1058637767)
		+ W(5, 1061520345, 1052655373, 1043614208, 1053852345)
		+ W(6, -1094701786, -1092563365, -1099755687, -1081976315)
		+ W(7, -1085039957, -1106127939, -1104465584, -1094975651)
		+ W(8, 1037312131, -1114954585, 1041973195, 1043978961) + W(9, -1109284733, 1037644971, 1036504960, -1153236991)
		+ W(10, 1034664643, 1012249970, 1007014628, 1034276907)
		+ W(11, -1121545966, 1031841028, -1122618723, 1015394179);
	sum2 = W(0, -1108119214, -1096454441, -1110533412, -1119694402)
		 + W(1, -1127729168, -1110958880, 1023031785, -1130979192)
		 + W(2, -1098605940, 1047215192, -1103381544, -1128298432)
		 + W(3, -1115663656, -1114162078, 1023974294, -1102917557)
		 + W(4, 1035846227, -1114546522, 1042040175, 1054173861) + W(5, -1103681801, 1035812038, 1020649501, 1043843622)
		 + W(6, 1036002502, 1051355228, -1102267339, 1055154953) + W(7, 1052945690, -1097546689, 1033369183, 1033695483)
		 + W(8, -1110269476, 1034086715, -1102892813, 1033662351)
		 + W(9, 1018137856, -1135158408, 998437331, -1106336801)
		 + W(10, -1115932080, 1019597651, -1130886478, -1108620470)
		 + W(11, 1033484697, -1106956606, 1029836288, 1026224246);
	WS(1049960663, -1098656338);
	sum1 =
		W(0, -1129270334, 1010743226, -1116543140, 1036165346) + W(1, 1026370235, 1026933359, 1009750007, -1164389112)
		+ W(2, -1097905355, 1038429850, 1026505899, -1111354490) + W(3, 1012909508, 1034045586, -1139624135, 1033987231)
		+ W(4, -1106458043, -1094238830, -1084542826, -1093117384)
		+ W(5, -1096055524, -1093158415, -1113672231, -1098353419)
		+ W(6, 1053746044, 1050579558, 1060156652, 1065413702) + W(7, -1110641506, -1140159326, -1153271990, 1046556600)
		+ W(8, -1153859324, 1008020477, -1101873487, -1122984978)
		+ W(9, -1132001470, 1048347588, 1027525597, -1124973593)
		+ W(10, -1120671826, 1036488405, 1033306211, 1035776465)
		+ W(11, 1015184758, -1115507932, 1024719161, 1037016731);
	sum2 = W(0, 1007202997, 1038605814, -1111184485, -1097778206)
		 + W(1, -1107862779, -1126800416, -1122928880, -1117103670)
		 + W(2, -1107138382, -1092409649, -1086536233, 1033842165)
		 + W(3, 1050500010, -1107791267, 1035028069, 1024236113)
		 + W(4, -1101985157, -1111080585, 1058778058, 1062592323)
		 + W(5, -1115904936, 1050870644, -1115500703, -1137706913)
		 + W(6, -1105521455, 1031799434, -1102287591, 1054124413)
		 + W(7, -1121603522, 1039372702, 1030823202, 1012044041) + W(8, 998286218, -1127152184, 1043783051, -1107786643)
		 + W(9, -1104929125, -1103666737, -1123649878, 1042413442)
		 + W(10, -1135144653, -1138707909, 1018462794, -1134709509)
		 + W(11, 1016336685, 1035379787, -1120475406, -1119073178);
	WS(1045571246, -1101396513);
	sum1 = W(0, 1027156266, -1135540454, -1123739311, -1123826896)
		 + W(1, -1110505155, -1138173481, 1019384210, -1138775820)
		 + W(2, -1105879340, 1031079263, 1036462891, 1048275928) + W(3, 1040289247, 1033674439, 1035302207, -1109766005)
		 + W(4, -1095381975, -1094890856, -1086841044, -1081913239)
		 + W(5, -1087831711, -1095054872, -1100616678, -1096527684)
		 + W(6, 1052608133, 1052732944, 1059410250, 1057453824) + W(7, 1053535332, 1059217778, 1056369955, 1057086003)
		 + W(8, 1036979366, -1110160581, 1033495803, 986236332) + W(9, -1121128186, -1117509614, 1002559041, 1031959012)
		 + W(10, -1116386461, -1124519785, -1113888968, 1015417435)
		 + W(11, -1106215130, 1025380519, -1132265864, 1009437253);
	sum2 = W(0, 1023702857, -1116086512, 1027064225, 1024261913) + W(1, -1115739014, 1023117658, 1011341860, 1016675050)
		 + W(2, 1025579445, 1041684936, 991232624, 1049263730) + W(3, 994389040, -1121855219, -1121905805, -1114246345)
		 + W(4, -1107828603, -1100190580, -1127488618, -1121382305)
		 + W(5, 1049530396, 1041567276, -1097196557, -1125328530)
		 + W(6, 1030949885, -1127701406, 1063977916, 1081524863)
		 + W(7, 1074557390, -1078514947, -1067412604, -1072747255)
		 + W(8, 1030056541, -1101693823, 1026840857, 1032271344) + W(9, 1041139218, 1024600809, -1110332083, 1045882874)
		 + W(10, -1138881396, 1031874044, -1115029594, -1124133978)
		 + W(11, 1015337722, -1113125346, -1157524144, 1009384836);
	WS(-1091844311, 1066789497);
	sum1 = W(0, -1126657090, -1118280816, 1035276339, 1034822275)
		 + W(1, -1122398524, 1027512241, -1105911320, 1036073133)
		 + W(2, -1121934839, -1104655157, 1036892560, 1041291861)
		 + W(3, 1016354085, -1100932977, -1113195754, -1137558275)
		 + W(4, 1053346558, -1150447404, 1061301148, 1054539137) + W(5, 1061579109, 1052329175, 1010492736, 1052092547)
		 + W(6, -1094816004, -1096277599, -1095276499, -1085328499)
		 + W(7, -1094948141, -1090319102, -1109759879, -1096198988)
		 + W(8, -1134360567, 1026981217, 1035239934, -1132053288)
		 + W(9, 1041572288, -1138204721, 1026669711, -1122862318)
		 + W(10, -1196074864, 1030410603, -1117233544, 1032377106)
		 + W(11, -1113536398, 1028691858, 1016723124, 1004385343);
	sum2 =
		W(0, -1130924015, 976327856, 1006816288, 1032746467) + W(1, -1109752024, 1030725620, -1118656485, 1013150272)
		+ W(2, 1022730742, -1107671502, -1102494949, -1063244855)
		+ W(3, -1117144683, -1118200508, 1023153636, 1019358625) + W(4, -1156842543, 1030703882, 1050591037, 1084548157)
		+ W(5, 1041535529, 1030607420, -1117378226, 1000111712) + W(6, 1039023607, -1100688592, 1039287442, -1091568120)
		+ W(7, 1042495948, -1100624377, 1033109796, -1135441064)
		+ W(8, -1147026848, -1113451109, 1030233046, 1034384724) + W(9, 1024850879, 1037336210, -1123040622, 1025293966)
		+ W(10, 1024455841, 1015244616, -1121583866, 1032201434)
		+ W(11, -1112832588, 984232072, 1003511712, -1124806470);
	WS(1062375148, 982896070);
	sum1 = W(0, 1041356906, -1141741512, -1123251246, -1121772047)
		 + W(1, -1138991637, -1156317853, -1161666833, 1011726474)
		 + W(2, -1092346958, 1042371688, -1107640316, 1037798623)
		 + W(3, 1035668286, 1026956462, 1016120313, -1115727625)
		 + W(4, -1098857839, -1100631199, -1093348349, -1081710855)
		 + W(5, -1084667272, -1088318752, -1093940123, -1084607638)
		 + W(6, 1052252533, 1048733184, 1057292943, 1063732968) + W(7, 1061645578, 1059891330, 1051947731, 1059995535)
		 + W(8, 1050501706, -1126563284, 1043133649, -1111246422)
		 + W(9, -1112114769, -1106214611, -1109426316, -1190508359)
		 + W(10, -1165233042, -1134397903, 1008063554, 1032268279)
		 + W(11, 988108978, 1037368483, -1138661789, 1040598420);
	sum2 =
		W(0, -1087149149, -1111774062, -1122195827, 1039123010) + W(1, 1035630599, 1055099903, 1042757145, 1060125526)
		+ W(2, -1081699534, 1035582541, -1087576154, -1082404199)
		+ W(3, -1111170675, -1119441337, -1097950160, -1098859385)
		+ W(4, 1075074133, 1078981756, 1080077903, -1086433828)
		+ W(5, -1073636555, -1080599553, -1080969229, -1075310961)
		+ W(6, 1074122230, 1067224402, 1066418532, -1082120864)
		+ W(7, -1078722695, -1083892454, 1038753292, -1085615144)
		+ W(8, 972078363, -1092574897, -1094572008, -1101495601) + W(9, -1124013413, 1051613332, 1020974546, 1056506110)
		+ W(10, -1097056662, 1045566397, 1049096521, -1109136155)
		+ W(11, 1034655424, 1023040696, 1027077203, -1129411423);
	WS(-1073733835, -1077508759);
	sum1 = W(0, 1004911573, 999004239, 1008908284, 1032559088) + W(1, -1123346838, 1021646261, -1114632613, 1036339578)
		 + W(2, 1043185540, -1120942224, -1136904037, -1114184455)
		 + W(3, -1112686066, 1032555200, 1005792618, 1040940927) + W(4, 1056421033, 1054442442, 1059517190, 1066321721)
		 + W(5, 1063474337, 1052962698, 1044159722, 992460573)
		 + W(6, -1084678800, -1094509130, -1087084867, -1089134469)
		 + W(7, -1088382556, -1089853747, -1092765869, -1093589176)
		 + W(8, 1025064353, 1020812405, -1149079216, -1127746091)
		 + W(9, 1027145139, -1126936380, 1027348136, -1126618160)
		 + W(10, 1009545653, 1022285001, -1118599969, 1007063543)
		 + W(11, -1149726053, 1015641511, 1023282088, 981480241);
	sum2 = W(0, 1016441223, -1123853806, 1034027700, 1016212045) + W(1, 1025170155, 1030169991, 1024326153, 1020004331)
		 + W(2, 1040812131, -1136381199, -1121560396, -1100123577)
		 + W(3, -1100550013, -1105283667, 1029487024, -1102325825)
		 + W(4, -1091551076, 1020713637, -1092123318, 1069362941)
		 + W(5, 1050653373, 1020763615, -1121149602, -1094990109)
		 + W(6, -1083270432, -1123741604, 1057043619, 1065772322)
		 + W(7, 1058297195, -1091989226, -1092470882, -1106605421)
		 + W(8, 1054198423, -1108424657, -1115262538, -1092584961)
		 + W(9, -1121642970, 1029919048, 1039520200, 1026718342)
		 + W(10, 1001473573, -1110846033, 1008724259, -1120589670)
		 + W(11, 1040111989, -1104422780, 1027795061, -1115881428);
	WS(-1083424620, -1083774644);
	sum1 = W(0, 1025997707, 995558823, -1132669247, 1015677409)
		 + W(1, -1113673299, -1146244698, 1028038186, -1119640804)
		 + W(2, -1107578509, -1112668224, -1109754213, 1048694360)
		 + W(3, -1099923633, 1044345284, -1117921566, 1030760459)
		 + W(4, -1116799831, -1098861996, -1099316274, -1079768279)
		 + W(5, -1093459346, -1098475085, -1113981277, -1105585281)
		 + W(6, 1051882641, 1045883512, 1060321715, 1059777970) + W(7, 1064776049, 1036566882, 1042756750, 1033934183)
		 + W(8, -1114213177, -1127946135, -1106758402, 1040276008)
		 + W(9, -1108196294, 1008462282, -1117078569, -1130472177)
		 + W(10, -1140244728, -1116793621, -1131243108, -1129876893)
		 + W(11, -1167573435, 1020492609, 1015090721, -1176961296);
	sum2 =
		W(0, -1120400279, 1006239848, 1033967902, -1138878316) + W(1, 1012842788, -1135736068, 1028356101, -1120658117)
		+ W(2, -1120118931, -1112851025, -1101370370, 1037781128)
		+ W(3, -1100258045, 1002346920, -1112182778, 995892591) + W(4, -1114073896, 1016448074, 1047917593, -1113781647)
		+ W(5, 1045546113, -1114666278, 1002645288, -1115876966) + W(6, 1044457775, -1095953339, 1065044078, 1069276419)
		+ W(7, -1075186216, 1035717470, -1097061266, 1049663208)
		+ W(8, 1036833596, -1112980685, -1119396143, -1110041421)
		+ W(9, -1132903556, -1120766465, 1015304410, -1123504973)
		+ W(10, -1137956564, -1122147671, 987310366, -1187381491)
		+ W(11, -1131003226, 1029533357, 1003776904, -1150885167);
	WS(1055938007, -1113494123);
	sum1 = W(0, 1002908945, 1005413771, 1025040167, 1016082831) + W(1, -1114102015, 1024456642, -1121270129, 1006080470)
		 + W(2, 1028210664, -1117675639, 1040926954, -1118443670) + W(3, 1040854289, 1046508410, 1019764906, 1029150738)
		 + W(4, -1133494457, 1035958810, 1041989700, -1101702418)
		 + W(5, -1098047787, -1093641223, -1111985289, -1102768646)
		 + W(6, -1135464580, -1095959351, -1087581816, -1121242873)
		 + W(7, 1048632765, 1052220147, 1025236686, 1042463785) + W(8, 1008466835, 1040264713, 1048292991, 1034336763)
		 + W(9, 1043249233, -1183964258, 1036425152, -1131127167)
		 + W(10, -1131269290, 1035203030, -1116685065, -1117662885)
		 + W(11, -1132796663, -1144182458, -1137681823, 1031884341);
	sum2 = W(0, -1148833389, 1034952858, -1131645803, 1044582101)
		 + W(1, -1100126968, 1041029558, -1101188496, 1038559400)
		 + W(2, -1103329032, -1114547380, -1099667252, 1046239383)
		 + W(3, 1038848953, 1023994452, 1040593566, -1104909140) + W(4, 1039527980, 1019372679, 1017530647, -1095619156)
		 + W(5, 1053527025, -1122648352, 1048348234, 1034383711) + W(6, 1036545465, -1111710878, 1040867364, 1074171367)
		 + W(7, -1072583834, -1089175055, -1110512168, 1048723535)
		 + W(8, -1140514638, 1042452640, 1048394746, 1046568773)
		 + W(9, -1104419698, -1095650184, -1113024814, -1105559093)
		 + W(10, -1111163586, 1025974311, -1102843950, 1030125627)
		 + W(11, 1045672947, 1033990232, 1039972451, -1123744674);
	WS(1054254551, 1014537956);
	sum1 = W(0, -1121039367, 1018675757, 1022410264, 1028321069) + W(1, 1032078897, 1035879540, 998902321, 1035017184)
		 + W(2, 1035774671, -1130008697, 1030747950, -1107714718)
		 + W(3, -1097508911, -1100889147, -1111836109, -1112194220)
		 + W(4, -1112598570, 1008273253, -1093495169, 1061840455) + W(5, 1062686448, 1058139578, 1050284599, 1050365160)
		 + W(6, -1132150029, -1122251932, 1041075666, -1100441032)
		 + W(7, -1084814013, -1090418276, -1098262366, -1104639554)
		 + W(8, -1109088445, -1109769252, -1103842329, -1105690119)
		 + W(9, 1049125597, 1045096257, 1018266794, -1137878196)
		 + W(10, 1040615567, 1003469451, 1040565356, -1126038165)
		 + W(11, -1115375938, -1105705223, 1030169589, -1123088958);
	sum2 =
		W(0, 1011204314, -1151906447, -1132982086, 1015334447) + W(1, -1126682819, 1031867988, -1118412630, 1019402007)
		+ W(2, -1130282463, 1008292026, -1113509623, -1118416042)
		+ W(3, 1010705513, 1015562377, 1033032763, -1171211484) + W(4, -1119643322, 1036989282, 1023195387, 1031871454)
		+ W(5, 1036745108, -1105750465, 1024841875, -1132045005) + W(6, 1040567914, -1093705400, 1046529995, 1053486166)
		+ W(7, 1053627848, -1097180463, 1042871577, -1098551422) + W(8, 1058038651, 1048788001, 1069827352, 1061661513)
		+ W(9, -1076895592, -1083563182, -1102862368, -1093245544)
		+ W(10, -1092395975, 1041384381, -1082188469, -1087135929)
		+ W(11, 1050130047, 1062283738, -1108358221, 1058279550);
	WS(1057163500, -1105993220);
	sum1 =
		W(0, -1117201821, -1121502764, 1035599249, -1105708961) + W(1, 1039647740, -1100922079, 1009912816, -1136735831)
		+ W(2, -1127293622, 1045431725, -1100979748, 1049617722) + W(3, -1110465655, 1042176840, 1018827936, 1001114727)
		+ W(4, 1046510122, -1097880614, 1061106926, -1099817760)
		+ W(5, -1119635500, -1109566363, -1147860066, 1037588842)
		+ W(6, -1119279260, 1032698105, -1097882833, -1088567265)
		+ W(7, 1058361641, -1097567811, 1036626725, -1111863248)
		+ W(8, -1111026820, 1044535287, -1095331735, 1053288920) + W(9, -1096979757, 1050620014, 999121112, 1037098289)
		+ W(10, 1018908832, -1110256660, 1024080836, -1117593824)
		+ W(11, 1027464313, -1113789929, -1159432152, 1012647057);
	sum2 = W(0, 1032576295, -1123342042, -1102694716, -1132748357)
		 + W(1, -1114775905, 1033817148, 942234367, -1109637447) + W(2, -1107895050, 1039805910, 1052615154, 1027679479)
		 + W(3, -1183264704, -1127944484, 1017960690, -1117652574)
		 + W(4, 1016729470, -1102939450, 1050355566, 1057040101)
		 + W(5, 1041423933, -1098800812, 1027447559, -1113353192)
		 + W(6, 1038099246, -1120156902, -1100691281, -1098318717)
		 + W(7, 1028185223, 1043085543, -1113846578, 1025700351) + W(8, -1122727069, -1128970625, 1046407453, 997134844)
		 + W(9, -1094682594, 1023808656, 1033077879, -1136470782)
		 + W(10, -1114110583, -1124467804, -1110408836, 1035923921)
		 + W(11, 1040728790, -1104134547, -1111084310, 1024627457);
	WS(1069430838, -1077807532);
	sum1 = W(0, -1123171840, -1123870031, 1012978707, 1026708965)
		 + W(1, 1032241614, -1110089696, 1013657340, -1120091289)
		 + W(2, 926704291, 1035074891, -1102713036, -1094582899)
		 + W(3, -1104095024, -1131766218, -1123449267, -1126388352)
		 + W(4, 1028287308, 1030377682, 1060355037, 1064667974) + W(5, 1044883747, 1023923417, 1023074654, -1134219998)
		 + W(6, 1024652287, -1104443381, 1049114747, 1049334299)
		 + W(7, -1097738289, -1112895132, -1133494194, -1105084689)
		 + W(8, -1121358347, -1137933441, -1102473935, -1095444677)
		 + W(9, -1112982200, -1115022670, -1123735342, -1125652635)
		 + W(10, -1124249574, -1123723658, -1124350158, -1155502135)
		 + W(11, 996719039, -1114119663, -1129702439, -1115595936);
	sum2 = W(0, -1176390445, 1032791968, -1107216374, 1039748018)
		 + W(1, -1104895086, 1038133354, -1123666927, 1013658503)
		 + W(2, -1120278537, -1112747779, 1039675898, 1025598156)
		 + W(3, 1049256042, -1105015824, 1024448666, -1110290749)
		 + W(4, -1122813389, -1119517685, 1061000499, 1059349510)
		 + W(5, -1087513873, 1030867610, -1108606159, 1029186614) + W(6, 1041053822, 1042596904, 1032712030, 1055783944)
		 + W(7, -1099074048, -1084050573, 1040697602, -1106116496)
		 + W(8, 1022193201, -1132233097, 1037891533, 1009116037)
		 + W(9, -1107732985, -1101549778, 1022775251, -1106656496)
		 + W(10, -1120846771, -1150821318, -1120324549, 1006903493)
		 + W(11, -1117395279, 1034659541, -1115429715, 1028618234);
	WS(-1107817820, -1083770194);
	sum1 = W(0, 1033900161, -1129878691, -1129439246, -1131338575)
		 + W(1, 1015365308, -1128788741, 1034359265, 1024049691) + W(2, -1103638846, 1019165999, 1023785569, 1041664750)
		 + W(3, 1007653393, 1026305479, 1029035509, -1111132977)
		 + W(4, -1091016130, -1105602789, -1097747004, -1076846267)
		 + W(5, -1089110318, -1101714279, -1095981534, -1089968180)
		 + W(6, 1053216608, 1056291523, 1057499003, 1059566574) + W(7, 1057822998, 1057215924, 1051239662, 1055184137)
		 + W(8, 1041711845, -1114138529, -1107402783, 1043057225)
		 + W(9, -1097881621, -1104471663, 1029122288, 1032118072)
		 + W(10, 1032252891, 1005244003, -1129556050, 1037921123)
		 + W(11, -1126092988, 1041959808, 1025745172, 1027268745);
	sum2 =
		W(0, -1108694073, 1045019344, -1102469381, 1037993179) + W(1, -1102369829, 1036817135, -1116848662, -1123721670)
		+ W(2, 1017327589, 1034893158, -1100848825, -1146521528)
		+ W(3, -1136622056, -1122158468, 1036214504, -1109074807)
		+ W(4, 1040440313, 1020539438, -1091152854, 1062010427) + W(5, 1017850914, -1095264144, 1045324437, 1047380031)
		+ W(6, 1037365040, 1043169414, -1179472005, 1059039676) + W(7, 1038217042, -1119445175, 1048192551, -1115655698)
		+ W(8, -1097181356, 1044490295, -1098856738, -1105305386)
		+ W(9, -1109601321, -1098482637, 1034613852, -1105047780)
		+ W(10, -1123414724, -1142407924, -1124070306, -1103656828)
		+ W(11, 1025666621, -1105116469, 1027457629, -1121369495);
	WS(-1121449656, -1084978473);
	sum1 = W(0, 1045775831, 1021114964, 1036495664, 1032769888) + W(1, -1134400474, 1043049231, -1112792957, 1043659613)
		 + W(2, -1099605930, 1028648016, -1113195701, -1106810756)
		 + W(3, 1033523886, -1109837568, 1039225431, -1097941829)
		 + W(4, -1086366198, -1100836955, -1085601027, -1088747404)
		 + W(5, -1083936243, -1087596695, -1102874546, -1088234269)
		 + W(6, 1054843763, 1049277222, 1059006957, 1062277595) + W(7, 1060137529, 1057384673, 1045407794, 1055835664)
		 + W(8, 1044622847, -1121703995, 1039106531, -1122091582)
		 + W(9, -1102614275, 1011169881, -1118753961, 1048366450)
		 + W(10, 1025802254, -1116658981, -1138285574, 1043922200)
		 + W(11, 1020367213, 1042132230, -1132370673, 1039326553);
	sum2 = W(0, 1027272459, -1122536322, -1115599503, -1109953333)
		 + W(1, -1101108438, -1160853572, -1125199072, -1105305527)
		 + W(2, -1105747151, -1103046200, 1043039962, 1029006014) + W(3, 1049577028, 1035298821, 1043042004, 1053260045)
		 + W(4, 1058588727, 1025881493, 1025318337, -1079698237)
		 + W(5, -1116019666, 1050247454, -1104971590, -1094505007)
		 + W(6, 1050147388, 1054947781, 1058930692, -1072349877)
		 + W(7, -1069493839, -1072151832, -1072978341, -1072202568)
		 + W(8, -1089616072, -1098050255, 1020160348, 1078384354) + W(9, 1078006681, 1075828182, 1074567753, 1072013431)
		 + W(10, 1040922163, -1157391810, -1097372724, 1029236731)
		 + W(11, -1111844849, -1095907204, 1046502148, 1037030073);
	WS(-1076413686, 1050217089);
	sum1 =
		W(0, 1037264211, -1140703701, 1010880426, -1119658251) + W(1, -1116247362, 1031154598, -1125273098, -1131976189)
		+ W(2, -1103937453, 981259974, -1126374874, 1042459879) + W(3, -1115463620, 1040532067, -1110800684, 1020764716)
		+ W(4, 1032015257, 1015092336, -1117441203, -1095655209)
		+ W(5, -1089060935, -1097693400, -1116339093, -1115082479)
		+ W(6, 1043075881, -1110472573, -1140207123, 1058975156) + W(7, 1059127610, 1049753500, 1026525586, 1038259412)
		+ W(8, -1122840185, -1115654547, -1121072785, 1016890098)
		+ W(9, -1095200233, 1024224509, -1116764924, 1027865572)
		+ W(10, -1144808135, -1126940256, -1127053849, 1040888602)
		+ W(11, 1021095812, 990976051, -1118091276, 1016317274);
	sum2 =
		W(0, 1057721492, 1028643349, 1060288138, 1059252612) + W(1, -1088865108, -1086775589, -1123025940, -1093527126)
		+ W(2, -1087030854, -1118716844, -1080168014, -1080273709)
		+ W(3, 1065839894, 1065802380, 1052992874, 1051057083) + W(4, -1098169441, 1050324940, 1016748144, -1095791676)
		+ W(5, 1025332663, 1048744751, -1103675095, 1047968677) + W(6, 976966634, 1023362490, -1115171624, 1047291739)
		+ W(7, -1136639192, -1124716700, 1045176631, -1122660154)
		+ W(8, 1023517212, -1141117066, 1023617033, -1099550108) + W(9, 1041241265, 1003901823, -1105682362, 1020688386)
		+ W(10, 1010046217, 1027499437, -1115470708, 1034407868)
		+ W(11, -1116997486, -1138422172, 1028187249, -1121332252);
	WS(1066004950, -1130673709);
	sum1 = W(0, -1116101174, -1143212072, -1110468285, -1115338446)
		 + W(1, -1108483849, 1016794668, -1129241385, 1013476922)
		 + W(2, 1031654568, -1115365365, 1037471350, 1044807147) + W(3, 1036857292, 1049500535, -1116011560, 1018991691)
		 + W(4, -1088044468, -1112634148, -1095270314, -1086079158)
		 + W(5, -1084922887, -1089120237, -1096691029, -1092328502)
		 + W(6, 1052873383, 1046315731, 1053790292, 1057379349) + W(7, 1062574892, 1059566963, 1043154809, 1052540519)
		 + W(8, 1041536990, 1018103788, 1044233532, -1114923292)
		 + W(9, -1111082699, -1112535089, 1013224078, 1045681849)
		 + W(10, -1136500130, -1125315968, -1143909091, 1020745202)
		 + W(11, 1016815907, -1120057699, 1009076749, -1111113254);
	sum2 = W(0, 1049010278, 1037489391, -1120558834, -1115441721) + W(1, -1107156556, 992841734, 1011333881, 1042878013)
		 + W(2, 1059657103, -1120407882, 1065561208, 1065354919)
		 + W(3, 1033902725, -1090673211, -1082019922, -1076779646)
		 + W(4, -1081123115, -1091075041, -1094693777, -1086070082)
		 + W(5, 1048072918, 1058489027, 1067731839, 1065573397)
		 + W(6, -1096253478, 1044030983, -1088412254, -1088804298)
		 + W(7, 1059822273, 1048768363, -1110539158, 1056386736) + W(8, 1022187211, -1110198086, 1026065263, 979808314)
		 + W(9, 1015305348, -1103664360, -1102578162, 1041735451)
		 + W(10, 1042763848, -1123055347, 1010460099, 1037997843)
		 + W(11, -1106407542, -1127526979, 1046102351, -1098151359);
	WS(1047691950, 1051513987);
	sum1 =
		W(0, 1022367675, 1023115866, 1025923810, -1121417283) + W(1, -1135269348, -1123344254, -1153116613, -1140725337)
		+ W(2, -1106171493, -1148261013, -1110614526, 1048684730) + W(3, 1043654816, 1037977761, 1018209505, 1012206837)
		+ W(4, 1047705594, -1138130365, -1138856554, -1092459648)
		+ W(5, -1088007377, -1117423671, -1145599589, -1130685354)
		+ W(6, -1115678670, 1039875161, -1098498099, 1059839847)
		+ W(7, 1055365231, -1110502987, -1108540005, 1013205632)
		+ W(8, -1110486184, 1038987295, -1111291916, 1037143648)
		+ W(9, -1116325726, 1038170008, 1024662707, -1106962771)
		+ W(10, -1119968336, -1146539325, 1031736900, -1113038256)
		+ W(11, 999460043, -1124410005, -1170140361, 1022378313);
	sum2 = W(0, -1153456458, -1134949160, 976205336, -1107040555)
		 + W(1, 1031938263, -1148458760, -1128058621, 1018102832)
		 + W(2, 1034638423, -1132037434, 1047224115, -1111241686)
		 + W(3, -1102088763, -1109506803, -1119972538, -1122339703)
		 + W(4, 1026219462, -1110235102, 1041432515, -1098519781) + W(5, 1016119332, 1045200456, 1026438298, 1012163112)
		 + W(6, -1118314715, 1026400860, -1098555575, 1048945857) + W(7, 1066956313, 1038098069, 1020127420, 1026446934)
		 + W(8, -1119545213, 1033998497, 1038320636, 1042089138)
		 + W(9, -1089428981, -1088147582, -1103340362, -1114149729)
		 + W(10, 1020158000, -1129681397, 1034767622, -1100590807)
		 + W(11, -1131704894, 1033722488, 1036980701, -1126638758);
	WS(1065730166, 1060778308);
	sum1 =
		W(0, -1109508860, -1155017835, -1113193022, 1018445113)
		+ W(1, -1116526739, 1027367671, -1113248331, -1116098736)
		+ W(2, -1157499671, -1122491724, -1101845990, -1123710636)
		+ W(3, 1037579925, -1109701838, 1024052458, -1155438706) + W(4, 1041425921, 1039607429, 1059840031, -1103201623)
		+ W(5, -1086536234, -1119532176, -1131587533, -1135484603)
		+ W(6, 999270323, -1108915110, -1093896302, 1034241095) + W(7, 1065443257, -1115473720, 1023021127, -1169161851)
		+ W(8, 1009856488, 1019270959, 1048952862, -1124851701) + W(9, -1100984082, 1042597895, 988759974, -1109972554)
		+ W(10, -1122732458, 1019165315, -1112299503, 1031136123)
		+ W(11, -1130156262, -1112137490, 1035869970, 1026435614);
	sum2 =
		W(0, -1117967445, 1040648348, -1112630617, 1042642774) + W(1, -1134880336, -1108734545, 1042723069, -1110919553)
		+ W(2, 1023936292, 1027011316, -1104815876, 1032485416) + W(3, -1097739621, 1008252288, 1027781874, 1017816544)
		+ W(4, 1048994422, -1081925843, 1069895227, -1079286264)
		+ W(5, 1067803238, -1093635474, 1039731885, -1113045602)
		+ W(6, 1036573845, -1090561506, 1061477130, -1076993331)
		+ W(7, 1074358700, -1082750513, -1152591489, 1040942069) + W(8, 1025878262, -1121546197, 1006994724, 1017402756)
		+ W(9, -1094759274, -1124517798, -1128233335, 1015619872)
		+ W(10, -1136777476, 1000734832, -1120512530, 1043800887)
		+ W(11, -1115175264, -1106635673, 1050798200, -1104563368);
	WS(1051081815, 1004177576);
	sum1 = W(0, -1127006616, 1009183853, 1030806032, 1035550201)
		 + W(1, -1148492092, 1031890286, -1122950699, 1033051522)
		 + W(2, 1047378036, -1123222753, 1030530563, -1112167248)
		 + W(3, -1102096100, -1119963793, -1117414047, -1118879820)
		 + W(4, 1040477302, -1133548407, 1061394914, 1067589976) + W(5, 1061693295, 1056018877, 1051876647, 1054656608)
		 + W(6, -1095193921, -1099314072, -1084986498, -1091645900)
		 + W(7, -1092420382, -1084371172, -1100397982, -1096248194)
		 + W(8, 984028115, 1033152150, -1134209438, -1104155199)
		 + W(9, -1126214664, -1117645071, -1115478541, -1098736399)
		 + W(10, 1015654525, 1000220336, 1016832613, 1007541309)
		 + W(11, 1020442767, 1016050244, 1015156587, -1120116135);
	sum2 =
		W(0, 1038737431, -1107492679, 1048033211, -1120313369) + W(1, 1015799927, -1127256174, -1108431753, 1025558434)
		+ W(2, -1086393652, 1061143042, -1086071985, 1050160290) + W(3, 1036302581, -1118303985, 1030572627, 1049210573)
		+ W(4, -1122890851, -1087802869, 1050554685, 1074235084)
		+ W(5, -1097102610, -1080828834, 1051308486, -1086660156)
		+ W(6, 1062117952, -1089713201, 1059347527, 1068761695)
		+ W(7, 1051722018, -1090432670, -1096060997, -1089293346)
		+ W(8, 1031555324, 1047951996, 1026779363, -1098359769)
		+ W(9, 1043634021, -1093586557, -1093678452, -1099341241)
		+ W(10, -1105710539, 1021198999, -1103176732, 1024031768)
		+ W(11, -1105088271, 1023611974, -1113357802, 1042868230);
	WS(-1081907798, -1114644056);
	sum1 = W(0, 1023775725, -1170980595, 1026005873, -1126334628)
		 + W(1, -1135823392, -1129163353, -1151688884, -1129940170)
		 + W(2, -1099395677, -1134709766, -1099241994, -1120114113)
		 + W(3, 1034531271, -1108351113, 1019473342, -1110039318) + W(4, 1055907631, 1050593936, 1058604967, 1054687330)
		 + W(5, 1038229186, 1034921283, 1018134455, -1120708196)
		 + W(6, -1100928459, -1112754945, -1087793848, -1087665246)
		 + W(7, -1104299004, 1040795209, 1040889398, 1054318790) + W(8, -1119324179, 1032148262, 1009969504, 1038203192)
		 + W(9, 1028440637, -1104169898, -1106565731, -1107725509)
		 + W(10, -1109439504, 1017060589, -1128826918, -1138112959)
		 + W(11, 1038462084, 999099597, 1007377992, 1027667523);
	sum2 =
		W(0, -1119441358, -1129970231, 1013923693, -1135011770) + W(1, 1015830944, -1115083307, 1009913072, -1117182320)
		+ W(2, -1109792567, -1120391232, -1103233485, -1103316489)
		+ W(3, -1104701758, 961266788, -1120471806, 1032096200) + W(4, -1127769135, 1050978947, 1033489482, 1054134565)
		+ W(5, 1049300223, -1110832497, 1049274561, -1124368769) + W(6, -1107196821, 992017798, -1095646457, 1049668759)
		+ W(7, 1056508485, 1047186396, -1110580647, -1109467751) + W(8, 1030789742, 1040616080, 1038693473, -1124339641)
		+ W(9, 1043974386, -1086696217, -1110322035, -1103392519)
		+ W(10, -1113410550, 1030775978, -1115392393, -1108882435)
		+ W(11, -1145057435, -1118394614, 1032794842, 1029776437);
	WS(1054547415, -1080700728);
	sum1 = W(0, -1118959255, 1000886579, -1108938574, 1035589374)
		 + W(1, -1115953331, -1120209015, -1130255148, -1114831416)
		 + W(2, -1106813137, 1020745112, 1000629071, -1089948699)
		 + W(3, -1104374042, -1115354302, -1115551813, -1107411355)
		 + W(4, -1136179854, 1042266506, -1114102394, 1058763908) + W(5, 1043996152, 1034434840, 1030595334, 1037557447)
		 + W(6, 1049136707, -1113159542, -1117329322, 1057279043)
		 + W(7, 1058534976, 1042941412, 1024662339, -1115931546)
		 + W(8, -1121699838, -1135369949, -1098171678, -1102488395)
		 + W(9, -1118338951, -1123101368, -1111680098, -1111356186)
		 + W(10, -1110798213, -1133353861, -1132246652, -1116069530)
		 + W(11, 1023843187, -1110056358, -1125104281, -1113468791);
	sum2 = W(0, -1104438281, 1006975884, -1114845259, -1121830816)
		 + W(1, 1035922248, -1109021584, 1024387710, -1116080890)
		 + W(2, 1010047952, 1033813267, -1104617278, 1016682467) + W(3, -1119230330, 1016925125, 1031893944, 1028042677)
		 + W(4, 1041416137, -1103312430, 1059878226, 1030331467)
		 + W(5, 1042445877, -1127060444, -1106783001, -1113418625)
		 + W(6, -1126834256, -1117623020, -1091497753, 1058017528)
		 + W(7, 1016098448, 1041560361, -1112957506, 1032681483)
		 + W(8, -1137643420, -1119875938, 1032827109, -1098691452)
		 + W(9, 1038105687, -1110812698, 1032692112, -1112120334)
		 + W(10, -1141914640, -1142859168, -1115736166, 1030249718)
		 + W(11, -1111253212, -1153808400, -1114320479, -1122393388);
	WS(1052913623, 1049378679);
	sum1 =
		W(0, -1122838827, -1140317417, -1125024735, -1119624720) + W(1, -1114511683, 1000517975, 980913767, -1118732996)
		+ W(2, 1042960148, -1131398976, 1047376245, -1142164473) + W(3, 1052155164, 1026436976, 1040745327, 1037554661)
		+ W(4, -1086626395, -1096052024, -1085621156, -1082562971)
		+ W(5, -1087926293, -1091398264, -1096441475, -1088065070)
		+ W(6, 1057292387, 1051976144, 1057250406, 1065554348) + W(7, 1052193006, 1054127476, 1052669955, 1051850318)
		+ W(8, 1037967453, -1115050310, 1033197251, -1105683981) + W(9, 1022767638, 1031945184, -1117629257, 1041425290)
		+ W(10, -1155224026, 1021209962, -1137632582, 1041116332)
		+ W(11, -1114068531, 1019309136, -1119607996, 1029050594);
	sum2 =
		W(0, -1128729473, 1026695603, -1122814467, 1038041001) + W(1, -1114364242, 1029245131, -1114309631, -1131614889)
		+ W(2, -1113890565, -1113695617, 1012493154, 1007226362) + W(3, 1022932917, -1121347205, 1028217359, 1005475605)
		+ W(4, 1030681183, 1046246583, -1119541727, -1105895610) + W(5, 1013035938, -1109256305, 1037707015, 1018572933)
		+ W(6, -1116238263, 1032966985, 1063042504, 1066720275) + W(7, 1061802664, 1054635319, 1034508407, -1114817272)
		+ W(8, 1054381777, 1060417287, 1065151040, 1069419683) + W(9, 1070184946, 1067716376, 1063333907, 1057796391)
		+ W(10, -1088819879, -1094452995, -1073258706, -1071852139)
		+ W(11, -1071972143, -1076852924, -1084913408, -1086618913);
	WS(-1080205366, 1054586731);
	sum1 = W(0, 1028285119, 1034516295, -1114270114, 1028158052) + W(1, -1122816794, 1015275709, 1008209269, 1026827799)
		 + W(2, -1104231365, -1118125300, -1122896269, 1031422323)
		 + W(3, 1042423964, -1113275778, 1035567225, -1113291743)
		 + W(4, -1105384067, -1098317298, -1102251495, -1084181862)
		 + W(5, -1083878719, -1102645126, -1094749758, -1095155767)
		 + W(6, 1018315643, 1050987674, 1045079495, 1065887519) + W(7, 1058366107, 1055927247, 1042520123, 1054820368)
		 + W(8, 1050517144, -1103331232, 1044797187, -1106919576)
		 + W(9, -1136969466, -1127822612, -1111681950, 1023800268)
		 + W(10, -1107795033, 1030553289, -1134423957, 1039594145)
		 + W(11, -1127143669, 1007528111, -1112108944, 1010334934);
	sum2 =
		W(0, 1018519238, 1015687849, -1123243110, -1154321191) + W(1, -1147705571, -1137574530, 1025499637, -1123293958)
		+ W(2, 999332143, 1021267259, 1021268373, 1001850235) + W(3, -1122367554, -1149097003, 1028798873, -1120881342)
		+ W(4, 1041061518, -1105547391, 1034089943, -1097359239) + W(5, 1024181853, 964634475, -1139074510, 1038775557)
		+ W(6, 1033756160, 1042746528, 1026544409, 1057524548) + W(7, -1128118669, 1033087855, -1129467393, -1131901697)
		+ W(8, 1071473984, 1066765865, 1067795051, 1059938647) + W(9, -1126584943, -1109247299, 1002507759, -1137941026)
		+ W(10, -1074851124, -1079967238, -1079279124, -1081222132)
		+ W(11, 1036308208, 995399503, 1006964374, -1131371017);
	WS(1032292188, -1145187004);
	sum1 = W(0, -1121091224, -1124591439, -1121198813, 1009701366)
		 + W(1, 1007646671, 1026658136, 1020346030, -1122546321) + W(2, 1026282854, 1032165735, 1048823572, -1113803654)
		 + W(3, -1119045850, -1092992668, 1019935126, -1119672872)
		 + W(4, -1110430066, -1099744666, -1088767505, -1109489438)
		 + W(5, 1041537816, 1047050636, -1121506375, -1110555528) + W(6, 1041424886, 1053335502, 1045555550, 1044961340)
		 + W(7, -1098280566, 1043075732, -1107270401, 1047792295)
		 + W(8, -1163709786, -1097458647, 1040806261, 1038271382)
		 + W(9, 1040783354, 1037260307, 1000329008, -1120965766)
		 + W(10, -1130362518, 1026340962, 1020242430, -1136150382)
		 + W(11, -1117600916, 997023189, -1124456788, 1026784415);
	sum2 =
		W(0, -1120115102, 1024423113, -1131404107, -1162462122) + W(1, -1116017912, 1035047655, -1146105278, 1011265421)
		+ W(2, 1027036707, -1119221834, 1034928052, -1115806512)
		+ W(3, -1133321326, -1101382306, 1029706393, 1023154260)
		+ W(4, 1028744443, -1122478763, 1034534080, -1117650486)
		+ W(5, -1108495610, -1105332910, 1038914207, -1113944011) + W(6, 1037973272, 1049287438, 1047707985, 1065549495)
		+ W(7, -1079218451, -1101676179, -1109811124, -1116861489)
		+ W(8, -1111409649, -1096539764, 1032305459, 1059270295)
		+ W(9, 1053073262, -1108544028, -1125217018, 1023662974)
		+ W(10, -1114092190, 1034186497, -1111870688, -1104163224)
		+ W(11, -1116841516, 1038206879, 1004549098, 1021319568);
	WS(1065238444, 1029810764);
	sum1 = W(0, -1117664959, 1033625479, -1121511107, 1026353828) + W(1, -1154871713, 980940712, 1018182811, 1025470327)
		 + W(2, 1035631050, 998132025, 1046740798, 1049143094) + W(3, 1044265580, 1037075730, 1028486865, -1128624253)
		 + W(4, -1105662947, -1110409480, -1115600622, -1117398499)
		 + W(5, -1101622768, -1109487884, -1112099063, -1120941494)
		 + W(6, 1044376095, 1041425605, -1117226857, -1088462543)
		 + W(7, -1090821428, -1099167518, 1039936213, -1117520833)
		 + W(8, -1180059800, 1029921727, 1047596134, 1050498082) + W(9, 1032067983, -1134957959, 1021107193, 1019194744)
		 + W(10, -1144996235, 1002652741, 986508455, 1031133314)
		 + W(11, -1119889178, 1038687768, -1122286680, 1032539083);
	sum2 =
		W(0, 1027136813, -1126103938, -1134438995, 1023841561) + W(1, 1003327910, -1130954514, -1135210803, 994333964)
		+ W(2, -1109237812, 1029641913, -1108335880, 1016569578) + W(3, 1032415828, 999116870, 1003972614, -1138234067)
		+ W(4, -1131106290, 1047599733, -1097134429, -1076957808)
		+ W(5, 1044824498, 1037851390, -1123469057, 1043898273) + W(6, 1028116649, 1041211299, -1092284431, -1103461794)
		+ W(7, 1073063564, -1111597872, 1033926584, -1115472968)
		+ W(8, -1115313320, -1119521049, -1100904528, 1040752059)
		+ W(9, 1045381268, -1112786376, 1034574746, -1137298819)
		+ W(10, -1132573667, 1022404146, 1016921434, 1027441157)
		+ W(11, -1106952976, 1036890340, -1110049884, -1139674515);
	WS(-1111543132, 1053084187);
	sum1 =
		W(0, 1033211657, -1116548448, 1043994373, -1112421659) + W(1, 1033458902, 1042588164, -1106715184, 1042106754)
		+ W(2, 1029336727, -1100473306, 1036113196, -1100606697)
		+ W(3, -1117467379, 1024205686, -1098518156, 1010302211) + W(4, 1056808676, 1042013257, 1061342772, 1060655799)
		+ W(5, 1059165410, 1057924951, 1042727104, 1057649845)
		+ W(6, -1089574549, -1097689349, -1087296749, -1082434496)
		+ W(7, -1087667391, -1091727169, -1095816456, -1093601226)
		+ W(8, -1112225370, 999357322, 1042186215, -1100755553) + W(9, 1042539448, 1041805473, -1105873704, -1114265639)
		+ W(10, 1035575202, -1114691470, 1040681774, 1045312421)
		+ W(11, 1039236406, 1042949980, -1113675407, 1035739628);
	sum2 =
		W(0, 1036389819, -1106855677, 1031620401, -1109245550) + W(1, 997072274, -1132619277, -1096737767, 1049991282)
		+ W(2, 1006854517, -1114095075, 1044374087, -1105124479)
		+ W(3, -1105277948, 1043212463, -1104242691, -1113287926)
		+ W(4, 1049279774, -1106885840, 1052305677, 1054861276) + W(5, 1057655059, 1046093411, -1094755169, 1057224822)
		+ W(6, -1104547241, -1120692701, 1045612807, 1058901209) + W(7, 1054428932, 1034709627, 1054770354, -1094426804)
		+ W(8, -1140479293, -1096936463, 1051540981, -1092919117)
		+ W(9, -1129490106, 1034565381, -1092959620, 1030915645)
		+ W(10, 1032391465, -1098591621, -1115708783, -1081363743)
		+ W(11, -1090444858, 1017473602, -1098730750, 1044114915);
	WS(-1084020140, 1068126260);
	sum1 =
		W(0, 1006295077, -1137936208, 1034316741, -1149620895)
		+ W(1, -1141477121, -1110713826, -1119964867, -1159113641)
		+ W(2, -1156074282, -1103771606, -1104490636, 1038480604) + W(3, 1018703789, 1041233006, 1031629367, 1005339683)
		+ W(4, 1049019906, 1049395923, 1061237576, 1033598516) + W(5, -1094713154, -1098857908, 1023717620, 1036793310)
		+ W(6, -1097931528, -1091558419, -1086810430, -1099102215)
		+ W(7, 1059440745, 1018408058, -1122483505, -1108866660) + W(8, -1117241095, 1040511881, 1040083512, 1044377854)
		+ W(9, 1044961993, -1146014215, 1038059949, -1129764324)
		+ W(10, -1123621559, 1023627215, -1108467318, -1115694024)
		+ W(11, -1120119968, -1145494414, -1122997930, 1007729326);
	sum2 =
		W(0, 1015277664, -1114453597, 1036987011, -1112547401) + W(1, 1038859445, -1116674795, 983557058, -1127718668)
		+ W(2, 1025130698, -1134749664, 1032879133, -1134874844)
		+ W(3, -1112115766, 1018163604, -1128408082, 1003243264)
		+ W(4, 1027591084, 1033917561, -1126832950, -1114337945) + W(5, 1026538526, -1114930086, 968847366, -1132712652)
		+ W(6, -1117062871, -1115087054, 1055956188, -1108159193)
		+ W(7, 1052262112, 1032023389, -1105383385, -1120777676)
		+ W(8, -1101670769, -1114105716, -1097729634, -1123425664)
		+ W(9, 1058230624, 1047994902, 1046456588, 1042953566)
		+ W(10, 1019605180, -1131991228, -1104354242, -1097147867)
		+ W(11, -1101321392, -1100180330, -1106875572, 1009596296);
	WS(1044178094, -1112419455);
	sum1 = W(0, -1131480425, 1014469647, 1033460669, -1111970637)
		 + W(1, 1018155424, 1028778773, -1120733619, 1036392279)
		 + W(2, 1028145051, -1106904202, -1114114798, -1103921210)
		 + W(3, -1104772954, -1105642670, -1122369255, -1105836421)
		 + W(4, 1050373320, 1050878345, 1059597501, 1061375910) + W(5, 1062331213, 1054878354, 1050980308, 1057064179)
		 + W(6, -1113746394, -1101407218, -1089975999, -1083033439)
		 + W(7, -1089702156, -1100724747, -1095744476, -1096031599)
		 + W(8, -1097767254, 1036986154, -1106579916, 1025899544)
		 + W(9, 1034746546, 1032512190, -1113254377, -1120232930)
		 + W(10, 1005496122, 1009224698, 1010606701, -1155279741)
		 + W(11, 1027233072, 1015772371, -1131981388, -1140419566);
	sum2 = W(0, 1044058702, -1105410550, 1033398047, -1119512188)
		 + W(1, -1121578506, -1129503263, 1005093795, -1116781712)
		 + W(2, -1120335698, 1016883675, 1032351899, -1103364509)
		 + W(3, -1123961512, 1043612533, -1110855577, 1044044613)
		 + W(4, 1041124235, 1035757794, -1105578788, -1105098443) + W(5, 1037191880, 1025665274, 1024086018, 1023695645)
		 + W(6, 1021344157, -1104385836, 1068114101, 1052569394)
		 + W(7, 1027075889, -1095293941, -1113226379, -1106316439)
		 + W(8, -1087803383, -1085495757, -1081571635, -1086748155)
		 + W(9, 1031589750, 1048618044, -1121765158, 1039073287) + W(10, 1057976488, 1058928386, 1051244378, 1048853947)
		 + W(11, -1130402783, -1124003088, 1010599720, -1120128288);
	WS(-1095246679, -1087513362);
	sum1 = W(0, 1027634667, 998672596, -1149130110, 1026870673) + W(1, 1006905115, 1027369115, -1156874400, 1027010724)
		 + W(2, 1005582218, 1034119552, -1098084154, -1141537276)
		 + W(3, -1098155038, -1115874224, -1130796284, -1110211381)
		 + W(4, 1054139855, 1049059024, 1052649123, 1065515488) + W(5, 1064339388, 1053781857, 1050040635, 1056042372)
		 + W(6, -1093682933, -1099832192, -1089047862, -1088853800)
		 + W(7, -1084571535, -1097071228, -1107001190, -1095503614)
		 + W(8, 1002440559, 1040529483, -1122861959, -1126585773)
		 + W(9, -1099945809, -1105399392, 1023818537, -1117200441)
		 + W(10, -1142612208, 1024339285, 1025618962, 1014930618)
		 + W(11, -1117714471, -1136815962, 1018962754, 1028298602);
	sum2 =
		W(0, 1021849900, -1131412357, -1118206650, -1125196517) + W(1, 1035111533, -1144348946, 1021086832, 1020034266)
		+ W(2, 1041438934, -1119369172, 1040592619, -1114002177) + W(3, 1032710077, 1044882286, -1106944856, 1034465258)
		+ W(4, -1128850825, 1021256857, 1046750596, 1025252531) + W(5, 1048692472, -1128830461, 1032666924, 1034167215)
		+ W(6, 1035803991, -1111021944, 1038923952, 1072474004) + W(7, 1077302109, -1095554578, 1044371493, -1126088605)
		+ W(8, -1100551265, 1042971908, -1109478151, -1083937830)
		+ W(9, -1067064389, -1084038225, -1106119426, -1103479472)
		+ W(10, 1028120411, -1109090883, 1026074630, -1100770381)
		+ W(11, 1049109423, 1041329596, 1033664959, -1114595648);
	WS(-1086863724, -1072185677);
	sum1 = W(0, 1028385114, -1117432553, 1039695343, -1109809663)
		 + W(1, 1021420394, -1123921882, -1130768465, 1022384484)
		 + W(2, 999422396, -1108936247, -1104614655, -1104994067)
		 + W(3, -1154652341, -1146863602, -1114930982, 1034006493)
		 + W(4, 1054099261, 1053618221, 1060257868, 1062802560) + W(5, 1056152893, 1045520765, 1044268562, 1050379178)
		 + W(6, -1096116227, -1097427086, -1085349189, -1083398775)
		 + W(7, -1099176000, -1110026089, -1104661441, -1115290030)
		 + W(8, -1144842721, 1026659130, 1037424170, 1038629270)
		 + W(9, 1048207210, -1118540449, -1129199023, -1101129750)
		 + W(10, -1139590961, 1021035463, -1123772160, -1103266023)
		 + W(11, 1017905387, -1111374457, 997564786, -1108736604);
	sum2 = W(0, -1122660132, 1028330563, -1115262781, 1045687787)
		 + W(1, -1108704409, 1029063313, -1116092784, 1013546756)
		 + W(2, 1040406414, 1017997140, 1025264396, -1103384157) + W(3, -1151694751, 986929807, 1026201848, -1115691336)
		 + W(4, 1007232002, 1025921746, 1043786284, 1040909479) + W(5, -1108714653, 1043690826, -1119932664, 1038266954)
		 + W(6, -1096101684, 1022732374, -1102241564, 1055010544)
		 + W(7, 1057419270, -1126901852, 1047767958, -1115096031)
		 + W(8, -1114861255, 1041150821, -1094431556, -1078483413)
		 + W(9, -1079156700, -1078269109, -1092610189, -1098859524)
		 + W(10, 1041847394, -1105481885, 1055232297, 1061241514)
		 + W(11, 1063042984, 1067726336, 1054314043, 1052159629);
	WS(-1100931758, -1079897221);
	sum1 = W(0, 1002503979, 1034941050, -1106318298, 1040768819)
		 + W(1, -1115730241, -1141069099, 1027555620, -1123362142)
		 + W(2, -1105750735, 1038153885, -1105238364, 1049149819)
		 + W(3, 1028324215, -1106412131, 1039911116, -1114353739)
		 + W(4, -1109125113, 1017797614, -1095922988, -1090093369)
		 + W(5, -1091054939, -1102230944, -1127686569, -1097766172)
		 + W(6, 1042140489, 1051948423, 1034322060, 1059094088) + W(7, 1049017573, 1050624300, 1045992036, 1043140938)
		 + W(8, -1126416416, 1024057510, -1103862864, 1040510958)
		 + W(9, -1112163155, -1106256757, 1017980086, 1018029782)
		 + W(10, -1119888216, 1035399096, -1104877795, 1042879258)
		 + W(11, -1120272065, -1112985689, 1033961137, -1117933580);
	sum2 = W(0, -1118098210, -1106915273, 1038839398, -1115506453)
		 + W(1, 1032442192, 1016491198, 996494424, -1145352236) + W(2, 1039272612, -1120265428, 1047577900, -1112696018)
		 + W(3, -1123012045, -1123570623, -1121836120, 1026228225)
		 + W(4, 1033865352, 1043187452, -1107536005, -1090204449) + W(5, 982996928, 1042935567, -1120793710, 1030161309)
		 + W(6, -1107428188, -1111026913, 1034998667, 1068488571)
		 + W(7, -1096446249, 1013219076, -1101384300, 1023915500)
		 + W(8, 1041731770, -1108614463, -1104254290, -1073443109) + W(9, 1040126834, 1041050172, 998034192, 1038049010)
		 + W(10, -1138511840, -1129236656, 1049639209, 1065503173)
		 + W(11, 1035312463, -1104804103, 1040382819, -1106858818);
	WS(1060652716, -1122012062);
	sum1 = W(0, -1136700086, -1120727741, -1136846536, -1102129381)
		 + W(1, 1035874533, -1111246103, 1019584793, -1111739075)
		 + W(2, -1113850590, 1022556549, 1030968440, 1036351121) + W(3, 1049961616, -1119797202, 1037896960, 1033695743)
		 + W(4, -1093156519, -1098011208, -1100004083, -1079676696)
		 + W(5, -1097573322, -1087704492, -1096988084, -1092447605)
		 + W(6, 1056384406, 1052398904, 1062519968, 1061355096) + W(7, 1059521337, 1052440101, 1048869443, 1048091420)
		 + W(8, -1101587139, -1106430355, -1132405458, -1107897312)
		 + W(9, 1048756772, -1109566980, 1020055223, 1043876621)
		 + W(10, 1021600449, -1114714908, 1016310696, -1113036024)
		 + W(11, 1022545811, 956768943, -1121983087, 1018273385);
	sum2 =
		W(0, -1134928360, 1028726521, -1102649789, 1041988393) + W(1, -1105797881, -1125378124, 1034345705, -1134413224)
		+ W(2, 1033535752, -1102458559, -1114678181, 1050124192)
		+ W(3, -1102215651, 1032107719, 1014416128, -1119150822) + W(4, -1108867200, 1031241917, 1028753942, 1056497468)
		+ W(5, -1090602802, 1057082230, 1023046526, 1025484112) + W(6, 1056652859, 1048810536, 1051021341, 1036208495)
		+ W(7, -1099717915, -1114740583, 1002570703, -1101875417)
		+ W(8, -1094974673, -1100509489, -1100441695, 1034323322)
		+ W(9, -1115767916, 1041259997, -1122784508, 1037850051)
		+ W(10, 1034782854, -1123876292, -1100025719, 1037384204)
		+ W(11, -1098766868, 1024245049, -1114560124, -1112409616);
	WS(-1104650926, -1097620835);
	sum1 = W(0, -1121602225, 1021304961, -1132438763, 1033606955)
		 + W(1, -1119908749, 1032325913, -1112547088, 1011690407)
		 + W(2, 1025795527, -1105437010, 1039870965, -1097752993)
		 + W(3, 1037504305, -1109081755, -1121171172, -1116159153)
		 + W(4, 1046345311, -1108985665, 1041625463, -1144407721)
		 + W(5, -1100934531, 1047145475, -1119544288, 1036418740)
		 + W(6, -1105175020, 1045711217, -1093274991, 1062570208)
		 + W(7, -1099088029, -1097698093, -1136783989, -1106563213)
		 + W(8, -1160491701, -1117138161, 1040158758, 1049985633) + W(9, 1037586881, 1004919651, -1124949278, 999804916)
		 + W(10, 1000929055, -1145522137, -1117941464, -1122762228)
		 + W(11, -1109694278, 1026835862, 1024727664, -1126831120);
	sum2 =
		W(0, -1103930431, 1043997541, -1102154605, 1046282803) + W(1, -1106269056, -1116052960, 993204113, -1113135778)
		+ W(2, -1122873970, -1100601593, -1174042309, -1084779372)
		+ W(3, -1114322527, 1046060831, -1115511338, 1041954938) + W(4, 1048581640, -1108032519, 1029742536, 1068068442)
		+ W(5, 1051594943, -1119470820, -1138871916, 1020181836) + W(6, -1139346648, 1042591516, 1045200151, 1052027066)
		+ W(7, -1098651742, -1115540046, 1021777728, -1107159950)
		+ W(8, 1030984702, -1123657132, -1106767363, -1086671314)
		+ W(9, 1024653780, -1127107345, -1163609763, -1134598872)
		+ W(10, -1115391660, -1107477718, 1032437784, 1025856678)
		+ W(11, 1036550683, -1121355040, -1115373797, -1122730046);
	WS(1066180726, 1071088208);
	sum1 = W(0, 1019239309, -1139409238, 1016498838, -1117575980)
		 + W(1, 1000209679, -1113394675, 1030691589, -1133365628)
		 + W(2, -1125280121, 1001471451, -1110062156, 1036666525)
		 + W(3, 1049354787, 1048739493, -1119525817, -1103045922)
		 + W(4, -1096761986, 1012641888, -1103040193, -1098591157)
		 + W(5, -1079760364, -1090655988, -1102803453, -1099636767)
		 + W(6, 1046613601, -1137946220, -1089511315, 1064065326) + W(7, 1058946251, 1056455200, 1048597558, 1050574049)
		 + W(8, -1107071425, 1047813898, 1045045936, 1024305865) + W(9, -1110782371, 1013890551, 981956228, 1043476657)
		 + W(10, 1022045682, 1006921793, 1010038708, 1025055882)
		 + W(11, 990559266, 1028621651, -1118324476, -1146495466);
	sum2 =
		W(0, -1132513434, -1110784932, 1015163300, 1015068960) + W(1, 1033174530, -1135254713, 1032888151, -1132281738)
		+ W(2, 1043448685, -1133524329, -1107748756, 1038994810)
		+ W(3, -1104237963, -1120882016, -1105704866, 1042278645)
		+ W(4, -1099364915, 1037755510, -1102119678, 1041992963) + W(5, 1059473601, 1015880446, 1034086136, -1087682569)
		+ W(6, -1092624350, 1047633966, -1120785461, 1052941265)
		+ W(7, -1112171819, -1149514732, -1106883398, 1032085587)
		+ W(8, 1056566992, -1103089496, 1032253510, -1122308723)
		+ W(9, 1028984470, -1121912217, 1037486360, -1121651695)
		+ W(10, -1119372495, -1105722911, -1123661455, -1115405106)
		+ W(11, -1126727948, 1038410412, -1113287020, 1025242322);
	WS(1036385628, 1044378228);
	sum1 = W(0, -1125923878, -1122454178, -1106272614, 1034604284)
		 + W(1, -1112814039, 1030894675, -1123079474, -1130721815)
		 + W(2, -1119989961, 1024777096, 1045742974, -1106270482)
		 + W(3, -1097223397, -1112273196, -1131680651, 974203052)
		 + W(4, -1113894352, -1109744594, -1081686591, 1049041391)
		 + W(5, 1058546239, 1043400251, 1024933634, -1127331477) + W(6, 1034400041, 1050462805, 1057689729, 1056885773)
		 + W(7, -1082103097, -1111542214, 1032256832, 1030325078)
		 + W(8, 1040468885, -1118152051, -1112362495, -1111838475)
		 + W(9, 1051410218, 1042722054, -1104716944, 1028514056)
		 + W(10, -1119159494, -1136375156, 1016953331, 1033159371)
		 + W(11, -1127987422, 1008300000, 1020481857, -1122308858);
	sum2 = W(0, -1126857538, -1118763531, 1031801448, 1032593429)
		 + W(1, 1004108563, -1119835024, 1016299757, -1169697445)
		 + W(2, -1124098806, -1105376950, 1037674477, -1110580495)
		 + W(3, -1116861031, 1039467599, -1109178305, 1033383777)
		 + W(4, 1017023528, -1096176503, 1067983244, -1078904043)
		 + W(5, 1060638644, -1111109918, -1098624444, 1040587540)
		 + W(6, -1105780084, -1094874635, 1071605005, -1075832971)
		 + W(7, 1065456263, -1112838992, -1104548941, 1006549790)
		 + W(8, -1128747572, -1140350635, -1109792866, -1097243929)
		 + W(9, 1040323331, -1114824160, 1033955221, -1127435882)
		 + W(10, -1133097491, 1036694112, -1111308161, 1036064001)
		 + W(11, 1039332997, -1103055030, 1027541135, 1022453269);
	WS(1044586414, 987793058);
	sum1 = W(0, 981244734, 1029861564, -1127551587, 1008852553)
		 + W(1, -1110264932, -1120415085, -1128191927, -1111219811)
		 + W(2, -1094962922, -1105742952, -1103252055, -1106380176)
		 + W(3, 1039776063, 1036900841, 1025145152, 1028803677) + W(4, 1056192743, 1054313512, 1058042871, 1048369556)
		 + W(5, -1104749720, -1097596121, -1105335335, -1103570473)
		 + W(6, -1106851755, -1099782448, -1098041547, -1096188128)
		 + W(7, 1052995119, 1058305414, 1045503990, 1055249646) + W(8, -1119312576, 1027895469, 1019737521, -1121596880)
		 + W(9, -1106765091, -1098125906, -1106717007, -1101993823)
		 + W(10, -1109764848, 1032524411, -1110892330, 1024237680)
		 + W(11, -1120426409, 1026360866, -1151171624, 1031597860);
	sum2 = W(0, -1170894487, -1116947191, 1031282910, -1112734885)
		 + W(1, 1042944653, -1112368696, 1023647443, -1149951158)
		 + W(2, 1038321486, 1032730216, 1034140662, -1104751545)
		 + W(3, -1102906173, -1115060896, -1124833342, -1103764076)
		 + W(4, 1053283699, -1102463031, 1044178467, 1054507486)
		 + W(5, -1128523954, 1038784522, -1109068581, -1105151256)
		 + W(6, -1093894288, -1109920837, -1089191295, 1065532097)
		 + W(7, -1115680584, 1029167633, 1021288403, 1048070264)
		 + W(8, -1100030896, 1047091130, -1097946325, -1095028025)
		 + W(9, -1094781909, 1050920778, -1113980416, 1052479172)
		 + W(10, 1046510222, -1098101478, 1046381950, -1113780206)
		 + W(11, 1020709100, -1114933696, -1114621382, -1120673083);
	WS(-1114317660, -1079530866);
	sum1 = W(0, 1005492722, 1045601427, -1125684614, 1040691817)
		 + W(1, -1138701159, -1122106750, 1010492340, -1132247342)
		 + W(2, -1115918380, -1100871485, -1122621547, -1094477942)
		 + W(3, 1044150368, 1041157065, 1039210328, 1037992735) + W(4, -1124407701, 1040297908, -1098312611, 1054673340)
		 + W(5, 1041833209, -1120050519, -1116922669, 1025359158)
		 + W(6, -1116105277, -1115200394, -1103806788, -1097950923)
		 + W(7, -1088150296, 1040435582, 1025767275, 1032362656) + W(8, 1041270838, 1034785295, 1049040249, -1103823208)
		 + W(9, -1129519613, -1121264402, -1133614768, -1107139719)
		 + W(10, -1125596386, 1024917256, 1026343653, 1033886401)
		 + W(11, 1039772509, 1028146611, 1030520276, 1032249339);
	sum2 = W(0, -1155531695, -1116868484, -1135508412, -1106991844)
		 + W(1, -1135674828, 1001487940, -1119877490, -1131775200)
		 + W(2, 1035594747, -1130123766, -1121397012, -1115576312)
		 + W(3, -1126221532, -1107263445, -1121744498, -1125291430)
		 + W(4, -1111112193, 1034328851, 1033705026, 1050004218)
		 + W(5, -1117911568, -1123887534, 1017446183, -1110635219)
		 + W(6, -1101564588, -1113096514, 1029679690, 1048453590) + W(7, 1050922209, 1043692754, 1034884616, 1032206024)
		 + W(8, -1116834132, -1115452418, -1152418495, 1029930774)
		 + W(9, 1007646710, -1114385718, -1122169416, 1016330315)
		 + W(10, -1130931838, -1123313694, 1018386998, -1127714868)
		 + W(11, -1121358676, 1023927325, -1115969900, -1122013064);
	WS(1066254326, -1103165682);
	sum1 =
		W(0, 1032736195, 1027879829, 1031762634, -1123062443) + W(1, 1004281096, -1148973229, -1119568276, -1130151676)
		+ W(2, -1107990998, -1114107453, -1103287009, 1041209406)
		+ W(3, 1039171204, -1113506869, 1029657432, 1042306865) + W(4, 1040177417, -1121888407, 1058340070, -1097968365)
		+ W(5, -1082040497, 1042461256, -1110264442, -1106785311)
		+ W(6, -1102376817, 1024426522, -1086180914, 1045901207) + W(7, 1060563077, 1045252895, 1035749465, 1042341554)
		+ W(8, 1034252186, -1134855959, 1048880356, -1117801777)
		+ W(9, -1108119503, 1021862138, 1017288487, -1125959462)
		+ W(10, 1019040113, 1012754494, -1128188760, -1116847305)
		+ W(11, -1149008906, -1140572507, 1021245074, 1010461490);
	sum2 = W(0, 1021177914, -1124089023, 1026640236, 1019818775) + W(1, 1019369915, -1106530127, 1038187852, 1030498751)
		 + W(2, -1111267114, 1044764288, 1026571855, -1103902938)
		 + W(3, -1139759728, 1046869720, -1116925721, -1107211067)
		 + W(4, 1038432054, -1106310853, -1115065858, 1063205014)
		 + W(5, 1054784388, -1096246655, -1115197568, 1035488589)
		 + W(6, -1105822865, -1100663157, -1088005063, 1066152263)
		 + W(7, -1093573252, -1098236584, 1033917272, -1107121631)
		 + W(8, 1037666445, 1039738660, -1097556837, -1094681119)
		 + W(9, -1095778937, 1051664274, -1104072801, 1038730556)
		 + W(10, -1122267795, -1121288215, 1045614354, -1112191805)
		 + W(11, 1041592438, -1110480242, 1015983837, 1022742082);
	WS(1062838508, -1098141683);
	sum1 = W(0, -1134697126, 1033720508, -1121504814, -1119656591)
		 + W(1, 950602286, -1114868293, 1034808260, -1113093265) + W(2, -1129876167, 1021336509, 1014720225, 1046652247)
		 + W(3, 1047400131, 1033072079, -1139606129, 1026913289)
		 + W(4, -1116304310, -1104597903, -1101916102, -1082370571)
		 + W(5, -1091801796, -1096699752, -1121911577, -1098146380)
		 + W(6, -1099161722, 1019102333, 1049624810, 1058084844) + W(7, 1053105145, 1050650780, 1034036747, 1048726310)
		 + W(8, 1038618718, 1045312786, 1036131058, 1029119981) + W(9, -1119759594, -1119884597, 1024218735, 1017329950)
		 + W(10, 1030514076, -1118743028, -1134396481, 1009920435)
		 + W(11, -1132133195, -1133963803, 990998386, -1121758433);
	sum2 =
		W(0, -1120814392, 1018600110, 1027325255, -1124538308) + W(1, -1127260613, 1007599328, -1128821133, -1125977712)
		+ W(2, 1026947049, -1114533760, -1112504706, -1107191892)
		+ W(3, 1023329910, -1124222597, 1024046209, 1019591350) + W(4, -1124609851, 1043306429, 1030055965, -1090928488)
		+ W(5, 1046523168, 1015958190, 1022187138, -1115445424) + W(6, 1029294693, -1096357662, 1075131584, -1118772404)
		+ W(7, -1092017575, -1113584525, -1109468012, -1105922548)
		+ W(8, -1089366560, -1078857162, -1106088729, 1060040329) + W(9, 1045316672, 1047822624, 1021757630, 1038940063)
		+ W(10, 1054044776, -1109773692, -1105806639, -1102685120)
		+ W(11, -1119137158, 1032716843, -1120065319, 1016647840);
	WS(1054286935, 1054427377);
	sum1 = W(0, -1139016422, 1015966225, 1034481375, 1029692191) + W(1, -1118014037, 1037138557, -1107878452, 996243233)
		 + W(2, 1031868724, 1024526894, -1107528289, -1123790766)
		 + W(3, 1033739398, -1101429240, 1035472806, -1114181077)
		 + W(4, -1103470657, -1100637795, 1043922306, -1096987004)
		 + W(5, -1103397016, 1045510949, -1113746932, 998962565) + W(6, 1027450488, 1046711412, -1098573729, 1036148808)
		 + W(7, 1053311986, 1016118627, -1127637067, 1041113135)
		 + W(8, 1036611766, -1105992614, 1045477269, -1138151730)
		 + W(9, -1103945702, 1013880803, 1041047838, -1118755335)
		 + W(10, -1113202838, 1036202402, -1121078688, 1006910195)
		 + W(11, 1033532379, -1135069562, -1112788047, 1020627009);
	sum2 =
		W(0, 998302909, 1020343611, 1029585253, 1014080934) + W(1, -1135780688, -1115911996, 1018594371, -1117868456)
		+ W(2, -1114977231, 1031676937, -1113383024, 1053648356) + W(3, 1044096370, 1042686855, -1108781434, 1037265024)
		+ W(4, -1111023634, -1115901635, -1091081120, -1095412525)
		+ W(5, 1066870285, -1137657706, 1043350243, -1126645268)
		+ W(6, 1036510752, -1117993552, -1099268355, -1083342245)
		+ W(7, 1034064765, 1037488276, 1014772326, -1113946823) + W(8, 1004185429, 1041465226, -1113451820, -1115471327)
		+ W(9, -1118193886, 1023464409, -1138084208, 1032826620)
		+ W(10, 1033017445, -1113757911, 1021941233, -1161911507)
		+ W(11, -1120710156, 1018751107, -1148724493, 967002060);
	WS(1069042774, 1023813606);
	sum1 =
		W(0, -1120569815, 982627530, -1113058670, -1122018428) + W(1, -1110295833, 1021479086, 1001627822, 1013049407)
		+ W(2, 1029846837, -1113747494, 1033076468, 1039673254) + W(3, 1038190732, 1046432919, -1134594983, 1016231853)
		+ W(4, -1087916882, -1109565588, -1095056850, -1085384902)
		+ W(5, -1083727323, -1089999723, -1094559921, -1094610970)
		+ W(6, 1052864835, 1048856613, 1056781822, 1059308179) + W(7, 1063669175, 1059014405, 1044534497, 1048044230)
		+ W(8, 1037940281, 1011966045, 1041407837, -1107102153) + W(9, -1111254596, -1110936865, 1025983877, 1046858383)
		+ W(10, -1130288148, -1136915076, -1140629239, 1027021082)
		+ W(11, 1007651659, -1128736648, -1139332738, -1114487747);
	sum2 = W(0, -1097118790, -1115645027, -1109249259, 1042765123)
		 + W(1, 1015795842, 1028792702, -1116071919, -1105083736)
		 + W(2, -1088323667, 1030684990, -1081609065, -1082143899)
		 + W(3, -1102809807, 1059694558, 1064574838, 1072110122) + W(4, 1067177084, 1056476304, 1058423359, 1061996602)
		 + W(5, 1006287482, -1085597397, -1080103447, -1081832849)
		 + W(6, 1049654149, -1101283859, 1057270411, 1055747315)
		 + W(7, -1087207348, -1106003210, 1023804763, -1090423898)
		 + W(8, -1120538318, 1040556965, -1122455315, -1120372038)
		 + W(9, -1106540179, 1042932361, 1048665861, -1101912272)
		 + W(10, -1108580354, -1124995735, 1017763415, -1114753052)
		 + W(11, 1040354664, 1033427208, -1098395984, 1049644025);
	WS(1046279854, -1100682627);
	sum1 = W(0, -1155754074, -1110611178, 1022309140, -1118509483)
		 + W(1, -1109973457, 1022155595, -1107208537, -1117715774)
		 + W(2, -1109896894, -1114421037, -1131162933, 1027993210)
		 + W(3, 1040243222, -1117693450, 1019138289, 996768085) + W(4, -1107576521, 1030120983, -1094043528, 1062355587)
		 + W(5, -1094900881, -1110047247, -1110631994, -1107567326)
		 + W(6, 1035511522, -1124410677, 1038811574, 1059809630) + W(7, 1038778317, 1046487839, -1127423844, 1039784548)
		 + W(8, 1002805634, -1114543731, 1039227081, -1113128332)
		 + W(9, -1105636701, -1109843880, 1004796827, -1112311954)
		 + W(10, -1116898232, 1008443967, -1122237996, -1141634631)
		 + W(11, 1021837827, -1132048229, -1123472091, -1128081977);
	sum2 =
		W(0, -1155805362, -1111094572, 1028160711, -1123681391)
		+ W(1, -1116453985, -1119301235, -1108559318, -1115385578)
		+ W(2, -1107499970, -1112866732, -1106540686, -1140638716)
		+ W(3, 1031083122, -1139408516, 1034592379, -1116565509) + W(4, 1022847832, 1044264749, -1155674450, 1057429467)
		+ W(5, -1106158641, 1025824831, -1111164410, -1121519923)
		+ W(6, 1035480223, -1148903065, 1040150233, 1045538131) + W(7, 1031696457, 1041846065, -1120456085, -1129601606)
		+ W(8, -1120962569, -1114470280, 1010774604, 1016428102)
		+ W(9, -1120179561, -1118124541, 999266665, -1119709653)
		+ W(10, -1110725720, 1021130376, -1120260095, 1009992044)
		+ W(11, 1026515918, -1114275912, 1011855672, -1115407958);
	WS(1068834358, -1130516755);
	sum1 = W(0, -1110020716, 1043574522, -1110718798, -1129582842)
		 + W(1, -1114402010, 1034180284, 1025857751, -1111247176)
		 + W(2, 1034114243, -1095778974, 1047457188, -1108460854)
		 + W(3, 1054126843, -1096959660, 1033414773, 1039130852) + W(4, 1048068617, 1048936405, 1038642250, -1114164062)
		 + W(5, -1110583455, 1049433806, -1136840220, -1119539023)
		 + W(6, -1102038774, 1035735542, -1105529591, -1096174934)
		 + W(7, -1112126358, 1043709316, -1123546692, -1112879245)
		 + W(8, 1031998965, -1100504766, 1047377413, -1130108598)
		 + W(9, 1044906670, -1095231947, -1130058411, 1035429307)
		 + W(10, -1110620517, 1038840817, -1109142655, 1023990363)
		 + W(11, -1122044916, 1040978881, -1131191403, -1115530151);
	sum2 = W(0, 970017593, -1125442959, -1107196630, -1108273260)
		 + W(1, -1130992285, -1132402709, 1017358256, 988670622) + W(2, -1108165952, 1040753488, 1033984686, 1051322703)
		 + W(3, -1113564209, 1041587650, -1116630320, -1122802752)
		 + W(4, 1047729556, 1000227776, 1038319755, 1055231112) + W(5, -1094436986, 986706110, -1124437274, -1132214419)
		 + W(6, -1102798485, -1088611471, -1087549565, 1062180091)
		 + W(7, 1046553690, -1113546876, -1120036494, 1032902155)
		 + W(8, -1142827268, 1049645408, -1127043239, -1103837458)
		 + W(9, -1107399737, 1048231400, -1124561928, -1145381770)
		 + W(10, 1029593938, -1108133201, -1114349374, 1035145460)
		 + W(11, -1114342182, -1146643074, -1126967424, 1014303584);
	WS(1067517750, 1033639701);
	sum1 = W(0, 1025509678, -1130341242, -1120272434, 1018375590)
		 + W(1, -1116961737, 1026047982, 1025041660, -1113724179)
		 + W(2, -1102897085, -1132678155, -1151042791, 1013105800)
		 + W(3, 1041000592, 1032243033, 1034904976, -1123793645)
		 + W(4, 1023511162, -1096924480, -1094474081, -1086033191)
		 + W(5, -1085852953, -1093123217, -1093479580, -1091335173)
		 + W(6, 1037697110, 1040728225, 1056422164, 1062857884) + W(7, 1058773976, 1063905370, 1050274619, 1057695471)
		 + W(8, 1039047450, -1108434135, 1032921189, -1122589009)
		 + W(9, -1100255843, -1106044526, -1112977566, -1136654701)
		 + W(10, -1138182274, -1138791135, 1010850641, 1034477848)
		 + W(11, -1112868181, 1026848855, -1122948276, 1007925107);
	sum2 =
		W(0, -1101843642, 1047092496, 1032746990, -1098074183) + W(1, 1053786699, -1096910060, 1043846267, 1023876031)
		+ W(2, -1101718380, -1110599661, -1127672356, -1096713677)
		+ W(3, -1104014372, 1035860070, -1097849415, 1051096852) + W(4, 1046322966, 1053918698, -1100340247, 1069438643)
		+ W(5, 1025809994, -1083706115, 1048729218, -1081917128) + W(6, 1051125372, -1092942861, 1040369276, 1074732797)
		+ W(7, 1050011098, -1080423025, -1117530220, -1091623712)
		+ W(8, -1084762721, 1058235489, -1090389206, -1088693676) + W(9, 1053232821, 999981171, -1097505133, 1050919626)
		+ W(10, 1050651985, -1101055683, 1050412863, -1103557505)
		+ W(11, 1052371166, -1099152238, 1041618808, -1123531943);
	WS(-1098378327, -1087753140);
	sum1 = W(0, -1149815841, 1013838405, 1021155853, 1025974631) + W(1, 1017740987, 1020943940, -1137239299, 1031952605)
		 + W(2, -1123262056, -1131552366, -1114416842, -1103162646)
		 + W(3, -1099404299, -1100518162, -1111541722, -1098489580)
		 + W(4, -1110243207, 997589309, -1104972312, 1042062186) + W(5, 1057054155, 1059648114, 1047878460, 1061110492)
		 + W(6, 1053738584, 1025605911, 1049179692, -1094476095)
		 + W(7, -1093068705, -1101042271, -1111532695, -1100382705)
		 + W(8, -1096838314, 967065877, -1108406847, -1130981226) + W(9, 1023051300, 1010424693, -1117167136, 989087216)
		 + W(10, 1031741109, -1135340592, 1029594857, -1145022506)
		 + W(11, 1005012974, -1112923496, 1030823984, -1113821120);
	sum2 =
		W(0, 1034695587, -1111830177, 1017885202, -1116805918) + W(1, 1039973913, -1113376464, 1024357631, -1109344122)
		+ W(2, 1032463913, 1031752431, -1103205904, 1045285117) + W(3, -1092035876, 1044034906, -1097056010, 1034392181)
		+ W(4, -1087773887, -1104893727, -1114987001, 1061301409)
		+ W(5, 1053784665, -1096259933, 1015259894, -1095057905) + W(6, 1051055536, 1010301739, 1045597173, 1065451004)
		+ W(7, 1036331211, -1101789830, -1105822235, -1098597360)
		+ W(8, -1103774157, 1003908630, -1107230114, 999416278)
		+ W(9, -1118216068, 1047293827, -1119063058, -1139528651)
		+ W(10, 1028563957, -1111301343, 1042437558, -1106181364)
		+ W(11, 1014136811, -1127455968, -1137717779, 1017174230);
	WS(1051991511, -1090129628);
	sum1 = W(0, -1119709994, 1028979258, 1025569135, 1025156752)
		 + W(1, -1113846787, 1032797781, -1137003429, -1126457798)
		 + W(2, 1035475128, -1103260128, -1099928080, 1041023848) + W(3, 1030722332, 1040845476, 1015665914, 1032471277)
		 + W(4, 1044364174, 1048862488, 1054464119, -1103260308) + W(5, -1090331224, 1039529634, 1015668019, 1036006161)
		 + W(6, -1099369674, -1107028176, -1092954947, 1048877896)
		 + W(7, 1036105176, -1113372113, -1104520406, -1111431094) + W(8, 1024914253, 1037758213, 1045752341, 992983000)
		 + W(9, -1115078629, 1027244574, 1039091960, -1113568276)
		 + W(10, -1122358045, -1142000036, -1110227337, 1023847918)
		 + W(11, 1018698636, -1139349278, -1131269376, 1004297100);
	sum2 =
		W(0, 1043798657, -1117698064, -1102458928, -1101130902) + W(1, 1025730631, 1026623851, 995294154, 1012466631)
		+ W(2, -1098470129, -1096590117, -1084690772, 1065791971)
		+ W(3, -1123809426, 1019910088, 990258218, -1124630920) + W(4, -1126555274, 1047971790, 1067678357, -1099131342)
		+ W(5, 1036453804, -1117295572, -1116170672, 1010360391) + W(6, 1029962999, 1037727050, 1008201251, -1083609361)
		+ W(7, 1031198846, -1113754273, 1030505142, -1136369090)
		+ W(8, 1028782608, -1161955740, -1103096568, 1051059538)
		+ W(9, -1106261335, 1041141064, 1028328942, -1119361560)
		+ W(10, -1131048284, 1022180969, -1120783295, 1014843769)
		+ W(11, 1020274026, -1111232000, -1127235720, 1001879503);
	WS(1062559660, 1025273829);
	sum1 = W(0, 1017067222, 1004255955, 1019590495, -1109975080) + W(1, 1028071367, 1004648665, -1129853588, 999516190)
		 + W(2, -1098241838, 1041017424, -1136327879, 1032386976)
		 + W(3, 1031451349, -1112687016, 1040197151, -1105242363)
		 + W(4, -1088364567, -1088941672, -1087512143, -1083706517)
		 + W(5, -1089169701, -1092690193, -1100415991, -1093365052)
		 + W(6, 1060515311, 1050253504, 1064814036, 1061681108) + W(7, 1061080357, 1052988124, 1048643203, 1050105214)
		 + W(8, -1113064427, -1115329590, -1113817187, -1146803505)
		 + W(9, -1112935650, 1031379878, -1112391860, 1051227835)
		 + W(10, 1036248943, -1133026900, 1008140615, 1028690158)
		 + W(11, 1010963867, 1030651112, -1133141907, -1139571464);
	sum2 =
		W(0, 1058977722, -1123128465, 1051128320, 1025585093) + W(1, 1043020026, -1090331128, 1037612985, -1101815127)
		+ W(2, -1088438618, -1084402469, -1097793743, -1092491618)
		+ W(3, -1090336452, -1094761348, 1032815200, -1080227574)
		+ W(4, -1070888183, -1068917363, -1079680807, 1078112044)
		+ W(5, 1082393215, 1070728174, -1090225897, 1066541275)
		+ W(6, -1080154822, -1109667848, -1080832517, 1058335327)
		+ W(7, 1067339759, 1057746923, -1122043266, 1067785018) + W(8, 1057028315, -1133954517, 1057005952, -1089499329)
		+ W(9, 1038175360, -1096630558, 1051816122, -1086032969)
		+ W(10, 1020668753, -1117456198, 1031920962, 1039195999)
		+ W(11, 1046190750, -1139309423, -1116527206, 1046599598);
	WS(-1077531606, -1068627295);
	sum1 = W(0, -1124767318, 1034866077, -1101653116, -1130761376)
		 + W(1, -1106412978, -1121310187, 1040285922, -1107982930)
		 + W(2, -1113367136, 1048375560, -1104403272, 1049955828)
		 + W(3, 1036710310, -1108970480, 1049541454, -1107579101)
		 + W(4, -1095446127, -1099058463, -1090535733, -1087242437)
		 + W(5, -1088900579, -1096168584, -1097928011, -1095682732)
		 + W(6, 1055377197, 1047513184, 1058086815, 1061174628) + W(7, 1057172304, 1056094244, 1047121222, 1054731422)
		 + W(8, -1111814927, 1045191539, -1094831865, 1048150628)
		 + W(9, -1103308083, -1102502166, 1043510842, -1103869114)
		 + W(10, -1126382267, 1025894069, -1117513042, 1008100281)
		 + W(11, 999030326, -1115104524, 1032672660, 1025118882);
	sum2 =
		W(0, -1118325221, -1109912068, 1055626857, 1073210842) + W(1, 1050117205, -1108710534, 1007734945, 1005945059)
		+ W(2, 1021086937, -1119472758, 1051951524, 1028908234) + W(3, 1044779683, 1039597247, -1130127373, 1026547602)
		+ W(4, 1043003051, 1026424546, -1092928023, -1081037490)
		+ W(5, -1093398148, 1044106321, -1119182686, 1019051617)
		+ W(6, -1131106753, 1030452362, -1103671831, -1079815727)
		+ W(7, -1105002867, 1032627417, -1108845723, 1023992222)
		+ W(8, -1122810381, -1109242129, 1034708821, 1035695099) + W(9, 1037167425, -1112762482, -1120996683, 999154803)
		+ W(10, 1007248641, 1007569065, -1112697430, 1034566233)
		+ W(11, -1131640977, 1020894429, -1144614067, 1009135009);
	WS(1027136184, 1037475189);
	sum1 =
		W(0, 1032095571, -1100957374, 1042581547, 1008293424) + W(1, -1125080965, 1046313162, -1104233593, 1032243376)
		+ W(2, -1116112165, 1049686375, 1028374302, -1096656387)
		+ W(3, 1033692244, -1105885187, -1122471385, -1122778646)
		+ W(4, -1115063802, 1038845436, -1088748902, 1053200569)
		+ W(5, 1024446429, -1103807360, 1048125173, -1114896431) + W(6, 1049018533, -1106083983, 1046087792, 1044615055)
		+ W(7, -1090279185, 1052904956, -1106111045, -1113201013)
		+ W(8, -1119314641, -1120251015, 1034473457, -1099043646)
		+ W(9, 1029265287, 1033985068, -1106885357, 1045413959)
		+ W(10, -1107767341, 1047825580, -1104556803, 1041068763)
		+ W(11, 1035958465, -1106489925, 1037737330, -1123269230);
	sum2 =
		W(0, -1109957285, 1046942588, -1108558913, 1035311457) + W(1, -1103268017, 1020819182, 1017489970, -1119040125)
		+ W(2, 1028061230, -1090820835, -1168618571, 1053631926)
		+ W(3, -1140171429, 1024395745, 1034074787, -1111153127)
		+ W(4, 1045893852, 1047577084, -1096957845, -1097789717)
		+ W(5, 1058472778, 1010859305, -1118924631, -1134098557) + W(6, -1110812851, 1048459161, 1058947879, 1028951753)
		+ W(7, -1086199154, 1018177816, -1119421881, 1029986143)
		+ W(8, -1108048047, -1114577527, -1104353646, 1041621301)
		+ W(9, 1047742834, -1101676043, 1030918112, -1110045381)
		+ W(10, 1027149256, -1106934834, -1104794282, -1139749789)
		+ W(11, -1105608688, 1051639728, -1105627073, 1035525353);
	WS(1059085676, -1120419895);
	sum1 = W(0, -1123531970, 1015920803, -1129458830, 1003238718)
		 + W(1, 1024388894, 1019022757, -1122285937, 1029064795) + W(2, 1010567522, 1041225150, 1048968044, -1107069702)
		 + W(3, -1107554082, -1131681870, -1110859547, 1018058500)
		 + W(4, -1140828475, 1042370229, -1081896608, 1061545382) + W(5, 1057779808, 1048429719, 1046207852, 1043188126)
		 + W(6, 1031892193, -1105839574, 1052692461, -1113798029)
		 + W(7, -1080962214, 1023517883, -1107360247, -1109838114)
		 + W(8, -1126417758, 1021017477, -1106306215, 1033163859)
		 + W(9, 1051334024, 974463598, -1137698561, -1182091254)
		 + W(10, 1013434325, -1117671948, 1033141013, -1110196995)
		 + W(11, 998455538, -1104852314, -1130795454, -1115208005);
	sum2 = W(0, -1115293356, -1104270657, 995357221, -1140125409)
		 + W(1, 1041981586, 1016190873, -1140513641, -1115228320)
		 + W(2, 1051048471, 1028093784, -1111420185, -1087783718) + W(3, 1031459460, 1035133120, 1028088400, 1019234873)
		 + W(4, -1116254969, 1055158904, -1108447426, 1057721666)
		 + W(5, -1086769840, -1119040585, -1121069799, 1043934745)
		 + W(6, -1108089569, -1104160418, -1113016550, 1060085251)
		 + W(7, 1041174723, -1119561801, -1114345654, -1097229960)
		 + W(8, -1110389222, 1040482382, -1105273681, -1106428297)
		 + W(9, 1046452617, 1045849559, 1044224673, -1114369945)
		 + W(10, 1032305896, -1109483288, 1033267880, -1106001572)
		 + W(11, -1115354420, -1127947625, -1119205024, 1033437588);
	WS(1063842732, 1069263660);
	sum1 = W(0, -1134238373, 1031532473, -1118861678, 1031846503)
		 + W(1, -1118980549, 1032122901, -1119645672, 1033668289)
		 + W(2, -1122877239, -1122091454, -1114405937, -1102409375)
		 + W(3, -1105793535, -1113900631, -1129606328, -1133229476)
		 + W(4, 1055968823, 1052972391, 1057777668, 1062381841) + W(5, 1065218890, 1051224528, 1055096307, 1043160456)
		 + W(6, -1099884346, -1097152888, -1088480739, -1081966868)
		 + W(7, -1086950263, -1107218856, -1097976619, -1106065147)
		 + W(8, -1101209335, -1119905385, 1025124405, -1166909210)
		 + W(9, 1045788186, -1105943487, 1011470685, -1107257190)
		 + W(10, 1027783644, 1025876211, -1133551424, -1124858713)
		 + W(11, -1146513705, -1136389690, -1153551023, 1024085520);
	sum2 = W(0, 1008982555, -1122047761, -1134583037, -1137222855)
		 + W(1, -1140752305, 1029699842, -1114302140, 1026101716)
		 + W(2, 1017497319, -1119731325, -1110768789, 1050149080)
		 + W(3, 1041298195, -1094516021, 1037679865, 1029205125) + W(4, -1114050188, 1048705804, 1082656561, 1079097716)
		 + W(5, -1069364548, -1064571216, -1105564781, -1121859551)
		 + W(6, 1044555710, -1104624717, 1041907901, -1088882238)
		 + W(7, 1050137131, -1099205492, -1109039739, 1040352044)
		 + W(8, -1115112254, -1113283108, 1041138312, 1033378952)
		 + W(9, 1048604087, -1105508475, 1026612451, -1131493091)
		 + W(10, -1121509319, 1042591944, -1111081434, 1018241317)
		 + W(11, -1128224049, 1008906239, -1118064246, 1024193619);
	WS(-1129102704, 1046511454);
	sum1 = W(0, -1120255189, 992833099, -1134582632, -1138794987)
		 + W(1, -1157138191, -1129425099, 1016407976, -1133147960) + W(2, 1003871004, 1029362986, 988783847, 1011030567)
		 + W(3, -1118838023, -1111313565, -1115457860, -1106432157)
		 + W(4, -1098175836, -1113473140, -1095364566, -1091886143)
		 + W(5, 1040190185, -1149570791, 1037653026, 1038304902) + W(6, 1060542285, 1049212165, 1059935407, 1049733902)
		 + W(7, -1115543549, 1041064643, -1119854466, 1029519512)
		 + W(8, -1104614392, -1118651222, -1098721330, -1109648580)
		 + W(9, -1121023765, -1105481630, 1031662787, -1111089569)
		 + W(10, -1115237700, 1012659838, 1026034940, -1116104473)
		 + W(11, 1036784617, -1112251695, 1023835049, -1170197274);
	sum2 = W(0, 1039353726, -1104263814, 1027240563, 1028285409) + W(1, 1032871415, -1151417050, 1027668005, 1023556565)
		 + W(2, 1022956598, 1036699032, -1120983737, -1106986979)
		 + W(3, -1095425364, -1136397826, -1108376211, -1098325150)
		 + W(4, -1093991321, -1154678850, -1089878099, 1067214284)
		 + W(5, 1047639440, 1051464555, -1104038071, 1061372327)
		 + W(6, -1088722171, -1088770012, -1101846939, 1070132546)
		 + W(7, 1045480826, -1099095249, 1043597107, -1086577064)
		 + W(8, 1039854738, -1104468959, -1096446657, 1029156699)
		 + W(9, -1098508409, 1024325599, -1148394393, 1034968116)
		 + W(10, -1125147089, -1123571799, 1036003207, -1117321918)
		 + W(11, 1027342659, -1150420266, -1138411071, 1031516803);
	WS(1056411607, -1109579684);
	sum1 = W(0, -1129654332, 1027988397, 1041758889, 1027974595) + W(1, 1038643645, 1038422303, -1115801276, 1047822542)
		 + W(2, 1040494825, 1031736403, -1118623100, -1104250813)
		 + W(3, 1023561152, -1115303377, -1111435064, 1037517815) + W(4, 1053570965, 1051564806, 1061336939, 1057393436)
		 + W(5, 1065029703, 1052932495, 1051403778, 1056446507)
		 + W(6, -1089114662, -1091392278, -1087917688, -1081469355)
		 + W(7, -1091410052, -1085011849, -1108233957, -1089621406)
		 + W(8, -1099475130, 1018661052, 1034322317, -1094207710)
		 + W(9, 1052271760, -1096091282, 1036087894, -1095410877)
		 + W(10, 1041782836, 1032323860, 1035039650, 1010041732)
		 + W(11, 1041287822, 1020820966, 1036272138, 1043391417);
	sum2 = W(0, -1114696922, 1043151870, -1098855398, 1045725515)
		 + W(1, 1041130784, -1093166728, 1048010869, -1097485062)
		 + W(2, 1063327246, 1054945342, -1111180476, -1078968963)
		 + W(3, -1075182266, -1073598210, -1072729035, -1069127579)
		 + W(4, -1085101471, -1091433742, 1044429796, 1071264665) + W(5, 1068966947, 1074573142, 1072575447, 1082548410)
		 + W(6, -1089121793, -1108711949, -1096795753, 1049748951)
		 + W(7, 1041099170, -1107925652, -1087601324, 1057234494) + W(8, 1049274948, 1036153834, 1047012469, 1043607695)
		 + W(9, 1008700501, -1106854972, -1100708600, -1095686167)
		 + W(10, 1041765085, -1114908726, 1017938665, -1113887753)
		 + W(11, 1052357470, -1097732836, 1035577978, -1117196119);
	WS(-1075355670, -1094395357);
	sum1 = W(0, -1145694380, 1031927794, -1126751284, -1107635165)
		 + W(1, 1035883256, -1117999477, 1025403748, -1135056568) + W(2, 1013276974, 1019602069, 1034056645, 1046251906)
		 + W(3, -1107984424, -1101824103, -1117853800, -1113050587)
		 + W(4, 1022872131, 1012968093, 1064151904, 1059501808) + W(5, 1052823861, 1052884390, 1040309473, 1051481338)
		 + W(6, -1102394069, -1105184299, -1089968245, -1079531190)
		 + W(7, 1040654683, -1097950850, 1021798787, -1099617206)
		 + W(8, -1132601278, -1113047243, -1112578984, 1045395638)
		 + W(9, 1035604635, -1102570614, 1016601958, -1117559395)
		 + W(10, 1032373060, -1123577887, 1012023536, -1121043161)
		 + W(11, -1136193989, -1124087697, 1014648876, 1015049529);
	sum2 = W(0, 1040559153, -1099966915, 1051040838, -1122400566)
		 + W(1, -1103745056, -1127876766, -1118336076, -1122216569)
		 + W(2, 1024400373, 1050797480, -1098907063, -1088192853) + W(3, -1132746540, 1040989775, 999475557, 1024449813)
		 + W(4, -1112035522, -1095559069, -1091507667, 1063399780)
		 + W(5, 1064106398, -1101527709, 1025976147, -1118033876)
		 + W(6, -1102969122, 1048535090, -1081423354, 1065515124)
		 + W(7, -1104928579, 1047332946, -1171911780, 1047796018)
		 + W(8, 1035694118, -1109162397, 1049424016, -1098794388)
		 + W(9, -1097345189, -1105732065, -1107661001, 1036172042)
		 + W(10, 1008704054, 1035803260, 1032276403, -1104133833)
		 + W(11, 1042270874, -1109516912, 1033064723, -1106418589);
	WS(1045480366, -1089018411);
	sum1 = W(0, 956510844, 998930446, -1129843310, -1113698796) + W(1, 1001814128, -1126854725, 1033942209, -1127622934)
		 + W(2, -1147321796, -1119371847, 1033743797, 1047477674) + W(3, 993727556, 1019312750, 991522899, -1124727396)
		 + W(4, -1098659472, -1114996930, -1084286683, -1080535200)
		 + W(5, -1100569285, -1095107249, -1106428344, -1102902186)
		 + W(6, 1046172476, 1016456206, 1060852743, 1065762350) + W(7, 1055209670, 1054147605, 1040201800, 1049320503)
		 + W(8, -1117032824, 1032232105, 1034928007, 1036591131)
		 + W(9, 1034876769, -1103835661, -1110790848, -1117790432)
		 + W(10, 1012429717, 992745416, -1120189081, -1130833259)
		 + W(11, -1112309127, -1162991986, 1019870324, -1166423644);
	sum2 = W(0, -1135134951, -1138029383, 1039247354, -1105815405)
		 + W(1, 1043479193, -1108579602, 1036464698, -1114044136)
		 + W(2, 1034251754, -1112450391, 1048129179, 1013788103)
		 + W(3, -1107279344, -1098532570, -1125069222, -1106884027)
		 + W(4, -1112699779, 1048844919, -1081251706, -1102377508)
		 + W(5, 1074756442, -1079912447, 1051417558, -1113485350)
		 + W(6, 1028246411, -1097747276, 1030988939, -1085286825) + W(7, 1066704374, 1048531717, 1025432715, 1037742006)
		 + W(8, 1024730233, 1036047504, 1032907358, -1098604264)
		 + W(9, -1121203556, -1097926469, 1037541288, -1114746618)
		 + W(10, -1141862453, -1116303285, 1032058431, 1026446373)
		 + W(11, -1115422697, 1017067577, -1110631868, 1026757097);
	WS(-1129198960, -1098545020);
	sum1 = W(0, 1016631370, -1109829274, 1027654249, -1135763497)
		 + W(1, 1022371969, -1109147378, -1124465415, 1000105708)
		 + W(2, -1103774667, 1046260982, 1041444949, 1029491033) + W(3, 1033440347, 1047095266, -1135425502, 1031236725)
		 + W(4, -1097986678, -1103302894, -1085753764, -1087937321)
		 + W(5, -1100503343, -1092825640, -1114972810, -1092048676)
		 + W(6, 1055978916, 1038066845, 1057520791, 1064242364) + W(7, 1043702710, -1106434743, 1042256612, 1048160666)
		 + W(8, 998946812, 1013747092, 1033950432, -1108378356) + W(9, -1149232679, 1039795292, -1134578155, 1047273267)
		 + W(10, -1113370572, 1026014767, -1133701934, -1124979408)
		 + W(11, 1034434352, -1123636138, -1133096682, -1110866582);
	sum2 =
		W(0, 1008784866, -1111810524, -1123287968, 1035375858) + W(1, -1131156064, 1014562100, 1013976797, 1025684805)
		+ W(2, -1101060946, 1041574978, -1113715041, 1009783259)
		+ W(3, -1117592464, 1037249766, -1112331585, -1116058888)
		+ W(4, 1045200185, -1109901275, -1111729623, -1099551228)
		+ W(5, 1028611861, -1126723736, 1048583824, -1123970907) + W(6, 1046672822, -1123470329, 1052382391, 1057574679)
		+ W(7, 1037781521, -1088911756, -1105025107, -1098796399)
		+ W(8, -1118279822, -1113194466, -1105523541, -1090683445)
		+ W(9, -1089242363, 1057541056, 1046019340, 1058673062) + W(10, 994298612, -1124039764, 1016737108, 1025528776)
		+ W(11, 1044936991, 1038965019, -1100984465, -1111874598);
	WS(1055927127, 1032414456);
	sum1 = W(0, 1026777470, -1114645447, -1107741345, 1034928754)
		 + W(1, -1106080726, 1036990351, -1132545269, -1115024108)
		 + W(2, -1105922759, 1038629978, -1118870909, 1048976902)
		 + W(3, 1031310464, -1116578243, -1121324945, 1028926430)
		 + W(4, 1039415013, -1109541160, -1121580331, 1035267569)
		 + W(5, -1092363639, 1052806443, -1105847083, -1107491323)
		 + W(6, -1114467391, 1049649890, -1099187900, -1110167275)
		 + W(7, 1044706191, -1098780639, 1042096283, 1026721601) + W(8, 1040445212, -1118657663, 1040802710, 1050521172)
		 + W(9, -1122260014, 1045812872, -1112784326, 1028974308)
		 + W(10, -1109775801, 1029983880, -1103039897, 1032803169)
		 + W(11, -1106266495, -1117906236, 1031828590, -1113700371);
	sum2 =
		W(0, 1046339838, -1116647554, 1008329020, 1019769686) + W(1, -1108633040, 1035617664, 1033551944, -1127469148)
		+ W(2, -1095477634, 1046850624, 1046890022, -1090363791)
		+ W(3, 1015468535, -1092874283, -1110478242, 1032940188)
		+ W(4, 1041080449, -1097525459, -1087064144, 1051375999)
		+ W(5, 1042338708, 1061754259, -1118600243, -1108757958)
		+ W(6, -1106007640, 1046513622, 1055899106, -1097018549)
		+ W(7, -1122727333, -1100515622, 1043707610, 1042447169) + W(8, 1022253579, -1109703351, 1048733947, 1049672544)
		+ W(9, 1051464963, 1025134369, -1099218588, -1108633308)
		+ W(10, -1124447256, 1043170037, -1100004355, -1097807314)
		+ W(11, -1129042543, -1112390214, 1040819075, -1120359161);
	WS(1063732396, 1030954530);
	sum1 = W(0, 1032126752, 976782235, 1026279044, -1118035684) + W(1, 1028715099, -1121995199, 1032435871, -1124714096)
		 + W(2, 1036299263, -1151769923, 1034233519, 1048463661) + W(3, 1036782808, 1036166050, 1020132772, 1046021200)
		 + W(4, 1040042182, -1126287138, 1024363996, -1092651532)
		 + W(5, -1113174091, -1102126950, -1118937966, -1096484767)
		 + W(6, -1085959612, -1100277765, -1112294345, -1099766629)
		 + W(7, 1035866674, 1049742039, -1116277291, 1041160144) + W(8, 1040218780, 1040546448, 1044348191, 1048686290)
		 + W(9, 1009750781, -1118854702, 1040779899, 1026126509)
		 + W(10, 1017251428, -1135394341, -1164354746, 1013744650)
		 + W(11, -1137751148, 972654113, -1123833085, 1032085003);
	sum2 = W(0, 1023560328, 1005726416, -1116687692, -1115408842)
		 + W(1, 1041728877, -1105589301, 1038558105, -1113100068)
		 + W(2, -1114346246, 1027252420, -1128267680, -1102003721)
		 + W(3, 1038357336, 1012806192, 1025579970, 1032847335) + W(4, 1055635447, 1058379047, -1093219742, -1075825777)
		 + W(5, -1122468504, 1043596623, -1110943172, 1037773232)
		 + W(6, 1080093571, 1066361916, -1079490865, -1069273193)
		 + W(7, 1048667285, 1040586029, 1032482622, -1123027612) + W(8, 1053265582, 1041698127, 1044641580, -1103412699)
		 + W(9, -1104322529, -1123753164, -1134749344, 1003892288)
		 + W(10, -1109086292, 1032891532, -1142986448, 1040229437)
		 + W(11, 1008854368, -1116993440, -1125346072, 1027065900);
	WS(-1091386327, 1040820769);
	sum1 = W(0, -1133727678, 1015097725, -1138479056, -1114059050)
		 + W(1, 1024901707, -1122041679, 1013224377, -1123564392)
		 + W(2, -1113530145, -1145488419, 1016526204, 1038143634)
		 + W(3, -1118547201, 1031893970, -1120867010, 1007161468)
		 + W(4, 1024243708, -1111308865, -1103657483, -1091368514)
		 + W(5, -1102986721, -1104061090, 1020963773, -1118947879)
		 + W(6, 1033777591, 1043618337, 1057905859, 1056300329) + W(7, 1019703993, 1024793576, -1114932462, 1024563890)
		 + W(8, 1009482248, -1113425624, -1104459527, -1103801765)
		 + W(9, 1043076580, 1039830345, 1042855834, -1129826522)
		 + W(10, -1122301794, 1016257779, 1026855702, -1136938187)
		 + W(11, -1118577003, -1111999542, -1119434421, 1018984621);
	sum2 =
		W(0, -1118014300, -1121259996, -1118480989, -1120519112) + W(1, 1034237400, 1031820662, -1116062192, 1029964608)
		+ W(2, -1107425211, 1034914627, 1057124947, 1041680563) + W(3, -1110358856, -1114315301, 1010762999, 974005161)
		+ W(4, 988341556, 1058886039, 1080471640, -1067455811) + W(5, -1105716188, -1113532913, 1033223294, -1106855886)
		+ W(6, -1122432623, 1043257251, 1049657622, -1080970083)
		+ W(7, -1091987171, 1051213388, -1109593637, 1037720533) + W(8, 1031639360, -1110426684, 981320073, -1105451271)
		+ W(9, 1044181951, -1110623014, 1038375349, 999181553) + W(10, -1122715046, 1030027284, 1022014335, 1012008135)
		+ W(11, -1121988626, 1009779611, -1113750985, 1028099986);
	WS(1067317974, -1128063738);
	sum1 = W(0, -1112292702, 1030230219, 1023947008, 1037678225) + W(1, 1016840879, 1032095758, 1018620213, 1023530868)
		 + W(2, 1047000343, 1008892739, 1038318737, -1110797816)
		 + W(3, -1118959774, -1114918032, -1114992535, 1004226268)
		 + W(4, -1088068429, -1130941083, -1122235065, 1055157388)
		 + W(5, 1048428783, 1052878187, 1036886165, 1052393190) + W(6, 1048838463, -1108932456, 1034700890, -1096039434)
		 + W(7, -1113377160, -1088738347, -1100769370, -1082056652)
		 + W(8, -1121751190, 1013016624, -1165199081, 1039874719) + W(9, 1031603132, 1045859362, 1028131502, 1050791676)
		 + W(10, 1027999791, 1017454988, 1031463650, 1025959551)
		 + W(11, 1018062255, -1143147336, 1018649043, -1115371169);
	sum2 =
		W(0, 1017164622, 1004731920, 1046790460, -1106036842) + W(1, 1036535757, -1103678216, 1025471738, -1122761780)
		+ W(2, -1091622621, 1038964407, 1049069382, 1047078409)
		+ W(3, -1107481011, -1098544714, 1040369699, -1107095641)
		+ W(4, 1072454217, -1113390241, -1080520963, -1071223185) + W(5, 1059476479, 1061994978, 1053016271, 1054597152)
		+ W(6, 1067262657, -1112910469, 1044434118, -1073367678) + W(7, -1099641871, 1029437169, 1051233508, 1062276141)
		+ W(8, -1098954881, 1038887363, 1033204278, -1106847320) + W(9, 967303234, 1030771421, -1123160801, -1113404397)
		+ W(10, 1035940089, -1108193245, 1032575148, -1127548642)
		+ W(11, 1015223408, -1109007913, 1042599225, -1116480773);
	WS(-1095745367, -1102532016);
	sum1 =
		W(0, -1117700567, -1125050061, -1104292247, 1032821374) + W(1, -1106685309, 1026094807, -1109617979, 1025256272)
		+ W(2, -1131139906, -1115476726, 1044141479, 1043020835) + W(3, 1033588284, 1027591436, 1031476842, -1109574827)
		+ W(4, -1104729417, 1049785973, -1096094522, -1103984511)
		+ W(5, -1135965844, -1092452582, 1035377859, -1108767399) + W(6, 1031266390, 1034862742, 1043929817, 1025371182)
		+ W(7, 1048857569, 1049600882, -1127826823, 1045422790) + W(8, 1034962037, -1108925228, -1121682994, 1003529681)
		+ W(9, -1108409524, 1029191534, -1105178749, -1147768356)
		+ W(10, -1123836106, 1021444802, -1112024639, 1036065165)
		+ W(11, -1114922921, 1028793076, 1025559229, 1027631502);
	sum2 = W(0, -1102917712, -1090566997, -1083236080, -1084121809)
		 + W(1, -1092542987, -1098664696, -1115432352, -1109069600)
		 + W(2, 1050493331, 1058641835, 1072277942, 1066117726) + W(3, 1055792221, 1016159325, -1123932559, -1107091755)
		 + W(4, -1104683957, -1106617401, -1083529216, -1110147426)
		 + W(5, 1053260074, 1047496584, 1040670728, 1041712051) + W(6, 1038417192, -1131983160, 1026745412, -1097349120)
		 + W(7, -1092834676, 1048447149, -1110071086, 1019306140)
		 + W(8, 1032679083, -1117134944, 1030312114, 1045086676)
		 + W(9, -1115504874, -1103742512, 1018575153, 1023956348)
		 + W(10, -1124032472, -1142618034, 1033461689, -1107466492)
		 + W(11, 1040055828, -1111688997, 1025562022, 995416610);
	WS(1064673964, 1027541745);
	sum1 = W(0, 1040862122, -1105951646, -1159900529, 1047048323)
		 + W(1, -1123048515, -1115789415, 1032172675, 1028373376)
		 + W(2, 1042078126, -1104573695, -1104241265, -1111978190)
		 + W(3, -1096920009, 1032018046, 1022298419, -1099040790) + W(4, 1060076351, 1032906140, 1059885441, 1064315273)
		 + W(5, 1059865934, 1050382000, 1053685923, 1058530774)
		 + W(6, -1092017101, -1098380055, -1084208856, -1089015252)
		 + W(7, -1085419935, -1095947620, -1104053605, -1087017843)
		 + W(8, 1050924251, -1103234546, 1045405901, 1048739529) + W(9, 1043557114, 1032498465, 1042167691, 1037400788)
		 + W(10, -1113513485, -1122608113, -1114509959, -1097330869)
		 + W(11, -1130206982, 1009712656, 1011282770, -1099616447);
	sum2 =
		W(0, 1039738446, -1096514001, 1067583917, 1083413745) + W(1, 1067818743, -1089267428, 1050540062, -1102208699)
		+ W(2, -1137481092, 1050849818, 1017170018, 1041988969) + W(3, -1115429835, 1054896719, -1108022123, 1042362507)
		+ W(4, 1036746190, -1109747727, -1078331016, -1066189939)
		+ W(5, -1077977055, 1050059376, -1119460484, -1140654200)
		+ W(6, 998253152, -1102987618, 1044897487, -1088427847)
		+ W(7, -1125950758, -1108032139, 1038480975, -1098634922)
		+ W(8, 1035100433, -1144728624, -1108804343, 1030429056)
		+ W(9, -1124211336, 1045807183, -1164441214, -1138500556)
		+ W(10, 1029249908, -1103405950, -1113657787, 1049519441)
		+ W(11, -1105416150, -1104699523, 1036658641, -1135144148);
	WS(-1084384556, -1100810808);
	sum1 = W(0, 1032390692, 1033258828, 1036208454, -1153131217) + W(1, 1035878930, -1113170436, 1034716867, 1008810370)
		 + W(2, -1101205955, -1114756638, 1034225747, -1123281148)
		 + W(3, 1052764669, -1110681734, -1132636906, 1010363102)
		 + W(4, -1095424763, -1115332589, -1089988048, -1080799329)
		 + W(5, -1086451675, -1089641270, -1111992667, -1089944572)
		 + W(6, 1056723089, 1044941511, 1059213081, 1058219330) + W(7, 1065718984, 1051546784, 1048907447, 1051751177)
		 + W(8, -1103994552, -1103092466, 1016698694, -1102604175)
		 + W(9, 1010056863, -1105901266, -1104305197, 1025009925)
		 + W(10, -1113631133, 1038921097, 1041433148, 1029458059)
		 + W(11, 1046701849, -1114617106, 1022756491, 1042675492);
	sum2 =
		W(0, 1003892755, -1123544386, 1040199158, -1099919704) + W(1, 1046124074, -1114201767, -1137485313, 1018916205)
		+ W(2, -1106845972, 1040443741, 1041556166, -1098641213) + W(3, 1043027552, -1102894487, 1031291554, 1029095170)
		+ W(4, -1130802613, -1099129814, 1034864555, 1044973210) + W(5, 1046986152, 1040886200, -1097152858, 1035815457)
		+ W(6, 1042856976, 1046395618, 1049252005, 1051151809) + W(7, -1120255910, -1098031952, -1103612985, 1034278467)
		+ W(8, -1090921483, -1117156960, -1101642940, -1094482604)
		+ W(9, 1049495257, -1113386876, -1132183417, 1026205590)
		+ W(10, 1035865477, -1128022157, 1029291710, 1033022953)
		+ W(11, 1028643166, 1031856421, -1106468948, 1020718685);
	WS(-1097545175, -1081485407);
	sum1 =
		W(0, 1036015463, 1036906638, 1033438601, -1148467606) + W(1, -1116883369, 1043481795, -1107248831, 1035852867)
		+ W(2, 1034150438, -1107749409, 1025404544, -1130068931)
		+ W(3, -1110996648, -1129433572, -1112307200, -1133343797)
		+ W(4, 1057909318, 1041348600, 1058891216, 1062920275) + W(5, 1058446394, 1057530498, 1041812911, 1058924580)
		+ W(6, -1085934785, -1091465804, -1088212159, -1085185870)
		+ W(7, -1083820335, -1097522985, -1098817647, -1088845017)
		+ W(8, 1035924004, -1120240750, 1040930578, 1044931644) + W(9, -1110014855, 1046628778, -1112689630, 1031062731)
		+ W(10, 1033963168, -1115496908, 1023737332, 1034996968)
		+ W(11, -1109644005, 1044774695, -1109394217, 991839047);
	sum2 =
		W(0, -1085422352, -1073537081, -1090145600, -1103264022)
		+ W(1, -1098060014, 1039561049, -1111561066, -1097648243)
		+ W(2, -1096165509, -1097506962, 1035648589, 1037776879)
		+ W(3, -1106454260, -1132410675, -1095706003, -1093619532)
		+ W(4, 1057773529, 1050305732, 1070820271, 1064009122) + W(5, -1102687355, 1037201191, -1106323076, 1065891070)
		+ W(6, -1090487063, 1042351306, 1042246902, 1057815879) + W(7, 1056492080, -1132940238, 1047053654, -1104795343)
		+ W(8, 1044955346, -1096519547, 1012707558, 1035447241) + W(9, -1098251612, 1055262754, -1098685023, 1017091667)
		+ W(10, 1048850208, -1098077313, 1040847724, 1039355809)
		+ W(11, -1128314591, 1034334977, -1107078913, 1044351754);
	WS(-1079771574, 1075069839);
	sum1 = W(0, 1032166989, -1111167476, -1123178206, 1032734815)
		 + W(1, 1029165557, -1112820125, -1135576864, -1114861753)
		 + W(2, -1118529175, 1021133405, -1093562003, -1104246611)
		 + W(3, -1098100446, -1114628655, -1133453360, -1119446905)
		 + W(4, 1055702741, 1048648437, 1062276827, 1071187580) + W(5, 1061220800, 1049405702, 1042497282, 1051379002)
		 + W(6, -1092970539, -1092445782, -1088433116, -1118830448)
		 + W(7, -1097110780, -1093425874, -1109854691, -1094782027)
		 + W(8, -1117950828, 1033539229, -1104828877, -1114529494)
		 + W(9, -1112849365, 1023590922, 992807281, -1104282614)
		 + W(10, -1113551430, -1142239002, -1110397888, -1119974813)
		 + W(11, -1139975764, -1111568211, 974859957, -1107804608);
	sum2 =
		W(0, -1108373663, 1008476139, -1104454680, 1048684757) + W(1, -1093428939, 1053127551, -1096653504, 1052320010)
		+ W(2, 1058265898, -1092753943, 1052155727, -1094584251)
		+ W(3, 1044002260, 1027921055, -1109762731, -1093142139)
		+ W(4, -1105791278, -1098184263, -1106622092, 1051207789)
		+ W(5, 1040647411, -1092246791, 1028193495, -1102532444) + W(6, -1097633487, 1036219103, 1039768739, 1059813061)
		+ W(7, 1037804238, 1058749571, -1091622541, 1056925595) + W(8, 1040059628, -1096394805, 1043022076, -1089567461)
		+ W(9, 1053976656, -1109099791, -1128546349, -1105143398)
		+ W(10, 1041333883, -1106791026, 1034264586, 1043988712)
		+ W(11, -1094438691, 1046191998, -1105323978, 1027895571);
	WS(-1080085654, 1070612946);
	sum1 = W(0, 1024243697, -1118763904, -1129448298, -1125372076)
		 + W(1, -1130529432, -1113325424, 1028582463, -1115811081)
		 + W(2, -1111019203, 1017624971, 998267115, 1049904509) + W(3, 1044325341, 1036368923, 1022422215, 1029887376)
		 + W(4, -1099863023, -1093242824, -1096657110, -1083526619)
		 + W(5, -1084273056, -1089131829, -1100657096, -1095229037)
		 + W(6, 1051294614, 1049086721, 1054244159, 1063525996) + W(7, 1060516258, 1052725165, 1045179095, 1047234173)
		 + W(8, 1018553499, -1110032568, -1107816470, 1050014740)
		 + W(9, -1120428313, 1042939778, -1105723916, 1034815359)
		 + W(10, 1001929499, -1129474933, -1103030358, 1034265690)
		 + W(11, 1028809164, -1137068591, 995816851, 1023513072);
	sum2 =
		W(0, 1027629060, 1025235210, -1125103522, -1130467636) + W(1, 1000499297, 1020465580, -1138182160, 1014590712)
		+ W(2, -1114994936, 1042086314, -1109536432, 1043514454)
		+ W(3, -1116030212, 1034381305, -1133867384, 1032991925) + W(4, 1044032624, -1110089750, 1027377576, 1040857173)
		+ W(5, 1049094807, -1102199059, 1040209410, -1107097337) + W(6, -1120685804, 1041443307, 1041551160, 1078385077)
		+ W(7, 1071531230, -1097624207, 1042950964, -1110894461)
		+ W(8, 1028515824, -1109301707, 1038947979, -1069674168)
		+ W(9, -1072009528, 1042363648, -1100125727, 1020171064)
		+ W(10, -1128032940, 1028557604, -1095260923, 1041445431)
		+ W(11, 1044521776, -1111317304, 1026231984, -1115643044);
	WS(-1094677847, 1071331518);
	sum1 = W(0, -1108370254, 1027561514, -1098732332, -1118400576)
		 + W(1, -1098654343, 1020701942, -1114608461, -1102267173)
		 + W(2, 1050522446, -1102155388, 1051883284, 1052444946) + W(3, 1048632224, 1036179296, 1043748547, 1046936641)
		 + W(4, -1090412394, -1096900614, -1088235704, -1081990504)
		 + W(5, -1083209683, -1095695623, -1096819473, -1088405429)
		 + W(6, 1059909490, 1033926552, 1060113893, 1065971548) + W(7, 1057796766, 1055081266, 1048355474, 1057781222)
		 + W(8, -1131659964, -1108396174, -1104366446, 1016076284)
		 + W(9, -1094058291, 1044926426, -1102235562, -1122894705)
		 + W(10, 1045668787, -1099365497, 1036562753, 1045429432)
		 + W(11, 1027649399, -1115499084, 1020598162, 1041162909);
	sum2 =
		W(0, -1102306900, 1039340517, 1036459319, 1032447827) + W(1, -1099327251, 1052797014, -1122082449, -1098452307)
		+ W(2, 1042298222, 1011988276, -1104503945, -1099734245) + W(3, 1032726509, 1032685073, 1045894449, 1031495568)
		+ W(4, 1021581591, -1091773202, -1086047943, -1071833762)
		+ W(5, -1087097517, -1094401898, -1089730964, -1094627244)
		+ W(6, -1097774924, -1083547573, -1076320925, -1070847208)
		+ W(7, -1079468544, -1084551630, -1096261152, -1097740674)
		+ W(8, 1051289508, 1050176620, 1066124397, 1069182349) + W(9, 1058492703, 1061745990, 1029975482, 1062784611)
		+ W(10, 1044651623, 1060043835, 1072230275, 1080482397) + W(11, 1067612874, 1060905071, 1035766217, 1036170953);
	WS(-1075403638, -1098484659);
	sum1 =
		W(0, 1008218969, 1031048294, -1123131291, 1045188911) + W(1, -1123984690, 1016373997, 1038284987, 993498863)
		+ W(2, -1141902179, 1016567255, -1102849342, 1018204181)
		+ W(3, -1097928441, -1102752375, -1119205801, -1111653947)
		+ W(4, 1045612697, 1051272109, 1045999461, 1067242878) + W(5, 1057827361, 1039307800, 1052680217, 1048974634)
		+ W(6, -1098198307, -1097302541, -1089514713, -1083074125)
		+ W(7, -1090995143, -1089521325, -1111274305, -1089001074)
		+ W(8, -1115216112, 1045061466, -1110301017, 1055219615) + W(9, 1042127630, 1018247819, 1043301703, -1112012330)
		+ W(10, 1014117412, 1032424528, -1117285565, 1039741805) + W(11, -1138318152, 990571063, 1035406958, 991913685);
	sum2 = W(0, 1032878555, -1123900432, 1029453781, -1120535472)
		 + W(1, 1040510410, -1109544472, 1036988619, -1113659102) + W(2, -1136655860, 1023477569, 993352402, 1007422372)
		 + W(3, -1110556919, -1138628828, -1137184004, 1035524869)
		 + W(4, 1031615749, 1032172309, -1101515073, 1063516373)
		 + W(5, -1114866186, -1101753271, 1046060209, -1110546008)
		 + W(6, -1113247036, 1040892014, -1093800370, 1059067488)
		 + W(7, 1049733424, -1112478460, -1128679382, -1106958218)
		 + W(8, -1102324444, 1041677780, -1099560811, -1101931537)
		 + W(9, -1091691569, -1137342172, -1112686045, 999359657)
		 + W(10, 1033821831, -1122117887, -1111754290, -1118366060)
		 + W(11, -1131546954, 1043560141, -1110783375, 1026284797);
	WS(1018938736, 1060529869);
	sum1 =
		W(0, -1114076530, 1008598737, 1029696041, -1118730378) + W(1, 1036159584, 1012443924, 1034257674, -1133449206)
		+ W(2, 1037607357, -1120766810, -1113865353, 1019917938)
		+ W(3, 1041300082, -1119787914, -1102751430, 1018668169) + W(4, 1045714156, 1044442542, 1057228923, 1049628033)
		+ W(5, -1081803320, 1042784239, 1016494120, 1031639516) + W(6, -1166977277, 1024586298, -1084710912, 1048848151)
		+ W(7, 1052825757, -1110703311, -1108049641, -1111061268)
		+ W(8, -1102825464, 985048227, 1048654858, -1109196652) + W(9, -1101625253, 1021290536, 1039349129, 1018121541)
		+ W(10, 1003359422, 1019680094, -1122235660, 1032134772)
		+ W(11, 1023446241, 1025035938, -1122160707, 1028394476);
	sum2 = W(0, -1146778654, 1009999826, 1042445717, 1027431889)
		 + W(1, -1118789096, 1034933139, -1102516465, 1039233552)
		 + W(2, 1033337426, -1117028555, -1092512747, -1100415596)
		 + W(3, -1100913756, 1031653672, 1049736808, -1123203031)
		 + W(4, -1101837401, -1107426057, -1106280442, 1063146362)
		 + W(5, -1086144449, -1121957589, -1104136456, -1123128270)
		 + W(6, 1023259685, -1113617305, 1063964069, 1058459732)
		 + W(7, -1101061454, -1139753565, 1034026738, -1143324392)
		 + W(8, -1165315756, 1042598704, -1101414619, -1136881638)
		 + W(9, -1099212326, 1035181957, 1031514566, -1103321885)
		 + W(10, 1017616818, -1119841713, 1033400884, -1110929163)
		 + W(11, 1043348599, -1110261015, -1119239229, 1032933914);
	WS(1057790316, -1113005641);
	sum1 = W(0, -1123468520, 1016842734, 1017823704, 1031334797) + W(1, 1029517379, 1032276500, 1024531558, 1032934320)
		 + W(2, 1034968039, -1180462681, -1141354132, -1111663246)
		 + W(3, -1096962432, -1102337515, -1112383277, -1115337892)
		 + W(4, -1107161453, -1109372445, -1097660717, 1060769665)
		 + W(5, 1062816796, 1057344992, 1050585827, 1048852876) + W(6, 1035442035, -1126387193, 1045333479, -1097006056)
		 + W(7, -1085875335, -1087615930, -1099229077, -1104188731)
		 + W(8, -1107573447, -1110219956, -1111689634, 1016331253)
		 + W(9, 1042106418, 1042154624, 1021430571, 1007994773) + W(10, 1040623159, 1001956750, 1034883047, -1121213099)
		 + W(11, 999707420, -1110655190, 1027213229, -1125102461);
	sum2 =
		W(0, 1027505374, -1119743709, 1022357321, -1129702556) + W(1, 1025908250, -1116658238, 1007287620, -1132286080)
		+ W(2, 1006384241, 1032385395, -1110226975, 1009992786) + W(3, -1117540770, 1015280579, 1013929491, -1123806249)
		+ W(4, 1038217397, -1124784904, 1036163691, 1038388564) + W(5, -1107551412, 1043662427, -1110875284, 1032548500)
		+ W(6, -1102596332, 1055108824, -1095998103, -1096068823)
		+ W(7, 1027585837, 1052401764, -1112465838, 1049275421)
		+ W(8, -1088198084, -1101781911, -1077861124, -1082211809)
		+ W(9, 1067639721, 1063419774, 1041946916, 1054953848) + W(10, 1054112069, -1110486748, 1063443275, 1060625206)
		+ W(11, -1095993202, -1084462256, 1040943353, -1088060635);
	WS(1057314092, 1031126097);
	sum1 = W(0, -1113264897, 1042921300, -1118216326, 1036778483)
		 + W(1, 1035020911, -1108928881, 1036290288, 1012907241) + W(2, 1047286031, 1038748523, 1040626286, 1048990343)
		 + W(3, 1036098930, 1042428894, 1016422504, 1041504752) + W(4, 1051515170, 1044373061, 1057172805, -1111196723)
		 + W(5, 1053560288, 1053915059, 1044112316, 1048512334)
		 + W(6, -1091122512, -1119263830, -1081529962, -1076778621)
		 + W(7, -1085296972, -1112351005, -1100809115, -1107245185)
		 + W(8, 1035529026, 1016709539, 1043973191, 1049229393) + W(9, 1046938632, -1123285785, 1035877806, -1123727583)
		 + W(10, -1125355113, 1029610636, 1029771624, -1112976162)
		 + W(11, 1041831703, -1103970660, 1044125996, -1123672296);
	sum2 = W(0, -1110279027, 1044898087, -1096945908, 1039092196)
		 + W(1, -1113241071, -1099008684, 1044106833, -1103116396)
		 + W(2, -1116888772, -1115916604, -1107202311, 1045884385)
		 + W(3, -1103988696, 1049112986, -1123386226, -1134049769)
		 + W(4, 1033554595, -1111117443, 1035778723, -1113256321)
		 + W(5, -1115920774, -1139004677, -1112080343, -1114347803)
		 + W(6, -1108669327, 1045218355, -1103416606, 1065794034)
		 + W(7, -1090569433, 1055599565, -1099737884, 1044073709)
		 + W(8, 1015808739, -1106102431, 1041666953, -1107247823)
		 + W(9, 1049716916, -1106016659, 1031391070, -1108799013)
		 + W(10, 1027314221, -1116221606, 1024714919, -1098987808)
		 + W(11, 1049758114, -1091770239, 1053158291, -1105054228);
	WS(-1078536214, 1004530797);
	sum1 =
		W(0, 1027375859, 1017444741, -1120029560, 1000019140) + W(1, -1114543207, 1013557197, -1122136338, -1148145247)
		+ W(2, -1101920227, 1031432968, -1106564803, 1048371434) + W(3, -1118108517, 1042631950, 1018155212, 1016114854)
		+ W(4, 1025777344, -1103056081, -1107107772, -1082038651)
		+ W(5, -1087843395, -1090887738, -1103973545, -1102912795)
		+ W(6, 1044389645, 1048716617, 1051154454, 1066595410) + W(7, 1055824714, 1054676989, 1041035048, 1016296812)
		+ W(8, -1110651587, -1137653198, -1107166356, -1130046381)
		+ W(9, -1105265945, 1030116559, 1023828021, 1040191506)
		+ W(10, 1018050380, -1125959547, 1019570356, -1125449965)
		+ W(11, 1033235496, -1126792065, -1122035417, -1142050258);
	sum2 =
		W(0, 1027035378, -1132701065, -1114259972, 1024730711) + W(1, 986229224, 1013886009, -1129435432, -1141056234)
		+ W(2, 1026113022, 1034348094, 1019537869, -1139897757)
		+ W(3, -1140805741, -1118691470, 1009541569, -1129312440)
		+ W(4, -1111907604, 1044772326, -1115459713, -1083470341) + W(5, 1024256637, 1050967575, 1013091981, 1028089297)
		+ W(6, -1117578886, 987582920, -1091701771, -1064559027) + W(7, 1083026821, 1062853848, -1097816209, 1036032976)
		+ W(8, -1140538653, -1136739637, -1106970806, 1035917626)
		+ W(9, 1051507274, 1035548789, 1030786995, -1102804079) + W(10, 1018825264, 1015195718, 1029368182, -1129456736)
		+ W(11, 1025912688, -1107265712, 1031335734, -1115863996);
	WS(1053759831, 1032374114);
	sum1 = W(0, 972229904, -1109228149, 1034978575, 1041049216) + W(1, -1120680758, 1029299866, -1104501302, 1034604409)
		 + W(2, -1121671930, -1112583528, 1034149296, 1029443406)
		 + W(3, 1029497788, -1098177536, -1147362406, -1129221556)
		 + W(4, 1054724605, -1112974870, 1061211455, 1048871720) + W(5, 1059772533, 1052523382, -1143596105, 1050895314)
		 + W(6, -1092393035, -1101934908, -1092299422, -1093922438)
		 + W(7, -1094240300, -1091878482, -1112394307, -1097371836)
		 + W(8, 1018308729, 1027590122, 1034030567, -1111847647)
		 + W(9, 1041914031, -1113968603, 1028043992, -1126204095)
		 + W(10, -1129466650, 1029939172, -1113423424, 1038901743)
		 + W(11, -1106909549, 1040006220, -1140269215, 998375305);
	sum2 =
		W(0, -1150066816, -1122485893, -1114773240, 1024800634) + W(1, 996682648, -1123997738, 1019128023, -1127165963)
		+ W(2, -1150466984, 1032358015, 1050624105, 1086980496) + W(3, 1049846439, -1116390866, 1016213345, -1127449775)
		+ W(4, 1023864952, -1120268940, -1092046440, -1062089081)
		+ W(5, -1092228228, 1022750294, 1015347232, 1000268865) + W(6, -1110066210, 1042589181, 1028033997, -1086968029)
		+ W(7, 1024724796, 1041929871, -1114433107, -1139900476) + W(8, 1023825317, 1027888694, -1151325172, 1038366470)
		+ W(9, -1121152696, -1118357792, 1031614438, -1136800730)
		+ W(10, -1124858867, -1130877326, -1135440218, -1140173368)
		+ W(11, 1022098295, 1017805328, -1119866592, 1025894920);
	WS(1063005484, 1009613411);
	sum1 = W(0, 1023879031, -1116658758, 1016433014, 1020845368)
		 + W(1, 1014732617, -1133265115, -1123204757, 1010953149)
		 + W(2, -1099686359, -1121736524, -1101192360, -1114633573)
		 + W(3, -1095872969, -1106126199, -1114430117, -1135381594)
		 + W(4, 1052137768, 1047373394, 1060630207, 1066103327) + W(5, 1062822060, 1059882369, 1050777829, 1058652475)
		 + W(6, 1046007565, -1096622041, -1088767007, -1084203279)
		 + W(7, -1090088910, -1090037515, -1103091289, -1092699671)
		 + W(8, -1104853008, 1032552475, -1107092245, 1041296218)
		 + W(9, 1027255591, -1131360500, -1122457924, -1108476770)
		 + W(10, 1005501772, -1119708225, -1118541917, -1116191290)
		 + W(11, 1022596005, -1115075910, 1022253604, -1114779071);
	sum2 =
		W(0, 1018912922, -1115513506, 1035927400, -1104590179) + W(1, 1040736265, -1107721632, 1025188211, -1112944230)
		+ W(2, 1027578843, -1122957333, 1036987406, -1100032664)
		+ W(3, -1110179624, -1125426330, -1103038285, 1043904940)
		+ W(4, 1033809184, -1107632498, -1102289594, 1055409420)
		+ W(5, 1055289786, -1112721987, 1036015348, -1110109848) + W(6, -1094114890, 1001948858, 1056054406, 1048553428)
		+ W(7, 1051787669, -1094744691, 1032878358, -1118996080)
		+ W(8, -1100264522, 1024979575, -1110397259, -1121465059)
		+ W(9, -1147035242, 1045301422, -1131004626, -1124556646)
		+ W(10, -1107937173, 996744179, -1110541201, -1114033403)
		+ W(11, 1041331760, -1113161109, -1108457170, 1028913131);
	WS(-1088267692, 1058858468);
	sum1 = W(0, -1112379634, 1029162995, -1140270752, -1141342278)
		 + W(1, -1155361775, -1113272402, -1140210569, 1015213304)
		 + W(2, 1030761249, 1004146884, -1122297718, 1040340278) + W(3, 1036240851, -1129581456, 1042224566, 994119730)
		 + W(4, 1050799110, 1045209037, 1060358148, 1057423488) + W(5, 1058630580, 1044230767, -1104611845, -1109863885)
		 + W(6, -1099191401, -1095201623, -1091143388, -1083233902)
		 + W(7, -1098879351, -1096101987, -1122560784, -1109785875)
		 + W(8, 1033839199, 981108966, 1043211072, 1032118859) + W(9, 1032700466, 1030417559, -1140846885, 1009738084)
		 + W(10, -1111715307, 1002675052, -1120236170, -1118812007)
		 + W(11, 1017441470, -1148456452, -1124250818, -1131671893);
	sum2 = W(0, -1113443438, 1023812788, -1131593767, -1112801638)
		 + W(1, -1105757720, -1107427633, -1107137147, 1049954034)
		 + W(2, 1021821461, 1044300514, -1104994806, 1060658961)
		 + W(3, 1044687616, -1087213560, -1093064102, -1093773442)
		 + W(4, -1122246023, -1104002403, 1038382254, -1099826888)
		 + W(5, 1066144433, 1057721748, -1097329958, 1039897892)
		 + W(6, -1146734500, 1024116650, 1049088332, -1089766136)
		 + W(7, 1042354562, -1129092349, 1044181933, -1105235988)
		 + W(8, -1128559783, -1115812447, -1105739887, 1025686404)
		 + W(9, -1117250635, 1035306954, -1106719387, 1040800736)
		 + W(10, -1125128801, -1134793082, -1131329759, 1034755166)
		 + W(11, -1114066084, 1031417186, -1117543346, -1128306605);
	WS(1042978478, 1051058289);
	sum1 = W(0, -1105382966, 1035278676, -1102112151, -1102711504)
		 + W(1, -1113404858, -1111458068, 1038103836, -1101215220)
		 + W(2, 1032357083, 1023966158, -1113794846, 1052488610) + W(3, 1046698475, 1025992701, 1042579843, 1026938905)
		 + W(4, -1099095273, -1110890773, -1087097191, -1081382120)
		 + W(5, -1086454106, -1097860134, -1105233954, -1091436978)
		 + W(6, 1056839899, 1050844654, 1060126757, 1063120271) + W(7, 1060142827, 1054395618, 1048420817, 1056719627)
		 + W(8, -1122236410, 1019140850, -1107056589, -1150461374)
		 + W(9, -1103751812, -1120625160, 1025690583, -1112415123)
		 + W(10, 1024938700, -1122653091, -1122892351, -1119829084)
		 + W(11, 1007453138, -1106500335, 1032216339, 1010325087);
	sum2 = W(0, 986675002, -1112567440, 1033516168, -1097585273) + W(1, 1031672616, 1029453516, -1106591291, 981423732)
		 + W(2, -1098687074, 1041166801, -1099338776, 1019263552)
		 + W(3, -1108963639, -1104454378, -1109440188, 1024870634)
		 + W(4, 995475005, -1097111455, 1062728692, 1066654492) + W(5, 1034345380, -1124466258, -1092068145, 1048117247)
		 + W(6, -1115454695, -1132868679, -1120015952, 1054175336)
		 + W(7, 1038275134, -1096244103, 1039104546, -1119846616)
		 + W(8, -1110655697, -1114152579, 1023628514, -1097107880)
		 + W(9, -1118909665, 1049130538, -1093717692, 1042494451)
		 + W(10, 1018060844, -1101427932, 1045275251, -1098419362)
		 + W(11, 1049612882, -1100742770, 1000911598, -1140045927);
	WS(-1097071959, 1072623846);
	sum1 = W(0, 1026094363, -1114366565, 1026372640, -1127140609)
		 + W(1, 1020533357, -1164090721, -1143600974, 993477434) + W(2, 1010541764, 1023927408, 1034504814, 1038480008)
		 + W(3, 1046400295, 1040252248, 1040642843, 1032065949)
		 + W(4, -1087379998, -1100421531, -1091057687, -1086095524)
		 + W(5, -1083615449, -1089701071, -1093225865, -1090227881)
		 + W(6, 1028105114, 1051865478, 1057630379, 1064048287) + W(7, 1061319210, 1056141130, 1049626241, 1047950199)
		 + W(8, 1046169702, -1105971271, 1041980470, -1104375598)
		 + W(9, -1113258549, -1149976804, -1120849689, 1048635489)
		 + W(10, -1135291959, -1125008010, 1012391943, 1011497593)
		 + W(11, -1126436590, 1008261592, -1126913777, 1026040178);
	sum2 =
		W(0, 1012042818, 1021360395, -1107209227, 1027378250) + W(1, -1105921842, 1041772128, -1127367716, -1127019644)
		+ W(2, 1045767812, -1098807230, 1044720012, 1042281858) + W(3, 1016599978, -1127223374, -1115783877, 1027816090)
		+ W(4, -1063490706, -1081789373, 1074390906, 1079115935)
		+ W(5, 1058048856, -1108782236, -1128008216, 1032186898)
		+ W(6, -1101778611, -1114664520, 1049922132, -1094869567)
		+ W(7, -1118592797, -1121088549, -1137516645, -1111496361)
		+ W(8, -1112785819, 1033999610, -1110057121, 1045861970)
		+ W(9, 1034050759, -1129798306, 1033434514, -1136389257)
		+ W(10, 1012780879, 1021391529, -1130294258, 1031106226)
		+ W(11, -1122317121, 1025125464, -1149825053, 1031888403);
	WS(-1103312814, -1092017335);
	sum1 =
		W(0, -1127703091, 1018146514, -1121799134, 1017072510) + W(1, -1131539818, -1112727125, 1017229265, -1109754009)
		+ W(2, -1101144796, -1115460311, -1106383343, -1133230391)
		+ W(3, 1034901054, 1027622014, 1018005017, 1034197373) + W(4, 1054306333, 1039997174, 1024945271, -1088288960)
		+ W(5, -1088630417, -1096972398, -1101045202, -1098488314)
		+ W(6, -1126801713, 1026063214, -1131110905, 1059941407) + W(7, 1061737047, 1057455253, 1048616129, 1051714580)
		+ W(8, 1023075088, 1027296474, -1132250026, -1113425894)
		+ W(9, -1097522374, -1097018828, -1112216732, -1142469689)
		+ W(10, 989243788, -1122138660, 1032388672, 982272924) + W(11, 1021266411, -1135487483, -1117699788, 995701513);
	sum2 = W(0, 1015133861, 1037113072, -1114822552, 1028491873)
		 + W(1, -1105557810, 1038591890, -1105949948, 1032708826)
		 + W(2, -1105189044, -1115931822, -1098364789, -1113527921)
		 + W(3, 1024139573, -1112247318, 1007564387, -1120342494)
		 + W(4, -1093732269, -1102686481, 1041653115, 1065997875)
		 + W(5, -1130473293, -1098512761, -1125828389, -1125733097)
		 + W(6, -1094162786, -1113599737, 1041635421, 1064813540)
		 + W(7, 1037786550, 1036196676, -1114108758, -1132225813)
		 + W(8, -1109540616, 1040400825, -1118060506, -1123044799)
		 + W(9, -1105450383, -1106060901, -1118151575, 1010062515)
		 + W(10, 1030009493, -1114813207, 1027616765, -1116517245)
		 + W(11, 1021543889, 1005718790, -1122858549, 1029912177);
	WS(1054094679, 1053313313);
	sum1 = W(0, -1133457438, -1120986711, 1034987238, 1028444909)
		 + W(1, 1035642130, 1018062863, 1034710931, -1149170946)
		 + W(2, -1123263126, -1130558777, -1097984725, -1096198619)
		 + W(3, 1007426149, 1002886242, -1123562906, 1018181775) + W(4, 1046955525, 1034791245, 1059693200, 1056744813)
		 + W(5, -1111414009, 1030506913, -1113706235, 1033357311)
		 + W(6, -1124016519, 1044418743, -1102062065, -1098120268)
		 + W(7, -1111514230, -1104691680, 1011520719, -1107703301)
		 + W(8, 1039131745, -1102726978, -1136653836, -1097784815)
		 + W(9, -1121981368, 1038384226, -1114621003, 1012043028)
		 + W(10, -1120644986, 1007447622, -1119688622, -1150742701)
		 + W(11, 1028941155, -1124505481, 1028268649, 1016894461);
	sum2 =
		W(0, 988916677, -1137939637, -1123566910, 1028209713) + W(1, -1123858844, 1036944358, -1119538750, -1142606817)
		+ W(2, 1035831303, -1140903881, -1103092742, -1131746560)
		+ W(3, -1101579019, 1038814302, -1130948272, 1038676356)
		+ W(4, -1110571087, 1038296707, -1107155945, -1117714466)
		+ W(5, 1038803820, -1103151768, 1032643961, -1111989951) + W(6, 1034464782, -1090860425, 1056968489, 1064742714)
		+ W(7, 1040557782, -1120375726, -1111036663, -1122089622)
		+ W(8, -1106828560, 1044389789, -1079651989, 1050942503) + W(9, 1043224862, -1130430804, 1041889175, 1014857001)
		+ W(10, -1178538002, 1041756630, 1029915845, -1106236653)
		+ W(11, -1110415601, 1019097405, -1132733633, -1140337549);
	WS(1060301740, -1107262085);
	sum1 = W(0, 980901136, 1027361860, -1140723427, 1026764890) + W(1, 1040866884, 1025665684, 1033047081, -1120424813)
		 + W(2, 1034782831, 1047173818, 1039236098, -1167399456)
		 + W(3, -1096504911, -1107799148, -1104388354, 1042507977)
		 + W(4, -1105836176, -1090641081, -1089836727, 1057068694)
		 + W(5, 1061579759, 1058017849, 1050545524, 1043225643) + W(6, 1036556474, 1050207945, 1053103024, 1041462691)
		 + W(7, -1084387656, -1086651203, -1099258584, -1106352190)
		 + W(8, -1123655719, -1104237805, -1097134658, -1168491986)
		 + W(9, 1041789973, 1041962562, 1042093191, -1107448273)
		 + W(10, -1123449511, 1032390687, 1023266998, -1128069487)
		 + W(11, -1111341496, -1121577073, -1128080260, -1118302731);
	sum2 = W(0, -1120672932, 1020434122, 1029602171, 986372169) + W(1, 1039121856, -1113202257, -1139183469, 1010867474)
		 + W(2, 1046006360, -1097339905, -1114812458, -1107596062)
		 + W(3, 1036462865, 1042494496, -1097212089, -1111658779)
		 + W(4, -1112452525, 1059308780, 1040180724, -1073685765)
		 + W(5, 1068230783, 1060720662, -1116372590, -1096232759)
		 + W(6, -1103760793, 1054394959, 1058139034, -1075031098)
		 + W(7, 1055263295, 1065727212, -1106882983, -1102585430)
		 + W(8, -1135937657, 1038148088, -1103543044, -1098429000)
		 + W(9, 1051067274, -1106499347, -1127997619, 998537328)
		 + W(10, 1037670355, -1114765629, -1120562291, -1131755817)
		 + W(11, 1034635900, 1010504894, -1127537321, -1141626877);
	WS(-1096709719, -1109932402);
	sum1 =
		W(0, 1015250582, -1109965037, 1037158888, -1115453048) + W(1, 1032345875, -1113173429, 1033146133, -1109546082)
		+ W(2, -1143431239, 1015070528, -1094706154, 1051852512)
		+ W(3, -1107272167, 1039101648, -1112986991, 1034073405) + W(4, 1041217222, 1044707911, 1032459556, -1103734188)
		+ W(5, -1116721265, -1100636937, 980311674, 1017051268) + W(6, 1009444904, -1099789672, 1049449359, -1091866852)
		+ W(7, 1042112892, 1051337808, 1011811037, 1035868647) + W(8, -1127867147, 1028928427, 1015515213, 1049692098)
		+ W(9, -1094357813, 1036490203, -1118660177, 1019523665)
		+ W(10, -1115442975, 1033219242, -1119289842, -1140261177)
		+ W(11, 1041543818, -1107580668, 1027230184, -1121586498);
	sum2 =
		W(0, -1129366500, 1029756683, -1113040482, 1041050942) + W(1, 1019865458, -1130192114, 1021094310, 1011878989)
		+ W(2, -1111869912, 1029022998, 1046043365, 1028636589)
		+ W(3, -1100561355, -1118786886, -1136660469, -1113939693)
		+ W(4, -1114572049, 1041454921, 1063827282, -1088878874)
		+ W(5, -1120053198, 1037601458, -1121128994, 1024511741) + W(6, 1047691494, 1051011830, -1075590857, 1052419847)
		+ W(7, 1053136256, -1142379802, -1115896886, 1033422229)
		+ W(8, 1024096486, -1094989992, -1094007689, 1049374228) + W(9, 1051405216, -1105102628, 1030093181, 1038213156)
		+ W(10, -1112777200, 1033382685, 1046068934, 1022134325)
		+ W(11, -1104418826, 1039472389, -1173694926, -1122209396);
	WS(1065853238, 1014077745);
	sum1 = W(0, -1141216588, 1026623353, -1128763228, 1020370461)
		 + W(1, 1026101893, -1118113002, 1032019108, -1113706417)
		 + W(2, -1117433015, -1129058045, 1039902504, 1043759351) + W(3, 1050608829, 1042454284, 1027449020, 965645460)
		 + W(4, -1094201799, -1096460535, -1083943142, -1077503527)
		 + W(5, -1089716396, -1098731144, -1095714819, -1094767340)
		 + W(6, 1050233869, 1049952264, 1051933059, 1055071872) + W(7, 1055823041, 1057515106, 1050055875, 1054942629)
		 + W(8, 1044254087, 1008011942, 1048823509, 1025148605) + W(9, 1040921250, -1120507502, -1149099066, 1040832262)
		 + W(10, -1138617969, 1022594791, -1141149825, 1032777398)
		 + W(11, -1117303781, 1030831063, -1131034510, 1023411184);
	sum2 = W(0, 1024492456, -1126703609, 1029353704, 1036516578)
		 + W(1, 1032071462, -1107363712, 1044306067, -1105180142)
		 + W(2, -1107369605, 1040389587, -1109233879, -1095300447)
		 + W(3, -1104963978, -1106122650, -1143085570, 1043865859)
		 + W(4, -1114418679, 1038677226, 1043636997, 1063429366)
		 + W(5, -1101740776, -1097459892, 1035238854, -1116890590)
		 + W(6, -1102696165, -1115181151, -1104069114, 1063594124)
		 + W(7, -1098164193, 1040620147, -1106357294, -1127904241)
		 + W(8, -1133142225, -1114014523, -1122395696, -1091978649)
		 + W(9, 1053626887, -1097146692, 1040976159, -1120794976)
		 + W(10, -1122518916, 1026327736, 1035228514, 1023044321)
		 + W(11, -1116601496, -1130578705, 1026795860, -1127926993);
	WS(-1088917996, 1063906509);
	sum1 = W(0, -1110920777, 1042151912, -1101936374, 1005195703)
		 + W(1, 1032265367, -1103459368, 1041691572, -1129700693)
		 + W(2, 1044506738, -1103723194, 1033303784, 1049511025)
		 + W(3, -1113286290, 1043019742, -1128222025, -1114181825)
		 + W(4, 1047786311, 1032125650, 1061302810, 1034065915) + W(5, 1048810800, 1054491533, -1112859072, 1049358361)
		 + W(6, -1095080042, -1113114611, -1088574755, -1080208865)
		 + W(7, 1049193686, -1121283466, 1024774526, -1147499681)
		 + W(8, -1134941681, 1025189266, -1115794445, 1048946939)
		 + W(9, -1126346531, -1103486336, 1015955599, -1097425800)
		 + W(10, 1033765698, -1104090263, 1041151454, -1113407178)
		 + W(11, -1109067703, 1044875416, -1121559327, 1029016425);
	sum2 = W(0, -1103461552, 1050674327, -1104590141, 1015549042)
		 + W(1, 1036919049, -1098769683, 1046313441, -1112862464)
		 + W(2, -1127991186, -1116051994, -1131508502, 1050173609)
		 + W(3, -1105608002, 1039941075, -1101603735, 1031505597)
		 + W(4, -1120190757, -1113530372, 1055990720, 1072931527)
		 + W(5, -1095048932, -1078020039, -1101033642, 1010804308)
		 + W(6, -1108916090, -1124692174, -1121470095, 1046026095)
		 + W(7, 1050729023, -1084802111, 1047911325, 1034713295) + W(8, 1012492564, 1042343963, 1032226081, 1048814953)
		 + W(9, -1098673970, -1101605152, -1113534935, 1017021378)
		 + W(10, 1029245469, -1115385529, 1026603353, 1024686773)
		 + W(11, -1108452621, 1046452703, -1112756717, -1119772659);
	WS(-1128039792, 1065254279);
	sum1 = W(0, 949814928, 1027171091, -1129242384, 1031101353)
		 + W(1, -1120975327, 1003634843, -1144006416, -1123053628)
		 + W(2, -1114341117, 1031806764, 1033646238, 1018879791) + W(3, 1042055949, 1033681236, 1023909046, 1027677731)
		 + W(4, -1094482850, -1095186291, -1085842430, -1092086861)
		 + W(5, -1084252337, -1089087466, -1099056317, -1095496311)
		 + W(6, 1052398616, 1051880795, 1058904806, 1068407459) + W(7, 1055432619, 1036562814, 1039311896, 1050962337)
		 + W(8, 1027872723, -1139824782, 1010706555, -1098849364)
		 + W(9, -1121195299, 1023772639, -1126801378, 1038931216)
		 + W(10, -1155305313, 1022544667, -1121892394, 1040052675)
		 + W(11, -1127339326, 993927654, -1123991661, 1005742098);
	sum2 =
		W(0, -1120833032, 1034915193, -1115307960, 967112657) + W(1, 1023925021, -1107476032, 1033449936, -1132191993)
		+ W(2, -1124763415, -1113475142, 1025322201, 1059271888)
		+ W(3, -1102912552, -1118552210, -1103660545, 1033898849)
		+ W(4, -1118777010, 1010824003, 1064953874, 1082807588)
		+ W(5, -1080316189, -1064631277, -1110193476, 1039205719)
		+ W(6, 1030229073, -1105412742, 1042572184, -1098383492)
		+ W(7, 1054443836, -1098098835, -1121091158, 1028111985) + W(8, 1028911958, -1133618203, 1022077590, 1048790378)
		+ W(9, -1103923621, 1029953956, -1106218101, 1036034024)
		+ W(10, -1123843510, 1030755234, -1135426163, -1113939962)
		+ W(11, 1038571089, -1109596012, 1035405992, -1126376787);
	WS(-1100484014, -1082813103);
	sum1 = W(0, -1123138350, -1124738939, 991988525, -1115403050)
		 + W(1, 1032429349, -1113715255, 1024280877, 1024090791) + W(2, 1037916588, -1123209507, 1049386547, 1038702225)
		 + W(3, 1052139678, -1114440425, 1033284897, -1105213156)
		 + W(4, -1092840871, -1095165544, -1086369653, -1082690349)
		 + W(5, -1080932794, -1104541586, -1091044852, -1098590565)
		 + W(6, 1048819422, 1053647432, 1054472273, 1063735148) + W(7, 1057734851, 1057909982, 1048946363, 1057027323)
		 + W(8, 1042234192, -1117914254, 1039202605, -1121098737)
		 + W(9, -1124146173, -1120991811, -1116174764, -1140316975)
		 + W(10, -1212876940, 1018206961, -1120915541, 1024686130)
		 + W(11, 1015928020, -1138122766, 1018911880, 1023234987);
	sum2 =
		W(0, 1017320792, -1115193567, 1033153774, -1109723345) + W(1, 1038092476, -1111785287, -1119671739, -1109901657)
		+ W(2, -1151813795, -1117132961, 1023133248, -1096979800)
		+ W(3, 1051436512, -1136600857, 1043953938, 1038440342)
		+ W(4, -1114719136, -1104426322, -1094043595, -1067432541)
		+ W(5, -1094705611, 1084038773, 1051561136, -1097692319)
		+ W(6, -1127138406, 1035777956, 1044557822, -1081748159) + W(7, -1094662263, 1059186895, 1023890070, 1021470996)
		+ W(8, 1024237362, -1122656452, 1043828952, -1105451925)
		+ W(9, -1118217110, -1118750811, 1026839182, -1114305884)
		+ W(10, 1038691322, -1114810881, -1134215421, 1025666138)
		+ W(11, 1023161212, -1141123106, 1009024009, -1122422926);
	WS(-1090600151, 1059961608);
	sum1 = W(0, 1026132748, -1119499740, 1009974340, -1113885561)
		 + W(1, 1031101992, -1111559238, 1038517558, -1109274083) + W(2, 1003856660, 1023957057, 1043713207, 977342510)
		 + W(3, 1051525550, 1025363409, 1031878320, -1114083846)
		 + W(4, -1086859502, -1105095800, -1089372619, -1080432315)
		 + W(5, -1084623068, -1086083942, -1090836983, -1097114792)
		 + W(6, 1051724689, 1035359281, 1059175635, 1059908410) + W(7, 1060487798, 1059822844, 1051599439, 1057278953)
		 + W(8, 1051693682, 1030063117, 1040699442, -1106762114)
		 + W(9, -1114853678, -1116041416, -1130086580, 1040974422)
		 + W(10, 1032934656, -1123043606, 1034542394, 1018557983)
		 + W(11, 1019132432, 1031213982, -1150140386, -1138998830);
	sum2 = W(0, 992923986, -1162949315, 1026898877, -1114052913)
		 + W(1, -1129262506, 1033577774, -1129225578, 1036380420)
		 + W(2, -1099561897, -1123994385, -1116860796, 1033030662)
		 + W(3, 1024241717, 1027801571, 1041458479, 1050404867) + W(4, -1105536701, -1114799541, 1049791100, 1035377948)
		 + W(5, -1088177074, 1049717575, 1043978030, -1091169113) + W(6, 1079165891, 1071631223, 1068780303, 1075632919)
		 + W(7, -1093777203, -1083766160, 1029517847, -1083354335)
		 + W(8, -1067147152, -1073660425, -1081838471, -1083671230)
		 + W(9, 1057542893, 1057183721, -1103299573, 1061807320)
		 + W(10, -1122782084, -1122543983, -1095462698, -1097530520)
		 + W(11, -1107750254, 1032284006, 1025982179, 1016984746);
	WS(-1077101366, 1062204989);
	sum1 = W(0, 1030791972, 1033145401, 1041963978, 974201395) + W(1, -1122207423, 987140211, 1038549201, -1110991006)
		 + W(2, 1034919675, -1109323772, -1109601924, -1098302775)
		 + W(3, 1049858413, -1163737350, -1104961646, 1022472166)
		 + W(4, -1119759728, 1033209467, 1053457281, 1054965265)
		 + W(5, -1085314770, -1111164798, -1103072597, -1115893275)
		 + W(6, -1099266697, 1032826652, -1084468746, -1116769210)
		 + W(7, 1055247733, 1051122507, 1043488164, 1036206931) + W(8, 1044609922, -1108657922, 1049423472, 1034832195)
		 + W(9, -1104833109, -1113738245, -1121147841, -1131086146)
		 + W(10, -1131275309, -1142019948, 1005679697, -1125973710)
		 + W(11, 1038354000, 1030630601, -1132893044, 1033991117);
	sum2 =
		W(0, -1128313262, -1111995834, -1111474816, -1108547758)
		+ W(1, -1123519406, -1107039325, -1122872424, 1034342977) + W(2, 1013333880, 1035550861, 1047569009, 1036006103)
		+ W(3, -1104835579, -1119199538, -1113807123, -1111926114)
		+ W(4, 1041733323, 1024909109, 1049082846, -1093864056) + W(5, 1049905793, 1005924363, -1107099901, -1117079308)
		+ W(6, 1023499747, -1107108555, 1042800306, -1137016284) + W(7, 1032249988, -1146750815, 1024429363, 1029021112)
		+ W(8, -1111312052, 1015145454, 1017141780, 1013541080) + W(9, 1034012446, -1119513572, 1036805530, 1021769214)
		+ W(10, 1026149469, -1188980193, -1123639612, -1132476264)
		+ W(11, 987971164, -1118671040, -1119021692, 1010774610);
	WS(1062330988, -1108933484);
	sum1 = W(0, -1130422235, 1014897395, 1027643186, -1143835797)
		 + W(1, 1008148004, -1128962907, 1015454424, -1140840472)
		 + W(2, -1127744279, 1022571909, -1103670303, -1110385841)
		 + W(3, 1042533684, -1104774725, -1116892960, -1113171223)
		 + W(4, -1103583502, -1095189640, -1097916197, -1083565633)
		 + W(5, -1085814590, -1117452294, -1099231943, -1103031657)
		 + W(6, -1112967222, 1057599524, 1050533350, 1066390108) + W(7, 1059916677, 1050496965, 1049304867, 1049771574)
		 + W(8, 1030687296, 1033146447, 1045948242, -1104991248)
		 + W(9, -1098839314, -1114792086, -1127702342, 1032045679)
		 + W(10, 1027221408, -1115561596, 1024802772, 1027456689)
		 + W(11, -1125614226, 1027191883, -1115468561, 1026854932);
	sum2 =
		W(0, 1032895988, -1117467777, 1028545567, -1111764526) + W(1, 1041090350, -1115412116, -1125773241, 1023304410)
		+ W(2, 1032830726, -1111744013, 1005059811, 984631841) + W(3, 1049595248, -1107906030, -1128022386, 1041765137)
		+ W(4, -1115406541, 1060942494, 1047355779, -1080183554) + W(5, -1134532596, 1035977506, 1020817981, 998580490)
		+ W(6, -1088204952, 1054289941, 1071613570, -1077634808) + W(7, -1093147012, 1042083474, 1037668146, 1032116542)
		+ W(8, -1092446016, -1123665301, 1060958044, 1046926373)
		+ W(9, -1113920155, -1097187857, -1142970826, -1125184917)
		+ W(10, 1031989945, -1104702594, 1046230999, -1100189171)
		+ W(11, 1034621337, -1132922134, -1117116166, 1022449461);
	WS(-1109331804, 1042368707);
	sum1 =
		W(0, -1127022377, 1024616740, -1123466393, -1123208698) + W(1, -1123129456, 1019270569, 981412042, -1140654132)
		+ W(2, 1017844485, -1131144083, -1107976561, -1113085828)
		+ W(3, -1114039899, -1111910285, -1118232839, 1022571624) + W(4, 1059385318, 1050963589, 1060165431, 1059271336)
		+ W(5, 1060839292, 1056907678, 1049849056, 1053487153)
		+ W(6, -1100795701, -1097056965, -1085607547, -1083778221)
		+ W(7, -1087428756, -1094957746, -1097540376, -1103251894)
		+ W(8, -1111987554, 1029893237, 1029216560, 1039937652) + W(9, 1032072458, -1114977786, 1024925794, -1099334072)
		+ W(10, 1016900750, 1023074109, -1112887422, 998408382)
		+ W(11, -1132276000, 1030127674, 1027413302, 1016237783);
	sum2 = W(0, 1032849952, -1124884727, -1113876395, -1129227720)
		 + W(1, -1120368220, 1017198470, -1139825528, -1146042855)
		 + W(2, 1026055449, -1115329827, 1027815845, 1037903820) + W(3, 1033732250, -1135699996, 999495607, -1129930944)
		 + W(4, -1062565523, -1069645041, 1071954840, 1082661778) + W(5, 1074466947, 1029601901, 1010255452, 1032971494)
		 + W(6, -1095655110, 1045607629, 1038549538, -1099195860)
		 + W(7, 1038448988, -1098438651, -1108984513, 1036170224)
		 + W(8, -1117249787, -1117682124, 1041120073, 1049745271)
		 + W(9, -1117133911, 1028175479, 1021673198, -1119888169)
		 + W(10, 1033345650, -1126204236, -1111681252, 1027383795)
		 + W(11, 1003632367, -1122462785, 1028818665, 1008778484);
	WS(-1115348316, 1054745777);
	sum1 = W(0, -1137232980, 1010567825, 1027515738, -1129778165)
		 + W(1, 1031078129, -1163675813, 1021335208, 1015357019)
		 + W(2, 1036166838, 1015838740, -1156212270, -1111605669)
		 + W(3, -1105267814, -1129353779, -1109102196, 1044530957)
		 + W(4, 1049991788, 1049110157, 1058008076, 1064241460) + W(5, 1060214194, 1054590870, 1041116785, 1051902330)
		 + W(6, -1091675395, -1096298109, -1087264777, -1084812083)
		 + W(7, -1090012802, -1089909917, -1099321920, -1087098097)
		 + W(8, 1017816583, 1034100235, 1034455816, 1015442096) + W(9, 1038960299, 1024747424, -1128935590, 1001621141)
		 + W(10, 1029575560, 1027659359, 1022248439, 1022178737)
		 + W(11, 1027280241, 1032358751, -1140454872, 1023518060);
	sum2 =
		W(0, -1165172934, 1024206556, -1116697030, 1027518769) + W(1, -1114129087, 1038375004, -1112102389, 1033334280)
		+ W(2, 1029679520, 1020162972, 1034059275, 1040171419) + W(3, 1027996817, -1110434123, 1034335827, -1129105068)
		+ W(4, -1126280148, -1122180110, 997668227, -1097026624)
		+ W(5, 1034726751, 1040744343, -1102815825, -1107441727) + W(6, -1133513625, 1032751166, 1058808820, 1078058683)
		+ W(7, 1074823993, -1082346775, -1066028315, -1081349721)
		+ W(8, 1007295249, -1123729058, -1106696521, 1051253388)
		+ W(9, -1129919188, -1130957332, -1106067749, 1046963831)
		+ W(10, -1112190701, 1031911051, -1130859572, -1110596693)
		+ W(11, 1030310076, 1020514684, -1120038362, -1140190249);
	WS(-1106429870, -1094013011);
	sum1 = W(0, -1180060253, 1010730896, 1021824818, -1126648308)
		 + W(1, -1129917792, -1130361130, -1120274467, -1140710069)
		 + W(2, 1032914805, -1122572746, 1007289698, 1032028260) + W(3, 1028442598, 1044381070, 997655159, 1048974915)
		 + W(4, 1051659804, 1041447962, 1049003466, 1055000463)
		 + W(5, 1028832887, -1108621431, -1127588999, -1092428073)
		 + W(6, -1083977393, -1096070845, -1090427610, -1110426966)
		 + W(7, -1154202266, 1047276227, -1106909952, 1037115308) + W(8, 1044666432, 1042077981, 1040702780, 1039434940)
		 + W(9, -1143541158, -1126798128, 1034262401, -1116914978)
		 + W(10, -1143253052, -1112889935, 1019043703, -1121648024)
		 + W(11, -1121855216, 1025638626, -1112957869, 1027653084);
	sum2 = W(0, -1113021585, 1027309129, 1040557912, -1105312463)
		 + W(1, 1045635393, -1102513438, 1027399099, -1114789238)
		 + W(2, 1044056205, 1042644451, -1130917417, -1097839840)
		 + W(3, -1093830389, -1101732547, -1116545436, 1035602021)
		 + W(4, -1096040530, -1098848264, -1086782093, 1066533545)
		 + W(5, 1047866369, 1049511378, 1054444603, 1045074348) + W(6, -1099894114, -1100852865, 1055980834, 1060955207)
		 + W(7, 1049480207, -1136131482, -1099150452, -1089010378)
		 + W(8, -1101136816, 1051352325, -1094431966, -1105883820)
		 + W(9, -1100511063, -1095199310, 1057783348, -1105061215)
		 + W(10, -1129192316, -1127314210, 1001033976, 1028457481)
		 + W(11, -1109915970, 1041484506, -1111537389, 1038428609);
	WS(1043891118, 1068855714);
	sum1 = W(0, 1034864935, -1115119790, 1021640868, -1116826163)
		 + W(1, -1131811026, 1023733166, -1143217636, -1132040205)
		 + W(2, -1116934668, -1132968331, 1038582262, 1007221512)
		 + W(3, 1042862352, 1036137865, -1140157826, -1132089051)
		 + W(4, -1092449819, -1094480060, -1087769325, -1085866861)
		 + W(5, -1087019235, -1090795981, -1096174840, -1088777568)
		 + W(6, 1054927906, 1036212657, 1059302628, 1065404307) + W(7, 1060871017, 1058788692, 1054585007, 1058320673)
		 + W(8, 1034556804, -1105343195, 1039390277, -1118670257)
		 + W(9, -1097654326, -1110180471, -1103987387, 1039274926)
		 + W(10, -1137767170, -1110944332, 1007166673, 1000130184)
		 + W(11, -1149095244, 1038210141, -1123846591, 1033742658);
	sum2 = W(0, -1109312558, 1016877071, -1119267190, 1012463989)
		 + W(1, -1126846961, -1130793473, 1028514185, 987754923) + W(2, 1043524956, 1022447527, 1041115214, -1113751024)
		 + W(3, 1044302697, 1017381631, -1118188819, 1030898373)
		 + W(4, -1128190925, -1112207078, -1098728904, -1096567460)
		 + W(5, -1103900959, 1042180588, -1098746809, 1045698067)
		 + W(6, -1098627702, -1106898612, -1125515089, 1069702771)
		 + W(7, 1067943590, 1068665203, 1066385707, 1053793920) + W(8, 1046310591, 1038513036, 1034661588, -1085518745)
		 + W(9, -1080776989, -1076263106, -1082060374, -1093259035)
		 + W(10, -1109532722, 1007593597, -1120394532, -1104054586)
		 + W(11, -1120974914, 1042247803, 1009589981, -1114854661);
	WS(-1087649964, 1019782291);
	sum1 =
		W(0, -1120416323, -1143853715, 997344379, -1117444008) + W(1, 1021907901, -1121005123, 1024251314, -1131127160)
		+ W(2, 1030168161, -1112895868, 1041161399, -1109107148) + W(3, 1047711365, -1121138472, 1000308143, 1016698342)
		+ W(4, 1040415828, 1040272853, -1108639376, 1066099001) + W(5, 1016783474, 1034911086, 1025062450, 1039033917)
		+ W(6, -1105270513, 1031966316, -1088122706, -1107599501)
		+ W(7, -1089416651, -1111272734, -1107120316, -1102333873)
		+ W(8, 1024428446, -1115504066, 1050439898, -1101667648) + W(9, 1046888529, 1033038819, -1142414472, 1024070769)
		+ W(10, -1138699736, -1138905653, 986611002, -1107645603)
		+ W(11, 998160367, -1138080961, 1016114481, -1128756052);
	sum2 =
		W(0, -1107127477, 1033768126, 1023416069, -1125558334) + W(1, 1043030557, -1118774605, -1151915405, 1000627574)
		+ W(2, 1040784536, -1100939724, -1105075327, 1031863699)
		+ W(3, -1103416126, -1104742149, 1042707477, -1121719211)
		+ W(4, -1117663793, 1017594321, -1107862291, -1098589794)
		+ W(5, 1051532765, 1047503953, -1106456825, 1014542959) + W(6, -1112675945, 1057262150, -1072566694, 1078638992)
		+ W(7, -1086195181, -1109470897, 1041105499, -1106760943)
		+ W(8, 1039537683, -1092150404, 1066290117, -1077578123) + W(9, 1053259006, 1050584179, -1103867215, 1033290657)
		+ W(10, 1025325994, 1019337948, -1099590626, 1051733383)
		+ W(11, -1119314417, -1100419866, 1038050610, 1002291590);
	WS(1061891500, 1029739432);
	sum1 = W(0, -1120639769, -1135804195, -1111424495, 1029738303)
		 + W(1, -1117498485, -1118615961, -1125527056, -1118385394)
		 + W(2, -1106216192, 1006283635, -1105829118, -1090566706)
		 + W(3, -1116262763, 1034396863, 1019261400, -1120846617)
		 + W(4, -1113834067, -1103570763, -1096510251, 1051808376)
		 + W(5, -1092264601, -1100309453, -1103214946, -1103884676)
		 + W(6, 1044238166, 991333090, 1059958553, 1070740438) + W(7, 1055146526, 1034609097, 1035571491, 1043753671)
		 + W(8, -1114217922, -1139025510, -1105864021, -1094764771)
		 + W(9, -1102695282, -1115698885, -1137185181, -1118241703)
		 + W(10, -1131739160, -1118882723, -1144807936, 1034612526)
		 + W(11, -1134494805, 1017541191, -1114134173, 1003240643);
	sum2 =
		W(0, -1121600381, 1006302792, -1119262688, 1002488024) + W(1, 1029037035, 1026568605, -1136033516, 1023468893)
		+ W(2, 1026550907, -1138054916, 1026195583, -1109251816) + W(3, 989985520, -1119850715, 1023268674, -1113487368)
		+ W(4, 1038640235, -1115693397, 1049140618, -1070322023) + W(5, 1050244555, -1111337441, 1034795019, 1032357843)
		+ W(6, -1118247849, 1032667651, -1131891756, 1075955836)
		+ W(7, -1093462820, 1039467523, -1123631905, -1111383976)
		+ W(8, -1129506938, -1150824496, 1032667233, 1037796079)
		+ W(9, 1041966968, -1119306593, 1011205316, -1140765060)
		+ W(10, -1121040584, 1022873234, -1116879102, -1123674716)
		+ W(11, 1023067742, -1115823182, 1030765775, -1117038411);
	WS(-1084563692, -1094583093);
	sum1 = W(0, 1022703229, -1162852794, -1132568844, 1021772616) + W(1, 1024085850, 996545514, 1026223997, -1146052282)
		 + W(2, 1012279186, -1124105959, 1040618577, -1104495965)
		 + W(3, -1108936808, -1134036365, -1117471057, -1121618798)
		 + W(4, 1016172182, 1043937588, -1096721723, 975997096) + W(5, -1105257082, -1119752408, 1035927703, 1030206390)
		 + W(6, -1118740542, 1029178707, 1047241030, 1058138797)
		 + W(7, -1098942649, 1033384955, -1119041259, -1135741956)
		 + W(8, 1030161881, -1113029519, -1110742685, -1095587800)
		 + W(9, 1044167852, 1030217107, 1033396614, -1114495566)
		 + W(10, -1118949361, 1029291849, 1002005802, 1026228226)
		 + W(11, -1121437018, -1128298663, -1127843472, 1024441958);
	sum2 =
		W(0, 1025430445, 1022296570, 1036981025, -1113204042) + W(1, 1015494893, -1113488118, -1127432409, -1122316989)
		+ W(2, -1154040649, 1041313314, -1095051054, 1045521896) + W(3, -1140159290, 1036274902, 1033705522, 1014652738)
		+ W(4, -1116838887, -1089338077, -1080092115, 1068042633)
		+ W(5, -1123762249, 1036460009, -1115504399, 1034428960)
		+ W(6, 1050769250, -1110563158, 1047738904, -1105725339)
		+ W(7, 1046459196, -1099991734, 1035671600, -1109634740)
		+ W(8, -1101164186, 1049390351, -1105225557, 1058198082)
		+ W(9, -1097909404, 1042800199, -1112380024, 1019626217)
		+ W(10, 1025324860, -1110459458, -1123670947, -1102419914)
		+ W(11, 1036400862, -1121611661, 1029427990, -1122111247);
	WS(1070570422, -1118483066);
	sum1 =
		W(0, 1018165832, -1132852684, -1139725729, -1109730565) + W(1, 1028156415, -1118139972, 1024357779, -1122455036)
		+ W(2, -1110069429, 1031499417, 1040072889, 1042906054) + W(3, 1042919301, -1168228894, 1039947243, -1103975241)
		+ W(4, -1099959964, -1099020957, -1084885570, -1081528768)
		+ W(5, -1083523477, -1091258848, -1095225642, -1094692227)
		+ W(6, 1060331110, 1050128623, 1059366093, 1062372980) + W(7, 1058454089, 1058887102, 1048717802, 1057283318)
		+ W(8, -1162935118, 1032275410, 1019497086, 996066926) + W(9, -1118811556, -1112630512, -1117991970, 998336395)
		+ W(10, -1139421786, 1009522871, -1140197674, -1117746023)
		+ W(11, -1128372287, 1014662756, -1119179525, 1028666043);
	sum2 =
		W(0, 1041833519, -1108615966, -1125372171, -1161988394) + W(1, -1113215633, 1034531971, -1118383435, 1028261725)
		+ W(2, -1105638218, 1028972955, 1029956673, 1048735800) + W(3, 1034458457, 1025753183, 1036634769, 1000882603)
		+ W(4, -1090712556, 1051586707, 1040982790, -1113315600)
		+ W(5, 1025381303, -1116357686, -1096961046, 1047278155)
		+ W(6, -1068172350, -1062545743, 1058445980, 1081890452) + W(7, 1078990875, 1057946443, -1129266047, 1020805991)
		+ W(8, 1053466473, -1089644697, 1044082250, 1021891615) + W(9, 1047100697, -1138523317, -1118643722, 1003167691)
		+ W(10, 1031038629, -1109024185, -1115541422, -1110157560)
		+ W(11, 1034093689, -1121128958, -1164400298, 1023430939);
	WS(-1086946092, 1067745931);
	sum1 = W(0, -1129718754, 1029399808, 1034551451, 1031195606) + W(1, 1040134022, 1033121193, 1023151712, 1042343314)
		 + W(2, 1043160110, -1107060738, 1035261538, -1095383669)
		 + W(3, -1133919947, -1122710934, -1107305618, 1042006276)
		 + W(4, 1057051220, 1052187432, 1056679450, 1065908691) + W(5, 1053194351, 1055695833, 1050664148, 1051480109)
		 + W(6, -1086793423, -1093519641, -1086890615, -1082115172)
		 + W(7, -1091092163, -1087806651, -1106762967, -1086763775)
		 + W(8, 1029510552, 1041235060, 1027399596, 1028581668) + W(9, 1039541441, 1022886169, 1035840335, -1123269599)
		 + W(10, 1019782728, 1028876859, -1121687640, -1151056709)
		 + W(11, 985161115, 1032179179, -1137650955, 1023858088);
	sum2 = W(0, -1092038506, -1100127293, -1076970891, -1074419095)
		 + W(1, -1072137471, -1071882845, -1075499422, -1077760287)
		 + W(2, 1049598436, 1048639033, 1064718435, 1072396257) + W(3, 1071503744, 1074270589, 1071966648, 1067893220)
		 + W(4, 1043882093, 1037661877, 1059313512, 1057486689) + W(5, 1051417643, 1058040444, 1034550731, -1109701446)
		 + W(6, 1042320103, -1103044471, 1034035103, -1104719409)
		 + W(7, -1111075093, 1044428409, -1105998171, 1040427981)
		 + W(8, -1131832297, 1002123811, -1103733932, 1041582287)
		 + W(9, -1115120295, -1139439905, 1008560441, -1112073274)
		 + W(10, -1121740952, 1029198842, -1115216799, 1010136401)
		 + W(11, -1128000009, 1024386386, -1120184167, 1030441594);
	WS(-1081254198, -1103496580);
	sum1 = W(0, -1115414444, 1041339642, -1098407452, -1130637434)
		 + W(1, 1020760807, -1101995566, 1047565230, -1100079212)
		 + W(2, -1146587219, -1098606506, 1050459360, 1042214179)
		 + W(3, -1117423418, 1034598934, -1122745995, 1024450296)
		 + W(4, -1093427101, -1097683981, -1091994231, -1078168847)
		 + W(5, -1095228700, -1092752622, -1097351785, -1094816186)
		 + W(6, 1048836291, 1057498447, 1058816906, 1061921355) + W(7, 1063391143, 1049596874, 1055225025, 1057483350)
		 + W(8, 1038644661, -1144521152, -1117884339, 1040740783)
		 + W(9, -1099277734, -1125383814, -1125503451, -1112883619)
		 + W(10, 1040942563, -1102869832, 1036627839, -1165859686)
		 + W(11, -1107645994, 1047950513, -1104517417, 1038686359);
	sum2 = W(0, -1101463653, 1049429767, -1128244554, -1113723320)
		 + W(1, -1100253783, -1100739127, 1041910404, -1105778187)
		 + W(2, 1057761413, 1067192921, 1075421514, 1075836777)
		 + W(3, -1088665878, 1016894214, -1116933337, -1111337535)
		 + W(4, -1092703936, -1078098525, -1071536845, -1077415283)
		 + W(5, 1059548308, 1051692516, -1101242161, 1048285068)
		 + W(6, -1109493923, -1139460835, 1039603395, -1087182285)
		 + W(7, 1034610843, -1117875445, 1013931579, 1038460759) + W(8, 1041760680, 1028945771, -1114414573, 1045554670)
		 + W(9, -1106673179, 1032645955, -1122014712, -1113595007)
		 + W(10, 1014720459, -1117756514, 1016362862, -1118637934)
		 + W(11, -1125369728, 1027339291, 1013909643, -1124961818);
	WS(-1089093868, 1047195432);
	sum1 = W(0, -1139038025, -1146634508, -1107247574, -1111039036)
		 + W(1, -1111569431, -1131070116, -1123633457, -1125658710)
		 + W(2, -1108646892, -1102493258, -1102675263, 1027299238)
		 + W(3, 1043334313, 1035038251, -1130835530, 1006218639) + W(4, 1042227448, 1050027260, 1055627170, -1094097439)
		 + W(5, -1086063146, -1091453053, -1104540112, -1100496626)
		 + W(6, -1116853265, -1113152371, -1102292967, 1059178599)
		 + W(7, 1064850945, 1055758905, 1047069456, 1028822677) + W(8, 1032512066, 1037772585, 1040310103, -1120135685)
		 + W(9, -1097054397, -1107670363, -1109953256, 1033685440)
		 + W(10, 1015754506, -1111624526, -1122052409, -1123630421)
		 + W(11, 1035574535, -1126001639, 1015067608, 906381938);
	sum2 = W(0, -1103632983, 1043805370, -1100282419, 1043204826)
		 + W(1, -1107284068, 1032596944, -1115324019, 1038389706)
		 + W(2, 1051248459, -1102825598, -1110573499, 1027245233)
		 + W(3, -1115422824, -1088944566, -1119815045, -1103855212)
		 + W(4, 1050224986, -1106748849, -1142028319, 1068200484)
		 + W(5, -1110893073, -1082511144, -1101546175, -1099926119)
		 + W(6, -1112111441, -1107415409, 1047715488, 1064575785)
		 + W(7, -1116519441, -1166081973, 1033478296, -1112155627)
		 + W(8, -1114055425, -1113209339, -1106125891, 1034756297)
		 + W(9, -1121811913, 1036646608, -1139772871, 1042197713)
		 + W(10, -1111599379, 1037386114, -1107474855, 1042201726)
		 + W(11, -1115818225, 1036836551, -1107371535, 1026011708);
	WS(-1121781432, -1075996235);
	sum1 = W(0, -1139185884, 1017932812, 1031934942, 986151814) + W(1, -1164665422, 1000199096, 1007298263, -1140438078)
		 + W(2, -1104344139, -1106763371, -1097501556, -1122902443)
		 + W(3, -1153685131, -1127990679, 1001735501, -1113474827)
		 + W(4, 1055178280, 1050633065, 1061458986, 1056941803) + W(5, 1057254916, 1045616484, 1030315686, 1046908556)
		 + W(6, 1023675446, -1102467779, -1098857564, -1087567683)
		 + W(7, -1091469811, -1104204108, -1129857478, -1103515070)
		 + W(8, -1115352921, -1113788396, 987917899, 1038547421)
		 + W(9, -1108760371, 1011665321, -1121847517, -1118109260)
		 + W(10, -1116105386, -1134059780, -1113912527, -1136836585)
		 + W(11, 1007170123, -1128021832, -1154396360, -1121041198);
	sum2 = W(0, -1168649543, -1129109975, 1016893178, -1132018102)
		 + W(1, -1117453381, 1023462612, -1106957470, -1115823387)
		 + W(2, -1097479461, -1104465921, -1103938775, -1118749694)
		 + W(3, -1115486085, 976518647, 1025546665, 1034975399) + W(4, 1049098480, 1049155382, 1057022497, -1098731951)
		 + W(5, -1119719509, -1106384437, -1098317799, -1105263623)
		 + W(6, 1042706476, -1102354715, 1043506300, -1097087336) + W(7, 1057524747, 1036026738, 1045328977, 1035074429)
		 + W(8, 1041988609, -1112820525, 1047765539, 1046909100)
		 + W(9, -1100642605, -1121071990, -1106523641, 1003192501)
		 + W(10, -1106980555, -1122042062, -1105649317, 1031531696)
		 + W(11, -1114531186, 1040948740, -1113359258, 1033488186);
	WS(1058868844, 1053114578);
	sum1 = W(0, 1019520880, -1122446279, 1037061470, 1025396381) + W(1, 1029402067, 1031841884, -1120186199, 1033549944)
		 + W(2, 1047026923, -1120049453, 994701546, -1104790763)
		 + W(3, -1104820950, 1021084025, -1105237507, 1009185118) + W(4, 1040716289, 1048040834, 1059285152, 1063349990)
		 + W(5, 1062179110, 1056787146, 1046529242, 1057448647)
		 + W(6, -1095841007, -1093651986, -1089525095, -1081113852)
		 + W(7, -1086213616, -1087503095, -1091401861, -1088312360)
		 + W(8, 1020793813, 1039005404, 1046415125, 1040363303) + W(9, 1045703966, 1041196477, 999605293, 1036113571)
		 + W(10, 1026453035, -1117418946, 1019785277, -1114838686)
		 + W(11, 1030676884, 1024749253, 1004229292, 1022861598);
	sum2 =
		W(0, 1050427341, -1106859908, 1035861035, -1112488680) + W(1, 1032409135, -1122621450, -1104767713, 1046587865)
		+ W(2, -1089070569, -1111523090, 1043538575, -1097196972)
		+ W(3, 1036654054, -1133854060, -1130574088, -1093068011)
		+ W(4, 1053219089, 1052246278, 1059060280, -1088179143) + W(5, 1017346040, 1043005089, -1092034159, 1052143300)
		+ W(6, 1067490860, -1093125710, -1078649576, -1087268097)
		+ W(7, 1059384755, 1062938540, -1093321870, 1059539225)
		+ W(8, -1080930470, -1078811541, -1074777053, -1075643449)
		+ W(9, -1124572738, 1049929252, -1112625720, 1059287102) + W(10, 1058659628, 1066232343, 1073277874, 1065823003)
		+ W(11, 1062269032, 1043425453, -1092663388, -1098215774);
	WS(-1074642550, 1059001037);
	sum1 =
		W(0, 1033877849, -1114814273, 1017602926, -1122785432) + W(1, -1119942606, -1121541554, 1004629641, -1103073299)
		+ W(2, -1105864948, -1133959838, -1106724665, 1042832010) + W(3, 1046400581, 1036804396, 1032924291, 1039804561)
		+ W(4, 1040506928, -1108476642, -1098100854, -1084427489)
		+ W(5, -1083890617, -1088670813, -1090515058, -1095458045)
		+ W(6, -1096349630, 1023714759, 1055335876, 1065396984) + W(7, 1062559324, 1061684023, 1051195620, 1054342111)
		+ W(8, 1046552293, -1108357401, 1032280783, -1132282059)
		+ W(9, -1113686945, -1104721044, -1110306392, 1031943308)
		+ W(10, -1110243859, -1127057913, -1147216585, 1033899323)
		+ W(11, 1032718711, 1025273824, -1122497752, -1121848889);
	sum2 =
		W(0, 1024273115, -1131612410, -1107407950, 1041256788) + W(1, -1117121277, 1031505312, -1110072407, 1016793154)
		+ W(2, 1021686194, 1025348247, -1105777061, 1042238427)
		+ W(3, -1126779625, -1118046720, -1118330488, 1027338756)
		+ W(4, 1043888107, -1101286924, 1048538591, -1090332406)
		+ W(5, 1053208564, 1043322093, -1135252559, -1116082242)
		+ W(6, -1108335658, -1122239076, 1046097166, 1036931728) + W(7, 1040874893, 1040745205, 1050743072, -1096125238)
		+ W(8, -1077891718, -1091711743, -1097181377, 1065426853)
		+ W(9, 1063431633, 1040529954, -1097546746, 1050690616)
		+ W(10, -1110849641, -1111108183, 1033944270, -1111979954)
		+ W(11, 1039617071, -1105370761, -1122096807, -1122718137);
	WS(-1088674604, -1128666815);
	sum1 = W(0, -1123914807, 1016031116, 1014718188, 1024027612)
		 + W(1, -1145356432, 1024193015, -1124389866, 1032770888)
		 + W(2, -1112902532, -1154837176, -1114821559, -1098901213)
		 + W(3, -1103324234, -1099251759, -1119376425, -1101826270)
		 + W(4, 1031043843, 1033184452, 1015481863, 1054517603) + W(5, 1051928805, 1059978813, 1047372601, 1062901239)
		 + W(6, 1051063687, -1131397783, 1027540319, -1102428675)
		 + W(7, -1094753613, -1100081596, -1110958225, -1101878062)
		 + W(8, -1094561666, 1025159063, -1102063788, -1104802482)
		 + W(9, 1021380397, -1111732847, -1154253637, -1113334654)
		 + W(10, 1018478931, -1134237698, 1024172061, -1126359028)
		 + W(11, -1133861065, -1114031158, 1028470484, -1114369951);
	sum2 =
		W(0, -1125911137, 1012595671, 999266341, 1044288444) + W(1, -1101165077, 1041147790, -1113177198, 1025832748)
		+ W(2, -1108931889, -1114639139, 1007405169, -1110292957) + W(3, 1050109344, 1041510968, 1029583838, 1046353900)
		+ W(4, 1017628143, 1032292317, -1114156858, -1067836662) + W(5, -1072172899, 1037860217, 1074693740, 1081403750)
		+ W(6, 1050970701, -1128469007, -1110785518, -1074929312)
		+ W(7, -1105301985, 1044362436, 1048694785, 1057358913) + W(8, 1035307535, -1112594616, 1028698628, -1112320536)
		+ W(9, 1032862316, -1133865234, -1121233078, 1015908463)
		+ W(10, -1132880011, 1026392505, -1126668834, 1035975658)
		+ W(11, -1115294669, -1122721591, 1027549527, -1114367420);
	WS(-1092184279, -1114774309);
	sum1 = W(0, -1112548452, -1120800919, -1114639366, 1008341430)
		 + W(1, 1009522319, -1120506536, 1034801619, 1022706306) + W(2, 1035183681, 1038305887, 1043708422, 1037535198)
		 + W(3, -1098020135, 1029108045, -1128765878, -1106461058)
		 + W(4, -1114927434, -1101125062, -1087724142, -1103312811)
		 + W(5, 1062809460, -1118967585, 1002077113, 1043448960) + W(6, 1044352162, 1039166894, 1063427286, 1034792975)
		 + W(7, -1088121787, -1115071968, -1114196826, -1129024277)
		 + W(8, 979364527, -1131609361, -1093459700, 1048665209) + W(9, 1043037714, 1023205859, 1033949151, -1126884683)
		 + W(10, -1115173597, -1182492945, 1021495134, -1113251558)
		 + W(11, -1113757330, -1113409875, -1123554950, -1115469664);
	sum2 = W(0, -1130731300, -1146462793, -1114036842, 1017173194)
		 + W(1, 1027612469, -1121343755, 1027895615, -1154268081)
		 + W(2, -1113218164, 1028824397, 1013989596, 1034818358)
		 + W(3, -1104368005, 1040334859, -1123082454, -1123775916)
		 + W(4, 1024876637, -1129593633, 1044891209, -1101530532)
		 + W(5, 1049606516, -1097048862, 1042764886, -1113704648)
		 + W(6, -1112264614, -1113338336, 1058622224, -1105838439)
		 + W(7, 1050794194, -1102338893, 1040822444, -1122592353)
		 + W(8, -1099018413, -1111675537, -1088855347, 1059579881)
		 + W(9, 1042736448, 1043492825, -1121501222, 1034905054)
		 + W(10, 1026854381, -1102804304, -1102462733, -1108694945)
		 + W(11, -1114432119, 1019755962, -1122392540, -1119817837);
	WS(1061153836, -1122742154);
	sum1 = W(0, 1027853554, -1115291137, -1171221910, -1112977164)
		 + W(1, -1121554637, 1022714404, -1157881362, -1123187178)
		 + W(2, -1109089440, 1043116226, -1138258466, 1050791197)
		 + W(3, 1034471002, 1041098678, -1134239506, 1034237593)
		 + W(4, -1102650256, -1115210274, -1112757431, -1077890273)
		 + W(5, -1082648980, -1093251577, -1097764996, -1092621429)
		 + W(6, 1051082942, 1047414994, 1055597733, 1055540065) + W(7, 1061271560, 1053866013, 1044732088, 1032996986)
		 + W(8, 1027843188, -1112215273, 1034632359, 1042514461) + W(9, -1131618020, 1046515591, 1036747322, 1043087924)
		 + W(10, -1131011401, -1119605372, -1126942769, -1126698730)
		 + W(11, 998349933, 1025132479, -1120958927, 984532249);
	sum2 =
		W(0, 1031101174, -1132731961, 1022986308, 1017601076) + W(1, -1126674740, 1022398052, 1013813081, 1010235161)
		+ W(2, -1102026314, 1038074007, -1092900468, 1030590838)
		+ W(3, 1001758673, 1001713969, -1140283033, -1138091097) + W(4, 1042272104, -1090146581, 1028046198, 1054179894)
		+ W(5, -1096188072, 1035923987, -1106500726, 1036670019) + W(6, -1126868316, 1042331882, 1039425711, 1068886648)
		+ W(7, 1049555295, -1096410864, 1036573795, -1105222854) + W(8, 1028240358, 1036936531, -1122656394, 1039233571)
		+ W(9, -1086618714, -1090080092, -1110072380, -1134061337)
		+ W(10, 1023923290, -1128194324, -1114483483, -1108833787)
		+ W(11, 1026905222, 1029729918, 1035325123, 1035525391);
	WS(-1098883799, 1037141561);
	sum1 = W(0, -1114839991, 1029657918, -1116594483, 1034543274)
		 + W(1, 1026816074, -1140770618, 1035386535, 1007197468) + W(2, 1039141586, 1034970850, 1048999812, 1026227619)
		 + W(3, -1103366664, -1115755155, -1109617409, -1117505278)
		 + W(4, -1110021469, -1090767256, -1089859629, 1007604554)
		 + W(5, 1063309440, 1050338841, 1049028980, 1050252341) + W(6, 1020247259, 1029681923, 1058872566, -1100094273)
		 + W(7, -1090400131, -1090199858, -1104209655, -1101914812)
		 + W(8, 1030453625, -1119339247, -1104869706, -1106749124)
		 + W(9, 1040832320, 1023759014, 1040157646, 1034144506)
		 + W(10, 1040211480, -1126798193, 1041448405, -1123771570)
		 + W(11, 1006844457, -1131945671, -1115455274, -1106217213);
	sum2 = W(0, 1003211606, -1137674963, -1151639180, -1126381316)
		 + W(1, -1125497686, -1120928387, 1024650751, -1121709003)
		 + W(2, -1120528483, -1120827669, -1113012012, -1125167698)
		 + W(3, -1133545211, 1042115577, -1111755343, 1034768106)
		 + W(4, -1156174412, -1165578649, 1045965141, -1143882022)
		 + W(5, -1157195276, -1139515595, 1024020315, -1128894336)
		 + W(6, -1122088448, 1021421814, -1108742643, 1025314463) + W(7, 1048741047, 1042307479, 1028526161, 1033940928)
		 + W(8, 1034591096, 1046263423, 1043768035, 1048434617)
		 + W(9, -1100558843, -1111490489, -1106766859, -1105393784)
		 + W(10, 1008615371, -1109822394, -1107512724, -1102660599)
		 + W(11, -1103528899, -1116374767, 1031989982, -1146160726);
	WS(1056068055, 1054753321);
	sum1 = W(0, -1151415881, -1148496799, 1010657956, 1024019466)
		 + W(1, -1130137728, 1008503186, -1132133255, 1035499631)
		 + W(2, 1039080395, -1110003853, 1010453293, 1036235820) + W(3, 1020552269, 1036573197, -1115513116, 1040242409)
		 + W(4, 1057552055, 1043835198, 1059020393, 1056043521) + W(5, 1059247988, 1054798584, 1050516586, 1047345767)
		 + W(6, -1089028090, 1042243518, -1089501818, -1077848098)
		 + W(7, -1085601017, -1088101382, -1102383812, -1092379525)
		 + W(8, -1115248008, 1050869997, 1038857744, 1040563886) + W(9, 1031869090, 1014726271, 1037313809, -1116861746)
		 + W(10, 1035025164, 1014222010, 1019596694, -1121658024)
		 + W(11, -1123056704, 1035081577, -1137744617, 1008326318);
	sum2 =
		W(0, 1028355794, -1106782132, 1035193429, 1019490884) + W(1, -1103311494, 1051099266, -1107701072, 1017055868)
		+ W(2, -1096807405, 1053669968, -1113415499, 1045145961) + W(3, 1033457423, -1105194567, -1111393110, 995616995)
		+ W(4, 1040605863, -1138391825, 1054131819, -1117197986) + W(5, 1014178849, 1043284247, 1045435457, -1110630971)
		+ W(6, 1067941768, -1075220438, -1088459045, 1059082808)
		+ W(7, 1050105229, -1121773074, -1120483817, 1023829774)
		+ W(8, -1077104108, -1095467240, -1094157882, 1063065831)
		+ W(9, 1061761756, 1042603721, -1116379229, 1044996767)
		+ W(10, 1052817152, -1103015841, 1049259157, -1103440804)
		+ W(11, -1095094287, -1122898552, -1109769641, 1018464332);
	WS(-1081368566, -1084412265);
	sum1 = W(0, 1027068306, 1015688387, 1033201483, 1018141039) + W(1, 1032237687, 1022250212, 1019999841, 1019305877)
		 + W(2, -1116002144, -1139602460, -1116483849, -1108067395)
		 + W(3, -1114781410, -1101031910, -1110135922, -1115253585)
		 + W(4, 1048181720, 1048418201, 1059204754, 1059054739) + W(5, 1060863016, 1054995541, 1048891912, 1054003721)
		 + W(6, -1097381330, -1109028275, -1086309497, -1080843359)
		 + W(7, 1035809139, -1090938969, -1097995920, -1098655035)
		 + W(8, -1110979184, 1018111780, -1126061147, 1023153354)
		 + W(9, 1043786804, -1102361409, 1017536656, -1110370680)
		 + W(10, 1021378954, 1036715310, -1118145977, 1024269909)
		 + W(11, 1014428471, 1015803518, 1027639288, 1026153225);
	sum2 =
		W(0, -1105480981, 1035973965, 1037165381, -1106311589) + W(1, 1052000177, -1104974154, -1120302417, 1040627526)
		+ W(2, 1050460434, -1096496755, 1049140757, 1006710678) + W(3, -1091756558, 1044207757, 1032159893, -1100748342)
		+ W(4, -1098849709, 1051612828, -1090898849, 1040931379) + W(5, 1058463605, -1090778289, 1039812947, 1045155050)
		+ W(6, 1048076097, -1090117310, 1053634690, 1066845841)
		+ W(7, -1077185739, 1058534342, -1102438650, -1096398368)
		+ W(8, 1035320005, 1047120319, 1021130333, -1083953982) + W(9, 1057459457, -1091684787, 1041032826, 1045504944)
		+ W(10, -1105501338, -1108725217, 1039969785, 1046728781)
		+ W(11, 1038345201, -1141278071, 1040363142, -1109297232);
	WS(1040286894, 1035975353);
	sum1 =
		W(0, -1171293815, 1023182418, 996039142, -1137235964) + W(1, -1135192533, 1025821242, -1128818097, 1020463141)
		+ W(2, 1034319831, -1127987806, -1102399280, -1105596260)
		+ W(3, -1103790599, -1108335719, -1114500598, -1129600787)
		+ W(4, 1059664710, 1048633701, 1062256902, 1059153168) + W(5, 1061115073, 1056014846, 1050028641, 1052737098)
		+ W(6, -1091927835, -1097464070, -1087363556, -1086480503)
		+ W(7, -1089057879, -1099300213, -1097571161, -1112421262)
		+ W(8, -1116625676, 1029070026, 1016696459, 1000027879) + W(9, 1028964506, -1108586113, 1032749254, -1096430155)
		+ W(10, 1013574450, 1012611215, -1115123712, 1006568169)
		+ W(11, -1134032598, 1032814547, 1020632239, 1016193698);
	sum2 = W(0, -1115556642, -1130243023, 1032034792, -1126476135)
		 + W(1, 1032996496, -1138592966, -1121911846, 1029413614)
		 + W(2, 1037372428, 1030557532, 1049080310, -1112452010)
		 + W(3, -1108874582, -1125709403, -1147299853, -1125845903)
		 + W(4, 1085969060, 1077581449, -1074326256, -1064530882)
		 + W(5, -1074476109, -1104386166, 1029772508, -1109306490)
		 + W(6, 1051814466, 1043810263, -1103611514, -1081646826) + W(7, 1033029539, 993676602, 1034388196, 1000946837)
		 + W(8, 1011471282, 1030366783, -1109496698, -1129814679) + W(9, 1035377868, 1007963430, 1005762565, 1024214725)
		 + W(10, -1114698318, 1034280644, -1140286158, 1022645135)
		 + W(11, -1126128243, 1013431542, -1114714998, 1024966722);
	WS(-1128144240, -1105727419);
	sum1 =
		W(0, 1008177348, 1008158465, 1025380533, 1041196118) + W(1, -1123971020, 1038005880, -1110790464, 1022532691)
		+ W(2, 1038442911, 1030921926, -1116236765, -1091904121)
		+ W(3, -1110541401, -1155490648, -1118346788, -1132141153)
		+ W(4, 1034971295, -1108323937, 1041262911, -1116818069) + W(5, -1118195565, 1050488689, 1005836543, 1035288564)
		+ W(6, 1037111480, 1020025483, 1039711206, -1090328900) + W(7, 1053066642, -1108534613, 1032777199, 1043217853)
		+ W(8, -1119737674, 1015575522, -1096558626, -1106145913)
		+ W(9, -1107602136, 1033678004, 1034582855, -1110557919) + W(10, 1019898055, 1036155997, 1023258159, 1038413850)
		+ W(11, -1123851725, 1027658998, -1118860082, -1161170171);
	sum2 = W(0, -1128930637, 1013105493, 1027020519, -1111106512)
		 + W(1, 1033707008, -1108465338, -1130609759, -1112986298)
		 + W(2, -1132037027, -1110061572, 1023565141, -1118411413)
		 + W(3, -1104848450, 1001195043, -1113096913, -1123693871)
		 + W(4, 1018701611, 1028677045, -1097696705, 1051172043) + W(5, 1036460110, -1134254189, 1035127174, 1021784635)
		 + W(6, -1110976033, -1113315034, -1136487341, 1064921249)
		 + W(7, -1097426277, 1028959819, -1113952185, -1139702593)
		 + W(8, -1129623857, -1136221161, 1045236380, -1100340880)
		 + W(9, 1026225447, 1033145987, -1105387359, 1025786651)
		 + W(10, 1029665439, -1120215489, 1025952555, -1120959951)
		 + W(11, 1006240491, -1118442072, -1137489821, -1119362634);
	WS(1066786198, 1018352061);
	sum1 = W(0, 1037807432, -1147124480, 1032919115, 1043153405) + W(1, 1024885356, 1040525108, 1034093744, 1041644314)
		 + W(2, 1042991174, -1118935590, -1102401423, -1111703874)
		 + W(3, -1105747115, -1109427003, 1036876386, -1113217832)
		 + W(4, 1056116676, 1053008404, 1058826232, 1052869895) + W(5, 1063596395, 1052412861, 1055303296, 1055747689)
		 + W(6, -1089303485, -1093203077, -1091158043, -1077398372)
		 + W(7, -1088790919, -1096537905, -1092801624, -1095292522)
		 + W(8, -1115182496, 1032850856, -1118679276, -1112497438)
		 + W(9, 1041854800, -1158252416, 1029739551, -1097656684) + W(10, 1044944769, 1019595829, 1030098999, 990101824)
		 + W(11, 1037575334, 1022825908, 1042956152, 1027108728);
	sum2 =
		W(0, 1036031230, -1120880520, -1118383086, -1112120068) + W(1, 1044452135, -1113902667, 1036248196, -1175016923)
		+ W(2, -1102747382, 1035081854, -1081312733, -1097589576)
		+ W(3, -1136989239, -1101386787, 1038098664, -1106083613) + W(4, 1040389106, 999021742, 1046511529, 1061513306)
		+ W(5, -1098672489, 1028645652, 1037598188, 1027306194) + W(6, 1027629590, 1048871361, -1102228261, 1059108854)
		+ W(7, 1030279668, -1090327880, 1046091275, -1110606753) + W(8, 1033840740, 1037408166, -1111365044, 1017984327)
		+ W(9, 1032578550, -1098256610, 1055272900, -1100293962)
		+ W(10, -1113736580, 1036561850, -1105995296, 1037901466)
		+ W(11, 1024281094, 1003868670, 1035521712, -1114802202);
	WS(-1088826540, -1072617048);
	sum1 = W(0, 986338164, 1023136598, -1127817408, 1038855104) + W(1, -1112014844, 1032100206, -1114071293, 1031252724)
		 + W(2, 1037920241, -1108211448, -1117329516, -1098615294)
		 + W(3, -1156351446, -1125030464, 1025960366, -1128205111)
		 + W(4, 1051799989, 1051897846, 1060040519, 1068445460) + W(5, 1041659186, 1049473503, 1046320643, 1053193450)
		 + W(6, -1096657083, -1097067830, -1085267217, -1091986338)
		 + W(7, -1085224562, -1095210946, -1103740786, -1098483636)
		 + W(8, -1131268440, -1134063855, 1034398076, -1104903024)
		 + W(9, 1041222927, -1123500579, 1021522163, -1110505437)
		 + W(10, -1122826702, 1022858827, 1016624516, 1025833567)
		 + W(11, -1148095931, 1018816617, 1004333185, -1135786218);
	sum2 = W(0, 1025188267, -1121532154, 1037371296, -1111771837)
		 + W(1, 1040037716, -1106548534, 1039102739, -1109851481)
		 + W(2, -1139275200, 1033600964, -1123953755, 1046721727)
		 + W(3, -1098628025, 1040338433, -1109104289, 1042987802)
		 + W(4, 1040515214, -1111129732, 1035395064, -1119362505)
		 + W(5, 1046868281, -1095083293, 1045077862, -1121821072)
		 + W(6, -1131755519, -1105820182, 1067277095, 1075696256)
		 + W(7, -1070220409, -1079865944, 1049591033, -1113640498)
		 + W(8, -1105181237, 1041295374, -1104867399, 1058324165)
		 + W(9, -1095490474, 1030948623, -1107729189, 1039251361)
		 + W(10, 1030566925, -1137053008, -1131759093, 1026363312)
		 + W(11, -1118056117, 1018203389, -1128931569, -1123620784);
	WS(-1126600048, -1081356549);
	sum1 = W(0, -1127841038, -1121393942, -1127713943, -1112866678)
		 + W(1, -1130256197, -1113126004, -1135790871, -1114110304)
		 + W(2, -1133929050, 1032965854, 1033968271, 1043820719) + W(3, 1042942538, 1043379215, 1027795642, 1034600139)
		 + W(4, -1098403026, -1092154099, -1092503722, -1081570623)
		 + W(5, -1086843241, -1092479684, -1097678271, -1094287464)
		 + W(6, 1044657313, 1056638003, 1049224359, 1066854747) + W(7, 1055316562, 1058087872, 1032418298, 1051778533)
		 + W(8, -1112364357, 1040562850, 1040769245, -1105175211)
		 + W(9, -1123699911, -1108064855, -1138101411, 999504676)
		 + W(10, -1126110067, 1036225512, -1129561307, 1047740947)
		 + W(11, -1102743497, 1041161205, -1106598351, 1039116783);
	sum2 = W(0, 1002695390, -1122258341, -1122292123, -1120933435)
		 + W(1, 1032169765, -1117894001, 1003179774, -1138289315) + W(2, 1041236493, 1024135109, 1018577975, 1034742596)
		 + W(3, -1148289286, -1155671947, 1027950533, -1116290259)
		 + W(4, -1107205869, -1167041196, 1048984334, -1085659967)
		 + W(5, 1041640777, -1108030745, -1123201389, -1139220243)
		 + W(6, -1110230321, -1120190201, -1063745707, -1070580481)
		 + W(7, 1042707591, 1049556353, -1106095214, 1050855401) + W(8, 1025661924, 1051920007, 1083223141, 1079255156)
		 + W(9, -1110361303, -1097500712, 1030518681, -1105964729)
		 + W(10, 1013006047, -1101224590, 1033459361, 1037086181)
		 + W(11, -1105447820, 1029970779, 1006793819, -1115669085);
	WS(1044741550, -1111040261);
	sum1 = W(0, -1123328853, -1102049737, 1040528310, -1104112191)
		 + W(1, 1024305776, -1101315365, 1021709031, -1111623399)
		 + W(2, -1129171790, 1051367713, -1097130129, 1051950321)
		 + W(3, 1039437043, 1045396986, -1108128612, -1165073551)
		 + W(4, -1119860449, -1091471693, 1035652177, -1092522751)
		 + W(5, -1095677118, -1130673884, -1112716514, -1121220876)
		 + W(6, 1045626213, 1046305018, 1049556145, 1053940037) + W(7, 1055561708, -1095468986, 1044018368, 1026385047)
		 + W(8, -1104602741, 1044417333, -1091825946, 1049099055)
		 + W(9, -1104689389, 1055485165, -1103796617, 1036376309)
		 + W(10, 1022127887, -1107859535, 1033350174, -1124872112)
		 + W(11, -1115808049, -1115536169, 1029190802, -1122289340);
	sum2 = W(0, -1104033148, -1105436527, -1109964889, -1097126651)
		 + W(1, -1098141643, -1090250993, -1116302593, -1118233874)
		 + W(2, 1039328248, 1038128967, 1010051700, 1057153562) + W(3, 1057745438, 1060383381, 1035812245, 1044677482)
		 + W(4, 1040757730, 1010939044, 1051778220, 1035481326)
		 + W(5, -1094952202, -1102222701, -1133841678, -1105877607)
		 + W(6, 1023457753, -1118329847, -1098103909, -1094975289)
		 + W(7, 1048659070, -1098057265, -1123621243, -1160321672)
		 + W(8, -1105261590, 1011822306, 1019752394, 1037637839) + W(9, 1023965510, 1049957743, -1104798795, 1036758948)
		 + W(10, 1019934334, 998732076, -1151355224, -1112777586)
		 + W(11, 1012075272, -1134551782, 1031321862, -1124061226);
	WS(1065794902, 1053657215);
	sum1 = W(0, -1121908120, 1018314063, 1015310777, -1124873339)
		 + W(1, 1031572020, -1147984576, 1024640407, 1026486289) + W(2, 1038333639, 1031009517, 1039118671, 1034311430)
		 + W(3, 1041290230, -1120195837, -1119856235, -1114392412)
		 + W(4, 1027457764, -1106391546, -1097318831, -1141167585)
		 + W(5, 1054548019, 1053489270, 1041008530, 1038700424) + W(6, -1123855831, 1034446294, 1039330595, -1090069831)
		 + W(7, -1096859758, -1090834490, -1105884449, -1105777031)
		 + W(8, -1123864939, -1121443224, 1026117491, 1040632671) + W(9, 1028976296, 1043686014, 1007855863, 1023881277)
		 + W(10, 1004753494, 1015085764, -1152877546, -1119728987)
		 + W(11, -1155937596, -1132243578, 999100652, -1148206328);
	sum2 =
		W(0, -1111593455, 1026283313, -1106910582, -1123416451) + W(1, 1050577288, -1128641646, 1047088729, -1113858977)
		+ W(2, 1035072504, 1028902500, 1047373071, 1053329938) + W(3, -1092564654, -1100521328, -1096962366, 1017970524)
		+ W(4, 1043803228, -1108682745, 1040261276, 1067600226) + W(5, -1072392505, -1113219589, 1049469167, 1037790473)
		+ W(6, 1033408259, -1102620143, 1048908013, -1090850305) + W(7, 1062297118, 1017836657, 1033530157, -1125952722)
		+ W(8, -1104275307, 1005020832, -1100960524, 1050480903)
		+ W(9, -1138210428, -1168415746, 1025688819, -1131011166) + W(10, 998670368, 1032181798, 1023771046, 1032569956)
		+ W(11, -1112013629, 1023611526, -1112880371, 1021270423);
	WS(1062391596, 1012575503);
	sum1 = W(0, 1031343933, -1104891955, 1032025473, 1018981700)
		 + W(1, -1107154694, 1037332142, -1113508494, -1120166325)
		 + W(2, -1118754907, 1040079801, -1098309187, 1047266492)
		 + W(3, 1041578200, -1102249736, 1040475388, -1099931343)
		 + W(4, -1124966418, 1034244551, -1115351741, -1082667844)
		 + W(5, 1034155267, -1116669206, -1108675062, 1037232762)
		 + W(6, -1110681406, -1097175282, 1051954479, 1046130725) + W(7, 1051147223, 1052085167, 1003822408, 1045069376)
		 + W(8, 1044511208, 1039695694, 1024690888, 1049723012) + W(9, -1103478091, 1031631968, 1001356052, -1120670778)
		 + W(10, -1105353116, 1041572194, -1106768761, -1111177056)
		 + W(11, 1041859398, -1100878141, 1037747241, -1115735812);
	sum2 =
		W(0, 1033523600, -1111554425, -1129275556, -1122087690)
		+ W(1, -1124036306, 1037981702, -1119955572, -1122349214) + W(2, 984378304, 1035520350, -1139357832, 1042336361)
		+ W(3, -1098127108, -1108770624, 1031985496, 1030270440) + W(4, 1029410276, 1027721316, -1120989222, 1063527919)
		+ W(5, -1086537602, -1087308230, 1038170956, 1040810725) + W(6, 1013286288, -1092144316, 1051778774, 1062226267)
		+ W(7, -1106529787, 1023869712, -1106223749, -1113965912)
		+ W(8, -1149511552, 1040549613, -1101613332, 1044728263)
		+ W(9, -1102568312, 1043627655, -1109791564, 1025118636)
		+ W(10, -1114072340, 1027894332, -1138380800, -1113445964)
		+ W(11, 1042436209, -1103441850, 1038090706, -1120264936);
	WS(1061969900, 1065420380);
	sum1 = W(0, 1002358108, -1132400117, 1036273784, -1121891281) + W(1, 1031471239, 1014037550, 1015146068, 1021231496)
		 + W(2, 1041410250, 1024825568, -1111416381, -1112279056)
		 + W(3, -1100377015, -1110955448, -1140842745, -1109508230)
		 + W(4, 1005238718, 1055004288, 1058195604, 1065721300) + W(5, 1058645356, 1050103969, 1047622119, 1050895308)
		 + W(6, -1098164717, -1093641048, -1089452644, -1081575699)
		 + W(7, -1095897092, -1095327860, -1122283864, -1101391147)
		 + W(8, -1127598604, 1037205414, -1122200151, 1041630292)
		 + W(9, -1115380038, 1033148051, -1112032609, -1107652840)
		 + W(10, 1013481849, -1128588267, 995531041, -1118185583)
		 + W(11, 1031870564, -1125213521, 1031659065, -1167265945);
	sum2 = W(0, 1037378832, -1105869799, 1034348880, 1010791317)
		 + W(1, 1020451237, 1025476671, -1121382126, -1144944739)
		 + W(2, -1097408481, 1040337956, 1050274911, -1124897054)
		 + W(3, -1105197585, -1107003535, -1131733180, -1128932040)
		 + W(4, -1089422359, 1064628576, 1078490638, -1067190452) + W(5, 1026583828, 1034175619, 1030289482, 1035014695)
		 + W(6, -1134521568, 1048269110, 1055313899, -1081189141)
		 + W(7, 1051135592, 1043712009, -1114815155, -1125325948)
		 + W(8, 1024014288, -1113808990, 1025241947, -1100728789)
		 + W(9, 1047164907, -1112306567, 1025919494, -1116208218)
		 + W(10, -1156999910, -1121898726, 1025759300, 1010618498)
		 + W(11, 981635389, -1142752483, -1158764013, 1029088384);
	WS(1048733783, 1027643848);
	sum1 = W(0, -1133845785, -1133175894, -1135183403, -1116789548)
		 + W(1, -1148511502, -1134260761, 1018609610, -1123833247)
		 + W(2, 1036515120, 1023561851, 1042717327, 1030082171) + W(3, 1048693393, 1034425221, 1039337356, 1027869798)
		 + W(4, -1088559253, -1093510507, -1088396394, -1080791005)
		 + W(5, -1089662985, -1090323862, -1100061261, -1089888600)
		 + W(6, 1057953132, 1049915371, 1060634166, 1063183646) + W(7, 1058925305, 1044704560, 1042697693, 1047384498)
		 + W(8, 1034283684, -1130587597, -1127730531, -1114509469)
		 + W(9, -1138682841, 1038705162, 1015444552, 1049640472)
		 + W(10, -1114935677, 1012777537, -1122593837, 1031486794)
		 + W(11, -1116148770, -1166921432, -1126426832, 1023971661);
	sum2 =
		W(0, 994989105, -1144072856, -1122509885, 1026939205) + W(1, 1028398855, -1120878413, 1025208177, -1113678678)
		+ W(2, 1037891939, -1103317800, 1037436931, -1127785128)
		+ W(3, -1103788534, 1034163445, -1127272012, 1026044831) + W(4, -1173716290, 1052666546, 1001371192, 1040815920)
		+ W(5, -1100616833, 1020001090, -1134790452, 1043708121)
		+ W(6, -1100065758, -1122814128, -1129250144, 1058553182)
		+ W(7, 1055924851, 1053725018, 1036740791, -1123998093)
		+ W(8, -1120127409, -1094230404, -1083084807, -1075758811)
		+ W(9, -1074914963, -1075891465, -1081737398, -1084193900)
		+ W(10, 1036146011, 1054652553, 1061875701, 1067689129) + W(11, 1068744910, 1067320464, 1065190583, 1062426867);
	WS(-1084457324, 1066101859);
	sum1 = W(0, -1146837948, 1016102797, -1115430590, -1115904029)
		 + W(1, -1139281484, -1117556663, 1034492603, -1124011056)
		 + W(2, -1111022815, -1125864729, 1047559389, 1034715654)
		 + W(3, -1103064096, -1108958078, -1131712724, -1131623214)
		 + W(4, -1115296098, 1038645029, -1083544605, 1037951214)
		 + W(5, 1057869073, -1109939240, -1123954086, -1123535023)
		 + W(6, 1042035070, 1047347075, 1059438663, 1052960194) + W(7, -1083491782, 1046468604, -1121536740, 1043250206)
		 + W(8, 1030912362, -1106508822, -1104927285, -1167432352)
		 + W(9, 1045723406, 1012598283, 1019381994, -1110102674)
		 + W(10, -1121095658, -1128702979, 1022709564, -1129984885)
		 + W(11, -1123913107, -1123056725, 1026960983, -1128824061);
	sum2 =
		W(0, -1125705477, -1127756609, 993770127, 1034569455) + W(1, 1010458600, -1119844207, -1122090273, 1019369801)
		+ W(2, -1127395739, 1044805550, -1097909373, -1177736375)
		+ W(3, -1116962018, 1043096893, 1035619005, -1112228363) + W(4, -1105227463, 1015549291, 1049252886, 1058826852)
		+ W(5, -1119951878, -1094678765, -1119199398, -1109645851)
		+ W(6, 1036906007, -1109261657, -1102191244, 1061852121)
		+ W(7, -1086841826, -1128420796, 1021651597, 1038741216)
		+ W(8, 1026846896, 1037043129, -1097396928, -1116961215) + W(9, -1103314123, 1038664018, 1035622840, 1019677755)
		+ W(10, 989272222, -1106679057, 1042524140, 1013800282)
		+ W(11, 1033157194, -1128652243, -1124905499, -1126258736);
	WS(1067036470, -1087655195);
	sum1 = W(0, -1143851962, 1026890311, -1106604063, 1016195769)
		 + W(1, -1138731339, 1037080924, -1121217270, 1029907824)
		 + W(2, 1018554747, -1120379564, -1114993347, 1022258327) + W(3, 981655329, 1045778247, 1025121994, 1023696087)
		 + W(4, 1050955184, 1053786273, 1042552729, 1063572966) + W(5, 1058367344, 1055564522, 1047575674, 1048845230)
		 + W(6, -1110423387, -1098337218, -1090196611, -1083965137)
		 + W(7, -1084059678, -1090231591, -1096786628, -1095677575)
		 + W(8, -1106360251, 1040602294, -1134551499, 1045568787) + W(9, 1046272662, 1028646847, 1026932869, 1027665749)
		 + W(10, 1025799530, -1118031105, -1119796702, -1110210301)
		 + W(11, -1132188582, -1117810092, 1021012754, -1118338222);
	sum2 =
		W(0, -1113854255, 1028862084, -1104900936, -1104116954) + W(1, -1114719178, 1040474278, 1048817634, -1122519186)
		+ W(2, -1108417433, 1033605964, -1109151867, -1102487521)
		+ W(3, -1071728118, -1073652757, -1090221130, -1102125815)
		+ W(4, 1042382895, 1032534216, 1017793091, 1067799294) + W(5, 1077900204, 1051278318, 1048299521, -1105402373)
		+ W(6, 1025435556, 1033584957, 1033281558, -1099286824) + W(7, 1056033422, -1113833767, 1011833167, -1107682623)
		+ W(8, -1108154666, 1046901615, -1111336587, 1036137805) + W(9, 1024983956, 1034492621, 1033542750, -1127962013)
		+ W(10, 1042045079, -1105415159, 1039313065, 1005958605)
		+ W(11, 1020191839, -1114752489, 1024757388, 1032711916);
	WS(-1087701164, 1071308133);
	sum1 = W(0, 1040776942, -1112915908, 1032135583, -1109010607)
		 + W(1, -1125896234, 1033070381, 1001383873, -1127540900)
		 + W(2, -1100025248, 1039729431, -1111499300, 1047911115)
		 + W(3, -1096854047, 1047586960, -1100475875, 1025720505)
		 + W(4, 1040244657, -1108101926, -1107965963, -1095250332)
		 + W(5, -1097276733, -1104060437, -1129328465, -1115131352)
		 + W(6, 1047131214, -1104971284, 1036283892, 1057920197) + W(7, 1057601759, 1046835436, 1017446731, 1041767855)
		 + W(8, -1116520012, -1123736282, -1105297773, 1040789767)
		 + W(9, -1089523085, 1046328829, -1107686492, 1031878575)
		 + W(10, -1152028354, -1120800451, 1024489952, 1038925278)
		 + W(11, 1034463851, -1130324381, -1112186573, 1015088161);
	sum2 = W(0, -1089646175, -1112379036, -1087427677, -1088789602)
		 + W(1, 1059010203, 1060985431, -1139584980, 1054225000) + W(2, 1060062242, 1018139178, 1066898400, 1066001716)
		 + W(3, -1079880526, -1081253059, -1095878540, -1095013927)
		 + W(4, 1050551269, -1096611550, -1116330565, 1056235229)
		 + W(5, -1118197619, -1102574794, 1039647840, -1099698701)
		 + W(6, 1017421696, 1040955729, 1035645225, 1040223965) + W(7, -1114176344, 1044677785, -1100382074, 1035015292)
		 + W(8, -1124178965, -1115297526, -1111832492, 1027731712)
		 + W(9, -1106279788, -1130074994, 1040262609, -1124507789)
		 + W(10, 1023971829, -1112174927, 1035838465, -1128027042)
		 + W(11, 1015547306, 1033729011, -1110899873, 1032866060);
	WS(1063980716, -1121784884);
	sum1 =
		W(0, 1027357276, -1104528667, -1122859745, -1107033792)
		+ W(1, -1105809438, 1033196814, -1111338526, -1111105883)
		+ W(2, 1046480497, -1121849329, 1049050976, 1046903620) + W(3, -1128776604, 1050194992, -1112079704, 1037688238)
		+ W(4, -1094692773, -1090457523, -1090130146, -1084796508)
		+ W(5, -1089370535, -1105629197, -1093813713, -1094775914)
		+ W(6, 1050884987, 1048987838, 1057733925, 1061180023) + W(7, 1054317580, 1055134019, 1046804578, 1057027842)
		+ W(8, 1046796692, -1098583576, 1037378828, 1034725880) + W(9, -1096435840, 1049629536, -1097780651, 1038664949)
		+ W(10, 1025153935, -1107151594, 1016110982, 1023598816)
		+ W(11, -1114135692, 1040596522, -1113598601, -1127372967);
	sum2 =
		W(0, 1041589168, 1024315846, 1043663909, 1040621380) + W(1, 1040212968, 1033384296, 1014426993, 1022694293)
		+ W(2, -1098133521, -1106371173, -1106740015, -1107177437)
		+ W(3, -1111131552, 1040430896, 1032409853, 1003633577) + W(4, 1031854878, 1051327081, -1108849860, -1106409587)
		+ W(5, -1120392794, -1093765703, -1107120761, -1104283048)
		+ W(6, -1105720063, 1023684981, -1124767392, -1127108094)
		+ W(7, -1102248051, 1050935529, 1033359350, -1128561530)
		+ W(8, 1035016760, -1128261352, 1035542785, -1111599720) + W(9, 1051247500, -1102687331, 1037002974, 1026574958)
		+ W(10, -1121214780, 1011090873, 1029549000, 1034668152)
		+ W(11, -1136161665, 1018485311, -1126387868, 998242826);
	WS(1047153326, -1105960410);
	sum1 = W(0, 1032318440, -1133035902, 1023033002, -1111741083)
		 + W(1, 1009988015, -1126171361, -1183551252, -1118067977)
		 + W(2, -1105871782, 1024269605, -1110369667, 1047130673)
		 + W(3, 1043587009, -1113373146, 1035984354, -1111622952)
		 + W(4, -1111485966, -1098984649, 1050315790, -1080272088)
		 + W(5, -1086889743, -1098309317, -1105786176, -1106267538)
		 + W(6, 1043448020, 1044051929, 1059563250, 1053459949) + W(7, 1061038806, 1044456898, 1048086975, 1037611273)
		 + W(8, -1110710801, 1028564080, -1113831750, 1024144723)
		 + W(9, -1117616080, -1145766181, -1114741783, 1040212689)
		 + W(10, 1019497606, 1019882933, -1118335287, 1018957863)
		 + W(11, -1122250988, -1124691083, -1123242346, -1150984053);
	sum2 = W(0, -1132142402, 1019405455, 1022592575, 1002713172) + W(1, 993592760, -1120241477, 1024283135, -1139068036)
		 + W(2, -1109262360, 1034679642, -1099677890, 1048612806)
		 + W(3, 1036415285, -1118742739, -1125545553, -1129249399)
		 + W(4, 1044069954, -1104355470, -1119884477, -1094376769)
		 + W(5, -1110824904, 1031998111, -1128336378, 1030577347)
		 + W(6, -1111364284, -1108806456, -1066728208, 1079847520)
		 + W(7, 1060715429, -1103911380, 1028262793, -1127589036)
		 + W(8, 1031679549, -1097044621, 1043056057, 1057366851) + W(9, -1104696735, 993276152, 1012785110, -1133646774)
		 + W(10, 1018817977, 1034241557, 988348592, -1114461524)
		 + W(11, -1107038514, 1036085605, -1128734189, -1182233281);
	WS(1056964652, 1042968547);
	sum1 = W(0, 1026864302, -1136392949, 1024389106, -1126999334)
		 + W(1, 1026043785, -1130628252, 1000688741, 1002882868) + W(2, 1044356666, 1026146499, 1030265493, 1038248593)
		 + W(3, -1126651679, -1146035092, 986691602, 1033146167) + W(4, -1111481597, 1051097712, 1040695131, 1052760426)
		 + W(5, 1056669112, 1038264227, 1027446877, 1040116499)
		 + W(6, -1091567350, -1098882624, -1090350559, -1081953599)
		 + W(7, -1095456258, -1102468122, -1109487565, -1110909592)
		 + W(8, 1041608192, 1029687022, 1042991030, 1043333208) + W(9, 1044232931, 1038520784, 1033386798, 1040618297)
		 + W(10, 1008927875, -1130908784, -1127664937, -1121268145)
		 + W(11, 952128323, -1146879000, -1137895230, 1023066122);
	sum2 =
		W(0, -1155037894, -1117766868, 1042293027, 1004126723) + W(1, -1123150924, 1015608713, -1135323377, 1030487760)
		+ W(2, -1109445776, -1132308185, -1101307898, 995397702) + W(3, 1014206993, 1046458351, -1120597884, 1026431488)
		+ W(4, -1106399184, 1041934367, -1137539889, 1035303811)
		+ W(5, -1091518060, -1124849601, 1043824666, 1061366644) + W(6, 1052866656, -1111172948, 1058738313, 1064268129)
		+ W(7, 1052685347, -1090299347, -1087905074, -1075431372) + W(8, 1046069094, 1042904039, 1045435531, 1051607279)
		+ W(9, -1098813712, -1150133894, 1037110006, -1089430426)
		+ W(10, 1012439553, -1108172404, -1110297962, -1110625272)
		+ W(11, -1107185126, 1045339946, -1122419536, 1049588119);
	WS(-1096061015, 1045980634);
	sum1 =
		W(0, -1136709393, 1028828435, 997001355, 1022855123) + W(1, -1128346047, 1031977874, 984865373, 1040707047)
		+ W(2, 1047345176, 1016418418, 1049157941, 1032879612) + W(3, 1042754713, 1032419332, -1124110958, 1040469689)
		+ W(4, -1089944925, -1096285771, -1094897728, -1097979037)
		+ W(5, 1014307589, 1040846151, 1042092045, 1041011167) + W(6, -1113534082, 1049565603, -1113216951, -1094660427)
		+ W(7, 1031601097, -1095562472, -1109834744, -1093905225) + W(8, 1020871950, 1021274185, 1042276288, 1039512084)
		+ W(9, 1028680388, 1044068336, -1140756488, 1048548616) + W(10, 1032683291, 1018404508, 1027484139, -1119890439)
		+ W(11, 1030972704, -1125789619, 1031142826, -1123584299);
	sum2 =
		W(0, -1114682679, -1115477579, -1100789101, -1113658391) + W(1, -1110942733, 1044868728, 1028313432, 1046472362)
		+ W(2, 1055059251, 1024869090, 1055732865, -1122542034)
		+ W(3, -1120682294, -1107016239, -1152832742, -1087243594)
		+ W(4, 1064739409, 1031266096, 1030176534, 1067742275) + W(5, 1062911121, -1081471397, -1080677577, -1077241450)
		+ W(6, -1095220576, -1113806527, 1040530242, 1036337974) + W(7, -1087169731, 1042181045, 1042749891, 1067213860)
		+ W(8, -1100660553, -1105830101, -1096186716, -1103152959)
		+ W(9, 1035448471, 1052603278, 1033558186, 1052345796) + W(10, 1038444345, -1132048253, 1040636888, 1015520805)
		+ W(11, 1032588114, -1102136445, -1134141481, -1112398105);
	WS(-1086603372, 1061480206);
	sum1 = W(0, 1025472273, -1143591172, -1124123051, -1110008795)
		 + W(1, -1124248793, -1127491490, 1014214528, -1120184170)
		 + W(2, 1022341006, 1027469190, -1141108008, 1042054049) + W(3, 1051331968, 1044174205, 1044005681, -1155225358)
		 + W(4, 1006839158, -1128153798, 1051787090, -1090097115)
		 + W(5, -1081435553, -1089913687, -1092574472, -1096696337)
		 + W(6, -1102342404, -1124925900, -1093885235, 1058414043)
		 + W(7, 1063214861, 1057428893, 1052102264, 1048742922) + W(8, 1042514621, 1043263108, 1027880941, -1105821275)
		 + W(9, -1094479791, -1099759469, -1112069887, 1035771431)
		 + W(10, -1114893026, -1114252238, -1121794488, 1039892842)
		 + W(11, 1028544109, 1041669328, 977928239, 1039400116);
	sum2 =
		W(0, 1037224808, -1109009263, -1120793535, -1110258597)
		+ W(1, -1112240446, -1151274598, -1120536233, -1103902982)
		+ W(2, 1025638319, 1049599085, -1142324554, 1028269513) + W(3, -1132053081, -1119573384, 1010517574, 1008384356)
		+ W(4, -1093017633, 1039705537, 1040559103, 1053657173) + W(5, -1120149375, 1043501160, -1121251494, 1035850418)
		+ W(6, -1143762368, -1112746506, -1099136162, 1056581815)
		+ W(7, -1118127758, -1147801478, -1130373692, 1032229723)
		+ W(8, -1119609796, -1119534458, -1123476586, -1104556193)
		+ W(9, 1044376501, -1107739102, 1033895801, -1122521676) + W(10, 995865588, 1021427773, 988834049, -1122952792)
		+ W(11, -1114993482, 1029987722, -1106681926, -1116132116);
	WS(1037058908, -1087106898);
	sum1 = W(0, 1032385376, 1028077583, 1014613011, -1151370839) + W(1, -1139761263, 1027279360, 1022565566, 1031834108)
		 + W(2, 1026637522, -1129390954, 1048467894, 1048758199) + W(3, 1043852440, 1034990442, 1017011558, 1036138504)
		 + W(4, -1098495714, -1107088868, -1108180359, -1093334653)
		 + W(5, -1108393155, -1097414435, -1111470776, -1104527470)
		 + W(6, 1041048768, 1041268325, 1045140885, -1080472255) + W(7, 1045570315, 1045361342, 1028923180, 1036330497)
		 + W(8, 1039729665, -1126519617, 1040649531, -1114665834)
		 + W(9, -1125126080, 1035082182, 1023808326, 1027790590) + W(10, 1017191910, -1132138900, 1035348883, 997380151)
		 + W(11, 1031307292, 1030937245, -1138594135, 1036519916);
	sum2 = W(0, -1111516802, 1036231024, -1130951686, 1031916934)
		 + W(1, -1130989326, -1129631002, -1123615369, -1119469958)
		 + W(2, -1131222514, -1098228691, 1034905648, -1090487171)
		 + W(3, 1032129266, 1035677128, -1103168970, 1049196148)
		 + W(4, -1097346809, -1128682274, -1113861539, 1052765954)
		 + W(5, -1108538807, -1122282521, 1038239484, -1116187122)
		 + W(6, 1049467820, 1020406578, 1024259929, 1061096371)
		 + W(7, -1104129123, -1108918961, -1114584358, -1129232626)
		 + W(8, -1118099733, -1102087439, 1049541587, -1108988196)
		 + W(9, 1033200380, 1042713844, -1097598443, 1018354634)
		 + W(10, -1111393075, 1039222222, -1113826501, 1025340241)
		 + W(11, 1029417921, -1111528334, 1034012496, 1029857705);
	WS(1054906071, -1091145324);
	sum1 =
		W(0, 1029398237, -1140775857, -1128656451, 1004160018) + W(1, -1130732913, 1029686973, 1021855224, -1128798955)
		+ W(2, -1120406171, -1106052861, -1099422950, 1032725545)
		+ W(3, -1097841652, 1037934865, 1036573848, -1157619404) + W(4, 1051536197, 1046952684, 1057886666, -1085942396)
		+ W(5, -1098611557, 1042440654, 1035129734, 1032622058)
		+ W(6, -1115196942, -1109008729, -1097962977, -1130426984)
		+ W(7, 1048146402, 1034532491, -1122054089, 1027356128) + W(8, -1136290815, 1034481647, -1114344740, 1050651652)
		+ W(9, -1102043591, -1133864753, -1124817654, -1126847669)
		+ W(10, -1126429728, 1032555988, 1015919623, -1108426832)
		+ W(11, 1040987294, -1107032303, 1044439941, -1115113714);
	sum2 = W(0, -1113802973, -1116219822, 1020553430, -1109755343)
		 + W(1, -1131329246, -1112950186, -1113313093, -1116367256)
		 + W(2, 1027581315, -1112877584, -1110295429, 1027296115)
		 + W(3, -1126007358, 1035099341, -1130784978, 1035863861)
		 + W(4, -1110955855, -1127685514, -1097495000, 1025841055)
		 + W(5, -1104102640, -1110724235, -1165405916, -1097352168)
		 + W(6, 1047020911, 1021259086, 1057623683, 1053623791) + W(7, 1057318729, 1040083835, 1048620928, 1039940909)
		 + W(8, -1105727831, -1118276653, -1110729082, -1104267868)
		 + W(9, -1106795812, -1119773745, -1128480210, -1110646461)
		 + W(10, 1022816774, -1129541322, 997980814, 1016281450)
		 + W(11, -1105649969, 1031563375, -1111917112, 1032754595);
	WS(1063926444, -1083200389);
	sum1 =
		W(0, -1110900111, 1015785179, -1132926346, 1034778082) + W(1, 1029162938, 1024169214, 1031086749, -1116484151)
		+ W(2, 1049653262, -1116391059, 1048988121, -1111931241)
		+ W(3, 1002973694, -1107911937, -1104277444, -1114837807)
		+ W(4, -1089993663, -1106495964, -1104923071, 1061854120) + W(5, 1062129309, 1059656227, 1047872627, 1055218483)
		+ W(6, 1052688460, 1038385529, 1045396422, -1089207439)
		+ W(7, -1085048198, -1087799869, -1096506545, -1096830980)
		+ W(8, -1098055945, -1108169455, -1110654965, -1111176153)
		+ W(9, 1042255343, 1043917388, 1012240783, 1049045741) + W(10, 1042131972, -1121748392, 1039495970, -1117097761)
		+ W(11, -1120523578, -1106362715, 1011366638, -1098874335);
	sum2 = W(0, 1031260311, 1008713252, -1110413739, -1108083749)
		 + W(1, 1024382525, -1107516795, 1032742989, -1107429215)
		 + W(2, -1079593190, -1080879443, -1099919153, 1067198745)
		 + W(3, 1061544601, 1037733964, 1034769578, 1037726418) + W(4, -1121246507, 1035854140, 1040572163, -1111993270)
		 + W(5, 1060638292, -1122943484, -1098923291, 1034609836)
		 + W(6, -1113337443, 1043424734, -1112705599, -1102589461)
		 + W(7, 1044789771, 1040341398, -1116338100, 1030676197) + W(8, 985022717, -1123981203, 1028350097, 1035118406)
		 + W(9, -1119559917, -1123835438, 1021760610, -1114867192)
		 + W(10, 1032096214, -1130846658, -1119780465, 1007072124)
		 + W(11, -1132931022, -1131952682, 1028149723, -1115680064);
	WS(-1091090263, 1040227933);
	sum1 =
		W(0, -1123880467, -1114808049, 1014154590, 1032220316) + W(1, 1018131933, -1121223347, -1128795491, 1008528046)
		+ W(2, -1113261184, 1027485320, -1101480756, 1043855170) + W(3, -1088775234, 1021676847, 1031227206, 1026364723)
		+ W(4, 1033284496, 1019377225, -1102787036, -1094753319) + W(5, 1065098078, -1107869654, 1045897152, 1025551690)
		+ W(6, 1044923332, -1098653061, 1059927492, 1040011797)
		+ W(7, -1099661886, -1151140018, -1113799968, -1125551659)
		+ W(8, -1105999782, 1042536309, -1095990282, 1044858269)
		+ W(9, -1091964998, 1045062557, -1109510984, 1023695008)
		+ W(10, -1135767575, -1127683258, 1037484605, -1120454550)
		+ W(11, 1029352975, -1109078132, 1027724204, 1006311503);
	sum2 = W(0, -1123304381, 1011470018, -1116901758, 1029761957)
		 + W(1, -1135722528, -1111769341, -1107033568, 1032808415)
		 + W(2, -1135928985, -1131363804, 1044779190, -1101932196)
		 + W(3, -1097334030, 994986369, 1042173475, 1025113569) + W(4, 1039889929, 1045400660, -1100997480, 1055172736)
		 + W(5, -1087140500, 1054550160, -1110305303, -1115908038)
		 + W(6, -1113522433, -1100907702, -1104972678, 1058841413)
		 + W(7, 1039800739, -1122473050, -1109069053, 1032761157)
		 + W(8, -1108136941, 1038781261, 1052809383, -1093286229)
		 + W(9, 1034962749, -1105965260, 1038676003, -1155418681)
		 + W(10, 1038356153, -1139124254, -1105005165, 1040780481)
		 + W(11, -1105451984, 1042887374, -1114167820, -1152192529);
	WS(1063982124, 1031276218);
	sum1 = W(0, 1041442545, -1103090149, 1042807746, 1024468200)
		 + W(1, -1106882536, 1049721332, -1101888878, 1042454319)
		 + W(2, 1031361481, 1026538936, -1101400314, 1034898060)
		 + W(3, -1103132501, -1112916420, -1139074135, -1110788513)
		 + W(4, 1056936890, 1055470587, 1060963845, 1061353486) + W(5, 1063510555, 1048946651, 1054541302, 1058321972)
		 + W(6, -1090353464, -1090262005, -1096383728, -1078114170)
		 + W(7, -1106902698, -1088793180, -1098771630, -1093460753)
		 + W(8, -1122143798, -1101092681, 1031723710, -1122232454)
		 + W(9, 1043143621, -1172995470, 1032268200, -1104729748)
		 + W(10, 1007942615, 1040474995, -1103896066, 1027975174)
		 + W(11, 1030475455, -1101011290, 1044176219, -1108198577);
	sum2 = W(0, 1015674059, 1034996578, 1026624942, -1128049054) + W(1, 999367802, 1021382702, -1124407536, 1029480964)
		 + W(2, -1109357907, 1024785272, -1129998179, -1120348186)
		 + W(3, 1048014132, -1105300006, 1046166047, -1116382211)
		 + W(4, 1031332447, 1048659656, -1108514478, 1052415888)
		 + W(5, -1105319294, -1117149322, 1010482847, -1154249511)
		 + W(6, 1066992274, 1076858856, 1078632808, 1073772904) + W(7, -1105884909, 1038594495, 1038514249, -1098756758)
		 + W(8, -1074609058, -1070866381, -1068251573, -1076608801)
		 + W(9, -1103939197, -1109221944, -1098022157, -1125235504)
		 + W(10, 1048304191, 1030261153, -1098508369, -1108782845)
		 + W(11, 1048310856, 1031934850, 1046147873, 1038709270);
	WS(-1084008748, -1076428689);
	sum1 = W(0, 995293936, -1162911689, -1138016718, -1132274729)
		 + W(1, -1145295444, -1131268254, -1201649403, -1135278623)
		 + W(2, -1119372516, 1036299874, 1017340780, 1041960361) + W(3, 1044385332, 1034368866, 1043013720, -1103541652)
		 + W(4, -1088304948, -1097059736, -1085861109, -1081600491)
		 + W(5, -1083799507, -1090459925, -1104403080, -1103180426)
		 + W(6, 1059786207, 1051547992, 1060565598, 1064118968) + W(7, 1058261310, 1050466917, 1049921019, 1042671596)
		 + W(8, -1137964103, -1125552990, -1116363658, -1116908178)
		 + W(9, -1119006543, 1026422690, -1131911306, 1051353751)
		 + W(10, 1013109895, 1006687204, 1002349741, 1007519945)
		 + W(11, 994300076, -1119097260, -1123993357, 1023041036);
	sum2 =
		W(0, 1033856632, 1041148647, -1094518814, 1045521814) + W(1, -1128266986, 1033117136, -1173165821, 1041230368)
		+ W(2, -1090933982, -1094617784, -1122277735, 1062250596)
		+ W(3, 1027053741, 1050179515, 1033890948, -1086799133) + W(4, 1068958128, 1066199400, 1055138982, -1070105649)
		+ W(5, -1070096660, -1082392713, 1067349236, 1076979077)
		+ W(6, 1067844920, -1102124443, 1051248434, -1078683071)
		+ W(7, -1079091570, -1089309992, 1047411220, 1070525583)
		+ W(8, -1095515318, -1122244574, 1036900546, 1046136146) + W(9, 1021983978, 1045719314, 1050937215, -1091587052)
		+ W(10, -1124923033, 1042779533, -1103088355, -1114411292)
		+ W(11, -1114099181, 1023274434, -1124200313, 1042022635);
	WS(-1081223670, 1021288719);
	sum1 = W(0, 1011016529, -1123721507, 1017381041, 1017648243) + W(1, 1028006000, -1122128468, 1009660876, 1007983923)
		 + W(2, 1035837139, 1032041909, -1108640782, 1024313608)
		 + W(3, -1105590117, -1108791100, -1128783630, -1116825572)
		 + W(4, 1042651768, 1036928499, 1055254255, 1061777248) + W(5, 1061429156, 1052534382, 1049990152, 1053483289)
		 + W(6, -1098433890, -1100608474, -1094722148, -1083909329)
		 + W(7, -1087617676, -1091388554, -1104773376, -1093454083)
		 + W(8, -1129696110, 1024607124, -1131079071, 1047474926)
		 + W(9, 1036831026, 1033276873, -1150770463, 1005912461) + W(10, 995272815, 1027549342, -1116321147, 1017435439)
		 + W(11, -1122084432, -1139273509, 1024807730, -1125665142);
	sum2 = W(0, 1057380038, 1057597982, 1069621581, 1060801069) + W(1, 1060050844, 1041938366, -1122435905, 1024344515)
		 + W(2, -1088994983, -1085734595, -1072283812, -1079782207)
		 + W(3, -1081640783, 1046270010, -1113922524, 1043446590) + W(4, 1016685185, 983594263, 1066773393, 1060848632)
		 + W(5, 1043641192, -1105013658, -1104981345, -1105295106)
		 + W(6, 998662038, 1031174835, -1099503122, -1097910780) + W(7, 1038323247, 1026094487, 1036576275, -1145544806)
		 + W(8, 1040844632, -1116219635, -1134907857, 1027931069)
		 + W(9, -1111695032, 1047921746, -1114519002, 1032973176)
		 + W(10, 1027712021, -1109851055, 1037507283, -1116080368)
		 + W(11, -1123552119, 1028446195, -1108250726, 1031771441);
	WS(-1120405176, 1052288640);
	sum1 =
		W(0, -1136485047, -1120969533, 1032711321, 1027237267) + W(1, 1021305874, -1146847086, -1133175986, 1039673939)
		+ W(2, 1040656325, 1013423883, -1108004548, -1107763377) + W(3, 1022040031, 1040265357, 1031093856, -1100629595)
		+ W(4, 1051431647, 1042796768, 1062809491, 1060861813) + W(5, 1027813500, -1107918083, 1039657966, 1043412169)
		+ W(6, -1114886102, -1092939904, -1083705303, -1089040632)
		+ W(7, 1039332409, -1098943929, -1112315213, -1104541036)
		+ W(8, -1113721480, 1039390695, 1026161897, -1116341945)
		+ W(9, -1108229347, 1035322940, -1115465454, -1114748782)
		+ W(10, -1115542032, -1165530871, 1020434857, 1024821617)
		+ W(11, 1031183209, 1019272038, 1024346473, 1012723731);
	sum2 =
		W(0, 1032873736, -1106233681, 1036788040, 1009987037) + W(1, -1117147579, 1018109057, -1114508674, -1106556966)
		+ W(2, -1128467212, -1131275971, -1113770947, -1088748320)
		+ W(3, -1097209973, 1040210251, -1099376356, 1050939532)
		+ W(4, -1098460251, 1035809416, -1078975662, 1062703231) + W(5, 1059662245, -1110493560, 1052516052, 992650581)
		+ W(6, 1024553592, -1114616785, -1092555656, 1067981395) + W(7, 1058574054, -1103422592, 1038056552, 1026754378)
		+ W(8, 1047433570, 1026776904, -1132131619, -1104531393)
		+ W(9, -1106248497, -1125640736, -1107638185, -1107493388)
		+ W(10, -1128334191, -1107845863, 1043173677, -1111351589)
		+ W(11, 991598885, -1107997815, 1023829740, -1106870741);
	WS(1050656983, 1072047790);
	sum1 = W(0, -1128713579, 1026709637, 1023201012, 1030859291)
		 + W(1, 1041237492, -1152997210, -1155686725, 1040488948)
		 + W(2, 1048792739, 1034799517, 1014670385, -1116111658) + W(3, 1025355287, -1112906461, 1036463444, 1002270506)
		 + W(4, 1050333168, 1050171449, 1053203577, 1064066450) + W(5, 1060032700, 1050694506, 1053095469, 1046913707)
		 + W(6, -1097949975, -1104033571, -1085647978, -1080119690)
		 + W(7, -1088145917, -1088560507, -1105136840, -1093840327)
		 + W(8, -1101689274, 1036522731, -1115538280, 1043957990)
		 + W(9, 1037919995, -1120212113, 1035379762, -1108210918)
		 + W(10, -1127716817, 1037025856, -1116963676, -1112813084)
		 + W(11, 1036783049, -1113565993, 1035776666, -1122514141);
	sum2 =
		W(0, 1032121925, -1105031648, -1130820039, -1105961083) + W(1, 1040237041, -1091675607, 1052906990, -1119953618)
		+ W(2, 1067037293, 1072414374, 1072723545, 1076922042) + W(3, 1072846596, -1079373087, 1048404715, -1090018360)
		+ W(4, -1074821338, -1081225596, -1069168235, -1068908234)
		+ W(5, 1068735095, 1050158994, 1043049709, 1036354441) + W(6, -1094551116, 1050387420, 1050306407, -1080768789)
		+ W(7, -1110799161, 1048692149, 1039557097, -1114340558) + W(8, 1045030197, 1035683027, 1054464199, -1129129027)
		+ W(9, -1109242003, -1102086715, 1050068036, -1106557101)
		+ W(10, -1115959604, -1117669800, -1109697271, -1106200850)
		+ W(11, 1041008693, -1107790175, 1019897614, 1034398799);
	WS(-1081468886, 1041730784);
	sum1 = W(0, -1114247594, 999910687, -1112649805, 1022168820) + W(1, 1009392321, 1025791509, -1115410306, 1020540891)
		 + W(2, 1021500053, 1042624634, 1043096639, 1034747044) + W(3, -1103886814, -1101453262, 1026735815, 1034256626)
		 + W(4, 1028761377, 1005300019, -1100727404, 1035906940) + W(5, 1062898916, 1054732110, 1042621601, 1041116931)
		 + W(6, 1044129269, 1053438789, 1055682820, -1086991443)
		 + W(7, -1084075064, -1098009154, -1097832968, -1117544535)
		 + W(8, -1131183895, -1096850135, -1106832988, 1038040260)
		 + W(9, 1044548897, 1037861846, 1022910341, -1121491970)
		 + W(10, -1121682823, 1029411807, 1022343799, -1113521452)
		 + W(11, -1110992968, -1110478453, -1125653940, -1112646442);
	sum2 = W(0, -1109856908, 995541592, -1107331629, 1043476326)
		 + W(1, -1104942022, 1039471517, -1114856041, 1022399907) + W(2, 1025315462, 1040254152, 1035675473, 1026228130)
		 + W(3, -1101803200, -1123010638, 1040268905, 1028920354)
		 + W(4, -1111613060, 997512408, -1115826672, 1067108106)
		 + W(5, 1053887552, -1104388416, -1120685867, -1103458923)
		 + W(6, -1108093549, -1085520225, -1103361463, 1059978555)
		 + W(7, -1094292172, -1120534147, -1108094032, 1040596394)
		 + W(8, 1041489120, -1094645099, -1102705141, -1121534122)
		 + W(9, 1039802977, 1017265579, 1040793483, -1107135380)
		 + W(10, -1114414815, 1040714423, -1125997775, 1032256197)
		 + W(11, -1130615251, -1129091643, -1108206349, 1027593934);
	WS(1054796503, -1111794816);

	return clamp(mstd0 + 5.0 * vsum / wsum * mstd1, 0.0, 1.0);
}

shared float inp[555];

#define CURRENT_PASS 2

#define GET_SAMPLE(x) dot(x.rgb, rgb2y)
#define imageStore(out_image, pos, val) imageStoreOverride(pos, val.x)
void imageStoreOverride(uint2 pos, float value) {
	float2 UV = mul(rgb2uv, INPUT.SampleLevel(sam_INPUT_LINEAR, HOOKED_map(pos), 0).rgb);
	OUTPUT[pos] = float4(mul(yuv2rgb, float3(value.x, UV)), 1.0);
}

#define INPUT_tex(pos) GET_SAMPLE(vec4(texture(INPUT, pos)))
static const float2 INPUT_size = float2(GetInputSize());
static const float2 INPUT_pt = float2(GetInputPt());

#define temp_tex(pos) (float(texture(temp, pos).x))
static const float2 temp_size = float2(GetInputSize().x * 1, GetInputSize().y * 2);
static const float2 temp_pt = float2(1.0 / (temp_size.x), 1.0 / (temp_size.y));

#define HOOKED_tex(pos) temp_tex(pos)
#define HOOKED_size temp_size
#define HOOKED_pt temp_pt

void Pass2(uint2 blockStart, uint3 threadId) {
	ivec2 group_base = ivec2(gl_WorkGroupID) * ivec2(gl_WorkGroupSize);
	int local_pos = int(gl_LocalInvocationID.x) * 15 + int(gl_LocalInvocationID.y);
	for (int id = int(gl_LocalInvocationIndex); id < 555; id += int(gl_WorkGroupSize.x * gl_WorkGroupSize.y)) {
		uint x = (uint)id / 15, y = (uint)id % 15;
		inp[id] =
			HOOKED_tex(HOOKED_pt * vec2(float(group_base.x + x - (2)) + 0.5, float(group_base.y + y - (3)) + 0.5)).x;
	}
	barrier();
	vec4 ret = vec4(0.0, 0.0, 0.0, 0.0);
	vec4 ret0 = vec4(0.0, 0.0, 0.0, 0.0);
	vec4 samples[12];
	samples[0][0] = inp[local_pos + 0];
	samples[0][1] = inp[local_pos + 1];
	samples[0][2] = inp[local_pos + 2];
	samples[0][3] = inp[local_pos + 3];
	samples[1][0] = inp[local_pos + 4];
	samples[1][1] = inp[local_pos + 5];
	samples[1][2] = inp[local_pos + 6];
	samples[1][3] = inp[local_pos + 7];
	samples[2][0] = inp[local_pos + 15];
	samples[2][1] = inp[local_pos + 16];
	samples[2][2] = inp[local_pos + 17];
	samples[2][3] = inp[local_pos + 18];
	samples[3][0] = inp[local_pos + 19];
	samples[3][1] = inp[local_pos + 20];
	samples[3][2] = inp[local_pos + 21];
	samples[3][3] = inp[local_pos + 22];
	samples[4][0] = inp[local_pos + 30];
	samples[4][1] = inp[local_pos + 31];
	samples[4][2] = inp[local_pos + 32];
	samples[4][3] = inp[local_pos + 33];
	samples[5][0] = inp[local_pos + 34];
	samples[5][1] = inp[local_pos + 35];
	samples[5][2] = inp[local_pos + 36];
	samples[5][3] = inp[local_pos + 37];
	samples[6][0] = inp[local_pos + 45];
	samples[6][1] = inp[local_pos + 46];
	samples[6][2] = inp[local_pos + 47];
	samples[6][3] = inp[local_pos + 48];
	samples[7][0] = inp[local_pos + 49];
	samples[7][1] = inp[local_pos + 50];
	samples[7][2] = inp[local_pos + 51];
	samples[7][3] = inp[local_pos + 52];
	samples[8][0] = inp[local_pos + 60];
	samples[8][1] = inp[local_pos + 61];
	samples[8][2] = inp[local_pos + 62];
	samples[8][3] = inp[local_pos + 63];
	samples[9][0] = inp[local_pos + 64];
	samples[9][1] = inp[local_pos + 65];
	samples[9][2] = inp[local_pos + 66];
	samples[9][3] = inp[local_pos + 67];
	samples[10][0] = inp[local_pos + 75];
	samples[10][1] = inp[local_pos + 76];
	samples[10][2] = inp[local_pos + 77];
	samples[10][3] = inp[local_pos + 78];
	samples[11][0] = inp[local_pos + 79];
	samples[11][1] = inp[local_pos + 80];
	samples[11][2] = inp[local_pos + 81];
	samples[11][3] = inp[local_pos + 82];
	ret[0] = nnedi3(samples);
	ret0[0] = inp[local_pos + 33];
#if CURRENT_PASS == LAST_PASS
	uint2 destPos = blockStart + threadId.xy * 2;
	uint2 outputSize = GetOutputSize();
	if (destPos.x >= outputSize.x || destPos.y >= outputSize.y) {
		return;
	}
#endif
	imageStore(out_image, ivec2(gl_GlobalInvocationID) * ivec2(2, 1), ret0);
	imageStore(out_image, ivec2(gl_GlobalInvocationID) * ivec2(2, 1) + ivec2(1, 0), ret);
}
