// This file is generated by the scripts available at https://github.com/hauuau/magpie-prescalers
// Please don't edit this file directly.
// Generated by: nnedi3.py --nns 64 --win 8x6 --use-compute-shader --use-magpie
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

//!MAGPIE EFFECT
//!VERSION 4
//!SORT_NAME NNEDI3_064_6

//!TEXTURE
Texture2D INPUT;

//!SAMPLER
//!FILTER POINT
SamplerState sam_INPUT;

//!TEXTURE
//!WIDTH  INPUT_WIDTH * 1 * 2
//!HEIGHT INPUT_HEIGHT * 2 * 1
Texture2D OUTPUT;

//!SAMPLER
//!FILTER LINEAR
SamplerState sam_INPUT_LINEAR;

//!TEXTURE
//!FORMAT R16_FLOAT
//!WIDTH  INPUT_WIDTH * 1
//!HEIGHT INPUT_HEIGHT * 2
Texture2D temp;

//!SAMPLER
//!FILTER POINT
SamplerState sam_temp;

//!COMMON
#include "prescalers.hlsli"

#define LAST_PASS 2

//!PASS 1
//!DESC NNEDI3 (double_y, nns64, win8x6)
//!IN INPUT
//!OUT temp
//!BLOCK_SIZE 32, 16
//!NUM_THREADS 32, 8
#pragma optionNV(inline none)
float nnedi3(vec4 samples[12]) {
	float sum = 0.0, sumsq = 0.0;
	[unroll] for (int i = 0; i < 12; i++) {
		sum += dot(samples[i], vec4(1.0, 1.0, 1.0, 1.0));
		sumsq += dot(samples[i], samples[i]);
	}
	float mstd0 = sum / 48.0;
	float mstd1 = sumsq / 48.0 - mstd0 * mstd0;
	float mstd2 = mix(0.0, inversesqrt(mstd1), mstd1 >= 1.192092896e-7);
	mstd1 *= mstd2;
	float vsum = 0.0, wsum = 0.0, sum1, sum2;
#define T(x) intBitsToFloat(x)
#define W(i, w0, w1, w2, w3) dot(samples[i], vec4(T(w0), T(w1), T(w2), T(w3)))
#define WS(w0, w1)                                                                                                     \
	sum1 = exp(sum1 * mstd2 + T(w0));                                                                                  \
	sum2 = sum2 * mstd2 + T(w1);                                                                                       \
	wsum += sum1;                                                                                                      \
	vsum += sum1 * (sum2 / (1.0 + abs(sum2)));
	sum1 =
		W(0, -1120714617, 1035162146, -1110752415, -1121818163) + W(1, 1035961863, -1120878363, 1007614003, -1123901891)
		+ W(2, 1046176310, -1105876799, 1034124059, -1120533037)
		+ W(3, -1123305414, 1027364554, -1114390527, -1096860741)
		+ W(4, 1022953826, -1155422496, 1009908268, 1030225939) + W(5, -1110762423, 1046191054, 1023450788, -1124524780)
		+ W(6, -1129324172, -1116882705, 1032526991, 1043289735)
		+ W(7, -1114841418, -1129613106, -1121901526, 1030599214)
		+ W(8, -1096831458, 1052908756, -1114991488, 1013731840)
		+ W(9, 1022915304, -1135846624, -1117077507, 1034530771)
		+ W(10, -1116257712, 981289536, -1142748844, -1113117446)
		+ W(11, -1127767760, 1039462233, 1025047056, -1143328976);
	sum2 =
		W(0, -1131108965, 1043465638, 988544780, -1145266179) + W(1, 1018501507, 1021344415, 1000650931, -1113612493)
		+ W(2, -1124179817, -1111438835, 1003301507, -1131299129)
		+ W(3, 1025688791, -1106748353, -1070139293, -1110118136)
		+ W(4, 1026178295, -1123696315, -1116852534, 1029599173)
		+ W(5, -1102659167, -1097100047, 1031198431, 1012522521) + W(6, -1145056307, 1045881517, 1078104617, 1027449515)
		+ W(7, -1123515159, 1024975831, -1123043594, -1118230687)
		+ W(8, 1048052425, 1027739737, -1134523125, 1020199127) + W(9, 1018436747, 1029259867, -1126127905, -1136112041)
		+ W(10, 995063942, -1162666156, -1139914565, -1107504809)
		+ W(11, 1025133515, 1036504803, -1120319069, -1131042995);
	WS(1061710334, -1113637247);
	sum1 = W(0, -1121814583, 1036106897, -1109309294, -1143950978)
		 + W(1, 1033251382, -1118153848, -1138603692, -1122595552)
		 + W(2, 1048694647, -1103580007, 1032154570, -1122508490)
		 + W(3, -1138264845, 1018454510, 1030681928, -1097890158)
		 + W(4, 1019050396, 1012933309, -1140194465, 1033737112)
		 + W(5, -1115559686, -1120177173, 1021617155, -1120902675)
		 + W(6, -1131439046, -1122735662, 1044326142, 1042373458)
		 + W(7, -1113884080, -1152998244, -1125621862, 1024541667)
		 + W(8, -1097437158, 1052689231, -1107957310, 1016843898)
		 + W(9, 1023073058, -1122620661, -1132933761, 1034486114)
		 + W(10, -1116304653, -1144273714, -1129805541, -1116003130)
		 + W(11, -1128614666, 1037961704, 1019245786, -1155701620);
	sum2 = W(0, -1162960213, -1107084454, -1126626424, 1025411499)
		 + W(1, -1126548940, -1127269937, 1013908203, 1023868855) + W(2, 1032930462, 1029914487, 997665611, 1018748433)
		 + W(3, -1113327157, 1032525526, 1076098019, 1035900190)
		 + W(4, -1121182801, -1158385717, 1023571595, 1048796624)
		 + W(5, -1132699465, -1093496445, 1038561302, 1000017309)
		 + W(6, -1133790043, -1104878976, -1072747140, 1026052839)
		 + W(7, -1146184997, -1123007653, 1024139725, 1003078933)
		 + W(8, -1104764998, -1109617402, -1142783113, -1154085627)
		 + W(9, -1130037920, -1121062518, 1019199125, 1025857863)
		 + W(10, -1147685381, 1000677165, 1007034787, 1034207166)
		 + W(11, -1123497947, -1118139493, 1017680405, 1016687665);
	WS(1064800702, 1030635520);
	sum1 =
		W(0, 1004285524, -1128056492, 1035663048, -1110660706) + W(1, -1128734654, 1028175148, -1122860750, 1024005652)
		+ W(2, 1031878036, -1116831438, -1204558974, -1143857649) + W(3, -1122286551, 1035530413, 984521208, 1023270757)
		+ W(4, -1136886024, 1005008153, 1021316024, 1053335517) + W(5, -1100061872, -1093549817, 1042579293, 1016449422)
		+ W(6, -1116388951, -1139373960, 1048911707, -1104621327)
		+ W(7, -1148999845, -1135015336, 1022533838, -1130762670)
		+ W(8, 1035194194, -1149876978, -1142259845, 1010510404)
		+ W(9, -1125657162, -1121564617, -1131931048, -1142066105)
		+ W(10, -1120920449, 1018152308, 1001429301, -1129213371)
		+ W(11, -1141986761, 1031904066, -1111776529, 1020350678);
	sum2 =
		W(0, 1015139874, -1120731382, 1017539382, 1020112270) + W(1, -1126248934, 1013963196, -1150118671, -1116737087)
		+ W(2, 1031888972, -1112637962, 1010207212, -1138130380) + W(3, 1032711786, -1087320828, 1059502015, 1026899401)
		+ W(4, -1119882792, 1019091922, 1028577839, -1069693959)
		+ W(5, 1078824499, -1094071548, 1040940327, -1123861886)
		+ W(6, -1116703472, -1103666133, 1045823576, 1036639812)
		+ W(7, -1131804892, 1004924552, -1123435694, -1138801588)
		+ W(8, 1009232228, -1114441289, 1029410629, -1130443436) + W(9, -1140098908, 999422392, 1011539428, 1023067274)
		+ W(10, -1130083750, -1137456436, -1140019692, 1029210329)
		+ W(11, -1118193829, -1131442506, 1007549476, 1026106777);
	WS(1058942782, 1023618692);
	sum1 = W(0, -1126072821, 1041771492, -1110777188, -1110871838)
		 + W(1, 1036426764, -1142526755, 1011693912, 1025548876) + W(2, 1035801072, 1043278082, -1146527995, 1015953709)
		 + W(3, 1017195423, 1036961985, -1094081945, -1103634941)
		 + W(4, 1046715887, -1148709083, -1122268692, 1037536142)
		 + W(5, -1091452759, -1105679152, 1040286827, -1119884351)
		 + W(6, 1022607903, 1038780013, -1095962376, -1103558179) + W(7, 1049101574, -1122534754, 982545387, 1023558139)
		 + W(8, 1049096396, -1130619215, 1031851588, 1007174309)
		 + W(9, -1126061755, 1037537425, -1113879430, -1136949949)
		 + W(10, 1002869195, 1017517093, 1003763447, 1035261291) + W(11, 955835050, 1026350907, 1006549707, 986004587);
	sum2 =
		W(0, -1128639222, 1001638233, -1119841411, 1014385869) + W(1, 986023269, -1135260845, -1150616818, 1013509397)
		+ W(2, 1029376723, 1037911199, 970306708, 1013815957) + W(3, -1118932607, 1035428655, 1019940778, -1102461584)
		+ W(4, -1141011097, 959170344, -1125568566, 1024255335) + W(5, 1063260126, -1085129330, -1110526300, 1017551658)
		+ W(6, 991022546, 1031481278, 1032753418, -1110003004) + W(7, 1033244979, 1016351942, -1129687950, -1111645244)
		+ W(8, 1026999545, 1019019978, -1121764803, -1127392454) + W(9, 1018120650, 1028380841, -1121385219, 1021463302)
		+ W(10, 1025283273, 1009569613, 1006676397, -1115817479)
		+ W(11, -1134958989, 1017625850, -1128128990, -1138867245);
	WS(1037837808, 1056377428);
	sum1 = W(0, -1135573495, -1105969090, 1027945538, 1043223694)
		 + W(1, -1100584037, 1025656415, 1023727061, -1138454045)
		 + W(2, -1116105371, 1039709953, -1111027805, 1021082723)
		 + W(3, -1118803082, -1114548551, -1126955510, 1051232418)
		 + W(4, -1097887999, 1018764077, -1123500111, 1046351686)
		 + W(5, -1122693874, -1100833583, 1040497066, -1115071549)
		 + W(6, 1020600341, 1036383371, 1053007142, -1103740252) + W(7, 1024768136, 1025234525, -1111066541, 1034647805)
		 + W(8, 1035274060, -1101618713, -1138012047, -1116333124)
		 + W(9, 1008936161, 1026657308, -1156882549, 1033814037)
		 + W(10, -1123286772, 1016891995, -1115286797, 1033474888)
		 + W(11, -1122516460, -1129756781, 1010716753, -1114238799);
	sum2 = W(0, 1020978875, -1100967324, 1043179705, 1026290891)
		 + W(1, 1013196277, -1138979633, -1121670462, -1130583533)
		 + W(2, -1122981488, 1032797386, -1120286641, 966672716)
		 + W(3, -1103298336, -1096736455, 1062358565, -1104401130)
		 + W(4, -1114052290, -1152672163, -1110731474, 1053186254)
		 + W(5, -1112891412, -1091109944, 1048200412, -1122242747)
		 + W(6, -1105136733, 1045958215, 1031005462, -1133705481)
		 + W(7, -1113847816, 1023845499, -1119790394, 1043729632)
		 + W(8, 1033523405, -1102472853, 1033631266, -1118586102)
		 + W(9, -1127100056, 1033816035, -1109547546, 1031959215)
		 + W(10, -1126209517, -1147194793, 999102475, 1020355333)
		 + W(11, -1122874410, -1122532081, 1027184816, -1127245018);
	WS(1050865148, 1032626572);
	sum1 = W(0, -1110436993, 1043627312, -1118552440, 1045700875)
		 + W(1, -1115060612, 1040430485, 1040042556, -1101476879)
		 + W(2, -1108049256, 1033317691, 1031191472, -1096410465)
		 + W(3, -1107890608, 1049906138, -1107535228, -1115480133)
		 + W(4, 1025393771, 1042925123, -1113356418, -1109025830)
		 + W(5, -1162779891, 1049713062, -1106727656, -1114330616)
		 + W(6, 1034032544, -1120749707, -1095271743, 1042738346)
		 + W(7, -1127443770, -1106585845, -1105712244, 1051482110)
		 + W(8, 1035225158, -1122810712, 1039553933, 1042770518) + W(9, 999321197, -1103830356, -1104074479, 1050825756)
		 + W(10, -1104755066, -1103219825, -1110201208, 1048543054)
		 + W(11, -1106449960, 1031488492, 1040395170, 1009713998);
	sum2 =
		W(0, 1024944996, -1111924540, -1107012648, 1057346437) + W(1, -1105023593, -1097010076, 1020193961, 1007347355)
		+ W(2, 1049541488, 1054940943, -1097277462, -1107952444)
		+ W(3, 1014966838, -1116539066, -1107447750, 1059914271)
		+ W(4, -1142156696, -1085761230, 1015828472, 1012341552)
		+ W(5, -1109770505, 1066972918, 1043445868, -1078926120)
		+ W(6, -1113612636, 1034050704, -1111197863, 1063973493)
		+ W(7, 1017043379, -1084679416, 1032934706, -1113193567)
		+ W(8, 1014122612, 1056333532, -1118781870, -1092348708) + W(9, -1116105943, 1042584092, 1016467631, 1045837843)
		+ W(10, -1113967259, -1128370702, 1021395599, -1116104243)
		+ W(11, -1135977693, 1043326701, -1117573943, -1108363561);
	WS(1054811644, 1027249161);
	sum1 =
		W(0, 1040940111, -1101358582, -1113576073, 1049141881) + W(1, -1132483205, -1116754862, -1100243090, 1036221579)
		+ W(2, 1038054901, -1105999252, -1104538698, 1037145120) + W(3, 1043481462, 1014943347, -1097482896, 1051960356)
		+ W(4, 1036681666, -1118995685, -1119365790, -1109150355)
		+ W(5, -1106696288, 1048275427, -1123112824, -1126689554)
		+ W(6, -1111878381, 1036687602, 1022736646, -1118345360) + W(7, 1019000333, 1038634998, 1044780378, -1109759237)
		+ W(8, -1097940765, 1049145430, 1044474573, -1101292557)
		+ W(9, -1101638738, 1028424107, 1038478827, -1113101949)
		+ W(10, -1103799553, 1034438878, 1035929492, -1122643648)
		+ W(11, -1103674991, 1037909315, 1037239602, -1126283866);
	sum2 = W(0, 1023766557, 1016554458, 1021815988, -1137435361) + W(1, -1114856427, 1032032312, 1015306072, 1020144724)
		 + W(2, -1103467660, 1016553974, 1044555388, -1105991725)
		 + W(3, -1136376403, -1116988904, 1034521268, 1060795535)
		 + W(4, -1088370625, -1127777881, -1113107482, 1050162106)
		 + W(5, -1102546407, 1075503478, -1071164689, 1035804901)
		 + W(6, 1038494252, -1104347057, -1103257907, 1072821349)
		 + W(7, -1077590614, -1120944929, -1113447013, 1003678517)
		 + W(8, 1025406308, -1113972415, -1112563255, 1036418439)
		 + W(9, 1023629411, 1033762395, -1113239746, 1031283975)
		 + W(10, 995356642, -1123929939, 1024784188, -1109441777)
		 + W(11, 1026085595, 1037416902, -1112537357, -1140753514);
	WS(1055940220, -1124188157);
	sum1 =
		W(0, -1113999823, -1119569210, 1015781094, -1147977024) + W(1, -1117684995, -1108336232, 1015763751, 1043278990)
		+ W(2, -1106256755, 1046188556, 1036478965, 1006648968) + W(3, -1115168029, -1094609330, 1052603679, 1041916962)
		+ W(4, 1033522483, -1101485874, 1022861696, 1044340802)
		+ W(5, -1095339972, -1108128054, 1047885622, -1110457109)
		+ W(6, -1114461725, 1033154083, -1108564239, 1057380776)
		+ W(7, 1036635468, -1114614567, -1113117029, -1106205123)
		+ W(8, 1042723938, -1095928258, 1035899866, -1108232826) + W(9, 1032164308, 1021089498, -1125646960, 1041299799)
		+ W(10, -1139371156, 1034599135, -1121800074, -1107756257)
		+ W(11, -1171638077, 1027517543, -1131185034, -1115299047);
	sum2 =
		W(0, -1120118804, -1136369034, -1127959037, 1015341014) + W(1, 1033327798, -1113602386, 1013270421, 1027353114)
		+ W(2, -1129939889, 1034464346, 1041751325, -1114857235)
		+ W(3, -1120552641, -1125884733, -1117793827, -1117887441)
		+ W(4, 1049619624, -1103868602, -1117027367, 1035518448)
		+ W(5, -1095769137, 1043338219, 1049093640, -1097589990) + W(6, 1016254148, 1043285424, -1095274849, 1049861339)
		+ W(7, 1048627700, -1105817123, -1110780393, -1129166063)
		+ W(8, -1117623897, -1128474295, 1035712363, -1106207094)
		+ W(9, 1030787932, -1140216380, -1128598589, 1032330618)
		+ W(10, 1035384499, 1004274322, -1133117880, -1120569751)
		+ W(11, -1129927717, 1018695247, 1027229852, -1120123842);
	WS(1057163582, 1025817537);
	sum1 =
		W(0, 1037167835, 1031655825, -1096271953, 1045084224) + W(1, 1033520525, 1016078798, -1121852313, 1046829204)
		+ W(2, -1093143228, 1046279122, -1103697416, 1030441081) + W(3, 1034559945, 1038865075, -1085198281, 1057074420)
		+ W(4, -1107583934, 1036548879, 1027044951, 987855837) + W(5, 1050118415, 1040167170, 1024989936, 974934139)
		+ W(6, 1039868489, -1105739319, 1057217669, -1086525384) + W(7, 1034776664, 1034922130, 1037598609, -1112419405)
		+ W(8, 1047779928, -1087515051, 1044254259, -1113468278) + W(9, 1007581568, 1015381448, 1035805671, -1098926044)
		+ W(10, -1134624240, 1036139674, 1031626785, 1037495244)
		+ W(11, 1015872616, -1124461564, -1113253902, 1017385676);
	sum2 = W(0, -1136384493, 1036526786, 1028719631, -1123632092)
		 + W(1, -1145098603, -1122280548, 1023814631, -1099879539)
		 + W(2, 1030342243, 1043747658, -1102737141, -1130733945) + W(3, 1033659202, 1034332004, 1046758826, 1050427835)
		 + W(4, -1112406001, 1014543213, 1017810163, 1013925981)
		 + W(5, -1093436173, -1100447595, -1119158797, -1123106681)
		 + W(6, 1009967381, -1106516740, 1051870663, 1041231786) + W(7, 1034292458, 1019870319, 1017781727, -1101585218)
		 + W(8, 1042788701, 1045006578, -1107586767, 1013053757)
		 + W(9, -1118180802, -1131784625, -1114786901, 1010389989)
		 + W(10, -1143106923, -1119739637, -1141961139, -1112082470)
		 + W(11, -1113417628, -1117114477, 1032164569, 1012643781);
	WS(-1081763615, -1092598780);
	sum1 = W(0, -1130922677, -1114318275, -1127997567, 1028467828)
		 + W(1, 1023598927, -1139280241, -1122514966, 1026414532)
		 + W(2, -1121576984, -1127358845, 1017010415, 1002425203)
		 + W(3, -1136114845, 1017564438, -1088500870, 1061837768)
		 + W(4, -1116904946, -1123987795, 1015393433, 1021344041)
		 + W(5, -1098266094, 1035926493, 1037585875, -1136160989)
		 + W(6, -1137786397, -1095352826, 1061435536, -1095349722)
		 + W(7, 1040151266, -1131570741, 1023447063, -1116164091)
		 + W(8, -1148866211, -1114585584, 1031742785, -1116123969)
		 + W(9, -1142668459, -1123782681, 1039772482, -1114677716)
		 + W(10, 1007413957, 1020007637, -1140705115, 1012849463)
		 + W(11, 1024002537, -1116920883, -1128808099, -1126849079);
	sum2 =
		W(0, 1021958137, 1034408685, -1106091708, -1098486326) + W(1, 1028745769, 1024682325, -1117837187, 1036094407)
		+ W(2, -1147105428, -1110159069, 1031154711, -1116910593)
		+ W(3, 1026312941, 1033683959, -1094093059, -1088187103)
		+ W(4, -1105512708, 1039406737, -1115513274, -1124949158)
		+ W(5, 1061646324, 1055280585, -1100598283, -1117359799) + W(6, 1037370871, -1091894288, 1058519893, 1045036050)
		+ W(7, -1109806227, 1026080301, -1112242113, 1027011647)
		+ W(8, -1106569597, 1045721104, -1117345257, -1117139296)
		+ W(9, 1033686533, -1107943508, 1037199097, 1034325435) + W(10, -1144974476, 991455177, -1107052036, 1010459130)
		+ W(11, 1030945863, 1039418143, -1124920152, -1112397476);
	WS(1049187708, 1061143407);
	sum1 = W(0, 1032206028, 1046469409, 1044620591, -1086760535) + W(1, 1049164066, 1022165171, -1121811767, 1033070593)
		 + W(2, 1020031147, -1113096094, -1132628435, 1009114287)
		 + W(3, 1032297330, 1049873346, -1111788011, -1092765627)
		 + W(4, 1051671486, 1034535880, -1136528167, 1050639650)
		 + W(5, -1089881571, -1083700943, 1044844041, 1024964917)
		 + W(6, 1005295654, 1041319460, -1127219501, -1092202425) + W(7, 1037004161, 1011091807, 1031846890, 1041542033)
		 + W(8, 1033106537, 1011207027, 1026161438, 1038185039) + W(9, -1136496587, 1036329419, 991465499, 1015330121)
		 + W(10, -1134373563, 1018308239, 1032778794, 1043869975)
		 + W(11, -1112918515, 1026637361, 1019220893, 1032129132);
	sum2 =
		W(0, -1123557888, 1024038368, 964997605, -1123190992) + W(1, -1170950771, 1009594487, -1139662759, 1022314468)
		+ W(2, 1007232143, 1040909663, -1119781676, 1011035391) + W(3, -1120649660, 1016353740, -1112234110, 1035500288)
		+ W(4, -1122589660, -1122952928, 1021700488, -1149024430) + W(5, 1052797849, 1059925772, 1021322900, 1015425876)
		+ W(6, -1119215196, -1127462832, 1032636001, -1123381020)
		+ W(7, -1124742672, 1024335912, 1025758640, -1109226016)
		+ W(8, -1096670151, -1110751472, 1037872214, -1115520552)
		+ W(9, -1134635263, 1022909500, -1103246759, -1114698588)
		+ W(10, -1123038904, 1026100870, 1025396502, -1106595065)
		+ W(11, -1095307242, 1016687528, 1025386190, -1128653768);
	WS(-1080960863, 1058419411);
	sum1 = W(0, -1118700722, -1111066847, 984198859, 1043965403)
		 + W(1, -1108783427, 1000248987, 1032983255, -1112208894)
		 + W(2, -1099715572, -1113907195, -1113914551, -1124179019)
		 + W(3, -1122641758, -1099579692, 1049479517, 1050672334)
		 + W(4, -1105019770, -1128328213, 1033094082, -1090459763)
		 + W(5, 1062349342, 1061713555, -1095692932, 1023738862)
		 + W(6, -1121000958, -1107128402, -1099059374, 1059583022)
		 + W(7, -1099879371, -1131329315, -1133773881, -1107276892)
		 + W(8, 1033076198, -1121054998, -1108028092, 1027231576)
		 + W(9, -1141737059, -1116550064, -1125040759, 1024684126)
		 + W(10, 1024533736, -1113801521, -1120123854, -1103159313)
		 + W(11, 1037355536, 1026513898, -1110661700, 1007580489);
	sum2 =
		W(0, 995719700, -1129327601, -1125739202, 1029045123) + W(1, 1025141617, -1154923092, -1114687459, 1021214658)
		+ W(2, 1027238209, 1037994429, -1113434302, 1007115993) + W(3, 1024240180, 997717028, -1120915257, 1036441804)
		+ W(4, 1032546636, 1003062850, -1115935924, 978476974) + W(5, -1078687396, 1066236156, 1035362808, -1118441375)
		+ W(6, 1025427056, -1140454571, -1111104335, 1022342240) + W(7, 1033358736, 1017727844, -1123062148, 1010080137)
		+ W(8, -1128218828, 1028953671, -1166615662, -1129048983) + W(9, 999440794, 1002330866, -1147995690, 1024857232)
		+ W(10, -1165027863, 1019778022, -1131128122, -1152746908)
		+ W(11, -1128526870, -1126806088, 1024563904, 1009762473);
	WS(-1082880574, -1095080656);
	sum1 =
		W(0, -1120399523, -1111736159, -1111698940, 1037879414)
		+ W(1, 1037066756, -1118524245, -1123397517, -1128373242)
		+ W(2, 1019423266, 1028697399, -1119567216, 1027581671) + W(3, -1135116544, 1025039907, -1092929515, 1062200098)
		+ W(4, -1131199446, -1139610160, -1168421181, -1127950106)
		+ W(5, -1098702381, 1023355236, 1027882718, -1139561152)
		+ W(6, -1131259136, -1098593297, 1060991762, -1094756999)
		+ W(7, 1038218895, 1005358744, 1037719400, -1106461210) + W(8, 1018082074, -1115312044, 1022591155, -1113962893)
		+ W(9, -1113348279, 1024172498, 1036669022, -1106391640)
		+ W(10, -1118950442, 1026868195, 1030740495, 1028249110)
		+ W(11, -1114016273, -1109491766, -1141634128, -1126548648);
	sum2 = W(0, 1007561151, -1106890729, -1144059530, 1010626011)
		 + W(1, -1140206187, -1152147163, -1118820752, 1031296198)
		 + W(2, -1112391017, -1114880200, -1136937433, -1120281594)
		 + W(3, -1128452386, -1110907715, 1056169840, 1052511775)
		 + W(4, 1034255225, -1114711449, -1121745985, 1032462388)
		 + W(5, -1096446085, -1094697844, 1033067226, 993102387) + W(6, -1114861795, 1035962501, 1031556034, 1056886944)
		 + W(7, -1104164393, -1120009849, -1121584151, 1035033495)
		 + W(8, 987032615, -1129701328, 1013679559, -1122813977) + W(9, -1120079456, 982365671, -1138039959, 980377326)
		 + W(10, -1115367679, -1118918686, -1129117272, 1035951051)
		 + W(11, -1119286197, -1126702674, -1137374445, 1006646323);
	WS(1058795070, 1058351276);
	sum1 =
		W(0, -1129226172, -1106246658, 1041614193, 1041522846) + W(1, -1106977045, -1140271486, 1032650784, -1132244111)
		+ W(2, 1048401911, 1041471472, 1031926461, -1130658915) + W(3, -1134152362, -1102574120, 1050141831, 1033352747)
		+ W(4, -1121658742, -1115542891, -1122312016, 1028257624)
		+ W(5, -1088102699, 1030285885, -1124591186, -1119417531)
		+ W(6, -1145265749, 1004724909, -1093353638, 1056599450)
		+ W(7, -1107883356, -1155196377, -1118796187, -1128587973)
		+ W(8, -1112285036, 1049138668, -1114299650, 1003429157)
		+ W(9, 1017891569, -1150296521, -1122892680, 1043369227)
		+ W(10, -1130730345, -1125742491, -1131365684, -1107598873)
		+ W(11, -1120116589, 1040658126, 1034850634, -1137642362);
	sum2 =
		W(0, 1018264792, -1109681111, 1028734812, -1104210606) + W(1, 1025579416, 1029305888, 1019878456, -1134735936)
		+ W(2, -1093714299, -1099909667, 1032419228, -1113499692)
		+ W(3, 1020074080, -1106212594, 1034660210, -1098896203) + W(4, 1010388000, 1025031188, -1143212320, 1037009054)
		+ W(5, 1047288883, 1060586916, 1030286292, -1130541520) + W(6, -1148803168, -1132238328, 1031452084, 1042866381)
		+ W(7, -1107165918, -1127563664, -1127882992, 1032289620)
		+ W(8, -1112028563, -1109339206, 1019446368, 1026005920) + W(9, 1017409120, 990246720, -1115169564, 1023925320)
		+ W(10, 989303425, -1123344268, -1131165168, 1004132864)
		+ W(11, 1020410832, -1112228144, 1029468412, 1009015280);
	WS(1043816952, 1056206353);
	sum1 =
		W(0, -1132948972, -1115461859, 1034684352, 1037119642) + W(1, -1107088436, -1144087781, 1024900084, -1107172113)
		+ W(2, 1038250028, 1039626815, -1110088668, -1116127087)
		+ W(3, -1150680698, -1097009915, 1061195075, -1095598055)
		+ W(4, -1113187289, -1117712852, 1016358425, -1102438229)
		+ W(5, 1051576078, 1056604231, -1102307882, -1114968828)
		+ W(6, -1160444148, 1024199571, -1088975285, 1057172865)
		+ W(7, -1103288997, -1134624362, -1115326124, -1148961467)
		+ W(8, 1010078034, 1029312608, -1122873761, 1012385158) + W(9, 1019123435, -1130723763, -1107729186, 1039764276)
		+ W(10, 1032878393, -1114736693, -1120343575, -1144998513)
		+ W(11, 1022450003, -1112740858, 1034042985, 1002559709);
	sum2 =
		W(0, -1135809827, 1031002711, -1136033931, -1114169661) + W(1, -1107967067, 1027957130, -1140675011, 1009667595)
		+ W(2, 1025543601, -1124911966, -1108557845, 1004385158)
		+ W(3, -1137384851, -1156373420, -1123691685, 1056449903)
		+ W(4, -1096033675, 1015282250, -1147988326, 1010789683)
		+ W(5, -1105219090, 1044469394, -1118550723, -1115586301)
		+ W(6, 1019754904, -1122328477, -1118075063, 1046754031)
		+ W(7, 1020360378, -1120013003, -1172160176, -1135703979)
		+ W(8, -1111692677, 1034039333, 1005574774, -1130287690) + W(9, 1006265798, 1016962928, -1131889022, 1024901767)
		+ W(10, 1025982043, -1127946498, 990940844, -1135289651)
		+ W(11, 1010975355, -1111731157, 1036125487, -1169619760);
	WS(1049886076, 1034318367);
	sum1 = W(0, -1140544720, 1022042959, 1021784769, -1131075883)
		 + W(1, -1142660485, -1160888244, 1006465467, -1106141033)
		 + W(2, 966352080, 1032360624, 1029412697, -1121174096) + W(3, 1025588553, -1104462159, 1059646174, -1086897182)
		 + W(4, 1042100949, 1017231209, -1118154094, -1100197533)
		 + W(5, 1051735858, 1059041662, -1106256562, -1150715274) + W(6, 996302474, 1029682164, -1085821075, 1057694799)
		 + W(7, -1106530518, 1024907260, -1111905052, -1112348667)
		 + W(8, 1029991670, 1036690656, -1121375714, 1015672965)
		 + W(9, -1125961261, -1117824763, -1111853843, 1030592201)
		 + W(10, 1017125029, -1120397516, -1122979160, -1123002959)
		 + W(11, 1031029131, -1155480906, 1014936522, -1124207481);
	sum2 = W(0, -1110846605, 1032320648, 1027180085, 1029603693)
		 + W(1, 1033577170, -1112673640, -1118194097, 1027617785)
		 + W(2, -1144235925, 1030911393, -1134544211, -1123614185)
		 + W(3, -1143898437, 1000132981, 1031570329, -1119293171)
		 + W(4, -1126616369, -1129974305, 1019764549, -1102116254)
		 + W(5, 1058710858, 1058397441, -1096477332, 1018853209) + W(6, 1008325379, 1026769453, 1031557517, -1104852463)
		 + W(7, -1103611475, 1036639048, 999139301, -1131321177)
		 + W(8, -1129394727, -1097515304, -1115701158, 1018401637)
		 + W(9, 997400075, 1008054267, -1131248001, -1123234663)
		 + W(10, -1119810656, 1024391909, 1024689095, -1118482095)
		 + W(11, -1120094485, -1106708620, -1134741251, 1017993989);
	WS(1058429118, 1064863249);
	sum1 =
		W(0, 1021156518, 983001563, 1054264097, -1097350840) + W(1, -1175841770, 964768362, 1024394983, -1115666854)
		+ W(2, 1049468028, -1099725362, 1024539904, -1149024695) + W(3, 1020219616, 1039490386, 1055450440, -1115114453)
		+ W(4, 997016493, 1012766063, -1131178666, 1046648007) + W(5, -1104196510, -1085827188, 1043203980, 1022718592)
		+ W(6, 1016100640, 1017911734, 992909240, -1100930382) + W(7, 1033767351, -1136266891, 1007341951, 1043757188)
		+ W(8, -1104186631, -1128095056, -1119513801, 1035657141)
		+ W(9, 994206685, -1128564932, -1122765517, -1118903024) + W(10, -1131557236, 1016423590, 964693930, 1045299318)
		+ W(11, -1105268364, 1023907580, -1106015350, 1029236260);
	sum2 = W(0, 1005391535, -1106696811, 1050575955, -1100156814)
		 + W(1, -1098256564, 1028021126, 1018096716, -1121907467)
		 + W(2, 1051313221, 1060662591, 1029467086, -1129063320) + W(3, -1135288360, 1026226746, 1047952814, 1068258385)
		 + W(4, -1142136447, -1131820748, -1121648533, 1031305614)
		 + W(5, -1081952512, -1074657656, 1051661425, 1008147176) + W(6, 996459166, 1032267559, 1040750694, -1095314974)
		 + W(7, 1035381379, -1168737402, -1130245220, -1111725659)
		 + W(8, 1031579134, 1036231973, -1107714686, 1020424408) + W(9, -1123582348, 1028271694, 1007524520, 1044691450)
		 + W(10, 1022647148, -1129848660, 1033610651, -1108648643)
		 + W(11, 1034169827, 1044987108, -1100160947, 1024695710);
	WS(-1083443454, 998713176);
	sum1 = W(0, 1032696047, 1040709994, 1040929033, -1087559501) + W(1, 1049786774, -1146095614, 1026355790, 1040668906)
		 + W(2, 1032459486, -1103862520, 1037090637, 1033091241) + W(3, 1024354795, 1036398699, 1012490030, -1102928053)
		 + W(4, 1047072725, 1024780023, 1034252472, 1051748575) + W(5, -1097753826, -1093112676, 1050721065, 1037512365)
		 + W(6, 1012872363, 1035129883, -1114537329, -1092883854) + W(7, 1039546228, 1024615038, 1032281789, 1044965075)
		 + W(8, -1100635790, -1099081393, 1011437457, 1037286498)
		 + W(9, 1027888345, 1031400701, -1103916602, -1104850339)
		 + W(10, 1009955155, 1036010231, 1016830581, 1048807512)
		 + W(11, -1098186970, -1112352715, -1114553850, 1033653631);
	sum2 =
		W(0, 1035861958, -1098289107, 1026686124, -1096172460) + W(1, -1113513064, 1019723703, -1161872500, -1119785106)
		+ W(2, 1049978705, -1107697817, 1027596044, -1121217732)
		+ W(3, -1113290777, 1033623622, -1098402027, -1091833397)
		+ W(4, -1098063812, 1033198374, -1137177342, 1045692473) + W(5, 1024040864, 1013412750, 1031079096, -1107709748)
		+ W(6, 1034613598, -1106425659, 1053770527, 1046082211) + W(7, 1012376430, 1038124498, -1103597964, -1117971136)
		+ W(8, -1127968019, 1057075430, -1095279992, -1112843267) + W(9, 1038756242, 1019694879, 1049090628, 1047895771)
		+ W(10, 1045163433, -1120386622, -1111249467, -1114046628)
		+ W(11, 1052585151, -1102204197, -1100444173, 1034273086);
	WS(-1086369662, -1078015058);
	sum1 =
		W(0, 1024279387, 1042615374, 1054091094, -1095346029) + W(1, 1050416872, -1113840294, -1100066053, -1106499229)
		+ W(2, -1113085188, -1103658220, -1111759460, -1141254386)
		+ W(3, 1039589628, 1049518735, 1050614757, -1097514477) + W(4, 1048966812, 1032485602, -1104719791, -1115604002)
		+ W(5, -1103236040, -1100854410, -1122281110, -1113439156)
		+ W(6, -1113174076, -1127523972, 1047781504, -1097175852)
		+ W(7, 1043919349, -1119980106, -1125885710, 1049389829) + W(8, -1108066658, 1026529231, 1032565272, 1039770777)
		+ W(9, -1111149795, -1102519338, 1041501469, -1104719494)
		+ W(10, 1027138593, -1104628175, 1024511623, 1042212335)
		+ W(11, 1048227542, -1099302313, 1036646913, 1032389542);
	sum2 =
		W(0, -1092512531, -1098738343, 1063615535, 1009177475) + W(1, -1119750726, 1030476954, -1093473489, -1088925799)
		+ W(2, 1062426368, 1026425874, 1012050343, -1120184004) + W(3, -1081280020, 1042571962, 1067242406, 998962046)
		+ W(4, 1025403720, 1031881676, -1076988140, 1043337888)
		+ W(5, 1066811408, -1096426756, -1129159374, -1116680638)
		+ W(6, -1081342477, 1033193400, 1066297017, 1022780060) + W(7, 1023044380, -1135563955, -1086556968, 1010020371)
		+ W(8, 1060290312, 1026166068, -1115355073, 1004442726) + W(9, -1107875638, -1102154130, 1052028857, 1017583668)
		+ W(10, 1026819560, 946141982, -1121362077, -1126174974)
		+ W(11, 1037059936, -1119102823, -1127777686, 1034449190);
	WS(-1129707456, 1007685382);
	sum1 = W(0, -1134894751, -1098519836, 1040671079, 1044073412)
		 + W(1, -1109530006, -1134057701, 1044154267, 1030394337) + W(2, 1013414869, 1041040503, 1035376874, 1028314315)
		 + W(3, -1111052786, -1107874844, -1103276809, 1038778991)
		 + W(4, -1105794628, -1112561176, 1038046773, -1118678129)
		 + W(5, -1098881194, -1107344299, -1139987723, 992777541)
		 + W(6, -1192544411, -1111301144, -1110522396, 1048980909)
		 + W(7, -1108336721, -1112828028, -1128991721, -1115520098)
		 + W(8, -1107120076, 1052479600, -1112546431, -1132207293)
		 + W(9, 1035051017, 1015910765, 1033063921, 1049200001) + W(10, 1023468750, 999515194, -1122391156, -1103669035)
		 + W(11, -1111557603, 1051478546, 1018554845, -1119107128);
	sum2 =
		W(0, -1137824107, -1110122518, -1137081539, 1039063461)
		+ W(1, -1158403413, -1124656554, -1126465818, 1033612180)
		+ W(2, -1106894813, 1047362418, -1117814890, 1023374342) + W(3, 1005362547, -1116868027, 1045165527, 1067526191)
		+ W(4, -1136640937, -1115663214, -1158497445, 1039739597)
		+ W(5, -1106604299, 1071589227, 1044031039, -1148955153)
		+ W(6, -1119770196, 1037998233, -1138568822, 1061860820)
		+ W(7, -1133800170, -1123862185, 1021074352, -1112420682) + W(8, 1039276731, -1077533661, 1031122886, 999718675)
		+ W(9, -1138544392, 1025116420, -1104439342, -1073373771)
		+ W(10, -1106196407, -1139157324, 1034621027, -1120069279)
		+ W(11, -1113398206, -1094637864, 1031315442, 1025985948);
	WS(1033791472, -1138498893);
	sum1 = W(0, -1143657507, -1102835756, 1024249065, 1044190455)
		 + W(1, -1107762844, 1008291608, 1014781903, -1108646231)
		 + W(2, -1130492804, 1021681616, -1112711792, -1128240816)
		 + W(3, 1029133201, -1108649138, 1008218246, -1115040338)
		 + W(4, 1019895480, 1025256893, 1018917100, -1106020223) + W(5, 1054388603, 1058377694, -1123372431, 1014932868)
		 + W(6, 998381448, 1003669472, -1092207694, 1046387590) + W(7, -1111491159, 1007448080, 1016812674, -1113672010)
		 + W(8, -1132293500, 1049136345, -1123523050, 1008489644)
		 + W(9, -1118545247, -1114481905, -1112726231, 1017676194)
		 + W(10, -1123035739, -1112884042, -1137667330, -1127743919)
		 + W(11, -1119594899, -1119541597, 1028355707, 1001709096);
	sum2 = W(0, 1014470821, -1106657768, 1034825132, 1006830039)
		 + W(1, -1104684796, -1124459301, -1120344268, -1106292024)
		 + W(2, 1032219219, -1101139832, -1114556582, 1008940380)
		 + W(3, -1114330800, 1049926230, 1057813788, -1102461554)
		 + W(4, -1111886229, 1029827978, -1106002658, 1054743689)
		 + W(5, 1049962194, -1103958261, 1050373872, -1133852786)
		 + W(6, 1024999308, -1112305858, 1051810194, -1098680718)
		 + W(7, 1035894797, -1109427720, -1126273593, -1122403994)
		 + W(8, 996027236, 1040205712, -1100520246, 1024816377) + W(9, -1127411221, -1116955850, 984340447, -1109277736)
		 + W(10, 1014102650, -1117160816, -1123975632, 1030827431)
		 + W(11, -1114551452, -1111240037, -1106040331, 1003623824);
	WS(1060089726, 1074996161);
	sum1 =
		W(0, -1117558175, 1046443391, -1083103171, 1040714346) + W(1, 1044503809, 1023987857, 1029119241, 1039893948)
		+ W(2, -1093429938, 1021452133, 1030628716, 1027140771) + W(3, -1141503452, 1041448800, -1088988175, 1048946821)
		+ W(4, 1038933875, 1026874120, 1010789890, 1035829124) + W(5, 1032282738, 1021975771, 1038764813, 1026271340)
		+ W(6, 1037081758, 1041862066, 1035486030, 1040332065) + W(7, 1032949373, 1034225415, -1120312844, 1028398131)
		+ W(8, -1142682180, -1090323173, 1041097413, -1113760891)
		+ W(9, 1027150698, 1038548631, -1111879740, -1112512014) + W(10, 1029165798, 1028642719, 1021223318, 1047369209)
		+ W(11, -1105296983, -1095359061, 1046714577, -1134282558);
	sum2 = W(0, -1130708327, -1131662151, 1027052068, -1104634511)
		 + W(1, 1037500532, -1117309872, -1156760442, -1160974837)
		 + W(2, -1119116140, -1148640061, 1028521640, -1132259207)
		 + W(3, 1011385503, -1122121264, 1006726095, -1101053828)
		 + W(4, 1041142688, -1129219511, 1005458237, -1104012424)
		 + W(5, 1053197196, 1050251696, -1121651972, -1148190653)
		 + W(6, 1015786967, 1025508020, -1150821434, 1043632028)
		 + W(7, -1105814552, 1005943453, -1121500080, -1106371091)
		 + W(8, 1032166230, -1115585403, -1117076340, -1120252400)
		 + W(9, 1023017975, 1032453110, -1116451706, 1032061998)
		 + W(10, -1120517680, 1024831312, 1008927007, -1107217673)
		 + W(11, -1143126685, 1045664978, -1103126409, -1126349911);
	WS(-1081408895, 1057237802);
	sum1 =
		W(0, 1016592219, 1050393725, -1096948620, -1099121222) + W(1, 1042338077, 1026859007, -1135569700, 1025037351)
		+ W(2, 1021729271, -1114451665, 1033766733, 1023688209) + W(3, 1019913045, 1042967287, -1123436299, -1104931659)
		+ W(4, 1036822635, 994107237, -1134722237, 1042881918) + W(5, -1107250293, -1092679092, 1042265522, 1017621813)
		+ W(6, 1020337237, 1033060699, 1047123275, -1098053310) + W(7, 1043883210, 1033354815, 1019971573, 1038993285)
		+ W(8, 1037602588, -1091584672, 1042862441, -1147819555) + W(9, 1015924209, 1028206140, 1034435092, -1092984777)
		+ W(10, 1029491668, 1035642823, 1027236154, 1041649576) + W(11, 1044331459, -1089381821, 1042007901, 963919445);
	sum2 = W(0, -1127968320, -1092240358, 1057542400, 1016463192)
		 + W(1, -1094079665, 1037438732, 1036537032, 1030963640)
		 + W(2, -1105653780, -1097383073, 1040975890, 1019305024)
		 + W(3, -1112917417, -1097473768, 1053316325, 1038201480)
		 + W(4, -1101066411, 1028884816, 1020801080, -1109029546) + W(5, 1058712288, 1052867895, 1013027424, 1010261952)
		 + W(6, 1019615648, -1116583352, 1043894648, -1123129572)
		 + W(7, -1118015492, 1027371024, -1127208552, 1028578068)
		 + W(8, -1093453186, -1141347136, -1117505000, -1113360113)
		 + W(9, 1023589392, -1113404853, 1034405836, 1006791808)
		 + W(10, -1111557726, 1034904608, -1121416948, 1041090246)
		 + W(11, -1094394128, 1037486484, 1044943944, -1104647878);
	WS(-1076745215, 1064070508);
	sum1 =
		W(0, 1019383636, 1043437193, -1100863080, 1019299111) + W(1, 1041928012, 1018313975, -1138649581, 1030286820)
		+ W(2, 1033675388, 1027453406, 1031909515, -1136380470) + W(3, 1029667879, 1040316179, -1102225484, -1110289513)
		+ W(4, 1043406276, 1026991539, -1127653591, 1048543741)
		+ W(5, -1084687593, -1082029409, 1044625233, -1136351578) + W(6, 1027426151, 1029763954, -1111626052, 983973284)
		+ W(7, 1044339921, 1027257018, 1022926189, 1039947283) + W(8, 1026499316, 1031954367, 1039879984, 1022902273)
		+ W(9, 1004012708, 1025479577, -1122995300, -1118301831) + W(10, 1022733729, 1026798858, 1016119660, 1041368223)
		+ W(11, 1026134601, 1016553765, 1012331970, 1027440187);
	sum2 =
		W(0, -1131696089, 1012459087, -1112347233, 1039451269) + W(1, -1158657302, -1129595249, 1008718823, -1135045027)
		+ W(2, -1125420309, -1110618065, 1007247903, 999949222) + W(3, -1149188438, -1118135053, 1041969824, 1024383435)
		+ W(4, 1015365577, -1130814181, -1140198251, 1033739972) + W(5, 1052325325, 1052741682, 1034080133, -1140370763)
		+ W(6, -1129603953, -1142742214, 1029891118, -1121721953)
		+ W(7, -1110453303, 1020979581, 1007479839, 1015462815)
		+ W(8, -1120072309, -1095903036, -1162307222, -1132990667)
		+ W(9, -1141563590, -1126906553, 1017890385, -1105015368)
		+ W(10, -1122346803, 1008938691, 1018622169, -1135479163)
		+ W(11, 1016803437, -1098230278, 1021342643, -1137891195);
	WS(-1094563452, 1051169575);
	sum1 =
		W(0, -1154622990, 1018130713, 1040428881, -1120902330) + W(1, -1113835211, 1019319877, 1029393378, 1035203109)
		+ W(2, 1032896399, 1039535746, 1021002107, 1036762426) + W(3, -1117775501, -1113234793, 1049040808, -1102863965)
		+ W(4, -1107942972, -1135300966, 1033996553, -1106127031)
		+ W(5, -1112183035, -1090463816, -1105904891, 1040237135)
		+ W(6, -1136342582, -1114335628, 1048012112, 961094679) + W(7, -1148767576, 1032716400, 1018491963, -1112874623)
		+ W(8, 1044702279, -1098092733, -1124337998, -1137189022) + W(9, 1032030382, 1023872671, 1032915973, 1033184663)
		+ W(10, 1006151100, 1037223880, 1015760954, -1110067034)
		+ W(11, 1035998904, 1029109433, -1110631596, 1013167238);
	sum2 =
		W(0, 1028413027, -1121092135, 1017337743, -1137632446) + W(1, 999930971, 1027578971, -1120070369, -1130520759)
		+ W(2, 1037177446, -1104029390, 1033133092, -1114678191)
		+ W(3, 1012563150, -1120753460, -1106734706, 1048794348)
		+ W(4, -1111694827, 1030530567, -1111535757, -1097640928)
		+ W(5, 1051800696, 1050145982, 1041394994, -1119592910) + W(6, 1011962278, -1098008778, 1035782812, -1114477541)
		+ W(7, -1118971109, 1001961835, 1009477102, 999766235) + W(8, -1106510696, 1047938812, -1127041263, 1024176823)
		+ W(9, -1153318262, -1122757360, 1010623246, -1111017918)
		+ W(10, 1020162151, -1115486877, 974823129, -1129371381)
		+ W(11, 1028214977, -1123769252, -1124747017, 1007999422);
	WS(1057759166, -1088449289);
	sum1 =
		W(0, -1129635066, 1044873994, -1087389198, -1116302487) + W(1, 1048786726, 1017011581, 1025446574, 1037627635)
		+ W(2, -1097118359, 1022204225, 1039292653, 1021371937) + W(3, -1144519245, 1041685209, -1089578865, 1022125102)
		+ W(4, 1045860709, 1025212662, 1017539549, 1033910011) + W(5, -1129568803, -1105345911, 1045748274, 1031878029)
		+ W(6, 1026395242, 1039651930, 1010566389, -1122366800) + W(7, 1027479143, 1013486066, -1122678010, 1035038013)
		+ W(8, 1030050103, -1097803608, 1033498658, 1007580942) + W(9, 1025431320, 1039320958, -1110122707, -1119554634)
		+ W(10, -1161253492, 1028360045, 1024557433, 1038868536)
		+ W(11, -1112614790, -1126568107, 1010965710, 1015223035);
	sum2 =
		W(0, -1162281894, 1033992046, 1042856153, 1038465062) + W(1, -1093956780, 1024284423, -1124547002, -1149048922)
		+ W(2, 1036788056, 1046094595, -1100316514, 1035682376) + W(3, -1150111187, 988741862, -1112557119, 1060179844)
		+ W(4, -1090501223, -1122577303, -1135956229, -1132541637)
		+ W(5, -1097406101, 1049669935, 1022378118, -1113139255)
		+ W(6, -1145634890, -1132011310, -1121853795, -1101657128)
		+ W(7, 1045140163, -1130855582, 965409433, 1024739191) + W(8, -1104384368, 1042681611, -1121116299, -1118824057)
		+ W(9, -1123274137, 1008671821, 1032013500, -1111116605)
		+ W(10, 1035479824, 1006161754, 1024679583, -1129294934)
		+ W(11, -1147059498, 1027020519, -1131272734, -1124922046);
	WS(-1086987838, -1100233980);
	sum1 =
		W(0, 1015308459, 1041765192, -1105415847, 1042444900) + W(1, -1111075669, 1003799483, -1122325985, 1028094431)
		+ W(2, -1114108890, 1041449686, -1106140165, 1034767973)
		+ W(3, -1116672610, 1042485054, -1092596043, 1049087917)
		+ W(4, -1110170951, -1144225139, 1032904116, -1118546351)
		+ W(5, 1046690691, -1128556841, 1034284768, 1033288361)
		+ W(6, -1141168915, -1118052589, 1054244345, -1089307961)
		+ W(7, 1026589088, 1010481109, 1033123257, -1116818498) + W(8, 1049735534, -1094503991, 1030527932, -1121578684)
		+ W(9, 1001375875, 992241989, 1040724504, -1104029377) + W(10, 1008796465, 1030765989, 1015833828, 1015146386)
		+ W(11, 1041637233, -1100869156, -1123717612, -1124977133);
	sum2 = W(0, -1128145157, -1100557855, 1057648426, 1048654145)
		 + W(1, -1122215769, -1133425768, 1026284201, -1106810438)
		 + W(2, 1054522141, 1057115188, -1103409060, 1017140792) + W(3, 1012811840, 1042787919, -1098531848, 1046636853)
		 + W(4, 1046426252, -1118227807, -1136599052, 1044596046)
		 + W(5, -1073275189, -1074262745, 1035358469, -1143532160) + W(6, 992541697, 1038174685, 1061008073, 1044984510)
		 + W(7, 1036107748, 1016191398, 1011005728, -1104618112) + W(8, 1059653331, 1060082709, -1104639697, 981079778)
		 + W(9, -1127430370, -1166127490, 1035655860, 1034192337)
		 + W(10, -1130597644, 1006837720, 995789721, -1116633305)
		 + W(11, 1017274260, 1033697834, -1112828961, 1021901152);
	WS(-1092446204, 989212831);
	sum1 =
		W(0, 1007124942, 1048125124, -1138101793, -1141178857) + W(1, -1102978326, 1034583667, -1116778591, -1131432602)
		+ W(2, -1106585464, 1019782926, -1115311760, 1015089582) + W(3, 1027403088, 1042237585, 1016240146, 1036610823)
		+ W(4, -1110971902, 1027127900, -1121715541, -1138060917)
		+ W(5, 1037962972, -1101006449, -1114322839, 1008360193) + W(6, 1019921952, 1027977243, 1053191424, -1094792341)
		+ W(7, 1031189102, 1028625507, 1020332096, -1126238792) + W(8, 1053622732, -1089064867, -1137835047, 1017386452)
		+ W(9, -1139218425, -1131884420, 1043276755, -1101892348)
		+ W(10, -1132849129, 1009465805, 1020381759, 1024321015)
		+ W(11, 1049124886, -1107274751, -1110951117, 1008208785);
	sum2 =
		W(0, -1120159352, -1088595541, 1060560783, 1061831343) + W(1, -1089452071, -1101640393, -1125980662, 1050146519)
		+ W(2, -1093128727, -1098317152, 1042347964, 1038452583)
		+ W(3, -1131578305, -1090859444, 1057304640, 1057012981)
		+ W(4, -1095995319, -1105624394, 1028063854, -1107336769)
		+ W(5, 1071289406, 1069689231, -1096815763, 1041229675)
		+ W(6, 1021975879, -1105868965, -1087527230, -1097221007)
		+ W(7, -1104502319, 1037791301, 1033612769, 1041431951)
		+ W(8, -1086794372, -1086042421, 1049524493, -1143180172)
		+ W(9, -1119579693, -1112749441, 982969010, 1033122226) + W(10, -1104150062, 1029453052, 1040487308, 1042279365)
		+ W(11, -1089785065, -1088997285, -1135764460, 1049121852);
	WS(-1080642303, 1037515653);
	sum1 =
		W(0, 1014399585, -1123461796, -1115821917, 1037702505) + W(1, -1105260875, -1134503912, 1040389217, 1009459592)
		+ W(2, -1138501592, 1046330151, -1113097082, 1032999462)
		+ W(3, 1025436037, -1118449912, 1046808963, -1088063230)
		+ W(4, -1166545913, 1011659972, 1035628117, -1111999897) + W(5, 1046961203, 1048171302, -1112931778, 1033647146)
		+ W(6, 1032176658, 1042449564, -1085801589, 1046621083) + W(7, -1116953058, 1020514160, 1019714410, -1098862637)
		+ W(8, 1042823052, 1033619294, -1108126015, 1023868127) + W(9, 1031481267, 1015874414, 1032561937, 1017602698)
		+ W(10, 1033606503, 1030447848, -1129425897, -1108656118)
		+ W(11, 1022709518, -1172911161, -1161936349, 1015791986);
	sum2 =
		W(0, -1139497271, -1104932637, 1000924601, 1034980171) + W(1, -1102656208, -1154378706, 1025910769, 1043978669)
		+ W(2, -1116100213, 1042493673, 1038409695, 1025837919)
		+ W(3, -1105297083, -1105480129, -1102785010, 1044002411)
		+ W(4, -1098474508, -1109802618, 1037339247, 1037617885) + W(5, 1049988969, 1050036780, -1122964745, 1036616991)
		+ W(6, -1111547600, -1107402541, 1045831134, 1039942071)
		+ W(7, -1106907325, -1132149525, -1123186639, -1105522985)
		+ W(8, 1040977948, -1097804729, 1028039731, -1111839940) + W(9, 1029488041, 1011577705, 1036894407, 1042714488)
		+ W(10, -1112976714, 1040500443, -1137152287, -1102258444)
		+ W(11, 1025599417, -1139888185, -1112698813, -1114191023);
	WS(1060124606, -1084472548);
	sum1 =
		W(0, 1012638700, -1112711971, 1024524352, 1032623962) + W(1, -1115629480, 1027484509, -1131934189, 1021193865)
		+ W(2, 1017460401, -1117271615, 1023262959, -1157409515)
		+ W(3, -1129347279, -1125331574, -1113956442, 1049120342)
		+ W(4, -1108495481, 1010910287, -1138043955, 1048955067) + W(5, -1094951982, 1015143283, 1031640934, 1021584239)
		+ W(6, 1007380511, -1106488069, 1048203795, -1110142007)
		+ W(7, -1129214986, -1144904917, 1022374575, -1115361884)
		+ W(8, 1005249701, 1024310560, -1136673413, 1017598403) + W(9, 996895579, -1120058426, 1026650437, -1121731240)
		+ W(10, 1017029987, -1145343061, 992489843, -1118477310)
		+ W(11, -1129456851, 1036683482, -1115998674, 1014521967);
	sum2 =
		W(0, -1113301049, 1041723134, -1119425470, 1012563935) + W(1, 1013366251, -1135264199, -1129519836, 1018887182)
		+ W(2, -1123219625, 1021107126, -1131491053, 1017265018)
		+ W(3, -1113144608, 1065721494, -1082046556, 1032971141)
		+ W(4, -1132479565, -1135106943, -1114997262, 1081282167)
		+ W(5, -1068115046, -1092304788, 1028331651, 927030725) + W(6, 1028189537, 1053752802, -1091841582, -1120681827)
		+ W(7, 1021570574, 983594844, -1144798799, 1004635839) + W(8, -1126716683, 1026059029, -1132445755, -1137356791)
		+ W(9, -1135227415, 1024321495, -1149813598, 992723582) + W(10, 1010781703, 959859164, -1123606042, 1032429021)
		+ W(11, -1137534547, -1121765421, 1024141029, -1123588459);
	WS(1064307390, 997943845);
	sum1 =
		W(0, 1016504192, -1110031838, -1108555962, 1047561626) + W(1, -1114174882, 1004953741, 1004931163, -1124632947)
		+ W(2, -1129767067, 1003984285, 1017992857, 1018940039) + W(3, 1001468389, -1106796660, -1106350773, 1053522405)
		+ W(4, -1106382906, 1000370245, -1125536771, -1132488742)
		+ W(5, -1097456765, 1050670238, -1136221548, 1015934681)
		+ W(6, 1024701821, -1111862756, 1040312105, -1128004006)
		+ W(7, -1123896954, 1011062590, -1157300426, -1111316170)
		+ W(8, -1110123941, 1039422954, 1020844396, -1128259885) + W(9, 1008115882, -1153319146, 1030600762, 1005773541)
		+ W(10, 1015300557, -1153739770, 1014991280, -1116314499)
		+ W(11, -1109063375, 1042190650, 1024320647, -1130969505);
	sum2 = W(0, 1036505224, -1100095598, 1039944480, -1110028565)
		 + W(1, 1016119595, 1017378303, 1018720963, -1119632397) + W(2, 1033659023, 1025734363, 1015545311, -1126149289)
		 + W(3, 1037554666, -1082101932, 1064933062, -1103479495)
		 + W(4, 1036578506, 1022196513, 1035136259, -1072130218) + W(5, 1074634461, 1012777017, 1036162128, -1118704038)
		 + W(6, -1131720942, -1090292986, 1057038142, -1132873326)
		 + W(7, -1120419990, 1020047721, 1012123245, -1114842502)
		 + W(8, 1046242606, -1117820012, -1115011900, 1033886326)
		 + W(9, 1027168757, -1108983905, 1018437263, -1117294599)
		 + W(10, 1004277346, -1136709697, 1024471767, -1105383800)
		 + W(11, 1041395450, 1033191694, -1113427773, 1024978781);
	WS(1053812476, -1113586226);
	sum1 = W(0, -1130399840, -1111011390, 1007197394, 1037708373)
		 + W(1, -1122978308, -1139049030, 1028349447, -1120416825)
		 + W(2, -1105796643, 1044272829, -1110423782, -1125249991)
		 + W(3, 1021963321, -1107941440, 1056809437, -1093131829)
		 + W(4, -1122097703, 1011721762, -1121520129, -1106086226)
		 + W(5, 1046348585, 1057081835, -1099751719, -1114497366)
		 + W(6, 1020769785, -1129958415, -1090756230, 1059679544)
		 + W(7, -1102044582, 1018253471, -1115853964, -1107644952)
		 + W(8, 1050300257, -1119895572, -1111488955, 1022041005)
		 + W(9, 1021860117, -1122155502, -1116443513, 1040260199)
		 + W(10, 1019054925, -1121197023, -1121122124, -1114352785)
		 + W(11, 1041113720, -1110926804, -1156322407, -1135672898);
	sum2 =
		W(0, 1015672618, 1010541588, -1115998566, 1020421847) + W(1, -1129704409, 1015113530, -1121994623, 1032866568)
		+ W(2, 1011616452, -1095022641, 1020628925, 1017019595)
		+ W(3, -1149412980, 1044676778, -1107438884, -1097106911)
		+ W(4, -1112769863, 1022483811, -1127744422, -1124040172)
		+ W(5, 1058620442, 1015017230, -1113422252, 1015061518) + W(6, 990134373, -1102290659, 1049322309, -1104275347)
		+ W(7, 1039268635, -1114030797, 1024671460, 1029499881) + W(8, -1104592911, 1045525693, 1026741584, -1136765715)
		+ W(9, -1132259460, -1120084193, 1035840939, -1119993661)
		+ W(10, 999745387, -1131682952, -1125579600, 1001699435)
		+ W(11, -1123886068, 1037165892, -1126762930, -1134246014);
	WS(1059863230, -1098226968);
	sum1 =
		W(0, -1111154474, -1130042625, -1124092147, -1126659421)
		+ W(1, -1116454602, -1109234699, 1033627108, 1044463840) + W(2, -1125693093, 1045974478, 1040744732, 1026252457)
		+ W(3, -1111220881, -1098768819, 1043860042, 1040108899)
		+ W(4, -1149847241, -1103478147, 1018934285, 1036585799)
		+ W(5, -1094381437, -1098844542, 1043775752, -1107008620)
		+ W(6, -1156119577, 1041677635, 1034781361, 1051479065)
		+ W(7, 1046003792, -1127254569, -1108034825, -1100472134)
		+ W(8, 1038465479, -1096809363, -1121805723, -1105262391) + W(9, 1035708952, 1038444026, 1027036095, 1040658808)
		+ W(10, 1037992790, 1038964162, -1116166225, -1111999396)
		+ W(11, 1019243847, 1003830125, -1131289879, -1116821910);
	sum2 =
		W(0, 1031860762, 1008804487, 1036033743, -1130814575) + W(1, -1114717025, 1042429978, -1114215534, -1119320351)
		+ W(2, -1105317049, -1126605754, -1103884858, 1019583714) + W(3, 1037917300, 1028769566, 1033869945, 1029943513)
		+ W(4, -1097519272, 1050527129, -1123072391, -1145928741)
		+ W(5, -1104666827, 1058632863, -1084821476, 1057878257)
		+ W(6, -1121765219, -1118791492, -1103277106, 1010033985)
		+ W(7, -1091781337, 1047090522, 1036233577, 1035112755) + W(8, 1043081028, 1033184724, -1108906997, 1050006554)
		+ W(9, -1113082189, -1119166399, -1110309063, -1124066564)
		+ W(10, -1105454190, -1116436299, 1007761049, 1034891236)
		+ W(11, 1003334201, -1146667244, -1124982586, 1037673833);
	WS(1053829756, -1108691549);
	sum1 =
		W(0, 1014621415, 1034972923, -1105089900, -1121242915) + W(1, 1024842558, -1125107735, -1117035633, 1031518451)
		+ W(2, -1146432572, 1011744694, -1195363583, 1024600093)
		+ W(3, 1017668333, 1028891034, -1111069516, -1099260407)
		+ W(4, 1035963185, -1111257697, -1121088251, 1043029617) + W(5, 1052288956, -1096216885, 1043236853, 1022444749)
		+ W(6, -1113943163, 1037608353, 1043183409, -1109446679)
		+ W(7, -1104376301, 1008767270, 1027915142, -1118505878) + W(8, 1040529537, 1033001703, -1110826184, 983774736)
		+ W(9, -1117882340, 1008280866, -1127832039, 1023717270)
		+ W(10, -1108863440, 1021787123, 1018110476, -1114328254)
		+ W(11, 1025673432, 1038283409, -1136644866, -1122279626);
	sum2 = W(0, 1011466728, -1153535168, -1121363658, -1113493290)
		 + W(1, 1016979229, -1121975877, -1128158188, -1133074596)
		 + W(2, -1108077390, 1031842286, -1114077565, 1032726750)
		 + W(3, 993685376, -1111924694, 1048370655, -1096696142) + W(4, 1032702600, -1126878203, 1021341187, 1041916532)
		 + W(5, -1088803436, -1097359431, 1051606360, 1020447303)
		 + W(6, -1125064327, -1115375045, 1050909934, 1066069354)
		 + W(7, -1108957150, -1115472084, 1016637363, -1111577830)
		 + W(8, 1048268187, -1102058354, -1106393780, 1011253904)
		 + W(9, -1135616946, -1121861231, 1028734454, -1112810542)
		 + W(10, -1104652034, 1032484333, -1142265296, -1139232914)
		 + W(11, 1033829714, -1108918948, -1124153420, -1135690267);
	WS(1043379192, -1131322837);
	sum1 =
		W(0, -1129021027, -1109595831, 1033800339, 1042153991) + W(1, -1099711038, 1026187331, -1148980502, -1141769560)
		+ W(2, 1040943040, 1016895818, 1029537886, 1023917269) + W(3, -1117253390, -1131540259, -1099641090, 1040857522)
		+ W(4, -1104535414, 999787984, 1015261926, 1038059198) + W(5, 1019360940, -1103092216, 1032384358, -1137467256)
		+ W(6, 1024719214, 1043151230, 1047704456, -1091529984) + W(7, 1043292971, 1021851650, -1130947836, 1040366611)
		+ W(8, -1120007803, -1100986498, 1031568104, -1117455240) + W(9, 974083843, 1036650848, 1032688054, -1116706574)
		+ W(10, 1019020464, 1021119266, 1010796022, 1032003186)
		+ W(11, -1135300928, -1114490317, 1026900536, -1124200964);
	sum2 =
		W(0, -1127801857, 1028175283, -1129802997, -1133354170) + W(1, -1129332011, 1029358411, -1143073539, 1010285366)
		+ W(2, 1022418743, -1111757330, 1032847739, -1119713292)
		+ W(3, -1106914355, 1045024365, -1109183829, 1035388549) + W(4, 1028119663, 984677997, -1114698807, -1107796176)
		+ W(5, 1055188047, -1099199714, 1027769667, -1126683209)
		+ W(6, -1129241721, -1093181393, 1060464193, -1108056884)
		+ W(7, 1015260775, -1117802232, 1034854605, -1094857339) + W(8, 1038631095, 1042537531, -1123722407, 1025618013)
		+ W(9, 1015357631, -1104001534, 1035894131, 1019867695)
		+ W(10, 1021694327, -1116557581, 1026781991, -1106206681)
		+ W(11, -1121422795, 1010545294, -1120402439, 1021478623);
	WS(1049844732, -1121310639);
	sum1 =
		W(0, 1023733410, 1044402267, 1053233309, -1096212219) + W(1, 1051767783, -1114613442, -1099209689, -1106734859)
		+ W(2, -1108848000, -1103164857, -1109302031, -1129199659)
		+ W(3, 1040893204, 1050332331, 1049912979, -1099336615) + W(4, 1050917291, 1033787229, -1102957277, -1111686974)
		+ W(5, -1098618899, -1097562740, -1121562509, -1111886543)
		+ W(6, -1114244983, -1122456058, 1048539349, -1096335583)
		+ W(7, 1042792075, -1121890370, -1136674298, 1049981942) + W(8, -1111429758, 1033031043, 1039550692, 1041151474)
		+ W(9, -1108461358, -1102278760, 1039273110, -1102589972)
		+ W(10, 1008842338, -1104020956, 1021220348, 1043895987)
		+ W(11, 1048170180, -1101337719, 1041281742, 1031699907);
	sum2 = W(0, 1051830333, 1040398919, -1088812275, -1112895824)
		 + W(1, 1030823820, -1120174945, 1052363768, 1056364330)
		 + W(2, -1088095023, -1128031249, -1126124865, 1022839272)
		 + W(3, 1062286287, -1105094784, -1083945825, -1110939052)
		 + W(4, -1131257287, -1113476028, 1068323273, -1117763636)
		 + W(5, -1086712736, -1122350162, 1034881723, 1031923437)
		 + W(6, 1062941652, -1117097644, -1085128967, -1107088013)
		 + W(7, 993374262, -1149114843, 1058036233, -1135317262)
		 + W(8, -1090471655, -1117471490, 1022005418, -1131972943)
		 + W(9, 1038399576, 1045469136, -1096613184, -1128774604)
		 + W(10, -1124473506, 1015689530, 1029358050, -1127713443)
		 + W(11, -1118175248, 1023889083, 1006015479, -1114795832);
	WS(997080576, -1130763300);
	sum1 = W(0, -1113905570, -1121320815, 1038521748, 1025325853)
		 + W(1, -1108459484, -1123369669, 1030153879, -1108108727)
		 + W(2, 1032364321, -1131460303, -1152289285, -1111143084)
		 + W(3, -1117230256, -1100762033, 1051702873, 1040312882)
		 + W(4, -1099800679, 1018134009, -1152616277, -1090117932)
		 + W(5, 1069923213, 1063008042, -1092045374, -1116551136)
		 + W(6, -1146808706, -1109500574, -1104049339, 1056019095)
		 + W(7, -1100849447, 1015899783, -1112646432, -1102311764)
		 + W(8, 1028696893, -1115439812, -1105934578, -1120248394)
		 + W(9, -1186209359, -1119610882, -1120830317, -1125581089)
		 + W(10, 1028735898, -1113190874, -1120216576, -1099135446)
		 + W(11, 1030578386, -1116447004, -1108771165, -1120342084);
	sum2 =
		W(0, -1130955153, 1025142055, 1025405091, 1041203911) + W(1, 1034798579, -1107186683, -1115062100, 1033634795)
		+ W(2, -1124058081, -1151569099, -1098708869, 1041850582)
		+ W(3, -1114768924, -1114031272, 1047530952, -1160505239)
		+ W(4, 1048498835, -1097808347, 1040485485, -1115074190)
		+ W(5, -1104495565, 1065129660, -1095909934, 1045395705)
		+ W(6, -1102247365, -1110799922, 1038913214, -1115442088)
		+ W(7, -1105078519, -1106337339, 1040365390, 1039570131) + W(8, -1102056033, 1037120419, 1024518769, 1007217475)
		+ W(9, -1105380703, -1112489130, -1123724877, -1145632358)
		+ W(10, -1109649658, -1152795787, -1134789779, 1035629875)
		+ W(11, -1104428707, 1035843769, -1117935125, -1124566009);
	WS(-1078383103, 1059446981);
	sum1 =
		W(0, -1139864362, -1142609202, -1105667544, 1048881003) + W(1, -1110989208, 1019807480, 1022304576, 1008862865)
		+ W(2, -1100327790, 1047898440, 1029966423, -1128249884)
		+ W(3, -1117916615, -1109139429, -1098424968, 1053051896)
		+ W(4, 1023833874, -1114518074, 1007335089, 1032501274) + W(5, -1089810345, -1104044598, 1040575921, 1013296733)
		+ W(6, -1119884647, 982044231, 1033240873, 1051763270) + W(7, -1114053146, -1110353213, 1022280942, -1115332063)
		+ W(8, 1049118183, -1113330784, 1041606896, -1126749570) + W(9, 1023668405, 991223187, -1140016273, 1027424455)
		+ W(10, -1122699729, 1021514772, 1034312731, -1102309771)
		+ W(11, -1110413061, 1032557738, 1041157596, -1121516731);
	sum2 =
		W(0, -1143648694, 1050457027, -1090901428, -1095258955) + W(1, 1047388223, 1034828442, 1022767513, -1104882348)
		+ W(2, 1017677825, -1116653154, -1125154789, -1149114774) + W(3, 963325627, 1052893834, -1090554669, 1030383529)
		+ W(4, -1114292033, 1040557770, -1138915747, -1122824043)
		+ W(5, 1048412513, 1063122641, -1118207917, 1005930742) + W(6, 1040530304, 1019582897, -1101863176, -1089352859)
		+ W(7, 1048190601, 980397999, 1031585165, -1094902239) + W(8, -1104950416, 1057380402, -1102824630, 1033506230)
		+ W(9, 1008260859, -1113748748, -1120605391, -1106433792)
		+ W(10, 1038107916, -1115355457, -1120690652, -1090635807)
		+ W(11, 1056780417, 1049388154, -1104842210, -1136517107);
	WS(-1104952056, -1073278929);
	sum1 = W(0, -1144211169, -1099507218, 1047627264, 1043300637)
		 + W(1, -1098196346, 1030331294, 1031125659, -1116651974)
		 + W(2, -1113308557, 1037274304, -1126577137, -1122667056)
		 + W(3, -1121100585, -1101060075, 1054491321, -1102367022)
		 + W(4, -1102852173, 1026346581, -1142367854, -1105066053)
		 + W(5, 1039149624, 1051689271, -1106731162, -1120693369)
		 + W(6, 1025675017, -1131576359, -1106626380, 1044811828)
		 + W(7, -1111689619, 1018492983, -1114298540, -1114707952)
		 + W(8, 1042584197, -1128472513, -1126957444, -1140414731)
		 + W(9, 1036563163, -1120605819, -1128818827, 1045578618)
		 + W(10, 992521004, -1128018583, -1122834968, -1111900952)
		 + W(11, 1039018645, -1115669626, 1025441875, 997033420);
	sum2 =
		W(0, -1117577133, 1036324905, 1012676607, -1164734594) + W(1, 1039853902, -1110394349, -1139616023, -1124977156)
		+ W(2, -1115101040, 1032695755, -1116113854, 1006188424) + W(3, 997820975, -1120808104, 1041273688, 1041759226)
		+ W(4, 1041255405, -1120661488, 1028627780, -1109376562)
		+ W(5, 1049990275, -1096754642, -1106762918, 1033535767) + W(6, -1114909048, 1029259135, 1043064430, 1041324783)
		+ W(7, -1111929038, 1021759445, 1032747040, -1145526876) + W(8, 1039154681, -1094055114, 1025837595, 1023476809)
		+ W(9, -1116006677, 1022442689, 1027909669, -1098711698)
		+ W(10, -1130147608, -1133986843, 1030832637, 983753970)
		+ W(11, -1115224952, 1023440264, -1112181665, 1029342490);
	WS(1057403966, -1096678293);
	sum1 = W(0, 1015545167, -1133819725, 1037006758, -1110196161)
		 + W(1, -1111752718, 1028708905, 1013920108, -1127594402)
		 + W(2, -1136130453, -1123399563, 1041684833, -1119121787)
		 + W(3, 1030182836, 1031500952, 1042283546, -1086200264) + W(4, 1047364560, -1120221088, 991347091, -1107540753)
		 + W(5, 1040431359, 1060132444, -1104881213, 1006406689) + W(6, 1031028372, 1042502792, -1084295706, 1049379651)
		 + W(7, -1113607001, 1002061113, -1130110920, -1120427420)
		 + W(8, 1042737160, 1001749345, -1117219726, 1026883950) + W(9, -1137745417, 1023814022, 1019878434, 1023472436)
		 + W(10, 1017968636, -1124476270, -1127755335, -1113612941)
		 + W(11, 1042334622, -1123659840, 1008021369, 1011156129);
	sum2 =
		W(0, -1178786588, -1129322914, -1116170217, 1036181740) + W(1, 1016863918, -1132924585, 1027650789, -1117835702)
		+ W(2, -1106357388, 1050236879, -1107702296, -1127926494)
		+ W(3, 1004569898, -1120140062, 1012300621, 1029537087) + W(4, -1115347042, 1007741857, 1010647389, -1110565129)
		+ W(5, 1051050908, -1121260831, 1019718506, -1147888890)
		+ W(6, -1130907066, 1046200355, -1094299123, -1105419536)
		+ W(7, 1018471790, -1122466004, -1128412421, 1035331810)
		+ W(8, 1038925264, -1104188032, 1035623426, -1132432621)
		+ W(9, 1000455394, 1040609034, -1110352470, -1148832482)
		+ W(10, 1031812039, -1132484471, 1019136642, -1114775527)
		+ W(11, 1028674911, 1009994365, -1129304944, -1146317634);
	WS(1056335484, -1129697442);
	sum1 = W(0, -1118615510, 1026825265, -1102686619, 1045269336)
		 + W(1, 1031523962, -1140818205, -1123816285, -1162479083)
		 + W(2, -1175208362, -1122870505, 1025178018, -1112741005)
		 + W(3, 1016357093, -1123245334, -1112742573, 1056143939)
		 + W(4, -1115481871, 1004860403, -1126548591, -1115166368)
		 + W(5, 1012633705, 1022501065, -1098786498, -1121817826) + W(6, 1017679973, 993334229, 1048503365, 1044007618)
		 + W(7, -1107348056, -1134864917, -1125007109, 1009460392)
		 + W(8, -1110640192, 1043433395, -1104721331, -1142571619)
		 + W(9, -1130509569, -1117686884, 1010107581, 1037226473)
		 + W(10, -1124234681, -1120701013, -1127256452, -1110259820)
		 + W(11, 1008538193, 1040188728, -1112073470, 1004599859);
	sum2 = W(0, -1140731697, -1126783010, 1035005186, -1110815467)
		 + W(1, -1144657885, -1127206230, 1018164054, -1144859189)
		 + W(2, 1011714049, 1039236492, -1130754383, -1146205013)
		 + W(3, -1116322329, -1148034885, -1112384840, -1109778149)
		 + W(4, -1113329105, -1113225660, 1033668632, -1111621890)
		 + W(5, 1057652336, 1053123628, -1107649638, 1012470213)
		 + W(6, -1110091010, 1034430751, -1103655808, -1113563636)
		 + W(7, -1112793157, -1113811608, 1006827755, -1133278289)
		 + W(8, 1035575897, 1009902097, -1136830370, -1126431906)
		 + W(9, 1024608202, -1134565598, 1007536733, 1031837967)
		 + W(10, -1131576514, 1007646275, 978878091, -1106732021)
		 + W(11, 1017810394, 1032913014, -1118754368, -1123083034);
	WS(1064654654, 1035088379);
	sum1 = W(0, -1123150274, -1101065371, 1052021669, 1034671630)
		 + W(1, -1103122974, -1124628232, 1013730923, -1104968795)
		 + W(2, 1043838624, -1116995686, 1025043295, -1123853974)
		 + W(3, -1124984926, -1104298005, 1050953841, -1125221929)
		 + W(4, -1102292982, -1122875259, -1143080352, -1097917367)
		 + W(5, 1053857683, 1053311748, -1101557747, -1129945790)
		 + W(6, -1115541655, -1115560637, -1098028717, 1054064059)
		 + W(7, -1102206963, -1115475969, -1120446591, -1112072243)
		 + W(8, -1118042236, 1056948345, -1099829586, 1010096420)
		 + W(9, 1019709882, -1121553409, -1117850604, 1047317764)
		 + W(10, -1123986585, -1120157778, -1123168830, -1101025669)
		 + W(11, 1024509393, 1051915779, -1105952782, 1010117900);
	sum2 =
		W(0, -1115290116, -1109338596, 1052546267, -1101682429) + W(1, -1106866549, 1027635895, 1036300391, -1120873277)
		+ W(2, 1031940424, 1045633640, -1121551223, 1021591180)
		+ W(3, -1109664288, -1133763869, 1041363997, -1094977574)
		+ W(4, 1008614181, -1119215823, 1023887773, -1110763968) + W(5, 1046589307, 1050150667, -1110488084, 1009099129)
		+ W(6, 1031338337, -1104363651, 1038758869, -1104681827)
		+ W(7, -1120223295, 1016354897, -1112746552, -1111086518)
		+ W(8, 1026186944, -1121584221, 1035823152, -1115537942) + W(9, 1029647363, 1014654409, 1011886363, 1042076972)
		+ W(10, -1111033402, 1012736237, -1123357025, -1113327782)
		+ W(11, -1114411312, 1033926660, 1046305164, -1109553196);
	WS(-1088190206, -1108558078);
	sum1 = W(0, -1109712467, 1048826552, -1117596347, 1045129740)
		 + W(1, -1145103958, 1040739958, 1034096473, -1100191472)
		 + W(2, -1104233509, 1021528052, 1015098342, -1095362037)
		 + W(3, -1111610193, 1051587686, -1112703594, -1123092480)
		 + W(4, 1033306871, 1043699492, -1111503908, -1114238856)
		 + W(5, -1118548075, 1045282957, -1105600408, -1112734841)
		 + W(6, 1029528067, -1124911644, -1094857227, 1041941490)
		 + W(7, -1116887040, -1106244021, -1109918121, 1053388852)
		 + W(8, 1040678692, -1121835291, 1043572363, 1044475255)
		 + W(9, -1130336610, -1101598429, -1102065648, 1050563972)
		 + W(10, -1101594283, -1100499697, -1110290409, 1049826386)
		 + W(11, -1108498290, 1032628503, 1041251987, 1015959598);
	sum2 = W(0, -1140036524, 1033121292, 1020537037, -1094559771)
		 + W(1, 1042598592, 1048560917, -1122134368, -1135675176)
		 + W(2, -1102563608, -1090683436, 1049536131, 1043095342)
		 + W(3, -1124742331, 1022385651, 1017232470, -1089829937) + W(4, 1015761873, 1060516603, 1023368729, 1037868584)
		 + W(5, -1097085277, -1081905013, -1122385293, 1068776853)
		 + W(6, 1025643512, -1113410705, 1026038978, -1085580324)
		 + W(7, -1119606047, 1062905414, -1117935205, 1034815986)
		 + W(8, -1107749524, -1093433405, 1034046493, 1053234619)
		 + W(9, 1029315286, -1106876578, -1116418603, -1100509010)
		 + W(10, 1037794408, 1023262329, -1121900993, 1029051910)
		 + W(11, 1013163432, -1107168757, 1020109569, 1038509970);
	WS(1048802172, -1118644607);
	sum1 =
		W(0, 1022629891, -1112271863, -1115934246, -1112205646) + W(1, 1050188943, -1125264263, 1001330921, 1008285357)
		+ W(2, 1007889405, -1137992085, 1025826270, -1127716075)
		+ W(3, -1147098739, -1106982824, -1110669107, 1044651974)
		+ W(4, 1026008921, -1113499645, 1023807923, 1020475895) + W(5, -1095657203, 1050363724, 1011316531, 1026946398)
		+ W(6, -1129374813, 958183765, -1113474437, 1050921091) + W(7, -1106529387, -1121270209, 1028532286, 1025640422)
		+ W(8, -1090481180, 1050665633, -1131537104, 1021652689)
		+ W(9, 1031375324, -1133565569, -1104303995, 1037811271)
		+ W(10, -1125009457, 1014192325, -1151549405, -1106868493)
		+ W(11, -1104624276, 1049383075, 1022847857, -1142930963);
	sum2 =
		W(0, 1016559128, -1089262209, 1053795811, 1058569170) + W(1, -1094475155, 1008650912, -1119933527, 1032931419)
		+ W(2, -1108360154, -1097574423, 1036603460, -1121755244)
		+ W(3, 1008526536, -1094914643, 1052999976, 1052760357) + W(4, -1106271635, 1039081818, 1034816070, -1096197918)
		+ W(5, 1069558608, 1058007152, 1022028102, 1004102711) + W(6, 1018959568, -1101210129, -1103281588, -1106340652)
		+ W(7, -1121182797, 1033515588, 1026554777, 1049415798) + W(8, -1085501184, -1101474305, 1027756295, 1032461240)
		+ W(9, -1112891495, -1128790619, -1098019814, -1114646508)
		+ W(10, -1124734105, -1118822413, 1046177388, 1043157162)
		+ W(11, -1088254262, -1096632714, 1015426864, 1043397723);
	WS(-1085648446, -1079079370);
	sum1 = W(0, 1031831473, 1036117159, 1049939273, -1094329359) + W(1, 1040633606, 1023486628, -1114079994, 1003975776)
		 + W(2, 1042007752, -1097850009, -1134555900, 1019647980)
		 + W(3, 1031367567, 1044164867, 1043312672, -1089391360) + W(4, 1041283678, 1023951387, -1118896788, 1045647319)
		 + W(5, -1095211959, -1087218668, 1044809099, 1014099708)
		 + W(6, -1123680847, 1033826253, -1122554975, -1100203021)
		 + W(7, 1046447947, 1017251780, 1033718927, 1041970952) + W(8, -1116359196, 1033960979, 1042238738, 1031788713)
		 + W(9, -1123944253, 1024952417, -1176880640, -1108529239)
		 + W(10, 1024390649, -1146375056, 1033541103, 1040029267)
		 + W(11, 1026974961, -1111794397, 996515216, 1033511473);
	sum2 = W(0, 1019169584, 1042983019, -1098354632, -1099987280)
		 + W(1, 1048978343, -1118546716, -1120973142, 1009997472)
		 + W(2, -1106283039, 1032814660, -1103033329, 1022934360)
		 + W(3, 1033125970, -1103915398, 1033722376, -1095179878)
		 + W(4, 1055664562, -1110281795, 1025364316, 1036688212) + W(5, 1062322516, 1032770062, -1097173506, 1045599869)
		 + W(6, -1109812797, -1125420780, -1098634798, -1109050948)
		 + W(7, -1103688168, -1119010038, 1040314133, -1119986230)
		 + W(8, 1057333054, -1097734639, -1173745415, 1038965178)
		 + W(9, -1108282977, 1034277286, -1102308141, 1034195486)
		 + W(10, -1107997912, 1007528912, 1018923536, -1117630132)
		 + W(11, -1125368820, 1049154263, -1098308929, 1035253180);
	WS(-1089355774, -1078290086);
	sum1 = W(0, -1122950775, 1037182841, -1118638572, -1121667553)
		 + W(1, 1009124079, -1115334660, -1112691207, -1124344033)
		 + W(2, 1041047393, -1104403323, -1138062223, -1126199861)
		 + W(3, 1023290087, 1046400294, -1098349922, -1099164822)
		 + W(4, 1044398104, -1136525567, -1107733500, -1118583361)
		 + W(5, 1057481334, 1054069421, -1149431076, -1110719762)
		 + W(6, -1146188190, 1042531744, -1139289650, -1097191323)
		 + W(7, 1044515332, 1015659149, -1132821263, -1121639475)
		 + W(8, -1109625472, 1041114291, -1120573261, -1121643278)
		 + W(9, -1112282369, -1137408791, 1026873009, -1120861012)
		 + W(10, -1120947806, -1122889719, -1116356099, 1018516820)
		 + W(11, -1139389015, -1139200383, 1017011067, -1120569352);
	sum2 = W(0, -1120919296, -1124567280, 1037030993, -1120629799)
		 + W(1, -1106639281, 1020211370, 1009843654, -1107129213)
		 + W(2, 1043380414, -1102119519, 1030878171, -1126825280)
		 + W(3, -1132368064, 1020831927, -1109288357, -1112537154)
		 + W(4, -1118412551, -1144175329, 1020138111, -1098918731)
		 + W(5, 1059483198, 1064361176, -1093377806, -1146281491)
		 + W(6, 1029564211, -1132836513, -1119273466, -1104145236)
		 + W(7, -1123848756, -1135251423, -1115205032, 1010227332)
		 + W(8, -1106893419, 1043150197, -1103899854, 1028327527)
		 + W(9, 1016741875, -1118685376, 1028452918, -1117770026)
		 + W(10, 1024207514, -1128215590, -1119663171, 1026001154)
		 + W(11, -1135273053, 1019055438, -1109882780, 1024565629);
	WS(1064975294, 1066308158);
	sum1 =
		W(0, 1031747776, -1119071204, 984462229, -1132055971) + W(1, -1148253029, -1126913907, -1106142801, 1032019633)
		+ W(2, 1045090381, -1108909198, -1110036442, 1036419718) + W(3, 1028818885, 1041375482, -1093262116, 1038243096)
		+ W(4, 1036945928, -1121925745, 1001228109, -1112793497) + W(5, 1049965274, 1021279149, -1115536386, 1019907753)
		+ W(6, -1115396498, 1013499583, 1052662103, -1090377239) + W(7, 1034061985, 1032108124, 1041342669, -1123968938)
		+ W(8, -1113450905, 1040402543, 993049059, -1109636927) + W(9, -1108139113, 1024220311, 1035427697, -1107965954)
		+ W(10, -1113141447, 1032825796, 1027821620, 1020544662)
		+ W(11, -1138282267, -1116422289, 1016907357, -1128061041);
	sum2 =
		W(0, 1016610899, -1118189976, 1027283971, 1028895363) + W(1, -1113530321, 1007846553, -1135553471, 1018031354)
		+ W(2, -1118352328, 1032145382, -1123867563, 1011272254)
		+ W(3, -1163068737, -1120752887, 1042584076, 1042427003)
		+ W(4, -1099207121, 1010785270, -1147979120, 1035872696)
		+ W(5, -1095799786, 1073605475, -1075418961, 1026092591) + W(6, -1121296916, 1034250650, 1009508653, 1056095764)
		+ W(7, -1091570337, 1030054693, -1139692219, 1022157658)
		+ W(8, -1121907329, -1130051225, -1113117501, 1019567305)
		+ W(9, 1007282246, -1131969269, -1148404200, 1025403981)
		+ W(10, -1124635978, 1012575724, 1019770181, -1131641536)
		+ W(11, 1013257077, -1121748387, -1123610989, 1018865930);
	WS(1062423998, 1020226002);
	sum1 = W(0, -1122384152, -1116470612, -1095861522, 1055717600)
		 + W(1, -1128557498, -1133541800, 1000976853, 1015809956)
		 + W(2, -1125526476, 1034182342, -1136390676, 1025071548)
		 + W(3, -1122957973, -1115150860, -1101122465, 1052715645)
		 + W(4, -1101688288, -1121585121, -1140430696, -1100102424)
		 + W(5, 1051208664, 1053221217, -1097231798, 1026360261) + W(6, 1018079658, -1099378776, 1045734276, 1041738487)
		 + W(7, -1114764537, -1127628368, -1116871589, -1102397253)
		 + W(8, 1040938184, 1038184662, -1107259340, -1121765359)
		 + W(9, 1021042950, -1121061927, 1045437908, -1114085178)
		 + W(10, 1034631967, 1018430000, -1130305609, -1097083551)
		 + W(11, 1049869175, 1019939330, -1105843464, -1122412137);
	sum2 = W(0, -1125184611, -1124729770, 1045115043, 1058112728) + W(1, 1023628890, 1007171579, 985313435, -1132095255)
		 + W(2, -1117207517, 1067077185, -1158219675, -1118062236)
		 + W(3, -1181860650, 1028760415, 1036693207, -1107623537)
		 + W(4, 1043689375, 1000645119, -1124740239, 1011065519)
		 + W(5, -1088457353, -1080660794, 1020427720, -1160295467)
		 + W(6, -1132645547, 1033849803, -1096437481, -1109418981)
		 + W(7, -1110185484, 1015083304, 999484231, 1015359010) + W(8, 1048821220, -1117188353, 1032363474, 1023561702)
		 + W(9, -1125466771, -1140486285, -1107942084, 1027196953)
		 + W(10, -1121893121, -1134577643, 1024683619, -1125848669)
		 + W(11, 1027562883, -1127975224, 1023023798, -1158549787);
	WS(-1085592318, -1113086899);
	sum1 =
		W(0, -1127342656, -1105245475, -1104578161, 1053241687) + W(1, -1103827813, -1138537863, 1024334944, 1029597578)
		+ W(2, -1117644382, 1041591201, 1020278010, 1015573096)
		+ W(3, -1107952998, -1104926592, -1101901257, 1051692021)
		+ W(4, -1097952575, -1110174988, 1034498345, -1110412429)
		+ W(5, 1053247055, 1044816720, -1110749814, 1033881662) + W(6, -1131633306, -1103724998, 1051300307, 1042909421)
		+ W(7, -1106968399, -1116328992, -1110168462, -1098176238)
		+ W(8, 1051451939, -1124765258, -1105195378, -1113141267)
		+ W(9, 1033648125, -1115323711, 1049307889, -1143558503)
		+ W(10, 1027981559, 1028312016, -1119681052, -1098367950)
		+ W(11, 1053283054, -1113485404, -1102600950, -1113790704);
	sum2 =
		W(0, 1019423143, -1118706158, -1110500850, 982325064) + W(1, -1117883328, -1145733922, -1134200265, -1122995556)
		+ W(2, 1021681136, -1106847870, -1115095323, 1001371122)
		+ W(3, 1022335641, -1113839515, -1121978030, 1042414810)
		+ W(4, -1112736275, 1019850892, -1126211289, -1123774588)
		+ W(5, 1048787768, 1052221246, -1118959328, -1113736050) + W(6, -1160177640, 1002859666, 1035034344, 1009324191)
		+ W(7, 1026260852, 1023767274, 995157684, -1114460336) + W(8, 1025695056, -1129766425, -1114723897, -1130130145)
		+ W(9, -1138832033, -1131104601, -1126984825, -1136621129)
		+ W(10, 1016807320, -1131688905, -1130236057, 1027754115)
		+ W(11, 1027074464, -1120353368, -1121253912, 992217060);
	WS(1025516512, -1100199588);
	sum1 =
		W(0, 1010096560, 1021891087, 1041308560, -1106994989) + W(1, -1107391304, 1032706511, 998291066, -1128181387)
		+ W(2, 1015332531, -1097993736, 1040752366, -1115681272)
		+ W(3, 1015136529, -1152435393, 1054580194, -1087955312) + W(4, 1021987303, 1013936722, 1016981531, 1035336779)
		+ W(5, 1043985948, 1049373383, 1016493518, -1153713033) + W(6, -1134306338, 1040424469, -1088067164, 1048585956)
		+ W(7, -1111549299, -1122756060, 1015217585, 1041134374) + W(8, -1097437107, 1044933000, 1015283332, 1028860515)
		+ W(9, 1025573847, -1147235028, -1108043523, 1037061588)
		+ W(10, -1125444197, -1124931799, 1027586712, -1105873140)
		+ W(11, 1024655979, 1041451309, 1025261651, 1010373746);
	sum2 =
		W(0, 1024904631, -1115115972, -1128899549, -1100416868) + W(1, 1014205090, -1138213458, -1136864762, 1023564875)
		+ W(2, -1103710322, -1105139728, -1112771593, 1024304323)
		+ W(3, 1005033941, -1114446231, -1140124434, -1107001478)
		+ W(4, -1105823902, 1028369943, 1030076655, -1115188268) + W(5, 1057566767, 1061216146, -1101449249, 1031401203)
		+ W(6, 1022202973, -1099782234, 1051976820, -1114917196) + W(7, -1115621063, -1127316949, 995105737, 1025338591)
		+ W(8, 1009750634, -1107279078, -1123827499, 1002907445)
		+ W(9, 1009257370, -1107689693, 1040613751, -1123762171)
		+ W(10, -1124460977, 1021828037, -1113660547, 1049272645)
		+ W(11, -1105716747, -1112133417, 1019919657, -1121285688);
	WS(1050734204, -1108852232);
	sum1 = W(0, -1111669430, -1116292712, -1122281377, 1027495958)
		 + W(1, -1113568120, -1123139966, 1026854009, -1106093993)
		 + W(2, -1103616254, -1113635568, -1125634353, -1117637392)
		 + W(3, -1115457556, -1104273631, 1027625969, 1042550097)
		 + W(4, -1100906821, -1147736996, 1022285659, -1090233269)
		 + W(5, 1069754213, 1065691213, -1090598793, 999398084)
		 + W(6, -1130768721, -1103820941, -1114752252, 1054098174)
		 + W(7, -1103145534, -1140005358, -1124925681, -1107176543)
		 + W(8, -1130883179, 1026991873, -1107767585, -1123096067)
		 + W(9, 988348114, -1114665965, -1144129324, 1018693905)
		 + W(10, 1007587914, -1120005196, -1117352760, -1103610460)
		 + W(11, 1032882469, 1034282506, -1112131865, -1122062653);
	sum2 =
		W(0, 1024214881, -1105712489, -1096328526, 1036545949) + W(1, -1114697429, 1029115040, -1122830075, 1026001227)
		+ W(2, -1089670730, -1104892025, 1027384734, -1127506094)
		+ W(3, 1024710111, -1105988647, -1109313571, 1042923133)
		+ W(4, -1108836817, 1018384918, -1118490155, 1044311614) + W(5, 1057951288, 1050757116, 1046225965, -1118982995)
		+ W(6, -1134765475, -1128591966, 1031038781, 1041007149) + W(7, -1111832237, 1000957030, 1007204875, 1016894538)
		+ W(8, -1135710147, -1111844715, 1020988490, 1018633070) + W(9, 955722144, -1132281374, -1121635711, 982097434)
		+ W(10, -1141601766, -1131312630, -1132418382, -1121103003)
		+ W(11, 1040031313, -1131469166, -1137288635, 1012074251);
	WS(-1077332287, -1089760701);
	sum1 =
		W(0, 998476811, -1126986618, 1035645275, 1035996661) + W(1, -1111559939, 1002151576, -1146931846, -1106320367)
		+ W(2, 1033143495, 1030948981, -1116749294, -1132098378)
		+ W(3, 1020090684, -1103512376, 1057100532, -1098691810)
		+ W(4, -1114602228, 1020764052, -1115596769, -1106044643)
		+ W(5, 1033806067, 1054020686, -1102410839, -1131285468) + W(6, 1018970620, 1033789092, -1089559024, 1053006209)
		+ W(7, -1114317262, -1143682184, -1117338894, -1121544222)
		+ W(8, -1119052427, 1053247323, -1148875196, -1140686688)
		+ W(9, -1131301080, 1025908912, -1109205213, -1117960094)
		+ W(10, 1040862618, -1112291776, -1134004534, -1120853460)
		+ W(11, 1021655744, -1112997269, 1024305160, -1137942600);
	sum2 =
		W(0, 1006079429, 1015506585, -1129173219, -1126961905) + W(1, 1025558752, 1004493969, -1142220161, 1012377004)
		+ W(2, 1019086641, 1027847692, -1121396179, -1129089615)
		+ W(3, -1129651941, 1027444401, 1029291472, -1099113060) + W(4, 1031608500, 1032469225, -1120056293, 1027255740)
		+ W(5, -1087748986, -1071778912, -1132223695, -1117547929)
		+ W(6, 1021210606, -1154390002, 1030702430, 1077548482) + W(7, 1041292060, 1017793536, -1138049810, -1121552483)
		+ W(8, 1046290929, 1017608723, 1030045463, -1115202758) + W(9, 1020679942, 988683875, -1149010889, 1009874569)
		+ W(10, -1116313503, 1024909384, -1144760977, -1149209645)
		+ W(11, 958643736, -1165018915, -1108302337, -1153372770);
	WS(1054407548, 983325672);
	sum1 =
		W(0, 1028412425, -1105600625, -1148390382, 1033571545) + W(1, 1032293767, -1124427701, -1115456470, 1033490817)
		+ W(2, 1044756246, -1114006910, -1119790070, 1037509878)
		+ W(3, 1017604747, -1115519181, -1103922376, 1059608097) + W(4, -1107101148, 1007976775, 1031921957, 1031550611)
		+ W(5, -1090010995, -1087252051, 1044072953, 1022727275)
		+ W(6, -1121692358, -1103698804, 1062123705, -1094628214)
		+ W(7, 1027680451, 1033962892, 1041128181, -1109550327) + W(8, -1103937189, 1042983319, 1021059262, -1108328080)
		+ W(9, -1131299175, 1030793272, 1039103265, -1106569209) + W(10, 1007158719, 1032055396, 1034097067, 1014014769)
		+ W(11, -1135652511, -1116995186, -1141553278, -1143059662);
	sum2 = W(0, 1007145536, 1011835040, -1115291423, 1029973058)
		 + W(1, 1036345379, -1106716830, -1108956115, 1040320325)
		 + W(2, -1145921569, -1113530029, -1116109872, 1031627486)
		 + W(3, -1123468231, 1009493536, -1120694127, 1025444390)
		 + W(4, -1106839609, -1106619549, 1003522017, 1036429861) + W(5, 1057547857, 1039825371, 1028735446, 1032586179)
		 + W(6, -1106382527, 1045134298, -1120933925, -1093621604)
		 + W(7, 1043632212, -1135351552, 1023566518, -1132203156)
		 + W(8, -1105348488, 1030401418, 1032927131, -1107014793)
		 + W(9, -1116797301, 1044032552, -1105744806, -1111109931)
		 + W(10, 1031187850, 1030984886, 1016028592, -1103689691)
		 + W(11, 1019566780, 1039637835, -1119043970, -1117261713);
	WS(1062610366, -1081620328);
	sum1 = W(0, 1034909184, 1041975919, 1038564634, -1086061975) + W(1, 1054071881, -1118145809, 1022225638, 1036878493)
		 + W(2, 1032326503, -1097049310, 1038246806, 1033815666) + W(3, 1022593144, 1038275488, 1032775158, -1094128798)
		 + W(4, 1049378869, 984752392, 1034659649, 1049110721) + W(5, -1104434937, -1097332230, 1048167927, 1040915883)
		 + W(6, -1145063906, 1039909252, -1098154666, -1096830529)
		 + W(7, 1037005773, -1127387550, 1029979468, 1050285945)
		 + W(8, -1091716385, 1031802154, -1122539766, 1042582214)
		 + W(9, 1024460554, 1032760119, -1098908862, -1125106744)
		 + W(10, 1023442918, 1025327999, -1129493655, 1052309552)
		 + W(11, -1093908076, 1033460244, -1111713187, 1038395208);
	sum2 = W(0, 1025388154, -1106689977, -1110560421, 1049316874) + W(1, 983067209, -1121273022, 1001261778, 1031762430)
		 + W(2, -1111104301, -1112011481, 1033280635, 1026153330)
		 + W(3, 1007664153, -1105078255, -1122922762, 1044332351)
		 + W(4, -1133572905, -1116643818, 1018216589, -1117638934)
		 + W(5, 1029938402, -1117360942, 1022258405, 1033323756)
		 + W(6, 1011431705, -1119019386, -1107704269, -1116357646)
		 + W(7, 1016143957, -1123412994, -1124915037, 1039919645)
		 + W(8, 1043034893, -1107523849, -1109485745, 1027380094)
		 + W(9, 1007167865, -1115769810, 1041034358, -1112781805)
		 + W(10, 1010088409, 1016238045, -1118462618, 1041969311)
		 + W(11, 1050092429, -1104673921, -1106654827, 1006440178);
	WS(-1079099231, 1058224693);
	sum1 =
		W(0, -1136025729, -1098612147, 1040574357, 1044962866) + W(1, -1107948018, -1152707357, 1041807413, 1030021338)
		+ W(2, -1113591959, 1041390773, 1030293261, 1019631368) + W(3, -1113852830, -1101745716, 1035906153, 1038641429)
		+ W(4, -1102747762, -1119110697, 1038775953, -1114342965)
		+ W(5, -1100940817, -1112997607, -1131180663, 1008365619)
		+ W(6, -1130024634, -1109189268, -1110548904, 1053521164)
		+ W(7, -1102886695, -1120409456, -1139925939, -1116898669)
		+ W(8, -1107090858, 1048687519, -1127712365, -1156710253) + W(9, 1032899333, -1169623989, 983487291, 1048553583)
		+ W(10, 1020276366, -1137865855, -1135488689, -1105924753)
		+ W(11, -1105279552, 1049805017, 1033907987, -1120648241);
	sum2 =
		W(0, 1026221982, 1031288593, 1025270629, -1105433524) + W(1, 1025604422, 1025361731, -1150712731, -1121646784)
		+ W(2, 1040465550, -1099611845, 1015298833, -1118571342)
		+ W(3, -1135858910, 1020650492, -1102699692, -1077885918) + W(4, 1013887757, 1035533544, 998750602, -1118866549)
		+ W(5, -1090773917, -1073585027, -1111404471, -1115122758)
		+ W(6, 1026066546, -1126679589, -1103726643, -1083499628)
		+ W(7, 1029004921, 1025173545, -1122173835, 1033676882) + W(8, 1038653616, 1072488285, -1128843744, -1132364945)
		+ W(9, 1019885572, -1119823506, 1044175124, 1076879885) + W(10, 1042609155, 982102231, -1114797832, 1024418530)
		+ W(11, 1035909226, 1053754278, -1128976380, -1120827581);
	WS(1039418864, -1140458522);
	sum1 = W(0, 983096624, -1114535995, 1044450572, 1027001827) + W(1, -1117675070, 1035770150, 1029517505, -1145085849)
		 + W(2, -1097839409, 1032347927, 1031259878, -1104931415)
		 + W(3, -1121873782, -1102746926, 1062380387, -1106235793)
		 + W(4, -1105839880, 1033087169, 1019803894, 1028523779)
		 + W(5, -1088253674, -1090653261, 1036696746, -1121428646)
		 + W(6, 1027911414, -1100878768, -1109645966, 1061486174)
		 + W(7, -1097301074, -1120235273, -1108005699, 1038991951)
		 + W(8, -1154916402, 1029669390, 1024178544, 1035324408)
		 + W(9, 1033576274, -1142936385, -1107146685, 1047810758)
		 + W(10, 1038477872, -1108040973, -1135118358, -1125909817)
		 + W(11, -1122115416, 1038152785, 1041849616, 1017003668);
	sum2 = W(0, -1121567066, 1033267920, -1104421963, -1130139832)
		 + W(1, -1132243276, 1024120715, 1034344084, 1026284945)
		 + W(2, -1103410132, 1037507308, 1034735332, -1109350039)
		 + W(3, -1105011035, 1033899226, 1022298858, -1102818563)
		 + W(4, 1044067085, -1127155070, -1142865888, -1120108491) + W(5, 1057117238, 1003910328, 1041074904, 975508032)
		 + W(6, -1136511728, -1122542627, 1038703002, 1043197066)
		 + W(7, -1101099519, -1117378085, -1106811819, -1120621959)
		 + W(8, 1033583066, -1124006960, -1109459597, 1001772648)
		 + W(9, 1032101677, -1134482876, -1122973141, -1124335993)
		 + W(10, 1041237660, -1113899392, -1113394506, -1114137407)
		 + W(11, 1030826553, -1125132432, -1128301632, -1126301549);
	WS(1053462780, -1083681865);
	sum1 = W(0, 1023511963, 1041747598, 1041497612, -1138339988) + W(1, 1035615616, 1020629658, -1126058411, 1015154794)
		 + W(2, 1018224530, 996055791, 1027711272, -1123213919) + W(3, 1027394040, 1045749945, 1041814811, 1014351349)
		 + W(4, 1040756601, 1032965474, -1118697149, 1048726745)
		 + W(5, -1086401302, -1082085657, 1048515830, -1129047376)
		 + W(6, 993307519, 1043007793, -1115623160, -1096882594) + W(7, 1042139693, -1132054806, 1025756296, 1038169844)
		 + W(8, 1032344226, -1105145572, 1038148425, 1033289129)
		 + W(9, -1131368524, 1024626666, -1127070442, -1110953740)
		 + W(10, 1009997960, -1128695798, 1029589575, 1040782360)
		 + W(11, -1131398580, -1110890258, 1029718722, 1029252236);
	sum2 = W(0, 1008350928, -1118714967, 1030231193, -1091889801)
		 + W(1, -1108897465, 1032606711, 1011413600, 1024023545)
		 + W(2, -1124778398, -1098641764, 1033453825, -1125648711)
		 + W(3, -1120704007, -1126562655, -1110351493, -1104262464)
		 + W(4, -1106889474, 1025836907, 1027382950, 1034951721) + W(5, 1052754126, 1057762368, 1035809187, -1131934955)
		 + W(6, -1127381517, -1128407708, 1033272406, -1161878816)
		 + W(7, -1132306565, -1134699254, 981904616, -1126139913)
		 + W(8, -1151802072, 1012148800, -1153180738, -1131180247) + W(9, 1015535284, 999360844, 1013432992, 1024540201)
		 + W(10, 1014625240, -1171757551, -1135583391, -1138986423)
		 + W(11, -1123376913, 1031971990, -1118108772, -1140791326);
	WS(-1099299320, 1056598066);
	sum1 =
		W(0, 1006197652, -1127547996, -1106221946, 1045972807) + W(1, 1004824505, -1119658116, -1128153660, 1041714651)
		+ W(2, -1098261544, 1038366195, -1113181968, 1030219574)
		+ W(3, -1136164796, 1029712499, -1085896508, 1057638589)
		+ W(4, -1113770157, -1129447670, 1035903322, -1128532088) + W(5, 1057218165, 1054413180, 1038963911, 1033715440)
		+ W(6, -1130396894, -1106761055, 1054525467, -1086573266)
		+ W(7, 1033084478, -1128924420, 1036246880, -1121593759)
		+ W(8, 1028130044, -1090476168, 1042818602, -1116035017)
		+ W(9, -1124832314, 1017604226, 1036683414, -1101308500)
		+ W(10, -1130963634, 1030841394, 1029570879, 1017990507)
		+ W(11, 1016287010, -1110319406, -1114724733, 998207538);
	sum2 =
		W(0, -1131923124, 1046772351, -1110971235, -1105011941) + W(1, 1028001687, -1121147281, 993280665, 1028557303)
		+ W(2, -1134148898, -1104446514, -1147560296, 1024426003)
		+ W(3, -1127811288, -1107794670, 1043137579, -1096504482)
		+ W(4, -1101129935, 1034898623, 1032538133, -1098564467)
		+ W(5, 1067961229, 1066594258, -1104613803, -1136832302)
		+ W(6, 992174233, -1121892222, -1095277951, -1107079502) + W(7, -1097683180, 1036381319, 1002762140, 1035775413)
		+ W(8, -1099141736, -1090299346, -1129031039, 1009264906)
		+ W(9, 1015088121, -1158807761, 1011333246, -1132433157) + W(10, -1108888578, 1032287279, 992586073, 1019898989)
		+ W(11, -1118039147, -1109952821, 1040568125, -1111357043);
	WS(-1105186296, -1108555742);
	sum1 =
		W(0, 1040483623, -1105046378, -1118442722, 1040666374) + W(1, 986662468, -1118942975, -1101386974, 1038429012)
		+ W(2, 1042743759, -1109750289, -1103538071, 1040611956) + W(3, 1040816739, 1031828819, -1093958439, 1050019912)
		+ W(4, 1033262923, -1118385334, -1134311356, -1107675004)
		+ W(5, 1030110546, 1040526743, -1121451017, 1012951144) + W(6, -1108915605, 1034430779, 1044698927, -1097473172)
		+ W(7, 1032745156, 1035127903, 1046011615, -1109709717) + W(8, -1103097566, 1045974257, 1041021277, -1100748433)
		+ W(9, -1102638726, 1030173660, 1041159370, -1110364069)
		+ W(10, -1106175813, 1037154391, 1034864637, -1130419297)
		+ W(11, -1111922822, 1017242540, 1032931450, -1121991998);
	sum2 = W(0, -1127162070, 1014979733, -1114518101, 1016203776)
		 + W(1, 1035296562, -1117887634, -1135271108, -1136185376)
		 + W(2, 1038675289, -1140478504, -1111853852, 1030827904)
		 + W(3, 1003505825, 1028363168, -1105093650, -1089585970)
		 + W(4, 1058969759, -1123277259, 1012864633, -1131143608)
		 + W(5, -1095849351, -1070239185, 1079096535, -1116960146)
		 + W(6, -1123384038, 1033256022, 1028346583, -1078361549)
		 + W(7, 1068193425, -1125445846, 1026898060, -1133517476)
		 + W(8, -1113528611, 1038794260, 1032636395, -1113311282)
		 + W(9, -1134649836, -1120532892, 1028725832, -1125525718)
		 + W(10, 1017911666, 991223090, -1125848258, 1028008335)
		 + W(11, -1117113572, 1005296645, 1032298564, -1134431064);
	WS(1065442623, 1015025160);
	sum1 =
		W(0, -1115365041, -1113215535, 1018550702, 983382403) + W(1, -1103693946, -1124004468, 1040496438, 1031517084)
		+ W(2, 1044423084, 1017412396, 1032083208, 1040563090)
		+ W(3, -1114325264, -1109245393, -1131936399, -1109909072)
		+ W(4, -1106995843, -1120263275, 1036061554, 1002812769) + W(5, 1034975748, -1099246196, 1024898238, 1012000060)
		+ W(6, 1038370800, 1036804053, 1048106991, -1114225707) + W(7, 1044531927, 1036150809, -1112496600, -1099928488)
		+ W(8, -1107673238, -1129165678, -1096349707, -1113013165)
		+ W(9, 1039123015, 1036473513, 1041344487, 1011581692) + W(10, 1043676418, 1037117105, -1120668655, -1116761110)
		+ W(11, 1019812354, -1138585900, -1110354101, -1128538214);
	sum2 =
		W(0, 1010698941, 1023126843, -1106210958, -1122624743) + W(1, -1122034237, -1117968485, 1042699596, -1140656688)
		+ W(2, 1029081919, 1040813712, -1174961495, 1039098482)
		+ W(3, 1048659418, -1095653758, -1118272649, -1097694847)
		+ W(4, 1033474214, -1118912655, 1058578114, -1081184698) + W(5, 1060468587, 996865603, -1102355565, 1020119257)
		+ W(6, 1052277576, -1097586600, 1043044817, -1103459725) + W(7, 1049205466, 1031051049, 1019470633, -1098953045)
		+ W(8, -1108654451, -1128239326, -1112376452, -1108144089)
		+ W(9, 1041036392, 1018118885, 1029721267, 1034766857) + W(10, 1033989555, 1038110136, -1119471849, -1122826054)
		+ W(11, -1130901998, 1000734433, 1017824567, -1114988670);
	WS(-1115864032, 1039792746);
	sum1 =
		W(0, -1140468214, -1121375417, 1034497081, 1039608980) + W(1, -1113171393, -1132620605, 996096400, -1108218204)
		+ W(2, 1033625894, 1040179481, -1108192053, 1018030914) + W(3, 1010495721, -1109130991, 1055392502, -1093805194)
		+ W(4, -1127063626, 1012649753, -1114956320, -1115276388)
		+ W(5, 1036829073, 1050653566, -1109643980, -1127455572) + W(6, 1013460969, 1040789857, -1088431348, 1049263376)
		+ W(7, -1124542831, -1135717173, -1122072970, -1114444905)
		+ W(8, 1030275655, 1051648994, -1129660583, -1147064482)
		+ W(9, -1127833232, 1026520268, -1111886108, -1121903450)
		+ W(10, 1034831154, -1114505023, -1140762151, -1127271361)
		+ W(11, 1031218972, -1112576115, 1019975176, -1135014713);
	sum2 =
		W(0, 1015385693, -1115435752, 1035175215, 1017441239) + W(1, -1112773411, 998363696, 1020691269, -1141202058)
		+ W(2, -1117300235, -1122675471, 1031000417, 1016207247) + W(3, 1015565489, -1111436746, 1033401267, 1055273933)
		+ W(4, -1101083444, -1113092041, 1019337403, 1040267853) + W(5, -1100581516, 1073306798, 1046685605, 1013448250)
		+ W(6, -1132207064, -1114623303, 1041259906, -1073173797)
		+ W(7, -1115311051, -1130370856, -1131086480, 1025609602)
		+ W(8, -1101351817, 1032997632, -1113329498, 1026870685)
		+ W(9, -1163542113, -1140470334, 1020278145, -1122237085)
		+ W(10, 1031244051, -1124843109, 1010427910, -1128429973)
		+ W(11, 1027629029, -1119509251, 1033297372, 1014260054);
	WS(1060418110, -1122066101);
	sum1 =
		W(0, 1031696780, -1115430516, -1104465800, 1041576533) + W(1, -1122042801, 1028261758, -1124029560, -1129767372)
		+ W(2, -1124342772, 1035204176, -1109435772, 1025573168)
		+ W(3, -1147879495, 1033383950, -1084846132, 1057835449)
		+ W(4, -1106791333, 1024098613, -1123330286, 1032201307) + W(5, 1040589380, -1121351835, 1025265863, 1000233671)
		+ W(6, -1137787811, -1124043956, 1059143665, -1085338500)
		+ W(7, 1037079395, 1020968696, 1025904121, -1135655378) + W(8, 1047669789, 1026196737, 1031201378, -1122702819)
		+ W(9, -1122010711, 1016436406, 1032251443, -1113520196)
		+ W(10, -1120875027, 1016849816, -1131825009, 1011740349)
		+ W(11, 1017074582, 1023559701, 1024540211, -1123483709);
	sum2 = W(0, -1127836624, 1033364881, -1101679270, 1023580345)
		 + W(1, -1149619356, -1136662275, -1173496113, -1127629564)
		 + W(2, -1105780675, -1119640853, 1033890881, -1122666983)
		 + W(3, 1027284157, -1104916712, -1113070309, -1132739235)
		 + W(4, -1113766541, 1023707939, 1022886010, -1097350377)
		 + W(5, 1061873799, 1062616603, -1112358042, 1028952789)
		 + W(6, 1036751625, -1105423640, -1096904559, 1009507187)
		 + W(7, -1119315178, -1117384012, -1124242822, 1034826035)
		 + W(8, -1105550966, -1098447862, 1045500652, -1137245711)
		 + W(9, 1017945890, -1122986652, -1127473876, -1116534057)
		 + W(10, 1015952658, -1136860123, -1140181115, 1033442485)
		 + W(11, -1108824717, -1115327874, 1033458469, 1001899534);
	WS(1052277756, 1024619064);
	sum1 = W(0, 1029425189, -1120340480, 1055903799, -1093981294)
		 + W(1, -1125235986, 1026200342, -1155801216, -1107014752)
		 + W(2, 1049346130, -1099678446, 1003141514, -1131584400)
		 + W(3, 1030252033, 1038469578, 1057427995, -1098793998) + W(4, 1025012844, 1031806855, -1112675811, 1032327591)
		 + W(5, -1103272826, -1090697510, -1118748640, -1126277858)
		 + W(6, 1025211073, 1034534022, 1040656272, -1103403378) + W(7, 1025335343, 1010568017, -1122395345, 1039704040)
		 + W(8, -1111436999, 1041606598, -1106833215, 1032770798) + W(9, 994289396, -1137717581, 1016775164, 1005246730)
		 + W(10, 1029370155, -1124454216, -1124711713, 1045346698)
		 + W(11, -1134653325, 1013960373, -1099652851, 1034190187);
	sum2 = W(0, 1023289146, 1045862572, -1095566322, -1087461476) + W(1, 1016132472, 1044890152, 1020437582, 1028786959)
		 + W(2, -1132354231, -1101737384, -1127607289, -1124440021)
		 + W(3, 1009748873, -1120652794, -1090793815, -1083542229)
		 + W(4, -1107157844, 1037463572, 1030199907, 1015917080) + W(5, 1063879108, 1069217208, -1097091848, 1032502373)
		 + W(6, 1007345789, -1117660774, -1107315270, 1056862945)
		 + W(7, -1098187278, 1028169917, 1010063617, -1106003069)
		 + W(8, 1045942315, -1153692567, -1116485608, -1108513707)
		 + W(9, 1018930146, 1039304637, -1106431667, -1111757292)
		 + W(10, 1036040005, 1034190881, -1127799210, -1098471935)
		 + W(11, 1048572904, 1056217861, -1094693884, -1108016950);
	WS(-1086218302, -1084258561);
	sum1 = W(0, 1027347742, 1041008695, 1040638149, -1088163117) + W(1, 1045697689, -1131589088, 1021408948, 1036310380)
		 + W(2, 1041666443, -1103354245, 1033383494, 1033326017)
		 + W(3, -1127633782, 1035524367, 1033011818, -1094269524)
		 + W(4, 1040895122, -1132088142, 1039366096, 1048593117) + W(5, 1050103608, -1122175629, 1042904478, 1042877939)
		 + W(6, -1116749595, -1138037400, -1111907839, -1096387988)
		 + W(7, -1136050786, -1131538396, 1033396118, 1045683171)
		 + W(8, -1097626581, -1103712029, 1018682217, 1039834587)
		 + W(9, -1139872292, 1032120647, -1099416246, -1111740158)
		 + W(10, -1126758410, 1030901630, 1025066091, 1046369740)
		 + W(11, -1095221944, -1117250695, -1121047845, 1034112696);
	sum2 = W(0, -1116225927, 1020583173, -1120289762, -1116630862)
		 + W(1, 1037488437, -1120774706, 1030773056, 1018516207)
		 + W(2, -1142227828, -1157244503, -1120616119, 1021325617)
		 + W(3, -1122365237, -1121497633, 1024002380, 1045806125)
		 + W(4, -1122845130, -1124264052, 1032148531, 1032012136) + W(5, 1050603076, 1061490298, 1029135782, 1020114521)
		 + W(6, -1127594672, -1111134479, 1040110681, -1104925089)
		 + W(7, -1122119114, -1129316292, 1026422036, -1112679629)
		 + W(8, -1109379336, -1096282325, 1035818151, -1129796491)
		 + W(9, 1023835916, -1123177144, -1102178993, -1103628682)
		 + W(10, -1118358279, 1024324894, -1131330830, -1112996078)
		 + W(11, -1102999759, -1116593585, 1024073644, -1129630471);
	WS(-1092406524, -1089571522);

	return clamp(mstd0 + 5.0 * vsum / wsum * mstd1, 0.0, 1.0);
}

shared float inp[507];

#define CURRENT_PASS 1

#define GET_SAMPLE(x) dot(x.rgb, rgb2y)
#define imageStore(out_image, pos, val) imageStoreOverride(pos, val.x)
void imageStoreOverride(uint2 pos, float value) { temp[pos] = (value); }

#define INPUT_tex(pos) GET_SAMPLE(vec4(texture(INPUT, pos)))
static const float2 INPUT_size = float2(GetInputSize());
static const float2 INPUT_pt = float2(GetInputPt());

#define HOOKED_tex(pos) INPUT_tex(pos)
#define HOOKED_size INPUT_size
#define HOOKED_pt INPUT_pt

void Pass1(uint2 blockStart, uint3 threadId) {
	ivec2 group_base = ivec2(gl_WorkGroupID) * ivec2(gl_WorkGroupSize);
	int local_pos = int(gl_LocalInvocationID.x) * 13 + int(gl_LocalInvocationID.y);
	for (int id = int(gl_LocalInvocationIndex); id < 507; id += int(gl_WorkGroupSize.x * gl_WorkGroupSize.y)) {
		uint x = (uint)id / 13, y = (uint)id % 13;
		inp[id] =
			HOOKED_tex(HOOKED_pt * vec2(float(group_base.x + x - (3)) + 0.5, float(group_base.y + y - (2)) + 0.5)).x;
	}
	barrier();
	vec4 ret = vec4(0.0, 0.0, 0.0, 0.0);
	vec4 ret0 = vec4(0.0, 0.0, 0.0, 0.0);
	vec4 samples[12];
	samples[0][0] = inp[local_pos + 0];
	samples[0][1] = inp[local_pos + 1];
	samples[0][2] = inp[local_pos + 2];
	samples[0][3] = inp[local_pos + 3];
	samples[1][0] = inp[local_pos + 4];
	samples[1][1] = inp[local_pos + 5];
	samples[1][2] = inp[local_pos + 13];
	samples[1][3] = inp[local_pos + 14];
	samples[2][0] = inp[local_pos + 15];
	samples[2][1] = inp[local_pos + 16];
	samples[2][2] = inp[local_pos + 17];
	samples[2][3] = inp[local_pos + 18];
	samples[3][0] = inp[local_pos + 26];
	samples[3][1] = inp[local_pos + 27];
	samples[3][2] = inp[local_pos + 28];
	samples[3][3] = inp[local_pos + 29];
	samples[4][0] = inp[local_pos + 30];
	samples[4][1] = inp[local_pos + 31];
	samples[4][2] = inp[local_pos + 39];
	samples[4][3] = inp[local_pos + 40];
	samples[5][0] = inp[local_pos + 41];
	samples[5][1] = inp[local_pos + 42];
	samples[5][2] = inp[local_pos + 43];
	samples[5][3] = inp[local_pos + 44];
	samples[6][0] = inp[local_pos + 52];
	samples[6][1] = inp[local_pos + 53];
	samples[6][2] = inp[local_pos + 54];
	samples[6][3] = inp[local_pos + 55];
	samples[7][0] = inp[local_pos + 56];
	samples[7][1] = inp[local_pos + 57];
	samples[7][2] = inp[local_pos + 65];
	samples[7][3] = inp[local_pos + 66];
	samples[8][0] = inp[local_pos + 67];
	samples[8][1] = inp[local_pos + 68];
	samples[8][2] = inp[local_pos + 69];
	samples[8][3] = inp[local_pos + 70];
	samples[9][0] = inp[local_pos + 78];
	samples[9][1] = inp[local_pos + 79];
	samples[9][2] = inp[local_pos + 80];
	samples[9][3] = inp[local_pos + 81];
	samples[10][0] = inp[local_pos + 82];
	samples[10][1] = inp[local_pos + 83];
	samples[10][2] = inp[local_pos + 91];
	samples[10][3] = inp[local_pos + 92];
	samples[11][0] = inp[local_pos + 93];
	samples[11][1] = inp[local_pos + 94];
	samples[11][2] = inp[local_pos + 95];
	samples[11][3] = inp[local_pos + 96];
	ret[0] = nnedi3(samples);
	ret0[0] = inp[local_pos + 41];
#if CURRENT_PASS == LAST_PASS
	uint2 destPos = blockStart + threadId.xy * 2;
	uint2 outputSize = GetOutputSize();
	if (destPos.x >= outputSize.x || destPos.y >= outputSize.y) {
		return;
	}
#endif
	imageStore(out_image, ivec2(gl_GlobalInvocationID) * ivec2(1, 2), ret0);
	imageStore(out_image, ivec2(gl_GlobalInvocationID) * ivec2(1, 2) + ivec2(0, 1), ret);
}
//!PASS 2
//!DESC NNEDI3 (double_x, nns64, win8x6)
//!IN INPUT, temp
//!OUT OUTPUT
//!BLOCK_SIZE 64, 8
//!NUM_THREADS 32, 8
#pragma optionNV(inline none)
float nnedi3(vec4 samples[12]) {
	float sum = 0.0, sumsq = 0.0;
	[unroll] for (int i = 0; i < 12; i++) {
		sum += dot(samples[i], vec4(1.0, 1.0, 1.0, 1.0));
		sumsq += dot(samples[i], samples[i]);
	}
	float mstd0 = sum / 48.0;
	float mstd1 = sumsq / 48.0 - mstd0 * mstd0;
	float mstd2 = mix(0.0, inversesqrt(mstd1), mstd1 >= 1.192092896e-7);
	mstd1 *= mstd2;
	float vsum = 0.0, wsum = 0.0, sum1, sum2;
#define T(x) intBitsToFloat(x)
#define W(i, w0, w1, w2, w3) dot(samples[i], vec4(T(w0), T(w1), T(w2), T(w3)))
#define WS(w0, w1)                                                                                                     \
	sum1 = exp(sum1 * mstd2 + T(w0));                                                                                  \
	sum2 = sum2 * mstd2 + T(w1);                                                                                       \
	wsum += sum1;                                                                                                      \
	vsum += sum1 * (sum2 / (1.0 + abs(sum2)));
	sum1 =
		W(0, -1120714617, 1007614003, -1123305414, 1009908268) + W(1, -1129324172, -1121901526, 1022915304, -1142748844)
		+ W(2, 1035162146, -1123901891, 1027364554, 1030225939)
		+ W(3, -1116882705, 1030599214, -1135846624, -1113117446)
		+ W(4, -1110752415, 1046176310, -1114390527, -1110762423)
		+ W(5, 1032526991, -1096831458, -1117077507, -1127767760)
		+ W(6, -1121818163, -1105876799, -1096860741, 1046191054) + W(7, 1043289735, 1052908756, 1034530771, 1039462233)
		+ W(8, 1035961863, 1034124059, 1022953826, 1023450788) + W(9, -1114841418, -1114991488, -1116257712, 1025047056)
		+ W(10, -1120878363, -1120533037, -1155422496, -1124524780)
		+ W(11, -1129613106, 1013731840, 981289536, -1143328976);
	sum2 =
		W(0, -1131108965, 1000650931, 1025688791, -1116852534) + W(1, -1145056307, -1123043594, 1018436747, -1139914565)
		+ W(2, 1043465638, -1113612493, -1106748353, 1029599173)
		+ W(3, 1045881517, -1118230687, 1029259867, -1107504809)
		+ W(4, 988544780, -1124179817, -1070139293, -1102659167) + W(5, 1078104617, 1048052425, -1126127905, 1025133515)
		+ W(6, -1145266179, -1111438835, -1110118136, -1097100047)
		+ W(7, 1027449515, 1027739737, -1136112041, 1036504803) + W(8, 1018501507, 1003301507, 1026178295, 1031198431)
		+ W(9, -1123515159, -1134523125, 995063942, -1120319069)
		+ W(10, 1021344415, -1131299129, -1123696315, 1012522521)
		+ W(11, 1024975831, 1020199127, -1162666156, -1131042995);
	WS(1061710334, -1113637247);
	sum1 = W(0, -1121814583, -1138603692, -1138264845, -1140194465)
		 + W(1, -1131439046, -1125621862, 1023073058, -1129805541)
		 + W(2, 1036106897, -1122595552, 1018454510, 1033737112)
		 + W(3, -1122735662, 1024541667, -1122620661, -1116003130)
		 + W(4, -1109309294, 1048694647, 1030681928, -1115559686)
		 + W(5, 1044326142, -1097437158, -1132933761, -1128614666)
		 + W(6, -1143950978, -1103580007, -1097890158, -1120177173)
		 + W(7, 1042373458, 1052689231, 1034486114, 1037961704) + W(8, 1033251382, 1032154570, 1019050396, 1021617155)
		 + W(9, -1113884080, -1107957310, -1116304653, 1019245786)
		 + W(10, -1118153848, -1122508490, 1012933309, -1120902675)
		 + W(11, -1152998244, 1016843898, -1144273714, -1155701620);
	sum2 =
		W(0, -1162960213, 1013908203, -1113327157, 1023571595) + W(1, -1133790043, 1024139725, -1130037920, 1007034787)
		+ W(2, -1107084454, 1023868855, 1032525526, 1048796624) + W(3, -1104878976, 1003078933, -1121062518, 1034207166)
		+ W(4, -1126626424, 1032930462, 1076098019, -1132699465)
		+ W(5, -1072747140, -1104764998, 1019199125, -1123497947)
		+ W(6, 1025411499, 1029914487, 1035900190, -1093496445) + W(7, 1026052839, -1109617402, 1025857863, -1118139493)
		+ W(8, -1126548940, 997665611, -1121182801, 1038561302)
		+ W(9, -1146184997, -1142783113, -1147685381, 1017680405)
		+ W(10, -1127269937, 1018748433, -1158385717, 1000017309)
		+ W(11, -1123007653, -1154085627, 1000677165, 1016687665);
	WS(1064800702, 1030635520);
	sum1 = W(0, 1004285524, -1122860750, -1122286551, 1021316024)
		 + W(1, -1116388951, 1022533838, -1125657162, 1001429301)
		 + W(2, -1128056492, 1024005652, 1035530413, 1053335517)
		 + W(3, -1139373960, -1130762670, -1121564617, -1129213371)
		 + W(4, 1035663048, 1031878036, 984521208, -1100061872) + W(5, 1048911707, 1035194194, -1131931048, -1141986761)
		 + W(6, -1110660706, -1116831438, 1023270757, -1093549817)
		 + W(7, -1104621327, -1149876978, -1142066105, 1031904066)
		 + W(8, -1128734654, -1204558974, -1136886024, 1042579293)
		 + W(9, -1148999845, -1142259845, -1120920449, -1111776529)
		 + W(10, 1028175148, -1143857649, 1005008153, 1016449422)
		 + W(11, -1135015336, 1010510404, 1018152308, 1020350678);
	sum2 =
		W(0, 1015139874, -1150118671, 1032711786, 1028577839) + W(1, -1116703472, -1123435694, -1140098908, -1140019692)
		+ W(2, -1120731382, -1116737087, -1087320828, -1069693959)
		+ W(3, -1103666133, -1138801588, 999422392, 1029210329) + W(4, 1017539382, 1031888972, 1059502015, 1078824499)
		+ W(5, 1045823576, 1009232228, 1011539428, -1118193829) + W(6, 1020112270, -1112637962, 1026899401, -1094071548)
		+ W(7, 1036639812, -1114441289, 1023067274, -1131442506)
		+ W(8, -1126248934, 1010207212, -1119882792, 1040940327)
		+ W(9, -1131804892, 1029410629, -1130083750, 1007549476)
		+ W(10, 1013963196, -1138130380, 1019091922, -1123861886)
		+ W(11, 1004924552, -1130443436, -1137456436, 1026106777);
	WS(1058942782, 1023618692);
	sum1 = W(0, -1126072821, 1011693912, 1017195423, -1122268692) + W(1, 1022607903, 982545387, -1126061755, 1003763447)
		 + W(2, 1041771492, 1025548876, 1036961985, 1037536142) + W(3, 1038780013, 1023558139, 1037537425, 1035261291)
		 + W(4, -1110777188, 1035801072, -1094081945, -1091452759)
		 + W(5, -1095962376, 1049096396, -1113879430, 955835050)
		 + W(6, -1110871838, 1043278082, -1103634941, -1105679152)
		 + W(7, -1103558179, -1130619215, -1136949949, 1026350907)
		 + W(8, 1036426764, -1146527995, 1046715887, 1040286827) + W(9, 1049101574, 1031851588, 1002869195, 1006549707)
		 + W(10, -1142526755, 1015953709, -1148709083, -1119884351)
		 + W(11, -1122534754, 1007174309, 1017517093, 986004587);
	sum2 =
		W(0, -1128639222, -1150616818, -1118932607, -1125568566) + W(1, 991022546, -1129687950, 1018120650, 1006676397)
		+ W(2, 1001638233, 1013509397, 1035428655, 1024255335) + W(3, 1031481278, -1111645244, 1028380841, -1115817479)
		+ W(4, -1119841411, 1029376723, 1019940778, 1063260126) + W(5, 1032753418, 1026999545, -1121385219, -1134958989)
		+ W(6, 1014385869, 1037911199, -1102461584, -1085129330) + W(7, -1110003004, 1019019978, 1021463302, 1017625850)
		+ W(8, 986023269, 970306708, -1141011097, -1110526300) + W(9, 1033244979, -1121764803, 1025283273, -1128128990)
		+ W(10, -1135260845, 1013815957, 959170344, 1017551658)
		+ W(11, 1016351942, -1127392454, 1009569613, -1138867245);
	WS(1037837808, 1056377428);
	sum1 =
		W(0, -1135573495, 1023727061, -1118803082, -1123500111) + W(1, 1020600341, -1111066541, 1008936161, -1115286797)
		+ W(2, -1105969090, -1138454045, -1114548551, 1046351686) + W(3, 1036383371, 1034647805, 1026657308, 1033474888)
		+ W(4, 1027945538, -1116105371, -1126955510, -1122693874)
		+ W(5, 1053007142, 1035274060, -1156882549, -1122516460) + W(6, 1043223694, 1039709953, 1051232418, -1100833583)
		+ W(7, -1103740252, -1101618713, 1033814037, -1129756781)
		+ W(8, -1100584037, -1111027805, -1097887999, 1040497066)
		+ W(9, 1024768136, -1138012047, -1123286772, 1010716753)
		+ W(10, 1025656415, 1021082723, 1018764077, -1115071549)
		+ W(11, 1025234525, -1116333124, 1016891995, -1114238799);
	sum2 = W(0, 1020978875, -1121670462, -1103298336, -1110731474)
		 + W(1, -1105136733, -1119790394, -1127100056, 999102475)
		 + W(2, -1100967324, -1130583533, -1096736455, 1053186254)
		 + W(3, 1045958215, 1043729632, 1033816035, 1020355333) + W(4, 1043179705, -1122981488, 1062358565, -1112891412)
		 + W(5, 1031005462, 1033523405, -1109547546, -1122874410)
		 + W(6, 1026290891, 1032797386, -1104401130, -1091109944)
		 + W(7, -1133705481, -1102472853, 1031959215, -1122532081)
		 + W(8, 1013196277, -1120286641, -1114052290, 1048200412)
		 + W(9, -1113847816, 1033631266, -1126209517, 1027184816)
		 + W(10, -1138979633, 966672716, -1152672163, -1122242747)
		 + W(11, 1023845499, -1118586102, -1147194793, -1127245018);
	WS(1050865148, 1032626572);
	sum1 = W(0, -1110436993, 1040042556, -1107890608, -1113356418)
		 + W(1, 1034032544, -1105712244, 999321197, -1110201208)
		 + W(2, 1043627312, -1101476879, 1049906138, -1109025830)
		 + W(3, -1120749707, 1051482110, -1103830356, 1048543054)
		 + W(4, -1118552440, -1108049256, -1107535228, -1162779891)
		 + W(5, -1095271743, 1035225158, -1104074479, -1106449960)
		 + W(6, 1045700875, 1033317691, -1115480133, 1049713062) + W(7, 1042738346, -1122810712, 1050825756, 1031488492)
		 + W(8, -1115060612, 1031191472, 1025393771, -1106727656)
		 + W(9, -1127443770, 1039553933, -1104755066, 1040395170)
		 + W(10, 1040430485, -1096410465, 1042925123, -1114330616)
		 + W(11, -1106585845, 1042770518, -1103219825, 1009713998);
	sum2 = W(0, 1024944996, 1020193961, 1014966838, 1015828472) + W(1, -1113612636, 1032934706, -1116105943, 1021395599)
		 + W(2, -1111924540, 1007347355, -1116539066, 1012341552)
		 + W(3, 1034050704, -1113193567, 1042584092, -1116104243)
		 + W(4, -1107012648, 1049541488, -1107447750, -1109770505)
		 + W(5, -1111197863, 1014122612, 1016467631, -1135977693) + W(6, 1057346437, 1054940943, 1059914271, 1066972918)
		 + W(7, 1063973493, 1056333532, 1045837843, 1043326701)
		 + W(8, -1105023593, -1097277462, -1142156696, 1043445868)
		 + W(9, 1017043379, -1118781870, -1113967259, -1117573943)
		 + W(10, -1097010076, -1107952444, -1085761230, -1078926120)
		 + W(11, -1084679416, -1092348708, -1128370702, -1108363561);
	WS(1054811644, 1027249161);
	sum1 =
		W(0, 1040940111, -1100243090, 1043481462, -1119365790) + W(1, -1111878381, 1044780378, -1101638738, 1035929492)
		+ W(2, -1101358582, 1036221579, 1014943347, -1109150355)
		+ W(3, 1036687602, -1109759237, 1028424107, -1122643648)
		+ W(4, -1113576073, 1038054901, -1097482896, -1106696288)
		+ W(5, 1022736646, -1097940765, 1038478827, -1103674991) + W(6, 1049141881, -1105999252, 1051960356, 1048275427)
		+ W(7, -1118345360, 1049145430, -1113101949, 1037909315)
		+ W(8, -1132483205, -1104538698, 1036681666, -1123112824)
		+ W(9, 1019000333, 1044474573, -1103799553, 1037239602)
		+ W(10, -1116754862, 1037145120, -1118995685, -1126689554)
		+ W(11, 1038634998, -1101292557, 1034438878, -1126283866);
	sum2 = W(0, 1023766557, 1015306072, -1136376403, -1113107482)
		 + W(1, 1038494252, -1113447013, 1023629411, 1024784188) + W(2, 1016554458, 1020144724, -1116988904, 1050162106)
		 + W(3, -1104347057, 1003678517, 1033762395, -1109441777)
		 + W(4, 1021815988, -1103467660, 1034521268, -1102546407)
		 + W(5, -1103257907, 1025406308, -1113239746, 1026085595)
		 + W(6, -1137435361, 1016553974, 1060795535, 1075503478) + W(7, 1072821349, -1113972415, 1031283975, 1037416902)
		 + W(8, -1114856427, 1044555388, -1088370625, -1071164689)
		 + W(9, -1077590614, -1112563255, 995356642, -1112537357)
		 + W(10, 1032032312, -1105991725, -1127777881, 1035804901)
		 + W(11, -1120944929, 1036418439, -1123929939, -1140753514);
	WS(1055940220, -1124188157);
	sum1 =
		W(0, -1113999823, 1015763751, -1115168029, 1022861696) + W(1, -1114461725, -1113117029, 1032164308, -1121800074)
		+ W(2, -1119569210, 1043278990, -1094609330, 1044340802)
		+ W(3, 1033154083, -1106205123, 1021089498, -1107756257)
		+ W(4, 1015781094, -1106256755, 1052603679, -1095339972)
		+ W(5, -1108564239, 1042723938, -1125646960, -1171638077)
		+ W(6, -1147977024, 1046188556, 1041916962, -1108128054) + W(7, 1057380776, -1095928258, 1041299799, 1027517543)
		+ W(8, -1117684995, 1036478965, 1033522483, 1047885622) + W(9, 1036635468, 1035899866, -1139371156, -1131185034)
		+ W(10, -1108336232, 1006648968, -1101485874, -1110457109)
		+ W(11, -1114614567, -1108232826, 1034599135, -1115299047);
	sum2 = W(0, -1120118804, 1013270421, -1120552641, -1117027367)
		 + W(1, 1016254148, -1110780393, 1030787932, -1133117880)
		 + W(2, -1136369034, 1027353114, -1125884733, 1035518448)
		 + W(3, 1043285424, -1129166063, -1140216380, -1120569751)
		 + W(4, -1127959037, -1129939889, -1117793827, -1095769137)
		 + W(5, -1095274849, -1117623897, -1128598589, -1129927717)
		 + W(6, 1015341014, 1034464346, -1117887441, 1043338219) + W(7, 1049861339, -1128474295, 1032330618, 1018695247)
		 + W(8, 1033327798, 1041751325, 1049619624, 1049093640) + W(9, 1048627700, 1035712363, 1035384499, 1027229852)
		 + W(10, -1113602386, -1114857235, -1103868602, -1097589990)
		 + W(11, -1105817123, -1106207094, 1004274322, -1120123842);
	WS(1057163582, 1025817537);
	sum1 = W(0, 1037167835, -1121852313, 1034559945, 1027044951) + W(1, 1039868489, 1037598609, 1007581568, 1031626785)
		 + W(2, 1031655825, 1046829204, 1038865075, 987855837) + W(3, -1105739319, -1112419405, 1015381448, 1037495244)
		 + W(4, -1096271953, -1093143228, -1085198281, 1050118415)
		 + W(5, 1057217669, 1047779928, 1035805671, 1015872616) + W(6, 1045084224, 1046279122, 1057074420, 1040167170)
		 + W(7, -1086525384, -1087515051, -1098926044, -1124461564)
		 + W(8, 1033520525, -1103697416, -1107583934, 1024989936)
		 + W(9, 1034776664, 1044254259, -1134624240, -1113253902) + W(10, 1016078798, 1030441081, 1036548879, 974934139)
		 + W(11, 1034922130, -1113468278, 1036139674, 1017385676);
	sum2 =
		W(0, -1136384493, 1023814631, 1033659202, 1017810163) + W(1, 1009967381, 1017781727, -1118180802, -1141961139)
		+ W(2, 1036526786, -1099879539, 1034332004, 1013925981)
		+ W(3, -1106516740, -1101585218, -1131784625, -1112082470)
		+ W(4, 1028719631, 1030342243, 1046758826, -1093436173) + W(5, 1051870663, 1042788701, -1114786901, -1113417628)
		+ W(6, -1123632092, 1043747658, 1050427835, -1100447595) + W(7, 1041231786, 1045006578, 1010389989, -1117114477)
		+ W(8, -1145098603, -1102737141, -1112406001, -1119158797)
		+ W(9, 1034292458, -1107586767, -1143106923, 1032164569)
		+ W(10, -1122280548, -1130733945, 1014543213, -1123106681)
		+ W(11, 1019870319, 1013053757, -1119739637, 1012643781);
	WS(-1081763615, -1092598780);
	sum1 = W(0, -1130922677, -1122514966, -1136114845, 1015393433)
		 + W(1, -1137786397, 1023447063, -1142668459, -1140705115)
		 + W(2, -1114318275, 1026414532, 1017564438, 1021344041)
		 + W(3, -1095352826, -1116164091, -1123782681, 1012849463)
		 + W(4, -1127997567, -1121576984, -1088500870, -1098266094)
		 + W(5, 1061435536, -1148866211, 1039772482, 1024002537) + W(6, 1028467828, -1127358845, 1061837768, 1035926493)
		 + W(7, -1095349722, -1114585584, -1114677716, -1116920883)
		 + W(8, 1023598927, 1017010415, -1116904946, 1037585875) + W(9, 1040151266, 1031742785, 1007413957, -1128808099)
		 + W(10, -1139280241, 1002425203, -1123987795, -1136160989)
		 + W(11, -1131570741, -1116123969, 1020007637, -1126849079);
	sum2 =
		W(0, 1021958137, -1117837187, 1026312941, -1115513274) + W(1, 1037370871, -1112242113, 1033686533, -1107052036)
		+ W(2, 1034408685, 1036094407, 1033683959, -1124949158) + W(3, -1091894288, 1027011647, -1107943508, 1010459130)
		+ W(4, -1106091708, -1147105428, -1094093059, 1061646324)
		+ W(5, 1058519893, -1106569597, 1037199097, 1030945863)
		+ W(6, -1098486326, -1110159069, -1088187103, 1055280585) + W(7, 1045036050, 1045721104, 1034325435, 1039418143)
		+ W(8, 1028745769, 1031154711, -1105512708, -1100598283)
		+ W(9, -1109806227, -1117345257, -1144974476, -1124920152)
		+ W(10, 1024682325, -1116910593, 1039406737, -1117359799)
		+ W(11, 1026080301, -1117139296, 991455177, -1112397476);
	WS(1049187708, 1061143407);
	sum1 = W(0, 1032206028, -1121811767, 1032297330, -1136528167)
		 + W(1, 1005295654, 1031846890, -1136496587, 1032778794) + W(2, 1046469409, 1033070593, 1049873346, 1050639650)
		 + W(3, 1041319460, 1041542033, 1036329419, 1043869975) + W(4, 1044620591, 1020031147, -1111788011, -1089881571)
		 + W(5, -1127219501, 1033106537, 991465499, -1112918515)
		 + W(6, -1086760535, -1113096094, -1092765627, -1083700943)
		 + W(7, -1092202425, 1011207027, 1015330121, 1026637361) + W(8, 1049164066, -1132628435, 1051671486, 1044844041)
		 + W(9, 1037004161, 1026161438, -1134373563, 1019220893) + W(10, 1022165171, 1009114287, 1034535880, 1024964917)
		 + W(11, 1011091807, 1038185039, 1018308239, 1032129132);
	sum2 =
		W(0, -1123557888, -1139662759, -1120649660, 1021700488) + W(1, -1119215196, 1025758640, -1134635263, 1025396502)
		+ W(2, 1024038368, 1022314468, 1016353740, -1149024430)
		+ W(3, -1127462832, -1109226016, 1022909500, -1106595065) + W(4, 964997605, 1007232143, -1112234110, 1052797849)
		+ W(5, 1032636001, -1096670151, -1103246759, -1095307242)
		+ W(6, -1123190992, 1040909663, 1035500288, 1059925772)
		+ W(7, -1123381020, -1110751472, -1114698588, 1016687528)
		+ W(8, -1170950771, -1119781676, -1122589660, 1021322900)
		+ W(9, -1124742672, 1037872214, -1123038904, 1025386190)
		+ W(10, 1009594487, 1011035391, -1122952928, 1015425876)
		+ W(11, 1024335912, -1115520552, 1026100870, -1128653768);
	WS(-1080960863, 1058419411);
	sum1 = W(0, -1118700722, 1032983255, -1122641758, 1033094082)
		 + W(1, -1121000958, -1133773881, -1141737059, -1120123854)
		 + W(2, -1111066847, -1112208894, -1099579692, -1090459763)
		 + W(3, -1107128402, -1107276892, -1116550064, -1103159313)
		 + W(4, 984198859, -1099715572, 1049479517, 1062349342) + W(5, -1099059374, 1033076198, -1125040759, 1037355536)
		 + W(6, 1043965403, -1113907195, 1050672334, 1061713555) + W(7, 1059583022, -1121054998, 1024684126, 1026513898)
		 + W(8, -1108783427, -1113914551, -1105019770, -1095692932)
		 + W(9, -1099879371, -1108028092, 1024533736, -1110661700)
		 + W(10, 1000248987, -1124179019, -1128328213, 1023738862)
		 + W(11, -1131329315, 1027231576, -1113801521, 1007580489);
	sum2 = W(0, 995719700, -1114687459, 1024240180, -1115935924) + W(1, 1025427056, -1123062148, 999440794, -1131128122)
		 + W(2, -1129327601, 1021214658, 997717028, 978476974) + W(3, -1140454571, 1010080137, 1002330866, -1152746908)
		 + W(4, -1125739202, 1027238209, -1120915257, -1078687396)
		 + W(5, -1111104335, -1128218828, -1147995690, -1128526870)
		 + W(6, 1029045123, 1037994429, 1036441804, 1066236156) + W(7, 1022342240, 1028953671, 1024857232, -1126806088)
		 + W(8, 1025141617, -1113434302, 1032546636, 1035362808)
		 + W(9, 1033358736, -1166615662, -1165027863, 1024563904)
		 + W(10, -1154923092, 1007115993, 1003062850, -1118441375)
		 + W(11, 1017727844, -1129048983, 1019778022, 1009762473);
	WS(-1082880574, -1095080656);
	sum1 = W(0, -1120399523, -1123397517, -1135116544, -1168421181)
		 + W(1, -1131259136, 1037719400, -1113348279, 1030740495)
		 + W(2, -1111736159, -1128373242, 1025039907, -1127950106)
		 + W(3, -1098593297, -1106461210, 1024172498, 1028249110)
		 + W(4, -1111698940, 1019423266, -1092929515, -1098702381)
		 + W(5, 1060991762, 1018082074, 1036669022, -1114016273) + W(6, 1037879414, 1028697399, 1062200098, 1023355236)
		 + W(7, -1094756999, -1115312044, -1106391640, -1109491766)
		 + W(8, 1037066756, -1119567216, -1131199446, 1027882718)
		 + W(9, 1038218895, 1022591155, -1118950442, -1141634128)
		 + W(10, -1118524245, 1027581671, -1139610160, -1139561152)
		 + W(11, 1005358744, -1113962893, 1026868195, -1126548648);
	sum2 =
		W(0, 1007561151, -1118820752, -1128452386, -1121745985)
		+ W(1, -1114861795, -1121584151, -1120079456, -1129117272)
		+ W(2, -1106890729, 1031296198, -1110907715, 1032462388) + W(3, 1035962501, 1035033495, 982365671, 1035951051)
		+ W(4, -1144059530, -1112391017, 1056169840, -1096446085)
		+ W(5, 1031556034, 987032615, -1138039959, -1119286197) + W(6, 1010626011, -1114880200, 1052511775, -1094697844)
		+ W(7, 1056886944, -1129701328, 980377326, -1126702674) + W(8, -1140206187, -1136937433, 1034255225, 1033067226)
		+ W(9, -1104164393, 1013679559, -1115367679, -1137374445)
		+ W(10, -1152147163, -1120281594, -1114711449, 993102387)
		+ W(11, -1120009849, -1122813977, -1118918686, 1006646323);
	WS(1058795070, 1058351276);
	sum1 = W(0, -1129226172, 1032650784, -1134152362, -1122312016)
		 + W(1, -1145265749, -1118796187, 1017891569, -1131365684)
		 + W(2, -1106246658, -1132244111, -1102574120, 1028257624)
		 + W(3, 1004724909, -1128587973, -1150296521, -1107598873)
		 + W(4, 1041614193, 1048401911, 1050141831, -1088102699)
		 + W(5, -1093353638, -1112285036, -1122892680, -1120116589)
		 + W(6, 1041522846, 1041471472, 1033352747, 1030285885) + W(7, 1056599450, 1049138668, 1043369227, 1040658126)
		 + W(8, -1106977045, 1031926461, -1121658742, -1124591186)
		 + W(9, -1107883356, -1114299650, -1130730345, 1034850634)
		 + W(10, -1140271486, -1130658915, -1115542891, -1119417531)
		 + W(11, -1155196377, 1003429157, -1125742491, -1137642362);
	sum2 =
		W(0, 1018264792, 1019878456, 1020074080, -1143212320) + W(1, -1148803168, -1127882992, 1017409120, -1131165168)
		+ W(2, -1109681111, -1134735936, -1106212594, 1037009054) + W(3, -1132238328, 1032289620, 990246720, 1004132864)
		+ W(4, 1028734812, -1093714299, 1034660210, 1047288883) + W(5, 1031452084, -1112028563, -1115169564, 1020410832)
		+ W(6, -1104210606, -1099909667, -1098896203, 1060586916)
		+ W(7, 1042866381, -1109339206, 1023925320, -1112228144) + W(8, 1025579416, 1032419228, 1010388000, 1030286292)
		+ W(9, -1107165918, 1019446368, 989303425, 1029468412) + W(10, 1029305888, -1113499692, 1025031188, -1130541520)
		+ W(11, -1127563664, 1026005920, -1123344268, 1009015280);
	WS(1043816952, 1056206353);
	sum1 = W(0, -1132948972, 1024900084, -1150680698, 1016358425)
		 + W(1, -1160444148, -1115326124, 1019123435, -1120343575)
		 + W(2, -1115461859, -1107172113, -1097009915, -1102438229)
		 + W(3, 1024199571, -1148961467, -1130723763, -1144998513)
		 + W(4, 1034684352, 1038250028, 1061195075, 1051576078) + W(5, -1088975285, 1010078034, -1107729186, 1022450003)
		 + W(6, 1037119642, 1039626815, -1095598055, 1056604231) + W(7, 1057172865, 1029312608, 1039764276, -1112740858)
		 + W(8, -1107088436, -1110088668, -1113187289, -1102307882)
		 + W(9, -1103288997, -1122873761, 1032878393, 1034042985)
		 + W(10, -1144087781, -1116127087, -1117712852, -1114968828)
		 + W(11, -1134624362, 1012385158, -1114736693, 1002559709);
	sum2 = W(0, -1135809827, -1140675011, -1137384851, -1147988326)
		 + W(1, 1019754904, -1172160176, 1006265798, 990940844) + W(2, 1031002711, 1009667595, -1156373420, 1010789683)
		 + W(3, -1122328477, -1135703979, 1016962928, -1135289651)
		 + W(4, -1136033931, 1025543601, -1123691685, -1105219090)
		 + W(5, -1118075063, -1111692677, -1131889022, 1010975355)
		 + W(6, -1114169661, -1124911966, 1056449903, 1044469394)
		 + W(7, 1046754031, 1034039333, 1024901767, -1111731157)
		 + W(8, -1107967067, -1108557845, -1096033675, -1118550723)
		 + W(9, 1020360378, 1005574774, 1025982043, 1036125487) + W(10, 1027957130, 1004385158, 1015282250, -1115586301)
		 + W(11, -1120013003, -1130287690, -1127946498, -1169619760);
	WS(1049886076, 1034318367);
	sum1 =
		W(0, -1140544720, 1006465467, 1025588553, -1118154094) + W(1, 996302474, -1111905052, -1125961261, -1122979160)
		+ W(2, 1022042959, -1106141033, -1104462159, -1100197533)
		+ W(3, 1029682164, -1112348667, -1117824763, -1123002959) + W(4, 1021784769, 966352080, 1059646174, 1051735858)
		+ W(5, -1085821075, 1029991670, -1111853843, 1031029131)
		+ W(6, -1131075883, 1032360624, -1086897182, 1059041662) + W(7, 1057694799, 1036690656, 1030592201, -1155480906)
		+ W(8, -1142660485, 1029412697, 1042100949, -1106256562)
		+ W(9, -1106530518, -1121375714, 1017125029, 1014936522)
		+ W(10, -1160888244, -1121174096, 1017231209, -1150715274)
		+ W(11, 1024907260, 1015672965, -1120397516, -1124207481);
	sum2 = W(0, -1110846605, -1118194097, -1143898437, 1019764549) + W(1, 1008325379, 999139301, 997400075, 1024689095)
		 + W(2, 1032320648, 1027617785, 1000132981, -1102116254)
		 + W(3, 1026769453, -1131321177, 1008054267, -1118482095)
		 + W(4, 1027180085, -1144235925, 1031570329, 1058710858)
		 + W(5, 1031557517, -1129394727, -1131248001, -1120094485)
		 + W(6, 1029603693, 1030911393, -1119293171, 1058397441)
		 + W(7, -1104852463, -1097515304, -1123234663, -1106708620)
		 + W(8, 1033577170, -1134544211, -1126616369, -1096477332)
		 + W(9, -1103611475, -1115701158, -1119810656, -1134741251)
		 + W(10, -1112673640, -1123614185, -1129974305, 1018853209)
		 + W(11, 1036639048, 1018401637, 1024391909, 1017993989);
	WS(1058429118, 1064863249);
	sum1 =
		W(0, 1021156518, 1024394983, 1020219616, -1131178666) + W(1, 1016100640, 1007341951, 994206685, 964693930)
		+ W(2, 983001563, -1115666854, 1039490386, 1046648007) + W(3, 1017911734, 1043757188, -1128564932, 1045299318)
		+ W(4, 1054264097, 1049468028, 1055450440, -1104196510) + W(5, 992909240, -1104186631, -1122765517, -1105268364)
		+ W(6, -1097350840, -1099725362, -1115114453, -1085827188)
		+ W(7, -1100930382, -1128095056, -1118903024, 1023907580) + W(8, -1175841770, 1024539904, 997016493, 1043203980)
		+ W(9, 1033767351, -1119513801, -1131557236, -1106015350)
		+ W(10, 964768362, -1149024695, 1012766063, 1022718592)
		+ W(11, -1136266891, 1035657141, 1016423590, 1029236260);
	sum2 =
		W(0, 1005391535, 1018096716, -1135288360, -1121648533) + W(1, 996459166, -1130245220, -1123582348, 1033610651)
		+ W(2, -1106696811, -1121907467, 1026226746, 1031305614)
		+ W(3, 1032267559, -1111725659, 1028271694, -1108648643) + W(4, 1050575955, 1051313221, 1047952814, -1081952512)
		+ W(5, 1040750694, 1031579134, 1007524520, 1034169827) + W(6, -1100156814, 1060662591, 1068258385, -1074657656)
		+ W(7, -1095314974, 1036231973, 1044691450, 1044987108) + W(8, -1098256564, 1029467086, -1142136447, 1051661425)
		+ W(9, 1035381379, -1107714686, 1022647148, -1100160947)
		+ W(10, 1028021126, -1129063320, -1131820748, 1008147176)
		+ W(11, -1168737402, 1020424408, -1129848660, 1024695710);
	WS(-1083443454, 998713176);
	sum1 = W(0, 1032696047, 1026355790, 1024354795, 1034252472) + W(1, 1012872363, 1032281789, 1027888345, 1016830581)
		 + W(2, 1040709994, 1040668906, 1036398699, 1051748575) + W(3, 1035129883, 1044965075, 1031400701, 1048807512)
		 + W(4, 1040929033, 1032459486, 1012490030, -1097753826)
		 + W(5, -1114537329, -1100635790, -1103916602, -1098186970)
		 + W(6, -1087559501, -1103862520, -1102928053, -1093112676)
		 + W(7, -1092883854, -1099081393, -1104850339, -1112352715)
		 + W(8, 1049786774, 1037090637, 1047072725, 1050721065) + W(9, 1039546228, 1011437457, 1009955155, -1114553850)
		 + W(10, -1146095614, 1033091241, 1024780023, 1037512365)
		 + W(11, 1024615038, 1037286498, 1036010231, 1033653631);
	sum2 =
		W(0, 1035861958, -1161872500, -1113290777, -1137177342) + W(1, 1034613598, -1103597964, 1038756242, -1111249467)
		+ W(2, -1098289107, -1119785106, 1033623622, 1045692473)
		+ W(3, -1106425659, -1117971136, 1019694879, -1114046628)
		+ W(4, 1026686124, 1049978705, -1098402027, 1024040864) + W(5, 1053770527, -1127968019, 1049090628, 1052585151)
		+ W(6, -1096172460, -1107697817, -1091833397, 1013412750)
		+ W(7, 1046082211, 1057075430, 1047895771, -1102204197) + W(8, -1113513064, 1027596044, -1098063812, 1031079096)
		+ W(9, 1012376430, -1095279992, 1045163433, -1100444173)
		+ W(10, 1019723703, -1121217732, 1033198374, -1107709748)
		+ W(11, 1038124498, -1112843267, -1120386622, 1034273086);
	WS(-1086369662, -1078015058);
	sum1 =
		W(0, 1024279387, -1100066053, 1039589628, -1104719791) + W(1, -1113174076, -1125885710, -1111149795, 1024511623)
		+ W(2, 1042615374, -1106499229, 1049518735, -1115604002)
		+ W(3, -1127523972, 1049389829, -1102519338, 1042212335)
		+ W(4, 1054091094, -1113085188, 1050614757, -1103236040) + W(5, 1047781504, -1108066658, 1041501469, 1048227542)
		+ W(6, -1095346029, -1103658220, -1097514477, -1100854410)
		+ W(7, -1097175852, 1026529231, -1104719494, -1099302313)
		+ W(8, 1050416872, -1111759460, 1048966812, -1122281110) + W(9, 1043919349, 1032565272, 1027138593, 1036646913)
		+ W(10, -1113840294, -1141254386, 1032485602, -1113439156)
		+ W(11, -1119980106, 1039770777, -1104628175, 1032389542);
	sum2 = W(0, -1092512531, -1093473489, -1081280020, -1076988140)
		 + W(1, -1081342477, -1086556968, -1107875638, -1121362077)
		 + W(2, -1098738343, -1088925799, 1042571962, 1043337888)
		 + W(3, 1033193400, 1010020371, -1102154130, -1126174974) + W(4, 1063615535, 1062426368, 1067242406, 1066811408)
		 + W(5, 1066297017, 1060290312, 1052028857, 1037059936) + W(6, 1009177475, 1026425874, 998962046, -1096426756)
		 + W(7, 1022780060, 1026166068, 1017583668, -1119102823)
		 + W(8, -1119750726, 1012050343, 1025403720, -1129159374)
		 + W(9, 1023044380, -1115355073, 1026819560, -1127777686)
		 + W(10, 1030476954, -1120184004, 1031881676, -1116680638)
		 + W(11, -1135563955, 1004442726, 946141982, 1034449190);
	WS(-1129707456, 1007685382);
	sum1 = W(0, -1134894751, 1044154267, -1111052786, 1038046773)
		 + W(1, -1192544411, -1128991721, 1035051017, -1122391156)
		 + W(2, -1098519836, 1030394337, -1107874844, -1118678129)
		 + W(3, -1111301144, -1115520098, 1015910765, -1103669035)
		 + W(4, 1040671079, 1013414869, -1103276809, -1098881194)
		 + W(5, -1110522396, -1107120076, 1033063921, -1111557603)
		 + W(6, 1044073412, 1041040503, 1038778991, -1107344299) + W(7, 1048980909, 1052479600, 1049200001, 1051478546)
		 + W(8, -1109530006, 1035376874, -1105794628, -1139987723)
		 + W(9, -1108336721, -1112546431, 1023468750, 1018554845)
		 + W(10, -1134057701, 1028314315, -1112561176, 992777541)
		 + W(11, -1112828028, -1132207293, 999515194, -1119107128);
	sum2 =
		W(0, -1137824107, -1126465818, 1005362547, -1158497445) + W(1, -1119770196, 1021074352, -1138544392, 1034621027)
		+ W(2, -1110122518, 1033612180, -1116868027, 1039739597)
		+ W(3, 1037998233, -1112420682, 1025116420, -1120069279)
		+ W(4, -1137081539, -1106894813, 1045165527, -1106604299)
		+ W(5, -1138568822, 1039276731, -1104439342, -1113398206) + W(6, 1039063461, 1047362418, 1067526191, 1071589227)
		+ W(7, 1061860820, -1077533661, -1073373771, -1094637864)
		+ W(8, -1158403413, -1117814890, -1136640937, 1044031039)
		+ W(9, -1133800170, 1031122886, -1106196407, 1031315442)
		+ W(10, -1124656554, 1023374342, -1115663214, -1148955153)
		+ W(11, -1123862185, 999718675, -1139157324, 1025985948);
	WS(1033791472, -1138498893);
	sum1 = W(0, -1143657507, 1014781903, 1029133201, 1018917100) + W(1, 998381448, 1016812674, -1118545247, -1137667330)
		 + W(2, -1102835756, -1108646231, -1108649138, -1106020223)
		 + W(3, 1003669472, -1113672010, -1114481905, -1127743919)
		 + W(4, 1024249065, -1130492804, 1008218246, 1054388603)
		 + W(5, -1092207694, -1132293500, -1112726231, -1119594899)
		 + W(6, 1044190455, 1021681616, -1115040338, 1058377694) + W(7, 1046387590, 1049136345, 1017676194, -1119541597)
		 + W(8, -1107762844, -1112711792, 1019895480, -1123372431)
		 + W(9, -1111491159, -1123523050, -1123035739, 1028355707)
		 + W(10, 1008291608, -1128240816, 1025256893, 1014932868)
		 + W(11, 1007448080, 1008489644, -1112884042, 1001709096);
	sum2 = W(0, 1014470821, -1120344268, -1114330800, -1106002658)
		 + W(1, 1024999308, -1126273593, -1127411221, -1123975632)
		 + W(2, -1106657768, -1106292024, 1049926230, 1054743689)
		 + W(3, -1112305858, -1122403994, -1116955850, 1030827431)
		 + W(4, 1034825132, 1032219219, 1057813788, 1049962194) + W(5, 1051810194, 996027236, 984340447, -1114551452)
		 + W(6, 1006830039, -1101139832, -1102461554, -1103958261)
		 + W(7, -1098680718, 1040205712, -1109277736, -1111240037)
		 + W(8, -1104684796, -1114556582, -1111886229, 1050373872)
		 + W(9, 1035894797, -1100520246, 1014102650, -1106040331)
		 + W(10, -1124459301, 1008940380, 1029827978, -1133852786)
		 + W(11, -1109427720, 1024816377, -1117160816, 1003623824);
	WS(1060089726, 1074996161);
	sum1 =
		W(0, -1117558175, 1029119241, -1141503452, 1010789890) + W(1, 1037081758, -1120312844, 1027150698, 1021223318)
		+ W(2, 1046443391, 1039893948, 1041448800, 1035829124) + W(3, 1041862066, 1028398131, 1038548631, 1047369209)
		+ W(4, -1083103171, -1093429938, -1088988175, 1032282738)
		+ W(5, 1035486030, -1142682180, -1111879740, -1105296983) + W(6, 1040714346, 1021452133, 1048946821, 1021975771)
		+ W(7, 1040332065, -1090323173, -1112512014, -1095359061) + W(8, 1044503809, 1030628716, 1038933875, 1038764813)
		+ W(9, 1032949373, 1041097413, 1029165798, 1046714577) + W(10, 1023987857, 1027140771, 1026874120, 1026271340)
		+ W(11, 1034225415, -1113760891, 1028642719, -1134282558);
	sum2 =
		W(0, -1130708327, -1156760442, 1011385503, 1005458237) + W(1, 1015786967, -1121500080, 1023017975, 1008927007)
		+ W(2, -1131662151, -1160974837, -1122121264, -1104012424)
		+ W(3, 1025508020, -1106371091, 1032453110, -1107217673) + W(4, 1027052068, -1119116140, 1006726095, 1053197196)
		+ W(5, -1150821434, 1032166230, -1116451706, -1143126685)
		+ W(6, -1104634511, -1148640061, -1101053828, 1050251696)
		+ W(7, 1043632028, -1115585403, 1032061998, 1045664978) + W(8, 1037500532, 1028521640, 1041142688, -1121651972)
		+ W(9, -1105814552, -1117076340, -1120517680, -1103126409)
		+ W(10, -1117309872, -1132259207, -1129219511, -1148190653)
		+ W(11, 1005943453, -1120252400, 1024831312, -1126349911);
	WS(-1081408895, 1057237802);
	sum1 = W(0, 1016592219, -1135569700, 1019913045, -1134722237) + W(1, 1020337237, 1019971573, 1015924209, 1027236154)
		 + W(2, 1050393725, 1025037351, 1042967287, 1042881918) + W(3, 1033060699, 1038993285, 1028206140, 1041649576)
		 + W(4, -1096948620, 1021729271, -1123436299, -1107250293)
		 + W(5, 1047123275, 1037602588, 1034435092, 1044331459)
		 + W(6, -1099121222, -1114451665, -1104931659, -1092679092)
		 + W(7, -1098053310, -1091584672, -1092984777, -1089381821)
		 + W(8, 1042338077, 1033766733, 1036822635, 1042265522) + W(9, 1043883210, 1042862441, 1029491668, 1042007901)
		 + W(10, 1026859007, 1023688209, 994107237, 1017621813) + W(11, 1033354815, -1147819555, 1035642823, 963919445);
	sum2 =
		W(0, -1127968320, 1036537032, -1112917417, 1020801080) + W(1, 1019615648, -1127208552, 1023589392, -1121416948)
		+ W(2, -1092240358, 1030963640, -1097473768, -1109029546)
		+ W(3, -1116583352, 1028578068, -1113404853, 1041090246) + W(4, 1057542400, -1105653780, 1053316325, 1058712288)
		+ W(5, 1043894648, -1093453186, 1034405836, -1094394128) + W(6, 1016463192, -1097383073, 1038201480, 1052867895)
		+ W(7, -1123129572, -1141347136, 1006791808, 1037486484)
		+ W(8, -1094079665, 1040975890, -1101066411, 1013027424)
		+ W(9, -1118015492, -1117505000, -1111557726, 1044943944)
		+ W(10, 1037438732, 1019305024, 1028884816, 1010261952)
		+ W(11, 1027371024, -1113360113, 1034904608, -1104647878);
	WS(-1076745215, 1064070508);
	sum1 = W(0, 1019383636, -1138649581, 1029667879, -1127653591) + W(1, 1027426151, 1022926189, 1004012708, 1016119660)
		 + W(2, 1043437193, 1030286820, 1040316179, 1048543741) + W(3, 1029763954, 1039947283, 1025479577, 1041368223)
		 + W(4, -1100863080, 1033675388, -1102225484, -1084687593)
		 + W(5, -1111626052, 1026499316, -1122995300, 1026134601)
		 + W(6, 1019299111, 1027453406, -1110289513, -1082029409) + W(7, 983973284, 1031954367, -1118301831, 1016553765)
		 + W(8, 1041928012, 1031909515, 1043406276, 1044625233) + W(9, 1044339921, 1039879984, 1022733729, 1012331970)
		 + W(10, 1018313975, -1136380470, 1026991539, -1136351578)
		 + W(11, 1027257018, 1022902273, 1026798858, 1027440187);
	sum2 = W(0, -1131696089, 1008718823, -1149188438, -1140198251)
		 + W(1, -1129603953, 1007479839, -1141563590, 1018622169)
		 + W(2, 1012459087, -1135045027, -1118135053, 1033739972)
		 + W(3, -1142742214, 1015462815, -1126906553, -1135479163)
		 + W(4, -1112347233, -1125420309, 1041969824, 1052325325)
		 + W(5, 1029891118, -1120072309, 1017890385, 1016803437) + W(6, 1039451269, -1110618065, 1024383435, 1052741682)
		 + W(7, -1121721953, -1095903036, -1105015368, -1098230278)
		 + W(8, -1158657302, 1007247903, 1015365577, 1034080133)
		 + W(9, -1110453303, -1162307222, -1122346803, 1021342643)
		 + W(10, -1129595249, 999949222, -1130814181, -1140370763)
		 + W(11, 1020979581, -1132990667, 1008938691, -1137891195);
	WS(-1094563452, 1051169575);
	sum1 =
		W(0, -1154622990, 1029393378, -1117775501, 1033996553) + W(1, -1136342582, 1018491963, 1032030382, 1015760954)
		+ W(2, 1018130713, 1035203109, -1113234793, -1106127031)
		+ W(3, -1114335628, -1112874623, 1023872671, -1110067034)
		+ W(4, 1040428881, 1032896399, 1049040808, -1112183035) + W(5, 1048012112, 1044702279, 1032915973, 1035998904)
		+ W(6, -1120902330, 1039535746, -1102863965, -1090463816) + W(7, 961094679, -1098092733, 1033184663, 1029109433)
		+ W(8, -1113835211, 1021002107, -1107942972, -1105904891)
		+ W(9, -1148767576, -1124337998, 1006151100, -1110631596)
		+ W(10, 1019319877, 1036762426, -1135300966, 1040237135)
		+ W(11, 1032716400, -1137189022, 1037223880, 1013167238);
	sum2 =
		W(0, 1028413027, -1120070369, 1012563150, -1111535757) + W(1, 1011962278, 1009477102, -1153318262, 974823129)
		+ W(2, -1121092135, -1130520759, -1120753460, -1097640928)
		+ W(3, -1098008778, 999766235, -1122757360, -1129371381) + W(4, 1017337743, 1037177446, -1106734706, 1051800696)
		+ W(5, 1035782812, -1106510696, 1010623246, 1028214977) + W(6, -1137632446, -1104029390, 1048794348, 1050145982)
		+ W(7, -1114477541, 1047938812, -1111017918, -1123769252) + W(8, 999930971, 1033133092, -1111694827, 1041394994)
		+ W(9, -1118971109, -1127041263, 1020162151, -1124747017)
		+ W(10, 1027578971, -1114678191, 1030530567, -1119592910)
		+ W(11, 1001961835, 1024176823, -1115486877, 1007999422);
	WS(1057759166, -1088449289);
	sum1 =
		W(0, -1129635066, 1025446574, -1144519245, 1017539549) + W(1, 1026395242, -1122678010, 1025431320, 1024557433)
		+ W(2, 1044873994, 1037627635, 1041685209, 1033910011) + W(3, 1039651930, 1035038013, 1039320958, 1038868536)
		+ W(4, -1087389198, -1097118359, -1089578865, -1129568803)
		+ W(5, 1010566389, 1030050103, -1110122707, -1112614790)
		+ W(6, -1116302487, 1022204225, 1022125102, -1105345911)
		+ W(7, -1122366800, -1097803608, -1119554634, -1126568107)
		+ W(8, 1048786726, 1039292653, 1045860709, 1045748274) + W(9, 1027479143, 1033498658, -1161253492, 1010965710)
		+ W(10, 1017011581, 1021371937, 1025212662, 1031878029) + W(11, 1013486066, 1007580942, 1028360045, 1015223035);
	sum2 = W(0, -1162281894, -1124547002, -1150111187, -1135956229)
		 + W(1, -1145634890, 965409433, -1123274137, 1024679583) + W(2, 1033992046, -1149048922, 988741862, -1132541637)
		 + W(3, -1132011310, 1024739191, 1008671821, -1129294934)
		 + W(4, 1042856153, 1036788056, -1112557119, -1097406101)
		 + W(5, -1121853795, -1104384368, 1032013500, -1147059498)
		 + W(6, 1038465062, 1046094595, 1060179844, 1049669935) + W(7, -1101657128, 1042681611, -1111116605, 1027020519)
		 + W(8, -1093956780, -1100316514, -1090501223, 1022378118)
		 + W(9, 1045140163, -1121116299, 1035479824, -1131272734)
		 + W(10, 1024284423, 1035682376, -1122577303, -1113139255)
		 + W(11, -1130855582, -1118824057, 1006161754, -1124922046);
	WS(-1086987838, -1100233980);
	sum1 =
		W(0, 1015308459, -1122325985, -1116672610, 1032904116) + W(1, -1141168915, 1033123257, 1001375875, 1015833828)
		+ W(2, 1041765192, 1028094431, 1042485054, -1118546351) + W(3, -1118052589, -1116818498, 992241989, 1015146386)
		+ W(4, -1105415847, -1114108890, -1092596043, 1046690691) + W(5, 1054244345, 1049735534, 1040724504, 1041637233)
		+ W(6, 1042444900, 1041449686, 1049087917, -1128556841)
		+ W(7, -1089307961, -1094503991, -1104029377, -1100869156)
		+ W(8, -1111075669, -1106140165, -1110170951, 1034284768)
		+ W(9, 1026589088, 1030527932, 1008796465, -1123717612) + W(10, 1003799483, 1034767973, -1144225139, 1033288361)
		+ W(11, 1010481109, -1121578684, 1030765989, -1124977133);
	sum2 = W(0, -1128145157, 1026284201, 1012811840, -1136599052) + W(1, 992541697, 1011005728, -1127430370, 995789721)
		 + W(2, -1100557855, -1106810438, 1042787919, 1044596046)
		 + W(3, 1038174685, -1104618112, -1166127490, -1116633305)
		 + W(4, 1057648426, 1054522141, -1098531848, -1073275189) + W(5, 1061008073, 1059653331, 1035655860, 1017274260)
		 + W(6, 1048654145, 1057115188, 1046636853, -1074262745) + W(7, 1044984510, 1060082709, 1034192337, 1033697834)
		 + W(8, -1122215769, -1103409060, 1046426252, 1035358469)
		 + W(9, 1036107748, -1104639697, -1130597644, -1112828961)
		 + W(10, -1133425768, 1017140792, -1118227807, -1143532160)
		 + W(11, 1016191398, 981079778, 1006837720, 1021901152);
	WS(-1092446204, 989212831);
	sum1 =
		W(0, 1007124942, -1116778591, 1027403088, -1121715541) + W(1, 1019921952, 1020332096, -1139218425, 1020381759)
		+ W(2, 1048125124, -1131432602, 1042237585, -1138060917)
		+ W(3, 1027977243, -1126238792, -1131884420, 1024321015)
		+ W(4, -1138101793, -1106585464, 1016240146, 1037962972) + W(5, 1053191424, 1053622732, 1043276755, 1049124886)
		+ W(6, -1141178857, 1019782926, 1036610823, -1101006449)
		+ W(7, -1094792341, -1089064867, -1101892348, -1107274751)
		+ W(8, -1102978326, -1115311760, -1110971902, -1114322839)
		+ W(9, 1031189102, -1137835047, -1132849129, -1110951117)
		+ W(10, 1034583667, 1015089582, 1027127900, 1008360193) + W(11, 1028625507, 1017386452, 1009465805, 1008208785);
	sum2 =
		W(0, -1120159352, -1125980662, -1131578305, 1028063854) + W(1, 1021975879, 1033612769, -1119579693, 1040487308)
		+ W(2, -1088595541, 1050146519, -1090859444, -1107336769)
		+ W(3, -1105868965, 1041431951, -1112749441, 1042279365) + W(4, 1060560783, -1093128727, 1057304640, 1071289406)
		+ W(5, -1087527230, -1086794372, 982969010, -1089785065) + W(6, 1061831343, -1098317152, 1057012981, 1069689231)
		+ W(7, -1097221007, -1086042421, 1033122226, -1088997285)
		+ W(8, -1089452071, 1042347964, -1095995319, -1096815763)
		+ W(9, -1104502319, 1049524493, -1104150062, -1135764460)
		+ W(10, -1101640393, 1038452583, -1105624394, 1041229675)
		+ W(11, 1037791301, -1143180172, 1029453052, 1049121852);
	WS(-1080642303, 1037515653);
	sum1 = W(0, 1014399585, 1040389217, 1025436037, 1035628117) + W(1, 1032176658, 1019714410, 1031481267, -1129425897)
		 + W(2, -1123461796, 1009459592, -1118449912, -1111999897)
		 + W(3, 1042449564, -1098862637, 1015874414, -1108656118)
		 + W(4, -1115821917, -1138501592, 1046808963, 1046961203)
		 + W(5, -1085801589, 1042823052, 1032561937, 1022709518) + W(6, 1037702505, 1046330151, -1088063230, 1048171302)
		 + W(7, 1046621083, 1033619294, 1017602698, -1172911161)
		 + W(8, -1105260875, -1113097082, -1166545913, -1112931778)
		 + W(9, -1116953058, -1108126015, 1033606503, -1161936349)
		 + W(10, -1134503912, 1032999462, 1011659972, 1033647146)
		 + W(11, 1020514160, 1023868127, 1030447848, 1015791986);
	sum2 = W(0, -1139497271, 1025910769, -1105297083, 1037339247)
		 + W(1, -1111547600, -1123186639, 1029488041, -1137152287)
		 + W(2, -1104932637, 1043978669, -1105480129, 1037617885)
		 + W(3, -1107402541, -1105522985, 1011577705, -1102258444)
		 + W(4, 1000924601, -1116100213, -1102785010, 1049988969) + W(5, 1045831134, 1040977948, 1036894407, 1025599417)
		 + W(6, 1034980171, 1042493673, 1044002411, 1050036780) + W(7, 1039942071, -1097804729, 1042714488, -1139888185)
		 + W(8, -1102656208, 1038409695, -1098474508, -1122964745)
		 + W(9, -1106907325, 1028039731, -1112976714, -1112698813)
		 + W(10, -1154378706, 1025837919, -1109802618, 1036616991)
		 + W(11, -1132149525, -1111839940, 1040500443, -1114191023);
	WS(1060124606, -1084472548);
	sum1 = W(0, 1012638700, -1131934189, -1129347279, -1138043955) + W(1, 1007380511, 1022374575, 996895579, 992489843)
		 + W(2, -1112711971, 1021193865, -1125331574, 1048955067)
		 + W(3, -1106488069, -1115361884, -1120058426, -1118477310)
		 + W(4, 1024524352, 1017460401, -1113956442, -1094951982)
		 + W(5, 1048203795, 1005249701, 1026650437, -1129456851) + W(6, 1032623962, -1117271615, 1049120342, 1015143283)
		 + W(7, -1110142007, 1024310560, -1121731240, 1036683482)
		 + W(8, -1115629480, 1023262959, -1108495481, 1031640934)
		 + W(9, -1129214986, -1136673413, 1017029987, -1115998674)
		 + W(10, 1027484509, -1157409515, 1010910287, 1021584239)
		 + W(11, -1144904917, 1017598403, -1145343061, 1014521967);
	sum2 = W(0, -1113301049, -1129519836, -1113144608, -1114997262)
		 + W(1, 1028189537, -1144798799, -1135227415, -1123606042)
		 + W(2, 1041723134, 1018887182, 1065721494, 1081282167) + W(3, 1053752802, 1004635839, 1024321495, 1032429021)
		 + W(4, -1119425470, -1123219625, -1082046556, -1068115046)
		 + W(5, -1091841582, -1126716683, -1149813598, -1137534547)
		 + W(6, 1012563935, 1021107126, 1032971141, -1092304788) + W(7, -1120681827, 1026059029, 992723582, -1121765421)
		 + W(8, 1013366251, -1131491053, -1132479565, 1028331651)
		 + W(9, 1021570574, -1132445755, 1010781703, 1024141029)
		 + W(10, -1135264199, 1017265018, -1135106943, 927030725)
		 + W(11, 983594844, -1137356791, 959859164, -1123588459);
	WS(1064307390, 997943845);
	sum1 = W(0, 1016504192, 1004931163, 1001468389, -1125536771) + W(1, 1024701821, -1157300426, 1008115882, 1014991280)
		 + W(2, -1110031838, -1124632947, -1106796660, -1132488742)
		 + W(3, -1111862756, -1111316170, -1153319146, -1116314499)
		 + W(4, -1108555962, -1129767067, -1106350773, -1097456765)
		 + W(5, 1040312105, -1110123941, 1030600762, -1109063375) + W(6, 1047561626, 1003984285, 1053522405, 1050670238)
		 + W(7, -1128004006, 1039422954, 1005773541, 1042190650)
		 + W(8, -1114174882, 1017992857, -1106382906, -1136221548)
		 + W(9, -1123896954, 1020844396, 1015300557, 1024320647) + W(10, 1004953741, 1018940039, 1000370245, 1015934681)
		 + W(11, 1011062590, -1128259885, -1153739770, -1130969505);
	sum2 = W(0, 1036505224, 1018720963, 1037554666, 1035136259) + W(1, -1131720942, 1012123245, 1027168757, 1024471767)
		 + W(2, -1100095598, -1119632397, -1082101932, -1072130218)
		 + W(3, -1090292986, -1114842502, -1108983905, -1105383800)
		 + W(4, 1039944480, 1033659023, 1064933062, 1074634461) + W(5, 1057038142, 1046242606, 1018437263, 1041395450)
		 + W(6, -1110028565, 1025734363, -1103479495, 1012777017)
		 + W(7, -1132873326, -1117820012, -1117294599, 1033191694)
		 + W(8, 1016119595, 1015545311, 1036578506, 1036162128)
		 + W(9, -1120419990, -1115011900, 1004277346, -1113427773)
		 + W(10, 1017378303, -1126149289, 1022196513, -1118704038)
		 + W(11, 1020047721, 1033886326, -1136709697, 1024978781);
	WS(1053812476, -1113586226);
	sum1 =
		W(0, -1130399840, 1028349447, 1021963321, -1121520129) + W(1, 1020769785, -1115853964, 1021860117, -1121122124)
		+ W(2, -1111011390, -1120416825, -1107941440, -1106086226)
		+ W(3, -1129958415, -1107644952, -1122155502, -1114352785)
		+ W(4, 1007197394, -1105796643, 1056809437, 1046348585) + W(5, -1090756230, 1050300257, -1116443513, 1041113720)
		+ W(6, 1037708373, 1044272829, -1093131829, 1057081835) + W(7, 1059679544, -1119895572, 1040260199, -1110926804)
		+ W(8, -1122978308, -1110423782, -1122097703, -1099751719)
		+ W(9, -1102044582, -1111488955, 1019054925, -1156322407)
		+ W(10, -1139049030, -1125249991, 1011721762, -1114497366)
		+ W(11, 1018253471, 1022041005, -1121197023, -1135672898);
	sum2 = W(0, 1015672618, -1121994623, -1149412980, -1127744422)
		 + W(1, 990134373, 1024671460, -1132259460, -1125579600) + W(2, 1010541588, 1032866568, 1044676778, -1124040172)
		 + W(3, -1102290659, 1029499881, -1120084193, 1001699435)
		 + W(4, -1115998566, 1011616452, -1107438884, 1058620442)
		 + W(5, 1049322309, -1104592911, 1035840939, -1123886068)
		 + W(6, 1020421847, -1095022641, -1097106911, 1015017230)
		 + W(7, -1104275347, 1045525693, -1119993661, 1037165892)
		 + W(8, -1129704409, 1020628925, -1112769863, -1113422252)
		 + W(9, 1039268635, 1026741584, 999745387, -1126762930) + W(10, 1015113530, 1017019595, 1022483811, 1015061518)
		 + W(11, -1114030797, -1136765715, -1131682952, -1134246014);
	WS(1059863230, -1098226968);
	sum1 =
		W(0, -1111154474, 1033627108, -1111220881, 1018934285) + W(1, -1156119577, -1108034825, 1035708952, -1116166225)
		+ W(2, -1130042625, 1044463840, -1098768819, 1036585799)
		+ W(3, 1041677635, -1100472134, 1038444026, -1111999396)
		+ W(4, -1124092147, -1125693093, 1043860042, -1094381437) + W(5, 1034781361, 1038465479, 1027036095, 1019243847)
		+ W(6, -1126659421, 1045974478, 1040108899, -1098844542) + W(7, 1051479065, -1096809363, 1040658808, 1003830125)
		+ W(8, -1116454602, 1040744732, -1149847241, 1043775752)
		+ W(9, 1046003792, -1121805723, 1037992790, -1131289879)
		+ W(10, -1109234699, 1026252457, -1103478147, -1107008620)
		+ W(11, -1127254569, -1105262391, 1038964162, -1116821910);
	sum2 = W(0, 1031860762, -1114215534, 1037917300, -1123072391)
		 + W(1, -1121765219, 1036233577, -1113082189, 1007761049)
		 + W(2, 1008804487, -1119320351, 1028769566, -1145928741)
		 + W(3, -1118791492, 1035112755, -1119166399, 1034891236)
		 + W(4, 1036033743, -1105317049, 1033869945, -1104666827)
		 + W(5, -1103277106, 1043081028, -1110309063, 1003334201)
		 + W(6, -1130814575, -1126605754, 1029943513, 1058632863)
		 + W(7, 1010033985, 1033184724, -1124066564, -1146667244)
		 + W(8, -1114717025, -1103884858, -1097519272, -1084821476)
		 + W(9, -1091781337, -1108906997, -1105454190, -1124982586)
		 + W(10, 1042429978, 1019583714, 1050527129, 1057878257)
		 + W(11, 1047090522, 1050006554, -1116436299, 1037673833);
	WS(1053829756, -1108691549);
	sum1 = W(0, 1014621415, -1117035633, 1017668333, -1121088251)
		 + W(1, -1113943163, 1027915142, -1117882340, 1018110476) + W(2, 1034972923, 1031518451, 1028891034, 1043029617)
		 + W(3, 1037608353, -1118505878, 1008280866, -1114328254)
		 + W(4, -1105089900, -1146432572, -1111069516, 1052288956)
		 + W(5, 1043183409, 1040529537, -1127832039, 1025673432)
		 + W(6, -1121242915, 1011744694, -1099260407, -1096216885)
		 + W(7, -1109446679, 1033001703, 1023717270, 1038283409) + W(8, 1024842558, -1195363583, 1035963185, 1043236853)
		 + W(9, -1104376301, -1110826184, -1108863440, -1136644866)
		 + W(10, -1125107735, 1024600093, -1111257697, 1022444749)
		 + W(11, 1008767270, 983774736, 1021787123, -1122279626);
	sum2 =
		W(0, 1011466728, -1128158188, 993685376, 1021341187) + W(1, -1125064327, 1016637363, -1135616946, -1142265296)
		+ W(2, -1153535168, -1133074596, -1111924694, 1041916532)
		+ W(3, -1115375045, -1111577830, -1121861231, -1139232914)
		+ W(4, -1121363658, -1108077390, 1048370655, -1088803436) + W(5, 1050909934, 1048268187, 1028734454, 1033829714)
		+ W(6, -1113493290, 1031842286, -1096696142, -1097359431)
		+ W(7, 1066069354, -1102058354, -1112810542, -1108918948)
		+ W(8, 1016979229, -1114077565, 1032702600, 1051606360)
		+ W(9, -1108957150, -1106393780, -1104652034, -1124153420)
		+ W(10, -1121975877, 1032726750, -1126878203, 1020447303)
		+ W(11, -1115472084, 1011253904, 1032484333, -1135690267);
	WS(1043379192, -1131322837);
	sum1 =
		W(0, -1129021027, -1148980502, -1117253390, 1015261926) + W(1, 1024719214, -1130947836, 974083843, 1010796022)
		+ W(2, -1109595831, -1141769560, -1131540259, 1038059198) + W(3, 1043151230, 1040366611, 1036650848, 1032003186)
		+ W(4, 1033800339, 1040943040, -1099641090, 1019360940) + W(5, 1047704456, -1120007803, 1032688054, -1135300928)
		+ W(6, 1042153991, 1016895818, 1040857522, -1103092216)
		+ W(7, -1091529984, -1100986498, -1116706574, -1114490317)
		+ W(8, -1099711038, 1029537886, -1104535414, 1032384358) + W(9, 1043292971, 1031568104, 1019020464, 1026900536)
		+ W(10, 1026187331, 1023917269, 999787984, -1137467256)
		+ W(11, 1021851650, -1117455240, 1021119266, -1124200964);
	sum2 = W(0, -1127801857, -1143073539, -1106914355, -1114698807)
		 + W(1, -1129241721, 1034854605, 1015357631, 1026781991) + W(2, 1028175283, 1010285366, 1045024365, -1107796176)
		 + W(3, -1093181393, -1094857339, -1104001534, -1106206681)
		 + W(4, -1129802997, 1022418743, -1109183829, 1055188047)
		 + W(5, 1060464193, 1038631095, 1035894131, -1121422795)
		 + W(6, -1133354170, -1111757330, 1035388549, -1099199714)
		 + W(7, -1108056884, 1042537531, 1019867695, 1010545294) + W(8, -1129332011, 1032847739, 1028119663, 1027769667)
		 + W(9, 1015260775, -1123722407, 1021694327, -1120402439)
		 + W(10, 1029358411, -1119713292, 984677997, -1126683209)
		 + W(11, -1117802232, 1025618013, -1116557581, 1021478623);
	WS(1049844732, -1121310639);
	sum1 =
		W(0, 1023733410, -1099209689, 1040893204, -1102957277) + W(1, -1114244983, -1136674298, -1108461358, 1021220348)
		+ W(2, 1044402267, -1106734859, 1050332331, -1111686974)
		+ W(3, -1122456058, 1049981942, -1102278760, 1043895987)
		+ W(4, 1053233309, -1108848000, 1049912979, -1098618899) + W(5, 1048539349, -1111429758, 1039273110, 1048170180)
		+ W(6, -1096212219, -1103164857, -1099336615, -1097562740)
		+ W(7, -1096335583, 1033031043, -1102589972, -1101337719)
		+ W(8, 1051767783, -1109302031, 1050917291, -1121562509) + W(9, 1042792075, 1039550692, 1008842338, 1041281742)
		+ W(10, -1114613442, -1129199659, 1033787229, -1111886543)
		+ W(11, -1121890370, 1041151474, -1104020956, 1031699907);
	sum2 = W(0, 1051830333, 1052363768, 1062286287, 1068323273) + W(1, 1062941652, 1058036233, 1038399576, 1029358050)
		 + W(2, 1040398919, 1056364330, -1105094784, -1117763636)
		 + W(3, -1117097644, -1135317262, 1045469136, -1127713443)
		 + W(4, -1088812275, -1088095023, -1083945825, -1086712736)
		 + W(5, -1085128967, -1090471655, -1096613184, -1118175248)
		 + W(6, -1112895824, -1128031249, -1110939052, -1122350162)
		 + W(7, -1107088013, -1117471490, -1128774604, 1023889083)
		 + W(8, 1030823820, -1126124865, -1131257287, 1034881723) + W(9, 993374262, 1022005418, -1124473506, 1006015479)
		 + W(10, -1120174945, 1022839272, -1113476028, 1031923437)
		 + W(11, -1149114843, -1131972943, 1015689530, -1114795832);
	WS(997080576, -1130763300);
	sum1 = W(0, -1113905570, 1030153879, -1117230256, -1152616277)
		 + W(1, -1146808706, -1112646432, -1186209359, -1120216576)
		 + W(2, -1121320815, -1108108727, -1100762033, -1090117932)
		 + W(3, -1109500574, -1102311764, -1119610882, -1099135446)
		 + W(4, 1038521748, 1032364321, 1051702873, 1069923213) + W(5, -1104049339, 1028696893, -1120830317, 1030578386)
		 + W(6, 1025325853, -1131460303, 1040312882, 1063008042)
		 + W(7, 1056019095, -1115439812, -1125581089, -1116447004)
		 + W(8, -1108459484, -1152289285, -1099800679, -1092045374)
		 + W(9, -1100849447, -1105934578, 1028735898, -1108771165)
		 + W(10, -1123369669, -1111143084, 1018134009, -1116551136)
		 + W(11, 1015899783, -1120248394, -1113190874, -1120342084);
	sum2 = W(0, -1130955153, -1115062100, -1114768924, 1040485485)
		 + W(1, -1102247365, 1040365390, -1105380703, -1134789779)
		 + W(2, 1025142055, 1033634795, -1114031272, -1115074190)
		 + W(3, -1110799922, 1039570131, -1112489130, 1035629875)
		 + W(4, 1025405091, -1124058081, 1047530952, -1104495565)
		 + W(5, 1038913214, -1102056033, -1123724877, -1104428707)
		 + W(6, 1041203911, -1151569099, -1160505239, 1065129660)
		 + W(7, -1115442088, 1037120419, -1145632358, 1035843769)
		 + W(8, 1034798579, -1098708869, 1048498835, -1095909934)
		 + W(9, -1105078519, 1024518769, -1109649658, -1117935125)
		 + W(10, -1107186683, 1041850582, -1097808347, 1045395705)
		 + W(11, -1106337339, 1007217475, -1152795787, -1124566009);
	WS(-1078383103, 1059446981);
	sum1 =
		W(0, -1139864362, 1022304576, -1117916615, 1007335089) + W(1, -1119884647, 1022280942, 1023668405, 1034312731)
		+ W(2, -1142609202, 1008862865, -1109139429, 1032501274) + W(3, 982044231, -1115332063, 991223187, -1102309771)
		+ W(4, -1105667544, -1100327790, -1098424968, -1089810345)
		+ W(5, 1033240873, 1049118183, -1140016273, -1110413061) + W(6, 1048881003, 1047898440, 1053051896, -1104044598)
		+ W(7, 1051763270, -1113330784, 1027424455, 1032557738) + W(8, -1110989208, 1029966423, 1023833874, 1040575921)
		+ W(9, -1114053146, 1041606896, -1122699729, 1041157596)
		+ W(10, 1019807480, -1128249884, -1114518074, 1013296733)
		+ W(11, -1110353213, -1126749570, 1021514772, -1121516731);
	sum2 = W(0, -1143648694, 1022767513, 963325627, -1138915747) + W(1, 1040530304, 1031585165, 1008260859, -1120690652)
		 + W(2, 1050457027, -1104882348, 1052893834, -1122824043)
		 + W(3, 1019582897, -1094902239, -1113748748, -1090635807)
		 + W(4, -1090901428, 1017677825, -1090554669, 1048412513)
		 + W(5, -1101863176, -1104950416, -1120605391, 1056780417)
		 + W(6, -1095258955, -1116653154, 1030383529, 1063122641)
		 + W(7, -1089352859, 1057380402, -1106433792, 1049388154)
		 + W(8, 1047388223, -1125154789, -1114292033, -1118207917)
		 + W(9, 1048190601, -1102824630, 1038107916, -1104842210)
		 + W(10, 1034828442, -1149114774, 1040557770, 1005930742)
		 + W(11, 980397999, 1033506230, -1115355457, -1136517107);
	WS(-1104952056, -1073278929);
	sum1 =
		W(0, -1144211169, 1031125659, -1121100585, -1142367854) + W(1, 1025675017, -1114298540, 1036563163, -1122834968)
		+ W(2, -1099507218, -1116651974, -1101060075, -1105066053)
		+ W(3, -1131576359, -1114707952, -1120605819, -1111900952)
		+ W(4, 1047627264, -1113308557, 1054491321, 1039149624) + W(5, -1106626380, 1042584197, -1128818827, 1039018645)
		+ W(6, 1043300637, 1037274304, -1102367022, 1051689271) + W(7, 1044811828, -1128472513, 1045578618, -1115669626)
		+ W(8, -1098196346, -1126577137, -1102852173, -1106731162)
		+ W(9, -1111689619, -1126957444, 992521004, 1025441875)
		+ W(10, 1030331294, -1122667056, 1026346581, -1120693369)
		+ W(11, 1018492983, -1140414731, -1128018583, 997033420);
	sum2 =
		W(0, -1117577133, -1139616023, 997820975, 1028627780) + W(1, -1114909048, 1032747040, -1116006677, 1030832637)
		+ W(2, 1036324905, -1124977156, -1120808104, -1109376562) + W(3, 1029259135, -1145526876, 1022442689, 983753970)
		+ W(4, 1012676607, -1115101040, 1041273688, 1049990275) + W(5, 1043064430, 1039154681, 1027909669, -1115224952)
		+ W(6, -1164734594, 1032695755, 1041759226, -1096754642)
		+ W(7, 1041324783, -1094055114, -1098711698, 1023440264)
		+ W(8, 1039853902, -1116113854, 1041255405, -1106762918)
		+ W(9, -1111929038, 1025837595, -1130147608, -1112181665)
		+ W(10, -1110394349, 1006188424, -1120661488, 1033535767)
		+ W(11, 1021759445, 1023476809, -1133986843, 1029342490);
	WS(1057403966, -1096678293);
	sum1 = W(0, 1015545167, 1013920108, 1030182836, 991347091) + W(1, 1031028372, -1130110920, -1137745417, -1127755335)
		 + W(2, -1133819725, -1127594402, 1031500952, -1107540753)
		 + W(3, 1042502792, -1120427420, 1023814022, -1113612941)
		 + W(4, 1037006758, -1136130453, 1042283546, 1040431359) + W(5, -1084295706, 1042737160, 1019878434, 1042334622)
		 + W(6, -1110196161, -1123399563, -1086200264, 1060132444)
		 + W(7, 1049379651, 1001749345, 1023472436, -1123659840)
		 + W(8, -1111752718, 1041684833, 1047364560, -1104881213)
		 + W(9, -1113607001, -1117219726, 1017968636, 1008021369)
		 + W(10, 1028708905, -1119121787, -1120221088, 1006406689)
		 + W(11, 1002061113, 1026883950, -1124476270, 1011156129);
	sum2 =
		W(0, -1178786588, 1027650789, 1004569898, 1010647389) + W(1, -1130907066, -1128412421, 1000455394, 1019136642)
		+ W(2, -1129322914, -1117835702, -1120140062, -1110565129)
		+ W(3, 1046200355, 1035331810, 1040609034, -1114775527) + W(4, -1116170217, -1106357388, 1012300621, 1051050908)
		+ W(5, -1094299123, 1038925264, -1110352470, 1028674911) + W(6, 1036181740, 1050236879, 1029537087, -1121260831)
		+ W(7, -1105419536, -1104188032, -1148832482, 1009994365)
		+ W(8, 1016863918, -1107702296, -1115347042, 1019718506) + W(9, 1018471790, 1035623426, 1031812039, -1129304944)
		+ W(10, -1132924585, -1127926494, 1007741857, -1147888890)
		+ W(11, -1122466004, -1132432621, -1132484471, -1146317634);
	WS(1056335484, -1129697442);
	sum1 = W(0, -1118615510, -1123816285, 1016357093, -1126548591)
		 + W(1, 1017679973, -1125007109, -1130509569, -1127256452)
		 + W(2, 1026825265, -1162479083, -1123245334, -1115166368)
		 + W(3, 993334229, 1009460392, -1117686884, -1110259820)
		 + W(4, -1102686619, -1175208362, -1112742573, 1012633705)
		 + W(5, 1048503365, -1110640192, 1010107581, 1008538193) + W(6, 1045269336, -1122870505, 1056143939, 1022501065)
		 + W(7, 1044007618, 1043433395, 1037226473, 1040188728) + W(8, 1031523962, 1025178018, -1115481871, -1098786498)
		 + W(9, -1107348056, -1104721331, -1124234681, -1112073470)
		 + W(10, -1140818205, -1112741005, 1004860403, -1121817826)
		 + W(11, -1134864917, -1142571619, -1120701013, 1004599859);
	sum2 = W(0, -1140731697, 1018164054, -1116322329, 1033668632) + W(1, -1110091010, 1006827755, 1024608202, 978878091)
		 + W(2, -1126783010, -1144859189, -1148034885, -1111621890)
		 + W(3, 1034430751, -1133278289, -1134565598, -1106732021)
		 + W(4, 1035005186, 1011714049, -1112384840, 1057652336) + W(5, -1103655808, 1035575897, 1007536733, 1017810394)
		 + W(6, -1110815467, 1039236492, -1109778149, 1053123628)
		 + W(7, -1113563636, 1009902097, 1031837967, 1032913014)
		 + W(8, -1144657885, -1130754383, -1113329105, -1107649638)
		 + W(9, -1112793157, -1136830370, -1131576514, -1118754368)
		 + W(10, -1127206230, -1146205013, -1113225660, 1012470213)
		 + W(11, -1113811608, -1126431906, 1007646275, -1123083034);
	WS(1064654654, 1035088379);
	sum1 = W(0, -1123150274, 1013730923, -1124984926, -1143080352)
		 + W(1, -1115541655, -1120446591, 1019709882, -1123168830)
		 + W(2, -1101065371, -1104968795, -1104298005, -1097917367)
		 + W(3, -1115560637, -1112072243, -1121553409, -1101025669)
		 + W(4, 1052021669, 1043838624, 1050953841, 1053857683)
		 + W(5, -1098028717, -1118042236, -1117850604, 1024509393)
		 + W(6, 1034671630, -1116995686, -1125221929, 1053311748) + W(7, 1054064059, 1056948345, 1047317764, 1051915779)
		 + W(8, -1103122974, 1025043295, -1102292982, -1101557747)
		 + W(9, -1102206963, -1099829586, -1123986585, -1105952782)
		 + W(10, -1124628232, -1123853974, -1122875259, -1129945790)
		 + W(11, -1115475969, 1010096420, -1120157778, 1010117900);
	sum2 =
		W(0, -1115290116, 1036300391, -1109664288, 1023887773) + W(1, 1031338337, -1112746552, 1029647363, -1123357025)
		+ W(2, -1109338596, -1120873277, -1133763869, -1110763968)
		+ W(3, -1104363651, -1111086518, 1014654409, -1113327782) + W(4, 1052546267, 1031940424, 1041363997, 1046589307)
		+ W(5, 1038758869, 1026186944, 1011886363, -1114411312) + W(6, -1101682429, 1045633640, -1094977574, 1050150667)
		+ W(7, -1104681827, -1121584221, 1042076972, 1033926660)
		+ W(8, -1106866549, -1121551223, 1008614181, -1110488084)
		+ W(9, -1120223295, 1035823152, -1111033402, 1046305164)
		+ W(10, 1027635895, 1021591180, -1119215823, 1009099129)
		+ W(11, 1016354897, -1115537942, 1012736237, -1109553196);
	WS(-1088190206, -1108558078);
	sum1 = W(0, -1109712467, 1034096473, -1111610193, -1111503908)
		 + W(1, 1029528067, -1109918121, -1130336610, -1110290409)
		 + W(2, 1048826552, -1100191472, 1051587686, -1114238856)
		 + W(3, -1124911644, 1053388852, -1101598429, 1049826386)
		 + W(4, -1117596347, -1104233509, -1112703594, -1118548075)
		 + W(5, -1094857227, 1040678692, -1102065648, -1108498290)
		 + W(6, 1045129740, 1021528052, -1123092480, 1045282957) + W(7, 1041941490, -1121835291, 1050563972, 1032628503)
		 + W(8, -1145103958, 1015098342, 1033306871, -1105600408)
		 + W(9, -1116887040, 1043572363, -1101594283, 1041251987)
		 + W(10, 1040739958, -1095362037, 1043699492, -1112734841)
		 + W(11, -1106244021, 1044475255, -1100499697, 1015959598);
	sum2 =
		W(0, -1140036524, -1122134368, -1124742331, 1023368729) + W(1, 1025643512, -1117935205, 1029315286, -1121900993)
		+ W(2, 1033121292, -1135675176, 1022385651, 1037868584) + W(3, -1113410705, 1034815986, -1106876578, 1029051910)
		+ W(4, 1020537037, -1102563608, 1017232470, -1097085277)
		+ W(5, 1026038978, -1107749524, -1116418603, 1013163432)
		+ W(6, -1094559771, -1090683436, -1089829937, -1081905013)
		+ W(7, -1085580324, -1093433405, -1100509010, -1107168757)
		+ W(8, 1042598592, 1049536131, 1015761873, -1122385293) + W(9, -1119606047, 1034046493, 1037794408, 1020109569)
		+ W(10, 1048560917, 1043095342, 1060516603, 1068776853) + W(11, 1062905414, 1053234619, 1023262329, 1038509970);
	WS(1048802172, -1118644607);
	sum1 =
		W(0, 1022629891, 1001330921, -1147098739, 1023807923) + W(1, -1129374813, 1028532286, 1031375324, -1151549405)
		+ W(2, -1112271863, 1008285357, -1106982824, 1020475895) + W(3, 958183765, 1025640422, -1133565569, -1106868493)
		+ W(4, -1115934246, 1007889405, -1110669107, -1095657203)
		+ W(5, -1113474437, -1090481180, -1104303995, -1104624276)
		+ W(6, -1112205646, -1137992085, 1044651974, 1050363724) + W(7, 1050921091, 1050665633, 1037811271, 1049383075)
		+ W(8, 1050188943, 1025826270, 1026008921, 1011316531) + W(9, -1106529387, -1131537104, -1125009457, 1022847857)
		+ W(10, -1125264263, -1127716075, -1113499645, 1026946398)
		+ W(11, -1121270209, 1021652689, 1014192325, -1142930963);
	sum2 = W(0, 1016559128, -1119933527, 1008526536, 1034816070) + W(1, 1018959568, 1026554777, -1112891495, 1046177388)
		 + W(2, -1089262209, 1032931419, -1094914643, -1096197918)
		 + W(3, -1101210129, 1049415798, -1128790619, 1043157162)
		 + W(4, 1053795811, -1108360154, 1052999976, 1069558608)
		 + W(5, -1103281588, -1085501184, -1098019814, -1088254262)
		 + W(6, 1058569170, -1097574423, 1052760357, 1058007152)
		 + W(7, -1106340652, -1101474305, -1114646508, -1096632714)
		 + W(8, -1094475155, 1036603460, -1106271635, 1022028102)
		 + W(9, -1121182797, 1027756295, -1124734105, 1015426864)
		 + W(10, 1008650912, -1121755244, 1039081818, 1004102711)
		 + W(11, 1033515588, 1032461240, -1118822413, 1043397723);
	WS(-1085648446, -1079079370);
	sum1 = W(0, 1031831473, -1114079994, 1031367567, -1118896788)
		 + W(1, -1123680847, 1033718927, -1123944253, 1033541103) + W(2, 1036117159, 1003975776, 1044164867, 1045647319)
		 + W(3, 1033826253, 1041970952, 1024952417, 1040029267) + W(4, 1049939273, 1042007752, 1043312672, -1095211959)
		 + W(5, -1122554975, -1116359196, -1176880640, 1026974961)
		 + W(6, -1094329359, -1097850009, -1089391360, -1087218668)
		 + W(7, -1100203021, 1033960979, -1108529239, -1111794397)
		 + W(8, 1040633606, -1134555900, 1041283678, 1044809099) + W(9, 1046447947, 1042238738, 1024390649, 996515216)
		 + W(10, 1023486628, 1019647980, 1023951387, 1014099708)
		 + W(11, 1017251780, 1031788713, -1146375056, 1033511473);
	sum2 = W(0, 1019169584, -1120973142, 1033125970, 1025364316)
		 + W(1, -1109812797, 1040314133, -1108282977, 1018923536)
		 + W(2, 1042983019, 1009997472, -1103915398, 1036688212)
		 + W(3, -1125420780, -1119986230, 1034277286, -1117630132)
		 + W(4, -1098354632, -1106283039, 1033722376, 1062322516)
		 + W(5, -1098634798, 1057333054, -1102308141, -1125368820)
		 + W(6, -1099987280, 1032814660, -1095179878, 1032770062)
		 + W(7, -1109050948, -1097734639, 1034195486, 1049154263)
		 + W(8, 1048978343, -1103033329, 1055664562, -1097173506)
		 + W(9, -1103688168, -1173745415, -1107997912, -1098308929)
		 + W(10, -1118546716, 1022934360, -1110281795, 1045599869)
		 + W(11, -1119010038, 1038965178, 1007528912, 1035253180);
	WS(-1089355774, -1078290086);
	sum1 = W(0, -1122950775, -1112691207, 1023290087, -1107733500)
		 + W(1, -1146188190, -1132821263, -1112282369, -1116356099)
		 + W(2, 1037182841, -1124344033, 1046400294, -1118583361)
		 + W(3, 1042531744, -1121639475, -1137408791, 1018516820)
		 + W(4, -1118638572, 1041047393, -1098349922, 1057481334)
		 + W(5, -1139289650, -1109625472, 1026873009, -1139389015)
		 + W(6, -1121667553, -1104403323, -1099164822, 1054069421)
		 + W(7, -1097191323, 1041114291, -1120861012, -1139200383)
		 + W(8, 1009124079, -1138062223, 1044398104, -1149431076)
		 + W(9, 1044515332, -1120573261, -1120947806, 1017011067)
		 + W(10, -1115334660, -1126199861, -1136525567, -1110719762)
		 + W(11, 1015659149, -1121643278, -1122889719, -1120569352);
	sum2 =
		W(0, -1120919296, 1009843654, -1132368064, 1020138111) + W(1, 1029564211, -1115205032, 1016741875, -1119663171)
		+ W(2, -1124567280, -1107129213, 1020831927, -1098918731)
		+ W(3, -1132836513, 1010227332, -1118685376, 1026001154) + W(4, 1037030993, 1043380414, -1109288357, 1059483198)
		+ W(5, -1119273466, -1106893419, 1028452918, -1135273053)
		+ W(6, -1120629799, -1102119519, -1112537154, 1064361176)
		+ W(7, -1104145236, 1043150197, -1117770026, 1019055438)
		+ W(8, -1106639281, 1030878171, -1118412551, -1093377806)
		+ W(9, -1123848756, -1103899854, 1024207514, -1109882780)
		+ W(10, 1020211370, -1126825280, -1144175329, -1146281491)
		+ W(11, -1135251423, 1028327527, -1128215590, 1024565629);
	WS(1064975294, 1066308158);
	sum1 =
		W(0, 1031747776, -1106142801, 1028818885, 1001228109) + W(1, -1115396498, 1041342669, -1108139113, 1027821620)
		+ W(2, -1119071204, 1032019633, 1041375482, -1112793497) + W(3, 1013499583, -1123968938, 1024220311, 1020544662)
		+ W(4, 984462229, 1045090381, -1093262116, 1049965274) + W(5, 1052662103, -1113450905, 1035427697, -1138282267)
		+ W(6, -1132055971, -1108909198, 1038243096, 1021279149)
		+ W(7, -1090377239, 1040402543, -1107965954, -1116422289)
		+ W(8, -1148253029, -1110036442, 1036945928, -1115536386) + W(9, 1034061985, 993049059, -1113141447, 1016907357)
		+ W(10, -1126913907, 1036419718, -1121925745, 1019907753)
		+ W(11, 1032108124, -1109636927, 1032825796, -1128061041);
	sum2 =
		W(0, 1016610899, -1135553471, -1163068737, -1147979120) + W(1, -1121296916, -1139692219, 1007282246, 1019770181)
		+ W(2, -1118189976, 1018031354, -1120752887, 1035872696)
		+ W(3, 1034250650, 1022157658, -1131969269, -1131641536)
		+ W(4, 1027283971, -1118352328, 1042584076, -1095799786)
		+ W(5, 1009508653, -1121907329, -1148404200, 1013257077) + W(6, 1028895363, 1032145382, 1042427003, 1073605475)
		+ W(7, 1056095764, -1130051225, 1025403981, -1121748387)
		+ W(8, -1113530321, -1123867563, -1099207121, -1075418961)
		+ W(9, -1091570337, -1113117501, -1124635978, -1123610989)
		+ W(10, 1007846553, 1011272254, 1010785270, 1026092591) + W(11, 1030054693, 1019567305, 1012575724, 1018865930);
	WS(1062423998, 1020226002);
	sum1 =
		W(0, -1122384152, 1000976853, -1122957973, -1140430696) + W(1, 1018079658, -1116871589, 1021042950, -1130305609)
		+ W(2, -1116470612, 1015809956, -1115150860, -1100102424)
		+ W(3, -1099378776, -1102397253, -1121061927, -1097083551)
		+ W(4, -1095861522, -1125526476, -1101122465, 1051208664) + W(5, 1045734276, 1040938184, 1045437908, 1049869175)
		+ W(6, 1055717600, 1034182342, 1052715645, 1053221217) + W(7, 1041738487, 1038184662, -1114085178, 1019939330)
		+ W(8, -1128557498, -1136390676, -1101688288, -1097231798)
		+ W(9, -1114764537, -1107259340, 1034631967, -1105843464)
		+ W(10, -1133541800, 1025071548, -1121585121, 1026360261)
		+ W(11, -1127628368, -1121765359, 1018430000, -1122412137);
	sum2 =
		W(0, -1125184611, 985313435, -1181860650, -1124740239) + W(1, -1132645547, 999484231, -1125466771, 1024683619)
		+ W(2, -1124729770, -1132095255, 1028760415, 1011065519)
		+ W(3, 1033849803, 1015359010, -1140486285, -1125848669)
		+ W(4, 1045115043, -1117207517, 1036693207, -1088457353)
		+ W(5, -1096437481, 1048821220, -1107942084, 1027562883)
		+ W(6, 1058112728, 1067077185, -1107623537, -1080660794)
		+ W(7, -1109418981, -1117188353, 1027196953, -1127975224)
		+ W(8, 1023628890, -1158219675, 1043689375, 1020427720) + W(9, -1110185484, 1032363474, -1121893121, 1023023798)
		+ W(10, 1007171579, -1118062236, 1000645119, -1160295467)
		+ W(11, 1015083304, 1023561702, -1134577643, -1158549787);
	WS(-1085592318, -1113086899);
	sum1 =
		W(0, -1127342656, 1024334944, -1107952998, 1034498345) + W(1, -1131633306, -1110168462, 1033648125, -1119681052)
		+ W(2, -1105245475, 1029597578, -1104926592, -1110412429)
		+ W(3, -1103724998, -1098176238, -1115323711, -1098367950)
		+ W(4, -1104578161, -1117644382, -1101901257, 1053247055) + W(5, 1051300307, 1051451939, 1049307889, 1053283054)
		+ W(6, 1053241687, 1041591201, 1051692021, 1044816720) + W(7, 1042909421, -1124765258, -1143558503, -1113485404)
		+ W(8, -1103827813, 1020278010, -1097952575, -1110749814)
		+ W(9, -1106968399, -1105195378, 1027981559, -1102600950)
		+ W(10, -1138537863, 1015573096, -1110174988, 1033881662)
		+ W(11, -1116328992, -1113141267, 1028312016, -1113790704);
	sum2 =
		W(0, 1019423143, -1134200265, 1022335641, -1126211289) + W(1, -1160177640, 995157684, -1138832033, -1130236057)
		+ W(2, -1118706158, -1122995556, -1113839515, -1123774588)
		+ W(3, 1002859666, -1114460336, -1131104601, 1027754115)
		+ W(4, -1110500850, 1021681136, -1121978030, 1048787768) + W(5, 1035034344, 1025695056, -1126984825, 1027074464)
		+ W(6, 982325064, -1106847870, 1042414810, 1052221246) + W(7, 1009324191, -1129766425, -1136621129, -1120353368)
		+ W(8, -1117883328, -1115095323, -1112736275, -1118959328)
		+ W(9, 1026260852, -1114723897, 1016807320, -1121253912)
		+ W(10, -1145733922, 1001371122, 1019850892, -1113736050)
		+ W(11, 1023767274, -1130130145, -1131688905, 992217060);
	WS(1025516512, -1100199588);
	sum1 = W(0, 1010096560, 998291066, 1015136529, 1016981531) + W(1, -1134306338, 1015217585, 1025573847, 1027586712)
		 + W(2, 1021891087, -1128181387, -1152435393, 1035336779)
		 + W(3, 1040424469, 1041134374, -1147235028, -1105873140) + W(4, 1041308560, 1015332531, 1054580194, 1043985948)
		 + W(5, -1088067164, -1097437107, -1108043523, 1024655979)
		 + W(6, -1106994989, -1097993736, -1087955312, 1049373383)
		 + W(7, 1048585956, 1044933000, 1037061588, 1041451309) + W(8, -1107391304, 1040752366, 1021987303, 1016493518)
		 + W(9, -1111549299, 1015283332, -1125444197, 1025261651)
		 + W(10, 1032706511, -1115681272, 1013936722, -1153713033)
		 + W(11, -1122756060, 1028860515, -1124931799, 1010373746);
	sum2 = W(0, 1024904631, -1136864762, 1005033941, 1030076655) + W(1, 1022202973, 995105737, 1009257370, -1113660547)
		 + W(2, -1115115972, 1023564875, -1114446231, -1115188268)
		 + W(3, -1099782234, 1025338591, -1107689693, 1049272645)
		 + W(4, -1128899549, -1103710322, -1140124434, 1057566767)
		 + W(5, 1051976820, 1009750634, 1040613751, -1105716747)
		 + W(6, -1100416868, -1105139728, -1107001478, 1061216146)
		 + W(7, -1114917196, -1107279078, -1123762171, -1112133417)
		 + W(8, 1014205090, -1112771593, -1105823902, -1101449249)
		 + W(9, -1115621063, -1123827499, -1124460977, 1019919657)
		 + W(10, -1138213458, 1024304323, 1028369943, 1031401203)
		 + W(11, -1127316949, 1002907445, 1021828037, -1121285688);
	WS(1050734204, -1108852232);
	sum1 = W(0, -1111669430, 1026854009, -1115457556, 1022285659)
		 + W(1, -1130768721, -1124925681, 988348114, -1117352760)
		 + W(2, -1116292712, -1106093993, -1104273631, -1090233269)
		 + W(3, -1103820941, -1107176543, -1114665965, -1103610460)
		 + W(4, -1122281377, -1103616254, 1027625969, 1069754213)
		 + W(5, -1114752252, -1130883179, -1144129324, 1032882469)
		 + W(6, 1027495958, -1113635568, 1042550097, 1065691213) + W(7, 1054098174, 1026991873, 1018693905, 1034282506)
		 + W(8, -1113568120, -1125634353, -1100906821, -1090598793)
		 + W(9, -1103145534, -1107767585, 1007587914, -1112131865)
		 + W(10, -1123139966, -1117637392, -1147736996, 999398084)
		 + W(11, -1140005358, -1123096067, -1120005196, -1122062653);
	sum2 =
		W(0, 1024214881, -1122830075, 1024710111, -1118490155) + W(1, -1134765475, 1007204875, 955722144, -1132418382)
		+ W(2, -1105712489, 1026001227, -1105988647, 1044311614)
		+ W(3, -1128591966, 1016894538, -1132281374, -1121103003)
		+ W(4, -1096328526, -1089670730, -1109313571, 1057951288)
		+ W(5, 1031038781, -1135710147, -1121635711, 1040031313) + W(6, 1036545949, -1104892025, 1042923133, 1050757116)
		+ W(7, 1041007149, -1111844715, 982097434, -1131469166) + W(8, -1114697429, 1027384734, -1108836817, 1046225965)
		+ W(9, -1111832237, 1020988490, -1141601766, -1137288635)
		+ W(10, 1029115040, -1127506094, 1018384918, -1118982995)
		+ W(11, 1000957030, 1018633070, -1131312630, 1012074251);
	WS(-1077332287, -1089760701);
	sum1 =
		W(0, 998476811, -1146931846, 1020090684, -1115596769) + W(1, 1018970620, -1117338894, -1131301080, -1134004534)
		+ W(2, -1126986618, -1106320367, -1103512376, -1106044643)
		+ W(3, 1033789092, -1121544222, 1025908912, -1120853460) + W(4, 1035645275, 1033143495, 1057100532, 1033806067)
		+ W(5, -1089559024, -1119052427, -1109205213, 1021655744)
		+ W(6, 1035996661, 1030948981, -1098691810, 1054020686) + W(7, 1053006209, 1053247323, -1117960094, -1112997269)
		+ W(8, -1111559939, -1116749294, -1114602228, -1102410839)
		+ W(9, -1114317262, -1148875196, 1040862618, 1024305160)
		+ W(10, 1002151576, -1132098378, 1020764052, -1131285468)
		+ W(11, -1143682184, -1140686688, -1112291776, -1137942600);
	sum2 =
		W(0, 1006079429, -1142220161, -1129651941, -1120056293) + W(1, 1021210606, -1138049810, 1020679942, -1144760977)
		+ W(2, 1015506585, 1012377004, 1027444401, 1027255740) + W(3, -1154390002, -1121552483, 988683875, -1149209645)
		+ W(4, -1129173219, 1019086641, 1029291472, -1087748986) + W(5, 1030702430, 1046290929, -1149010889, 958643736)
		+ W(6, -1126961905, 1027847692, -1099113060, -1071778912)
		+ W(7, 1077548482, 1017608723, 1009874569, -1165018915) + W(8, 1025558752, -1121396179, 1031608500, -1132223695)
		+ W(9, 1041292060, 1030045463, -1116313503, -1108302337)
		+ W(10, 1004493969, -1129089615, 1032469225, -1117547929)
		+ W(11, 1017793536, -1115202758, 1024909384, -1153372770);
	WS(1054407548, 983325672);
	sum1 =
		W(0, 1028412425, -1115456470, 1017604747, 1031921957) + W(1, -1121692358, 1041128181, -1131299175, 1034097067)
		+ W(2, -1105600625, 1033490817, -1115519181, 1031550611)
		+ W(3, -1103698804, -1109550327, 1030793272, 1014014769)
		+ W(4, -1148390382, 1044756246, -1103922376, -1090010995)
		+ W(5, 1062123705, -1103937189, 1039103265, -1135652511)
		+ W(6, 1033571545, -1114006910, 1059608097, -1087252051)
		+ W(7, -1094628214, 1042983319, -1106569209, -1116995186)
		+ W(8, 1032293767, -1119790070, -1107101148, 1044072953) + W(9, 1027680451, 1021059262, 1007158719, -1141553278)
		+ W(10, -1124427701, 1037509878, 1007976775, 1022727275)
		+ W(11, 1033962892, -1108328080, 1032055396, -1143059662);
	sum2 =
		W(0, 1007145536, -1108956115, -1123468231, 1003522017) + W(1, -1106382527, 1023566518, -1116797301, 1016028592)
		+ W(2, 1011835040, 1040320325, 1009493536, 1036429861) + W(3, 1045134298, -1132203156, 1044032552, -1103689691)
		+ W(4, -1115291423, -1145921569, -1120694127, 1057547857)
		+ W(5, -1120933925, -1105348488, -1105744806, 1019566780)
		+ W(6, 1029973058, -1113530029, 1025444390, 1039825371) + W(7, -1093621604, 1030401418, -1111109931, 1039637835)
		+ W(8, 1036345379, -1116109872, -1106839609, 1028735446) + W(9, 1043632212, 1032927131, 1031187850, -1119043970)
		+ W(10, -1106716830, 1031627486, -1106619549, 1032586179)
		+ W(11, -1135351552, -1107014793, 1030984886, -1117261713);
	WS(1062610366, -1081620328);
	sum1 = W(0, 1034909184, 1022225638, 1022593144, 1034659649) + W(1, -1145063906, 1029979468, 1024460554, -1129493655)
		 + W(2, 1041975919, 1036878493, 1038275488, 1049110721) + W(3, 1039909252, 1050285945, 1032760119, 1052309552)
		 + W(4, 1038564634, 1032326503, 1032775158, -1104434937)
		 + W(5, -1098154666, -1091716385, -1098908862, -1093908076)
		 + W(6, -1086061975, -1097049310, -1094128798, -1097332230)
		 + W(7, -1096830529, 1031802154, -1125106744, 1033460244) + W(8, 1054071881, 1038246806, 1049378869, 1048167927)
		 + W(9, 1037005773, -1122539766, 1023442918, -1111713187)
		 + W(10, -1118145809, 1033815666, 984752392, 1040915883)
		 + W(11, -1127387550, 1042582214, 1025327999, 1038395208);
	sum2 = W(0, 1025388154, 1001261778, 1007664153, 1018216589) + W(1, 1011431705, -1124915037, 1007167865, -1118462618)
		 + W(2, -1106689977, 1031762430, -1105078255, -1117638934)
		 + W(3, -1119019386, 1039919645, -1115769810, 1041969311)
		 + W(4, -1110560421, -1111104301, -1122922762, 1029938402)
		 + W(5, -1107704269, 1043034893, 1041034358, 1050092429)
		 + W(6, 1049316874, -1112011481, 1044332351, -1117360942)
		 + W(7, -1116357646, -1107523849, -1112781805, -1104673921)
		 + W(8, 983067209, 1033280635, -1133572905, 1022258405) + W(9, 1016143957, -1109485745, 1010088409, -1106654827)
		 + W(10, -1121273022, 1026153330, -1116643818, 1033323756)
		 + W(11, -1123412994, 1027380094, 1016238045, 1006440178);
	WS(-1079099231, 1058224693);
	sum1 =
		W(0, -1136025729, 1041807413, -1113852830, 1038775953) + W(1, -1130024634, -1139925939, 1032899333, -1135488689)
		+ W(2, -1098612147, 1030021338, -1101745716, -1114342965)
		+ W(3, -1109189268, -1116898669, -1169623989, -1105924753)
		+ W(4, 1040574357, -1113591959, 1035906153, -1100940817)
		+ W(5, -1110548904, -1107090858, 983487291, -1105279552) + W(6, 1044962866, 1041390773, 1038641429, -1112997607)
		+ W(7, 1053521164, 1048687519, 1048553583, 1049805017) + W(8, -1107948018, 1030293261, -1102747762, -1131180663)
		+ W(9, -1102886695, -1127712365, 1020276366, 1033907987)
		+ W(10, -1152707357, 1019631368, -1119110697, 1008365619)
		+ W(11, -1120409456, -1156710253, -1137865855, -1120648241);
	sum2 =
		W(0, 1026221982, -1150712731, -1135858910, 998750602) + W(1, 1026066546, -1122173835, 1019885572, -1114797832)
		+ W(2, 1031288593, -1121646784, 1020650492, -1118866549)
		+ W(3, -1126679589, 1033676882, -1119823506, 1024418530)
		+ W(4, 1025270629, 1040465550, -1102699692, -1090773917) + W(5, -1103726643, 1038653616, 1044175124, 1035909226)
		+ W(6, -1105433524, -1099611845, -1077885918, -1073585027)
		+ W(7, -1083499628, 1072488285, 1076879885, 1053754278) + W(8, 1025604422, 1015298833, 1013887757, -1111404471)
		+ W(9, 1029004921, -1128843744, 1042609155, -1128976380)
		+ W(10, 1025361731, -1118571342, 1035533544, -1115122758)
		+ W(11, 1025173545, -1132364945, 982102231, -1120827581);
	WS(1039418864, -1140458522);
	sum1 = W(0, 983096624, 1029517505, -1121873782, 1019803894) + W(1, 1027911414, -1108005699, 1033576274, -1135118358)
		 + W(2, -1114535995, -1145085849, -1102746926, 1028523779)
		 + W(3, -1100878768, 1038991951, -1142936385, -1125909817)
		 + W(4, 1044450572, -1097839409, 1062380387, -1088253674)
		 + W(5, -1109645966, -1154916402, -1107146685, -1122115416)
		 + W(6, 1027001827, 1032347927, -1106235793, -1090653261) + W(7, 1061486174, 1029669390, 1047810758, 1038152785)
		 + W(8, -1117675070, 1031259878, -1105839880, 1036696746)
		 + W(9, -1097301074, 1024178544, 1038477872, 1041849616)
		 + W(10, 1035770150, -1104931415, 1033087169, -1121428646)
		 + W(11, -1120235273, 1035324408, -1108040973, 1017003668);
	sum2 = W(0, -1121567066, 1034344084, -1105011035, -1142865888)
		 + W(1, -1136511728, -1106811819, 1032101677, -1113394506)
		 + W(2, 1033267920, 1026284945, 1033899226, -1120108491)
		 + W(3, -1122542627, -1120621959, -1134482876, -1114137407)
		 + W(4, -1104421963, -1103410132, 1022298858, 1057117238)
		 + W(5, 1038703002, 1033583066, -1122973141, 1030826553)
		 + W(6, -1130139832, 1037507308, -1102818563, 1003910328)
		 + W(7, 1043197066, -1124006960, -1124335993, -1125132432)
		 + W(8, -1132243276, 1034735332, 1044067085, 1041074904)
		 + W(9, -1101099519, -1109459597, 1041237660, -1128301632)
		 + W(10, 1024120715, -1109350039, -1127155070, 975508032)
		 + W(11, -1117378085, 1001772648, -1113899392, -1126301549);
	WS(1053462780, -1083681865);
	sum1 = W(0, 1023511963, -1126058411, 1027394040, -1118697149) + W(1, 993307519, 1025756296, -1131368524, 1029589575)
		 + W(2, 1041747598, 1015154794, 1045749945, 1048726745) + W(3, 1043007793, 1038169844, 1024626666, 1040782360)
		 + W(4, 1041497612, 1018224530, 1041814811, -1086401302)
		 + W(5, -1115623160, 1032344226, -1127070442, -1131398580)
		 + W(6, -1138339988, 996055791, 1014351349, -1082085657)
		 + W(7, -1096882594, -1105145572, -1110953740, -1110890258)
		 + W(8, 1035615616, 1027711272, 1040756601, 1048515830) + W(9, 1042139693, 1038148425, 1009997960, 1029718722)
		 + W(10, 1020629658, -1123213919, 1032965474, -1129047376)
		 + W(11, -1132054806, 1033289129, -1128695798, 1029252236);
	sum2 = W(0, 1008350928, 1011413600, -1120704007, 1027382950) + W(1, -1127381517, 981904616, 1015535284, -1135583391)
		 + W(2, -1118714967, 1024023545, -1126562655, 1034951721)
		 + W(3, -1128407708, -1126139913, 999360844, -1138986423)
		 + W(4, 1030231193, -1124778398, -1110351493, 1052754126)
		 + W(5, 1033272406, -1151802072, 1013432992, -1123376913)
		 + W(6, -1091889801, -1098641764, -1104262464, 1057762368)
		 + W(7, -1161878816, 1012148800, 1024540201, 1031971990)
		 + W(8, -1108897465, 1033453825, -1106889474, 1035809187)
		 + W(9, -1132306565, -1153180738, 1014625240, -1118108772)
		 + W(10, 1032606711, -1125648711, 1025836907, -1131934955)
		 + W(11, -1134699254, -1131180247, -1171757551, -1140791326);
	WS(-1099299320, 1056598066);
	sum1 = W(0, 1006197652, -1128153660, -1136164796, 1035903322)
		 + W(1, -1130396894, 1036246880, -1124832314, 1029570879)
		 + W(2, -1127547996, 1041714651, 1029712499, -1128532088)
		 + W(3, -1106761055, -1121593759, 1017604226, 1017990507)
		 + W(4, -1106221946, -1098261544, -1085896508, 1057218165)
		 + W(5, 1054525467, 1028130044, 1036683414, 1016287010) + W(6, 1045972807, 1038366195, 1057638589, 1054413180)
		 + W(7, -1086573266, -1090476168, -1101308500, -1110319406)
		 + W(8, 1004824505, -1113181968, -1113770157, 1038963911)
		 + W(9, 1033084478, 1042818602, -1130963634, -1114724733)
		 + W(10, -1119658116, 1030219574, -1129447670, 1033715440)
		 + W(11, -1128924420, -1116035017, 1030841394, 998207538);
	sum2 = W(0, -1131923124, 993280665, -1127811288, 1032538133) + W(1, 992174233, 1002762140, 1015088121, 992586073)
		 + W(2, 1046772351, 1028557303, -1107794670, -1098564467)
		 + W(3, -1121892222, 1035775413, -1158807761, 1019898989)
		 + W(4, -1110971235, -1134148898, 1043137579, 1067961229)
		 + W(5, -1095277951, -1099141736, 1011333246, -1118039147)
		 + W(6, -1105011941, -1104446514, -1096504482, 1066594258)
		 + W(7, -1107079502, -1090299346, -1132433157, -1109952821)
		 + W(8, 1028001687, -1147560296, -1101129935, -1104613803)
		 + W(9, -1097683180, -1129031039, -1108888578, 1040568125)
		 + W(10, -1121147281, 1024426003, 1034898623, -1136832302)
		 + W(11, 1036381319, 1009264906, 1032287279, -1111357043);
	WS(-1105186296, -1108555742);
	sum1 =
		W(0, 1040483623, -1101386974, 1040816739, -1134311356) + W(1, -1108915605, 1046011615, -1102638726, 1034864637)
		+ W(2, -1105046378, 1038429012, 1031828819, -1107675004)
		+ W(3, 1034430779, -1109709717, 1030173660, -1130419297)
		+ W(4, -1118442722, 1042743759, -1093958439, 1030110546)
		+ W(5, 1044698927, -1103097566, 1041159370, -1111922822) + W(6, 1040666374, -1109750289, 1050019912, 1040526743)
		+ W(7, -1097473172, 1045974257, -1110364069, 1017242540) + W(8, 986662468, -1103538071, 1033262923, -1121451017)
		+ W(9, 1032745156, 1041021277, -1106175813, 1032931450)
		+ W(10, -1118942975, 1040611956, -1118385334, 1012951144)
		+ W(11, 1035127903, -1100748433, 1037154391, -1121991998);
	sum2 = W(0, -1127162070, -1135271108, 1003505825, 1012864633)
		 + W(1, -1123384038, 1026898060, -1134649836, -1125848258)
		 + W(2, 1014979733, -1136185376, 1028363168, -1131143608)
		 + W(3, 1033256022, -1133517476, -1120532892, 1028008335)
		 + W(4, -1114518101, 1038675289, -1105093650, -1095849351)
		 + W(5, 1028346583, -1113528611, 1028725832, -1117113572)
		 + W(6, 1016203776, -1140478504, -1089585970, -1070239185)
		 + W(7, -1078361549, 1038794260, -1125525718, 1005296645)
		 + W(8, 1035296562, -1111853852, 1058969759, 1079096535) + W(9, 1068193425, 1032636395, 1017911666, 1032298564)
		 + W(10, -1117887634, 1030827904, -1123277259, -1116960146)
		 + W(11, -1125445846, -1113311282, 991223090, -1134431064);
	WS(1065442623, 1015025160);
	sum1 =
		W(0, -1115365041, 1040496438, -1114325264, 1036061554) + W(1, 1038370800, -1112496600, 1039123015, -1120668655)
		+ W(2, -1113215535, 1031517084, -1109245393, 1002812769)
		+ W(3, 1036804053, -1099928488, 1036473513, -1116761110) + W(4, 1018550702, 1044423084, -1131936399, 1034975748)
		+ W(5, 1048106991, -1107673238, 1041344487, 1019812354) + W(6, 983382403, 1017412396, -1109909072, -1099246196)
		+ W(7, -1114225707, -1129165678, 1011581692, -1138585900)
		+ W(8, -1103693946, 1032083208, -1106995843, 1024898238)
		+ W(9, 1044531927, -1096349707, 1043676418, -1110354101)
		+ W(10, -1124004468, 1040563090, -1120263275, 1012000060)
		+ W(11, 1036150809, -1113013165, 1037117105, -1128538214);
	sum2 = W(0, 1010698941, 1042699596, 1048659418, 1058578114) + W(1, 1052277576, 1019470633, 1041036392, -1119471849)
		 + W(2, 1023126843, -1140656688, -1095653758, -1081184698)
		 + W(3, -1097586600, -1098953045, 1018118885, -1122826054)
		 + W(4, -1106210958, 1029081919, -1118272649, 1060468587)
		 + W(5, 1043044817, -1108654451, 1029721267, -1130901998)
		 + W(6, -1122624743, 1040813712, -1097694847, 996865603)
		 + W(7, -1103459725, -1128239326, 1034766857, 1000734433)
		 + W(8, -1122034237, -1174961495, 1033474214, -1102355565)
		 + W(9, 1049205466, -1112376452, 1033989555, 1017824567)
		 + W(10, -1117968485, 1039098482, -1118912655, 1020119257)
		 + W(11, 1031051049, -1108144089, 1038110136, -1114988670);
	WS(-1115864032, 1039792746);
	sum1 =
		W(0, -1140468214, 996096400, 1010495721, -1114956320) + W(1, 1013460969, -1122072970, -1127833232, -1140762151)
		+ W(2, -1121375417, -1108218204, -1109130991, -1115276388)
		+ W(3, 1040789857, -1114444905, 1026520268, -1127271361) + W(4, 1034497081, 1033625894, 1055392502, 1036829073)
		+ W(5, -1088431348, 1030275655, -1111886108, 1031218972) + W(6, 1039608980, 1040179481, -1093805194, 1050653566)
		+ W(7, 1049263376, 1051648994, -1121903450, -1112576115)
		+ W(8, -1113171393, -1108192053, -1127063626, -1109643980)
		+ W(9, -1124542831, -1129660583, 1034831154, 1019975176)
		+ W(10, -1132620605, 1018030914, 1012649753, -1127455572)
		+ W(11, -1135717173, -1147064482, -1114505023, -1135014713);
	sum2 =
		W(0, 1015385693, 1020691269, 1015565489, 1019337403) + W(1, -1132207064, -1131086480, -1163542113, 1010427910)
		+ W(2, -1115435752, -1141202058, -1111436746, 1040267853)
		+ W(3, -1114623303, 1025609602, -1140470334, -1128429973)
		+ W(4, 1035175215, -1117300235, 1033401267, -1100581516) + W(5, 1041259906, -1101351817, 1020278145, 1027629029)
		+ W(6, 1017441239, -1122675471, 1055273933, 1073306798)
		+ W(7, -1073173797, 1032997632, -1122237085, -1119509251)
		+ W(8, -1112773411, 1031000417, -1101083444, 1046685605)
		+ W(9, -1115311051, -1113329498, 1031244051, 1033297372) + W(10, 998363696, 1016207247, -1113092041, 1013448250)
		+ W(11, -1130370856, 1026870685, -1124843109, 1014260054);
	WS(1060418110, -1122066101);
	sum1 = W(0, 1031696780, -1124029560, -1147879495, -1123330286)
		 + W(1, -1137787811, 1025904121, -1122010711, -1131825009)
		 + W(2, -1115430516, -1129767372, 1033383950, 1032201307)
		 + W(3, -1124043956, -1135655378, 1016436406, 1011740349)
		 + W(4, -1104465800, -1124342772, -1084846132, 1040589380)
		 + W(5, 1059143665, 1047669789, 1032251443, 1017074582) + W(6, 1041576533, 1035204176, 1057835449, -1121351835)
		 + W(7, -1085338500, 1026196737, -1113520196, 1023559701)
		 + W(8, -1122042801, -1109435772, -1106791333, 1025265863)
		 + W(9, 1037079395, 1031201378, -1120875027, 1024540211) + W(10, 1028261758, 1025573168, 1024098613, 1000233671)
		 + W(11, 1020968696, -1122702819, 1016849816, -1123483709);
	sum2 = W(0, -1127836624, -1173496113, 1027284157, 1022886010)
		 + W(1, 1036751625, -1124242822, 1017945890, -1140181115)
		 + W(2, 1033364881, -1127629564, -1104916712, -1097350377)
		 + W(3, -1105423640, 1034826035, -1122986652, 1033442485)
		 + W(4, -1101679270, -1105780675, -1113070309, 1061873799)
		 + W(5, -1096904559, -1105550966, -1127473876, -1108824717)
		 + W(6, 1023580345, -1119640853, -1132739235, 1062616603)
		 + W(7, 1009507187, -1098447862, -1116534057, -1115327874)
		 + W(8, -1149619356, 1033890881, -1113766541, -1112358042)
		 + W(9, -1119315178, 1045500652, 1015952658, 1033458469)
		 + W(10, -1136662275, -1122666983, 1023707939, 1028952789)
		 + W(11, -1117384012, -1137245711, -1136860123, 1001899534);
	WS(1052277756, 1024619064);
	sum1 =
		W(0, 1029425189, -1155801216, 1030252033, -1112675811) + W(1, 1025211073, -1122395345, 994289396, -1124711713)
		+ W(2, -1120340480, -1107014752, 1038469578, 1032327591) + W(3, 1034534022, 1039704040, -1137717581, 1045346698)
		+ W(4, 1055903799, 1049346130, 1057427995, -1103272826) + W(5, 1040656272, -1111436999, 1016775164, -1134653325)
		+ W(6, -1093981294, -1099678446, -1098793998, -1090697510)
		+ W(7, -1103403378, 1041606598, 1005246730, 1013960373) + W(8, -1125235986, 1003141514, 1025012844, -1118748640)
		+ W(9, 1025335343, -1106833215, 1029370155, -1099652851)
		+ W(10, 1026200342, -1131584400, 1031806855, -1126277858)
		+ W(11, 1010568017, 1032770798, -1124454216, 1034190187);
	sum2 = W(0, 1023289146, 1020437582, 1009748873, 1030199907) + W(1, 1007345789, 1010063617, 1018930146, -1127799210)
		 + W(2, 1045862572, 1028786959, -1120652794, 1015917080)
		 + W(3, -1117660774, -1106003069, 1039304637, -1098471935)
		 + W(4, -1095566322, -1132354231, -1090793815, 1063879108)
		 + W(5, -1107315270, 1045942315, -1106431667, 1048572904)
		 + W(6, -1087461476, -1101737384, -1083542229, 1069217208)
		 + W(7, 1056862945, -1153692567, -1111757292, 1056217861)
		 + W(8, 1016132472, -1127607289, -1107157844, -1097091848)
		 + W(9, -1098187278, -1116485608, 1036040005, -1094693884)
		 + W(10, 1044890152, -1124440021, 1037463572, 1032502373)
		 + W(11, 1028169917, -1108513707, 1034190881, -1108016950);
	WS(-1086218302, -1084258561);
	sum1 = W(0, 1027347742, 1021408948, -1127633782, 1039366096)
		 + W(1, -1116749595, 1033396118, -1139872292, 1025066091) + W(2, 1041008695, 1036310380, 1035524367, 1048593117)
		 + W(3, -1138037400, 1045683171, 1032120647, 1046369740) + W(4, 1040638149, 1041666443, 1033011818, 1050103608)
		 + W(5, -1111907839, -1097626581, -1099416246, -1095221944)
		 + W(6, -1088163117, -1103354245, -1094269524, -1122175629)
		 + W(7, -1096387988, -1103712029, -1111740158, -1117250695)
		 + W(8, 1045697689, 1033383494, 1040895122, 1042904478)
		 + W(9, -1136050786, 1018682217, -1126758410, -1121047845)
		 + W(10, -1131589088, 1033326017, -1132088142, 1042877939)
		 + W(11, -1131538396, 1039834587, 1030901630, 1034112696);
	sum2 = W(0, -1116225927, 1030773056, -1122365237, 1032148531)
		 + W(1, -1127594672, 1026422036, 1023835916, -1131330830)
		 + W(2, 1020583173, 1018516207, -1121497633, 1032012136)
		 + W(3, -1111134479, -1112679629, -1123177144, -1112996078)
		 + W(4, -1120289762, -1142227828, 1024002380, 1050603076)
		 + W(5, 1040110681, -1109379336, -1102178993, -1102999759)
		 + W(6, -1116630862, -1157244503, 1045806125, 1061490298)
		 + W(7, -1104925089, -1096282325, -1103628682, -1116593585)
		 + W(8, 1037488437, -1120616119, -1122845130, 1029135782)
		 + W(9, -1122119114, 1035818151, -1118358279, 1024073644)
		 + W(10, -1120774706, 1021325617, -1124264052, 1020114521)
		 + W(11, -1129316292, -1129796491, 1024324894, -1129630471);
	WS(-1092406524, -1089571522);

	return clamp(mstd0 + 5.0 * vsum / wsum * mstd1, 0.0, 1.0);
}

shared float inp[555];

#define CURRENT_PASS 2

#define GET_SAMPLE(x) dot(x.rgb, rgb2y)
#define imageStore(out_image, pos, val) imageStoreOverride(pos, val.x)
void imageStoreOverride(uint2 pos, float value) {
	float2 UV = mul(rgb2uv, INPUT.SampleLevel(sam_INPUT_LINEAR, HOOKED_map(pos), 0).rgb);
	OUTPUT[pos] = float4(mul(yuv2rgb, float3(value.x, UV)), 1.0);
}

#define INPUT_tex(pos) GET_SAMPLE(vec4(texture(INPUT, pos)))
static const float2 INPUT_size = float2(GetInputSize());
static const float2 INPUT_pt = float2(GetInputPt());

#define temp_tex(pos) (float(texture(temp, pos).x))
static const float2 temp_size = float2(GetInputSize().x * 1, GetInputSize().y * 2);
static const float2 temp_pt = float2(1.0 / (temp_size.x), 1.0 / (temp_size.y));

#define HOOKED_tex(pos) temp_tex(pos)
#define HOOKED_size temp_size
#define HOOKED_pt temp_pt

void Pass2(uint2 blockStart, uint3 threadId) {
	ivec2 group_base = ivec2(gl_WorkGroupID) * ivec2(gl_WorkGroupSize);
	int local_pos = int(gl_LocalInvocationID.x) * 15 + int(gl_LocalInvocationID.y);
	for (int id = int(gl_LocalInvocationIndex); id < 555; id += int(gl_WorkGroupSize.x * gl_WorkGroupSize.y)) {
		uint x = (uint)id / 15, y = (uint)id % 15;
		inp[id] =
			HOOKED_tex(HOOKED_pt * vec2(float(group_base.x + x - (2)) + 0.5, float(group_base.y + y - (3)) + 0.5)).x;
	}
	barrier();
	vec4 ret = vec4(0.0, 0.0, 0.0, 0.0);
	vec4 ret0 = vec4(0.0, 0.0, 0.0, 0.0);
	vec4 samples[12];
	samples[0][0] = inp[local_pos + 0];
	samples[0][1] = inp[local_pos + 1];
	samples[0][2] = inp[local_pos + 2];
	samples[0][3] = inp[local_pos + 3];
	samples[1][0] = inp[local_pos + 4];
	samples[1][1] = inp[local_pos + 5];
	samples[1][2] = inp[local_pos + 6];
	samples[1][3] = inp[local_pos + 7];
	samples[2][0] = inp[local_pos + 15];
	samples[2][1] = inp[local_pos + 16];
	samples[2][2] = inp[local_pos + 17];
	samples[2][3] = inp[local_pos + 18];
	samples[3][0] = inp[local_pos + 19];
	samples[3][1] = inp[local_pos + 20];
	samples[3][2] = inp[local_pos + 21];
	samples[3][3] = inp[local_pos + 22];
	samples[4][0] = inp[local_pos + 30];
	samples[4][1] = inp[local_pos + 31];
	samples[4][2] = inp[local_pos + 32];
	samples[4][3] = inp[local_pos + 33];
	samples[5][0] = inp[local_pos + 34];
	samples[5][1] = inp[local_pos + 35];
	samples[5][2] = inp[local_pos + 36];
	samples[5][3] = inp[local_pos + 37];
	samples[6][0] = inp[local_pos + 45];
	samples[6][1] = inp[local_pos + 46];
	samples[6][2] = inp[local_pos + 47];
	samples[6][3] = inp[local_pos + 48];
	samples[7][0] = inp[local_pos + 49];
	samples[7][1] = inp[local_pos + 50];
	samples[7][2] = inp[local_pos + 51];
	samples[7][3] = inp[local_pos + 52];
	samples[8][0] = inp[local_pos + 60];
	samples[8][1] = inp[local_pos + 61];
	samples[8][2] = inp[local_pos + 62];
	samples[8][3] = inp[local_pos + 63];
	samples[9][0] = inp[local_pos + 64];
	samples[9][1] = inp[local_pos + 65];
	samples[9][2] = inp[local_pos + 66];
	samples[9][3] = inp[local_pos + 67];
	samples[10][0] = inp[local_pos + 75];
	samples[10][1] = inp[local_pos + 76];
	samples[10][2] = inp[local_pos + 77];
	samples[10][3] = inp[local_pos + 78];
	samples[11][0] = inp[local_pos + 79];
	samples[11][1] = inp[local_pos + 80];
	samples[11][2] = inp[local_pos + 81];
	samples[11][3] = inp[local_pos + 82];
	ret[0] = nnedi3(samples);
	ret0[0] = inp[local_pos + 33];
#if CURRENT_PASS == LAST_PASS
	uint2 destPos = blockStart + threadId.xy * 2;
	uint2 outputSize = GetOutputSize();
	if (destPos.x >= outputSize.x || destPos.y >= outputSize.y) {
		return;
	}
#endif
	imageStore(out_image, ivec2(gl_GlobalInvocationID) * ivec2(2, 1), ret0);
	imageStore(out_image, ivec2(gl_GlobalInvocationID) * ivec2(2, 1) + ivec2(1, 0), ret);
}
