//
//  EditEnhance_f.shader
//  BeautyPlus
//
//  Created by Webster Wu on 2/18/16.
//  Copyright © 2016 美图网. All rights reserved.
//

#ifdef GL_ES//for discriminate GLES & GL
#ifdef GL_FRAGMENT_PRECISION_HIGH
precision highp float;
#else
precision mediump float;
#endif
#else
#define highp
#define mediump
#define lowp
#endif

uniform sampler2D inputImageTexture0;

varying highp vec2 texcoordOut;

uniform lowp vec2 vignetteCenter;
uniform lowp vec3 vignetteColor;
uniform highp float vignetteStart;
uniform highp float vignetteEnd;
uniform highp float alpha;

void main()
{
    lowp vec4 sourceImageColor = texture2D(inputImageTexture0, texcoordOut);
    lowp float d = distance(texcoordOut, vec2(vignetteCenter.x, vignetteCenter.y));
    lowp float percent = smoothstep(vignetteStart, vignetteEnd, d);
    vec4 tmpColor = vec4(mix(sourceImageColor.rgb, vignetteColor, percent), sourceImageColor.a);
    gl_FragColor = mix(sourceImageColor, tmpColor, alpha);
}
