//
//  EditEnhance_f.shader
//  BeautyPlus
//
//  Created by Webster Wu on 2/18/16.
//  Copyright © 2016 美图网. All rights reserved.
//

#ifdef GL_ES//for discriminate GLES & GL
#ifdef GL_FRAGMENT_PRECISION_HIGH
precision highp float;
#else
precision mediump float;
#endif
#else
#define highp
#define mediump
#define lowp
#endif

varying vec2 texcoordOut;

uniform sampler2D inputImageTexture0;
uniform mat3 whiteMatrix;

void main() {
    vec3 color = texture2D(inputImageTexture0, texcoordOut).rgb;

    gl_FragColor.rgb = clamp(whiteMatrix * color, 0.0, 1.0);
    gl_FragColor.a = 1.;
}

