<?php


/**
 * 获取自定义分类法筛选配置
 * @Author Dadong2g
 * @date   2022-12-04
 * @return [type]
 */
function get_site_custom_taxonomy() {

    $data   = _cao('site_custom_taxonomy', array());
    $config = array();
    if (empty($data) || !is_array($data)) {
        return array();
    }

    foreach ($data as $key => $value) {

        $custom_taxonomy = trim($value['taxonomy']);

        if (!preg_match("/^[a-zA-Z\s]+$/", $custom_taxonomy)) {
            continue; //不是英文标识
        }

        $config[$custom_taxonomy] = $value;
    }

    return $config;
}

/**
 * 根据分类id获取当前分类筛选配置
 * @Author Dadong2g
 * @date   2022-12-04
 * @param  [type]     $cat_id [description]
 * @return [type]
 */
function get_cat_filter_config($cat_id) {

    $data   = _cao('site_term_filter_config', array());

    if (empty($cat_id) || empty($data)) {
        return array();
    }

    $config = array();

    foreach ($data as $item) {
        if ($item['cat_id'] == $cat_id) {
            $config = $item;
        }
    }

    return $config;
}

// 自定义分类筛选
// prefix custom
//
add_action('init', function () {

    $custom_taxonomy = get_site_custom_taxonomy();

    if (empty($custom_taxonomy)) {
        return;
    }

    foreach ($custom_taxonomy as $tax_key => $tax_item) {

        if ($tax_key == 'type') {
            continue;
        }
        
        if (taxonomy_exists($tax_key)) {
            continue;
        }

        register_extended_taxonomy($tax_key, 'post', [
            'labels'       => [
                'name'          => $tax_item['name'],
                'singular_name' => $tax_item['name'],
                'menu_name'     => $tax_item['name'],
                'search_items'  => __('搜索', 'ripro'),
                'all_items'     => __('全部', 'ripro'),
                'view_item'     => __('查看', 'ripro'),
                'edit_item'     => __('编辑', 'ripro'),
                'update_item'   => __('更新', 'ripro'),
                'add_new_item'  => __('添加新', 'ripro') . $tax_item['name'],
                'new_item_name' => __('新增', 'ripro'),
            ],
            'hierarchical' => false,
            'meta_box'     => $tax_item['type'],
            'rewrite'      => [
                'slug' => $tax_key,
            ],
        ]);
    }

});


