<?php

namespace Yurun\PaySDK\Alipay\Params\Refund;

/**
 * 支付宝无密退款业务参数类
 * 注：无密退款接口权限需要联系支付宝客服申请签约.
 */
class BusinessParams
{
    /**
     * 每进行一次即时到账批量退款，都需要提供一个批次号，通过该批次号可以查询这一批次的退款交易记录。对于每一个合作伙伴，传递的每一个批次号都必须保证唯一性。
     * 格式为：退款日期（8 位当天日期）+流水号（3～24 位，流水号可以接受数字或英文字符，建议使用数字，但不可接受“000”）。
     *
     * @var string
     */
    public $batch_no;

    /**
     * 退款请求的当前时间。
     * 格式为：yyyy-MM-dd hh:mm:ss。
     *
     * @var string
     */
    public $refund_date;

    /**
     * 退款总笔数
     * 即参数 detail_data 的值中，“#”字符出现的数量加 1，最大支持 1000 笔（即“#”字符出现的最大数量 999个）。
     *
     * @var int
     */
    public $batch_num;

    /**
     * 退款请求的明细数据。
     * 单笔数据集格式为：第一笔交易#第二笔交易#第三笔交易...#第 N 笔交易。
     * 其中每一笔交易按退交易、退分润、退子交易的组合来划分，有以下 4 种格式：
     *   – 交易退款数据集|分润退款数据集 1|分润退款数据集 2|...|分润退款数据集 N
     *   – 交易退款数据集|分润退款数据集 1|分润退款数据集 2|...|分润退款数据集 N$$退子交易
     *   – 交易退款数据集
     *   – 交易退款数据集$$退子交易
     * 交易退款数据集格式为：原付款支付宝交易号^退款总金额^退款理由。
     * 分润退款数据集格式为：转出人支付宝账号[原收到分润金额的账户]^转出人支付宝账号对应用户ID[2088开头16位纯数字]^转入人支付宝账号[原付出分润金额的账户]^转入人支付宝账号对应用户 ID^退款金额^退款理由。
     * 子交易退款数据集格式为：金额^退款理由。
     *
     * @var string
     */
    public $detail_data;

    /**
     * 是否使用冻结金额退款
     * Y：可以使用冻结金额退款
     * N：不可使用冻结金额退款
     * 如果不提供，则默认值为 N.
     *
     * @var string
     */
    public $use_freeze_amount;

    /**
     * 结果返回类型：xml。
     * xml：以 XML 格式返回执行结果。
     *
     * @var string
     */
    public $return_type;
}
