//Tablacus Explorer

if ("undefined" === typeof Promise) {
	Promise = function (fn) {
		this.promise = fn;
	}
	Promise.all = function (ar) {
		ar.then = function (fn) {
			for (var i = 0; i < ar.length; ++i) {
				if ("function" === typeof ar[i] && ar[i].promise) {
					(function (ar, i) {
						ar[i].promise(function (data) {
							ar[i] = data;
						});
					})(ar, i);
				}
			}
			fn(ar);
			return ar;
		}
		return ar;
	}
}

FixScript = RemoveAsync = function (s, a) {
	if (a) {
		return "(async () => {" + s + "\n})();";
	}
	s = s.replace(/([^\.\w])(async |await )/g, "$1");
	if ("undefined" === typeof ScriptEngineMajorVersion) {
		return s;
	}
	var v = ScriptEngineMajorVersion();
	s = s.replace(/(\([^\(\)]*\))\s*=>\s*\{/g, "function $1 {");
	if (v > 10) {
		return s;
	}
	s = s.replace(/([^\.\w])(const |let )/g, "$1var ").replace(/^const |^let /, "var ");
	return v > 9 ? s : s.replace(/(\s)(setTimeout\()/g, "$1window.$2");
}

AddEventEx = function (w, Name, fn) {
	if ("string" === typeof fn) {
		fn = new Function(FixScript(fn, window.chrome));
	}
	if (w.addEventListener) {
		w.addEventListener(Name, fn, false);
	} else if (w.attachEvent) {
		w.attachEvent("on" + Name, fn);
	}
}

BuildPath = function () {
	var s = "";
	var q;
	for (var i = 0; i < arguments.length; ++i) {
		if (q = String(arguments[i]).replace(/[\/\\]$/, "")) {
			if (s) {
				s += "\\" + (q.replace(/^[\/\\]+/, ""));
			} else {
				s = q;
			}
		}
	}
	return s.replace(/\//g, "\\");
};

GetParentFolderName = function (s) {
	var res = /^(.*)([\\\/])/.exec(s);
	var d = res && /^[A-Z]:/i.test(res[1]) ? 3 : 1;
	var r = res ? res[1].length < d ? res[1] + res[2] : res[1] : "";
	return r != s && r != "\\" && r.length >= d ? r : "";
}

LoadScript = function (js, cb) {
	var fn;
	var promise = [];
	while (fn = js.shift()) {
		if (window.chrome) {
			(function (fn) {
				promise.push(new Promise(function (resolve, reject) {
					var el = document.createElement("script");
					el.type = "text/javascript";
					el.src = BuildPath(ScriptBase, fn).replace(/\\/g, "/");
					el.onload = resolve;
					document.body.appendChild(el);
				}));
			})(fn);
		} else {
			fn = BuildPath((GetParentFolderName(api.GetModuleFileName(null))).replace(/\\$/, ""), fn);
			var ado = api.CreateObject("ads");
			if (ado) {
				ado.CharSet = "utf-8";
				ado.Open();
				try {
					ado.LoadFromFile(fn);
				} catch (e) {
					wsh.Popup([e.stack || e.message, fn].join("\n\n"));
				}
				var src = FixScript(ado.ReadText());
				ado.Close();
				document.write('<script type="text/javascript">\n' + src + '\n</script>');
			}
		}
	}
	Promise.all(promise).then(function () {
		if (cb) {
			cb();
		}
	});
}

GetFileName = function (s) {
	var res = /([^\\\/]*)$/.exec(s);
	return res ? res[1] : "";
}

PathQuoteSpaces = function (s) {
	return /\s/.test(s) ? '"' + s + '"' : s;
}

PathUnquoteSpaces = function (s) {
	var res = /^"(.*)"$/.exec(s);
	return res ? res[1] : s;
}

GetNum = function (s, d) {
	return "number" === typeof s ? s : Number("string" === typeof s ? s.replace(/[^\d\-\.].*/, "") : s) || d || 0;
}

SameText = function (s1, s2) {
	return String(s1).toLowerCase() === String(s2).toLowerCase();
}

//Tablacus
Ox80000000 = 0x80000000 | 0;
CTRL_FV = 0;
CTRL_SB = 1;
CTRL_EB = 2;
CTRL_TE = 0x10000;
CTRL_WB = 0x20000;
CTRL_SW = 0x20001;
CTRL_TC = 0x30000;
CTRL_TV = 0x40000;
CTRL_DT = 0x80000;
CTRL_FI = 0xF0000;

TCA_NONE = 0;
TCA_AUTO = 1;
TCA_TOP = 2;
TCA_BOTTOM = 3;
TCA_LEFT = 4;
TCA_RIGHT = 5;

USE_TASKMEMORY = 0;

TWM_APP = 0x8001; //WM_APP+1
TWM_CHANGENOTIFY = TWM_APP++;

TTID_TIMER = 0x2000;

SHGDN_ORIGINAL = 0x40000000;
SHGDN_FORPARSINGEX = 0x80000000;
HOME_PATH = 0;//Desktop
TITLE = "Tablacus Explorer";
ssfRESULTSFOLDER = 0x40;
ssfUNAVAILABLE = 0x41;
FILTER_IMAGE = "*.jpg;*.jpeg;*.png;*.bmp;*.gif;*.ico;data:*";
REGEXP_IMAGE = /^data:|\.jpe?g$|\.png$|\.bmp$|\.gif$|\.ico$/i;

//Windows
MAXINT = 0x7fffffff;
MAX_PATH = 260;
INVALID_HANDLE_VALUE = -1;

S_OK = 0;
S_FALSE = 1;
E_NOTIMPL = 0x80004001 | 0;
E_ABORT = 0x80004004 | 0;
E_FAIL = 0x80004005 | 0;
E_ACCESSDENIED = 0x80070005 | 0;

SBSP_SAMEBROWSER = 1;
SBSP_NEWBROWSER = 2;
SBSP_OPENMODE = 0x10;
SBSP_EXPLOREMODE = 0x20;
SBSP_RELATIVE = 0x1000;
SBSP_PARENT = 0x2000;
SBSP_NAVIGATEBACK = 0x4000;
SBSP_NAVIGATEFORWARD = 0x8000;
SBSP_ACTIVATE_NOFOCUS = 0x80000;
SBSP_WRITENOHISTORY = 0x08000000;

ssfALTSTARTUP = 0x1d;
ssfAPPDATA = 0x1a;
ssfBITBUCKET = 0xa;
ssfCOMMONALTSTARTUP = 0x1e;
ssfCOMMONAPPDATA = 0x23;
ssfCOMMONDESKTOPDIR = 0x19;
ssfCOMMONFAVORITES = 0x1f;
ssfCOMMONPROGRAMS = 0x17;
ssfCOMMONSTARTMENU = 0x16;
ssfCOMMONSTARTUP = 0x18;
ssfCONTROLS = 3;
ssfCOOKIES = 0x21;
ssfDESKTOP = 0;
ssfDESKTOPDIRECTORY = 0x10;
ssfDRIVES = 0x11;
ssfFAVORITES = 6;
ssfFONTS = 0x14;
ssfHISTORY = 0x22;
ssfINTERNETCACHE = 0x20;
ssfLOCALAPPDATA = 0x1c;
ssfMYPICTURES = 0x27;
ssfNETHOOD = 0x13;
ssfNETWORK = 0x12;
ssfPERSONAL = 5;
ssfPRINTERS = 4;
ssfPRINTHOOD = 0x1b;
ssfPROFILE = 0x28;
ssfPROGRAMFILES = 0x26;
ssfPROGRAMFILESx86 = 0x2a;
ssfPROGRAMS = 2;
ssfRECENT = 8;
ssfSENDTO = 9;
ssfSTARTMENU = 0xb;
ssfSTARTUP = 7;
ssfSYSTEM = 0x25;
ssfSYSTEMx86 = 0x29;
ssfTEMPLATES = 0x15;
ssfWINDOWS = 0x24;

FVM_AUTO = -1;
FVM_ICON = 1;
FVM_SMALLICON = 2;
FVM_LIST = 3;
FVM_DETAILS = 4;
FVM_THUMBNAIL = 5;
FVM_TILE = 6;
FVM_THUMBSTRIP = 7;

FWF_NONE = 0;
FWF_AUTOARRANGE = 1;
FWF_ABBREVIATEDNAMES = 2;
FWF_SNAPTOGRID = 4;
FWF_OWNERDATA = 8;
FWF_BESTFITWINDOW = 0x10;
FWF_DESKTOP = 0x20;
FWF_SINGLESEL = 0x40;
FWF_NOSUBFOLDERS = 0x80;
FWF_TRANSPARENT = 0x0100;
FWF_NOCLIENTEDGE = 0x0200;
FWF_NOSCROLL = 0x0400;
FWF_ALIGNLEFT = 0x0800;
FWF_NOICONS = 0x1000;
FWF_SHOWSELALWAYS = 0x2000;
FWF_NOVISIBLE = 0x4000;
FWF_SINGLECLICKACTIVATE = 0x8000;
FWF_NOWEBVIEW = 0x010000;
FWF_HIDEFILENAMES = 0x020000;
FWF_CHECKSELECT = 0x040000;
FWF_NOENUMREFRESH = 0x080000;
FWF_NOGROUPING = 0x100000;
FWF_FULLROWSELECT = 0x200000;
FWF_NOFILTERS = 0x400000;
FWF_NOCOLUMNHEADER = 0x800000;
FWF_NOHEADERINALLVIEWS = 0x01000000;
FWF_EXTENDEDTILES = 0x02000000;
FWF_TRICHECKSELECT = 0x04000000;
FWF_AUTOCHECKSELECT = 0x08000000;
FWF_NOBROWSERVIEWSTATE = 0x10000000;
FWF_SUBSETGROUPS = 0x20000000;
FWF_USESEARCHFOLDER = 0x40000000;
FWF_ALLOWRTLREADING = Ox80000000;

EBO_NONE = 0;
EBO_NAVIGATEONCE = 1;
EBO_SHOWFRAMES = 2;
EBO_ALWAYSNAVIGATE = 4;
EBO_NOWRAPPERWINDOW = 0x10;
EBO_HTMLSHAREPOINTVIEW = 0x20;

SVSI_DESELECT = 0;
SVSI_SELECT = 1;
SVSI_EDIT = 3;
SVSI_DESELECTOTHERS = 4;
SVSI_ENSUREVISIBLE = 8;
SVSI_FOCUSED = 0x10;
SVSI_TRANSLATEPT = 0x20;
SVSI_SELECTIONMARK = 0x40;
SVSI_POSITIONITEM = 0x80;
SVSI_CHECK = 0x0100;
SVSI_CHECK2 = 0x0200;
SVSI_KEYBOARDSELECT = 0x0401;
SVSI_NOTAKEFOCUS = 0x40000000;
SVSI_NOSTATECHANGE = Ox80000000;

EPS_DONTCARE = 0;
EPS_DEFAULT_ON = 1;
EPS_DEFAULT_OFF = 2;
EPS_STATEMASK = 0xffff;
EPS_INITIALSTATE = 0x10000;
EPS_FORCE = 0x20000;

EP_Commands = '{D9745868-CA5F-4A76-91CD-F5A129FBB076}';
EP_Commands_Organize = '{72E81700-E3EC-4660-BF24-3C3B7B648806}';
EP_Commands_View = '{21F7C32D-EEAA-439B-BB51-37B96FD6A943}';
EP_DetailsPane = '{43ABF98B-89B8-472D-B9CE-E69B8229F019}';
EP_NavPane = '{CB316B22-25F7-42B8-8A09-540D23A43C2F}';
EP_PreviewPane = '{893C63D1-45C8-4D17-BE19-223BE71BE365}';
EP_LibraryPane = '{DD503620-8D21-4DE8-A945-B4483196D612}';

VK_LBUTTON = 1;
VK_RBUTTON = 2;
VK_CANCEL = 3;
VK_MBUTTON = 4;
VK_XBUTTON1 = 5;
VK_XBUTTON2 = 6;
VK_BACK = 8;
VK_TAB = 9;
VK_CLEAR = 0x0C;
VK_RETURN = 0x0D;
VK_SHIFT = 0x10;
VK_CONTROL = 0x11;
VK_MENU = 0x12;
VK_CAPITAL = 0x14;
VK_ESCAPE = 0x1B;
VK_SPACE = 0x20;
VK_PRIOR = 0x21;
VK_NEXT = 0x22;
VK_END = 0x23;
VK_HOME = 0x24;
VK_LEFT = 0x25;
VK_UP = 0x26;
VK_RIGHT = 0x27;
VK_DOWN = 0x28;
VK_SELECT = 0x29;
VK_PRINT = 0x2A;
VK_EXECUTE = 0x2B;
VK_SNAPSHOT = 0x2C;
VK_INSERT = 0x2D;
VK_DELETE = 0x2E;
VK_HELP = 0x2F;
VK_LWIN = 0x5B;
VK_RWIN = 0x5C;
VK_APPS = 0x5D;
VK_F1 = 0x70;
VK_F2 = 0x71;
VK_F3 = 0x72;
VK_F4 = 0x73;
VK_F5 = 0x74;
VK_F6 = 0x75;
VK_F7 = 0x76;
VK_F8 = 0x77;
VK_F9 = 0x78;
VK_F10 = 0x79;
VK_F11 = 0x7A;
VK_F12 = 0x7B;
VK_PROCESSKEY = 0xE5;

MK_LBUTTON = 1;
MK_RBUTTON = 2;
MK_SHIFT = 4;
MK_CONTROL = 8;
MK_MBUTTON = 0x10;
MK_XBUTTON1 = 0x20;
MK_XBUTTON2 = 0x40;

XBUTTON1 = 1;
XBUTTON2 = 2;

DROPEFFECT_NONE = 0;
DROPEFFECT_COPY = 1;
DROPEFFECT_MOVE = 2;
DROPEFFECT_LINK = 4;

WM_NULL = 0;
WM_CREATE = 1;
WM_DESTROY = 2;
WM_MOVE = 3;
WM_SIZE = 5;
WM_ACTIVATE = 6;
WM_SETFOCUS = 7;
WM_KILLFOCUS = 8;
WM_ENABLE = 0xA;
WM_SETREDRAW = 0xB;
WM_SETTEXT = 0xC;
WM_GETTEXT = 0xD;
WM_GETTEXTLENGTH = 0xE;
WM_PAINT = 0xF;
WM_CLOSE = 0x10;
WM_QUERYENDSESSION = 0x11;
WM_QUERYOPEN = 0x13;
WM_ENDSESSION = 0x16;
WM_QUIT = 0x12;
WM_ERASEBKGND = 0x14;
WM_SYSCOLORCHANGE = 0x15;
WM_SHOWWINDOW = 0x18;
WM_WININICHANGE = 0x1A;
WM_SETTINGCHANGE = WM_WININICHANGE;
WM_DEVMODECHANGE = 0x1B;
WM_ACTIVATEAPP = 0x1C;
WM_FONTCHANGE = 0x1D;
WM_TIMECHANGE = 0x1E;
WM_CANCELMODE = 0x1F;
WM_SETCURSOR = 0x20;
WM_MOUSEACTIVATE = 0x21;
WM_CHILDACTIVATE = 0x22;
WM_QUEUESYNC = 0x23;
WM_GETMINMAXINFO = 0x24;
WM_DRAWITEM = 0x2B;
WM_MEASUREITEM = 0x2C;
WM_SETFONT = 0x30;
WM_GETFONT = 0x31;
WM_COPYDATA = 0x4A;
WM_NOTIFY = 0x4E;
WM_CONTEXTMENU = 0x7B;
WM_GETICON = 0x7F;
WM_SETICON = 0x80;
WM_NCLBUTTONDOWN = 0xA1;
WM_KEYDOWN = 0x0100;
WM_KEYUP = 0x0101;
WM_CHAR = 0x0102;
WM_DEADCHAR = 0x0103;
WM_SYSKEYDOWN = 0x0104;
WM_SYSKEYUP = 0x0105;
WM_SYSCHAR = 0x0106;
WM_SYSDEADCHAR = 0x0107;
WM_UNICHAR = 0x0109;
WM_INITDIALOG = 0x0110;
WM_COMMAND = 0x0111;
WM_SYSCOMMAND = 0x0112;
WM_TIMER = 0x0113;
WM_HSCROLL = 0x0114;
WM_VSCROLL = 0x0115;
WM_INITMENU = 0x0116;
WM_INITMENUPOPUP = 0x0117;
WM_MENUSELECT = 0x011F;
WM_MENUCHAR = 0x0120;
WM_MENURBUTTONUP = 0x0122;
WM_MENUDRAG = 0x0123;
WM_MENUGETOBJECT = 0x0124;
WM_UNINITMENUPOPUP = 0x0125;
WM_MENUCOMMAND = 0x0126;

WM_MOUSEMOVE = 0x0200;
WM_LBUTTONDOWN = 0x0201;
WM_LBUTTONUP = 0x0202;
WM_LBUTTONDBLCLK = 0x0203;
WM_RBUTTONDOWN = 0x0204;
WM_RBUTTONUP = 0x0205;
WM_RBUTTONDBLCLK = 0x0206;
WM_MBUTTONDOWN = 0x0207;
WM_MBUTTONUP = 0x0208;
WM_MBUTTONDBLCLK = 0x0209;
WM_MOUSEWHEEL = 0x020A;
WM_XBUTTONDOWN = 0x020B;
WM_XBUTTONUP = 0x020C;
WM_XBUTTONDBLCLK = 0x020D;
WM_PARENTNOTIFY = 0x0210;
WM_ENTERMENULOOP = 0x0211;
WM_EXITMENULOOP = 0x0212;
WM_POWERBROADCAST = 0x0218;
WM_DEVICECHANGE = 0x0219;
WM_DROPFILES = 0x0233;
WM_DPICHANGED = 0x02E0
WM_HOTKEY = 0x0312;
WM_THEMECHANGED = 0x031A;
WM_CLIPBOARDUPDATE = 0x8000;

WM_USER = 0x0400;
WM_APP = 0x8000;

TCHT_NOWHERE = 1;
TCHT_ONITEMICON = 2;
TCHT_ONITEMLABEL = 4;
TCHT_ONITEM = 6;

TCM_DELETEALLITEMS = 0x1309;
TCM_DELETEITEM = 0x1308;
TCM_GETCURSEL = 0x130B;
TCM_GETITEMCOUNT = 0x1304;
TCM_INSERTITEM = 0x1307;
TCM_SETCURSEL = 0x130C;
TCM_SETIMAGELIST = 0x1303;
TCM_SETITEM = 0x133d;
TCM_GETITEM = 0x133c;
TCM_SETMINTABWIDTH = 0x1331;

TCIF_TEXT = 1;
TCIF_IMAGE = 2;
TCIF_RTLREADING = 4;
TCIF_PARAM = 8;
TCIF_STATE = 0x10;

WC_LISTVIEW = "SysListView32";
WC_TREEVIEW = "SysTreeView32";
WC_TABCONTROL = "SysTabControl32";
WC_HEADER = "SysHeader32";
WC_EDIT = "Edit";

LVM_FINDITEM = 0x100D;
LVM_GETBKCOLOR = 0x1000;
LVM_GETBKIMAGE = 0x108B;
LVM_GETCOLUMN = 0x105F;
LVM_GETCOLUMNWIDTH = 0x101D;
LVM_GETCOUNTPERPAGE = 0x1028;
LVM_GETEDITCONTROL = 0x1018;
LVM_GETEXTENDEDLISTVIEWSTYLE = 0x1037;
LVM_GETGROUPCOUNT = 0x1098;
LVM_GETGROUPINFO = 0x1095;
LVM_GETHEADER = 0x101F;
LVM_GETITEM = 0x104B;
LVM_GETITEMCOUNT = 0x1004;
LVM_GETITEMPOSITION = 0x1010;
LVM_GETITEMRECT = 0x100E;
LVM_GETITEMSTATE = 0x102C;
LVM_GETNEXTITEM = 0x100C;
LVM_GETORIGIN = 0x1029;
LVM_GETSELECTEDCOLUMN = 0x10AE;
LVM_GETSTRINGWIDTH = 0x1057;
LVM_GETTEXTCOLOR = 0x1023;
LVM_GETTEXTBKCOLOR = 0x1025;
LVM_GETTOPINDEX = 0x1027;
LVM_GETVIEW = 0x108F;
LVM_HASGROUP = 0x10A1;
LVM_HITTEST = 0x1012;
LVM_ISITEMVISIBLE = 0x10B6;
LVM_ISGROUPVIEWENABLED = 0x10B2;
LVM_REDRAWITEMS = 0x1015;
LVM_SCROLL = 0x1014;
LVM_SETBKCOLOR = 0x1001;
LVM_SETBKIMAGE = 0x108A;
LVM_SETCOLUMN = 0x1060;
LVM_SETCOLUMNWIDTH = 0x101E;
LVM_SETEXTENDEDLISTVIEWSTYLE = 0x1036;
LVM_SETGROUPINFO = 0x1093;
LVM_SETICONSPACING = 0x1035;
LVM_SETITEM = 0x1006;
LVM_SETITEMPOSITION32 = 0x1031;
LVM_SETITEMSTATE = 0x102B;
LVM_SETSELECTEDCOLUMN = 0x108C;
LVM_SETTEXTBKCOLOR = 0x1026;
LVM_SETTEXTCOLOR = 0x1024;
LVM_SETVIEW = 0x108E;

LVIF_TEXT = 1;
LVIF_IMAGE = 2;
LVIF_PARAM = 4;
LVIF_STATE = 8;
LVIF_INDENT = 0x10;
LVIF_NORECOMPUTE = 0x0800;
LVIF_GROUPID = 0x0100;
LVIF_COLUMNS = 0x0200;
LVIF_COLFMT = 0x010000;

LVIS_FOCUSED = 1;
LVIS_SELECTED = 2;
LVIS_CUT = 4;
LVIS_DROPHILITED = 8;
LVIS_GLOW = 0x10;
LVIS_ACTIVATING = 0x20;
LVIS_OVERLAYMASK = 0x0F00;
LVIS_STATEIMAGEMASK = 0xF000;

LVFI_PARAM = 1;
LVFI_STRING = 2;
LVFI_SUBSTRING = 4;
LVFI_PARTIAL = 8;
LVFI_WRAP = 0x20;
LVFI_NEARESTXY = 0x40;

LVS_EX_GRIDLINES = 1;
LVS_EX_SUBITEMIMAGES = 2;
LVS_EX_CHECKBOXES = 4;
LVS_EX_TRACKSELECT = 8;
LVS_EX_HEADERDRAGDROP = 0x10;
LVS_EX_FULLROWSELECT = 0x20;
LVS_EX_ONECLICKACTIVATE = 0x40;
LVS_EX_TWOCLICKACTIVATE = 0x80;
LVS_EX_FLATSB = 0x0100;
LVS_EX_REGIONAL = 0x0200;
LVS_EX_INFOTIP = 0x0400;
LVS_EX_UNDERLINEHOT = 0x0800;
LVS_EX_UNDERLINECOLD = 0x1000;
LVS_EX_MULTIWORKAREAS = 0x2000;
LVS_EX_LABELTIP = 0x4000;
LVS_EX_BORDERSELECT = 0x8000;
LVS_EX_DOUBLEBUFFER = 0x010000;
LVS_EX_HIDELABELS = 0x020000;
LVS_EX_SINGLEROW = 0x040000;
LVS_EX_SNAPTOGRID = 0x080000;
LVS_EX_SIMPLESELECT = 0x100000;
LVS_EX_JUSTIFYCOLUMNS = 0x200000;
LVS_EX_TRANSPARENTBKGND = 0x400000;
LVS_EX_TRANSPARENTSHADOWTEXT = 0x800000;
LVS_EX_AUTOAUTOARRANGE = 0x01000000;
LVS_EX_HEADERINALLVIEWS = 0x02000000;
LVS_EX_AUTOCHECKSELECT = 0x08000000;
LVS_EX_AUTOSIZECOLUMNS = 0x10000000;
LVS_EX_COLUMNSNAPPOINTS = 0x40000000;
LVS_EX_COLUMNOVERFLOW = Ox80000000;

LVBKIF_SOURCE_NONE = 0;
LVBKIF_SOURCE_HBITMAP = 1;
LVBKIF_SOURCE_URL = 2;
LVBKIF_SOURCE_MASK = 3;
LVBKIF_STYLE_NORMAL = 0;
LVBKIF_STYLE_TILE = 0x10;
LVBKIF_STYLE_MASK = 0x10;
LVBKIF_FLAG_TILEOFFSET = 0x0100;
LVBKIF_TYPE_WATERMARK = 0x10000000;
LVBKIF_FLAG_ALPHABLEND = 0x20000000;

LVIR_BOUNDS = 0;
LVIR_ICON = 1;
LVIR_LABEL = 2;
LVIR_SELECTBOUNDS = 3;

LVNI_ALL = 0;
LVNI_FOCUSED = 1;
LVNI_SELECTED = 2;
LVNI_CUT = 4;
LVNI_DROPHILITED = 8;
LVNI_STATEMASK = LVNI_FOCUSED | LVNI_SELECTED | LVNI_CUT | LVNI_DROPHILITED;
LVNI_VISIBLEORDER = 0x10;
LVNI_PREVIOUS = 0x20;
LVNI_VISIBLEONLY = 0x40;
LVNI_SAMEGROUPONLY = 0x80;
LVNI_ABOVE = 0x0100;
LVNI_BELOW = 0x0200;
LVNI_TOLEFT = 0x0400;
LVNI_TORIGHT = 0x0800;
LVNI_DIRECTIONMASK = LVNI_ABOVE | LVNI_BELOW | LVNI_TOLEFT | LVNI_TORIGHT;

HDM_GETITEMCOUNT = 0x1200;
HDM_GETITEM = 0x120B;
HDM_SETITEM = 0x120C;

HDI_WIDTH = 1;
HDI_TEXT = 2;
HDI_FORMAT = 4;
HDI_LPARAM = 8;
HDI_BITMAP = 0x10;
HDI_IMAGE = 0x20;
HDI_DI_SETITEM = 0x40;
HDI_ORDER = 0x80;
HDI_FILTER = 0x0100;
HDI_STATE = 0x0200;

HDF_LEFT = 0;
HDF_RIGHT = 1;
HDF_CENTER = 2;
HDF_JUSTIFYMASK = 3;
HDF_RTLREADING = 4;
HDF_BITMAP = 0x2000;
HDF_STRING = 0x4000;
HDF_OWNERDRAW = 0x8000;
HDF_IMAGE = 0x0800;
HDF_BITMAP_ON_RIGHT = 0x1000;
HDF_SORTUP = 0x0400;
HDF_SORTDOWN = 0x0200;

TVM_CREATEDRAGIMAGE = 0x1112;
TVM_DELETEITEM = 0x1101;
TVM_ENDEDITLABELNO = 0x1116;
TVM_ENSUREVISIBLE = 0x1114;
TVM_EXPAND = 0x1102;
TVM_GETCOUNT = 0x1105;
TVM_GETEDITCONTROL = 0x110f;
TVM_GETIMAGELIST = 0x1108;
TVM_GETINDENT = 0x1106;
TVM_GETITEMRECT = 0x1104;
TVM_GETNEXTITEM = 0x110a;
TVM_GETVISIBLECOUNT = 0x1110;
TVM_HITTEST = 0x1111;
TVM_EDITLABEL = 0x1141;
TVM_GETISEARCHSTRING = 0x1140;
TVM_GETITEM = 0x113e;
TVM_INSERTITEM = 0x1132;
TVM_SETITEM = 0x113f;
TVM_SELECTITEM = 0x110b;
TVM_SETIMAGELIST = 0x1109;
TVM_SETINDENT = 0x1107;
TVM_SORTCHILDREN = 0x1113;
TVM_SORTCHILDRENCB = 0x1115;
TVM_SETITEMHEIGHT = 0x111B;
TVM_GETITEMHEIGHT = 0x111C;
TVM_SETBKCOLOR = 0x111D;
TVM_GETBKCOLOR = 0x111F;
TVM_SETTEXTCOLOR = 0x111E;
TVM_GETTEXTCOLOR = 0x1120;
TVM_SETLINECOLOR = 0x1128;
TVM_GETLINECOLOR = 0x1129;

TVIF_TEXT = 1;
TVIF_IMAGE = 2;
TVIF_PARAM = 4;
TVIF_STATE = 8;
TVIF_HANDLE = 0x10;
TVIF_SELECTEDIMAGE = 0x20;
TVIF_CHILDREN = 0x40;
TVIF_INTEGRAL = 0x80;
TVIF_STATEEX = 0x0100;
TVIF_EXPANDEDIMAGE = 0x0200;

TVIS_SELECTED = 2;
TVIS_CUT = 4;
TVIS_DROPHILITED = 8;
TVIS_BOLD = 0x10;
TVIS_EXPANDED = 0x20;
TVIS_EXPANDEDONCE = 0x40;
TVIS_EXPANDPARTIAL = 0x80;
TVIS_OVERLAYMASK = 0x0F00;
TVIS_STATEIMAGEMASK = 0xF000;
TVIS_USERMASK = 0xF000;
TVIS_EX_FLAT = 1;
TVIS_EX_DISABLED = 2;
TVIS_EX_ALL = 2;

MF_INSERT = 0;
MF_CHANGE = 0x80;
MF_APPEND = 0x0100;
MF_DELETE = 0x0200;
MF_REMOVE = 0x1000;
MF_BYCOMMAND = 0;
MF_BYPOSITION = 0x0400;
MF_SEPARATOR = 0x0800;
MF_ENABLED = 0;
MF_GRAYED = 1;
MF_DISABLED = 2;
MF_UNCHECKED = 0;
MF_CHECKED = 8;
MF_USECHECKBITMAPS = 0x0200;
MF_STRING = 0;
MF_BITMAP = 4;
MF_OWNERDRAW = 0x0100;
MF_POPUP = 0x10;
MF_MENUBARBREAK = 0x20;
MF_MENUBREAK = 0x40;
MF_UNHILITE = 0;
MF_HILITE = 0x80;
MF_DEFAULT = 0x1000;
MF_SYSMENU = 0x2000;
MF_HELP = 0x4000;
MF_RIGHTJUSTIFY = 0x4000;
MF_MOUSESELECT = 0x8000;

MFT_STRING = MF_STRING;
MFT_BITMAP = MF_BITMAP;
MFT_MENUBARBREAK = MF_MENUBARBREAK;
MFT_MENUBREAK = MF_MENUBREAK;
MFT_OWNERDRAW = MF_OWNERDRAW;
MFT_RADIOCHECK = 0x0200;
MFT_SEPARATOR = MF_SEPARATOR;
MFT_RIGHTORDER = 0x2000;
MFT_RIGHTJUSTIFY = MF_RIGHTJUSTIFY;

MFS_GRAYED = 3;
MFS_DISABLED = MFS_GRAYED;
MFS_CHECKED = MF_CHECKED;
MFS_HILITE = MF_HILITE;
MFS_ENABLED = MF_ENABLED;
MFS_UNCHECKED = MF_UNCHECKED;
MFS_UNHILITE = MF_UNHILITE;
MFS_DEFAULT = MF_DEFAULT;

GMDI_USEDISABLED = 1;
GMDI_GOINTOPOPUPS = 2;

TPM_LEFTBUTTON = 0;
TPM_RIGHTBUTTON = 2;
TPM_LEFTALIGN = 0;
TPM_CENTERALIGN = 4;
TPM_RIGHTALIGN = 8;
TPM_TOPALIGN = 0;
TPM_VCENTERALIGN = 0x10;
TPM_BOTTOMALIGN = 0x20;
TPM_HORIZONTAL = 0;
TPM_VERTICAL = 0x40;
TPM_NONOTIFY = 0x80;
TPM_RETURNCMD = 0x0100;
TPM_RECURSE = 1;
TPM_HORPOSANIMATION = 0x0400;
TPM_HORNEGANIMATION = 0x0800;
TPM_VERPOSANIMATION = 0x1000;
TPM_VERNEGANIMATION = 0x2000;
TPM_NOANIMATION = 0x4000;

CMF_NORMAL = 0;
CMF_DEFAULTONLY = 1;
CMF_VERBSONLY = 2;
CMF_EXPLORE = 4;
CMF_NOVERBS = 8;
CMF_CANRENAME = 0x10;
CMF_NODEFAULT = 0x20;
CMF_INCLUDESTATIC = 0x40;
CMF_ITEMMENU = 0x80;
CMF_EXTENDEDVERBS = 0x0100;
CMF_DISABLEDVERBS = 0x0200;
CMF_ASYNCVERBSTATE = 0x0400;
CMF_OPTIMIZEFORINVOKE = 0x0800;
CMF_SYNCCASCADEMENU = 0x1000;
CMF_DONOTPICKDEFAULT = 0x2000;

SW_HIDE = 0
SW_SHOWNORMAL = 1
SW_NORMAL = 1
SW_SHOWMINIMIZED = 2
SW_SHOWMAXIMIZED = 3
SW_MAXIMIZE = 3
SW_SHOWNOACTIVATE = 4
SW_SHOW = 5
SW_MINIMIZE = 6
SW_SHOWMINNOACTIVE = 7
SW_SHOWNA = 8
SW_RESTORE = 9
SW_SHOWDEFAULT = 10
SW_FORCEMINIMIZE = 11

LOAD_LIBRARY_AS_DATAFILE = 2;
IMAGE_BITMAP = 0;
IMAGE_ICON = 1;
IMAGE_CURSOR = 2;
IMAGE_ENHMETAFILE = 3;

LR_DEFAULTCOLOR = 0;
LR_MONOCHROME = 1;
LR_COLOR = 2;
LR_LOADFROMFILE = 0x10;
LR_LOADTRANSPARENT = 0x20;
LR_CREATEDIBSECTION = 0x2000;
LR_COPYFROMRESOURCE = 0x4000;
LR_SHARED = 0x8000;

CLR_NONE = 0xFFFFFFFF;
CLR_DEFAULT = 0xFF000000;

COLOR_SCROLLBAR = 0;
COLOR_BACKGROUND = 1;
COLOR_ACTIVECAPTION = 2;
COLOR_INACTIVECAPTION = 3;
COLOR_MENU = 4;
COLOR_WINDOW = 5;
COLOR_WINDOWFRAME = 6;
COLOR_MENUTEXT = 7;
COLOR_WINDOWTEXT = 8;
COLOR_CAPTIONTEXT = 9;
COLOR_ACTIVEBORDER = 10;
COLOR_INACTIVEBORDER = 11;
COLOR_APPWORKSPACE = 12;
COLOR_HIGHLIGHT = 13;
COLOR_HIGHLIGHTTEXT = 14;
COLOR_BTNFACE = 15;
COLOR_BTNSHADOW = 16;
COLOR_GRAYTEXT = 17;
COLOR_BTNTEXT = 18;
COLOR_INACTIVECAPTIONTEXT = 19;
COLOR_BTNHIGHLIGHT = 20;

ILD_NORMAL = 0;
ILD_TRANSPARENT = 1;
ILD_FOCUS = 2;
ILD_SELECTED = 4;
ILD_MASK = 0x10;
ILD_IMAGE = 0x20;

WS_BORDER = 0x800000;

TCS_TABS = 0;
TCS_BUTTONS = 0x0100;
TCS_SINGLELINE = 0;
TCS_MULTILINE = 0x0200;
TCS_RIGHTJUSTIFY = 0;
TCS_FIXEDWIDTH = 0x0400;
TCS_RAGGEDRIGHT = 0x0800;
TCS_FOCUSONBUTTONDOWN = 0x1000;
TCS_OWNERDRAWFIXED = 0x2000;
TCS_TOOLTIPS = 0x4000;
TCS_FOCUSNEVER = 0x8000;
TCS_SCROLLOPPOSITE = 1;
TCS_BOTTOM = 2;
TCS_RIGHT = 2;
TCS_MULTISELECT = 4;
TCS_FLATBUTTONS = 8;
TCS_FORCEICONLEFT = 0x10;
TCS_FORCELABELLEFT = 0x20;
TCS_HOTTRACK = 0x40;
TCS_VERTICAL = 0x80;

NSTCS_HASEXPANDOS = 1;
NSTCS_HASLINES = 2;
NSTCS_SINGLECLICKEXPAND = 4;
NSTCS_FULLROWSELECT = 8;
NSTCS_SPRINGEXPAND = 0x10;
NSTCS_HORIZONTALSCROLL = 0x20;
NSTCS_ROOTHASEXPANDO = 0x40;
NSTCS_SHOWSELECTIONALWAYS = 0x80;
NSTCS_NOINFOTIP = 0x200;
NSTCS_EVENHEIGHT = 0x400;
NSTCS_NOREPLACEOPEN = 0x800;
NSTCS_DISABLEDRAGDROP = 0x1000;
NSTCS_NOORDERSTREAM = 0x2000;
NSTCS_RICHTOOLTIP = 0x4000;
NSTCS_BORDER = 0x8000;
NSTCS_NOEDITLABELS = 0x10000;
NSTCS_TABSTOP = 0x20000;
NSTCS_FAVORITESMODE = 0x80000;
NSTCS_AUTOHSCROLL = 0x100000;
NSTCS_FADEINOUTEXPANDOS = 0x200000;
NSTCS_EMPTYTEXT = 0x400000;
NSTCS_CHECKBOXES = 0x800000;
NSTCS_PARTIALCHECKBOXES = 0x1000000;
NSTCS_EXCLUSIONCHECKBOXES = 0x2000000;
NSTCS_DIMMEDCHECKBOXES = 0x4000000;
NSTCS_NOINDENTCHECKS = 0x8000000;
NSTCS_ALLOWJUNCTIONS = 0x10000000;
NSTCS_SHOWTABSBUTTON = 0x20000000;
NSTCS_SHOWDELETEBUTTON = 0x40000000;
NSTCS_SHOWREFRESHBUTTON = Ox80000000;

SHGDN_NORMAL = 0;
SHGDN_INFOLDER = 1;
SHGDN_FOREDITING = 0x1000;
SHGDN_FORADDRESSBAR = 0x4000;
SHGDN_FORPARSING = 0x8000;

SHCONTF_CHECKING_FOR_CHILDREN = 0x010;
SHCONTF_FOLDERS = 0x020;
SHCONTF_NONFOLDERS = 0x040;
SHCONTF_INCLUDEHIDDEN = 0x080;
SHCONTF_INIT_ON_FIRST_NEXT = 0x100;
SHCONTF_NETPRINTERSRCH = 0x200;
SHCONTF_SHAREABLE = 0x400;
SHCONTF_STORAGE = 0x800;
SHCONTF_NAVIGATION_ENUM = 0x01000;
SHCONTF_FASTITEMS = 0x02000;
SHCONTF_FLATLIST = 0x04000;
SHCONTF_ENABLE_ASYNC = 0x08000;
SHCONTF_INCLUDESUPERHIDDEN = 0x10000;

SHGDFIL_FINDDATA = 1;
SHGDFIL_NETRESOURCE = 2;
SHGDFIL_DESCRIPTIONID = 3;

NSTCRS_VISIBLE = 0;
NSTCRS_HIDDEN = 1;
NSTCRS_EXPANDED = 2;

NSTCEHT_NOWHERE = 1;
NSTCEHT_ONITEMICON = 2;
NSTCEHT_ONITEMLABEL = 4;
NSTCEHT_ONITEMINDENT = 8;
NSTCEHT_ONITEMBUTTON = 0x10;
NSTCEHT_ONITEMRIGHT = 0x20;
NSTCEHT_ONITEMSTATEICON = 0x40;
NSTCEHT_ONITEM = 0x46;
NSTCEHT_ONITEMTABBUTTON = 0x1000;

NSTCECT_LBUTTON = 1;
NSTCECT_MBUTTON = 2;
NSTCECT_RBUTTON = 3;
NSTCECT_BUTTON = 3;
NSTCECT_DBLCLICK = 4;

LVHT_NOWHERE = 1;
LVHT_ONITEMICON = 2;
LVHT_ONITEMLABEL = 4;
LVHT_ONITEMSTATEICON = 8;
LVHT_ONITEM = LVHT_ONITEMICON | LVHT_ONITEMLABEL | LVHT_ONITEMSTATEICON;

LVHT_ABOVE = 8;
LVHT_BELOW = 0x10;
LVHT_TORIGHT = 0x20;
LVHT_TOLEFT = 0x40;

TVHT_NOWHERE = 1;
TVHT_ONITEMICON = 2;
TVHT_ONITEMLABEL = 4;
TVHT_ONITEMINDENT = 8;
TVHT_ONITEMBUTTON = 0x10;
TVHT_ONITEMRIGHT = 0x20;
TVHT_ONITEMSTATEICON = 0x40;
TVHT_ONITEM = TVHT_ONITEMICON | TVHT_ONITEMLABEL | TVHT_ONITEMSTATEICON;

TVHT_ABOVE = 0x0100;
TVHT_BELOW = 0x0200;
TVHT_TORIGHT = 0x0400;
TVHT_TOLEFT = 0x0800;

WHITE_BRUSH = 0;
LTGRAY_BRUSH = 1;
GRAY_BRUSH = 2;
DKGRAY_BRUSH = 3;
BLACK_BRUSH = 4;
NULL_BRUSH = 5;
HOLLOW_BRUSH = NULL_BRUSH;
WHITE_PEN = 6;
BLACK_PEN = 7;
NULL_PEN = 8;
OEM_FIXED_FONT = 10;
ANSI_FIXED_FONT = 11;
ANSI_VAR_FONT = 12;
SYSTEM_FONT = 13;
DEVICE_DEFAULT_FONT = 14;
DEFAULT_PALETTE = 15;
SYSTEM_FIXED_FONT = 16;
DEFAULT_GUI_FONT = 17;
DC_BRUSH = 18;
DC_PEN = 19;

VT_EMPTY = 0;
VT_NULL = 1;
VT_I1 = 16;
VT_I2 = 2;
VT_I4 = 3;
VT_I8 = 20;
VT_UI1 = 17;
VT_UI2 = 18;
VT_UI4 = 19;
VT_UI8 = 21;
VT_R4 = 4;
VT_R8 = 5;
VT_BSTR = 8;
VT_UTF8 = 29;
VT_LPSTR = 30;
VT_LPWSTR = 31;
VT_PTR = 26;
VT_VARIANT = 12;
VT_RECORD = 36;
VT_USERDEFINED = 29;
VT_ARRAY = 0x2000;

FO_MOVE = 1;
FO_COPY = 2;
FO_DELETE = 3;
FO_RENAME = 4;

FOF_MULTIDESTFILES = 1;
FOF_CONFIRMMOUSE = 2;
FOF_SILENT = 4;
FOF_RENAMEONCOLLISION = 8;
FOF_NOCONFIRMATION = 0x10;
FOF_WANTMAPPINGHANDLE = 0x20;
FOF_ALLOWUNDO = 0x40;
FOF_FILESONLY = 0x80;
FOF_SIMPLEPROGRESS = 0x0100;
FOF_NOCONFIRMMKDIR = 0x0200;
FOF_NOERRORUI = 0x0400;
FOF_NOCOPYSECURITYATTRIBS = 0x0800;
FOF_NORECURSION = 0x1000;
FOF_NO_CONNECTED_ELEMENTS = 0x2000;
FOF_WANTNUKEWARNING = 0x4000;
FOF_NORECURSEREPARSE = 0x8000;

SM_CYSCREEN = 1;
SM_CXVSCROLL = 2;
SM_CYHSCROLL = 3;
SM_CYCAPTION = 4;
SM_CXBORDER = 5;
SM_CYBORDER = 6;
SM_CXDLGFRAME = 7;
SM_CYDLGFRAME = 8;
SM_CYVTHUMB = 9;
SM_CXHTHUMB = 10;
SM_CXICON = 11;
SM_CYICON = 12;
SM_CXCURSOR = 13;
SM_CYCURSOR = 14;
SM_CYMENU = 15;
SM_CXFULLSCREEN = 16;
SM_CYFULLSCREEN = 17;
SM_CYKANJIWINDOW = 18;
SM_MOUSEPRESENT = 19;
SM_CYVSCROLL = 20;
SM_CXHSCROLL = 21;
SM_DEBUG = 22;
SM_SWAPBUTTON = 23;
SM_RESERVED1 = 24;
SM_RESERVED2 = 25;
SM_RESERVED3 = 26;
SM_RESERVED4 = 27;
SM_CXMIN = 28;
SM_CYMIN = 29;
SM_CXSIZE = 30;
SM_CYSIZE = 31;
SM_CXFRAME = 32;
SM_CYFRAME = 33;
SM_CXMINTRACK = 34;
SM_CYMINTRACK = 35;
SM_CXDOUBLECLK = 36;
SM_CYDOUBLECLK = 37;
SM_CXICONSPACING = 38;
SM_CYICONSPACING = 39;
SM_MENUDROPALIGNMENT = 40;
SM_PENWINDOWS = 41;
SM_DBCSENABLED = 42;
SM_CMOUSEBUTTONS = 43;
SM_CXFIXEDFRAME = SM_CXDLGFRAME;
SM_CYFIXEDFRAME = SM_CYDLGFRAME;
SM_CXSIZEFRAME = SM_CXFRAME;
SM_CYSIZEFRAME = SM_CYFRAME;
SM_SECURE = 44;
SM_CXEDGE = 45;
SM_CYEDGE = 46;
SM_CXMINSPACING = 47;
SM_CYMINSPACING = 48;
SM_CXSMICON = 49;
SM_CYSMICON = 50;
SM_CYSMCAPTION = 51;
SM_CXSMSIZE = 52;
SM_CYSMSIZE = 53;
SM_CXMENUSIZE = 54;
SM_CYMENUSIZE = 55;
SM_ARRANGE = 56;
SM_CXMINIMIZED = 57;
SM_CYMINIMIZED = 58;
SM_CXMAXTRACK = 59;
SM_CYMAXTRACK = 60;
SM_CXMAXIMIZED = 61;
SM_CYMAXIMIZED = 62;
SM_NETWORK = 63;
SM_CLEANBOOT = 67;
SM_CXDRAG = 68;
SM_CYDRAG = 69;
SM_SHOWSOUNDS = 70;
SM_CXMENUCHECK = 71;
SM_CYMENUCHECK = 72;
SM_SLOWMACHINE = 73;
SM_MIDEASTENABLED = 74;
SM_MOUSEWHEELPRESENT = 75;
SM_XVIRTUALSCREEN = 76;
SM_YVIRTUALSCREEN = 77;
SM_CXVIRTUALSCREEN = 78;
SM_CYVIRTUALSCREEN = 79;
SM_CMONITORS = 80;
SM_SAMEDISPLAYFORMAT = 81;
SM_IMMENABLED = 82;
SM_CXFOCUSBORDER = 83;
SM_CYFOCUSBORDER = 84;
SM_TABLETPC = 86;
SM_MEDIACENTER = 87;
SM_STARTER = 88;
SM_SERVERR2 = 89;
SM_MOUSEHORIZONTALWHEELPRESENT = 91;
SM_CXPADDEDBORDER = 92;
SM_CMETRICS = 93;
SM_REMOTESESSION = 0x1000;
SM_SHUTTINGDOWN = 0x2000;
SM_REMOTECONTROL = 0x2001;
SM_CARETBLINKINGENABLED = 0x2002;

FCIDM_MENU_FILE = 0x8000;
FCIDM_MENU_EDIT = 0x8040;
FCIDM_MENU_VIEW = 0x8080;
FCIDM_MENU_TOOLS = 0x80C0;
FCIDM_MENU_HELP = 0x8100;
FCIDM_MENU_FAVORITES = 0x8170;

GWL_STYLE = -16;
GWL_EXSTYLE = -20;
GWLP_WNDPROC = -4;
GWLP_HINSTANCE = -6;
GWLP_HWNDPARENT = -8;
GWLP_USERDATA = -21;
GWLP_ID = -12;

GCLP_MENUNAME = -8;
GCLP_HBRBACKGROUND = -10;
GCLP_HCURSOR = -12;
GCLP_HICON = -14;
GCLP_HMODULE = -16;
GCLP_WNDPROC = -24;
GCLP_HICONSM = -34;

SPI_GETICONTITLELOGFONT = 0x1F;
SPI_GETNONCLIENTMETRICS = 0x29;

DI_MASK = 1;
DI_IMAGE = 2;
DI_NORMAL = 3;
DI_COMPAT = 4;
DI_DEFAULTSIZE = 8;
DI_NOMIRROR = 0x10;

FILE_SHARE_READ = 1;
FILE_SHARE_WRITE = 2;
FILE_SHARE_DELETE = 4;

FILE_ATTRIBUTE_READONLY = 1;
FILE_ATTRIBUTE_HIDDEN = 2;
FILE_ATTRIBUTE_SYSTEM = 4;
FILE_ATTRIBUTE_DIRECTORY = 0x10;
FILE_ATTRIBUTE_ARCHIVE = 0x20;
FILE_ATTRIBUTE_DEVICE = 0x40;
FILE_ATTRIBUTE_NORMAL = 0x80;
FILE_ATTRIBUTE_TEMPORARY = 0x0100;
FILE_ATTRIBUTE_SPARSE_FILE = 0x0200;
FILE_ATTRIBUTE_REPARSE_POINT = 0x0400;
FILE_ATTRIBUTE_COMPRESSED = 0x0800;
FILE_ATTRIBUTE_OFFLINE = 0x1000;
FILE_ATTRIBUTE_NOT_CONTENT_INDEXED = 0x2000;
FILE_ATTRIBUTE_ENCRYPTED = 0x4000;
FILE_ATTRIBUTE_VIRTUAL = 0x010000;

SHGFI_ICON = 0x0100;
SHGFI_DISPLAYNAME = 0x0200;
SHGFI_TYPENAME = 0x0400;
SHGFI_ATTRIBUTES = 0x0800;
SHGFI_ICONLOCATION = 0x1000;
SHGFI_EXETYPE = 0x2000;
SHGFI_SYSICONINDEX = 0x4000;
SHGFI_LINKOVERLAY = 0x8000;
SHGFI_SELECTED = 0x010000;
SHGFI_ATTR_SPECIFIED = 0x020000;
SHGFI_LARGEICON = 0;
SHGFI_SMALLICON = 1;
SHGFI_OPENICON = 2;
SHGFI_SHELLICONSIZE = 4;
SHGFI_PIDL = 8;
SHGFI_USEFILEATTRIBUTES = 0x10;
SHGFI_ADDOVERLAYS = 0x20;
SHGFI_OVERLAYINDEX = 0x40;

OFN_READONLY = 1;
OFN_OVERWRITEPROMPT = 2;
OFN_HIDEREADONLY = 4;
OFN_NOCHANGEDIR = 8;
OFN_SHOWHELP = 0x10;
OFN_ENABLEHOOK = 0x20;
OFN_ENABLETEMPLATE = 0x40;
OFN_ENABLETEMPLATEHANDLE = 0x80;
OFN_NOVALIDATE = 0x0100;
OFN_ALLOWMULTISELECT = 0x0200;
OFN_EXTENSIONDIFFERENT = 0x0400;
OFN_PATHMUSTEXIST = 0x0800;
OFN_FILEMUSTEXIST = 0x1000;
OFN_CREATEPROMPT = 0x2000;
OFN_SHAREAWARE = 0x4000;
OFN_NOREADONLYRETURN = 0x8000;
OFN_NOTESTFILECREATE = 0x010000;
OFN_NONETWORKBUTTON = 0x020000;
OFN_NOLONGNAMES = 0x040000;
OFN_EXPLORER = 0x080000;
OFN_NODEREFERENCELINKS = 0x100000;
OFN_LONGNAMES = 0x200000;
OFN_ENABLEINCLUDENOTIFY = 0x400000;
OFN_ENABLESIZING = 0x800000;
OFN_DONTADDTORECENT = 0x02000000;
OFN_FORCESHOWHIDDEN = 0x10000000;

DBT_APPYBEGIN = 0;
DBT_APPYEND = 1;
DBT_DEVNODES_CHANGED = 7;
DBT_QUERYCHANGECONFIG = 0x17;
DBT_CONFIGCHANGED = 0x18;
DBT_CONFIGCHANGECANCELED = 0x19;
DBT_MONITORCHANGE = 0x1B;
DBT_SHELLLOGGEDON = 0x20;
DBT_CONFIGMGAPI32 = 0x22;
DBT_VXDINITCOMPLETE = 0x23;
DBT_DEVICEARRIVAL = 0x8000;
DBT_DEVICEQUERYREMOVE = 0x8001;
DBT_DEVICEQUERYREMOVEFAILED = 0x8002;
DBT_DEVICEREMOVEPENDING = 0x8003;
DBT_DEVICEREMOVECOMPLETE = 0x8004;
DBT_DEVICETYPESPECIFIC = 0x8005;
DBT_CUSTOMEVENT = 0x8006;
DBT_VOLLOCKQUERYLOCK = 0x8041;
DBT_VOLLOCKLOCKTAKEN = 0x8042;
DBT_VOLLOCKLOCKFAILED = 0x8043;
DBT_VOLLOCKQUERYUNLOCK = 0x8044;
DBT_VOLLOCKLOCKRELEASED = 0x8045;
DBT_VOLLOCKUNLOCKFAILED = 0x8046;

WS_OVERLAPPED = 0;
WS_POPUP = Ox80000000;
WS_CHILD = 0x40000000;
WS_MINIMIZE = 0x20000000;
WS_VISIBLE = 0x10000000;
WS_DISABLED = 0x08000000;
WS_CLIPSIBLINGS = 0x04000000;
WS_CLIPCHILDREN = 0x02000000;
WS_MAXIMIZE = 0x01000000;
WS_CAPTION = 0xC00000;
WS_BORDER = 0x800000;
WS_DLGFRAME = 0x400000;
WS_VSCROLL = 0x200000;
WS_HSCROLL = 0x100000;
WS_SYSMENU = 0x080000;
WS_THICKFRAME = 0x040000;
WS_GROUP = 0x020000;
WS_TABSTOP = 0x010000;

WS_MINIMIZEBOX = 0x020000;
WS_MAXIMIZEBOX = 0x010000;

SC_SIZE = 0xF000;
SC_MOVE = 0xF010;
SC_MINIMIZE = 0xF020;
SC_MAXIMIZE = 0xF030;
SC_NEXTWINDOW = 0xF040;
SC_PREVWINDOW = 0xF050;
SC_CLOSE = 0xF060;
SC_VSCROLL = 0xF070;
SC_HSCROLL = 0xF080;
SC_MOUSEMENU = 0xF090;
SC_KEYMENU = 0xF100;
SC_ARRANGE = 0xF110;
SC_RESTORE = 0xF120;
SC_TASKLIST = 0xF130;
SC_SCREENSAVE = 0xF140;
SC_HOTKEY = 0xF150;
SC_DEFAULT = 0xF160;
SC_MONITORPOWER = 0xF170;
SC_CONTEXTHELP = 0xF180;
SC_SEPARATOR = 0xF00F;

NIN_SELECT = WM_USER + 0;
NINF_KEY = 1;
NIN_KEYSELECT = NIN_SELECT | NINF_KEY;
NIN_BALLOONSHOW = WM_USER + 2;
NIN_BALLOONHIDE = WM_USER + 3;
NIN_BALLOONTIMEOUT = WM_USER + 4;
NIN_BALLOONUSERCLICK = WM_USER + 5;
NIN_POPUPOPEN = WM_USER + 6;
NIN_POPUPCLOSE = WM_USER + 7;

NIM_ADD = 0;
NIM_MODIFY = 1;
NIM_DELETE = 2;
NIM_SETFOCUS = 3;
NIM_SETVERSION = 4;

NIF_MESSAGE = 1
NIF_ICON = 2
NIF_TIP = 4
NIF_STATE = 8
NIF_INFO = 0x10
NIF_GUID = 0x20
NIF_REALTIME = 0x40
NIF_SHOWTIP = 0x80

OBM_CLOSE = 32754;
OBM_UPARROWI = 32737;
OBM_UPARROW = 32753;
OBM_DNARROWI = 32736;
OBM_DNARROW = 32752;
OBM_RGARROWI = 32735;
OBM_RGARROW = 32751;
OBM_LFARROWI = 32734;
OBM_LFARROW = 32750;
OBM_REDUCE = 32749;
OBM_SIZE = 32766;
OBM_ZOOM = 32748;
OBM_RESTORE = 32747;
OBM_REDUCED = 32746;
OBM_ZOOMD = 32745;
OBM_RESTORED = 32744;
OBM_BTSIZE = 32761;
OBM_UPARROWD = 32743;
OBM_CHECK = 32760;
OBM_DNARROWD = 32742;
OBM_CHECKBOXES = 32759;
OBM_RGARROWD = 32741;
OBM_BTNCORNERS = 32758;
OBM_LFARROWD = 32740;
OBM_MNARROW = 32739;
OBM_COMBO = 32738;

PS_SOLID = 0;
PS_DASH = 1;
PS_DOT = 2;
PS_DASHDOT = 3;
PS_DASHDOTDOT = 4;
PS_NULL = 5;
PS_INSIDEFRAME = 6;

RDW_INVALIDATE = 1;
RDW_INTERNALPAINT = 2;
RDW_ERASE = 4;

RDW_VALIDATE = 8;
RDW_NOINTERNALPAINT = 0x10;
RDW_NOERASE = 0x20;

RDW_NOCHILDREN = 0x40;
RDW_ALLCHILDREN = 0x80;

RDW_UPDATENOW = 0x0100;
RDW_ERASENOW = 0x0200;

RDW_FRAME = 0x0400;
RDW_NOFRAME = 0x0800;

SEE_MASK_ICON = 0x10;
SEE_MASK_HOTKEY = 0x20;
SEE_MASK_NOCLOSEPROCESS = 0x40;
SEE_MASK_CONNECTNETDRV = 0x80;
SEE_MASK_NOASYNC = 0x0100;
SEE_MASK_DOENVSUBST = 0x0200;
SEE_MASK_FLAG_NO_UI = 0x0400;
SEE_MASK_UNICODE = 0x4000;
SEE_MASK_NO_CONSOLE = 0x8000;
SEE_MASK_ASYNCOK = 0x100000;

CMIC_MASK_HOTKEY = SEE_MASK_HOTKEY;
CMIC_MASK_ICON = SEE_MASK_ICON;
CMIC_MASK_FLAG_NO_UI = SEE_MASK_FLAG_NO_UI;
CMIC_MASK_UNICODE = SEE_MASK_UNICODE;
CMIC_MASK_NO_CONSOLE = SEE_MASK_NO_CONSOLE;

CC_RGBINIT = 1;
CC_FULLOPEN = 2;
CC_PREVENTFULLOPEN = 4;
CC_SHOWHELP = 8;
CC_ENABLEHOOK = 0x10;
CC_ENABLETEMPLATE = 0x20;
CC_ENABLETEMPLATEHANDLE = 0x40;
CC_SOLIDCOLOR = 0x80;
CC_ANYCOLOR = 0x0100;

CDB2GVF_SHOWALLFILES = 1;
CDB2GVF_NOSELECTVERB = 8;

CONTEXT_MENU_DEFAULT = 0;
CONTEXT_MENU_IMAGE = 1;
CONTEXT_MENU_CONTROL = 2;
CONTEXT_MENU_TABLE = 3;
CONTEXT_MENU_TEXTSELECT = 4;
CONTEXT_MENU_ANCHOR = 5;
CONTEXT_MENU_UNKNOWN = 6;
CONTEXT_MENU_IMGDYNSRC = 7;
CONTEXT_MENU_IMGART = 8;
CONTEXT_MENU_DEBUG = 9;
CONTEXT_MENU_VSCROLL = 10;
CONTEXT_MENU_HSCROLL = 11;

MIIM_STATE = 1;
MIIM_ID = 2;
MIIM_SUBMENU = 4;
MIIM_CHECKMARKS = 8;
MIIM_TYPE = 0x10;
MIIM_DATA = 0x20;
MIIM_STRING = 0x40;
MIIM_BITMAP = 0x80;
MIIM_FTYPE = 0x0100;

HBMMENU_CALLBACK = -1;
HBMMENU_SYSTEM = 1;
HBMMENU_MBAR_RESTORE = 2;
HBMMENU_MBAR_MINIMIZE = 3;
HBMMENU_MBAR_CLOSE = 5;
HBMMENU_MBAR_CLOSE_D = 6;
HBMMENU_MBAR_MINIMIZE_D = 7;
HBMMENU_POPUP_CLOSE = 8;
HBMMENU_POPUP_RESTORE = 9;
HBMMENU_POPUP_MAXIMIZE = 10;
HBMMENU_POPUP_MINIMIZE = 11;

CommandID_EXIT = 3;
CommandID_LINK = 17;
CommandID_DELETE = 18;
CommandID_RENAME = 19;
CommandID_PROPERTIES = 20;
CommandID_CUT = 25;
CommandID_COPY = 26;
CommandID_PASTE = 27;
CommandID_STORE = 28;

ICON_SMALL = 0;
ICON_BIG = 1;
ICON_SMALL2 = 2;

adTypeBinary = 1;
adTypeText = 2;
adLF = 10;
adCR = 13;
adCRLF = -1;
adWriteChar = 0;
adWriteLine = 1;
adSaveCreateNotExist = 1;
adSaveCreateOverWrite = 2;
adReadAll = -1;
adReadLine = -2;

MB_OK = 0;
MB_OKCANCEL = 1;
MB_ABORTRETRYIGNORE = 2;
MB_YESNOCANCEL = 3;
MB_YESNO = 4;
MB_RETRYCANCEL = 5;
MB_CANCELTRYCONTINUE = 6;

MB_ICONSTOP = 0x10;
MB_ICONQUESTION = 0x20;
MB_ICONEXCLAMATION = 0x30;
MB_ICONINFORMATION = 0x40;
MB_USERICON = 0x80;

MB_DEFBUTTON1 = 0;
MB_DEFBUTTON2 = 0x0100;
MB_DEFBUTTON3 = 0x0200;
MB_DEFBUTTON4 = 0x0300;

MB_APPLMODAL = 0;
MB_SYSTEMMODAL = 0x1000;
MB_TASKMODAL = 0x2000;
MB_NOFOCUS = 0x8000;
MB_SETFOREGROUND = 0x010000;
MB_DEFAULT_DESKTOP_ONLY = 0x020000;
MB_TOPMOST = 0x040000;
MB_RIGHT = 0x080000;
MB_RTLREADING = 0x100000;

IDOK = 1;
IDCANCEL = 2;
IDABORT = 3;
IDRETRY = 4;
IDIGNORE = 5;
IDYES = 6;
IDNO = 7;
IDCLOSE = 8;
IDHELP = 9;
IDTRYAGAIN = 10;
IDCONTINUE = 11;

GW_HWNDFIRST = 0;
GW_HWNDLAST = 1;
GW_HWNDNEXT = 2;
GW_HWNDPREV = 3;
GW_OWNER = 4;
GW_CHILD = 5;
GW_ENABLEDPOPUP = 6;

SYNCHRONIZE = 0x100000;
STANDARD_RIGHTS_REQUIRED = 0x0F0000;

PROCESS_TERMINATE = 1;
PROCESS_CREATE_THREAD = 2;
PROCESS_SET_SESSIONID = 4;
PROCESS_VM_OPERATION = 8;
PROCESS_VM_READ = 0x10;
PROCESS_VM_WRITE = 0x20;
PROCESS_DUP_HANDLE = 0x40;
PROCESS_CREATE_PROCESS = 0x80;
PROCESS_SET_QUOTA = 0x0100;
PROCESS_SET_INFORMATION = 0x0200;
PROCESS_QUERY_INFORMATION = 0x0400;
PROCESS_SUSPEND_RESUME = 0x0800;
PROCESS_QUERY_LIMITED_INFORMATION = 0x1000;
PROCESS_ALL_ACCESS = STANDARD_RIGHTS_REQUIRED | SYNCHRONIZE | 0xFFFF;

MOUSEEVENTF_MOVE = 1;
MOUSEEVENTF_LEFTDOWN = 2;
MOUSEEVENTF_LEFTUP = 4;
MOUSEEVENTF_RIGHTDOWN = 8;
MOUSEEVENTF_RIGHTUP = 0x10;
MOUSEEVENTF_MIDDLEDOWN = 0x20;
MOUSEEVENTF_MIDDLEUP = 0x40;
MOUSEEVENTF_XDOWN = 0x80;
MOUSEEVENTF_XUP = 0x0100;
MOUSEEVENTF_WHEEL = 0x0800;
MOUSEEVENTF_HWHEEL = 0x1000;
MOUSEEVENTF_MOVE_NOCOALESCE = 0x2000;
MOUSEEVENTF_VIRTUALDESK = 0x4000;
MOUSEEVENTF_ABSOLUTE = 0x8000;

INFINITE = 0xFFFFFFFF;

WAIT_OBJECT_0 = 0;
WAIT_ABANDONED = 0x80;
WAIT_TIMEOUT = 0x0102;

QS_KEY = 1;
QS_MOUSEMOVE = 2;
QS_MOUSEBUTTON = 4;
QS_POSTMESSAGE = 8;
QS_TIMER = 0x10;
QS_PAINT = 0x20;
QS_SENDMESSAGE = 0x40;
QS_HOTKEY = 0x80;
QS_ALLPOSTMESSAGE = 0x0100;
QS_RAWINPUT = 0x0400;
QS_MOUSE = QS_MOUSEMOVE | QS_MOUSEBUTTON;
QS_INPUT = QS_MOUSE | QS_KEY | QS_RAWINPUT;
QS_ALLEVENTS = QS_INPUT | QS_POSTMESSAGE | QS_TIMER | QS_PAINT | QS_HOTKEY;
QS_ALLINPUT = QS_INPUT | QS_POSTMESSAGE | QS_TIMER | QS_PAINT | QS_HOTKEY | QS_SENDMESSAGE;

PM_NOREMOVE = 0;
PM_REMOVE = 1;
PM_NOYIELD = 2;
PM_QS_INPUT = QS_INPUT << 16;
PM_QS_POSTMESSAGE = (QS_POSTMESSAGE | QS_HOTKEY | QS_TIMER) << 16;
PM_QS_PAINT = QS_PAINT << 16;
PM_QS_SENDMESSAGE = QS_SENDMESSAGE << 16;

MNC_IGNORE = 0;
MNC_CLOSE = 1;
MNC_EXECUTE = 2;
MNC_SELECT = 3;

SFGAO_CANCOPY = DROPEFFECT_COPY;
SFGAO_CANMOVE = DROPEFFECT_MOVE;
SFGAO_CANLINK = DROPEFFECT_LINK;
SFGAO_STORAGE = 8;
SFGAO_CANRENAME = 0x10;
SFGAO_CANDELETE = 0x20;
SFGAO_HASPROPSHEET = 0x40;
SFGAO_DROPTARGET = 0x0100;
SFGAO_CAPABILITYMASK = 0x0177;
SFGAO_SYSTEM = 0x1000;
SFGAO_ENCRYPTED = 0x2000;
SFGAO_ISSLOW = 0x4000;
SFGAO_GHOSTED = 0x8000;
SFGAO_LINK = 0x010000;
SFGAO_SHARE = 0x020000;
SFGAO_READONLY = 0x040000;
SFGAO_HIDDEN = 0x080000;
SFGAO_DISPLAYATTRMASK = 0x0FC000;
SFGAO_FILESYSANCESTOR = 0x10000000;
SFGAO_FOLDER = 0x20000000;
SFGAO_FILESYSTEM = 0x40000000;
SFGAO_HASSUBFOLDER = Ox80000000;
SFGAO_CONTENTSMASK = Ox80000000;
SFGAO_VALIDATE = 0x01000000;
SFGAO_REMOVABLE = 0x02000000;
SFGAO_COMPRESSED = 0x04000000;
SFGAO_BROWSABLE = 0x08000000;
SFGAO_NONENUMERATED = 0x100000;
SFGAO_NEWCONTENT = 0x200000;
SFGAO_CANMONIKER = 0x400000;
SFGAO_HASSTORAGE = 0x400000;
SFGAO_STREAM = 0x400000;
SFGAO_STORAGEANCESTOR = 0x800000;
SFGAO_STORAGECAPMASK = 0x70C50008;
SFGAO_PKEYSFGAOMASK = 0x81044000 | 0;

GCS_VERB = 4;
GCS_HELPTEXT = 5;
GCS_VALIDATE = 6;
GCS_VERBICON = 0x14;

HKEY_CLASSES_ROOT = Ox80000000;
HKEY_CURRENT_USER = 0x80000001 | 0;
HKEY_LOCAL_MACHINE = 0x80000002 | 0;
HKEY_USERS = 0x80000003 | 0;
HKEY_PERFORMANCE_DATA = 0x80000004 | 0;
HKEY_PERFORMANCE_TEXT = 0x80000050 | 0;
HKEY_PERFORMANCE_NLSTEXT = 0x80000060 | 0;
HKEY_CURRENT_CONFIG = 0x80000005 | 0;
HKEY_CURRENT_USER_LOCAL_SETTINGS = 0x80000007 | 0;

SHERB_NOCONFIRMATION = 1;
SHERB_NOPROGRESSUI = 2;
SHERB_NOSOUND = 4;

KEYEVENTF_EXTENDEDKEY = 1;
KEYEVENTF_KEYUP = 2;
KEYEVENTF_UNICODE = 4;
KEYEVENTF_SCANCODE = 8;

ASSOCF_NONE = 0;
ASSOCF_INIT_NOREMAPCLSID = 1;
ASSOCF_INIT_BYEXENAME = 2;
ASSOCF_OPEN_BYEXENAME = 2;
ASSOCF_INIT_DEFAULTTOSTAR = 4;
ASSOCF_INIT_DEFAULTTOFOLDER = 8;
ASSOCF_NOUSERSETTINGS = 0x10;
ASSOCF_NOTRUNCATE = 0x20;
ASSOCF_VERIFY = 0x40;
ASSOCF_REMAPRUNDLL = 0x80;
ASSOCF_NOFIXUPS = 0x0100;
ASSOCF_IGNOREBASECLASS = 0x0200;
ASSOCF_INIT_IGNOREUNKNOWN = 0x0400;
ASSOCF_INIT_FIXED_PROGID = 0x0800;
ASSOCF_IS_PROTOCOL = 0x1000;
ASSOCF_INIT_FOR_FILE = 0x2000;

ASSOCSTR_COMMAND = 1;
ASSOCSTR_EXECUTABLE = 2;
ASSOCSTR_FRIENDLYDOCNAME = 3;
ASSOCSTR_FRIENDLYAPPNAME = 4;
ASSOCSTR_NOOPEN = 5;
ASSOCSTR_SHELLNEWVALUE = 6;
ASSOCSTR_DDECOMMAND = 7;
ASSOCSTR_DDEIFEXEC = 8;
ASSOCSTR_DDEAPPLICATION = 9;
ASSOCSTR_DDETOPIC = 10;
ASSOCSTR_INFOTIP = 11;
ASSOCSTR_QUICKTIP = 12;
ASSOCSTR_TILEINFO = 13;
ASSOCSTR_CONTENTTYPE = 14;
ASSOCSTR_DEFAULTICON = 15;
ASSOCSTR_SHELLEXTENSION = 16;
ASSOCSTR_DROPTARGET = 17;
ASSOCSTR_DELEGATEEXECUTE = 18;
ASSOCSTR_SUPPORTED_URI_PROTOCOLS = 19;

SHIL_LARGE = 0;
SHIL_SMALL = 1;
SHIL_EXTRALARGE = 2;
SHIL_SYSSMALL = 3;
SHIL_JUMBO = 4;

SHCNRF_InterruptLevel = 1;
SHCNRF_ShellLevel = 2;
SHCNRF_RecursiveInterrupt = 0x1000;
SHCNRF_NewDelivery = 0x8000;

SHCNE_RENAMEITEM = 1;
SHCNE_CREATE = 2;
SHCNE_DELETE = 4;
SHCNE_MKDIR = 8;
SHCNE_RMDIR = 0x10;
SHCNE_MEDIAINSERTED = 0x20;
SHCNE_MEDIAREMOVED = 0x40;
SHCNE_DRIVEREMOVED = 0x80;
SHCNE_DRIVEADD = 0x0100;
SHCNE_NETSHARE = 0x0200;
SHCNE_NETUNSHARE = 0x0400;
SHCNE_ATTRIBUTES = 0x0800;
SHCNE_UPDATEDIR = 0x1000;
SHCNE_UPDATEITEM = 0x2000;
SHCNE_SERVERDISCONNECT = 0x4000;
SHCNE_UPDATEIMAGE = 0x8000;
SHCNE_DRIVEADDGUI = 0x010000;
SHCNE_RENAMEFOLDER = 0x020000;
SHCNE_FREESPACE = 0x040000;
SHCNE_EXTENDED_EVENT = 0x04000000;
SHCNE_ASSOCCHANGED = 0x08000000;
SHCNE_DISKEVENTS = 0x02381F;
SHCNE_GLOBALEVENTS = 0x0C0581E0;
SHCNE_ALLEVENTS = 0x7FFFFFFF;
SHCNE_INTERRUPT = Ox80000000;

SHCNF_IDLIST = 0;
SHCNF_DWORD = 3;
SHCNF_PATH = 5;
SHCNF_PRINTER = 6;
SHCNF_TYPE = 0xFF;
SHCNF_FLUSH = 0x1000;
SHCNF_FLUSHNOWAIT = 0x3000;

SRCCOPY = 0xCC0020;
SRCPAINT = 0xEE0086;
SRCAND = 0x8800C6;
SRCINVERT = 0x660046;
SRCERASE = 0x440328;
NOTSRCCOPY = 0x330008;
NOTSRCERASE = 0x1100A6;
MERGECOPY = 0xC000CA;
MERGEPAINT = 0xBB0226;
PATCOPY = 0xF00021;
PATPAINT = 0xFB0A09;
PATINVERT = 0x5A0049;
DSTINVERT = 0x550009;
BLACKNESS = 0x42;
WHITENESS = 0xFF0062;
NOMIRRORBITMAP = Ox80000000;
CAPTUREBLT = 0x40000000;

ODS_SELECTED = 1;
ODS_GRAYED = 2;
ODS_DISABLED = 4;
ODS_CHECKED = 8;
ODS_FOCUS = 0x10;
ODS_DEFAULT = 0x20;
ODS_COMBOBOXEDIT = 0x1000;
ODS_HOTLIGHT = 0x40;
ODS_INACTIVE = 0x80;
ODS_NOACCEL = 0x0100;
ODS_NOFOCUSRECT = 0x0200;

MNS_NOCHECK = Ox80000000;
MNS_MODELESS = 0x40000000;
MNS_DRAGDROP = 0x20000000;
MNS_AUTODISMISS = 0x10000000;
MNS_NOTIFYBYPOS = 0x08000000;
MNS_CHECKORBMP = 0x04000000;

MIM_MAXHEIGHT = 1;
MIM_BACKGROUND = 2;
MIM_HELPID = 4;
MIM_MENUDATA = 8;
MIM_STYLE = 0x10;
MIM_APPLYTOSUBMENUS = Ox80000000;

SVGIO_BACKGROUND = 0;
SVGIO_SELECTION = 1;
SVGIO_ALLVIEW = 2;
SVGIO_CHECKED = 3;
SVGIO_TYPE_MASK = 0xf;
SVGIO_FLAG_VIEWORDER = Ox80000000;

ASFW_ANY = -1;

SWP_NOSIZE = 1;
SWP_NOMOVE = 2;
SWP_NOZORDER = 4;
SWP_NOREDRAW = 8;
SWP_NOACTIVATE = 0x10;
SWP_FRAMECHANGED = 0x20;
SWP_SHOWWINDOW = 0x40;
SWP_HIDEWINDOW = 0x80;
SWP_NOCOPYBITS = 0x100;
SWP_NOOWNERZORDER = 0x200;
SWP_NOSENDCHANGING = 0x400;
SWP_DEFERERASE = 0x2000;
SWP_ASYNCWINDOWPOS = 0x4000;

HWND_TOP = 0;
HWND_BOTTOM = 1;
HWND_TOPMOST = -1;
HWND_NOTOPMOST = -2;

LOCALE_SYSTEM_DEFAULT = 2048;
LOCALE_USER_DEFAULT = 1024;
LOCALE_NOUSEROVERRIDE = Ox80000000;
LOCALE_USE_CP_ACP = 0x40000000;
LOCALE_SSHORTDATE = 0x1F;
LOCALE_SLONGDATE = 0x20;
LOCALE_STIMEFORMAT = 0x1003;

TIME_NOMINUTESORSECONDS = 1;
TIME_NOSECONDS = 2;
TIME_NOTIMEMARKER = 4;
TIME_FORCE24HOURFORMAT = 8;

DATE_SHORTDATE = 1;
DATE_LONGDATE = 2;
DATE_USE_ALT_CALENDAR = 4;
DATE_YEARMONTH = 8;
DATE_LTRREADING = 0x10;
DATE_RTLREADING = 0x20;
DATE_AUTOLAYOUT = 0x40;

MONITOR_DEFAULTTONULL = 0;
MONITOR_DEFAULTTOPRIMARY = 1;
MONITOR_DEFAULTTONEAREST = 2;

PDFF_DEFAULT = 0;
PDFF_PREFIXNAME = 1;
PDFF_FILENAME = 2;
PDFF_ALWAYSKB = 4;
PDFF_RESERVED_RIGHTTOLEFT = 8;
PDFF_SHORTTIME = 0x10;
PDFF_LONGTIME = 0x20;
PDFF_HIDETIME = 0x40;
PDFF_SHORTDATE = 0x80;
PDFF_LONGDATE = 0x100;
PDFF_HIDEDATE = 0x200;
PDFF_RELATIVEDATE = 0x400;
PDFF_USEEDITINVITATION = 0x800;
PDFF_READONLY = 0x1000;
PDFF_NOAUTOREADINGORDER = 0x2000;

MOD_ALT = 1;
MOD_CONTROL = 2;
MOD_SHIFT = 4;
MOD_WIN = 8;
MOD_NOREPEAT = 0x4000;

CDIS_SELECTED = 1;
CDIS_GRAYED = 2;
CDIS_DISABLED = 4;
CDIS_CHECKED = 8;
CDIS_FOCUS = 0x10;
CDIS_DEFAULT = 0x20;
CDIS_HOT = 0x40;
CDIS_MARKED = 0x80;
CDIS_INDETERMINATE = 0x0100;
CDIS_SHOWKEYBOARDCUES = 0x0200;
CDIS_NEARHOT = 0x0400;
CDIS_OTHERSIDEHOT = 0x0800;
CDIS_DROPHILITED = 0x1000;

DT_TOP = 0;
DT_LEFT = 0;
DT_CENTER = 1;
DT_RIGHT = 2;
DT_VCENTER = 4;
DT_BOTTOM = 8;
DT_WORDBREAK = 0x10;
DT_SINGLELINE = 0x20;
DT_EXPANDTABS = 0x40;
DT_TABSTOP = 0x80;
DT_NOCLIP = 0x0100;
DT_EXTERNALLEADING = 0x0200;
DT_CALCRECT = 0x0400;
DT_NOPREFIX = 0x0800;
DT_INTERNAL = 0x1000;
DT_EDITCONTROL = 0x2000;
DT_PATH_ELLIPSIS = 0x4000;
DT_END_ELLIPSIS = 0x8000;
DT_MODIFYSTRING = 0x010000;
DT_RTLREADING = 0x020000;
DT_WORD_ELLIPSIS = 0x040000;
DT_NOFULLWIDTHCHARBREAK = 0x080000;
DT_HIDEPREFIX = 0x100000;
DT_PREFIXONLY = 0x200000;

PBT_APMRESUMEAUTOMATIC = 0x12;
PBT_POWERSETTINGCHANGE = 0x8013;

MOVEFILE_REPLACE_EXISTING = 1;
MOVEFILE_COPY_ALLOWED = 2;
MOVEFILE_DELAY_UNTIL_REBOOT = 4;
MOVEFILE_WRITE_THROUGH = 8;
MOVEFILE_CREATE_HARDLINK = 0x10;
MOVEFILE_FAIL_IF_NOT_TRACKABLE = 0x20;

STGM_DIRECT = 0;
STGM_TRANSACTED = 0x010000;
STGM_SIMPLE = 0x08000000;
STGM_READ = 0;
STGM_WRITE = 1;
STGM_READWRITE = 2;
STGM_SHARE_DENY_NONE = 0x40;
STGM_SHARE_DENY_READ = 0x30;
STGM_SHARE_DENY_WRITE = 0x20;
STGM_SHARE_EXCLUSIVE = 0x10;
STGM_PRIORITY = 0x040000;
STGM_DELETEONRELEASE = 0x04000000;
STGM_NOSCRATCH = 0x100000;
STGM_CREATE = 0x1000;
STGM_CONVERT = 0x020000;
STGM_FAILIFTHERE = 0;
STGM_NOSNAPSHOT = 0x200000;
STGM_DIRECT_SWMR = 0x400000;

if (!window.chrome || !window.alert) {
	if (!window.te) {
		te = external;
	}
	api = te.WindowsAPI0.CreateObject("api");
	fso = api.CreateObject("fso");
	sha = api.CreateObject("sha");
	wsh = api.CreateObject("wsh");
	wnw = api.CreateObject("WScript.Network");
	WebBrowser = te.Ctrl(CTRL_WB);
	system32 = api.GetDisplayNameOf(ssfSYSTEM, SHGDN_FORPARSING);
	hShell32 = api.GetModuleHandle(BuildPath(system32, "shell32.dll"));
	osInfo = api.Memory("OSVERSIONINFOEX");
	osInfo.dwOSVersionInfoSize = osInfo.Size;
	api.GetVersionEx(osInfo);
	WINVER = osInfo.dwMajorVersion * 0x100 + osInfo.dwMinorVersion;
}
$ = window;
