/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.lwjgl3.awt;

import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.SharedLibraryLoader;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.Random;
import java.util.UUID;
import java.util.zip.CRC32;

public class GlfwAWTLoader {
    public static boolean isMac = System.getProperty("os.name").contains("Mac");
    private static final Random random = new Random();

    public static void closeQuietly(Closeable c) {
        if (c != null) {
            try {
                c.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    static String randomUUID() {
        return new UUID(random.nextLong(), random.nextLong()).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String crc(InputStream input2) {
        if (input2 == null) {
            throw new IllegalArgumentException("input cannot be null.");
        }
        CRC32 crc = new CRC32();
        byte[] buffer = new byte[4096];
        try {
            int length;
            while ((length = input2.read(buffer)) != -1) {
                crc.update(buffer, 0, length);
            }
        }
        catch (Exception exception2) {
        }
        finally {
            GlfwAWTLoader.closeQuietly(input2);
        }
        return Long.toString(crc.getValue(), 16);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File extractFile(String sourcePath, File outFile) {
        File file;
        if (!outFile.getParentFile().exists() && !outFile.getParentFile().mkdirs()) {
            throw new GdxRuntimeException("Couldn't create ANGLE native library output directory " + outFile.getParentFile().getAbsolutePath());
        }
        FileOutputStream out2 = null;
        InputStream in = null;
        try {
            int length;
            out2 = new FileOutputStream(outFile);
            in = GlfwAWTLoader.class.getResourceAsStream("/" + sourcePath);
            byte[] buffer = new byte[4096];
            while ((length = in.read(buffer)) != -1) {
                ((OutputStream)out2).write(buffer, 0, length);
            }
            file = outFile;
        }
        catch (Throwable throwable) {
            try {
                GlfwAWTLoader.closeQuietly(out2);
                GlfwAWTLoader.closeQuietly(in);
                throw throwable;
            }
            catch (Throwable t) {
                throw new GdxRuntimeException("Couldn't load ANGLE shared library " + sourcePath, t);
            }
        }
        GlfwAWTLoader.closeQuietly(out2);
        GlfwAWTLoader.closeQuietly(in);
        return file;
    }

    private static File getExtractedFile(String dirName, String fileName) {
        File file2;
        File idealFile = new File(System.getProperty("java.io.tmpdir") + "/libgdx" + System.getProperty("user.name") + "/" + dirName, fileName);
        if (GlfwAWTLoader.canWrite(idealFile)) {
            return idealFile;
        }
        try {
            file2 = File.createTempFile(dirName, null);
            if (file2.delete() && GlfwAWTLoader.canWrite(file2 = new File(file2, fileName))) {
                return file2;
            }
        }
        catch (IOException file2) {
            // empty catch block
        }
        file2 = new File(System.getProperty("user.home") + "/.libgdx/" + dirName, fileName);
        if (GlfwAWTLoader.canWrite(file2)) {
            return file2;
        }
        file2 = new File(".temp/" + dirName, fileName);
        if (GlfwAWTLoader.canWrite(file2)) {
            return file2;
        }
        if (System.getenv("APP_SANDBOX_CONTAINER_ID") != null) {
            return idealFile;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean canWrite(File file) {
        File testFile;
        File parent = file.getParentFile();
        if (file.exists()) {
            if (!file.canWrite() || !GlfwAWTLoader.canExecute(file)) {
                return false;
            }
            testFile = new File(parent, GlfwAWTLoader.randomUUID().toString());
        } else {
            parent.mkdirs();
            if (!parent.isDirectory()) {
                return false;
            }
            testFile = file;
        }
        try {
            new FileOutputStream(testFile).close();
            if (!GlfwAWTLoader.canExecute(testFile)) {
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        catch (Throwable ex) {
            boolean bl = false;
            return bl;
        }
        finally {
            testFile.delete();
        }
    }

    private static boolean canExecute(File file) {
        try {
            Method canExecute = File.class.getMethod("canExecute", new Class[0]);
            if (((Boolean)canExecute.invoke((Object)file, new Object[0])).booleanValue()) {
                return true;
            }
            Method setExecutable = File.class.getMethod("setExecutable", Boolean.TYPE, Boolean.TYPE);
            setExecutable.invoke((Object)file, true, false);
            return (Boolean)canExecute.invoke((Object)file, new Object[0]);
        }
        catch (Exception exception2) {
            return false;
        }
    }

    public static File load() {
        if (!isMac) {
            return null;
        }
        if (!EventQueue.isDispatchThread()) {
            try {
                EventQueue.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        Toolkit.getDefaultToolkit();
                    }
                });
            }
            catch (Throwable t) {
                throw new GdxRuntimeException("Couldn't initialize AWT.", t);
            }
        }
        String source = SharedLibraryLoader.isARM ? "macosarm64/libglfwarm64.dylib" : "macosx64/libglfw.dylib";
        String crc = GlfwAWTLoader.crc(GlfwAWTLoader.class.getResourceAsStream("/" + source));
        File sharedLib = GlfwAWTLoader.getExtractedFile(crc, new File(source).getName());
        GlfwAWTLoader.extractFile(source, sharedLib);
        return sharedLib;
    }
}

