/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.maps.tiled;

import com.badlogic.gdx.assets.AssetDescriptor;
import com.badlogic.gdx.assets.AssetManager;
import com.badlogic.gdx.assets.loaders.FileHandleResolver;
import com.badlogic.gdx.assets.loaders.TextureLoader;
import com.badlogic.gdx.assets.loaders.resolvers.InternalFileHandleResolver;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.maps.ImageResolver;
import com.badlogic.gdx.maps.MapProperties;
import com.badlogic.gdx.maps.tiled.BaseTmxMapLoader;
import com.badlogic.gdx.maps.tiled.TiledMap;
import com.badlogic.gdx.maps.tiled.TiledMapTileSet;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.ObjectMap;
import com.badlogic.gdx.utils.XmlReader;

public class TmxMapLoader
extends BaseTmxMapLoader<Parameters> {
    public TmxMapLoader() {
        super(new InternalFileHandleResolver());
    }

    public TmxMapLoader(FileHandleResolver resolver) {
        super(resolver);
    }

    public TiledMap load(String fileName) {
        return this.load(fileName, new Parameters());
    }

    public TiledMap load(String fileName, Parameters parameter) {
        FileHandle tmxFile = this.resolve(fileName);
        this.root = this.xml.parse(tmxFile);
        ObjectMap<String, Texture> textures = new ObjectMap<String, Texture>();
        Array<FileHandle> textureFiles = this.getDependencyFileHandles(tmxFile);
        for (FileHandle textureFile : textureFiles) {
            Texture texture = new Texture(textureFile, parameter.generateMipMaps);
            texture.setFilter(parameter.textureMinFilter, parameter.textureMagFilter);
            textures.put(textureFile.path(), texture);
        }
        TiledMap map2 = this.loadTiledMap(tmxFile, parameter, new ImageResolver.DirectImageResolver(textures));
        map2.setOwnedResources(textures.values().toArray());
        return map2;
    }

    @Override
    public void loadAsync(AssetManager manager, String fileName, FileHandle tmxFile, Parameters parameter) {
        this.map = this.loadTiledMap(tmxFile, parameter, new ImageResolver.AssetManagerImageResolver(manager));
    }

    @Override
    public TiledMap loadSync(AssetManager manager, String fileName, FileHandle file, Parameters parameter) {
        return this.map;
    }

    @Override
    protected Array<AssetDescriptor> getDependencyAssetDescriptors(FileHandle tmxFile, TextureLoader.TextureParameter textureParameter) {
        Array<AssetDescriptor> descriptors = new Array<AssetDescriptor>();
        Array<FileHandle> fileHandles2 = this.getDependencyFileHandles(tmxFile);
        for (FileHandle handle2 : fileHandles2) {
            descriptors.add(new AssetDescriptor<Texture>(handle2, Texture.class, textureParameter));
        }
        return descriptors;
    }

    protected Array<FileHandle> getDependencyFileHandles(FileHandle tmxFile) {
        Array<FileHandle> fileHandles2 = new Array<FileHandle>();
        for (XmlReader.Element tileset : this.root.getChildrenByName("tileset")) {
            String source = tileset.getAttribute("source", null);
            if (source != null) {
                FileHandle tsxFile = TmxMapLoader.getRelativeFileHandle(tmxFile, source);
                tileset = this.xml.parse(tsxFile);
                XmlReader.Element imageElement = tileset.getChildByName("image");
                if (imageElement != null) {
                    String imageSource = tileset.getChildByName("image").getAttribute("source");
                    FileHandle image2 = TmxMapLoader.getRelativeFileHandle(tsxFile, imageSource);
                    fileHandles2.add(image2);
                    continue;
                }
                for (XmlReader.Element tile : tileset.getChildrenByName("tile")) {
                    String imageSource = tile.getChildByName("image").getAttribute("source");
                    FileHandle image3 = TmxMapLoader.getRelativeFileHandle(tsxFile, imageSource);
                    fileHandles2.add(image3);
                }
                continue;
            }
            XmlReader.Element imageElement = tileset.getChildByName("image");
            if (imageElement != null) {
                String imageSource = tileset.getChildByName("image").getAttribute("source");
                FileHandle image4 = TmxMapLoader.getRelativeFileHandle(tmxFile, imageSource);
                fileHandles2.add(image4);
                continue;
            }
            for (XmlReader.Element tile : tileset.getChildrenByName("tile")) {
                String imageSource = tile.getChildByName("image").getAttribute("source");
                FileHandle image5 = TmxMapLoader.getRelativeFileHandle(tmxFile, imageSource);
                fileHandles2.add(image5);
            }
        }
        for (XmlReader.Element imageLayer : this.root.getChildrenByName("imagelayer")) {
            XmlReader.Element image6 = imageLayer.getChildByName("image");
            String source = image6.getAttribute("source", null);
            if (source == null) continue;
            FileHandle handle2 = TmxMapLoader.getRelativeFileHandle(tmxFile, source);
            fileHandles2.add(handle2);
        }
        return fileHandles2;
    }

    @Override
    protected void addStaticTiles(FileHandle tmxFile, ImageResolver imageResolver, TiledMapTileSet tileSet, XmlReader.Element element, Array<XmlReader.Element> tileElements, String name2, int firstgid, int tilewidth, int tileheight, int spacing, int margin, String source, int offsetX, int offsetY, String imageSource, int imageWidth, int imageHeight, FileHandle image2) {
        MapProperties props = tileSet.getProperties();
        if (image2 != null) {
            TextureRegion texture = imageResolver.getImage(image2.path());
            props.put("imagesource", imageSource);
            props.put("imagewidth", imageWidth);
            props.put("imageheight", imageHeight);
            props.put("tilewidth", tilewidth);
            props.put("tileheight", tileheight);
            props.put("margin", margin);
            props.put("spacing", spacing);
            int stopWidth = texture.getRegionWidth() - tilewidth;
            int stopHeight = texture.getRegionHeight() - tileheight;
            int id = firstgid;
            for (int y = margin; y <= stopHeight; y += tileheight + spacing) {
                for (int x = margin; x <= stopWidth; x += tilewidth + spacing) {
                    TextureRegion tileRegion = new TextureRegion(texture, x, y, tilewidth, tileheight);
                    int tileId = id++;
                    this.addStaticTiledMapTile(tileSet, tileRegion, tileId, offsetX, offsetY);
                }
            }
        } else {
            for (XmlReader.Element tileElement : tileElements) {
                XmlReader.Element imageElement = tileElement.getChildByName("image");
                if (imageElement != null) {
                    imageSource = imageElement.getAttribute("source");
                    image2 = source != null ? TmxMapLoader.getRelativeFileHandle(TmxMapLoader.getRelativeFileHandle(tmxFile, source), imageSource) : TmxMapLoader.getRelativeFileHandle(tmxFile, imageSource);
                }
                TextureRegion texture = imageResolver.getImage(image2.path());
                int tileId = firstgid + tileElement.getIntAttribute("id");
                this.addStaticTiledMapTile(tileSet, texture, tileId, offsetX, offsetY);
            }
        }
    }

    public static class Parameters
    extends BaseTmxMapLoader.Parameters {
    }
}

