/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.net;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;
import java.util.Set;

public final class HttpParametersUtils {
    public static String defaultEncoding = "UTF-8";
    public static String nameValueSeparator = "=";
    public static String parameterSeparator = "&";

    private HttpParametersUtils() {
    }

    public static String convertHttpParameters(Map<String, String> parameters2) {
        Set<String> keySet = parameters2.keySet();
        StringBuilder convertedParameters = new StringBuilder();
        for (String name2 : keySet) {
            convertedParameters.append(HttpParametersUtils.encode(name2, defaultEncoding));
            convertedParameters.append(nameValueSeparator);
            convertedParameters.append(HttpParametersUtils.encode(parameters2.get(name2), defaultEncoding));
            convertedParameters.append(parameterSeparator);
        }
        if (convertedParameters.length() > 0) {
            convertedParameters.deleteCharAt(convertedParameters.length() - 1);
        }
        return convertedParameters.toString();
    }

    private static String encode(String content2, String encoding) {
        try {
            return URLEncoder.encode(content2, encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

