/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.tools.bmfont;

import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.PixmapIO;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.PixmapPacker;
import com.badlogic.gdx.utils.Array;

public class BitmapFontWriter {
    private static OutputFormat format = OutputFormat.Text;

    public static void setOutputFormat(OutputFormat fmt) {
        if (fmt == null) {
            throw new NullPointerException("format cannot be null");
        }
        format = fmt;
    }

    public static OutputFormat getOutputFormat() {
        return format;
    }

    private static String quote(Object params) {
        return BitmapFontWriter.quote(params, false);
    }

    private static String quote(Object params, boolean spaceAfter) {
        if (BitmapFontWriter.getOutputFormat() == OutputFormat.XML) {
            return "\"" + params.toString().trim() + "\"" + (spaceAfter ? " " : "");
        }
        return params.toString();
    }

    public static void writeFont(BitmapFont.BitmapFontData fontData, String[] pageRefs, FileHandle outFntFile, FontInfo info2, int scaleW, int scaleH) {
        String charset;
        if (info2 == null) {
            info2 = new FontInfo();
            info2.face = outFntFile.nameWithoutExtension();
        }
        int lineHeight = (int)fontData.lineHeight;
        int pages = pageRefs.length;
        int packed = 0;
        int base = (int)(fontData.capHeight + (fontData.flipped ? -fontData.ascent : fontData.ascent));
        OutputFormat fmt = BitmapFontWriter.getOutputFormat();
        boolean xml = fmt == OutputFormat.XML;
        StringBuilder buf = new StringBuilder();
        if (xml) {
            buf.append("<font>\n");
        }
        String xmlOpen = xml ? "\t<" : "";
        String xmlCloseSelf = xml ? "/>" : "";
        String xmlTab = xml ? "\t" : "";
        String xmlClose = xml ? ">" : "";
        String xmlQuote = xml ? "\"" : "";
        String alphaChnlParams = xml ? " alphaChnl=\"0\" redChnl=\"0\" greenChnl=\"0\" blueChnl=\"0\"" : " alphaChnl=0 redChnl=0 greenChnl=0 blueChnl=0";
        buf.append(xmlOpen).append("info face=\"").append(info2.face == null ? "" : info2.face.replaceAll("\"", "'")).append("\" size=").append(BitmapFontWriter.quote(info2.size)).append(" bold=").append(BitmapFontWriter.quote(info2.bold ? 1 : 0)).append(" italic=").append(BitmapFontWriter.quote(info2.italic ? 1 : 0)).append(" charset=\"").append(info2.charset == null ? "" : info2.charset).append("\" unicode=").append(BitmapFontWriter.quote(info2.unicode ? 1 : 0)).append(" stretchH=").append(BitmapFontWriter.quote(info2.stretchH)).append(" smooth=").append(BitmapFontWriter.quote(info2.smooth ? 1 : 0)).append(" aa=").append(BitmapFontWriter.quote(info2.aa)).append(" padding=").append(xmlQuote).append(info2.padding.up).append(",").append(info2.padding.right).append(",").append(info2.padding.down).append(",").append(info2.padding.left).append(xmlQuote).append(" spacing=").append(xmlQuote).append(info2.spacing.horizontal).append(",").append(info2.spacing.vertical).append(xmlQuote).append(xmlCloseSelf).append("\n");
        buf.append(xmlOpen).append("common lineHeight=").append(BitmapFontWriter.quote(lineHeight)).append(" base=").append(BitmapFontWriter.quote(base)).append(" scaleW=").append(BitmapFontWriter.quote(scaleW)).append(" scaleH=").append(BitmapFontWriter.quote(scaleH)).append(" pages=").append(BitmapFontWriter.quote(pages)).append(" packed=").append(BitmapFontWriter.quote(packed)).append(alphaChnlParams).append(xmlCloseSelf).append("\n");
        if (xml) {
            buf.append("\t<pages>\n");
        }
        for (int i = 0; i < pageRefs.length; ++i) {
            buf.append(xmlTab).append(xmlOpen).append("page id=").append(BitmapFontWriter.quote(i)).append(" file=\"").append(pageRefs[i]).append("\"").append(xmlCloseSelf).append("\n");
        }
        if (xml) {
            buf.append("\t</pages>\n");
        }
        Array<BitmapFont.Glyph> glyphs = new Array<BitmapFont.Glyph>(256);
        for (int i = 0; i < fontData.glyphs.length; ++i) {
            if (fontData.glyphs[i] == null) continue;
            for (int j = 0; j < fontData.glyphs[i].length; ++j) {
                if (fontData.glyphs[i][j] == null) continue;
                glyphs.add(fontData.glyphs[i][j]);
            }
        }
        buf.append(xmlOpen).append("chars count=").append(BitmapFontWriter.quote(glyphs.size)).append(xmlClose).append("\n");
        int padTop = info2.padding.up;
        int padLeft = info2.padding.left;
        int padRight = info2.padding.right;
        int padX = padLeft + padRight;
        int padY = info2.padding.up + info2.padding.down;
        for (int i = 0; i < glyphs.size; ++i) {
            BitmapFont.Glyph g = (BitmapFont.Glyph)glyphs.get(i);
            boolean empty2 = g.width == 0 || g.height == 0;
            buf.append(xmlTab).append(xmlOpen).append("char id=").append(BitmapFontWriter.quote(String.format("%-6s", g.id), true)).append("x=").append(BitmapFontWriter.quote(String.format("%-5s", empty2 ? 0 : g.srcX), true)).append("y=").append(BitmapFontWriter.quote(String.format("%-5s", empty2 ? 0 : g.srcY), true)).append("width=").append(BitmapFontWriter.quote(String.format("%-5s", empty2 ? 0 : g.width), true)).append("height=").append(BitmapFontWriter.quote(String.format("%-5s", empty2 ? 0 : g.height), true)).append("xoffset=").append(BitmapFontWriter.quote(String.format("%-5s", g.xoffset - padLeft), true)).append("yoffset=").append(BitmapFontWriter.quote(String.format("%-5s", fontData.flipped ? g.yoffset + padTop : -(g.height + (g.yoffset + padTop))), true)).append("xadvance=").append(BitmapFontWriter.quote(String.format("%-5s", g.xadvance), true)).append("page=").append(BitmapFontWriter.quote(String.format("%-5s", g.page), true)).append("chnl=").append(BitmapFontWriter.quote(0, true)).append(xmlCloseSelf).append("\n");
        }
        if (xml) {
            buf.append("\t</chars>\n");
        }
        int kernCount = 0;
        StringBuilder kernBuf = new StringBuilder();
        for (int i = 0; i < glyphs.size; ++i) {
            for (int j = 0; j < glyphs.size; ++j) {
                BitmapFont.Glyph first2 = (BitmapFont.Glyph)glyphs.get(i);
                BitmapFont.Glyph second2 = (BitmapFont.Glyph)glyphs.get(j);
                int kern = first2.getKerning((char)second2.id);
                if (kern == 0) continue;
                ++kernCount;
                kernBuf.append(xmlTab).append(xmlOpen).append("kerning first=").append(BitmapFontWriter.quote(first2.id)).append(" second=").append(BitmapFontWriter.quote(second2.id)).append(" amount=").append(BitmapFontWriter.quote(kern, true)).append(xmlCloseSelf).append("\n");
            }
        }
        buf.append(xmlOpen).append("kernings count=").append(BitmapFontWriter.quote(kernCount)).append(xmlClose).append("\n");
        buf.append((CharSequence)kernBuf);
        if (xml) {
            buf.append("\t</kernings>\n");
        }
        if (info2.hasOverrideMetrics) {
            if (xml) {
                buf.append("\t<metrics>\n");
            }
            buf.append(xmlTab).append(xmlOpen).append("metrics ascent=").append(BitmapFontWriter.quote(Float.valueOf(info2.ascent), true)).append(" descent=").append(BitmapFontWriter.quote(Float.valueOf(info2.descent), true)).append(" down=").append(BitmapFontWriter.quote(Float.valueOf(info2.down), true)).append(" capHeight=").append(BitmapFontWriter.quote(Float.valueOf(info2.capHeight), true)).append(" lineHeight=").append(BitmapFontWriter.quote(Float.valueOf(info2.lineHeight), true)).append(" spaceXAdvance=").append(BitmapFontWriter.quote(Float.valueOf(info2.spaceXAdvance), true)).append(" xHeight=").append(BitmapFontWriter.quote(Float.valueOf(info2.xHeight), true)).append(xmlCloseSelf).append("\n");
            if (xml) {
                buf.append("\t</metrics>\n");
            }
        }
        if (xml) {
            buf.append("</font>");
        }
        if ((charset = info2.charset) != null && charset.length() == 0) {
            charset = null;
        }
        outFntFile.writeString(buf.toString(), false, charset);
    }

    public static void writeFont(BitmapFont.BitmapFontData fontData, Pixmap[] pages, FileHandle outFntFile, FontInfo info2) {
        String[] pageRefs = BitmapFontWriter.writePixmaps(pages, outFntFile.parent(), outFntFile.nameWithoutExtension());
        BitmapFontWriter.writeFont(fontData, pageRefs, outFntFile, info2, pages[0].getWidth(), pages[0].getHeight());
    }

    public static String[] writePixmaps(Pixmap[] pages, FileHandle outputDir, String fileName) {
        if (pages == null || pages.length == 0) {
            throw new IllegalArgumentException("no pixmaps supplied to BitmapFontWriter.write");
        }
        String[] pageRefs = new String[pages.length];
        for (int i = 0; i < pages.length; ++i) {
            String ref;
            pageRefs[i] = ref = pages.length == 1 ? fileName + ".png" : fileName + "_" + i + ".png";
            PixmapIO.writePNG(outputDir.child(ref), pages[i]);
        }
        return pageRefs;
    }

    public static String[] writePixmaps(Array<PixmapPacker.Page> pages, FileHandle outputDir, String fileName) {
        Pixmap[] pix = new Pixmap[pages.size];
        for (int i = 0; i < pages.size; ++i) {
            pix[i] = pages.get(i).getPixmap();
        }
        return BitmapFontWriter.writePixmaps(pix, outputDir, fileName);
    }

    public static class FontInfo {
        public String face;
        public int size = 12;
        public boolean bold;
        public boolean italic;
        public String charset;
        public boolean unicode = true;
        public int stretchH = 100;
        public boolean smooth = true;
        public int aa = 2;
        public Padding padding = new Padding();
        public Spacing spacing = new Spacing();
        public int outline = 0;
        public boolean hasOverrideMetrics;
        public float ascent;
        public float descent;
        public float down;
        public float capHeight;
        public float lineHeight;
        public float spaceXAdvance;
        public float xHeight;

        public FontInfo() {
        }

        public FontInfo(String face, int size2) {
            this.face = face;
            this.size = size2;
        }

        public void overrideMetrics(BitmapFont.BitmapFontData data2) {
            this.hasOverrideMetrics = true;
            this.ascent = data2.ascent;
            this.descent = data2.descent;
            this.down = data2.down;
            this.capHeight = data2.capHeight;
            this.lineHeight = data2.lineHeight;
            this.spaceXAdvance = data2.spaceXadvance;
            this.xHeight = data2.xHeight;
        }
    }

    public static class Spacing {
        public int horizontal;
        public int vertical;
    }

    public static class Padding {
        public int up;
        public int down;
        public int left;
        public int right;

        public Padding() {
        }

        public Padding(int up, int down, int left, int right) {
            this.up = up;
            this.down = down;
            this.left = left;
            this.right = right;
        }
    }

    public static enum OutputFormat {
        Text,
        XML;

    }
}

